/*
 * Decompiled with CFR 0.152.
 */
package kafka.raft;

import java.io.File;
import java.io.Serializable;
import java.nio.channels.FileChannel;
import java.nio.channels.OverlappingFileLockException;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import kafka.log.LogManager$;
import kafka.raft.KafkaRaftManager;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaRaftServer;
import kafka.server.MetaProperties;
import kafka.tools.TestRaftServer;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.raft.KafkaRaftClient;
import org.apache.kafka.raft.RaftConfig;
import org.apache.kafka.server.common.serialization.RecordSerde;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.Mockito;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableOnce;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005}c\u0001\u0002\u0006\f\u0001AAQa\u0006\u0001\u0005\u0002aAQa\u0007\u0001\u0005\nqAQ!\u0015\u0001\u0005\nICQa\u001b\u0001\u0005\u00021Dq!!\b\u0001\t\u0003\ty\u0002C\u0004\u00028\u0001!\t!!\u000f\t\u000f\u0005%\u0003\u0001\"\u0003\u0002L!9\u0011q\u000b\u0001\u0005\u0002\u0005e\u0002bBA.\u0001\u0011\u0005\u0011\u0011\b\u0002\u0010%\u00064G/T1oC\u001e,'\u000fV3ti*\u0011A\"D\u0001\u0005e\u00064GOC\u0001\u000f\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A\t\u0011\u0005I)R\"A\n\u000b\u0003Q\tQa]2bY\u0006L!AF\n\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t\u0011\u0004\u0005\u0002\u001b\u00015\t1\"\u0001\u0007de\u0016\fG/Z\"p]\u001aLw\rF\u0003\u001eGm\u0002u\n\u0005\u0002\u001fC5\tqD\u0003\u0002!\u001b\u000511/\u001a:wKJL!AI\u0010\u0003\u0017-\u000bgm[1D_:4\u0017n\u001a\u0005\u0006I\t\u0001\r!J\u0001\raJ|7-Z:t%>dWm\u001d\t\u0004M5\u0002dBA\u0014,!\tA3#D\u0001*\u0015\tQs\"\u0001\u0004=e>|GOP\u0005\u0003YM\ta\u0001\u0015:fI\u00164\u0017B\u0001\u00180\u0005\r\u0019V\r\u001e\u0006\u0003YM\u0001\"!\r\u001d\u000f\u0005I2dBA\u001a6\u001d\tAC'C\u0001\u000f\u0013\t\u0001S\"\u0003\u00028?\u0005y1*\u00194lCJ\u000bg\r^*feZ,'/\u0003\u0002:u\tY\u0001K]8dKN\u001c(k\u001c7f\u0015\t9t\u0004C\u0003=\u0005\u0001\u0007Q(\u0001\u0004o_\u0012,\u0017\n\u001a\t\u0003%yJ!aP\n\u0003\u0007%sG\u000fC\u0003B\u0005\u0001\u0007!)\u0001\u0004m_\u001e$\u0015N\u001d\t\u0004%\r+\u0015B\u0001#\u0014\u0005\u0019y\u0005\u000f^5p]B\u0011a)T\u0007\u0002\u000f*\u0011\u0001*S\u0001\u0005M&dWM\u0003\u0002K\u0017\u0006\u0019a.[8\u000b\u00031\u000bAA[1wC&\u0011aj\u0012\u0002\u0005!\u0006$\b\u000eC\u0003Q\u0005\u0001\u0007!)A\u0006nKR\fG-\u0019;b\t&\u0014\u0018!E2sK\u0006$XMU1gi6\u000bg.Y4feR\u00191\u000bX5\u0011\u0007i!f+\u0003\u0002V\u0017\t\u00012*\u00194lCJ\u000bg\r^'b]\u0006<WM\u001d\t\u0004%]K\u0016B\u0001-\u0014\u0005\u0015\t%O]1z!\t\u0011\",\u0003\u0002\\'\t!!)\u001f;f\u0011\u0015i6\u00011\u0001_\u00039!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u0004\"aX4\u000e\u0003\u0001T!!\u00192\u0002\r\r|W.\\8o\u0015\tq1M\u0003\u0002eK\u00061\u0011\r]1dQ\u0016T\u0011AZ\u0001\u0004_J<\u0017B\u00015a\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:DQA[\u0002A\u0002u\taaY8oM&<\u0017!\u0005;fgRtu\u000eZ3JIB\u0013Xm]3oiR\u0011Q\u000e\u001d\t\u0003%9L!a\\\n\u0003\tUs\u0017\u000e\u001e\u0005\u0006I\u0011\u0001\r!\u001d\t\u0003MIL!a]\u0018\u0003\rM#(/\u001b8hQ\u0019!Q/a\u0001\u0002\u0006A\u0011ao`\u0007\u0002o*\u0011\u00010_\u0001\taJ|g/\u001b3fe*\u0011!p_\u0001\u0007a\u0006\u0014\u0018-\\:\u000b\u0005ql\u0018a\u00026va&$XM\u001d\u0006\u0003}\u0016\fQA[;oSRL1!!\u0001x\u0005-1\u0016\r\\;f'>,(oY3\u0002\u000fM$(/\u001b8hg22\u0011qAA\u0006\u0003\u001f\t#!!\u0003\u0002\r\t\u0014xn[3sC\t\ti!\u0001\u0006d_:$(o\u001c7mKJ\f#!!\u0005\u0002#\t\u0014xn[3sY\r|g\u000e\u001e:pY2,'\u000fK\u0002\u0005\u0003+\u0001B!a\u0006\u0002\u001a5\t\u00110C\u0002\u0002\u001ce\u0014\u0011\u0003U1sC6,G/\u001a:ju\u0016$G+Z:u\u0003\u0001\"Xm\u001d;M_\u001e$\u0015N\u001d'pG.<\u0006.\u001a8D_:$(o\u001c7mKJ|e\u000e\\=\u0015\u00075\f\t\u0003\u0003\u0004\u0002$\u0015\u0001\r!]\u0001\bI&\u0014H+\u001f9fQ\u0019)Q/a\u0001\u0002(12\u0011\u0011FA\u0017\u0003c\t#!a\u000b\u0002\u001b5,G/\u00193bi\u0006lsN\u001c7zC\t\ty#\u0001\u0005m_\u001elsN\u001c7zC\t\t\u0019$\u0001\u0003c_RD\u0007fA\u0003\u0002\u0016\u0005\u0019D/Z:u\u0019><G)\u001b:M_\u000e\\w\u000b[3o\u0005J|7.\u001a:P]2Lx+\u001b;i'\u0016\u0004\u0018M]1uK6+G/\u00193bi\u0006$\u0015N\u001d\u000b\u0002[\"\u001aa!!\u0010\u0011\t\u0005}\u0012QI\u0007\u0003\u0003\u0003R1!a\u0011|\u0003\r\t\u0007/[\u0005\u0005\u0003\u000f\n\tE\u0001\u0003UKN$\u0018A\u00034jY\u0016dunY6fIR!\u0011QJA*!\r\u0011\u0012qJ\u0005\u0004\u0003#\u001a\"a\u0002\"p_2,\u0017M\u001c\u0005\u0007\u0003+:\u0001\u0019A#\u0002\tA\fG\u000f[\u0001\u0015i\u0016\u001cHo\u00155vi\u0012|wO\\%p)\"\u0014X-\u00193)\u0007!\ti$A\u0010uKN$XK\\2bk\u001eDG/\u0012=dKB$\u0018n\u001c8J]&{G\u000b\u001b:fC\u0012D3!CA\u001f\u0001")
public class RaftManagerTest {
    private KafkaConfig createConfig(Set<KafkaRaftServer.ProcessRole> processRoles, int nodeId, Option<Path> logDir, Option<Path> metadataDir) {
        Properties props = new Properties();
        logDir.foreach((Function1 & Serializable)value -> props.setProperty(KafkaConfig$.MODULE$.LogDirProp(), ((Object)value).toString()));
        metadataDir.foreach((Function1 & Serializable)value -> props.setProperty(KafkaConfig$.MODULE$.MetadataLogDirProp(), ((Object)value).toString()));
        props.setProperty(KafkaConfig$.MODULE$.ProcessRolesProp(), processRoles.mkString(","));
        props.setProperty(KafkaConfig$.MODULE$.NodeIdProp(), Integer.toString(nodeId));
        props.setProperty(KafkaConfig$.MODULE$.ControllerListenerNamesProp(), "SSL");
        if (processRoles.contains((Object)KafkaRaftServer.BrokerRole$.MODULE$)) {
            props.setProperty(KafkaConfig$.MODULE$.InterBrokerListenerNameProp(), "PLAINTEXT");
            if (processRoles.contains((Object)KafkaRaftServer.ControllerRole$.MODULE$)) {
                props.setProperty(KafkaConfig$.MODULE$.ListenersProp(), "PLAINTEXT://localhost:9092,SSL://localhost:9093");
                props.setProperty(KafkaConfig$.MODULE$.QuorumVotersProp(), new StringBuilder(15).append(nodeId).append("@localhost:9093").toString());
            } else {
                int voterId = nodeId + 1;
                props.setProperty(KafkaConfig$.MODULE$.QuorumVotersProp(), new StringBuilder(15).append(voterId).append("@localhost:9093").toString());
            }
        } else if (processRoles.contains((Object)KafkaRaftServer.ControllerRole$.MODULE$)) {
            props.setProperty(KafkaConfig$.MODULE$.ListenersProp(), "SSL://localhost:9093");
            props.setProperty(KafkaConfig$.MODULE$.QuorumVotersProp(), new StringBuilder(15).append(nodeId).append("@localhost:9093").toString());
        }
        return new KafkaConfig((Map)props);
    }

    private KafkaRaftManager<byte[]> createRaftManager(TopicPartition topicPartition, KafkaConfig config) {
        Uuid topicId = new Uuid(0L, 2L);
        MetaProperties metaProperties = new MetaProperties(Uuid.randomUuid().toString(), config.nodeId());
        return new KafkaRaftManager(metaProperties, config, (RecordSerde)new TestRaftServer.ByteArraySerde(), topicPartition, topicId, Time.SYSTEM, new Metrics(Time.SYSTEM), Option$.MODULE$.empty(), CompletableFuture.completedFuture(RaftConfig.parseVoterConnections((List)config.quorumVoters())));
    }

    @ParameterizedTest
    @ValueSource(strings={"broker", "controller", "broker,controller"})
    public void testNodeIdPresent(String processRoles) {
        Set processRolesSet = Predef$.MODULE$.Set().empty();
        if (processRoles.contains("broker")) {
            processRolesSet = (Set)processRolesSet.$plus$plus((IterableOnce)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaRaftServer.BrokerRole$[]{KafkaRaftServer.BrokerRole$.MODULE$})));
        }
        if (processRoles.contains("controller")) {
            processRolesSet = (Set)processRolesSet.$plus$plus((IterableOnce)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaRaftServer.ControllerRole$[]{KafkaRaftServer.ControllerRole$.MODULE$})));
        }
        File logDir = TestUtils.tempDirectory(null, null);
        int nodeId = 1;
        KafkaRaftManager<byte[]> raftManager = this.createRaftManager(new TopicPartition("__raft_id_test", 0), this.createConfig((Set<KafkaRaftServer.ProcessRole>)processRolesSet, nodeId, (Option<Path>)new Some((Object)logDir.toPath()), (Option<Path>)None$.MODULE$));
        Assertions.assertEquals((int)nodeId, (int)raftManager.client().nodeId().getAsInt());
        raftManager.shutdown();
    }

    @ParameterizedTest
    @ValueSource(strings={"metadata-only", "log-only", "both"})
    public void testLogDirLockWhenControllerOnly(String dirType) {
        None$ logDir;
        None$ none$ = dirType.equals("metadata-only") ? None$.MODULE$ : (logDir = new Some((Object)TestUtils.tempDirectory(null, null).toPath()));
        None$ metadataDir = dirType.equals("log-only") ? None$.MODULE$ : new Some((Object)TestUtils.tempDirectory(null, null).toPath());
        int nodeId = 1;
        KafkaRaftManager<byte[]> raftManager = this.createRaftManager(new TopicPartition("__raft_id_test", 0), this.createConfig((Set<KafkaRaftServer.ProcessRole>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaRaftServer.ProcessRole[]{KafkaRaftServer.ControllerRole$.MODULE$}))), nodeId, (Option<Path>)logDir, (Option<Path>)metadataDir));
        Path lockPath = ((Path)metadataDir.getOrElse(() -> RaftManagerTest.$anonfun$testLogDirLockWhenControllerOnly$1((Option)logDir))).resolve(LogManager$.MODULE$.LockFileName());
        Assertions.assertTrue((boolean)this.fileLocked(lockPath));
        raftManager.shutdown();
        Assertions.assertFalse((boolean)this.fileLocked(lockPath));
    }

    @Test
    public void testLogDirLockWhenBrokerOnlyWithSeparateMetadataDir() {
        Some logDir = new Some((Object)TestUtils.tempDirectory(null, null).toPath());
        Some metadataDir = new Some((Object)TestUtils.tempDirectory(null, null).toPath());
        int nodeId = 1;
        KafkaRaftManager<byte[]> raftManager = this.createRaftManager(new TopicPartition("__raft_id_test", 0), this.createConfig((Set<KafkaRaftServer.ProcessRole>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaRaftServer.ProcessRole[]{KafkaRaftServer.BrokerRole$.MODULE$}))), nodeId, (Option<Path>)logDir, (Option<Path>)metadataDir));
        Path lockPath = ((Path)metadataDir.getOrElse((Function0 & Serializable)() -> (Path)logDir.get())).resolve(LogManager$.MODULE$.LockFileName());
        Assertions.assertTrue((boolean)this.fileLocked(lockPath));
        raftManager.shutdown();
        Assertions.assertFalse((boolean)this.fileLocked(lockPath));
    }

    private boolean fileLocked(Path path) {
        boolean bl;
        try (FileChannel resource_resource = FileChannel.open(path, StandardOpenOption.WRITE);){
            bl = RaftManagerTest.$anonfun$fileLocked$1(resource_resource);
        }
        return bl;
    }

    @Test
    public void testShutdownIoThread() {
        KafkaRaftClient raftClient = (KafkaRaftClient)Mockito.mock(KafkaRaftClient.class);
        KafkaRaftManager.RaftIoThread ioThread = new KafkaRaftManager.RaftIoThread(raftClient, "test-raft");
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)raftClient.isRunning())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Assertions.assertTrue((boolean)ioThread.isRunning());
        CompletableFuture<Object> shutdownFuture = new CompletableFuture<Object>();
        Mockito.when((Object)raftClient.shutdown(5000)).thenReturn(shutdownFuture);
        ioThread.initiateShutdown();
        Assertions.assertTrue((boolean)ioThread.isRunning());
        Assertions.assertTrue((boolean)ioThread.isShutdownInitiated());
        ((KafkaRaftClient)Mockito.verify((Object)raftClient)).shutdown(5000);
        shutdownFuture.complete(null);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)raftClient.isRunning())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        ioThread.run();
        Assertions.assertFalse((boolean)ioThread.isRunning());
        Assertions.assertTrue((boolean)ioThread.isShutdownComplete());
    }

    @Test
    public void testUncaughtExceptionInIoThread() {
        KafkaRaftClient raftClient = (KafkaRaftClient)Mockito.mock(KafkaRaftClient.class);
        KafkaRaftManager.RaftIoThread ioThread = new KafkaRaftManager.RaftIoThread(raftClient, "test-raft");
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)raftClient.isRunning())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Assertions.assertTrue((boolean)ioThread.isRunning());
        raftClient.poll();
        Mockito.when((Object)BoxedUnit.UNIT).thenThrow(new Throwable[]{new RuntimeException()});
        ioThread.run();
        Assertions.assertTrue((boolean)ioThread.isShutdownComplete());
        Assertions.assertTrue((boolean)ioThread.isThreadFailed());
        Assertions.assertFalse((boolean)ioThread.isRunning());
    }

    public static final /* synthetic */ Path $anonfun$testLogDirLockWhenControllerOnly$1(Option logDir$1) {
        return (Path)logDir$1.get();
    }

    public static final /* synthetic */ boolean $anonfun$fileLocked$1(FileChannel channel) {
        try {
            Option$.MODULE$.apply((Object)channel.tryLock()).foreach((Function1 & Serializable)x$1 -> {
                x$1.close();
                return BoxedUnit.UNIT;
            });
            return false;
        }
        catch (OverlappingFileLockException overlappingFileLockException) {
            return true;
        }
    }

    public static final /* synthetic */ Object $anonfun$fileLocked$1$adapted(FileChannel channel) {
        return BoxesRunTime.boxToBoolean((boolean)RaftManagerTest.$anonfun$fileLocked$1(channel));
    }
}

