/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import kafka.log.AppendOrigin;
import kafka.log.ClientRecordDeletion$;
import kafka.log.LoadedLogOffsets;
import kafka.log.LocalLog;
import kafka.log.LocalLog$;
import kafka.log.LogCleanerManager;
import kafka.log.LogCleanerManager$;
import kafka.log.LogCleanerManagerTest;
import kafka.log.LogCleaningAborted$;
import kafka.log.LogCleaningException;
import kafka.log.LogCleaningInProgress$;
import kafka.log.LogCleaningPaused;
import kafka.log.LogCleaningState;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogLoader;
import kafka.log.LogSegment;
import kafka.log.LogSegments;
import kafka.log.LogStartOffsetIncrementReason;
import kafka.log.LogToClean;
import kafka.log.OffsetsToClean;
import kafka.log.ProducerStateManager;
import kafka.log.ProducerStateManagerConfig;
import kafka.log.UnifiedLog;
import kafka.log.UnifiedLog$;
import kafka.server.BrokerTopicStats;
import kafka.server.Defaults$;
import kafka.server.LogDirFailureChannel;
import kafka.utils.Logging;
import kafka.utils.MockScheduler;
import kafka.utils.MockTime;
import kafka.utils.Pool;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\reb\u0001\u0002(P\u0001QCQ!\u0019\u0001\u0005\u0002\tDq!\u001a\u0001C\u0002\u0013\u0005a\r\u0003\u0004p\u0001\u0001\u0006Ia\u001a\u0005\ba\u0002\u0011\r\u0011\"\u0001g\u0011\u0019\t\b\u0001)A\u0005O\"9!\u000f\u0001b\u0001\n\u00031\u0007BB:\u0001A\u0003%q\rC\u0004u\u0001\t\u0007I\u0011\u00014\t\rU\u0004\u0001\u0015!\u0003h\u0011\u001d1\bA1A\u0005\u0002]Dq!a\u0002\u0001A\u0003%\u0001\u0010\u0003\u0005\u0002\n\u0001\u0011\r\u0011\"\u0001x\u0011\u001d\tY\u0001\u0001Q\u0001\naD\u0011\"!\u0004\u0001\u0005\u0004%\t!a\u0004\t\u0011\u0005u\u0001\u0001)A\u0005\u0003#A\u0011\"a\b\u0001\u0005\u0004%\t!!\t\t\u0011\u0005%\u0002\u0001)A\u0005\u0003GA\u0011\"a\u000b\u0001\u0005\u0004%\t!!\f\t\u0011\u0005U\u0002\u0001)A\u0005\u0003_A\u0011\"a\u000e\u0001\u0005\u0004%\t!!\u000f\t\u0011\u0005\u0005\u0003\u0001)A\u0005\u0003wA\u0011\"a\u0011\u0001\u0005\u0004%\t!!\u0012\t\u0011\u00055\u0003\u0001)A\u0005\u0003\u000fB\u0011\"a\u0014\u0001\u0005\u0004%\t!!\u0015\t\u0011\u0005%\u0004\u0001)A\u0005\u0003'2a!a\u001b\u0001\u0001\u00055\u0004\u0002DA;5\t\u0005\t\u0015!\u0003\u0002x\u0005=\u0005\u0002DAI5\t\u0005\t\u0015!\u0003\u0002\u0014\u0006}\u0005\u0002DAQ5\t\u0005\t\u0015!\u0003\u0002$\u0006=\u0006BB1\u001b\t\u0003\t\t\fC\u0004\u0002>j!\t%a0\t\u000f\u0005='\u0004\"\u0011\u0002R\"I\u00111\u001f\u000e\u0012\u0002\u0013\u0005\u0011Q\u001f\u0005\n\u0005\u0017Q\u0012\u0013!C\u0001\u0005\u001bAqA!\u0005\u0001\t\u0003\u0011\u0019\u0002C\u0004\u0003,\u0001!IA!\f\t\u000f\tu\u0002\u0001\"\u0001\u0003\u0014!9!q\t\u0001\u0005\u0002\tM\u0001b\u0002B&\u0001\u0011\u0005!1\u0003\u0005\b\u0005\u001f\u0002A\u0011\u0001B\n\u0011\u001d\u0011\u0019\u0006\u0001C\u0001\u0005'AqAa\u0016\u0001\t\u0003\u0011\u0019\u0002C\u0004\u0003\\\u0001!\tAa\u0005\t\u000f\t}\u0003\u0001\"\u0001\u0003\u0014!9!1\r\u0001\u0005\u0002\tM\u0001b\u0002B4\u0001\u0011\u0005!1\u0003\u0005\b\u0005W\u0002A\u0011\u0001B\n\u0011\u001d\u0011y\u0007\u0001C\u0001\u0005'AqAa\u001d\u0001\t\u0003\u0011\u0019\u0002C\u0004\u0003x\u0001!\tAa\u0005\t\u000f\tm\u0004\u0001\"\u0001\u0003\u0014!9!q\u0010\u0001\u0005\u0002\tM\u0001b\u0002BB\u0001\u0011\u0005!1\u0003\u0005\b\u0005\u000f\u0003A\u0011\u0001B\n\u0011\u001d\u0011Y\t\u0001C\u0001\u0005'AqAa$\u0001\t\u0003\u0011\u0019\u0002C\u0004\u0003\u0014\u0002!\tAa\u0005\t\u000f\t]\u0005\u0001\"\u0001\u0003\u0014!9!1\u0014\u0001\u0005\u0002\tM\u0001b\u0002BP\u0001\u0011\u0005!1\u0003\u0005\b\u0005G\u0003A\u0011\u0001B\n\u0011\u001d\u00119\u000b\u0001C\u0001\u0005'AqAa+\u0001\t\u0003\u0011\u0019\u0002C\u0004\u00030\u0002!\tAa\u0005\t\u000f\tM\u0006\u0001\"\u0001\u0003\u0014!9!q\u0017\u0001\u0005\u0002\tM\u0001b\u0002B^\u0001\u0011\u0005!1\u0003\u0005\b\u0005\u007f\u0003A\u0011\u0002Ba\u0011\u001d\u0011)\r\u0001C\u0005\u0005\u000fDqA!4\u0001\t\u0013\u0011y\rC\u0005\u0003b\u0002\t\n\u0011\"\u0003\u0003d\"9!q\u001d\u0001\u0005\n\t%\bb\u0002Bx\u0001\u0011%!\u0011\u001f\u0005\b\u0007\u0003\u0001A\u0011BB\u0002\u0011\u001d\u0019Y\u0001\u0001C\u0005\u0007\u001bA\u0011ba\u0006\u0001#\u0003%Ia!\u0007\t\u000f\ru\u0001\u0001\"\u0003\u0004 \t)Bj\\4DY\u0016\fg.\u001a:NC:\fw-\u001a:UKN$(B\u0001)R\u0003\rawn\u001a\u0006\u0002%\u0006)1.\u00194lC\u000e\u00011c\u0001\u0001V7B\u0011a+W\u0007\u0002/*\t\u0001,A\u0003tG\u0006d\u0017-\u0003\u0002[/\n1\u0011I\\=SK\u001a\u0004\"\u0001X0\u000e\u0003uS!AX)\u0002\u000bU$\u0018\u000e\\:\n\u0005\u0001l&a\u0002'pO\u001eLgnZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\r\u0004\"\u0001\u001a\u0001\u000e\u0003=\u000ba\u0001^7q\t&\u0014X#A4\u0011\u0005!lW\"A5\u000b\u0005)\\\u0017AA5p\u0015\u0005a\u0017\u0001\u00026bm\u0006L!A\\5\u0003\t\u0019KG.Z\u0001\bi6\u0004H)\u001b:!\u0003\u001d!X\u000e\u001d#jeJ\n\u0001\u0002^7q\t&\u0014(\u0007I\u0001\u0007Y><G)\u001b:\u0002\u000f1|w\rR5sA\u00059An\\4ESJ\u0014\u0014\u0001\u00037pO\u0012K'O\r\u0011\u0002\u001dQ|\u0007/[2QCJ$\u0018\u000e^5p]V\t\u0001\u0010E\u0002z\u0003\u0007i\u0011A\u001f\u0006\u0003wr\faaY8n[>t'B\u0001*~\u0015\tqx0\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0003\u0003\u0003\t1a\u001c:h\u0013\r\t)A\u001f\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0003=!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u0004\u0013a\u0004;pa&\u001c\u0007+\u0019:uSRLwN\u001c\u001a\u0002!Q|\u0007/[2QCJ$\u0018\u000e^5p]J\u0002\u0013\u0001\u00037pOB\u0013x\u000e]:\u0016\u0005\u0005E\u0001\u0003BA\n\u00033i!!!\u0006\u000b\u0007\u0005]1.\u0001\u0003vi&d\u0017\u0002BA\u000e\u0003+\u0011!\u0002\u0015:pa\u0016\u0014H/[3t\u0003%awn\u001a)s_B\u001c\b%A\u0005m_\u001e\u001cuN\u001c4jOV\u0011\u00111\u0005\t\u0004I\u0006\u0015\u0012bAA\u0014\u001f\nIAj\\4D_:4\u0017nZ\u0001\u000bY><7i\u001c8gS\u001e\u0004\u0013\u0001\u0002;j[\u0016,\"!a\f\u0011\u0007q\u000b\t$C\u0002\u00024u\u0013\u0001\"T8dWRKW.Z\u0001\u0006i&lW\rI\u0001\u0007_\u001a47/\u001a;\u0016\u0005\u0005m\u0002c\u0001,\u0002>%\u0019\u0011qH,\u0003\u0007%sG/A\u0004pM\u001a\u001cX\r\u001e\u0011\u00025A\u0014x\u000eZ;dKJ\u001cF/\u0019;f\u001b\u0006t\u0017mZ3s\u0007>tg-[4\u0016\u0005\u0005\u001d\u0003c\u00013\u0002J%\u0019\u00111J(\u00035A\u0013x\u000eZ;dKJ\u001cF/\u0019;f\u001b\u0006t\u0017mZ3s\u0007>tg-[4\u00027A\u0014x\u000eZ;dKJ\u001cF/\u0019;f\u001b\u0006t\u0017mZ3s\u0007>tg-[4!\u0003I\u0019G.Z1oKJ\u001c\u0005.Z2la>Lg\u000e^:\u0016\u0005\u0005M\u0003cBA+\u0003?B\u00181M\u0007\u0003\u0003/RA!!\u0017\u0002\\\u00059Q.\u001e;bE2,'bAA//\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005\u0005\u0014q\u000b\u0002\u0004\u001b\u0006\u0004\bc\u0001,\u0002f%\u0019\u0011qM,\u0003\t1{gnZ\u0001\u0014G2,\u0017M\\3s\u0007\",7m\u001b9pS:$8\u000f\t\u0002\u0016\u0019><7\t\\3b]\u0016\u0014X*\u00198bO\u0016\u0014Xj\\2l'\rQ\u0012q\u000e\t\u0004I\u0006E\u0014bAA:\u001f\n\tBj\\4DY\u0016\fg.\u001a:NC:\fw-\u001a:\u0002\u000f1|w\rR5sgB)\u0011\u0011PAEO:!\u00111PAC\u001d\u0011\ti(a!\u000e\u0005\u0005}$bAAA'\u00061AH]8pizJ\u0011\u0001W\u0005\u0004\u0003\u000f;\u0016a\u00029bG.\fw-Z\u0005\u0005\u0003\u0017\u000biIA\u0002TKFT1!a\"X\u0013\u0011\t)(!\u001d\u0002\t1|wm\u001d\t\u00079\u0006U\u00050!'\n\u0007\u0005]UL\u0001\u0003Q_>d\u0007c\u00013\u0002\u001c&\u0019\u0011QT(\u0003\u0015Us\u0017NZ5fI2{w-\u0003\u0003\u0002\u0012\u0006E\u0014\u0001\u00067pO\u0012K'OR1jYV\u0014Xm\u00115b]:,G\u000e\u0005\u0003\u0002&\u0006-VBAAT\u0015\r\tI+U\u0001\u0007g\u0016\u0014h/\u001a:\n\t\u00055\u0016q\u0015\u0002\u0015\u0019><G)\u001b:GC&dWO]3DQ\u0006tg.\u001a7\n\t\u0005\u0005\u0016\u0011\u000f\u000b\t\u0003g\u000b9,!/\u0002<B\u0019\u0011Q\u0017\u000e\u000e\u0003\u0001Aq!!\u001e\u001f\u0001\u0004\t9\bC\u0004\u0002\u0012z\u0001\r!a%\t\u000f\u0005\u0005f\u00041\u0001\u0002$\u0006)\u0012\r\u001c7DY\u0016\fg.\u001a:DQ\u0016\u001c7\u000e]8j]R\u001cXCAAa!\u001d\t\u0019-a3y\u0003GrA!!2\u0002HB\u0019\u0011QP,\n\u0007\u0005%w+\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003C\niMC\u0002\u0002J^\u000b\u0011#\u001e9eCR,7\t[3dWB|\u0017N\u001c;t)!\t\u0019.!7\u0002^\u00065\bc\u0001,\u0002V&\u0019\u0011q[,\u0003\tUs\u0017\u000e\u001e\u0005\u0007\u00037\u0004\u0003\u0019A4\u0002\u000f\u0011\fG/\u0019#je\"I\u0011q\u001c\u0011\u0011\u0002\u0003\u0007\u0011\u0011]\u0001\u0017a\u0006\u0014H/\u001b;j_:$v.\u00169eCR,wJ]!eIB)a+a9\u0002h&\u0019\u0011Q],\u0003\r=\u0003H/[8o!\u00191\u0016\u0011\u001e=\u0002d%\u0019\u00111^,\u0003\rQ+\b\u000f\\33\u0011%\ty\u000f\tI\u0001\u0002\u0004\t\t0A\tqCJ$\u0018\u000e^5p]R{'+Z7pm\u0016\u0004BAVArq\u0006YR\u000f\u001d3bi\u0016\u001c\u0005.Z2la>Lg\u000e^:%I\u00164\u0017-\u001e7uII*\"!a>+\t\u0005\u0005\u0018\u0011`\u0016\u0003\u0003w\u0004B!!@\u0003\b5\u0011\u0011q \u0006\u0005\u0005\u0003\u0011\u0019!A\u0005v]\u000eDWmY6fI*\u0019!QA,\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003\n\u0005}(!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006YR\u000f\u001d3bi\u0016\u001c\u0005.Z2la>Lg\u000e^:%I\u00164\u0017-\u001e7uIM*\"Aa\u0004+\t\u0005E\u0018\u0011`\u0001\ti\u0016\f'\u000fR8x]R\u0011\u00111\u001b\u0015\u0004G\t]\u0001\u0003\u0002B\r\u0005Oi!Aa\u0007\u000b\t\tu!qD\u0001\u0004CBL'\u0002\u0002B\u0011\u0005G\tqA[;qSR,'OC\u0002\u0003&}\fQA[;oSRLAA!\u000b\u0003\u001c\tI\u0011I\u001a;fe\u0016\u000b7\r[\u0001\u001cg\u0016$X\u000f]%oGJ,\u0017m]5oO2Lh)\u001b7uQfdunZ:\u0015\u0011\u0005M%q\u0006B\u001b\u0005sAqA!\r%\u0001\u0004\u0011\u0019$\u0001\u0006qCJ$\u0018\u000e^5p]N\u0004R!!\u001f\u0002\nbDqAa\u000e%\u0001\u0004\tY$A\bti\u0006\u0014HOT;n\u0005\u0006$8\r[3t\u0011\u001d\u0011Y\u0004\na\u0001\u0003w\taBY1uG\"Len\u0019:f[\u0016tG/\u0001\u0017uKN$xI]1c\r&dG\u000f[5fgR\u001cu.\u001c9bGR,G\rT8h)\"\u0014xn^:Fq\u000e,\u0007\u000f^5p]\"\u001aQE!\u0011\u0011\t\te!1I\u0005\u0005\u0005\u000b\u0012YB\u0001\u0003UKN$\u0018\u0001\u000f;fgR<%/\u00192GS2$\b.[3ti\u000e{W\u000e]1di\u0016$Gj\\4SKR,(O\\:M_\u001e<\u0016\u000e\u001e5ESJ$\u0018.Z:u%\u0006$\u0018n\u001c\u0015\u0004M\t\u0005\u0013!\u000f;fgR<%/\u00192GS2$\b.[3ti\u000e{W\u000e]1di\u0016$Gj\\4JO:|'/Z:V]\u000edW-\u00198bE2,\u0007+\u0019:uSRLwN\\:)\u0007\u001d\u0012\t%\u0001\u001duKN$xI]1c\r&dG\u000f[5fgR\u001cu.\u001c9bGR,G\rT8h\u0013\u001etwN]3t\u0013:\u0004&o\\4sKN\u001c\b+\u0019:uSRLwN\\:)\u0007!\u0012\t%\u0001+uKN$xI]1c\r&dG\u000f[5fgR\u001cu.\u001c9bGR,G\rT8h\u0013\u001etwN]3t\u0005>$\b.\u00138Qe><'/Z:t!\u0006\u0014H/\u001b;j_:\u001c\u0018I\u001c3V]\u000edW-\u00198bE2,\u0007+\u0019:uSRLwN\\:)\u0007%\u0012\t%A\u0015uKN$H)\u001b:us>3gm]3u%\u0016\u001cX\r^%g\u0019\u0006\u0014x-\u001a:UQ\u0006tWI\u001c3PM\u001a\u001cX\r\u001e\u0015\u0004U\t\u0005\u0013\u0001\f;fgR$\u0015N\u001d;z\u001f\u001a47/\u001a;SKN,G/\u00134T[\u0006dG.\u001a:UQ\u0006t7\u000b^1si>3gm]3uQ\rY#\u0011I\u00014i\u0016\u001cH\u000fT8h'R\f'\u000f^(gMN,G\u000fT1sO\u0016\u0014H\u000b[1o\u0003\u000e$\u0018N^3TK\u001elWM\u001c;CCN,wJ\u001a4tKRD3\u0001\fB!\u0003A\"Xm\u001d;ESJ$\u0018p\u00144gg\u0016$H*\u0019:hKJ$\u0006.\u00198BGRLg/Z*fO6,g\u000e\u001e\"bg\u0016|eMZ:fi\"\u001aQF!\u0011\u0002\tR,7\u000f\u001e'pON<\u0016\u000e\u001e5TK\u001elWM\u001c;t)>$U\r\\3uKNCw.\u001e7e\u001d>$8i\u001c8tS\u0012,'o\u00117fC:,\b\u000fU8mS\u000eLH)\u001a7fi\u0016dunZ:)\u00079\u0012\t%\u0001%uKN$Hj\\4t/&$\bnU3h[\u0016tGo\u001d+p\t\u0016dW\r^3TQ>,H\u000eZ\"p]NLG-\u001a:DY\u0016\fg.\u001e9Q_2L7-_\"p[B\f7\r\u001e#fY\u0016$X\rT8hg\"\u001aqF!\u0011\u0002\u0005R,7\u000f\u001e'pON<\u0016\u000e\u001e5TK\u001elWM\u001c;t)>$U\r\\3uKNCw.\u001e7e\u0007>t7/\u001b3fe\u000ecW-\u00198vaB{G.[2z\u0007>l\u0007/Y2u\u0019><7\u000fK\u00021\u0005\u0003\n1\u0006^3ti2{wm]+oI\u0016\u00148\t\\3b]V\u0004\u0018J\\3mS\u001eL'\r\\3G_J\u001cu.\u001c9bGRLwN\u001c\u0015\u0004c\t\u0005\u0013a\f;fgR,\u0006\u000fZ1uK\u000eCWmY6q_&tGo]*i_VdG-\u00113e\u001f\u001a47/\u001a;U_B\u000b'\u000f^5uS>t\u0007f\u0001\u001a\u0003B\u0005qC/Z:u+B$\u0017\r^3DQ\u0016\u001c7\u000e]8j]R\u001c8\u000b[8vY\u0012\u0014V-\\8wKB\u000b'\u000f^5uS>tG)\u0019;bQ\r\u0019$\u0011I\u0001.i\u0016\u001cH\u000fS1oI2,Gj\\4ESJ4\u0015-\u001b7ve\u0016\u001c\u0006n\\;mIJ+Wn\u001c<f\t&\u0014\u0018I\u001c3ECR\f\u0007f\u0001\u001b\u0003B\u0005iC/Z:u\u001b\u0006L(-\u001a+sk:\u001c\u0017\r^3DQ\u0016\u001c7\u000e]8j]R\u001c\u0006n\\;mIR\u0013XO\\2bi\u0016$\u0015\r^1)\u0007U\u0012\t%\u0001\u001fuKN$\u0018\t\u001c;fe\u000eCWmY6q_&tG\u000fR5s'\"|W\u000f\u001c3SK6|g/\u001a#bi\u0006Len\u0015:d\t&\u0014\u0018I\u001c3BI\u0012LeNT3x\t&\u0014\bf\u0001\u001c\u0003B\u0005AC/Z:u\u0007>t7-\u001e:sK:$Hj\\4DY\u0016\fg.\u001e9B]\u0012dun\u001a+sk:\u001c\u0017\r^5p]\"\u001aqG!\u0011\u0002QQ,7\u000f^\"p]\u000e,(O]3oi2{wm\u00117fC:,\b/\u00118e)>\u0004\u0018n\u0019#fY\u0016$\u0018n\u001c8)\u0007a\u0012\t%\u0001\"uKN$Hj\\4t/&$\bnU3h[\u0016tGo\u001d+p\t\u0016dW\r^3TQ>,H\u000e\u001a(pi\u000e{gn]5eKJ,fn\u00197fC:\f'\r\\3QCJ$\u0018\u000e^5p]ND3!\u000fB!\u0003m!Xm\u001d;DY\u0016\fg.\u00192mK>3gm]3ug\u001a{'OT8oK\"\u001a!H!\u0011\u0002CQ,7\u000f^\"mK\u0006t\u0017M\u00197f\u001f\u001a47/\u001a;t\u0003\u000e$\u0018N^3TK\u001elWM\u001c;)\u0007m\u0012\t%A\u000euKN$8\t\\3b]\u0006\u0014G.Z(gMN,Go\u001d$peRKW.\u001a\u0015\u0004y\t\u0005\u0013\u0001\t;fgR\u001cE.Z1oC\ndWm\u00144gg\u0016$8OR8s'\"|'\u000f\u001e+j[\u0016D3!\u0010B!\u0003!\"Xm\u001d;DY\u0016\fg.\u00192mK>3gm]3ug:+W\rZ:DQ\u0016\u001c7\u000e]8j]R\u0014Vm]3uQ\rq$\u0011I\u0001+i\u0016\u001cH/\u00168eK\u000eLG-\u001a3Ue\u0006t7/Y2uS>t\u0017\r\u001c#bi\u0006tu\u000e^\"mK\u0006t\u0017M\u00197fQ\ry$\u0011I\u0001\u0011i\u0016\u001cH\u000fR8oK\u000ecW-\u00198j]\u001eD3\u0001\u0011B!\u0003A!Xm\u001d;E_:,G)\u001a7fi&tw\rK\u0002B\u0005\u0003\nq\u0006^3ti\u000eCWmY6q_&tG/\u00169eCR,GMR8s\u0013:4\u0018\r\\5e\u001f\u001a47/\u001a;O_\u000ecW-\u00198j]\u001eD3A\u0011B!\u0003A\"Xm\u001d;DQ\u0016\u001c7\u000e]8j]R,\u0006\u000fZ1uK\u00124uN]%om\u0006d\u0017\u000eZ(gMN,GOT8u'\u0016dWm\u0019;fI\"\u001a1I!\u0011\u0002)\r\u0014X-\u0019;f\u00072,\u0017M\\3s\u001b\u0006t\u0017mZ3s)\u0011\tyGa1\t\rA#\u0005\u0019AAM\u0003a\u0019'/Z1uK\u000ecW-\u00198fe6\u000bg.Y4fe6{7m\u001b\u000b\u0005\u0003g\u0013I\rC\u0004\u0003L\u0016\u0003\r!a%\u0002\tA|w\u000e\\\u0001\nGJ,\u0017\r^3M_\u001e$\u0002\"!'\u0003R\nU'q\u001c\u0005\b\u0005'4\u0005\u0019AA\u001e\u0003-\u0019XmZ7f]R\u001c\u0016N_3\t\u000f\t]g\t1\u0001\u0003Z\u0006i1\r\\3b]V\u0004\bk\u001c7jGf\u0004B!a1\u0003\\&!!Q\\Ag\u0005\u0019\u0019FO]5oO\"9aO\u0012I\u0001\u0002\u0004A\u0018aE2sK\u0006$X\rT8hI\u0011,g-Y;mi\u0012\u001aTC\u0001BsU\rA\u0018\u0011`\u0001\u001cGJ,\u0017\r^3M_^\u0014V\r^3oi&|g\u000eT8h\u0007>tg-[4\u0015\r\u0005\r\"1\u001eBw\u0011\u001d\u0011\u0019\u000e\u0013a\u0001\u0003wAqAa6I\u0001\u0004\u0011I.\u0001\u0007xe&$XMU3d_J$7\u000f\u0006\u0006\u0002T\nM(Q\u001fB}\u0005{Da\u0001U%A\u0002\u0005e\u0005b\u0002B|\u0013\u0002\u0007\u00111H\u0001\u000b]Vl')\u0019;dQ\u0016\u001c\bb\u0002B~\u0013\u0002\u0007\u00111H\u0001\u0010e\u0016\u001cwN\u001d3t!\u0016\u0014()\u0019;dQ\"9!q`%A\u0002\u0005m\u0012!\u00052bi\u000eDWm\u001d)feN+w-\\3oi\u0006i\u0011\r\u001d9f]\u0012\u0014VmY8sIN$b!a5\u0004\u0006\r\u001d\u0001B\u0002)K\u0001\u0004\tI\nC\u0004\u0004\n)\u0003\r!a\u000f\u0002\u00159,XNU3d_J$7/A\u0004nC.,Gj\\4\u0015\r\u0005e5qBB\n\u0011!\u0019\tb\u0013I\u0001\u0002\u00049\u0017a\u00013je\"91QC&A\u0002\u0005\r\u0012AB2p]\u001aLw-A\tnC.,Gj\\4%I\u00164\u0017-\u001e7uIE*\"aa\u0007+\u0007\u001d\fI0A\u0004sK\u000e|'\u000fZ:\u0015\u0011\r\u00052QFB\u0019\u0007k\u0001Baa\t\u0004*5\u00111Q\u0005\u0006\u0004\u0007OQ\u0018A\u0002:fG>\u0014H-\u0003\u0003\u0004,\r\u0015\"!D'f[>\u0014\u0018PU3d_J$7\u000fC\u0004\u000405\u0003\r!a\u000f\u0002\u0007-,\u0017\u0010C\u0004\u000445\u0003\r!a\u000f\u0002\u000bY\fG.^3\t\u000f\r]R\n1\u0001\u0002d\u0005IA/[7fgR\fW\u000e\u001d")
public class LogCleanerManagerTest
implements Logging {
    private final File tmpDir = TestUtils.tempDirectory(null, null);
    private final File tmpDir2 = TestUtils.tempDirectory(null, null);
    private final File logDir = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir());
    private final File logDir2 = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir());
    private final TopicPartition topicPartition = new TopicPartition("log", 0);
    private final TopicPartition topicPartition2 = new TopicPartition("log2", 0);
    private final Properties logProps = new Properties();
    private final LogConfig logConfig;
    private final MockTime time;
    private final int offset;
    private final ProducerStateManagerConfig producerStateManagerConfig;
    private final scala.collection.mutable.Map<TopicPartition, Object> cleanerCheckpoints;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$((Logging)this, (String)msg);
    }

    public void trace(Function0<String> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$((Logging)this, msg, e);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$((Logging)this, msg, e);
    }

    public void info(Function0<String> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$((Logging)this, msg, e);
    }

    public void warn(Function0<String> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$((Logging)this, msg, e);
    }

    public void error(Function0<String> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$((Logging)this, msg, e);
    }

    public void fatal(Function0<String> msg) {
        Logging.fatal$((Logging)this, msg);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$((Logging)this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public File tmpDir() {
        return this.tmpDir;
    }

    public File tmpDir2() {
        return this.tmpDir2;
    }

    public File logDir() {
        return this.logDir;
    }

    public File logDir2() {
        return this.logDir2;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public TopicPartition topicPartition2() {
        return this.topicPartition2;
    }

    public Properties logProps() {
        return this.logProps;
    }

    public LogConfig logConfig() {
        return this.logConfig;
    }

    public MockTime time() {
        return this.time;
    }

    public int offset() {
        return this.offset;
    }

    public ProducerStateManagerConfig producerStateManagerConfig() {
        return this.producerStateManagerConfig;
    }

    public scala.collection.mutable.Map<TopicPartition, Object> cleanerCheckpoints() {
        return this.cleanerCheckpoints;
    }

    @AfterEach
    public void tearDown() {
        Utils.delete((File)this.tmpDir());
    }

    private Pool<TopicPartition, UnifiedLog> setupIncreasinglyFilthyLogs(scala.collection.immutable.Seq<TopicPartition> partitions, int startNumBatches, int batchIncrement) {
        Pool logs = new Pool((Option)None$.MODULE$);
        IntRef numBatches = IntRef.create((int)startNumBatches);
        partitions.foreach((Function1 & Serializable)tp -> {
            LogCleanerManagerTest.$anonfun$setupIncreasinglyFilthyLogs$1(this, logs, numBatches, batchIncrement, tp);
            return BoxedUnit.UNIT;
        });
        return logs;
    }

    @Test
    public void testGrabFilthiestCompactedLogThrowsException() {
        TopicPartition tp = new TopicPartition("A", 1);
        int logSegmentSize = TestUtils$.MODULE$.singletonRecords("test".getBytes(), null, CompressionType.NONE, -1L, (byte)2).sizeInBytes() * 10;
        int logSegmentsCount = 2;
        File tpDir = new File(this.logDir(), "A-1");
        Files.createDirectories(tpDir.toPath(), new FileAttribute[0]);
        LogDirFailureChannel logDirFailureChannel = new LogDirFailureChannel(10);
        LogConfig config = this.createLowRetentionLogConfig(logSegmentSize, LogConfig$.MODULE$.Compact());
        int maxTransactionTimeoutMs = 300000;
        int producerIdExpirationCheckIntervalMs = Defaults$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        LogSegments segments = new LogSegments(tp);
        Option leaderEpochCache = UnifiedLog$.MODULE$.maybeCreateLeaderEpochCache(tpDir, this.topicPartition(), logDirFailureChannel, config.recordVersion(), "");
        ProducerStateManager producerStateManager = new ProducerStateManager(this.topicPartition(), tpDir, maxTransactionTimeoutMs, this.producerStateManagerConfig(), (Time)this.time());
        LoadedLogOffsets offsets = new LogLoader(tpDir, tp, config, (Scheduler)this.time().scheduler(), (Time)this.time(), logDirFailureChannel, true, segments, 0L, 0L, leaderEpochCache, producerStateManager, new ConcurrentHashMap()).load();
        LocalLog localLog = new LocalLog(tpDir, config, segments, offsets.recoveryPoint(), offsets.nextOffsetMetadata(), (Scheduler)this.time().scheduler(), (Time)this.time(), tp, logDirFailureChannel);
        public class Kafka_log_LogCleanerManagerTest$LogMock$1
        extends UnifiedLog {
            public Iterable<Object> getFirstBatchTimestampForSegments(Iterable<LogSegment> segments) {
                throw new IllegalStateException("Error!");
            }

            public Kafka_log_LogCleanerManagerTest$LogMock$1(LogCleanerManagerTest $outer, LoadedLogOffsets offsets$1, LocalLog localLog$1, int producerIdExpirationCheckIntervalMs$1, Option leaderEpochCache$1, ProducerStateManager producerStateManager$1) {
                super(offsets$1.logStartOffset(), localLog$1, new BrokerTopicStats(), producerIdExpirationCheckIntervalMs$1, leaderEpochCache$1, producerStateManager$1, (Option)None$.MODULE$, true);
            }
        }
        Kafka_log_LogCleanerManagerTest$LogMock$1 log = new Kafka_log_LogCleanerManagerTest$LogMock$1(null, offsets, localLog, producerIdExpirationCheckIntervalMs, leaderEpochCache, producerStateManager);
        this.writeRecords(log, logSegmentsCount * 2, 10, 2);
        Pool logsPool = new Pool((Option)None$.MODULE$);
        logsPool.put((Object)tp, (Object)log);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock((Pool<TopicPartition, UnifiedLog>)logsPool);
        this.cleanerCheckpoints().put((Object)tp, (Object)BoxesRunTime.boxToLong((long)1L));
        LogCleaningException thrownException = (LogCleaningException)Assertions.assertThrows(LogCleaningException.class, () -> cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2()).get());
        Assertions.assertEquals((Object)((Object)log), (Object)thrownException.log());
        Assertions.assertTrue((boolean)(thrownException.getCause() instanceof IllegalStateException));
    }

    @Test
    public void testGrabFilthiestCompactedLogReturnsLogWithDirtiestRatio() {
        TopicPartition tp0 = new TopicPartition("wishing-well", 0);
        TopicPartition tp1 = new TopicPartition("wishing-well", 1);
        TopicPartition tp2 = new TopicPartition("wishing-well", 2);
        .colon.colon partitions = new .colon.colon((Object)tp0, (List)new .colon.colon((Object)tp1, (List)new .colon.colon((Object)tp2, (List)Nil$.MODULE$)));
        Pool<TopicPartition, UnifiedLog> logs = this.setupIncreasinglyFilthyLogs((scala.collection.immutable.Seq<TopicPartition>)partitions, 20, 5);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock(logs);
        partitions.foreach((Function1 & Serializable)partition -> this.cleanerCheckpoints().put(partition, (Object)BoxesRunTime.boxToLong((long)20L)));
        LogToClean filthiestLog = (LogToClean)cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2()).get();
        Assertions.assertEquals((Object)tp2, (Object)filthiestLog.topicPartition());
        Assertions.assertEquals((Object)tp2, (Object)filthiestLog.log().topicPartition());
    }

    @Test
    public void testGrabFilthiestCompactedLogIgnoresUncleanablePartitions() {
        TopicPartition tp0 = new TopicPartition("wishing-well", 0);
        TopicPartition tp1 = new TopicPartition("wishing-well", 1);
        TopicPartition tp2 = new TopicPartition("wishing-well", 2);
        .colon.colon partitions = new .colon.colon((Object)tp0, (List)new .colon.colon((Object)tp1, (List)new .colon.colon((Object)tp2, (List)Nil$.MODULE$)));
        Pool<TopicPartition, UnifiedLog> logs = this.setupIncreasinglyFilthyLogs((scala.collection.immutable.Seq<TopicPartition>)partitions, 20, 5);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock(logs);
        partitions.foreach((Function1 & Serializable)partition -> this.cleanerCheckpoints().put(partition, (Object)BoxesRunTime.boxToLong((long)20L)));
        cleanerManager.markPartitionUncleanable(((UnifiedLog)logs.get((Object)tp2)).dir().getParent(), tp2);
        LogToClean filthiestLog = (LogToClean)cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2()).get();
        Assertions.assertEquals((Object)tp1, (Object)filthiestLog.topicPartition());
        Assertions.assertEquals((Object)tp1, (Object)filthiestLog.log().topicPartition());
    }

    @Test
    public void testGrabFilthiestCompactedLogIgnoresInProgressPartitions() {
        TopicPartition tp0 = new TopicPartition("wishing-well", 0);
        TopicPartition tp1 = new TopicPartition("wishing-well", 1);
        TopicPartition tp2 = new TopicPartition("wishing-well", 2);
        .colon.colon partitions = new .colon.colon((Object)tp0, (List)new .colon.colon((Object)tp1, (List)new .colon.colon((Object)tp2, (List)Nil$.MODULE$)));
        Pool<TopicPartition, UnifiedLog> logs = this.setupIncreasinglyFilthyLogs((scala.collection.immutable.Seq<TopicPartition>)partitions, 20, 5);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock(logs);
        partitions.foreach((Function1 & Serializable)partition -> this.cleanerCheckpoints().put(partition, (Object)BoxesRunTime.boxToLong((long)20L)));
        cleanerManager.setCleaningState(tp2, (LogCleaningState)LogCleaningInProgress$.MODULE$);
        LogToClean filthiestLog = (LogToClean)cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2()).get();
        Assertions.assertEquals((Object)tp1, (Object)filthiestLog.topicPartition());
        Assertions.assertEquals((Object)tp1, (Object)filthiestLog.log().topicPartition());
    }

    @Test
    public void testGrabFilthiestCompactedLogIgnoresBothInProgressPartitionsAndUncleanablePartitions() {
        TopicPartition tp0 = new TopicPartition("wishing-well", 0);
        TopicPartition tp1 = new TopicPartition("wishing-well", 1);
        TopicPartition tp2 = new TopicPartition("wishing-well", 2);
        .colon.colon partitions = new .colon.colon((Object)tp0, (List)new .colon.colon((Object)tp1, (List)new .colon.colon((Object)tp2, (List)Nil$.MODULE$)));
        Pool<TopicPartition, UnifiedLog> logs = this.setupIncreasinglyFilthyLogs((scala.collection.immutable.Seq<TopicPartition>)partitions, 20, 5);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock(logs);
        partitions.foreach((Function1 & Serializable)partition -> this.cleanerCheckpoints().put(partition, (Object)BoxesRunTime.boxToLong((long)20L)));
        cleanerManager.setCleaningState(tp2, (LogCleaningState)LogCleaningInProgress$.MODULE$);
        cleanerManager.markPartitionUncleanable(((UnifiedLog)logs.get((Object)tp1)).dir().getParent(), tp1);
        Option filthiestLog = cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)filthiestLog);
    }

    @Test
    public void testDirtyOffsetResetIfLargerThanEndOffset() {
        TopicPartition tp = new TopicPartition("foo", 0);
        Pool<TopicPartition, UnifiedLog> logs = this.setupIncreasinglyFilthyLogs((scala.collection.immutable.Seq<TopicPartition>)new .colon.colon((Object)tp, (List)Nil$.MODULE$), 20, 5);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock(logs);
        this.cleanerCheckpoints().put((Object)tp, (Object)BoxesRunTime.boxToLong((long)200L));
        LogToClean filthiestLog = (LogToClean)cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2()).get();
        Assertions.assertEquals((long)0L, (long)filthiestLog.firstDirtyOffset());
    }

    @Test
    public void testDirtyOffsetResetIfSmallerThanStartOffset() {
        TopicPartition tp = new TopicPartition("foo", 0);
        Pool<TopicPartition, UnifiedLog> logs = this.setupIncreasinglyFilthyLogs((scala.collection.immutable.Seq<TopicPartition>)new .colon.colon((Object)tp, (List)Nil$.MODULE$), 20, 5);
        ((UnifiedLog)logs.get((Object)tp)).maybeIncrementLogStartOffset(10L, (LogStartOffsetIncrementReason)ClientRecordDeletion$.MODULE$);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock(logs);
        this.cleanerCheckpoints().put((Object)tp, (Object)BoxesRunTime.boxToLong((long)0L));
        LogToClean filthiestLog = (LogToClean)cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2()).get();
        Assertions.assertEquals((long)10L, (long)filthiestLog.firstDirtyOffset());
    }

    @Test
    public void testLogStartOffsetLargerThanActiveSegmentBaseOffset() {
        TopicPartition tp = new TopicPartition("foo", 0);
        UnifiedLog log = this.createLog(2048, LogConfig$.MODULE$.Compact(), tp);
        Pool logs = new Pool((Option)None$.MODULE$);
        logs.put((Object)tp, (Object)log);
        this.appendRecords(log, 3);
        this.appendRecords(log, 3);
        this.appendRecords(log, 3);
        Assertions.assertEquals((int)1, (int)log.logSegments().size());
        log.maybeIncrementLogStartOffset(2L, (LogStartOffsetIncrementReason)ClientRecordDeletion$.MODULE$);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock((Pool<TopicPartition, UnifiedLog>)logs);
        this.cleanerCheckpoints().put((Object)tp, (Object)BoxesRunTime.boxToLong((long)0L));
        Option filthiestLog = cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)filthiestLog);
    }

    @Test
    public void testDirtyOffsetLargerThanActiveSegmentBaseOffset() {
        TopicPartition tp = new TopicPartition("foo", 0);
        Pool logs = new Pool((Option)None$.MODULE$);
        UnifiedLog log = this.createLog(2048, LogConfig$.MODULE$.Compact(), tp);
        logs.put((Object)tp, (Object)log);
        this.appendRecords(log, 3);
        this.appendRecords(log, 3);
        Assertions.assertEquals((int)1, (int)log.logSegments().size());
        Assertions.assertEquals((long)0L, (long)log.activeSegment().baseOffset());
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock((Pool<TopicPartition, UnifiedLog>)logs);
        this.cleanerCheckpoints().put((Object)tp, (Object)BoxesRunTime.boxToLong((long)3L));
        Option filthiestLog = cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)filthiestLog);
    }

    @Test
    public void testLogsWithSegmentsToDeleteShouldNotConsiderCleanupPolicyDeleteLogs() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), null, CompressionType.NONE, -1L, (byte)2);
        UnifiedLog log = this.createLog(records.sizeInBytes() * 5, LogConfig$.MODULE$.Delete(), this.createLog$default$3());
        int readyToDelete = this.createCleanerManager(log).deletableLogs().size();
        Assertions.assertEquals((int)0, (int)readyToDelete, (String)"should have 0 logs ready to be deleted");
    }

    @Test
    public void testLogsWithSegmentsToDeleteShouldConsiderCleanupPolicyCompactDeleteLogs() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), CompressionType.NONE, -1L, (byte)2);
        UnifiedLog log = this.createLog(records.sizeInBytes() * 5, new StringBuilder(1).append(LogConfig$.MODULE$.Compact()).append(",").append(LogConfig$.MODULE$.Delete()).toString(), this.createLog$default$3());
        int readyToDelete = this.createCleanerManager(log).deletableLogs().size();
        Assertions.assertEquals((int)1, (int)readyToDelete, (String)"should have 1 logs ready to be deleted");
    }

    @Test
    public void testLogsWithSegmentsToDeleteShouldConsiderCleanupPolicyCompactLogs() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), CompressionType.NONE, -1L, (byte)2);
        UnifiedLog log = this.createLog(records.sizeInBytes() * 5, LogConfig$.MODULE$.Compact(), this.createLog$default$3());
        int readyToDelete = this.createCleanerManager(log).deletableLogs().size();
        Assertions.assertEquals((int)1, (int)readyToDelete, (String)"should have 1 logs ready to be deleted");
    }

    @Test
    public void testLogsUnderCleanupIneligibleForCompaction() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), CompressionType.NONE, -1L, (byte)2);
        UnifiedLog log = this.createLog(records.sizeInBytes() * 5, LogConfig$.MODULE$.Delete(), this.createLog$default$3());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        log.appendAsLeader(records, 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.roll(log.roll$default$1());
        log.appendAsLeader(records, 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.updateHighWatermark(2L);
        Iterable deletableLog = cleanerManager.pauseCleaningForNonCompactedPartitions();
        Assertions.assertEquals((int)1, (int)deletableLog.size(), (String)"should have 1 logs ready to be deleted");
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), log.config().segmentSize());
        logProps.put(LogConfig$.MODULE$.RetentionMsProp(), log.config().retentionMs());
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact());
        logProps.put(LogConfig$.MODULE$.MinCleanableDirtyRatioProp(), Predef$.MODULE$.int2Integer(0));
        LogConfig config = new LogConfig((Map)logProps, LogConfig$.MODULE$.apply$default$2());
        log.updateConfig(config);
        Option cleanable = cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2());
        Assertions.assertEquals((int)0, (int)Option$.MODULE$.option2Iterable(cleanable).size(), (String)"should have 0 logs ready to be compacted");
        cleanerManager.resumeCleaning((Iterable)deletableLog.map((Function1 & Serializable)x$2 -> (TopicPartition)x$2._1()));
        Option cleanable2 = cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2());
        Assertions.assertEquals((int)1, (int)Option$.MODULE$.option2Iterable(cleanable2).size(), (String)"should have 1 logs ready to be compacted");
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Delete());
        LogConfig config2 = new LogConfig((Map)logProps, LogConfig$.MODULE$.apply$default$2());
        log.updateConfig(config2);
        Iterable deletableLog2 = cleanerManager.pauseCleaningForNonCompactedPartitions();
        Assertions.assertEquals((int)0, (int)deletableLog2.size(), (String)"should have 0 logs ready to be deleted");
        cleanerManager.doneDeleting((Iterable)new .colon.colon((Object)((LogToClean)cleanable2.get()).topicPartition(), (List)Nil$.MODULE$));
        Iterable deletableLog3 = cleanerManager.pauseCleaningForNonCompactedPartitions();
        Assertions.assertEquals((int)1, (int)deletableLog3.size(), (String)"should have 1 logs ready to be deleted");
    }

    @Test
    public void testUpdateCheckpointsShouldAddOffsetToPartition() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), CompressionType.NONE, -1L, (byte)2);
        UnifiedLog log = this.createLog(records.sizeInBytes() * 5, LogConfig$.MODULE$.Compact(), this.createLog$default$3());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        Assertions.assertNotEquals((Object)BoxesRunTime.boxToInteger((int)this.offset()), (Object)cleanerManager.allCleanerCheckpoints().getOrElse((Object)this.topicPartition(), (Function0)(JFunction0.mcI.sp & Serializable)() -> 0));
        cleanerManager.updateCheckpoints(this.logDir(), Option$.MODULE$.apply((Object)new Tuple2((Object)this.topicPartition(), (Object)BoxesRunTime.boxToLong((long)this.offset()))), cleanerManager.updateCheckpoints$default$3());
        Assertions.assertEquals((long)this.offset(), (long)BoxesRunTime.unboxToLong((Object)cleanerManager.allCleanerCheckpoints().apply((Object)this.topicPartition())));
    }

    @Test
    public void testUpdateCheckpointsShouldRemovePartitionData() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), CompressionType.NONE, -1L, (byte)2);
        UnifiedLog log = this.createLog(records.sizeInBytes() * 5, LogConfig$.MODULE$.Compact(), this.createLog$default$3());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        cleanerManager.updateCheckpoints(this.logDir(), Option$.MODULE$.apply((Object)new Tuple2((Object)this.topicPartition(), (Object)BoxesRunTime.boxToLong((long)this.offset()))), cleanerManager.updateCheckpoints$default$3());
        Assertions.assertEquals((long)this.offset(), (long)BoxesRunTime.unboxToLong((Object)cleanerManager.allCleanerCheckpoints().apply((Object)this.topicPartition())));
        File x$1 = this.logDir();
        Option x$2 = Option$.MODULE$.apply((Object)this.topicPartition());
        Option x$3 = cleanerManager.updateCheckpoints$default$2();
        cleanerManager.updateCheckpoints(x$1, x$3, x$2);
        Assertions.assertFalse((boolean)cleanerManager.allCleanerCheckpoints().contains((Object)this.topicPartition()));
    }

    @Test
    public void testHandleLogDirFailureShouldRemoveDirAndData() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), CompressionType.NONE, -1L, (byte)2);
        UnifiedLog log = this.createLog(records.sizeInBytes() * 5, LogConfig$.MODULE$.Compact(), this.createLog$default$3());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        cleanerManager.updateCheckpoints(this.logDir(), Option$.MODULE$.apply((Object)new Tuple2((Object)this.topicPartition(), (Object)BoxesRunTime.boxToLong((long)this.offset()))), cleanerManager.updateCheckpoints$default$3());
        cleanerManager.updateCheckpoints(this.logDir2(), Option$.MODULE$.apply((Object)new Tuple2((Object)this.topicPartition2(), (Object)BoxesRunTime.boxToLong((long)this.offset()))), cleanerManager.updateCheckpoints$default$3());
        Assertions.assertEquals((long)this.offset(), (long)BoxesRunTime.unboxToLong((Object)cleanerManager.allCleanerCheckpoints().apply((Object)this.topicPartition())));
        Assertions.assertEquals((long)this.offset(), (long)BoxesRunTime.unboxToLong((Object)cleanerManager.allCleanerCheckpoints().apply((Object)this.topicPartition2())));
        cleanerManager.handleLogDirFailure(this.logDir().getAbsolutePath());
        Assertions.assertEquals((long)this.offset(), (long)BoxesRunTime.unboxToLong((Object)cleanerManager.allCleanerCheckpoints().apply((Object)this.topicPartition2())));
        Assertions.assertFalse((boolean)cleanerManager.allCleanerCheckpoints().contains((Object)this.topicPartition()));
    }

    @Test
    public void testMaybeTruncateCheckpointShouldTruncateData() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), CompressionType.NONE, -1L, (byte)2);
        UnifiedLog log = this.createLog(records.sizeInBytes() * 5, LogConfig$.MODULE$.Compact(), this.createLog$default$3());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        long lowerOffset = 1L;
        long higherOffset = 1000L;
        cleanerManager.updateCheckpoints(this.logDir(), Option$.MODULE$.apply((Object)new Tuple2((Object)this.topicPartition(), (Object)BoxesRunTime.boxToLong((long)this.offset()))), cleanerManager.updateCheckpoints$default$3());
        Assertions.assertEquals((long)this.offset(), (long)BoxesRunTime.unboxToLong((Object)cleanerManager.allCleanerCheckpoints().apply((Object)this.topicPartition())));
        cleanerManager.maybeTruncateCheckpoint(this.logDir(), this.topicPartition(), higherOffset);
        Assertions.assertEquals((long)this.offset(), (long)BoxesRunTime.unboxToLong((Object)cleanerManager.allCleanerCheckpoints().apply((Object)this.topicPartition())));
        cleanerManager.maybeTruncateCheckpoint(this.logDir(), this.topicPartition(), lowerOffset);
        Assertions.assertEquals((long)lowerOffset, (long)BoxesRunTime.unboxToLong((Object)cleanerManager.allCleanerCheckpoints().apply((Object)this.topicPartition())));
    }

    @Test
    public void testAlterCheckpointDirShouldRemoveDataInSrcDirAndAddInNewDir() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), CompressionType.NONE, -1L, (byte)2);
        UnifiedLog log = this.createLog(records.sizeInBytes() * 5, LogConfig$.MODULE$.Compact(), this.createLog$default$3());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        cleanerManager.updateCheckpoints(this.logDir(), Option$.MODULE$.apply((Object)new Tuple2((Object)this.topicPartition(), (Object)BoxesRunTime.boxToLong((long)this.offset()))), cleanerManager.updateCheckpoints$default$3());
        Assertions.assertEquals((long)this.offset(), (long)BoxesRunTime.unboxToLong((Object)cleanerManager.allCleanerCheckpoints().apply((Object)this.topicPartition())));
        cleanerManager.alterCheckpointDir(this.topicPartition(), this.logDir(), this.logDir2());
        Assertions.assertEquals((long)this.offset(), (long)BoxesRunTime.unboxToLong((Object)cleanerManager.allCleanerCheckpoints().apply((Object)this.topicPartition())));
        cleanerManager.handleLogDirFailure(this.logDir2().getAbsolutePath());
        Assertions.assertFalse((boolean)cleanerManager.allCleanerCheckpoints().contains((Object)this.topicPartition()));
    }

    @Test
    public void testConcurrentLogCleanupAndLogTruncation() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), CompressionType.NONE, -1L, (byte)2);
        UnifiedLog log = this.createLog(records.sizeInBytes() * 5, LogConfig$.MODULE$.Delete(), this.createLog$default$3());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        Iterable pausedPartitions = cleanerManager.pauseCleaningForNonCompactedPartitions();
        cleanerManager.abortAndPauseCleaning(log.topicPartition());
        cleanerManager.resumeCleaning((Iterable)new .colon.colon((Object)log.topicPartition(), (List)Nil$.MODULE$));
        cleanerManager.resumeCleaning((Iterable)pausedPartitions.map((Function1 & Serializable)x$3 -> (TopicPartition)x$3._1()));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)cleanerManager.cleaningState(log.topicPartition()));
    }

    @Test
    public void testConcurrentLogCleanupAndTopicDeletion() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), CompressionType.NONE, -1L, (byte)2);
        UnifiedLog log = this.createLog(records.sizeInBytes() * 5, LogConfig$.MODULE$.Delete(), this.createLog$default$3());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        Iterable pausedPartitions = cleanerManager.pauseCleaningForNonCompactedPartitions();
        cleanerManager.abortCleaning(log.topicPartition());
        cleanerManager.resumeCleaning((Iterable)pausedPartitions.map((Function1 & Serializable)x$4 -> (TopicPartition)x$4._1()));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)cleanerManager.cleaningState(log.topicPartition()));
    }

    @Test
    public void testLogsWithSegmentsToDeleteShouldNotConsiderUncleanablePartitions() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), CompressionType.NONE, -1L, (byte)2);
        UnifiedLog log = this.createLog(records.sizeInBytes() * 5, LogConfig$.MODULE$.Compact(), this.createLog$default$3());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        cleanerManager.markPartitionUncleanable(log.dir().getParent(), this.topicPartition());
        int readyToDelete = cleanerManager.deletableLogs().size();
        Assertions.assertEquals((int)0, (int)readyToDelete, (String)"should have 0 logs ready to be deleted");
    }

    @Test
    public void testCleanableOffsetsForNone() {
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.logDir();
        UnifiedLog log = this.makeLog(x$2, x$1);
        while (log.numberOfSegments() < 8) {
            log.appendAsLeader(this.records((int)log.logEndOffset(), (int)log.logEndOffset(), this.time().milliseconds()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        }
        log.updateHighWatermark(50L);
        Some lastCleanOffset = new Some((Object)BoxesRunTime.boxToLong((long)0L));
        OffsetsToClean cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets(log, (Option)lastCleanOffset, this.time().milliseconds());
        Assertions.assertEquals((long)0L, (long)cleanableOffsets.firstDirtyOffset(), (String)"The first cleanable offset starts at the beginning of the log.");
        Assertions.assertEquals((long)log.highWatermark(), (long)log.lastStableOffset(), (String)"The high watermark equals the last stable offset as no transactions are in progress");
        Assertions.assertEquals((long)log.lastStableOffset(), (long)cleanableOffsets.firstUncleanableDirtyOffset(), (String)"The first uncleanable offset is bounded by the last stable offset.");
    }

    @Test
    public void testCleanableOffsetsActiveSegment() {
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.logDir();
        UnifiedLog log = this.makeLog(x$2, x$1);
        while (log.numberOfSegments() < 8) {
            log.appendAsLeader(this.records((int)log.logEndOffset(), (int)log.logEndOffset(), this.time().milliseconds()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        }
        log.updateHighWatermark(log.logEndOffset());
        Some lastCleanOffset = new Some((Object)BoxesRunTime.boxToLong((long)0L));
        OffsetsToClean cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets(log, (Option)lastCleanOffset, this.time().milliseconds());
        Assertions.assertEquals((long)0L, (long)cleanableOffsets.firstDirtyOffset(), (String)"The first cleanable offset starts at the beginning of the log.");
        Assertions.assertEquals((long)log.activeSegment().baseOffset(), (long)cleanableOffsets.firstUncleanableDirtyOffset(), (String)"The first uncleanable offset begins with the active segment.");
    }

    @Test
    public void testCleanableOffsetsForTime() {
        int compactionLag = 3600000;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        logProps.put(LogConfig$.MODULE$.MinCompactionLagMsProp(), Predef$.MODULE$.int2Integer(compactionLag));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.logDir();
        UnifiedLog log = this.makeLog(x$2, x$1);
        long t0 = this.time().milliseconds();
        while (log.numberOfSegments() < 4) {
            log.appendAsLeader(this.records((int)log.logEndOffset(), (int)log.logEndOffset(), t0), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        }
        LogSegment activeSegAtT0 = log.activeSegment();
        this.time().sleep(compactionLag + 1);
        long t1 = this.time().milliseconds();
        while (log.numberOfSegments() < 8) {
            log.appendAsLeader(this.records((int)log.logEndOffset(), (int)log.logEndOffset(), t1), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        }
        log.updateHighWatermark(log.logEndOffset());
        Some lastCleanOffset = new Some((Object)BoxesRunTime.boxToLong((long)0L));
        OffsetsToClean cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets(log, (Option)lastCleanOffset, this.time().milliseconds());
        Assertions.assertEquals((long)0L, (long)cleanableOffsets.firstDirtyOffset(), (String)"The first cleanable offset starts at the beginning of the log.");
        Assertions.assertEquals((long)activeSegAtT0.baseOffset(), (long)cleanableOffsets.firstUncleanableDirtyOffset(), (String)"The first uncleanable offset begins with the second block of log entries.");
    }

    @Test
    public void testCleanableOffsetsForShortTime() {
        int compactionLag = 3600000;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        logProps.put(LogConfig$.MODULE$.MinCompactionLagMsProp(), Predef$.MODULE$.int2Integer(compactionLag));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.logDir();
        UnifiedLog log = this.makeLog(x$2, x$1);
        long t0 = this.time().milliseconds();
        while (log.numberOfSegments() < 8) {
            log.appendAsLeader(this.records((int)log.logEndOffset(), (int)log.logEndOffset(), t0), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        }
        log.updateHighWatermark(log.logEndOffset());
        this.time().sleep(compactionLag + 1);
        Some lastCleanOffset = new Some((Object)BoxesRunTime.boxToLong((long)0L));
        OffsetsToClean cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets(log, (Option)lastCleanOffset, this.time().milliseconds());
        Assertions.assertEquals((long)0L, (long)cleanableOffsets.firstDirtyOffset(), (String)"The first cleanable offset starts at the beginning of the log.");
        Assertions.assertEquals((long)log.activeSegment().baseOffset(), (long)cleanableOffsets.firstUncleanableDirtyOffset(), (String)"The first uncleanable offset begins with active segment.");
    }

    @Test
    public void testCleanableOffsetsNeedsCheckpointReset() {
        TopicPartition tp = new TopicPartition("foo", 0);
        Pool<TopicPartition, UnifiedLog> logs = this.setupIncreasinglyFilthyLogs((scala.collection.immutable.Seq<TopicPartition>)new .colon.colon((Object)tp, (List)Nil$.MODULE$), 20, 5);
        ((UnifiedLog)logs.get((Object)tp)).maybeIncrementLogStartOffset(10L, (LogStartOffsetIncrementReason)ClientRecordDeletion$.MODULE$);
        Some lastCleanOffset = new Some((Object)BoxesRunTime.boxToLong((long)15L));
        Assertions.assertFalse((boolean)LogCleanerManager$.MODULE$.cleanableOffsets((UnifiedLog)logs.get((Object)tp), (Option)lastCleanOffset, this.time().milliseconds()).forceUpdateCheckpoint(), (String)"Checkpoint offset should not be reset if valid");
        ((UnifiedLog)logs.get((Object)tp)).maybeIncrementLogStartOffset(20L, (LogStartOffsetIncrementReason)ClientRecordDeletion$.MODULE$);
        Assertions.assertTrue((boolean)LogCleanerManager$.MODULE$.cleanableOffsets((UnifiedLog)logs.get((Object)tp), (Option)lastCleanOffset, this.time().milliseconds()).forceUpdateCheckpoint(), (String)"Checkpoint offset needs to be reset if less than log start offset");
        lastCleanOffset = new Some((Object)BoxesRunTime.boxToLong((long)25L));
        Assertions.assertTrue((boolean)LogCleanerManager$.MODULE$.cleanableOffsets((UnifiedLog)logs.get((Object)tp), (Option)lastCleanOffset, this.time().milliseconds()).forceUpdateCheckpoint(), (String)"Checkpoint offset needs to be reset if greater than log end offset");
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testUndecidedTransactionalDataNotCleanable() {
        void withEndTransactionMarker_marker;
        void withTransactionalRecords_records;
        void withTransactionalRecords_baseSequence;
        void withTransactionalRecords_records2;
        int compactionLag = 3600000;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        logProps.put(LogConfig$.MODULE$.MinCompactionLagMsProp(), Predef$.MODULE$.int2Integer(compactionLag));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.logDir();
        UnifiedLog log = this.makeLog(x$2, x$1);
        long producerId = 15L;
        short producerEpoch = (short)0;
        int sequence = 0;
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord(this.time().milliseconds(), "1".getBytes(), "a".getBytes()), new SimpleRecord(this.time().milliseconds(), "2".getBytes(), "b".getBytes())};
        CompressionType withTransactionalRecords_compressionType = CompressionType.NONE;
        Object var11_10 = null;
        simpleRecordArray = null;
        log.appendAsLeader(MemoryRecords.withRecords((byte)2, (long)0L, (CompressionType)withTransactionalRecords_compressionType, (TimestampType)TimestampType.CREATE_TIME, (long)producerId, (short)producerEpoch, (int)sequence, (int)-1, (boolean)true, (SimpleRecord[])withTransactionalRecords_records2), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        SimpleRecord[] simpleRecordArray2 = new SimpleRecord[]{new SimpleRecord(this.time().milliseconds(), "3".getBytes(), "c".getBytes())};
        int n = sequence + 2;
        CompressionType withTransactionalRecords_compressionType2 = CompressionType.NONE;
        Object var13_13 = null;
        simpleRecordArray2 = null;
        log.appendAsLeader(MemoryRecords.withRecords((byte)2, (long)0L, (CompressionType)withTransactionalRecords_compressionType2, (TimestampType)TimestampType.CREATE_TIME, (long)producerId, (short)producerEpoch, (int)withTransactionalRecords_baseSequence, (int)-1, (boolean)true, (SimpleRecord[])withTransactionalRecords_records), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.roll(log.roll$default$1());
        log.updateHighWatermark(3L);
        this.time().sleep(compactionLag + 1);
        OffsetsToClean cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets(log, (Option)new Some((Object)BoxesRunTime.boxToLong((long)0L)), this.time().milliseconds());
        Assertions.assertEquals((long)0L, (long)cleanableOffsets.firstDirtyOffset());
        Assertions.assertEquals((long)0L, (long)cleanableOffsets.firstUncleanableDirtyOffset());
        EndTransactionMarker endTransactionMarker = new EndTransactionMarker(ControlRecordType.ABORT, 15);
        long withEndTransactionMarker_timestamp = this.time().milliseconds();
        endTransactionMarker = null;
        log.appendAsLeader(MemoryRecords.withEndTransactionMarker((long)0L, (long)withEndTransactionMarker_timestamp, (int)-1, (long)producerId, (short)producerEpoch, (EndTransactionMarker)withEndTransactionMarker_marker), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.roll(log.roll$default$1());
        log.updateHighWatermark(4L);
        cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets(log, (Option)new Some((Object)BoxesRunTime.boxToLong((long)0L)), this.time().milliseconds());
        Assertions.assertEquals((long)0L, (long)cleanableOffsets.firstDirtyOffset());
        Assertions.assertEquals((long)3L, (long)cleanableOffsets.firstUncleanableDirtyOffset());
        this.time().sleep(compactionLag + 1);
        cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets(log, (Option)new Some((Object)BoxesRunTime.boxToLong((long)0L)), this.time().milliseconds());
        Assertions.assertEquals((long)0L, (long)cleanableOffsets.firstDirtyOffset());
        Assertions.assertEquals((long)4L, (long)cleanableOffsets.firstUncleanableDirtyOffset());
    }

    @Test
    public void testDoneCleaning() {
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.logDir();
        UnifiedLog log = this.makeLog(x$2, x$1);
        while (log.numberOfSegments() < 8) {
            log.appendAsLeader(this.records((int)log.logEndOffset(), (int)log.logEndOffset(), this.time().milliseconds()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        }
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        Assertions.assertThrows(IllegalStateException.class, () -> cleanerManager.doneCleaning(this.topicPartition(), log.dir(), 1L));
        cleanerManager.setCleaningState(this.topicPartition(), (LogCleaningState)new LogCleaningPaused(1));
        Assertions.assertThrows(IllegalStateException.class, () -> cleanerManager.doneCleaning(this.topicPartition(), log.dir(), 1L));
        cleanerManager.setCleaningState(this.topicPartition(), (LogCleaningState)LogCleaningInProgress$.MODULE$);
        long endOffset = 1L;
        cleanerManager.doneCleaning(this.topicPartition(), log.dir(), endOffset);
        Assertions.assertTrue((boolean)cleanerManager.cleaningState(this.topicPartition()).isEmpty());
        Assertions.assertTrue((boolean)cleanerManager.allCleanerCheckpoints().contains((Object)this.topicPartition()));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)endOffset)), (Object)cleanerManager.allCleanerCheckpoints().get((Object)this.topicPartition()));
        cleanerManager.setCleaningState(this.topicPartition(), (LogCleaningState)LogCleaningAborted$.MODULE$);
        cleanerManager.doneCleaning(this.topicPartition(), log.dir(), endOffset);
        Assertions.assertEquals((Object)new LogCleaningPaused(1), (Object)cleanerManager.cleaningState(this.topicPartition()).get());
        Assertions.assertTrue((boolean)cleanerManager.allCleanerCheckpoints().contains((Object)this.topicPartition()));
    }

    @Test
    public void testDoneDeleting() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), CompressionType.NONE, -1L, (byte)2);
        UnifiedLog log = this.createLog(records.sizeInBytes() * 5, new StringBuilder(1).append(LogConfig$.MODULE$.Compact()).append(",").append(LogConfig$.MODULE$.Delete()).toString(), this.createLog$default$3());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        TopicPartition tp = new TopicPartition("log", 0);
        Assertions.assertThrows(IllegalStateException.class, () -> cleanerManager.doneDeleting((Iterable)new .colon.colon((Object)tp, (List)Nil$.MODULE$)));
        cleanerManager.setCleaningState(tp, (LogCleaningState)new LogCleaningPaused(1));
        Assertions.assertThrows(IllegalStateException.class, () -> cleanerManager.doneDeleting((Iterable)new .colon.colon((Object)tp, (List)Nil$.MODULE$)));
        cleanerManager.setCleaningState(tp, (LogCleaningState)LogCleaningInProgress$.MODULE$);
        cleanerManager.doneDeleting((Iterable)new .colon.colon((Object)tp, (List)Nil$.MODULE$));
        Assertions.assertTrue((boolean)cleanerManager.cleaningState(tp).isEmpty());
        cleanerManager.setCleaningState(tp, (LogCleaningState)LogCleaningAborted$.MODULE$);
        cleanerManager.doneDeleting((Iterable)new .colon.colon((Object)tp, (List)Nil$.MODULE$));
        Assertions.assertEquals((Object)new LogCleaningPaused(1), (Object)cleanerManager.cleaningState(tp).get());
    }

    @Test
    public void testCheckpointUpdatedForInvalidOffsetNoCleaning() {
        TopicPartition tp = new TopicPartition("foo", 0);
        Pool<TopicPartition, UnifiedLog> logs = this.setupIncreasinglyFilthyLogs((scala.collection.immutable.Seq<TopicPartition>)new .colon.colon((Object)tp, (List)Nil$.MODULE$), 20, 5);
        ((UnifiedLog)logs.get((Object)tp)).maybeIncrementLogStartOffset(20L, (LogStartOffsetIncrementReason)ClientRecordDeletion$.MODULE$);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock(logs);
        this.cleanerCheckpoints().put((Object)tp, (Object)BoxesRunTime.boxToLong((long)15L));
        Option filthiestLog = cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)filthiestLog, (String)"Log should not be selected for cleaning");
        Assertions.assertEquals((long)20L, (long)BoxesRunTime.unboxToLong((Object)this.cleanerCheckpoints().apply((Object)tp)), (String)"Unselected log should have checkpoint offset updated");
    }

    @Test
    public void testCheckpointUpdatedForInvalidOffsetNotSelected() {
        TopicPartition tp0 = new TopicPartition("foo", 0);
        TopicPartition tp1 = new TopicPartition("foo", 1);
        .colon.colon partitions = new .colon.colon((Object)tp0, (List)new .colon.colon((Object)tp1, (List)Nil$.MODULE$));
        Pool<TopicPartition, UnifiedLog> logs = this.setupIncreasinglyFilthyLogs((scala.collection.immutable.Seq<TopicPartition>)partitions, 20, 5);
        ((UnifiedLog)logs.get((Object)tp0)).maybeIncrementLogStartOffset(15L, (LogStartOffsetIncrementReason)ClientRecordDeletion$.MODULE$);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock(logs);
        this.cleanerCheckpoints().put((Object)tp0, (Object)BoxesRunTime.boxToLong((long)10L));
        this.cleanerCheckpoints().put((Object)tp1, (Object)BoxesRunTime.boxToLong((long)5L));
        LogToClean filthiestLog = (LogToClean)cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2()).get();
        Assertions.assertEquals((Object)tp1, (Object)filthiestLog.topicPartition(), (String)"Dirtier log should be selected");
        Assertions.assertEquals((long)15L, (long)BoxesRunTime.unboxToLong((Object)this.cleanerCheckpoints().apply((Object)tp0)), (String)"Unselected log should have checkpoint offset updated");
    }

    private LogCleanerManager createCleanerManager(UnifiedLog log) {
        Pool logs = new Pool((Option)None$.MODULE$);
        logs.put((Object)this.topicPartition(), (Object)log);
        return new LogCleanerManager((Seq)new .colon.colon((Object)this.logDir(), (List)new .colon.colon((Object)this.logDir2(), (List)Nil$.MODULE$)), logs, null);
    }

    private LogCleanerManagerMock createCleanerManagerMock(Pool<TopicPartition, UnifiedLog> pool) {
        return new LogCleanerManagerMock((scala.collection.immutable.Seq<File>)new .colon.colon((Object)this.logDir(), (List)Nil$.MODULE$), pool, null);
    }

    private UnifiedLog createLog(int segmentSize, String cleanupPolicy, TopicPartition topicPartition) {
        LogConfig config = this.createLowRetentionLogConfig(segmentSize, cleanupPolicy);
        File partitionDir = new File(this.logDir(), LocalLog$.MODULE$.logDirName(topicPartition));
        MockScheduler x$5 = this.time().scheduler();
        MockTime x$6 = this.time();
        BrokerTopicStats x$7 = new BrokerTopicStats();
        ProducerStateManagerConfig x$9 = this.producerStateManagerConfig();
        int x$10 = Defaults$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        LogDirFailureChannel x$11 = new LogDirFailureChannel(10);
        None$ x$12 = None$.MODULE$;
        boolean x$14 = true;
        ConcurrentHashMap x$15 = new ConcurrentHashMap();
        return UnifiedLog$.MODULE$.apply(partitionDir, config, 0L, 0L, (Scheduler)x$5, x$7, (Time)x$6, 300000, x$9, x$10, x$11, x$14, (Option)x$12, true, x$15);
    }

    private TopicPartition createLog$default$3() {
        return new TopicPartition("log", 0);
    }

    private LogConfig createLowRetentionLogConfig(int segmentSize, String cleanupPolicy) {
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(segmentSize));
        logProps.put(LogConfig$.MODULE$.RetentionMsProp(), Predef$.MODULE$.int2Integer(1));
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), cleanupPolicy);
        logProps.put(LogConfig$.MODULE$.MinCleanableDirtyRatioProp(), Predef$.MODULE$.double2Double(0.05));
        return new LogConfig((Map)logProps, LogConfig$.MODULE$.apply$default$2());
    }

    private void writeRecords(UnifiedLog log, int numBatches, int recordsPerBatch, int batchesPerSegment) {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numBatches).foreach((Function1 & Serializable)i -> LogCleanerManagerTest.$anonfun$writeRecords$1(this, log, recordsPerBatch, batchesPerSegment, BoxesRunTime.unboxToInt((Object)i)));
        log.roll(log.roll$default$1());
    }

    /*
     * WARNING - void declaration
     */
    private void appendRecords(UnifiedLog log, int numRecords) {
        void withRecords_records;
        void withRecords_timestampType;
        long startOffset = log.logEndOffset();
        long endOffset = startOffset + (long)numRecords;
        LongRef lastTimestamp = LongRef.create((long)0L);
        IndexedSeq records = (IndexedSeq)new RichLong(Predef$.MODULE$.longWrapper(startOffset)).until((Object)BoxesRunTime.boxToLong((long)endOffset)).map((Function1 & Serializable)offset -> LogCleanerManagerTest.$anonfun$appendRecords$1(this, endOffset, lastTimestamp, BoxesRunTime.unboxToLong((Object)offset)));
        SimpleRecord[] simpleRecordArray = (SimpleRecord[])records.toArray(ClassTag$.MODULE$.apply(SimpleRecord.class));
        CompressionType withRecords_compressionType = CompressionType.NONE;
        byte withRecords_magic = 2;
        TimestampType timestampType = TimestampType.CREATE_TIME;
        long withRecords_initialOffset = 0L;
        timestampType = null;
        Object var9_8 = null;
        simpleRecordArray = null;
        log.appendAsLeader(MemoryRecords.withRecords((byte)withRecords_magic, (long)withRecords_initialOffset, (CompressionType)withRecords_compressionType, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records), 1, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.maybeIncrementHighWatermark(log.logEndOffsetMetadata());
    }

    private UnifiedLog makeLog(File dir, LogConfig config) {
        MockScheduler x$5 = this.time().scheduler();
        MockTime x$6 = this.time();
        BrokerTopicStats x$7 = new BrokerTopicStats();
        ProducerStateManagerConfig x$9 = this.producerStateManagerConfig();
        int x$10 = Defaults$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        LogDirFailureChannel x$11 = new LogDirFailureChannel(10);
        None$ x$12 = None$.MODULE$;
        boolean x$14 = true;
        ConcurrentHashMap x$15 = new ConcurrentHashMap();
        return UnifiedLog$.MODULE$.apply(dir, config, 0L, 0L, (Scheduler)x$5, x$7, (Time)x$6, 300000, x$9, x$10, x$11, x$14, (Option)x$12, true, x$15);
    }

    private File makeLog$default$1() {
        return this.logDir();
    }

    /*
     * WARNING - void declaration
     */
    private MemoryRecords records(int key, int value, long timestamp) {
        void withRecords_records;
        void withRecords_timestampType;
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord(timestamp, Integer.toString(key).getBytes(), Integer.toString(value).getBytes())};
        CompressionType withRecords_compressionType = CompressionType.NONE;
        byte withRecords_magic = 2;
        TimestampType timestampType = TimestampType.CREATE_TIME;
        long withRecords_initialOffset = 0L;
        return MemoryRecords.withRecords((byte)withRecords_magic, (long)withRecords_initialOffset, (CompressionType)withRecords_compressionType, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records);
    }

    public static final /* synthetic */ void $anonfun$setupIncreasinglyFilthyLogs$1(LogCleanerManagerTest $this, Pool logs$1, IntRef numBatches$1, int batchIncrement$1, TopicPartition tp) {
        UnifiedLog log = $this.createLog(2048, LogConfig$.MODULE$.Compact(), tp);
        logs$1.put((Object)tp, (Object)log);
        $this.writeRecords(log, numBatches$1.elem, 1, 5);
        numBatches$1.elem += batchIncrement$1;
    }

    public static final /* synthetic */ Object $anonfun$writeRecords$1(LogCleanerManagerTest $this, UnifiedLog log$2, int recordsPerBatch$1, int batchesPerSegment$1, int i) {
        $this.appendRecords(log$2, recordsPerBatch$1);
        if (i % batchesPerSegment$1 == 0) {
            return log$2.roll(log$2.roll$default$1());
        }
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ SimpleRecord $anonfun$appendRecords$1(LogCleanerManagerTest $this, long endOffset$1, LongRef lastTimestamp$1, long offset) {
        long currentTimestamp = $this.time().milliseconds();
        if (offset == endOffset$1 - 1L) {
            lastTimestamp$1.elem = currentTimestamp;
        }
        return new SimpleRecord(currentTimestamp, new StringBuilder(4).append("key-").append(offset).toString().getBytes(), new StringBuilder(6).append("value-").append(offset).toString().getBytes());
    }

    public LogCleanerManagerTest() {
        this.logProps().put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        this.logProps().put(LogConfig$.MODULE$.SegmentIndexBytesProp(), Predef$.MODULE$.int2Integer(1024));
        this.logProps().put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact());
        this.logConfig = new LogConfig((Map)this.logProps(), LogConfig$.MODULE$.apply$default$2());
        this.time = new MockTime(1400000000000L, 1000L);
        this.offset = 999;
        this.producerStateManagerConfig = new ProducerStateManagerConfig(Defaults$.MODULE$.ProducerIdExpirationMs());
        this.cleanerCheckpoints = (scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
    }

    public class LogCleanerManagerMock
    extends LogCleanerManager {
        public scala.collection.immutable.Map<TopicPartition, Object> allCleanerCheckpoints() {
            return this.kafka$log$LogCleanerManagerTest$LogCleanerManagerMock$$$outer().cleanerCheckpoints().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }

        /*
         * WARNING - void declaration
         */
        public void updateCheckpoints(File dataDir, Option<Tuple2<TopicPartition, Object>> partitionToUpdateOrAdd, Option<TopicPartition> partitionToRemove) {
            void var5_5;
            Predef$.MODULE$.assert(partitionToRemove.isEmpty(), (Function0 & Serializable)() -> "partitionToRemove argument with value not yet handled");
            Tuple2 tuple2 = (Tuple2)partitionToUpdateOrAdd.getOrElse((Function0 & Serializable)() -> {
                throw new IllegalArgumentException("partitionToUpdateOrAdd==None argument not yet handled");
            });
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            TopicPartition tp = (TopicPartition)tuple2._1();
            long l = tuple2._2$mcJ$sp();
            this.kafka$log$LogCleanerManagerTest$LogCleanerManagerMock$$$outer().cleanerCheckpoints().put((Object)var5_5, (Object)BoxesRunTime.boxToLong((long)l));
        }

        public Option<Tuple2<TopicPartition, Object>> updateCheckpoints$default$2() {
            return None$.MODULE$;
        }

        public Option<TopicPartition> updateCheckpoints$default$3() {
            return None$.MODULE$;
        }

        public /* synthetic */ LogCleanerManagerTest kafka$log$LogCleanerManagerTest$LogCleanerManagerMock$$$outer() {
            return LogCleanerManagerTest.this;
        }

        public LogCleanerManagerMock(scala.collection.immutable.Seq<File> logDirs, Pool<TopicPartition, UnifiedLog> logs, LogDirFailureChannel logDirFailureChannel) {
            if (LogCleanerManagerTest.this == null) {
                throw null;
            }
            super(logDirs, logs, logDirFailureChannel);
        }
    }
}

