/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.common.RequestAndCompletionHandler;
import kafka.coordinator.AbstractCoordinatorConcurrencyTest;
import kafka.coordinator.transaction.CompleteAbort$;
import kafka.coordinator.transaction.CompleteCommit$;
import kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata;
import kafka.coordinator.transaction.Empty$;
import kafka.coordinator.transaction.InitProducerIdResult;
import kafka.coordinator.transaction.Ongoing$;
import kafka.coordinator.transaction.PrepareCommit$;
import kafka.coordinator.transaction.ProducerIdManager;
import kafka.coordinator.transaction.TransactionConfig;
import kafka.coordinator.transaction.TransactionCoordinator;
import kafka.coordinator.transaction.TransactionCoordinatorConcurrencyTest$InitProducerIdOperation$;
import kafka.coordinator.transaction.TransactionLog$;
import kafka.coordinator.transaction.TransactionMarkerChannelManager;
import kafka.coordinator.transaction.TransactionMetadata;
import kafka.coordinator.transaction.TransactionState;
import kafka.coordinator.transaction.TransactionStateManager;
import kafka.coordinator.transaction.TransactionStateManager$;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.UnifiedLog;
import kafka.log.UnifiedLog$;
import kafka.server.Defaults$;
import kafka.server.FetchDataInfo;
import kafka.server.FetchIsolation;
import kafka.server.FetchLogEnd$;
import kafka.server.KafkaConfig$;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.MetadataCache;
import kafka.server.ReplicaManager;
import kafka.server.RequestLocal$;
import kafka.utils.Pool;
import kafka.utils.Scheduler;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.requests.TransactionResult;
import org.apache.kafka.common.requests.WriteTxnMarkersRequest;
import org.apache.kafka.common.requests.WriteTxnMarkersResponse;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.ProducerIdAndEpoch;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0005\u0011-c\u0001B7o\u0001UDq!a\b\u0001\t\u0003\t\u0019\fC\u0005\u00028\u0002\u0011\r\u0011\"\u0003\u0002:\"A\u0011\u0011\u0019\u0001!\u0002\u0013\tY\fC\u0005\u0002D\u0002\u0011\r\u0011\"\u0003\u0002:\"A\u0011Q\u0019\u0001!\u0002\u0013\tY\fC\u0005\u0002H\u0002\u0011\r\u0011\"\u0003\u0002:\"A\u0011\u0011\u001a\u0001!\u0002\u0013\tY\fC\u0005\u0002L\u0002\u0011\r\u0011\"\u0003\u0002N\"A\u0011Q\u001b\u0001!\u0002\u0013\ty\rC\u0006\u0002X\u0002\u0001\r\u00111A\u0005\n\u0005e\u0007bCAq\u0001\u0001\u0007\t\u0019!C\u0005\u0003GD1\"a:\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002\\\"Y\u0011\u0011\u001e\u0001A\u0002\u0003\u0007I\u0011BAv\u0011-\t\u0019\u0010\u0001a\u0001\u0002\u0004%I!!>\t\u0017\u0005e\b\u00011A\u0001B\u0003&\u0011Q\u001e\u0005\f\u0003w\u0004\u0001\u0019!a\u0001\n\u0013\ti\u0010C\u0006\u0003\u0006\u0001\u0001\r\u00111A\u0005\n\t\u001d\u0001b\u0003B\u0006\u0001\u0001\u0007\t\u0011)Q\u0005\u0003\u007fD\u0011B!\u0004\u0001\u0005\u0004%IAa\u0004\t\u0011\t%\u0006\u0001)A\u0005\u0005#A\u0011Ba+\u0001\u0005\u0004%IA!,\t\u0011\tm\u0006\u0001)A\u0005\u0005_C\u0011B!0\u0001\u0005\u0004%IAa0\t\u0011\tm\u0007\u0001)A\u0005\u0005\u0003D\u0011\"a\u0013\u0001\u0005\u0004%\tA!8\t\u0011\t}\u0007\u0001)A\u0005\u0003\u001bB\u0011B!9\u0001\u0001\u0004%I!a$\t\u0013\t\r\b\u00011A\u0005\n\t\u0015\b\u0002\u0003Bu\u0001\u0001\u0006K!!%\t\u000f\t-\b\u0001\"\u0011\u0003n\"91Q\u0001\u0001\u0005B\t5\bbBB\b\u0001\u0011\u0005!Q\u001e\u0005\b\u00073\u0001A\u0011\u0001Bw\u0011\u001d\u0019i\u0002\u0001C\u0001\u0005[Dqa!\t\u0001\t\u0003\u0011i\u000fC\u0004\u0004&\u0001!\tA!<\t\u000f\r%\u0002\u0001\"\u0001\u0003n\"91Q\u0006\u0001\u0005\u0002\t5\bbBB\u0019\u0001\u0011\u0005!Q\u001e\u0005\b\u0007k\u0001A\u0011\u0001Bw\u0011\u001d\u0019I\u0004\u0001C\u0001\u0005[Dqa!\u0010\u0001\t\u0003\u0011i\u000fC\u0004\u0004B\u0001!\tE!<\t\u000f\r\r\u0003\u0001\"\u0003\u0004F!911\f\u0001\u0005\n\ru\u0003bBB3\u0001\u0011%1q\r\u0005\b\u0007o\u0002A\u0011BB=\u0011\u001d\u0019)\t\u0001C\u0005\u0007\u000fCqaa#\u0001\t\u0013\u0019i\tC\u0004\u0004\u0014\u0002!Ia!&\u0007\u000f\t\u001d\u0002!!\u0001\u0003*!9\u0011qD\u001a\u0005\u0002\tM\u0002\"\u0003B'g\u0001\u0007I\u0011\u0001B(\u0011%\u00119f\ra\u0001\n\u0003\u0011I\u0006\u0003\u0005\u0003^M\u0002\u000b\u0015\u0002B)\u0011\u001d\u0011\tg\rC\u0001\u0005G2aa!'\u0001\u0001\rm\u0005BCBPs\t\u0015\r\u0011\"\u0001\u0004\"\"Q11V\u001d\u0003\u0002\u0003\u0006Iaa)\t\u000f\u0005}\u0011\b\"\u0001\u0004.\"911W\u001d\u0005B\rU\u0006bBB]s\u0011\u000531X\u0004\n\u0007\u007f\u0003\u0011\u0011!E\u0001\u0007\u00034\u0011b!'\u0001\u0003\u0003E\taa1\t\u000f\u0005}\u0001\t\"\u0001\u0004F\"I1q\u0019!\u0012\u0002\u0013\u00051\u0011\u001a\u0004\u0007\u0007?\u0004\u0001a!9\t\u0015\r\u00158I!A!\u0002\u0013\u00199\u000fC\u0004\u0002 \r#\ta!=\t\u000f\rM6\t\"\u0011\u0004x\"91\u0011X\"\u0005B\rmhABB\u0000\u0001\u0001!\t\u0001C\u0004\u0002 !#\t\u0001b\u0001\t\u000f\rM\u0006\n\"\u0011\u0005\b!91\u0011\u0018%\u0005B\u0011-\u0001b\u0002C\b\u0011\u0012%A\u0011\u0003\u0004\u0007\tC\u0001\u0001\u0001b\t\t\u0015\u0011\u0015RJ!A!\u0002\u0013\tY\fC\u0004\u0002 5#\t\u0001b\n\t\u000f\rMV\n\"\u0011\u0003n\"9AQF'\u0005B\t5hA\u0002C\u0018\u0001\u0001!\t\u0004\u0003\u0006\u0005&I\u0013\t\u0011)A\u0005\u0003wCq!a\bS\t\u0003!\u0019\u0004C\u0005\u0005:I\u0013\r\u0011\"\u0001\u0005<!AAQ\b*!\u0002\u0013\u0011I\rC\u0004\u00044J#\tE!<\t\u000f\u00115\"\u000b\"\u0011\u0003n\u001a1Aq\b\u0001\u0001\t\u0003B!\u0002b\u0011Z\u0005\u0003\u0005\u000b\u0011BB0\u0011\u001d\ty\"\u0017C\u0001\t\u000bBqaa-Z\t\u0003\u0012i\u000fC\u0004\u0005.e#\tE!<\b\u000f\u0005-a\u000e#\u0001\u0002\u000e\u00191QN\u001cE\u0001\u0003#Aq!a\b`\t\u0003\t\tC\u0002\u0004\u0002$}\u0003\u0011Q\u0005\u0005\u000b\u0003k\t'Q1A\u0005\u0002\u0005]\u0002BCA%C\n\u0005\t\u0015!\u0003\u0002:!Q\u00111J1\u0003\u0002\u0003\u0006I!!\u0014\t\u0015\u0005M\u0013M!A!\u0002\u0013\t)\u0006C\u0004\u0002 \u0005$\t!a\u001c\t\u0013\u0005m\u0014M1A\u0005\u0002\u0005u\u0004\u0002CAFC\u0002\u0006I!a \t\u0013\u00055\u0015\r1A\u0005\u0002\u0005=\u0005\"CALC\u0002\u0007I\u0011AAM\u0011!\t)+\u0019Q!\n\u0005E\u0005bBAXC\u0012\u0005\u0013\u0011\u0017\u0002&)J\fgn]1di&|gnQ8pe\u0012Lg.\u0019;pe\u000e{gnY;se\u0016t7-\u001f+fgRT!a\u001c9\u0002\u0017Q\u0014\u0018M\\:bGRLwN\u001c\u0006\u0003cJ\f1bY8pe\u0012Lg.\u0019;pe*\t1/A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u00011\bcA<yu6\t\u0001/\u0003\u0002za\n\u0011\u0013IY:ue\u0006\u001cGoQ8pe\u0012Lg.\u0019;pe\u000e{gnY;se\u0016t7-\u001f+fgR\u0004\"a_1\u000f\u0005qtfbA?\u0002\n9\u0019a0a\u0002\u000f\u0007}\f)!\u0004\u0002\u0002\u0002)\u0019\u00111\u0001;\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0019\u0018BA9s\u0013\ty\u0007/A\u0013Ue\u0006t7/Y2uS>t7i\\8sI&t\u0017\r^8s\u0007>t7-\u001e:sK:\u001c\u0017\u0010V3tiB\u0019\u0011qB0\u000e\u00039\u001c2aXA\n!\u0011\t)\"a\u0007\u000e\u0005\u0005]!BAA\r\u0003\u0015\u00198-\u00197b\u0013\u0011\ti\"a\u0006\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\u0011\u0011Q\u0002\u0002\f)J\fgn]1di&|gnE\u0003b\u0003'\t9\u0003\u0005\u0003\u0002*\u0005=bbA?\u0002,%\u0019\u0011Q\u00069\u0002E\u0005\u00137\u000f\u001e:bGR\u001cun\u001c:eS:\fGo\u001c:D_:\u001cWO\u001d:f]\u000eLH+Z:u\u0013\u0011\t\t$a\r\u0003#\r{wN\u001d3j]\u0006$xN]'f[\n,'OC\u0002\u0002.A\fq\u0002\u001e:b]N\f7\r^5p]\u0006d\u0017\nZ\u000b\u0003\u0003s\u0001B!a\u000f\u0002D9!\u0011QHA !\ry\u0018qC\u0005\u0005\u0003\u0003\n9\"\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u000b\n9E\u0001\u0004TiJLgn\u001a\u0006\u0005\u0003\u0003\n9\"\u0001\tue\u0006t7/Y2uS>t\u0017\r\\%eA\u0005Q\u0001O]8ek\u000e,'/\u00133\u0011\t\u0005U\u0011qJ\u0005\u0005\u0003#\n9B\u0001\u0003M_:<\u0017\u0001\u0002;j[\u0016\u0004B!a\u0016\u0002l5\u0011\u0011\u0011\f\u0006\u0005\u00037\ni&A\u0003vi&d7O\u0003\u0003\u0002`\u0005\u0005\u0014AB2p[6|gNC\u0002t\u0003GRA!!\u001a\u0002h\u00051\u0011\r]1dQ\u0016T!!!\u001b\u0002\u0007=\u0014x-\u0003\u0003\u0002n\u0005e#\u0001C'pG.$\u0016.\\3\u0015\u0011\u0005E\u0014QOA<\u0003s\u00022!a\u001db\u001b\u0005y\u0006bBA\u001bM\u0002\u0007\u0011\u0011\b\u0005\b\u0003\u00172\u0007\u0019AA'\u0011\u001d\t\u0019F\u001aa\u0001\u0003+\n!\u0003\u001e=o\u001b\u0016\u001c8/Y4f\u0017\u0016L()\u001f;fgV\u0011\u0011q\u0010\t\u0007\u0003+\t\t)!\"\n\t\u0005\r\u0015q\u0003\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0005\u0003+\t9)\u0003\u0003\u0002\n\u0006]!\u0001\u0002\"zi\u0016\f1\u0003\u001e=o\u001b\u0016\u001c8/Y4f\u0017\u0016L()\u001f;fg\u0002\nQ!\u001a8eK\u0012,\"!!%\u0011\t\u0005U\u00111S\u0005\u0005\u0003+\u000b9BA\u0004C_>dW-\u00198\u0002\u0013\u0015tG-\u001a3`I\u0015\fH\u0003BAN\u0003C\u0003B!!\u0006\u0002\u001e&!\u0011qTA\f\u0005\u0011)f.\u001b;\t\u0013\u0005\r&.!AA\u0002\u0005E\u0015a\u0001=%c\u00051QM\u001c3fI\u0002B3a[AU!\u0011\t)\"a+\n\t\u00055\u0016q\u0003\u0002\tm>d\u0017\r^5mK\u0006AAo\\*ue&tw\r\u0006\u0002\u0002:Q\u0011\u0011Q\u0017\t\u0004\u0003\u001f\u0001\u0011!\u00048Ue\u0006t7/Y2uS>t7/\u0006\u0002\u0002<B!\u0011QCA_\u0013\u0011\ty,a\u0006\u0003\u0007%sG/\u0001\bo)J\fgn]1di&|gn\u001d\u0011\u0002!\r|wN\u001d3j]\u0006$xN]#q_\u000eD\u0017!E2p_J$\u0017N\\1u_J,\u0005o\\2iA\u0005ia.^7QCJ$\u0018\u000e^5p]N\faB\\;n!\u0006\u0014H/\u001b;j_:\u001c\b%A\u0005uq:\u001cuN\u001c4jOV\u0011\u0011q\u001a\t\u0005\u0003\u001f\t\t.C\u0002\u0002T:\u0014\u0011\u0003\u0016:b]N\f7\r^5p]\u000e{gNZ5h\u0003)!\bP\\\"p]\u001aLw\rI\u0001\u0017iJ\fgn]1di&|gnQ8pe\u0012Lg.\u0019;peV\u0011\u00111\u001c\t\u0005\u0003\u001f\ti.C\u0002\u0002`:\u0014a\u0003\u0016:b]N\f7\r^5p]\u000e{wN\u001d3j]\u0006$xN]\u0001\u001biJ\fgn]1di&|gnQ8pe\u0012Lg.\u0019;pe~#S-\u001d\u000b\u0005\u00037\u000b)\u000fC\u0005\u0002$.\t\t\u00111\u0001\u0002\\\u00069BO]1og\u0006\u001cG/[8o\u0007>|'\u000fZ5oCR|'\u000fI\u0001\u0010ibt7\u000b^1uK6\u000bg.Y4feV\u0011\u0011Q\u001e\t\u0005\u0003\u001f\ty/C\u0002\u0002r:\u0014q\u0003\u0016:b]N\f7\r^5p]N#\u0018\r^3NC:\fw-\u001a:\u0002'QDhn\u0015;bi\u0016l\u0015M\\1hKJ|F%Z9\u0015\t\u0005m\u0015q\u001f\u0005\n\u0003Gs\u0011\u0011!a\u0001\u0003[\f\u0001\u0003\u001e=o'R\fG/Z'b]\u0006<WM\u001d\u0011\u0002/QDh.T1sW\u0016\u00148\t[1o]\u0016dW*\u00198bO\u0016\u0014XCAA\u0000!\u0011\tyA!\u0001\n\u0007\t\raNA\u0010Ue\u0006t7/Y2uS>tW*\u0019:lKJ\u001c\u0005.\u00198oK2l\u0015M\\1hKJ\f1\u0004\u001e=o\u001b\u0006\u00148.\u001a:DQ\u0006tg.\u001a7NC:\fw-\u001a:`I\u0015\fH\u0003BAN\u0005\u0013A\u0011\"a)\u0012\u0003\u0003\u0005\r!a@\u00021QDh.T1sW\u0016\u00148\t[1o]\u0016dW*\u00198bO\u0016\u0014\b%A\u0007bY2|\u0005/\u001a:bi&|gn]\u000b\u0003\u0005#\u0001bAa\u0005\u0003\u001e\t\u0005RB\u0001B\u000b\u0015\u0011\u00119B!\u0007\u0002\u0013%lW.\u001e;bE2,'\u0002\u0002B\u000e\u0003/\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0011yB!\u0006\u0003\u0007M+\u0017\u000f\r\u0003\u0003$\t-\u0004#\u0002B\u0013g\t%T\"\u0001\u0001\u0003\u0019QChn\u00149fe\u0006$\u0018n\u001c8\u0016\t\t-\"1H\n\u0004g\t5\u0002\u0003\u0002B\u0013\u0005_I1A!\ry\u0005%y\u0005/\u001a:bi&|g\u000e\u0006\u0002\u00036A)!QE\u001a\u00038A!!\u0011\bB\u001e\u0019\u0001!qA!\u00104\u0005\u0004\u0011yDA\u0001S#\u0011\u0011\tEa\u0012\u0011\t\u0005U!1I\u0005\u0005\u0005\u000b\n9BA\u0004O_RD\u0017N\\4\u0011\t\u0005U!\u0011J\u0005\u0005\u0005\u0017\n9BA\u0002B]f\faA]3tk2$XC\u0001B)!\u0019\t)Ba\u0015\u00038%!!QKA\f\u0005\u0019y\u0005\u000f^5p]\u0006Q!/Z:vYR|F%Z9\u0015\t\u0005m%1\f\u0005\n\u0003G3\u0014\u0011!a\u0001\u0005#\nqA]3tk2$\b\u0005K\u00028\u0003S\u000baB]3tk2$8)\u00197mE\u0006\u001c7\u000e\u0006\u0003\u0002\u001c\n\u0015\u0004b\u0002B4q\u0001\u0007!qG\u0001\u0002eB!!\u0011\bB6\t-\u0011i\u0007AA\u0001\u0002\u0003\u0015\tAa\u001c\u0003\u0005}\u000b\u0014\u0003\u0002B9\u0005\u0013\u0013bAa\u001d\u0003x\t\reA\u0002B;\u0001\u0001\u0011\tH\u0001\u0007=e\u00164\u0017N\\3nK:$h\b\u0005\u0003\u0003z\t}TB\u0001B>\u0015\u0011\u0011i(!\u0018\u0002\u0011A\u0014x\u000e^8d_2LAA!!\u0003|\t1QI\u001d:peN\u0004B!a\u0004\u0003\u0006&\u0019!q\u00118\u0003)%s\u0017\u000e\u001e)s_\u0012,8-\u001a:JIJ+7/\u001e7u%\u0019\u0011YI!$\u0003\u001e\u001a1!Q\u000f\u0001\u0001\u0005\u0013\u0003BAa$\u0003\u001a6\u0011!\u0011\u0013\u0006\u0005\u0005'\u0013)*\u0001\u0003mC:<'B\u0001BL\u0003\u0011Q\u0017M^1\n\t\tm%\u0011\u0013\u0002\u0007\u001f\nTWm\u0019;\u0011\t\t}%QU\u0007\u0003\u0005CSAAa)\u0003\u0016\u0006\u0011\u0011n\\\u0005\u0005\u0005O\u0013\tK\u0001\u0007TKJL\u0017\r\\5{C\ndW-\u0001\bbY2|\u0005/\u001a:bi&|gn\u001d\u0011\u0002\u001f\u0005dG\u000e\u0016:b]N\f7\r^5p]N,\"Aa,\u0011\u000b\tE&q\u0017>\u000e\u0005\tM&\u0002\u0002B[\u00053\tq!\\;uC\ndW-\u0003\u0003\u0003:\nM&aA*fi\u0006\u0001\u0012\r\u001c7Ue\u0006t7/Y2uS>t7\u000fI\u0001\u0016ibt'+Z2pe\u0012\u001c()\u001f)beRLG/[8o+\t\u0011\t\r\u0005\u0005\u0003D\n\u0015\u00171\u0018Be\u001b\t\u0011I\"\u0003\u0003\u0003H\ne!aA'baB1!\u0011\u0017Bf\u0005\u001fLAA!4\u00034\nY\u0011I\u001d:bs\n+hMZ3s!\u0011\u0011\tNa6\u000e\u0005\tM'\u0002\u0002Bk\u0003;\naA]3d_J$\u0017\u0002\u0002Bm\u0005'\u0014AbU5na2,'+Z2pe\u0012\fa\u0003\u001e=o%\u0016\u001cwN\u001d3t\u0005f\u0004\u0016M\u001d;ji&|g\u000eI\u000b\u0003\u0003\u001b\n1\u0002\u001d:pIV\u001cWM]%eA\u0005q!-^7q!J|G-^2fe&#\u0017A\u00052v[B\u0004&o\u001c3vG\u0016\u0014\u0018\nZ0%KF$B!a'\u0003h\"I\u00111\u0015\u000f\u0002\u0002\u0003\u0007\u0011\u0011S\u0001\u0010EVl\u0007\u000f\u0015:pIV\u001cWM]%eA\u0005)1/\u001a;VaR\u0011\u00111\u0014\u0015\u0004=\tE\b\u0003\u0002Bz\u0007\u0003i!A!>\u000b\t\t](\u0011`\u0001\u0004CBL'\u0002\u0002B~\u0005{\fqA[;qSR,'O\u0003\u0003\u0003\u0000\u0006\u001d\u0014!\u00026v]&$\u0018\u0002BB\u0002\u0005k\u0014!BQ3g_J,W)Y2i\u0003!!X-\u0019:E_^t\u0007fA\u0010\u0004\nA!!1_B\u0006\u0013\u0011\u0019iA!>\u0003\u0013\u00053G/\u001a:FC\u000eD\u0017\u0001\u000e;fgR\u001cuN\\2veJ,g\u000e^$p_\u0012\u0004\u0016\r\u001e5XSRD7i\u001c8dkJ\u0014XM\u001c;QCJ$\u0018\u000e^5p]2{\u0017\rZ5oO\"\u001a\u0001ea\u0005\u0011\t\tM8QC\u0005\u0005\u0007/\u0011)P\u0001\u0003UKN$\u0018A\b;fgR\u001cuN\\2veJ,g\u000e^$p_\u0012\u0004\u0016\r\u001e5TKF,XM\\2fQ\r\t31C\u0001\u001ei\u0016\u001cHoQ8oGV\u0014(/\u001a8u%\u0006tGm\\7TKF,XM\\2fg\"\u001a!ea\u0005\u0002EQ,7\u000f^\"p]\u000e,(O]3oi2{\u0017\rZ+oY>\fG\rU1si&$\u0018n\u001c8tQ\r\u001931C\u0001$i\u0016\u001cHoQ8oGV\u0014(/\u001a8u)J\fgn]1di&|g.\u0012=qSJ\fG/[8oQ\r!31C\u0001(i\u0016\u001cHoQ8oGV\u0014(/\u001a8u\u001d\u0016<\u0018J\\5u!J|G-^2fe&#'+Z9vKN$8\u000fK\u0002&\u0007'\tq\u0007^3ti\u000e{gnY;se\u0016tG/\u00138jiB\u0013x\u000eZ;dKJLEMU3rk\u0016\u001cHo](oK:+wo\u00148f\u0007>tG/\u001b8vS:<\u0007f\u0001\u0014\u0004\u0014\u0005qC/Z:u\u0007>t7-\u001e:sK:$8i\u001c8uS:,\u0018N\\4J]&$\bK]8ek\u000e,'/\u00133SKF,Xm\u001d;tQ\r931C\u0001.i\u0016\u001cHoQ8oGV\u0014(/\u001a8u\u0013:LG\u000f\u0015:pIV\u001cWM]%e%\u0016\fX/Z:ug^KG\u000f\u001b*fiJL\bf\u0001\u0015\u0004\u0014\u0005yC/Z:u\u0007>t7-\u001e:sK:$\u0018J\\5u!J|G-^2feJ+\u0017/^3tiN\fE\u000fU5e\u0005>,h\u000eZ1ss\"\u001a\u0011fa\u0005\u0002qQ,7\u000f^\"p]\u000e,(O]3oi&s\u0017\u000e\u001e)s_\u0012,8-\u001a:SKF,Xm\u001d;t/&$\bNU3uef\fE\u000fU5e\u0005>,h\u000eZ1ss\"\u001a!fa\u0005\u0002!\u0015t\u0017M\u00197f\u0007>l\u0007\u000f\\3uS>t\u0017!\u00057pC\u0012,f\u000e\\8bI\u0006\u001bG/[8ogR11qIB)\u0007/\u0002b!a\u000f\u0004J\r-\u0013\u0002\u0002B]\u0003\u000f\u0002B!!\u000b\u0004N%!1qJA\u001a\u0005\u0019\t5\r^5p]\"911\u000b\u0017A\u0002\rU\u0013\u0001\u00059beRLG/[8ogR{Gj\\1e!\u0019\tYd!\u0013\u0002<\"91\u0011\f\u0017A\u0002\rU\u0013A\u00059beRLG/[8ogR{WK\u001c7pC\u0012\f!c\u0019:fCR,GK]1og\u0006\u001cG/[8ogR!1qLB1!\u0015\tYd!\u0013{\u0011\u001d\u0019\u0019'\fa\u0001\u0003s\t\u0011\u0002\u001e=o!J,g-\u001b=\u0002#Y,'/\u001b4z)J\fgn]1di&|g\u000e\u0006\u0004\u0002\u001c\u000e%4Q\u000e\u0005\u0007\u0007Wr\u0003\u0019\u0001>\u0002\u0007QDh\u000eC\u0004\u0004p9\u0002\ra!\u001d\u0002\u001b\u0015D\b/Z2uK\u0012\u001cF/\u0019;f!\u0011\tyaa\u001d\n\u0007\rUdN\u0001\tUe\u0006t7/Y2uS>t7\u000b^1uK\u0006\u0019BO]1og\u0006\u001cG/[8o\u001b\u0016$\u0018\rZ1uCR!11PBB!\u0019\t)Ba\u0015\u0004~A!\u0011qBB@\u0013\r\u0019\tI\u001c\u0002\u0014)J\fgn]1di&|g.T3uC\u0012\fG/\u0019\u0005\u0007\u0007Wz\u0003\u0019\u0001>\u0002%A\u0014X\r]1sKR\u0013\u0018M\\:bGRLwN\u001c\u000b\u0005\u00037\u001bI\t\u0003\u0004\u0004lA\u0002\rA_\u0001\u000eaJ,\u0007/\u0019:f)btGj\\4\u0015\t\u0005m5q\u0012\u0005\b\u0007#\u000b\u0004\u0019AA^\u0003-\u0001\u0018M\u001d;ji&|g.\u00133\u0002AA\u0014X\r]1sK\u0016C\b.Y;ti\u0016$W\t]8dQRCh.T3uC\u0012\fG/\u0019\u000b\u0005\u0007{\u001a9\n\u0003\u0004\u0004lI\u0002\rA\u001f\u0002\u0018\u0013:LG\u000f\u0015:pIV\u001cWM]%e\u001fB,'/\u0019;j_:\u001c2!OBO!\u0015\u0011)c\rBB\u0003I\u0001(o\u001c3vG\u0016\u0014\u0018\nZ!oI\u0016\u0003xn\u00195\u0016\u0005\r\r\u0006CBA\u000b\u0005'\u001a)\u000b\u0005\u0003\u0002X\r\u001d\u0016\u0002BBU\u00033\u0012!\u0003\u0015:pIV\u001cWM]%e\u0003:$W\t]8dQ\u0006\u0019\u0002O]8ek\u000e,'/\u00133B]\u0012,\u0005o\\2iAQ!1qVBY!\r\u0011)#\u000f\u0005\n\u0007?c\u0004\u0013!a\u0001\u0007G\u000b1A];o)\u0011\tYja.\t\r\r-T\b1\u0001{\u00039\tw/Y5u\u0003:$g+\u001a:jMf$B!a'\u0004>\"111\u000e A\u0002i\fq#\u00138jiB\u0013x\u000eZ;dKJLEm\u00149fe\u0006$\u0018n\u001c8\u0011\u0007\t\u0015\u0002iE\u0002A\u0003'!\"a!1\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00132+\t\u0019YM\u000b\u0003\u0004$\u000e57FABh!\u0011\u0019\tna7\u000e\u0005\rM'\u0002BBk\u0007/\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\t\re\u0017qC\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BBo\u0007'\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0005m\tE\r\u001a)beRLG/[8ogR{G\u000b\u001f8Pa\u0016\u0014\u0018\r^5p]N\u00191ia9\u0011\u000b\t\u00152Ga\u001e\u0002\u0015A\f'\u000f^5uS>t7\u000f\u0005\u0004\u0002<\r%3\u0011\u001e\t\u0005\u0007W\u001ci/\u0004\u0002\u0002^%!1q^A/\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:$Baa=\u0004vB\u0019!QE\"\t\u000f\r\u0015X\t1\u0001\u0004hR!\u00111TB}\u0011\u0019\u0019YG\u0012a\u0001uR!\u00111TB\u007f\u0011\u0019\u0019Yg\u0012a\u0001u\nyQI\u001c3Uq:|\u0005/\u001a:bi&|gnE\u0002I\u0007G$\"\u0001\"\u0002\u0011\u0007\t\u0015\u0002\n\u0006\u0003\u0002\u001c\u0012%\u0001BBB6\u0015\u0002\u0007!\u0010\u0006\u0003\u0002\u001c\u00125\u0001BBB6\u0017\u0002\u0007!0A\tue\u0006t7/Y2uS>t'+Z:vYR$B\u0001b\u0005\u0005 A!AQ\u0003C\u000e\u001b\t!9B\u0003\u0003\u0005\u001a\u0005u\u0013\u0001\u0003:fcV,7\u000f^:\n\t\u0011uAq\u0003\u0002\u0012)J\fgn]1di&|gNU3tk2$\bBBB6\u0019\u0002\u0007!P\u0001\fM_\u0006$G\u000b\u001f8QCJ$\u0018\u000e^5p]\u0006\u001bG/[8o'\u0015i%QRB&\u0003M!\bP\u001c+pa&\u001c\u0007+\u0019:uSRLwN\\%e)\u0011!I\u0003b\u000b\u0011\u0007\t\u0015R\nC\u0004\u0005&=\u0003\r!a/\u0002\u000b\u0005<\u0018-\u001b;\u00031UsGn\\1e)bt\u0007+\u0019:uSRLwN\\!di&|gnE\u0003S\u0005\u001b\u001bY\u0005\u0006\u0003\u00056\u0011]\u0002c\u0001B\u0013%\"9AQ\u0005+A\u0002\u0005m\u0016A\u0003;y]J+7m\u001c:egV\u0011!\u0011Z\u0001\fibt'+Z2pe\u0012\u001c\bE\u0001\rFqBL'/\u001a+sC:\u001c\u0018m\u0019;j_:\u001c\u0018i\u0019;j_:\u001cR!\u0017BG\u0007\u0017\nA\u0002\u001e:b]N\f7\r^5p]N$B\u0001b\u0012\u0005JA\u0019!QE-\t\u000f\u0011\r3\f1\u0001\u0004`\u0001")
public class TransactionCoordinatorConcurrencyTest
extends AbstractCoordinatorConcurrencyTest<Transaction> {
    private volatile TransactionCoordinatorConcurrencyTest$InitProducerIdOperation$ InitProducerIdOperation$module;
    private final int nTransactions = this.nThreads() * 10;
    private final int kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$coordinatorEpoch;
    private final int kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$numPartitions = this.nThreads() * 5;
    private final TransactionConfig kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$txnConfig = new TransactionConfig(TransactionStateManager$.MODULE$.DefaultTransactionalIdExpirationMs(), TransactionStateManager$.MODULE$.DefaultTransactionsMaxTimeoutMs(), TransactionLog$.MODULE$.DefaultNumPartitions(), TransactionLog$.MODULE$.DefaultReplicationFactor(), TransactionLog$.MODULE$.DefaultSegmentBytes(), TransactionLog$.MODULE$.DefaultLoadBufferSize(), TransactionLog$.MODULE$.DefaultMinInSyncReplicas(), TransactionStateManager$.MODULE$.DefaultAbortTimedOutTransactionsIntervalMs(), TransactionStateManager$.MODULE$.DefaultRemoveExpiredTransactionalIdsIntervalMs(), Defaults$.MODULE$.RequestTimeoutMs());
    private TransactionCoordinator kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$transactionCoordinator;
    private TransactionStateManager kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$txnStateManager;
    private TransactionMarkerChannelManager txnMarkerChannelManager;
    private final scala.collection.immutable.Seq<TxnOperation<? extends Object>> allOperations;
    private final scala.collection.mutable.Set<Transaction> kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$allTransactions;
    private final Map<Object, ArrayBuffer<SimpleRecord>> txnRecordsByPartition;
    private final long producerId;
    private boolean bumpProducerId;

    public TransactionCoordinatorConcurrencyTest$InitProducerIdOperation$ InitProducerIdOperation() {
        if (this.InitProducerIdOperation$module == null) {
            this.InitProducerIdOperation$lzycompute$1();
        }
        return this.InitProducerIdOperation$module;
    }

    private int nTransactions() {
        return this.nTransactions;
    }

    public int kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$coordinatorEpoch() {
        return this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$coordinatorEpoch;
    }

    public int kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$numPartitions() {
        return this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$numPartitions;
    }

    public TransactionConfig kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$txnConfig() {
        return this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$txnConfig;
    }

    public TransactionCoordinator kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$transactionCoordinator() {
        return this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$transactionCoordinator;
    }

    private void transactionCoordinator_$eq(TransactionCoordinator x$1) {
        this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$transactionCoordinator = x$1;
    }

    public TransactionStateManager kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$txnStateManager() {
        return this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$txnStateManager;
    }

    private void txnStateManager_$eq(TransactionStateManager x$1) {
        this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$txnStateManager = x$1;
    }

    private TransactionMarkerChannelManager txnMarkerChannelManager() {
        return this.txnMarkerChannelManager;
    }

    private void txnMarkerChannelManager_$eq(TransactionMarkerChannelManager x$1) {
        this.txnMarkerChannelManager = x$1;
    }

    private scala.collection.immutable.Seq<TxnOperation<? extends Object>> allOperations() {
        return this.allOperations;
    }

    public scala.collection.mutable.Set<Transaction> kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$allTransactions() {
        return this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$allTransactions;
    }

    private Map<Object, ArrayBuffer<SimpleRecord>> txnRecordsByPartition() {
        return this.txnRecordsByPartition;
    }

    public long producerId() {
        return this.producerId;
    }

    private boolean bumpProducerId() {
        return this.bumpProducerId;
    }

    private void bumpProducerId_$eq(boolean x$1) {
        this.bumpProducerId = x$1;
    }

    @Override
    @BeforeEach
    public void setUp() {
        super.setUp();
        Mockito.when((Object)this.zkClient().getTopicPartitionCount("__transaction_state")).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$numPartitions())));
        this.txnStateManager_$eq(new TransactionStateManager(0, (Scheduler)this.scheduler(), (ReplicaManager)this.replicaManager(), this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$txnConfig(), (Time)this.time(), new Metrics()));
        this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$txnStateManager().startup((Function0)(JFunction0.mcI.sp & Serializable)() -> BoxesRunTime.unboxToInt((Object)this.zkClient().getTopicPartitionCount("__transaction_state").get()), true);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$numPartitions()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$txnStateManager().addLoadedTransactionsToCache(i, this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$coordinatorEpoch(), new Pool((Option)None$.MODULE$)));
        ProducerIdManager pidGenerator = (ProducerIdManager)Mockito.mock(ProducerIdManager.class);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)pidGenerator.generateProducerId())).thenAnswer(x$4 -> {
            if (this.bumpProducerId()) {
                return BoxesRunTime.boxToLong((long)(this.producerId() + 1L));
            }
            return BoxesRunTime.boxToLong((long)this.producerId());
        });
        Node brokerNode = new Node(0, "host", 10);
        MetadataCache metadataCache = (MetadataCache)Mockito.mock(MetadataCache.class);
        Mockito.when((Object)metadataCache.getPartitionLeaderEndpoint(ArgumentMatchers.anyString(), ArgumentMatchers.anyInt(), (ListenerName)ArgumentMatchers.any())).thenReturn((Object)new Some((Object)brokerNode));
        NetworkClient networkClient = (NetworkClient)Mockito.mock(NetworkClient.class);
        this.txnMarkerChannelManager_$eq(new TransactionMarkerChannelManager(KafkaConfig$.MODULE$.fromProps(this.serverProps()), metadataCache, networkClient, this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$txnStateManager(), (Time)this.time()));
        this.transactionCoordinator_$eq(new TransactionCoordinator(this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$txnConfig(), (Scheduler)this.scheduler(), (Function0 & Serializable)() -> pidGenerator, this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$txnStateManager(), this.txnMarkerChannelManager(), (Time)this.time(), new LogContext()));
    }

    @Override
    @AfterEach
    public void tearDown() {
        try {
            this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$transactionCoordinator().shutdown();
        }
        finally {
            super.tearDown();
        }
    }

    @Test
    public void testConcurrentGoodPathWithConcurrentPartitionLoading() {
        AtomicBoolean keepRunning = new AtomicBoolean(true);
        Thread t = new Thread(this, keepRunning){
            private final /* synthetic */ TransactionCoordinatorConcurrencyTest $outer;
            private final AtomicBoolean keepRunning$1;

            public void run() {
                while (this.keepRunning$1.get()) {
                    this.$outer.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$txnStateManager().addLoadingPartition(this.$outer.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$numPartitions() + 1, this.$outer.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$coordinatorEpoch());
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.keepRunning$1 = keepRunning$1;
            }
        };
        t.start();
        this.verifyConcurrentOperations((Function1 & Serializable)txnPrefix -> this.createTransactions((String)txnPrefix), (Seq<AbstractCoordinatorConcurrencyTest.Operation>)this.allOperations());
        keepRunning.set(false);
        t.join();
    }

    @Test
    public void testConcurrentGoodPathSequence() {
        this.verifyConcurrentOperations((Function1 & Serializable)txnPrefix -> this.createTransactions((String)txnPrefix), (Seq<AbstractCoordinatorConcurrencyTest.Operation>)this.allOperations());
    }

    @Test
    public void testConcurrentRandomSequences() {
        this.verifyConcurrentRandomSequences((Function1 & Serializable)txnPrefix -> this.createTransactions((String)txnPrefix), (Seq<AbstractCoordinatorConcurrencyTest.Operation>)this.allOperations());
    }

    @Test
    public void testConcurrentLoadUnloadPartitions() {
        scala.collection.immutable.Set partitionsToLoad = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$numPartitions() / 2).toSet();
        scala.collection.immutable.Set partitionsToUnload = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$numPartitions() / 2), this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$numPartitions()).toSet();
        this.verifyConcurrentActions((Set<AbstractCoordinatorConcurrencyTest.Action>)this.loadUnloadActions((scala.collection.immutable.Set<Object>)partitionsToLoad, (scala.collection.immutable.Set<Object>)partitionsToUnload));
    }

    @Test
    public void testConcurrentTransactionExpiration() {
        scala.collection.immutable.Set partitionsToLoad = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$numPartitions() / 3).toSet();
        scala.collection.immutable.Set partitionsToUnload = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$numPartitions() / 3), this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$numPartitions() * 2 / 3).toSet();
        scala.collection.immutable.Set partitionsWithExpiringTxn = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$numPartitions() * 2 / 3), this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$numPartitions()).toSet();
        scala.collection.immutable.Set expiringTransactions = ((IterableOnceOps)this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$allTransactions().filter((Function1 & Serializable)txn -> BoxesRunTime.boxToBoolean((boolean)partitionsWithExpiringTxn.contains((Object)BoxesRunTime.boxToInteger((int)this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$txnStateManager().partitionFor(txn.transactionalId())))))).toSet();
        ExpireTransactionsAction expireAction = new ExpireTransactionsAction(this, (scala.collection.immutable.Set<Transaction>)expiringTransactions);
        this.verifyConcurrentActions((Set<AbstractCoordinatorConcurrencyTest.Action>)((Set)this.loadUnloadActions((scala.collection.immutable.Set<Object>)partitionsToLoad, (scala.collection.immutable.Set<Object>)partitionsToUnload).$plus((Object)expireAction)));
    }

    @Test
    public void testConcurrentNewInitProducerIdRequests() {
        IndexedSeq transactions = (IndexedSeq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 100).flatMap((Function1 & Serializable)i -> this.createTransactions(new StringBuilder(29).append("testConcurrentInitProducerID").append(BoxesRunTime.unboxToInt((Object)i)).append("-").toString()));
        this.bumpProducerId_$eq(true);
        transactions.foreach((Function1 & Serializable)txn -> {
            TransactionCoordinatorConcurrencyTest.$anonfun$testConcurrentNewInitProducerIdRequests$2(this, txn);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testConcurrentInitProducerIdRequestsOneNewOneContinuing() {
        ((IndexedSeq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 10).flatMap((Function1 & Serializable)i -> this.createTransactions(new StringBuilder(29).append("testConcurrentInitProducerID").append(BoxesRunTime.unboxToInt((Object)i)).append("-").toString()))).foreach((Function1 & Serializable)txn -> {
            TransactionCoordinatorConcurrencyTest.$anonfun$testConcurrentInitProducerIdRequestsOneNewOneContinuing$2(this, txn);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testConcurrentContinuingInitProducerIdRequests() {
        ((IndexedSeq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 100).flatMap((Function1 & Serializable)i -> this.createTransactions(new StringBuilder(29).append("testConcurrentInitProducerID").append(BoxesRunTime.unboxToInt((Object)i)).append("-").toString()))).foreach((Function1 & Serializable)txn -> {
            TransactionCoordinatorConcurrencyTest.$anonfun$testConcurrentContinuingInitProducerIdRequests$2(this, txn);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testConcurrentInitProducerIdRequestsWithRetry() {
        ((IndexedSeq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 10).flatMap((Function1 & Serializable)i -> this.createTransactions(new StringBuilder(29).append("testConcurrentInitProducerID").append(BoxesRunTime.unboxToInt((Object)i)).append("-").toString()))).foreach((Function1 & Serializable)txn -> {
            TransactionCoordinatorConcurrencyTest.$anonfun$testConcurrentInitProducerIdRequestsWithRetry$2(this, txn);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testConcurrentInitProducerRequestsAtPidBoundary() {
        IndexedSeq transactions = (IndexedSeq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 10).flatMap((Function1 & Serializable)i -> this.createTransactions(new StringBuilder(29).append("testConcurrentInitProducerID").append(BoxesRunTime.unboxToInt((Object)i)).append("-").toString()));
        this.bumpProducerId_$eq(true);
        transactions.foreach((Function1 & Serializable)txn -> {
            TransactionCoordinatorConcurrencyTest.$anonfun$testConcurrentInitProducerRequestsAtPidBoundary$2(this, txn);
            return BoxedUnit.UNIT;
        });
        this.bumpProducerId_$eq(false);
    }

    @Test
    public void testConcurrentInitProducerRequestsWithRetryAtPidBoundary() {
        IndexedSeq transactions = (IndexedSeq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 10).flatMap((Function1 & Serializable)i -> this.createTransactions(new StringBuilder(29).append("testConcurrentInitProducerID").append(BoxesRunTime.unboxToInt((Object)i)).append("-").toString()));
        this.bumpProducerId_$eq(true);
        transactions.foreach((Function1 & Serializable)txn -> {
            TransactionCoordinatorConcurrencyTest.$anonfun$testConcurrentInitProducerRequestsWithRetryAtPidBoundary$2(this, txn);
            return BoxedUnit.UNIT;
        });
        this.bumpProducerId_$eq(false);
    }

    @Override
    public void enableCompletion() {
        super.enableCompletion();
        synchronized (this) {
            this.txnMarkerChannelManager().generateRequests().foreach((Function1 & Serializable)requestAndHandler -> {
                TransactionCoordinatorConcurrencyTest.$anonfun$enableCompletion$3(requestAndHandler);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    private scala.collection.immutable.Set<AbstractCoordinatorConcurrencyTest.Action> loadUnloadActions(scala.collection.immutable.Set<Object> partitionsToLoad, scala.collection.immutable.Set<Object> partitionsToUnload) {
        ((IterableOnceOps)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 10).flatMap((Function1 & Serializable)i -> this.createTransactions(new StringBuilder(35).append("testConcurrentLoadUnloadPartitions").append(BoxesRunTime.unboxToInt((Object)i)).append("-").toString()))).toSet().foreach((Function1 & Serializable)txn -> {
            this.prepareTransaction(txn);
            return BoxedUnit.UNIT;
        });
        scala.collection.immutable.Set unload = (scala.collection.immutable.Set)partitionsToLoad.map((Function1 & Serializable)x$11 -> TransactionCoordinatorConcurrencyTest.$anonfun$loadUnloadActions$3(this, BoxesRunTime.unboxToInt((Object)x$11)));
        unload.foreach((Function1 & Serializable)x$12 -> {
            x$12.run();
            return BoxedUnit.UNIT;
        });
        unload.foreach((Function1 & Serializable)x$13 -> {
            x$13.await();
            return BoxedUnit.UNIT;
        });
        return (scala.collection.immutable.Set)((IterableOps)partitionsToLoad.map((Function1 & Serializable)x$14 -> TransactionCoordinatorConcurrencyTest.$anonfun$loadUnloadActions$6(this, BoxesRunTime.unboxToInt((Object)x$14)))).$plus$plus((IterableOnce)partitionsToUnload.map((Function1 & Serializable)x$15 -> TransactionCoordinatorConcurrencyTest.$anonfun$loadUnloadActions$7(this, BoxesRunTime.unboxToInt((Object)x$15))));
    }

    private scala.collection.immutable.Set<Transaction> createTransactions(String txnPrefix) {
        IndexedSeq transactions = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.nTransactions()).map((Function1 & Serializable)i -> TransactionCoordinatorConcurrencyTest.$anonfun$createTransactions$1(this, txnPrefix, BoxesRunTime.unboxToInt((Object)i)));
        this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$allTransactions().$plus$plus$eq((IterableOnce)transactions);
        return transactions.toSet();
    }

    /*
     * WARNING - void declaration
     */
    public void kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$verifyTransaction(Transaction txn, TransactionState expectedState) {
        void var4_8;
        Tuple2 tuple2;
        long l = 100L;
        long computeUntilTrue_waitTime = 15000L;
        long computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void computeUntilTrue_pause;
            Option computeUntilTrue_result;
            if (TransactionCoordinatorConcurrencyTest.$anonfun$verifyTransaction$2(expectedState, computeUntilTrue_result = TransactionCoordinatorConcurrencyTest.$anonfun$verifyTransaction$1(this, txn))) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime + computeUntilTrue_waitTime) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(computeUntilTrue_waitTime), (long)computeUntilTrue_pause));
        }
        Object var11_6 = null;
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        Option metadata = (Option)tuple22._1();
        Assertions.assertTrue((boolean)tuple22._2$mcZ$sp(), (String)new StringBuilder(23).append("Invalid metadata state ").append(var4_8).toString());
    }

    public Option<TransactionMetadata> kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$transactionMetadata(Transaction txn) {
        Option option;
        boolean bl = false;
        Right right = null;
        Either either = this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$txnStateManager().getTransactionState(txn.transactionalId());
        if (either instanceof Left) {
            Errors error;
            Errors errors = error = (Errors)((Left)either).value();
            Errors errors2 = Errors.NOT_COORDINATOR;
            if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
                return None$.MODULE$;
            }
            throw new AssertionError((Object)new StringBuilder(34).append("Unexpected transaction error ").append(error).append(" for ").append(txn).toString());
        }
        if (either instanceof Right) {
            bl = true;
            right = (Right)either;
            Option option2 = (Option)right.value();
            if (option2 instanceof Some) {
                CoordinatorEpochAndTxnMetadata metadata = (CoordinatorEpochAndTxnMetadata)((Some)option2).value();
                return new Some((Object)metadata.transactionMetadata());
            }
        }
        if (bl && None$.MODULE$.equals(option = (Option)right.value())) {
            return None$.MODULE$;
        }
        throw new MatchError((Object)either);
    }

    private void prepareTransaction(Transaction txn) {
        int partitionId = this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$txnStateManager().partitionFor(txn.transactionalId());
        ArrayBuffer txnRecords = (ArrayBuffer)this.txnRecordsByPartition().apply((Object)BoxesRunTime.boxToInteger((int)partitionId));
        if (this.InitProducerIdOperation() == null) {
            throw null;
        }
        InitProducerIdOperation initPidOp = new InitProducerIdOperation(this, (Option<ProducerIdAndEpoch>)None$.MODULE$);
        AddPartitionsToTxnOperation addPartitionsOp = new AddPartitionsToTxnOperation(this, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic", 0)}))));
        initPidOp.run(txn);
        initPidOp.awaitAndVerify(txn);
        addPartitionsOp.run(txn);
        addPartitionsOp.awaitAndVerify(txn);
        TransactionMetadata txnMetadata = (TransactionMetadata)this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$transactionMetadata(txn).getOrElse((Function0 & Serializable)() -> {
            throw new IllegalStateException(new StringBuilder(22).append("Transaction not found ").append(txn).toString());
        });
        txnRecords.$plus$eq((Object)new SimpleRecord(txn.txnMessageKeyBytes(), TransactionLog$.MODULE$.valueToBytes(txnMetadata.prepareNoTransit())));
        txnMetadata.state_$eq((TransactionState)PrepareCommit$.MODULE$);
        txnRecords.$plus$eq((Object)new SimpleRecord(txn.txnMessageKeyBytes(), TransactionLog$.MODULE$.valueToBytes(txnMetadata.prepareNoTransit())));
        this.prepareTxnLog(partitionId);
    }

    /*
     * WARNING - void declaration
     */
    private void prepareTxnLog(int partitionId) {
        void withRecords_records;
        UnifiedLog logMock = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        Mockito.when((Object)logMock.config()).thenReturn((Object)new LogConfig(Collections.emptyMap(), LogConfig$.MODULE$.$lessinit$greater$default$2()));
        FileRecords fileRecordsMock = (FileRecords)Mockito.mock(FileRecords.class);
        TopicPartition topicPartition = new TopicPartition("__transaction_state", partitionId);
        long startOffset = BoxesRunTime.unboxToLong((Object)this.replicaManager().getLogEndOffset(topicPartition).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 20L));
        SimpleRecord[] simpleRecordArray = (SimpleRecord[])((IterableOnceOps)this.txnRecordsByPartition().apply((Object)BoxesRunTime.boxToInteger((int)partitionId))).toArray(ClassTag$.MODULE$.apply(SimpleRecord.class));
        CompressionType withRecords_compressionType = CompressionType.NONE;
        TimestampType withRecords_timestampType = TimestampType.CREATE_TIME;
        Object var13_8 = null;
        Object var11_7 = null;
        simpleRecordArray = null;
        MemoryRecords records = MemoryRecords.withRecords((byte)2, (long)startOffset, (CompressionType)withRecords_compressionType, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records);
        long endOffset = startOffset + (long)CollectionConverters$.MODULE$.IterableHasAsScala(records.records()).asScala().size();
        Mockito.when((Object)BoxesRunTime.boxToLong((long)logMock.logStartOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)startOffset));
        Mockito.when((Object)logMock.read(ArgumentMatchers.eq((long)startOffset), ArgumentMatchers.anyInt(), (FetchIsolation)ArgumentMatchers.eq((Object)FetchLogEnd$.MODULE$), ArgumentMatchers.eq((boolean)true))).thenReturn((Object)new FetchDataInfo(new LogOffsetMetadata(startOffset, UnifiedLog$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition()), (Records)fileRecordsMock, false, (Option)None$.MODULE$));
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)fileRecordsMock.sizeInBytes())).thenReturn((Object)BoxesRunTime.boxToInteger((int)records.sizeInBytes()));
        ArgumentCaptor bufferCaptor = ArgumentCaptor.forClass(ByteBuffer.class);
        fileRecordsMock.readInto((ByteBuffer)bufferCaptor.capture(), ArgumentMatchers.anyInt());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(x$17 -> {
            ByteBuffer buffer = (ByteBuffer)bufferCaptor.getValue();
            buffer.put(records.buffer().duplicate());
            return buffer.flip();
        });
        synchronized (this) {
            this.replicaManager().updateLog(topicPartition, logMock, endOffset);
            return;
        }
    }

    private TransactionMetadata prepareExhaustedEpochTxnMetadata(Transaction txn) {
        String x$1 = txn.transactionalId();
        long x$2 = this.producerId();
        short x$4 = (short)32766;
        Empty$ x$7 = Empty$.MODULE$;
        scala.collection.mutable.Set x$8 = (scala.collection.mutable.Set)Set$.MODULE$.empty();
        long x$9 = this.time().milliseconds();
        long x$10 = -1L;
        return new TransactionMetadata(x$1, x$2, -1L, x$4, -1, 60000, (TransactionState)x$7, x$8, x$10, x$9);
    }

    private final void InitProducerIdOperation$lzycompute$1() {
        synchronized (this) {
            if (this.InitProducerIdOperation$module == null) {
                this.InitProducerIdOperation$module = new TransactionCoordinatorConcurrencyTest$InitProducerIdOperation$(this);
            }
            return;
        }
    }

    public static final /* synthetic */ Tuple2 $anonfun$txnRecordsByPartition$1(int i) {
        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)i), ArrayBuffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$));
    }

    public static final /* synthetic */ void $anonfun$testConcurrentNewInitProducerIdRequests$2(TransactionCoordinatorConcurrencyTest $this, Transaction txn) {
        TransactionMetadata txnMetadata = $this.prepareExhaustedEpochTxnMetadata(txn);
        $this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$txnStateManager().putTransactionStateIfNotExists(txnMetadata);
        if ($this.InitProducerIdOperation() == null) {
            throw null;
        }
        InitProducerIdOperation newProducerOp1 = new InitProducerIdOperation($this, (Option<ProducerIdAndEpoch>)None$.MODULE$);
        if ($this.InitProducerIdOperation() == null) {
            throw null;
        }
        InitProducerIdOperation newProducerOp2 = new InitProducerIdOperation($this, (Option<ProducerIdAndEpoch>)None$.MODULE$);
        $this.verifyConcurrentActions((Set<AbstractCoordinatorConcurrencyTest.Action>)((Set)((IterableOps)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new InitProducerIdOperation[]{newProducerOp1, newProducerOp2}))).map((Function1 & Serializable)x$5 -> x$5.actionNoVerify(txn))));
        Errors errors = ((InitProducerIdResult)newProducerOp2.result().get()).error();
        Errors errors2 = ((InitProducerIdResult)newProducerOp1.result().get()).error();
        if (Errors.NONE.equals(errors2) && Errors.NONE.equals(errors)) {
            Assertions.assertNotEquals((short)((InitProducerIdResult)newProducerOp1.result().get()).producerEpoch(), (short)((InitProducerIdResult)newProducerOp2.result().get()).producerEpoch());
            return;
        }
        if (Errors.NONE.equals(errors2)) {
            Assertions.assertEquals((int)0, (int)((InitProducerIdResult)newProducerOp1.result().get()).producerEpoch());
            return;
        }
        if (Errors.NONE.equals(errors)) {
            Assertions.assertEquals((int)0, (int)((InitProducerIdResult)newProducerOp2.result().get()).producerEpoch());
            return;
        }
        BoxedUnit cfr_ignored_0 = (BoxedUnit)Assertions.fail((String)"One of two InitProducerId requests should succeed");
    }

    public static final /* synthetic */ void $anonfun$testConcurrentInitProducerIdRequestsOneNewOneContinuing$2(TransactionCoordinatorConcurrencyTest $this, Transaction txn) {
        if ($this.InitProducerIdOperation() == null) {
            throw null;
        }
        InitProducerIdOperation firstInitReq = new InitProducerIdOperation($this, (Option<ProducerIdAndEpoch>)None$.MODULE$);
        firstInitReq.run(txn);
        firstInitReq.awaitAndVerify(txn);
        ProducerIdAndEpoch producerIdAndEpoch = new ProducerIdAndEpoch(((InitProducerIdResult)firstInitReq.result().get()).producerId(), ((InitProducerIdResult)firstInitReq.result().get()).producerEpoch());
        InitProducerIdOperation bumpEpochOp = new InitProducerIdOperation($this, (Option<ProducerIdAndEpoch>)new Some((Object)producerIdAndEpoch));
        if ($this.InitProducerIdOperation() == null) {
            throw null;
        }
        InitProducerIdOperation newProducerOp = new InitProducerIdOperation($this, (Option<ProducerIdAndEpoch>)None$.MODULE$);
        $this.verifyConcurrentActions((Set<AbstractCoordinatorConcurrencyTest.Action>)((Set)((IterableOps)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new InitProducerIdOperation[]{bumpEpochOp, newProducerOp}))).map((Function1 & Serializable)x$6 -> x$6.actionNoVerify(txn))));
        Errors errors = ((InitProducerIdResult)newProducerOp.result().get()).error();
        Errors errors2 = ((InitProducerIdResult)bumpEpochOp.result().get()).error();
        if (Errors.NONE.equals(errors2) && Errors.NONE.equals(errors)) {
            Assertions.assertEquals((int)(producerIdAndEpoch.epoch + 2), (int)((InitProducerIdResult)newProducerOp.result().get()).producerEpoch());
            Assertions.assertEquals((int)(producerIdAndEpoch.epoch + 1), (int)((InitProducerIdResult)bumpEpochOp.result().get()).producerEpoch());
            return;
        }
        if (Errors.NONE.equals(errors2)) {
            Assertions.assertEquals((int)(producerIdAndEpoch.epoch + 1), (int)((InitProducerIdResult)bumpEpochOp.result().get()).producerEpoch());
            return;
        }
        if (Errors.NONE.equals(errors)) {
            Assertions.assertEquals((int)(producerIdAndEpoch.epoch + 1), (int)((InitProducerIdResult)newProducerOp.result().get()).producerEpoch());
            return;
        }
        BoxedUnit cfr_ignored_0 = (BoxedUnit)Assertions.fail((String)"One of two InitProducerId requests should succeed");
    }

    public static final /* synthetic */ void $anonfun$testConcurrentContinuingInitProducerIdRequests$2(TransactionCoordinatorConcurrencyTest $this, Transaction txn) {
        ProducerIdAndEpoch producerIdAndEpoch = new ProducerIdAndEpoch($this.producerId(), 10);
        InitProducerIdOperation bumpEpochOp1 = new InitProducerIdOperation($this, (Option<ProducerIdAndEpoch>)new Some((Object)producerIdAndEpoch));
        InitProducerIdOperation bumpEpochOp2 = new InitProducerIdOperation($this, (Option<ProducerIdAndEpoch>)new Some((Object)producerIdAndEpoch));
        $this.verifyConcurrentActions((Set<AbstractCoordinatorConcurrencyTest.Action>)((Set)((IterableOps)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new InitProducerIdOperation[]{bumpEpochOp1, bumpEpochOp2}))).map((Function1 & Serializable)x$7 -> x$7.actionNoVerify(txn))));
        Errors errors = ((InitProducerIdResult)bumpEpochOp2.result().get()).error();
        Errors errors2 = ((InitProducerIdResult)bumpEpochOp1.result().get()).error();
        if (Errors.NONE.equals(errors2) && Errors.NONE.equals(errors)) {
            BoxedUnit cfr_ignored_0 = (BoxedUnit)Assertions.fail((String)"One of two InitProducerId requests should fail due to concurrent requests or non-matching epochs");
            return;
        }
        if (Errors.NONE.equals(errors2)) {
            Assertions.assertEquals((int)0, (int)((InitProducerIdResult)bumpEpochOp1.result().get()).producerEpoch());
            return;
        }
        if (Errors.NONE.equals(errors)) {
            Assertions.assertEquals((int)0, (int)((InitProducerIdResult)bumpEpochOp2.result().get()).producerEpoch());
            return;
        }
        BoxedUnit cfr_ignored_1 = (BoxedUnit)Assertions.fail((String)"One of two InitProducerId requests should succeed");
    }

    public static final /* synthetic */ void $anonfun$testConcurrentInitProducerIdRequestsWithRetry$2(TransactionCoordinatorConcurrencyTest $this, Transaction txn) {
        if ($this.InitProducerIdOperation() == null) {
            throw null;
        }
        InitProducerIdOperation firstInitReq = new InitProducerIdOperation($this, (Option<ProducerIdAndEpoch>)None$.MODULE$);
        firstInitReq.run(txn);
        firstInitReq.awaitAndVerify(txn);
        ProducerIdAndEpoch initialProducerIdAndEpoch = new ProducerIdAndEpoch(((InitProducerIdResult)firstInitReq.result().get()).producerId(), ((InitProducerIdResult)firstInitReq.result().get()).producerEpoch());
        InitProducerIdOperation bumpEpochReq = new InitProducerIdOperation($this, (Option<ProducerIdAndEpoch>)new Some((Object)initialProducerIdAndEpoch));
        bumpEpochReq.run(txn);
        bumpEpochReq.awaitAndVerify(txn);
        ProducerIdAndEpoch bumpedProducerIdAndEpoch = new ProducerIdAndEpoch(((InitProducerIdResult)bumpEpochReq.result().get()).producerId(), ((InitProducerIdResult)bumpEpochReq.result().get()).producerEpoch());
        InitProducerIdOperation retryBumpEpochOp = new InitProducerIdOperation($this, (Option<ProducerIdAndEpoch>)new Some((Object)initialProducerIdAndEpoch));
        if ($this.InitProducerIdOperation() == null) {
            throw null;
        }
        InitProducerIdOperation newProducerOp = new InitProducerIdOperation($this, (Option<ProducerIdAndEpoch>)None$.MODULE$);
        $this.verifyConcurrentActions((Set<AbstractCoordinatorConcurrencyTest.Action>)((Set)((IterableOps)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new InitProducerIdOperation[]{retryBumpEpochOp, newProducerOp}))).map((Function1 & Serializable)x$8 -> x$8.actionNoVerify(txn))));
        Errors errors = ((InitProducerIdResult)newProducerOp.result().get()).error();
        Errors errors2 = ((InitProducerIdResult)retryBumpEpochOp.result().get()).error();
        if (Errors.NONE.equals(errors2) && Errors.NONE.equals(errors)) {
            Assertions.assertEquals((int)(bumpedProducerIdAndEpoch.epoch + 1), (int)((InitProducerIdResult)newProducerOp.result().get()).producerEpoch());
            Assertions.assertEquals((short)bumpedProducerIdAndEpoch.epoch, (short)((InitProducerIdResult)retryBumpEpochOp.result().get()).producerEpoch());
            return;
        }
        if (Errors.NONE.equals(errors2)) {
            Assertions.assertEquals((short)bumpedProducerIdAndEpoch.epoch, (short)((InitProducerIdResult)retryBumpEpochOp.result().get()).producerEpoch());
            return;
        }
        if (Errors.NONE.equals(errors)) {
            Assertions.assertEquals((int)(bumpedProducerIdAndEpoch.epoch + 1), (int)((InitProducerIdResult)newProducerOp.result().get()).producerEpoch());
            return;
        }
        BoxedUnit cfr_ignored_0 = (BoxedUnit)Assertions.fail((String)"At least one InitProducerId request should succeed");
    }

    public static final /* synthetic */ void $anonfun$testConcurrentInitProducerRequestsAtPidBoundary$2(TransactionCoordinatorConcurrencyTest $this, Transaction txn) {
        TransactionMetadata txnMetadata = $this.prepareExhaustedEpochTxnMetadata(txn);
        $this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$txnStateManager().putTransactionStateIfNotExists(txnMetadata);
        InitProducerIdOperation bumpEpochOp = new InitProducerIdOperation($this, (Option<ProducerIdAndEpoch>)new Some((Object)new ProducerIdAndEpoch($this.producerId(), (short)32766)));
        if ($this.InitProducerIdOperation() == null) {
            throw null;
        }
        InitProducerIdOperation newProducerOp = new InitProducerIdOperation($this, (Option<ProducerIdAndEpoch>)None$.MODULE$);
        $this.verifyConcurrentActions((Set<AbstractCoordinatorConcurrencyTest.Action>)((Set)((IterableOps)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new InitProducerIdOperation[]{bumpEpochOp, newProducerOp}))).map((Function1 & Serializable)x$9 -> x$9.actionNoVerify(txn))));
        Errors errors = ((InitProducerIdResult)newProducerOp.result().get()).error();
        Errors errors2 = ((InitProducerIdResult)bumpEpochOp.result().get()).error();
        if (Errors.NONE.equals(errors2) && Errors.NONE.equals(errors)) {
            Assertions.assertEquals((int)0, (int)((InitProducerIdResult)bumpEpochOp.result().get()).producerEpoch());
            Assertions.assertEquals((long)($this.producerId() + 1L), (long)((InitProducerIdResult)bumpEpochOp.result().get()).producerId());
            Assertions.assertEquals((int)1, (int)((InitProducerIdResult)newProducerOp.result().get()).producerEpoch());
            Assertions.assertEquals((long)($this.producerId() + 1L), (long)((InitProducerIdResult)newProducerOp.result().get()).producerId());
            return;
        }
        if (Errors.NONE.equals(errors2)) {
            Assertions.assertEquals((int)0, (int)((InitProducerIdResult)bumpEpochOp.result().get()).producerEpoch());
            Assertions.assertEquals((long)($this.producerId() + 1L), (long)((InitProducerIdResult)bumpEpochOp.result().get()).producerId());
            return;
        }
        if (Errors.NONE.equals(errors)) {
            Assertions.assertEquals((int)0, (int)((InitProducerIdResult)newProducerOp.result().get()).producerEpoch());
            Assertions.assertEquals((long)($this.producerId() + 1L), (long)((InitProducerIdResult)newProducerOp.result().get()).producerId());
            return;
        }
        BoxedUnit cfr_ignored_0 = (BoxedUnit)Assertions.fail((String)"One of two InitProducerId requests should succeed");
    }

    public static final /* synthetic */ void $anonfun$testConcurrentInitProducerRequestsWithRetryAtPidBoundary$2(TransactionCoordinatorConcurrencyTest $this, Transaction txn) {
        TransactionMetadata txnMetadata = $this.prepareExhaustedEpochTxnMetadata(txn);
        $this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$txnStateManager().putTransactionStateIfNotExists(txnMetadata);
        InitProducerIdOperation bumpEpochReq = new InitProducerIdOperation($this, (Option<ProducerIdAndEpoch>)new Some((Object)new ProducerIdAndEpoch($this.producerId(), (short)32766)));
        bumpEpochReq.run(txn);
        bumpEpochReq.awaitAndVerify(txn);
        InitProducerIdOperation retryBumpEpochOp = new InitProducerIdOperation($this, (Option<ProducerIdAndEpoch>)new Some((Object)new ProducerIdAndEpoch($this.producerId(), (short)32766)));
        if ($this.InitProducerIdOperation() == null) {
            throw null;
        }
        InitProducerIdOperation newProducerOp = new InitProducerIdOperation($this, (Option<ProducerIdAndEpoch>)None$.MODULE$);
        $this.verifyConcurrentActions((Set<AbstractCoordinatorConcurrencyTest.Action>)((Set)((IterableOps)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new InitProducerIdOperation[]{retryBumpEpochOp, newProducerOp}))).map((Function1 & Serializable)x$10 -> x$10.actionNoVerify(txn))));
        Errors errors = ((InitProducerIdResult)newProducerOp.result().get()).error();
        Errors errors2 = ((InitProducerIdResult)retryBumpEpochOp.result().get()).error();
        if (Errors.NONE.equals(errors2) && Errors.NONE.equals(errors)) {
            Assertions.assertEquals((int)0, (int)((InitProducerIdResult)retryBumpEpochOp.result().get()).producerEpoch());
            Assertions.assertEquals((long)($this.producerId() + 1L), (long)((InitProducerIdResult)retryBumpEpochOp.result().get()).producerId());
            Assertions.assertEquals((int)1, (int)((InitProducerIdResult)newProducerOp.result().get()).producerEpoch());
            Assertions.assertEquals((long)($this.producerId() + 1L), (long)((InitProducerIdResult)newProducerOp.result().get()).producerId());
            return;
        }
        if (Errors.NONE.equals(errors2)) {
            Assertions.assertEquals((int)0, (int)((InitProducerIdResult)retryBumpEpochOp.result().get()).producerEpoch());
            Assertions.assertEquals((long)($this.producerId() + 1L), (long)((InitProducerIdResult)retryBumpEpochOp.result().get()).producerId());
            return;
        }
        if (Errors.NONE.equals(errors)) {
            Assertions.assertEquals((int)1, (int)((InitProducerIdResult)newProducerOp.result().get()).producerEpoch());
            Assertions.assertEquals((long)($this.producerId() + 1L), (long)((InitProducerIdResult)newProducerOp.result().get()).producerId());
            return;
        }
        BoxedUnit cfr_ignored_0 = (BoxedUnit)Assertions.fail((String)"One of two InitProducerId requests should succeed");
    }

    private static final WriteTxnMarkersResponse createResponse$1(WriteTxnMarkersRequest request) {
        java.util.Map pidErrorMap = CollectionConverters$.MODULE$.MapHasAsJava((Map)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(request.markers()).asScala().map((Function1 & Serializable)marker -> new Tuple2((Object)BoxesRunTime.boxToLong((long)marker.producerId()), (Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(marker.partitions()).asScala().map((Function1 & Serializable)tp -> new Tuple2(tp, (Object)Errors.NONE))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).asJava()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).asJava();
        return new WriteTxnMarkersResponse(pidErrorMap);
    }

    public static final /* synthetic */ void $anonfun$enableCompletion$3(RequestAndCompletionHandler requestAndHandler) {
        WriteTxnMarkersResponse response = TransactionCoordinatorConcurrencyTest.createResponse$1((WriteTxnMarkersRequest)((WriteTxnMarkersRequest.Builder)requestAndHandler.request()).build());
        requestAndHandler.handler().onComplete(new ClientResponse(new RequestHeader(ApiKeys.PRODUCE, 0, "client", 1), null, null, 0L, 0L, false, null, null, (AbstractResponse)response));
    }

    public static final /* synthetic */ UnloadTxnPartitionAction $anonfun$loadUnloadActions$3(TransactionCoordinatorConcurrencyTest $this, int x$11) {
        return new UnloadTxnPartitionAction($this, x$11);
    }

    public static final /* synthetic */ LoadTxnPartitionAction $anonfun$loadUnloadActions$6(TransactionCoordinatorConcurrencyTest $this, int x$14) {
        return new LoadTxnPartitionAction($this, x$14);
    }

    public static final /* synthetic */ UnloadTxnPartitionAction $anonfun$loadUnloadActions$7(TransactionCoordinatorConcurrencyTest $this, int x$15) {
        return new UnloadTxnPartitionAction($this, x$15);
    }

    public static final /* synthetic */ Transaction $anonfun$createTransactions$1(TransactionCoordinatorConcurrencyTest $this, String txnPrefix$1, int i) {
        return new Transaction(new StringBuilder(0).append(txnPrefix$1).append(i).toString(), i, $this.time());
    }

    public static final /* synthetic */ Option $anonfun$verifyTransaction$1(TransactionCoordinatorConcurrencyTest $this, Transaction txn$7) {
        $this.enableCompletion();
        return $this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$transactionMetadata(txn$7);
    }

    public static final /* synthetic */ boolean $anonfun$verifyTransaction$3(TransactionState expectedState$1, TransactionMetadata m) {
        TransactionState transactionState = m.state();
        return !(transactionState != null ? !transactionState.equals(expectedState$1) : expectedState$1 != null) && m.pendingState().isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$verifyTransaction$2(TransactionState expectedState$1, Option metadata) {
        return metadata.nonEmpty() && metadata.forall((Function1 & Serializable)m -> BoxesRunTime.boxToBoolean((boolean)TransactionCoordinatorConcurrencyTest.$anonfun$verifyTransaction$3(expectedState$1, m)));
    }

    public TransactionCoordinatorConcurrencyTest() {
        this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$coordinatorEpoch = 10;
        if (this.InitProducerIdOperation() == null) {
            throw null;
        }
        this.allOperations = new .colon.colon((Object)new InitProducerIdOperation(this, (Option<ProducerIdAndEpoch>)None$.MODULE$), (List)new .colon.colon((Object)new AddPartitionsToTxnOperation(this, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic", 0)})))), (List)new .colon.colon((Object)new EndTxnOperation(this), (List)Nil$.MODULE$)));
        this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$allTransactions = (scala.collection.mutable.Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        this.txnRecordsByPartition = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$numPartitions()).map((Function1 & Serializable)i -> TransactionCoordinatorConcurrencyTest.$anonfun$txnRecordsByPartition$1(BoxesRunTime.unboxToInt((Object)i))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        this.producerId = 11L;
        this.bumpProducerId = false;
    }

    public static final /* synthetic */ Object $anonfun$verifyTransaction$2$adapted(TransactionState expectedState$1, Option metadata) {
        return BoxesRunTime.boxToBoolean((boolean)TransactionCoordinatorConcurrencyTest.$anonfun$verifyTransaction$2(expectedState$1, metadata));
    }

    public class AddPartitionsToTxnOperation
    extends TxnOperation<Errors> {
        private final scala.collection.immutable.Set<TopicPartition> partitions;

        public void run(Transaction txn) {
            this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$AddPartitionsToTxnOperation$$$outer().kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$transactionMetadata(txn).foreach((Function1 & Serializable)txnMetadata -> {
                AddPartitionsToTxnOperation.$anonfun$run$2(this, txn, txnMetadata);
                return BoxedUnit.UNIT;
            });
        }

        public void awaitAndVerify(Transaction txn) {
            Errors error = (Errors)this.result().getOrElse((Function0 & Serializable)() -> {
                throw new IllegalStateException("AddPartitionsToTransaction has not completed");
            });
            Assertions.assertEquals((Object)Errors.NONE, (Object)error);
            this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$AddPartitionsToTxnOperation$$$outer().kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$verifyTransaction(txn, (TransactionState)Ongoing$.MODULE$);
        }

        public /* synthetic */ TransactionCoordinatorConcurrencyTest kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$AddPartitionsToTxnOperation$$$outer() {
            return (TransactionCoordinatorConcurrencyTest)this.$outer;
        }

        public static final /* synthetic */ void $anonfun$run$2(AddPartitionsToTxnOperation $this, Transaction txn$9, TransactionMetadata txnMetadata) {
            $this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$AddPartitionsToTxnOperation$$$outer().kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$transactionCoordinator().handleAddPartitionsToTransaction(txn$9.transactionalId(), txnMetadata.producerId(), txnMetadata.producerEpoch(), $this.partitions, (Function1 & Serializable)r -> {
                $this.resultCallback(r);
                return BoxedUnit.UNIT;
            }, RequestLocal$.MODULE$.withThreadConfinedCaching());
            $this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$AddPartitionsToTxnOperation$$$outer().replicaManager().tryCompleteActions();
        }

        public AddPartitionsToTxnOperation(TransactionCoordinatorConcurrencyTest $outer, scala.collection.immutable.Set<TopicPartition> partitions) {
            this.partitions = partitions;
            super($outer);
        }
    }

    public class EndTxnOperation
    extends TxnOperation<Errors> {
        public void run(Transaction txn) {
            this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$EndTxnOperation$$$outer().kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$transactionMetadata(txn).foreach((Function1 & Serializable)txnMetadata -> {
                EndTxnOperation.$anonfun$run$4(this, txn, txnMetadata);
                return BoxedUnit.UNIT;
            });
        }

        public void awaitAndVerify(Transaction txn) {
            Errors error = (Errors)this.result().getOrElse((Function0 & Serializable)() -> {
                throw new IllegalStateException("EndTransaction has not completed");
            });
            if (!txn.ended()) {
                txn.ended_$eq(true);
                Assertions.assertEquals((Object)Errors.NONE, (Object)error);
                TransactionResult transactionResult = this.transactionResult(txn);
                TransactionResult transactionResult2 = TransactionResult.COMMIT;
                CompleteCommit$ expectedState = !(transactionResult != null ? !transactionResult.equals(transactionResult2) : transactionResult2 != null) ? CompleteCommit$.MODULE$ : CompleteAbort$.MODULE$;
                this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$EndTxnOperation$$$outer().kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$verifyTransaction(txn, (TransactionState)expectedState);
                return;
            }
            Assertions.assertEquals((Object)Errors.INVALID_TXN_STATE, (Object)error);
        }

        private TransactionResult transactionResult(Transaction txn) {
            String txnId = txn.transactionalId();
            if (StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(txnId), txnId.length() - 1) % 2 == 0) {
                return TransactionResult.COMMIT;
            }
            return TransactionResult.ABORT;
        }

        public /* synthetic */ TransactionCoordinatorConcurrencyTest kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$EndTxnOperation$$$outer() {
            return (TransactionCoordinatorConcurrencyTest)this.$outer;
        }

        public static final /* synthetic */ void $anonfun$run$4(EndTxnOperation $this, Transaction txn$10, TransactionMetadata txnMetadata) {
            $this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$EndTxnOperation$$$outer().kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$transactionCoordinator().handleEndTransaction(txn$10.transactionalId(), txnMetadata.producerId(), txnMetadata.producerEpoch(), $this.transactionResult(txn$10), (Function1 & Serializable)r -> {
                $this.resultCallback(r);
                return BoxedUnit.UNIT;
            }, RequestLocal$.MODULE$.withThreadConfinedCaching());
        }

        public EndTxnOperation(TransactionCoordinatorConcurrencyTest $outer) {
            super($outer);
        }
    }

    public class ExpireTransactionsAction
    implements AbstractCoordinatorConcurrencyTest.Action {
        private final scala.collection.immutable.Set<Transaction> transactions;
        public final /* synthetic */ TransactionCoordinatorConcurrencyTest $outer;

        @Override
        public void run() {
            this.transactions.foreach((Function1 & Serializable)txn -> {
                ExpireTransactionsAction.$anonfun$run$6(this, txn);
                return BoxedUnit.UNIT;
            });
            this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$ExpireTransactionsAction$$$outer().kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$txnStateManager().enableTransactionalIdExpiration();
            this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$ExpireTransactionsAction$$$outer().replicaManager().tryCompleteActions();
            this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$ExpireTransactionsAction$$$outer().time().sleep(this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$ExpireTransactionsAction$$$outer().kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$txnConfig().removeExpiredTransactionalIdsIntervalMs() + 1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void await() {
            void var2_7;
            Tuple2 tuple2;
            long l = 100L;
            long computeUntilTrue_waitTime = 15000L;
            long computeUntilTrue_startTime = System.currentTimeMillis();
            while (true) {
                void computeUntilTrue_pause;
                boolean bl = ExpireTransactionsAction.$anonfun$await$3(this);
                Boolean computeUntilTrue_result = BoxesRunTime.boxToBoolean((boolean)bl);
                if (BoxesRunTime.unboxToBoolean((Object)Predef$.MODULE$.identity((Object)BoxesRunTime.boxToBoolean((boolean)bl)))) {
                    tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                    break;
                }
                if (System.currentTimeMillis() > computeUntilTrue_startTime + computeUntilTrue_waitTime) {
                    tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                    break;
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(computeUntilTrue_waitTime), (long)computeUntilTrue_pause));
            }
            Object var9_4 = null;
            Tuple2 tuple22 = tuple2;
            if (tuple22 == null) {
                throw new MatchError(null);
            }
            boolean success = tuple22._2$mcZ$sp();
            Assertions.assertTrue((boolean)var2_7, (String)"Transaction not expired");
        }

        public /* synthetic */ TransactionCoordinatorConcurrencyTest kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$ExpireTransactionsAction$$$outer() {
            return this.$outer;
        }

        public static final /* synthetic */ void $anonfun$run$6(ExpireTransactionsAction $this, Transaction txn) {
            $this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$ExpireTransactionsAction$$$outer().kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$transactionMetadata(txn).foreach((Function1 & Serializable)txnMetadata -> {
                txnMetadata.txnLastUpdateTimestamp_$eq($this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$ExpireTransactionsAction$$$outer().time().milliseconds() - (long)$this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$ExpireTransactionsAction$$$outer().kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$txnConfig().transactionalIdExpirationMs());
                return BoxedUnit.UNIT;
            });
        }

        public static final /* synthetic */ boolean $anonfun$await$4(ExpireTransactionsAction $this, Transaction txn) {
            return $this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$ExpireTransactionsAction$$$outer().kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$transactionMetadata(txn).isEmpty();
        }

        public static final /* synthetic */ boolean $anonfun$await$3(ExpireTransactionsAction $this) {
            $this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$ExpireTransactionsAction$$$outer().replicaManager().tryCompleteActions();
            return $this.transactions.forall((Function1 & Serializable)txn -> BoxesRunTime.boxToBoolean((boolean)ExpireTransactionsAction.$anonfun$await$4($this, txn)));
        }

        public static final /* synthetic */ boolean $anonfun$await$5(boolean x) {
            return BoxesRunTime.unboxToBoolean((Object)Predef$.MODULE$.identity((Object)BoxesRunTime.boxToBoolean((boolean)x)));
        }

        public ExpireTransactionsAction(TransactionCoordinatorConcurrencyTest $outer, scala.collection.immutable.Set<Transaction> transactions) {
            this.transactions = transactions;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }

        public static final /* synthetic */ Object $anonfun$await$5$adapted(Object x) {
            return BoxesRunTime.boxToBoolean((boolean)ExpireTransactionsAction.$anonfun$await$5(BoxesRunTime.unboxToBoolean((Object)x)));
        }
    }

    public class InitProducerIdOperation
    extends TxnOperation<InitProducerIdResult> {
        private final Option<ProducerIdAndEpoch> producerIdAndEpoch;

        public Option<ProducerIdAndEpoch> producerIdAndEpoch() {
            return this.producerIdAndEpoch;
        }

        public void run(Transaction txn) {
            this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$InitProducerIdOperation$$$outer().kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$transactionCoordinator().handleInitProducerId(txn.transactionalId(), 60000, this.producerIdAndEpoch(), (Function1 & Serializable)r -> {
                this.resultCallback(r);
                return BoxedUnit.UNIT;
            }, RequestLocal$.MODULE$.withThreadConfinedCaching());
            this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$InitProducerIdOperation$$$outer().replicaManager().tryCompleteActions();
        }

        public void awaitAndVerify(Transaction txn) {
            InitProducerIdResult initPidResult = (InitProducerIdResult)this.result().getOrElse((Function0 & Serializable)() -> {
                throw new IllegalStateException("InitProducerId has not completed");
            });
            Assertions.assertEquals((Object)Errors.NONE, (Object)initPidResult.error());
            this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$InitProducerIdOperation$$$outer().kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$verifyTransaction(txn, (TransactionState)Empty$.MODULE$);
        }

        public /* synthetic */ TransactionCoordinatorConcurrencyTest kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$InitProducerIdOperation$$$outer() {
            return (TransactionCoordinatorConcurrencyTest)this.$outer;
        }

        public InitProducerIdOperation(TransactionCoordinatorConcurrencyTest $outer, Option<ProducerIdAndEpoch> producerIdAndEpoch) {
            this.producerIdAndEpoch = producerIdAndEpoch;
            super($outer);
        }
    }

    public class LoadTxnPartitionAction
    implements AbstractCoordinatorConcurrencyTest.Action {
        private final int txnTopicPartitionId;
        public final /* synthetic */ TransactionCoordinatorConcurrencyTest $outer;

        @Override
        public void run() {
            this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$LoadTxnPartitionAction$$$outer().kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$transactionCoordinator().onElection(this.txnTopicPartitionId, this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$LoadTxnPartitionAction$$$outer().kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$coordinatorEpoch());
        }

        @Override
        public void await() {
            this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$LoadTxnPartitionAction$$$outer().kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$allTransactions().foreach((Function1 & Serializable)txn -> {
                LoadTxnPartitionAction.$anonfun$await$1(this, txn);
                return BoxedUnit.UNIT;
            });
        }

        public /* synthetic */ TransactionCoordinatorConcurrencyTest kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$LoadTxnPartitionAction$$$outer() {
            return this.$outer;
        }

        public static final /* synthetic */ void $anonfun$await$1(LoadTxnPartitionAction $this, Transaction txn) {
            if ($this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$LoadTxnPartitionAction$$$outer().kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$txnStateManager().partitionFor(txn.transactionalId()) == $this.txnTopicPartitionId) {
                $this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$LoadTxnPartitionAction$$$outer().kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$verifyTransaction(txn, (TransactionState)CompleteCommit$.MODULE$);
                return;
            }
        }

        public LoadTxnPartitionAction(TransactionCoordinatorConcurrencyTest $outer, int txnTopicPartitionId) {
            this.txnTopicPartitionId = txnTopicPartitionId;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }

    public static class Transaction
    implements AbstractCoordinatorConcurrencyTest.CoordinatorMember {
        private final String transactionalId;
        private final byte[] txnMessageKeyBytes;
        private volatile boolean ended;

        public String transactionalId() {
            return this.transactionalId;
        }

        public byte[] txnMessageKeyBytes() {
            return this.txnMessageKeyBytes;
        }

        public boolean ended() {
            return this.ended;
        }

        public void ended_$eq(boolean x$1) {
            this.ended = x$1;
        }

        public String toString() {
            return this.transactionalId();
        }

        public Transaction(String transactionalId, long producerId, MockTime time) {
            this.transactionalId = transactionalId;
            this.txnMessageKeyBytes = TransactionLog$.MODULE$.keyToBytes(transactionalId);
            this.ended = false;
        }
    }

    public abstract class TxnOperation<R>
    extends AbstractCoordinatorConcurrencyTest.Operation {
        private volatile Option<R> result = None$.MODULE$;

        public Option<R> result() {
            return this.result;
        }

        public void result_$eq(Option<R> x$1) {
            this.result = x$1;
        }

        public void resultCallback(R r) {
            this.result_$eq((Option<R>)new Some(r));
        }

        public /* synthetic */ TransactionCoordinatorConcurrencyTest kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$TxnOperation$$$outer() {
            return (TransactionCoordinatorConcurrencyTest)this.$outer;
        }

        public TxnOperation(TransactionCoordinatorConcurrencyTest $outer) {
            super($outer);
        }
    }

    public class UnloadTxnPartitionAction
    implements AbstractCoordinatorConcurrencyTest.Action {
        private final int txnTopicPartitionId;
        private final ArrayBuffer<SimpleRecord> txnRecords;
        public final /* synthetic */ TransactionCoordinatorConcurrencyTest $outer;

        public ArrayBuffer<SimpleRecord> txnRecords() {
            return this.txnRecords;
        }

        @Override
        public void run() {
            this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$UnloadTxnPartitionAction$$$outer().kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$transactionCoordinator().onResignation(this.txnTopicPartitionId, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$UnloadTxnPartitionAction$$$outer().kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$coordinatorEpoch())));
        }

        @Override
        public void await() {
            this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$UnloadTxnPartitionAction$$$outer().kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$allTransactions().foreach((Function1 & Serializable)txn -> {
                UnloadTxnPartitionAction.$anonfun$await$2(this, txn);
                return BoxedUnit.UNIT;
            });
        }

        public /* synthetic */ TransactionCoordinatorConcurrencyTest kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$UnloadTxnPartitionAction$$$outer() {
            return this.$outer;
        }

        public static final /* synthetic */ void $anonfun$await$2(UnloadTxnPartitionAction $this, Transaction txn) {
            if ($this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$UnloadTxnPartitionAction$$$outer().kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$txnStateManager().partitionFor(txn.transactionalId()) == $this.txnTopicPartitionId) {
                Assertions.assertTrue((boolean)$this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$UnloadTxnPartitionAction$$$outer().kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$transactionMetadata(txn).isEmpty(), (String)"Transaction metadata not removed");
                return;
            }
        }

        public UnloadTxnPartitionAction(TransactionCoordinatorConcurrencyTest $outer, int txnTopicPartitionId) {
            this.txnTopicPartitionId = txnTopicPartitionId;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.txnRecords = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        }
    }
}

