/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.security.AlgorithmParameters;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.utils.PasswordEncoder;
import kafka.utils.PasswordEncoder$;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.types.Password;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.LinearSeqOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.MapOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0005\u0005=e\u0001\u0002\u000f\u001e\u0001\tB\u0001\u0002\r\u0001\u0003\u0002\u0003\u0006I!\r\u0005\t\u0001\u0002\u0011\t\u0011)A\u0005\u0003\"Aq\n\u0001B\u0001B\u0003%A\t\u0003\u0005Q\u0001\t\u0005\t\u0015!\u0003R\u0011!!\u0006A!A!\u0002\u0013\t\u0006\"B+\u0001\t\u00031\u0006bB/\u0001\u0005\u0004%IA\u0018\u0005\u0007O\u0002\u0001\u000b\u0011B0\t\u000f!\u0004!\u0019!C\u0005S\"9\u00111\u0002\u0001!\u0002\u0013Q\u0007bBA\u0007\u0001\u0011\u0005\u0013q\u0002\u0005\b\u0003+\u0001A\u0011IA\f\u0011\u001d\ti\u0002\u0001C\u0005\u0003?Aq!!\u000e\u0001\t\u0013\t9\u0004C\u0004\u0002`\u0001!I!!\u0019\t\u000f\u0005\u001d\u0004\u0001\"\u0003\u0002j\u00199A\u000e\u0001I\u0001$\u0013i\u0007\"\u00028\u0012\r\u0003y\u0007\"B>\u0012\r\u0003ahABA7\u0001\u0011\ty\u0007\u0003\u0004V)\u0011\u0005\u0011\u0011\u000f\u0005\u0007]R!\t!!\u001e\t\rm$B\u0011AA>\r\u0019\ty\b\u0001\u0003\u0002\u0002\"1Q\u000b\u0007C\u0001\u0003\u0007CaA\u001c\r\u0005\u0002\u0005\u001d\u0005BB>\u0019\t\u0003\tYIA\rF]\u000e\u0014\u0018\u0010\u001d;j]\u001e\u0004\u0016m]:x_J$WI\\2pI\u0016\u0014(B\u0001\u0010 \u0003\u0015)H/\u001b7t\u0015\u0005\u0001\u0013!B6bM.\f7\u0001A\n\u0005\u0001\rJS\u0006\u0005\u0002%O5\tQEC\u0001'\u0003\u0015\u00198-\u00197b\u0013\tASE\u0001\u0004B]f\u0014VM\u001a\t\u0003U-j\u0011!H\u0005\u0003Yu\u0011q\u0002U1tg^|'\u000fZ#oG>$WM\u001d\t\u0003U9J!aL\u000f\u0003\u000f1{wmZ5oO\u000611/Z2sKR\u0004\"A\r \u000e\u0003MR!\u0001N\u001b\u0002\u000bQL\b/Z:\u000b\u0005Y:\u0014AB2p]\u001aLwM\u0003\u00029s\u000511m\\7n_:T!\u0001\t\u001e\u000b\u0005mb\u0014AB1qC\u000eDWMC\u0001>\u0003\ry'oZ\u0005\u0003\u007fM\u0012\u0001\u0002U1tg^|'\u000fZ\u0001\u0014W\u0016Lh)Y2u_JL\u0018\t\\4pe&$\b.\u001c\t\u0004I\t#\u0015BA\"&\u0005\u0019y\u0005\u000f^5p]B\u0011Q\t\u0014\b\u0003\r*\u0003\"aR\u0013\u000e\u0003!S!!S\u0011\u0002\rq\u0012xn\u001c;?\u0013\tYU%\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u001b:\u0013aa\u0015;sS:<'BA&&\u0003=\u0019\u0017\u000e\u001d5fe\u0006cwm\u001c:ji\"l\u0017!C6fs2+gn\u001a;i!\t!#+\u0003\u0002TK\t\u0019\u0011J\u001c;\u0002\u0015%$XM]1uS>t7/\u0001\u0004=S:LGO\u0010\u000b\u0007/bK&l\u0017/\u0011\u0005)\u0002\u0001\"\u0002\u0019\u0007\u0001\u0004\t\u0004\"\u0002!\u0007\u0001\u0004\t\u0005\"B(\u0007\u0001\u0004!\u0005\"\u0002)\u0007\u0001\u0004\t\u0006\"\u0002+\u0007\u0001\u0004\t\u0016\u0001D:fGV\u0014XMU1oI>lW#A0\u0011\u0005\u0001,W\"A1\u000b\u0005\t\u001c\u0017\u0001C:fGV\u0014\u0018\u000e^=\u000b\u0003\u0011\fAA[1wC&\u0011a-\u0019\u0002\r'\u0016\u001cWO]3SC:$w.\\\u0001\u000eg\u0016\u001cWO]3SC:$w.\u001c\u0011\u0002'\rL\u0007\u000f[3s!\u0006\u0014\u0018-\\:F]\u000e|G-\u001a:\u0016\u0003)\u0004\"a[\t\u000e\u0003\u0001\u00111cQ5qQ\u0016\u0014\b+\u0019:b[N,enY8eKJ\u001c\"!E\u0012\u0002\u000bQ|W*\u00199\u0015\u0005A4\b\u0003B9u\t\u0012k\u0011A\u001d\u0006\u0003g\u0016\n!bY8mY\u0016\u001cG/[8o\u0013\t)(OA\u0002NCBDQa\u001e\nA\u0002a\faaY5qQ\u0016\u0014\bC\u00011z\u0013\tQ\u0018MA\nBY\u001e|'/\u001b;i[B\u000b'/Y7fi\u0016\u00148/A\bu_B\u000b'/Y7fi\u0016\u00148\u000b]3d)\ri\u0018q\u0001\t\u0004}\u0006\rQ\"A@\u000b\u0007\u0005\u0005\u0011-\u0001\u0003ta\u0016\u001c\u0017bAA\u0003\u007f\n1\u0012\t\\4pe&$\b.\u001c)be\u0006lW\r^3s'B,7\r\u0003\u0004\u0002\nM\u0001\r\u0001]\u0001\ta\u0006\u0014\u0018-\\'ba\u0006!2-\u001b9iKJ\u0004\u0016M]1ng\u0016s7m\u001c3fe\u0002\na!\u001a8d_\u0012,Gc\u0001#\u0002\u0012!1\u00111C\u0006A\u0002E\n\u0001\u0002]1tg^|'\u000fZ\u0001\u0007I\u0016\u001cw\u000eZ3\u0015\u0007E\nI\u0002\u0003\u0004\u0002\u001c1\u0001\r\u0001R\u0001\u0010K:\u001cw\u000eZ3e!\u0006\u001c8o^8sI\u0006\u00012/Z2sKR\\U-\u001f$bGR|'/\u001f\u000b\u0005\u0003C\t\t\u0004\u0005\u0003\u0002$\u00055RBAA\u0013\u0015\u0011\t9#!\u000b\u0002\r\r\u0014\u0018\u0010\u001d;p\u0015\t\tY#A\u0003kCZ\f\u00070\u0003\u0003\u00020\u0005\u0015\"\u0001E*fGJ,GoS3z\r\u0006\u001cGo\u001c:z\u0011\u0019\t\u0019$\u0004a\u0001\u0003\u0006i1.Z=GC\u000e$xN]=BY\u001e\fQb]3de\u0016$8*Z=Ta\u0016\u001cG\u0003DA\u001d\u0003\u0007\n9%a\u0013\u0002N\u0005u\u0003\u0003BA\u001e\u0003\u007fi!!!\u0010\u000b\t\u0005\u0005\u0011QE\u0005\u0005\u0003\u0003\niDA\u0007TK\u000e\u0014X\r^&fsN\u0003Xm\u0019\u0005\b\u0003\u000br\u0001\u0019AA\u0011\u0003)YW-\u001f$bGR|'/\u001f\u0005\u0007\u0003\u0013r\u0001\u0019\u0001#\u0002\u0013\rL\u0007\u000f[3s\u00032<\u0007\"\u0002)\u000f\u0001\u0004\t\u0006bBA(\u001d\u0001\u0007\u0011\u0011K\u0001\u0005g\u0006dG\u000fE\u0003%\u0003'\n9&C\u0002\u0002V\u0015\u0012Q!\u0011:sCf\u00042\u0001JA-\u0013\r\tY&\n\u0002\u0005\u0005f$X\rC\u0003U\u001d\u0001\u0007\u0011+\u0001\u0007cCN,g\u0007N#oG>$W\rF\u0002E\u0003GBq!!\u001a\u0010\u0001\u0004\t\t&A\u0003csR,7/\u0001\u000bdSBDWM\u001d)be\u0006l7/\u00138ti\u0006t7-\u001a\u000b\u0004U\u0006-\u0004\"B(\u0011\u0001\u0004!%aD%w!\u0006\u0014\u0018-\\:F]\u000e|G-\u001a:\u0014\u0007Q\u0019#\u000e\u0006\u0002\u0002tA\u00111\u000e\u0006\u000b\u0004a\u0006]\u0004BBA=-\u0001\u0007\u00010\u0001\u0007dSBDWM\u001d)be\u0006l7\u000fF\u0002~\u0003{Ba!!\u0003\u0018\u0001\u0004\u0001(\u0001E$d[B\u000b'/Y7t\u000b:\u001cw\u000eZ3s'\rA2E\u001b\u000b\u0003\u0003\u000b\u0003\"a\u001b\r\u0015\u0007A\fI\t\u0003\u0004\u0002zi\u0001\r\u0001\u001f\u000b\u0004{\u00065\u0005BBA\u00057\u0001\u0007\u0001\u000f")
public class EncryptingPasswordEncoder
implements PasswordEncoder,
Logging {
    private final Password secret;
    private final Option<String> keyFactoryAlgorithm;
    private final String cipherAlgorithm;
    private final int keyLength;
    private final int iterations;
    private final SecureRandom secureRandom;
    private final CipherParamsEncoder cipherParamsEncoder;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    @Override
    public byte[] base64Decode(String encoded) {
        return PasswordEncoder.base64Decode$(this, encoded);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private SecureRandom secureRandom() {
        return this.secureRandom;
    }

    private CipherParamsEncoder cipherParamsEncoder() {
        return this.cipherParamsEncoder;
    }

    @Override
    public String encode(Password password) {
        byte[] salt = new byte[256];
        this.secureRandom().nextBytes(salt);
        Cipher cipher = Cipher.getInstance(this.cipherAlgorithm);
        SecretKeyFactory keyFactory = this.secretKeyFactory(this.keyFactoryAlgorithm);
        SecretKeySpec keySpec = this.secretKeySpec(keyFactory, this.cipherAlgorithm, this.keyLength, salt, this.iterations);
        cipher.init(1, keySpec);
        byte[] encryptedPassword = cipher.doFinal(password.value().getBytes(StandardCharsets.UTF_8));
        return ((IterableOnceOps)((Map)((MapOps)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)PasswordEncoder$.MODULE$.KeyFactoryAlgorithmProp()), (Object)keyFactory.getAlgorithm()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)PasswordEncoder$.MODULE$.CipherAlgorithmProp()), (Object)this.cipherAlgorithm), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)PasswordEncoder$.MODULE$.KeyLengthProp()), (Object)BoxesRunTime.boxToInteger((int)this.keyLength)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)PasswordEncoder$.MODULE$.SaltProp()), (Object)this.kafka$utils$EncryptingPasswordEncoder$$base64Encode(salt)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)PasswordEncoder$.MODULE$.IterationsProp()), (Object)Integer.toString(this.iterations)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)PasswordEncoder$.MODULE$.EncyrptedPasswordProp()), (Object)this.kafka$utils$EncryptingPasswordEncoder$$base64Encode(encryptedPassword)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)PasswordEncoder$.MODULE$.PasswordLengthProp()), (Object)BoxesRunTime.boxToInteger((int)password.value().length()))}))).$plus$plus(this.cipherParamsEncoder().toMap(cipher.getParameters()))).map((Function1 & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            String k = (String)x0$1._1();
            Object v = x0$1._2();
            String string = new StringBuilder(1).append(k).append(":").append(v).toString();
            return string;
        })).mkString(",");
    }

    @Override
    public Password decode(String encodedPassword) {
        String string;
        Map<String, String> params = CoreUtils$.MODULE$.parseCsvMap(encodedPassword);
        String keyFactoryAlg = (String)params.apply((Object)PasswordEncoder$.MODULE$.KeyFactoryAlgorithmProp());
        String cipherAlg = (String)params.apply((Object)PasswordEncoder$.MODULE$.CipherAlgorithmProp());
        int keyLength = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString((String)params.apply((Object)PasswordEncoder$.MODULE$.KeyLengthProp())));
        byte[] salt = this.base64Decode((String)params.apply((Object)PasswordEncoder$.MODULE$.SaltProp()));
        int iterations = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString((String)params.apply((Object)PasswordEncoder$.MODULE$.IterationsProp())));
        byte[] encryptedPassword = this.base64Decode((String)params.apply((Object)PasswordEncoder$.MODULE$.EncyrptedPasswordProp()));
        int passwordLengthProp = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString((String)params.apply((Object)PasswordEncoder$.MODULE$.PasswordLengthProp())));
        Cipher cipher = Cipher.getInstance(cipherAlg);
        SecretKeyFactory keyFactory = this.secretKeyFactory((Option<String>)new Some((Object)keyFactoryAlg));
        SecretKeySpec keySpec = this.secretKeySpec(keyFactory, cipherAlg, keyLength, salt, iterations);
        cipher.init(2, (Key)keySpec, this.cipherParamsEncoder().toParameterSpec(params));
        try {
            byte[] decrypted = cipher.doFinal(encryptedPassword);
            string = new String(decrypted, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            throw new ConfigException("Password could not be decoded", (Object)e);
        }
        String password = string;
        if (password.length() != passwordLengthProp) {
            throw new ConfigException("Password could not be decoded, sanity check of length failed");
        }
        return new Password(password);
    }

    private SecretKeyFactory secretKeyFactory(Option<String> keyFactoryAlg) {
        SecretKeyFactory secretKeyFactory;
        if (keyFactoryAlg instanceof Some) {
            secretKeyFactory = SecretKeyFactory.getInstance((String)((Some)keyFactoryAlg).value());
        } else if (None$.MODULE$.equals(keyFactoryAlg)) {
            SecretKeyFactory secretKeyFactory2;
            try {
                secretKeyFactory2 = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA512");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                secretKeyFactory2 = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
            }
            secretKeyFactory = secretKeyFactory2;
        } else {
            throw new MatchError(keyFactoryAlg);
        }
        return secretKeyFactory;
    }

    private SecretKeySpec secretKeySpec(SecretKeyFactory keyFactory, String cipherAlg, int keyLength, byte[] salt, int iterations) {
        PBEKeySpec keySpec = new PBEKeySpec(this.secret.value().toCharArray(), salt, iterations, keyLength);
        String algorithm = cipherAlg.indexOf(47) > 0 ? cipherAlg.substring(0, cipherAlg.indexOf(47)) : cipherAlg;
        return new SecretKeySpec(keyFactory.generateSecret(keySpec).getEncoded(), algorithm);
    }

    public String kafka$utils$EncryptingPasswordEncoder$$base64Encode(byte[] bytes) {
        return Base64.getEncoder().encodeToString(bytes);
    }

    private CipherParamsEncoder cipherParamsInstance(String cipherAlgorithm) {
        String string;
        Option option;
        Regex aesPattern = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("AES/(.*)/.*"));
        CipherParamsEncoder cipherParamsEncoder = cipherAlgorithm != null && !(option = aesPattern.unapplySeq((CharSequence)cipherAlgorithm)).isEmpty() && option.get() != null && ((List)option.get()).lengthCompare(1) == 0 && "GCM".equals(string = (String)((LinearSeqOps)option.get()).apply(0)) ? new GcmParamsEncoder() : new IvParamsEncoder();
        return cipherParamsEncoder;
    }

    public EncryptingPasswordEncoder(Password secret, Option<String> keyFactoryAlgorithm, String cipherAlgorithm, int keyLength, int iterations) {
        this.secret = secret;
        this.keyFactoryAlgorithm = keyFactoryAlgorithm;
        this.cipherAlgorithm = cipherAlgorithm;
        this.keyLength = keyLength;
        this.iterations = iterations;
        this.secureRandom = new SecureRandom();
        this.cipherParamsEncoder = this.cipherParamsInstance(cipherAlgorithm);
    }

    private interface CipherParamsEncoder {
        public Map<String, String> toMap(AlgorithmParameters var1);

        public AlgorithmParameterSpec toParameterSpec(Map<String, String> var1);
    }

    private class GcmParamsEncoder
    implements CipherParamsEncoder {
        @Override
        public Map<String, String> toMap(AlgorithmParameters cipherParams) {
            if (cipherParams != null) {
                GCMParameterSpec spec = cipherParams.getParameterSpec(GCMParameterSpec.class);
                return (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)PasswordEncoder$.MODULE$.InitializationVectorProp()), (Object)this.kafka$utils$EncryptingPasswordEncoder$GcmParamsEncoder$$$outer().kafka$utils$EncryptingPasswordEncoder$$base64Encode(spec.getIV())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"authenticationTagLength"), (Object)Integer.toString(spec.getTLen()))}));
            }
            throw new IllegalStateException("Could not determine initialization vector for cipher");
        }

        @Override
        public AlgorithmParameterSpec toParameterSpec(Map<String, String> paramMap) {
            return new GCMParameterSpec(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString((String)paramMap.apply((Object)"authenticationTagLength"))), this.kafka$utils$EncryptingPasswordEncoder$GcmParamsEncoder$$$outer().base64Decode((String)paramMap.apply((Object)PasswordEncoder$.MODULE$.InitializationVectorProp())));
        }

        public /* synthetic */ EncryptingPasswordEncoder kafka$utils$EncryptingPasswordEncoder$GcmParamsEncoder$$$outer() {
            return EncryptingPasswordEncoder.this;
        }

        public GcmParamsEncoder() {
            if (EncryptingPasswordEncoder.this == null) {
                throw null;
            }
        }
    }

    private class IvParamsEncoder
    implements CipherParamsEncoder {
        @Override
        public Map<String, String> toMap(AlgorithmParameters cipherParams) {
            if (cipherParams != null) {
                IvParameterSpec ivSpec = cipherParams.getParameterSpec(IvParameterSpec.class);
                return (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)PasswordEncoder$.MODULE$.InitializationVectorProp()), (Object)this.kafka$utils$EncryptingPasswordEncoder$IvParamsEncoder$$$outer().kafka$utils$EncryptingPasswordEncoder$$base64Encode(ivSpec.getIV()))}));
            }
            throw new IllegalStateException("Could not determine initialization vector for cipher");
        }

        @Override
        public AlgorithmParameterSpec toParameterSpec(Map<String, String> paramMap) {
            return new IvParameterSpec(this.kafka$utils$EncryptingPasswordEncoder$IvParamsEncoder$$$outer().base64Decode((String)paramMap.apply((Object)PasswordEncoder$.MODULE$.InitializationVectorProp())));
        }

        public /* synthetic */ EncryptingPasswordEncoder kafka$utils$EncryptingPasswordEncoder$IvParamsEncoder$$$outer() {
            return EncryptingPasswordEncoder.this;
        }

        public IvParamsEncoder() {
            if (EncryptingPasswordEncoder.this == null) {
                throw null;
            }
        }
    }
}

