/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.concurrent.locks.ReentrantLock;
import kafka.coordinator.transaction.CompleteAbort$;
import kafka.coordinator.transaction.CompleteCommit$;
import kafka.coordinator.transaction.Dead$;
import kafka.coordinator.transaction.Empty$;
import kafka.coordinator.transaction.Ongoing$;
import kafka.coordinator.transaction.PrepareAbort$;
import kafka.coordinator.transaction.PrepareCommit$;
import kafka.coordinator.transaction.PrepareEpochFence$;
import kafka.coordinator.transaction.TransactionMetadata$;
import kafka.coordinator.transaction.TransactionState;
import kafka.coordinator.transaction.TxnTransitMetadata;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.Errors;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Set;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction2;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0005\rUrA\u0002#F\u0011\u0003)5J\u0002\u0004N\u000b\"\u0005QI\u0014\u0005\u0006+\u0006!\ta\u0016\u0005\u00061\u0006!\t!\u0017\u0005\u00071\u0006!\tAa>\t\ra\u000bA\u0011AB\u0003\u0011\u001d\u00199\"\u0001C\u0001\u00073A\u0011b!\b\u0002#\u0003%\taa\b\u0007\u000b5+\u0005!R.\t\u0011\tD!Q1A\u0005\u0002\rD\u0001b\u001c\u0005\u0003\u0002\u0003\u0006I\u0001\u001a\u0005\ta\"\u0011\t\u0019!C\u0001c\"AQ\u000f\u0003BA\u0002\u0013\u0005a\u000f\u0003\u0005}\u0011\t\u0005\t\u0015)\u0003s\u0011!i\bB!a\u0001\n\u0003\t\b\u0002\u0003@\t\u0005\u0003\u0007I\u0011A@\t\u0013\u0005\r\u0001B!A!B\u0013\u0011\bBCA\u0003\u0011\t\u0005\r\u0011\"\u0001\u0002\b!Q\u0011q\u0002\u0005\u0003\u0002\u0004%\t!!\u0005\t\u0015\u0005U\u0001B!A!B\u0013\tI\u0001\u0003\u0006\u0002\u0018!\u0011\t\u0019!C\u0001\u0003\u000fA!\"!\u0007\t\u0005\u0003\u0007I\u0011AA\u000e\u0011)\ty\u0002\u0003B\u0001B\u0003&\u0011\u0011\u0002\u0005\u000b\u0003CA!\u00111A\u0005\u0002\u0005\r\u0002BCA\u0016\u0011\t\u0005\r\u0011\"\u0001\u0002.!Q\u0011\u0011\u0007\u0005\u0003\u0002\u0003\u0006K!!\n\t\u0015\u0005M\u0002B!a\u0001\n\u0003\t)\u0004\u0003\u0006\u0002>!\u0011\t\u0019!C\u0001\u0003\u007fA!\"a\u0011\t\u0005\u0003\u0005\u000b\u0015BA\u001c\u0011)\t)\u0005\u0003BC\u0002\u0013\u0005\u0011q\t\u0005\u000b\u0003_B!\u0011!Q\u0001\n\u0005%\u0003\"CA9\u0011\t\u0005\r\u0011\"\u0001r\u0011)\t\u0019\b\u0003BA\u0002\u0013\u0005\u0011Q\u000f\u0005\n\u0003sB!\u0011!Q!\nID\u0011\"a!\t\u0005\u0003\u0007I\u0011A9\t\u0015\u0005\u0015\u0005B!a\u0001\n\u0003\t9\tC\u0005\u0002\f\"\u0011\t\u0011)Q\u0005e\"1Q\u000b\u0003C\u0001\u0003\u001fC\u0011\"!*\t\u0001\u0004%\t!a*\t\u0013\u0005=\u0006\u00021A\u0005\u0002\u0005E\u0006\u0002CA[\u0011\u0001\u0006K!!+\t\u0013\u0005]\u0006\u00021A\u0005\u0002\u0005e\u0006\"CAa\u0011\u0001\u0007I\u0011AAb\u0011!\t9\r\u0003Q!\n\u0005m\u0006BCAe\u0011\t\u0007I\u0011A#\u0002L\"A\u0011Q\u001d\u0005!\u0002\u0013\ti\rC\u0004\u0002h\"!\t!!;\t\u000f\t5\u0001\u0002\"\u0001\u0003\u0010!9!1\u0004\u0005\u0005\u0002\tu\u0001b\u0002B\u0012\u0011\u0011\u0005!Q\u0005\u0005\b\u0005[AA\u0011\u0001B\u0013\u0011\u001d\u0011y\u0003\u0003C\u0001\u0005cAqAa\u0018\t\t\u0003\u0011\t\u0007C\u0004\u0003p!!\tA!\u001d\t\u000f\t\r\u0005\u0002\"\u0001\u0003\u0006\"9!Q\u0012\u0005\u0005\u0002\t=\u0005b\u0002BJ\u0011\u0011\u0005!Q\u0005\u0005\b\u0005+CA\u0011AA]\u0011\u001d\u00119\n\u0003C\u0005\u0003sCqA!'\t\t\u0013\u0011Y\nC\u0004\u00036\"!\tAa.\t\u000f\tu\u0006\u0002\"\u0003\u0003@\"9!1\u0019\u0005\u0005\n\t\u0015\u0007b\u0002Be\u0011\u0011%!1\u001a\u0005\b\u0005#DA\u0011AA]\u0011\u001d\u0011\u0019\u000e\u0003C!\u0005+DqAa6\t\t\u0003\u0012I\u000eC\u0004\u0003`\"!\tE!9\u0002'Q\u0013\u0018M\\:bGRLwN\\'fi\u0006$\u0017\r^1\u000b\u0005\u0019;\u0015a\u0003;sC:\u001c\u0018m\u0019;j_:T!\u0001S%\u0002\u0017\r|wN\u001d3j]\u0006$xN\u001d\u0006\u0002\u0015\u0006)1.\u00194lCB\u0011A*A\u0007\u0002\u000b\n\u0019BK]1og\u0006\u001cG/[8o\u001b\u0016$\u0018\rZ1uCN\u0011\u0011a\u0014\t\u0003!Nk\u0011!\u0015\u0006\u0002%\u0006)1oY1mC&\u0011A+\u0015\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?\u0007\u0001!\u0012aS\u0001\u0006CB\u0004H.\u001f\u000b\f5\n-(Q\u001eBx\u0005c\u0014\u0019\u0010\u0005\u0002M\u0011M\u0019\u0001b\u0014/\u0011\u0005u\u0003W\"\u00010\u000b\u0005}K\u0015!B;uS2\u001c\u0018BA1_\u0005\u001daunZ4j]\u001e\fq\u0002\u001e:b]N\f7\r^5p]\u0006d\u0017\nZ\u000b\u0002IB\u0011Q\r\u001c\b\u0003M*\u0004\"aZ)\u000e\u0003!T!!\u001b,\u0002\rq\u0012xn\u001c;?\u0013\tY\u0017+\u0001\u0004Qe\u0016$WMZ\u0005\u0003[:\u0014aa\u0015;sS:<'BA6R\u0003A!(/\u00198tC\u000e$\u0018n\u001c8bY&#\u0007%\u0001\u0006qe>$WoY3s\u0013\u0012,\u0012A\u001d\t\u0003!NL!\u0001^)\u0003\t1{gnZ\u0001\u000faJ|G-^2fe&#w\fJ3r)\t9(\u0010\u0005\u0002Qq&\u0011\u00110\u0015\u0002\u0005+:LG\u000fC\u0004|\u0019\u0005\u0005\t\u0019\u0001:\u0002\u0007a$\u0013'A\u0006qe>$WoY3s\u0013\u0012\u0004\u0013A\u00047bgR\u0004&o\u001c3vG\u0016\u0014\u0018\nZ\u0001\u0013Y\u0006\u001cH\u000f\u0015:pIV\u001cWM]%e?\u0012*\u0017\u000fF\u0002x\u0003\u0003Aqa_\b\u0002\u0002\u0003\u0007!/A\bmCN$\bK]8ek\u000e,'/\u00133!\u00035\u0001(o\u001c3vG\u0016\u0014X\t]8dQV\u0011\u0011\u0011\u0002\t\u0004!\u0006-\u0011bAA\u0007#\n)1\u000b[8si\u0006\t\u0002O]8ek\u000e,'/\u00129pG\"|F%Z9\u0015\u0007]\f\u0019\u0002\u0003\u0005|%\u0005\u0005\t\u0019AA\u0005\u00039\u0001(o\u001c3vG\u0016\u0014X\t]8dQ\u0002\n\u0011\u0003\\1tiB\u0013x\u000eZ;dKJ,\u0005o\\2i\u0003Ua\u0017m\u001d;Qe>$WoY3s\u000bB|7\r[0%KF$2a^A\u000f\u0011!YX#!AA\u0002\u0005%\u0011A\u00057bgR\u0004&o\u001c3vG\u0016\u0014X\t]8dQ\u0002\nA\u0002\u001e=o)&lWm\\;u\u001bN,\"!!\n\u0011\u0007A\u000b9#C\u0002\u0002*E\u00131!\u00138u\u0003A!\bP\u001c+j[\u0016|W\u000f^'t?\u0012*\u0017\u000fF\u0002x\u0003_A\u0001b\u001f\r\u0002\u0002\u0003\u0007\u0011QE\u0001\u000eibtG+[7f_V$Xj\u001d\u0011\u0002\u000bM$\u0018\r^3\u0016\u0005\u0005]\u0002c\u0001'\u0002:%\u0019\u00111H#\u0003!Q\u0013\u0018M\\:bGRLwN\\*uCR,\u0017!C:uCR,w\fJ3r)\r9\u0018\u0011\t\u0005\twn\t\t\u00111\u0001\u00028\u000511\u000f^1uK\u0002\nq\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|gn]\u000b\u0003\u0003\u0013\u0002b!a\u0013\u0002V\u0005eSBAA'\u0015\u0011\ty%!\u0015\u0002\u000f5,H/\u00192mK*\u0019\u00111K)\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002X\u00055#aA*fiB!\u00111LA6\u001b\t\tiF\u0003\u0003\u0002`\u0005\u0005\u0014AB2p[6|gNC\u0002K\u0003GRA!!\u001a\u0002h\u00051\u0011\r]1dQ\u0016T!!!\u001b\u0002\u0007=\u0014x-\u0003\u0003\u0002n\u0005u#A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\\\u0001\u0011i>\u0004\u0018n\u0019)beRLG/[8og\u0002\n\u0011\u0003\u001e=o'R\f'\u000f\u001e+j[\u0016\u001cH/Y7q\u0003U!\bP\\*uCJ$H+[7fgR\fW\u000e]0%KF$2a^A<\u0011\u001dY\b%!AA\u0002I\f!\u0003\u001e=o'R\f'\u000f\u001e+j[\u0016\u001cH/Y7qA!\u001a\u0011%! \u0011\u0007A\u000by(C\u0002\u0002\u0002F\u0013\u0001B^8mCRLG.Z\u0001\u0017ibtG*Y:u+B$\u0017\r^3US6,7\u000f^1na\u0006QB\u000f\u001f8MCN$X\u000b\u001d3bi\u0016$\u0016.\\3ti\u0006l\u0007o\u0018\u0013fcR\u0019q/!#\t\u000fm\u001c\u0013\u0011!a\u0001e\u00069B\u000f\u001f8MCN$X\u000b\u001d3bi\u0016$\u0016.\\3ti\u0006l\u0007\u000f\t\u0015\u0004I\u0005uD#\u0006.\u0002\u0012\u0006M\u0015QSAL\u00033\u000bY*!(\u0002 \u0006\u0005\u00161\u0015\u0005\u0006E\u0016\u0002\r\u0001\u001a\u0005\u0006a\u0016\u0002\rA\u001d\u0005\u0006{\u0016\u0002\rA\u001d\u0005\b\u0003\u000b)\u0003\u0019AA\u0005\u0011\u001d\t9\"\na\u0001\u0003\u0013Aq!!\t&\u0001\u0004\t)\u0003C\u0004\u00024\u0015\u0002\r!a\u000e\t\u000f\u0005\u0015S\u00051\u0001\u0002J!A\u0011\u0011O\u0013\u0011\u0002\u0003\u0007!\u000f\u0003\u0004\u0002\u0004\u0016\u0002\rA]\u0001\ra\u0016tG-\u001b8h'R\fG/Z\u000b\u0003\u0003S\u0003R\u0001UAV\u0003oI1!!,R\u0005\u0019y\u0005\u000f^5p]\u0006\u0001\u0002/\u001a8eS:<7\u000b^1uK~#S-\u001d\u000b\u0004o\u0006M\u0006\u0002C>(\u0003\u0003\u0005\r!!+\u0002\u001bA,g\u000eZ5oON#\u0018\r^3!\u0003MA\u0017m\u001d$bS2,G-\u00129pG\"4UM\\2f+\t\tY\fE\u0002Q\u0003{K1!a0R\u0005\u001d\u0011un\u001c7fC:\fq\u0003[1t\r\u0006LG.\u001a3Fa>\u001c\u0007NR3oG\u0016|F%Z9\u0015\u0007]\f)\r\u0003\u0005|U\u0005\u0005\t\u0019AA^\u0003QA\u0017m\u001d$bS2,G-\u00129pG\"4UM\\2fA\u0005!An\\2l+\t\ti\r\u0005\u0003\u0002P\u0006\u0005XBAAi\u0015\u0011\t\u0019.!6\u0002\u000b1|7m[:\u000b\t\u0005]\u0017\u0011\\\u0001\u000bG>t7-\u001e:sK:$(\u0002BAn\u0003;\fA!\u001e;jY*\u0011\u0011q\\\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002d\u0006E'!\u0004*fK:$(/\u00198u\u0019>\u001c7.A\u0003m_\u000e\\\u0007%\u0001\u0004j]2{7m[\u000b\u0005\u0003W\f\t\u0010\u0006\u0003\u0002n\n\r\u0001\u0003BAx\u0003cd\u0001\u0001B\u0004\u0002t:\u0012\r!!>\u0003\u0003Q\u000bB!a>\u0002~B\u0019\u0001+!?\n\u0007\u0005m\u0018KA\u0004O_RD\u0017N\\4\u0011\u0007A\u000by0C\u0002\u0003\u0002E\u00131!\u00118z\u0011!\u0011)A\fCA\u0002\t\u001d\u0011a\u00014v]B)\u0001K!\u0003\u0002n&\u0019!1B)\u0003\u0011q\u0012\u0017P\\1nKz\nQ\"\u00193e!\u0006\u0014H/\u001b;j_:\u001cHcA<\u0003\u0012!9!1C\u0018A\u0002\tU\u0011A\u00039beRLG/[8ogB1!q\u0003B\r\u00033j!!!\u0015\n\t\u0005]\u0013\u0011K\u0001\u0010e\u0016lwN^3QCJ$\u0018\u000e^5p]R\u0019qOa\b\t\u000f\t\u0005\u0002\u00071\u0001\u0002Z\u0005qAo\u001c9jGB\u000b'\u000f^5uS>t\u0017\u0001\u00059sKB\f'/\u001a(p)J\fgn]5u)\t\u00119\u0003E\u0002M\u0005SI1Aa\u000bF\u0005I!\u0006P\u001c+sC:\u001c\u0018\u000e^'fi\u0006$\u0017\r^1\u00023A\u0014X\r]1sK\u001a+gnY3Qe>$WoY3s\u000bB|7\r[\u0001\u001eaJ,\u0007/\u0019:f\u0013:\u001c'/Z7f]R\u0004&o\u001c3vG\u0016\u0014X\t]8dQRA!1\u0007B)\u0005+\u0012Y\u0006\u0005\u0005\u00036\t}\"Q\tB\u0014\u001d\u0011\u00119Da\u000f\u000f\u0007\u001d\u0014I$C\u0001S\u0013\r\u0011i$U\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u0011\tEa\u0011\u0003\r\u0015KG\u000f[3s\u0015\r\u0011i$\u0015\t\u0005\u0005\u000f\u0012i%\u0004\u0002\u0003J)!!1JA/\u0003!\u0001(o\u001c;pG>d\u0017\u0002\u0002B(\u0005\u0013\u0012a!\u0012:s_J\u001c\bb\u0002B*g\u0001\u0007\u0011QE\u0001\u0010]\u0016<H\u000b\u001f8US6,w.\u001e;Ng\"9!qK\u001aA\u0002\te\u0013!F3ya\u0016\u001cG/\u001a3Qe>$WoY3s\u000bB|7\r\u001b\t\u0006!\u0006-\u0016\u0011\u0002\u0005\u0007\u0005;\u001a\u0004\u0019\u0001:\u0002\u001fU\u0004H-\u0019;f)&lWm\u001d;b[B\f\u0011\u0004\u001d:fa\u0006\u0014X\r\u0015:pIV\u001cWM]%e%>$\u0018\r^5p]RQ!q\u0005B2\u0005O\u0012IGa\u001b\t\r\t\u0015D\u00071\u0001s\u00035qWm\u001e)s_\u0012,8-\u001a:JI\"9!1\u000b\u001bA\u0002\u0005\u0015\u0002B\u0002B/i\u0001\u0007!\u000fC\u0004\u0003nQ\u0002\r!a/\u0002\u001fI,7m\u001c:e\u0019\u0006\u001cH/\u00129pG\"\fA\u0003\u001d:fa\u0006\u0014X-\u00113e!\u0006\u0014H/\u001b;j_:\u001cHC\u0002B\u0014\u0005g\u0012\t\tC\u0004\u0003vU\u0002\rAa\u001e\u0002)\u0005$G-\u001a3U_BL7\rU1si&$\u0018n\u001c8t!\u0019\u0011IHa \u0002Z5\u0011!1\u0010\u0006\u0005\u0005{\n\t&A\u0005j[6,H/\u00192mK&!\u0011q\u000bB>\u0011\u0019\u0011i&\u000ea\u0001e\u0006!\u0002O]3qCJ,\u0017IY8si>\u00138i\\7nSR$bAa\n\u0003\b\n-\u0005b\u0002BEm\u0001\u0007\u0011qG\u0001\t]\u0016<8\u000b^1uK\"1!Q\f\u001cA\u0002I\fq\u0002\u001d:fa\u0006\u0014XmQ8na2,G/\u001a\u000b\u0005\u0005O\u0011\t\n\u0003\u0004\u0003^]\u0002\rA]\u0001\faJ,\u0007/\u0019:f\t\u0016\fG-\u0001\rjgB\u0013x\u000eZ;dKJ,\u0005o\\2i\u000bbD\u0017-^:uK\u0012\fQ\u0003[1t!\u0016tG-\u001b8h)J\fgn]1di&|g.A\nqe\u0016\u0004\u0018M]3Ue\u0006t7/\u001b;j_:$v\u000e\u0006\n\u0003(\tu%q\u0014BQ\u0005K\u0013IKa+\u00030\nM\u0006b\u0002BEw\u0001\u0007\u0011q\u0007\u0005\u0007\u0005KZ\u0004\u0019\u0001:\t\u000f\t\r6\b1\u0001\u0002\n\u0005Aa.Z<Fa>\u001c\u0007\u000eC\u0004\u0003(n\u0002\r!!\u0003\u0002\u00199,w\u000fT1ti\u0016\u0003xn\u00195\t\u000f\tM3\b1\u0001\u0002&!9!QV\u001eA\u0002\t]\u0014A\u00058foR{\u0007/[2QCJ$\u0018\u000e^5p]NDaA!-<\u0001\u0004\u0011\u0018\u0001\u00068foRChn\u0015;beR$\u0016.\\3ti\u0006l\u0007\u000f\u0003\u0004\u0003^m\u0002\rA]\u0001\u0015G>l\u0007\u000f\\3uKR\u0013\u0018M\\:ji&|g\u000eV8\u0015\u0007]\u0014I\fC\u0004\u0003<r\u0002\rAa\n\u0002\u001fQ\u0014\u0018M\\:ji6+G/\u00193bi\u0006\f!C^1mS\u0012\u0004&o\u001c3vG\u0016\u0014X\t]8dQR!\u00111\u0018Ba\u0011\u001d\u0011Y,\u0010a\u0001\u0005O\taC^1mS\u0012\u0004&o\u001c3vG\u0016\u0014X\t]8dQ\n+X\u000e\u001d\u000b\u0005\u0003w\u00139\rC\u0004\u0003<z\u0002\rAa\n\u00027QD'o\\<Ti\u0006$X\r\u0016:b]NLG/[8o\r\u0006LG.\u001e:f)\r9(Q\u001a\u0005\b\u0005\u001f|\u0004\u0019\u0001B\u0014\u0003I!\bP\u001c+sC:\u001c\u0018\u000e^'fi\u0006$\u0017\r^1\u00027A,g\u000eZ5oOR\u0013\u0018M\\:ji&|g.\u00138Qe><'/Z:t\u0003!!xn\u0015;sS:<G#\u00013\u0002\r\u0015\fX/\u00197t)\u0011\tYLa7\t\u000f\tu'\t1\u0001\u0002~\u0006!A\u000f[1u\u0003!A\u0017m\u001d5D_\u0012,GCAA\u0013Q\rA!Q\u001d\t\u0004;\n\u001d\u0018b\u0001Bu=\nian\u001c8uQJ,\u0017\rZ:bM\u0016DQAY\u0002A\u0002\u0011DQ\u0001]\u0002A\u0002IDq!!\u0002\u0004\u0001\u0004\tI\u0001C\u0004\u0002\"\r\u0001\r!!\n\t\r\tU8\u00011\u0001s\u0003%!\u0018.\\3ti\u0006l\u0007\u000fF\u0007[\u0005s\u0014YP!@\u0003\u0000\u000e\u000511\u0001\u0005\u0006E\u0012\u0001\r\u0001\u001a\u0005\u0006a\u0012\u0001\rA\u001d\u0005\b\u0003\u000b!\u0001\u0019AA\u0005\u0011\u001d\t\t\u0003\u0002a\u0001\u0003KAq!a\r\u0005\u0001\u0004\t9\u0004\u0003\u0004\u0003v\u0012\u0001\rA\u001d\u000b\u00125\u000e\u001d1\u0011BB\u0006\u0007\u001b\u0019ya!\u0005\u0004\u0014\rU\u0001\"\u00022\u0006\u0001\u0004!\u0007\"\u00029\u0006\u0001\u0004\u0011\b\"B?\u0006\u0001\u0004\u0011\bbBA\u0003\u000b\u0001\u0007\u0011\u0011\u0002\u0005\b\u0003/)\u0001\u0019AA\u0005\u0011\u001d\t\t#\u0002a\u0001\u0003KAq!a\r\u0006\u0001\u0004\t9\u0004\u0003\u0004\u0003v\u0016\u0001\rA]\u0001\u0011SN,\u0005o\\2i\u000bbD\u0017-^:uK\u0012$B!a/\u0004\u001c!9\u0011Q\u0001\u0004A\u0002\u0005%\u0011a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$\u0013(\u0006\u0002\u0004\")\u001a!oa\t,\u0005\r\u0015\u0002\u0003BB\u0014\u0007ci!a!\u000b\u000b\t\r-2QF\u0001\nk:\u001c\u0007.Z2lK\u0012T1aa\fR\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0007g\u0019ICA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\u0004")
public class TransactionMetadata
implements Logging {
    private final String transactionalId;
    private long producerId;
    private long lastProducerId;
    private short producerEpoch;
    private short lastProducerEpoch;
    private int txnTimeoutMs;
    private TransactionState state;
    private final scala.collection.mutable.Set<TopicPartition> topicPartitions;
    private volatile long txnStartTimestamp;
    private volatile long txnLastUpdateTimestamp;
    private Option<TransactionState> pendingState;
    private boolean hasFailedEpochFence;
    private final ReentrantLock lock;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static long $lessinit$greater$default$9() {
        return -1L;
    }

    public static boolean isEpochExhausted(short producerEpoch) {
        return TransactionMetadata$.MODULE$.isEpochExhausted(producerEpoch);
    }

    public static TransactionMetadata apply(String transactionalId, long producerId, long lastProducerId, short producerEpoch, short lastProducerEpoch, int txnTimeoutMs, TransactionState state, long timestamp) {
        return TransactionMetadata$.MODULE$.apply(transactionalId, producerId, lastProducerId, producerEpoch, lastProducerEpoch, txnTimeoutMs, state, timestamp);
    }

    public static TransactionMetadata apply(String transactionalId, long producerId, short producerEpoch, int txnTimeoutMs, TransactionState state, long timestamp) {
        return TransactionMetadata$.MODULE$.apply(transactionalId, producerId, producerEpoch, txnTimeoutMs, state, timestamp);
    }

    public static TransactionMetadata apply(String transactionalId, long producerId, short producerEpoch, int txnTimeoutMs, long timestamp) {
        return TransactionMetadata$.MODULE$.apply(transactionalId, producerId, producerEpoch, txnTimeoutMs, timestamp);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public String transactionalId() {
        return this.transactionalId;
    }

    public long producerId() {
        return this.producerId;
    }

    public void producerId_$eq(long x$1) {
        this.producerId = x$1;
    }

    public long lastProducerId() {
        return this.lastProducerId;
    }

    public void lastProducerId_$eq(long x$1) {
        this.lastProducerId = x$1;
    }

    public short producerEpoch() {
        return this.producerEpoch;
    }

    public void producerEpoch_$eq(short x$1) {
        this.producerEpoch = x$1;
    }

    public short lastProducerEpoch() {
        return this.lastProducerEpoch;
    }

    public void lastProducerEpoch_$eq(short x$1) {
        this.lastProducerEpoch = x$1;
    }

    public int txnTimeoutMs() {
        return this.txnTimeoutMs;
    }

    public void txnTimeoutMs_$eq(int x$1) {
        this.txnTimeoutMs = x$1;
    }

    public TransactionState state() {
        return this.state;
    }

    public void state_$eq(TransactionState x$1) {
        this.state = x$1;
    }

    public scala.collection.mutable.Set<TopicPartition> topicPartitions() {
        return this.topicPartitions;
    }

    public long txnStartTimestamp() {
        return this.txnStartTimestamp;
    }

    public void txnStartTimestamp_$eq(long x$1) {
        this.txnStartTimestamp = x$1;
    }

    public long txnLastUpdateTimestamp() {
        return this.txnLastUpdateTimestamp;
    }

    public void txnLastUpdateTimestamp_$eq(long x$1) {
        this.txnLastUpdateTimestamp = x$1;
    }

    public Option<TransactionState> pendingState() {
        return this.pendingState;
    }

    public void pendingState_$eq(Option<TransactionState> x$1) {
        this.pendingState = x$1;
    }

    public boolean hasFailedEpochFence() {
        return this.hasFailedEpochFence;
    }

    public void hasFailedEpochFence_$eq(boolean x$1) {
        this.hasFailedEpochFence = x$1;
    }

    public ReentrantLock lock() {
        return this.lock;
    }

    public <T> T inLock(Function0<T> fun) {
        Object object;
        ReentrantLock inLock_lock = this.lock();
        inLock_lock.lock();
        try {
            object = fun.apply();
        }
        finally {
            inLock_lock.unlock();
        }
        return (T)object;
    }

    public void addPartitions(Set<TopicPartition> partitions) {
        this.topicPartitions().$plus$plus$eq(partitions);
    }

    public void removePartition(TopicPartition topicPartition) {
        TransactionState transactionState = this.state();
        PrepareCommit$ prepareCommit$ = PrepareCommit$.MODULE$;
        if (transactionState == null || !transactionState.equals(prepareCommit$)) {
            TransactionState transactionState2 = this.state();
            PrepareAbort$ prepareAbort$ = PrepareAbort$.MODULE$;
            if (transactionState2 == null || !transactionState2.equals(prepareAbort$)) {
                throw new IllegalStateException(new StringBuilder(0).append(new StringBuilder(68).append("Transaction metadata's current state is ").append(this.state()).append(", and its pending state is ").append(this.pendingState()).append(" ").toString()).append("while trying to remove partitions whose txn marker has been sent, this is not expected").toString());
            }
        }
        this.topicPartitions().$minus$eq((Object)topicPartition);
    }

    public TxnTransitMetadata prepareNoTransit() {
        return new TxnTransitMetadata(this.producerId(), this.lastProducerId(), this.producerEpoch(), this.lastProducerEpoch(), this.txnTimeoutMs(), this.state(), (scala.collection.immutable.Set<TopicPartition>)this.topicPartitions().toSet(), this.txnStartTimestamp(), this.txnLastUpdateTimestamp());
    }

    public TxnTransitMetadata prepareFenceProducerEpoch() {
        if (this.producerEpoch() == Short.MAX_VALUE) {
            throw new IllegalStateException("Cannot fence producer with epoch equal to Short.MaxValue since this would overflow");
        }
        short bumpedEpoch = this.hasFailedEpochFence() ? this.producerEpoch() : (short)(this.producerEpoch() + 1);
        return this.prepareTransitionTo(PrepareEpochFence$.MODULE$, this.producerId(), bumpedEpoch, (short)-1, this.txnTimeoutMs(), (scala.collection.immutable.Set<TopicPartition>)this.topicPartitions().toSet(), this.txnStartTimestamp(), this.txnLastUpdateTimestamp());
    }

    public Either<Errors, TxnTransitMetadata> prepareIncrementProducerEpoch(int newTxnTimeoutMs, Option<Object> expectedProducerEpoch, long updateTimestamp) {
        Left left;
        Tuple2 tuple2;
        Right right;
        if (this.isProducerEpochExhausted()) {
            throw new IllegalStateException(new StringBuilder(56).append("Cannot allocate any more producer epochs for producerId ").append(this.producerId()).toString());
        }
        short bumpedEpoch = (short)(this.producerEpoch() + 1);
        if (None$.MODULE$.equals(expectedProducerEpoch)) {
            right = package$.MODULE$.Right().apply((Object)new Tuple2((Object)BoxesRunTime.boxToShort((short)bumpedEpoch), (Object)BoxesRunTime.boxToShort((short)-1)));
        } else if (expectedProducerEpoch instanceof Some) {
            Right right2;
            short expectedEpoch = BoxesRunTime.unboxToShort((Object)((Some)expectedProducerEpoch).value());
            if (this.producerEpoch() == -1 || expectedEpoch == this.producerEpoch()) {
                right2 = package$.MODULE$.Right().apply((Object)new Tuple2((Object)BoxesRunTime.boxToShort((short)bumpedEpoch), (Object)BoxesRunTime.boxToShort((short)this.producerEpoch())));
            } else if (expectedEpoch == this.lastProducerEpoch()) {
                right2 = package$.MODULE$.Right().apply((Object)new Tuple2((Object)BoxesRunTime.boxToShort((short)this.producerEpoch()), (Object)BoxesRunTime.boxToShort((short)this.lastProducerEpoch())));
            } else {
                this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(48).append("Expected producer epoch ").append(expectedEpoch).append(" does not match current ").toString()).append(new StringBuilder(43).append("producer epoch ").append(this.producerEpoch()).append(" or previous producer epoch ").append(this.lastProducerEpoch()).toString()).toString());
                right2 = package$.MODULE$.Left().apply((Object)Errors.PRODUCER_FENCED);
            }
            right = right2;
        } else {
            throw new MatchError(expectedProducerEpoch);
        }
        if (right instanceof Right && (tuple2 = (Tuple2)right.value()) != null) {
            short nextEpoch = BoxesRunTime.unboxToShort((Object)tuple2._1());
            short lastEpoch = BoxesRunTime.unboxToShort((Object)tuple2._2());
            left = package$.MODULE$.Right().apply((Object)this.prepareTransitionTo(Empty$.MODULE$, this.producerId(), nextEpoch, lastEpoch, newTxnTimeoutMs, (scala.collection.immutable.Set<TopicPartition>)Set$.MODULE$.empty(), -1L, updateTimestamp));
        } else if (right instanceof Left) {
            Errors err = (Errors)((Left)right).value();
            left = package$.MODULE$.Left().apply((Object)err);
        } else {
            throw new MatchError((Object)right);
        }
        return left;
    }

    public TxnTransitMetadata prepareProducerIdRotation(long newProducerId, int newTxnTimeoutMs, long updateTimestamp, boolean recordLastEpoch) {
        if (this.hasPendingTransaction()) {
            throw new IllegalStateException("Cannot rotate producer ids while a transaction is still pending");
        }
        return this.prepareTransitionTo(Empty$.MODULE$, newProducerId, (short)0, recordLastEpoch ? (short)this.producerEpoch() : (short)-1, newTxnTimeoutMs, (scala.collection.immutable.Set<TopicPartition>)Set$.MODULE$.empty(), -1L, updateTimestamp);
    }

    public TxnTransitMetadata prepareAddPartitions(scala.collection.immutable.Set<TopicPartition> addedTopicPartitions, long updateTimestamp) {
        TransactionState transactionState = this.state();
        boolean bl = Empty$.MODULE$.equals(transactionState) ? true : (CompleteAbort$.MODULE$.equals(transactionState) ? true : CompleteCommit$.MODULE$.equals(transactionState));
        long l = bl ? updateTimestamp : this.txnStartTimestamp();
        return this.prepareTransitionTo(Ongoing$.MODULE$, this.producerId(), this.producerEpoch(), this.lastProducerEpoch(), this.txnTimeoutMs(), (scala.collection.immutable.Set<TopicPartition>)this.topicPartitions().$plus$plus(addedTopicPartitions).toSet(), l, updateTimestamp);
    }

    public TxnTransitMetadata prepareAbortOrCommit(TransactionState newState, long updateTimestamp) {
        return this.prepareTransitionTo(newState, this.producerId(), this.producerEpoch(), this.lastProducerEpoch(), this.txnTimeoutMs(), (scala.collection.immutable.Set<TopicPartition>)this.topicPartitions().toSet(), this.txnStartTimestamp(), updateTimestamp);
    }

    public TxnTransitMetadata prepareComplete(long updateTimestamp) {
        TransactionState transactionState = this.state();
        PrepareCommit$ prepareCommit$ = PrepareCommit$.MODULE$;
        CompleteAbort$ newState = transactionState != null && transactionState.equals(prepareCommit$) ? CompleteCommit$.MODULE$ : CompleteAbort$.MODULE$;
        this.hasFailedEpochFence_$eq(false);
        return this.prepareTransitionTo(newState, this.producerId(), this.producerEpoch(), this.lastProducerEpoch(), this.txnTimeoutMs(), (scala.collection.immutable.Set<TopicPartition>)Predef$.MODULE$.Set().empty(), this.txnStartTimestamp(), updateTimestamp);
    }

    public TxnTransitMetadata prepareDead() {
        return this.prepareTransitionTo(Dead$.MODULE$, this.producerId(), this.producerEpoch(), this.lastProducerEpoch(), this.txnTimeoutMs(), (scala.collection.immutable.Set<TopicPartition>)Predef$.MODULE$.Set().empty(), this.txnStartTimestamp(), this.txnLastUpdateTimestamp());
    }

    public boolean isProducerEpochExhausted() {
        return TransactionMetadata$.MODULE$.isEpochExhausted(this.producerEpoch());
    }

    private boolean hasPendingTransaction() {
        TransactionState transactionState = this.state();
        boolean bl = Ongoing$.MODULE$.equals(transactionState) ? true : (PrepareAbort$.MODULE$.equals(transactionState) ? true : PrepareCommit$.MODULE$.equals(transactionState));
        boolean bl2 = bl;
        return bl2;
    }

    private TxnTransitMetadata prepareTransitionTo(TransactionState newState, long newProducerId, short newEpoch, short newLastEpoch, int newTxnTimeoutMs, scala.collection.immutable.Set<TopicPartition> newTopicPartitions, long newTxnStartTimestamp, long updateTimestamp) {
        if (this.pendingState().isDefined()) {
            throw new IllegalStateException(new StringBuilder(0).append(new StringBuilder(43).append("Preparing transaction state transition to ").append(newState).append(" ").toString()).append(new StringBuilder(33).append("while it already a pending state ").append(this.pendingState().get()).toString()).toString());
        }
        if (newProducerId < 0L) {
            throw new IllegalArgumentException(new StringBuilder(24).append("Illegal new producer id ").append(newProducerId).toString());
        }
        if (newEpoch < 0) {
            throw new IllegalArgumentException(new StringBuilder(27).append("Illegal new producer epoch ").append(newEpoch).toString());
        }
        if (newState.validPreviousStates().contains((Object)this.state())) {
            TxnTransitMetadata transitMetadata = new TxnTransitMetadata(newProducerId, this.producerId(), newEpoch, newLastEpoch, newTxnTimeoutMs, newState, newTopicPartitions, newTxnStartTimestamp, updateTimestamp);
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(45).append("TransactionalId ").append(this.transactionalId()).append(" prepare transition from ").append(this.state()).append(" to ").append(transitMetadata).toString());
            this.pendingState_$eq((Option<TransactionState>)new Some((Object)newState));
            return transitMetadata;
        }
        throw new IllegalStateException(new StringBuilder(0).append(new StringBuilder(72).append("Preparing transaction state transition to ").append(newState).append(" failed since the target state").toString()).append(new StringBuilder(53).append(" ").append(newState).append(" is not a valid previous state of the current state ").append(this.state()).toString()).toString());
    }

    public void completeTransitionTo(TxnTransitMetadata transitMetadata) {
        TransactionState toState;
        TransactionState transactionState = toState = (TransactionState)this.pendingState().getOrElse((Function0 & Serializable)() -> {
            this.fatal((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(82).append(this).append("'s transition to ").append(transitMetadata).append(" failed since pendingState is not defined: this should not happen").toString());
            throw new IllegalStateException(new StringBuilder(78).append(new StringBuilder(17).append("TransactionalId ").append(this.transactionalId()).append(" ").toString()).append("completing transaction state transition while it does not have a pending state").toString());
        });
        TransactionState transactionState2 = transitMetadata.txnState();
        if (transactionState == null ? transactionState2 != null : !transactionState.equals(transactionState2)) {
            this.throwStateTransitionFailure(transitMetadata);
            return;
        }
        if (Empty$.MODULE$.equals(toState)) {
            if (this.producerEpoch() != transitMetadata.producerEpoch() && !this.validProducerEpochBump(transitMetadata) || transitMetadata.topicPartitions().nonEmpty() || transitMetadata.txnStartTimestamp() != -1L) {
                this.throwStateTransitionFailure(transitMetadata);
            } else {
                this.txnTimeoutMs_$eq(transitMetadata.txnTimeoutMs());
                this.producerEpoch_$eq(transitMetadata.producerEpoch());
                this.lastProducerEpoch_$eq(transitMetadata.lastProducerEpoch());
                this.producerId_$eq(transitMetadata.producerId());
                this.lastProducerId_$eq(transitMetadata.lastProducerId());
            }
        } else if (Ongoing$.MODULE$.equals(toState)) {
            if (!this.validProducerEpoch(transitMetadata) || !this.topicPartitions().subsetOf(transitMetadata.topicPartitions()) || this.txnTimeoutMs() != transitMetadata.txnTimeoutMs()) {
                this.throwStateTransitionFailure(transitMetadata);
            } else {
                this.txnStartTimestamp_$eq(transitMetadata.txnStartTimestamp());
                this.addPartitions((Set<TopicPartition>)transitMetadata.topicPartitions());
            }
        } else {
            boolean bl = PrepareAbort$.MODULE$.equals(toState) ? true : PrepareCommit$.MODULE$.equals(toState);
            if (bl) {
                if (!this.validProducerEpoch(transitMetadata) || !this.topicPartitions().toSet().equals(transitMetadata.topicPartitions()) || this.txnTimeoutMs() != transitMetadata.txnTimeoutMs() || this.txnStartTimestamp() != transitMetadata.txnStartTimestamp()) {
                    this.throwStateTransitionFailure(transitMetadata);
                }
            } else {
                boolean bl2 = CompleteAbort$.MODULE$.equals(toState) ? true : CompleteCommit$.MODULE$.equals(toState);
                if (bl2) {
                    if (!this.validProducerEpoch(transitMetadata) || this.txnTimeoutMs() != transitMetadata.txnTimeoutMs() || transitMetadata.txnStartTimestamp() == -1L) {
                        this.throwStateTransitionFailure(transitMetadata);
                    } else {
                        this.txnStartTimestamp_$eq(transitMetadata.txnStartTimestamp());
                        this.topicPartitions().clear();
                    }
                } else if (PrepareEpochFence$.MODULE$.equals(toState)) {
                    this.throwStateTransitionFailure(transitMetadata);
                } else {
                    if (Dead$.MODULE$.equals(toState)) {
                        throw new IllegalStateException(new StringBuilder(0).append(new StringBuilder(55).append("TransactionalId ").append(this.transactionalId()).append(" is trying to complete a transition to ").toString()).append(new StringBuilder(95).append(toState).append(". This means that the transactionalId was being expired, and the only acceptable completion of ").toString()).append(new StringBuilder(100).append("this operation is to remove the transaction metadata from the cache, not to persist the ").append(toState).append(" in the log.").toString()).toString());
                    }
                    throw new MatchError((Object)toState);
                }
            }
        }
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(46).append("TransactionalId ").append(this.transactionalId()).append(" complete transition from ").append(this.state()).append(" to ").append(transitMetadata).toString());
        this.txnLastUpdateTimestamp_$eq(transitMetadata.txnLastUpdateTimestamp());
        this.pendingState_$eq((Option<TransactionState>)None$.MODULE$);
        this.state_$eq(toState);
    }

    private boolean validProducerEpoch(TxnTransitMetadata transitMetadata) {
        short transitEpoch = transitMetadata.producerEpoch();
        long transitProducerId = transitMetadata.producerId();
        return transitEpoch == this.producerEpoch() && transitProducerId == this.producerId();
    }

    private boolean validProducerEpochBump(TxnTransitMetadata transitMetadata) {
        short transitEpoch = transitMetadata.producerEpoch();
        long transitProducerId = transitMetadata.producerId();
        return transitEpoch == this.producerEpoch() + 1 || transitEpoch == 0 && transitProducerId != this.producerId();
    }

    private void throwStateTransitionFailure(TxnTransitMetadata txnTransitMetadata) {
        this.fatal((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(48).append(this.toString()).append("'s transition to ").append(txnTransitMetadata).append(" failed: this should not happen").toString());
        throw new IllegalStateException(new StringBuilder(26).append(new StringBuilder(45).append("TransactionalId ").append(this.transactionalId()).append(" failed transition to state ").append(txnTransitMetadata).append(" ").toString()).append("due to unexpected metadata").toString());
    }

    public boolean pendingTransitionInProgress() {
        return this.pendingState().isDefined();
    }

    public String toString() {
        return new StringBuilder(20).append("TransactionMetadata(").append(new StringBuilder(18).append("transactionalId=").append(this.transactionalId()).append(", ").toString()).append(new StringBuilder(13).append("producerId=").append(this.producerId()).append(", ").toString()).append(new StringBuilder(16).append("producerEpoch=").append(this.producerEpoch()).append(", ").toString()).append(new StringBuilder(15).append("txnTimeoutMs=").append(this.txnTimeoutMs()).append(", ").toString()).append(new StringBuilder(8).append("state=").append(this.state()).append(", ").toString()).append(new StringBuilder(15).append("pendingState=").append(this.pendingState()).append(", ").toString()).append(new StringBuilder(18).append("topicPartitions=").append(this.topicPartitions()).append(", ").toString()).append(new StringBuilder(20).append("txnStartTimestamp=").append(this.txnStartTimestamp()).append(", ").toString()).append(new StringBuilder(24).append("txnLastUpdateTimestamp=").append(this.txnLastUpdateTimestamp()).append(")").toString()).toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object that) {
        if (!(that instanceof TransactionMetadata)) return false;
        TransactionMetadata transactionMetadata = (TransactionMetadata)that;
        String string = this.transactionalId();
        String string2 = transactionMetadata.transactionalId();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (this.producerId() != transactionMetadata.producerId()) return false;
        if (this.producerEpoch() != transactionMetadata.producerEpoch()) return false;
        if (this.lastProducerEpoch() != transactionMetadata.lastProducerEpoch()) return false;
        if (this.txnTimeoutMs() != transactionMetadata.txnTimeoutMs()) return false;
        if (!this.state().equals(transactionMetadata.state())) return false;
        if (!this.topicPartitions().equals(transactionMetadata.topicPartitions())) return false;
        if (this.txnStartTimestamp() != transactionMetadata.txnStartTimestamp()) return false;
        if (this.txnLastUpdateTimestamp() != transactionMetadata.txnLastUpdateTimestamp()) return false;
        return true;
    }

    public int hashCode() {
        return BoxesRunTime.unboxToInt((Object)((IterableOnceOps)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.transactionalId(), BoxesRunTime.boxToLong((long)this.producerId()), BoxesRunTime.boxToShort((short)this.producerEpoch()), BoxesRunTime.boxToInteger((int)this.txnTimeoutMs()), this.state(), this.topicPartitions(), BoxesRunTime.boxToLong((long)this.txnStartTimestamp()), BoxesRunTime.boxToLong((long)this.txnLastUpdateTimestamp())}))).map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.hashCode()))).foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2)(JFunction2.mcIII.sp & Serializable)(a, b) -> 31 * a + b));
    }

    public TransactionMetadata(String transactionalId, long producerId, long lastProducerId, short producerEpoch, short lastProducerEpoch, int txnTimeoutMs, TransactionState state, scala.collection.mutable.Set<TopicPartition> topicPartitions, long txnStartTimestamp, long txnLastUpdateTimestamp) {
        this.transactionalId = transactionalId;
        this.producerId = producerId;
        this.lastProducerId = lastProducerId;
        this.producerEpoch = producerEpoch;
        this.lastProducerEpoch = lastProducerEpoch;
        this.txnTimeoutMs = txnTimeoutMs;
        this.state = state;
        this.topicPartitions = topicPartitions;
        this.txnStartTimestamp = txnStartTimestamp;
        this.txnLastUpdateTimestamp = txnLastUpdateTimestamp;
        this.pendingState = None$.MODULE$;
        this.hasFailedEpochFence = false;
        this.lock = new ReentrantLock();
    }
}

