/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.File;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.List;
import java.util.Properties;
import kafka.tools.TerseFailure;
import kafka.utils.Exit$;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentType;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import net.sourceforge.argparse4j.inf.Subparsers;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.QuorumInfo;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.util.ToolsUtils;
import scala.Console$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class MetadataQuorumCommand$ {
    public static final MetadataQuorumCommand$ MODULE$ = new MetadataQuorumCommand$();

    public void main(String[] args) {
        int res = this.mainNoExit(args);
        throw Exit$.MODULE$.exit(res, (Option<String>)None$.MODULE$);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int mainNoExit(String[] args) {
        ArgumentParser parser = ArgumentParsers.newArgumentParser((String)"kafka-metadata-quorum").defaultHelp(true).description("This tool describes kraft metadata quorum status.");
        parser.addArgument(new String[]{"--bootstrap-server"}).help("A comma-separated list of host:port pairs to use for establishing the connection to the Kafka cluster.").required(true);
        parser.addArgument(new String[]{"--command-config"}).type((ArgumentType)Arguments.fileType()).help("Property file containing configs to be passed to Admin Client.");
        Subparsers subparsers = parser.addSubparsers().dest("command");
        this.addDescribeParser(subparsers);
        try (Admin admin = null;){
            int n;
            try {
                Properties properties;
                Namespace namespace = parser.parseArgsOrFail(args);
                String command = namespace.getString("command");
                File commandConfig = (File)namespace.get("command_config");
                if (commandConfig != null) {
                    if (!commandConfig.exists()) {
                        throw new TerseFailure(new StringBuilder(33).append("Properties file ").append(commandConfig.getPath()).append(" does not exists!").toString());
                    }
                    properties = Utils.loadProps((String)commandConfig.getPath(), null);
                } else {
                    properties = new Properties();
                }
                Properties props = properties;
                props.put("bootstrap.servers", namespace.getString("bootstrap_server"));
                admin = Admin.create((Properties)props);
                String string = command;
                String string2 = "describe";
                if (string == null || !string.equals(string2)) throw new IllegalStateException(new StringBuilder(47).append("Unknown command: ").append(command).append(", only 'describe' is supported").toString());
                if (Predef$.MODULE$.Boolean2boolean(namespace.getBoolean("status")) && Predef$.MODULE$.Boolean2boolean(namespace.getBoolean("replication"))) {
                    throw new TerseFailure("Only one of --status or --replication should be specified with describe sub-command");
                }
                if (Predef$.MODULE$.Boolean2boolean(namespace.getBoolean("replication"))) {
                    this.handleDescribeReplication(admin);
                } else {
                    if (!Predef$.MODULE$.Boolean2boolean(namespace.getBoolean("status"))) throw new TerseFailure("One of --status or --replication must be specified with describe sub-command");
                    this.handleDescribeStatus(admin);
                }
                n = 0;
                return n;
            }
            catch (TerseFailure e) {
                Console$.MODULE$.err().println(e.getMessage());
                n = 1;
            }
            return n;
        }
    }

    public void addDescribeParser(Subparsers subparsers) {
        Subparser describeParser = subparsers.addParser("describe").help("Describe the metadata quorum info");
        describeParser.addArgumentGroup("Status").addArgument(new String[]{"--status"}).help("A short summary of the quorum status and the other provides detailed information about the status of replication.").action((ArgumentAction)Arguments.storeTrue());
        describeParser.addArgumentGroup("Replication").addArgument(new String[]{"--replication"}).help("Detailed information about the status of replication").action((ArgumentAction)Arguments.storeTrue());
    }

    private void handleDescribeReplication(Admin admin) {
        QuorumInfo quorumInfo = (QuorumInfo)admin.describeMetadataQuorum().quorumInfo().get();
        int leaderId = quorumInfo.leaderId();
        QuorumInfo.ReplicaState leader = (QuorumInfo.ReplicaState)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(quorumInfo.voters()).asScala().filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)MetadataQuorumCommand$.$anonfun$handleDescribeReplication$1(leaderId, x$1)))).head();
        ToolsUtils.prettyPrintTable((String[])new String[]{"NodeId", "LogEndOffset", "Lag", "LastFetchTimestamp", "LastCaughtUpTimestamp", "Status"}, (List)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOps)MetadataQuorumCommand$.convertQuorumInfo$1((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new QuorumInfo.ReplicaState[]{leader})), "Leader", leader).$plus$plus((IterableOnce)MetadataQuorumCommand$.convertQuorumInfo$1(((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(quorumInfo.voters()).asScala().filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)MetadataQuorumCommand$.$anonfun$handleDescribeReplication$4(leaderId, x$3)))).toSeq(), "Follower", leader))).$plus$plus((IterableOnce)MetadataQuorumCommand$.convertQuorumInfo$1(CollectionConverters$.MODULE$.ListHasAsScala(quorumInfo.observers()).asScala().toSeq(), "Observer", leader))).asJava(), (PrintStream)Console$.MODULE$.out());
    }

    private void handleDescribeStatus(Admin admin) {
        String clusterId = (String)admin.describeCluster().clusterId().get();
        QuorumInfo quorumInfo = (QuorumInfo)admin.describeMetadataQuorum().quorumInfo().get();
        int leaderId = quorumInfo.leaderId();
        QuorumInfo.ReplicaState leader = (QuorumInfo.ReplicaState)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(quorumInfo.voters()).asScala().filter((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)MetadataQuorumCommand$.$anonfun$handleDescribeStatus$1(leaderId, x$4)))).head();
        QuorumInfo.ReplicaState maxLagFollower = (QuorumInfo.ReplicaState)CollectionConverters$.MODULE$.ListHasAsScala(quorumInfo.voters()).asScala().minBy((Function1 & Serializable)x$5 -> BoxesRunTime.boxToLong((long)x$5.logEndOffset()), (Ordering)Ordering.Long$.MODULE$);
        long maxFollowerLag = leader.logEndOffset() - maxLagFollower.logEndOffset();
        long maxFollowerLagTimeMs = leader.equals(maxLagFollower) ? 0L : (leader.lastCaughtUpTimestamp().isPresent() && maxLagFollower.lastCaughtUpTimestamp().isPresent() ? leader.lastCaughtUpTimestamp().getAsLong() - maxLagFollower.lastCaughtUpTimestamp().getAsLong() : -1L);
        Predef$.MODULE$.println((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(289).append("|ClusterId:              ").append(clusterId).append("\n          |LeaderId:               ").append(quorumInfo.leaderId()).append("\n          |LeaderEpoch:            ").append(quorumInfo.leaderEpoch()).append("\n          |HighWatermark:          ").append(quorumInfo.highWatermark()).append("\n          |MaxFollowerLag:         ").append(maxFollowerLag).append("\n          |MaxFollowerLagTimeMs:   ").append(maxFollowerLagTimeMs).append("\n          |CurrentVoters:          ").append(((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(quorumInfo.voters()).asScala().map((Function1 & Serializable)x$6 -> BoxesRunTime.boxToInteger((int)x$6.replicaId()))).mkString("[", ",", "]")).append("\n          |CurrentObservers:       ").append(((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(quorumInfo.observers()).asScala().map((Function1 & Serializable)x$7 -> BoxesRunTime.boxToInteger((int)x$7.replicaId()))).mkString("[", ",", "]")).append("\n          |").toString())));
    }

    public static final /* synthetic */ boolean $anonfun$handleDescribeReplication$1(int leaderId$1, QuorumInfo.ReplicaState x$1) {
        return x$1.replicaId() == leaderId$1;
    }

    private static final scala.collection.immutable.Seq convertQuorumInfo$1(scala.collection.immutable.Seq infos, String status, QuorumInfo.ReplicaState leader$1) {
        return (scala.collection.immutable.Seq)infos.map((Function1 & Serializable)info -> (String[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.genericArrayOps((Object)new Object[]{BoxesRunTime.boxToInteger((int)info.replicaId()), BoxesRunTime.boxToLong((long)info.logEndOffset()), BoxesRunTime.boxToLong((long)(leader$1.logEndOffset() - info.logEndOffset())), BoxesRunTime.boxToLong((long)info.lastFetchTimestamp().orElse(-1L)), BoxesRunTime.boxToLong((long)info.lastCaughtUpTimestamp().orElse(-1L)), status}), (Function1 & Serializable)x$2 -> x$2.toString(), ClassTag$.MODULE$.apply(String.class)));
    }

    public static final /* synthetic */ boolean $anonfun$handleDescribeReplication$4(int leaderId$1, QuorumInfo.ReplicaState x$3) {
        return x$3.replicaId() != leaderId$1;
    }

    public static final /* synthetic */ boolean $anonfun$handleDescribeStatus$1(int leaderId$2, QuorumInfo.ReplicaState x$4) {
        return x$4.replicaId() == leaderId$2;
    }

    private MetadataQuorumCommand$() {
    }
}

