/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.stream.Stream;
import kafka.server.MetadataCache;
import kafka.server.MetadataCacheTest$;
import kafka.server.metadata.KRaftMetadataCache;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.MetadataResponseData;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.metadata.BrokerRegistrationChangeRecord;
import org.apache.kafka.common.metadata.RegisterBrokerRecord;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.UpdateMetadataRequest;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005Ew!\u0002\f\u0018\u0011\u0003ab!\u0002\u0010\u0018\u0011\u0003y\u0002\"\u0002\u0014\u0002\t\u00039\u0003\"\u0002\u0015\u0002\t\u0003I\u0003\"B\u001c\u0002\t\u0003I\u0003\"\u0002\u001d\u0002\t\u0003Id\u0001\u0002\u0010\u0018\u00019CQA\n\u0004\u0005\u0002=Cq!\u0015\u0004C\u0002\u0013\u0005!\u000b\u0003\u0004W\r\u0001\u0006Ia\u0015\u0005\u0006/\u001a!\t\u0001\u0017\u0005\u0006_\u001a!\t\u0001\u001d\u0005\u0006k\u001a!\tA\u001e\u0005\u0006w\u001a!\t\u0001 \u0005\b\u0003\u00071A\u0011BA\u0003\u0011\u001d\tiH\u0002C\u0001\u0003\u007fBq!!#\u0007\t\u0003\tY\tC\u0004\u0002\u0016\u001a!\t!a&\t\u000f\u0005\u0005f\u0001\"\u0001\u0002$\"9\u0011Q\u0016\u0004\u0005\u0002\u0005=\u0006bBA^\r\u0011\u0005\u0011Q\u0018\u0005\b\u0003\u001b4A\u0011AA_\u0003EiU\r^1eCR\f7)Y2iKR+7\u000f\u001e\u0006\u00031e\taa]3sm\u0016\u0014(\"\u0001\u000e\u0002\u000b-\fgm[1\u0004\u0001A\u0011Q$A\u0007\u0002/\t\tR*\u001a;bI\u0006$\u0018mQ1dQ\u0016$Vm\u001d;\u0014\u0005\u0005\u0001\u0003CA\u0011%\u001b\u0005\u0011#\"A\u0012\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0015\u0012#AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u00029\u0005y!p[\"bG\",\u0007K]8wS\u0012,'\u000fF\u0001+!\rY#\u0007N\u0007\u0002Y)\u0011QFL\u0001\u0007gR\u0014X-Y7\u000b\u0005=\u0002\u0014\u0001B;uS2T\u0011!M\u0001\u0005U\u00064\u0018-\u0003\u00024Y\t11\u000b\u001e:fC6\u0004\"!H\u001b\n\u0005Y:\"!D'fi\u0006$\u0017\r^1DC\u000eDW-A\u0007dC\u000eDW\r\u0015:pm&$WM]\u0001\fkB$\u0017\r^3DC\u000eDW\rF\u0002;{}\u0002\"!I\u001e\n\u0005q\u0012#\u0001B+oSRDQAP\u0003A\u0002Q\nQaY1dQ\u0016DQ\u0001Q\u0003A\u0002\u0005\u000bqA]3rk\u0016\u001cH\u000f\u0005\u0002C\u00196\t1I\u0003\u0002E\u000b\u0006A!/Z9vKN$8O\u0003\u0002G\u000f\u000611m\\7n_:T!A\u0007%\u000b\u0005%S\u0015AB1qC\u000eDWMC\u0001L\u0003\ry'oZ\u0005\u0003\u001b\u000e\u0013Q#\u00169eCR,W*\u001a;bI\u0006$\u0018MU3rk\u0016\u001cHo\u0005\u0002\u0007AQ\t\u0001\u000b\u0005\u0002\u001e\r\u0005Y!M]8lKJ,\u0005o\\2i+\u0005\u0019\u0006CA\u0011U\u0013\t)&E\u0001\u0003M_:<\u0017\u0001\u00042s_.,'/\u00129pG\"\u0004\u0013!I4fiR{\u0007/[2NKR\fG-\u0019;b\u001d>tW\t_5ti&tw\rV8qS\u000e\u001cHC\u0001\u001eZ\u0011\u0015q$\u00021\u00015Q\u0011Q1l\u001a5\u0011\u0005q+W\"A/\u000b\u0005y{\u0016\u0001\u00039s_ZLG-\u001a:\u000b\u0005\u0001\f\u0017A\u00029be\u0006l7O\u0003\u0002cG\u00069!.\u001e9ji\u0016\u0014(B\u00013K\u0003\u0015QWO\\5u\u0013\t1WL\u0001\u0007NKRDw\u000eZ*pkJ\u001cW-A\u0003wC2,X\rL\u0001jC\u00059\u0004F\u0001\u0006l!\taW.D\u0001`\u0013\tqwLA\tQCJ\fW.\u001a;fe&TX\r\u001a+fgR\f\u0001cZ3u)>\u0004\u0018nY'fi\u0006$\u0017\r^1\u0015\u0005i\n\b\"\u0002 \f\u0001\u0004!\u0004\u0006B\u0006\\ONd\u0013!\u001b\u0015\u0003\u0017-\f1fZ3u)>\u0004\u0018nY'fi\u0006$\u0017\r^1QCJ$\u0018\u000e^5p]2+\u0017\rZ3s\u001d>$\u0018I^1jY\u0006\u0014G.\u001a\u000b\u0003u]DQA\u0010\u0007A\u0002QBC\u0001D.hs2\n\u0011\u000e\u000b\u0002\rW\u0006)t-\u001a;U_BL7-T3uC\u0012\fG/\u0019)beRLG/[8o\u0019&\u001cH/\u001a8fe:{G/\u0011<bS2\f'\r\\3P]2+\u0017\rZ3s)\tQT\u0010C\u0003?\u001b\u0001\u0007A\u0007\u000b\u0003\u000e7\u001e|H&A5)\u00055Y\u0017\u0001\u000f<fe&4\u0017\u0010V8qS\u000elU\r^1eCR\f\u0007+\u0019:uSRLwN\u001c'fC\u0012,'o\u0014:F]\u0012\u0004x.\u001b8u\u001d>$\u0018I^1jY\u0006\u0014G.\u001a\u000b\u0010u\u0005\u001d\u0011\u0011BA\n\u0003\u001f\ny&a\u0019\u0002t!)aH\u0004a\u0001i!9\u00111\u0002\bA\u0002\u00055\u0011!F7fi\u0006$\u0017\r^1DC\u000eDWM\u0011:pW\u0016\u0014\u0018\n\u001a\t\u0004C\u0005=\u0011bAA\tE\t\u0019\u0011J\u001c;\t\u000f\u0005Ua\u00021\u0001\u0002\u0018\u00059!M]8lKJ\u001c\bCBA\r\u0003?\t\u0019#\u0004\u0002\u0002\u001c)\u0019\u0011Q\u0004\u0012\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002\"\u0005m!aA*fcB!\u0011QEA%\u001d\u0011\t9#a\u0011\u000f\t\u0005%\u0012q\b\b\u0005\u0003W\tiD\u0004\u0003\u0002.\u0005mb\u0002BA\u0018\u0003sqA!!\r\u000285\u0011\u00111\u0007\u0006\u0004\u0003kY\u0012A\u0002\u001fs_>$h(C\u0001L\u0013\tI%*\u0003\u0002\u001b\u0011&\u0011aiR\u0005\u0004\u0003\u0003*\u0015aB7fgN\fw-Z\u0005\u0005\u0003\u000b\n9%A\rVa\u0012\fG/Z'fi\u0006$\u0017\r^1SKF,Xm\u001d;ECR\f'bAA!\u000b&!\u00111JA'\u0005Q)\u0006\u000fZ1uK6+G/\u00193bi\u0006\u0014%o\\6fe*!\u0011QIA$\u0011\u001d\t\tF\u0004a\u0001\u0003'\nA\u0002\\5ti\u0016tWM\u001d(b[\u0016\u0004B!!\u0016\u0002\\5\u0011\u0011q\u000b\u0006\u0004\u00033*\u0015a\u00028fi^|'o[\u0005\u0005\u0003;\n9F\u0001\u0007MSN$XM\\3s\u001d\u0006lW\rC\u0004\u0002b9\u0001\r!!\u0004\u0002\r1,\u0017\rZ3s\u0011\u001d\t)G\u0004a\u0001\u0003O\nQ\"\u001a=qK\u000e$X\rZ#se>\u0014\b\u0003BA5\u0003_j!!a\u001b\u000b\u0007\u00055T)\u0001\u0005qe>$xnY8m\u0013\u0011\t\t(a\u001b\u0003\r\u0015\u0013(o\u001c:t\u0011\u001d\t)H\u0004a\u0001\u0003o\n\u0011$\u001a:s_J,f.\u0019<bS2\f'\r\\3MSN$XM\\3sgB\u0019\u0011%!\u001f\n\u0007\u0005m$EA\u0004C_>dW-\u00198\u0002G\u001d,G\u000fV8qS\u000elU\r^1eCR\f'+\u001a9mS\u000e\fgj\u001c;Bm\u0006LG.\u00192mKR\u0019!(!!\t\u000byz\u0001\u0019\u0001\u001b)\u000b=Yv-!\"-\u0003%D#aD6\u0002?\u001d,G\u000fV8qS\u000elU\r^1eCR\f\u0017j\u001d:O_R\fe/Y5mC\ndW\rF\u0002;\u0003\u001bCQA\u0010\tA\u0002QBS\u0001E.h\u0003#c\u0013!\u001b\u0015\u0003!-\f\u0001gZ3u)>\u0004\u0018nY'fi\u0006$\u0017\r^1XSRDgj\u001c8TkB\u0004xN\u001d;fIN+7-\u001e:jif\u0004&o\u001c;pG>dGc\u0001\u001e\u0002\u001a\")a(\u0005a\u0001i!*\u0011cW4\u0002\u001e2\n\u0011\u000e\u000b\u0002\u0012W\u0006qs-\u001a;BY&4XM\u0011:pW\u0016\u00148o\u00155pk2$gj\u001c;CK6+H/\u0019;fI\nKX\u000b\u001d3bi\u0016\u001c\u0015m\u00195f)\rQ\u0014Q\u0015\u0005\u0006}I\u0001\r\u0001\u000e\u0015\u0006%m;\u0017\u0011\u0016\u0017\u0002S\"\u0012!c[\u0001*i\u0016\u001cHoR3u\u00072,8\u000f^3s\u001b\u0016$\u0018\rZ1uC^KG\u000f[(gM2Lg.\u001a*fa2L7-Y:\u0015\u0007i\n\t\fC\u0003?'\u0001\u0007A\u0007K\u0003\u00147\u001e\f)\f\f\u0002\u00028\u0006\n\u0001\u0006\u000b\u0002\u0014W\u0006\u0011B/Z:u\u0013N\u0014%o\\6fe\u001a+gnY3e)\u0005Q\u0004f\u0001\u000b\u0002BB!\u00111YAe\u001b\t\t)MC\u0002\u0002H\u0006\f1!\u00199j\u0013\u0011\tY-!2\u0003\tQ+7\u000f^\u0001!i\u0016\u001cH/S:Ce>\\WM]%o\u0007>tGO]8mY\u0016$7\u000b[;uI><h\u000eK\u0002\u0016\u0003\u0003\u0004")
public class MetadataCacheTest {
    private final long brokerEpoch;

    public static void updateCache(MetadataCache cache, UpdateMetadataRequest request) {
        MetadataCacheTest$.MODULE$.updateCache(cache, request);
    }

    public static Stream<MetadataCache> cacheProvider() {
        return MetadataCacheTest$.MODULE$.cacheProvider();
    }

    public static Stream<MetadataCache> zkCacheProvider() {
        return MetadataCacheTest$.MODULE$.zkCacheProvider();
    }

    public long brokerEpoch() {
        return this.brokerEpoch;
    }

    @ParameterizedTest
    @MethodSource(value={"cacheProvider"})
    public void getTopicMetadataNonExistingTopics(MetadataCache cache) {
        String topic = "topic";
        Assertions.assertTrue((boolean)cache.getTopicMetadata((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic})), ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT), cache.getTopicMetadata$default$3(), cache.getTopicMetadata$default$4()).isEmpty());
    }

    @ParameterizedTest
    @MethodSource(value={"cacheProvider"})
    public void getTopicMetadata(MetadataCache cache) {
        String topic0 = "topic-0";
        String topic1 = "topic-1";
        int zkVersion = 3;
        int controllerId = 2;
        int controllerEpoch = 1;
        IndexedSeq brokers = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 4).map((Function1 & Serializable)brokerId -> MetadataCacheTest.$anonfun$getTopicMetadata$1(BoxesRunTime.unboxToInt((Object)brokerId)));
        .colon.colon partitionStates = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(topic0).setPartitionIndex(0).setControllerEpoch(controllerEpoch).setLeader(0).setLeaderEpoch(0).setIsr(Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(3))).setZkVersion(zkVersion).setReplicas(Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(3))), (List)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(topic0).setPartitionIndex(1).setControllerEpoch(controllerEpoch).setLeader(1).setLeaderEpoch(1).setIsr(Arrays.asList(Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(0))).setZkVersion(zkVersion).setReplicas(Arrays.asList(Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(4))), (List)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(topic1).setPartitionIndex(0).setControllerEpoch(controllerEpoch).setLeader(2).setLeaderEpoch(2).setIsr(Arrays.asList(Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(1))).setZkVersion(zkVersion).setReplicas(Arrays.asList(Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(3))), (List)Nil$.MODULE$)));
        HashMap<String, Uuid> topicIds = new HashMap<String, Uuid>();
        topicIds.put(topic0, Uuid.randomUuid());
        topicIds.put(topic1, Uuid.randomUuid());
        short version = ApiKeys.UPDATE_METADATA.latestVersion();
        UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(version, controllerId, controllerEpoch, this.brokerEpoch(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)partitionStates).asJava(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)brokers).asJava(), topicIds).build();
        MetadataCacheTest$.MODULE$.updateCache(cache, updateMetadataRequest);
        new .colon.colon((Object)SecurityProtocol.PLAINTEXT, (List)new .colon.colon((Object)SecurityProtocol.SSL, (List)Nil$.MODULE$)).foreach(arg_0 -> MetadataCacheTest.$anonfun$getTopicMetadata$2$adapted(cache, topicIds, (Seq)partitionStates, topic0, topic1, arg_0));
    }

    @ParameterizedTest
    @MethodSource(value={"cacheProvider"})
    public void getTopicMetadataPartitionLeaderNotAvailable(MetadataCache cache) {
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
        .colon.colon brokers = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataBroker().setId(0).setEndpoints(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost("foo").setPort(9092).setSecurityProtocol(securityProtocol.id).setListener(listenerName.value()), (List)Nil$.MODULE$)).asJava()), (List)Nil$.MODULE$);
        int metadataCacheBrokerId = 0;
        this.verifyTopicMetadataPartitionLeaderOrEndpointNotAvailable(cache, metadataCacheBrokerId, (Seq<UpdateMetadataRequestData.UpdateMetadataBroker>)brokers, listenerName, 1, Errors.LEADER_NOT_AVAILABLE, false);
        this.verifyTopicMetadataPartitionLeaderOrEndpointNotAvailable(cache, metadataCacheBrokerId, (Seq<UpdateMetadataRequestData.UpdateMetadataBroker>)brokers, listenerName, 1, Errors.LEADER_NOT_AVAILABLE, true);
    }

    @ParameterizedTest
    @MethodSource(value={"cacheProvider"})
    public void getTopicMetadataPartitionListenerNotAvailableOnLeader(MetadataCache cache) {
        ListenerName plaintextListenerName = ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT);
        ListenerName sslListenerName = ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.SSL);
        .colon.colon broker0Endpoints = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost("host0").setPort(9092).setSecurityProtocol(SecurityProtocol.PLAINTEXT.id).setListener(plaintextListenerName.value()), (List)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost("host0").setPort(9093).setSecurityProtocol(SecurityProtocol.SSL.id).setListener(sslListenerName.value()), (List)Nil$.MODULE$));
        .colon.colon broker1Endpoints = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost("host1").setPort(9092).setSecurityProtocol(SecurityProtocol.PLAINTEXT.id).setListener(plaintextListenerName.value()), (List)Nil$.MODULE$);
        .colon.colon brokers = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataBroker().setId(0).setEndpoints(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)broker0Endpoints).asJava()), (List)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataBroker().setId(1).setEndpoints(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)broker1Endpoints).asJava()), (List)Nil$.MODULE$));
        int metadataCacheBrokerId = 0;
        this.verifyTopicMetadataPartitionLeaderOrEndpointNotAvailable(cache, metadataCacheBrokerId, (Seq<UpdateMetadataRequestData.UpdateMetadataBroker>)brokers, sslListenerName, 1, Errors.LISTENER_NOT_FOUND, true);
        this.verifyTopicMetadataPartitionLeaderOrEndpointNotAvailable(cache, metadataCacheBrokerId, (Seq<UpdateMetadataRequestData.UpdateMetadataBroker>)brokers, sslListenerName, 1, Errors.LEADER_NOT_AVAILABLE, false);
    }

    private void verifyTopicMetadataPartitionLeaderOrEndpointNotAvailable(MetadataCache cache, int metadataCacheBrokerId, Seq<UpdateMetadataRequestData.UpdateMetadataBroker> brokers, ListenerName listenerName, int leader, Errors expectedError, boolean errorUnavailableListeners) {
        String topic = "topic";
        int zkVersion = 3;
        int controllerId = 2;
        int controllerEpoch = 1;
        int leaderEpoch = 1;
        .colon.colon partitionStates = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(topic).setPartitionIndex(0).setControllerEpoch(controllerEpoch).setLeader(leader).setLeaderEpoch(leaderEpoch).setIsr(Arrays.asList(Predef$.MODULE$.int2Integer(0))).setZkVersion(zkVersion).setReplicas(Arrays.asList(Predef$.MODULE$.int2Integer(0))), (List)Nil$.MODULE$);
        short version = ApiKeys.UPDATE_METADATA.latestVersion();
        UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(version, controllerId, controllerEpoch, this.brokerEpoch(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)partitionStates).asJava(), CollectionConverters$.MODULE$.SeqHasAsJava(brokers).asJava(), Collections.emptyMap()).build();
        MetadataCacheTest$.MODULE$.updateCache(cache, updateMetadataRequest);
        scala.collection.immutable.Set x$1 = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic}));
        boolean x$4 = cache.getTopicMetadata$default$3();
        Seq topicMetadatas = cache.getTopicMetadata((Set)x$1, listenerName, x$4, errorUnavailableListeners);
        Assertions.assertEquals((int)1, (int)topicMetadatas.size());
        MetadataResponseData.MetadataResponseTopic topicMetadata = (MetadataResponseData.MetadataResponseTopic)topicMetadatas.head();
        Assertions.assertEquals((short)Errors.NONE.code(), (short)topicMetadata.errorCode());
        java.util.List partitionMetadatas = topicMetadata.partitions();
        Assertions.assertEquals((int)1, (int)partitionMetadatas.size());
        MetadataResponseData.MetadataResponsePartition partitionMetadata = (MetadataResponseData.MetadataResponsePartition)partitionMetadatas.get(0);
        Assertions.assertEquals((int)0, (int)partitionMetadata.partitionIndex());
        Assertions.assertEquals((short)expectedError.code(), (short)partitionMetadata.errorCode());
        Assertions.assertFalse((boolean)partitionMetadata.isrNodes().isEmpty());
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0})), (Object)CollectionConverters$.MODULE$.ListHasAsScala(partitionMetadata.replicaNodes()).asScala());
    }

    @ParameterizedTest
    @MethodSource(value={"cacheProvider"})
    public void getTopicMetadataReplicaNotAvailable(MetadataCache cache) {
        String topic = "topic";
        int zkVersion = 3;
        int controllerId = 2;
        int controllerEpoch = 1;
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
        .colon.colon brokers = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataBroker().setId(0).setEndpoints(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost("foo").setPort(9092).setSecurityProtocol(securityProtocol.id).setListener(listenerName.value()), (List)Nil$.MODULE$)).asJava()), (List)Nil$.MODULE$);
        int leader = 0;
        int leaderEpoch = 0;
        java.util.List<Integer> replicas = Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1));
        java.util.List<Integer> isr = Arrays.asList(Predef$.MODULE$.int2Integer(0));
        .colon.colon partitionStates = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(topic).setPartitionIndex(0).setControllerEpoch(controllerEpoch).setLeader(leader).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(zkVersion).setReplicas(replicas), (List)Nil$.MODULE$);
        short version = ApiKeys.UPDATE_METADATA.latestVersion();
        UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(version, controllerId, controllerEpoch, this.brokerEpoch(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)partitionStates).asJava(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)brokers).asJava(), Collections.emptyMap()).build();
        MetadataCacheTest$.MODULE$.updateCache(cache, updateMetadataRequest);
        Seq topicMetadatas = cache.getTopicMetadata((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic})), listenerName, false, cache.getTopicMetadata$default$4());
        Assertions.assertEquals((int)1, (int)topicMetadatas.size());
        MetadataResponseData.MetadataResponseTopic topicMetadata = (MetadataResponseData.MetadataResponseTopic)topicMetadatas.head();
        Assertions.assertEquals((short)Errors.NONE.code(), (short)topicMetadata.errorCode());
        java.util.List partitionMetadatas = topicMetadata.partitions();
        Assertions.assertEquals((int)1, (int)partitionMetadatas.size());
        MetadataResponseData.MetadataResponsePartition partitionMetadata = (MetadataResponseData.MetadataResponsePartition)partitionMetadatas.get(0);
        Assertions.assertEquals((int)0, (int)partitionMetadata.partitionIndex());
        Assertions.assertEquals((short)Errors.NONE.code(), (short)partitionMetadata.errorCode());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1})), (Object)CollectionConverters$.MODULE$.ListHasAsScala(partitionMetadata.replicaNodes()).asScala().toSet());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0})), (Object)CollectionConverters$.MODULE$.ListHasAsScala(partitionMetadata.isrNodes()).asScala().toSet());
        Seq topicMetadatasWithError = cache.getTopicMetadata((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic})), listenerName, true, cache.getTopicMetadata$default$4());
        Assertions.assertEquals((int)1, (int)topicMetadatasWithError.size());
        MetadataResponseData.MetadataResponseTopic topicMetadataWithError = (MetadataResponseData.MetadataResponseTopic)topicMetadatasWithError.head();
        Assertions.assertEquals((short)Errors.NONE.code(), (short)topicMetadataWithError.errorCode());
        java.util.List partitionMetadatasWithError = topicMetadataWithError.partitions();
        Assertions.assertEquals((int)1, (int)partitionMetadatasWithError.size());
        MetadataResponseData.MetadataResponsePartition partitionMetadataWithError = (MetadataResponseData.MetadataResponsePartition)partitionMetadatasWithError.get(0);
        Assertions.assertEquals((int)0, (int)partitionMetadataWithError.partitionIndex());
        Assertions.assertEquals((short)Errors.REPLICA_NOT_AVAILABLE.code(), (short)partitionMetadataWithError.errorCode());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0})), (Object)CollectionConverters$.MODULE$.ListHasAsScala(partitionMetadataWithError.replicaNodes()).asScala().toSet());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0})), (Object)CollectionConverters$.MODULE$.ListHasAsScala(partitionMetadataWithError.isrNodes()).asScala().toSet());
    }

    @ParameterizedTest
    @MethodSource(value={"cacheProvider"})
    public void getTopicMetadataIsrNotAvailable(MetadataCache cache) {
        String topic = "topic";
        int zkVersion = 3;
        int controllerId = 2;
        int controllerEpoch = 1;
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
        .colon.colon brokers = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataBroker().setId(0).setRack("rack1").setEndpoints(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost("foo").setPort(9092).setSecurityProtocol(securityProtocol.id).setListener(listenerName.value()), (List)Nil$.MODULE$)).asJava()), (List)Nil$.MODULE$);
        int leader = 0;
        int leaderEpoch = 0;
        java.util.List<Integer> replicas = Arrays.asList(Predef$.MODULE$.int2Integer(0));
        java.util.List<Integer> isr = Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1));
        .colon.colon partitionStates = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(topic).setPartitionIndex(0).setControllerEpoch(controllerEpoch).setLeader(leader).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(zkVersion).setReplicas(replicas), (List)Nil$.MODULE$);
        short version = ApiKeys.UPDATE_METADATA.latestVersion();
        UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(version, controllerId, controllerEpoch, this.brokerEpoch(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)partitionStates).asJava(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)brokers).asJava(), Collections.emptyMap()).build();
        MetadataCacheTest$.MODULE$.updateCache(cache, updateMetadataRequest);
        Seq topicMetadatas = cache.getTopicMetadata((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic})), listenerName, false, cache.getTopicMetadata$default$4());
        Assertions.assertEquals((int)1, (int)topicMetadatas.size());
        MetadataResponseData.MetadataResponseTopic topicMetadata = (MetadataResponseData.MetadataResponseTopic)topicMetadatas.head();
        Assertions.assertEquals((short)Errors.NONE.code(), (short)topicMetadata.errorCode());
        java.util.List partitionMetadatas = topicMetadata.partitions();
        Assertions.assertEquals((int)1, (int)partitionMetadatas.size());
        MetadataResponseData.MetadataResponsePartition partitionMetadata = (MetadataResponseData.MetadataResponsePartition)partitionMetadatas.get(0);
        Assertions.assertEquals((int)0, (int)partitionMetadata.partitionIndex());
        Assertions.assertEquals((short)Errors.NONE.code(), (short)partitionMetadata.errorCode());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0})), (Object)CollectionConverters$.MODULE$.ListHasAsScala(partitionMetadata.replicaNodes()).asScala().toSet());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1})), (Object)CollectionConverters$.MODULE$.ListHasAsScala(partitionMetadata.isrNodes()).asScala().toSet());
        Seq topicMetadatasWithError = cache.getTopicMetadata((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic})), listenerName, true, cache.getTopicMetadata$default$4());
        Assertions.assertEquals((int)1, (int)topicMetadatasWithError.size());
        MetadataResponseData.MetadataResponseTopic topicMetadataWithError = (MetadataResponseData.MetadataResponseTopic)topicMetadatasWithError.head();
        Assertions.assertEquals((short)Errors.NONE.code(), (short)topicMetadataWithError.errorCode());
        java.util.List partitionMetadatasWithError = topicMetadataWithError.partitions();
        Assertions.assertEquals((int)1, (int)partitionMetadatasWithError.size());
        MetadataResponseData.MetadataResponsePartition partitionMetadataWithError = (MetadataResponseData.MetadataResponsePartition)partitionMetadatasWithError.get(0);
        Assertions.assertEquals((int)0, (int)partitionMetadataWithError.partitionIndex());
        Assertions.assertEquals((short)Errors.REPLICA_NOT_AVAILABLE.code(), (short)partitionMetadataWithError.errorCode());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0})), (Object)CollectionConverters$.MODULE$.ListHasAsScala(partitionMetadataWithError.replicaNodes()).asScala().toSet());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0})), (Object)CollectionConverters$.MODULE$.ListHasAsScala(partitionMetadataWithError.isrNodes()).asScala().toSet());
    }

    @ParameterizedTest
    @MethodSource(value={"cacheProvider"})
    public void getTopicMetadataWithNonSupportedSecurityProtocol(MetadataCache cache) {
        String topic = "topic";
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        .colon.colon brokers = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataBroker().setId(0).setRack("").setEndpoints(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost("foo").setPort(9092).setSecurityProtocol(securityProtocol.id).setListener(ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol).value()), (List)Nil$.MODULE$)).asJava()), (List)Nil$.MODULE$);
        int controllerEpoch = 1;
        int leader = 0;
        int leaderEpoch = 0;
        java.util.List<Integer> replicas = Arrays.asList(Predef$.MODULE$.int2Integer(0));
        java.util.List<Integer> isr = Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1));
        .colon.colon partitionStates = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(topic).setPartitionIndex(0).setControllerEpoch(controllerEpoch).setLeader(leader).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(3).setReplicas(replicas), (List)Nil$.MODULE$);
        short version = ApiKeys.UPDATE_METADATA.latestVersion();
        UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(version, 2, controllerEpoch, this.brokerEpoch(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)partitionStates).asJava(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)brokers).asJava(), Collections.emptyMap()).build();
        MetadataCacheTest$.MODULE$.updateCache(cache, updateMetadataRequest);
        Seq topicMetadata = cache.getTopicMetadata((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic})), ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.SSL), cache.getTopicMetadata$default$3(), cache.getTopicMetadata$default$4());
        Assertions.assertEquals((int)1, (int)topicMetadata.size());
        Assertions.assertEquals((int)1, (int)((MetadataResponseData.MetadataResponseTopic)topicMetadata.head()).partitions().size());
        Assertions.assertEquals((int)-1, (int)((MetadataResponseData.MetadataResponsePartition)((MetadataResponseData.MetadataResponseTopic)topicMetadata.head()).partitions().get(0)).leaderId());
    }

    @ParameterizedTest
    @MethodSource(value={"cacheProvider"})
    public void getAliveBrokersShouldNotBeMutatedByUpdateCache(MetadataCache cache) {
        String topic = "topic";
        Range.Inclusive initialBrokerIds = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 2);
        this.updateCache$1((Seq)initialBrokerIds, topic, cache);
        Iterable aliveBrokersFromCache = cache.getAliveBrokers();
        this.updateCache$1((Seq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 3), topic, cache);
        Assertions.assertEquals((Object)initialBrokerIds.toSet(), (Object)((IterableOnceOps)aliveBrokersFromCache.map((Function1 & Serializable)x$5 -> BoxesRunTime.boxToInteger((int)x$5.id()))).toSet());
    }

    @ParameterizedTest
    @MethodSource(value={"zkCacheProvider"})
    public void testGetClusterMetadataWithOfflineReplicas(MetadataCache cache) {
        String topic = "topic";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
        .colon.colon brokers = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataBroker().setId(0).setRack("").setEndpoints(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost("foo").setPort(9092).setSecurityProtocol(securityProtocol.id).setListener(listenerName.value()), (List)Nil$.MODULE$)).asJava()), (List)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataBroker().setId(1).setEndpoints(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)Seq$.MODULE$.empty()).asJava()), (List)Nil$.MODULE$));
        int controllerEpoch = 1;
        int leader = 1;
        int leaderEpoch = 0;
        java.util.List<Integer> replicas = Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1));
        java.util.List<Integer> isr = Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1));
        java.util.List<Integer> offline = Arrays.asList(Predef$.MODULE$.int2Integer(1));
        .colon.colon partitionStates = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(topic).setPartitionIndex(topicPartition.partition()).setControllerEpoch(controllerEpoch).setLeader(leader).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(3).setReplicas(replicas).setOfflineReplicas(offline), (List)Nil$.MODULE$);
        short version = ApiKeys.UPDATE_METADATA.latestVersion();
        UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(version, 2, controllerEpoch, this.brokerEpoch(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)partitionStates).asJava(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)brokers).asJava(), Collections.emptyMap()).build();
        MetadataCacheTest$.MODULE$.updateCache(cache, updateMetadataRequest);
        Node expectedNode0 = new Node(0, "foo", 9092);
        Node expectedNode1 = new Node(1, "", -1);
        Cluster cluster = cache.getClusterMetadata("clusterId", listenerName);
        Assertions.assertEquals((Object)expectedNode0, (Object)cluster.nodeById(0));
        Assertions.assertNull((Object)cluster.nodeById(1));
        Assertions.assertEquals((Object)expectedNode1, (Object)cluster.leaderFor(topicPartition));
        PartitionInfo partitionInfo = cluster.partition(topicPartition);
        Assertions.assertEquals((Object)expectedNode1, (Object)partitionInfo.leader());
        Assertions.assertEquals((Object)new .colon.colon((Object)expectedNode0, (List)new .colon.colon((Object)expectedNode1, (List)Nil$.MODULE$)), (Object)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])partitionInfo.replicas())));
        Assertions.assertEquals((Object)new .colon.colon((Object)expectedNode0, (List)new .colon.colon((Object)expectedNode1, (List)Nil$.MODULE$)), (Object)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])partitionInfo.inSyncReplicas())));
        Assertions.assertEquals((Object)new .colon.colon((Object)expectedNode1, (List)Nil$.MODULE$), (Object)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])partitionInfo.offlineReplicas())));
    }

    @Test
    public void testIsBrokerFenced() {
        KRaftMetadataCache kRaftMetadataCache;
        int kRaftMetadataCache_brokerId = 0;
        KRaftMetadataCache kRaftMetadataCache2 = kRaftMetadataCache = new KRaftMetadataCache(kRaftMetadataCache_brokerId);
        kRaftMetadataCache = null;
        KRaftMetadataCache metadataCache = kRaftMetadataCache2;
        MetadataDelta delta = new MetadataDelta(MetadataImage.EMPTY);
        delta.replay(new RegisterBrokerRecord().setBrokerId(0).setFenced(false));
        metadataCache.setImage(delta.apply());
        Assertions.assertFalse((boolean)metadataCache.isBrokerFenced(0));
        delta.replay(new BrokerRegistrationChangeRecord().setBrokerId(0).setFenced((byte)1));
        metadataCache.setImage(delta.apply());
        Assertions.assertTrue((boolean)metadataCache.isBrokerFenced(0));
    }

    @Test
    public void testIsBrokerInControlledShutdown() {
        KRaftMetadataCache kRaftMetadataCache;
        int kRaftMetadataCache_brokerId = 0;
        KRaftMetadataCache kRaftMetadataCache2 = kRaftMetadataCache = new KRaftMetadataCache(kRaftMetadataCache_brokerId);
        kRaftMetadataCache = null;
        KRaftMetadataCache metadataCache = kRaftMetadataCache2;
        MetadataDelta delta = new MetadataDelta(MetadataImage.EMPTY);
        delta.replay(new RegisterBrokerRecord().setBrokerId(0).setInControlledShutdown(false));
        metadataCache.setImage(delta.apply());
        Assertions.assertFalse((boolean)metadataCache.isBrokerShuttingDown(0));
        delta.replay(new BrokerRegistrationChangeRecord().setBrokerId(0).setInControlledShutdown((byte)1));
        metadataCache.setImage(delta.apply());
        Assertions.assertTrue((boolean)metadataCache.isBrokerShuttingDown(0));
    }

    private static final Seq endpoints$2(int brokerId) {
        String host = new StringBuilder(4).append("foo-").append(brokerId).toString();
        return new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost(host).setPort(9092).setSecurityProtocol(SecurityProtocol.PLAINTEXT.id).setListener(ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT).value()), (List)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost(host).setPort(9093).setSecurityProtocol(SecurityProtocol.SSL.id).setListener(ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.SSL).value()), (List)Nil$.MODULE$));
    }

    public static final /* synthetic */ UpdateMetadataRequestData.UpdateMetadataBroker $anonfun$getTopicMetadata$1(int brokerId) {
        return new UpdateMetadataRequestData.UpdateMetadataBroker().setId(brokerId).setEndpoints(CollectionConverters$.MODULE$.SeqHasAsJava(MetadataCacheTest.endpoints$2(brokerId)).asJava()).setRack("rack1");
    }

    public static final /* synthetic */ boolean $anonfun$getTopicMetadata$3(String topic$2, UpdateMetadataRequestData.UpdateMetadataPartitionState ps) {
        String string = ps.topicName();
        return !(string != null ? !string.equals(topic$2) : topic$2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getTopicMetadata$6(int partitionId$1, UpdateMetadataRequestData.UpdateMetadataPartitionState x$4) {
        return x$4.partitionIndex() == partitionId$1;
    }

    public static final /* synthetic */ void $anonfun$getTopicMetadata$5(Seq topicPartitionStates$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            MetadataResponseData.MetadataResponsePartition partitionMetadata = (MetadataResponseData.MetadataResponsePartition)x0$1._1();
            int partitionId = x0$1._2$mcI$sp();
            Assertions.assertEquals((short)Errors.NONE.code(), (short)partitionMetadata.errorCode());
            Assertions.assertEquals((int)partitionId, (int)partitionMetadata.partitionIndex());
            UpdateMetadataRequestData.UpdateMetadataPartitionState partitionState = (UpdateMetadataRequestData.UpdateMetadataPartitionState)topicPartitionStates$1.find((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)MetadataCacheTest.$anonfun$getTopicMetadata$6(partitionId, x$4))).getOrElse((Function0 & Serializable)() -> (Nothing$)Assertions.fail((String)new StringBuilder(45).append("Unable to find partition state for partition ").append(partitionId).toString()));
            Assertions.assertEquals((int)partitionState.leader(), (int)partitionMetadata.leaderId());
            Assertions.assertEquals((int)partitionState.leaderEpoch(), (int)partitionMetadata.leaderEpoch());
            Assertions.assertEquals((Object)partitionState.isr(), (Object)partitionMetadata.isrNodes());
            Assertions.assertEquals((Object)partitionState.replicas(), (Object)partitionMetadata.replicaNodes());
            return;
        }
        throw new MatchError(null);
    }

    private static final void checkTopicMetadata$1(String topic, MetadataCache cache$1, ListenerName listenerName$1, HashMap topicIds$1, Seq partitionStates$1) {
        Seq topicMetadatas = cache$1.getTopicMetadata((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic})), listenerName$1, cache$1.getTopicMetadata$default$3(), cache$1.getTopicMetadata$default$4());
        Assertions.assertEquals((int)1, (int)topicMetadatas.size());
        MetadataResponseData.MetadataResponseTopic topicMetadata = (MetadataResponseData.MetadataResponseTopic)topicMetadatas.head();
        Assertions.assertEquals((short)Errors.NONE.code(), (short)topicMetadata.errorCode());
        Assertions.assertEquals((Object)topic, (Object)topicMetadata.name());
        Assertions.assertEquals(topicIds$1.get(topic), (Object)topicMetadata.topicId());
        Seq topicPartitionStates = (Seq)partitionStates$1.filter((Function1 & Serializable)ps -> BoxesRunTime.boxToBoolean((boolean)MetadataCacheTest.$anonfun$getTopicMetadata$3(topic, ps)));
        Buffer partitionMetadatas = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(topicMetadata.partitions()).asScala().sortBy((Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.partitionIndex()), (Ordering)Ordering.Int$.MODULE$);
        Assertions.assertEquals((int)topicPartitionStates.size(), (int)partitionMetadatas.size(), (String)new StringBuilder(37).append("Unexpected partition count for topic ").append(topic).toString());
        ((IterableOnceOps)partitionMetadatas.zipWithIndex()).foreach((Function1 & Serializable)x0$1 -> {
            MetadataCacheTest.$anonfun$getTopicMetadata$5(topicPartitionStates, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$getTopicMetadata$2(MetadataCache cache$1, HashMap topicIds$1, Seq partitionStates$1, String topic0$1, String topic1$1, SecurityProtocol securityProtocol) {
        ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
        MetadataCacheTest.checkTopicMetadata$1(topic0$1, cache$1, listenerName, topicIds$1, partitionStates$1);
        MetadataCacheTest.checkTopicMetadata$1(topic1$1, cache$1, listenerName, topicIds$1, partitionStates$1);
    }

    public static final /* synthetic */ UpdateMetadataRequestData.UpdateMetadataBroker $anonfun$getAliveBrokersShouldNotBeMutatedByUpdateCache$1(int brokerId) {
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        return new UpdateMetadataRequestData.UpdateMetadataBroker().setId(brokerId).setRack("").setEndpoints(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost("foo").setPort(9092).setSecurityProtocol(securityProtocol.id).setListener(ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol).value()), (List)Nil$.MODULE$)).asJava());
    }

    private final void updateCache$1(Seq brokerIds, String topic$3, MetadataCache cache$2) {
        Seq brokers = (Seq)brokerIds.map((Function1 & Serializable)brokerId -> MetadataCacheTest.$anonfun$getAliveBrokersShouldNotBeMutatedByUpdateCache$1(BoxesRunTime.unboxToInt((Object)brokerId)));
        int controllerEpoch = 1;
        int leader = 0;
        int leaderEpoch = 0;
        java.util.List<Integer> replicas = Arrays.asList(Predef$.MODULE$.int2Integer(0));
        java.util.List<Integer> isr = Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1));
        .colon.colon partitionStates = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(topic$3).setPartitionIndex(0).setControllerEpoch(controllerEpoch).setLeader(leader).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(3).setReplicas(replicas), (List)Nil$.MODULE$);
        short version = ApiKeys.UPDATE_METADATA.latestVersion();
        UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(version, 2, controllerEpoch, this.brokerEpoch(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)partitionStates).asJava(), CollectionConverters$.MODULE$.SeqHasAsJava(brokers).asJava(), Collections.emptyMap()).build();
        MetadataCacheTest$.MODULE$.updateCache(cache$2, updateMetadataRequest);
    }

    public MetadataCacheTest() {
        this.brokerEpoch = 0L;
    }

    public static final /* synthetic */ Object $anonfun$getTopicMetadata$2$adapted(MetadataCache cache$1, HashMap topicIds$1, Seq partitionStates$1, String topic0$1, String topic1$1, SecurityProtocol securityProtocol) {
        MetadataCacheTest.$anonfun$getTopicMetadata$2(cache$1, topicIds$1, partitionStates$1, topic0$1, topic1$1, securityProtocol);
        return BoxedUnit.UNIT;
    }
}

