/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import kafka.cluster.Partition;
import kafka.log.LeaderOffsetIncremented$;
import kafka.log.LogAppendInfo;
import kafka.log.UnifiedLog;
import kafka.server.AbstractFetcherThread;
import kafka.server.FailedPartitions;
import kafka.server.KafkaConfig;
import kafka.server.LeaderEndPoint;
import kafka.server.OffsetAndEpoch;
import kafka.server.OffsetTruncationState;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaQuota;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.server.common.MetadataVersion;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005md\u0001B\f\u0019\u0001uA\u0001B\t\u0001\u0003\u0002\u0003\u0006Ia\t\u0005\na\u0001\u0011\t\u0011)A\u0005cQB\u0001\"\u000e\u0001\u0003\u0002\u0003\u0006IA\u000e\u0005\ts\u0001\u0011\t\u0011)A\u0005u!AQ\b\u0001B\u0001B\u0003%a\b\u0003\u0005B\u0001\t\u0005\t\u0015!\u0003C\u0011!)\u0005A!A!\u0002\u0013\u0019\u0003\u0002\u0003$\u0001\u0005\u0003\u0005\u000b\u0011B$\t\u000b]\u0003A\u0011\u0001-\t\u000f\t\u0004!\u0019!C)G\"1q\r\u0001Q\u0001\n\u0011DQ\u0001\u001b\u0001\u0005R%DQa\u001e\u0001\u0005RaDQ! \u0001\u0005RyDq!!\u0001\u0001\t#\n\u0019\u0001C\u0004\u0002\u0014\u0001!\t%!\u0006\t\u000f\u0005]\u0001\u0001\"\u0011\u0002\u001a!9\u0011\u0011\u0005\u0001\u0005B\u0005\r\u0002bBA#\u0001\u0011\u0005\u0011q\t\u0005\b\u00037\u0002A\u0011IA/\u0011\u001d\ti\u0007\u0001C)\u0003_BQ\"a\u001e\u0001!\u0003\r\t\u0011!C\u0005\u0003s\"$\u0001\u0006*fa2L7-\u0019$fi\u000eDWM\u001d+ie\u0016\fGM\u0003\u0002\u001a5\u000511/\u001a:wKJT\u0011aG\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001a\u0004\u0005\u0002 A5\t\u0001$\u0003\u0002\"1\t)\u0012IY:ue\u0006\u001cGOR3uG\",'\u000f\u00165sK\u0006$\u0017\u0001\u00028b[\u0016\u0004\"\u0001J\u0017\u000f\u0005\u0015Z\u0003C\u0001\u0014*\u001b\u00059#B\u0001\u0015\u001d\u0003\u0019a$o\\8u})\t!&A\u0003tG\u0006d\u0017-\u0003\u0002-S\u00051\u0001K]3eK\u001aL!AL\u0018\u0003\rM#(/\u001b8h\u0015\ta\u0013&\u0001\u0004mK\u0006$WM\u001d\t\u0003?IJ!a\r\r\u0003\u001d1+\u0017\rZ3s\u000b:$\u0007k\\5oi&\u0011\u0001\u0007I\u0001\rEJ|7.\u001a:D_:4\u0017n\u001a\t\u0003?]J!\u0001\u000f\r\u0003\u0017-\u000bgm[1D_:4\u0017nZ\u0001\u0011M\u0006LG.\u001a3QCJ$\u0018\u000e^5p]N\u0004\"aH\u001e\n\u0005qB\"\u0001\u0005$bS2,G\rU1si&$\u0018n\u001c8t\u0003)\u0011X\r\u001d7jG\u0006luM\u001d\t\u0003?}J!\u0001\u0011\r\u0003\u001dI+\u0007\u000f\\5dC6\u000bg.Y4fe\u0006)\u0011/^8uCB\u0011qdQ\u0005\u0003\tb\u0011ABU3qY&\u001c\u0017-U;pi\u0006\f\u0011\u0002\\8h!J,g-\u001b=\u0002/5,G/\u00193bi\u00064VM]:j_:\u001cV\u000f\u001d9mS\u0016\u0014\bc\u0001%J\u00176\t\u0011&\u0003\u0002KS\tIa)\u001e8di&|g\u000e\r\t\u0003\u0019Vk\u0011!\u0014\u0006\u0003\u001d>\u000baaY8n[>t'BA\rQ\u0015\tY\u0012K\u0003\u0002S'\u00061\u0011\r]1dQ\u0016T\u0011\u0001V\u0001\u0004_J<\u0017B\u0001,N\u0005=iU\r^1eCR\fg+\u001a:tS>t\u0017A\u0002\u001fj]&$h\bF\u0005Z5ncVLX0aCB\u0011q\u0004\u0001\u0005\u0006E%\u0001\ra\t\u0005\u0006a%\u0001\r!\r\u0005\u0006k%\u0001\rA\u000e\u0005\u0006s%\u0001\rA\u000f\u0005\u0006{%\u0001\rA\u0010\u0005\u0006\u0003&\u0001\rA\u0011\u0005\u0006\u000b&\u0001\ra\t\u0005\u0006\r&\u0001\raR\u0001 SN|eMZ:fi\u001a{'\u000fT3bI\u0016\u0014X\t]8dQN+\b\u000f]8si\u0016$W#\u00013\u0011\u0005!+\u0017B\u00014*\u0005\u001d\u0011un\u001c7fC:\f\u0001%[:PM\u001a\u001cX\r\u001e$pe2+\u0017\rZ3s\u000bB|7\r[*vaB|'\u000f^3eA\u0005YA.\u0019;fgR,\u0005o\\2i)\tQ\u0007\u000fE\u0002IW6L!\u0001\\\u0015\u0003\r=\u0003H/[8o!\tAe.\u0003\u0002pS\t\u0019\u0011J\u001c;\t\u000bEd\u0001\u0019\u0001:\u0002\u001dQ|\u0007/[2QCJ$\u0018\u000e^5p]B\u00111/^\u0007\u0002i*\u0011a\nU\u0005\u0003mR\u0014a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g.\u0001\bm_\u001e\u001cF/\u0019:u\u001f\u001a47/\u001a;\u0015\u0005ed\bC\u0001%{\u0013\tY\u0018F\u0001\u0003M_:<\u0007\"B9\u000e\u0001\u0004\u0011\u0018\u0001\u00047pO\u0016sGm\u00144gg\u0016$HCA=\u0000\u0011\u0015\th\u00021\u0001s\u0003E)g\u000eZ(gMN,GOR8s\u000bB|7\r\u001b\u000b\u0007\u0003\u000b\ti!a\u0004\u0011\t![\u0017q\u0001\t\u0004?\u0005%\u0011bAA\u00061\tqqJ\u001a4tKR\fe\u000eZ#q_\u000eD\u0007\"B9\u0010\u0001\u0004\u0011\bBBA\t\u001f\u0001\u0007Q.A\u0003fa>\u001c\u0007.\u0001\tj]&$\u0018.\u0019;f'\",H\u000fZ8x]R\tA-A\u0007bo\u0006LGo\u00155vi\u0012|wO\u001c\u000b\u0003\u00037\u00012\u0001SA\u000f\u0013\r\ty\"\u000b\u0002\u0005+:LG/\u0001\u000bqe>\u001cWm]:QCJ$\u0018\u000e^5p]\u0012\u000bG/\u0019\u000b\t\u0003K\t\u0019$!\u000e\u0002:A!\u0001j[A\u0014!\u0011\tI#a\f\u000e\u0005\u0005-\"bAA\u00175\u0005\u0019An\\4\n\t\u0005E\u00121\u0006\u0002\u000e\u0019><\u0017\t\u001d9f]\u0012LeNZ8\t\u000bE\u0014\u0002\u0019\u0001:\t\r\u0005]\"\u00031\u0001z\u0003-1W\r^2i\u001f\u001a47/\u001a;\t\u000f\u0005m\"\u00031\u0001\u0002>\u0005i\u0001/\u0019:uSRLwN\u001c#bi\u0006\u0004B!a\u0010\u0002B5\t\u0001!C\u0002\u0002D\u0001\u0012\u0011BR3uG\"$\u0015\r^1\u000275\f\u0017PY3XCJt\u0017JZ(wKJ\u001c\u0018N_3e%\u0016\u001cwN\u001d3t)\u0019\tY\"!\u0013\u0002Z!9\u00111J\nA\u0002\u00055\u0013a\u0002:fG>\u0014Hm\u001d\t\u0005\u0003\u001f\n)&\u0004\u0002\u0002R)\u0019\u00111\u000b;\u0002\rI,7m\u001c:e\u0013\u0011\t9&!\u0015\u0003\u001b5+Wn\u001c:z%\u0016\u001cwN\u001d3t\u0011\u0015\t8\u00031\u0001s\u0003!!(/\u001e8dCR,GCBA\u000e\u0003?\n\u0019\u0007\u0003\u0004\u0002bQ\u0001\rA]\u0001\u0003iBDq!!\u001a\u0015\u0001\u0004\t9'A\u000bpM\u001a\u001cX\r\u001e+sk:\u001c\u0017\r^5p]N#\u0018\r^3\u0011\u0007}\tI'C\u0002\u0002la\u0011Qc\u00144gg\u0016$HK];oG\u0006$\u0018n\u001c8Ti\u0006$X-A\fueVt7-\u0019;f\rVdG._!oIN#\u0018M\u001d;BiR1\u00111DA9\u0003gBQ!]\u000bA\u0002IDa!!\u001e\u0016\u0001\u0004I\u0018AB8gMN,G/\u0001\u0007tkB,'\u000f\n7fC\u0012,'/F\u00012\u0001")
public class ReplicaFetcherThread
extends AbstractFetcherThread {
    private final KafkaConfig brokerConfig;
    private final ReplicaManager replicaMgr;
    private final ReplicaQuota quota;
    private final Function0<MetadataVersion> metadataVersionSupplier;
    private final boolean isOffsetForLeaderEpochSupported;

    private /* synthetic */ LeaderEndPoint super$leader() {
        return super.leader();
    }

    @Override
    public boolean isOffsetForLeaderEpochSupported() {
        return this.isOffsetForLeaderEpochSupported;
    }

    @Override
    public Option<Object> latestEpoch(TopicPartition topicPartition) {
        return this.replicaMgr.localLogOrException(topicPartition).latestEpoch();
    }

    @Override
    public long logStartOffset(TopicPartition topicPartition) {
        return this.replicaMgr.localLogOrException(topicPartition).logStartOffset();
    }

    @Override
    public long logEndOffset(TopicPartition topicPartition) {
        return this.replicaMgr.localLogOrException(topicPartition).logEndOffset();
    }

    @Override
    public Option<OffsetAndEpoch> endOffsetForEpoch(TopicPartition topicPartition, int epoch) {
        return this.replicaMgr.localLogOrException(topicPartition).endOffsetForEpoch(epoch);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean initiateShutdown() {
        void var1_1;
        boolean justShutdown = super.initiateShutdown();
        if (justShutdown) {
            try {
                super.leader().initiateClose();
            }
            catch (Throwable t) {
                this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(80).append("Failed to initiate shutdown of ").append(this.super$leader()).append(" after initiating replica fetcher thread shutdown").toString(), (Function0<Throwable>)(Function0 & Serializable)() -> t);
            }
        }
        return (boolean)var1_1;
    }

    @Override
    public void awaitShutdown() {
        super.awaitShutdown();
        try {
            super.leader().close();
            return;
        }
        catch (Throwable t) {
            this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(59).append("Failed to close ").append(this.super$leader()).append(" after shutting down replica fetcher thread").toString(), (Function0<Throwable>)(Function0 & Serializable)() -> t);
            return;
        }
    }

    @Override
    public Option<LogAppendInfo> processPartitionData(TopicPartition topicPartition, long fetchOffset, FetchResponseData.PartitionData partitionData) {
        boolean logTrace = this.isTraceEnabled();
        Partition partition = this.replicaMgr.getPartitionOrException(topicPartition);
        UnifiedLog log = partition.localLogOrException();
        MemoryRecords records = this.toMemoryRecords(FetchResponse.recordsOrFail((FetchResponseData.PartitionData)partitionData));
        this.maybeWarnIfOversizedRecords(records, topicPartition);
        if (fetchOffset != log.logEndOffset()) {
            throw new IllegalStateException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Offset mismatch for partition %s: fetched offset = %d, log end offset = %d."), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition, BoxesRunTime.boxToLong((long)fetchOffset), BoxesRunTime.boxToLong((long)log.logEndOffset())})));
        }
        if (logTrace) {
            this.trace((Function0<String>)(Function0 & Serializable)() -> StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Follower has replica log end offset %d for partition %s. Received %d messages and leader hw %d"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)log.logEndOffset()), topicPartition, BoxesRunTime.boxToInteger((int)records.sizeInBytes()), BoxesRunTime.boxToLong((long)partitionData.highWatermark())})));
        }
        Option<LogAppendInfo> logAppendInfo = partition.appendRecordsToFollowerOrFutureReplica(records, false);
        if (logTrace) {
            this.trace((Function0<String>)(Function0 & Serializable)() -> StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Follower has replica log end offset %d after appending %d bytes of messages for partition %s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)log.logEndOffset()), BoxesRunTime.boxToInteger((int)records.sizeInBytes()), topicPartition})));
        }
        long leaderLogStartOffset = partitionData.logStartOffset();
        long followerHighWatermark = log.updateHighWatermark(partitionData.highWatermark());
        log.maybeIncrementLogStartOffset(leaderLogStartOffset, LeaderOffsetIncremented$.MODULE$);
        if (logTrace) {
            this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(54).append("Follower set replica high watermark for partition ").append(topicPartition).append(" to ").append(followerHighWatermark).toString());
        }
        if (this.quota.isThrottled(topicPartition)) {
            this.quota.record(records.sizeInBytes());
        }
        if (partition.isReassigning() && partition.isAddingLocalReplica()) {
            this.brokerTopicStats().updateReassignmentBytesIn(records.sizeInBytes());
        }
        this.brokerTopicStats().updateReplicationBytesIn(records.sizeInBytes());
        return logAppendInfo;
    }

    public void maybeWarnIfOversizedRecords(MemoryRecords records, TopicPartition topicPartition) {
        if (((MetadataVersion)this.metadataVersionSupplier.apply()).fetchRequestVersion() <= 2 && records.sizeInBytes() > 0 && records.validBytes() <= 0) {
            this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(311).append(new StringBuilder(101).append("Replication is failing due to a message that is greater than replica.fetch.max.bytes for partition ").append(topicPartition).append(". ").toString()).append("This generally occurs when the max.message.bytes has been overridden to exceed this value and a suitably large ").append("message has also been sent. To fix this problem increase replica.fetch.max.bytes in your broker config to be ").append("equal or larger than your settings for max.message.bytes, both at a broker and topic level.").toString());
        }
    }

    @Override
    public void truncate(TopicPartition tp, OffsetTruncationState offsetTruncationState) {
        Partition partition = this.replicaMgr.getPartitionOrException(tp);
        UnifiedLog log = partition.localLogOrException();
        partition.truncateTo(offsetTruncationState.offset(), false);
        if (offsetTruncationState.offset() < log.highWatermark()) {
            this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(44).append("Truncating ").append(tp).append(" to offset ").append(offsetTruncationState.offset()).append(" below high watermark ").toString()).append(String.valueOf(BoxesRunTime.boxToLong((long)log.highWatermark()))).toString());
        }
        if (offsetTruncationState.truncationCompleted()) {
            this.replicaMgr.replicaAlterLogDirsManager().markPartitionsForTruncation(this.brokerConfig.brokerId(), tp, offsetTruncationState.offset());
        }
    }

    @Override
    public void truncateFullyAndStartAt(TopicPartition topicPartition, long offset) {
        this.replicaMgr.getPartitionOrException(topicPartition).truncateFullyAndStartAt(offset, false);
    }

    public ReplicaFetcherThread(String name, LeaderEndPoint leader, KafkaConfig brokerConfig, FailedPartitions failedPartitions, ReplicaManager replicaMgr, ReplicaQuota quota, String logPrefix, Function0<MetadataVersion> metadataVersionSupplier) {
        this.brokerConfig = brokerConfig;
        this.replicaMgr = replicaMgr;
        this.quota = quota;
        this.metadataVersionSupplier = metadataVersionSupplier;
        super(name, name, leader, failedPartitions, Predef$.MODULE$.Integer2int(brokerConfig.replicaFetchBackoffMs()), false, replicaMgr.brokerTopicStats());
        this.logIdent_$eq(logPrefix);
        this.isOffsetForLeaderEpochSupported = ((MetadataVersion)metadataVersionSupplier.apply()).isOffsetForLeaderEpochSupported();
    }
}

