/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import java.util.Properties;
import kafka.common.InconsistentBrokerMetadataException;
import kafka.common.InconsistentNodeIdException;
import kafka.log.LocalLog$;
import kafka.server.BrokerMetadataCheckpoint;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaRaftServer$;
import kafka.server.MetaProperties;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.metadata.bootstrap.BootstrapDirectory;
import org.apache.kafka.metadata.bootstrap.BootstrapMetadata;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple3;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001dc\u0001B\t\u0013\u0001]AQA\b\u0001\u0005\u0002}AqA\t\u0001C\u0002\u0013%1\u0005\u0003\u0004-\u0001\u0001\u0006I\u0001\n\u0005\u0006[\u0001!\tA\f\u0005\u0006\u007f\u0001!\tA\f\u0005\u0006\u0003\u0002!IA\u0011\u0005\bu\u0002\t\n\u0011\"\u0003|\u0011\u001d\ti\u0001\u0001C\u0005\u0003\u001fAq!a\t\u0001\t\u0013\t)\u0003\u0003\u0004\u0002,\u0001!\tA\f\u0005\u0007\u0003_\u0001A\u0011\u0001\u0018\t\r\u0005M\u0002\u0001\"\u0001/\u0011\u0019\t9\u0004\u0001C\u0001]!1\u00111\b\u0001\u0005\u00029Ba!a\u0010\u0001\t\u0003q\u0003BBA\"\u0001\u0011\u0005aFA\nLC\u001a\\\u0017MU1giN+'O^3s)\u0016\u001cHO\u0003\u0002\u0014)\u000511/\u001a:wKJT\u0011!F\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0001\u0004\u0005\u0002\u001a95\t!DC\u0001\u001c\u0003\u0015\u00198-\u00197b\u0013\ti\"D\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0001\u0002\"!\t\u0001\u000e\u0003I\tqb\u00197vgR,'/\u00133CCN,g\u0007N\u000b\u0002IA\u0011QEK\u0007\u0002M)\u0011q\u0005K\u0001\u0005Y\u0006twMC\u0001*\u0003\u0011Q\u0017M^1\n\u0005-2#AB*ue&tw-\u0001\tdYV\u001cH/\u001a:JI\n\u000b7/\u001a\u001c5A\u0005\u0001C/Z:u'V\u001c7-Z:tMVdGj\\1e\u001b\u0016$\u0018\r\u0015:pa\u0016\u0014H/[3t)\u0005y\u0003CA\r1\u0013\t\t$D\u0001\u0003V]&$\bF\u0001\u00034!\t!T(D\u00016\u0015\t1t'A\u0002ba&T!\u0001O\u001d\u0002\u000f),\b/\u001b;fe*\u0011!hO\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002y\u0005\u0019qN]4\n\u0005y*$\u0001\u0002+fgR\fA\u0006^3ti2{\u0017\rZ'fi\u0006\u0004&o\u001c9feRLWm],ji\"LenY8og&\u001cH/\u001a8u\u001d>$W-\u00133)\u0005\u0015\u0019\u0014\u0001G5om>\\W\rT8bI6+G/\u0019)s_B,'\u000f^5fgR!1\t\u001a4o!\u0015IBIR%U\u0013\t)%D\u0001\u0004UkBdWm\r\t\u0003C\u001dK!\u0001\u0013\n\u0003\u001d5+G/\u0019)s_B,'\u000f^5fgB\u0011!JU\u0007\u0002\u0017*\u0011A*T\u0001\nE>|Go\u001d;sCBT!AT(\u0002\u00115,G/\u00193bi\u0006T!!\u0006)\u000b\u0005E[\u0014AB1qC\u000eDW-\u0003\u0002T\u0017\n\t\"i\\8ugR\u0014\u0018\r]'fi\u0006$\u0017\r^1\u0011\u0007UC&,D\u0001W\u0015\t9&$\u0001\u0006d_2dWm\u0019;j_:L!!\u0017,\u0003\u0007M+\u0017\u000f\u0005\u0002\\E:\u0011A\f\u0019\t\u0003;ji\u0011A\u0018\u0006\u0003?Z\ta\u0001\u0010:p_Rt\u0014BA1\u001b\u0003\u0019\u0001&/\u001a3fM&\u00111f\u0019\u0006\u0003CjAQ!\u001a\u0004A\u0002\u0019\u000ba\"\\3uCB\u0013x\u000e]3si&,7\u000fC\u0003h\r\u0001\u0007\u0001.\u0001\td_:4\u0017n\u001a)s_B,'\u000f^5fgB\u0011\u0011\u000e\\\u0007\u0002U*\u00111\u000eK\u0001\u0005kRLG.\u0003\u0002nU\nQ\u0001K]8qKJ$\u0018.Z:\t\u000f=4\u0001\u0013!a\u0001a\u0006yQ.\u001a;bI\u0006$\u0018MV3sg&|g\u000eE\u0002\u001acNL!A\u001d\u000e\u0003\r=\u0003H/[8o!\t!\b0D\u0001v\u0015\t1x/\u0001\u0004d_6lwN\u001c\u0006\u0003'=K!!_;\u0003\u001f5+G/\u00193bi\u00064VM]:j_:\f!%\u001b8w_.,Gj\\1e\u001b\u0016$\u0018\r\u0015:pa\u0016\u0014H/[3tI\u0011,g-Y;mi\u0012\u001aT#\u0001?+\u0005Al8&\u0001@\u0011\u0007}\fI!\u0004\u0002\u0002\u0002)!\u00111AA\u0003\u0003%)hn\u00195fG.,GMC\u0002\u0002\bi\t!\"\u00198o_R\fG/[8o\u0013\u0011\tY!!\u0001\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\nxe&$X-T3uCB\u0013x\u000e]3si&,7\u000fF\u00030\u0003#\t\t\u0003C\u0004\u0002\u0014!\u0001\r!!\u0006\u0002\r1|w\rR5s!\u0011\t9\"!\b\u000e\u0005\u0005e!bAA\u000eQ\u0005\u0011\u0011n\\\u0005\u0005\u0003?\tIB\u0001\u0003GS2,\u0007\"B3\t\u0001\u00041\u0015AF<sSR,'i\\8ugR\u0014\u0018\r]'fi\u0006$\u0017\r^1\u0015\u000b=\n9#!\u000b\t\u000f\u0005M\u0011\u00021\u0001\u0002\u0016!)q.\u0003a\u0001g\u0006\u0019D/Z:u'R\f'\u000f^;q\r\u0006LGn]%g\u001b\u0016$\u0018\r\u0015:pa\u0016\u0014H/[3t\u001b&\u001c8/\u001b8h\u0013:\u001cv.\\3M_\u001e$\u0015N\u001d\u0015\u0003\u0015M\nQ\u0005^3tiN#\u0018M\u001d;va\u001a\u000b\u0017\u000e\\:JM6+G/\u0019'pO\u0012K'/S:PM\u001ad\u0017N\\3)\u0005-\u0019\u0014\u0001\u000b;fgR\u001cF/\u0019:ukB$u.Z:O_R4\u0015-\u001b7JM\u0012\u000bG/\u0019#je&\u001bxJ\u001a4mS:,\u0007F\u0001\u00074\u0003\u001d\"Xm\u001d;Ti\u0006\u0014H/\u001e9GC&d7/\u00134V]\u0016D\b/Z2uK\u0012lU\r^1eCR\fG)\u001b:)\u00055\u0019\u0014\u0001\f;fgRdu.\u00193Qe>\u0004XM\u001d;jKN<\u0016\u000e\u001e5J]\u000e|gn]5ti\u0016tGo\u00117vgR,'/\u00133tQ\tq1'\u0001\fuKN$8JU1giV\u0003H-\u0019;f/&$\b.\u0013\"QQ\ty1'A\ruKN$8JU1giV\u0003H-\u0019;f/&$\bn\\;u\u0013\n\u0003\u0006F\u0001\t4\u0001")
public class KafkaRaftServerTest {
    private final String clusterIdBase64;

    private String clusterIdBase64() {
        return this.clusterIdBase64;
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testSuccessfulLoadMetaProperties() {
        void var7_7;
        void var6_6;
        String clusterId = this.clusterIdBase64();
        int nodeId = 0;
        MetaProperties metaProperties = new MetaProperties(clusterId, nodeId);
        Properties configProperties = new Properties();
        configProperties.put(KafkaConfig$.MODULE$.ProcessRolesProp(), "broker,controller");
        configProperties.put(KafkaConfig$.MODULE$.NodeIdProp(), Integer.toString(nodeId));
        configProperties.put(KafkaConfig$.MODULE$.ListenersProp(), "PLAINTEXT://127.0.0.1:9092,SSL://127.0.0.1:9093");
        configProperties.put(KafkaConfig$.MODULE$.QuorumVotersProp(), new StringBuilder(15).append(nodeId).append("@localhost:9093").toString());
        configProperties.put(KafkaConfig$.MODULE$.ControllerListenerNamesProp(), "SSL");
        Tuple3<MetaProperties, BootstrapMetadata, Seq<String>> tuple3 = this.invokeLoadMetaProperties(metaProperties, configProperties, this.invokeLoadMetaProperties$default$3());
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        MetaProperties loadedMetaProperties = (MetaProperties)tuple3._1();
        Seq offlineDirs = (Seq)tuple3._3();
        Assertions.assertEquals((Object)metaProperties, (Object)var6_6);
        Assertions.assertEquals((Object)package$.MODULE$.Seq().empty(), (Object)var7_7);
    }

    @Test
    public void testLoadMetaPropertiesWithInconsistentNodeId() {
        String clusterId = this.clusterIdBase64();
        int metaNodeId = 1;
        int configNodeId = 0;
        MetaProperties metaProperties = new MetaProperties(clusterId, metaNodeId);
        Properties configProperties = new Properties();
        configProperties.put(KafkaConfig$.MODULE$.ProcessRolesProp(), "controller");
        configProperties.put(KafkaConfig$.MODULE$.NodeIdProp(), Integer.toString(configNodeId));
        configProperties.put(KafkaConfig$.MODULE$.QuorumVotersProp(), new StringBuilder(15).append(configNodeId).append("@localhost:9092").toString());
        configProperties.put(KafkaConfig$.MODULE$.ControllerListenerNamesProp(), "PLAINTEXT");
        Assertions.assertThrows(InconsistentNodeIdException.class, () -> this.invokeLoadMetaProperties(metaProperties, configProperties, this.invokeLoadMetaProperties$default$3()));
    }

    private Tuple3<MetaProperties, BootstrapMetadata, Seq<String>> invokeLoadMetaProperties(MetaProperties metaProperties, Properties configProperties, Option<MetadataVersion> metadataVersion) {
        Tuple3 tuple3;
        File file;
        File file2;
        File file3 = file2 = TestUtils.tempDirectory(null, null);
        file2 = null;
        File file4 = file = file3;
        file = null;
        File tempLogDir = file4;
        try {
            this.writeMetaProperties(tempLogDir, metaProperties);
            metadataVersion.foreach((Function1 & Serializable)mv -> {
                this.writeBootstrapMetadata(tempLogDir, mv);
                return BoxedUnit.UNIT;
            });
            configProperties.put(KafkaConfig$.MODULE$.LogDirProp(), tempLogDir.getAbsolutePath());
            KafkaConfig config = KafkaConfig$.MODULE$.fromProps(configProperties);
            tuple3 = KafkaRaftServer$.MODULE$.initializeLogDirs(config);
        }
        finally {
            Utils.delete((File)tempLogDir);
        }
        return tuple3;
    }

    private Option<MetadataVersion> invokeLoadMetaProperties$default$3() {
        return new Some((Object)MetadataVersion.latest());
    }

    private void writeMetaProperties(File logDir, MetaProperties metaProperties) {
        File metaPropertiesFile = new File(logDir.getAbsolutePath(), "meta.properties");
        new BrokerMetadataCheckpoint(metaPropertiesFile).write(metaProperties.toProperties());
    }

    private void writeBootstrapMetadata(File logDir, MetadataVersion metadataVersion) {
        new BootstrapDirectory(logDir.toString(), Optional.empty()).writeBinaryFile(BootstrapMetadata.fromVersion((MetadataVersion)metadataVersion, (String)"test"));
    }

    @Test
    public void testStartupFailsIfMetaPropertiesMissingInSomeLogDir() {
        File file;
        File file2;
        File file3;
        File file4;
        String clusterId = this.clusterIdBase64();
        int nodeId = 1;
        File file5 = file4 = TestUtils.tempDirectory(null, null);
        file4 = null;
        File file6 = file3 = file5;
        file3 = null;
        File logDir1 = file6;
        File file7 = file2 = TestUtils.tempDirectory(null, null);
        file2 = null;
        File file8 = file = file7;
        file = null;
        File logDir2 = file8;
        this.writeMetaProperties(logDir1, new MetaProperties(clusterId, nodeId));
        Properties configProperties = new Properties();
        configProperties.put(KafkaConfig$.MODULE$.ProcessRolesProp(), "broker");
        configProperties.put(KafkaConfig$.MODULE$.NodeIdProp(), Integer.toString(nodeId));
        configProperties.put(KafkaConfig$.MODULE$.QuorumVotersProp(), new StringBuilder(15).append(nodeId + 1).append("@localhost:9092").toString());
        configProperties.put(KafkaConfig$.MODULE$.LogDirProp(), ((IterableOnceOps)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new File[]{logDir1, logDir2})).map((Function1 & Serializable)x$2 -> x$2.getAbsolutePath())).mkString(","));
        configProperties.put(KafkaConfig$.MODULE$.ControllerListenerNamesProp(), "SSL");
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(configProperties);
        Assertions.assertThrows(KafkaException.class, () -> KafkaRaftServer$.MODULE$.initializeLogDirs(config));
    }

    @Test
    public void testStartupFailsIfMetaLogDirIsOffline() {
        File file;
        File file2;
        String clusterId = this.clusterIdBase64();
        int nodeId = 1;
        File file3 = file2 = TestUtils.tempDirectory(null, null);
        file2 = null;
        File file4 = file = file3;
        file = null;
        File validDir = file4;
        this.writeMetaProperties(validDir, new MetaProperties(clusterId, nodeId));
        File invalidDir = TestUtils.tempFile((String)"blah");
        Properties configProperties = new Properties();
        configProperties.put(KafkaConfig$.MODULE$.ProcessRolesProp(), "broker");
        configProperties.put(KafkaConfig$.MODULE$.QuorumVotersProp(), new StringBuilder(15).append(nodeId + 1).append("@localhost:9092").toString());
        configProperties.put(KafkaConfig$.MODULE$.NodeIdProp(), Integer.toString(nodeId));
        configProperties.put(KafkaConfig$.MODULE$.MetadataLogDirProp(), invalidDir.getAbsolutePath());
        configProperties.put(KafkaConfig$.MODULE$.LogDirProp(), validDir.getAbsolutePath());
        configProperties.put(KafkaConfig$.MODULE$.ControllerListenerNamesProp(), "SSL");
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(configProperties);
        Assertions.assertThrows(KafkaException.class, () -> KafkaRaftServer$.MODULE$.initializeLogDirs(config));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testStartupDoesNotFailIfDataDirIsOffline() {
        void var9_11;
        void var8_10;
        File file;
        File file2;
        String clusterId = this.clusterIdBase64();
        int nodeId = 1;
        File file3 = file2 = TestUtils.tempDirectory(null, null);
        file2 = null;
        File file4 = file = file3;
        file = null;
        File validDir = file4;
        this.writeMetaProperties(validDir, new MetaProperties(clusterId, nodeId));
        this.writeBootstrapMetadata(validDir, MetadataVersion.latest());
        File invalidDir = TestUtils.tempFile((String)"blah");
        Properties configProperties = new Properties();
        configProperties.put(KafkaConfig$.MODULE$.ProcessRolesProp(), "broker");
        configProperties.put(KafkaConfig$.MODULE$.NodeIdProp(), Integer.toString(nodeId));
        configProperties.put(KafkaConfig$.MODULE$.QuorumVotersProp(), new StringBuilder(15).append(nodeId + 1).append("@localhost:9092").toString());
        configProperties.put(KafkaConfig$.MODULE$.MetadataLogDirProp(), validDir.getAbsolutePath());
        configProperties.put(KafkaConfig$.MODULE$.LogDirProp(), invalidDir.getAbsolutePath());
        configProperties.put(KafkaConfig$.MODULE$.ControllerListenerNamesProp(), "SSL");
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(configProperties);
        Tuple3 tuple3 = KafkaRaftServer$.MODULE$.initializeLogDirs(config);
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        MetaProperties loadedProperties = (MetaProperties)tuple3._1();
        Seq offlineDirs = (Seq)tuple3._3();
        Assertions.assertEquals((int)nodeId, (int)var8_10.nodeId());
        Assertions.assertEquals((Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{invalidDir.getAbsolutePath()})), (Object)var9_11);
    }

    @Test
    public void testStartupFailsIfUnexpectedMetadataDir() {
        File file;
        File file2;
        File file3;
        File file4;
        int nodeId = 1;
        String clusterId = this.clusterIdBase64();
        File file5 = file4 = TestUtils.tempDirectory(null, null);
        file4 = null;
        File file6 = file3 = file5;
        file3 = null;
        File metadataDir = file6;
        File file7 = file2 = TestUtils.tempDirectory(null, null);
        file2 = null;
        File file8 = file = file7;
        file = null;
        File dataDir = file8;
        package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new File[]{metadataDir, dataDir})).foreach((Function1 & Serializable)dir -> {
            this.writeMetaProperties(dir, new MetaProperties(clusterId, nodeId));
            return BoxedUnit.UNIT;
        });
        TopicPartition logDirName_topicPartition = KafkaRaftServer$.MODULE$.MetadataPartition();
        Object var9_9 = null;
        Files.createDirectory(new File(dataDir, LocalLog$.MODULE$.logDirName(logDirName_topicPartition)).toPath(), new FileAttribute[0]);
        Properties configProperties = new Properties();
        configProperties.put(KafkaConfig$.MODULE$.ProcessRolesProp(), "broker");
        configProperties.put(KafkaConfig$.MODULE$.NodeIdProp(), Integer.toString(nodeId));
        configProperties.put(KafkaConfig$.MODULE$.QuorumVotersProp(), new StringBuilder(15).append(nodeId + 1).append("@localhost:9092").toString());
        configProperties.put(KafkaConfig$.MODULE$.MetadataLogDirProp(), metadataDir.getAbsolutePath());
        configProperties.put(KafkaConfig$.MODULE$.LogDirProp(), dataDir.getAbsolutePath());
        configProperties.put(KafkaConfig$.MODULE$.ControllerListenerNamesProp(), "SSL");
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(configProperties);
        Assertions.assertThrows(KafkaException.class, () -> KafkaRaftServer$.MODULE$.initializeLogDirs(config));
    }

    @Test
    public void testLoadPropertiesWithInconsistentClusterIds() {
        File file;
        File file2;
        File file3;
        File file4;
        int nodeId = 1;
        File file5 = file4 = TestUtils.tempDirectory(null, null);
        file4 = null;
        File file6 = file3 = file5;
        file3 = null;
        File logDir1 = file6;
        File file7 = file2 = TestUtils.tempDirectory(null, null);
        file2 = null;
        File file8 = file = file7;
        file = null;
        File logDir2 = file8;
        package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new File[]{logDir1, logDir2})).foreach((Function1 & Serializable)dir -> {
            this.writeMetaProperties(dir, new MetaProperties(Uuid.randomUuid().toString(), nodeId));
            return BoxedUnit.UNIT;
        });
        Properties configProperties = new Properties();
        configProperties.put(KafkaConfig$.MODULE$.ProcessRolesProp(), "broker");
        configProperties.put(KafkaConfig$.MODULE$.QuorumVotersProp(), new StringBuilder(15).append(nodeId + 1).append("@localhost:9092").toString());
        configProperties.put(KafkaConfig$.MODULE$.NodeIdProp(), Integer.toString(nodeId));
        configProperties.put(KafkaConfig$.MODULE$.LogDirProp(), ((IterableOnceOps)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new File[]{logDir1, logDir2})).map((Function1 & Serializable)x$4 -> x$4.getAbsolutePath())).mkString(","));
        configProperties.put(KafkaConfig$.MODULE$.ControllerListenerNamesProp(), "SSL");
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(configProperties);
        Assertions.assertThrows(InconsistentBrokerMetadataException.class, () -> KafkaRaftServer$.MODULE$.initializeLogDirs(config));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testKRaftUpdateWithIBP() {
        void var7_7;
        void var8_8;
        void var6_6;
        String clusterId = this.clusterIdBase64();
        int nodeId = 0;
        MetaProperties metaProperties = new MetaProperties(clusterId, nodeId);
        Properties configProperties = new Properties();
        configProperties.put(KafkaConfig$.MODULE$.ProcessRolesProp(), "broker,controller");
        configProperties.put(KafkaConfig$.MODULE$.NodeIdProp(), Integer.toString(nodeId));
        configProperties.put(KafkaConfig$.MODULE$.ListenersProp(), "PLAINTEXT://127.0.0.1:9092,SSL://127.0.0.1:9093");
        configProperties.put(KafkaConfig$.MODULE$.QuorumVotersProp(), new StringBuilder(15).append(nodeId).append("@localhost:9093").toString());
        configProperties.put(KafkaConfig$.MODULE$.ControllerListenerNamesProp(), "SSL");
        configProperties.put(KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp(), "3.3-IV1");
        Tuple3<MetaProperties, BootstrapMetadata, Seq<String>> tuple3 = this.invokeLoadMetaProperties(metaProperties, configProperties, (Option<MetadataVersion>)None$.MODULE$);
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        MetaProperties loadedMetaProperties = (MetaProperties)tuple3._1();
        BootstrapMetadata bootstrapMetadata = (BootstrapMetadata)tuple3._2();
        Seq offlineDirs = (Seq)tuple3._3();
        Assertions.assertEquals((Object)metaProperties, (Object)var6_6);
        Assertions.assertEquals((Object)package$.MODULE$.Seq().empty(), (Object)var8_8);
        Assertions.assertEquals((Object)var7_7.metadataVersion(), (Object)MetadataVersion.IBP_3_3_IV1);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testKRaftUpdateWithoutIBP() {
        void var8_10;
        void var9_11;
        void var7_9;
        File file;
        File file2;
        String clusterId = this.clusterIdBase64();
        int nodeId = 0;
        MetaProperties metaProperties = new MetaProperties(clusterId, nodeId);
        File file3 = file2 = TestUtils.tempDirectory(null, null);
        file2 = null;
        File file4 = file = file3;
        file = null;
        File logDir = file4;
        this.writeMetaProperties(logDir, metaProperties);
        Properties configProperties = new Properties();
        configProperties.put(KafkaConfig$.MODULE$.ProcessRolesProp(), "broker,controller");
        configProperties.put(KafkaConfig$.MODULE$.NodeIdProp(), Integer.toString(nodeId));
        configProperties.put(KafkaConfig$.MODULE$.ListenersProp(), "PLAINTEXT://127.0.0.1:9092,SSL://127.0.0.1:9093");
        configProperties.put(KafkaConfig$.MODULE$.QuorumVotersProp(), new StringBuilder(15).append(nodeId).append("@localhost:9093").toString());
        configProperties.put(KafkaConfig$.MODULE$.ControllerListenerNamesProp(), "SSL");
        configProperties.put(KafkaConfig$.MODULE$.LogDirProp(), logDir.getAbsolutePath());
        Tuple3<MetaProperties, BootstrapMetadata, Seq<String>> tuple3 = this.invokeLoadMetaProperties(metaProperties, configProperties, (Option<MetadataVersion>)None$.MODULE$);
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        MetaProperties loadedMetaProperties = (MetaProperties)tuple3._1();
        BootstrapMetadata bootstrapMetadata = (BootstrapMetadata)tuple3._2();
        Seq offlineDirs = (Seq)tuple3._3();
        Assertions.assertEquals((Object)metaProperties, (Object)var7_9);
        Assertions.assertEquals((Object)package$.MODULE$.Seq().empty(), (Object)var9_11);
        Assertions.assertEquals((Object)var8_10.metadataVersion(), (Object)MetadataVersion.latest());
    }

    public KafkaRaftServerTest() {
        this.clusterIdBase64 = "H3KKO4NTRPaCWtEmm3vW7A";
    }
}

