/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import com.yammer.metrics.core.Metric;
import com.yammer.metrics.core.MetricName;
import java.io.File;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.nio.ByteBuffer;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Semaphore;
import kafka.api.ApiVersion;
import kafka.api.ApiVersion$;
import kafka.api.KAFKA_2_6_IV0$;
import kafka.api.KAFKA_3_2_IV0$;
import kafka.cluster.AbstractPartitionTest;
import kafka.cluster.CommittedPartitionState;
import kafka.cluster.DelayedOperations;
import kafka.cluster.IsrChangeListener;
import kafka.cluster.OngoingReassignmentState;
import kafka.cluster.Partition;
import kafka.cluster.Partition$;
import kafka.cluster.PartitionState;
import kafka.cluster.PendingShrinkIsr;
import kafka.cluster.Replica;
import kafka.cluster.SimpleAssignmentState;
import kafka.common.UnexpectedAppendOffsetException;
import kafka.log.AppendOrigin;
import kafka.log.CleanerConfig;
import kafka.log.ClientRecordDeletion$;
import kafka.log.LoadedLogOffsets;
import kafka.log.LocalLog;
import kafka.log.LogAppendInfo;
import kafka.log.LogLoader;
import kafka.log.LogManager;
import kafka.log.LogReadInfo;
import kafka.log.LogSegments;
import kafka.log.LogStartOffsetIncrementReason;
import kafka.log.ProducerStateManager;
import kafka.log.UnifiedLog;
import kafka.log.UnifiedLog$;
import kafka.metrics.KafkaYammerMetrics;
import kafka.server.AlterIsrItem;
import kafka.server.AlterIsrManager;
import kafka.server.BrokerToControllerChannelManager;
import kafka.server.BrokerTopicStats;
import kafka.server.ControllerRequestCompletionHandler;
import kafka.server.DefaultAlterIsrManager;
import kafka.server.Defaults$;
import kafka.server.FetchIsolation;
import kafka.server.FetchLogEnd$;
import kafka.server.LogDirFailureChannel;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.MetadataCache;
import kafka.server.RequestLocal;
import kafka.server.RequestLocal$;
import kafka.server.ZkIsrManager;
import kafka.server.checkpoints.OffsetCheckpoints;
import kafka.server.epoch.LeaderEpochFileCache;
import kafka.server.metadata.ConfigRepository;
import kafka.server.metadata.MockConfigRepository;
import kafka.utils.KafkaScheduler;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.common.IsolationLevel;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.InconsistentTopicIdException;
import org.apache.kafka.common.errors.NotLeaderOrFollowerException;
import org.apache.kafka.common.errors.OffsetNotAvailableException;
import org.apache.kafka.common.errors.OffsetOutOfRangeException;
import org.apache.kafka.common.message.AlterPartitionResponseData;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.message.LeaderAndIsrRequestData;
import org.apache.kafka.common.message.OffsetForLeaderEpochResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.DefaultRecordBatch;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.AlterPartitionResponse;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.utils.SystemTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.metadata.LeaderRecoveryState;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.verification.VerificationMode;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0005\r\u0005b\u0001\u0002$H\u00011CQ!\u0015\u0001\u0005\u0002ICQ\u0001\u0016\u0001\u0005\u0002UCQ!\u001b\u0001\u0005\u0002UCQa\u001b\u0001\u0005\u0002UCQ!\u001c\u0001\u0005\u0002UCQa\u001c\u0001\u0005\u0002UCQ!\u001d\u0001\u0005\u0002UCQa\u001d\u0001\u0005\u0002UCQ!\u001e\u0001\u0005\u0002UCQa\u001e\u0001\u0005\u0002UCQ!\u001f\u0001\u0005\u0002UCQa\u001f\u0001\u0005\u0002UCQ! \u0001\u0005\u0002UCQa \u0001\u0005\u0002UCa!a\u0001\u0001\t\u0003)\u0006BBA\u0004\u0001\u0011\u0005Q\u000b\u0003\u0004\u0002\f\u0001!\t!\u0016\u0005\u0007\u0003\u001f\u0001A\u0011A+\t\r\u0005M\u0001\u0001\"\u0001V\u0011\u0019\t9\u0002\u0001C\u0001+\"1\u00111\u0004\u0001\u0005\u0002UCa!a\b\u0001\t\u0003)\u0006bBA\u0012\u0001\u0011\u0005\u0011Q\u0005\u0005\n\u0003g\u0002\u0011\u0013!C\u0001\u0003kBq!a#\u0001\t\u0003\ti\t\u0003\u0004\u0002\u0014\u0002!\t!\u0016\u0005\u0007\u0003/\u0003A\u0011A+\t\r\u0005m\u0005\u0001\"\u0001V\u0011\u0019\ty\n\u0001C\u0001+\"1\u00111\u0015\u0001\u0005\u0002UCa!a*\u0001\t\u0003)\u0006BBAV\u0001\u0011\u0005Q\u000b\u0003\u0004\u00020\u0002!\t!\u0016\u0005\u0007\u0003g\u0003A\u0011A+\t\r\u0005]\u0006\u0001\"\u0001V\u0011\u0019\tY\f\u0001C\u0001+\"1\u0011q\u0018\u0001\u0005\u0002UCa!a1\u0001\t\u0003)\u0006BBAd\u0001\u0011\u0005Q\u000bC\u0004\u0002L\u0002!\t!!4\t\u000f\u0005=\b\u0001\"\u0003\u0002r\"I!q\u0005\u0001\u0012\u0002\u0013%!\u0011\u0006\u0005\n\u0005[\u0001\u0011\u0013!C\u0005\u0003kB\u0011Ba\f\u0001#\u0003%I!!\u001e\t\r\tE\u0002\u0001\"\u0001V\u0011\u0019\u0011)\u0004\u0001C\u0001+\"1!\u0011\b\u0001\u0005\u0002UCaA!\u0010\u0001\t\u0003)\u0006B\u0002B!\u0001\u0011\u0005Q\u000b\u0003\u0004\u0003F\u0001!\t!\u0016\u0005\b\u0005\u0013\u0002A\u0011\u0001B&\u0011\u0019\u0011Y\u0006\u0001C\u0001+\"1!q\f\u0001\u0005\u0002UCaAa\u0019\u0001\t\u0003)\u0006B\u0002B4\u0001\u0011\u0005Q\u000b\u0003\u0004\u0003l\u0001!\t!\u0016\u0005\u0007\u0005_\u0002A\u0011A+\t\u000f\tM\u0004\u0001\"\u0003\u0003v!I!1\u0015\u0001\u0012\u0002\u0013%!Q\u0015\u0005\b\u0005S\u0003A\u0011\u0002BV\r\u0019\u0011\t\r\u0001\u0003\u0003D\"Q!qV\u001f\u0003\u0002\u0003\u0006IA!-\t\u0015\t\u0015WH!A!\u0002\u0013\t\u0019\u0007\u0003\u0006\u0003Hv\u0012\t\u0011)A\u0005\u0005\u0013D!Ba4>\u0005\u0003\u0005\u000b\u0011\u0002Bi\u00111\u0011\u0019/\u0010B\u0001B\u0003%!Q\u001dBv\u0011)\u0011i/\u0010B\u0001B\u0003%!q\u001e\u0005\u0007#v\"\taa\u0001\t\u000f\rUQ\b\"\u0011\u0004\u0018\ti\u0001+\u0019:uSRLwN\u001c+fgRT!\u0001S%\u0002\u000f\rdWo\u001d;fe*\t!*A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001i\u0005C\u0001(P\u001b\u00059\u0015B\u0001)H\u0005U\t%m\u001d;sC\u000e$\b+\u0019:uSRLwN\u001c+fgR\fa\u0001P5oSRtD#A*\u0011\u00059\u0003\u0011a\b;fgRd\u0015m\u001d;GKR\u001c\u0007.\u001a3PM\u001a\u001cX\r\u001e,bY&$\u0017\r^5p]R\ta\u000b\u0005\u0002X56\t\u0001LC\u0001Z\u0003\u0015\u00198-\u00197b\u0013\tY\u0006L\u0001\u0003V]&$\bF\u0001\u0002^!\tqv-D\u0001`\u0015\t\u0001\u0017-A\u0002ba&T!AY2\u0002\u000f),\b/\u001b;fe*\u0011A-Z\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002M\u0006\u0019qN]4\n\u0005!|&\u0001\u0002+fgR\fq\u0004^3ti6\u000b7.\u001a'fC\u0012,'/\u00169eCR,7/\u00129pG\"\u001c\u0015m\u00195fQ\t\u0019Q,\u0001\u0015uKN$X*Y=cKJ+\u0007\u000f\\1dK\u000e+(O]3oi^KG\u000f\u001b$viV\u0014XMU3qY&\u001c\u0017\r\u000b\u0002\u0005;\u0006iC/Z:u\u001b\u0006\\WMR8mY><XM],ji\"<\u0016\u000e\u001e5G_2dwn^3s\u0003B\u0004XM\u001c3SK\u000e|'\u000fZ:)\u0005\u0015i\u0016\u0001\u0010;fgRl\u0015-\u001f2f%\u0016\u0004H.Y2f\u0007V\u0014(/\u001a8u/&$\bNR;ukJ,'+\u001a9mS\u000e\fG)\u001b4gKJ,g\u000e\u001e\"bg\u0016|eMZ:fiND#AB/\u0002_Q,7\u000f\u001e$fi\u000eDwJ\u001a4tKR\u001cf.\u00199tQ>$X\t]8dQZ\u000bG.\u001b3bi&|gNR8s\u0019\u0016\fG-\u001a:)\u0005\u001di\u0016!\r;fgR4U\r^2i\u001f\u001a47/\u001a;T]\u0006\u00048\u000f[8u\u000bB|7\r\u001b,bY&$\u0017\r^5p]\u001a{'OR8mY><XM\u001d\u0015\u0003\u0011u\u000b1\u0006^3ti>3gm]3u\r>\u0014H*Z1eKJ,\u0005o\\2i-\u0006d\u0017\u000eZ1uS>tgi\u001c:MK\u0006$WM\u001d\u0015\u0003\u0013u\u000bQ\u0006^3ti>3gm]3u\r>\u0014H*Z1eKJ,\u0005o\\2i-\u0006d\u0017\u000eZ1uS>tgi\u001c:G_2dwn^3sQ\tQQ,\u0001\u0014uKN$(+Z1e%\u0016\u001cwN\u001d3Fa>\u001c\u0007NV1mS\u0012\fG/[8o\r>\u0014H*Z1eKJD#aC/\u0002QQ,7\u000f\u001e*fC\u0012\u0014VmY8sI\u0016\u0003xn\u00195WC2LG-\u0019;j_:4uN\u001d$pY2|w/\u001a:)\u00051i\u0016a\r;fgR4U\r^2i\u001f\u001a47/\u001a;G_J$\u0016.\\3ti\u0006l\u0007/\u00129pG\"4\u0016\r\\5eCRLwN\u001c$pe2+\u0017\rZ3sQ\tiQ,A\u001buKN$h)\u001a;dQ>3gm]3u\r>\u0014H+[7fgR\fW\u000e]#q_\u000eDg+\u00197jI\u0006$\u0018n\u001c8G_J4u\u000e\u001c7po\u0016\u0014\bF\u0001\b^\u0003!\"Xm\u001d;GKR\u001c\u0007\u000eT1uKN$xJ\u001a4tKRLen\u00197vI\u0016\u001cH*Z1eKJ,\u0005o\\2iQ\tyQ,A\u0013uKN$Xj\u001c8pi>t\u0017nY(gMN,Go]!gi\u0016\u0014H*Z1eKJ\u001c\u0005.\u00198hK\"\u0012\u0001#X\u0001/i\u0016\u001cH/\u00119qK:$'+Z2pe\u0012\u001c\u0018i\u001d$pY2|w/\u001a:CK2|w\u000fT8h'R\f'\u000f^(gMN,G\u000f\u000b\u0002\u0012;\u0006iB/Z:u\u0019&\u001cHo\u00144gg\u0016$\u0018j]8mCRLwN\u001c'fm\u0016d7\u000f\u000b\u0002\u0013;\u0006qA/Z:u\u000f\u0016$(+\u001a9mS\u000e\f\u0007FA\n^\u0003]\"Xm\u001d;BaB,g\u000e\u001a*fG>\u0014Hm\u001d+p\r>dGn\\<fe^KG\u000f\u001b(p%\u0016\u0004H.[2b)\"\u0014xn^:Fq\u000e,\u0007\u000f^5p]\"\u0012A#X\u0001%i\u0016\u001cH/T1lK\u001a{G\u000e\\8xKJ<\u0016\u000e\u001e5O_2+\u0017\rZ3s\u0013\u0012\u001c\u0005.\u00198hK\"\u0012Q#X\u0001Hi\u0016\u001cHOR8mY><XM\u001d#pKNtu\u000e\u001e&pS:L5KU+oi&d7)Y;hQR,\u0006\u000fV8PM\u001a\u001cX\r^,ji\"LgnQ;se\u0016tG\u000fT3bI\u0016\u0014X\t]8dQ\"\u0012a#X\u0001\u000eGJ,\u0017\r^3SK\u000e|'\u000fZ:\u0015\u0011\u0005\u001d\u0012QHA0\u0003S\u0002B!!\u000b\u0002:5\u0011\u00111\u0006\u0006\u0005\u0003[\ty#\u0001\u0004sK\u000e|'\u000f\u001a\u0006\u0005\u0003c\t\u0019$\u0001\u0004d_6lwN\u001c\u0006\u0004\u0015\u0006U\"bAA\u001cK\u00061\u0011\r]1dQ\u0016LA!a\u000f\u0002,\tiQ*Z7pef\u0014VmY8sINDq!a\u0010\u0018\u0001\u0004\t\t%A\u0004sK\u000e|'\u000fZ:\u0011\r\u0005\r\u00131KA-\u001d\u0011\t)%a\u0014\u000f\t\u0005\u001d\u0013QJ\u0007\u0003\u0003\u0013R1!a\u0013L\u0003\u0019a$o\\8u}%\t\u0011,C\u0002\u0002Ra\u000bq\u0001]1dW\u0006<W-\u0003\u0003\u0002V\u0005]#\u0001C%uKJ\f'\r\\3\u000b\u0007\u0005E\u0003\f\u0005\u0003\u0002*\u0005m\u0013\u0002BA/\u0003W\u0011AbU5na2,'+Z2pe\u0012Dq!!\u0019\u0018\u0001\u0004\t\u0019'\u0001\u0006cCN,wJ\u001a4tKR\u00042aVA3\u0013\r\t9\u0007\u0017\u0002\u0005\u0019>tw\rC\u0005\u0002l]\u0001\n\u00111\u0001\u0002n\u0005!\u0002/\u0019:uSRLwN\u001c'fC\u0012,'/\u00129pG\"\u00042aVA8\u0013\r\t\t\b\u0017\u0002\u0004\u0013:$\u0018aF2sK\u0006$XMU3d_J$7\u000f\n3fM\u0006,H\u000e\u001e\u00134+\t\t9H\u000b\u0003\u0002n\u0005e4FAA>!\u0011\ti(a\"\u000e\u0005\u0005}$\u0002BAA\u0003\u0007\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\u0015\u0005,\u0001\u0006b]:|G/\u0019;j_:LA!!#\u0002\u0000\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u00025\r\u0014X-\u0019;f)J\fgn]1di&|g.\u00197SK\u000e|'\u000fZ:\u0015\r\u0005\u001d\u0012qRAI\u0011\u001d\ty$\u0007a\u0001\u0003\u0003Bq!!\u0019\u001a\u0001\u0004\t\u0019'\u0001\u0007uKN$\u0018\t^'j]&\u001b(\u000f\u000b\u0002\u001b;\u0006aB/Z:u+B$\u0017\r^3G_2dwn^3s\r\u0016$8\r[*uCR,\u0007FA\u000e^\u00039\"Xm\u001d;J]Z\fG.\u001b3BYR,'\u000fU1si&$\u0018n\u001c8SKF,Xm\u001d;t\u0003J,gj\u001c;SKR\u0014\u0018.\u001a3)\u0005qi\u0016\u0001\u0005;fgRL5O]#ya\u0006t7/[8oQ\tiR,A\u0010uKN$\u0018j\u001d:O_R,\u0005\u0010]1oI\u0016$\u0017JZ+qI\u0006$XMR1jYND#AH/\u0002%Q,7\u000f\u001e*fiJL8\u000b\u001b:j].L5O\u001d\u0015\u0003?u\u000b!\u0003^3ti6\u000b\u0017PY3TQJLgn[%te\"\u0012\u0001%X\u0001\u001di\u0016\u001cH/\u00117uKJL5O\u001d'fC\u0012,'/\u00118e\u0013N\u0014(+Y2fQ\t\tS,A\u0018uKN$8\u000b[8vY\u0012tu\u000e^*ie&t7.S:s\u0013\u001a\u0004&/\u001a<j_V\u001ch)\u001a;dQ&\u001b8)Y;hQR,\u0006\u000f\u000b\u0002#;\u0006\u0001D/Z:u'\"|W\u000f\u001c3O_R\u001c\u0006N]5oW&\u001b(/\u00134G_2dwn^3s\u0007\u0006,x\r\u001b;VaR{Gj\\4F]\u0012D#aI/\u0002;Q,7\u000f^%te:{Go\u00155sk:\\\u0017JZ+qI\u0006$XMR1jYND#\u0001J/\u00021Q,7\u000f^!mi\u0016\u0014\u0018j\u001d:V].twn\u001e8U_BL7\r\u000b\u0002&;\u0006QB/Z:u\u00032$XM]%te&sg/\u00197jIZ+'o]5p]\"\u0012a%X\u0001\u001ci\u0016\u001cH/\u00117uKJL5O]+oKb\u0004Xm\u0019;fI\u0016\u0013(o\u001c:)\u0005\u001dj\u0016!\u00065b]\u0012dW-\u00117uKJL5O\u001d$bS2,(/\u001a\u000b\u0006-\u0006=\u0017q\u001c\u0005\b\u0003#D\u0003\u0019AAj\u0003\u0015)'O]8s!\u0011\t).a7\u000e\u0005\u0005]'\u0002BAm\u0003_\t\u0001\u0002\u001d:pi>\u001cw\u000e\\\u0005\u0005\u0003;\f9N\u0001\u0004FeJ|'o\u001d\u0005\b\u0003CD\u0003\u0019AAr\u0003!\u0019\u0017\r\u001c7cC\u000e\\\u0007CC,\u0002f\u00065\u0014QNAu-&\u0019\u0011q\u001d-\u0003\u0013\u0019+hn\u0019;j_:\u001c\u0004c\u0001(\u0002l&\u0019\u0011Q^$\u0003\u0013A\u000b'\u000f^5uS>t\u0017AL2sK\u0006$Xm\u00117jK:$(+Z:q_:\u001cXmV5uQ\u0006cG/\u001a:QCJ$\u0018\u000e^5p]J+7\u000f]8og\u0016$B\"a=\u0002\u0000\n-!Q\u0003B\u0010\u0005G\u0001B!!>\u0002|6\u0011\u0011q\u001f\u0006\u0005\u0003s\f\u0019$A\u0004dY&,g\u000e^:\n\t\u0005u\u0018q\u001f\u0002\u000f\u00072LWM\u001c;SKN\u0004xN\\:f\u0011\u001d\u0011\t!\u000ba\u0001\u0005\u0007\ta\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0005\u0003\u0003\u0006\t\u001dQBAA\u0018\u0013\u0011\u0011I!a\f\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\"9!QB\u0015A\u0002\t=\u0011A\u00059beRLG/[8o\u000bJ\u0014xN]\"pI\u0016\u00042a\u0016B\t\u0013\r\u0011\u0019\u0002\u0017\u0002\u0006'\"|'\u000f\u001e\u0005\n\u0005/I\u0003\u0013!a\u0001\u00053\t1![:s!\u0019\t\u0019Ea\u0007\u0002n%!!QDA,\u0005\u0011a\u0015n\u001d;\t\u0013\t\u0005\u0012\u0006%AA\u0002\u00055\u0014a\u00037fC\u0012,'/\u00129pG\"D\u0011B!\n*!\u0003\u0005\r!!\u001c\u0002\u001dA\f'\u000f^5uS>tW\t]8dQ\u0006A4M]3bi\u0016\u001cE.[3oiJ+7\u000f]8og\u0016<\u0016\u000e\u001e5BYR,'\u000fU1si&$\u0018n\u001c8SKN\u0004xN\\:fI\u0011,g-Y;mi\u0012\u001aTC\u0001B\u0016U\u0011\u0011I\"!\u001f\u0002q\r\u0014X-\u0019;f\u00072LWM\u001c;SKN\u0004xN\\:f/&$\b.\u00117uKJ\u0004\u0016M\u001d;ji&|gNU3ta>t7/\u001a\u0013eK\u001a\fW\u000f\u001c;%i\u0005A4M]3bi\u0016\u001cE.[3oiJ+7\u000f]8og\u0016<\u0016\u000e\u001e5BYR,'\u000fU1si&$\u0018n\u001c8SKN\u0004xN\\:fI\u0011,g-Y;mi\u0012*\u0014!\f;fgR\u0004\u0016M\u001d;ji&|gn\u00155pk2$'+\u001a;ss\u0006cG/\u001a:QCJ$\u0018\u000e^5p]J+\u0017/^3ti\"\u0012Q&X\u0001\u001bi\u0016\u001cHoU5oO2,\u0017J\u001c$mS\u001eDG/\u00117uKJL5O\u001d\u0015\u0003]u\u000bQ\u0004^3tij[\u0017j\u001d:NC:\fw-\u001a:Bgft7mQ1mY\n\f7m\u001b\u0015\u0003_u\u000b!\u0006^3tiV\u001bXm\u00115fG.\u0004x.\u001b8u)>Le.\u001b;jC2L'0\u001a%jO\"<\u0016\r^3s[\u0006\u00148\u000e\u000b\u00021;\u0006aC/Z:u)>\u0004\u0018nY%e\u0003:$\u0007+\u0019:uSRLwN\\'fi\u0006$\u0017\r^1GS2,gi\u001c:MK\u0006$WM\u001d\u0015\u0003cu\u000ba\u0006^3tiR{\u0007/[2JI\u0006sG\rU1si&$\u0018n\u001c8NKR\fG-\u0019;b\r&dWMR8s\r>dGn\\<fe\"\u0012!'X\u0001\rG\",7m\u001b+pa&\u001c\u0017\n\u001a\u000b\u0006-\n5#q\u000b\u0005\b\u0005\u001f\u001a\u0004\u0019\u0001B)\u0003=)\u0007\u0010]3di\u0016$Gk\u001c9jG&#\u0007\u0003\u0002B\u0003\u0005'JAA!\u0016\u00020\t!Q+^5e\u0011\u001d\u0011If\ra\u0001\u0003S\f\u0011\u0002]1si&$\u0018n\u001c8\u0002/Q,7\u000f^!eI\u0006sGMU3n_Z,W*\u001a;sS\u000e\u001c\bF\u0001\u001b^\u00035\"Xm\u001d;V]\u0012,'OU3qY&\u001c\u0017\r^3e!\u0006\u0014H/\u001b;j_:\u001c8i\u001c:sK\u000e$8+Z7b]RL7m\u001d\u0015\u0003ku\u000b!\u0004^3tiV\u0003H-\u0019;f\u0003N\u001c\u0018n\u001a8nK:$\u0018I\u001c3JgJD#AN/\u0002+Q,7\u000f\u001e'pO\u000e{gNZ5h\u001d>$H)\u001b:us\"\u0012q'X\u0001!i\u0016\u001cH\u000fT8h\u0007>tg-[4ESJ$\u00180Q:U_BL7-\u00169eCR,G\r\u000b\u00029;\u0006\tC/Z:u\u0019><7i\u001c8gS\u001e$\u0015N\u001d;z\u0003N\u0014%o\\6feV\u0003H-\u0019;fI\"\u0012\u0011(X\u0001\u000b[\u0006\\W\rT3bI\u0016\u0014HC\u0005B<\u0005{\u00129Ia#\u0003\u000e\nU%\u0011\u0014BO\u0005C\u00032a\u0016B=\u0013\r\u0011Y\b\u0017\u0002\b\u0005>|G.Z1o\u0011\u001d\u0011yH\u000fa\u0001\u0005\u0003\u000bq\u0001^8qS\u000eLE\rE\u0003X\u0005\u0007\u0013\t&C\u0002\u0003\u0006b\u0013aa\u00149uS>t\u0007b\u0002BEu\u0001\u0007\u0011QN\u0001\u0010G>tGO]8mY\u0016\u0014X\t]8dQ\"9!\u0011\u0005\u001eA\u0002\u00055\u0004b\u0002B\fu\u0001\u0007!q\u0012\t\u0007\u0003\u0007\u0012\t*!\u001c\n\t\tM\u0015q\u000b\u0002\u0004'\u0016\f\bb\u0002BLu\u0001\u0007!qR\u0001\te\u0016\u0004H.[2bg\"9!1\u0014\u001eA\u0002\u00055\u0014!\u0003>l-\u0016\u00148/[8o\u0011\u001d\u0011yJ\u000fa\u0001\u0005o\nQ![:OK^D\u0011B!\u0017;!\u0003\u0005\r!!;\u0002)5\f7.\u001a'fC\u0012,'\u000f\n3fM\u0006,H\u000e\u001e\u00139+\t\u00119K\u000b\u0003\u0002j\u0006e\u0014aC:fK\u0012dun\u001a#bi\u0006$rA\u0016BW\u0005w\u0013y\fC\u0004\u00030r\u0002\rA!-\u0002\u00071|w\r\u0005\u0003\u00034\n]VB\u0001B[\u0015\r\u0011y+S\u0005\u0005\u0005s\u0013)L\u0001\u0006V]&4\u0017.\u001a3M_\u001eDqA!0=\u0001\u0004\ti'\u0001\u0006ok6\u0014VmY8sINDqA!\t=\u0001\u0004\tiGA\u0004TY><Hj\\4\u0014\u0007u\u0012\t,\u0001\bm_\u001e\u001cF/\u0019:u\u001f\u001a47/\u001a;\u0002\u00111|7-\u00197M_\u001e\u0004BAa-\u0003L&!!Q\u001aB[\u0005!aunY1m\u0019><\u0017\u0001\u00057fC\u0012,'/\u00129pG\"\u001c\u0015m\u00195f!\u00159&1\u0011Bj!\u0011\u0011)Na8\u000e\u0005\t]'\u0002\u0002Bm\u00057\fQ!\u001a9pG\"T1A!8J\u0003\u0019\u0019XM\u001d<fe&!!\u0011\u001dBl\u0005QaU-\u00193fe\u0016\u0003xn\u00195GS2,7)Y2iK\u0006!\u0002O]8ek\u000e,'o\u0015;bi\u0016l\u0015M\\1hKJ\u0004BAa-\u0003h&!!\u0011\u001eB[\u0005Q\u0001&o\u001c3vG\u0016\u00148\u000b^1uK6\u000bg.Y4fe&!!1\u001dB\\\u0003=\t\u0007\u000f]3oIN+W.\u00199i_J,\u0007\u0003\u0002By\u0005\u007fl!Aa=\u000b\t\tU(q_\u0001\u000bG>t7-\u001e:sK:$(\u0002\u0002B}\u0005w\fA!\u001e;jY*\u0011!Q`\u0001\u0005U\u00064\u0018-\u0003\u0003\u0004\u0002\tM(!C*f[\u0006\u0004\bn\u001c:f)9\u0019)a!\u0003\u0004\f\r51qBB\t\u0007'\u00012aa\u0002>\u001b\u0005\u0001\u0001b\u0002BX\t\u0002\u0007!\u0011\u0017\u0005\b\u0005\u000b$\u0005\u0019AA2\u0011\u001d\u00119\r\u0012a\u0001\u0005\u0013DqAa4E\u0001\u0004\u0011\t\u000eC\u0004\u0003d\u0012\u0003\rA!:\t\u000f\t5H\t1\u0001\u0003p\u0006\u0001\u0012\r\u001d9f]\u0012\f5OR8mY><XM\u001d\u000b\u0005\u00073\u0019y\u0002\u0005\u0003\u00034\u000em\u0011\u0002BB\u000f\u0005k\u0013Q\u0002T8h\u0003B\u0004XM\u001c3J]\u001a|\u0007bBA \u000b\u0002\u0007\u0011q\u0005")
public class PartitionTest
extends AbstractPartitionTest {
    @Test
    public void testLastFetchedOffsetValidation() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = this.topicPartition();
        None$ x$2 = None$.MODULE$;
        boolean x$3 = qual$1.getOrCreateLog$default$2();
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        UnifiedLog log = qual$1.getOrCreateLog(x$1, x$3, x$4, (Option)x$2);
        PartitionTest.append$1(0, 2, log);
        PartitionTest.append$1(3, 3, log);
        PartitionTest.append$1(3, 3, log);
        PartitionTest.append$1(4, 5, log);
        PartitionTest.append$1(7, 1, log);
        PartitionTest.append$1(9, 3, log);
        Assertions.assertEquals((long)17L, (long)log.logEndOffset());
        int leaderEpoch = 10;
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, true);
        PartitionTest.assertDivergence$1(PartitionTest.epochEndOffset$1(0, 2L), PartitionTest.read$1(2, 5L, partition, leaderEpoch));
        PartitionTest.assertDivergence$1(PartitionTest.epochEndOffset$1(0, 2L), PartitionTest.read$1(0, 4L, partition, leaderEpoch));
        PartitionTest.assertDivergence$1(PartitionTest.epochEndOffset$1(4, 13L), PartitionTest.read$1(6, 6L, partition, leaderEpoch));
        PartitionTest.assertDivergence$1(PartitionTest.epochEndOffset$1(4, 13L), PartitionTest.read$1(5, 9L, partition, leaderEpoch));
        PartitionTest.assertDivergence$1(PartitionTest.epochEndOffset$1(10, 17L), PartitionTest.read$1(10, 18L, partition, leaderEpoch));
        PartitionTest.assertNoDivergence$1(PartitionTest.read$1(0, 2L, partition, leaderEpoch));
        PartitionTest.assertNoDivergence$1(PartitionTest.read$1(7, 14L, partition, leaderEpoch));
        PartitionTest.assertNoDivergence$1(PartitionTest.read$1(9, 17L, partition, leaderEpoch));
        PartitionTest.assertNoDivergence$1(PartitionTest.read$1(10, 17L, partition, leaderEpoch));
        Assertions.assertThrows(OffsetOutOfRangeException.class, () -> PartitionTest.read$1(11, 5L, partition, leaderEpoch));
        log.updateHighWatermark(log.logEndOffset());
        log.maybeIncrementLogStartOffset(5L, (LogStartOffsetIncrementReason)ClientRecordDeletion$.MODULE$);
        PartitionTest.assertDivergence$1(PartitionTest.epochEndOffset$1(2, 5L), PartitionTest.read$1(2, 8L, partition, leaderEpoch));
        PartitionTest.assertNoDivergence$1(PartitionTest.read$1(0, 5L, partition, leaderEpoch));
        PartitionTest.assertNoDivergence$1(PartitionTest.read$1(3, 5L, partition, leaderEpoch));
        Assertions.assertThrows(OffsetOutOfRangeException.class, () -> PartitionTest.read$1(0, 0L, partition, leaderEpoch));
        log.maybeIncrementLogStartOffset(10L, (LogStartOffsetIncrementReason)ClientRecordDeletion$.MODULE$);
        Assertions.assertThrows(OffsetOutOfRangeException.class, () -> PartitionTest.read$1(5, 6L, partition, leaderEpoch));
        Assertions.assertThrows(OffsetOutOfRangeException.class, () -> PartitionTest.read$1(3, 6L, partition, leaderEpoch));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testMakeLeaderUpdatesEpochCache() {
        void withRecords_records;
        void withRecords_partitionLeaderEpoch;
        void withRecords_compressionType;
        void withRecords_records2;
        void withRecords_partitionLeaderEpoch2;
        void withRecords_compressionType2;
        int leaderEpoch = 8;
        LogManager qual$1 = this.logManager();
        TopicPartition x$12 = this.topicPartition();
        None$ x$2 = None$.MODULE$;
        boolean x$3 = qual$1.getOrCreateLog$default$2();
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        UnifiedLog log = qual$1.getOrCreateLog(x$12, x$3, x$4, (Option)x$2);
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord("k1".getBytes(), "v1".getBytes()), new SimpleRecord("k2".getBytes(), "v2".getBytes())};
        boolean bl = false;
        CompressionType compressionType = CompressionType.NONE;
        long withRecords_initialOffset = 0L;
        compressionType = null;
        simpleRecordArray = null;
        log.appendAsLeader(MemoryRecords.withRecords((byte)2, (long)withRecords_initialOffset, (CompressionType)withRecords_compressionType2, (TimestampType)TimestampType.CREATE_TIME, (long)-1L, (short)-1, (int)-1, (int)withRecords_partitionLeaderEpoch2, (boolean)false, (SimpleRecord[])withRecords_records2), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        SimpleRecord[] simpleRecordArray2 = new SimpleRecord[]{new SimpleRecord("k3".getBytes(), "v3".getBytes()), new SimpleRecord("k4".getBytes(), "v4".getBytes())};
        int n = 5;
        CompressionType compressionType2 = CompressionType.NONE;
        long withRecords_initialOffset2 = 0L;
        compressionType2 = null;
        simpleRecordArray2 = null;
        log.appendAsLeader(MemoryRecords.withRecords((byte)2, (long)withRecords_initialOffset2, (CompressionType)withRecords_compressionType, (TimestampType)TimestampType.CREATE_TIME, (long)-1L, (short)-1, (int)-1, (int)withRecords_partitionLeaderEpoch, (boolean)false, (SimpleRecord[])withRecords_records), 5, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        Assertions.assertEquals((long)4L, (long)log.logEndOffset());
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, true);
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)4)), (Object)partition.leaderLogIfLocal().map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToLong((long)x$1.logEndOffset())));
        OffsetForLeaderEpochResponseData.EpochEndOffset epochEndOffset = partition.lastOffsetForLeaderEpoch(Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), leaderEpoch, true);
        Assertions.assertEquals((long)4L, (long)epochEndOffset.endOffset());
        Assertions.assertEquals((int)leaderEpoch, (int)epochEndOffset.leaderEpoch());
    }

    @Test
    public void testMaybeReplaceCurrentWithFutureReplica() {
        CountDownLatch latch = new CountDownLatch(1);
        this.logManager().maybeUpdatePreferredLogDir(this.topicPartition(), this.logDir1().getAbsolutePath());
        this.partition().createLogIfNotExists(true, false, this.offsetCheckpoints(), (Option)None$.MODULE$);
        this.logManager().maybeUpdatePreferredLogDir(this.topicPartition(), this.logDir2().getAbsolutePath());
        this.partition().maybeCreateFutureReplica(this.logDir2().getAbsolutePath(), this.offsetCheckpoints());
        Thread thread1 = new Thread(this, latch){
            private final /* synthetic */ PartitionTest $outer;
            private final CountDownLatch latch$1;

            public void run() {
                this.latch$1.await();
                Partition qual$1 = this.$outer.partition();
                boolean x$1 = qual$1.removeFutureLocalReplica$default$1();
                qual$1.removeFutureLocalReplica(x$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.latch$1 = latch$1;
            }
        };
        Thread thread2 = new Thread(this, latch){
            private final /* synthetic */ PartitionTest $outer;
            private final CountDownLatch latch$1;

            public void run() {
                this.latch$1.await();
                this.$outer.partition().maybeReplaceCurrentWithFutureReplica();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.latch$1 = latch$1;
            }
        };
        thread1.start();
        thread2.start();
        latch.countDown();
        thread1.join();
        thread2.join();
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.partition().futureLog());
    }

    @Test
    public void testMakeFollowerWithWithFollowerAppendRecords() {
        Semaphore appendSemaphore = new Semaphore(0);
        MockTime mockTime = new MockTime();
        this.partition_$eq(new Partition(this, mockTime, appendSemaphore){
            private final /* synthetic */ PartitionTest $outer;
            private final MockTime mockTime$1;
            private final Semaphore appendSemaphore$1;

            public UnifiedLog createLog(boolean isNew, boolean isFutureReplica, OffsetCheckpoints offsetCheckpoints, Option<Uuid> topicId) {
                UnifiedLog log = super.createLog(isNew, isFutureReplica, offsetCheckpoints, (Option)None$.MODULE$);
                LogDirFailureChannel logDirFailureChannel = new LogDirFailureChannel(1);
                LogSegments segments = new LogSegments(log.topicPartition());
                Option leaderEpochCache = UnifiedLog$.MODULE$.maybeCreateLeaderEpochCache(log.dir(), log.topicPartition(), logDirFailureChannel, log.config().recordVersion(), "");
                int maxTransactionTimeoutMs = 300000;
                int maxProducerIdExpirationMs = 3600000;
                ProducerStateManager producerStateManager = new ProducerStateManager(log.topicPartition(), log.dir(), maxTransactionTimeoutMs, maxProducerIdExpirationMs, (Time)this.mockTime$1);
                LoadedLogOffsets offsets = new LogLoader(log.dir(), log.topicPartition(), log.config(), (Scheduler)this.mockTime$1.scheduler(), (Time)this.mockTime$1, logDirFailureChannel, true, segments, 0L, 0L, leaderEpochCache, producerStateManager).load();
                LocalLog localLog = new LocalLog(log.dir(), log.config(), segments, offsets.recoveryPoint(), offsets.nextOffsetMetadata(), (Scheduler)this.mockTime$1.scheduler(), (Time)this.mockTime$1, log.topicPartition(), logDirFailureChannel);
                return new SlowLog(this.$outer, log, offsets.logStartOffset(), localLog, (Option<LeaderEpochFileCache>)leaderEpochCache, producerStateManager, this.appendSemaphore$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.mockTime$1 = mockTime$1;
                this.appendSemaphore$1 = appendSemaphore$1;
                super($outer.topicPartition(), Defaults$.MODULE$.ReplicaLagTimeMaxMs(), ApiVersion$.MODULE$.latestVersion(), $outer.brokerId(), (Time)$outer.time(), (IsrChangeListener)$outer.isrChangeListener(), $outer.delayedOperations(), $outer.metadataCache(), $outer.logManager(), (AlterIsrManager)$outer.alterIsrManager());
            }
        });
        this.partition().createLogIfNotExists(true, false, this.offsetCheckpoints(), (Option)None$.MODULE$);
        Thread appendThread = new Thread(this){
            private final /* synthetic */ PartitionTest $outer;

            public void run() {
                MemoryRecords records = this.$outer.createRecords((Iterable<SimpleRecord>)((Iterable)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("k1".getBytes(), "v1".getBytes()), new SimpleRecord("k2".getBytes(), "v2".getBytes())}))), 0L, this.$outer.createRecords$default$3());
                this.$outer.partition().appendRecordsToFollowerOrFutureReplica(records, false);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        appendThread.start();
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!appendSemaphore.hasQueuedThreads()) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"follower log append is not called.");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
        LeaderAndIsrRequestData.LeaderAndIsrPartitionState partitionState = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(0).setLeader(2).setLeaderEpoch(1).setIsr(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(this.brokerId())}))).asJava()).setZkVersion(1).setReplicas(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(this.brokerId())}))).asJava()).setIsNew(false);
        Assertions.assertTrue((boolean)this.partition().makeFollower(partitionState, this.offsetCheckpoints(), (Option)None$.MODULE$));
        appendSemaphore.release();
        appendThread.join();
        Assertions.assertEquals((long)2L, (long)this.partition().localLogOrException().logEndOffset());
        Assertions.assertEquals((long)2L, (long)BoxesRunTime.unboxToInt((Object)this.partition().leaderReplicaIdOpt().get()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testMaybeReplaceCurrentWithFutureReplicaDifferentBaseOffsets() {
        void builder_partitionLeaderEpoch;
        void builder_isTransactional;
        void builder_baseSequence;
        void builder_producerEpoch;
        void builder_logAppendTime;
        void builder_baseOffset;
        void builder_timestampType;
        void builder_compressionType;
        void withRecords_records;
        void withRecords_partitionLeaderEpoch;
        void withRecords_compressionType;
        void withRecords_records2;
        void withRecords_partitionLeaderEpoch2;
        void withRecords_compressionType2;
        this.logManager().maybeUpdatePreferredLogDir(this.topicPartition(), this.logDir1().getAbsolutePath());
        this.partition().createLogIfNotExists(true, false, this.offsetCheckpoints(), (Option)None$.MODULE$);
        this.logManager().maybeUpdatePreferredLogDir(this.topicPartition(), this.logDir2().getAbsolutePath());
        this.partition().maybeCreateFutureReplica(this.logDir2().getAbsolutePath(), this.offsetCheckpoints());
        UnifiedLog currentLog = (UnifiedLog)this.partition().log().get();
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord("k1".getBytes(), "v1".getBytes()), new SimpleRecord("k1".getBytes(), "v2".getBytes()), new SimpleRecord("k1".getBytes(), "v3".getBytes()), new SimpleRecord("k2".getBytes(), "v4".getBytes()), new SimpleRecord("k2".getBytes(), "v5".getBytes()), new SimpleRecord("k2".getBytes(), "v6".getBytes())};
        boolean bl = false;
        CompressionType compressionType = CompressionType.NONE;
        long withRecords_initialOffset = 0L;
        compressionType = null;
        simpleRecordArray = null;
        currentLog.appendAsLeader(MemoryRecords.withRecords((byte)2, (long)withRecords_initialOffset, (CompressionType)withRecords_compressionType2, (TimestampType)TimestampType.CREATE_TIME, (long)-1L, (short)-1, (int)-1, (int)withRecords_partitionLeaderEpoch2, (boolean)false, (SimpleRecord[])withRecords_records2), 0, currentLog.appendAsLeader$default$3(), currentLog.appendAsLeader$default$4(), currentLog.appendAsLeader$default$5());
        currentLog.roll(currentLog.roll$default$1());
        SimpleRecord[] simpleRecordArray2 = new SimpleRecord[]{new SimpleRecord("k3".getBytes(), "v7".getBytes()), new SimpleRecord("k4".getBytes(), "v8".getBytes())};
        boolean bl2 = false;
        CompressionType compressionType2 = CompressionType.NONE;
        long withRecords_initialOffset2 = 0L;
        compressionType2 = null;
        simpleRecordArray2 = null;
        currentLog.appendAsLeader(MemoryRecords.withRecords((byte)2, (long)withRecords_initialOffset2, (CompressionType)withRecords_compressionType, (TimestampType)TimestampType.CREATE_TIME, (long)-1L, (short)-1, (int)-1, (int)withRecords_partitionLeaderEpoch, (boolean)false, (SimpleRecord[])withRecords_records), 0, currentLog.appendAsLeader$default$3(), currentLog.appendAsLeader$default$4(), currentLog.appendAsLeader$default$5());
        ByteBuffer buffer = ByteBuffer.allocate(1024);
        boolean bl3 = false;
        long l = -1L;
        long l2 = 0L;
        TimestampType timestampType = TimestampType.CREATE_TIME;
        CompressionType compressionType3 = CompressionType.NONE;
        byte builder_magic = 2;
        boolean bl4 = false;
        int n = -1;
        int n2 = -1;
        long builder_producerId = -1L;
        compressionType3 = null;
        timestampType = null;
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buffer, (byte)builder_magic, (CompressionType)builder_compressionType, (TimestampType)builder_timestampType, (long)builder_baseOffset, (long)builder_logAppendTime, (long)builder_producerId, (short)builder_producerEpoch, (int)builder_baseSequence, (boolean)builder_isTransactional, (boolean)false, (int)builder_partitionLeaderEpoch);
        builder.appendWithOffset(2L, new SimpleRecord("k1".getBytes(), "v3".getBytes()));
        builder.appendWithOffset(5L, new SimpleRecord("k2".getBytes(), "v6".getBytes()));
        builder.appendWithOffset(6L, new SimpleRecord("k3".getBytes(), "v7".getBytes()));
        builder.appendWithOffset(7L, new SimpleRecord("k4".getBytes(), "v8".getBytes()));
        this.partition().futureLocalLogOrException().appendAsFollower(builder.build());
        Assertions.assertTrue((boolean)this.partition().maybeReplaceCurrentWithFutureReplica());
    }

    @Test
    public void testFetchOffsetSnapshotEpochValidationForLeader() {
        int leaderEpoch = 5;
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, true);
        PartitionTest.assertSnapshotError$1(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), partition);
        PartitionTest.assertSnapshotError$1(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), partition);
        PartitionTest.assertSnapshotError$1(Errors.NONE, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), partition);
        PartitionTest.assertSnapshotError$1(Errors.NONE, Optional.empty(), partition);
    }

    @Test
    public void testFetchOffsetSnapshotEpochValidationForFollower() {
        int leaderEpoch = 5;
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, false);
        PartitionTest.assertSnapshotError$2(Errors.NONE, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), false, partition);
        PartitionTest.assertSnapshotError$2(Errors.NONE, Optional.empty(), false, partition);
        PartitionTest.assertSnapshotError$2(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), false, partition);
        PartitionTest.assertSnapshotError$2(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), false, partition);
        PartitionTest.assertSnapshotError$2(Errors.NOT_LEADER_OR_FOLLOWER, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), true, partition);
        PartitionTest.assertSnapshotError$2(Errors.NOT_LEADER_OR_FOLLOWER, Optional.empty(), true, partition);
        PartitionTest.assertSnapshotError$2(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), true, partition);
        PartitionTest.assertSnapshotError$2(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), true, partition);
    }

    @Test
    public void testOffsetForLeaderEpochValidationForLeader() {
        int leaderEpoch = 5;
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, true);
        PartitionTest.assertLastOffsetForLeaderError$1(Errors.NONE, Optional.empty(), partition);
        PartitionTest.assertLastOffsetForLeaderError$1(Errors.NONE, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), partition);
        PartitionTest.assertLastOffsetForLeaderError$1(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), partition);
        PartitionTest.assertLastOffsetForLeaderError$1(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), partition);
    }

    @Test
    public void testOffsetForLeaderEpochValidationForFollower() {
        int leaderEpoch = 5;
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, false);
        PartitionTest.assertLastOffsetForLeaderError$2(Errors.NONE, Optional.empty(), false, partition);
        PartitionTest.assertLastOffsetForLeaderError$2(Errors.NONE, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), false, partition);
        PartitionTest.assertLastOffsetForLeaderError$2(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), false, partition);
        PartitionTest.assertLastOffsetForLeaderError$2(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), false, partition);
        PartitionTest.assertLastOffsetForLeaderError$2(Errors.NOT_LEADER_OR_FOLLOWER, Optional.empty(), true, partition);
        PartitionTest.assertLastOffsetForLeaderError$2(Errors.NOT_LEADER_OR_FOLLOWER, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), true, partition);
        PartitionTest.assertLastOffsetForLeaderError$2(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), true, partition);
        PartitionTest.assertLastOffsetForLeaderError$2(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), true, partition);
    }

    @Test
    public void testReadRecordEpochValidationForLeader() {
        int leaderEpoch = 5;
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, true);
        PartitionTest.assertReadRecordsError$1(Errors.NONE, Optional.empty(), partition);
        PartitionTest.assertReadRecordsError$1(Errors.NONE, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), partition);
        PartitionTest.assertReadRecordsError$1(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), partition);
        PartitionTest.assertReadRecordsError$1(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), partition);
    }

    @Test
    public void testReadRecordEpochValidationForFollower() {
        int leaderEpoch = 5;
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, false);
        PartitionTest.assertReadRecordsError$2(Errors.NONE, Optional.empty(), false, partition);
        PartitionTest.assertReadRecordsError$2(Errors.NONE, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), false, partition);
        PartitionTest.assertReadRecordsError$2(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), false, partition);
        PartitionTest.assertReadRecordsError$2(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), false, partition);
        PartitionTest.assertReadRecordsError$2(Errors.NOT_LEADER_OR_FOLLOWER, Optional.empty(), true, partition);
        PartitionTest.assertReadRecordsError$2(Errors.NOT_LEADER_OR_FOLLOWER, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), true, partition);
        PartitionTest.assertReadRecordsError$2(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), true, partition);
        PartitionTest.assertReadRecordsError$2(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), true, partition);
    }

    @Test
    public void testFetchOffsetForTimestampEpochValidationForLeader() {
        int leaderEpoch = 5;
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, true);
        PartitionTest.assertFetchOffsetError$1(Errors.NONE, Optional.empty(), partition);
        PartitionTest.assertFetchOffsetError$1(Errors.NONE, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), partition);
        PartitionTest.assertFetchOffsetError$1(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), partition);
        PartitionTest.assertFetchOffsetError$1(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), partition);
    }

    @Test
    public void testFetchOffsetForTimestampEpochValidationForFollower() {
        int leaderEpoch = 5;
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, false);
        PartitionTest.assertFetchOffsetError$2(Errors.NONE, Optional.empty(), false, partition);
        PartitionTest.assertFetchOffsetError$2(Errors.NONE, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), false, partition);
        PartitionTest.assertFetchOffsetError$2(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), false, partition);
        PartitionTest.assertFetchOffsetError$2(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), false, partition);
        PartitionTest.assertFetchOffsetError$2(Errors.NOT_LEADER_OR_FOLLOWER, Optional.empty(), true, partition);
        PartitionTest.assertFetchOffsetError$2(Errors.NOT_LEADER_OR_FOLLOWER, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), true, partition);
        PartitionTest.assertFetchOffsetError$2(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), true, partition);
        PartitionTest.assertFetchOffsetError$2(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), true, partition);
    }

    @Test
    public void testFetchLatestOffsetIncludesLeaderEpoch() {
        int leaderEpoch = 5;
        Option timestampAndOffsetOpt = this.setupPartitionWithMocks(leaderEpoch, true).fetchOffsetForTimestamp(-1L, (Option)None$.MODULE$, Optional.empty(), true);
        Assertions.assertTrue((boolean)timestampAndOffsetOpt.isDefined());
        FileRecords.TimestampAndOffset timestampAndOffset = (FileRecords.TimestampAndOffset)timestampAndOffsetOpt.get();
        Assertions.assertEquals((int)leaderEpoch, (Integer)((Integer)timestampAndOffset.leaderEpoch.get()));
    }

    /*
     * Unable to fully structure code
     */
    @Test
    public void testMonotonicOffsetsAfterLeaderChange() {
        block51: {
            block53: {
                block52: {
                    block50: {
                        block47: {
                            block49: {
                                block48: {
                                    block46: {
                                        controllerEpoch = 3;
                                        leader = this.brokerId();
                                        follower1 = this.brokerId() + 1;
                                        follower2 = this.brokerId() + 2;
                                        replicas = (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{leader, follower1, follower2}));
                                        isr = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(leader), Predef$.MODULE$.int2Integer(follower2)}))).asJava();
                                        leaderEpoch = 8;
                                        batch1 = TestUtils$.MODULE$.records((Iterable<SimpleRecord>)((Iterable)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord(10L, "k1".getBytes(), "v1".getBytes()), new SimpleRecord(11L, "k2".getBytes(), "v2".getBytes())}))), TestUtils$.MODULE$.records$default$2(), TestUtils$.MODULE$.records$default$3(), TestUtils$.MODULE$.records$default$4(), TestUtils$.MODULE$.records$default$5(), TestUtils$.MODULE$.records$default$6(), TestUtils$.MODULE$.records$default$7(), TestUtils$.MODULE$.records$default$8());
                                        batch2 = TestUtils$.MODULE$.records((Iterable<SimpleRecord>)((Iterable)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("k3".getBytes(), "v1".getBytes()), new SimpleRecord(20L, "k4".getBytes(), "v2".getBytes()), new SimpleRecord(21L, "k5".getBytes(), "v3".getBytes())}))), TestUtils$.MODULE$.records$default$2(), TestUtils$.MODULE$.records$default$3(), TestUtils$.MODULE$.records$default$4(), TestUtils$.MODULE$.records$default$5(), TestUtils$.MODULE$.records$default$6(), TestUtils$.MODULE$.records$default$7(), TestUtils$.MODULE$.records$default$8());
                                        leaderState = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(leader).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(1).setReplicas(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)replicas.map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$testMonotonicOffsetsAfterLeaderChange$1$adapted(java.lang.Object ), (Ljava/lang/Object;)Ljava/lang/Integer;)())).asJava()).setIsNew(true);
                                        Assertions.assertTrue((boolean)this.partition().makeLeader(leaderState, this.offsetCheckpoints(), (Option)None$.MODULE$), (String)"Expected first makeLeader() to return 'leader changed'");
                                        Assertions.assertEquals((int)leaderEpoch, (int)this.partition().getLeaderEpoch(), (String)"Current leader epoch");
                                        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(leader), Predef$.MODULE$.int2Integer(follower2)})), (Object)this.partition().partitionState().isr(), (String)"ISR");
                                        requestLocal = RequestLocal$.MODULE$.withThreadConfinedCaching();
                                        this.partition().appendRecordsToLeader(batch1, (AppendOrigin)AppendOrigin.Client$.MODULE$, 0, requestLocal);
                                        this.partition().appendRecordsToLeader(batch2, (AppendOrigin)AppendOrigin.Client$.MODULE$, 0, requestLocal);
                                        Assertions.assertEquals((long)this.partition().localLogOrException().logStartOffset(), (long)this.partition().localLogOrException().highWatermark(), (String)"Expected leader's HW not move");
                                        this.updateFollowerFetchState$1(follower1, new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()));
                                        this.updateFollowerFetchState$1(follower1, new LogOffsetMetadata(2L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()));
                                        this.updateFollowerFetchState$1(follower2, new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()));
                                        this.updateFollowerFetchState$1(follower2, new LogOffsetMetadata(2L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()));
                                        this.alterIsrManager().completeIsrUpdate(2);
                                        Assertions.assertEquals((long)2L, (long)this.partition().localLogOrException().highWatermark());
                                        var12_12 = false;
                                        var13_13 = null;
                                        var14_14 = this.fetchOffsetsForTimestamp$1(-1L, (Option)None$.MODULE$);
                                        if (!(var14_14 instanceof Right)) ** GOTO lbl-1000
                                        var12_12 = true;
                                        var13_13 = (Right)var14_14;
                                        var15_15 = (Option)var13_13.value();
                                        if (var15_15 instanceof Some) {
                                            offsetAndTimestamp = (FileRecords.TimestampAndOffset)((Some)var15_15).value();
                                            Assertions.assertEquals((long)5L, (long)offsetAndTimestamp.offset);
                                        } else if (var12_12 && None$.MODULE$.equals(var17_17 = (Option)var13_13.value())) {
                                            (BoxedUnit)Assertions.fail((String)"Should have seen some offsets");
                                        } else if (var14_14 instanceof Left) {
                                            (BoxedUnit)Assertions.fail((String)"Should not have seen an error");
                                        } else {
                                            throw new MatchError((Object)var14_14);
                                        }
                                        var18_18 = false;
                                        var19_19 = null;
                                        var20_20 = this.fetchOffsetsForTimestamp$1(-1L, (Option)new Some((Object)IsolationLevel.READ_UNCOMMITTED));
                                        if (!(var20_20 instanceof Right)) ** GOTO lbl-1000
                                        var18_18 = true;
                                        var19_19 = (Right)var20_20;
                                        var21_21 = (Option)var19_19.value();
                                        if (var21_21 instanceof Some) {
                                            offsetAndTimestamp = (FileRecords.TimestampAndOffset)((Some)var21_21).value();
                                            Assertions.assertEquals((long)2L, (long)offsetAndTimestamp.offset);
                                        } else if (var18_18 && None$.MODULE$.equals(var23_23 = (Option)var19_19.value())) {
                                            (BoxedUnit)Assertions.fail((String)"Should have seen some offsets");
                                        } else if (var20_20 instanceof Left) {
                                            (BoxedUnit)Assertions.fail((String)"Should not have seen an error");
                                        } else {
                                            throw new MatchError((Object)var20_20);
                                        }
                                        Assertions.assertEquals((Object)package$.MODULE$.Right().apply((Object)None$.MODULE$), (Object)this.fetchOffsetsForTimestamp$1(30L, (Option)new Some((Object)IsolationLevel.READ_UNCOMMITTED)));
                                        followerState = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(follower2).setLeaderEpoch(leaderEpoch + 1).setIsr(isr).setZkVersion(4).setReplicas(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)replicas.map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$testMonotonicOffsetsAfterLeaderChange$2$adapted(java.lang.Object ), (Ljava/lang/Object;)Ljava/lang/Integer;)())).asJava()).setIsNew(false);
                                        Assertions.assertTrue((boolean)this.partition().makeFollower(followerState, this.offsetCheckpoints(), (Option)None$.MODULE$));
                                        newLeaderState = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(leader).setLeaderEpoch(leaderEpoch + 2).setIsr(isr).setZkVersion(5).setReplicas(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)replicas.map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$testMonotonicOffsetsAfterLeaderChange$3$adapted(java.lang.Object ), (Ljava/lang/Object;)Ljava/lang/Integer;)())).asJava()).setIsNew(false);
                                        Assertions.assertTrue((boolean)this.partition().makeLeader(newLeaderState, this.offsetCheckpoints(), (Option)None$.MODULE$));
                                        var26_26 = false;
                                        var27_27 = null;
                                        var28_28 = false;
                                        var29_29 = null;
                                        var30_30 = this.fetchOffsetsForTimestamp$1(-1L, (Option)new Some((Object)IsolationLevel.READ_UNCOMMITTED));
                                        if (!(var30_30 instanceof Right)) break block46;
                                        var26_26 = true;
                                        var27_27 = (Right)var30_30;
                                        if (!((Option)var27_27.value() instanceof Some)) break block46;
                                        (BoxedUnit)Assertions.fail((String)"Should have failed with OffsetNotAvailable");
                                        break block47;
                                    }
                                    if (!var26_26 || !None$.MODULE$.equals(var31_31 = (Option)var27_27.value())) break block48;
                                    (BoxedUnit)Assertions.fail((String)"Should have seen an error");
                                    break block47;
                                }
                                if (!(var30_30 instanceof Left)) break block49;
                                var28_28 = true;
                                var29_29 = (Left)var30_30;
                                if ((ApiException)var29_29.value() instanceof OffsetNotAvailableException) break block47;
                            }
                            if (var28_28 && (e = (ApiException)var29_29.value()) != null) {
                                (BoxedUnit)Assertions.fail((String)new StringBuilder(42).append("Expected OffsetNotAvailableException, got ").append(e).toString());
                            } else {
                                throw new MatchError((Object)var30_30);
                            }
                        }
                        var33_33 = false;
                        var34_34 = null;
                        var35_35 = this.fetchOffsetsForTimestamp$1(-1L, (Option)None$.MODULE$);
                        if (!(var35_35 instanceof Right)) ** GOTO lbl-1000
                        var33_33 = true;
                        var34_34 = (Right)var35_35;
                        var36_36 = (Option)var34_34.value();
                        if (var36_36 instanceof Some) {
                            offsetAndTimestamp = (FileRecords.TimestampAndOffset)((Some)var36_36).value();
                            Assertions.assertEquals((long)5L, (long)offsetAndTimestamp.offset);
                        } else if (var33_33 && None$.MODULE$.equals(var38_38 = (Option)var34_34.value())) {
                            (BoxedUnit)Assertions.fail((String)"Should have seen some offsets");
                        } else if (var35_35 instanceof Left && (e = (ApiException)((Left)var35_35).value()) != null) {
                            (BoxedUnit)Assertions.fail((String)new StringBuilder(17).append("Got ApiException ").append(e).toString());
                        } else {
                            throw new MatchError((Object)var35_35);
                        }
                        var40_40 = false;
                        var41_41 = null;
                        var42_42 = this.fetchOffsetsForTimestamp$1(-2L, (Option)new Some((Object)IsolationLevel.READ_UNCOMMITTED));
                        if (!(var42_42 instanceof Right)) ** GOTO lbl-1000
                        var40_40 = true;
                        var41_41 = (Right)var42_42;
                        var43_43 = (Option)var41_41.value();
                        if (var43_43 instanceof Some) {
                            offsetAndTimestamp = (FileRecords.TimestampAndOffset)((Some)var43_43).value();
                            Assertions.assertEquals((long)0L, (long)offsetAndTimestamp.offset);
                        } else if (var40_40 && None$.MODULE$.equals(var45_45 = (Option)var41_41.value())) {
                            (BoxedUnit)Assertions.fail((String)"Should have seen some offsets");
                        } else if (var42_42 instanceof Left && (e = (ApiException)((Left)var42_42).value()) != null) {
                            (BoxedUnit)Assertions.fail((String)new StringBuilder(17).append("Got ApiException ").append(e).toString());
                        } else {
                            throw new MatchError((Object)var42_42);
                        }
                        var47_47 = false;
                        var48_48 = null;
                        var49_49 = this.fetchOffsetsForTimestamp$1(11L, (Option)new Some((Object)IsolationLevel.READ_UNCOMMITTED));
                        if (!(var49_49 instanceof Right)) ** GOTO lbl-1000
                        var47_47 = true;
                        var48_48 = (Right)var49_49;
                        var50_50 = (Option)var48_48.value();
                        if (var50_50 instanceof Some) {
                            offsetAndTimestamp = (FileRecords.TimestampAndOffset)((Some)var50_50).value();
                            Assertions.assertEquals((long)1L, (long)offsetAndTimestamp.offset);
                            Assertions.assertEquals((long)11L, (long)offsetAndTimestamp.timestamp);
                        } else if (var47_47 && None$.MODULE$.equals(var52_52 = (Option)var48_48.value())) {
                            (BoxedUnit)Assertions.fail((String)"Should have seen some offsets");
                        } else if (var49_49 instanceof Left && (e = (ApiException)((Left)var49_49).value()) != null) {
                            (BoxedUnit)Assertions.fail((String)new StringBuilder(17).append("Got ApiException ").append(e).toString());
                        } else {
                            throw new MatchError((Object)var49_49);
                        }
                        var54_54 = false;
                        var55_55 = null;
                        var56_56 = false;
                        var57_57 = null;
                        var58_58 = this.fetchOffsetsForTimestamp$1(100L, (Option)new Some((Object)IsolationLevel.READ_UNCOMMITTED));
                        if (!(var58_58 instanceof Right)) break block50;
                        var54_54 = true;
                        var55_55 = (Right)var58_58;
                        if (!((Option)var55_55.value() instanceof Some)) break block50;
                        (BoxedUnit)Assertions.fail((String)"Should have failed");
                        break block51;
                    }
                    if (!var54_54 || !None$.MODULE$.equals(var59_59 = (Option)var55_55.value())) break block52;
                    (BoxedUnit)Assertions.fail((String)"Should have failed");
                    break block51;
                }
                if (!(var58_58 instanceof Left)) break block53;
                var56_56 = true;
                var57_57 = (Left)var58_58;
                if ((ApiException)var57_57.value() instanceof OffsetNotAvailableException) break block51;
            }
            if (var56_56 && (e = (ApiException)var57_57.value()) != null) {
                (BoxedUnit)Assertions.fail((String)new StringBuilder(50).append("Should have seen OffsetNotAvailableException, saw ").append(e).toString());
            } else {
                throw new MatchError((Object)var58_58);
            }
        }
        this.updateFollowerFetchState$1(follower1, new LogOffsetMetadata(5L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()));
        this.updateFollowerFetchState$1(follower2, new LogOffsetMetadata(5L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()));
        this.alterIsrManager().completeIsrUpdate(6);
        var61_61 = false;
        var62_62 = null;
        var63_63 = this.fetchOffsetsForTimestamp$1(-1L, (Option)new Some((Object)IsolationLevel.READ_UNCOMMITTED));
        if (!(var63_63 instanceof Right)) ** GOTO lbl-1000
        var61_61 = true;
        var62_62 = (Right)var63_63;
        var64_64 = (Option)var62_62.value();
        if (var64_64 instanceof Some) {
            offsetAndTimestamp = (FileRecords.TimestampAndOffset)((Some)var64_64).value();
            Assertions.assertEquals((long)5L, (long)offsetAndTimestamp.offset);
        } else if (var61_61 && None$.MODULE$.equals(var66_66 = (Option)var62_62.value())) {
            (BoxedUnit)Assertions.fail((String)"Should have seen some offsets");
        } else if (var63_63 instanceof Left && (e = (ApiException)((Left)var63_63).value()) != null) {
            (BoxedUnit)Assertions.fail((String)new StringBuilder(17).append("Got ApiException ").append(e).toString());
        } else {
            throw new MatchError((Object)var63_63);
        }
        Assertions.assertEquals((Object)package$.MODULE$.Right().apply((Object)None$.MODULE$), (Object)this.fetchOffsetsForTimestamp$1(100L, (Option)new Some((Object)IsolationLevel.READ_UNCOMMITTED)));
    }

    @Test
    public void testAppendRecordsAsFollowerBelowLogStartOffset() {
        this.partition().createLogIfNotExists(false, false, this.offsetCheckpoints(), (Option)None$.MODULE$);
        UnifiedLog log = this.partition().localLogOrException();
        long initialLogStartOffset = 5L;
        this.partition().truncateFullyAndStartAt(initialLogStartOffset, false);
        Assertions.assertEquals((long)initialLogStartOffset, (long)log.logEndOffset(), (String)new StringBuilder(50).append("Log end offset after truncate fully and start at ").append(initialLogStartOffset).append(":").toString());
        Assertions.assertEquals((long)initialLogStartOffset, (long)log.logStartOffset(), (String)new StringBuilder(52).append("Log start offset after truncate fully and start at ").append(initialLogStartOffset).append(":").toString());
        Assertions.assertThrows(UnexpectedAppendOffsetException.class, () -> this.partition().appendRecordsToFollowerOrFutureReplica(this.createRecords((Iterable<SimpleRecord>)((Iterable)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("k1".getBytes(), "v1".getBytes())}))), 3L, this.createRecords$default$3()), false));
        Assertions.assertEquals((long)initialLogStartOffset, (long)log.logEndOffset(), (String)"Log end offset should not change after failure to append");
        long newLogStartOffset = 4L;
        MemoryRecords records = this.createRecords((Iterable<SimpleRecord>)((Iterable)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("k1".getBytes(), "v1".getBytes()), new SimpleRecord("k2".getBytes(), "v2".getBytes()), new SimpleRecord("k3".getBytes(), "v3".getBytes())}))), newLogStartOffset, this.createRecords$default$3());
        this.partition().appendRecordsToFollowerOrFutureReplica(records, false);
        Assertions.assertEquals((long)7L, (long)log.logEndOffset(), (String)new StringBuilder(59).append("Log end offset after append of 3 records with base offset ").append(newLogStartOffset).append(":").toString());
        Assertions.assertEquals((long)newLogStartOffset, (long)log.logStartOffset(), (String)new StringBuilder(61).append("Log start offset after append of 3 records with base offset ").append(newLogStartOffset).append(":").toString());
        this.partition().appendRecordsToFollowerOrFutureReplica(this.createRecords((Iterable<SimpleRecord>)((Iterable)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("k1".getBytes(), "v1".getBytes())}))), 7L, this.createRecords$default$3()), false);
        Assertions.assertEquals((long)8L, (long)log.logEndOffset(), (String)"Log end offset after append of 1 record at offset 7:");
        Assertions.assertEquals((long)newLogStartOffset, (long)log.logStartOffset(), (String)"Log start offset not expected to change:");
        MemoryRecords records2 = this.createRecords((Iterable<SimpleRecord>)((Iterable)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("k1".getBytes(), "v1".getBytes()), new SimpleRecord("k2".getBytes(), "v2".getBytes())}))), 3L, this.createRecords$default$3());
        Assertions.assertThrows(UnexpectedAppendOffsetException.class, () -> this.partition().appendRecordsToFollowerOrFutureReplica(records2, false));
        Assertions.assertEquals((long)8L, (long)log.logEndOffset(), (String)"Log end offset should not change after failure to append");
        this.partition().appendRecordsToFollowerOrFutureReplica(this.createRecords((Iterable<SimpleRecord>)((Iterable)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("k1".getBytes(), "v1".getBytes())}))), 8L, this.createRecords$default$3()), false);
        Assertions.assertEquals((long)9L, (long)log.logEndOffset(), (String)"Log end offset after append of 1 record at offset 8:");
        Assertions.assertEquals((long)newLogStartOffset, (long)log.logStartOffset(), (String)"Log start offset not expected to change:");
    }

    @Test
    public void testListOffsetIsolationLevels() {
        int controllerEpoch = 0;
        int leaderEpoch = 5;
        java.util.List replicas = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(this.brokerId()), Predef$.MODULE$.int2Integer(this.brokerId() + 1)}))).asJava();
        this.partition().createLogIfNotExists(false, false, this.offsetCheckpoints(), (Option)None$.MODULE$);
        Assertions.assertTrue((boolean)this.partition().makeLeader(new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(this.brokerId()).setLeaderEpoch(leaderEpoch).setIsr(replicas).setZkVersion(1).setReplicas(replicas).setIsNew(true), this.offsetCheckpoints(), (Option)None$.MODULE$), (String)"Expected become leader transition to succeed");
        Assertions.assertEquals((int)leaderEpoch, (int)this.partition().getLeaderEpoch());
        MemoryRecords records = this.createTransactionalRecords((Iterable<SimpleRecord>)((Iterable)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("k1".getBytes(), "v1".getBytes()), new SimpleRecord("k2".getBytes(), "v2".getBytes()), new SimpleRecord("k3".getBytes(), "v3".getBytes())}))), 0L);
        this.partition().appendRecordsToLeader(records, (AppendOrigin)AppendOrigin.Client$.MODULE$, 0, RequestLocal$.MODULE$.withThreadConfinedCaching());
        Assertions.assertEquals((long)3L, (long)this.fetchLatestOffset$1((Option)None$.MODULE$).offset);
        Assertions.assertEquals((long)0L, (long)this.fetchLatestOffset$1((Option)new Some((Object)IsolationLevel.READ_UNCOMMITTED)).offset);
        Assertions.assertEquals((long)0L, (long)this.fetchLatestOffset$1((Option)new Some((Object)IsolationLevel.READ_COMMITTED)).offset);
        ((UnifiedLog)this.partition().log().get()).updateHighWatermark(1L);
        Assertions.assertEquals((long)3L, (long)this.fetchLatestOffset$1((Option)None$.MODULE$).offset);
        Assertions.assertEquals((long)1L, (long)this.fetchLatestOffset$1((Option)new Some((Object)IsolationLevel.READ_UNCOMMITTED)).offset);
        Assertions.assertEquals((long)0L, (long)this.fetchLatestOffset$1((Option)new Some((Object)IsolationLevel.READ_COMMITTED)).offset);
        Assertions.assertEquals((long)0L, (long)this.fetchEarliestOffset$1((Option)None$.MODULE$).offset);
        Assertions.assertEquals((long)0L, (long)this.fetchEarliestOffset$1((Option)new Some((Object)IsolationLevel.READ_UNCOMMITTED)).offset);
        Assertions.assertEquals((long)0L, (long)this.fetchEarliestOffset$1((Option)new Some((Object)IsolationLevel.READ_COMMITTED)).offset);
    }

    @Test
    public void testGetReplica() {
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.partition().log());
        Assertions.assertThrows(NotLeaderOrFollowerException.class, () -> this.partition().localLogOrException());
    }

    @Test
    public void testAppendRecordsToFollowerWithNoReplicaThrowsException() {
        Assertions.assertThrows(NotLeaderOrFollowerException.class, () -> this.partition().appendRecordsToFollowerOrFutureReplica(this.createRecords((Iterable<SimpleRecord>)((Iterable)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("k1".getBytes(), "v1".getBytes())}))), 0L, this.createRecords$default$3()), false));
    }

    @Test
    public void testMakeFollowerWithNoLeaderIdChange() {
        LeaderAndIsrRequestData.LeaderAndIsrPartitionState partitionState = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(0).setLeader(1).setLeaderEpoch(1).setIsr(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(this.brokerId())}))).asJava()).setZkVersion(1).setReplicas(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(this.brokerId())}))).asJava()).setIsNew(false);
        this.partition().makeFollower(partitionState, this.offsetCheckpoints(), (Option)None$.MODULE$);
        partitionState = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(0).setLeader(1).setLeaderEpoch(4).setIsr(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(this.brokerId())}))).asJava()).setZkVersion(1).setReplicas(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(this.brokerId())}))).asJava()).setIsNew(false);
        Assertions.assertTrue((boolean)this.partition().makeFollower(partitionState, this.offsetCheckpoints(), (Option)None$.MODULE$));
        partitionState = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(0).setLeader(1).setLeaderEpoch(4).setIsr(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(this.brokerId())}))).asJava()).setZkVersion(1).setReplicas(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(this.brokerId())}))).asJava());
        Assertions.assertFalse((boolean)this.partition().makeFollower(partitionState, this.offsetCheckpoints(), (Option)None$.MODULE$));
    }

    @Test
    public void testFollowerDoesNotJoinISRUntilCaughtUpToOffsetWithinCurrentLeaderEpoch() {
        int controllerEpoch = 3;
        int leader = this.brokerId();
        int follower1 = this.brokerId() + 1;
        int follower2 = this.brokerId() + 2;
        java.util.List replicas = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(leader), Predef$.MODULE$.int2Integer(follower1), Predef$.MODULE$.int2Integer(follower2)}))).asJava();
        java.util.List isr = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(leader), Predef$.MODULE$.int2Integer(follower2)}))).asJava();
        int leaderEpoch = 8;
        MemoryRecords batch1 = TestUtils$.MODULE$.records((Iterable<SimpleRecord>)((Iterable)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("k1".getBytes(), "v1".getBytes()), new SimpleRecord("k2".getBytes(), "v2".getBytes())}))), (byte)2, CompressionType.NONE, -1L, (short)-1, -1, 0L, -1);
        MemoryRecords batch2 = TestUtils$.MODULE$.records((Iterable<SimpleRecord>)((Iterable)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("k3".getBytes(), "v1".getBytes()), new SimpleRecord("k4".getBytes(), "v2".getBytes()), new SimpleRecord("k5".getBytes(), "v3".getBytes())}))), (byte)2, CompressionType.NONE, -1L, (short)-1, -1, 0L, -1);
        MemoryRecords batch3 = TestUtils$.MODULE$.records((Iterable<SimpleRecord>)((Iterable)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("k6".getBytes(), "v1".getBytes()), new SimpleRecord("k7".getBytes(), "v2".getBytes())}))), (byte)2, CompressionType.NONE, -1L, (short)-1, -1, 0L, -1);
        LeaderAndIsrRequestData.LeaderAndIsrPartitionState leaderState = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(leader).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(1).setReplicas(replicas).setIsNew(true);
        Assertions.assertTrue((boolean)this.partition().makeLeader(leaderState, this.offsetCheckpoints(), (Option)None$.MODULE$), (String)"Expected first makeLeader() to return 'leader changed'");
        Assertions.assertEquals((int)leaderEpoch, (int)this.partition().getLeaderEpoch(), (String)"Current leader epoch");
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(leader), Predef$.MODULE$.int2Integer(follower2)})), (Object)this.partition().partitionState().isr(), (String)"ISR");
        RequestLocal requestLocal = RequestLocal$.MODULE$.withThreadConfinedCaching();
        long lastOffsetOfFirstBatch = this.partition().appendRecordsToLeader(batch1, (AppendOrigin)AppendOrigin.Client$.MODULE$, 0, requestLocal).lastOffset();
        this.partition().appendRecordsToLeader(batch2, (AppendOrigin)AppendOrigin.Client$.MODULE$, 0, requestLocal);
        Assertions.assertEquals((long)this.partition().localLogOrException().logStartOffset(), (long)((UnifiedLog)this.partition().log().get()).highWatermark(), (String)"Expected leader's HW not move");
        this.updateFollowerFetchState$2(follower2, new LogOffsetMetadata(0L, UnifiedLog$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition()));
        this.updateFollowerFetchState$2(follower2, new LogOffsetMetadata(lastOffsetOfFirstBatch, UnifiedLog$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition()));
        Assertions.assertEquals((long)lastOffsetOfFirstBatch, (long)((UnifiedLog)this.partition().log().get()).highWatermark(), (String)"Expected leader's HW");
        LeaderAndIsrRequestData.LeaderAndIsrPartitionState followerState = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(follower2).setLeaderEpoch(leaderEpoch + 1).setIsr(isr).setZkVersion(1).setReplicas(replicas).setIsNew(false);
        this.partition().makeFollower(followerState, this.offsetCheckpoints(), (Option)None$.MODULE$);
        LeaderAndIsrRequestData.LeaderAndIsrPartitionState newLeaderState = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(leader).setLeaderEpoch(leaderEpoch + 2).setIsr(isr).setZkVersion(1).setReplicas(replicas).setIsNew(false);
        Assertions.assertTrue((boolean)this.partition().makeLeader(newLeaderState, this.offsetCheckpoints(), (Option)None$.MODULE$), (String)"Expected makeLeader() to return 'leader changed' after makeFollower()");
        long currentLeaderEpochStartOffset = this.partition().localLogOrException().logEndOffset();
        this.partition().appendRecordsToLeader(batch3, (AppendOrigin)AppendOrigin.Client$.MODULE$, 0, requestLocal);
        this.updateFollowerFetchState$2(follower1, new LogOffsetMetadata(0L, UnifiedLog$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition()));
        this.updateFollowerFetchState$2(follower1, new LogOffsetMetadata(lastOffsetOfFirstBatch, UnifiedLog$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition()));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(leader), Predef$.MODULE$.int2Integer(follower2)})), (Object)this.partition().partitionState().isr(), (String)"ISR");
        this.updateFollowerFetchState$2(follower1, new LogOffsetMetadata(currentLeaderEpochStartOffset, UnifiedLog$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition()));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(leader), Predef$.MODULE$.int2Integer(follower2)})), (Object)this.partition().partitionState().isr(), (String)"ISR");
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(leader), Predef$.MODULE$.int2Integer(follower1), Predef$.MODULE$.int2Integer(follower2)})), (Object)this.partition().partitionState().maximalIsr(), (String)"ISR");
        Assertions.assertEquals((Object)((AlterIsrItem)this.alterIsrManager().isrUpdates().head()).leaderAndIsr().isr().toSet(), (Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{leader, follower1, follower2})), (String)"AlterIsr");
    }

    /*
     * WARNING - void declaration
     */
    public MemoryRecords createRecords(Iterable<SimpleRecord> records, long baseOffset, int partitionLeaderEpoch) {
        MemoryRecordsBuilder memoryRecordsBuilder;
        void builder_isTransactional;
        void builder_baseSequence;
        void builder_producerEpoch;
        void builder_logAppendTime;
        void builder_timestampType;
        void builder_compressionType;
        MemoryRecordsBuilder memoryRecordsBuilder2;
        ByteBuffer buf = ByteBuffer.allocate(DefaultRecordBatch.sizeInBytes((java.lang.Iterable)CollectionConverters$.MODULE$.IterableHasAsJava(records).asJava()));
        long l = this.time().milliseconds();
        TimestampType timestampType = TimestampType.LOG_APPEND_TIME;
        CompressionType compressionType = CompressionType.NONE;
        byte builder_magic = 2;
        boolean bl = false;
        int n = -1;
        int n2 = -1;
        long builder_producerId = -1L;
        MemoryRecordsBuilder memoryRecordsBuilder3 = memoryRecordsBuilder2 = MemoryRecords.builder((ByteBuffer)buf, (byte)builder_magic, (CompressionType)builder_compressionType, (TimestampType)builder_timestampType, (long)baseOffset, (long)builder_logAppendTime, (long)builder_producerId, (short)builder_producerEpoch, (int)builder_baseSequence, (boolean)builder_isTransactional, (boolean)false, (int)partitionLeaderEpoch);
        memoryRecordsBuilder2 = null;
        MemoryRecordsBuilder memoryRecordsBuilder4 = memoryRecordsBuilder = memoryRecordsBuilder3;
        compressionType = null;
        timestampType = null;
        memoryRecordsBuilder = null;
        MemoryRecordsBuilder builder = memoryRecordsBuilder4;
        records.foreach((Function1 & Serializable)x$1 -> {
            builder.append(x$1);
            return BoxedUnit.UNIT;
        });
        return builder.build();
    }

    public int createRecords$default$3() {
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    public MemoryRecords createTransactionalRecords(Iterable<SimpleRecord> records, long baseOffset) {
        MemoryRecordsBuilder memoryRecordsBuilder;
        void builder_partitionLeaderEpoch;
        void builder_logAppendTime;
        void builder_timestampType;
        MemoryRecordsBuilder memoryRecordsBuilder2;
        long producerId = 1L;
        short producerEpoch = (short)0;
        int baseSequence = 0;
        boolean isTransactional = true;
        ByteBuffer buf = ByteBuffer.allocate(DefaultRecordBatch.sizeInBytes((java.lang.Iterable)CollectionConverters$.MODULE$.IterableHasAsJava(records).asJava()));
        CompressionType builder_compressionType = CompressionType.NONE;
        int n = -1;
        long l = -1L;
        TimestampType timestampType = TimestampType.CREATE_TIME;
        byte builder_magic = 2;
        MemoryRecordsBuilder memoryRecordsBuilder3 = memoryRecordsBuilder2 = MemoryRecords.builder((ByteBuffer)buf, (byte)builder_magic, (CompressionType)builder_compressionType, (TimestampType)builder_timestampType, (long)baseOffset, (long)builder_logAppendTime, (long)producerId, (short)producerEpoch, (int)baseSequence, (boolean)isTransactional, (boolean)false, (int)builder_partitionLeaderEpoch);
        timestampType = null;
        memoryRecordsBuilder2 = null;
        MemoryRecordsBuilder memoryRecordsBuilder4 = memoryRecordsBuilder = memoryRecordsBuilder3;
        Object var11_8 = null;
        memoryRecordsBuilder = null;
        MemoryRecordsBuilder builder = memoryRecordsBuilder4;
        records.foreach((Function1 & Serializable)x$1 -> {
            builder.append(x$1);
            return BoxedUnit.UNIT;
        });
        return builder.build();
    }

    @Test
    public void testAtMinIsr() {
        int controllerEpoch = 3;
        int leader = this.brokerId();
        int follower1 = this.brokerId() + 1;
        int follower2 = this.brokerId() + 2;
        java.util.List replicas = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(leader), Predef$.MODULE$.int2Integer(follower1), Predef$.MODULE$.int2Integer(follower2)}))).asJava();
        java.util.List isr = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(leader)}))).asJava();
        int leaderEpoch = 8;
        Assertions.assertFalse((boolean)this.partition().isAtMinIsr());
        LeaderAndIsrRequestData.LeaderAndIsrPartitionState leaderState = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(leader).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(1).setReplicas(replicas).setIsNew(true);
        this.partition().makeLeader(leaderState, this.offsetCheckpoints(), (Option)None$.MODULE$);
        Assertions.assertTrue((boolean)this.partition().isAtMinIsr());
    }

    @Test
    public void testUpdateFollowerFetchState() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = this.topicPartition();
        None$ x$2 = None$.MODULE$;
        boolean x$3 = qual$1.getOrCreateLog$default$2();
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        UnifiedLog log = qual$1.getOrCreateLog(x$1, x$3, x$4, (Option)x$2);
        this.seedLogData(log, 6, 4);
        int controllerEpoch = 0;
        int leaderEpoch = 5;
        int remoteBrokerId = this.brokerId() + 1;
        java.util.List replicas = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(this.brokerId()), Predef$.MODULE$.int2Integer(remoteBrokerId)}))).asJava();
        this.partition().createLogIfNotExists(false, false, this.offsetCheckpoints(), (Option)None$.MODULE$);
        long initializeTimeMs = this.time().milliseconds();
        Assertions.assertTrue((boolean)this.partition().makeLeader(new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(this.brokerId()).setLeaderEpoch(leaderEpoch).setIsr(replicas).setZkVersion(1).setReplicas(replicas).setIsNew(true), this.offsetCheckpoints(), (Option)None$.MODULE$), (String)"Expected become leader transition to succeed");
        Replica remoteReplica = (Replica)this.partition().getReplica(remoteBrokerId).get();
        Assertions.assertEquals((long)initializeTimeMs, (long)remoteReplica.lastCaughtUpTimeMs());
        Assertions.assertEquals((long)LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata().messageOffset(), (long)remoteReplica.logEndOffset());
        Assertions.assertEquals((long)UnifiedLog$.MODULE$.UnknownOffset(), (long)remoteReplica.logStartOffset());
        this.time().sleep(500L);
        this.partition().updateFollowerFetchState(remoteBrokerId, new LogOffsetMetadata(3L, UnifiedLog$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition()), 0L, this.time().milliseconds(), 6L);
        Assertions.assertEquals((long)initializeTimeMs, (long)remoteReplica.lastCaughtUpTimeMs());
        Assertions.assertEquals((long)3L, (long)remoteReplica.logEndOffset());
        Assertions.assertEquals((long)0L, (long)remoteReplica.logStartOffset());
        this.time().sleep(500L);
        this.partition().updateFollowerFetchState(remoteBrokerId, new LogOffsetMetadata(6L, UnifiedLog$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition()), 0L, this.time().milliseconds(), 6L);
        Assertions.assertEquals((long)this.time().milliseconds(), (long)remoteReplica.lastCaughtUpTimeMs());
        Assertions.assertEquals((long)6L, (long)remoteReplica.logEndOffset());
        Assertions.assertEquals((long)0L, (long)remoteReplica.logStartOffset());
    }

    @Test
    public void testInvalidAlterPartitionRequestsAreNotRetried() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = this.topicPartition();
        None$ x$2 = None$.MODULE$;
        boolean x$3 = qual$1.getOrCreateLog$default$2();
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        UnifiedLog log = qual$1.getOrCreateLog(x$1, x$3, x$4, (Option)x$2);
        this.seedLogData(log, 10, 4);
        int controllerEpoch = 0;
        int leaderEpoch = 5;
        int remoteBrokerId = this.brokerId() + 1;
        java.util.List replicas = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(this.brokerId()), Predef$.MODULE$.int2Integer(remoteBrokerId)}))).asJava();
        java.util.List isr = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(this.brokerId())}))).asJava();
        this.partition().createLogIfNotExists(false, false, this.offsetCheckpoints(), (Option)None$.MODULE$);
        Assertions.assertTrue((boolean)this.partition().makeLeader(new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(this.brokerId()).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(1).setReplicas(replicas).setIsNew(true), this.offsetCheckpoints(), (Option)None$.MODULE$), (String)"Expected become leader transition to succeed");
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), (Object)this.partition().partitionState().isr());
        Replica remoteReplica = (Replica)this.partition().getReplica(remoteBrokerId).get();
        Assertions.assertEquals((long)LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata().messageOffset(), (long)remoteReplica.logEndOffset());
        Assertions.assertEquals((long)UnifiedLog$.MODULE$.UnknownOffset(), (long)remoteReplica.logStartOffset());
        this.partition().updateFollowerFetchState(remoteBrokerId, new LogOffsetMetadata(10L, UnifiedLog$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition()), 0L, this.time().milliseconds(), 10L);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), (Object)this.partition().inSyncReplicaIds());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId})), (Object)this.partition().partitionState().maximalIsr());
        Assertions.assertEquals((int)1, (int)this.alterIsrManager().isrUpdates().size());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId})), (Object)((AlterIsrItem)this.alterIsrManager().isrUpdates().head()).leaderAndIsr().isr().toSet());
        this.alterIsrManager().failIsrUpdate(Errors.INVALID_REQUEST);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), (Object)this.partition().inSyncReplicaIds());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId})), (Object)this.partition().partitionState().maximalIsr());
        Assertions.assertEquals((int)0, (int)this.alterIsrManager().isrUpdates().size());
        Assertions.assertEquals((int)0, (int)this.isrChangeListener().expands().get());
        Assertions.assertEquals((int)0, (int)this.isrChangeListener().shrinks().get());
        Assertions.assertEquals((int)1, (int)this.isrChangeListener().failures().get());
    }

    @Test
    public void testIsrExpansion() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = this.topicPartition();
        None$ x$2 = None$.MODULE$;
        boolean x$3 = qual$1.getOrCreateLog$default$2();
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        UnifiedLog log = qual$1.getOrCreateLog(x$1, x$3, x$4, (Option)x$2);
        this.seedLogData(log, 10, 4);
        int controllerEpoch = 0;
        int leaderEpoch = 5;
        int remoteBrokerId = this.brokerId() + 1;
        List replicas = (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId}));
        java.util.List isr = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(this.brokerId())}))).asJava();
        this.partition().createLogIfNotExists(false, false, this.offsetCheckpoints(), (Option)None$.MODULE$);
        Assertions.assertTrue((boolean)this.partition().makeLeader(new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(this.brokerId()).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(1).setReplicas(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)replicas.map((Function1 & Serializable)x -> PartitionTest.$anonfun$testIsrExpansion$1(BoxesRunTime.unboxToInt((Object)x)))).asJava()).setIsNew(true), this.offsetCheckpoints(), (Option)None$.MODULE$), (String)"Expected become leader transition to succeed");
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), (Object)this.partition().partitionState().isr());
        Replica remoteReplica = (Replica)this.partition().getReplica(remoteBrokerId).get();
        Assertions.assertEquals((long)LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata().messageOffset(), (long)remoteReplica.logEndOffset());
        Assertions.assertEquals((long)UnifiedLog$.MODULE$.UnknownOffset(), (long)remoteReplica.logStartOffset());
        this.partition().updateFollowerFetchState(remoteBrokerId, new LogOffsetMetadata(3L, UnifiedLog$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition()), 0L, this.time().milliseconds(), 6L);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), (Object)this.partition().partitionState().isr());
        Assertions.assertEquals((long)3L, (long)remoteReplica.logEndOffset());
        Assertions.assertEquals((long)0L, (long)remoteReplica.logStartOffset());
        this.partition().updateFollowerFetchState(remoteBrokerId, new LogOffsetMetadata(10L, UnifiedLog$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition()), 0L, this.time().milliseconds(), 6L);
        Assertions.assertEquals((int)this.alterIsrManager().isrUpdates().size(), (int)1);
        Assertions.assertEquals((Object)((AlterIsrItem)this.alterIsrManager().isrUpdates().head()).leaderAndIsr().isr(), (Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId})));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), (Object)this.partition().partitionState().isr());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId})), (Object)this.partition().partitionState().maximalIsr());
        Assertions.assertEquals((long)10L, (long)remoteReplica.logEndOffset());
        Assertions.assertEquals((long)0L, (long)remoteReplica.logStartOffset());
        this.alterIsrManager().completeIsrUpdate(2);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId})), (Object)this.partition().partitionState().isr());
        Assertions.assertEquals((int)this.isrChangeListener().expands().get(), (int)1);
        Assertions.assertEquals((int)this.isrChangeListener().shrinks().get(), (int)0);
        Assertions.assertEquals((int)this.isrChangeListener().failures().get(), (int)0);
    }

    @Test
    public void testIsrNotExpandedIfUpdateFails() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = this.topicPartition();
        None$ x$2 = None$.MODULE$;
        boolean x$3 = qual$1.getOrCreateLog$default$2();
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        UnifiedLog log = qual$1.getOrCreateLog(x$1, x$3, x$4, (Option)x$2);
        this.seedLogData(log, 10, 4);
        int controllerEpoch = 0;
        int leaderEpoch = 5;
        int remoteBrokerId = this.brokerId() + 1;
        java.util.List replicas = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(this.brokerId()), Predef$.MODULE$.int2Integer(remoteBrokerId)}))).asJava();
        java.util.List isr = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(this.brokerId())}))).asJava();
        this.partition().createLogIfNotExists(false, false, this.offsetCheckpoints(), (Option)None$.MODULE$);
        Assertions.assertTrue((boolean)this.partition().makeLeader(new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(this.brokerId()).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(1).setReplicas(replicas).setIsNew(true), this.offsetCheckpoints(), (Option)None$.MODULE$), (String)"Expected become leader transition to succeed");
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), (Object)this.partition().partitionState().isr());
        Replica remoteReplica = (Replica)this.partition().getReplica(remoteBrokerId).get();
        Assertions.assertEquals((long)LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata().messageOffset(), (long)remoteReplica.logEndOffset());
        Assertions.assertEquals((long)UnifiedLog$.MODULE$.UnknownOffset(), (long)remoteReplica.logStartOffset());
        this.partition().updateFollowerFetchState(remoteBrokerId, new LogOffsetMetadata(10L, UnifiedLog$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition()), 0L, this.time().milliseconds(), 10L);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), (Object)this.partition().inSyncReplicaIds());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId})), (Object)this.partition().partitionState().maximalIsr());
        Assertions.assertEquals((int)this.alterIsrManager().isrUpdates().size(), (int)1);
        Assertions.assertEquals((long)10L, (long)remoteReplica.logEndOffset());
        Assertions.assertEquals((long)0L, (long)remoteReplica.logStartOffset());
        this.alterIsrManager().failIsrUpdate(Errors.INVALID_UPDATE_VERSION);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), (Object)this.partition().inSyncReplicaIds());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId})), (Object)this.partition().partitionState().maximalIsr());
        Assertions.assertEquals((int)this.alterIsrManager().isrUpdates().size(), (int)0);
        Assertions.assertEquals((int)this.isrChangeListener().expands().get(), (int)0);
        Assertions.assertEquals((int)this.isrChangeListener().shrinks().get(), (int)0);
        Assertions.assertEquals((int)this.isrChangeListener().failures().get(), (int)1);
    }

    @Test
    public void testRetryShrinkIsr() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = this.topicPartition();
        None$ x$2 = None$.MODULE$;
        boolean x$3 = qual$1.getOrCreateLog$default$2();
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        UnifiedLog log = qual$1.getOrCreateLog(x$1, x$3, x$4, (Option)x$2);
        this.seedLogData(log, 10, 4);
        int controllerEpoch = 0;
        int leaderEpoch = 5;
        int remoteBrokerId = this.brokerId() + 1;
        scala.collection.immutable.Seq replicas = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId}));
        scala.collection.immutable.Seq isr = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId}));
        Uuid topicId = Uuid.randomUuid();
        Assertions.assertTrue((boolean)this.makeLeader((Option<Uuid>)new Some((Object)topicId), controllerEpoch, leaderEpoch, (scala.collection.immutable.Seq<Object>)isr, (scala.collection.immutable.Seq<Object>)replicas, 1, true, this.partition()));
        Assertions.assertEquals((long)0L, (long)this.partition().localLogOrException().highWatermark());
        this.time().sleep(this.partition().replicaLagTimeMaxMs() + 1L);
        this.partition().maybeShrinkIsr();
        Assertions.assertEquals((int)this.alterIsrManager().isrUpdates().size(), (int)1);
        Assertions.assertEquals((Object)((AlterIsrItem)this.alterIsrManager().isrUpdates().head()).leaderAndIsr().isr(), (Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()})));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId})), (Object)this.partition().partitionState().isr());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId})), (Object)this.partition().partitionState().maximalIsr());
        this.alterIsrManager().failIsrUpdate(Errors.NETWORK_EXCEPTION);
        Assertions.assertEquals((int)0, (int)this.isrChangeListener().shrinks().get());
        Assertions.assertEquals((int)1, (int)this.isrChangeListener().failures().get());
        Assertions.assertEquals((int)1, (int)this.partition().getZkVersion());
        Assertions.assertEquals((int)this.alterIsrManager().isrUpdates().size(), (int)1);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId})), (Object)this.partition().partitionState().isr());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId})), (Object)this.partition().partitionState().maximalIsr());
        Assertions.assertEquals((long)0L, (long)this.partition().localLogOrException().highWatermark());
        this.alterIsrManager().completeIsrUpdate(2);
        Assertions.assertEquals((int)1, (int)this.isrChangeListener().shrinks().get());
        Assertions.assertEquals((int)2, (int)this.partition().getZkVersion());
        Assertions.assertEquals((int)this.alterIsrManager().isrUpdates().size(), (int)0);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), (Object)this.partition().partitionState().isr());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), (Object)this.partition().partitionState().maximalIsr());
        Assertions.assertEquals((long)log.logEndOffset(), (long)this.partition().localLogOrException().highWatermark());
    }

    @Test
    public void testMaybeShrinkIsr() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = this.topicPartition();
        None$ x$2 = None$.MODULE$;
        boolean x$3 = qual$1.getOrCreateLog$default$2();
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        UnifiedLog log = qual$1.getOrCreateLog(x$1, x$3, x$4, (Option)x$2);
        this.seedLogData(log, 10, 4);
        int controllerEpoch = 0;
        int leaderEpoch = 5;
        int remoteBrokerId = this.brokerId() + 1;
        scala.collection.immutable.Seq replicas = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId}));
        scala.collection.immutable.Seq isr = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId}));
        long initializeTimeMs = this.time().milliseconds();
        Assertions.assertTrue((boolean)this.makeLeader((Option<Uuid>)None$.MODULE$, controllerEpoch, leaderEpoch, (scala.collection.immutable.Seq<Object>)isr, (scala.collection.immutable.Seq<Object>)replicas, 1, true, this.partition()));
        Assertions.assertEquals((long)0L, (long)this.partition().localLogOrException().highWatermark());
        Replica remoteReplica = (Replica)this.partition().getReplica(remoteBrokerId).get();
        Assertions.assertEquals((long)initializeTimeMs, (long)remoteReplica.lastCaughtUpTimeMs());
        Assertions.assertEquals((long)LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata().messageOffset(), (long)remoteReplica.logEndOffset());
        Assertions.assertEquals((long)UnifiedLog$.MODULE$.UnknownOffset(), (long)remoteReplica.logStartOffset());
        this.partition().maybeShrinkIsr();
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId})), (Object)this.partition().partitionState().isr());
        this.time().sleep(this.partition().replicaLagTimeMaxMs() + 1L);
        this.partition().maybeShrinkIsr();
        Assertions.assertEquals((int)0, (int)this.isrChangeListener().shrinks().get());
        Assertions.assertEquals((int)this.alterIsrManager().isrUpdates().size(), (int)1);
        Assertions.assertEquals((Object)((AlterIsrItem)this.alterIsrManager().isrUpdates().head()).leaderAndIsr().isr(), (Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()})));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId})), (Object)this.partition().partitionState().isr());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId})), (Object)this.partition().partitionState().maximalIsr());
        Assertions.assertEquals((long)0L, (long)this.partition().localLogOrException().highWatermark());
        this.alterIsrManager().completeIsrUpdate(2);
        Assertions.assertEquals((int)1, (int)this.isrChangeListener().shrinks().get());
        Assertions.assertEquals((int)2, (int)this.partition().getZkVersion());
        Assertions.assertEquals((int)this.alterIsrManager().isrUpdates().size(), (int)0);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), (Object)this.partition().partitionState().isr());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), (Object)this.partition().partitionState().maximalIsr());
        Assertions.assertEquals((long)log.logEndOffset(), (long)this.partition().localLogOrException().highWatermark());
    }

    @Test
    public void testAlterIsrLeaderAndIsrRace() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = this.topicPartition();
        None$ x$2 = None$.MODULE$;
        boolean x$3 = qual$1.getOrCreateLog$default$2();
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        UnifiedLog log = qual$1.getOrCreateLog(x$1, x$3, x$4, (Option)x$2);
        this.seedLogData(log, 10, 4);
        int controllerEpoch = 0;
        int leaderEpoch = 5;
        int remoteBrokerId = this.brokerId() + 1;
        scala.collection.immutable.Seq replicas = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId}));
        scala.collection.immutable.Seq isr = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId}));
        long initializeTimeMs = this.time().milliseconds();
        Assertions.assertTrue((boolean)this.makeLeader((Option<Uuid>)None$.MODULE$, controllerEpoch, leaderEpoch, (scala.collection.immutable.Seq<Object>)isr, (scala.collection.immutable.Seq<Object>)replicas, 1, true, this.partition()));
        Assertions.assertEquals((long)0L, (long)this.partition().localLogOrException().highWatermark());
        Replica remoteReplica = (Replica)this.partition().getReplica(remoteBrokerId).get();
        Assertions.assertEquals((long)initializeTimeMs, (long)remoteReplica.lastCaughtUpTimeMs());
        Assertions.assertEquals((long)LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata().messageOffset(), (long)remoteReplica.logEndOffset());
        Assertions.assertEquals((long)UnifiedLog$.MODULE$.UnknownOffset(), (long)remoteReplica.logStartOffset());
        this.time().sleep(this.partition().replicaLagTimeMaxMs() + 1L);
        this.partition().maybeShrinkIsr();
        Assertions.assertTrue((boolean)this.partition().partitionState().isInflight());
        Assertions.assertFalse((boolean)this.makeLeader((Option<Uuid>)None$.MODULE$, controllerEpoch, leaderEpoch, (scala.collection.immutable.Seq<Object>)isr, (scala.collection.immutable.Seq<Object>)replicas, 2, false, this.partition()));
        Assertions.assertEquals((long)0L, (long)this.partition().localLogOrException().highWatermark());
        Assertions.assertFalse((boolean)this.partition().partitionState().isInflight(), (String)"ISR should be committed and not inflight");
        this.time().sleep(this.partition().replicaLagTimeMaxMs() + 1L);
        this.partition().maybeShrinkIsr();
        Assertions.assertFalse((boolean)this.partition().partitionState().isInflight(), (String)"ISR should still be committed and not inflight");
        this.alterIsrManager().completeIsrUpdate(10);
        this.partition().maybeShrinkIsr();
        Assertions.assertTrue((boolean)this.partition().partitionState().isInflight(), (String)"ISR should be pending a shrink");
    }

    @Test
    public void testShouldNotShrinkIsrIfPreviousFetchIsCaughtUp() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = this.topicPartition();
        None$ x$2 = None$.MODULE$;
        boolean x$3 = qual$1.getOrCreateLog$default$2();
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        UnifiedLog log = qual$1.getOrCreateLog(x$1, x$3, x$4, (Option)x$2);
        this.seedLogData(log, 10, 4);
        int controllerEpoch = 0;
        int leaderEpoch = 5;
        int remoteBrokerId = this.brokerId() + 1;
        scala.collection.immutable.Seq replicas = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId}));
        scala.collection.immutable.Seq isr = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId}));
        long initializeTimeMs = this.time().milliseconds();
        Assertions.assertTrue((boolean)this.makeLeader((Option<Uuid>)None$.MODULE$, controllerEpoch, leaderEpoch, (scala.collection.immutable.Seq<Object>)isr, (scala.collection.immutable.Seq<Object>)replicas, 1, true, this.partition()));
        Assertions.assertEquals((long)0L, (long)this.partition().localLogOrException().highWatermark());
        Replica remoteReplica = (Replica)this.partition().getReplica(remoteBrokerId).get();
        Assertions.assertEquals((long)initializeTimeMs, (long)remoteReplica.lastCaughtUpTimeMs());
        Assertions.assertEquals((long)LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata().messageOffset(), (long)remoteReplica.logEndOffset());
        Assertions.assertEquals((long)UnifiedLog$.MODULE$.UnknownOffset(), (long)remoteReplica.logStartOffset());
        this.time().sleep(5000L);
        long firstFetchTimeMs = this.time().milliseconds();
        this.partition().updateFollowerFetchState(remoteBrokerId, new LogOffsetMetadata(5L, UnifiedLog$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition()), 0L, firstFetchTimeMs, 10L);
        Assertions.assertEquals((long)initializeTimeMs, (long)remoteReplica.lastCaughtUpTimeMs());
        Assertions.assertEquals((long)5L, (long)this.partition().localLogOrException().highWatermark());
        Assertions.assertEquals((long)5L, (long)remoteReplica.logEndOffset());
        Assertions.assertEquals((long)0L, (long)remoteReplica.logStartOffset());
        this.time().sleep(5001L);
        this.seedLogData(log, 5, leaderEpoch);
        this.partition().updateFollowerFetchState(remoteBrokerId, new LogOffsetMetadata(10L, UnifiedLog$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition()), 0L, this.time().milliseconds(), 15L);
        Assertions.assertEquals((long)firstFetchTimeMs, (long)remoteReplica.lastCaughtUpTimeMs());
        Assertions.assertEquals((long)10L, (long)this.partition().localLogOrException().highWatermark());
        Assertions.assertEquals((long)10L, (long)remoteReplica.logEndOffset());
        Assertions.assertEquals((long)0L, (long)remoteReplica.logStartOffset());
        this.partition().maybeShrinkIsr();
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId})), (Object)this.partition().partitionState().isr());
        Assertions.assertEquals((int)this.alterIsrManager().isrUpdates().size(), (int)0);
    }

    @Test
    public void testShouldNotShrinkIsrIfFollowerCaughtUpToLogEnd() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = this.topicPartition();
        None$ x$2 = None$.MODULE$;
        boolean x$3 = qual$1.getOrCreateLog$default$2();
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        UnifiedLog log = qual$1.getOrCreateLog(x$1, x$3, x$4, (Option)x$2);
        this.seedLogData(log, 10, 4);
        int controllerEpoch = 0;
        int leaderEpoch = 5;
        int remoteBrokerId = this.brokerId() + 1;
        scala.collection.immutable.Seq replicas = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId}));
        scala.collection.immutable.Seq isr = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId}));
        long initializeTimeMs = this.time().milliseconds();
        Assertions.assertTrue((boolean)this.makeLeader((Option<Uuid>)None$.MODULE$, controllerEpoch, leaderEpoch, (scala.collection.immutable.Seq<Object>)isr, (scala.collection.immutable.Seq<Object>)replicas, 1, true, this.partition()));
        Assertions.assertEquals((long)0L, (long)this.partition().localLogOrException().highWatermark());
        Replica remoteReplica = (Replica)this.partition().getReplica(remoteBrokerId).get();
        Assertions.assertEquals((long)initializeTimeMs, (long)remoteReplica.lastCaughtUpTimeMs());
        Assertions.assertEquals((long)LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata().messageOffset(), (long)remoteReplica.logEndOffset());
        Assertions.assertEquals((long)UnifiedLog$.MODULE$.UnknownOffset(), (long)remoteReplica.logStartOffset());
        this.partition().updateFollowerFetchState(remoteBrokerId, new LogOffsetMetadata(10L, UnifiedLog$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition()), 0L, this.time().milliseconds(), 10L);
        Assertions.assertEquals((long)initializeTimeMs, (long)remoteReplica.lastCaughtUpTimeMs());
        Assertions.assertEquals((long)10L, (long)this.partition().localLogOrException().highWatermark());
        Assertions.assertEquals((long)10L, (long)remoteReplica.logEndOffset());
        Assertions.assertEquals((long)0L, (long)remoteReplica.logStartOffset());
        this.time().sleep(30001L);
        this.partition().maybeShrinkIsr();
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId})), (Object)this.partition().partitionState().isr());
        Assertions.assertEquals((int)this.alterIsrManager().isrUpdates().size(), (int)0);
    }

    @Test
    public void testIsrNotShrunkIfUpdateFails() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = this.topicPartition();
        None$ x$2 = None$.MODULE$;
        boolean x$3 = qual$1.getOrCreateLog$default$2();
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        UnifiedLog log = qual$1.getOrCreateLog(x$1, x$3, x$4, (Option)x$2);
        this.seedLogData(log, 10, 4);
        int controllerEpoch = 0;
        int leaderEpoch = 5;
        int remoteBrokerId = this.brokerId() + 1;
        scala.collection.immutable.Seq replicas = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId}));
        scala.collection.immutable.Seq isr = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId}));
        long initializeTimeMs = this.time().milliseconds();
        Assertions.assertTrue((boolean)this.makeLeader((Option<Uuid>)None$.MODULE$, controllerEpoch, leaderEpoch, (scala.collection.immutable.Seq<Object>)isr, (scala.collection.immutable.Seq<Object>)replicas, 1, true, this.partition()));
        Assertions.assertEquals((long)0L, (long)this.partition().localLogOrException().highWatermark());
        Replica remoteReplica = (Replica)this.partition().getReplica(remoteBrokerId).get();
        Assertions.assertEquals((long)initializeTimeMs, (long)remoteReplica.lastCaughtUpTimeMs());
        Assertions.assertEquals((long)LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata().messageOffset(), (long)remoteReplica.logEndOffset());
        Assertions.assertEquals((long)UnifiedLog$.MODULE$.UnknownOffset(), (long)remoteReplica.logStartOffset());
        this.time().sleep(30001L);
        this.partition().maybeShrinkIsr();
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId})), (Object)this.partition().inSyncReplicaIds());
        Assertions.assertEquals((int)this.alterIsrManager().isrUpdates().size(), (int)1);
        Assertions.assertEquals((long)0L, (long)this.partition().localLogOrException().highWatermark());
        this.alterIsrManager().failIsrUpdate(Errors.INVALID_UPDATE_VERSION);
        Assertions.assertEquals(this.partition().partitionState().getClass(), PendingShrinkIsr.class);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId})), (Object)this.partition().inSyncReplicaIds());
        Assertions.assertEquals((int)this.alterIsrManager().isrUpdates().size(), (int)0);
        Assertions.assertEquals((long)0L, (long)this.partition().localLogOrException().highWatermark());
    }

    @Test
    public void testAlterIsrUnknownTopic() {
        this.handleAlterIsrFailure(Errors.UNKNOWN_TOPIC_OR_PARTITION, (Function3<Object, Object, Partition, BoxedUnit>)(Function3 & Serializable)(brokerId, remoteBrokerId, partition) -> {
            PartitionTest.$anonfun$testAlterIsrUnknownTopic$1(this, BoxesRunTime.unboxToInt((Object)brokerId), BoxesRunTime.unboxToInt((Object)remoteBrokerId), partition);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testAlterIsrInvalidVersion() {
        this.handleAlterIsrFailure(Errors.INVALID_UPDATE_VERSION, (Function3<Object, Object, Partition, BoxedUnit>)(Function3 & Serializable)(brokerId, remoteBrokerId, partition) -> {
            PartitionTest.$anonfun$testAlterIsrInvalidVersion$1(this, BoxesRunTime.unboxToInt((Object)brokerId), BoxesRunTime.unboxToInt((Object)remoteBrokerId), partition);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testAlterIsrUnexpectedError() {
        this.handleAlterIsrFailure(Errors.UNKNOWN_SERVER_ERROR, (Function3<Object, Object, Partition, BoxedUnit>)(Function3 & Serializable)(brokerId, remoteBrokerId, partition) -> {
            PartitionTest.$anonfun$testAlterIsrUnexpectedError$1(this, BoxesRunTime.unboxToInt((Object)brokerId), BoxesRunTime.unboxToInt((Object)remoteBrokerId), partition);
            return BoxedUnit.UNIT;
        });
    }

    public void handleAlterIsrFailure(Errors error, Function3<Object, Object, Partition, BoxedUnit> callback) {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = this.topicPartition();
        None$ x$2 = None$.MODULE$;
        boolean x$3 = qual$1.getOrCreateLog$default$2();
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        UnifiedLog log = qual$1.getOrCreateLog(x$1, x$3, x$4, (Option)x$2);
        this.seedLogData(log, 10, 4);
        int controllerEpoch = 0;
        int leaderEpoch = 5;
        int remoteBrokerId = this.brokerId() + 1;
        scala.collection.immutable.Seq replicas = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId}));
        scala.collection.immutable.Seq isr = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()}));
        Assertions.assertTrue((boolean)this.makeLeader((Option<Uuid>)None$.MODULE$, controllerEpoch, leaderEpoch, (scala.collection.immutable.Seq<Object>)isr, (scala.collection.immutable.Seq<Object>)replicas, 1, true, this.partition()));
        Assertions.assertEquals((long)10L, (long)this.partition().localLogOrException().highWatermark());
        Replica remoteReplica = (Replica)this.partition().getReplica(remoteBrokerId).get();
        Assertions.assertEquals((long)LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata().messageOffset(), (long)remoteReplica.logEndOffset());
        Assertions.assertEquals((long)UnifiedLog$.MODULE$.UnknownOffset(), (long)remoteReplica.logStartOffset());
        this.partition().updateFollowerFetchState(remoteBrokerId, new LogOffsetMetadata(10L, UnifiedLog$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition()), 0L, this.time().milliseconds(), 10L);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), (Object)this.partition().inSyncReplicaIds());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId})), (Object)this.partition().partitionState().maximalIsr());
        Assertions.assertEquals((int)this.alterIsrManager().isrUpdates().size(), (int)1);
        Assertions.assertEquals((long)10L, (long)remoteReplica.logEndOffset());
        Assertions.assertEquals((long)0L, (long)remoteReplica.logStartOffset());
        this.alterIsrManager().failIsrUpdate(error);
        callback.apply((Object)BoxesRunTime.boxToInteger((int)this.brokerId()), (Object)BoxesRunTime.boxToInteger((int)remoteBrokerId), (Object)this.partition());
    }

    private ClientResponse createClientResponseWithAlterPartitionResponse(TopicPartition topicPartition, short partitionErrorCode, List<Object> isr, int leaderEpoch, int partitionEpoch) {
        AlterPartitionResponseData alterPartitionResponseData = new AlterPartitionResponseData();
        AlterPartitionResponseData.TopicData topicResponse = new AlterPartitionResponseData.TopicData().setName(topicPartition.topic());
        topicResponse.partitions().add(new AlterPartitionResponseData.PartitionData().setPartitionIndex(topicPartition.partition()).setIsr(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)isr.map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1))).asJava()).setLeaderEpoch(leaderEpoch).setPartitionEpoch(partitionEpoch).setErrorCode(partitionErrorCode));
        alterPartitionResponseData.topics().add(topicResponse);
        AlterPartitionResponse alterPartitionResponse = new AlterPartitionResponse(alterPartitionResponseData);
        return new ClientResponse(new RequestHeader(ApiKeys.ALTER_PARTITION, 0, "client", 1), null, null, 0L, 0L, false, null, null, (AbstractResponse)alterPartitionResponse);
    }

    private List<Object> createClientResponseWithAlterPartitionResponse$default$3() {
        return package$.MODULE$.List().empty();
    }

    private int createClientResponseWithAlterPartitionResponse$default$4() {
        return 0;
    }

    private int createClientResponseWithAlterPartitionResponse$default$5() {
        return 0;
    }

    @Test
    public void testPartitionShouldRetryAlterPartitionRequest() {
        BrokerToControllerChannelManager mockChannelManager = (BrokerToControllerChannelManager)Mockito.mock(BrokerToControllerChannelManager.class);
        DefaultAlterIsrManager alterPartitionManager = new DefaultAlterIsrManager(mockChannelManager, (Scheduler)Mockito.mock(KafkaScheduler.class), (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L, (ApiVersion)KAFKA_3_2_IV0$.MODULE$);
        this.partition_$eq(new Partition(this.topicPartition(), Defaults$.MODULE$.ReplicaLagTimeMaxMs(), this.interBrokerProtocolVersion(), this.brokerId(), (Time)this.time(), (IsrChangeListener)this.isrChangeListener(), this.delayedOperations(), this.metadataCache(), this.logManager(), (AlterIsrManager)alterPartitionManager));
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = this.topicPartition();
        None$ x$2 = None$.MODULE$;
        boolean x$3 = qual$1.getOrCreateLog$default$2();
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        UnifiedLog log = qual$1.getOrCreateLog(x$1, x$3, x$4, (Option)x$2);
        this.seedLogData(log, 10, 4);
        int controllerEpoch = 0;
        int leaderEpoch = 5;
        int follower1 = this.brokerId() + 1;
        int follower2 = this.brokerId() + 2;
        int follower3 = this.brokerId() + 3;
        scala.collection.immutable.Seq replicas = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), follower1, follower2, follower3}));
        scala.collection.immutable.Seq isr = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), follower1, follower2}));
        int partitionEpoch = 1;
        ((DelayedOperations)Mockito.doNothing().when((Object)this.delayedOperations())).checkAndCompleteAll();
        ClientResponse alterPartitionResponseWithUnknownServerError = this.createClientResponseWithAlterPartitionResponse(this.topicPartition(), Errors.UNKNOWN_SERVER_ERROR.code(), this.createClientResponseWithAlterPartitionResponse$default$3(), 0, 0);
        ClientResponse alterPartitionResponseWithoutError = this.createClientResponseWithAlterPartitionResponse(this.topicPartition(), Errors.NONE.code(), (List<Object>)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), follower1, follower2, follower3}))), leaderEpoch, partitionEpoch + 1);
        mockChannelManager.sendRequest((AbstractRequest.Builder)ArgumentMatchers.any(), (ControllerRequestCompletionHandler)ArgumentMatchers.any());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(invocation -> {
            PartitionTest.$anonfun$testPartitionShouldRetryAlterPartitionRequest$2(alterPartitionResponseWithUnknownServerError, invocation);
            return BoxedUnit.UNIT;
        }).thenAnswer(invocation -> {
            PartitionTest.$anonfun$testPartitionShouldRetryAlterPartitionRequest$3(alterPartitionResponseWithoutError, invocation);
            return BoxedUnit.UNIT;
        });
        Assertions.assertTrue((boolean)this.makeLeader((Option<Uuid>)None$.MODULE$, controllerEpoch, leaderEpoch, (scala.collection.immutable.Seq<Object>)isr, (scala.collection.immutable.Seq<Object>)replicas, partitionEpoch, true, this.partition()));
        Assertions.assertEquals((long)0L, (long)this.partition().localLogOrException().highWatermark());
        this.partition().updateFollowerFetchState(follower3, new LogOffsetMetadata(10L, UnifiedLog$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition()), 0L, this.time().milliseconds(), 10L);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), follower1, follower2, follower3})), (Object)this.partition().partitionState().isr());
        Assertions.assertEquals((int)(partitionEpoch + 1), (int)this.partition().getZkVersion());
        ((BrokerToControllerChannelManager)Mockito.verify((Object)mockChannelManager, (VerificationMode)Mockito.times((int)2))).sendRequest((AbstractRequest.Builder)ArgumentMatchers.any(), (ControllerRequestCompletionHandler)ArgumentMatchers.any());
        Assertions.assertFalse((boolean)this.partition().partitionState().isInflight());
    }

    @Test
    public void testSingleInFlightAlterIsr() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = this.topicPartition();
        None$ x$2 = None$.MODULE$;
        boolean x$3 = qual$1.getOrCreateLog$default$2();
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        UnifiedLog log = qual$1.getOrCreateLog(x$1, x$3, x$4, (Option)x$2);
        this.seedLogData(log, 10, 4);
        int controllerEpoch = 0;
        int leaderEpoch = 5;
        int follower1 = this.brokerId() + 1;
        int follower2 = this.brokerId() + 2;
        int follower3 = this.brokerId() + 3;
        scala.collection.immutable.Seq replicas = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), follower1, follower2, follower3}));
        scala.collection.immutable.Seq isr = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), follower1, follower2}));
        ((DelayedOperations)Mockito.doNothing().when((Object)this.delayedOperations())).checkAndCompleteAll();
        Assertions.assertTrue((boolean)this.makeLeader((Option<Uuid>)None$.MODULE$, controllerEpoch, leaderEpoch, (scala.collection.immutable.Seq<Object>)isr, (scala.collection.immutable.Seq<Object>)replicas, 1, true, this.partition()));
        Assertions.assertEquals((long)0L, (long)this.partition().localLogOrException().highWatermark());
        this.partition().updateFollowerFetchState(follower3, new LogOffsetMetadata(10L, UnifiedLog$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition()), 0L, this.time().milliseconds(), 10L);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), follower1, follower2})), (Object)this.partition().partitionState().isr());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), follower1, follower2, follower3})), (Object)this.partition().partitionState().maximalIsr());
        Assertions.assertEquals((int)this.alterIsrManager().isrUpdates().size(), (int)1);
        this.time().sleep(this.partition().replicaLagTimeMaxMs() + 1L);
        this.partition().maybeShrinkIsr();
        Assertions.assertEquals((int)this.alterIsrManager().isrUpdates().size(), (int)1);
    }

    @Test
    public void testZkIsrManagerAsyncCallback() {
        KafkaScheduler scheduler = new KafkaScheduler(1, "zk-isr-test", true);
        scheduler.startup();
        KafkaZkClient kafkaZkClient = (KafkaZkClient)Mockito.mock(KafkaZkClient.class);
        ((KafkaZkClient)Mockito.doAnswer(x$2 -> new Tuple2.mcZI.sp(true, 2)).when((Object)kafkaZkClient)).conditionalUpdatePath(ArgumentMatchers.anyString(), (byte[])ArgumentMatchers.any(), ArgumentMatchers.eq((int)1), (Option)ArgumentMatchers.any());
        MockTime apply_time = this.time();
        Object var25_3 = null;
        ZkIsrManager zkIsrManager = new ZkIsrManager((Scheduler)scheduler, (Time)apply_time, kafkaZkClient);
        zkIsrManager.start();
        Partition partition = new Partition(this.topicPartition(), Defaults$.MODULE$.ReplicaLagTimeMaxMs(), (ApiVersion)KAFKA_2_6_IV0$.MODULE$, this.brokerId(), (Time)this.time(), (IsrChangeListener)this.isrChangeListener(), this.delayedOperations(), this.metadataCache(), this.logManager(), (AlterIsrManager)zkIsrManager);
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = this.topicPartition();
        None$ x$22 = None$.MODULE$;
        boolean x$3 = qual$1.getOrCreateLog$default$2();
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        UnifiedLog log = qual$1.getOrCreateLog(x$1, x$3, x$4, (Option)x$22);
        this.seedLogData(log, 10, 4);
        int controllerEpoch = 0;
        int leaderEpoch = 5;
        int follower1 = this.brokerId() + 1;
        int follower2 = this.brokerId() + 2;
        int follower3 = this.brokerId() + 3;
        scala.collection.immutable.Seq replicas = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), follower1, follower2, follower3}));
        scala.collection.immutable.Seq isr = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), follower1, follower2}));
        ((DelayedOperations)Mockito.doNothing().when((Object)this.delayedOperations())).checkAndCompleteAll();
        None$ x$6 = None$.MODULE$;
        Assertions.assertTrue((boolean)this.makeLeader((Option<Uuid>)x$6, controllerEpoch, leaderEpoch, (scala.collection.immutable.Seq<Object>)isr, (scala.collection.immutable.Seq<Object>)replicas, 1, true, partition));
        Assertions.assertEquals((long)0L, (long)partition.localLogOrException().highWatermark());
        partition.updateFollowerFetchState(follower3, new LogOffsetMetadata(10L, UnifiedLog$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition()), 0L, this.time().milliseconds(), 10L);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!PartitionTest.$anonfun$testZkIsrManagerAsyncCallback$2(partition)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Expected ISR state to be committed");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), l));
        }
        PartitionState partitionState = partition.partitionState();
        if (partitionState instanceof CommittedPartitionState) {
            scala.collection.immutable.Set isr2 = ((CommittedPartitionState)partitionState).isr();
            Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), follower1, follower2, follower3})), (Object)isr2);
        } else {
            BoxedUnit cfr_ignored_0 = (BoxedUnit)Assertions.fail((String)"Expected a committed ISR following Zk expansion");
        }
        scheduler.shutdown();
    }

    @Test
    public void testUseCheckpointToInitializeHighWatermark() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = this.topicPartition();
        None$ x$2 = None$.MODULE$;
        boolean x$3 = qual$1.getOrCreateLog$default$2();
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        UnifiedLog log = qual$1.getOrCreateLog(x$1, x$3, x$4, (Option)x$2);
        this.seedLogData(log, 6, 5);
        Mockito.when((Object)this.offsetCheckpoints().fetch(this.logDir1().getAbsolutePath(), this.topicPartition())).thenReturn((Object)new Some((Object)BoxesRunTime.boxToLong((long)4L)));
        int controllerEpoch = 3;
        java.util.List replicas = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(this.brokerId()), Predef$.MODULE$.int2Integer(this.brokerId() + 1)}))).asJava();
        LeaderAndIsrRequestData.LeaderAndIsrPartitionState leaderState = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(this.brokerId()).setLeaderEpoch(6).setIsr(replicas).setZkVersion(1).setReplicas(replicas).setIsNew(false);
        this.partition().makeLeader(leaderState, this.offsetCheckpoints(), (Option)None$.MODULE$);
        Assertions.assertEquals((long)4L, (long)this.partition().localLogOrException().highWatermark());
    }

    @Test
    public void testTopicIdAndPartitionMetadataFileForLeader() {
        int controllerEpoch = 3;
        int leaderEpoch = 5;
        Uuid topicId = Uuid.randomUuid();
        java.util.List replicas = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(this.brokerId()), Predef$.MODULE$.int2Integer(this.brokerId() + 1)}))).asJava();
        LeaderAndIsrRequestData.LeaderAndIsrPartitionState leaderState = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(this.brokerId()).setLeaderEpoch(leaderEpoch).setIsr(replicas).setZkVersion(1).setReplicas(replicas).setIsNew(false);
        this.partition().makeLeader(leaderState, this.offsetCheckpoints(), (Option)new Some((Object)topicId));
        this.checkTopicId(topicId, this.partition());
        Partition partition2 = new Partition(this.topicPartition(), Defaults$.MODULE$.ReplicaLagTimeMaxMs(), ApiVersion$.MODULE$.latestVersion(), this.brokerId(), (Time)this.time(), (IsrChangeListener)this.isrChangeListener(), this.delayedOperations(), this.metadataCache(), this.logManager(), (AlterIsrManager)this.alterIsrManager());
        Assertions.assertTrue((boolean)partition2.topicId().isDefined());
        Assertions.assertEquals((Object)topicId, (Object)partition2.topicId().get());
        Assertions.assertFalse((boolean)partition2.log().isDefined());
        Assertions.assertThrows(InconsistentTopicIdException.class, () -> partition2.makeLeader(leaderState, this.offsetCheckpoints(), (Option)new Some((Object)Uuid.randomUuid())));
        partition2.makeLeader(leaderState, this.offsetCheckpoints(), (Option)None$.MODULE$);
        this.checkTopicId(topicId, partition2);
    }

    @Test
    public void testTopicIdAndPartitionMetadataFileForFollower() {
        int controllerEpoch = 3;
        int leaderEpoch = 5;
        Uuid topicId = Uuid.randomUuid();
        java.util.List replicas = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(this.brokerId()), Predef$.MODULE$.int2Integer(this.brokerId() + 1)}))).asJava();
        LeaderAndIsrRequestData.LeaderAndIsrPartitionState leaderState = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(this.brokerId()).setLeaderEpoch(leaderEpoch).setIsr(replicas).setZkVersion(1).setReplicas(replicas).setIsNew(false);
        this.partition().makeFollower(leaderState, this.offsetCheckpoints(), (Option)new Some((Object)topicId));
        this.checkTopicId(topicId, this.partition());
        Partition partition2 = new Partition(this.topicPartition(), Defaults$.MODULE$.ReplicaLagTimeMaxMs(), ApiVersion$.MODULE$.latestVersion(), this.brokerId(), (Time)this.time(), (IsrChangeListener)this.isrChangeListener(), this.delayedOperations(), this.metadataCache(), this.logManager(), (AlterIsrManager)this.alterIsrManager());
        Assertions.assertTrue((boolean)partition2.topicId().isDefined());
        Assertions.assertEquals((Object)topicId, (Object)partition2.topicId().get());
        Assertions.assertFalse((boolean)partition2.log().isDefined());
        Assertions.assertThrows(InconsistentTopicIdException.class, () -> partition2.makeFollower(leaderState, this.offsetCheckpoints(), (Option)new Some((Object)Uuid.randomUuid())));
        partition2.makeFollower(leaderState, this.offsetCheckpoints(), (Option)None$.MODULE$);
        this.checkTopicId(topicId, partition2);
    }

    public void checkTopicId(Uuid expectedTopicId, Partition partition) {
        Assertions.assertTrue((boolean)partition.topicId().isDefined());
        Assertions.assertEquals((Object)expectedTopicId, (Object)partition.topicId().get());
        Assertions.assertTrue((boolean)partition.log().isDefined());
        UnifiedLog log = (UnifiedLog)partition.log().get();
        Assertions.assertEquals((Object)expectedTopicId, (Object)log.topicId().get());
        Assertions.assertTrue((boolean)log.partitionMetadataFile().exists());
        Assertions.assertEquals((Object)expectedTopicId, (Object)log.partitionMetadataFile().read().topicId());
    }

    @Test
    public void testAddAndRemoveMetrics() {
        Assertions.assertTrue((boolean)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"UnderReplicated", "UnderMinIsr", "InSyncReplicasCount", "ReplicasCount", "LastStableOffsetLag", "AtMinIsr"}))).forall((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)PartitionTest.$anonfun$testAddAndRemoveMetrics$3(x$4))));
        Partition$.MODULE$.removeMetrics(this.topicPartition());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$), (Object)CollectionConverters$.MODULE$.MapHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala().keySet().filter((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)PartitionTest.$anonfun$testAddAndRemoveMetrics$4(x$5))));
    }

    @Test
    public void testUnderReplicatedPartitionsCorrectSemantics() {
        int controllerEpoch = 3;
        java.util.List replicas = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(this.brokerId()), Predef$.MODULE$.int2Integer(this.brokerId() + 1), Predef$.MODULE$.int2Integer(this.brokerId() + 2)}))).asJava();
        java.util.List isr = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(this.brokerId()), Predef$.MODULE$.int2Integer(this.brokerId() + 1)}))).asJava();
        LeaderAndIsrRequestData.LeaderAndIsrPartitionState leaderState = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(this.brokerId()).setLeaderEpoch(6).setIsr(isr).setZkVersion(1).setReplicas(replicas).setIsNew(false);
        this.partition().makeLeader(leaderState, this.offsetCheckpoints(), (Option)None$.MODULE$);
        Assertions.assertTrue((boolean)this.partition().isUnderReplicated());
        leaderState = leaderState.setIsr(replicas);
        this.partition().makeLeader(leaderState, this.offsetCheckpoints(), (Option)None$.MODULE$);
        Assertions.assertFalse((boolean)this.partition().isUnderReplicated());
    }

    @Test
    public void testUpdateAssignmentAndIsr() {
        TopicPartition topicPartition = new TopicPartition("test", 1);
        Partition partition = new Partition(topicPartition, 1000L, ApiVersion$.MODULE$.latestVersion(), 0, (Time)new SystemTime(), (IsrChangeListener)Mockito.mock(IsrChangeListener.class), (DelayedOperations)Mockito.mock(DelayedOperations.class), (MetadataCache)Mockito.mock(MetadataCache.class), (LogManager)Mockito.mock(LogManager.class), (AlterIsrManager)Mockito.mock(AlterIsrManager.class));
        scala.collection.immutable.Seq replicas = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3}));
        scala.collection.immutable.Set isr = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3}));
        scala.collection.immutable.Seq adding = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4, 5}));
        scala.collection.immutable.Seq removing = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2}));
        partition.updateAssignmentAndIsr((Seq)replicas, isr, (Seq)adding, (Seq)removing, LeaderRecoveryState.RECOVERED);
        Assertions.assertTrue((boolean)(partition.assignmentState() instanceof OngoingReassignmentState), (String)"The assignmentState is not OngoingReassignmentState");
        Assertions.assertEquals((Object)replicas, (Object)partition.assignmentState().replicas());
        Assertions.assertEquals((Object)isr, (Object)partition.partitionState().isr());
        Assertions.assertEquals((Object)adding, (Object)((OngoingReassignmentState)partition.assignmentState()).addingReplicas());
        Assertions.assertEquals((Object)removing, (Object)((OngoingReassignmentState)partition.assignmentState()).removingReplicas());
        Assertions.assertEquals((Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Object)partition.remoteReplicas().map((Function1 & Serializable)x$6 -> BoxesRunTime.boxToInteger((int)x$6.brokerId())));
        scala.collection.immutable.Seq replicas2 = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 3, 4, 5}));
        scala.collection.immutable.Set isr2 = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 3, 4, 5}));
        partition.updateAssignmentAndIsr((Seq)replicas2, isr2, (Seq)package$.MODULE$.Seq().empty(), (Seq)package$.MODULE$.Seq().empty(), LeaderRecoveryState.RECOVERED);
        Assertions.assertTrue((boolean)(partition.assignmentState() instanceof SimpleAssignmentState), (String)"The assignmentState is not SimpleAssignmentState");
        Assertions.assertEquals((Object)replicas2, (Object)partition.assignmentState().replicas());
        Assertions.assertEquals((Object)isr2, (Object)partition.partitionState().isr());
        Assertions.assertEquals((Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 4, 5})), (Object)partition.remoteReplicas().map((Function1 & Serializable)x$7 -> BoxesRunTime.boxToInteger((int)x$7.brokerId())));
    }

    @Test
    public void testLogConfigNotDirty() {
        String string;
        this.logManager().shutdown();
        MockConfigRepository spyConfigRepository = (MockConfigRepository)Mockito.spy((Object)this.configRepository());
        int n = 1;
        long l = 0x400000L;
        double d = 0.9;
        int n2 = 0x100000;
        int n3 = 0x2000000;
        double d2 = Double.MAX_VALUE;
        long l2 = 15000L;
        String string2 = string = "MD5";
        string = null;
        String x$9 = string2;
        this.logManager_$eq(TestUtils$.MODULE$.createLogManager((Seq<File>)((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new File[]{this.logDir1(), this.logDir2()}))), this.logConfig(), spyConfigRepository, new CleanerConfig(n, l, d, n2, n3, d2, l2, false, x$9), this.time(), ApiVersion$.MODULE$.latestVersion()));
        LogManager spyLogManager = (LogManager)Mockito.spy((Object)this.logManager());
        new Partition(this.topicPartition(), Defaults$.MODULE$.ReplicaLagTimeMaxMs(), ApiVersion$.MODULE$.latestVersion(), this.brokerId(), (Time)this.time(), (IsrChangeListener)this.isrChangeListener(), this.delayedOperations(), this.metadataCache(), spyLogManager, (AlterIsrManager)this.alterIsrManager()).createLog(true, false, this.offsetCheckpoints(), (Option)None$.MODULE$);
        ((LogManager)Mockito.verify((Object)spyLogManager)).initializingLog((TopicPartition)ArgumentMatchers.eq((Object)this.topicPartition()));
        ((LogManager)Mockito.verify((Object)spyLogManager)).finishedInitializingLog((TopicPartition)ArgumentMatchers.eq((Object)this.topicPartition()), (Option)ArgumentMatchers.any());
        ((ConfigRepository)Mockito.verify((Object)spyConfigRepository, (VerificationMode)Mockito.times((int)1))).topicConfig(this.topicPartition().topic());
    }

    @Test
    public void testLogConfigDirtyAsTopicUpdated() {
        String string;
        this.logManager().shutdown();
        MockConfigRepository spyConfigRepository = (MockConfigRepository)Mockito.spy((Object)this.configRepository());
        int n = 1;
        long l = 0x400000L;
        double d = 0.9;
        int n2 = 0x100000;
        int n3 = 0x2000000;
        double d2 = Double.MAX_VALUE;
        long l2 = 15000L;
        String string2 = string = "MD5";
        string = null;
        String x$9 = string2;
        this.logManager_$eq(TestUtils$.MODULE$.createLogManager((Seq<File>)((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new File[]{this.logDir1(), this.logDir2()}))), this.logConfig(), spyConfigRepository, new CleanerConfig(n, l, d, n2, n3, d2, l2, false, x$9), this.time(), ApiVersion$.MODULE$.latestVersion()));
        LogManager spyLogManager = (LogManager)Mockito.spy((Object)this.logManager());
        ((LogManager)Mockito.doAnswer(x$8 -> {
            PartitionTest.$anonfun$testLogConfigDirtyAsTopicUpdated$1(this, x$8);
            return BoxedUnit.UNIT;
        }).when((Object)spyLogManager)).initializingLog((TopicPartition)ArgumentMatchers.eq((Object)this.topicPartition()));
        new Partition(this.topicPartition(), Defaults$.MODULE$.ReplicaLagTimeMaxMs(), ApiVersion$.MODULE$.latestVersion(), this.brokerId(), (Time)this.time(), (IsrChangeListener)this.isrChangeListener(), this.delayedOperations(), this.metadataCache(), spyLogManager, (AlterIsrManager)this.alterIsrManager()).createLog(true, false, this.offsetCheckpoints(), (Option)None$.MODULE$);
        ((LogManager)Mockito.verify((Object)spyLogManager)).initializingLog((TopicPartition)ArgumentMatchers.eq((Object)this.topicPartition()));
        ((LogManager)Mockito.verify((Object)spyLogManager)).finishedInitializingLog((TopicPartition)ArgumentMatchers.eq((Object)this.topicPartition()), (Option)ArgumentMatchers.any());
        ((ConfigRepository)Mockito.verify((Object)spyConfigRepository, (VerificationMode)Mockito.times((int)2))).topicConfig(this.topicPartition().topic());
    }

    @Test
    public void testLogConfigDirtyAsBrokerUpdated() {
        String string;
        this.logManager().shutdown();
        MockConfigRepository spyConfigRepository = (MockConfigRepository)Mockito.spy((Object)this.configRepository());
        int n = 1;
        long l = 0x400000L;
        double d = 0.9;
        int n2 = 0x100000;
        int n3 = 0x2000000;
        double d2 = Double.MAX_VALUE;
        long l2 = 15000L;
        String string2 = string = "MD5";
        string = null;
        String x$92 = string2;
        this.logManager_$eq(TestUtils$.MODULE$.createLogManager((Seq<File>)((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new File[]{this.logDir1(), this.logDir2()}))), this.logConfig(), spyConfigRepository, new CleanerConfig(n, l, d, n2, n3, d2, l2, false, x$92), this.time(), ApiVersion$.MODULE$.latestVersion()));
        this.logManager().startup((Set)Predef$.MODULE$.Set().empty());
        LogManager spyLogManager = (LogManager)Mockito.spy((Object)this.logManager());
        ((LogManager)Mockito.doAnswer(x$9 -> {
            PartitionTest.$anonfun$testLogConfigDirtyAsBrokerUpdated$1(this, x$9);
            return BoxedUnit.UNIT;
        }).when((Object)spyLogManager)).initializingLog((TopicPartition)ArgumentMatchers.eq((Object)this.topicPartition()));
        new Partition(this.topicPartition(), Defaults$.MODULE$.ReplicaLagTimeMaxMs(), ApiVersion$.MODULE$.latestVersion(), this.brokerId(), (Time)this.time(), (IsrChangeListener)this.isrChangeListener(), this.delayedOperations(), this.metadataCache(), spyLogManager, (AlterIsrManager)this.alterIsrManager()).createLog(true, false, this.offsetCheckpoints(), (Option)None$.MODULE$);
        ((LogManager)Mockito.verify((Object)spyLogManager)).initializingLog((TopicPartition)ArgumentMatchers.eq((Object)this.topicPartition()));
        ((LogManager)Mockito.verify((Object)spyLogManager)).finishedInitializingLog((TopicPartition)ArgumentMatchers.eq((Object)this.topicPartition()), (Option)ArgumentMatchers.any());
        ((ConfigRepository)Mockito.verify((Object)spyConfigRepository, (VerificationMode)Mockito.times((int)2))).topicConfig(this.topicPartition().topic());
    }

    private boolean makeLeader(Option<Uuid> topicId, int controllerEpoch, int leaderEpoch, scala.collection.immutable.Seq<Object> isr, scala.collection.immutable.Seq<Object> replicas, int zkVersion, boolean isNew, Partition partition) {
        partition.createLogIfNotExists(isNew, false, this.offsetCheckpoints(), topicId);
        boolean newLeader = partition.makeLeader(new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(this.brokerId()).setLeaderEpoch(leaderEpoch).setIsr(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)isr.map((Function1 & Serializable)x -> PartitionTest.$anonfun$makeLeader$1(BoxesRunTime.unboxToInt((Object)x)))).asJava()).setZkVersion(zkVersion).setReplicas(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)replicas.map((Function1 & Serializable)x -> PartitionTest.$anonfun$makeLeader$2(BoxesRunTime.unboxToInt((Object)x)))).asJava()).setIsNew(isNew), this.offsetCheckpoints(), topicId);
        Assertions.assertTrue((boolean)partition.isLeader());
        Assertions.assertFalse((boolean)partition.partitionState().isInflight());
        Assertions.assertEquals(topicId, (Object)partition.topicId());
        Assertions.assertEquals((int)leaderEpoch, (int)partition.getLeaderEpoch());
        Assertions.assertEquals((Object)isr.toSet(), (Object)partition.partitionState().isr());
        Assertions.assertEquals((Object)isr.toSet(), (Object)partition.partitionState().maximalIsr());
        Assertions.assertEquals((int)zkVersion, (int)partition.getZkVersion());
        return newLeader;
    }

    private Partition makeLeader$default$8() {
        return this.partition();
    }

    private void seedLogData(UnifiedLog log, int numRecords, int leaderEpoch) {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numRecords).foreach((Function1 & Serializable)i -> PartitionTest.$anonfun$seedLogData$1(leaderEpoch, log, BoxesRunTime.unboxToInt((Object)i)));
    }

    public static final /* synthetic */ SimpleRecord $anonfun$testLastFetchedOffsetValidation$1(int i) {
        return new SimpleRecord(String.valueOf(BoxesRunTime.boxToInteger((int)i)).getBytes());
    }

    /*
     * WARNING - void declaration
     */
    private static final void append$1(int leaderEpoch, int count, UnifiedLog log$1) {
        void withRecords_records;
        void withRecords_compressionType;
        MemoryRecords memoryRecords;
        IndexedSeq recordArray = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), count).map((Function1 & Serializable)i -> PartitionTest.$anonfun$testLastFetchedOffsetValidation$1(BoxesRunTime.unboxToInt((Object)i)));
        SimpleRecord[] simpleRecordArray = (SimpleRecord[])recordArray.toArray(ClassTag$.MODULE$.apply(SimpleRecord.class));
        CompressionType compressionType = CompressionType.NONE;
        long withRecords_initialOffset = 0L;
        MemoryRecords memoryRecords2 = memoryRecords = MemoryRecords.withRecords((byte)2, (long)withRecords_initialOffset, (CompressionType)withRecords_compressionType, (TimestampType)TimestampType.CREATE_TIME, (long)-1L, (short)-1, (int)-1, (int)leaderEpoch, (boolean)false, (SimpleRecord[])withRecords_records);
        compressionType = null;
        simpleRecordArray = null;
        memoryRecords = null;
        MemoryRecords records = memoryRecords2;
        log$1.appendAsLeader(records, leaderEpoch, log$1.appendAsLeader$default$3(), log$1.appendAsLeader$default$4(), log$1.appendAsLeader$default$5());
    }

    private static final FetchResponseData.EpochEndOffset epochEndOffset$1(int epoch, long endOffset) {
        return new FetchResponseData.EpochEndOffset().setEpoch(epoch).setEndOffset(endOffset);
    }

    private static final LogReadInfo read$1(int lastFetchedEpoch, long fetchOffset, Partition partition$1, int leaderEpoch$1) {
        return partition$1.readRecords(Optional.of(Predef$.MODULE$.int2Integer(lastFetchedEpoch)), fetchOffset, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch$1)), Integer.MAX_VALUE, (FetchIsolation)FetchLogEnd$.MODULE$, true, true);
    }

    private static final void assertDivergence$1(FetchResponseData.EpochEndOffset divergingEpoch, LogReadInfo readInfo) {
        Assertions.assertEquals((Object)new Some((Object)divergingEpoch), (Object)readInfo.divergingEpoch());
        Assertions.assertEquals((int)0, (int)readInfo.fetchedData().records().sizeInBytes());
    }

    private static final void assertNoDivergence$1(LogReadInfo readInfo) {
        Assertions.assertEquals((Object)None$.MODULE$, (Object)readInfo.divergingEpoch());
    }

    public static final /* synthetic */ boolean $anonfun$testMakeFollowerWithWithFollowerAppendRecords$1(Semaphore appendSemaphore$1) {
        return appendSemaphore$1.hasQueuedThreads();
    }

    public static final /* synthetic */ String $anonfun$testMakeFollowerWithWithFollowerAppendRecords$2() {
        return "follower log append is not called.";
    }

    private static final void assertSnapshotError$1(Errors expectedError, Optional currentLeaderEpoch, Partition partition$2) {
        try {
            partition$2.fetchOffsetSnapshot(currentLeaderEpoch, true);
            Assertions.assertEquals((Object)Errors.NONE, (Object)expectedError);
            return;
        }
        catch (ApiException error) {
            Assertions.assertEquals((Object)expectedError, (Object)Errors.forException((Throwable)error));
            return;
        }
    }

    private static final void assertSnapshotError$2(Errors expectedError, Optional currentLeaderEpoch, boolean fetchOnlyLeader, Partition partition$3) {
        try {
            partition$3.fetchOffsetSnapshot(currentLeaderEpoch, fetchOnlyLeader);
            Assertions.assertEquals((Object)Errors.NONE, (Object)expectedError);
            return;
        }
        catch (ApiException error) {
            Assertions.assertEquals((Object)expectedError, (Object)Errors.forException((Throwable)error));
            return;
        }
    }

    private static final void assertLastOffsetForLeaderError$1(Errors error, Optional currentLeaderEpochOpt, Partition partition$4) {
        OffsetForLeaderEpochResponseData.EpochEndOffset endOffset = partition$4.lastOffsetForLeaderEpoch(currentLeaderEpochOpt, 0, true);
        Assertions.assertEquals((short)error.code(), (short)endOffset.errorCode());
    }

    private static final void assertLastOffsetForLeaderError$2(Errors error, Optional currentLeaderEpochOpt, boolean fetchOnlyLeader, Partition partition$5) {
        OffsetForLeaderEpochResponseData.EpochEndOffset endOffset = partition$5.lastOffsetForLeaderEpoch(currentLeaderEpochOpt, 0, fetchOnlyLeader);
        Assertions.assertEquals((short)error.code(), (short)endOffset.errorCode());
    }

    private static final void assertReadRecordsError$1(Errors error, Optional currentLeaderEpochOpt, Partition partition$6) {
        try {
            partition$6.readRecords(Optional.empty(), 0L, currentLeaderEpochOpt, 1024, (FetchIsolation)FetchLogEnd$.MODULE$, true, false);
            Errors errors = error;
            Errors errors2 = Errors.NONE;
            if (errors == null ? errors2 != null : !errors.equals(errors2)) {
                Assertions.fail((String)new StringBuilder(40).append("Expected readRecords to fail with error ").append(error).toString());
            }
        }
        catch (Exception e) {
            Assertions.assertEquals((Object)error, (Object)Errors.forException((Throwable)e));
        }
    }

    private static final void assertReadRecordsError$2(Errors error, Optional currentLeaderEpochOpt, boolean fetchOnlyLeader, Partition partition$7) {
        try {
            partition$7.readRecords(Optional.empty(), 0L, currentLeaderEpochOpt, 1024, (FetchIsolation)FetchLogEnd$.MODULE$, fetchOnlyLeader, false);
            Errors errors = error;
            Errors errors2 = Errors.NONE;
            if (errors == null ? errors2 != null : !errors.equals(errors2)) {
                Assertions.fail((String)new StringBuilder(40).append("Expected readRecords to fail with error ").append(error).toString());
            }
        }
        catch (Exception e) {
            Assertions.assertEquals((Object)error, (Object)Errors.forException((Throwable)e));
        }
    }

    private static final void assertFetchOffsetError$1(Errors error, Optional currentLeaderEpochOpt, Partition partition$8) {
        try {
            partition$8.fetchOffsetForTimestamp(0L, (Option)None$.MODULE$, currentLeaderEpochOpt, true);
            Errors errors = error;
            Errors errors2 = Errors.NONE;
            if (errors == null ? errors2 != null : !errors.equals(errors2)) {
                Assertions.fail((String)new StringBuilder(40).append("Expected readRecords to fail with error ").append(error).toString());
            }
        }
        catch (Exception e) {
            Assertions.assertEquals((Object)error, (Object)Errors.forException((Throwable)e));
        }
    }

    private static final void assertFetchOffsetError$2(Errors error, Optional currentLeaderEpochOpt, boolean fetchOnlyLeader, Partition partition$9) {
        try {
            partition$9.fetchOffsetForTimestamp(0L, (Option)None$.MODULE$, currentLeaderEpochOpt, fetchOnlyLeader);
            Errors errors = error;
            Errors errors2 = Errors.NONE;
            if (errors == null ? errors2 != null : !errors.equals(errors2)) {
                Assertions.fail((String)new StringBuilder(40).append("Expected readRecords to fail with error ").append(error).toString());
            }
        }
        catch (Exception e) {
            Assertions.assertEquals((Object)error, (Object)Errors.forException((Throwable)e));
        }
    }

    public static final /* synthetic */ Integer $anonfun$testMonotonicOffsetsAfterLeaderChange$1(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }

    private final void updateFollowerFetchState$1(int followerId, LogOffsetMetadata fetchOffsetMetadata) {
        this.partition().updateFollowerFetchState(followerId, fetchOffsetMetadata, 0L, this.time().milliseconds(), this.partition().localLogOrException().logEndOffset());
    }

    private final Either fetchOffsetsForTimestamp$1(long timestamp, Option isolation) {
        try {
            return package$.MODULE$.Right().apply((Object)this.partition().fetchOffsetForTimestamp(timestamp, isolation, Optional.of(Predef$.MODULE$.int2Integer(this.partition().getLeaderEpoch())), true));
        }
        catch (ApiException e) {
            return package$.MODULE$.Left().apply((Object)e);
        }
    }

    public static final /* synthetic */ Integer $anonfun$testMonotonicOffsetsAfterLeaderChange$2(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }

    public static final /* synthetic */ Integer $anonfun$testMonotonicOffsetsAfterLeaderChange$3(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }

    private final FileRecords.TimestampAndOffset fetchLatestOffset$1(Option isolationLevel) {
        Option res = this.partition().fetchOffsetForTimestamp(-1L, isolationLevel, Optional.empty(), true);
        Assertions.assertTrue((boolean)res.isDefined());
        return (FileRecords.TimestampAndOffset)res.get();
    }

    private final FileRecords.TimestampAndOffset fetchEarliestOffset$1(Option isolationLevel) {
        Option res = this.partition().fetchOffsetForTimestamp(-2L, isolationLevel, Optional.empty(), true);
        Assertions.assertTrue((boolean)res.isDefined());
        return (FileRecords.TimestampAndOffset)res.get();
    }

    private final void updateFollowerFetchState$2(int followerId, LogOffsetMetadata fetchOffsetMetadata) {
        this.partition().updateFollowerFetchState(followerId, fetchOffsetMetadata, 0L, this.time().milliseconds(), this.partition().localLogOrException().logEndOffset());
    }

    public static final /* synthetic */ Integer $anonfun$testIsrExpansion$1(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }

    public static final /* synthetic */ void $anonfun$testAlterIsrUnknownTopic$1(PartitionTest $this, int brokerId, int remoteBrokerId, Partition partition) {
        Assertions.assertEquals((Object)partition.partitionState().isr(), (Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{brokerId})));
        Assertions.assertEquals((Object)partition.partitionState().maximalIsr(), (Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{brokerId, remoteBrokerId})));
        Assertions.assertEquals((int)$this.alterIsrManager().isrUpdates().size(), (int)0);
    }

    public static final /* synthetic */ void $anonfun$testAlterIsrInvalidVersion$1(PartitionTest $this, int brokerId, int remoteBrokerId, Partition partition) {
        Assertions.assertEquals((Object)partition.partitionState().isr(), (Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{brokerId})));
        Assertions.assertEquals((Object)partition.partitionState().maximalIsr(), (Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{brokerId, remoteBrokerId})));
        Assertions.assertEquals((int)$this.alterIsrManager().isrUpdates().size(), (int)0);
    }

    public static final /* synthetic */ void $anonfun$testAlterIsrUnexpectedError$1(PartitionTest $this, int brokerId, int remoteBrokerId, Partition partition) {
        Assertions.assertEquals((Object)partition.partitionState().isr(), (Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{brokerId})));
        Assertions.assertEquals((Object)partition.partitionState().maximalIsr(), (Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{brokerId, remoteBrokerId})));
        Assertions.assertEquals((int)$this.alterIsrManager().isrUpdates().size(), (int)1);
    }

    public static final /* synthetic */ void $anonfun$testPartitionShouldRetryAlterPartitionRequest$2(ClientResponse alterPartitionResponseWithUnknownServerError$1, InvocationOnMock invocation) {
        ((ControllerRequestCompletionHandler)invocation.getArguments()[1]).onComplete(alterPartitionResponseWithUnknownServerError$1);
    }

    public static final /* synthetic */ void $anonfun$testPartitionShouldRetryAlterPartitionRequest$3(ClientResponse alterPartitionResponseWithoutError$1, InvocationOnMock invocation) {
        ((ControllerRequestCompletionHandler)invocation.getArguments()[1]).onComplete(alterPartitionResponseWithoutError$1);
    }

    public static final /* synthetic */ boolean $anonfun$testZkIsrManagerAsyncCallback$2(Partition partition$10) {
        return !partition$10.partitionState().isInflight();
    }

    public static final /* synthetic */ String $anonfun$testZkIsrManagerAsyncCallback$3() {
        return "Expected ISR state to be committed";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$testAddAndRemoveMetrics$1(String metric$1, Tuple2 x0$1) {
        if (x0$1 == null) throw new MatchError(null);
        MetricName metricName = (MetricName)x0$1._1();
        String string = metricName.getName();
        if (string == null) {
            if (metric$1 != null) {
                return false;
            }
        } else if (!string.equals(metric$1)) return false;
        String string2 = metricName.getType();
        String string3 = "Partition";
        if (string2 == null) return false;
        if (!string2.equals(string3)) return false;
        return true;
    }

    private static final Option getMetric$1(String metric) {
        return ((IterableOps)CollectionConverters$.MODULE$.MapHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)PartitionTest.$anonfun$testAddAndRemoveMetrics$1(metric, x0$1)))).headOption().map((Function1 & Serializable)x$3 -> (Metric)x$3._2());
    }

    public static final /* synthetic */ boolean $anonfun$testAddAndRemoveMetrics$3(String x$4) {
        return PartitionTest.getMetric$1(x$4).isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$testAddAndRemoveMetrics$4(MetricName x$5) {
        String string = x$5.getType();
        String string2 = "Partition";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ void $anonfun$testLogConfigDirtyAsTopicUpdated$1(PartitionTest $this, InvocationOnMock x$8) {
        $this.logManager().initializingLog($this.topicPartition());
        $this.logManager().topicConfigUpdated($this.topicPartition().topic());
    }

    public static final /* synthetic */ void $anonfun$testLogConfigDirtyAsBrokerUpdated$1(PartitionTest $this, InvocationOnMock x$9) {
        $this.logManager().initializingLog($this.topicPartition());
        $this.logManager().brokerConfigUpdated();
    }

    public static final /* synthetic */ Integer $anonfun$makeLeader$1(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }

    public static final /* synthetic */ Integer $anonfun$makeLeader$2(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ LogAppendInfo $anonfun$seedLogData$1(int leaderEpoch$2, UnifiedLog log$2, int i) {
        void withRecords_records;
        void withRecords_compressionType;
        MemoryRecords memoryRecords;
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord(new StringBuilder(1).append("k").append(i).toString().getBytes(), new StringBuilder(1).append("v").append(i).toString().getBytes())};
        CompressionType compressionType = CompressionType.NONE;
        long withRecords_initialOffset = 0L;
        MemoryRecords memoryRecords2 = memoryRecords = MemoryRecords.withRecords((byte)2, (long)withRecords_initialOffset, (CompressionType)withRecords_compressionType, (TimestampType)TimestampType.CREATE_TIME, (long)-1L, (short)-1, (int)-1, (int)leaderEpoch$2, (boolean)false, (SimpleRecord[])withRecords_records);
        compressionType = null;
        simpleRecordArray = null;
        memoryRecords = null;
        MemoryRecords records = memoryRecords2;
        return log$2.appendAsLeader(records, leaderEpoch$2, log$2.appendAsLeader$default$3(), log$2.appendAsLeader$default$4(), log$2.appendAsLeader$default$5());
    }

    public static final /* synthetic */ Integer $anonfun$testMonotonicOffsetsAfterLeaderChange$1$adapted(Object x) {
        return PartitionTest.$anonfun$testMonotonicOffsetsAfterLeaderChange$1(BoxesRunTime.unboxToInt((Object)x));
    }

    public static final /* synthetic */ Integer $anonfun$testMonotonicOffsetsAfterLeaderChange$2$adapted(Object x) {
        return PartitionTest.$anonfun$testMonotonicOffsetsAfterLeaderChange$2(BoxesRunTime.unboxToInt((Object)x));
    }

    public static final /* synthetic */ Integer $anonfun$testMonotonicOffsetsAfterLeaderChange$3$adapted(Object x) {
        return PartitionTest.$anonfun$testMonotonicOffsetsAfterLeaderChange$3(BoxesRunTime.unboxToInt((Object)x));
    }

    private class SlowLog
    extends UnifiedLog {
        private final Semaphore appendSemaphore;
        public final /* synthetic */ PartitionTest $outer;

        public LogAppendInfo appendAsFollower(MemoryRecords records) {
            this.appendSemaphore.acquire();
            return super.appendAsFollower(records);
        }

        public /* synthetic */ PartitionTest kafka$cluster$PartitionTest$SlowLog$$$outer() {
            return this.$outer;
        }

        public SlowLog(PartitionTest $outer, UnifiedLog log, long logStartOffset, LocalLog localLog, Option<LeaderEpochFileCache> leaderEpochCache, ProducerStateManager producerStateManager, Semaphore appendSemaphore) {
            this.appendSemaphore = appendSemaphore;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super(logStartOffset, localLog, new BrokerTopicStats(), log.producerIdExpirationCheckIntervalMs(), leaderEpochCache, producerStateManager, (Option)None$.MODULE$, true);
        }
    }
}

