/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.api.ApiVersion;
import kafka.api.ApiVersion$;
import kafka.api.LeaderAndIsr;
import kafka.cluster.Partition;
import kafka.log.AppendOrigin;
import kafka.log.CleanerConfig;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.server.AlterIsrManager;
import kafka.server.BrokerTopicStats;
import kafka.server.FetchPartitionData;
import kafka.server.HostedPartition;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.LogDirFailureChannel;
import kafka.server.MetadataCache;
import kafka.server.QuotaFactory;
import kafka.server.QuotaFactory$;
import kafka.server.ReplicaFetcherManager;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaManagerConcurrencyTest$AlterIsrEvent$;
import kafka.server.ReplicaManagerConcurrencyTest$InitializeEvent$;
import kafka.server.ReplicaManagerConcurrencyTest$ShutdownEvent$;
import kafka.server.ReplicaQuota;
import kafka.server.ReplicationQuotaManager;
import kafka.server.metadata.KRaftMetadataCache;
import kafka.server.metadata.MockConfigRepository;
import kafka.utils.MockScheduler;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.ShutdownableThread;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.IsolationLevel;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metadata.PartitionChangeRecord;
import org.apache.kafka.common.metadata.PartitionRecord;
import org.apache.kafka.common.metadata.TopicRecord;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.replica.ClientMetadata;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.metadata.LeaderRecoveryState;
import org.apache.kafka.metadata.PartitionRegistration;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0005\u0011]haBA\u000e\u0003;\u0001\u0011q\u0005\u0005\b\u0003k\u0001A\u0011AA\u001c\u0011%\ti\u0004\u0001b\u0001\n\u0013\ty\u0004\u0003\u0005\u0002N\u0001\u0001\u000b\u0011BA!\u0011%\ty\u0005\u0001b\u0001\n\u0013\t\t\u0006\u0003\u0005\u0002l\u0001\u0001\u000b\u0011BA*\u0011%\ti\u0007\u0001b\u0001\n\u0013\ty\u0007\u0003\u0005\u0002\u0006\u0002\u0001\u000b\u0011BA9\u0011%\t9\t\u0001b\u0001\n\u0013\tI\t\u0003\u0005\u0002\"\u0002\u0001\u000b\u0011BAF\u0011\u001d\t\u0019\u000b\u0001C\u0005\u0003KCq!!-\u0001\t\u0003\t\u0019\fC\u0004\u0002L\u0002!\t!a-\u0007\r\u0005U\u0007\u0001BAl\u0011)\ti$\u0004B\u0001B\u0003%\u0011\u0011\t\u0005\b\u0003kiA\u0011AAm\u0011\u001d\t\t/\u0004C!\u0003gCq!a9\u0001\t\u0013\t)O\u0002\u0004\u0004\u001a\u0001!11\u0004\u0005\r\u0007;\u0011\"\u0011!Q\u0001\n\r}1Q\u0006\u0005\u000b\u0007c\u0011\"\u0011!Q\u0001\n\u0005E\bBCB\u001a%\t\u0005\t\u0015!\u0003\u00046!Q11\b\n\u0003\u0002\u0003\u0006I!a:\t\u000f\u0005U\"\u0003\"\u0001\u0004>!I1\u0011\n\nC\u0002\u0013%11\n\u0005\t\u0007/\u0012\u0002\u0015!\u0003\u0004N!I1\u0011\f\nC\u0002\u0013%11\f\u0005\t\u0007\u0007\u0013\u0002\u0015!\u0003\u0004^!I1Q\u0011\nA\u0002\u0013%1q\u0011\u0005\n\u0007\u001f\u0013\u0002\u0019!C\u0005\u0007#C\u0001b!&\u0013A\u0003&1\u0011\u0012\u0005\b\u0003C\u0014B\u0011IAZ\r\u0019\u00199\n\u0001\u0003\u0004\u001a\"a1Q\u0004\u0011\u0003\u0002\u0003\u0006Iaa\b\u0004.!Q!Q\n\u0011\u0003\u0002\u0003\u0006IA!\u0015\t\u0015\rm\u0002E!A!\u0002\u0013\t9\u000fC\u0004\u00026\u0001\"\taa'\t\u0013\r%\u0003E1A\u0005\n\r-\u0003\u0002CB,A\u0001\u0006Ia!\u0014\t\u0013\r\u0015\u0006\u00051A\u0005\n\t-\u0006\"CBTA\u0001\u0007I\u0011BBU\u0011!\u0019i\u000b\tQ!\n\u0005E\bbBAqA\u0011\u0005\u00131\u0017\u0005\u000f\u0007_\u0003\u0003\u0013aA\u0001\u0002\u0013%1\u0011WB\u0017\r%\u0011y\u0001\u0001I\u0001$C\u0011\tbB\u0004\u00044\u0002A\tI!<\u0007\u000f\t\u001d\b\u0001#!\u0003j\"9\u0011Q\u0007\u0018\u0005\u0002\t-\b\"\u0003BM]\u0005\u0005I\u0011\tBN\u0011%\u0011IKLA\u0001\n\u0003\u0011Y\u000bC\u0005\u0003.:\n\t\u0011\"\u0001\u0003p\"I!1\u0018\u0018\u0002\u0002\u0013\u0005#Q\u0018\u0005\n\u0005\u000ft\u0013\u0011!C\u0001\u0005gD\u0011B!7/\u0003\u0003%\tEa7\t\u0013\tug&!A\u0005B\t}waBB[\u0001!\u0005%Q \u0004\b\u0005o\u0004\u0001\u0012\u0011B}\u0011\u001d\t)\u0004\u000fC\u0001\u0005wD\u0011B!'9\u0003\u0003%\tEa'\t\u0013\t%\u0006(!A\u0005\u0002\t-\u0006\"\u0003BWq\u0005\u0005I\u0011\u0001B\u0000\u0011%\u0011Y\fOA\u0001\n\u0003\u0012i\fC\u0005\u0003Hb\n\t\u0011\"\u0001\u0004\u0004!I!\u0011\u001c\u001d\u0002\u0002\u0013\u0005#1\u001c\u0005\n\u0005;D\u0014\u0011!C!\u0005?4aA!\u0006\u0001\u0001\n]\u0001B\u0003B\u001c\u0003\nU\r\u0011\"\u0001\u0003:!Q!1J!\u0003\u0012\u0003\u0006IAa\u000f\t\u0015\t5\u0013I!f\u0001\n\u0003\u0011y\u0005\u0003\u0006\u0003Z\u0005\u0013\t\u0012)A\u0005\u0005#B!Ba\u0017B\u0005+\u0007I\u0011\u0001B/\u0011)\u0011y&\u0011B\tB\u0003%!\u0011\t\u0005\b\u0003k\tE\u0011\u0001B1\u0011%\u0011Y'QA\u0001\n\u0003\u0011i\u0007C\u0005\u0003v\u0005\u000b\n\u0011\"\u0001\u0003x!I!QR!\u0012\u0002\u0013\u0005!q\u0012\u0005\n\u0005'\u000b\u0015\u0013!C\u0001\u0005+C\u0011B!'B\u0003\u0003%\tEa'\t\u0013\t%\u0016)!A\u0005\u0002\t-\u0006\"\u0003BW\u0003\u0006\u0005I\u0011\u0001BX\u0011%\u0011Y,QA\u0001\n\u0003\u0012i\fC\u0005\u0003H\u0006\u000b\t\u0011\"\u0001\u0003J\"I!1[!\u0002\u0002\u0013\u0005#Q\u001b\u0005\n\u00053\f\u0015\u0011!C!\u00057D\u0011B!8B\u0003\u0003%\tEa8\t\u0013\t\u0005\u0018)!A\u0005B\t\rx!CB\\\u0001\u0005\u0005\t\u0012AB]\r%\u0011)\u0002AA\u0001\u0012\u0003\u0019Y\fC\u0004\u00026]#\taa5\t\u0013\tuw+!A\u0005F\t}\u0007\"CBk/\u0006\u0005I\u0011QBl\u0011%\u0019ynVA\u0001\n\u0003\u001b\tO\u0002\u0004\u0002~\u0002!\u0011q \u0005\b\u0003kaF\u0011\u0001B\u0001\u0011%\u0011\u0019\u0001\u0018b\u0001\n\u0013\u0011)\u0001\u0003\u0005\u0004\bq\u0003\u000b\u0011\u0002B\u0004\u0011\u001d\u0019I\u0001\u0018C\u0001\u0007\u0017Aqa!\u0004]\t\u0003\u0019y\u0001C\u0004\u0004\u0016q#\t!a-\t\u000f\r]A\f\"\u0001\u00024\u001a111\u001f\u0001\u0005\u0007kD!ba>e\u0005\u0003\u0005\u000b\u0011BB}\u0011)\tI\u0010\u001aB\u0001B\u0003%\u00111 \u0005\u000b\u0007w!'\u0011!Q\u0001\n\u0005\u001d\bbBA\u001bI\u0012\u0005A1\u0013\u0005\n\t;#\u0007\u0019!C\u0005\t?C\u0011\u0002b*e\u0001\u0004%I\u0001\"+\t\u0011\u00115F\r)Q\u0005\tCCqa!\u0006e\t\u0003\t\u0019\fC\u0004\u0004\u0018\u0011$\t%a-\t\u000f\u0005\u0005H\r\"\u0011\u00024\u001a111 \u0001\u0005\u0007{D!ba@p\u0005\u000b\u0007I\u0011\u0001C\u0001\u0011)!Ia\u001cB\u0001B\u0003%A1\u0001\u0005\u000b\u0007_y'Q1A\u0005\u0002\rE\u0006B\u0003C\u0006_\n\u0005\t\u0015!\u0003\u0004 !QAQB8\u0003\u0002\u0003\u0006I\u0001b\u0004\t\u000f\u0005Ur\u000e\"\u0001\u0005\"!IA\u0011F8C\u0002\u0013%A1\u0006\u0005\t\t\u000b{\u0007\u0015!\u0003\u0005.!91QC8\u0005\u0002\u0011\u001d\u0005bBB\u0007_\u0012\u0005A1\u0012\u0004\u0007\tc\u0001A\u0001b\r\t\u0015\r](P!b\u0001\n\u0003!)\u0004\u0003\u0006\u00058i\u0014\t\u0011)A\u0005\u0007sD!\u0002\"\u000f{\u0005\u000b\u0007I\u0011\u0001BV\u0011)!YD\u001fB\u0001B\u0003%\u0011\u0011\u001f\u0005\u000b\t{Q(\u00111A\u0005\u0002\u0011}\u0002B\u0003C!u\n\u0005\r\u0011\"\u0001\u0005D!QAq\t>\u0003\u0002\u0003\u0006K\u0001\"\u0006\t\u000f\u0005U\"\u0010\"\u0001\u0005J!91Q\u0002>\u0005\u0002\u0011E\u0003b\u0002C3u\u0012%Aq\r\u0005\b\u0007+QH\u0011\u0001CA\r\u0019!y\u000b\u0001\u0003\u00052\"Y\u0011\u0011`A\u0007\u0005\u0003\u0005\u000b\u0011BA~\u0011!\t)$!\u0004\u0005\u0002\u0011e\u0006\u0002CAR\u0003\u001b!\t\u0005b0\t\u000f\u0011u\u0002\u0001\"\u0003\u0005J\"IAq\u001e\u0001\u0012\u0002\u0013%A\u0011\u001f\u0005\n\tk\u0004\u0011\u0013!C\u0005\tc\u0014QDU3qY&\u001c\u0017-T1oC\u001e,'oQ8oGV\u0014(/\u001a8dsR+7\u000f\u001e\u0006\u0005\u0003?\t\t#\u0001\u0004tKJ4XM\u001d\u0006\u0003\u0003G\tQa[1gW\u0006\u001c\u0001aE\u0002\u0001\u0003S\u0001B!a\u000b\u000225\u0011\u0011Q\u0006\u0006\u0003\u0003_\tQa]2bY\u0006LA!a\r\u0002.\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtDCAA\u001d!\r\tY\u0004A\u0007\u0003\u0003;\tA\u0001^5nKV\u0011\u0011\u0011\t\t\u0005\u0003\u0007\nI%\u0004\u0002\u0002F)!\u0011qIA\u0011\u0003\u0015)H/\u001b7t\u0013\u0011\tY%!\u0012\u0003\u00115{7m\u001b+j[\u0016\fQ\u0001^5nK\u0002\nq!\\3ue&\u001c7/\u0006\u0002\u0002TA!\u0011QKA4\u001b\t\t9F\u0003\u0003\u0002P\u0005e#\u0002BA.\u0003;\naaY8n[>t'\u0002BA\u0012\u0003?RA!!\u0019\u0002d\u00051\u0011\r]1dQ\u0016T!!!\u001a\u0002\u0007=\u0014x-\u0003\u0003\u0002j\u0005]#aB'fiJL7m]\u0001\t[\u0016$(/[2tA\u0005AQ\r_3dkR|'/\u0006\u0002\u0002rA!\u00111OAA\u001b\t\t)H\u0003\u0003\u0002x\u0005e\u0014AC2p]\u000e,(O]3oi*!\u00111PA?\u0003\u0011)H/\u001b7\u000b\u0005\u0005}\u0014\u0001\u00026bm\u0006LA!a!\u0002v\tA2k\u00195fIVdW\rZ#yK\u000e,Ho\u001c:TKJ4\u0018nY3\u0002\u0013\u0015DXmY;u_J\u0004\u0013!\u0002;bg.\u001cXCAAF!\u0019\ti)a&\u0002\u001c6\u0011\u0011q\u0012\u0006\u0005\u0003#\u000b\u0019*A\u0004nkR\f'\r\\3\u000b\t\u0005U\u0015QF\u0001\u000bG>dG.Z2uS>t\u0017\u0002BAM\u0003\u001f\u0013aAQ;gM\u0016\u0014\b\u0003BA\"\u0003;KA!a(\u0002F\t\u00112\u000b[;uI><h.\u00192mKRC'/Z1e\u0003\u0019!\u0018m]6tA\u000511/\u001e2nSR$B!a*\u0002.B!\u00111FAU\u0013\u0011\tY+!\f\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003_S\u0001\u0019AAN\u0003\u0011!\u0018m]6\u0002\u000f\rdW-\u00198vaR\u0011\u0011q\u0015\u0015\u0004\u0017\u0005]\u0006\u0003BA]\u0003\u000fl!!a/\u000b\t\u0005u\u0016qX\u0001\u0004CBL'\u0002BAa\u0003\u0007\fqA[;qSR,'O\u0003\u0003\u0002F\u0006\r\u0014!\u00026v]&$\u0018\u0002BAe\u0003w\u0013\u0011\"\u00114uKJ,\u0015m\u00195\u0002WQ,7\u000f^%te\u0016C\b/\u00198e\u0003:$7\u000b\u001b:j].<\u0016\u000e\u001e5D_:\u001cWO\u001d:f]R\u0004&o\u001c3vG\u0016D3\u0001DAh!\u0011\tI,!5\n\t\u0005M\u00171\u0018\u0002\u0005)\u0016\u001cHOA\u0003DY>\u001c7nE\u0002\u000e\u00037#B!a7\u0002`B\u0019\u0011Q\\\u0007\u000e\u0003\u0001Aq!!\u0010\u0010\u0001\u0004\t\t%\u0001\u0004e_^{'o[\u0001\u0014EVLG\u000e\u001a*fa2L7-Y'b]\u0006<WM\u001d\u000b\u0007\u0003O\fi/a>\u0011\t\u0005m\u0012\u0011^\u0005\u0005\u0003W\fiB\u0001\bSKBd\u0017nY1NC:\fw-\u001a:\t\u000f\u0005=\u0018\u00031\u0001\u0002r\u00069An\\2bY&#\u0007\u0003BA\u0016\u0003gLA!!>\u0002.\t\u0019\u0011J\u001c;\t\u000f\u0005e\u0018\u00031\u0001\u0002|\u000691\r[1o]\u0016d\u0007cAAo9\n\t2i\u001c8ue>dG.\u001a:DQ\u0006tg.\u001a7\u0014\u0007q\u000bI\u0003\u0006\u0002\u0002|\u0006QQM^3oiF+X-^3\u0016\u0005\t\u001d\u0001CBA:\u0005\u0013\u0011i!\u0003\u0003\u0003\f\u0005U$a\u0005'j].,GM\u00117pG.LgnZ)vKV,\u0007cAAoY\ty1i\u001c8ue>dG.\u001a:Fm\u0016tGoE\u0002-\u0003SIC\u0001L!/q\ti\u0011\t\u001c;fe&\u001b(/\u0012<f]R\u001c\u0012\"QA\u0015\u0005\u001b\u0011IBa\b\u0011\t\u0005-\"1D\u0005\u0005\u0005;\tiCA\u0004Qe>$Wo\u0019;\u0011\t\t\u0005\"\u0011\u0007\b\u0005\u0005G\u0011iC\u0004\u0003\u0003&\t-RB\u0001B\u0014\u0015\u0011\u0011I#!\n\u0002\rq\u0012xn\u001c;?\u0013\t\ty#\u0003\u0003\u00030\u00055\u0012a\u00029bG.\fw-Z\u0005\u0005\u0005g\u0011)D\u0001\u0007TKJL\u0017\r\\5{C\ndWM\u0003\u0003\u00030\u00055\u0012A\u00024viV\u0014X-\u0006\u0002\u0003<A1\u00111\u000fB\u001f\u0005\u0003JAAa\u0010\u0002v\t\t2i\\7qY\u0016$\u0018M\u00197f\rV$XO]3\u0011\t\t\r#qI\u0007\u0003\u0005\u000bRA!!0\u0002\"%!!\u0011\nB#\u00051aU-\u00193fe\u0006sG-S:s\u0003\u001d1W\u000f^;sK\u0002\na\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g.\u0006\u0002\u0003RA!!1\u000bB+\u001b\t\tI&\u0003\u0003\u0003X\u0005e#A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\\\u0001\u0010i>\u0004\u0018n\u0019)beRLG/[8oA\u0005aA.Z1eKJ\fe\u000eZ%teV\u0011!\u0011I\u0001\u000eY\u0016\fG-\u001a:B]\u0012L5O\u001d\u0011\u0015\u0011\t\r$Q\rB4\u0005S\u00022!!8B\u0011\u001d\u00119\u0004\u0013a\u0001\u0005wAqA!\u0014I\u0001\u0004\u0011\t\u0006C\u0004\u0003\\!\u0003\rA!\u0011\u0002\t\r|\u0007/\u001f\u000b\t\u0005G\u0012yG!\u001d\u0003t!I!qG%\u0011\u0002\u0003\u0007!1\b\u0005\n\u0005\u001bJ\u0005\u0013!a\u0001\u0005#B\u0011Ba\u0017J!\u0003\u0005\rA!\u0011\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011!\u0011\u0010\u0016\u0005\u0005w\u0011Yh\u000b\u0002\u0003~A!!q\u0010BE\u001b\t\u0011\tI\u0003\u0003\u0003\u0004\n\u0015\u0015!C;oG\",7m[3e\u0015\u0011\u00119)!\f\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003\f\n\u0005%!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TC\u0001BIU\u0011\u0011\tFa\u001f\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%gU\u0011!q\u0013\u0016\u0005\u0005\u0003\u0012Y(A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0005;\u0003BAa(\u0003&6\u0011!\u0011\u0015\u0006\u0005\u0005G\u000bi(\u0001\u0003mC:<\u0017\u0002\u0002BT\u0005C\u0013aa\u0015;sS:<\u0017\u0001\u00049s_\u0012,8\r^!sSRLXCAAy\u00039\u0001(o\u001c3vGR,E.Z7f]R$BA!-\u00038B!\u00111\u0006BZ\u0013\u0011\u0011),!\f\u0003\u0007\u0005s\u0017\u0010C\u0005\u0003:>\u000b\t\u00111\u0001\u0002r\u0006\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"Aa0\u0011\r\t\u0005'1\u0019BY\u001b\t\t\u0019*\u0003\u0003\u0003F\u0006M%\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$BAa3\u0003RB!\u00111\u0006Bg\u0013\u0011\u0011y-!\f\u0003\u000f\t{w\u000e\\3b]\"I!\u0011X)\u0002\u0002\u0003\u0007!\u0011W\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u0003\u001e\n]\u0007\"\u0003B]%\u0006\u0005\t\u0019AAy\u0003!A\u0017m\u001d5D_\u0012,GCAAy\u0003!!xn\u0015;sS:<GC\u0001BO\u0003\u0019)\u0017/^1mgR!!1\u001aBs\u0011%\u0011I,VA\u0001\u0002\u0004\u0011\tLA\bJ]&$\u0018.\u00197ju\u0016,e/\u001a8u'%q\u0013\u0011\u0006B\u0007\u00053\u0011y\u0002\u0006\u0002\u0003nB\u0019\u0011Q\u001c\u0018\u0015\t\tE&\u0011\u001f\u0005\n\u0005s\u0013\u0014\u0011!a\u0001\u0003c$BAa3\u0003v\"I!\u0011\u0018\u001b\u0002\u0002\u0003\u0007!\u0011\u0017\u0002\u000e'\",H\u000fZ8x]\u00163XM\u001c;\u0014\u0013a\nIC!\u0004\u0003\u001a\t}AC\u0001B\u007f!\r\ti\u000e\u000f\u000b\u0005\u0005c\u001b\t\u0001C\u0005\u0003:r\n\t\u00111\u0001\u0002rR!!1ZB\u0003\u0011%\u0011ILPA\u0001\u0002\u0004\u0011\t,A\u0006fm\u0016tG/U;fk\u0016\u0004\u0013\u0001\u00029pY2$\"A!\u0004\u0002\u0011\u0005dG/\u001a:JgJ$bAa\u000f\u0004\u0012\rM\u0001b\u0002B'C\u0002\u0007!\u0011\u000b\u0005\b\u00057\n\u0007\u0019\u0001B!\u0003)Ig.\u001b;jC2L'0Z\u0001\tg\",H\u000fZ8x]\naa)\u001a;dQ\u0016\u0014Xj\u001c3fYN\u0019!#a'\u0002\u0011\rd\u0017.\u001a8u\u0013\u0012\u0004Ba!\t\u0004*9!11EB\u0013!\u0011\u0011)#!\f\n\t\r\u001d\u0012QF\u0001\u0007!J,G-\u001a4\n\t\t\u001d61\u0006\u0006\u0005\u0007O\ti#\u0003\u0003\u00040\u0005u\u0015\u0001\u00028b[\u0016\f\u0011B]3qY&\u001c\u0017-\u00133\u0002!Q|\u0007/[2JIB\u000b'\u000f^5uS>t\u0007\u0003\u0002B*\u0007oIAa!\u000f\u0002Z\t\u0001Bk\u001c9jG&#\u0007+\u0019:uSRLwN\\\u0001\u000fe\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s))\u0019yd!\u0011\u0004D\r\u00153q\t\t\u0004\u0003;\u0014\u0002bBB\u000f/\u0001\u00071q\u0004\u0005\b\u0007c9\u0002\u0019AAy\u0011\u001d\u0019\u0019d\u0006a\u0001\u0007kAqaa\u000f\u0018\u0001\u0004\t9/\u0001\u0004sC:$w.\\\u000b\u0003\u0007\u001b\u0002Baa\u0014\u0004T5\u00111\u0011\u000b\u0006\u0005\u0003w\ni#\u0003\u0003\u0004V\rE#A\u0002*b]\u0012|W.A\u0004sC:$w.\u001c\u0011\u0002\u001d\rd\u0017.\u001a8u\u001b\u0016$\u0018\rZ1uCV\u00111Q\f\t\u0005\u0007?\u001aiH\u0004\u0003\u0004b\r]d\u0002BB2\u0007grAa!\u001a\u0004r9!1qMB8\u001d\u0011\u0019Ig!\u001c\u000f\t\t\u001521N\u0005\u0003\u0003KJA!!\u0019\u0002d%!\u00111EA0\u0013\u0011\tY&!\u0018\n\t\rU\u0014\u0011L\u0001\be\u0016\u0004H.[2b\u0013\u0011\u0019Iha\u001f\u0002\u001d\rc\u0017.\u001a8u\u001b\u0016$\u0018\rZ1uC*!1QOA-\u0013\u0011\u0019yh!!\u0003+\u0011+g-Y;mi\u000ec\u0017.\u001a8u\u001b\u0016$\u0018\rZ1uC*!1\u0011PB>\u0003=\u0019G.[3oi6+G/\u00193bi\u0006\u0004\u0013a\u00034fi\u000eDwJ\u001a4tKR,\"a!#\u0011\t\u0005-21R\u0005\u0005\u0007\u001b\u000biC\u0001\u0003M_:<\u0017a\u00044fi\u000eDwJ\u001a4tKR|F%Z9\u0015\t\u0005\u001d61\u0013\u0005\n\u0005sk\u0012\u0011!a\u0001\u0007\u0013\u000bABZ3uG\"|eMZ:fi\u0002\u0012Q\u0002\u0015:pIV\u001cWM]'pI\u0016d7c\u0001\u0011\u0002\u001cRA1QTBP\u0007C\u001b\u0019\u000bE\u0002\u0002^\u0002Bqa!\b%\u0001\u0004\u0019y\u0002C\u0004\u0003N\u0011\u0002\rA!\u0015\t\u000f\rmB\u00051\u0001\u0002h\u0006A1/Z9vK:\u001cW-\u0001\u0007tKF,XM\\2f?\u0012*\u0017\u000f\u0006\u0003\u0002(\u000e-\u0006\"\u0003B]Q\u0005\u0005\t\u0019AAy\u0003%\u0019X-];f]\u000e,\u0007%\u0001\u0006tkB,'\u000f\n8b[\u0016,\"aa\b\u0002\u001f%s\u0017\u000e^5bY&TX-\u0012<f]R\fQb\u00155vi\u0012|wO\\#wK:$\u0018!D!mi\u0016\u0014\u0018j\u001d:Fm\u0016tG\u000fE\u0002\u0002^^\u001bRaVB_\u0007\u0013\u0004Bba0\u0004F\nm\"\u0011\u000bB!\u0005Gj!a!1\u000b\t\r\r\u0017QF\u0001\beVtG/[7f\u0013\u0011\u00199m!1\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t7\u0007\u0005\u0003\u0004L\u000eEWBABg\u0015\u0011\u0019y-! \u0002\u0005%|\u0017\u0002\u0002B\u001a\u0007\u001b$\"a!/\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0011\t\r4\u0011\\Bn\u0007;DqAa\u000e[\u0001\u0004\u0011Y\u0004C\u0004\u0003Ni\u0003\rA!\u0015\t\u000f\tm#\f1\u0001\u0003B\u00059QO\\1qa2LH\u0003BBr\u0007_\u0004b!a\u000b\u0004f\u000e%\u0018\u0002BBt\u0003[\u0011aa\u00149uS>t\u0007CCA\u0016\u0007W\u0014YD!\u0015\u0003B%!1Q^A\u0017\u0005\u0019!V\u000f\u001d7fg!I1\u0011_.\u0002\u0002\u0003\u0007!1M\u0001\u0004q\u0012\u0002$aD\"p]R\u0014x\u000e\u001c7fe6{G-\u001a7\u0014\u0007\u0011\fY*A\u0003u_BL7\rE\u0002\u0002^>\u0014!\u0002V8qS\u000elu\u000eZ3m'\ry\u0017\u0011F\u0001\bi>\u0004\u0018nY%e+\t!\u0019\u0001\u0005\u0003\u0003T\u0011\u0015\u0011\u0002\u0002C\u0004\u00033\u0012A!V;jI\u0006AAo\u001c9jG&#\u0007%A\u0003oC6,\u0007%\u0001\u000bj]&$\u0018.\u00197SK\u001eL7\u000f\u001e:bi&|gn\u001d\t\t\u0007C!\t\"!=\u0005\u0016%!A1CB\u0016\u0005\ri\u0015\r\u001d\t\u0005\t/!i\"\u0004\u0002\u0005\u001a)!A1DA/\u0003!iW\r^1eCR\f\u0017\u0002\u0002C\u0010\t3\u0011Q\u0003U1si&$\u0018n\u001c8SK\u001eL7\u000f\u001e:bi&|g\u000e\u0006\u0005\u0004z\u0012\rBQ\u0005C\u0014\u0011\u001d\u0019y0\u001ea\u0001\t\u0007Aqaa\fv\u0001\u0004\u0019y\u0002C\u0004\u0005\u000eU\u0004\r\u0001b\u0004\u0002\u0015A\f'\u000f^5uS>t7/\u0006\u0002\u0005.AA1\u0011\u0005C\t\u0003c$y\u0003E\u0002\u0002^j\u0014a\u0002U1si&$\u0018n\u001c8N_\u0012,GnE\u0002{\u0003S)\"a!?\u0002\rQ|\u0007/[2!\u0003-\u0001\u0018M\u001d;ji&|g.\u00133\u0002\u0019A\f'\u000f^5uS>t\u0017\n\u001a\u0011\u0002\u0019I,w-[:ue\u0006$\u0018n\u001c8\u0016\u0005\u0011U\u0011\u0001\u0005:fO&\u001cHO]1uS>tw\fJ3r)\u0011\t9\u000b\"\u0012\t\u0015\te\u0016\u0011AA\u0001\u0002\u0004!)\"A\u0007sK\u001eL7\u000f\u001e:bi&|g\u000e\t\u000b\t\t_!Y\u0005\"\u0014\u0005P!A1q_A\u0003\u0001\u0004\u0019I\u0010\u0003\u0005\u0005:\u0005\u0015\u0001\u0019AAy\u0011!!i$!\u0002A\u0002\u0011UAC\u0002B!\t'\")\u0006\u0003\u0005\u0003\\\u0005\u001d\u0001\u0019\u0001B!\u0011!!9&a\u0002A\u0002\u0011e\u0013!\u00023fYR\f\u0007\u0003\u0002C.\tCj!\u0001\"\u0018\u000b\t\u0011}\u0013QL\u0001\u0006S6\fw-Z\u0005\u0005\tG\"iFA\u0007NKR\fG-\u0019;b\t\u0016dG/Y\u0001\u0007i>d\u0015n\u001d;\u0015\t\u0011%Dq\u000f\t\u0007\tW\"i\u0007\"\u001d\u000e\u0005\u0005e\u0014\u0002\u0002C8\u0003s\u0012A\u0001T5tiB!!q\u0014C:\u0013\u0011!)H!)\u0003\u000f%sG/Z4fe\"AA\u0011PA\u0005\u0001\u0004!Y(\u0001\u0003j]R\u001c\bCBA\u0016\t{\n\t0\u0003\u0003\u0005\u0000\u00055\"!B!se\u0006LH\u0003BAT\t\u0007C\u0001\u0002b\u0016\u0002\f\u0001\u0007A\u0011L\u0001\fa\u0006\u0014H/\u001b;j_:\u001c\b\u0005\u0006\u0003\u0002(\u0012%\u0005b\u0002C,q\u0002\u0007A\u0011\f\u000b\t\u0005\u0003\"i\tb$\u0005\u0012\"9!QJ=A\u0002\tE\u0003b\u0002B.s\u0002\u0007!\u0011\t\u0005\b\t/J\b\u0019\u0001C-)!!)\nb&\u0005\u001a\u0012m\u0005cAAoI\"91q\u001f5A\u0002\re\bbBA}Q\u0002\u0007\u00111 \u0005\b\u0007wA\u0007\u0019AAt\u0003-a\u0017\r^3ti&k\u0017mZ3\u0016\u0005\u0011\u0005\u0006\u0003\u0002C.\tGKA\u0001\"*\u0005^\tiQ*\u001a;bI\u0006$\u0018-S7bO\u0016\fq\u0002\\1uKN$\u0018*\\1hK~#S-\u001d\u000b\u0005\u0003O#Y\u000bC\u0005\u0003:*\f\t\u00111\u0001\u0005\"\u0006aA.\u0019;fgRLU.Y4fA\t\u0019Rj\\2l\u00032$XM]%te6\u000bg.Y4feN1\u0011QBA\u0015\tg\u0003B!a\u000f\u00056&!AqWA\u000f\u0005=\tE\u000e^3s\u0013N\u0014X*\u00198bO\u0016\u0014H\u0003\u0002C^\t{\u0003B!!8\u0002\u000e!A\u0011\u0011`A\t\u0001\u0004\tY\u0010\u0006\u0005\u0003<\u0011\u0005G1\u0019Cc\u0011!\u0011i%a\u0005A\u0002\tE\u0003\u0002\u0003B.\u0003'\u0001\rA!\u0011\t\u0011\u0011\u001d\u00171\u0003a\u0001\u0003c\fqbY8oiJ|G\u000e\\3s\u000bB|7\r\u001b\u000b\u000f\t+!Y\r\"6\u0005Z\u0012uGq\u001dCv\u0011!!i-!\u0006A\u0002\u0011=\u0017A\u0003:fa2L7-Y%egB1!\u0011\u0005Ci\u0003cLA\u0001b5\u00036\t\u00191+Z9\t\u0011\u0011]\u0017Q\u0003a\u0001\t\u001f\f1![:s\u0011!!Y.!\u0006A\u0002\u0005E\u0018A\u00027fC\u0012,'\u000f\u0003\u0005\u0005`\u0006U\u0001\u0019\u0001Cq\u0003MaW-\u00193feJ+7m\u001c<fef\u001cF/\u0019;f!\u0011!9\u0002b9\n\t\u0011\u0015H\u0011\u0004\u0002\u0014\u0019\u0016\fG-\u001a:SK\u000e|g/\u001a:z'R\fG/\u001a\u0005\u000b\tS\f)\u0002%AA\u0002\u0005E\u0018a\u00037fC\u0012,'/\u00129pG\"D!\u0002\"<\u0002\u0016A\u0005\t\u0019AAy\u00039\u0001\u0018M\u001d;ji&|g.\u00129pG\"\faC]3hSN$(/\u0019;j_:$C-\u001a4bk2$H%N\u000b\u0003\tgTC!!=\u0003|\u00051\"/Z4jgR\u0014\u0018\r^5p]\u0012\"WMZ1vYR$c\u0007")
public class ReplicaManagerConcurrencyTest {
    private volatile ReplicaManagerConcurrencyTest$InitializeEvent$ InitializeEvent$module;
    private volatile ReplicaManagerConcurrencyTest$ShutdownEvent$ ShutdownEvent$module;
    private volatile ReplicaManagerConcurrencyTest$AlterIsrEvent$ AlterIsrEvent$module;
    private final MockTime kafka$server$ReplicaManagerConcurrencyTest$$time = new MockTime();
    private final Metrics kafka$server$ReplicaManagerConcurrencyTest$$metrics = new Metrics();
    private final ScheduledExecutorService executor = Executors.newScheduledThreadPool(8);
    private final Buffer<ShutdownableThread> tasks = (Buffer)Buffer$.MODULE$.empty();

    public ReplicaManagerConcurrencyTest$InitializeEvent$ InitializeEvent() {
        if (this.InitializeEvent$module == null) {
            this.InitializeEvent$lzycompute$1();
        }
        return this.InitializeEvent$module;
    }

    public ReplicaManagerConcurrencyTest$ShutdownEvent$ ShutdownEvent() {
        if (this.ShutdownEvent$module == null) {
            this.ShutdownEvent$lzycompute$1();
        }
        return this.ShutdownEvent$module;
    }

    public ReplicaManagerConcurrencyTest$AlterIsrEvent$ AlterIsrEvent() {
        if (this.AlterIsrEvent$module == null) {
            this.AlterIsrEvent$lzycompute$1();
        }
        return this.AlterIsrEvent$module;
    }

    public MockTime kafka$server$ReplicaManagerConcurrencyTest$$time() {
        return this.kafka$server$ReplicaManagerConcurrencyTest$$time;
    }

    public Metrics kafka$server$ReplicaManagerConcurrencyTest$$metrics() {
        return this.kafka$server$ReplicaManagerConcurrencyTest$$metrics;
    }

    private ScheduledExecutorService executor() {
        return this.executor;
    }

    private Buffer<ShutdownableThread> tasks() {
        return this.tasks;
    }

    private void submit(ShutdownableThread task) {
        this.tasks().$plus$eq((Object)task);
        this.executor().submit((Runnable)task);
    }

    @AfterEach
    public void cleanup() {
        this.tasks().foreach((Function1 & Serializable)x$1 -> {
            x$1.shutdown();
            return BoxedUnit.UNIT;
        });
        this.executor().shutdownNow();
        this.executor().awaitTermination(5L, TimeUnit.SECONDS);
        this.kafka$server$ReplicaManagerConcurrencyTest$$metrics().close();
    }

    @Test
    public void testIsrExpandAndShrinkWithConcurrentProduce() {
        int localId = 0;
        int remoteId = 1;
        ControllerChannel channel = new ControllerChannel();
        ReplicaManager replicaManager = this.buildReplicaManager(localId, channel);
        PartitionRegistration initialPartitionRegistration = this.registration((scala.collection.immutable.Seq<Object>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{localId, remoteId}))), (scala.collection.immutable.Seq<Object>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{localId}))), localId, LeaderRecoveryState.RECOVERED, 0, 0);
        TopicModel topicModel = new TopicModel(this, Uuid.randomUuid(), "foo", (scala.collection.immutable.Map<Object, PartitionRegistration>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)initialPartitionRegistration)}))));
        TopicPartition topicPartition = new TopicPartition(topicModel.name(), 0);
        TopicIdPartition topicIdPartition = new TopicIdPartition(topicModel.topicId(), topicPartition);
        ControllerModel controller = new ControllerModel(this, topicModel, channel, replicaManager);
        this.submit(new Clock(this, this.kafka$server$ReplicaManagerConcurrencyTest$$time()));
        replicaManager.startup();
        this.submit(controller);
        controller.initialize();
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ReplicaManagerConcurrencyTest.$anonfun$testIsrExpandAndShrinkWithConcurrentProduce$1(replicaManager, topicPartition)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"Timed out waiting for partition to initialize");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
        Partition partition = replicaManager.getPartitionOrException(topicPartition);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> this.submit(new ProducerModel(this, new StringBuilder(9).append("producer-").append(i).toString(), topicPartition, replicaManager)));
        FetcherModel fetcher = new FetcherModel(this, new StringBuilder(8).append("replica-").append(remoteId).toString(), remoteId, topicIdPartition, replicaManager);
        this.submit(fetcher);
        long l3 = 15000L;
        long l4 = 100L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!ReplicaManagerConcurrencyTest.$anonfun$testIsrExpandAndShrinkWithConcurrentProduce$4(partition, localId, remoteId)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + l3) {
                Assertions.fail((String)"Test timed out before ISR was expanded");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l3), l4));
        }
        fetcher.shutdown();
        long l5 = 15000L;
        long l6 = 100L;
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!ReplicaManagerConcurrencyTest.$anonfun$testIsrExpandAndShrinkWithConcurrentProduce$6(partition, localId)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + l5) {
                Assertions.fail((String)"Test timed out before ISR was shrunk");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l5), l6));
        }
    }

    private ReplicaManager buildReplicaManager(int localId, ControllerChannel channel) {
        ApiVersion apiVersion;
        File file;
        File file2;
        File file3;
        File file4 = file3 = TestUtils.tempDirectory(null, null);
        file3 = null;
        File file5 = file2 = file4;
        file2 = null;
        File file6 = file = file5;
        file = null;
        File logDir = file6;
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.QuorumVotersProp(), "100@localhost:12345");
        props.put(KafkaConfig$.MODULE$.ProcessRolesProp(), "broker");
        props.put(KafkaConfig$.MODULE$.NodeIdProp(), Integer.toString(localId));
        props.put(KafkaConfig$.MODULE$.ControllerListenerNamesProp(), "SSL");
        props.put(KafkaConfig$.MODULE$.LogDirProp(), logDir.getAbsolutePath());
        props.put(KafkaConfig$.MODULE$.ReplicaLagTimeMaxMsProp(), Integer.toString(5000));
        KafkaConfig config = new KafkaConfig((java.util.Map)props, false);
        LogConfig x$1 = new LogConfig((java.util.Map)new Properties(), LogConfig$.MODULE$.$lessinit$greater$default$2());
        MockConfigRepository x$2 = new MockConfigRepository();
        scala.collection.immutable.Seq x$3 = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new File[]{logDir}));
        MockTime x$4 = this.kafka$server$ReplicaManagerConcurrencyTest$$time();
        CleanerConfig x$5 = TestUtils$.MODULE$.createLogManager$default$4();
        ApiVersion apiVersion2 = apiVersion = ApiVersion$.MODULE$.latestVersion();
        apiVersion = null;
        ApiVersion x$6 = apiVersion2;
        LogManager logManager = TestUtils$.MODULE$.createLogManager((Seq<File>)x$3, x$1, x$2, x$5, x$4, x$6);
        return new ReplicaManager(this, config, logManager, channel){

            public ReplicaFetcherManager createReplicaFetcherManager(Metrics metrics, Time time, Option<String> threadNamePrefix, ReplicationQuotaManager quotaManager) {
                return (ReplicaFetcherManager)Mockito.mock(ReplicaFetcherManager.class);
            }
            {
                None$ none$;
                None$ none$2;
                None$ none$3;
                None$ none$4;
                None$ none$5;
                None$ none$6;
                AtomicBoolean atomicBoolean;
                BrokerTopicStats brokerTopicStats;
                KRaftMetadataCache kRaftMetadataCache;
                Metrics x$1 = $outer.kafka$server$ReplicaManagerConcurrencyTest$$metrics();
                MockTime x$3 = $outer.kafka$server$ReplicaManagerConcurrencyTest$$time();
                MockScheduler x$4 = $outer.kafka$server$ReplicaManagerConcurrencyTest$$time().scheduler();
                QuotaFactory.QuotaManagers x$6 = QuotaFactory$.MODULE$.instantiate(config$1, $outer.kafka$server$ReplicaManagerConcurrencyTest$$metrics(), (Time)$outer.kafka$server$ReplicaManagerConcurrencyTest$$time(), "");
                int kRaftMetadataCache_brokerId = config$1.brokerId();
                KRaftMetadataCache kRaftMetadataCache2 = kRaftMetadataCache = new KRaftMetadataCache(kRaftMetadataCache_brokerId);
                kRaftMetadataCache = null;
                KRaftMetadataCache x$7 = kRaftMetadataCache2;
                LogDirFailureChannel x$8 = new LogDirFailureChannel(config$1.logDirs().size());
                MockAlterIsrManager x$9 = new MockAlterIsrManager($outer, channel$1);
                BrokerTopicStats brokerTopicStats2 = brokerTopicStats = new BrokerTopicStats();
                brokerTopicStats = null;
                BrokerTopicStats x$10 = brokerTopicStats2;
                AtomicBoolean atomicBoolean2 = atomicBoolean = new AtomicBoolean(false);
                atomicBoolean = null;
                AtomicBoolean x$11 = atomicBoolean2;
                None$ none$7 = none$6 = None$.MODULE$;
                none$6 = null;
                None$ x$12 = none$7;
                None$ none$8 = none$5 = None$.MODULE$;
                none$5 = null;
                None$ x$13 = none$8;
                None$ none$9 = none$4 = None$.MODULE$;
                none$4 = null;
                None$ x$14 = none$9;
                None$ none$10 = none$3 = None$.MODULE$;
                none$3 = null;
                None$ x$15 = none$10;
                None$ none$11 = none$2 = None$.MODULE$;
                none$2 = null;
                None$ x$16 = none$11;
                None$ none$12 = none$ = None$.MODULE$;
                none$ = null;
                None$ x$17 = none$12;
                super(config$1, x$1, (Time)x$3, (Scheduler)x$4, logManager$1, x$6, (MetadataCache)x$7, x$8, (AlterIsrManager)x$9, x$10, x$11, (Option)x$12, (Option)x$13, (Option)x$14, (Option)x$15, (Option)x$16, (Option)x$17);
            }
        };
    }

    private PartitionRegistration registration(scala.collection.immutable.Seq<Object> replicaIds, scala.collection.immutable.Seq<Object> isr, int leader, LeaderRecoveryState leaderRecoveryState, int leaderEpoch, int partitionEpoch) {
        return new PartitionRegistration((int[])replicaIds.toArray((ClassTag)ClassTag$.MODULE$.Int()), (int[])isr.toArray((ClassTag)ClassTag$.MODULE$.Int()), (int[])Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Int()), (int[])Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Int()), leader, leaderRecoveryState, leaderEpoch, partitionEpoch);
    }

    private int registration$default$5() {
        return 0;
    }

    private int registration$default$6() {
        return 0;
    }

    private final void InitializeEvent$lzycompute$1() {
        synchronized (this) {
            if (this.InitializeEvent$module == null) {
                this.InitializeEvent$module = new ReplicaManagerConcurrencyTest$InitializeEvent$(this);
            }
            return;
        }
    }

    private final void ShutdownEvent$lzycompute$1() {
        synchronized (this) {
            if (this.ShutdownEvent$module == null) {
                this.ShutdownEvent$module = new ReplicaManagerConcurrencyTest$ShutdownEvent$(this);
            }
            return;
        }
    }

    private final void AlterIsrEvent$lzycompute$1() {
        synchronized (this) {
            if (this.AlterIsrEvent$module == null) {
                this.AlterIsrEvent$module = new ReplicaManagerConcurrencyTest$AlterIsrEvent$(this);
            }
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$testIsrExpandAndShrinkWithConcurrentProduce$1(ReplicaManager replicaManager$1, TopicPartition topicPartition$1) {
        HostedPartition hostedPartition = replicaManager$1.getPartition(topicPartition$1);
        boolean bl = hostedPartition instanceof HostedPartition.Online ? ((HostedPartition.Online)hostedPartition).partition().isLeader() : false;
        return bl;
    }

    public static final /* synthetic */ String $anonfun$testIsrExpandAndShrinkWithConcurrentProduce$2() {
        return "Timed out waiting for partition to initialize";
    }

    public static final /* synthetic */ boolean $anonfun$testIsrExpandAndShrinkWithConcurrentProduce$4(Partition partition$1, int localId$1, int remoteId$1) {
        Set set = partition$1.inSyncReplicaIds();
        Object object = Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{localId$1, remoteId$1}));
        return !(set != null ? !set.equals(object) : object != null);
    }

    public static final /* synthetic */ String $anonfun$testIsrExpandAndShrinkWithConcurrentProduce$5() {
        return "Test timed out before ISR was expanded";
    }

    public static final /* synthetic */ boolean $anonfun$testIsrExpandAndShrinkWithConcurrentProduce$6(Partition partition$1, int localId$1) {
        Set set = partition$1.inSyncReplicaIds();
        Object object = Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{localId$1}));
        return !(set != null ? !set.equals(object) : object != null);
    }

    public static final /* synthetic */ String $anonfun$testIsrExpandAndShrinkWithConcurrentProduce$7() {
        return "Test timed out before ISR was shrunk";
    }

    public class AlterIsrEvent
    implements ControllerEvent,
    Product,
    Serializable {
        private final CompletableFuture<LeaderAndIsr> future;
        private final TopicPartition topicPartition;
        private final LeaderAndIsr leaderAndIsr;
        public final /* synthetic */ ReplicaManagerConcurrencyTest $outer;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public CompletableFuture<LeaderAndIsr> future() {
            return this.future;
        }

        public TopicPartition topicPartition() {
            return this.topicPartition;
        }

        public LeaderAndIsr leaderAndIsr() {
            return this.leaderAndIsr;
        }

        public AlterIsrEvent copy(CompletableFuture<LeaderAndIsr> future, TopicPartition topicPartition, LeaderAndIsr leaderAndIsr) {
            return new AlterIsrEvent(this.kafka$server$ReplicaManagerConcurrencyTest$AlterIsrEvent$$$outer(), future, topicPartition, leaderAndIsr);
        }

        public CompletableFuture<LeaderAndIsr> copy$default$1() {
            return this.future();
        }

        public TopicPartition copy$default$2() {
            return this.topicPartition();
        }

        public LeaderAndIsr copy$default$3() {
            return this.leaderAndIsr();
        }

        public String productPrefix() {
            return "AlterIsrEvent";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.future();
                }
                case 1: {
                    return this.topicPartition();
                }
                case 2: {
                    return this.leaderAndIsr();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof AlterIsrEvent;
        }

        public String productElementName(int x$1) {
            switch (x$1) {
                case 0: {
                    return "future";
                }
                case 1: {
                    return "topicPartition";
                }
                case 2: {
                    return "leaderAndIsr";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            if (!(x$1 instanceof AlterIsrEvent)) return false;
            if (((AlterIsrEvent)x$1).kafka$server$ReplicaManagerConcurrencyTest$AlterIsrEvent$$$outer() != this.kafka$server$ReplicaManagerConcurrencyTest$AlterIsrEvent$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            AlterIsrEvent alterIsrEvent = (AlterIsrEvent)x$1;
            CompletableFuture<LeaderAndIsr> completableFuture = this.future();
            CompletableFuture<LeaderAndIsr> completableFuture2 = alterIsrEvent.future();
            if (completableFuture == null) {
                if (completableFuture2 != null) {
                    return false;
                }
            } else if (!completableFuture.equals(completableFuture2)) return false;
            TopicPartition topicPartition = this.topicPartition();
            TopicPartition topicPartition2 = alterIsrEvent.topicPartition();
            if (topicPartition == null) {
                if (topicPartition2 != null) {
                    return false;
                }
            } else if (!topicPartition.equals(topicPartition2)) return false;
            LeaderAndIsr leaderAndIsr = this.leaderAndIsr();
            LeaderAndIsr leaderAndIsr2 = alterIsrEvent.leaderAndIsr();
            if (leaderAndIsr == null) {
                if (leaderAndIsr2 != null) {
                    return false;
                }
            } else if (!leaderAndIsr.equals(leaderAndIsr2)) return false;
            if (!alterIsrEvent.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ ReplicaManagerConcurrencyTest kafka$server$ReplicaManagerConcurrencyTest$AlterIsrEvent$$$outer() {
            return this.$outer;
        }

        public AlterIsrEvent(ReplicaManagerConcurrencyTest $outer, CompletableFuture<LeaderAndIsr> future, TopicPartition topicPartition, LeaderAndIsr leaderAndIsr) {
            this.future = future;
            this.topicPartition = topicPartition;
            this.leaderAndIsr = leaderAndIsr;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }

    private class Clock
    extends ShutdownableThread {
        private final MockTime time;
        public final /* synthetic */ ReplicaManagerConcurrencyTest $outer;

        public void doWork() {
            this.time.sleep(1L);
        }

        public /* synthetic */ ReplicaManagerConcurrencyTest kafka$server$ReplicaManagerConcurrencyTest$Clock$$$outer() {
            return this.$outer;
        }

        public Clock(ReplicaManagerConcurrencyTest $outer, MockTime time) {
            this.time = time;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super("clock", false);
        }
    }

    private class ControllerChannel {
        private final LinkedBlockingQueue<ControllerEvent> eventQueue;

        private LinkedBlockingQueue<ControllerEvent> eventQueue() {
            return this.eventQueue;
        }

        public ControllerEvent poll() {
            return this.eventQueue().take();
        }

        /*
         * WARNING - void declaration
         */
        public CompletableFuture<LeaderAndIsr> alterIsr(TopicPartition topicPartition, LeaderAndIsr leaderAndIsr) {
            void var3_3;
            CompletableFuture<LeaderAndIsr> future = new CompletableFuture<LeaderAndIsr>();
            this.eventQueue().offer(new AlterIsrEvent(this.kafka$server$ReplicaManagerConcurrencyTest$ControllerChannel$$$outer(), future, topicPartition, leaderAndIsr));
            return var3_3;
        }

        public void initialize() {
            this.eventQueue().offer(this.kafka$server$ReplicaManagerConcurrencyTest$ControllerChannel$$$outer().InitializeEvent());
        }

        public void shutdown() {
            this.eventQueue().offer(this.kafka$server$ReplicaManagerConcurrencyTest$ControllerChannel$$$outer().ShutdownEvent());
        }

        public /* synthetic */ ReplicaManagerConcurrencyTest kafka$server$ReplicaManagerConcurrencyTest$ControllerChannel$$$outer() {
            return ReplicaManagerConcurrencyTest.this;
        }

        public ControllerChannel() {
            if (ReplicaManagerConcurrencyTest.this == null) {
                throw null;
            }
            this.eventQueue = new LinkedBlockingQueue();
        }
    }

    public interface ControllerEvent {
    }

    private class ControllerModel
    extends ShutdownableThread {
        private final TopicModel topic;
        private final ControllerChannel channel;
        private final ReplicaManager replicaManager;
        private MetadataImage latestImage;
        public final /* synthetic */ ReplicaManagerConcurrencyTest $outer;

        private MetadataImage latestImage() {
            return this.latestImage;
        }

        private void latestImage_$eq(MetadataImage x$1) {
            this.latestImage = x$1;
        }

        public void initialize() {
            this.channel.initialize();
        }

        public void shutdown() {
            super.initiateShutdown();
            this.channel.shutdown();
            super.awaitShutdown();
        }

        public void doWork() {
            ControllerEvent controllerEvent = this.channel.poll();
            if (this.kafka$server$ReplicaManagerConcurrencyTest$ControllerModel$$$outer().InitializeEvent().equals(controllerEvent)) {
                MetadataDelta delta = new MetadataDelta(this.latestImage());
                this.topic.initialize(delta);
                this.latestImage_$eq(delta.apply());
                this.replicaManager.applyDelta(delta.topicsDelta(), this.latestImage());
                return;
            }
            if (controllerEvent instanceof AlterIsrEvent) {
                AlterIsrEvent alterIsrEvent = (AlterIsrEvent)controllerEvent;
                CompletableFuture<LeaderAndIsr> future = alterIsrEvent.future();
                TopicPartition topicPartition = alterIsrEvent.topicPartition();
                LeaderAndIsr leaderAndIsr = alterIsrEvent.leaderAndIsr();
                MetadataDelta delta = new MetadataDelta(this.latestImage());
                LeaderAndIsr updatedLeaderAndIsr = this.topic.alterIsr(topicPartition, leaderAndIsr, delta);
                this.latestImage_$eq(delta.apply());
                future.complete(updatedLeaderAndIsr);
                this.replicaManager.applyDelta(delta.topicsDelta(), this.latestImage());
                return;
            }
            if (this.kafka$server$ReplicaManagerConcurrencyTest$ControllerModel$$$outer().ShutdownEvent().equals(controllerEvent)) {
                return;
            }
            throw new MatchError((Object)controllerEvent);
        }

        public /* synthetic */ ReplicaManagerConcurrencyTest kafka$server$ReplicaManagerConcurrencyTest$ControllerModel$$$outer() {
            return this.$outer;
        }

        public ControllerModel(ReplicaManagerConcurrencyTest $outer, TopicModel topic, ControllerChannel channel, ReplicaManager replicaManager) {
            this.topic = topic;
            this.channel = channel;
            this.replicaManager = replicaManager;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super("controller", false);
            this.latestImage = MetadataImage.EMPTY;
        }
    }

    private class FetcherModel
    extends ShutdownableThread {
        private final int replicaId;
        private final TopicIdPartition topicIdPartition;
        private final ReplicaManager replicaManager;
        private final Random random;
        private final ClientMetadata.DefaultClientMetadata clientMetadata;
        private long fetchOffset;
        public final /* synthetic */ ReplicaManagerConcurrencyTest $outer;

        private Random random() {
            return this.random;
        }

        private ClientMetadata.DefaultClientMetadata clientMetadata() {
            return this.clientMetadata;
        }

        private long fetchOffset() {
            return this.fetchOffset;
        }

        private void fetchOffset_$eq(long x$1) {
            this.fetchOffset = x$1;
        }

        public void doWork() {
            FetchRequest.PartitionData partitionData = new FetchRequest.PartitionData(this.topicIdPartition.topicId(), this.fetchOffset(), -1L, 65536, Optional.empty(), Optional.empty());
            CompletableFuture future = new CompletableFuture();
            this.replicaManager.fetchMessages((long)this.random().nextInt(100), this.replicaId, 1, 0x100000, false, (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicIdPartition), (Object)partitionData)})), (ReplicaQuota)QuotaFactory.UnboundedQuota$.MODULE$, (Function1 & Serializable)results -> {
                this.fetchCallback$1(results, future);
                return BoxedUnit.UNIT;
            }, IsolationLevel.READ_UNCOMMITTED, (Option)new Some((Object)this.clientMetadata()));
            ((FetchPartitionData)future.get()).records().batches().forEach(batch -> this.fetchOffset_$eq(batch.lastOffset() + 1L));
        }

        public /* synthetic */ ReplicaManagerConcurrencyTest kafka$server$ReplicaManagerConcurrencyTest$FetcherModel$$$outer() {
            return this.$outer;
        }

        /*
         * WARNING - void declaration
         */
        private final void fetchCallback$1(Seq results, CompletableFuture future$1) {
            try {
                void var5_5;
                void var4_4;
                Assertions.assertEquals((int)1, (int)results.size());
                Tuple2 tuple2 = (Tuple2)results.head();
                if (tuple2 == null) {
                    throw new MatchError(null);
                }
                TopicIdPartition topicIdPartition = (TopicIdPartition)tuple2._1();
                FetchPartitionData result = (FetchPartitionData)tuple2._2();
                Assertions.assertEquals((Object)this.topicIdPartition, (Object)var4_4);
                Assertions.assertEquals((Object)Errors.NONE, (Object)var5_5.error());
                future$1.complete(var5_5);
                return;
            }
            catch (Throwable e) {
                future$1.completeExceptionally(e);
                return;
            }
        }

        public FetcherModel(ReplicaManagerConcurrencyTest $outer, String clientId, int replicaId, TopicIdPartition topicIdPartition, ReplicaManager replicaManager) {
            this.replicaId = replicaId;
            this.topicIdPartition = topicIdPartition;
            this.replicaManager = replicaManager;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super(clientId, false);
            this.random = new Random();
            this.clientMetadata = new ClientMetadata.DefaultClientMetadata("", super.name(), InetAddress.getLocalHost(), KafkaPrincipal.ANONYMOUS, "PLAINTEXT");
            this.fetchOffset = 0L;
        }
    }

    private class MockAlterIsrManager
    implements AlterIsrManager {
        private final ControllerChannel channel;
        public final /* synthetic */ ReplicaManagerConcurrencyTest $outer;

        public void start() {
            AlterIsrManager.start$((AlterIsrManager)this);
        }

        public void shutdown() {
            AlterIsrManager.shutdown$((AlterIsrManager)this);
        }

        public CompletableFuture<LeaderAndIsr> submit(TopicPartition topicPartition, LeaderAndIsr leaderAndIsr, int controllerEpoch) {
            return this.channel.alterIsr(topicPartition, leaderAndIsr);
        }

        public /* synthetic */ ReplicaManagerConcurrencyTest kafka$server$ReplicaManagerConcurrencyTest$MockAlterIsrManager$$$outer() {
            return this.$outer;
        }

        public MockAlterIsrManager(ReplicaManagerConcurrencyTest $outer, ControllerChannel channel) {
            this.channel = channel;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }

    private class PartitionModel {
        private final TopicModel topic;
        private final int partitionId;
        private PartitionRegistration registration;
        public final /* synthetic */ ReplicaManagerConcurrencyTest $outer;

        public TopicModel topic() {
            return this.topic;
        }

        public int partitionId() {
            return this.partitionId;
        }

        public PartitionRegistration registration() {
            return this.registration;
        }

        public void registration_$eq(PartitionRegistration x$1) {
            this.registration = x$1;
        }

        public LeaderAndIsr alterIsr(LeaderAndIsr leaderAndIsr, MetadataDelta delta) {
            delta.replay(new PartitionChangeRecord().setTopicId(this.topic().topicId()).setPartitionId(this.partitionId()).setIsr(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)leaderAndIsr.isr().map((Function1 & Serializable)x -> PartitionModel.$anonfun$alterIsr$2(BoxesRunTime.unboxToInt((Object)x)))).asJava()).setLeader(leaderAndIsr.leader()));
            this.registration_$eq((PartitionRegistration)delta.topicsDelta().changedTopic(this.topic().topicId()).partitionChanges().get(BoxesRunTime.boxToInteger((int)this.partitionId())));
            return leaderAndIsr.withZkVersion(this.registration().partitionEpoch);
        }

        private List<Integer> toList(int[] ints) {
            return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.intArrayOps(ints), (Function1 & Serializable)x -> PartitionModel.$anonfun$toList$1(BoxesRunTime.unboxToInt((Object)x)), ClassTag$.MODULE$.apply(Integer.class))).toList()).asJava();
        }

        public void initialize(MetadataDelta delta) {
            delta.replay(new PartitionRecord().setTopicId(this.topic().topicId()).setPartitionId(this.partitionId()).setReplicas(this.toList(this.registration().replicas)).setIsr(this.toList(this.registration().isr)).setLeader(this.registration().leader).setLeaderEpoch(this.registration().leaderEpoch).setPartitionEpoch(this.registration().partitionEpoch));
        }

        public /* synthetic */ ReplicaManagerConcurrencyTest kafka$server$ReplicaManagerConcurrencyTest$PartitionModel$$$outer() {
            return this.$outer;
        }

        public static final /* synthetic */ Integer $anonfun$alterIsr$2(int x) {
            return BoxesRunTime.boxToInteger((int)x);
        }

        public static final /* synthetic */ Integer $anonfun$toList$1(int x) {
            return BoxesRunTime.boxToInteger((int)x);
        }

        public PartitionModel(ReplicaManagerConcurrencyTest $outer, TopicModel topic, int partitionId, PartitionRegistration registration) {
            this.topic = topic;
            this.partitionId = partitionId;
            this.registration = registration;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }

    private class ProducerModel
    extends ShutdownableThread {
        private final TopicPartition topicPartition;
        private final ReplicaManager replicaManager;
        private final Random random;
        private int sequence;
        public final /* synthetic */ ReplicaManagerConcurrencyTest $outer;

        private /* synthetic */ String super$name() {
            return super.name();
        }

        private Random random() {
            return this.random;
        }

        private int sequence() {
            return this.sequence;
        }

        private void sequence_$eq(int x$1) {
            this.sequence = x$1;
        }

        public void doWork() {
            int numRecords = this.random().nextInt() % 10 + 1;
            IndexedSeq records = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numRecords).map((Function1 & Serializable)i -> ProducerModel.$anonfun$doWork$3(this, BoxesRunTime.unboxToInt((Object)i)));
            CompletableFuture future = new CompletableFuture();
            Object[] objectArray = new Tuple2[1];
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition), (Object)TestUtils$.MODULE$.records((Iterable<SimpleRecord>)records, (byte)2, CompressionType.NONE, -1L, (short)-1, -1, 0L, -1));
            this.replicaManager.appendRecords(30000L, (short)-1, false, (AppendOrigin)AppendOrigin.Client$.MODULE$, (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)), (Function1 & Serializable)results -> {
                this.produceCallback$1(results, future);
                return BoxedUnit.UNIT;
            }, this.replicaManager.appendRecords$default$7(), this.replicaManager.appendRecords$default$8(), this.replicaManager.appendRecords$default$9());
            future.get();
            this.sequence_$eq(this.sequence() + numRecords);
        }

        public /* synthetic */ ReplicaManagerConcurrencyTest kafka$server$ReplicaManagerConcurrencyTest$ProducerModel$$$outer() {
            return this.$outer;
        }

        public static final /* synthetic */ SimpleRecord $anonfun$doWork$3(ProducerModel $this, int i) {
            return new SimpleRecord(new StringBuilder(1).append($this.super$name()).append("-").append($this.sequence() + i).toString().getBytes());
        }

        /*
         * WARNING - void declaration
         */
        private final void produceCallback$1(Map results, CompletableFuture future$2) {
            try {
                void var5_5;
                void var4_4;
                Assertions.assertEquals((int)1, (int)results.size());
                Tuple2 tuple2 = (Tuple2)results.head();
                if (tuple2 == null) {
                    throw new MatchError(null);
                }
                TopicPartition topicPartition = (TopicPartition)tuple2._1();
                ProduceResponse.PartitionResponse result = (ProduceResponse.PartitionResponse)tuple2._2();
                Assertions.assertEquals((Object)this.topicPartition, (Object)var4_4);
                Assertions.assertEquals((Object)Errors.NONE, (Object)var5_5.error);
                future$2.complete(var5_5);
                return;
            }
            catch (Throwable e) {
                future$2.completeExceptionally(e);
                return;
            }
        }

        public ProducerModel(ReplicaManagerConcurrencyTest $outer, String clientId, TopicPartition topicPartition, ReplicaManager replicaManager) {
            this.topicPartition = topicPartition;
            this.replicaManager = replicaManager;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super(clientId, false);
            this.random = new Random();
            this.sequence = 0;
        }
    }

    private class TopicModel {
        private final Uuid topicId;
        private final String name;
        private final scala.collection.immutable.Map<Object, PartitionModel> partitions;
        public final /* synthetic */ ReplicaManagerConcurrencyTest $outer;

        public Uuid topicId() {
            return this.topicId;
        }

        public String name() {
            return this.name;
        }

        private scala.collection.immutable.Map<Object, PartitionModel> partitions() {
            return this.partitions;
        }

        public void initialize(MetadataDelta delta) {
            delta.replay(new TopicRecord().setName(this.name()).setTopicId(this.topicId()));
            this.partitions().values().foreach((Function1 & Serializable)x$4 -> {
                x$4.initialize(delta);
                return BoxedUnit.UNIT;
            });
        }

        public LeaderAndIsr alterIsr(TopicPartition topicPartition, LeaderAndIsr leaderAndIsr, MetadataDelta delta) {
            return ((PartitionModel)this.partitions().getOrElse((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition()), (Function0 & Serializable)() -> {
                throw new IllegalStateException(new StringBuilder(21).append("Unexpected partition ").append(topicPartition).toString());
            })).alterIsr(leaderAndIsr, delta);
        }

        public /* synthetic */ ReplicaManagerConcurrencyTest kafka$server$ReplicaManagerConcurrencyTest$TopicModel$$$outer() {
            return this.$outer;
        }

        public TopicModel(ReplicaManagerConcurrencyTest $outer, Uuid topicId, String name, scala.collection.immutable.Map<Object, PartitionRegistration> initialRegistrations) {
            this.topicId = topicId;
            this.name = name;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.partitions = (scala.collection.immutable.Map)initialRegistrations.map((Function1 & Serializable)x0$1 -> {
                if (x0$1 == null) {
                    throw new MatchError(null);
                }
                int partitionId = x0$1._1$mcI$sp();
                PartitionRegistration registration = (PartitionRegistration)x0$1._2();
                Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partitionId)), (Object)new PartitionModel(this.kafka$server$ReplicaManagerConcurrencyTest$TopicModel$$$outer(), this, partitionId, registration));
                return tuple2;
            });
        }
    }
}

