/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Properties;
import joptsimple.OptionException;
import kafka.admin.ConsumerGroupCommand;
import kafka.admin.ConsumerGroupCommandTest;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.MapOps;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\t5d\u0001\u0002\u001a4\u0001aBQ!\u0010\u0001\u0005\u0002yBq\u0001\u0011\u0001C\u0002\u0013\u0005\u0011\t\u0003\u0004K\u0001\u0001\u0006IA\u0011\u0005\b\u0017\u0002\u0011\r\u0011\"\u0001M\u0011\u0019\u0019\u0006\u0001)A\u0005\u001b\"9A\u000b\u0001b\u0001\n\u0003a\u0005BB+\u0001A\u0003%Q\nC\u0003W\u0001\u0011\u0005s\u000bC\u0003g\u0001\u0011%q\rC\u0003w\u0001\u0011%q\u000fC\u0004\u0002\u0002\u0001!I!a\u0001\t\u000f\u0005-\u0001\u0001\"\u0003\u0002\u000e!9\u0011\u0011\u0003\u0001\u0005\u0002\u0005M\u0001bBA\u001b\u0001\u0011\u0005\u00111\u0003\u0005\b\u0003s\u0001A\u0011AA\n\u0011\u001d\ti\u0004\u0001C\u0001\u0003'Aq!!\u0011\u0001\t\u0003\t\u0019\u0002C\u0004\u0002F\u0001!\t!a\u0005\t\u000f\u0005%\u0003\u0001\"\u0001\u0002\u0014!9\u0011Q\n\u0001\u0005\u0002\u0005M\u0001bBA)\u0001\u0011\u0005\u00111\u0003\u0005\b\u0003+\u0002A\u0011AA\n\u0011\u001d\tI\u0006\u0001C\u0001\u0003'Aq!!\u0018\u0001\t\u0003\t\u0019\u0002C\u0004\u0002b\u0001!\t!a\u0005\t\u000f\u0005\u0015\u0004\u0001\"\u0001\u0002\u0014!9\u0011\u0011\u000e\u0001\u0005\u0002\u0005M\u0001bBA7\u0001\u0011\u0005\u00111\u0003\u0005\b\u0003c\u0002A\u0011AA\n\u0011\u001d\t)\b\u0001C\u0001\u0003'Aq!!\u001f\u0001\t\u0003\t\u0019\u0002C\u0004\u0002~\u0001!\t!a\u0005\t\u000f\u0005\u0005\u0005\u0001\"\u0001\u0002\u0014!9\u0011Q\u0011\u0001\u0005\u0002\u0005M\u0001bBAE\u0001\u0011\u0005\u00111\u0003\u0005\b\u0003\u001b\u0003A\u0011AA\n\u0011\u001d\t\t\n\u0001C\u0001\u0003'Aq!!&\u0001\t\u0013\t9\nC\u0004\u0002(\u0002!I!!+\t\u0013\u0005]\u0006!%A\u0005\n\u0005e\u0006bBAh\u0001\u0011%\u0011\u0011\u001b\u0005\n\u0003C\u0004\u0011\u0013!C\u0005\u0003GD\u0011\"a:\u0001#\u0003%I!a9\t\u000f\u0005%\b\u0001\"\u0003\u0002l\"9!\u0011\u0002\u0001\u0005\n\t-\u0001\"\u0003B\u0011\u0001E\u0005I\u0011\u0002B\u0012\u0011%\u00119\u0003AI\u0001\n\u0013\u0011I\u0003C\u0004\u0003.\u0001!IAa\f\t\u000f\tE\u0003\u0001\"\u0003\u0003T\ta\"+Z:fi\u000e{gn];nKJ<%o\\;q\u001f\u001a47/\u001a;UKN$(B\u0001\u001b6\u0003\u0015\tG-\\5o\u0015\u00051\u0014!B6bM.\f7\u0001A\n\u0003\u0001e\u0002\"AO\u001e\u000e\u0003MJ!\u0001P\u001a\u00031\r{gn];nKJ<%o\\;q\u0007>lW.\u00198e)\u0016\u001cH/\u0001\u0004=S:LGO\u0010\u000b\u0002\u007fA\u0011!\bA\u0001\u0010_Z,'O]5eS:<\u0007K]8qgV\t!\t\u0005\u0002D\u00116\tAI\u0003\u0002F\r\u0006!Q\u000f^5m\u0015\u00059\u0015\u0001\u00026bm\u0006L!!\u0013#\u0003\u0015A\u0013x\u000e]3si&,7/\u0001\tpm\u0016\u0014(/\u001b3j]\u001e\u0004&o\u001c9tA\u00051Ao\u001c9jGF*\u0012!\u0014\t\u0003\u001dFk\u0011a\u0014\u0006\u0003!\u001a\u000bA\u0001\\1oO&\u0011!k\u0014\u0002\u0007'R\u0014\u0018N\\4\u0002\u000fQ|\u0007/[22A\u00051Ao\u001c9jGJ\nq\u0001^8qS\u000e\u0014\u0004%A\bhK:,'/\u0019;f\u0007>tg-[4t+\u0005A\u0006cA-_A6\t!L\u0003\u0002\\9\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\u000b\u0003u\u000bQa]2bY\u0006L!a\u0018.\u0003\u0007M+\u0017\u000f\u0005\u0002bI6\t!M\u0003\u0002dk\u000511/\u001a:wKJL!!\u001a2\u0003\u0017-\u000bgm[1D_:4\u0017nZ\u0001\nE\u0006\u001c\u0018nY!sON,\u0012\u0001\u001b\t\u0004S*dW\"\u0001/\n\u0005-d&!B!se\u0006L\bCA7u\u001d\tq'\u000f\u0005\u0002p96\t\u0001O\u0003\u0002ro\u00051AH]8pizJ!a\u001d/\u0002\rA\u0013X\rZ3g\u0013\t\u0011VO\u0003\u0002t9\u0006\u0011\"-^5mI\u0006\u0013xm\u001d$pe\u001e\u0013x.\u001e9t)\rA\u0007p\u001f\u0005\u0006s*\u0001\rA_\u0001\u0007OJ|W\u000f]:\u0011\u0007esF\u000eC\u0003}\u0015\u0001\u0007Q0\u0001\u0003be\u001e\u001c\bcA5\u007fY&\u0011q\u0010\u0018\u0002\u000byI,\u0007/Z1uK\u0012t\u0014!\u00052vS2$\u0017I]4t\r>\u0014xI]8vaR)\u0001.!\u0002\u0002\n!1\u0011qA\u0006A\u00021\fQa\u001a:pkBDQ\u0001`\u0006A\u0002u\fQCY;jY\u0012\f%oZ:G_J\fE\u000e\\$s_V\u00048\u000fF\u0002i\u0003\u001fAQ\u0001 \u0007A\u0002u\f\u0001\u0005^3tiJ+7/\u001a;PM\u001a\u001cX\r^:O_R,\u00050[:uS:<wI]8vaR\u0011\u0011Q\u0003\t\u0004S\u0006]\u0011bAA\r9\n!QK\\5uQ\ri\u0011Q\u0004\t\u0005\u0003?\t\t$\u0004\u0002\u0002\")!\u00111EA\u0013\u0003\r\t\u0007/\u001b\u0006\u0005\u0003O\tI#A\u0004kkBLG/\u001a:\u000b\t\u0005-\u0012QF\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0003\u0003_\t1a\u001c:h\u0013\u0011\t\u0019$!\t\u0003\tQ+7\u000f^\u0001\u001ei\u0016\u001cHOU3tKR|eMZ:fiN,\u00050[:uS:<Gk\u001c9jG\"\u001aa\"!\b\u0002WQ,7\u000f\u001e*fg\u0016$xJ\u001a4tKR\u001cX\t_5ti&tw\rV8qS\u000e\u001cV\r\\3di\u0016$wI]8vaND3aDA\u000f\u0003\u0019\"Xm\u001d;SKN,Go\u00144gg\u0016$8/\u0012=jgRLgn\u001a+pa&\u001c\u0017\t\u001c7He>,\bo\u001d\u0015\u0004!\u0005u\u0011A\t;fgR\u0014Vm]3u\u001f\u001a47/\u001a;t\u00032dGk\u001c9jGN\fE\u000e\\$s_V\u00048\u000fK\u0002\u0012\u0003;\tq\u0004^3tiJ+7/\u001a;PM\u001a\u001cX\r^:U_2{7-\u00197ECR,G+[7fQ\r\u0011\u0012QD\u0001 i\u0016\u001cHOU3tKR|eMZ:fiN$vNW8oK\u0012$\u0015\r^3US6,\u0007fA\n\u0002\u001e\u0005QB/Z:u%\u0016\u001cX\r^(gMN,Go\u001d\"z\tV\u0014\u0018\r^5p]\"\u001aA#!\b\u0002IQ,7\u000f\u001e*fg\u0016$xJ\u001a4tKR\u001c()\u001f#ve\u0006$\u0018n\u001c8U_\u0016\u000b'\u000f\\5fgRD3!FA\u000f\u0003]\"Xm\u001d;SKN,Go\u00144gg\u0016$8OQ=EkJ\fG/[8o\r\u0006dGNY1dWR{G*\u0019;fgR<\u0006.\u001a8O_J+7m\u001c:eg\"\u001aa#!\b\u00025Q,7\u000f\u001e*fg\u0016$xJ\u001a4tKR\u001cHk\\#be2LWm\u001d;)\u0007]\ti\"\u0001\ruKN$(+Z:fi>3gm]3ugR{G*\u0019;fgRD3\u0001GA\u000f\u0003}!Xm\u001d;SKN,Go\u00144gg\u0016$8\u000fV8DkJ\u0014XM\u001c;PM\u001a\u001cX\r\u001e\u0015\u00043\u0005u\u0011\u0001\t;fgR\u0014Vm]3u\u001f\u001a47/\u001a;t)>\u001c\u0006/Z2jM&\u001cwJ\u001a4tKRD3AGA\u000f\u0003e!Xm\u001d;SKN,Go\u00144gg\u0016$8o\u00155jMR\u0004F.^:)\u0007m\ti\"\u0001\u000euKN$(+Z:fi>3gm]3ugNC\u0017N\u001a;NS:,8\u000fK\u0002\u001d\u0003;\t\u0001\u0006^3tiJ+7/\u001a;PM\u001a\u001cX\r^:TQ&4GOQ=M_^,'\u000f\u00165b]\u0016\u000b'\u000f\\5fgRD3!HA\u000f\u0003\u001d\"Xm\u001d;SKN,Go\u00144gg\u0016$8o\u00155jMR\u0014\u0015\u0010S5hQ\u0016\u0014H\u000b[1o\u0019\u0006$Xm\u001d;)\u0007y\ti\"\u0001\u0013uKN$(+Z:fi>3gm]3ugR{W)\u0019:mS\u0016\u001cHo\u00148P]\u0016$v\u000e]5dQ\ry\u0012QD\u00011i\u0016\u001cHOU3tKR|eMZ:fiN$v.R1sY&,7\u000f^(o\u001f:,Gk\u001c9jG\u0006sG\rU1si&$\u0018n\u001c8)\u0007\u0001\ni\"\u0001\u0012uKN$(+Z:fi>3gm]3ugR{W)\u0019:mS\u0016\u001cHo\u00148U_BL7m\u001d\u0015\u0004C\u0005u\u0011a\f;fgR\u0014Vm]3u\u001f\u001a47/\u001a;t)>,\u0015M\u001d7jKN$xJ\u001c+pa&\u001c7/\u00118e!\u0006\u0014H/\u001b;j_:\u001c\bf\u0001\u0012\u0002\u001e\u0005qC/Z:u%\u0016\u001cX\r^(gMN,Go]#ya>\u0014H/S7q_J$\b\u000b\\1o'&tw\r\\3He>,\b/\u0011:hQ\r\u0019\u0013QD\u0001!i\u0016\u001cHOU3tKR|eMZ:fiN,\u0005\u0010]8si&k\u0007o\u001c:u!2\fg\u000eK\u0002%\u0003;\t!\u0006^3tiJ+7/\u001a;XSRDWK\u001c:fG><g.\u001b>fI:+woQ8ogVlWM](qi&|g\u000eK\u0002&\u0003;\tq\u0002\u001d:pIV\u001cW-T3tg\u0006<Wm\u001d\u000b\u0007\u0003+\tI*!(\t\r\u0005me\u00051\u0001m\u0003\u0015!x\u000e]5d\u0011\u001d\tyJ\na\u0001\u0003C\u000b1B\\;n\u001b\u0016\u001c8/Y4fgB\u0019\u0011.a)\n\u0007\u0005\u0015FLA\u0002J]R\f\u0011\u0004\u001d:pIV\u001cWmQ8ogVlW-\u00118e'\",H\u000fZ8x]RQ\u0011QCAV\u0003[\u000by+a-\t\r\u0005mu\u00051\u0001m\u0011\u0019\t9a\na\u0001Y\"9\u0011\u0011W\u0014A\u0002\u0005\u0005\u0016!\u0004;pi\u0006dW*Z:tC\u001e,7\u000fC\u0005\u00026\u001e\u0002\n\u00111\u0001\u0002\"\u0006aa.^7D_:\u001cX/\\3sg\u0006\u0019\u0003O]8ek\u000e,7i\u001c8tk6,\u0017I\u001c3TQV$Hm\\<oI\u0011,g-Y;mi\u0012\"TCAA^U\u0011\t\t+!0,\u0005\u0005}\u0006\u0003BAa\u0003\u0017l!!a1\u000b\t\u0005\u0015\u0017qY\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!3]\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003\u001b\f\u0019MA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fQ#Y<bSR\u001cuN\\:v[\u0016\u0014\bK]8he\u0016\u001c8\u000f\u0006\u0005\u0002\u0016\u0005M\u0017Q[Al\u0011!\tY*\u000bI\u0001\u0002\u0004a\u0007\u0002CA\u0004SA\u0005\t\u0019\u00017\t\u000f\u0005e\u0017\u00061\u0001\u0002\\\u0006)1m\\;oiB\u0019\u0011.!8\n\u0007\u0005}GL\u0001\u0003M_:<\u0017aH1xC&$8i\u001c8tk6,'\u000f\u0015:pOJ,7o\u001d\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011Q\u001d\u0016\u0004Y\u0006u\u0016aH1xC&$8i\u001c8tk6,'\u000f\u0015:pOJ,7o\u001d\u0013eK\u001a\fW\u000f\u001c;%e\u0005Q\u0012m^1ji\u000e{gn];nKJ<%o\\;q\u0013:\f7\r^5wKR1\u0011QCAw\u0005\u000fAq!a<-\u0001\u0004\t\t0\u0001\u000bd_:\u001cX/\\3s\u000fJ|W\u000f]*feZL7-\u001a\t\u0005\u0003g\u0014\tA\u0004\u0003\u0002v\u0006uh\u0002BA|\u0003wt1a\\A}\u0013\u00051\u0014B\u0001\u001b6\u0013\r\typM\u0001\u0015\u0007>t7/^7fe\u001e\u0013x.\u001e9D_6l\u0017M\u001c3\n\t\t\r!Q\u0001\u0002\u0015\u0007>t7/^7fe\u001e\u0013x.\u001e9TKJ4\u0018nY3\u000b\u0007\u0005}8\u0007\u0003\u0004\u0002\b1\u0002\r\u0001\\\u0001\u0016e\u0016\u001cX\r^!oI\u0006\u001b8/\u001a:u\u001f\u001a47/\u001a;t))\t)B!\u0004\u0003\u0010\tM!Q\u0004\u0005\u0006y6\u0002\r\u0001\u001b\u0005\b\u0005#i\u0003\u0019AAn\u00039)\u0007\u0010]3di\u0016$wJ\u001a4tKRD\u0011B!\u0006.!\u0003\u0005\rAa\u0006\u0002\r\u0011\u0014\u0018PU;o!\rI'\u0011D\u0005\u0004\u00057a&a\u0002\"p_2,\u0017M\u001c\u0005\t\u0005?i\u0003\u0013!a\u0001u\u00061Ao\u001c9jGN\fqD]3tKR\fe\u000eZ!tg\u0016\u0014Ho\u00144gg\u0016$8\u000f\n3fM\u0006,H\u000e\u001e\u00134+\t\u0011)C\u000b\u0003\u0003\u0018\u0005u\u0016a\b:fg\u0016$\u0018I\u001c3BgN,'\u000f^(gMN,Go\u001d\u0013eK\u001a\fW\u000f\u001c;%iU\u0011!1\u0006\u0016\u0004u\u0006u\u0016A\b:fg\u0016$\u0018I\u001c3BgN,'\u000f^(gMN,Go]\"p[6LG\u000f^3e)!\t)B!\r\u00034\t=\u0003bBAxa\u0001\u0007\u0011\u0011\u001f\u0005\b\u0005k\u0001\u0004\u0019\u0001B\u001c\u0003=)\u0007\u0010]3di\u0016$wJ\u001a4tKR\u001c\bcB7\u0003:\tu\u00121\\\u0005\u0004\u0005w)(aA'baB!!q\bB&\u001b\t\u0011\tE\u0003\u0003\u0003D\t\u0015\u0013AB2p[6|gNC\u00027\u0005\u000fRAA!\u0013\u0002.\u00051\u0011\r]1dQ\u0016LAA!\u0014\u0003B\tqAk\u001c9jGB\u000b'\u000f^5uS>t\u0007BBANa\u0001\u0007A.\u0001\u0007sKN,Go\u00144gg\u0016$8\u000f\u0006\u0003\u0003V\t-\u0004CB-\u0003X1\u0014I&C\u0002\u0003<i\u0003r!\u0017B,\u0005{\u0011Y\u0006\u0005\u0003\u0003^\t\u001dTB\u0001B0\u0015\u0011\u0011\tGa\u0019\u0002\u0011\r|gn];nKJTAA!\u001a\u0003F\u000591\r\\5f]R\u001c\u0018\u0002\u0002B5\u0005?\u0012\u0011c\u00144gg\u0016$\u0018I\u001c3NKR\fG-\u0019;b\u0011\u001d\ty/\ra\u0001\u0003c\u0004")
public class ResetConsumerGroupOffsetTest
extends ConsumerGroupCommandTest {
    private final Properties overridingProps = new Properties();
    private final String topic1;
    private final String topic2;

    public Properties overridingProps() {
        return this.overridingProps;
    }

    public String topic1() {
        return this.topic1;
    }

    public String topic2() {
        return this.topic2;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(1, this.zkConnect(), false, true, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, false, false, (Map<Object, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)), 1, false, 1, (short)1, 0).map((Function1 & Serializable)x$1 -> {
            Properties fromProps_overrides = this.overridingProps();
            return KafkaConfig$.MODULE$.fromProps(x$1, fromProps_overrides, true);
        });
    }

    private String[] basicArgs() {
        return new String[]{"--reset-offsets", "--bootstrap-server", this.bootstrapServers(this.bootstrapServers$default$1()), "--timeout", Long.toString(15000L)};
    }

    private String[] buildArgsForGroups(Seq<String> groups, scala.collection.immutable.Seq<String> args) {
        String[] groupArgs = (String[])((IterableOnceOps)groups.flatMap((Function1 & Serializable)group -> new .colon.colon((Object)"--group", (List)new .colon.colon(group, (List)Nil$.MODULE$)))).toArray(ClassTag$.MODULE$.apply(String.class));
        return (String[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])this.basicArgs()), (Object)groupArgs, ClassTag$.MODULE$.apply(String.class))), args, ClassTag$.MODULE$.apply(String.class));
    }

    private String[] buildArgsForGroup(String group, scala.collection.immutable.Seq<String> args) {
        return this.buildArgsForGroups((Seq<String>)new .colon.colon((Object)group, (List)Nil$.MODULE$), args);
    }

    private String[] buildArgsForAllGroups(scala.collection.immutable.Seq<String> args) {
        return (String[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])this.basicArgs()), (Object)new String[]{"--all-groups"}, ClassTag$.MODULE$.apply(String.class))), args, ClassTag$.MODULE$.apply(String.class));
    }

    @Test
    public void testResetOffsetsNotExistingGroup() {
        String group = "missing.group";
        String[] args = this.buildArgsForGroup(group, (scala.collection.immutable.Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--all-topics", "--to-current", "--execute"}));
        ConsumerGroupCommand.ConsumerGroupService consumerGroupCommand = this.getConsumerGroupService(args);
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ResetConsumerGroupOffsetTest.$anonfun$testResetOffsetsNotExistingGroup$1(consumerGroupCommand, group)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"Can't find a coordinator");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
        Map resetOffsets = (Map)consumerGroupCommand.resetOffsets().apply((Object)group);
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().empty(), (Object)resetOffsets);
        String x$2 = this.committedOffsets$default$1();
        Assertions.assertEquals((Object)resetOffsets, this.committedOffsets(x$2, group));
    }

    @Test
    public void testResetOffsetsExistingTopic() {
        String group = "new.group";
        Object[] args = this.buildArgsForGroup(group, (scala.collection.immutable.Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--topic", this.topic(), "--to-offset", "50"}));
        this.produceMessages(this.topic(), 100);
        this.resetAndAssertOffsets((String[])args, 50L, true, this.resetAndAssertOffsets$default$4());
        this.resetAndAssertOffsets((String[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps(args), (Object)new String[]{"--dry-run"}, ClassTag$.MODULE$.apply(String.class)), 50L, true, this.resetAndAssertOffsets$default$4());
        this.resetAndAssertOffsets((String[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps(args), (Object)new String[]{"--execute"}, ClassTag$.MODULE$.apply(String.class)), 50L, false, this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsExistingTopicSelectedGroups() {
        this.produceMessages(this.topic(), 100);
        IndexedSeq groups = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 3).map((Function1 & Serializable)id -> ResetConsumerGroupOffsetTest.$anonfun$testResetOffsetsExistingTopicSelectedGroups$1(this, BoxesRunTime.unboxToInt((Object)id)));
        Object[] args = this.buildArgsForGroups((Seq<String>)groups, (scala.collection.immutable.Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--topic", this.topic(), "--to-offset", "50"}));
        this.resetAndAssertOffsets((String[])args, 50L, true, this.resetAndAssertOffsets$default$4());
        this.resetAndAssertOffsets((String[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps(args), (Object)new String[]{"--dry-run"}, ClassTag$.MODULE$.apply(String.class)), 50L, true, this.resetAndAssertOffsets$default$4());
        this.resetAndAssertOffsets((String[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps(args), (Object)new String[]{"--execute"}, ClassTag$.MODULE$.apply(String.class)), 50L, false, this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsExistingTopicAllGroups() {
        Object[] args = this.buildArgsForAllGroups((scala.collection.immutable.Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--topic", this.topic(), "--to-offset", "50"}));
        this.produceMessages(this.topic(), 100);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 3).map((Function1 & Serializable)x$2 -> ResetConsumerGroupOffsetTest.$anonfun$testResetOffsetsExistingTopicAllGroups$1(this, BoxesRunTime.unboxToInt((Object)x$2))).foreach((Function1 & Serializable)group -> {
            ResetConsumerGroupOffsetTest.$anonfun$testResetOffsetsExistingTopicAllGroups$2(this, group);
            return BoxedUnit.UNIT;
        });
        this.resetAndAssertOffsets((String[])args, 50L, true, this.resetAndAssertOffsets$default$4());
        this.resetAndAssertOffsets((String[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps(args), (Object)new String[]{"--dry-run"}, ClassTag$.MODULE$.apply(String.class)), 50L, true, this.resetAndAssertOffsets$default$4());
        this.resetAndAssertOffsets((String[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps(args), (Object)new String[]{"--execute"}, ClassTag$.MODULE$.apply(String.class)), 50L, false, this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsAllTopicsAllGroups() {
        Object[] args = this.buildArgsForAllGroups((scala.collection.immutable.Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--all-topics", "--to-offset", "50"}));
        IndexedSeq topics = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 3).map((Function1 & Serializable)x$3 -> ResetConsumerGroupOffsetTest.$anonfun$testResetOffsetsAllTopicsAllGroups$1(this, BoxesRunTime.unboxToInt((Object)x$3)));
        IndexedSeq groups = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 3).map((Function1 & Serializable)x$4 -> ResetConsumerGroupOffsetTest.$anonfun$testResetOffsetsAllTopicsAllGroups$2(this, BoxesRunTime.unboxToInt((Object)x$4)));
        topics.foreach((Function1 & Serializable)topic -> {
            this.produceMessages(topic, 100);
            return BoxedUnit.UNIT;
        });
        topics.foreach((Function1 & Serializable)topic -> {
            groups.foreach((Function1 & Serializable)group -> {
                ResetConsumerGroupOffsetTest.$anonfun$testResetOffsetsAllTopicsAllGroups$5($this, topic, group);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
        this.resetAndAssertOffsets((String[])args, 50L, true, (Seq<String>)topics);
        this.resetAndAssertOffsets((String[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps(args), (Object)new String[]{"--dry-run"}, ClassTag$.MODULE$.apply(String.class)), 50L, true, (Seq<String>)topics);
        String[] x$42 = (String[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps(args), (Object)new String[]{"--execute"}, ClassTag$.MODULE$.apply(String.class));
        boolean bl = false;
        this.resetAndAssertOffsets(x$42, 50L, bl, (Seq<String>)topics);
    }

    @Test
    public void testResetOffsetsToLocalDateTime() {
        String string;
        String string2;
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -1);
        this.produceMessages(this.topic(), 100);
        ConsumerGroupCommandTest.ConsumerGroupExecutor executor = this.addConsumerGroupExecutor(1, this.topic(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5(), this.addConsumerGroupExecutor$default$6());
        String string3 = string2 = this.topic();
        string2 = null;
        String x$2 = string3;
        String string4 = string = this.group();
        string = null;
        String x$3 = string4;
        this.awaitConsumerProgress(x$2, x$3, 100L);
        executor.shutdown();
        String[] args = this.buildArgsForGroup(this.group(), (scala.collection.immutable.Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--all-topics", "--to-datetime", format.format(calendar.getTime()), "--execute"}));
        this.resetAndAssertOffsets(args, 0L, false, this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsToZonedDateTime() {
        String string;
        String string2;
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
        this.produceMessages(this.topic(), 50);
        Date checkpoint = new Date();
        this.produceMessages(this.topic(), 50);
        ConsumerGroupCommandTest.ConsumerGroupExecutor executor = this.addConsumerGroupExecutor(1, this.topic(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5(), this.addConsumerGroupExecutor$default$6());
        String string3 = string2 = this.topic();
        string2 = null;
        String x$2 = string3;
        String string4 = string = this.group();
        string = null;
        String x$3 = string4;
        this.awaitConsumerProgress(x$2, x$3, 100L);
        executor.shutdown();
        String[] args = this.buildArgsForGroup(this.group(), (scala.collection.immutable.Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--all-topics", "--to-datetime", format.format(checkpoint), "--execute"}));
        this.resetAndAssertOffsets(args, 50L, false, this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsByDuration() {
        String[] args = this.buildArgsForGroup(this.group(), (scala.collection.immutable.Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--all-topics", "--by-duration", "PT1M", "--execute"}));
        this.produceConsumeAndShutdown(this.topic(), this.group(), 100, 1);
        this.resetAndAssertOffsets(args, 0L, false, this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsByDurationToEarliest() {
        String[] args = this.buildArgsForGroup(this.group(), (scala.collection.immutable.Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--all-topics", "--by-duration", "PT0.1S", "--execute"}));
        this.produceConsumeAndShutdown(this.topic(), this.group(), 100, 1);
        this.resetAndAssertOffsets(args, 100L, false, this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsByDurationFallbackToLatestWhenNoRecords() {
        String topic = "foo2";
        String[] args = this.buildArgsForGroup(this.group(), (scala.collection.immutable.Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--topic", topic, "--by-duration", "PT1M", "--execute"}));
        this.createTopic(topic, this.createTopic$default$2(), this.createTopic$default$3(), this.createTopic$default$4(), this.createTopic$default$5());
        .colon.colon x$3 = new .colon.colon((Object)"foo2", (List)Nil$.MODULE$);
        boolean bl = false;
        this.resetAndAssertOffsets(args, 0L, bl, (Seq<String>)x$3);
        this.adminZkClient().deleteTopic(topic);
    }

    @Test
    public void testResetOffsetsToEarliest() {
        String[] args = this.buildArgsForGroup(this.group(), (scala.collection.immutable.Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--all-topics", "--to-earliest", "--execute"}));
        this.produceConsumeAndShutdown(this.topic(), this.group(), 100, 1);
        this.resetAndAssertOffsets(args, 0L, false, this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsToLatest() {
        String[] args = this.buildArgsForGroup(this.group(), (scala.collection.immutable.Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--all-topics", "--to-latest", "--execute"}));
        this.produceConsumeAndShutdown(this.topic(), this.group(), 100, 1);
        this.produceMessages(this.topic(), 100);
        this.resetAndAssertOffsets(args, 200L, false, this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsToCurrentOffset() {
        String[] args = this.buildArgsForGroup(this.group(), (scala.collection.immutable.Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--all-topics", "--to-current", "--execute"}));
        this.produceConsumeAndShutdown(this.topic(), this.group(), 100, 1);
        this.produceMessages(this.topic(), 100);
        this.resetAndAssertOffsets(args, 100L, false, this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsToSpecificOffset() {
        String[] args = this.buildArgsForGroup(this.group(), (scala.collection.immutable.Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--all-topics", "--to-offset", "1", "--execute"}));
        this.produceConsumeAndShutdown(this.topic(), this.group(), 100, 1);
        this.resetAndAssertOffsets(args, 1L, false, this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsShiftPlus() {
        String[] args = this.buildArgsForGroup(this.group(), (scala.collection.immutable.Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--all-topics", "--shift-by", "50", "--execute"}));
        this.produceConsumeAndShutdown(this.topic(), this.group(), 100, 1);
        this.produceMessages(this.topic(), 100);
        this.resetAndAssertOffsets(args, 150L, false, this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsShiftMinus() {
        String[] args = this.buildArgsForGroup(this.group(), (scala.collection.immutable.Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--all-topics", "--shift-by", "-50", "--execute"}));
        this.produceConsumeAndShutdown(this.topic(), this.group(), 100, 1);
        this.produceMessages(this.topic(), 100);
        this.resetAndAssertOffsets(args, 50L, false, this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsShiftByLowerThanEarliest() {
        String[] args = this.buildArgsForGroup(this.group(), (scala.collection.immutable.Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--all-topics", "--shift-by", "-150", "--execute"}));
        this.produceConsumeAndShutdown(this.topic(), this.group(), 100, 1);
        this.produceMessages(this.topic(), 100);
        this.resetAndAssertOffsets(args, 0L, false, this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsShiftByHigherThanLatest() {
        String[] args = this.buildArgsForGroup(this.group(), (scala.collection.immutable.Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--all-topics", "--shift-by", "150", "--execute"}));
        this.produceConsumeAndShutdown(this.topic(), this.group(), 100, 1);
        this.produceMessages(this.topic(), 100);
        this.resetAndAssertOffsets(args, 200L, false, this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsToEarliestOnOneTopic() {
        String[] args = this.buildArgsForGroup(this.group(), (scala.collection.immutable.Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--topic", this.topic(), "--to-earliest", "--execute"}));
        this.produceConsumeAndShutdown(this.topic(), this.group(), 100, 1);
        this.resetAndAssertOffsets(args, 0L, false, this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsToEarliestOnOneTopicAndPartition() {
        String topic = "bar";
        this.createTopic(topic, 2, 1, this.createTopic$default$4(), this.createTopic$default$5());
        String[] args = this.buildArgsForGroup(this.group(), (scala.collection.immutable.Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--topic", new StringBuilder(2).append(topic).append(":1").toString(), "--to-earliest", "--execute"}));
        ConsumerGroupCommand.ConsumerGroupService consumerGroupCommand = this.getConsumerGroupService(args);
        this.produceConsumeAndShutdown(topic, this.group(), 100, 2);
        Map<TopicPartition, Object> priorCommittedOffsets = this.committedOffsets(topic, this.committedOffsets$default$2());
        TopicPartition tp0 = new TopicPartition(topic, 0);
        TopicPartition tp1 = new TopicPartition(topic, 1);
        scala.collection.immutable.Map expectedOffsets = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp0), priorCommittedOffsets.apply((Object)tp0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)BoxesRunTime.boxToLong((long)0L))}));
        this.resetAndAssertOffsetsCommitted(consumerGroupCommand, (scala.collection.immutable.Map<TopicPartition, Object>)expectedOffsets, topic);
        this.adminZkClient().deleteTopic(topic);
    }

    @Test
    public void testResetOffsetsToEarliestOnTopics() {
        String topic1 = "topic1";
        String topic2 = "topic2";
        this.createTopic(topic1, 1, 1, this.createTopic$default$4(), this.createTopic$default$5());
        this.createTopic(topic2, 1, 1, this.createTopic$default$4(), this.createTopic$default$5());
        String[] args = this.buildArgsForGroup(this.group(), (scala.collection.immutable.Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--topic", topic1, "--topic", topic2, "--to-earliest", "--execute"}));
        ConsumerGroupCommand.ConsumerGroupService consumerGroupCommand = this.getConsumerGroupService(args);
        this.produceConsumeAndShutdown(topic1, this.group(), 100, 1);
        this.produceConsumeAndShutdown(topic2, this.group(), 100, 1);
        TopicPartition tp1 = new TopicPartition(topic1, 0);
        TopicPartition tp2 = new TopicPartition(topic2, 0);
        Map allResetOffsets = (Map)((MapOps)consumerGroupCommand.resetOffsets().apply((Object)this.group())).map((Function1 & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            TopicPartition k = (TopicPartition)x0$1._1();
            OffsetAndMetadata v = (OffsetAndMetadata)x0$1._2();
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)BoxesRunTime.boxToLong((long)v.offset()));
            return tuple2;
        });
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)BoxesRunTime.boxToLong((long)0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), (Object)BoxesRunTime.boxToLong((long)0L))})), (Object)allResetOffsets);
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)BoxesRunTime.boxToLong((long)0L))})), this.committedOffsets(topic1, this.committedOffsets$default$2()));
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), (Object)BoxesRunTime.boxToLong((long)0L))})), this.committedOffsets(topic2, this.committedOffsets$default$2()));
        this.adminZkClient().deleteTopic(topic1);
        this.adminZkClient().deleteTopic(topic2);
    }

    @Test
    public void testResetOffsetsToEarliestOnTopicsAndPartitions() {
        String topic1 = "topic1";
        String topic2 = "topic2";
        this.createTopic(topic1, 2, 1, this.createTopic$default$4(), this.createTopic$default$5());
        this.createTopic(topic2, 2, 1, this.createTopic$default$4(), this.createTopic$default$5());
        String[] args = this.buildArgsForGroup(this.group(), (scala.collection.immutable.Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--topic", new StringBuilder(2).append(topic1).append(":1").toString(), "--topic", new StringBuilder(2).append(topic2).append(":1").toString(), "--to-earliest", "--execute"}));
        ConsumerGroupCommand.ConsumerGroupService consumerGroupCommand = this.getConsumerGroupService(args);
        this.produceConsumeAndShutdown(topic1, this.group(), 100, 2);
        this.produceConsumeAndShutdown(topic2, this.group(), 100, 2);
        Map<TopicPartition, Object> priorCommittedOffsets1 = this.committedOffsets(topic1, this.committedOffsets$default$2());
        Map<TopicPartition, Object> priorCommittedOffsets2 = this.committedOffsets(topic2, this.committedOffsets$default$2());
        TopicPartition tp1 = new TopicPartition(topic1, 1);
        TopicPartition tp2 = new TopicPartition(topic2, 1);
        Map allResetOffsets = (Map)((MapOps)consumerGroupCommand.resetOffsets().apply((Object)this.group())).map((Function1 & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            TopicPartition k = (TopicPartition)x0$1._1();
            OffsetAndMetadata v = (OffsetAndMetadata)x0$1._2();
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)BoxesRunTime.boxToLong((long)v.offset()));
            return tuple2;
        });
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)BoxesRunTime.boxToInteger((int)0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), (Object)BoxesRunTime.boxToInteger((int)0))})), (Object)allResetOffsets);
        Assertions.assertEquals((Object)priorCommittedOffsets1.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)BoxesRunTime.boxToLong((long)0L))), this.committedOffsets(topic1, this.committedOffsets$default$2()));
        Assertions.assertEquals((Object)priorCommittedOffsets2.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), (Object)BoxesRunTime.boxToLong((long)0L))), this.committedOffsets(topic2, this.committedOffsets$default$2()));
        this.adminZkClient().deleteTopic(topic1);
        this.adminZkClient().deleteTopic(topic2);
    }

    @Test
    public void testResetOffsetsExportImportPlanSingleGroupArg() {
        String topic = "bar";
        TopicPartition tp0 = new TopicPartition(topic, 0);
        TopicPartition tp1 = new TopicPartition(topic, 1);
        this.createTopic(topic, 2, 1, this.createTopic$default$4(), this.createTopic$default$5());
        String[] cgcArgs = this.buildArgsForGroup(this.group(), (scala.collection.immutable.Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--all-topics", "--to-offset", "2", "--export"}));
        ConsumerGroupCommand.ConsumerGroupService consumerGroupCommand = this.getConsumerGroupService(cgcArgs);
        this.produceConsumeAndShutdown(topic, this.group(), 100, 2);
        File file = File.createTempFile("reset", ".csv");
        file.deleteOnExit();
        Map exportedOffsets = consumerGroupCommand.resetOffsets();
        BufferedWriter bw = new BufferedWriter(new FileWriter(file));
        bw.write(consumerGroupCommand.exportOffsetsToCsv(exportedOffsets));
        bw.close();
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp0), (Object)BoxesRunTime.boxToLong((long)2L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)BoxesRunTime.boxToLong((long)2L))})), (Object)((MapOps)exportedOffsets.apply((Object)this.group())).map((Function1 & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            TopicPartition k = (TopicPartition)x0$1._1();
            OffsetAndMetadata v = (OffsetAndMetadata)x0$1._2();
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)BoxesRunTime.boxToLong((long)v.offset()));
            return tuple2;
        }));
        String[] cgcArgsExec = this.buildArgsForGroup(this.group(), (scala.collection.immutable.Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--all-topics", "--from-file", file.getCanonicalPath(), "--dry-run"}));
        Map importedOffsets = this.getConsumerGroupService(cgcArgsExec).resetOffsets();
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp0), (Object)BoxesRunTime.boxToLong((long)2L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)BoxesRunTime.boxToLong((long)2L))})), (Object)((MapOps)importedOffsets.apply((Object)this.group())).map((Function1 & Serializable)x0$2 -> {
            if (x0$2 == null) {
                throw new MatchError(null);
            }
            TopicPartition k = (TopicPartition)x0$2._1();
            OffsetAndMetadata v = (OffsetAndMetadata)x0$2._2();
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)BoxesRunTime.boxToLong((long)v.offset()));
            return tuple2;
        }));
        this.adminZkClient().deleteTopic(topic);
    }

    @Test
    public void testResetOffsetsExportImportPlan() {
        String group1 = new StringBuilder(1).append(this.group()).append("1").toString();
        String group2 = new StringBuilder(1).append(this.group()).append("2").toString();
        String topic1 = "bar1";
        String topic2 = "bar2";
        TopicPartition t1p0 = new TopicPartition(topic1, 0);
        TopicPartition t1p1 = new TopicPartition(topic1, 1);
        TopicPartition t2p0 = new TopicPartition(topic2, 0);
        TopicPartition t2p1 = new TopicPartition(topic2, 1);
        this.createTopic(topic1, 2, 1, this.createTopic$default$4(), this.createTopic$default$5());
        this.createTopic(topic2, 2, 1, this.createTopic$default$4(), this.createTopic$default$5());
        String[] cgcArgs = this.buildArgsForGroups((Seq<String>)new .colon.colon((Object)group1, (List)new .colon.colon((Object)group2, (List)Nil$.MODULE$)), (scala.collection.immutable.Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--all-topics", "--to-offset", "2", "--export"}));
        ConsumerGroupCommand.ConsumerGroupService consumerGroupCommand = this.getConsumerGroupService(cgcArgs);
        this.produceConsumeAndShutdown(topic1, group1, 100, 1);
        this.produceConsumeAndShutdown(topic2, group2, 100, 1);
        this.awaitConsumerGroupInactive(consumerGroupCommand, group1);
        this.awaitConsumerGroupInactive(consumerGroupCommand, group2);
        File file = File.createTempFile("reset", ".csv");
        file.deleteOnExit();
        Map exportedOffsets = consumerGroupCommand.resetOffsets();
        BufferedWriter bw = new BufferedWriter(new FileWriter(file));
        bw.write(consumerGroupCommand.exportOffsetsToCsv(exportedOffsets));
        bw.close();
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)t1p0), (Object)BoxesRunTime.boxToLong((long)2L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)t1p1), (Object)BoxesRunTime.boxToLong((long)2L))})), (Object)((MapOps)exportedOffsets.apply((Object)group1)).map((Function1 & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            TopicPartition k = (TopicPartition)x0$1._1();
            OffsetAndMetadata v = (OffsetAndMetadata)x0$1._2();
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)BoxesRunTime.boxToLong((long)v.offset()));
            return tuple2;
        }));
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)t2p0), (Object)BoxesRunTime.boxToLong((long)2L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)t2p1), (Object)BoxesRunTime.boxToLong((long)2L))})), (Object)((MapOps)exportedOffsets.apply((Object)group2)).map((Function1 & Serializable)x0$2 -> {
            if (x0$2 == null) {
                throw new MatchError(null);
            }
            TopicPartition k = (TopicPartition)x0$2._1();
            OffsetAndMetadata v = (OffsetAndMetadata)x0$2._2();
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)BoxesRunTime.boxToLong((long)v.offset()));
            return tuple2;
        }));
        String[] cgcArgsExec = this.buildArgsForGroups((Seq<String>)new .colon.colon((Object)group1, (List)new .colon.colon((Object)group2, (List)Nil$.MODULE$)), (scala.collection.immutable.Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--all-topics", "--from-file", file.getCanonicalPath(), "--dry-run"}));
        Map importedOffsets = this.getConsumerGroupService(cgcArgsExec).resetOffsets();
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)t1p0), (Object)BoxesRunTime.boxToLong((long)2L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)t1p1), (Object)BoxesRunTime.boxToLong((long)2L))})), (Object)((MapOps)importedOffsets.apply((Object)group1)).map((Function1 & Serializable)x0$3 -> {
            if (x0$3 == null) {
                throw new MatchError(null);
            }
            TopicPartition k = (TopicPartition)x0$3._1();
            OffsetAndMetadata v = (OffsetAndMetadata)x0$3._2();
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)BoxesRunTime.boxToLong((long)v.offset()));
            return tuple2;
        }));
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)t2p0), (Object)BoxesRunTime.boxToLong((long)2L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)t2p1), (Object)BoxesRunTime.boxToLong((long)2L))})), (Object)((MapOps)importedOffsets.apply((Object)group2)).map((Function1 & Serializable)x0$4 -> {
            if (x0$4 == null) {
                throw new MatchError(null);
            }
            TopicPartition k = (TopicPartition)x0$4._1();
            OffsetAndMetadata v = (OffsetAndMetadata)x0$4._2();
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)BoxesRunTime.boxToLong((long)v.offset()));
            return tuple2;
        }));
        String[] cgcArgsExec2 = this.buildArgsForGroup(group1, (scala.collection.immutable.Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--all-topics", "--from-file", file.getCanonicalPath(), "--dry-run"}));
        Map importedOffsets2 = this.getConsumerGroupService(cgcArgsExec2).resetOffsets();
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)t1p0), (Object)BoxesRunTime.boxToLong((long)2L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)t1p1), (Object)BoxesRunTime.boxToLong((long)2L))})), (Object)((MapOps)importedOffsets2.apply((Object)group1)).map((Function1 & Serializable)x0$5 -> {
            if (x0$5 == null) {
                throw new MatchError(null);
            }
            TopicPartition k = (TopicPartition)x0$5._1();
            OffsetAndMetadata v = (OffsetAndMetadata)x0$5._2();
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)BoxesRunTime.boxToLong((long)v.offset()));
            return tuple2;
        }));
        this.adminZkClient().deleteTopic(this.topic());
    }

    @Test
    public void testResetWithUnrecognizedNewConsumerOption() {
        String[] cgcArgs = new String[]{"--new-consumer", "--bootstrap-server", this.bootstrapServers(this.bootstrapServers$default$1()), "--reset-offsets", "--group", this.group(), "--all-topics", "--to-offset", "2", "--export"};
        Assertions.assertThrows(OptionException.class, () -> this.getConsumerGroupService(cgcArgs));
    }

    private void produceMessages(String topic, int numMessages) {
        IndexedSeq records = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numMessages).map((Function1 & Serializable)x$5 -> ResetConsumerGroupOffsetTest.$anonfun$produceMessages$1(topic, BoxesRunTime.unboxToInt((Object)x$5)));
        TestUtils$.MODULE$.produceMessages(this.servers(), (Seq<ProducerRecord<byte[], byte[]>>)records, 1);
    }

    private void produceConsumeAndShutdown(String topic, String group, int totalMessages, int numConsumers) {
        this.produceMessages(topic, totalMessages);
        ConsumerGroupCommandTest.ConsumerGroupExecutor executor = this.addConsumerGroupExecutor(numConsumers, topic, group, this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5(), this.addConsumerGroupExecutor$default$6());
        this.awaitConsumerProgress(topic, group, totalMessages);
        executor.shutdown();
    }

    private int produceConsumeAndShutdown$default$4() {
        return 1;
    }

    private void awaitConsumerProgress(String topic, String group, long count) {
        try (KafkaConsumer<String, String> consumer = this.createNoAutoCommitConsumer(group);){
            scala.collection.immutable.Set partitions = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(consumer.partitionsFor(topic)).asScala().map((Function1 & Serializable)partitionInfo -> new TopicPartition(partitionInfo.topic(), partitionInfo.partition()))).toSet();
            long l = 15000L;
            long l2 = 100L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!ResetConsumerGroupOffsetTest.$anonfun$awaitConsumerProgress$2(consumer, partitions, count)) {
                if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                    Assertions.fail((String)ResetConsumerGroupOffsetTest.$anonfun$awaitConsumerProgress$6(this, count, topic, group));
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
            }
        }
    }

    private String awaitConsumerProgress$default$1() {
        return this.topic();
    }

    private String awaitConsumerProgress$default$2() {
        return this.group();
    }

    private void awaitConsumerGroupInactive(ConsumerGroupCommand.ConsumerGroupService consumerGroupService, String group) {
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ResetConsumerGroupOffsetTest.$anonfun$awaitConsumerGroupInactive$1(consumerGroupService, group)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)ResetConsumerGroupOffsetTest.$anonfun$awaitConsumerGroupInactive$2(consumerGroupService, group));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
    }

    private void resetAndAssertOffsets(String[] args, long expectedOffset, boolean dryRun, Seq<String> topics) {
        Map map;
        ConsumerGroupCommand.ConsumerGroupService consumerGroupCommand = this.getConsumerGroupService(args);
        scala.collection.immutable.Map expectedOffsets = ((IterableOnceOps)topics.map((Function1 & Serializable)topic -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(topic), Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(topic, 0)), (Object)BoxesRunTime.boxToLong((long)expectedOffset))}))))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        Map map2 = map = consumerGroupCommand.resetOffsets();
        map = null;
        Map resetOffsetsResultByGroup = map2;
        try {
            topics.foreach((Function1 & Serializable)topic -> {
                ResetConsumerGroupOffsetTest.$anonfun$resetAndAssertOffsets$2(this, resetOffsetsResultByGroup, expectedOffsets, dryRun, topic);
                return BoxedUnit.UNIT;
            });
        }
        finally {
            consumerGroupCommand.close();
        }
    }

    private boolean resetAndAssertOffsets$default$3() {
        return false;
    }

    private Seq<String> resetAndAssertOffsets$default$4() {
        return new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$);
    }

    private void resetAndAssertOffsetsCommitted(ConsumerGroupCommand.ConsumerGroupService consumerGroupService, scala.collection.immutable.Map<TopicPartition, Object> expectedOffsets, String topic) {
        consumerGroupService.resetOffsets().withFilter((Function1 & Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$2 != null))).foreach((Function1 & Serializable)x$9 -> {
            ResetConsumerGroupOffsetTest.$anonfun$resetAndAssertOffsetsCommitted$2(this, expectedOffsets, topic, x$9);
            return BoxedUnit.UNIT;
        });
    }

    private Map<String, Map<TopicPartition, OffsetAndMetadata>> resetOffsets(ConsumerGroupCommand.ConsumerGroupService consumerGroupService) {
        return consumerGroupService.resetOffsets();
    }

    public static final /* synthetic */ boolean $anonfun$testResetOffsetsNotExistingGroup$1(ConsumerGroupCommand.ConsumerGroupService consumerGroupCommand$1, String group$1) {
        String string = consumerGroupCommand$1.collectGroupState(group$1).coordinator().host();
        String string2 = "localhost";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ String $anonfun$testResetOffsetsNotExistingGroup$2() {
        return "Can't find a coordinator";
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ String $anonfun$testResetOffsetsExistingTopicSelectedGroups$1(ResetConsumerGroupOffsetTest $this, int id) {
        void var2_2;
        String string;
        String group = new StringBuilder(0).append($this.group()).append(id).toString();
        ConsumerGroupCommandTest.ConsumerGroupExecutor executor = $this.addConsumerGroupExecutor(1, $this.topic(), group, $this.addConsumerGroupExecutor$default$4(), $this.addConsumerGroupExecutor$default$5(), $this.addConsumerGroupExecutor$default$6());
        String string2 = string = $this.topic();
        string = null;
        String x$3 = string2;
        $this.awaitConsumerProgress(x$3, group, 100L);
        executor.shutdown();
        return var2_2;
    }

    public static final /* synthetic */ String $anonfun$testResetOffsetsExistingTopicAllGroups$1(ResetConsumerGroupOffsetTest $this, int x$2) {
        return new StringBuilder(0).append($this.group()).append(x$2).toString();
    }

    public static final /* synthetic */ void $anonfun$testResetOffsetsExistingTopicAllGroups$2(ResetConsumerGroupOffsetTest $this, String group) {
        String string;
        ConsumerGroupCommandTest.ConsumerGroupExecutor executor = $this.addConsumerGroupExecutor(1, $this.topic(), group, $this.addConsumerGroupExecutor$default$4(), $this.addConsumerGroupExecutor$default$5(), $this.addConsumerGroupExecutor$default$6());
        String string2 = string = $this.topic();
        string = null;
        String x$3 = string2;
        $this.awaitConsumerProgress(x$3, group, 100L);
        executor.shutdown();
    }

    public static final /* synthetic */ String $anonfun$testResetOffsetsAllTopicsAllGroups$1(ResetConsumerGroupOffsetTest $this, int x$3) {
        return new StringBuilder(0).append($this.topic()).append(x$3).toString();
    }

    public static final /* synthetic */ String $anonfun$testResetOffsetsAllTopicsAllGroups$2(ResetConsumerGroupOffsetTest $this, int x$4) {
        return new StringBuilder(0).append($this.group()).append(x$4).toString();
    }

    public static final /* synthetic */ void $anonfun$testResetOffsetsAllTopicsAllGroups$5(ResetConsumerGroupOffsetTest $this, String topic$1, String group) {
        ConsumerGroupCommandTest.ConsumerGroupExecutor executor = $this.addConsumerGroupExecutor(3, topic$1, group, $this.addConsumerGroupExecutor$default$4(), $this.addConsumerGroupExecutor$default$5(), $this.addConsumerGroupExecutor$default$6());
        $this.awaitConsumerProgress(topic$1, group, 100L);
        executor.shutdown();
    }

    public static final /* synthetic */ ProducerRecord $anonfun$produceMessages$1(String topic$2, int x$5) {
        return new ProducerRecord(topic$2, (Object)new byte[100000]);
    }

    public static final /* synthetic */ long $anonfun$awaitConsumerProgress$3(long x0$1, OffsetAndMetadata x1$1) {
        return x0$1 + BoxesRunTime.unboxToLong((Object)Option$.MODULE$.apply((Object)x1$1).map((Function1 & Serializable)x$6 -> BoxesRunTime.boxToLong((long)x$6.offset())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L));
    }

    public static final /* synthetic */ boolean $anonfun$awaitConsumerProgress$2(KafkaConsumer consumer$1, scala.collection.immutable.Set partitions$1, long count$1) {
        return BoxesRunTime.unboxToLong((Object)CollectionConverters$.MODULE$.CollectionHasAsScala(consumer$1.committed(CollectionConverters$.MODULE$.SetHasAsJava((Set)partitions$1).asJava()).values()).asScala().foldLeft((Object)BoxesRunTime.boxToLong((long)0L), (Function2 & Serializable)(x0$1, x1$1) -> BoxesRunTime.boxToLong((long)ResetConsumerGroupOffsetTest.$anonfun$awaitConsumerProgress$3(BoxesRunTime.unboxToLong((Object)x0$1), x1$1)))) == count$1;
    }

    public static final /* synthetic */ String $anonfun$awaitConsumerProgress$6(ResetConsumerGroupOffsetTest $this, long count$1, String topic$3, String group$2) {
        return new StringBuilder(77).append("Expected that consumer group has consumed all messages from topic/partition. ").append(new StringBuilder(34).append("Expected offset: ").append(count$1).append(". Actual offset: ").append($this.committedOffsets(topic$3, group$2).values().sum((Numeric)Numeric.LongIsIntegral$.MODULE$)).toString()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$awaitConsumerGroupInactive$1(ConsumerGroupCommand.ConsumerGroupService consumerGroupService$1, String group$3) {
        block3: {
            block2: {
                String state;
                String string = state = consumerGroupService$1.collectGroupState(group$3).state();
                String string2 = "Empty";
                if (string != null && string.equals(string2)) break block2;
                String string3 = state;
                String string4 = "Dead";
                if (string3 == null || !string3.equals(string4)) break block3;
            }
            return true;
        }
        return false;
    }

    public static final /* synthetic */ String $anonfun$awaitConsumerGroupInactive$2(ConsumerGroupCommand.ConsumerGroupService consumerGroupService$1, String group$3) {
        return new StringBuilder(56).append("Expected that consumer group is inactive. Actual state: ").append(consumerGroupService$1.collectGroupState(group$3).state()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$resetAndAssertOffsets$5(String topic$4, Tuple2 partitionInfo) {
        String string = ((TopicPartition)partitionInfo._1()).topic();
        return !(string != null ? !string.equals(topic$4) : topic$4 != null);
    }

    public static final /* synthetic */ void $anonfun$resetAndAssertOffsets$4(ResetConsumerGroupOffsetTest $this, String topic$4, scala.collection.immutable.Map expectedOffsets$1, boolean dryRun$1, Tuple2 x$7) {
        if (x$7 != null) {
            String group = (String)x$7._1();
            Map partitionInfo2 = (Map)x$7._2();
            Map<TopicPartition, Object> priorOffsets = $this.committedOffsets(topic$4, group);
            Assertions.assertEquals((Object)expectedOffsets$1.apply((Object)topic$4), (Object)((MapOps)partitionInfo2.filter((Function1 & Serializable)partitionInfo -> BoxesRunTime.boxToBoolean((boolean)ResetConsumerGroupOffsetTest.$anonfun$resetAndAssertOffsets$5(topic$4, partitionInfo)))).map((Function1 & Serializable)x0$1 -> {
                if (x0$1 == null) {
                    throw new MatchError(null);
                }
                TopicPartition k = (TopicPartition)x0$1._1();
                OffsetAndMetadata v = (OffsetAndMetadata)x0$1._2();
                Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)BoxesRunTime.boxToLong((long)v.offset()));
                return tuple2;
            }));
            Assertions.assertEquals(dryRun$1 ? priorOffsets : expectedOffsets$1.apply((Object)topic$4), $this.committedOffsets(topic$4, group));
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$resetAndAssertOffsets$2(ResetConsumerGroupOffsetTest $this, Map resetOffsetsResultByGroup$1, scala.collection.immutable.Map expectedOffsets$1, boolean dryRun$1, String topic) {
        resetOffsetsResultByGroup$1.withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$1 != null))).foreach((Function1 & Serializable)x$7 -> {
            ResetConsumerGroupOffsetTest.$anonfun$resetAndAssertOffsets$4($this, topic, expectedOffsets$1, dryRun$1, x$7);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$resetAndAssertOffsetsCommitted$4(ResetConsumerGroupOffsetTest $this, scala.collection.immutable.Map expectedOffsets$2, String topic$5, String group$4, Tuple2 x$8) {
        if (x$8 != null) {
            TopicPartition tp = (TopicPartition)x$8._1();
            Assertions.assertEquals((long)((OffsetAndMetadata)x$8._2()).offset(), (long)BoxesRunTime.unboxToLong((Object)expectedOffsets$2.apply((Object)tp)));
            Assertions.assertEquals((Object)expectedOffsets$2, $this.committedOffsets(topic$5, group$4));
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$resetAndAssertOffsetsCommitted$2(ResetConsumerGroupOffsetTest $this, scala.collection.immutable.Map expectedOffsets$2, String topic$5, Tuple2 x$9) {
        if (x$9 != null) {
            String group = (String)x$9._1();
            ((Map)x$9._2()).withFilter((Function1 & Serializable)check$ifrefutable$3 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$3 != null))).foreach((Function1 & Serializable)x$8 -> {
                ResetConsumerGroupOffsetTest.$anonfun$resetAndAssertOffsetsCommitted$4($this, expectedOffsets$2, topic$5, group, x$8);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError(null);
    }

    public ResetConsumerGroupOffsetTest() {
        this.topic1 = "foo1";
        this.topic2 = "foo2";
    }
}

