/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import kafka.cluster.Broker;
import kafka.cluster.EndPoint;
import kafka.log.LogConfig$;
import kafka.metrics.KafkaMetricsGroup;
import kafka.metrics.KafkaYammerMetrics;
import kafka.metrics.LinuxIoMetricsCollector;
import kafka.network.SocketServer;
import kafka.network.SocketServer$;
import kafka.raft.RaftManager;
import kafka.security.CredentialProvider;
import kafka.server.ControllerApis;
import kafka.server.ControllerConfigurationValidator;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaRequestHandlerPool;
import kafka.server.MetaProperties;
import kafka.server.QuotaFactory;
import kafka.server.QuotaFactory$;
import kafka.server.Server;
import kafka.server.Server$SHUTDOWN$;
import kafka.server.Server$SHUTTING_DOWN$;
import kafka.server.Server$STARTED$;
import kafka.server.Server$STARTING$;
import kafka.server.SimpleApiVersionManager;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import org.apache.kafka.common.ClusterResource;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.message.ApiMessageType;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.security.scram.internals.ScramMechanism;
import org.apache.kafka.common.security.token.delegation.internals.DelegationTokenCache;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.controller.ConfigurationValidator;
import org.apache.kafka.controller.Controller;
import org.apache.kafka.controller.ControllerMetrics;
import org.apache.kafka.controller.QuorumController;
import org.apache.kafka.controller.QuorumControllerMetrics;
import org.apache.kafka.metadata.VersionRange;
import org.apache.kafka.raft.RaftConfig;
import org.apache.kafka.server.authorizer.Authorizer;
import org.apache.kafka.server.authorizer.AuthorizerServerInfo;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.policy.AlterConfigPolicy;
import org.apache.kafka.server.policy.CreateTopicPolicy;
import org.slf4j.event.Level;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\r}a\u0001B!C\u0001\u001dC\u0001B\u0017\u0001\u0003\u0006\u0004%\ta\u0017\u0005\tA\u0002\u0011\t\u0011)A\u00059\"A\u0011\r\u0001BC\u0002\u0013\u0005!\r\u0003\u0005g\u0001\t\u0005\t\u0015!\u0003d\u0011!9\u0007A!b\u0001\n\u0003A\u0007\u0002C>\u0001\u0005\u0003\u0005\u000b\u0011B5\t\u0011q\u0004!Q1A\u0005\u0002uD\u0011\"!\u0003\u0001\u0005\u0003\u0005\u000b\u0011\u0002@\t\u0013]\u0003!Q1A\u0005\u0002\u0005-\u0001BCA\f\u0001\t\u0005\t\u0015!\u0003\u0002\u000e!Q\u0011\u0011\u0004\u0001\u0003\u0006\u0004%\t!a\u0007\t\u0015\u0005e\u0002A!A!\u0002\u0013\ti\u0002\u0003\u0006\u0002<\u0001\u0011)\u0019!C\u0001\u0003{A!\"a\"\u0001\u0005\u0003\u0005\u000b\u0011BA \u0011\u001d\tI\t\u0001C\u0001\u0003\u0017C\u0011\"!(\u0001\u0005\u0004%\t!a(\t\u0011\u00055\u0006\u0001)A\u0005\u0003CC\u0011\"a,\u0001\u0005\u0004%\t!!-\t\u0011\u0005e\u0006\u0001)A\u0005\u0003gC\u0011\"a/\u0001\u0001\u0004%\t!!0\t\u0013\u0005U\u0007\u00011A\u0005\u0002\u0005]\u0007\u0002CAr\u0001\u0001\u0006K!a0\t\u0013\u0005\u0015\b\u00011A\u0005\u0002\u0005\u001d\b\"CAx\u0001\u0001\u0007I\u0011AAy\u0011!\t)\u0010\u0001Q!\n\u0005%\b\"CA|\u0001\u0001\u0007I\u0011AA}\u0011%\u00119\u0001\u0001a\u0001\n\u0003\u0011I\u0001\u0003\u0005\u0003\u000e\u0001\u0001\u000b\u0015BA~\u0011%\u0011y\u0001\u0001a\u0001\n\u0003\u0011\t\u0002C\u0005\u0003,\u0001\u0001\r\u0011\"\u0001\u0003.!A!\u0011\u0007\u0001!B\u0013\u0011\u0019\u0002C\u0005\u00034\u0001\u0001\r\u0011\"\u0001\u00036!I!\u0011\t\u0001A\u0002\u0013\u0005!1\t\u0005\t\u0005\u000f\u0002\u0001\u0015)\u0003\u00038!I!\u0011\n\u0001A\u0002\u0013\u0005!1\n\u0005\n\u00053\u0002\u0001\u0019!C\u0001\u00057B\u0001Ba\u0018\u0001A\u0003&!Q\n\u0005\n\u0005C\u0002!\u0019!C\u0001\u0005GB\u0001Ba\u001a\u0001A\u0003%!Q\r\u0005\n\u0005S\u0002\u0001\u0019!C\u0001\u0005WB\u0011Ba\u001f\u0001\u0001\u0004%\tA! \t\u0011\t\u0005\u0005\u0001)Q\u0005\u0005[B\u0011Ba!\u0001\u0001\u0004%\tA!\"\t\u0013\t=\u0005\u00011A\u0005\u0002\tE\u0005\u0002\u0003BK\u0001\u0001\u0006KAa\"\t\u0013\t]\u0005\u00011A\u0005\u0002\te\u0005\"\u0003BS\u0001\u0001\u0007I\u0011\u0001BT\u0011!\u0011Y\u000b\u0001Q!\n\tm\u0005\"\u0003BW\u0001\t\u0007I\u0011\u0001BX\u0011!\u0011\t\r\u0001Q\u0001\n\tE\u0006\"\u0003Bb\u0001\u0001\u0007I\u0011\u0001Bc\u0011%\u0011)\u000e\u0001a\u0001\n\u0003\u00119\u000e\u0003\u0005\u0003\\\u0002\u0001\u000b\u0015\u0002Bd\u0011%\u0011i\u000e\u0001a\u0001\n\u0003\u0011y\u000eC\u0005\u0003h\u0002\u0001\r\u0011\"\u0001\u0003j\"A!Q\u001e\u0001!B\u0013\u0011\t\u000fC\u0005\u0003p\u0002\u0001\r\u0011\"\u0001\u0003r\"I!\u0011 \u0001A\u0002\u0013\u0005!1 \u0005\t\u0005\u007f\u0004\u0001\u0015)\u0003\u0003t\"91\u0011\u0001\u0001\u0005\n\r\r\u0001bBB\n\u0001\u0011\u00051Q\u0003\u0005\b\u0007/\u0001A\u0011AB\r\u0011\u001d\u0019Y\u0002\u0001C\u0001\u00073Aqa!\b\u0001\t\u0003\u0019IB\u0001\tD_:$(o\u001c7mKJ\u001cVM\u001d<fe*\u00111\tR\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003\u0015\u000bQa[1gW\u0006\u001c\u0001a\u0005\u0003\u0001\u0011:#\u0006CA%M\u001b\u0005Q%\"A&\u0002\u000bM\u001c\u0017\r\\1\n\u00055S%AB!osJ+g\r\u0005\u0002P%6\t\u0001K\u0003\u0002R\t\u0006)Q\u000f^5mg&\u00111\u000b\u0015\u0002\b\u0019><w-\u001b8h!\t)\u0006,D\u0001W\u0015\t9F)A\u0004nKR\u0014\u0018nY:\n\u0005e3&!E&bM.\fW*\u001a;sS\u000e\u001cxI]8va\u0006qQ.\u001a;b!J|\u0007/\u001a:uS\u0016\u001cX#\u0001/\u0011\u0005usV\"\u0001\"\n\u0005}\u0013%AD'fi\u0006\u0004&o\u001c9feRLWm]\u0001\u0010[\u0016$\u0018\r\u0015:pa\u0016\u0014H/[3tA\u000511m\u001c8gS\u001e,\u0012a\u0019\t\u0003;\u0012L!!\u001a\"\u0003\u0017-\u000bgm[1D_:4\u0017nZ\u0001\bG>tg-[4!\u0003-\u0011\u0018M\u001a;NC:\fw-\u001a:\u0016\u0003%\u00042A[7p\u001b\u0005Y'B\u00017E\u0003\u0011\u0011\u0018M\u001a;\n\u00059\\'a\u0003*bMRl\u0015M\\1hKJ\u0004\"\u0001]=\u000e\u0003ET!A]:\u0002\r\r|W.\\8o\u0015\t\u0019EO\u0003\u0002Fk*\u0011ao^\u0001\u0007CB\f7\r[3\u000b\u0003a\f1a\u001c:h\u0013\tQ\u0018O\u0001\u000bBa&lUm]:bO\u0016\fe\u000e\u001a,feNLwN\\\u0001\re\u00064G/T1oC\u001e,'\u000fI\u0001\u0005i&lW-F\u0001\u007f!\ry\u0018QA\u0007\u0003\u0003\u0003Q1!UA\u0002\u0015\t\u0011H/\u0003\u0003\u0002\b\u0005\u0005!\u0001\u0002+j[\u0016\fQ\u0001^5nK\u0002*\"!!\u0004\u0011\t\u0005=\u00111C\u0007\u0003\u0003#Q1aVA\u0002\u0013\u0011\t)\"!\u0005\u0003\u000f5+GO]5dg\u0006AQ.\u001a;sS\u000e\u001c\b%\u0001\tuQJ,\u0017\r\u001a(b[\u0016\u0004&/\u001a4jqV\u0011\u0011Q\u0004\t\u0006\u0013\u0006}\u00111E\u0005\u0004\u0003CQ%AB(qi&|g\u000e\u0005\u0003\u0002&\u0005Mb\u0002BA\u0014\u0003_\u00012!!\u000bK\u001b\t\tYCC\u0002\u0002.\u0019\u000ba\u0001\u0010:p_Rt\u0014bAA\u0019\u0015\u00061\u0001K]3eK\u001aLA!!\u000e\u00028\t11\u000b\u001e:j]\u001eT1!!\rK\u0003E!\bN]3bI:\u000bW.\u001a)sK\u001aL\u0007\u0010I\u0001\u001dG>tGO]8mY\u0016\u0014\u0018+^8sk64v\u000e^3sg\u001a+H/\u001e:f+\t\ty\u0004\u0005\u0004\u0002B\u0005=\u00131K\u0007\u0003\u0003\u0007RA!!\u0012\u0002H\u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\t\u0005%\u00131J\u0001\u0005kRLGN\u0003\u0002\u0002N\u0005!!.\u0019<b\u0013\u0011\t\t&a\u0011\u0003#\r{W\u000e\u001d7fi\u0006\u0014G.\u001a$viV\u0014X\r\u0005\u0005\u0002V\u0005]\u00131LA4\u001b\t\t9%\u0003\u0003\u0002Z\u0005\u001d#aA'baB!\u0011QLA2\u001b\t\tyF\u0003\u0003\u0002b\u0005-\u0013\u0001\u00027b]\u001eLA!!\u001a\u0002`\t9\u0011J\u001c;fO\u0016\u0014\b\u0003BA5\u0003\u0003sA!a\u001b\u0002|9!\u0011QNA=\u001d\u0011\ty'a\u001e\u000f\t\u0005E\u0014Q\u000f\b\u0005\u0003S\t\u0019(C\u0001y\u0013\t1x/\u0003\u0002Fk&\u0011A\u000e^\u0005\u0005\u0003{\ny(\u0001\u0006SC\u001a$8i\u001c8gS\u001eT!\u0001\u001c;\n\t\u0005\r\u0015Q\u0011\u0002\f\u0003\u0012$'/Z:t'B,7M\u0003\u0003\u0002~\u0005}\u0014!H2p]R\u0014x\u000e\u001c7feF+xN];n->$XM]:GkR,(/\u001a\u0011\u0002\rqJg.\u001b;?)A\ti)a$\u0002\u0012\u0006M\u0015QSAL\u00033\u000bY\n\u0005\u0002^\u0001!)!l\u0004a\u00019\")\u0011m\u0004a\u0001G\")qm\u0004a\u0001S\")Ap\u0004a\u0001}\"1qk\u0004a\u0001\u0003\u001bAq!!\u0007\u0010\u0001\u0004\ti\u0002C\u0004\u0002<=\u0001\r!a\u0010\u0002\t1|7m[\u000b\u0003\u0003C\u0003B!a)\u0002*6\u0011\u0011Q\u0015\u0006\u0005\u0003O\u000b\u0019%A\u0003m_\u000e\\7/\u0003\u0003\u0002,\u0006\u0015&!\u0004*fK:$(/\u00198u\u0019>\u001c7.A\u0003m_\u000e\\\u0007%A\tbo\u0006LGo\u00155vi\u0012|wO\\\"p]\u0012,\"!a-\u0011\t\u0005\r\u0016QW\u0005\u0005\u0003o\u000b)KA\u0005D_:$\u0017\u000e^5p]\u0006\u0011\u0012m^1jiNCW\u000f\u001e3po:\u001cuN\u001c3!\u0003\u0019\u0019H/\u0019;vgV\u0011\u0011q\u0018\t\u0005\u0003\u0003\fyM\u0004\u0003\u0002D\u0006-g\u0002BAc\u0003\u0013tA!!\u000b\u0002H&\tQ)\u0003\u0002D\t&\u0019\u0011Q\u001a\"\u0002\rM+'O^3s\u0013\u0011\t\t.a5\u0003\u001bA\u0013xnY3tgN#\u0018\r^;t\u0015\r\tiMQ\u0001\u000bgR\fG/^:`I\u0015\fH\u0003BAm\u0003?\u00042!SAn\u0013\r\tiN\u0013\u0002\u0005+:LG\u000fC\u0005\u0002bV\t\t\u00111\u0001\u0002@\u0006\u0019\u0001\u0010J\u0019\u0002\u000fM$\u0018\r^;tA\u00059B.\u001b8vq&{W*\u001a;sS\u000e\u001c8i\u001c7mK\u000e$xN]\u000b\u0003\u0003S\u00042!VAv\u0013\r\tiO\u0016\u0002\u0018\u0019&tW\u000f_%p\u001b\u0016$(/[2t\u0007>dG.Z2u_J\f1\u0004\\5okbLu.T3ue&\u001c7oQ8mY\u0016\u001cGo\u001c:`I\u0015\fH\u0003BAm\u0003gD\u0011\"!9\u0019\u0003\u0003\u0005\r!!;\u000211Lg.\u001e=J_6+GO]5dg\u000e{G\u000e\\3di>\u0014\b%\u0001\u0006bkRDwN]5{KJ,\"!a?\u0011\u000b%\u000by\"!@\u0011\t\u0005}(1A\u0007\u0003\u0005\u0003Q1!a>t\u0013\u0011\u0011)A!\u0001\u0003\u0015\u0005+H\u000f[8sSj,'/\u0001\bbkRDwN]5{KJ|F%Z9\u0015\t\u0005e'1\u0002\u0005\n\u0003C\\\u0012\u0011!a\u0001\u0003w\f1\"Y;uQ>\u0014\u0018N_3sA\u0005QAo\\6f]\u000e\u000b7\r[3\u0016\u0005\tM\u0001\u0003\u0002B\u000b\u0005Oi!Aa\u0006\u000b\t\te!1D\u0001\nS:$XM\u001d8bYNTAA!\b\u0003 \u0005QA-\u001a7fO\u0006$\u0018n\u001c8\u000b\t\t\u0005\"1E\u0001\u0006i>\\WM\u001c\u0006\u0005\u0005K\t\u0019!\u0001\u0005tK\u000e,(/\u001b;z\u0013\u0011\u0011ICa\u0006\u0003)\u0011+G.Z4bi&|g\u000eV8lK:\u001c\u0015m\u00195f\u00039!xn[3o\u0007\u0006\u001c\u0007.Z0%KF$B!!7\u00030!I\u0011\u0011\u001d\u0010\u0002\u0002\u0003\u0007!1C\u0001\fi>\\WM\\\"bG\",\u0007%\u0001\nde\u0016$WM\u001c;jC2\u0004&o\u001c<jI\u0016\u0014XC\u0001B\u001c!\u0011\u0011ID!\u0010\u000e\u0005\tm\"b\u0001B\u0013\t&!!q\bB\u001e\u0005I\u0019%/\u001a3f]RL\u0017\r\u001c)s_ZLG-\u001a:\u0002-\r\u0014X\rZ3oi&\fG\u000e\u0015:pm&$WM]0%KF$B!!7\u0003F!I\u0011\u0011]\u0011\u0002\u0002\u0003\u0007!qG\u0001\u0014GJ,G-\u001a8uS\u0006d\u0007K]8wS\u0012,'\u000fI\u0001\rg>\u001c7.\u001a;TKJ4XM]\u000b\u0003\u0005\u001b\u0002BAa\u0014\u0003V5\u0011!\u0011\u000b\u0006\u0004\u0005'\"\u0015a\u00028fi^|'o[\u0005\u0005\u0005/\u0012\tF\u0001\u0007T_\u000e\\W\r^*feZ,'/\u0001\tt_\u000e\\W\r^*feZ,'o\u0018\u0013fcR!\u0011\u0011\u001cB/\u0011%\t\t\u000fJA\u0001\u0002\u0004\u0011i%A\u0007t_\u000e\\W\r^*feZ,'\u000fI\u0001!g>\u001c7.\u001a;TKJ4XM\u001d$jeN$(i\\;oIB{'\u000f\u001e$viV\u0014X-\u0006\u0002\u0003fA1\u0011\u0011IA(\u00037\n\u0011e]8dW\u0016$8+\u001a:wKJ4\u0015N]:u\u0005>,h\u000e\u001a)peR4U\u000f^;sK\u0002\n\u0011c\u0019:fCR,Gk\u001c9jGB{G.[2z+\t\u0011i\u0007E\u0003J\u0003?\u0011y\u0007\u0005\u0003\u0003r\t]TB\u0001B:\u0015\r\u0011)h]\u0001\u0007a>d\u0017nY=\n\t\te$1\u000f\u0002\u0012\u0007J,\u0017\r^3U_BL7\rU8mS\u000eL\u0018!F2sK\u0006$X\rV8qS\u000e\u0004v\u000e\\5ds~#S-\u001d\u000b\u0005\u00033\u0014y\bC\u0005\u0002b&\n\t\u00111\u0001\u0003n\u0005\u00112M]3bi\u0016$v\u000e]5d!>d\u0017nY=!\u0003E\tG\u000e^3s\u0007>tg-[4Q_2L7-_\u000b\u0003\u0005\u000f\u0003R!SA\u0010\u0005\u0013\u0003BA!\u001d\u0003\f&!!Q\u0012B:\u0005E\tE\u000e^3s\u0007>tg-[4Q_2L7-_\u0001\u0016C2$XM]\"p]\u001aLw\rU8mS\u000eLx\fJ3r)\u0011\tINa%\t\u0013\u0005\u0005H&!AA\u0002\t\u001d\u0015AE1mi\u0016\u00148i\u001c8gS\u001e\u0004v\u000e\\5ds\u0002\n!bY8oiJ|G\u000e\\3s+\t\u0011Y\n\u0005\u0003\u0003\u001e\n\u0005VB\u0001BP\u0015\r\u00119\n^\u0005\u0005\u0005G\u0013yJ\u0001\u0006D_:$(o\u001c7mKJ\fabY8oiJ|G\u000e\\3s?\u0012*\u0017\u000f\u0006\u0003\u0002Z\n%\u0006\"CAq_\u0005\u0005\t\u0019\u0001BN\u0003-\u0019wN\u001c;s_2dWM\u001d\u0011\u0002#M,\b\u000f]8si\u0016$g)Z1ukJ,7/\u0006\u0002\u00032BA\u0011Q\u0005BZ\u0003G\u0011),\u0003\u0003\u0002Z\u0005]\u0002\u0003\u0002B\\\u0005{k!A!/\u000b\u0007\tmF/\u0001\u0005nKR\fG-\u0019;b\u0013\u0011\u0011yL!/\u0003\u0019Y+'o]5p]J\u000bgnZ3\u0002%M,\b\u000f]8si\u0016$g)Z1ukJ,7\u000fI\u0001\u000ecV|G/Y'b]\u0006<WM]:\u0016\u0005\t\u001d\u0007\u0003\u0002Be\u0005\u001ftA!a1\u0003L&\u0019!Q\u001a\"\u0002\u0019E+x\u000e^1GC\u000e$xN]=\n\t\tE'1\u001b\u0002\u000e#V|G/Y'b]\u0006<WM]:\u000b\u0007\t5')A\trk>$\u0018-T1oC\u001e,'o]0%KF$B!!7\u0003Z\"I\u0011\u0011\u001d\u001b\u0002\u0002\u0003\u0007!qY\u0001\u000fcV|G/Y'b]\u0006<WM]:!\u00039\u0019wN\u001c;s_2dWM]!qSN,\"A!9\u0011\u0007u\u0013\u0019/C\u0002\u0003f\n\u0013abQ8oiJ|G\u000e\\3s\u0003BL7/\u0001\nd_:$(o\u001c7mKJ\f\u0005/[:`I\u0015\fH\u0003BAm\u0005WD\u0011\"!98\u0003\u0003\u0005\rA!9\u0002\u001f\r|g\u000e\u001e:pY2,'/\u00119jg\u0002\n\u0011dY8oiJ|G\u000e\\3s\u0003BL7\u000fS1oI2,'\u000fU8pYV\u0011!1\u001f\t\u0004;\nU\u0018b\u0001B|\u0005\n92*\u00194lCJ+\u0017/^3ti\"\u000bg\u000e\u001a7feB{w\u000e\\\u0001\u001eG>tGO]8mY\u0016\u0014\u0018\t]5t\u0011\u0006tG\r\\3s!>|Gn\u0018\u0013fcR!\u0011\u0011\u001cB\u007f\u0011%\t\tOOA\u0001\u0002\u0004\u0011\u00190\u0001\u000ed_:$(o\u001c7mKJ\f\u0005/[:IC:$G.\u001a:Q_>d\u0007%A\tnCf\u0014Wm\u00115b]\u001e,7\u000b^1ukN$ba!\u0002\u0004\f\r=\u0001cA%\u0004\b%\u00191\u0011\u0002&\u0003\u000f\t{w\u000e\\3b]\"91Q\u0002\u001fA\u0002\u0005}\u0016\u0001\u00024s_6Dqa!\u0005=\u0001\u0004\ty,\u0001\u0002u_\u0006I1\r\\;ti\u0016\u0014\u0018\nZ\u000b\u0003\u0003G\tqa\u001d;beR,\b\u000f\u0006\u0002\u0002Z\u0006A1\u000f[;uI><h.A\u0007bo\u0006LGo\u00155vi\u0012|wO\u001c")
public class ControllerServer
implements KafkaMetricsGroup {
    private final MetaProperties metaProperties;
    private final KafkaConfig config;
    private final RaftManager<ApiMessageAndVersion> raftManager;
    private final Time time;
    private final Metrics metrics;
    private final Option<String> threadNamePrefix;
    private final CompletableFuture<java.util.Map<Integer, RaftConfig.AddressSpec>> controllerQuorumVotersFuture;
    private final ReentrantLock lock;
    private final Condition awaitShutdownCond;
    private Server.ProcessStatus status;
    private LinuxIoMetricsCollector linuxIoMetricsCollector;
    private Option<Authorizer> authorizer;
    private DelegationTokenCache tokenCache;
    private CredentialProvider credentialProvider;
    private SocketServer socketServer;
    private final CompletableFuture<Integer> socketServerFirstBoundPortFuture;
    private Option<CreateTopicPolicy> createTopicPolicy;
    private Option<AlterConfigPolicy> alterConfigPolicy;
    private Controller controller;
    private final scala.collection.immutable.Map<String, VersionRange> supportedFeatures;
    private QuotaFactory.QuotaManagers quotaManagers;
    private ControllerApis controllerApis;
    private KafkaRequestHandlerPool controllerApisHandlerPool;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public MetaProperties metaProperties() {
        return this.metaProperties;
    }

    public KafkaConfig config() {
        return this.config;
    }

    public RaftManager<ApiMessageAndVersion> raftManager() {
        return this.raftManager;
    }

    public Time time() {
        return this.time;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public Option<String> threadNamePrefix() {
        return this.threadNamePrefix;
    }

    public CompletableFuture<java.util.Map<Integer, RaftConfig.AddressSpec>> controllerQuorumVotersFuture() {
        return this.controllerQuorumVotersFuture;
    }

    public ReentrantLock lock() {
        return this.lock;
    }

    public Condition awaitShutdownCond() {
        return this.awaitShutdownCond;
    }

    public Server.ProcessStatus status() {
        return this.status;
    }

    public void status_$eq(Server.ProcessStatus x$1) {
        this.status = x$1;
    }

    public LinuxIoMetricsCollector linuxIoMetricsCollector() {
        return this.linuxIoMetricsCollector;
    }

    public void linuxIoMetricsCollector_$eq(LinuxIoMetricsCollector x$1) {
        this.linuxIoMetricsCollector = x$1;
    }

    public Option<Authorizer> authorizer() {
        return this.authorizer;
    }

    public void authorizer_$eq(Option<Authorizer> x$1) {
        this.authorizer = x$1;
    }

    public DelegationTokenCache tokenCache() {
        return this.tokenCache;
    }

    public void tokenCache_$eq(DelegationTokenCache x$1) {
        this.tokenCache = x$1;
    }

    public CredentialProvider credentialProvider() {
        return this.credentialProvider;
    }

    public void credentialProvider_$eq(CredentialProvider x$1) {
        this.credentialProvider = x$1;
    }

    public SocketServer socketServer() {
        return this.socketServer;
    }

    public void socketServer_$eq(SocketServer x$1) {
        this.socketServer = x$1;
    }

    public CompletableFuture<Integer> socketServerFirstBoundPortFuture() {
        return this.socketServerFirstBoundPortFuture;
    }

    public Option<CreateTopicPolicy> createTopicPolicy() {
        return this.createTopicPolicy;
    }

    public void createTopicPolicy_$eq(Option<CreateTopicPolicy> x$1) {
        this.createTopicPolicy = x$1;
    }

    public Option<AlterConfigPolicy> alterConfigPolicy() {
        return this.alterConfigPolicy;
    }

    public void alterConfigPolicy_$eq(Option<AlterConfigPolicy> x$1) {
        this.alterConfigPolicy = x$1;
    }

    public Controller controller() {
        return this.controller;
    }

    public void controller_$eq(Controller x$1) {
        this.controller = x$1;
    }

    public scala.collection.immutable.Map<String, VersionRange> supportedFeatures() {
        return this.supportedFeatures;
    }

    public QuotaFactory.QuotaManagers quotaManagers() {
        return this.quotaManagers;
    }

    public void quotaManagers_$eq(QuotaFactory.QuotaManagers x$1) {
        this.quotaManagers = x$1;
    }

    public ControllerApis controllerApis() {
        return this.controllerApis;
    }

    public void controllerApis_$eq(ControllerApis x$1) {
        this.controllerApis = x$1;
    }

    public KafkaRequestHandlerPool controllerApisHandlerPool() {
        return this.controllerApisHandlerPool;
    }

    public void controllerApisHandlerPool_$eq(KafkaRequestHandlerPool x$1) {
        this.controllerApisHandlerPool = x$1;
    }

    private boolean maybeChangeStatus(Server.ProcessStatus from, Server.ProcessStatus to) {
        block8: {
            boolean bl;
            block7: {
                this.lock().lock();
                try {
                    Server.ProcessStatus processStatus = this.status();
                    if (processStatus == null ? from != null : !processStatus.equals(from)) {
                        bl = false;
                        break block7;
                    }
                    this.status_$eq(to);
                    Server.ProcessStatus processStatus2 = to;
                    Server$SHUTDOWN$ server$SHUTDOWN$ = Server$SHUTDOWN$.MODULE$;
                    if (processStatus2 == null) {
                    } else if (processStatus2.equals(server$SHUTDOWN$)) {
                        this.awaitShutdownCond().signalAll();
                    }
                    break block8;
                }
                finally {
                    this.lock().unlock();
                }
            }
            return bl;
        }
        return true;
    }

    public String clusterId() {
        return this.metaProperties().clusterId().toString();
    }

    public void startup() {
        if (!this.maybeChangeStatus(Server$SHUTDOWN$.MODULE$, Server$STARTING$.MODULE$)) {
            return;
        }
        try {
            scala.collection.immutable.Map map;
            this.info((Function0<String>)(Function0 & Serializable)() -> "Starting controller");
            this.maybeChangeStatus(Server$STARTING$.MODULE$, Server$STARTED$.MODULE$);
            this.logIdent_$eq(new LogContext(new StringBuilder(23).append("[ControllerServer id=").append(this.config().nodeId()).append("] ").toString()).logPrefix());
            this.newGauge("ClusterId", new Gauge<String>(this){
                private final /* synthetic */ ControllerServer $outer;

                public final String value() {
                    ControllerServer controllerServer = this.$outer;
                    if (controllerServer == null) {
                        throw null;
                    }
                    return controllerServer.clusterId();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, this.newGauge$default$3());
            this.newGauge("yammer-metrics-count", new Gauge<Object>(this){
                private final /* synthetic */ ControllerServer $outer;

                public final int value() {
                    return ControllerServer.kafka$server$ControllerServer$$$anonfun$startup$4();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, this.newGauge$default$3());
            this.linuxIoMetricsCollector_$eq(new LinuxIoMetricsCollector("/proc", this.time(), this.logger().underlying()));
            if (this.linuxIoMetricsCollector().usable()) {
                this.newGauge("linux-disk-read-bytes", new Gauge<Object>(this){
                    private final /* synthetic */ ControllerServer $outer;

                    public final long value() {
                        return this.$outer.kafka$server$ControllerServer$$$anonfun$startup$6();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, this.newGauge$default$3());
                this.newGauge("linux-disk-write-bytes", new Gauge<Object>(this){
                    private final /* synthetic */ ControllerServer $outer;

                    public final long value() {
                        return this.$outer.kafka$server$ControllerServer$$$anonfun$startup$8();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, this.newGauge$default$3());
            }
            List javaListeners = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)this.config().controllerListeners().map((Function1 & Serializable)x$1 -> x$1.toJava())).asJava();
            this.authorizer_$eq(this.config().authorizer());
            this.authorizer().foreach((Function1 & Serializable)x$2 -> {
                x$2.configure(this.config().originals());
                return BoxedUnit.UNIT;
            });
            Option<Authorizer> option = this.authorizer();
            if (option instanceof Some) {
                Authorizer authZ = (Authorizer)((Some)option).value();
                Broker.ServerInfo controllerAuthorizerInfo = new Broker.ServerInfo(new ClusterResource(this.clusterId()), this.config().nodeId(), javaListeners, (Endpoint)javaListeners.get(0));
                map = CollectionConverters$.MODULE$.MapHasAsScala(authZ.start((AuthorizerServerInfo)controllerAuthorizerInfo)).asScala().map((Function1 & Serializable)x0$1 -> {
                    if (x0$1 == null) {
                        throw new MatchError(null);
                    }
                    Endpoint ep = (Endpoint)x0$1._1();
                    CompletionStage cs = (CompletionStage)x0$1._2();
                    Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ep), cs.toCompletableFuture());
                    return tuple2;
                }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            } else if (None$.MODULE$.equals(option)) {
                map = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(javaListeners).asScala().map((Function1 & Serializable)ep -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(ep), CompletableFuture.completedFuture(null)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            } else {
                throw new MatchError(option);
            }
            SimpleApiVersionManager apiVersionManager = new SimpleApiVersionManager(ApiMessageType.ListenerType.CONTROLLER);
            this.tokenCache_$eq(new DelegationTokenCache(ScramMechanism.mechanismNames()));
            this.credentialProvider_$eq(new CredentialProvider(ScramMechanism.mechanismNames(), this.tokenCache()));
            this.socketServer_$eq(new SocketServer(this.config(), this.metrics(), this.time(), this.credentialProvider(), apiVersionManager));
            this.socketServer().startup(false, (Option<EndPoint>)None$.MODULE$, this.config().controllerListeners());
            if (!this.config().controllerListeners().nonEmpty()) {
                throw new ConfigException("No controller.listener.names defined for controller");
            }
            this.socketServerFirstBoundPortFuture().complete(Predef$.MODULE$.int2Integer(this.socketServer().boundPort(((EndPoint)this.config().controllerListeners().head()).listenerName())));
            java.util.Map configDefs = CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ConfigResource.Type.BROKER), (Object)KafkaConfig$.MODULE$.configDef()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ConfigResource.Type.TOPIC), (Object)LogConfig$.MODULE$.configDefCopy())}))).asJava();
            String threadNamePrefixAsString = (String)this.threadNamePrefix().getOrElse((Function0 & Serializable)() -> "");
            this.createTopicPolicy_$eq((Option<CreateTopicPolicy>)Option$.MODULE$.apply(this.config().getConfiguredInstance(KafkaConfig$.MODULE$.CreateTopicPolicyClassNameProp(), CreateTopicPolicy.class)));
            this.alterConfigPolicy_$eq((Option<AlterConfigPolicy>)Option$.MODULE$.apply(this.config().getConfiguredInstance(KafkaConfig$.MODULE$.AlterConfigPolicyClassNameProp(), AlterConfigPolicy.class)));
            this.controller_$eq((Controller)new QuorumController.Builder(this.config().nodeId()).setTime(this.time()).setThreadNamePrefix(threadNamePrefixAsString).setConfigDefs(configDefs).setRaftClient(this.raftManager().client()).setDefaultReplicationFactor((short)this.config().defaultReplicationFactor()).setDefaultNumPartitions(this.config().numPartitions().intValue()).setSessionTimeoutNs(TimeUnit.NANOSECONDS.convert(this.config().brokerSessionTimeoutMs(), TimeUnit.MILLISECONDS)).setSnapshotMaxNewRecordBytes(Predef$.MODULE$.Long2long(this.config().metadataSnapshotMaxNewRecordBytes())).setMetrics((ControllerMetrics)new QuorumControllerMetrics(KafkaYammerMetrics.defaultRegistry())).setCreateTopicPolicy(OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(this.createTopicPolicy()))).setAlterConfigPolicy(OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(this.alterConfigPolicy()))).setConfigurationValidator((ConfigurationValidator)new ControllerConfigurationValidator()).build());
            this.quotaManagers_$eq(QuotaFactory$.MODULE$.instantiate(this.config(), this.metrics(), this.time(), (String)this.threadNamePrefix().getOrElse((Function0 & Serializable)() -> "")));
            Buffer controllerNodes = CollectionConverters$.MODULE$.ListHasAsScala(RaftConfig.voterConnectionsToNodes(this.controllerQuorumVotersFuture().get())).asScala();
            this.controllerApis_$eq(new ControllerApis(this.socketServer().dataPlaneRequestChannel(), this.authorizer(), this.quotaManagers(), this.time(), this.supportedFeatures(), this.controller(), this.raftManager(), this.config(), this.metaProperties(), (scala.collection.immutable.Seq<Node>)controllerNodes.toSeq(), apiVersionManager));
            this.controllerApisHandlerPool_$eq(new KafkaRequestHandlerPool(this.config().nodeId(), this.socketServer().dataPlaneRequestChannel(), this.controllerApis(), this.time(), Predef$.MODULE$.Integer2int(this.config().numIoThreads()), new StringBuilder(28).append(SocketServer$.MODULE$.DataPlaneMetricPrefix()).append("RequestHandlerAvgIdlePercent").toString(), SocketServer$.MODULE$.DataPlaneThreadPrefix()));
            this.socketServer().startProcessingRequests((Map<Endpoint, CompletableFuture<Void>>)map);
            return;
        }
        catch (Throwable e) {
            this.maybeChangeStatus(Server$STARTING$.MODULE$, Server$STARTED$.MODULE$);
            this.fatal((Function0<String>)(Function0 & Serializable)() -> "Fatal error during controller startup. Prepare to shutdown", (Function0<Throwable>)(Function0 & Serializable)() -> e);
            this.shutdown();
            throw e;
        }
    }

    public void shutdown() {
        if (!this.maybeChangeStatus(Server$STARTED$.MODULE$, Server$SHUTTING_DOWN$.MODULE$)) {
            return;
        }
        try {
            try {
                this.info((Function0<String>)(Function0 & Serializable)() -> "shutting down");
                if (this.socketServer() != null) {
                    CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.socketServer().stopProcessingRequests(), this, Level.WARN);
                }
                if (this.controller() != null) {
                    this.controller().beginShutdown();
                }
                if (this.socketServer() != null) {
                    CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.socketServer().shutdown(), this, Level.WARN);
                }
                if (this.controllerApisHandlerPool() != null) {
                    CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.controllerApisHandlerPool().shutdown(), this, Level.WARN);
                }
                if (this.controllerApis() != null) {
                    CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.controllerApis().close(), this, Level.WARN);
                }
                if (this.quotaManagers() != null) {
                    CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.quotaManagers().shutdown(), this, Level.WARN);
                }
                if (this.controller() != null) {
                    this.controller().close();
                }
                this.createTopicPolicy().foreach((Function1 & Serializable)policy -> {
                    CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> policy.close(), this, Level.WARN);
                    return BoxedUnit.UNIT;
                });
                this.alterConfigPolicy().foreach((Function1 & Serializable)policy -> {
                    CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> policy.close(), this, Level.WARN);
                    return BoxedUnit.UNIT;
                });
                this.socketServerFirstBoundPortFuture().completeExceptionally(new RuntimeException("shutting down"));
            }
            catch (Throwable e) {
                this.fatal((Function0<String>)(Function0 & Serializable)() -> "Fatal error during controller shutdown.", (Function0<Throwable>)(Function0 & Serializable)() -> e);
                throw e;
            }
        }
        finally {
            this.maybeChangeStatus(Server$SHUTTING_DOWN$.MODULE$, Server$SHUTDOWN$.MODULE$);
        }
    }

    public void awaitShutdown() {
        this.lock().lock();
        try {
            while (true) {
                Server.ProcessStatus processStatus = this.status();
                Server$SHUTDOWN$ server$SHUTDOWN$ = Server$SHUTDOWN$.MODULE$;
                if (processStatus == null || !processStatus.equals(server$SHUTDOWN$)) {
                    this.awaitShutdownCond().awaitUninterruptibly();
                    continue;
                }
                break;
            }
        }
        finally {
            this.lock().unlock();
        }
    }

    public final /* synthetic */ String kafka$server$ControllerServer$$$anonfun$startup$2() {
        return this.clusterId();
    }

    public static final /* synthetic */ int kafka$server$ControllerServer$$$anonfun$startup$4() {
        return KafkaYammerMetrics.defaultRegistry().allMetrics().size();
    }

    public final /* synthetic */ long kafka$server$ControllerServer$$$anonfun$startup$6() {
        return this.linuxIoMetricsCollector().readBytes();
    }

    public final /* synthetic */ long kafka$server$ControllerServer$$$anonfun$startup$8() {
        return this.linuxIoMetricsCollector().writeBytes();
    }

    public ControllerServer(MetaProperties metaProperties, KafkaConfig config, RaftManager<ApiMessageAndVersion> raftManager, Time time, Metrics metrics, Option<String> threadNamePrefix, CompletableFuture<java.util.Map<Integer, RaftConfig.AddressSpec>> controllerQuorumVotersFuture) {
        this.metaProperties = metaProperties;
        this.config = config;
        this.raftManager = raftManager;
        this.time = time;
        this.metrics = metrics;
        this.threadNamePrefix = threadNamePrefix;
        this.controllerQuorumVotersFuture = controllerQuorumVotersFuture;
        this.lock = new ReentrantLock();
        this.awaitShutdownCond = this.lock().newCondition();
        this.status = Server$SHUTDOWN$.MODULE$;
        this.linuxIoMetricsCollector = null;
        this.authorizer = null;
        this.tokenCache = null;
        this.credentialProvider = null;
        this.socketServer = null;
        this.socketServerFirstBoundPortFuture = new CompletableFuture();
        this.createTopicPolicy = None$.MODULE$;
        this.alterConfigPolicy = None$.MODULE$;
        this.controller = null;
        this.supportedFeatures = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        this.quotaManagers = null;
        this.controllerApis = null;
        this.controllerApisHandlerPool = null;
    }
}

