/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.stream.Stream;
import kafka.api.ConsumerTopicCreationTest$;
import kafka.api.IntegrationTestHarness;
import kafka.server.KafkaConfig$;
import kafka.utils.EmptyTestInfo;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0005\u0005%b\u0001\u0002\u000f\u001e\u0001\tBQ!\u000b\u0001\u0005\u0002)BQ!\f\u0001\u0005\u00029BQA\u0016\u0001\u0005\u0002];Q!X\u000f\t\u0002y3Q\u0001H\u000f\t\u0002}CQ!K\u0003\u0005\u0002\u00014A!Y\u0003\u0005E\"A1g\u0002B\u0001B\u0003%A\u0007\u0003\u0005>\u000f\t\u0005\t\u0015!\u00035\u0011\u0019Is\u0001\"\u0001\u0002\u0002!)\u0011p\u0002C)u\"9\u0011\u0011B\u0004\u0005B\u0005-a\u0001B3\u0006\t\u0019D\u0001bM\u0007\u0003\u0002\u0003\u0006I\u0001\u000e\u0005\t{5\u0011\t\u0011)A\u0005i!)\u0011&\u0004C\u0001U\"9Q.\u0004b\u0001\n\u0013q\u0007B\u0002:\u000eA\u0003%q\u000eC\u0004t\u001b\t\u0007I\u0011\u00028\t\rQl\u0001\u0015!\u0003p\u0011\u001d)XB1A\u0005\n9DaA^\u0007!\u0002\u0013y\u0007bB<\u000e\u0005\u0004%IA\u001c\u0005\u0007q6\u0001\u000b\u0011B8\t\u000belA\u0011\u000b>\t\u000bylA\u0011A@\t\rA+A\u0011AA\t\u0005e\u0019uN\\:v[\u0016\u0014Hk\u001c9jG\u000e\u0013X-\u0019;j_:$Vm\u001d;\u000b\u0005yy\u0012aA1qS*\t\u0001%A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001\u0019\u0003C\u0001\u0013(\u001b\u0005)#\"\u0001\u0014\u0002\u000bM\u001c\u0017\r\\1\n\u0005!*#AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002WA\u0011A\u0006A\u0007\u0002;\u0005)B/Z:u\u0003V$x\u000eV8qS\u000e\u001c%/Z1uS>tGcA\u00183yA\u0011A\u0005M\u0005\u0003c\u0015\u0012A!\u00168ji\")1G\u0001a\u0001i\u0005i\"M]8lKJ\fU\u000f^8U_BL7m\u0011:fCRLwN\\#oC\ndW\r\u0005\u00026u5\taG\u0003\u00028q\u0005!A.\u00198h\u0015\u0005I\u0014\u0001\u00026bm\u0006L!a\u000f\u001c\u0003\u000f\t{w\u000e\\3b]\")QH\u0001a\u0001i\u0005i2m\u001c8tk6,'/\u00117m_^\fU\u000f^8De\u0016\fG/\u001a+pa&\u001c7\u000f\u000b\u0003\u0003\u007f5s\u0005C\u0001!L\u001b\u0005\t%B\u0001\"D\u0003!\u0001(o\u001c<jI\u0016\u0014(B\u0001#F\u0003\u0019\u0001\u0018M]1ng*\u0011aiR\u0001\bUV\u0004\u0018\u000e^3s\u0015\tA\u0015*A\u0003kk:LGOC\u0001K\u0003\ry'oZ\u0005\u0003\u0019\u0006\u0013A\"T3uQ>$7k\\;sG\u0016\fQA^1mk\u0016d\u0013aT\u0011\u0002!\u0006Q\u0001/\u0019:b[\u0016$XM]:)\u0005\t\u0011\u0006CA*U\u001b\u0005\u0019\u0015BA+D\u0005E\u0001\u0016M]1nKR,'/\u001b>fIR+7\u000f^\u0001$i\u0016\u001cH/Q;u_R{\u0007/[2De\u0016\fG/[8o/&$\bNR8so\u0006\u0014H-\u001b8h)\ry\u0003,\u0017\u0005\u0006g\r\u0001\r\u0001\u000e\u0005\u0006{\r\u0001\r\u0001\u000e\u0015\u0005\u0007}j5\fL\u0001PQ\t\u0019!+A\rD_:\u001cX/\\3s)>\u0004\u0018nY\"sK\u0006$\u0018n\u001c8UKN$\bC\u0001\u0017\u0006'\t)1\u0005F\u0001_\u0005Y!Vm\u001d;DCN,w+\u001b;i\r>\u0014x/\u0019:eS:<7CA\u0004d!\t!W\"D\u0001\u0006\u0005!!Vm\u001d;DCN,7CA\u0007h!\ta\u0003.\u0003\u0002j;\t1\u0012J\u001c;fOJ\fG/[8o)\u0016\u001cH\u000fS1s]\u0016\u001c8\u000fF\u0002dW2DQa\r\tA\u0002QBQ!\u0010\tA\u0002Q\nq\u0001^8qS\u000e|\u0016'F\u0001p!\t)\u0004/\u0003\u0002rm\t11\u000b\u001e:j]\u001e\f\u0001\u0002^8qS\u000e|\u0016\u0007I\u0001\bi>\u0004\u0018nY03\u0003!!x\u000e]5d?J\u0002\u0013\u0001\u00059s_\u0012,8-\u001a:DY&,g\u000e^%e\u0003E\u0001(o\u001c3vG\u0016\u00148\t\\5f]RLE\rI\u0001\u0011G>t7/^7fe\u000ec\u0017.\u001a8u\u0013\u0012\f\u0011cY8ogVlWM]\"mS\u0016tG/\u00133!\u0003-\u0011'o\\6fe\u000e{WO\u001c;\u0016\u0003m\u0004\"\u0001\n?\n\u0005u,#aA%oi\u0006!A/Z:u)\u0005yCCBA\u0002\u0003\u000b\t9\u0001\u0005\u0002e\u000f!)1G\u0003a\u0001i!)QH\u0003a\u0001i\u0005\u0001RM\\1cY\u00164uN]<be\u0012LgnZ\u000b\u0003\u0003\u001b\u00012\u0001JA\b\u0013\tYT%\u0006\u0002\u0002\u0014A1\u0011QCA\u0010\u0003Gi!!a\u0006\u000b\t\u0005e\u00111D\u0001\u0007gR\u0014X-Y7\u000b\u0007\u0005u\u0001(\u0001\u0003vi&d\u0017\u0002BA\u0011\u0003/\u0011aa\u0015;sK\u0006l\u0007c\u0001!\u0002&%\u0019\u0011qE!\u0003\u0013\u0005\u0013x-^7f]R\u001c\b")
public class ConsumerTopicCreationTest {
    public static Stream<Arguments> parameters() {
        return ConsumerTopicCreationTest$.MODULE$.parameters();
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    public void testAutoTopicCreation(Boolean brokerAutoTopicCreationEnable, Boolean consumerAllowAutoCreateTopics) {
        TestCase testCase = new TestCase(brokerAutoTopicCreationEnable, consumerAllowAutoCreateTopics);
        testCase.setUp(new EmptyTestInfo());
        try {
            testCase.test();
        }
        finally {
            testCase.tearDown();
        }
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    public void testAutoTopicCreationWithForwarding(Boolean brokerAutoTopicCreationEnable, Boolean consumerAllowAutoCreateTopics) {
        TestCaseWithForwarding testCase = new TestCaseWithForwarding(brokerAutoTopicCreationEnable, consumerAllowAutoCreateTopics);
        testCase.setUp(new EmptyTestInfo());
        try {
            testCase.test();
        }
        finally {
            testCase.tearDown();
        }
    }

    private static class TestCase
    extends IntegrationTestHarness {
        private final Boolean brokerAutoTopicCreationEnable;
        private final Boolean consumerAllowAutoCreateTopics;
        private final String topic_1;
        private final String topic_2;
        private final String producerClientId;
        private final String consumerClientId;

        private String topic_1() {
            return this.topic_1;
        }

        private String topic_2() {
            return this.topic_2;
        }

        private String producerClientId() {
            return this.producerClientId;
        }

        private String consumerClientId() {
            return this.consumerClientId;
        }

        @Override
        public int brokerCount() {
            return 1;
        }

        public void test() {
            KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
            KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
            Admin adminClient = this.createAdminClient(this.createAdminClient$default$1());
            ProducerRecord record = new ProducerRecord(this.topic_1(), Predef$.MODULE$.int2Integer(0), (Object)"key".getBytes(), (Object)"value".getBytes());
            adminClient.createTopics(Collections.singleton(new NewTopic(this.topic_1(), 1, (short)1))).all().get();
            producer.send(record).get();
            consumer.subscribe(Arrays.asList(this.topic_1(), this.topic_2()));
            long l = 15000L;
            long l2 = 100L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!TestCase.$anonfun$test$1(consumer)) {
                if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                    Assertions.fail((String)"Timed out waiting to consume");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
            }
            KafkaZkClient qual$1 = this.zkClient();
            boolean x$1 = qual$1.getAllTopicsInCluster$default$1();
            boolean topicCreated = qual$1.getAllTopicsInCluster(x$1).contains((Object)this.topic_2());
            if (Predef$.MODULE$.Boolean2boolean(this.brokerAutoTopicCreationEnable) && Predef$.MODULE$.Boolean2boolean(this.consumerAllowAutoCreateTopics)) {
                Assertions.assertTrue((boolean)topicCreated);
                return;
            }
            Assertions.assertFalse((boolean)topicCreated);
        }

        public static final /* synthetic */ boolean $anonfun$test$1(KafkaConsumer consumer$1) {
            return consumer$1.poll(Duration.ofMillis(100L)).count() > 0;
        }

        public static final /* synthetic */ String $anonfun$test$2() {
            return "Timed out waiting to consume";
        }

        public TestCase(Boolean brokerAutoTopicCreationEnable, Boolean consumerAllowAutoCreateTopics) {
            this.brokerAutoTopicCreationEnable = brokerAutoTopicCreationEnable;
            this.consumerAllowAutoCreateTopics = consumerAllowAutoCreateTopics;
            this.topic_1 = "topic-1";
            this.topic_2 = "topic-2";
            this.producerClientId = "ConsumerTestProducer";
            this.consumerClientId = "ConsumerTestConsumer";
            this.serverConfig().setProperty(KafkaConfig$.MODULE$.ControlledShutdownEnableProp(), "false");
            this.serverConfig().setProperty(KafkaConfig$.MODULE$.AutoCreateTopicsEnableProp(), brokerAutoTopicCreationEnable.toString());
            this.producerConfig().setProperty("client.id", this.producerClientId());
            this.consumerConfig().setProperty("client.id", this.consumerClientId());
            this.consumerConfig().setProperty("group.id", "my-test");
            this.consumerConfig().setProperty("auto.offset.reset", "earliest");
            this.consumerConfig().setProperty("enable.auto.commit", "false");
            this.consumerConfig().setProperty("metadata.max.age.ms", "100");
            this.consumerConfig().setProperty("allow.auto.create.topics", consumerAllowAutoCreateTopics.toString());
        }
    }

    private static class TestCaseWithForwarding
    extends TestCase {
        @Override
        public int brokerCount() {
            return 3;
        }

        @Override
        public boolean enableForwarding() {
            return true;
        }

        public TestCaseWithForwarding(Boolean brokerAutoTopicCreationEnable, Boolean consumerAllowAutoCreateTopics) {
            super(brokerAutoTopicCreationEnable, consumerAllowAutoCreateTopics);
        }
    }
}

