/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import kafka.server.ControllerConfigurationValidator;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005=2AAB\u0004\u0001\u0019!)1\u0003\u0001C\u0001)!)q\u0003\u0001C\u00011!)\u0011\u0006\u0001C\u00011!)1\u0006\u0001C\u00011!)Q\u0006\u0001C\u00011\t!3i\u001c8ue>dG.\u001a:D_:4\u0017nZ;sCRLwN\u001c,bY&$\u0017\r^8s)\u0016\u001cHO\u0003\u0002\t\u0013\u000511/\u001a:wKJT\u0011AC\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001Q\u0002\u0005\u0002\u000f#5\tqBC\u0001\u0011\u0003\u0015\u00198-\u00197b\u0013\t\u0011rB\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003U\u0001\"A\u0006\u0001\u000e\u0003\u001d\tq\u0003^3tiVs7N\\8x]J+7o\\;sG\u0016$\u0016\u0010]3\u0015\u0003e\u0001\"A\u0004\u000e\n\u0005my!\u0001B+oSRD#AA\u000f\u0011\u0005y9S\"A\u0010\u000b\u0005\u0001\n\u0013aA1qS*\u0011!eI\u0001\bUV\u0004\u0018\u000e^3s\u0015\t!S%A\u0003kk:LGOC\u0001'\u0003\ry'oZ\u0005\u0003Q}\u0011A\u0001V3ti\u0006AB/Z:u\u001dVdG\u000eV8qS\u000e\u001cuN\u001c4jOZ\u000bG.^3)\u0005\ri\u0012\u0001\u0006;fgR4\u0016\r\\5e)>\u0004\u0018nY\"p]\u001aLw\r\u000b\u0002\u0005;\u00051B/Z:u\u0013:4\u0018\r\\5e)>\u0004\u0018nY\"p]\u001aLw\r\u000b\u0002\u0006;\u0001")
public class ControllerConfigurationValidatorTest {
    @Test
    public void testUnknownResourceType() {
        ControllerConfigurationValidator validator = new ControllerConfigurationValidator();
        Assertions.assertEquals((Object)"Unknown resource type BROKER_LOGGER", (Object)Assertions.assertThrows(InvalidRequestException.class, () -> validator.validate(new ConfigResource(ConfigResource.Type.BROKER_LOGGER, "foo"), Collections.emptyMap())).getMessage());
    }

    @Test
    public void testNullTopicConfigValue() {
        ControllerConfigurationValidator validator = new ControllerConfigurationValidator();
        TreeMap<String, String> config = new TreeMap<String, String>();
        config.put("segment.jitter.ms", "10");
        config.put("segment.bytes", null);
        config.put("segment.ms", null);
        Assertions.assertEquals((Object)"Null value not supported for topic configs : segment.bytes,segment.ms", (Object)Assertions.assertThrows(InvalidRequestException.class, () -> validator.validate(new ConfigResource(ConfigResource.Type.TOPIC, "foo"), (Map)config)).getMessage());
    }

    @Test
    public void testValidTopicConfig() {
        ControllerConfigurationValidator validator = new ControllerConfigurationValidator();
        TreeMap<String, String> config = new TreeMap<String, String>();
        config.put("segment.jitter.ms", "1000");
        config.put("segment.bytes", "67108864");
        validator.validate(new ConfigResource(ConfigResource.Type.TOPIC, "foo"), config);
    }

    @Test
    public void testInvalidTopicConfig() {
        ControllerConfigurationValidator validator = new ControllerConfigurationValidator();
        TreeMap<String, String> config = new TreeMap<String, String>();
        config.put("segment.jitter.ms", "1000");
        config.put("segment.bytes", "67108864");
        config.put("foobar", "abc");
        Assertions.assertEquals((Object)"Unknown topic config name: foobar", (Object)Assertions.assertThrows(InvalidConfigurationException.class, () -> validator.validate(new ConfigResource(ConfigResource.Type.TOPIC, "foo"), (Map)config)).getMessage());
    }
}

