/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.File;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import kafka.log.AbstractLogCleanerIntegrationTest;
import kafka.log.LogCleaner;
import kafka.log.LogCleanerManager$;
import kafka.log.LogSegment;
import kafka.log.UnifiedLog;
import kafka.metrics.KafkaMetricsGroup;
import kafka.metrics.KafkaYammerMetrics;
import kafka.utils.Logging;
import kafka.utils.MockTime;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArraySeq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0005\u0005Ee\u0001B\t\u0013\u0001]AQA\t\u0001\u0005\u0002\rBq!\n\u0001C\u0002\u0013\u0005a\u0005\u0003\u00045\u0001\u0001\u0006Ia\n\u0005\bk\u0001\u0011\r\u0011\"\u00017\u0011\u0019i\u0004\u0001)A\u0005o!9a\b\u0001b\u0001\n\u0003y\u0004B\u0002&\u0001A\u0003%\u0001\tC\u0003L\u0001\u0011\u0005A\nC\u0003\\\u0001\u0011\u0005A\nC\u0003a\u0001\u0011%\u0011\r\u0003\u0004a\u0001\u0011%\u0011\u0011\u0002\u0005\u0007A\u0002!I!!\f\t\r\u0005u\u0002\u0001\"\u0001M\u0011\u001d\t\t\u0005\u0001C\u0005\u0003\u0007Bq!!\u001a\u0001\t\u0013\t9\u0007\u0003\u0004\u0002\u000e\u0002!\t\u0001\u0014\u0002\u001a\u0019><7\t\\3b]\u0016\u0014\u0018J\u001c;fOJ\fG/[8o)\u0016\u001cHO\u0003\u0002\u0014)\u0005\u0019An\\4\u000b\u0003U\tQa[1gW\u0006\u001c\u0001aE\u0002\u00011q\u0001\"!\u0007\u000e\u000e\u0003II!a\u0007\n\u0003C\u0005\u00137\u000f\u001e:bGRdunZ\"mK\u0006tWM]%oi\u0016<'/\u0019;j_:$Vm\u001d;\u0011\u0005u\u0001S\"\u0001\u0010\u000b\u0005}!\u0012aB7fiJL7m]\u0005\u0003Cy\u0011\u0011cS1gW\u0006lU\r\u001e:jGN<%o\\;q\u0003\u0019a\u0014N\\5u}Q\tA\u0005\u0005\u0002\u001a\u0001\u0005)1m\u001c3fGV\tq\u0005\u0005\u0002)e5\t\u0011F\u0003\u0002+W\u00051!/Z2pe\u0012T!\u0001L\u0017\u0002\r\r|W.\\8o\u0015\t)bF\u0003\u00020a\u00051\u0011\r]1dQ\u0016T\u0011!M\u0001\u0004_J<\u0017BA\u001a*\u0005=\u0019u.\u001c9sKN\u001c\u0018n\u001c8UsB,\u0017AB2pI\u0016\u001c\u0007%\u0001\u0003uS6,W#A\u001c\u0011\u0005aZT\"A\u001d\u000b\u0005i\"\u0012!B;uS2\u001c\u0018B\u0001\u001f:\u0005!iunY6US6,\u0017!\u0002;j[\u0016\u0004\u0013a\u0004;pa&\u001c\u0007+\u0019:uSRLwN\\:\u0016\u0003\u0001\u00032!\u0011#G\u001b\u0005\u0011%\"A\"\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0015\u0013%!B!se\u0006L\bCA$I\u001b\u0005Y\u0013BA%,\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\f\u0001\u0003^8qS\u000e\u0004\u0016M\u001d;ji&|gn\u001d\u0011\u0002\u000f\rdW-\u00198vaR\tQ\n\u0005\u0002B\u001d&\u0011qJ\u0011\u0002\u0005+:LG\u000f\u000b\u0002\t#B\u0011!+W\u0007\u0002'*\u0011A+V\u0001\u0004CBL'B\u0001,X\u0003\u001dQW\u000f]5uKJT!\u0001\u0017\u0019\u0002\u000b),h.\u001b;\n\u0005i\u001b&!C!gi\u0016\u0014X)Y2i\u0003i\"Xm\u001d;NCJ\\7\u000fU1si&$\u0018n\u001c8t\u0003N|eM\u001a7j]\u0016\fe\u000e\u001a)paVd\u0017\r^3t+:\u001cG.Z1oC\ndW-T3ue&\u001c7\u000f\u000b\u0002\n;B\u0011!KX\u0005\u0003?N\u0013A\u0001V3ti\u0006Aq-\u001a;HCV<W-\u0006\u0002caR\u00111-\u001f\t\u0004I2tW\"A3\u000b\u0005\u0019<\u0017\u0001B2pe\u0016T!a\b5\u000b\u0005%T\u0017AB=b[6,'OC\u0001l\u0003\r\u0019w.\\\u0005\u0003[\u0016\u0014QaR1vO\u0016\u0004\"a\u001c9\r\u0001\u0011)\u0011O\u0003b\u0001e\n\tA+\u0005\u0002tmB\u0011\u0011\t^\u0005\u0003k\n\u0013qAT8uQ&tw\r\u0005\u0002Bo&\u0011\u0001P\u0011\u0002\u0004\u0003:L\b\"\u0002>\u000b\u0001\u0004Y\u0018A\u00024jYR,'\u000fE\u0003Byz\f\u0019!\u0003\u0002~\u0005\nIa)\u001e8di&|g.\r\t\u0003I~L1!!\u0001f\u0005)iU\r\u001e:jG:\u000bW.\u001a\t\u0004\u0003\u0006\u0015\u0011bAA\u0004\u0005\n9!i\\8mK\u0006tW\u0003BA\u0006\u0003#!B!!\u0004\u0002\u0014A!A\r\\A\b!\ry\u0017\u0011\u0003\u0003\u0006c.\u0011\rA\u001d\u0005\b\u0003+Y\u0001\u0019AA\f\u0003)iW\r\u001e:jG:\u000bW.\u001a\t\u0005\u00033\t9C\u0004\u0003\u0002\u001c\u0005\r\u0002cAA\u000f\u00056\u0011\u0011q\u0004\u0006\u0004\u0003C1\u0012A\u0002\u001fs_>$h(C\u0002\u0002&\t\u000ba\u0001\u0015:fI\u00164\u0017\u0002BA\u0015\u0003W\u0011aa\u0015;sS:<'bAA\u0013\u0005V!\u0011qFA\u001b)\u0019\t\t$a\u000e\u0002:A!A\r\\A\u001a!\ry\u0017Q\u0007\u0003\u0006c2\u0011\rA\u001d\u0005\b\u0003+a\u0001\u0019AA\f\u0011\u001d\tY\u0004\u0004a\u0001\u0003/\t1\"\\3ue&\u001c7kY8qK\u00069B/Z:u\u001b\u0006DHj\\4D_6\u0004\u0018m\u0019;j_:d\u0015m\u001a\u0015\u0003\u001bu\u000b1B]3bI\u001a\u0013x.\u001c'pOR!\u0011QIA/!\u0019\t9%!\u0014\u0002R5\u0011\u0011\u0011\n\u0006\u0004\u0003\u0017\u0012\u0015AC2pY2,7\r^5p]&!\u0011qJA%\u0005!IE/\u001a:bE2,\u0007cB!\u0002T\u0005]\u0013qK\u0005\u0004\u0003+\u0012%A\u0002+va2,'\u0007E\u0002B\u00033J1!a\u0017C\u0005\rIe\u000e\u001e\u0005\u0007'9\u0001\r!a\u0018\u0011\u0007e\t\t'C\u0002\u0002dI\u0011!\"\u00168jM&,G\rT8h\u000319(/\u001b;f\u0017\u0016LH)\u001e9t)A\tI'a\u001c\u0002t\u0005]\u0014\u0011PA>\u0003\u000b\u000bI\t\u0005\u0004\u0002H\u0005-\u0014\u0011K\u0005\u0005\u0003[\nIEA\u0002TKFDq!!\u001d\u0010\u0001\u0004\t9&A\u0004ok6\\U-_:\t\u000f\u0005Ut\u00021\u0001\u0002X\u00059a.^7EkB\u001c\bBB\n\u0010\u0001\u0004\ty\u0006C\u0003&\u001f\u0001\u0007q\u0005C\u0004\u0002~=\u0001\r!a \u0002\u0013QLW.Z:uC6\u0004\bcA!\u0002\u0002&\u0019\u00111\u0011\"\u0003\t1{gn\u001a\u0005\b\u0003\u000f{\u0001\u0019AA,\u0003)\u0019H/\u0019:u-\u0006dW/\u001a\u0005\b\u0003\u0017{\u0001\u0019AA,\u0003\u0011\u0019H/\u001a9\u0002%Q,7\u000f^%t)\"\u0014X-\u00193GC&dW\r\u001a\u0015\u0003!u\u0003")
public class LogCleanerIntegrationTest
extends AbstractLogCleanerIntegrationTest
implements KafkaMetricsGroup {
    private final CompressionType codec = CompressionType.LZ4;
    private final MockTime time = new MockTime();
    private final TopicPartition[] topicPartitions = new TopicPartition[]{new TopicPartition("log", 0), new TopicPartition("log", 1), new TopicPartition("log", 2)};
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$((KafkaMetricsGroup)this, (String)name, tags);
    }

    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$((KafkaMetricsGroup)this, (String)group, (String)typeName, (String)name, tags);
    }

    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$((KafkaMetricsGroup)this, (String)name, metric, tags);
    }

    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$((KafkaMetricsGroup)this);
    }

    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$((KafkaMetricsGroup)this, (String)name, (String)eventType, (TimeUnit)timeUnit, tags);
    }

    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$((KafkaMetricsGroup)this);
    }

    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$((KafkaMetricsGroup)this, (String)name, (boolean)biased, tags);
    }

    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$((KafkaMetricsGroup)this);
    }

    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$((KafkaMetricsGroup)this);
    }

    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$((KafkaMetricsGroup)this, (String)name, (TimeUnit)durationUnit, (TimeUnit)rateUnit, tags);
    }

    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$((KafkaMetricsGroup)this);
    }

    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$((KafkaMetricsGroup)this, (String)name, tags);
    }

    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$((KafkaMetricsGroup)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$((Logging)this, (String)msg);
    }

    public void trace(Function0<String> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$((Logging)this, msg, e);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$((Logging)this, msg, e);
    }

    public void info(Function0<String> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$((Logging)this, msg, e);
    }

    public void warn(Function0<String> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$((Logging)this, msg, e);
    }

    public void error(Function0<String> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$((Logging)this, msg, e);
    }

    public void fatal(Function0<String> msg) {
        Logging.fatal$((Logging)this, msg);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$((Logging)this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public CompressionType codec() {
        return this.codec;
    }

    @Override
    public MockTime time() {
        return this.time;
    }

    public TopicPartition[] topicPartitions() {
        return this.topicPartitions;
    }

    @AfterEach
    public void cleanup() {
        TestUtils$.MODULE$.clearYammerMetrics();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics() {
        void var3_3;
        int largeMessageKey = 20;
        Tuple2<String, MemoryRecords> tuple2 = this.createLargeSingleMessageSet(largeMessageKey, (byte)2, this.codec());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        MemoryRecords largeMessageSet = (MemoryRecords)tuple2._2();
        int maxMessageSize = var3_3.sizeInBytes();
        ArraySeq.ofRef x$1 = Predef$.MODULE$.wrapRefArray((Object[])this.topicPartitions());
        float x$4 = this.makeCleaner$default$2();
        int x$5 = this.makeCleaner$default$3();
        long x$6 = this.makeCleaner$default$6();
        int x$7 = this.makeCleaner$default$7();
        int x$8 = this.makeCleaner$default$8();
        long x$9 = this.makeCleaner$default$9();
        Option<Object> x$10 = this.makeCleaner$default$10();
        Properties x$11 = this.makeCleaner$default$11();
        this.cleaner_$eq(this.makeCleaner((Iterable<TopicPartition>)x$1, x$4, x$5, 100L, maxMessageSize, x$6, x$7, x$8, x$9, x$10, x$11));
        this.breakPartitionLog$1(this.topicPartitions()[0]);
        this.breakPartitionLog$1(this.topicPartitions()[1]);
        this.cleaner().startup();
        UnifiedLog log = (UnifiedLog)this.cleaner().logs().get((Object)this.topicPartitions()[0]);
        UnifiedLog log2 = (UnifiedLog)this.cleaner().logs().get((Object)this.topicPartitions()[1]);
        String uncleanableDirectory = log.dir().getParent();
        Gauge uncleanablePartitionsCountGauge = this.getGauge("uncleanable-partitions-count", uncleanableDirectory);
        Gauge uncleanableBytesGauge = this.getGauge("uncleanable-bytes", uncleanableDirectory);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 2000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!LogCleanerIntegrationTest.$anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$1(uncleanablePartitionsCountGauge)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"There should be 2 uncleanable partitions");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), l));
        }
        long expectedTotalUncleanableBytes = LogCleanerManager$.MODULE$.calculateCleanableBytes(log, 0L, ((LogSegment)log.logSegments().last()).baseOffset())._2$mcJ$sp() + LogCleanerManager$.MODULE$.calculateCleanableBytes(log2, 0L, ((LogSegment)log2.logSegments().last()).baseOffset())._2$mcJ$sp();
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 1000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!LogCleanerIntegrationTest.$anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$3(uncleanableBytesGauge, expectedTotalUncleanableBytes)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)LogCleanerIntegrationTest.$anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$4(expectedTotalUncleanableBytes));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), l2));
        }
        Set uncleanablePartitions = this.cleaner().cleanerManager().uncleanablePartitions(uncleanableDirectory);
        Assertions.assertTrue((boolean)uncleanablePartitions.contains((Object)this.topicPartitions()[0]));
        Assertions.assertTrue((boolean)uncleanablePartitions.contains((Object)this.topicPartitions()[1]));
        Assertions.assertFalse((boolean)uncleanablePartitions.contains((Object)this.topicPartitions()[2]));
        this.cleaner().logs().remove((Object)this.topicPartitions()[0]);
        long l3 = 100L;
        long waitUntilTrue_waitTimeMs3 = 2000L;
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!LogCleanerIntegrationTest.$anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$5(this, uncleanablePartitionsCountGauge)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs3) {
                Assertions.fail((String)"There should be 1 uncleanable partitions");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs3), l3));
        }
        Set uncleanablePartitions2 = this.cleaner().cleanerManager().uncleanablePartitions(uncleanableDirectory);
        Assertions.assertFalse((boolean)uncleanablePartitions2.contains((Object)this.topicPartitions()[0]));
        Assertions.assertTrue((boolean)uncleanablePartitions2.contains((Object)this.topicPartitions()[1]));
        Assertions.assertFalse((boolean)uncleanablePartitions2.contains((Object)this.topicPartitions()[2]));
    }

    private <T> Gauge<T> getGauge(Function1<MetricName, Object> filter) {
        return (Gauge)((Tuple2)((IterableOps)CollectionConverters$.MODULE$.MapHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerIntegrationTest.$anonfun$getGauge$1(filter, x0$1)))).headOption().getOrElse((Function0 & Serializable)() -> (Nothing$)Assertions.fail((String)"Unable to find metric")))._2();
    }

    private <T> Gauge<T> getGauge(String metricName) {
        Function1 & Serializable getGauge_filter = (Function1 & Serializable)mName -> BoxesRunTime.boxToBoolean((boolean)LogCleanerIntegrationTest.$anonfun$getGauge$3(metricName, mName));
        return (Gauge)((Tuple2)((IterableOps)CollectionConverters$.MODULE$.MapHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerIntegrationTest.$anonfun$getGauge$1(filter, x0$1)))).headOption().getOrElse((Function0 & Serializable)() -> (Nothing$)Assertions.fail((String)"Unable to find metric")))._2();
    }

    private <T> Gauge<T> getGauge(String metricName, String metricScope) {
        Function1 & Serializable getGauge_filter = (Function1 & Serializable)k -> BoxesRunTime.boxToBoolean((boolean)LogCleanerIntegrationTest.$anonfun$getGauge$4(metricName, metricScope, k));
        return (Gauge)((Tuple2)((IterableOps)CollectionConverters$.MODULE$.MapHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerIntegrationTest.$anonfun$getGauge$1(filter, x0$1)))).headOption().getOrElse((Function0 & Serializable)() -> (Nothing$)Assertions.fail((String)"Unable to find metric")))._2();
    }

    @Test
    public void testMaxLogCompactionLag() {
        int msPerHour = 3600000;
        int minCompactionLagMs = 1 * msPerHour;
        int maxCompactionLagMs = 6 * msPerHour;
        long cleanerBackOffMs = 200L;
        int segmentSize = 512;
        Object[] topicPartitions = new TopicPartition[]{new TopicPartition("log", 0), new TopicPartition("log", 1), new TopicPartition("log", 2)};
        float minCleanableDirtyRatio = 1.0f;
        ArraySeq.ofRef x$1 = Predef$.MODULE$.wrapRefArray(topicPartitions);
        long x$3 = minCompactionLagMs;
        long x$5 = maxCompactionLagMs;
        int x$7 = this.makeCleaner$default$3();
        int x$8 = this.makeCleaner$default$5();
        int x$9 = this.makeCleaner$default$7();
        Option<Object> x$10 = this.makeCleaner$default$10();
        Properties x$11 = this.makeCleaner$default$11();
        this.cleaner_$eq(this.makeCleaner((Iterable<TopicPartition>)x$1, minCleanableDirtyRatio, x$7, cleanerBackOffMs, x$8, x$3, x$9, segmentSize, x$5, x$10, x$11));
        UnifiedLog log = (UnifiedLog)this.cleaner().logs().get(topicPartitions[0]);
        long T0 = this.time().milliseconds();
        this.writeKeyDups(100, 3, log, CompressionType.NONE, T0, 0, 1);
        long startSizeBlock0 = log.size();
        LogSegment activeSegAtT0 = log.activeSegment();
        this.cleaner().startup();
        this.time().sleep(maxCompactionLagMs / 2);
        Thread.sleep(5L * cleanerBackOffMs);
        Assertions.assertEquals((long)startSizeBlock0, (long)log.size(), (String)"There should be no cleaning until the max compaction lag has passed");
        this.time().sleep(maxCompactionLagMs / 2 + 1);
        long T1 = this.time().milliseconds();
        Seq<Tuple2<Object, Object>> appends1 = this.writeKeyDups(100, 1, log, CompressionType.NONE, T1, 0, 0);
        log.roll(log.roll$default$1());
        LogSegment activeSegAtT1 = log.activeSegment();
        long firstBlockCleanableSegmentOffset = activeSegAtT0.baseOffset();
        LogCleaner qual$1 = this.cleaner();
        TopicPartition x$12 = new TopicPartition("log", 0);
        long x$14 = qual$1.awaitCleaned$default$3();
        qual$1.awaitCleaned(x$12, firstBlockCleanableSegmentOffset, x$14);
        Iterable<Tuple2<Object, Object>> read1 = this.readFromLog(log);
        long lastCleaned = BoxesRunTime.unboxToLong((Object)this.cleaner().cleanerManager().allCleanerCheckpoints().apply((Object)new TopicPartition("log", 0)));
        Assertions.assertTrue((lastCleaned >= firstBlockCleanableSegmentOffset ? 1 : 0) != 0, (String)new StringBuilder(71).append("log cleaner should have processed at least to offset ").append(firstBlockCleanableSegmentOffset).append(", but lastCleaned=").append(lastCleaned).toString());
        Assertions.assertNotEquals(appends1, read1, (String)"log should still contain non-zero keys");
        this.time().sleep(maxCompactionLagMs + 1);
        LogCleaner qual$2 = this.cleaner();
        TopicPartition x$15 = new TopicPartition("log", 0);
        long x$16 = activeSegAtT1.baseOffset();
        long x$17 = qual$2.awaitCleaned$default$3();
        qual$2.awaitCleaned(x$15, x$16, x$17);
        Iterable<Tuple2<Object, Object>> read2 = this.readFromLog(log);
        Assertions.assertEquals(appends1, read2, (String)"log should only contains zero keys now");
        long lastCleaned2 = BoxesRunTime.unboxToLong((Object)this.cleaner().cleanerManager().allCleanerCheckpoints().apply((Object)new TopicPartition("log", 0)));
        long secondBlockCleanableSegmentOffset = activeSegAtT1.baseOffset();
        Assertions.assertTrue((lastCleaned2 >= secondBlockCleanableSegmentOffset ? 1 : 0) != 0, (String)new StringBuilder(71).append("log cleaner should have processed at least to offset ").append(secondBlockCleanableSegmentOffset).append(", but lastCleaned=").append(lastCleaned2).toString());
    }

    private Iterable<Tuple2<Object, Object>> readFromLog(UnifiedLog log) {
        return (Iterable)log.logSegments().flatMap((Function1 & Serializable)segment -> (Iterable)CollectionConverters$.MODULE$.IterableHasAsScala(segment.log().records()).asScala().map((Function1 & Serializable)record -> {
            int key = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(TestUtils$.MODULE$.readString(record.key(), TestUtils$.MODULE$.readString$default$2())));
            int value = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(TestUtils$.MODULE$.readString(record.value(), TestUtils$.MODULE$.readString$default$2())));
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)key)), (Object)BoxesRunTime.boxToInteger((int)value));
        }));
    }

    private Seq<Tuple2<Object, Object>> writeKeyDups(int numKeys, int numDups, UnifiedLog log, CompressionType codec, long timestamp, int startValue, int step) {
        IntRef valCounter = IntRef.create((int)startValue);
        return (Seq)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numDups).flatMap((Function1 & Serializable)x$1 -> LogCleanerIntegrationTest.$anonfun$writeKeyDups$1(numKeys, valCounter, log, codec, timestamp, step, BoxesRunTime.unboxToInt((Object)x$1)));
    }

    @Test
    public void testIsThreadFailed() {
        String metricName = "DeadThreadCount";
        ArraySeq.ofRef x$1 = Predef$.MODULE$.wrapRefArray((Object[])this.topicPartitions());
        float x$4 = this.makeCleaner$default$2();
        int x$5 = this.makeCleaner$default$3();
        long x$6 = this.makeCleaner$default$6();
        int x$7 = this.makeCleaner$default$7();
        int x$8 = this.makeCleaner$default$8();
        long x$9 = this.makeCleaner$default$9();
        Option<Object> x$10 = this.makeCleaner$default$10();
        Properties x$11 = this.makeCleaner$default$11();
        this.cleaner_$eq(this.makeCleaner((Iterable<TopicPartition>)x$1, x$4, x$5, 100L, 100000, x$6, x$7, x$8, x$9, x$10, x$11));
        this.cleaner().startup();
        Assertions.assertEquals((int)0, (int)this.cleaner().deadThreadCount());
        this.cleaner().cleaners().foreach((Function1 & Serializable)x$2 -> {
            x$2.interrupt();
            return BoxedUnit.UNIT;
        });
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!LogCleanerIntegrationTest.$anonfun$testIsThreadFailed$2(this)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"Threads didn't terminate unexpectedly");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
        Assertions.assertEquals((int)this.cleaner().cleaners().size(), (int)BoxesRunTime.unboxToInt((Object)this.getGauge(metricName).value()));
        Assertions.assertEquals((int)this.cleaner().cleaners().size(), (int)this.cleaner().deadThreadCount());
    }

    private final void breakPartitionLog$1(TopicPartition tp) {
        UnifiedLog log = (UnifiedLog)this.cleaner().logs().get((Object)tp);
        this.writeDups(20, 3, log, this.codec(), this.writeDups$default$5(), this.writeDups$default$6());
        File partitionFile = ((LogSegment)log.logSegments().last()).log().file();
        PrintWriter writer = new PrintWriter(partitionFile);
        writer.write("jogeajgoea");
        writer.close();
        this.writeDups(20, 3, log, this.codec(), this.writeDups$default$5(), this.writeDups$default$6());
    }

    public static final /* synthetic */ boolean $anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$1(Gauge uncleanablePartitionsCountGauge$1) {
        return BoxesRunTime.unboxToInt((Object)uncleanablePartitionsCountGauge$1.value()) == 2;
    }

    public static final /* synthetic */ String $anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$2() {
        return "There should be 2 uncleanable partitions";
    }

    public static final /* synthetic */ boolean $anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$3(Gauge uncleanableBytesGauge$1, long expectedTotalUncleanableBytes$1) {
        return BoxesRunTime.unboxToLong((Object)uncleanableBytesGauge$1.value()) == expectedTotalUncleanableBytes$1;
    }

    public static final /* synthetic */ String $anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$4(long expectedTotalUncleanableBytes$1) {
        return new StringBuilder(34).append("There should be ").append(expectedTotalUncleanableBytes$1).append(" uncleanable bytes").toString();
    }

    public static final /* synthetic */ boolean $anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$5(LogCleanerIntegrationTest $this, Gauge uncleanablePartitionsCountGauge$1) {
        $this.time().sleep(1000L);
        return BoxesRunTime.unboxToInt((Object)uncleanablePartitionsCountGauge$1.value()) == 1;
    }

    public static final /* synthetic */ String $anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$6() {
        return "There should be 1 uncleanable partitions";
    }

    public static final /* synthetic */ boolean $anonfun$getGauge$1(Function1 filter$1, Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        MetricName k = (MetricName)x0$1._1();
        boolean bl = BoxesRunTime.unboxToBoolean((Object)filter$1.apply((Object)k));
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$getGauge$3(String metricName$1, MetricName mName) {
        return mName.getName().endsWith(metricName$1) && mName.getScope() == null;
    }

    public static final /* synthetic */ boolean $anonfun$getGauge$4(String metricName$2, String metricScope$1, MetricName k) {
        return k.getName().endsWith(metricName$2) && k.getScope().endsWith(metricScope$1);
    }

    public static final /* synthetic */ Tuple2 $anonfun$writeKeyDups$2(IntRef valCounter$1, UnifiedLog log$1, CompressionType codec$1, long timestamp$1, int step$1, int key) {
        int curValue = valCounter$1.elem;
        byte[] x$1 = Integer.toString(curValue).getBytes();
        byte[] x$3 = Integer.toString(key).getBytes();
        byte by = 2;
        log$1.appendAsLeader(TestUtils$.MODULE$.singletonRecords(x$1, x$3, codec$1, timestamp$1, by), 0, log$1.appendAsLeader$default$3(), log$1.appendAsLeader$default$4(), log$1.appendAsLeader$default$5());
        log$1.updateHighWatermark(log$1.logEndOffset());
        valCounter$1.elem += step$1;
        return new Tuple2.mcII.sp(key, curValue);
    }

    public static final /* synthetic */ IterableOnce $anonfun$writeKeyDups$1(int numKeys$1, IntRef valCounter$1, UnifiedLog log$1, CompressionType codec$1, long timestamp$1, int step$1, int x$1) {
        return RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numKeys$1).map((Function1 & Serializable)key -> LogCleanerIntegrationTest.$anonfun$writeKeyDups$2(valCounter$1, log$1, codec$1, timestamp$1, step$1, BoxesRunTime.unboxToInt((Object)key)));
    }

    public static final /* synthetic */ boolean $anonfun$testIsThreadFailed$3(boolean result, LogCleaner.CleanerThread thread) {
        return thread.isThreadFailed() && result;
    }

    public static final /* synthetic */ boolean $anonfun$testIsThreadFailed$2(LogCleanerIntegrationTest $this) {
        return BoxesRunTime.unboxToBoolean((Object)$this.cleaner().cleaners().foldLeft((Object)BoxesRunTime.boxToBoolean((boolean)true), (Function2 & Serializable)(result, thread) -> BoxesRunTime.boxToBoolean((boolean)LogCleanerIntegrationTest.$anonfun$testIsThreadFailed$3(BoxesRunTime.unboxToBoolean((Object)result), thread))));
    }

    public static final /* synthetic */ String $anonfun$testIsThreadFailed$4() {
        return "Threads didn't terminate unexpectedly";
    }
}

