/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Optional;
import kafka.cluster.Partition;
import kafka.log.LogOffsetSnapshot;
import kafka.log.UnifiedLog$;
import kafka.server.DelayedFetch;
import kafka.server.FetchDataInfo;
import kafka.server.FetchIsolation;
import kafka.server.FetchLogEnd$;
import kafka.server.FetchMetadata;
import kafka.server.FetchPartitionData;
import kafka.server.FetchPartitionStatus;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.LogReadResult;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaQuota;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.FencedLeaderEpochException;
import org.apache.kafka.common.errors.NotLeaderOrFollowerException;
import org.apache.kafka.common.message.OffsetForLeaderEpochResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.requests.FetchRequest;
import org.easymock.EasyMock;
import org.easymock.EasyMockSupport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0005}4AAD\b\u0001)!)Q\u0004\u0001C\u0001=!9\u0011\u0005\u0001b\u0001\n\u0013\u0011\u0003BB\u0015\u0001A\u0003%1\u0005C\u0004+\u0001\t\u0007I\u0011B\u0016\t\r=\u0002\u0001\u0015!\u0003-\u0011\u001d\u0001\u0004A1A\u0005\nEBa!\u000e\u0001!\u0002\u0013\u0011\u0004\"\u0002\u001c\u0001\t\u00039\u0004\"\u0002$\u0001\t\u00039\u0004\"\u0002%\u0001\t\u00039\u0004\"\u0002&\u0001\t\u0013Y\u0005\"B1\u0001\t\u0013\u0011\u0007\"B=\u0001\t\u0013Q(\u0001\u0005#fY\u0006LX\r\u001a$fi\u000eDG+Z:u\u0015\t\u0001\u0012#\u0001\u0004tKJ4XM\u001d\u0006\u0002%\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\u0016!\t12$D\u0001\u0018\u0015\tA\u0012$\u0001\u0005fCNLXn\\2l\u0015\u0005Q\u0012aA8sO&\u0011Ad\u0006\u0002\u0010\u000b\u0006\u001c\u00180T8dWN+\b\u000f]8si\u00061A(\u001b8jiz\"\u0012a\b\t\u0003A\u0001i\u0011aD\u0001\t[\u0006D()\u001f;fgV\t1\u0005\u0005\u0002%O5\tQEC\u0001'\u0003\u0015\u00198-\u00197b\u0013\tASEA\u0002J]R\f\u0011\"\\1y\u0005f$Xm\u001d\u0011\u0002\u001dI,\u0007\u000f\\5dC6\u000bg.Y4feV\tA\u0006\u0005\u0002![%\u0011af\u0004\u0002\u000f%\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s\u0003=\u0011X\r\u001d7jG\u0006l\u0015M\\1hKJ\u0004\u0013\u0001\u0004:fa2L7-Y)v_R\fW#\u0001\u001a\u0011\u0005\u0001\u001a\u0014B\u0001\u001b\u0010\u00051\u0011V\r\u001d7jG\u0006\fVo\u001c;b\u00035\u0011X\r\u001d7jG\u0006\fVo\u001c;bA\u0005AB/Z:u\r\u0016$8\r[,ji\"4UM\\2fI\u0016\u0003xn\u00195\u0015\u0003a\u0002\"\u0001J\u001d\n\u0005i*#\u0001B+oSRD#\u0001\u0003\u001f\u0011\u0005u\"U\"\u0001 \u000b\u0005}\u0002\u0015aA1qS*\u0011\u0011IQ\u0001\bUV\u0004\u0018\u000e^3s\u0015\t\u0019\u0015$A\u0003kk:LG/\u0003\u0002F}\t!A+Z:u\u0003]!Xm\u001d;O_RdU-\u00193fe>\u0013hi\u001c7m_^,'\u000f\u000b\u0002\ny\u0005\u0011B/Z:u\t&4XM]4j]\u001e,\u0005o\\2iQ\tQA(\u0001\nck&dGMR3uG\"lU\r^1eCR\fG\u0003\u0002'P#r\u0003\"\u0001I'\n\u00059{!!\u0004$fi\u000eDW*\u001a;bI\u0006$\u0018\rC\u0003Q\u0017\u0001\u00071%A\u0005sKBd\u0017nY1JI\")!k\u0003a\u0001'\u0006\u0001Bo\u001c9jG&#\u0007+\u0019:uSRLwN\u001c\t\u0003)jk\u0011!\u0016\u0006\u0003-^\u000baaY8n[>t'B\u0001\nY\u0015\tI\u0016$\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u00037V\u0013\u0001\u0003V8qS\u000eLE\rU1si&$\u0018n\u001c8\t\u000bu[\u0001\u0019\u00010\u0002\u0017\u0019,Go\u00195Ti\u0006$Xo\u001d\t\u0003A}K!\u0001Y\b\u0003)\u0019+Go\u00195QCJ$\u0018\u000e^5p]N#\u0018\r^;t\u0003U)\u0007\u0010]3diJ+\u0017\r\u001a$s_6\u0014V\r\u001d7jG\u0006$R\u0001O2eKFDQ\u0001\u0015\u0007A\u0002\rBQA\u0015\u0007A\u0002MCQA\u001a\u0007A\u0002\u001d\f!CZ3uG\"\u0004\u0016M\u001d;ji&|g\u000eR1uCB\u0011\u0001N\u001c\b\u0003S2l\u0011A\u001b\u0006\u0003WV\u000b\u0001B]3rk\u0016\u001cHo]\u0005\u0003[*\fABR3uG\"\u0014V-];fgRL!a\u001c9\u0003\u001bA\u000b'\u000f^5uS>tG)\u0019;b\u0015\ti'\u000eC\u0003s\u0019\u0001\u00071/A\u0003feJ|'\u000f\u0005\u0002uo6\tQO\u0003\u0002w+\u0006A\u0001O]8u_\u000e|G.\u0003\u0002yk\n1QI\u001d:peN\fqBY;jY\u0012\u0014V-\u00193SKN,H\u000e\u001e\u000b\u0003wz\u0004\"\u0001\t?\n\u0005u|!!\u0004'pOJ+\u0017\r\u001a*fgVdG\u000fC\u0003s\u001b\u0001\u00071\u000f")
public class DelayedFetchTest
extends EasyMockSupport {
    private final int maxBytes;
    private final ReplicaManager replicaManager = (ReplicaManager)this.mock(ReplicaManager.class);
    private final ReplicaQuota replicaQuota = (ReplicaQuota)this.mock(ReplicaQuota.class);

    private int maxBytes() {
        return this.maxBytes;
    }

    private ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    private ReplicaQuota replicaQuota() {
        return this.replicaQuota;
    }

    @Test
    public void testFetchWithFencedEpoch() {
        TopicIdPartition topicIdPartition = new TopicIdPartition(Uuid.randomUuid(), 0, "topic");
        long fetchOffset = 500L;
        long logStartOffset = 0L;
        Optional<Integer> currentLeaderEpoch = Optional.of(Predef$.MODULE$.int2Integer(10));
        int replicaId = 1;
        FetchPartitionStatus fetchStatus = new FetchPartitionStatus(new LogOffsetMetadata(fetchOffset, UnifiedLog$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition()), new FetchRequest.PartitionData(Uuid.ZERO_UUID, fetchOffset, logStartOffset, this.maxBytes(), currentLeaderEpoch));
        FetchMetadata fetchMetadata = this.buildFetchMetadata(replicaId, topicIdPartition, fetchStatus);
        ObjectRef fetchResultOpt = ObjectRef.create((Object)None$.MODULE$);
        DelayedFetch delayedFetch = new DelayedFetch(500L, fetchMetadata, this.replicaManager(), this.replicaQuota(), (Option)None$.MODULE$, (Function1 & Serializable)responses -> {
            DelayedFetchTest.callback$1(responses, fetchResultOpt);
            return BoxedUnit.UNIT;
        });
        Partition partition = (Partition)this.mock(Partition.class);
        EasyMock.expect((Object)this.replicaManager().getPartitionOrException(topicIdPartition.topicPartition())).andReturn((Object)partition);
        EasyMock.expect((Object)partition.fetchOffsetSnapshot(currentLeaderEpoch, true)).andThrow((Throwable)new FencedLeaderEpochException("Requested epoch has been fenced"));
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.replicaManager().isAddingReplica((TopicPartition)EasyMock.anyObject(), EasyMock.anyInt()))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.expectReadFromReplica(replicaId, topicIdPartition, fetchStatus.fetchInfo(), Errors.FENCED_LEADER_EPOCH);
        this.replayAll();
        Assertions.assertTrue((boolean)delayedFetch.tryComplete());
        Assertions.assertTrue((boolean)delayedFetch.isCompleted());
        Assertions.assertTrue((boolean)((Option)fetchResultOpt.elem).isDefined());
        FetchPartitionData fetchResult = (FetchPartitionData)((Option)fetchResultOpt.elem).get();
        Assertions.assertEquals((Object)Errors.FENCED_LEADER_EPOCH, (Object)fetchResult.error());
    }

    @Test
    public void testNotLeaderOrFollower() {
        TopicIdPartition topicIdPartition = new TopicIdPartition(Uuid.randomUuid(), 0, "topic");
        long fetchOffset = 500L;
        long logStartOffset = 0L;
        Optional<Integer> currentLeaderEpoch = Optional.of(Predef$.MODULE$.int2Integer(10));
        int replicaId = 1;
        FetchPartitionStatus fetchStatus = new FetchPartitionStatus(new LogOffsetMetadata(fetchOffset, UnifiedLog$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition()), new FetchRequest.PartitionData(Uuid.ZERO_UUID, fetchOffset, logStartOffset, this.maxBytes(), currentLeaderEpoch));
        FetchMetadata fetchMetadata = this.buildFetchMetadata(replicaId, topicIdPartition, fetchStatus);
        ObjectRef fetchResultOpt = ObjectRef.create((Object)None$.MODULE$);
        DelayedFetch delayedFetch = new DelayedFetch(500L, fetchMetadata, this.replicaManager(), this.replicaQuota(), (Option)None$.MODULE$, (Function1 & Serializable)responses -> {
            DelayedFetchTest.callback$2(responses, fetchResultOpt);
            return BoxedUnit.UNIT;
        });
        EasyMock.expect((Object)this.replicaManager().getPartitionOrException(topicIdPartition.topicPartition())).andThrow((Throwable)new NotLeaderOrFollowerException(new StringBuilder(26).append("Replica for ").append(topicIdPartition).append(" not available").toString()));
        this.expectReadFromReplica(replicaId, topicIdPartition, fetchStatus.fetchInfo(), Errors.NOT_LEADER_OR_FOLLOWER);
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.replicaManager().isAddingReplica((TopicPartition)EasyMock.anyObject(), EasyMock.anyInt()))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.replayAll();
        Assertions.assertTrue((boolean)delayedFetch.tryComplete());
        Assertions.assertTrue((boolean)delayedFetch.isCompleted());
        Assertions.assertTrue((boolean)((Option)fetchResultOpt.elem).isDefined());
    }

    @Test
    public void testDivergingEpoch() {
        TopicIdPartition topicIdPartition = new TopicIdPartition(Uuid.randomUuid(), 0, "topic");
        long fetchOffset = 500L;
        long logStartOffset = 0L;
        Optional<Integer> currentLeaderEpoch = Optional.of(Predef$.MODULE$.int2Integer(10));
        Optional<Integer> lastFetchedEpoch = Optional.of(Predef$.MODULE$.int2Integer(9));
        int replicaId = 1;
        FetchPartitionStatus fetchStatus = new FetchPartitionStatus(new LogOffsetMetadata(fetchOffset, UnifiedLog$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition()), new FetchRequest.PartitionData(topicIdPartition.topicId(), fetchOffset, logStartOffset, this.maxBytes(), currentLeaderEpoch, lastFetchedEpoch));
        FetchMetadata fetchMetadata = this.buildFetchMetadata(replicaId, topicIdPartition, fetchStatus);
        ObjectRef fetchResultOpt = ObjectRef.create((Object)None$.MODULE$);
        DelayedFetch delayedFetch = new DelayedFetch(500L, fetchMetadata, this.replicaManager(), this.replicaQuota(), (Option)None$.MODULE$, (Function1 & Serializable)responses -> {
            DelayedFetchTest.callback$3(responses, fetchResultOpt);
            return BoxedUnit.UNIT;
        });
        Partition partition = (Partition)this.mock(Partition.class);
        EasyMock.expect((Object)this.replicaManager().getPartitionOrException(topicIdPartition.topicPartition())).andReturn((Object)partition);
        LogOffsetMetadata endOffsetMetadata = new LogOffsetMetadata(500L, 0L, 500);
        EasyMock.expect((Object)partition.fetchOffsetSnapshot(currentLeaderEpoch, true)).andReturn((Object)new LogOffsetSnapshot(0L, endOffsetMetadata, endOffsetMetadata, endOffsetMetadata));
        EasyMock.expect((Object)partition.lastOffsetForLeaderEpoch(currentLeaderEpoch, Predef$.MODULE$.Integer2int(lastFetchedEpoch.get()), false)).andReturn((Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(topicIdPartition.partition()).setErrorCode(Errors.NONE.code()).setLeaderEpoch(Predef$.MODULE$.Integer2int(lastFetchedEpoch.get())).setEndOffset(fetchOffset - 1L));
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.replicaManager().isAddingReplica((TopicPartition)EasyMock.anyObject(), EasyMock.anyInt()))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.expectReadFromReplica(replicaId, topicIdPartition, fetchStatus.fetchInfo(), Errors.NONE);
        this.replayAll();
        Assertions.assertTrue((boolean)delayedFetch.tryComplete());
        Assertions.assertTrue((boolean)delayedFetch.isCompleted());
        Assertions.assertTrue((boolean)((Option)fetchResultOpt.elem).isDefined());
    }

    private FetchMetadata buildFetchMetadata(int replicaId, TopicIdPartition topicIdPartition, FetchPartitionStatus fetchStatus) {
        return new FetchMetadata(1, this.maxBytes(), false, true, (FetchIsolation)FetchLogEnd$.MODULE$, true, replicaId, (Seq)new .colon.colon((Object)new Tuple2((Object)topicIdPartition, (Object)fetchStatus), (List)Nil$.MODULE$));
    }

    private void expectReadFromReplica(int replicaId, TopicIdPartition topicIdPartition, FetchRequest.PartitionData fetchPartitionData, Errors error) {
        FetchLogEnd$ x$3 = FetchLogEnd$.MODULE$;
        int x$4 = this.maxBytes();
        .colon.colon x$6 = new .colon.colon((Object)new Tuple2((Object)topicIdPartition, (Object)fetchPartitionData), (List)Nil$.MODULE$);
        None$ x$7 = None$.MODULE$;
        ReplicaQuota x$8 = this.replicaQuota();
        EasyMock.expect((Object)this.replicaManager().readFromLocalLog(replicaId, true, (FetchIsolation)x$3, x$4, false, (Seq)x$6, x$8, (Option)x$7)).andReturn((Object)new .colon.colon((Object)new Tuple2((Object)topicIdPartition, (Object)this.buildReadResult(error)), (List)Nil$.MODULE$));
    }

    private LogReadResult buildReadResult(Errors error) {
        None$ none$;
        Errors errors = error;
        Errors errors2 = Errors.NONE;
        None$ x$1 = (errors == null ? errors2 != null : !errors.equals(errors2)) ? new Some((Object)error.exception()) : None$.MODULE$;
        FetchDataInfo x$2 = new FetchDataInfo(LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata(), (Records)MemoryRecords.EMPTY, false, (Option)None$.MODULE$);
        None$ x$3 = None$.MODULE$;
        None$ x$9 = None$.MODULE$;
        None$ none$2 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$10 = none$2;
        return new LogReadResult(x$2, (Option)x$3, -1L, -1L, -1L, -1L, -1L, (Option)x$9, (Option)x$10, (Option)x$1);
    }

    private static final void callback$1(Seq responses, ObjectRef fetchResultOpt$1) {
        fetchResultOpt$1.elem = new Some(((Tuple2)responses.head())._2());
    }

    private static final void callback$2(Seq responses, ObjectRef fetchResultOpt$2) {
        fetchResultOpt$2.elem = new Some(((Tuple2)responses.head())._2());
    }

    private static final void callback$3(Seq responses, ObjectRef fetchResultOpt$3) {
        fetchResultOpt$3.elem = new Some(((Tuple2)responses.head())._2());
    }

    public DelayedFetchTest() {
        this.maxBytes = 1024;
    }
}

