/*
 * Decompiled with CFR 0.152.
 */
package integration.kafka.server;

import java.io.File;
import java.io.Serializable;
import java.time.Duration;
import java.util.Arrays;
import java.util.Properties;
import kafka.api.ApiVersion;
import kafka.api.DefaultApiVersion;
import kafka.api.KAFKA_2_7_IV0$;
import kafka.api.KAFKA_2_8_IV1$;
import kafka.api.KAFKA_3_1_IV0$;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005-4A\u0001D\u0007\u0001)!)1\u0004\u0001C\u00019!)q\u0004\u0001C!A!)q\u0005\u0001C!Q!)!\u0007\u0001C\u0001g!)A\t\u0001C\u0001g!)a\t\u0001C\u0001\u000f\")\u0011\u000b\u0001C\u0001g!)1\u000b\u0001C\u0001g!)Q\u000b\u0001C\u0001-\")q\f\u0001C\u0005A\")!\r\u0001C\u0005G\n\u0019c)\u001a;dQJ+\u0017/^3ti\n+Go^3f]\u0012KgMZ3sK:$\u0018J\u00199UKN$(B\u0001\b\u0010\u0003\u0019\u0019XM\u001d<fe*\u0011\u0001#E\u0001\u0006W\u000647.\u0019\u0006\u0002%\u0005Y\u0011N\u001c;fOJ\fG/[8o\u0007\u0001\u0019\"\u0001A\u000b\u0011\u0005YIR\"A\f\u000b\u00059A\"\"\u0001\t\n\u0005i9\"a\u0004\"bg\u0016\u0014V-];fgR$Vm\u001d;\u0002\rqJg.\u001b;?)\u0005i\u0002C\u0001\u0010\u0001\u001b\u0005i\u0011a\u00032s_.,'oQ8v]R,\u0012!\t\t\u0003E\u0015j\u0011a\t\u0006\u0002I\u0005)1oY1mC&\u0011ae\t\u0002\u0004\u0013:$\u0018aD4f]\u0016\u0014\u0018\r^3D_:4\u0017nZ:\u0016\u0003%\u00022AK\u00170\u001b\u0005Y#B\u0001\u0017$\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003]-\u00121aU3r!\t1\u0002'\u0003\u00022/\tY1*\u00194lC\u000e{gNZ5h\u0003Q!Xm\u001d;D_:$(o\u001c7mKJ|E\u000eZ%C!R\tA\u0007\u0005\u0002#k%\u0011ag\t\u0002\u0005+:LG\u000f\u000b\u0002\u0005qA\u0011\u0011HQ\u0007\u0002u)\u00111\bP\u0001\u0004CBL'BA\u001f?\u0003\u001dQW\u000f]5uKJT!a\u0010!\u0002\u000b),h.\u001b;\u000b\u0003\u0005\u000b1a\u001c:h\u0013\t\u0019%H\u0001\u0003UKN$\u0018\u0001\u0006;fgR\u001cuN\u001c;s_2dWM\u001d(fo&\u0013\u0005\u000b\u000b\u0002\u0006q\u0005QB/Z:u\u0007>tGO]8mY\u0016\u0014x+\u001b;i\u000f&4XM\\%C!R\u0019A\u0007S(\t\u000b%3\u0001\u0019\u0001&\u0002\u000fY,'o]5p]B\u00111*T\u0007\u0002\u0019*\u00111\bG\u0005\u0003\u001d2\u0013\u0011\u0003R3gCVdG/\u00119j-\u0016\u00148/[8o\u0011\u0015\u0001f\u00011\u0001\"\u0003A\u0019wN\u001c;s_2dWM\u001d\"s_.,'/A\ruKN$8i\u001c8ue>dG.\u001a:OK^$vn\u00147e\u0013\n\u0003\u0006FA\u00049\u0003e!Xm\u001d;D_:$(o\u001c7mKJ|E\u000e\u001a+p\u001d\u0016<\u0018J\u0011))\u0005!A\u0014A\u0007;fgR\u001cuN\u001c;s_2dWM]*xSR\u001c\u0007.\u001b8h\u0013\n\u0003F#\u0002\u001bX3nk\u0006\"\u0002-\n\u0001\u0004Q\u0015\u0001\u0003<feNLwN\\\u0019\t\u000biK\u0001\u0019A\u0011\u0002\u000f\t\u0014xn[3sc!)A,\u0003a\u0001\u0015\u0006Aa/\u001a:tS>t'\u0007C\u0003_\u0013\u0001\u0007\u0011%A\u0004ce>\\WM\u001d\u001a\u0002/\u0015t7/\u001e:f\u0007>tGO]8mY\u0016\u0014x+\u001b;i\u0013\n\u0003FC\u0001\u001bb\u0011\u0015I%\u00021\u0001K\u00031\u0019'/Z1uK\u000e{gNZ5h)\ryCM\u001a\u0005\u0006K.\u0001\r!I\u0001\u0007]>$W-\u00133\t\u000b\u001d\\\u0001\u0019\u00015\u0002%%tG/\u001a:Ce>\\WM\u001d,feNLwN\u001c\t\u0003\u0017&L!A\u001b'\u0003\u0015\u0005\u0003\u0018NV3sg&|g\u000e")
public class FetchRequestBetweenDifferentIbpTest
extends BaseRequestTest {
    @Override
    public int brokerCount() {
        return 3;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return new .colon.colon((Object)this.createConfig(0, (ApiVersion)KAFKA_2_7_IV0$.MODULE$), (List)new .colon.colon((Object)this.createConfig(1, (ApiVersion)KAFKA_2_8_IV1$.MODULE$), (List)new .colon.colon((Object)this.createConfig(2, (ApiVersion)KAFKA_3_1_IV0$.MODULE$), (List)Nil$.MODULE$)));
    }

    @Test
    public void testControllerOldIBP() {
        this.testControllerWithGivenIBP((DefaultApiVersion)KAFKA_2_7_IV0$.MODULE$, 0);
    }

    @Test
    public void testControllerNewIBP() {
        this.testControllerWithGivenIBP((DefaultApiVersion)KAFKA_3_1_IV0$.MODULE$, 2);
    }

    public void testControllerWithGivenIBP(DefaultApiVersion version, int controllerBroker) {
        String topic = "topic";
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        this.ensureControllerWithIBP(version);
        Assertions.assertEquals((int)controllerBroker, (int)this.controllerSocketServer().config().brokerId());
        scala.collection.immutable.Map<Object, Object> partitionLeaders = this.createTopic(topic, (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 0, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 2, 1})))}))));
        TestUtils$.MODULE$.waitForAllPartitionsMetadata(this.servers(), topic, 2);
        Assertions.assertEquals((int)1, (int)BoxesRunTime.unboxToInt((Object)partitionLeaders.apply((Object)BoxesRunTime.boxToInteger((int)0))));
        Assertions.assertEquals((int)0, (int)BoxesRunTime.unboxToInt((Object)partitionLeaders.apply((Object)BoxesRunTime.boxToInteger((int)1))));
        ProducerRecord record1 = new ProducerRecord(topic, Predef$.MODULE$.int2Integer(0), null, (Object)"key".getBytes(), (Object)"value".getBytes());
        ProducerRecord record2 = new ProducerRecord(topic, Predef$.MODULE$.int2Integer(1), null, (Object)"key".getBytes(), (Object)"value".getBytes());
        producer.send(record1);
        producer.send(record2);
        consumer.assign(Arrays.asList(new TopicPartition(topic, 0), new TopicPartition(topic, 1)));
        int count = consumer.poll(Duration.ofMillis(1500L)).count() + consumer.poll(Duration.ofMillis(1500L)).count();
        Assertions.assertEquals((int)2, (int)count);
    }

    @Test
    public void testControllerNewToOldIBP() {
        this.testControllerSwitchingIBP((DefaultApiVersion)KAFKA_3_1_IV0$.MODULE$, 2, (DefaultApiVersion)KAFKA_2_7_IV0$.MODULE$, 0);
    }

    @Test
    public void testControllerOldToNewIBP() {
        this.testControllerSwitchingIBP((DefaultApiVersion)KAFKA_2_7_IV0$.MODULE$, 0, (DefaultApiVersion)KAFKA_3_1_IV0$.MODULE$, 2);
    }

    public void testControllerSwitchingIBP(DefaultApiVersion version1, int broker1, DefaultApiVersion version2, int broker2) {
        String topic = "topic";
        String topic2 = "topic2";
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        this.ensureControllerWithIBP(version1);
        Assertions.assertEquals((int)broker1, (int)this.controllerSocketServer().config().brokerId());
        scala.collection.immutable.Map<Object, Object> partitionLeaders = this.createTopic(topic, (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 0, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 2, 1})))}))));
        TestUtils$.MODULE$.waitForAllPartitionsMetadata(this.servers(), topic, 2);
        Assertions.assertEquals((int)1, (int)BoxesRunTime.unboxToInt((Object)partitionLeaders.apply((Object)BoxesRunTime.boxToInteger((int)0))));
        Assertions.assertEquals((int)0, (int)BoxesRunTime.unboxToInt((Object)partitionLeaders.apply((Object)BoxesRunTime.boxToInteger((int)1))));
        ProducerRecord record1 = new ProducerRecord(topic, Predef$.MODULE$.int2Integer(0), null, (Object)"key".getBytes(), (Object)"value".getBytes());
        ProducerRecord record2 = new ProducerRecord(topic, Predef$.MODULE$.int2Integer(1), null, (Object)"key".getBytes(), (Object)"value".getBytes());
        producer.send(record1);
        producer.send(record2);
        consumer.assign(Arrays.asList(new TopicPartition(topic, 0), new TopicPartition(topic, 1)));
        int count = consumer.poll(Duration.ofMillis(1500L)).count() + consumer.poll(Duration.ofMillis(1500L)).count();
        Assertions.assertEquals((int)2, (int)count);
        this.ensureControllerWithIBP(version2);
        Assertions.assertEquals((int)broker2, (int)this.controllerSocketServer().config().brokerId());
        this.createTopic(topic2, (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 0, 2})))}))));
        TestUtils$.MODULE$.waitForAllPartitionsMetadata(this.servers(), topic2, 1);
        TestUtils$.MODULE$.waitForAllPartitionsMetadata(this.servers(), topic, 2);
        ProducerRecord record3 = new ProducerRecord(topic2, Predef$.MODULE$.int2Integer(0), null, (Object)"key".getBytes(), (Object)"value".getBytes());
        ProducerRecord record4 = new ProducerRecord(topic, Predef$.MODULE$.int2Integer(1), null, (Object)"key".getBytes(), (Object)"value".getBytes());
        producer.send(record3);
        producer.send(record4);
        consumer.assign(Arrays.asList(new TopicPartition(topic, 0), new TopicPartition(topic, 1), new TopicPartition(topic2, 0)));
        int count2 = consumer.poll(Duration.ofMillis(1500L)).count() + consumer.poll(Duration.ofMillis(1500L)).count();
        Assertions.assertEquals((int)2, (int)count2);
    }

    private void ensureControllerWithIBP(DefaultApiVersion version) {
        Buffer nonControllerServers = (Buffer)this.servers().filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)FetchRequestBetweenDifferentIbpTest.$anonfun$ensureControllerWithIBP$1(version, x$1)));
        nonControllerServers.iterator().foreach((Function1 & Serializable)server -> {
            server.shutdown();
            return BoxedUnit.UNIT;
        });
        TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), 15000L);
        nonControllerServers.iterator().foreach((Function1 & Serializable)server -> {
            server.startup();
            return BoxedUnit.UNIT;
        });
    }

    private KafkaConfig createConfig(int nodeId, ApiVersion interBrokerVersion) {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(nodeId, this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1);
        props.put(KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp(), interBrokerVersion.version());
        return KafkaConfig$.MODULE$.fromProps(props);
    }

    public static final /* synthetic */ boolean $anonfun$ensureControllerWithIBP$1(DefaultApiVersion version$1, KafkaServer x$1) {
        ApiVersion apiVersion = x$1.config().interBrokerProtocolVersion();
        return apiVersion == null ? version$1 != null : !apiVersion.equals(version$1);
    }
}

