/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.metadata;

import java.nio.ByteBuffer;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.function.Function;
import kafka.server.metadata.BrokerMetadataSnapshotter;
import kafka.server.metadata.SnapshotWriterBuilder;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MutableRecordBatch;
import org.apache.kafka.common.utils.AbstractIterator;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.MetadataImageTest;
import org.apache.kafka.metadata.MetadataRecordSerde;
import org.apache.kafka.queue.EventQueue;
import org.apache.kafka.queue.KafkaEventQueue;
import org.apache.kafka.raft.OffsetAndEpoch;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.serialization.RecordSerde;
import org.apache.kafka.snapshot.MockRawSnapshotWriter;
import org.apache.kafka.snapshot.SnapshotWriter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.None$;
import scala.Option;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005Eb\u0001\u0002\t\u0012\u0001aAQa\b\u0001\u0005\u0002\u0001BQa\t\u0001\u0005\u0002\u00112A!\u000e\u0001\u0001m!)qd\u0001C\u0001u!9Qh\u0001a\u0001\n\u0003q\u0004bB)\u0004\u0001\u0004%\tA\u0015\u0005\u0007+\u000e\u0001\u000b\u0015B \t\u000bY\u001bA\u0011I,\t\u000bE\u001cA\u0011\u0001:\u0007\tm\u0004\u0001\u0001 \u0005\u0007?)!\t!a\u0007\t\u0013\u0005}!B1A\u0005\u0002\u0005\u0005\u0002\u0002CA\u0015\u0015\u0001\u0006I!a\t\t\r\u0005-\"\u0002\"\u0011%\u0011\u0019\ti\u0003\u0001C\u0001I\ti\"I]8lKJlU\r^1eCR\f7K\\1qg\"|G\u000f^3s)\u0016\u001cHO\u0003\u0002\u0013'\u0005AQ.\u001a;bI\u0006$\u0018M\u0003\u0002\u0015+\u000511/\u001a:wKJT\u0011AF\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0011\u0004\u0005\u0002\u001b;5\t1DC\u0001\u001d\u0003\u0015\u00198-\u00197b\u0013\tq2D\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0005\u0002\"A\t\u0001\u000e\u0003E\t!\u0003^3ti\u000e\u0013X-\u0019;f\u0003:$7\t\\8tKR\tQ\u0005\u0005\u0002\u001bM%\u0011qe\u0007\u0002\u0005+:LG\u000f\u000b\u0002\u0003SA\u0011!fM\u0007\u0002W)\u0011A&L\u0001\u0004CBL'B\u0001\u00180\u0003\u001dQW\u000f]5uKJT!\u0001M\u0019\u0002\u000b),h.\u001b;\u000b\u0003I\n1a\u001c:h\u0013\t!4F\u0001\u0003UKN$(!G'pG.\u001cf.\u00199tQ>$xK]5uKJ\u0014U/\u001b7eKJ\u001c2aA\r8!\t\u0011\u0003(\u0003\u0002:#\t)2K\\1qg\"|Go\u0016:ji\u0016\u0014()^5mI\u0016\u0014H#A\u001e\u0011\u0005q\u001aQ\"\u0001\u0001\u0002\u000b%l\u0017mZ3\u0016\u0003}\u00022\u0001Q$J\u001b\u0005\t%B\u0001\"D\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003\t\u0016\u000bA!\u001e;jY*\ta)\u0001\u0003kCZ\f\u0017B\u0001%B\u0005E\u0019u.\u001c9mKR\f'\r\\3GkR,(/\u001a\t\u0003\u0015>k\u0011a\u0013\u0006\u0003{1S!AF'\u000b\u00059\u000b\u0014AB1qC\u000eDW-\u0003\u0002Q\u0017\niQ*\u001a;bI\u0006$\u0018-S7bO\u0016\f\u0011\"[7bO\u0016|F%Z9\u0015\u0005\u0015\u001a\u0006b\u0002+\u0007\u0003\u0003\u0005\raP\u0001\u0004q\u0012\n\u0014AB5nC\u001e,\u0007%A\u0003ck&dG\r\u0006\u0003YK*|\u0007cA-]=6\t!L\u0003\u0002\\\u0019\u0006A1O\\1qg\"|G/\u0003\u0002^5\nq1K\\1qg\"|Go\u0016:ji\u0016\u0014\bCA0d\u001b\u0005\u0001'BA1c\u0003\u0019\u0019w.\\7p]*\u0011A\u0003T\u0005\u0003I\u0002\u0014A#\u00119j\u001b\u0016\u001c8/Y4f\u0003:$g+\u001a:tS>t\u0007\"\u00024\t\u0001\u00049\u0017aD2p[6LG\u000f^3e\u001f\u001a47/\u001a;\u0011\u0005iA\u0017BA5\u001c\u0005\u0011auN\\4\t\u000b-D\u0001\u0019\u00017\u0002\u001d\r|W.\\5ui\u0016$W\t]8dQB\u0011!$\\\u0005\u0003]n\u00111!\u00138u\u0011\u0015\u0001\b\u00021\u0001h\u0003Qa\u0017m\u001d;D_:$\u0018-\u001b8fI2{w\rV5nK\u0006)2m\u001c8tk6,7K\\1qg\"|GOQ;gM\u0016\u0014HCA\u0013t\u0011\u0015!\u0018\u00021\u0001v\u0003\u0019\u0011WO\u001a4feB\u0011a/_\u0007\u0002o*\u0011\u00010R\u0001\u0004]&|\u0017B\u0001>x\u0005)\u0011\u0015\u0010^3Ck\u001a4WM\u001d\u0002\u000e\u00052|7m[5oO\u00163XM\u001c;\u0014\t)i\u0018q\u0001\t\u0004}\u0006\rQ\"A@\u000b\u0007\u0005\u0005Q)\u0001\u0003mC:<\u0017bAA\u0003\u007f\n1qJ\u00196fGR\u0004B!!\u0003\u0002\u00169!\u00111BA\t\u001b\t\tiAC\u0002\u0002\u00101\u000bQ!];fk\u0016LA!a\u0005\u0002\u000e\u0005QQI^3oiF+X-^3\n\t\u0005]\u0011\u0011\u0004\u0002\u0006\u000bZ,g\u000e\u001e\u0006\u0005\u0003'\ti\u0001\u0006\u0002\u0002\u001eA\u0011AHC\u0001\u0006Y\u0006$8\r[\u000b\u0003\u0003G\u00012\u0001QA\u0013\u0013\r\t9#\u0011\u0002\u000f\u0007>,h\u000e\u001e#po:d\u0015\r^2i\u0003\u0019a\u0017\r^2iA\u0005\u0019!/\u001e8\u0002%Q,7\u000f^\"sK\u0006$Xm\u00158baNDw\u000e\u001e\u0015\u0003\u001f%\u0002")
public class BrokerMetadataSnapshotterTest {
    @Test
    public void testCreateAndClose() {
        new BrokerMetadataSnapshotter(0, Time.SYSTEM, (Option)None$.MODULE$, (x$1, x$2, x$3) -> {
            throw new RuntimeException("unimplemented");
        }).close();
    }

    @Test
    public void testCreateSnapshot() {
        MockSnapshotWriterBuilder writerBuilder = new MockSnapshotWriterBuilder();
        try (BrokerMetadataSnapshotter snapshotter = new BrokerMetadataSnapshotter(0, Time.SYSTEM, (Option)None$.MODULE$, (SnapshotWriterBuilder)writerBuilder);){
            BlockingEvent blockingEvent = new BlockingEvent();
            KafkaEventQueue kafkaEventQueue = snapshotter.eventQueue();
            if (kafkaEventQueue == null) {
                throw null;
            }
            kafkaEventQueue.enqueue(EventQueue.EventInsertionType.APPEND, null, (Function)EventQueue.NoDeadlineFunction.INSTANCE, (EventQueue.Event)blockingEvent);
            Assertions.assertTrue((boolean)snapshotter.maybeStartSnapshot(123L, 12, 10000L, MetadataImageTest.IMAGE1));
            Assertions.assertFalse((boolean)snapshotter.maybeStartSnapshot(124L, 12, 11000L, MetadataImageTest.IMAGE2));
            blockingEvent.latch().countDown();
            Assertions.assertEquals((Object)MetadataImageTest.IMAGE1, (Object)writerBuilder.image().get());
        }
    }

    public class BlockingEvent
    implements EventQueue.Event {
        private final CountDownLatch latch;

        public void handleException(Throwable x$1) {
            super.handleException(x$1);
        }

        public CountDownLatch latch() {
            return this.latch;
        }

        public void run() {
            this.latch().await();
        }

        public /* synthetic */ BrokerMetadataSnapshotterTest kafka$server$metadata$BrokerMetadataSnapshotterTest$BlockingEvent$$$outer() {
            return BrokerMetadataSnapshotterTest.this;
        }

        public BlockingEvent() {
            if (BrokerMetadataSnapshotterTest.this == null) {
                throw null;
            }
            this.latch = new CountDownLatch(1);
        }
    }

    public class MockSnapshotWriterBuilder
    implements SnapshotWriterBuilder {
        private CompletableFuture<MetadataImage> image;

        public CompletableFuture<MetadataImage> image() {
            return this.image;
        }

        public void image_$eq(CompletableFuture<MetadataImage> x$1) {
            this.image = x$1;
        }

        public SnapshotWriter<ApiMessageAndVersion> build(long committedOffset, int committedEpoch, long lastContainedLogTime) {
            OffsetAndEpoch offsetAndEpoch = new OffsetAndEpoch(committedOffset, committedEpoch);
            return (SnapshotWriter)SnapshotWriter.createWithHeader(() -> Optional.of(new MockRawSnapshotWriter(offsetAndEpoch, buffer -> this.consumeSnapshotBuffer((ByteBuffer)buffer))), (int)1024, (MemoryPool)MemoryPool.NONE, (Time)Time.SYSTEM, (long)lastContainedLogTime, (CompressionType)CompressionType.NONE, (RecordSerde)MetadataRecordSerde.INSTANCE).get();
        }

        public void consumeSnapshotBuffer(ByteBuffer buffer) {
            MetadataDelta delta = new MetadataDelta(MetadataImage.EMPTY);
            AbstractIterator batchIterator = MemoryRecords.readableRecords((ByteBuffer)buffer).batchIterator();
            while (batchIterator.hasNext()) {
                MutableRecordBatch batch = (MutableRecordBatch)batchIterator.next();
                if (batch.isControlBatch()) continue;
                batch.forEach(record -> {
                    ByteBuffer recordBuffer = record.value().duplicate();
                    ApiMessageAndVersion messageAndVersion = MetadataRecordSerde.INSTANCE.read((Readable)new ByteBufferAccessor(recordBuffer), recordBuffer.remaining());
                    delta.replay(messageAndVersion.message());
                });
            }
            this.image().complete(delta.apply());
        }

        public /* synthetic */ BrokerMetadataSnapshotterTest kafka$server$metadata$BrokerMetadataSnapshotterTest$MockSnapshotWriterBuilder$$$outer() {
            return BrokerMetadataSnapshotterTest.this;
        }

        public MockSnapshotWriterBuilder() {
            if (BrokerMetadataSnapshotterTest.this == null) {
                throw null;
            }
            this.image = new CompletableFuture();
        }
    }
}

