/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata;
import kafka.coordinator.transaction.Dead$;
import kafka.coordinator.transaction.Ongoing$;
import kafka.coordinator.transaction.PrepareAbort$;
import kafka.coordinator.transaction.PrepareCommit$;
import kafka.coordinator.transaction.TransactionConfig;
import kafka.coordinator.transaction.TransactionLog$;
import kafka.coordinator.transaction.TransactionMetadata;
import kafka.coordinator.transaction.TransactionPartitionAndLeaderEpoch;
import kafka.coordinator.transaction.TransactionState;
import kafka.coordinator.transaction.TransactionState$;
import kafka.coordinator.transaction.TransactionStateManager$;
import kafka.coordinator.transaction.TransactionalIdAndProducerIdEpoch;
import kafka.coordinator.transaction.TransactionalIdCoordinatorEpochAndMetadata;
import kafka.coordinator.transaction.TransactionalIdCoordinatorEpochAndTransitMetadata;
import kafka.coordinator.transaction.TxnMetadataCacheEntry;
import kafka.coordinator.transaction.TxnTransitMetadata;
import kafka.log.AppendOrigin$Coordinator$;
import kafka.log.Log;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.message.UncompressedCodec$;
import kafka.server.FetchDataInfo;
import kafka.server.FetchLogEnd$;
import kafka.server.ReplicaManager;
import kafka.server.RequestLocal;
import kafka.server.RequestLocal$;
import kafka.utils.Implicits$MapExtensionMethods$;
import kafka.utils.Logging;
import kafka.utils.Pool;
import kafka.utils.Scheduler;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.ListTransactionsResponseData;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Avg;
import org.apache.kafka.common.metrics.stats.Max;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.MutableRecordBatch;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordConversionStats;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.requests.TransactionResult;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function4;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0005\r}t!B!C\u0011\u0003Ie!B&C\u0011\u0003a\u0005\"B*\u0002\t\u0003!\u0006bB+\u0002\u0005\u0004%\tA\u0016\u0005\u00075\u0006\u0001\u000b\u0011B,\t\u000fm\u000b!\u0019!C\u0001-\"1A,\u0001Q\u0001\n]Cq!X\u0001C\u0002\u0013\u0005a\u000b\u0003\u0004_\u0003\u0001\u0006Ia\u0016\u0005\b?\u0006\u0011\r\u0011\"\u0001W\u0011\u0019\u0001\u0017\u0001)A\u0005/\"9\u0011-\u0001b\u0001\n\u0003\u0011\u0007B\u00028\u0002A\u0003%1\rC\u0004p\u0003\t\u0007I\u0011\u00012\t\rA\f\u0001\u0015!\u0003d\r\u0011Y%\tA9\t\u0011a|!\u0011!Q\u0001\n]C\u0001\"_\b\u0003\u0002\u0003\u0006IA\u001f\u0005\t{>\u0011\t\u0011)A\u0005}\"Q\u0011\u0011B\b\u0003\u0002\u0003\u0006I!a\u0003\t\u0015\u0005EqB!A!\u0002\u0013\t\u0019\u0002\u0003\u0006\u0002,=\u0011\t\u0011)A\u0005\u0003[AaaU\b\u0005\u0002\u0005]RABA$\u001f\u0001\tI\u0005C\u0005\u0002n=\u0011\r\u0011\"\u0003\u0002p!A\u0011\u0011R\b!\u0002\u0013\t\t\bC\u0005\u0002\f>\u0011\r\u0011\"\u0003\u0002\u000e\"A\u00111T\b!\u0002\u0013\ty\t\u0003\u0006\u0002\u001e>\u0011\r\u0011\"\u0001C\u0003?C\u0001\"a.\u0010A\u0003%\u0011\u0011\u0015\u0005\u000b\u0003s{!\u0019!C\u0001\u0005\u0006m\u0006\u0002CAe\u001f\u0001\u0006I!!0\t\u0017\u0005-w\u00021AA\u0002\u0013%\u0011Q\u001a\u0005\f\u0003+|\u0001\u0019!a\u0001\n\u0013\t9\u000eC\u0006\u0002^>\u0001\r\u0011!Q!\n\u0005=\u0007BCAp\u001f\u0001\u0007\t\u0019!C\u0005-\"Y\u0011\u0011]\bA\u0002\u0003\u0007I\u0011BAr\u0011)\t9o\u0004a\u0001\u0002\u0003\u0006Ka\u0016\u0005\n\u0003c|!\u0019!C\u0005\u0003gD\u0001\"a?\u0010A\u0003%\u0011Q\u001f\u0005\t\u0003{|A\u0011\u0001\"\u0002\u0000\"9!\u0011B\b\u0005\u0002\t-\u0001b\u0002B\u0013\u001f\u0011%!q\u0005\u0005\b\u0005syA\u0011\u0002B\u001e\u0011\u001d\u0011\tf\u0004C\u0005\u0005'B\u0001B!\n\u0010\t\u0003\u0011%\u0011\u000e\u0005\b\u0005WzA\u0011\u0002B7\u0011\u001d\u00119i\u0004C\u0001\u0005SBqA!#\u0010\t\u0003\u0011Y\tC\u0004\u00030>!\tA!-\t\u000f\t]v\u0002\"\u0001\u0003:\"9!Q[\b\u0005\n\t]\u0007b\u0002Bq\u001f\u0011\u0005!1\u001d\u0005\b\u0005S|A\u0011\u0001Bv\u0011\u001d\u0011)p\u0004C\u0001\u0005oDqAa?\u0010\t\u0013\u0011i\u0010\u0003\u0005\u0004\f=!\tAQB\u0007\u0011\u001d\u0019Ib\u0004C\u0001\u00077Aqa!\u000b\u0010\t\u0003\u0019Y\u0003C\u0004\u0004*=!\taa\f\t\u000f\rUr\u0002\"\u0003\u0003j!91qG\b\u0005\u0002\re\u0002\"CB/\u001fE\u0005I\u0011AB0\u0011\u001d\u0019)h\u0004C\u0001\u0007oBqa! \u0010\t\u0003\u0011I'A\fUe\u0006t7/Y2uS>t7\u000b^1uK6\u000bg.Y4fe*\u00111\tR\u0001\fiJ\fgn]1di&|gN\u0003\u0002F\r\u0006Y1m\\8sI&t\u0017\r^8s\u0015\u00059\u0015!B6bM.\f7\u0001\u0001\t\u0003\u0015\u0006i\u0011A\u0011\u0002\u0018)J\fgn]1di&|gn\u0015;bi\u0016l\u0015M\\1hKJ\u001c\"!A'\u0011\u00059\u000bV\"A(\u000b\u0003A\u000bQa]2bY\u0006L!AU(\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t\u0011*A\u0010EK\u001a\fW\u000f\u001c;Ue\u0006t7/Y2uS>t7/T1y)&lWm\\;u\u001bN,\u0012a\u0016\t\u0003\u001dbK!!W(\u0003\u0007%sG/\u0001\u0011EK\u001a\fW\u000f\u001c;Ue\u0006t7/Y2uS>t7/T1y)&lWm\\;u\u001bN\u0004\u0013A\t#fM\u0006,H\u000e\u001e+sC:\u001c\u0018m\u0019;j_:\fG.\u00133FqBL'/\u0019;j_:l5/A\u0012EK\u001a\fW\u000f\u001c;Ue\u0006t7/Y2uS>t\u0017\r\\%e\u000bb\u0004\u0018N]1uS>tWj\u001d\u0011\u0002U\u0011+g-Y;mi\u0006\u0013wN\u001d;US6,GmT;u)J\fgn]1di&|gn]%oi\u0016\u0014h/\u00197Ng\u0006YC)\u001a4bk2$\u0018IY8siRKW.\u001a3PkR$&/\u00198tC\u000e$\u0018n\u001c8t\u0013:$XM\u001d<bY6\u001b\b%\u0001\u0018EK\u001a\fW\u000f\u001c;SK6|g/Z#ya&\u0014X\r\u001a+sC:\u001c\u0018m\u0019;j_:\fG.\u00133t\u0013:$XM\u001d<bY6\u001b\u0018a\f#fM\u0006,H\u000e\u001e*f[>4X-\u0012=qSJ,G\r\u0016:b]N\f7\r^5p]\u0006d\u0017\nZ:J]R,'O^1m\u001bN\u0004\u0013\u0001D'fiJL7m]$s_V\u0004X#A2\u0011\u0005\u0011\\gBA3j!\t1w*D\u0001h\u0015\tA\u0007*\u0001\u0004=e>|GOP\u0005\u0003U>\u000ba\u0001\u0015:fI\u00164\u0017B\u00017n\u0005\u0019\u0019FO]5oO*\u0011!nT\u0001\u000e\u001b\u0016$(/[2t\u000fJ|W\u000f\u001d\u0011\u0002\u001d1{\u0017\r\u001a+j[\u0016\u001cVM\\:pe\u0006yAj\\1e)&lWmU3og>\u0014\beE\u0002\u0010\u001bJ\u0004\"a\u001d<\u000e\u0003QT!!\u001e$\u0002\u000bU$\u0018\u000e\\:\n\u0005]$(a\u0002'pO\u001eLgnZ\u0001\tEJ|7.\u001a:JI\u0006I1o\u00195fIVdWM\u001d\t\u0003gnL!\u0001 ;\u0003\u0013M\u001b\u0007.\u001a3vY\u0016\u0014\u0018A\u0004:fa2L7-Y'b]\u0006<WM\u001d\t\u0004\u007f\u0006\u0015QBAA\u0001\u0015\r\t\u0019AR\u0001\u0007g\u0016\u0014h/\u001a:\n\t\u0005\u001d\u0011\u0011\u0001\u0002\u000f%\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s\u0003\u0019\u0019wN\u001c4jOB\u0019!*!\u0004\n\u0007\u0005=!IA\tUe\u0006t7/Y2uS>t7i\u001c8gS\u001e\fA\u0001^5nKB!\u0011QCA\u0014\u001b\t\t9BC\u0002v\u00033QA!a\u0007\u0002\u001e\u000511m\\7n_:T1aRA\u0010\u0015\u0011\t\t#a\t\u0002\r\u0005\u0004\u0018m\u00195f\u0015\t\t)#A\u0002pe\u001eLA!!\u000b\u0002\u0018\t!A+[7f\u0003\u001diW\r\u001e:jGN\u0004B!a\f\u000245\u0011\u0011\u0011\u0007\u0006\u0005\u0003W\tI\"\u0003\u0003\u00026\u0005E\"aB'fiJL7m\u001d\u000b\u000f\u0003s\tY$!\u0010\u0002@\u0005\u0005\u00131IA#!\tQu\u0002C\u0003y-\u0001\u0007q\u000bC\u0003z-\u0001\u0007!\u0010C\u0003~-\u0001\u0007a\u0010C\u0004\u0002\nY\u0001\r!a\u0003\t\u000f\u0005Ea\u00031\u0001\u0002\u0014!9\u00111\u0006\fA\u0002\u00055\"AF*f]\u0012$\u0006P\\'be.,'o]\"bY2\u0014\u0017mY6\u0011\u00199\u000bYeVA(\u00037\n\t'a\u001a\n\u0007\u00055sJA\u0005Gk:\u001cG/[8oiA!\u0011\u0011KA,\u001b\t\t\u0019F\u0003\u0003\u0002V\u0005e\u0011\u0001\u0003:fcV,7\u000f^:\n\t\u0005e\u00131\u000b\u0002\u0012)J\fgn]1di&|gNU3tk2$\bc\u0001&\u0002^%\u0019\u0011q\f\"\u0003'Q\u0013\u0018M\\:bGRLwN\\'fi\u0006$\u0017\r^1\u0011\u0007)\u000b\u0019'C\u0002\u0002f\t\u0013!\u0003\u0016=o)J\fgn]5u\u001b\u0016$\u0018\rZ1uCB\u0019a*!\u001b\n\u0007\u0005-tJ\u0001\u0003V]&$\u0018\u0001D:ikR$\u0018N\\4E_^tWCAA9!\u0011\t\u0019(!\"\u000e\u0005\u0005U$\u0002BA<\u0003s\na!\u0019;p[&\u001c'\u0002BA>\u0003{\n!bY8oGV\u0014(/\u001a8u\u0015\u0011\ty(!!\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0003\u0007\u000bAA[1wC&!\u0011qQA;\u00055\tEo\\7jG\n{w\u000e\\3b]\u0006i1\u000f[;ui&tw\rR8x]\u0002\n\u0011b\u001d;bi\u0016dunY6\u0016\u0005\u0005=\u0005\u0003BAI\u0003/k!!a%\u000b\t\u0005U\u0015\u0011P\u0001\u0006Y>\u001c7n]\u0005\u0005\u00033\u000b\u0019J\u0001\fSK\u0016tGO]1oiJ+\u0017\rZ,sSR,Gj\\2l\u0003)\u0019H/\u0019;f\u0019>\u001c7\u000eI\u0001\u0012Y>\fG-\u001b8h!\u0006\u0014H/\u001b;j_:\u001cXCAAQ!\u0019\t\u0019+!,\u000226\u0011\u0011Q\u0015\u0006\u0005\u0003O\u000bI+A\u0004nkR\f'\r\\3\u000b\u0007\u0005-v*\u0001\u0006d_2dWm\u0019;j_:LA!a,\u0002&\n\u00191+\u001a;\u0011\u0007)\u000b\u0019,C\u0002\u00026\n\u0013!\u0005\u0016:b]N\f7\r^5p]B\u000b'\u000f^5uS>t\u0017I\u001c3MK\u0006$WM]#q_\u000eD\u0017A\u00057pC\u0012Lgn\u001a)beRLG/[8og\u0002\n\u0001\u0004\u001e:b]N\f7\r^5p]6+G/\u00193bi\u0006\u001c\u0015m\u00195f+\t\ti\fE\u0004\u0002$\u0006}v+a1\n\t\u0005\u0005\u0017Q\u0015\u0002\u0004\u001b\u0006\u0004\bc\u0001&\u0002F&\u0019\u0011q\u0019\"\u0003+QCh.T3uC\u0012\fG/Y\"bG\",WI\u001c;ss\u0006IBO]1og\u0006\u001cG/[8o\u001b\u0016$\u0018\rZ1uC\u000e\u000b7\r[3!\u0003\u0019\u0012X\r\u001e:jKZ,GK]1og\u0006\u001cG/[8o)>\u0004\u0018n\u0019)beRLG/[8o\u0007>,h\u000e^\u000b\u0003\u0003\u001f\u0004BATAi/&\u0019\u00111[(\u0003\u0013\u0019+hn\u0019;j_:\u0004\u0014A\u000b:fiJLWM^3Ue\u0006t7/Y2uS>tGk\u001c9jGB\u000b'\u000f^5uS>t7i\\;oi~#S-\u001d\u000b\u0005\u0003O\nI\u000eC\u0005\u0002\\\u0006\n\t\u00111\u0001\u0002P\u0006\u0019\u0001\u0010J\u0019\u0002OI,GO]5fm\u0016$&/\u00198tC\u000e$\u0018n\u001c8U_BL7\rU1si&$\u0018n\u001c8D_VtG\u000fI\u0001\u001fiJ\fgn]1di&|g\u000eV8qS\u000e\u0004\u0016M\u001d;ji&|gnQ8v]R\f!\u0005\u001e:b]N\f7\r^5p]R{\u0007/[2QCJ$\u0018\u000e^5p]\u000e{WO\u001c;`I\u0015\fH\u0003BA4\u0003KD\u0001\"a7%\u0003\u0003\u0005\raV\u0001 iJ\fgn]1di&|g\u000eV8qS\u000e\u0004\u0016M\u001d;ji&|gnQ8v]R\u0004\u0003fA\u0013\u0002lB\u0019a*!<\n\u0007\u0005=xJ\u0001\u0005w_2\fG/\u001b7f\u0003M\u0001\u0018M\u001d;ji&|g\u000eT8bIN+gn]8s+\t\t)\u0010\u0005\u0003\u00020\u0005]\u0018\u0002BA}\u0003c\u0011aaU3og>\u0014\u0018\u0001\u00069beRLG/[8o\u0019>\fGmU3og>\u0014\b%A\nbI\u0012du.\u00193j]\u001e\u0004\u0016M\u001d;ji&|g\u000e\u0006\u0004\u0002h\t\u0005!Q\u0001\u0005\u0007\u0005\u0007A\u0003\u0019A,\u0002\u0017A\f'\u000f^5uS>t\u0017\n\u001a\u0005\u0007\u0005\u000fA\u0003\u0019A,\u0002!\r|wN\u001d3j]\u0006$xN]#q_\u000eD\u0017\u0001\u0006;j[\u0016$w*\u001e;Ue\u0006t7/Y2uS>t7\u000f\u0006\u0002\u0003\u000eA1!q\u0002B\r\u0005?qAA!\u0005\u0003\u00169\u0019aMa\u0005\n\u0003AK1Aa\u0006P\u0003\u001d\u0001\u0018mY6bO\u0016LAAa\u0007\u0003\u001e\tA\u0011\n^3sC\ndWMC\u0002\u0003\u0018=\u00032A\u0013B\u0011\u0013\r\u0011\u0019C\u0011\u0002\")J\fgn]1di&|g.\u00197JI\u0006sG\r\u0015:pIV\u001cWM]%e\u000bB|7\r[\u0001\u001ee\u0016lwN^3FqBL'/\u001a3Ue\u0006t7/Y2uS>t\u0017\r\\%egR1\u0011q\rB\u0015\u0005kAqAa\u000b+\u0001\u0004\u0011i#\u0001\u000bue\u0006t7/Y2uS>t\u0007+\u0019:uSRLwN\u001c\t\u0005\u0005_\u0011\t$\u0004\u0002\u0002\u001a%!!1GA\r\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:DqAa\u000e+\u0001\u0004\t\u0019-A\u000buq:lU\r^1eCR\f7)Y2iK\u0016sGO]=\u0002\u0019MDw.\u001e7e\u000bb\u0004\u0018N]3\u0015\r\tu\"1\tB$!\rq%qH\u0005\u0004\u0005\u0003z%a\u0002\"p_2,\u0017M\u001c\u0005\b\u0005\u000bZ\u0003\u0019AA.\u0003-!\bP\\'fi\u0006$\u0017\r^1\t\u000f\t%3\u00061\u0001\u0003L\u0005i1-\u001e:sK:$H+[7f\u001bN\u00042A\u0014B'\u0013\r\u0011ye\u0014\u0002\u0005\u0019>tw-A\u000bnCf\u0014W-\u00119qK:$W\t\u001f9je\u0006$\u0018n\u001c8\u0015\u0011\tu\"Q\u000bB,\u0005OBqA!\u0012-\u0001\u0004\tY\u0006C\u0004\u0003Z1\u0002\rAa\u0017\u0002\u001dI,7m\u001c:eg\n+\u0018\u000e\u001c3feB!!Q\fB2\u001b\t\u0011yF\u0003\u0003\u0003b\u0005e\u0011A\u0002:fG>\u0014H-\u0003\u0003\u0003f\t}#\u0001F'f[>\u0014\u0018PU3d_J$7OQ;jY\u0012,'\u000fC\u0004\u0003J1\u0002\rAa\u0013\u0015\u0005\u0005\u001d\u0014!K<sSR,Gk\\7cgR|g.Z:G_J,\u0005\u0010]5sK\u0012$&/\u00198tC\u000e$\u0018n\u001c8bY&#7\u000f\u0006\u0005\u0002h\t=$\u0011\u000fB?\u0011\u001d\u0011YC\fa\u0001\u0005[AqAa\u001d/\u0001\u0004\u0011)(A\nfqBL'/\u001a3G_J\u0004\u0016M\u001d;ji&|g\u000e\u0005\u0004\u0003\u0010\te!q\u000f\t\u0004\u0015\ne\u0014b\u0001B>\u0005\nQCK]1og\u0006\u001cG/[8oC2LEmQ8pe\u0012Lg.\u0019;pe\u0016\u0003xn\u00195B]\u0012lU\r^1eCR\f\u0007b\u0002B@]\u0001\u0007!\u0011Q\u0001\u0011i>l'm\u001d;p]\u0016\u0014VmY8sIN\u0004BA!\u0018\u0003\u0004&!!Q\u0011B0\u00055iU-\\8ssJ+7m\u001c:eg\u0006yRM\\1cY\u0016$&/\u00198tC\u000e$\u0018n\u001c8bY&#W\t\u001f9je\u0006$\u0018n\u001c8\u0002'\u001d,G\u000f\u0016:b]N\f7\r^5p]N#\u0018\r^3\u0015\t\t5%1\u0016\t\t\u0005\u001f\u0011yIa%\u0003 &!!\u0011\u0013B\u000f\u0005\u0019)\u0015\u000e\u001e5feB!!Q\u0013BN\u001b\t\u00119J\u0003\u0003\u0003\u001a\u0006e\u0011\u0001\u00039s_R|7m\u001c7\n\t\tu%q\u0013\u0002\u0007\u000bJ\u0014xN]:\u0011\u000b9\u0013\tK!*\n\u0007\t\rvJ\u0001\u0004PaRLwN\u001c\t\u0004\u0015\n\u001d\u0016b\u0001BU\u0005\nq2i\\8sI&t\u0017\r^8s\u000bB|7\r[!oIRCh.T3uC\u0012\fG/\u0019\u0005\u0007\u0005[\u0003\u0004\u0019A2\u0002\u001fQ\u0014\u0018M\\:bGRLwN\\1m\u0013\u0012\fa\u0004];u)J\fgn]1di&|gn\u0015;bi\u0016LeMT8u\u000bbL7\u000f^:\u0015\t\tM&Q\u0017\t\t\u0005\u001f\u0011yIa%\u0003&\"9!QI\u0019A\u0002\u0005m\u0013!\u00067jgR$&/\u00198tC\u000e$\u0018n\u001c8Ti\u0006$Xm\u001d\u000b\u0007\u0005w\u00139Ma4\u0011\t\tu&1Y\u0007\u0003\u0005\u007fSAA!1\u0002\u001a\u00059Q.Z:tC\u001e,\u0017\u0002\u0002Bc\u0005\u007f\u0013A\u0004T5tiR\u0013\u0018M\\:bGRLwN\\:SKN\u0004xN\\:f\t\u0006$\u0018\rC\u0004\u0003JJ\u0002\rAa3\u0002#\u0019LG\u000e^3s!J|G-^2fe&#7\u000fE\u0003e\u0005\u001b\u0014Y%C\u0002\u000206DqA!53\u0001\u0004\u0011\u0019.\u0001\tgS2$XM]*uCR,g*Y7fgB!AM!4d\u0003y9W\r^!oI6\u000b\u0017PY3BI\u0012$&/\u00198tC\u000e$\u0018n\u001c8Ti\u0006$X\r\u0006\u0004\u0003\u000e\ne'1\u001c\u0005\u0007\u0005[\u001b\u0004\u0019A2\t\u000f\tu7\u00071\u0001\u0003`\u0006)2M]3bi\u0016$G\u000b\u001f8NKR\fG-\u0019;b\u001fB$\b#\u0002(\u0003\"\u0006m\u0013\u0001\b<bY&$\u0017\r^3Ue\u0006t7/Y2uS>tG+[7f_V$Xj\u001d\u000b\u0005\u0005{\u0011)\u000f\u0003\u0004\u0003hR\u0002\raV\u0001\ribtG+[7f_V$Xj]\u0001\u0018iJ\fgn]1di&|g\u000eV8qS\u000e\u001cuN\u001c4jON,\"A!<\u0011\t\t=(\u0011_\u0007\u0003\u0003{JAAa=\u0002~\tQ\u0001K]8qKJ$\u0018.Z:\u0002\u0019A\f'\u000f^5uS>tgi\u001c:\u0015\u0007]\u0013I\u0010\u0003\u0004\u0003.Z\u0002\raY\u0001\u0018Y>\fG\r\u0016:b]N\f7\r^5p]6+G/\u00193bi\u0006$bAa@\u0004\u0006\r%\u0001CB:\u0004\u0002\r\fY&C\u0002\u0004\u0004Q\u0014A\u0001U8pY\"91qA\u001cA\u0002\t5\u0012A\u0004;pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0005\u0007\u0005\u000f9\u0004\u0019A,\u00029\u0005$G\rT8bI\u0016$GK]1og\u0006\u001cG/[8ogR{7)Y2iKRA\u0011qMB\b\u0007'\u0019)\u0002\u0003\u0004\u0004\u0012a\u0002\raV\u0001\u0012ibtGk\u001c9jGB\u000b'\u000f^5uS>t\u0007B\u0002B\u0004q\u0001\u0007q\u000bC\u0004\u0004\u0018a\u0002\rAa@\u0002%1|\u0017\rZ3e)J\fgn]1di&|gn]\u0001%Y>\fG\r\u0016:b]N\f7\r^5p]N4uN\u001d+y]R{\u0007/[2QCJ$\u0018\u000e^5p]RA\u0011qMB\u000f\u0007?\u0019\t\u0003\u0003\u0004\u0003\u0004e\u0002\ra\u0016\u0005\u0007\u0005\u000fI\u0004\u0019A,\t\u000f\r\r\u0012\b1\u0001\u0004&\u0005q1/\u001a8e)btW*\u0019:lKJ\u001c\bcAB\u0014/5\tq\"\u0001\u0014sK6|g/\u001a+sC:\u001c\u0018m\u0019;j_:\u001chi\u001c:Uq:$v\u000e]5d!\u0006\u0014H/\u001b;j_:$B!a\u001a\u0004.!1!1\u0001\u001eA\u0002]#b!a\u001a\u00042\rM\u0002B\u0002B\u0002w\u0001\u0007q\u000b\u0003\u0004\u0003\bm\u0002\raV\u0001/m\u0006d\u0017\u000eZ1uKR\u0013\u0018M\\:bGRLwN\u001c+pa&\u001c\u0007+\u0019:uSRLwN\\\"pk:$\u0018j]*uC\ndW-\u0001\fbaB,g\u000e\u001a+sC:\u001c\u0018m\u0019;j_:$v\u000eT8h)9\t9ga\u000f\u0004>\r}21IB'\u0007'BaA!,>\u0001\u0004\u0019\u0007B\u0002B\u0004{\u0001\u0007q\u000bC\u0004\u0004Bu\u0002\r!!\u0019\u0002\u00179,w/T3uC\u0012\fG/\u0019\u0005\b\u0007\u000bj\u0004\u0019AB$\u0003A\u0011Xm\u001d9p]N,7)\u00197mE\u0006\u001c7\u000eE\u0004O\u0007\u0013\u0012\u0019*a\u001a\n\u0007\r-sJA\u0005Gk:\u001cG/[8oc!I1qJ\u001f\u0011\u0002\u0003\u00071\u0011K\u0001\re\u0016$(/_(o\u000bJ\u0014xN\u001d\t\b\u001d\u000e%#1\u0013B\u001f\u0011\u001d\u0019)&\u0010a\u0001\u0007/\nAB]3rk\u0016\u001cH\u000fT8dC2\u00042a`B-\u0013\u0011\u0019Y&!\u0001\u0003\u0019I+\u0017/^3ti2{7-\u00197\u0002A\u0005\u0004\b/\u001a8e)J\fgn]1di&|g\u000eV8M_\u001e$C-\u001a4bk2$H%N\u000b\u0003\u0007CRCa!\u0015\u0004d-\u00121Q\r\t\u0005\u0007O\u001a\t(\u0004\u0002\u0004j)!11NB7\u0003%)hn\u00195fG.,GMC\u0002\u0004p=\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\u0019\u0019h!\u001b\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u0004ti\u0006\u0014H/\u001e9\u0015\r\u0005\u001d4\u0011PB>\u0011\u001d\tYm\u0010a\u0001\u0003\u001fDqAa\"@\u0001\u0004\u0011i$\u0001\u0005tQV$Hm\\<o\u0001")
public class TransactionStateManager
implements Logging {
    private final Scheduler scheduler;
    private final ReplicaManager replicaManager;
    private final TransactionConfig config;
    private final Time time;
    private final AtomicBoolean shuttingDown;
    private final ReentrantReadWriteLock stateLock;
    private final Set<TransactionPartitionAndLeaderEpoch> loadingPartitions;
    private final scala.collection.mutable.Map<Object, TxnMetadataCacheEntry> transactionMetadataCache;
    private Function0<Object> retrieveTransactionTopicPartitionCount;
    private volatile int transactionTopicPartitionCount;
    private final Sensor partitionLoadSensor;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static String LoadTimeSensor() {
        return TransactionStateManager$.MODULE$.LoadTimeSensor();
    }

    public static String MetricsGroup() {
        return TransactionStateManager$.MODULE$.MetricsGroup();
    }

    public static int DefaultRemoveExpiredTransactionalIdsIntervalMs() {
        return TransactionStateManager$.MODULE$.DefaultRemoveExpiredTransactionalIdsIntervalMs();
    }

    public static int DefaultAbortTimedOutTransactionsIntervalMs() {
        return TransactionStateManager$.MODULE$.DefaultAbortTimedOutTransactionsIntervalMs();
    }

    public static int DefaultTransactionalIdExpirationMs() {
        return TransactionStateManager$.MODULE$.DefaultTransactionalIdExpirationMs();
    }

    public static int DefaultTransactionsMaxTimeoutMs() {
        return TransactionStateManager$.MODULE$.DefaultTransactionsMaxTimeoutMs();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private AtomicBoolean shuttingDown() {
        return this.shuttingDown;
    }

    private ReentrantReadWriteLock stateLock() {
        return this.stateLock;
    }

    public Set<TransactionPartitionAndLeaderEpoch> loadingPartitions() {
        return this.loadingPartitions;
    }

    public scala.collection.mutable.Map<Object, TxnMetadataCacheEntry> transactionMetadataCache() {
        return this.transactionMetadataCache;
    }

    private Function0<Object> retrieveTransactionTopicPartitionCount() {
        return this.retrieveTransactionTopicPartitionCount;
    }

    private void retrieveTransactionTopicPartitionCount_$eq(Function0<Object> x$1) {
        this.retrieveTransactionTopicPartitionCount = x$1;
    }

    private int transactionTopicPartitionCount() {
        return this.transactionTopicPartitionCount;
    }

    private void transactionTopicPartitionCount_$eq(int x$1) {
        this.transactionTopicPartitionCount = x$1;
    }

    private Sensor partitionLoadSensor() {
        return this.partitionLoadSensor;
    }

    public void addLoadingPartition(int partitionId, int coordinatorEpoch) {
        TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch = new TransactionPartitionAndLeaderEpoch(partitionId, coordinatorEpoch);
        Lock inWriteLock_inLock_lock = this.stateLock().writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            TransactionStateManager.$anonfun$addLoadingPartition$1(this, partitionAndLeaderEpoch);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    public Iterable<TransactionalIdAndProducerIdEpoch> timedOutTransactions() {
        scala.collection.mutable.Iterable iterable;
        long now = this.time.milliseconds();
        Lock inReadLock_inLock_lock = this.stateLock().readLock();
        inReadLock_inLock_lock.lock();
        try {
            iterable = TransactionStateManager.$anonfun$timedOutTransactions$1(this, now);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
        return iterable;
    }

    private void removeExpiredTransactionalIds(TopicPartition transactionPartition, TxnMetadataCacheEntry txnMetadataCacheEntry) {
        Lock inReadLock_inLock_lock = this.stateLock().readLock();
        inReadLock_inLock_lock.lock();
        try {
            TransactionStateManager.$anonfun$removeExpiredTransactionalIds$1(this, transactionPartition, txnMetadataCacheEntry);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
    }

    private boolean shouldExpire(TransactionMetadata txnMetadata, long currentTimeMs) {
        return txnMetadata.state().isExpirationAllowed() && txnMetadata.txnLastUpdateTimestamp() <= currentTimeMs - (long)this.config.transactionalIdExpirationMs();
    }

    private boolean maybeAppendExpiration(TransactionMetadata txnMetadata, MemoryRecordsBuilder recordsBuilder, long currentTimeMs) {
        byte[] keyBytes = TransactionLog$.MODULE$.keyToBytes(txnMetadata.transactionalId());
        if (recordsBuilder.hasRoomFor(currentTimeMs, keyBytes, null, Record.EMPTY_HEADERS)) {
            recordsBuilder.append(currentTimeMs, keyBytes, null, Record.EMPTY_HEADERS);
            return true;
        }
        return false;
    }

    public void removeExpiredTransactionalIds() {
        Lock inReadLock_inLock_lock = this.stateLock().readLock();
        inReadLock_inLock_lock.lock();
        try {
            TransactionStateManager.$anonfun$removeExpiredTransactionalIds$4(this);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
    }

    private void writeTombstonesForExpiredTransactionalIds(TopicPartition transactionPartition, Iterable<TransactionalIdCoordinatorEpochAndMetadata> expiredForPartition, MemoryRecords tombstoneRecords) {
        Lock inReadLock_inLock_lock = this.stateLock().readLock();
        inReadLock_inLock_lock.lock();
        try {
            TransactionStateManager.$anonfun$writeTombstonesForExpiredTransactionalIds$7(this, transactionPartition, tombstoneRecords, expiredForPartition);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
    }

    public void enableTransactionalIdExpiration() {
        this.scheduler.schedule("transactionalId-expiration", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.removeExpiredTransactionalIds(), this.config.removeExpiredTransactionalIdsIntervalMs(), this.config.removeExpiredTransactionalIdsIntervalMs(), this.scheduler.schedule$default$5());
    }

    public Either<Errors, Option<CoordinatorEpochAndTxnMetadata>> getTransactionState(String transactionalId) {
        return this.getAndMaybeAddTransactionState(transactionalId, (Option<TransactionMetadata>)None$.MODULE$);
    }

    public Either<Errors, CoordinatorEpochAndTxnMetadata> putTransactionStateIfNotExists(TransactionMetadata txnMetadata) {
        return this.getAndMaybeAddTransactionState(txnMetadata.transactionalId(), (Option<TransactionMetadata>)new Some((Object)txnMetadata)).map((Function1 & Serializable)x$3 -> (CoordinatorEpochAndTxnMetadata)x$3.getOrElse((Function0 & Serializable)() -> {
            throw new IllegalStateException(new StringBuilder(61).append("Unexpected empty transaction metadata returned while putting ").append(txnMetadata).toString());
        }));
    }

    public ListTransactionsResponseData listTransactionStates(scala.collection.immutable.Set<Object> filterProducerIds, scala.collection.immutable.Set<String> filterStateNames) {
        ListTransactionsResponseData listTransactionsResponseData;
        Lock inReadLock_inLock_lock = this.stateLock().readLock();
        inReadLock_inLock_lock.lock();
        try {
            listTransactionsResponseData = TransactionStateManager.$anonfun$listTransactionStates$1(this, filterStateNames, filterProducerIds);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
        return listTransactionsResponseData;
    }

    private Either<Errors, Option<CoordinatorEpochAndTxnMetadata>> getAndMaybeAddTransactionState(String transactionalId, Option<TransactionMetadata> createdTxnMetadataOpt) {
        Either either;
        Lock inReadLock_inLock_lock = this.stateLock().readLock();
        inReadLock_inLock_lock.lock();
        try {
            either = TransactionStateManager.$anonfun$getAndMaybeAddTransactionState$1(this, transactionalId, createdTxnMetadataOpt);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
        return either;
    }

    public boolean validateTransactionTimeoutMs(int txnTimeoutMs) {
        return txnTimeoutMs <= this.config.transactionMaxTimeoutMs() && txnTimeoutMs > 0;
    }

    /*
     * WARNING - void declaration
     */
    public Properties transactionTopicConfigs() {
        void var1_1;
        Properties props = new Properties();
        props.put(LogConfig$.MODULE$.UncleanLeaderElectionEnableProp(), "false");
        props.put(LogConfig$.MODULE$.CompressionTypeProp(), UncompressedCodec$.MODULE$.name());
        props.put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact());
        props.put(LogConfig$.MODULE$.MinInSyncReplicasProp(), Integer.toString(this.config.transactionLogMinInsyncReplicas()));
        props.put(LogConfig$.MODULE$.SegmentBytesProp(), Integer.toString(this.config.transactionLogSegmentBytes()));
        return var1_1;
    }

    public int partitionFor(String transactionalId) {
        return Utils.abs((int)transactionalId.hashCode()) % this.transactionTopicPartitionCount();
    }

    private Pool<String, TransactionMetadata> loadTransactionMetadata(TopicPartition topicPartition, int coordinatorEpoch) {
        Pool<String, TransactionMetadata> loadedTransactions = new Pool<String, TransactionMetadata>((Option<Function1<String, TransactionMetadata>>)None$.MODULE$);
        Option<Log> option = this.replicaManager.getLog(topicPartition);
        if (None$.MODULE$.equals(option)) {
            this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(62).append("Attempted to load transaction metadata from ").append(topicPartition).append(", but found no log").toString());
        } else if (option instanceof Some) {
            Log log = (Log)((Some)option).value();
            ByteBuffer buffer = ByteBuffer.allocate(0);
            LongRef currOffset = LongRef.create((long)log.logStartOffset());
            boolean readAtLeastOneRecord = true;
            try {
                while (currOffset.elem < this.logEndOffset$1(topicPartition) && readAtLeastOneRecord && !this.shuttingDown().get()) {
                    MemoryRecords memoryRecords;
                    boolean bl;
                    Lock inReadLock_inLock_lock = this.stateLock().readLock();
                    inReadLock_inLock_lock.lock();
                    try {
                        bl = TransactionStateManager.$anonfun$loadTransactionMetadata$3(this, topicPartition, coordinatorEpoch);
                    }
                    finally {
                        inReadLock_inLock_lock.unlock();
                    }
                    Object var16_15 = null;
                    Object var17_16 = null;
                    if (!bl) break;
                    FetchDataInfo fetchDataInfo = log.read(currOffset.elem, this.config.transactionLogLoadBufferSize(), FetchLogEnd$.MODULE$, true);
                    readAtLeastOneRecord = fetchDataInfo.records().sizeInBytes() > 0;
                    Records records = fetchDataInfo.records();
                    if (records instanceof MemoryRecords) {
                        memoryRecords = (MemoryRecords)records;
                    } else if (records instanceof FileRecords) {
                        FileRecords fileRecords = (FileRecords)records;
                        int sizeInBytes = fileRecords.sizeInBytes();
                        int bytesNeeded = Math.max(this.config.transactionLogLoadBufferSize(), sizeInBytes);
                        if (buffer.capacity() < bytesNeeded) {
                            if (this.config.transactionLogLoadBufferSize() < bytesNeeded) {
                                this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(67).append("Loaded transaction metadata from ").append(topicPartition).append(" with buffer larger (").append(bytesNeeded).append(" bytes) than ").toString()).append(new StringBuilder(58).append("configured transaction.state.log.load.buffer.size (").append($this.config.transactionLogLoadBufferSize()).append(" bytes)").toString()).toString());
                            }
                            buffer = ByteBuffer.allocate(bytesNeeded);
                        } else {
                            buffer.clear();
                        }
                        buffer.clear();
                        fileRecords.readInto(buffer, 0);
                        memoryRecords = MemoryRecords.readableRecords((ByteBuffer)buffer);
                    } else {
                        throw new MatchError((Object)records);
                    }
                    memoryRecords.batches().forEach(batch -> CollectionConverters$.MODULE$.IterableHasAsScala((java.lang.Iterable)batch).asScala().foreach((Function1 & Serializable)record -> {
                        TransactionStateManager.$anonfun$loadTransactionMetadata$7(loadedTransactions, currOffset, batch, record);
                        return BoxedUnit.UNIT;
                    }));
                }
            }
            catch (Throwable t) {
                this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(48).append("Error loading transactions from transaction log ").append(topicPartition).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> t);
            }
        } else {
            throw new MatchError(option);
        }
        return loadedTransactions;
    }

    public void addLoadedTransactionsToCache(int txnTopicPartition, int coordinatorEpoch, Pool<String, TransactionMetadata> loadedTransactions) {
        TxnMetadataCacheEntry txnMetadataCacheEntry = new TxnMetadataCacheEntry(coordinatorEpoch, loadedTransactions);
        this.transactionMetadataCache().put((Object)BoxesRunTime.boxToInteger((int)txnTopicPartition), (Object)txnMetadataCacheEntry).foreach((Function1 & Serializable)previousTxnMetadataCacheEntry -> {
            this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(48).append("Unloaded transaction metadata ").append(previousTxnMetadataCacheEntry).append(" from ").append(txnTopicPartition$1).append(" as part of ").toString()).append(new StringBuilder(26).append("loading metadata at epoch ").append(coordinatorEpoch$2).toString()).toString());
            return BoxedUnit.UNIT;
        });
    }

    public void loadTransactionsForTxnTopicPartition(int partitionId, int coordinatorEpoch, Function4<Object, TransactionResult, TransactionMetadata, TxnTransitMetadata, BoxedUnit> sendTxnMarkers) {
        TopicPartition topicPartition = new TopicPartition("__transaction_state", partitionId);
        TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch = new TransactionPartitionAndLeaderEpoch(partitionId, coordinatorEpoch);
        Lock inWriteLock_inLock_lock = this.stateLock().writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            TransactionStateManager.$anonfun$loadTransactionsForTxnTopicPartition$1(this, partitionAndLeaderEpoch);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
        Object var8_6 = null;
        long scheduleStartMs = this.time.milliseconds();
        this.scheduler.schedule(new StringBuilder(24).append("load-txns-for-partition-").append(topicPartition).toString(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.loadTransactions$1(Predef$.MODULE$.long2Long(scheduleStartMs), topicPartition, coordinatorEpoch, partitionAndLeaderEpoch, sendTxnMarkers), this.scheduler.schedule$default$3(), this.scheduler.schedule$default$4(), this.scheduler.schedule$default$5());
    }

    public void removeTransactionsForTxnTopicPartition(int partitionId) {
        TopicPartition topicPartition = new TopicPartition("__transaction_state", partitionId);
        Lock inWriteLock_inLock_lock = this.stateLock().writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            TransactionStateManager.$anonfun$removeTransactionsForTxnTopicPartition$1(this, partitionId, topicPartition);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    public void removeTransactionsForTxnTopicPartition(int partitionId, int coordinatorEpoch) {
        TopicPartition topicPartition = new TopicPartition("__transaction_state", partitionId);
        TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch = new TransactionPartitionAndLeaderEpoch(partitionId, coordinatorEpoch);
        Lock inWriteLock_inLock_lock = this.stateLock().writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            TransactionStateManager.$anonfun$removeTransactionsForTxnTopicPartition$5(this, partitionAndLeaderEpoch, partitionId, topicPartition);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    private void validateTransactionTopicPartitionCountIsStable() {
        int curTransactionTopicPartitionCount;
        int previouslyDeterminedPartitionCount = this.transactionTopicPartitionCount();
        if (previouslyDeterminedPartitionCount != (curTransactionTopicPartitionCount = this.retrieveTransactionTopicPartitionCount().apply$mcI$sp())) {
            throw new KafkaException(new StringBuilder(60).append("Transaction topic number of partitions has changed from ").append(previouslyDeterminedPartitionCount).append(" to ").append(curTransactionTopicPartitionCount).toString());
        }
    }

    /*
     * Unable to fully structure code
     */
    public void appendTransactionToLog(String transactionalId, int coordinatorEpoch, TxnTransitMetadata newMetadata, Function1<Errors, BoxedUnit> responseCallback, Function1<Errors, Object> retryOnError, RequestLocal requestLocal) {
        keyBytes = TransactionLog$.MODULE$.keyToBytes(transactionalId);
        valueBytes = TransactionLog$.MODULE$.valueToBytes(newMetadata);
        timestamp = this.time.milliseconds();
        var17_10 = new SimpleRecord[]{new SimpleRecord(timestamp, keyBytes, valueBytes)};
        withRecords_compressionType = TransactionLog$.MODULE$.EnforcedCompressionType();
        withRecords_magic = 2;
        var23_13 = TimestampType.CREATE_TIME;
        withRecords_initialOffset = 0L;
        v0 = var24_15 = MemoryRecords.withRecords((byte)withRecords_magic, (long)withRecords_initialOffset, (CompressionType)withRecords_compressionType, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records);
        var23_13 = null;
        var24_15 = null;
        v1 = var20_16 = v0;
        var20_16 = null;
        v2 = var18_17 = v1;
        var16_11 = null;
        var17_10 = null;
        var18_17 = null;
        records = v2;
        topicPartition = new TopicPartition("__transaction_state", this.partitionFor(transactionalId));
        recordsPerPartition = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)records)}));
        inReadLock_inLock_lock = this.stateLock().readLock();
        inReadLock_inLock_lock.lock();
        try {
            block10: {
                block9: {
                    var25_22 = false;
                    var26_23 = null;
                    var27_24 = this.getTransactionState(transactionalId);
                    if (!(var27_24 instanceof Left)) break block9;
                    $anonfun$appendTransactionToLog$13_err = (Errors)((Left)var27_24).value();
                    (BoxedUnit)responseCallback.apply((Object)$anonfun$appendTransactionToLog$13_err);
                    break block10;
                }
                if (!(var27_24 instanceof Right)) ** GOTO lbl-1000
                var25_22 = true;
                var26_23 = (Right)var27_24;
                var29_26 = (Option)var26_23.value();
                if (None$.MODULE$.equals(var29_26)) {
                    (BoxedUnit)responseCallback.apply((Object)Errors.NOT_COORDINATOR);
                } else if (var25_22 && (var30_27 = (Option)var26_23.value()) instanceof Some) {
                    $anonfun$appendTransactionToLog$13_epochAndMetadata = (CoordinatorEpochAndTxnMetadata)((Some)var30_27).value();
                    if (BoxesRunTime.unboxToBoolean($anonfun$appendTransactionToLog$13_epochAndMetadata.transactionMetadata().inLock((JFunction0.mcZ.sp & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Z, $anonfun$appendTransactionToLog$14(kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata int scala.Function1 ), ()Z)((CoordinatorEpochAndTxnMetadata)$anonfun$appendTransactionToLog$13_epochAndMetadata, (int)coordinatorEpoch, responseCallback)))) {
                        $anonfun$appendTransactionToLog$13_x$1 = newMetadata.txnTimeoutMs();
                        $anonfun$appendTransactionToLog$13_x$2 = TransactionLog$.MODULE$.EnforcedRequiredAcks();
                        $anonfun$appendTransactionToLog$13_x$4 = AppendOrigin$Coordinator$.MODULE$;
                        $anonfun$appendTransactionToLog$13_x$6 = (Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$appendTransactionToLog$15$adapted(kafka.coordinator.transaction.TransactionStateManager org.apache.kafka.common.TopicPartition java.lang.String kafka.coordinator.transaction.TxnTransitMetadata int scala.Function1 scala.Function1 scala.collection.Map ), (Lscala/collection/Map;)Ljava/lang/Object;)((TransactionStateManager)this, (TopicPartition)topicPartition, (String)transactionalId, (TxnTransitMetadata)newMetadata, (int)coordinatorEpoch, retryOnError, responseCallback);
                        $anonfun$appendTransactionToLog$13_x$8 = this.replicaManager.appendRecords$default$7();
                        $anonfun$appendTransactionToLog$13_x$9 = this.replicaManager.appendRecords$default$8();
                        this.replicaManager.appendRecords($anonfun$appendTransactionToLog$13_x$1, $anonfun$appendTransactionToLog$13_x$2, true, $anonfun$appendTransactionToLog$13_x$4, (Map<TopicPartition, MemoryRecords>)recordsPerPartition, (Function1<Map<TopicPartition, ProduceResponse.PartitionResponse>, BoxedUnit>)$anonfun$appendTransactionToLog$13_x$6, $anonfun$appendTransactionToLog$13_x$8, $anonfun$appendTransactionToLog$13_x$9, requestLocal);
                        this.trace((Function0<String>)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$16(kafka.coordinator.transaction.TxnTransitMetadata java.lang.String int ), ()Ljava/lang/String;)((TxnTransitMetadata)newMetadata, (String)transactionalId, (int)coordinatorEpoch));
                    }
                } else {
                    throw new MatchError(var27_24);
                }
            }
            var26_23 = null;
            var27_24 = null;
            var28_25 = null;
            var29_26 = null;
            var30_27 = null;
            var31_28 = null;
            var35_31 = null;
            var36_32 = null;
            var37_33 = null;
            var38_34 = null;
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
    }

    public Function1<Errors, Object> appendTransactionToLog$default$5() {
        return (Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManager.$anonfun$appendTransactionToLog$default$5$1(x$8));
    }

    public void startup(Function0<Object> retrieveTransactionTopicPartitionCount, boolean enableTransactionalIdExpiration) {
        this.retrieveTransactionTopicPartitionCount = retrieveTransactionTopicPartitionCount;
        this.transactionTopicPartitionCount_$eq(retrieveTransactionTopicPartitionCount.apply$mcI$sp());
        if (enableTransactionalIdExpiration) {
            this.enableTransactionalIdExpiration();
        }
    }

    public void shutdown() {
        this.shuttingDown().set(true);
        this.loadingPartitions().clear();
        this.transactionMetadataCache().clear();
        this.info((Function0<String>)(Function0 & Serializable)() -> "Shutdown complete");
    }

    public static final /* synthetic */ boolean $anonfun$addLoadingPartition$1(TransactionStateManager $this, TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch$1) {
        return $this.loadingPartitions().add((Object)partitionAndLeaderEpoch$1);
    }

    public static final /* synthetic */ boolean $anonfun$timedOutTransactions$3(long now$1, Tuple2 x0$2) {
        boolean bl;
        if (x0$2 != null) {
            TransactionMetadata txnMetadata = (TransactionMetadata)x0$2._2();
            if (txnMetadata.pendingTransitionInProgress()) {
                bl = false;
            } else {
                TransactionState transactionState = txnMetadata.state();
                boolean bl2 = Ongoing$.MODULE$.equals(transactionState) ? txnMetadata.txnStartTimestamp() + (long)txnMetadata.txnTimeoutMs() < now$1 : false;
                bl = bl2;
            }
        } else {
            throw new MatchError(null);
        }
        boolean bl3 = bl;
        return bl3;
    }

    public static final /* synthetic */ scala.collection.mutable.Iterable $anonfun$timedOutTransactions$1(TransactionStateManager $this, long now$1) {
        return (scala.collection.mutable.Iterable)$this.transactionMetadataCache().flatMap((Function1 & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            IterableOnce iterableOnce = (IterableOnce)((IterableOps)((TxnMetadataCacheEntry)x0$1._2()).metadataPerTransactionalId().filter((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManager.$anonfun$timedOutTransactions$3(now$1, x0$2)))).map((Function1 & Serializable)x0$3 -> {
                if (x0$3 == null) {
                    throw new MatchError(null);
                }
                String txnId = (String)x0$3._1();
                TransactionMetadata txnMetadata = (TransactionMetadata)x0$3._2();
                TransactionalIdAndProducerIdEpoch transactionalIdAndProducerIdEpoch = new TransactionalIdAndProducerIdEpoch(txnId, txnMetadata.producerId(), txnMetadata.producerEpoch());
                return transactionalIdAndProducerIdEpoch;
            });
            return iterableOnce;
        });
    }

    private final void flushRecordsBuilder$1(TopicPartition transactionPartition$1, ListBuffer expired$1, ObjectRef recordsBuilder$1) {
        this.writeTombstonesForExpiredTransactionalIds(transactionPartition$1, (Iterable<TransactionalIdCoordinatorEpochAndMetadata>)expired$1.toSeq(), ((MemoryRecordsBuilder)recordsBuilder$1.elem).build());
        expired$1.clear();
        recordsBuilder$1.elem = null;
    }

    public static final /* synthetic */ void $anonfun$removeExpiredTransactionalIds$1(TransactionStateManager $this, TopicPartition transactionPartition$1, TxnMetadataCacheEntry txnMetadataCacheEntry$1) {
        Option<LogConfig> option = $this.replicaManager.getLogConfig(transactionPartition$1);
        if (option instanceof Some) {
            LogConfig logConfig = (LogConfig)((Some)option).value();
            long currentTimeMs = $this.time.milliseconds();
            Integer maxBatchSize = logConfig.maxMessageSize();
            ListBuffer expired = ListBuffer$.MODULE$.empty();
            ObjectRef recordsBuilder = ObjectRef.create(null);
            BufferedIterator stateEntries = txnMetadataCacheEntry$1.metadataPerTransactionalId().values().iterator().buffered();
            while (stateEntries.hasNext()) {
                TransactionMetadata txnMetadata = (TransactionMetadata)stateEntries.head();
                String transactionalId = txnMetadata.transactionalId();
                BooleanRef fullBatch = BooleanRef.create((boolean)false);
                txnMetadata.inLock((Function0 & Serializable)() -> {
                    if (txnMetadata.pendingState().isEmpty() && $this.shouldExpire(txnMetadata, currentTimeMs)) {
                        if ((MemoryRecordsBuilder)recordsBuilder$1.elem == null) {
                            recordsBuilder$1.elem = MemoryRecords.builder((ByteBuffer)ByteBuffer.allocate(package$.MODULE$.min(16384, Predef$.MODULE$.Integer2int(maxBatchSize))), (CompressionType)TransactionLog$.MODULE$.EnforcedCompressionType(), (TimestampType)TimestampType.CREATE_TIME, (long)0L, (int)Predef$.MODULE$.Integer2int(maxBatchSize));
                        }
                        if ($this.maybeAppendExpiration(txnMetadata, (MemoryRecordsBuilder)recordsBuilder$1.elem, currentTimeMs)) {
                            TxnTransitMetadata transitMetadata = txnMetadata.prepareDead();
                            return expired.$plus$eq((Object)new TransactionalIdCoordinatorEpochAndMetadata(transactionalId, txnMetadataCacheEntry$1.coordinatorEpoch(), transitMetadata));
                        }
                        fullBatch$1.elem = true;
                        return BoxedUnit.UNIT;
                    }
                    return BoxedUnit.UNIT;
                });
                if (fullBatch.elem) {
                    $this.writeTombstonesForExpiredTransactionalIds(transactionPartition$1, (Iterable<TransactionalIdCoordinatorEpochAndMetadata>)expired.toSeq(), ((MemoryRecordsBuilder)recordsBuilder.elem).build());
                    expired.clear();
                    recordsBuilder.elem = null;
                    continue;
                }
                stateEntries.next();
            }
            if (expired.nonEmpty()) {
                $this.writeTombstonesForExpiredTransactionalIds(transactionPartition$1, (Iterable<TransactionalIdCoordinatorEpochAndMetadata>)expired.toSeq(), ((MemoryRecordsBuilder)recordsBuilder.elem).build());
                expired.clear();
                recordsBuilder.elem = null;
                return;
            }
        } else {
            if (None$.MODULE$.equals(option)) {
                $this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(95).append(new StringBuilder(61).append("Transaction expiration for partition ").append(transactionPartition$1).append(" failed because the log ").toString()).append("config was not available, which likely means the partition is not online or is no longer local.").toString());
                return;
            }
            throw new MatchError(option);
        }
    }

    public static final /* synthetic */ void $anonfun$removeExpiredTransactionalIds$5(TransactionStateManager $this, int partitionId, TxnMetadataCacheEntry partitionCacheEntry) {
        TopicPartition transactionPartition = new TopicPartition("__transaction_state", partitionId);
        $this.removeExpiredTransactionalIds(transactionPartition, partitionCacheEntry);
    }

    public static final /* synthetic */ void $anonfun$removeExpiredTransactionalIds$4(TransactionStateManager $this) {
        $this.transactionMetadataCache().foreachEntry((arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2 & Serializable)(partitionId, partitionCacheEntry) -> {
            TransactionStateManager.$anonfun$removeExpiredTransactionalIds$5($this, BoxesRunTime.unboxToInt((Object)partitionId), partitionCacheEntry);
            return BoxedUnit.UNIT;
        }, arg_0, arg_1));
    }

    public static final /* synthetic */ void $anonfun$writeTombstonesForExpiredTransactionalIds$2(TransactionStateManager $this, TopicPartition topicPartition$1, Iterable expiredForPartition$1, ProduceResponse.PartitionResponse response$1) {
        $this.transactionMetadataCache().get((Object)BoxesRunTime.boxToInteger((int)topicPartition$1.partition())).foreach((Function1 & Serializable)txnMetadataCacheEntry -> {
            expiredForPartition$1.foreach((Function1 & Serializable)idCoordinatorEpochAndMetadata -> {
                String transactionalId = idCoordinatorEpochAndMetadata.transactionalId();
                TransactionMetadata txnMetadata = txnMetadataCacheEntry.metadataPerTransactionalId().get(transactionalId);
                return txnMetadata.inLock((Function0 & Serializable)() -> {
                    if (txnMetadataCacheEntry.coordinatorEpoch() == idCoordinatorEpochAndMetadata.coordinatorEpoch() && txnMetadata.pendingState().contains((Object)Dead$.MODULE$) && txnMetadata.producerEpoch() == idCoordinatorEpochAndMetadata.transitMetadata().producerEpoch()) {
                        Errors errors = response$1.error;
                        Errors errors2 = Errors.NONE;
                        if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
                            return txnMetadataCacheEntry.metadataPerTransactionalId().remove(transactionalId);
                        }
                    }
                    $this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(42).append("Failed to remove expired transactionalId: ").append(transactionalId).toString()).append(new StringBuilder(43).append(" from cache. Tombstone append error code: ").append(response$1.error).append(",").toString()).append(new StringBuilder(33).append(" pendingState: ").append(txnMetadata.pendingState()).append(", producerEpoch: ").append(txnMetadata.producerEpoch()).append(",").toString()).append(new StringBuilder(26).append(" expected producerEpoch: ").append(idCoordinatorEpochAndMetadata.transitMetadata().producerEpoch()).append(",").toString()).append(new StringBuilder(48).append(" coordinatorEpoch: ").append(txnMetadataCacheEntry.coordinatorEpoch()).append(", expected coordinatorEpoch: ").toString()).append(String.valueOf(BoxesRunTime.boxToInteger((int)idCoordinatorEpochAndMetadata.coordinatorEpoch()))).toString());
                    txnMetadata.pendingState_$eq((Option<TransactionState>)None$.MODULE$);
                    return BoxedUnit.UNIT;
                });
            });
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$writeTombstonesForExpiredTransactionalIds$1(TransactionStateManager $this, Iterable expiredForPartition$1, TopicPartition topicPartition, ProduceResponse.PartitionResponse response) {
        Lock inReadLock_inLock_lock = $this.stateLock().readLock();
        inReadLock_inLock_lock.lock();
        try {
            TransactionStateManager.$anonfun$writeTombstonesForExpiredTransactionalIds$2($this, topicPartition, expiredForPartition$1, response);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
    }

    private final void removeFromCacheCallback$1(Map responses, Iterable expiredForPartition$1) {
        Function2 & Serializable forKeyValue$extension_f = (Function2 & Serializable)(topicPartition, response) -> {
            TransactionStateManager.$anonfun$writeTombstonesForExpiredTransactionalIds$1(this, expiredForPartition$1, topicPartition, response);
            return BoxedUnit.UNIT;
        };
        responses.foreachEntry((arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1(forKeyValue$extension_f, arg_0, arg_1));
    }

    public static final /* synthetic */ void $anonfun$writeTombstonesForExpiredTransactionalIds$7(TransactionStateManager $this, TopicPartition transactionPartition$2, MemoryRecords tombstoneRecords$1, Iterable expiredForPartition$1) {
        long x$1 = $this.config.requestTimeoutMs();
        short x$2 = TransactionLog$.MODULE$.EnforcedRequiredAcks();
        AppendOrigin$Coordinator$ x$4 = AppendOrigin$Coordinator$.MODULE$;
        scala.collection.immutable.Map x$5 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)transactionPartition$2), (Object)tombstoneRecords$1)}));
        Function1 & Serializable x$6 = (Function1 & Serializable)responses -> {
            $this.removeFromCacheCallback$1(responses, expiredForPartition$1);
            return BoxedUnit.UNIT;
        };
        RequestLocal x$7 = RequestLocal$.MODULE$.NoCaching();
        Option<Lock> x$8 = $this.replicaManager.appendRecords$default$7();
        Function1<Map<TopicPartition, RecordConversionStats>, BoxedUnit> x$9 = $this.replicaManager.appendRecords$default$8();
        $this.replicaManager.appendRecords(x$1, x$2, true, x$4, (Map<TopicPartition, MemoryRecords>)x$5, (Function1<Map<TopicPartition, ProduceResponse.PartitionResponse>, BoxedUnit>)x$6, x$8, x$9, x$7);
    }

    private static final boolean shouldInclude$1(TransactionMetadata txnMetadata, scala.collection.immutable.Set filterProducerIds$1, scala.collection.immutable.Set filterStateNames$1, Set filterStates$1) {
        TransactionState transactionState = txnMetadata.state();
        Dead$ dead$ = Dead$.MODULE$;
        if (transactionState != null && transactionState.equals(dead$)) {
            return false;
        }
        if (filterProducerIds$1.nonEmpty() && !filterProducerIds$1.contains((Object)BoxesRunTime.boxToLong((long)txnMetadata.producerId()))) {
            return false;
        }
        return !filterStateNames$1.nonEmpty() || filterStates$1.contains((Object)txnMetadata.state());
    }

    public static final /* synthetic */ void $anonfun$listTransactionStates$3(ArrayList states$1, scala.collection.immutable.Set filterProducerIds$1, scala.collection.immutable.Set filterStateNames$1, Set filterStates$1, int x$4, TxnMetadataCacheEntry cache) {
        cache.metadataPerTransactionalId().values().foreach((Function1 & Serializable)txnMetadata -> txnMetadata.inLock((Function0 & Serializable)() -> {
            if (TransactionStateManager.shouldInclude$1(txnMetadata, filterProducerIds$1, filterStateNames$1, filterStates$1)) {
                return BoxesRunTime.boxToBoolean((boolean)states$1.add(new ListTransactionsResponseData.TransactionState().setTransactionalId(txnMetadata.transactionalId()).setProducerId(txnMetadata.producerId()).setTransactionState(txnMetadata.state().name())));
            }
            return BoxedUnit.UNIT;
        }));
    }

    public static final /* synthetic */ ListTransactionsResponseData $anonfun$listTransactionStates$1(TransactionStateManager $this, scala.collection.immutable.Set filterStateNames$1, scala.collection.immutable.Set filterProducerIds$1) {
        ListTransactionsResponseData response = new ListTransactionsResponseData();
        if ($this.loadingPartitions().nonEmpty()) {
            return response.setErrorCode(Errors.COORDINATOR_LOAD_IN_PROGRESS.code());
        }
        Set filterStates = (Set)Set$.MODULE$.empty();
        filterStateNames$1.foreach((Function1 & Serializable)stateName -> {
            Object object;
            Option<TransactionState> option = TransactionState$.MODULE$.fromName((String)stateName);
            if (option instanceof Some) {
                TransactionState state = (TransactionState)((Some)option).value();
                object = filterStates.$plus$eq((Object)state);
            } else if (None$.MODULE$.equals(option)) {
                object = BoxesRunTime.boxToBoolean((boolean)response.unknownStateFilters().add(stateName));
            } else {
                throw new MatchError(option);
            }
            return object;
        });
        ArrayList states = new ArrayList();
        $this.transactionMetadataCache().foreachEntry((arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2 & Serializable)(x$4, cache) -> {
            TransactionStateManager.$anonfun$listTransactionStates$3(states, filterProducerIds$1, filterStateNames$1, filterStates, BoxesRunTime.unboxToInt((Object)x$4), cache);
            return BoxedUnit.UNIT;
        }, arg_0, arg_1));
        return response.setErrorCode(Errors.NONE.code()).setTransactionStates(states);
    }

    public static final /* synthetic */ boolean $anonfun$getAndMaybeAddTransactionState$2(int partitionId$1, TransactionPartitionAndLeaderEpoch x$5) {
        return x$5.txnPartitionId() == partitionId$1;
    }

    public static final /* synthetic */ Either $anonfun$getAndMaybeAddTransactionState$1(TransactionStateManager $this, String transactionalId$3, Option createdTxnMetadataOpt$1) {
        Left left;
        int partitionId = $this.partitionFor(transactionalId$3);
        if ($this.loadingPartitions().exists((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManager.$anonfun$getAndMaybeAddTransactionState$2(partitionId, x$5)))) {
            return scala.package$.MODULE$.Left().apply((Object)Errors.COORDINATOR_LOAD_IN_PROGRESS);
        }
        Option option = $this.transactionMetadataCache().get((Object)BoxesRunTime.boxToInteger((int)partitionId));
        if (option instanceof Some) {
            TxnMetadataCacheEntry cacheEntry = (TxnMetadataCacheEntry)((Some)option).value();
            Option txnMetadata = Option$.MODULE$.apply((Object)cacheEntry.metadataPerTransactionalId().get(transactionalId$3)).orElse((Function0 & Serializable)() -> createdTxnMetadataOpt$1.map((Function1 & Serializable)createdTxnMetadata -> (TransactionMetadata)Option$.MODULE$.apply((Object)cacheEntry.metadataPerTransactionalId().putIfNotExists(transactionalId$3, (TransactionMetadata)createdTxnMetadata)).getOrElse((Function0 & Serializable)() -> createdTxnMetadata)));
            left = scala.package$.MODULE$.Right().apply((Object)txnMetadata.map((Function1 & Serializable)x$6 -> new CoordinatorEpochAndTxnMetadata(cacheEntry.coordinatorEpoch(), (TransactionMetadata)x$6)));
        } else if (None$.MODULE$.equals(option)) {
            left = scala.package$.MODULE$.Left().apply((Object)Errors.NOT_COORDINATOR);
        } else {
            throw new MatchError((Object)option);
        }
        return left;
    }

    private final long logEndOffset$1(TopicPartition topicPartition$2) {
        return BoxesRunTime.unboxToLong((Object)this.replicaManager.getLogEndOffset(topicPartition$2).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> -1L));
    }

    public static final /* synthetic */ boolean $anonfun$loadTransactionMetadata$4(TopicPartition topicPartition$2, int coordinatorEpoch$1, TransactionPartitionAndLeaderEpoch idAndEpoch) {
        return idAndEpoch.txnPartitionId() == topicPartition$2.partition() && idAndEpoch.coordinatorEpoch() == coordinatorEpoch$1;
    }

    public static final /* synthetic */ boolean $anonfun$loadTransactionMetadata$3(TransactionStateManager $this, TopicPartition topicPartition$2, int coordinatorEpoch$1) {
        return $this.loadingPartitions().exists((Function1 & Serializable)idAndEpoch -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManager.$anonfun$loadTransactionMetadata$4(topicPartition$2, coordinatorEpoch$1, idAndEpoch)));
    }

    public static final /* synthetic */ void $anonfun$loadTransactionMetadata$7(Pool loadedTransactions$1, LongRef currOffset$1, MutableRecordBatch batch$1, Record record) {
        Predef$.MODULE$.require(record.hasKey(), (Function0 & Serializable)() -> "Transaction state log's key should not be null");
        String transactionalId = TransactionLog$.MODULE$.readTxnRecordKey(record.key()).transactionalId();
        Option<TransactionMetadata> option = TransactionLog$.MODULE$.readTxnRecordValue(transactionalId, record.value());
        if (None$.MODULE$.equals(option)) {
            TransactionMetadata cfr_ignored_0 = (TransactionMetadata)loadedTransactions$1.remove(transactionalId);
        } else if (option instanceof Some) {
            TransactionMetadata txnMetadata = (TransactionMetadata)((Some)option).value();
            loadedTransactions$1.put(transactionalId, txnMetadata);
        } else {
            throw new MatchError(option);
        }
        currOffset$1.elem = batch$1.nextOffset();
    }

    public static final /* synthetic */ boolean $anonfun$loadTransactionsForTxnTopicPartition$1(TransactionStateManager $this, TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch$2) {
        return $this.loadingPartitions().add((Object)partitionAndLeaderEpoch$2);
    }

    public static final /* synthetic */ void $anonfun$loadTransactionsForTxnTopicPartition$4(TransactionStateManager $this, TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch$2, TopicPartition topicPartition$3, int coordinatorEpoch$3, Pool loadedTransactions$2, Function4 sendTxnMarkers$1) {
        if ($this.loadingPartitions().contains((Object)partitionAndLeaderEpoch$2)) {
            $this.addLoadedTransactionsToCache(topicPartition$3.partition(), coordinatorEpoch$3, loadedTransactions$2);
            ListBuffer transactionsPendingForCompletion = new ListBuffer();
            loadedTransactions$2.foreach((Function1 & Serializable)x0$1 -> {
                if (x0$1 == null) {
                    throw new MatchError(null);
                }
                String transactionalId = (String)x0$1._1();
                TransactionMetadata txnMetadata = (TransactionMetadata)x0$1._2();
                Object t = txnMetadata.inLock((Function0 & Serializable)() -> {
                    TransactionState transactionState = txnMetadata.state();
                    Object object = PrepareAbort$.MODULE$.equals(transactionState) ? transactionsPendingForCompletion.$plus$eq((Object)new TransactionalIdCoordinatorEpochAndTransitMetadata(transactionalId, coordinatorEpoch$3, TransactionResult.ABORT, txnMetadata, txnMetadata.prepareComplete($this.time.milliseconds()))) : (PrepareCommit$.MODULE$.equals(transactionState) ? transactionsPendingForCompletion.$plus$eq((Object)new TransactionalIdCoordinatorEpochAndTransitMetadata(transactionalId, coordinatorEpoch$3, TransactionResult.COMMIT, txnMetadata, txnMetadata.prepareComplete($this.time.milliseconds()))) : BoxedUnit.UNIT);
                    return object;
                });
                return t;
            });
            $this.loadingPartitions().remove((Object)partitionAndLeaderEpoch$2);
            transactionsPendingForCompletion.foreach((Function1 & Serializable)txnTransitMetadata -> {
                sendTxnMarkers$1.apply((Object)BoxesRunTime.boxToInteger((int)txnTransitMetadata.coordinatorEpoch()), (Object)txnTransitMetadata.result(), (Object)txnTransitMetadata.txnMetadata(), (Object)txnTransitMetadata.transitMetadata());
                return BoxedUnit.UNIT;
            });
        }
    }

    private final void loadTransactions$1(Long startTimeMs, TopicPartition topicPartition$3, int coordinatorEpoch$3, TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch$2, Function4 sendTxnMarkers$1) {
        long schedulerTimeMs = this.time.milliseconds() - Predef$.MODULE$.Long2long(startTimeMs);
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(44).append("Loading transaction metadata from ").append(topicPartition$3).append(" at epoch ").append(coordinatorEpoch$3).toString());
        this.validateTransactionTopicPartitionCountIsStable();
        Pool<String, TransactionMetadata> loadedTransactions = this.loadTransactionMetadata(topicPartition$3, coordinatorEpoch$3);
        long endTimeMs = this.time.milliseconds();
        long totalLoadingTimeMs = endTimeMs - Predef$.MODULE$.Long2long(startTimeMs);
        this.partitionLoadSensor().record((double)totalLoadingTimeMs, endTimeMs, false);
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(48).append("Finished loading ").append(loadedTransactions.size()).append(" transaction metadata from ").append(topicPartition$3).append(" in ").toString()).append(new StringBuilder(65).append(totalLoadingTimeMs).append(" milliseconds, of which ").append(schedulerTimeMs).append(" milliseconds was spent in the scheduler.").toString()).toString());
        Lock inWriteLock_inLock_lock = this.stateLock().writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            if (this.loadingPartitions().contains((Object)partitionAndLeaderEpoch$2)) {
                this.addLoadedTransactionsToCache(topicPartition$3.partition(), coordinatorEpoch$3, loadedTransactions);
                ListBuffer $anonfun$loadTransactionsForTxnTopicPartition$4_transactionsPendingForCompletion = new ListBuffer();
                loadedTransactions.foreach((Function1 & Serializable)x0$1 -> {
                    if (x0$1 == null) {
                        throw new MatchError(null);
                    }
                    String transactionalId = (String)x0$1._1();
                    TransactionMetadata txnMetadata = (TransactionMetadata)x0$1._2();
                    Object t = txnMetadata.inLock((Function0 & Serializable)() -> {
                        TransactionState transactionState = txnMetadata.state();
                        Object object = PrepareAbort$.MODULE$.equals(transactionState) ? transactionsPendingForCompletion.$plus$eq((Object)new TransactionalIdCoordinatorEpochAndTransitMetadata(transactionalId, coordinatorEpoch$3, TransactionResult.ABORT, txnMetadata, txnMetadata.prepareComplete($this.time.milliseconds()))) : (PrepareCommit$.MODULE$.equals(transactionState) ? transactionsPendingForCompletion.$plus$eq((Object)new TransactionalIdCoordinatorEpochAndTransitMetadata(transactionalId, coordinatorEpoch$3, TransactionResult.COMMIT, txnMetadata, txnMetadata.prepareComplete($this.time.milliseconds()))) : BoxedUnit.UNIT);
                        return object;
                    });
                    return t;
                });
                this.loadingPartitions().remove((Object)partitionAndLeaderEpoch$2);
                $anonfun$loadTransactionsForTxnTopicPartition$4_transactionsPendingForCompletion.foreach((Function1 & Serializable)txnTransitMetadata -> {
                    sendTxnMarkers$1.apply((Object)BoxesRunTime.boxToInteger((int)txnTransitMetadata.coordinatorEpoch()), (Object)txnTransitMetadata.result(), (Object)txnTransitMetadata.txnMetadata(), (Object)txnTransitMetadata.transitMetadata());
                    return BoxedUnit.UNIT;
                });
            }
            Object var15_11 = null;
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
        Object var13_10 = null;
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(67).append("Completed loading transaction metadata from ").append(topicPartition$3).append(" for coordinator epoch ").append(coordinatorEpoch$3).toString());
    }

    public static final /* synthetic */ boolean $anonfun$removeTransactionsForTxnTopicPartition$2(int partitionId$2, TransactionPartitionAndLeaderEpoch x$7) {
        return x$7.txnPartitionId() == partitionId$2;
    }

    public static final /* synthetic */ void $anonfun$removeTransactionsForTxnTopicPartition$1(TransactionStateManager $this, int partitionId$2, TopicPartition topicPartition$4) {
        $this.loadingPartitions().$minus$minus$eq((IterableOnce)$this.loadingPartitions().filter((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManager.$anonfun$removeTransactionsForTxnTopicPartition$2(partitionId$2, x$7))));
        $this.transactionMetadataCache().remove((Object)BoxesRunTime.boxToInteger((int)partitionId$2)).foreach((Function1 & Serializable)txnMetadataCacheEntry -> {
            $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(46).append("Unloaded transaction metadata ").append(txnMetadataCacheEntry).append(" for ").append(topicPartition$4).append(" following ").toString()).append("local partition deletion").toString());
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$removeTransactionsForTxnTopicPartition$5(TransactionStateManager $this, TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch$3, int partitionId$3, TopicPartition topicPartition$5) {
        $this.loadingPartitions().remove((Object)partitionAndLeaderEpoch$3);
        Option option = $this.transactionMetadataCache().remove((Object)BoxesRunTime.boxToInteger((int)partitionId$3));
        if (option instanceof Some) {
            TxnMetadataCacheEntry txnMetadataCacheEntry = (TxnMetadataCacheEntry)((Some)option).value();
            $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(65).append("Unloaded transaction metadata ").append(txnMetadataCacheEntry).append(" for ").append(topicPartition$5).append(" on become-follower transition").toString());
            return;
        }
        if (None$.MODULE$.equals(option)) {
            $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(75).append("No cached transaction metadata found for ").append(topicPartition$5).append(" during become-follower transition").toString());
            return;
        }
        throw new MatchError((Object)option);
    }

    public static final /* synthetic */ String $anonfun$appendTransactionToLog$1(String transactionalId$5, TxnTransitMetadata newMetadata$1, ProduceResponse.PartitionResponse status$1) {
        return new StringBuilder(41).append("Appending ").append(transactionalId$5).append("'s new metadata ").append(newMetadata$1).append(" failed due to ").append(status$1.error.exceptionName()).toString();
    }

    public static final /* synthetic */ String $anonfun$appendTransactionToLog$2(String transactionalId$5, Errors err$1) {
        return new StringBuilder(0).append(new StringBuilder(63).append("Accessing the cached transaction metadata for ").append(transactionalId$5).append(" returns ").append(err$1).append(" error; ").toString()).append("aborting transition to the new metadata and setting the error in the callback").toString();
    }

    public static final /* synthetic */ void $anonfun$appendTransactionToLog$3(TransactionStateManager $this, CoordinatorEpochAndTxnMetadata epochAndMetadata$1, int coordinatorEpoch$4, String transactionalId$5, TxnTransitMetadata newMetadata$1, ObjectRef responseError$1, TransactionMetadata metadata$1) {
        if (epochAndMetadata$1.coordinatorEpoch() != coordinatorEpoch$4) {
            $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(83).append("The cached coordinator epoch for ").append(transactionalId$5).append(" has changed to ").append(epochAndMetadata$1.coordinatorEpoch()).append(" after appended its new metadata ").append(newMetadata$1).append(" ").toString()).append(new StringBuilder(78).append("to the transaction log (txn topic partition ").append($this.partitionFor(transactionalId$5)).append(") while it was ").append(coordinatorEpoch$4).append(" before appending; ").toString()).append(new StringBuilder(70).append("aborting transition to the new metadata and returning ").append(Errors.NOT_COORDINATOR).append(" in the callback").toString()).toString());
            responseError$1.elem = Errors.NOT_COORDINATOR;
            return;
        }
        metadata$1.completeTransitionTo(newMetadata$1);
        $this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(72).append("Updating ").append(transactionalId$5).append("'s transaction state to ").append(newMetadata$1).append(" with coordinator epoch ").append(coordinatorEpoch$4).append(" for ").append(transactionalId$5).append(" succeeded").toString());
    }

    public static final /* synthetic */ String $anonfun$appendTransactionToLog$6(TransactionStateManager $this, String transactionalId$5, TxnTransitMetadata newMetadata$1, int coordinatorEpoch$4) {
        return new StringBuilder(0).append(new StringBuilder(106).append("The cached coordinator metadata does not exist in the cache anymore for ").append(transactionalId$5).append(" after appended its new metadata ").append(newMetadata$1).append(" ").toString()).append(new StringBuilder(78).append("to the transaction log (txn topic partition ").append($this.partitionFor(transactionalId$5)).append(") while it was ").append(coordinatorEpoch$4).append(" before appending; ").toString()).append(new StringBuilder(70).append("aborting transition to the new metadata and returning ").append(Errors.NOT_COORDINATOR).append(" in the callback").toString()).toString();
    }

    public static final /* synthetic */ void $anonfun$appendTransactionToLog$7(TransactionStateManager $this, CoordinatorEpochAndTxnMetadata epochAndTxnMetadata$1, int coordinatorEpoch$4, Function1 retryOnError$1, ObjectRef responseError$1, TransactionMetadata metadata$2, TxnTransitMetadata newMetadata$1) {
        if (epochAndTxnMetadata$1.coordinatorEpoch() == coordinatorEpoch$4) {
            if (BoxesRunTime.unboxToBoolean((Object)retryOnError$1.apply((Object)((Errors)responseError$1.elem)))) {
                $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(72).append("TransactionalId ").append(metadata$2.transactionalId()).append(" append transaction log for ").append(newMetadata$1).append(" transition failed due to ").append((Errors)responseError$1.elem).append(", ").toString()).append(new StringBuilder(97).append("not resetting pending state ").append(metadata$2.pendingState()).append(" but just returning the error in the callback to let the caller retry").toString()).toString());
                return;
            }
            $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(72).append("TransactionalId ").append(metadata$2.transactionalId()).append(" append transaction log for ").append(newMetadata$1).append(" transition failed due to ").append((Errors)responseError$1.elem).append(", ").toString()).append(new StringBuilder(87).append("resetting pending state from ").append(metadata$2.pendingState()).append(", aborting state transition and returning ").append((Errors)responseError$1.elem).append(" in the callback").toString()).toString());
            metadata$2.pendingState_$eq((Option<TransactionState>)None$.MODULE$);
            return;
        }
        $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(72).append("TransactionalId ").append(metadata$2.transactionalId()).append(" append transaction log for ").append(newMetadata$1).append(" transition failed due to ").append((Errors)responseError$1.elem).append(", ").toString()).append(new StringBuilder(115).append("aborting state transition and returning the error in the callback since the coordinator epoch has changed from ").append(epochAndTxnMetadata$1.coordinatorEpoch()).append(" to ").append(coordinatorEpoch$4).toString()).toString());
    }

    public static final /* synthetic */ String $anonfun$appendTransactionToLog$11(String transactionalId$5, TxnTransitMetadata newMetadata$1, ObjectRef responseError$1) {
        return new StringBuilder(0).append(new StringBuilder(72).append("TransactionalId ").append(transactionalId$5).append(" append transaction log for ").append(newMetadata$1).append(" transition failed due to ").append((Errors)responseError$1.elem).append(", ").toString()).append("aborting state transition and returning the error in the callback since metadata is not available in the cache anymore").toString();
    }

    public static final /* synthetic */ String $anonfun$appendTransactionToLog$12(String transactionalId$5, TxnTransitMetadata newMetadata$1, ObjectRef responseError$1, Errors error$1) {
        return new StringBuilder(0).append(new StringBuilder(72).append("TransactionalId ").append(transactionalId$5).append(" append transaction log for ").append(newMetadata$1).append(" transition failed due to ").append((Errors)responseError$1.elem).append(", ").toString()).append(new StringBuilder(101).append("aborting state transition and returning the error in the callback since retrieving metadata returned ").append(error$1).toString()).toString();
    }

    /*
     * Unable to fully structure code
     */
    private final void updateCacheCallback$1(Map responseStatus, TopicPartition topicPartition$6, String transactionalId$5, TxnTransitMetadata newMetadata$1, int coordinatorEpoch$4, Function1 retryOnError$1, Function1 responseCallback$1) {
        block15: {
            block13: {
                block17: {
                    block16: {
                        block14: {
                            if (responseStatus.size() != 1 || !responseStatus.contains((Object)topicPartition$6)) {
                                throw new IllegalStateException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Append status %s should only have one partition %s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{responseStatus, topicPartition$6})));
                            }
                            status = (ProduceResponse.PartitionResponse)responseStatus.apply((Object)topicPartition$6);
                            v0 = status.error;
                            var14_9 = Errors.NONE;
                            if (!(v0 != null ? v0.equals(var14_9) == false : var14_9 != null)) {
                                v1 = Errors.NONE;
                            } else {
                                this.debug((Function0<String>)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$1(java.lang.String kafka.coordinator.transaction.TxnTransitMetadata org.apache.kafka.common.requests.ProduceResponse$PartitionResponse ), ()Ljava/lang/String;)((String)transactionalId$5, (TxnTransitMetadata)newMetadata$1, (ProduceResponse.PartitionResponse)status));
                                var15_10 = status.error;
                                var11_11 = Errors.UNKNOWN_TOPIC_OR_PARTITION.equals(var15_10) != false ? true : (Errors.NOT_ENOUGH_REPLICAS.equals(var15_10) != false ? true : (Errors.NOT_ENOUGH_REPLICAS_AFTER_APPEND.equals(var15_10) != false ? true : Errors.REQUEST_TIMED_OUT.equals(var15_10) != false));
                                if (var11_11) {
                                    var8_12 = Errors.COORDINATOR_NOT_AVAILABLE;
                                } else {
                                    var10_13 = Errors.NOT_LEADER_OR_FOLLOWER.equals(var15_10) != false ? true : Errors.KAFKA_STORAGE_ERROR.equals(var15_10) != false;
                                    if (var10_13) {
                                        var8_12 = Errors.NOT_COORDINATOR;
                                    } else {
                                        var9_14 = Errors.MESSAGE_TOO_LARGE.equals(var15_10) != false ? true : Errors.RECORD_LIST_TOO_LARGE.equals(var15_10) != false;
                                        var8_12 = var9_14 != false ? Errors.UNKNOWN_SERVER_ERROR : var15_10;
                                    }
                                }
                                v1 = var8_12;
                            }
                            responseError = ObjectRef.create((Object)v1);
                            v2 = (Errors)responseError.elem;
                            var16_16 = Errors.NONE;
                            if (v2 != null ? v2.equals(var16_16) == false : var16_16 != null) break block13;
                            var17_17 = false;
                            var18_18 = null;
                            var19_19 = this.getTransactionState(transactionalId$5);
                            if (!(var19_19 instanceof Left)) break block14;
                            err = (Errors)((Left)var19_19).value();
                            this.info((Function0<String>)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$2(java.lang.String org.apache.kafka.common.protocol.Errors ), ()Ljava/lang/String;)((String)transactionalId$5, (Errors)err));
                            responseError.elem = err;
                            break block15;
                        }
                        if (!(var19_19 instanceof Right)) break block16;
                        var17_17 = true;
                        var18_18 = (Right)var19_19;
                        var21_21 = (Option)var18_18.value();
                        if (!(var21_21 instanceof Some)) break block16;
                        epochAndMetadata = (CoordinatorEpochAndTxnMetadata)((Some)var21_21).value();
                        metadata = epochAndMetadata.transactionMetadata();
                        (BoxedUnit)metadata.inLock((JFunction0.mcV.sp & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()V, $anonfun$appendTransactionToLog$3(kafka.coordinator.transaction.TransactionStateManager kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata int java.lang.String kafka.coordinator.transaction.TxnTransitMetadata scala.runtime.ObjectRef kafka.coordinator.transaction.TransactionMetadata ), ()V)((TransactionStateManager)this, (CoordinatorEpochAndTxnMetadata)epochAndMetadata, (int)coordinatorEpoch$4, (String)transactionalId$5, (TxnTransitMetadata)newMetadata$1, (ObjectRef)responseError, (TransactionMetadata)metadata));
                        break block15;
                    }
                    if (!var17_17 || !None$.MODULE$.equals(var24_24 = (Option)var18_18.value())) break block17;
                    this.info((Function0<String>)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$6(kafka.coordinator.transaction.TransactionStateManager java.lang.String kafka.coordinator.transaction.TxnTransitMetadata int ), ()Ljava/lang/String;)((TransactionStateManager)this, (String)transactionalId$5, (TxnTransitMetadata)newMetadata$1, (int)coordinatorEpoch$4));
                    responseError.elem = Errors.NOT_COORDINATOR;
                    break block15;
                }
                throw new MatchError(var19_19);
            }
            var25_25 = false;
            var26_26 = null;
            var27_27 = this.getTransactionState(transactionalId$5);
            if (!(var27_27 instanceof Right)) ** GOTO lbl-1000
            var25_25 = true;
            var26_26 = (Right)var27_27;
            var28_28 = (Option)var26_26.value();
            if (var28_28 instanceof Some) {
                epochAndTxnMetadata = (CoordinatorEpochAndTxnMetadata)((Some)var28_28).value();
                metadata = epochAndTxnMetadata.transactionMetadata();
                (BoxedUnit)metadata.inLock((JFunction0.mcV.sp & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()V, $anonfun$appendTransactionToLog$7(kafka.coordinator.transaction.TransactionStateManager kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata int scala.Function1 scala.runtime.ObjectRef kafka.coordinator.transaction.TransactionMetadata kafka.coordinator.transaction.TxnTransitMetadata ), ()V)((TransactionStateManager)this, (CoordinatorEpochAndTxnMetadata)epochAndTxnMetadata, (int)coordinatorEpoch$4, (Function1)retryOnError$1, (ObjectRef)responseError, (TransactionMetadata)metadata, (TxnTransitMetadata)newMetadata$1));
            } else if (var25_25 && None$.MODULE$.equals(var31_31 = (Option)var26_26.value())) {
                this.info((Function0<String>)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$11(java.lang.String kafka.coordinator.transaction.TxnTransitMetadata scala.runtime.ObjectRef ), ()Ljava/lang/String;)((String)transactionalId$5, (TxnTransitMetadata)newMetadata$1, (ObjectRef)responseError));
            } else if (var27_27 instanceof Left) {
                error = (Errors)((Left)var27_27).value();
                this.info((Function0<String>)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$12(java.lang.String kafka.coordinator.transaction.TxnTransitMetadata scala.runtime.ObjectRef org.apache.kafka.common.protocol.Errors ), ()Ljava/lang/String;)((String)transactionalId$5, (TxnTransitMetadata)newMetadata$1, (ObjectRef)responseError, (Errors)error));
            } else {
                throw new MatchError(var27_27);
            }
        }
        responseCallback$1.apply((Object)((Errors)responseError.elem));
    }

    public static final /* synthetic */ void $anonfun$appendTransactionToLog$13(TransactionStateManager $this, String transactionalId$5, Function1 responseCallback$1, int coordinatorEpoch$4, TxnTransitMetadata newMetadata$1, scala.collection.immutable.Map recordsPerPartition$1, RequestLocal requestLocal$1, TopicPartition topicPartition$6, Function1 retryOnError$1) {
        Option option;
        boolean bl = false;
        Right right = null;
        Either<Errors, Option<CoordinatorEpochAndTxnMetadata>> either = $this.getTransactionState(transactionalId$5);
        if (either instanceof Left) {
            Errors err = (Errors)((Left)either).value();
            BoxedUnit cfr_ignored_0 = (BoxedUnit)responseCallback$1.apply((Object)err);
            return;
        }
        if (either instanceof Right) {
            bl = true;
            right = (Right)either;
            Option option2 = (Option)right.value();
            if (None$.MODULE$.equals(option2)) {
                BoxedUnit cfr_ignored_1 = (BoxedUnit)responseCallback$1.apply((Object)Errors.NOT_COORDINATOR);
                return;
            }
        }
        if (bl && (option = (Option)right.value()) instanceof Some) {
            CoordinatorEpochAndTxnMetadata epochAndMetadata = (CoordinatorEpochAndTxnMetadata)((Some)option).value();
            if (BoxesRunTime.unboxToBoolean(epochAndMetadata.transactionMetadata().inLock((JFunction0.mcZ.sp & Serializable)() -> {
                if (epochAndMetadata.coordinatorEpoch() != coordinatorEpoch$4) {
                    responseCallback$1.apply((Object)Errors.NOT_COORDINATOR);
                    return false;
                }
                return true;
            }))) {
                long x$1 = newMetadata$1.txnTimeoutMs();
                short x$2 = TransactionLog$.MODULE$.EnforcedRequiredAcks();
                AppendOrigin$Coordinator$ x$4 = AppendOrigin$Coordinator$.MODULE$;
                Function1 & Serializable x$6 = (Function1 & Serializable)responseStatus -> {
                    $this.updateCacheCallback$1(responseStatus, topicPartition$6, transactionalId$5, newMetadata$1, coordinatorEpoch$4, retryOnError$1, responseCallback$1);
                    return BoxedUnit.UNIT;
                };
                Option<Lock> x$8 = $this.replicaManager.appendRecords$default$7();
                Function1<Map<TopicPartition, RecordConversionStats>, BoxedUnit> x$9 = $this.replicaManager.appendRecords$default$8();
                $this.replicaManager.appendRecords(x$1, x$2, true, x$4, (Map<TopicPartition, MemoryRecords>)recordsPerPartition$1, (Function1<Map<TopicPartition, ProduceResponse.PartitionResponse>, BoxedUnit>)x$6, x$8, x$9, requestLocal$1);
                $this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(96).append("Appending new metadata ").append(newMetadata$1).append(" for transaction id ").append(transactionalId$5).append(" with coordinator epoch ").append(coordinatorEpoch$4).append(" to the local transaction log").toString());
                return;
            }
        } else {
            throw new MatchError(either);
        }
    }

    public static final /* synthetic */ boolean $anonfun$appendTransactionToLog$default$5$1(Errors x$8) {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public TransactionStateManager(int brokerId, Scheduler scheduler, ReplicaManager replicaManager, TransactionConfig config, Time time, Metrics metrics) {
        void add_stat;
        void add_metricName;
        void add_stat2;
        void add_metricName2;
        this.scheduler = scheduler;
        this.replicaManager = replicaManager;
        this.config = config;
        this.time = time;
        this.logIdent_$eq(new StringBuilder(30).append("[Transaction State Manager ").append(brokerId).append("]: ").toString());
        this.shuttingDown = new AtomicBoolean(false);
        this.stateLock = new ReentrantReadWriteLock();
        this.loadingPartitions = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.transactionMetadataCache = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.partitionLoadSensor = metrics.sensor(TransactionStateManager$.MODULE$.LoadTimeSensor());
        Sensor sensor = this.partitionLoadSensor();
        Max max = new Max();
        MetricName metricName = metrics.metricName("partition-load-time-max", TransactionStateManager$.MODULE$.MetricsGroup(), "The max time it took to load the partitions in the last 30sec");
        if (sensor == null) {
            throw null;
        }
        sensor.add((MetricName)add_metricName2, (MeasurableStat)add_stat2, null);
        metricName = null;
        max = null;
        Sensor sensor2 = this.partitionLoadSensor();
        Avg avg = new Avg();
        MetricName metricName2 = metrics.metricName("partition-load-time-avg", TransactionStateManager$.MODULE$.MetricsGroup(), "The avg time it took to load the partitions in the last 30sec");
        if (sensor2 == null) {
            throw null;
        }
        sensor2.add((MetricName)add_metricName, (MeasurableStat)add_stat, null);
    }
}

