/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.Properties;
import kafka.common.InconsistentBrokerIdException;
import kafka.server.BrokerMetadataCheckpoint;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.RawMetaProperties;
import kafka.utils.TestUtils$;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.test.TestUtils;
import org.apache.zookeeper.KeeperException;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005=c\u0001\u0002\u000f\u001e\u0001\tBQ!\u000b\u0001\u0005\u0002)Bq!\f\u0001A\u0002\u0013\u0005a\u0006C\u00048\u0001\u0001\u0007I\u0011\u0001\u001d\t\r\u0005\u0003\u0001\u0015)\u00030\u0011\u001d\u0011\u0005\u00011A\u0005\u0002\rCqa\u0012\u0001A\u0002\u0013\u0005\u0001\n\u0003\u0004K\u0001\u0001\u0006K\u0001\u0012\u0005\b\u0017\u0002\u0001\r\u0011\"\u0001/\u0011\u001da\u0005\u00011A\u0005\u00025Caa\u0014\u0001!B\u0013y\u0003b\u0002)\u0001\u0001\u0004%\ta\u0011\u0005\b#\u0002\u0001\r\u0011\"\u0001S\u0011\u0019!\u0006\u0001)Q\u0005\t\"9Q\u000b\u0001b\u0001\n\u00031\u0006BB/\u0001A\u0003%q\u000bC\u0004_\u0001\u0001\u0007I\u0011A0\t\u000f%\u0004\u0001\u0019!C\u0001U\"1A\u000e\u0001Q!\n\u0001DQ!\u001c\u0001\u0005B9DQ\u0001 \u0001\u0005B9Da!a\u0001\u0001\t\u0003q\u0007BBA\u0007\u0001\u0011\u0005a\u000e\u0003\u0004\u0002\u0012\u0001!\tA\u001c\u0005\u0007\u0003+\u0001A\u0011\u00018\t\r\u0005e\u0001\u0001\"\u0001o\u0011\u0019\ti\u0002\u0001C\u0001]\"9\u0011\u0011\u0005\u0001\u0005\u0002\u0005\r\"AG*feZ,'oR3oKJ\fG/\u001a\"s_.,'/\u00133UKN$(B\u0001\u0010 \u0003\u0019\u0019XM\u001d<fe*\t\u0001%A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001\u0019\u0003C\u0001\u0013(\u001b\u0005)#B\u0001\u0014 \u0003\tQ8.\u0003\u0002)K\t!\"l\\8LK\u0016\u0004XM\u001d+fgRD\u0015M\u001d8fgN\fa\u0001P5oSRtD#A\u0016\u0011\u00051\u0002Q\"A\u000f\u0002\rA\u0014x\u000e]:2+\u0005y\u0003C\u0001\u00196\u001b\u0005\t$B\u0001\u001a4\u0003\u0011)H/\u001b7\u000b\u0003Q\nAA[1wC&\u0011a'\r\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\u0018A\u00039s_B\u001c\u0018g\u0018\u0013fcR\u0011\u0011h\u0010\t\u0003uuj\u0011a\u000f\u0006\u0002y\u0005)1oY1mC&\u0011ah\u000f\u0002\u0005+:LG\u000fC\u0004A\u0007\u0005\u0005\t\u0019A\u0018\u0002\u0007a$\u0013'A\u0004qe>\u00048/\r\u0011\u0002\u000f\r|gNZ5hcU\tA\t\u0005\u0002-\u000b&\u0011a)\b\u0002\f\u0017\u000647.Y\"p]\u001aLw-A\u0006d_:4\u0017nZ\u0019`I\u0015\fHCA\u001dJ\u0011\u001d\u0001e!!AA\u0002\u0011\u000b\u0001bY8oM&<\u0017\u0007I\u0001\u0007aJ|\u0007o\u001d\u001a\u0002\u0015A\u0014x\u000e]:3?\u0012*\u0017\u000f\u0006\u0002:\u001d\"9\u0001)CA\u0001\u0002\u0004y\u0013a\u00029s_B\u001c(\u0007I\u0001\bG>tg-[43\u0003-\u0019wN\u001c4jOJzF%Z9\u0015\u0005e\u001a\u0006b\u0002!\r\u0003\u0003\u0005\r\u0001R\u0001\tG>tg-[43A\u0005\u0019\"M]8lKJlU\r^1Qe>\u00048OR5mKV\tq\u000b\u0005\u0002Y76\t\u0011L\u0003\u0002[g\u0005!A.\u00198h\u0013\ta\u0016L\u0001\u0004TiJLgnZ\u0001\u0015EJ|7.\u001a:NKR\f\u0007K]8qg\u001aKG.\u001a\u0011\u0002\u000fM,'O^3sgV\t\u0001\rE\u0002bI\u001al\u0011A\u0019\u0006\u0003Gn\n!bY8mY\u0016\u001cG/[8o\u0013\t)'MA\u0002TKF\u0004\"\u0001L4\n\u0005!l\"aC&bM.\f7+\u001a:wKJ\f1b]3sm\u0016\u00148o\u0018\u0013fcR\u0011\u0011h\u001b\u0005\b\u0001F\t\t\u00111\u0001a\u0003!\u0019XM\u001d<feN\u0004\u0013!B:fiV\u0003H#A\u001d)\u0005M\u0001\bCA9{\u001b\u0005\u0011(BA:u\u0003\r\t\u0007/\u001b\u0006\u0003kZ\fqA[;qSR,'O\u0003\u0002xq\u0006)!.\u001e8ji*\t\u00110A\u0002pe\u001eL!a\u001f:\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.\u0001\u0005uK\u0006\u0014Hi\\<oQ\t!b\u0010\u0005\u0002r\u007f&\u0019\u0011\u0011\u0001:\u0003\u0013\u00053G/\u001a:FC\u000eD\u0017\u0001\u0007;fgR\fU\u000f^8HK:,'/\u0019;f\u0005J|7.\u001a:JI\"\u001aQ#a\u0002\u0011\u0007E\fI!C\u0002\u0002\fI\u0014A\u0001V3ti\u0006\u0011C/Z:u+N,'oQ8oM&<\u0017I\u001c3HK:,'/\u0019;fI\n\u0013xn[3s\u0013\u0012D3AFA\u0004\u0003q!Xm\u001d;ESN\f'\r\\3HK:,'/\u0019;fI\n\u0013xn[3s\u0013\u0012D3aFA\u0004\u0003q!Xm\u001d;Nk2$\u0018\u000e\u001d7f\u0019><G)\u001b:t\u001b\u0016$\u0018\r\u0015:paND3\u0001GA\u0004\u0003A\"Xm\u001d;D_:\u001c\u0018n\u001d;f]R\u0014%o\\6fe&#gI]8n+N,'oQ8oM&<\u0017I\u001c3NKR\f\u0007K]8qg\"\u001a\u0011$a\u0002\u0002?Q,7\u000f\u001e\"s_.,'/T3uC\u0012\fG/Y(o\u0013\u0012\u001cu\u000e\u001c7jg&|g\u000eK\u0002\u001b\u0003\u000f\tAC^3sS\u001aL(I]8lKJlU\r^1eCR\fGCBA\u0013\u0003W\t)\u0005E\u0002;\u0003OI1!!\u000b<\u0005\u001d\u0011un\u001c7fC:Dq!!\f\u001c\u0001\u0004\ty#A\u0004m_\u001e$\u0015N]:\u0011\t\u0005$\u0017\u0011\u0007\t\u0005\u0003g\t\tE\u0004\u0003\u00026\u0005u\u0002cAA\u001cw5\u0011\u0011\u0011\b\u0006\u0004\u0003w\t\u0013A\u0002\u001fs_>$h(C\u0002\u0002@m\na\u0001\u0015:fI\u00164\u0017b\u0001/\u0002D)\u0019\u0011qH\u001e\t\u000f\u0005\u001d3\u00041\u0001\u0002J\u0005A!M]8lKJLE\rE\u0002;\u0003\u0017J1!!\u0014<\u0005\rIe\u000e\u001e")
public class ServerGenerateBrokerIdTest
extends ZooKeeperTestHarness {
    private Properties props1 = null;
    private KafkaConfig config1 = null;
    private Properties props2 = null;
    private KafkaConfig config2 = null;
    private final String brokerMetaPropsFile;
    private Seq<KafkaServer> servers = Nil$.MODULE$;

    public Properties props1() {
        return this.props1;
    }

    public void props1_$eq(Properties x$1) {
        this.props1 = x$1;
    }

    public KafkaConfig config1() {
        return this.config1;
    }

    public void config1_$eq(KafkaConfig x$1) {
        this.config1 = x$1;
    }

    public Properties props2() {
        return this.props2;
    }

    public void props2_$eq(Properties x$1) {
        this.props2 = x$1;
    }

    public KafkaConfig config2() {
        return this.config2;
    }

    public void config2_$eq(KafkaConfig x$1) {
        this.config2 = x$1;
    }

    public String brokerMetaPropsFile() {
        return this.brokerMetaPropsFile;
    }

    public Seq<KafkaServer> servers() {
        return this.servers;
    }

    public void servers_$eq(Seq<KafkaServer> x$1) {
        this.servers = x$1;
    }

    @Override
    @BeforeEach
    public void setUp() {
        super.setUp();
        this.props1_$eq(TestUtils$.MODULE$.createBrokerConfig(-1, this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1));
        this.config1_$eq(KafkaConfig$.MODULE$.fromProps(this.props1()));
        this.props2_$eq(TestUtils$.MODULE$.createBrokerConfig(0, this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1));
        this.config2_$eq(KafkaConfig$.MODULE$.fromProps(this.props2()));
    }

    @Override
    @AfterEach
    public void tearDown() {
        TestUtils$.MODULE$.shutdownServers(this.servers());
        super.tearDown();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAutoGenerateBrokerId() {
        KafkaServer kafkaServer;
        void createServer_threadNamePrefix;
        void createServer_config;
        KafkaServer kafkaServer2;
        Time time;
        KafkaConfig x$1 = this.config1();
        Option x$2 = Option$.MODULE$.apply((Object)this.getClass().getName());
        Time time2 = time = Time.SYSTEM;
        time = null;
        Time x$3 = time2;
        boolean bl = false;
        KafkaServer server1 = new KafkaServer(x$1, x$3, x$2, bl);
        server1.startup();
        server1.shutdown();
        Assertions.assertTrue((boolean)this.verifyBrokerMetadata((Seq<String>)this.config1().logDirs(), 1001));
        Option option = Option$.MODULE$.apply((Object)this.getClass().getName());
        KafkaConfig kafkaConfig = this.config1();
        TestUtils$ createServer_this = TestUtils$.MODULE$;
        Time createServer_createServer_time = Time.SYSTEM;
        KafkaServer kafkaServer3 = kafkaServer2 = createServer_this.createServer((KafkaConfig)createServer_config, createServer_createServer_time, (Option<String>)createServer_threadNamePrefix, false);
        Object var8_10 = null;
        kafkaServer2 = null;
        KafkaServer kafkaServer4 = kafkaServer = kafkaServer3;
        Object var5_9 = null;
        kafkaConfig = null;
        option = null;
        kafkaServer = null;
        server1 = kafkaServer4;
        this.servers_$eq((Seq<KafkaServer>)new .colon.colon((Object)server1, (List)Nil$.MODULE$));
        Assertions.assertEquals((int)server1.config().brokerId(), (int)1001);
        server1.shutdown();
        TestUtils$.MODULE$.assertNoNonDaemonThreads(this.getClass().getName());
    }

    @Test
    public void testUserConfigAndGeneratedBrokerId() {
        Time time;
        Time time2;
        Time time3;
        KafkaConfig x$12 = this.config1();
        Option x$2 = Option$.MODULE$.apply((Object)this.getClass().getName());
        Time time4 = time3 = Time.SYSTEM;
        time3 = null;
        Time x$3 = time4;
        boolean bl = false;
        KafkaServer server1 = new KafkaServer(x$12, x$3, x$2, bl);
        KafkaConfig x$5 = this.config2();
        Option x$6 = Option$.MODULE$.apply((Object)this.getClass().getName());
        Time time5 = time2 = Time.SYSTEM;
        time2 = null;
        Time x$7 = time5;
        boolean bl2 = false;
        KafkaServer server2 = new KafkaServer(x$5, x$7, x$6, bl2);
        Properties props3 = TestUtils$.MODULE$.createBrokerConfig(-1, this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1);
        KafkaConfig x$9 = KafkaConfig$.MODULE$.fromProps(props3);
        Option x$10 = Option$.MODULE$.apply((Object)this.getClass().getName());
        Time time6 = time = Time.SYSTEM;
        time = null;
        Time x$11 = time6;
        boolean bl3 = false;
        KafkaServer server3 = new KafkaServer(x$9, x$11, x$10, bl3);
        server1.startup();
        Assertions.assertEquals((int)server1.config().brokerId(), (int)1001);
        server2.startup();
        Assertions.assertEquals((int)server2.config().brokerId(), (int)0);
        server3.startup();
        Assertions.assertEquals((int)server3.config().brokerId(), (int)1002);
        this.servers_$eq((Seq<KafkaServer>)new .colon.colon((Object)server1, (List)new .colon.colon((Object)server2, (List)new .colon.colon((Object)server3, (List)Nil$.MODULE$))));
        this.servers().foreach((Function1 & Serializable)x$1 -> {
            x$1.shutdown();
            return BoxedUnit.UNIT;
        });
        Assertions.assertTrue((boolean)this.verifyBrokerMetadata((Seq<String>)server1.config().logDirs(), 1001));
        Assertions.assertTrue((boolean)this.verifyBrokerMetadata((Seq<String>)server2.config().logDirs(), 0));
        Assertions.assertTrue((boolean)this.verifyBrokerMetadata((Seq<String>)server3.config().logDirs(), 1002));
        TestUtils$.MODULE$.assertNoNonDaemonThreads(this.getClass().getName());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDisableGeneratedBrokerId() {
        KafkaServer kafkaServer;
        void createServer_threadNamePrefix;
        KafkaServer kafkaServer2;
        Properties props3 = TestUtils$.MODULE$.createBrokerConfig(3, this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1);
        props3.put(KafkaConfig$.MODULE$.BrokerIdGenerationEnableProp(), "false");
        props3.put(KafkaConfig$.MODULE$.MaxReservedBrokerIdProp(), "0");
        KafkaConfig config3 = KafkaConfig$.MODULE$.fromProps(props3);
        Option option = Option$.MODULE$.apply((Object)this.getClass().getName());
        TestUtils$ createServer_this = TestUtils$.MODULE$;
        Time createServer_createServer_time = Time.SYSTEM;
        KafkaServer kafkaServer3 = kafkaServer2 = createServer_this.createServer(config3, createServer_createServer_time, (Option<String>)createServer_threadNamePrefix, false);
        Object var6_5 = null;
        kafkaServer2 = null;
        KafkaServer kafkaServer4 = kafkaServer = kafkaServer3;
        Object var4_4 = null;
        option = null;
        kafkaServer = null;
        KafkaServer server3 = kafkaServer4;
        this.servers_$eq((Seq<KafkaServer>)new .colon.colon((Object)server3, (List)Nil$.MODULE$));
        Assertions.assertEquals((int)server3.config().brokerId(), (int)3);
        server3.shutdown();
        Assertions.assertTrue((boolean)this.verifyBrokerMetadata((Seq<String>)server3.config().logDirs(), 3));
        TestUtils$.MODULE$.assertNoNonDaemonThreads(this.getClass().getName());
    }

    @Test
    public void testMultipleLogDirsMetaProps() {
        Time time;
        Time time2;
        String logDirs = new StringBuilder(2).append(this.props1().getProperty("log.dir")).append(",").append(TestUtils.tempDirectory(null, null).getAbsolutePath()).append(",").append(TestUtils.tempDirectory(null, null).getAbsolutePath()).toString();
        this.props1().setProperty("log.dir", logDirs);
        this.config1_$eq(KafkaConfig$.MODULE$.fromProps(this.props1()));
        KafkaConfig x$1 = this.config1();
        Option x$2 = Option$.MODULE$.apply((Object)this.getClass().getName());
        Time time3 = time2 = Time.SYSTEM;
        time2 = null;
        Time x$3 = time3;
        boolean bl = false;
        KafkaServer server1 = new KafkaServer(x$1, x$3, x$2, bl);
        server1.startup();
        this.servers_$eq((Seq<KafkaServer>)new .colon.colon((Object)server1, (List)Nil$.MODULE$));
        server1.shutdown();
        Assertions.assertTrue((boolean)this.verifyBrokerMetadata((Seq<String>)this.config1().logDirs(), 1001));
        String newLogDirs = new StringBuilder(1).append(this.props1().getProperty("log.dir")).append(",").append(TestUtils.tempDirectory(null, null).getAbsolutePath()).toString();
        this.props1().setProperty("log.dir", newLogDirs);
        this.config1_$eq(KafkaConfig$.MODULE$.fromProps(this.props1()));
        KafkaConfig x$5 = this.config1();
        Option x$6 = Option$.MODULE$.apply((Object)this.getClass().getName());
        Time time4 = time = Time.SYSTEM;
        time = null;
        Time x$7 = time4;
        boolean bl2 = false;
        server1 = new KafkaServer(x$5, x$7, x$6, bl2);
        server1.startup();
        this.servers_$eq((Seq<KafkaServer>)new .colon.colon((Object)server1, (List)Nil$.MODULE$));
        server1.shutdown();
        Assertions.assertTrue((boolean)this.verifyBrokerMetadata((Seq<String>)this.config1().logDirs(), 1001));
        TestUtils$.MODULE$.assertNoNonDaemonThreads(this.getClass().getName());
    }

    @Test
    public void testConsistentBrokerIdFromUserConfigAndMetaProps() {
        Time time;
        Time time2;
        KafkaConfig x$1 = this.config1();
        Option x$2 = Option$.MODULE$.apply((Object)this.getClass().getName());
        Time time3 = time2 = Time.SYSTEM;
        time2 = null;
        Time x$3 = time3;
        boolean bl = false;
        KafkaServer server1 = new KafkaServer(x$1, x$3, x$2, bl);
        server1.startup();
        this.servers_$eq((Seq<KafkaServer>)new .colon.colon((Object)server1, (List)Nil$.MODULE$));
        server1.shutdown();
        KafkaConfig x$5 = this.config2();
        Option x$6 = Option$.MODULE$.apply((Object)this.getClass().getName());
        Time time4 = time = Time.SYSTEM;
        time = null;
        Time x$7 = time4;
        boolean bl2 = false;
        server1 = new KafkaServer(x$5, x$7, x$6, bl2);
        try {
            server1.startup();
        }
        catch (InconsistentBrokerIdException inconsistentBrokerIdException) {}
        server1.shutdown();
        TestUtils$.MODULE$.assertNoNonDaemonThreads(this.getClass().getName());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testBrokerMetadataOnIdCollision() {
        KafkaServer kafkaServer;
        void createServer_threadNamePrefix;
        KafkaServer kafkaServer2;
        Time time;
        KafkaServer kafkaServer3;
        void createServer_threadNamePrefix2;
        KafkaServer kafkaServer4;
        Properties propsA = TestUtils$.MODULE$.createBrokerConfig(1, this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1);
        KafkaConfig configA = KafkaConfig$.MODULE$.fromProps(propsA);
        Option option = Option$.MODULE$.apply((Object)this.getClass().getName());
        TestUtils$ createServer_this = TestUtils$.MODULE$;
        Time createServer_createServer_time = Time.SYSTEM;
        KafkaServer kafkaServer5 = kafkaServer4 = createServer_this.createServer(configA, createServer_createServer_time, (Option<String>)createServer_threadNamePrefix2, false);
        Object var13_5 = null;
        kafkaServer4 = null;
        KafkaServer kafkaServer6 = kafkaServer3 = kafkaServer5;
        Object var11_4 = null;
        option = null;
        kafkaServer3 = null;
        KafkaServer serverA = kafkaServer6;
        Properties propsB = TestUtils$.MODULE$.createBrokerConfig(1, this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1);
        KafkaConfig configB = KafkaConfig$.MODULE$.fromProps(propsB);
        Option x$2 = Option$.MODULE$.apply((Object)this.getClass().getName());
        Time time2 = time = Time.SYSTEM;
        time = null;
        Time x$3 = time2;
        boolean bl = false;
        KafkaServer serverB = new KafkaServer(configB, x$3, x$2, bl);
        Assertions.assertThrows(KeeperException.NodeExistsException.class, () -> serverB.startup());
        this.servers_$eq((Seq<KafkaServer>)new .colon.colon((Object)serverA, (List)Nil$.MODULE$));
        serverB.config().logDirs().foreach((Function1 & Serializable)logDir -> {
            ServerGenerateBrokerIdTest.$anonfun$testBrokerMetadataOnIdCollision$2(this, logDir);
            return BoxedUnit.UNIT;
        });
        propsB.setProperty(KafkaConfig$.MODULE$.BrokerIdProp(), "2");
        KafkaConfig newConfigB = KafkaConfig$.MODULE$.fromProps(propsB);
        Option option2 = Option$.MODULE$.apply((Object)this.getClass().getName());
        TestUtils$ createServer_this2 = TestUtils$.MODULE$;
        Time createServer_createServer_time2 = Time.SYSTEM;
        KafkaServer kafkaServer7 = kafkaServer2 = createServer_this2.createServer(newConfigB, createServer_createServer_time2, (Option<String>)createServer_threadNamePrefix, false);
        Object var18_19 = null;
        kafkaServer2 = null;
        KafkaServer kafkaServer8 = kafkaServer = kafkaServer7;
        Object var16_18 = null;
        option2 = null;
        kafkaServer = null;
        KafkaServer newServerB = kafkaServer8;
        this.servers_$eq((Seq<KafkaServer>)new .colon.colon((Object)serverA, (List)new .colon.colon((Object)newServerB, (List)Nil$.MODULE$)));
        serverA.shutdown();
        newServerB.shutdown();
        Assertions.assertTrue((boolean)this.verifyBrokerMetadata((Seq<String>)serverA.config().logDirs(), 1));
        Assertions.assertTrue((boolean)this.verifyBrokerMetadata((Seq<String>)newServerB.config().logDirs(), 2));
        TestUtils$.MODULE$.assertNoNonDaemonThreads(this.getClass().getName());
    }

    public boolean verifyBrokerMetadata(Seq<String> logDirs, int brokerId) {
        Object object = new Object();
        try {
            logDirs.foreach((Function1 & Serializable)logDir -> {
                ServerGenerateBrokerIdTest.$anonfun$verifyBrokerMetadata$1(this, brokerId, object, logDir);
                return BoxedUnit.UNIT;
            });
            return true;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                return ex.value$mcZ$sp();
            }
            throw ex;
        }
    }

    public static final /* synthetic */ void $anonfun$testBrokerMetadataOnIdCollision$2(ServerGenerateBrokerIdTest $this, String logDir) {
        Assertions.assertFalse((boolean)new File(new StringBuilder(0).append(logDir).append(File.separator).append($this.brokerMetaPropsFile()).toString()).exists());
    }

    public static final /* synthetic */ void $anonfun$verifyBrokerMetadata$1(ServerGenerateBrokerIdTest $this, int brokerId$1, Object nonLocalReturnKey1$1, String logDir) {
        Option brokerMetadataOpt = new BrokerMetadataCheckpoint(new File(new StringBuilder(0).append(logDir).append(File.separator).append($this.brokerMetaPropsFile()).toString())).read();
        if (brokerMetadataOpt instanceof Some) {
            Properties properties = (Properties)((Some)brokerMetadataOpt).value();
            if (new RawMetaProperties(properties).brokerId().exists((Function1)(JFunction1.mcZI.sp & Serializable)x$2 -> x$2 != brokerId$1)) {
                throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, false);
            }
        } else {
            throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, false);
        }
    }

    public ServerGenerateBrokerIdTest() {
        this.brokerMetaPropsFile = "meta.properties";
    }
}

