/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import java.io.Serializable;
import kafka.api.LeaderAndIsr;
import kafka.api.LeaderAndIsr$;
import kafka.common.StateChangeFailedException;
import kafka.controller.ControlledShutdownPartitionLeaderElectionStrategy$;
import kafka.controller.ControllerBrokerRequestBatch;
import kafka.controller.ControllerContext;
import kafka.controller.Election$;
import kafka.controller.ElectionResult;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.controller.NewPartition$;
import kafka.controller.NonExistentPartition$;
import kafka.controller.OfflinePartition$;
import kafka.controller.OfflinePartitionLeaderElectionStrategy;
import kafka.controller.OnlinePartition$;
import kafka.controller.PartitionLeaderElectionStrategy;
import kafka.controller.PartitionState;
import kafka.controller.PartitionStateMachine;
import kafka.controller.PreferredReplicaPartitionLeaderElectionStrategy$;
import kafka.controller.ReassignPartitionLeaderElectionStrategy$;
import kafka.controller.ReplicaAssignment;
import kafka.controller.StateChangeLogger;
import kafka.log.LogConfig;
import kafka.server.KafkaConfig;
import kafka.utils.Implicits$MapExtensionMethods$;
import kafka.zk.KafkaZkClient;
import kafka.zk.TopicPartitionStateZNode$;
import kafka.zookeeper.GetDataResponse;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.ControllerMovedException;
import org.apache.zookeeper.KeeperException;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Growable;
import scala.collection.mutable.Map$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0005\u0005%f\u0001B\n\u0015\u0001eA\u0001B\b\u0001\u0003\u0002\u0003\u0006Ia\b\u0005\tK\u0001\u0011\t\u0011)A\u0005M!A\u0011\u0006\u0001B\u0001B\u0003%!\u0006\u0003\u0005.\u0001\t\u0005\t\u0015!\u0003/\u0011!!\u0004A!A!\u0002\u0013)\u0004\"\u0002\u001d\u0001\t\u0003I\u0004b\u0002!\u0001\u0005\u0004%I!\u0011\u0005\u0007\u0011\u0002\u0001\u000b\u0011\u0002\"\t\u000b%\u0003A\u0011\t&\t\u000f\u0005\u001d\u0001\u0001\"\u0003\u0002\n!9\u0011q\u0002\u0001\u0005\n\u0005E\u0001bBA\r\u0001\u0011%\u00111\u0004\u0005\b\u0003?\u0001A\u0011BA\u0011\u0011\u001d\tI\u0003\u0001C\u0005\u0003WAq!!\u0011\u0001\t\u0013\t\u0019\u0005C\u0004\u0002b\u0001!I!a\u0019\t\u000f\u0005=\u0004\u0001\"\u0003\u0002r!9\u0011q\u000e\u0001\u0005\n\u0005u%a\u0006.l!\u0006\u0014H/\u001b;j_:\u001cF/\u0019;f\u001b\u0006\u001c\u0007.\u001b8f\u0015\t)b#\u0001\u0006d_:$(o\u001c7mKJT\u0011aF\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001!\u0004\u0005\u0002\u001c95\tA#\u0003\u0002\u001e)\t)\u0002+\u0019:uSRLwN\\*uCR,W*Y2iS:,\u0017AB2p]\u001aLw\r\u0005\u0002!G5\t\u0011E\u0003\u0002#-\u000511/\u001a:wKJL!\u0001J\u0011\u0003\u0017-\u000bgm[1D_:4\u0017nZ\u0001\u0012gR\fG/Z\"iC:<W\rT8hO\u0016\u0014\bCA\u000e(\u0013\tACCA\tTi\u0006$Xm\u00115b]\u001e,Gj\\4hKJ\f\u0011cY8oiJ|G\u000e\\3s\u0007>tG/\u001a=u!\tY2&\u0003\u0002-)\t\t2i\u001c8ue>dG.\u001a:D_:$X\r\u001f;\u0002\u0011i\\7\t\\5f]R\u0004\"a\f\u001a\u000e\u0003AR!!\r\f\u0002\u0005i\\\u0017BA\u001a1\u00055Y\u0015MZ6b5.\u001cE.[3oi\u0006a2m\u001c8ue>dG.\u001a:Ce>\\WM\u001d*fcV,7\u000f\u001e\"bi\u000eD\u0007CA\u000e7\u0013\t9DC\u0001\u000fD_:$(o\u001c7mKJ\u0014%o\\6feJ+\u0017/^3ti\n\u000bGo\u00195\u0002\rqJg.\u001b;?)\u0019Q4\bP\u001f?\u007fA\u00111\u0004\u0001\u0005\u0006=\u0019\u0001\ra\b\u0005\u0006K\u0019\u0001\rA\n\u0005\u0006S\u0019\u0001\rA\u000b\u0005\u0006[\u0019\u0001\rA\f\u0005\u0006i\u0019\u0001\r!N\u0001\rG>tGO]8mY\u0016\u0014\u0018\nZ\u000b\u0002\u0005B\u00111IR\u0007\u0002\t*\tQ)A\u0003tG\u0006d\u0017-\u0003\u0002H\t\n\u0019\u0011J\u001c;\u0002\u001b\r|g\u000e\u001e:pY2,'/\u00133!\u0003IA\u0017M\u001c3mKN#\u0018\r^3DQ\u0006tw-Z:\u0015\t-\u000bho\u001f\t\u0005\u0019>\u000bF,D\u0001N\u0015\tqE)\u0001\u0006d_2dWm\u0019;j_:L!\u0001U'\u0003\u00075\u000b\u0007\u000f\u0005\u0002S56\t1K\u0003\u0002U+\u000611m\\7n_:T!a\u0006,\u000b\u0005]C\u0016AB1qC\u000eDWMC\u0001Z\u0003\ry'oZ\u0005\u00037N\u0013a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0005\u0003^K\"\\gB\u00010d\u001d\ty&-D\u0001a\u0015\t\t\u0007$\u0001\u0004=e>|GOP\u0005\u0002\u000b&\u0011A\rR\u0001\ba\u0006\u001c7.Y4f\u0013\t1wM\u0001\u0004FSRDWM\u001d\u0006\u0003I\u0012\u0003\"!X5\n\u0005)<'!\u0003+ie><\u0018M\u00197f!\taw.D\u0001n\u0015\tqg#A\u0002ba&L!\u0001]7\u0003\u00191+\u0017\rZ3s\u0003:$\u0017j\u001d:\t\u000bIL\u0001\u0019A:\u0002\u0015A\f'\u000f^5uS>t7\u000fE\u0002MiFK!!^'\u0003\u0007M+\u0017\u000fC\u0003x\u0013\u0001\u0007\u00010A\u0006uCJ<W\r^*uCR,\u0007CA\u000ez\u0013\tQHC\u0001\bQCJ$\u0018\u000e^5p]N#\u0018\r^3\t\u000bqL\u0001\u0019A?\u0002EA\f'\u000f^5uS>tG*Z1eKJ,E.Z2uS>t7\u000b\u001e:bi\u0016<\u0017p\u00149u!\u0011\u0019e0!\u0001\n\u0005}$%AB(qi&|g\u000eE\u0002\u001c\u0003\u0007I1!!\u0002\u0015\u0005}\u0001\u0016M\u001d;ji&|g\u000eT3bI\u0016\u0014X\t\\3di&|gn\u0015;sCR,w-_\u0001\u000fa\u0006\u0014H/\u001b;j_:\u001cF/\u0019;f)\rA\u00181\u0002\u0005\u0007\u0003\u001bQ\u0001\u0019A)\u0002\u0013A\f'\u000f^5uS>t\u0017\u0001\u00063p\u0011\u0006tG\r\\3Ti\u0006$Xm\u00115b]\u001e,7\u000fF\u0004L\u0003'\t)\"a\u0006\t\u000bI\\\u0001\u0019A:\t\u000b]\\\u0001\u0019\u0001=\t\u000bq\\\u0001\u0019A?\u0002G%t\u0017\u000e^5bY&TX\rT3bI\u0016\u0014\u0018I\u001c3JgJ4uN\u001d)beRLG/[8ogR\u00191/!\b\t\u000bId\u0001\u0019A:\u00021\u0015dWm\u0019;MK\u0006$WM\u001d$peB\u000b'\u000f^5uS>t7\u000fF\u0003L\u0003G\t)\u0003C\u0003s\u001b\u0001\u00071\u000fC\u0004\u0002(5\u0001\r!!\u0001\u0002?A\f'\u000f^5uS>tG*Z1eKJ,E.Z2uS>t7\u000b\u001e:bi\u0016<\u00170\u0001\u000ee_\u0016cWm\u0019;MK\u0006$WM\u001d$peB\u000b'\u000f^5uS>t7\u000f\u0006\u0004\u0002.\u0005u\u0012q\b\t\u0007\u0007\u0006=\u00121G:\n\u0007\u0005EBI\u0001\u0004UkBdWM\r\t\u0006\u0019>\u000b\u0016Q\u0007\t\u0006;\u0016\f9d\u001b\t\u0004;\u0006e\u0012bAA\u001eO\nIQ\t_2faRLwN\u001c\u0005\u0006e:\u0001\ra\u001d\u0005\b\u0003Oq\u0001\u0019AA\u0001\u0003\u0005\u001aw\u000e\u001c7fGR,fn\u00197fC:dU-\u00193fe\u0016cWm\u0019;j_:\u001cF/\u0019;f)\u0019\t)%!\u0016\u0002^A!A\n^A$!!\u0019\u0015\u0011J)\u0002N\u0005=\u0013bAA&\t\n1A+\u001e9mKN\u00022a\u0011@l!\r\u0019\u0015\u0011K\u0005\u0004\u0003'\"%a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003/z\u0001\u0019AA-\u00035aW-\u00193fe\u0006sG-S:sgB!A\n^A.!\u0015\u0019\u0015qF)l\u0011\u001d\tyf\u0004a\u0001\u0003\u001f\nA\"\u00197m_^,fn\u00197fC:\fA\u0003\\8h\u0013:4\u0018\r\\5e)J\fgn]5uS>tGCBA3\u0003W\ni\u0007E\u0002D\u0003OJ1!!\u001bE\u0005\u0011)f.\u001b;\t\r\u00055\u0001\u00031\u0001R\u0011\u00159\b\u00031\u0001y\u0003Qawn\u001a$bS2,Gm\u0015;bi\u0016\u001c\u0005.\u00198hKRQ\u0011QMA:\u0003k\nI(a\u001f\t\r\u00055\u0011\u00031\u0001R\u0011\u0019\t9(\u0005a\u0001q\u0006I1-\u001e:s'R\fG/\u001a\u0005\u0006oF\u0001\r\u0001\u001f\u0005\b\u0003{\n\u0002\u0019AA@\u0003\u0011\u0019w\u000eZ3\u0011\t\u0005\u0005\u0015q\u0013\b\u0005\u0003\u0007\u000b\tJ\u0004\u0003\u0002\u0006\u00065e\u0002BAD\u0003\u0017s1aXAE\u0013\u0005I\u0016BA,Y\u0013\r\tyIV\u0001\nu>|7.Z3qKJLA!a%\u0002\u0016\u0006y1*Z3qKJ,\u0005pY3qi&|gNC\u0002\u0002\u0010ZKA!!'\u0002\u001c\n!1i\u001c3f\u0015\u0011\t\u0019*!&\u0015\u0015\u0005\u0015\u0014qTAQ\u0003G\u000b)\u000b\u0003\u0004\u0002\u000eI\u0001\r!\u0015\u0005\u0007\u0003o\u0012\u0002\u0019\u0001=\t\u000b]\u0014\u0002\u0019\u0001=\t\r\u0005\u001d&\u00031\u0001i\u0003\u0005!\b")
public class ZkPartitionStateMachine
extends PartitionStateMachine {
    private final KafkaConfig config;
    private final StateChangeLogger stateChangeLogger;
    private final ControllerContext controllerContext;
    private final KafkaZkClient zkClient;
    private final ControllerBrokerRequestBatch controllerBrokerRequestBatch;
    private final int controllerId;

    private int controllerId() {
        return this.controllerId;
    }

    @Override
    public Map<TopicPartition, Either<Throwable, LeaderAndIsr>> handleStateChanges(Seq<TopicPartition> partitions, PartitionState targetState, Option<PartitionLeaderElectionStrategy> partitionLeaderElectionStrategyOpt) {
        if (partitions.nonEmpty()) {
            try {
                this.controllerBrokerRequestBatch.newBatch();
                Map<TopicPartition, Either<Throwable, LeaderAndIsr>> result = this.doHandleStateChanges(partitions, targetState, partitionLeaderElectionStrategyOpt);
                this.controllerBrokerRequestBatch.sendRequestsToBrokers(this.controllerContext.epoch());
                return result;
            }
            catch (ControllerMovedException e) {
                this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(72).append("Controller moved to another broker when moving some partitions to ").append(targetState).append(" state").toString(), (Function0<Throwable>)(Function0 & Serializable)() -> e);
                throw e;
            }
            catch (Throwable e) {
                this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(44).append("Error while moving some partitions to ").append(targetState).append(" state").toString(), (Function0<Throwable>)(Function0 & Serializable)() -> e);
                return partitions.iterator().map((Function1 & Serializable)x$1 -> {
                    Left left;
                    if (package$.MODULE$.Left() == null) {
                        throw null;
                    }
                    Left left2 = left = new Left((Object)e);
                    left = null;
                    Left $minus$greater$extension_y = left2;
                    return new Tuple2(x$1, (Object)$minus$greater$extension_y);
                }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            }
        }
        return (Map)scala.collection.Map$.MODULE$.empty();
    }

    private PartitionState partitionState(TopicPartition partition) {
        return this.controllerContext.partitionState(partition);
    }

    private Map<TopicPartition, Either<Throwable, LeaderAndIsr>> doHandleStateChanges(Seq<TopicPartition> partitions, PartitionState targetState, Option<PartitionLeaderElectionStrategy> partitionLeaderElectionStrategyOpt) {
        Map map;
        StateChangeLogger stateChangeLog = this.stateChangeLogger.withControllerEpoch(this.controllerContext.epoch());
        boolean traceEnabled = stateChangeLog.isTraceEnabled();
        partitions.foreach((Function1 & Serializable)partition -> {
            this.controllerContext.putPartitionStateIfNotExists(partition, NonExistentPartition$.MODULE$);
            return BoxedUnit.UNIT;
        });
        Tuple2<Seq<TopicPartition>, Seq<TopicPartition>> tuple2 = this.controllerContext.checkValidPartitionStateChange(partitions, targetState);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Seq seq = (Seq)tuple2._1();
        Seq seq2 = (Seq)tuple2._2();
        seq2.foreach((Function1 & Serializable)partition -> {
            this.logInvalidTransition(partition, targetState);
            return BoxedUnit.UNIT;
        });
        if (NewPartition$.MODULE$.equals(targetState)) {
            seq.foreach((Function1 & Serializable)partition -> {
                ZkPartitionStateMachine.$anonfun$doHandleStateChanges$3(this, stateChangeLog, targetState, partition);
                return BoxedUnit.UNIT;
            });
            map = (Map)scala.collection.Map$.MODULE$.empty();
        } else if (OnlinePartition$.MODULE$.equals(targetState)) {
            Map<TopicPartition, Either<Throwable, LeaderAndIsr>> map2;
            Seq uninitializedPartitions = (Seq)seq.filter((Function1 & Serializable)partition -> BoxesRunTime.boxToBoolean((boolean)ZkPartitionStateMachine.$anonfun$doHandleStateChanges$5(this, partition)));
            Seq partitionsToElectLeader = (Seq)seq.filter((Function1 & Serializable)partition -> BoxesRunTime.boxToBoolean((boolean)ZkPartitionStateMachine.$anonfun$doHandleStateChanges$6(this, partition)));
            if (uninitializedPartitions.nonEmpty()) {
                this.initializeLeaderAndIsrForPartitions((Seq<TopicPartition>)uninitializedPartitions).foreach((Function1 & Serializable)partition -> {
                    ZkPartitionStateMachine.$anonfun$doHandleStateChanges$7(this, stateChangeLog, targetState, partition);
                    return BoxedUnit.UNIT;
                });
            }
            if (partitionsToElectLeader.nonEmpty()) {
                if (partitionLeaderElectionStrategyOpt == null) {
                    throw null;
                }
                if (partitionLeaderElectionStrategyOpt.isEmpty()) {
                    throw new IllegalArgumentException("Election strategy is a required field when the target state is OnlinePartition");
                }
                Map<TopicPartition, Either<Throwable, LeaderAndIsr>> electionResults = this.electLeaderForPartitions((Seq<TopicPartition>)partitionsToElectLeader, (PartitionLeaderElectionStrategy)partitionLeaderElectionStrategyOpt.get());
                electionResults.foreach((Function1 & Serializable)x0$1 -> {
                    ZkPartitionStateMachine.$anonfun$doHandleStateChanges$10(this, stateChangeLog, targetState, x0$1);
                    return BoxedUnit.UNIT;
                });
                map2 = electionResults;
            } else {
                map2 = (Map<TopicPartition, Either<Throwable, LeaderAndIsr>>)scala.collection.Map$.MODULE$.empty();
            }
            map = map2;
        } else if (OfflinePartition$.MODULE$.equals(targetState)) {
            seq.foreach((Function1 & Serializable)partition -> {
                ZkPartitionStateMachine.$anonfun$doHandleStateChanges$12(this, traceEnabled, stateChangeLog, targetState, partition);
                return BoxedUnit.UNIT;
            });
            map = (Map)scala.collection.Map$.MODULE$.empty();
        } else if (NonExistentPartition$.MODULE$.equals(targetState)) {
            seq.foreach((Function1 & Serializable)partition -> {
                ZkPartitionStateMachine.$anonfun$doHandleStateChanges$14(this, traceEnabled, stateChangeLog, targetState, partition);
                return BoxedUnit.UNIT;
            });
            map = (Map)scala.collection.Map$.MODULE$.empty();
        } else {
            throw new MatchError((Object)targetState);
        }
        return map;
    }

    /*
     * WARNING - void declaration
     */
    private Seq<TopicPartition> initializeLeaderAndIsrForPartitions(Seq<TopicPartition> partitions) {
        void var2_2;
        Seq seq;
        Buffer successfulInitializations = (Buffer)Buffer$.MODULE$.empty();
        Tuple2 tuple2 = ((Seq)((Seq)partitions.map((Function1 & Serializable)partition -> {
            Seq<Object> $minus$greater$extension_y = $this.controllerContext.partitionReplicaAssignment((TopicPartition)partition);
            return new Tuple2(partition, $minus$greater$extension_y);
        })).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2;
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            TopicPartition partition = (TopicPartition)x0$1._1();
            Seq liveReplicasForPartition = (Seq)((Seq)x0$1._2()).filter((Function1)(JFunction1.mcZI.sp & Serializable)replica -> $this.controllerContext.isReplicaOnline(replica, partition, $this.controllerContext.isReplicaOnline$default$3()));
            Tuple2 tuple22 = tuple2 = new Tuple2((Object)partition, (Object)liveReplicasForPartition);
            tuple2 = null;
            Tuple2 tuple23 = tuple22;
            return tuple23;
        })).partition((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)ZkPartitionStateMachine.$anonfun$initializeLeaderAndIsrForPartitions$4(x0$2)));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Seq seq2 = (Seq)tuple2._1();
        Seq seq3 = (Seq)tuple2._2();
        seq2.foreach((Function1 & Serializable)x0$3 -> {
            ZkPartitionStateMachine.$anonfun$initializeLeaderAndIsrForPartitions$5(this, x0$3);
            return BoxedUnit.UNIT;
        });
        scala.collection.immutable.Map leaderIsrAndControllerEpochs = ((IterableOnceOps)seq3.map((Function1 & Serializable)x0$4 -> {
            Tuple2 tuple2;
            if (x0$4 == null) {
                throw new MatchError(null);
            }
            TopicPartition partition = (TopicPartition)x0$4._1();
            Seq liveReplicas = (Seq)x0$4._2();
            LeaderAndIsr leaderAndIsr = LeaderAndIsr$.MODULE$.apply(BoxesRunTime.unboxToInt((Object)liveReplicas.head()), (List<Object>)liveReplicas.toList());
            LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr, $this.controllerContext.epoch());
            Tuple2 tuple22 = tuple2 = new Tuple2((Object)partition, (Object)leaderIsrAndControllerEpoch);
            tuple2 = null;
            Tuple2 tuple23 = tuple22;
            return tuple23;
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        try {
            seq = this.zkClient.createTopicPartitionStatesRaw((Map<TopicPartition, LeaderIsrAndControllerEpoch>)leaderIsrAndControllerEpochs, this.controllerContext.epochZkVersion());
        }
        catch (ControllerMovedException e) {
            this.error((Function0<String>)(Function0 & Serializable)() -> "Controller moved to another broker when trying to create the topic partition state znode", (Function0<Throwable>)(Function0 & Serializable)() -> e);
            throw e;
        }
        catch (Exception e) {
            seq3.foreach((Function1 & Serializable)x0$5 -> {
                ZkPartitionStateMachine.$anonfun$initializeLeaderAndIsrForPartitions$9(this, e, x0$5);
                return BoxedUnit.UNIT;
            });
            seq = (Seq)Seq$.MODULE$.empty();
        }
        seq.foreach((Function1 & Serializable)createResponse -> {
            KeeperException.Code code = createResponse.resultCode();
            TopicPartition partition = (TopicPartition)createResponse.ctx().get();
            LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)leaderIsrAndControllerEpochs.apply((Object)partition);
            KeeperException.Code code2 = code;
            KeeperException.Code code3 = KeeperException.Code.OK;
            if (!(code2 != null ? !code2.equals(code3) : code3 != null)) {
                $this.controllerContext.putPartitionLeadershipInfo(partition, leaderIsrAndControllerEpoch);
                $this.controllerBrokerRequestBatch.addLeaderAndIsrRequestForBrokers((Seq<Object>)leaderIsrAndControllerEpoch.leaderAndIsr().isr(), partition, leaderIsrAndControllerEpoch, $this.controllerContext.partitionFullReplicaAssignment(partition), true);
                if (successfulInitializations == null) {
                    throw null;
                }
                return successfulInitializations.addOne((Object)partition);
            }
            this.logFailedStateChange(partition, (PartitionState)NewPartition$.MODULE$, (PartitionState)OnlinePartition$.MODULE$, code);
            return BoxedUnit.UNIT;
        });
        return var2_2;
    }

    private Map<TopicPartition, Either<Throwable, LeaderAndIsr>> electLeaderForPartitions(Seq<TopicPartition> partitions, PartitionLeaderElectionStrategy partitionLeaderElectionStrategy) {
        Seq remaining = partitions;
        scala.collection.mutable.Map finishedElections = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        while (remaining.nonEmpty()) {
            Tuple2<Map<TopicPartition, Either<Exception, LeaderAndIsr>>, Seq<TopicPartition>> tuple2 = this.doElectLeaderForPartitions(remaining, partitionLeaderElectionStrategy);
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            Map map = (Map)tuple2._1();
            Seq seq = (Seq)tuple2._2();
            remaining = seq;
            map.foreach((Function1 & Serializable)x0$1 -> {
                ZkPartitionStateMachine.$anonfun$electLeaderForPartitions$1(this, x0$1);
                return BoxedUnit.UNIT;
            });
            if (finishedElections == null) {
                throw null;
            }
            finishedElections.addAll((IterableOnce)map);
            if (!remaining.nonEmpty() || !this.logger().underlying().isInfoEnabled()) continue;
            this.logger().underlying().info("Retrying leader election with strategy {} for partitions {}", new Object[]{partitionLeaderElectionStrategy, remaining});
        }
        return finishedElections.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private Tuple2<Map<TopicPartition, Either<Exception, LeaderAndIsr>>, Seq<TopicPartition>> doElectLeaderForPartitions(Seq<TopicPartition> partitions, PartitionLeaderElectionStrategy partitionLeaderElectionStrategy) {
        Tuple2 tuple2;
        Seq<GetDataResponse> seq;
        try {
            seq = this.zkClient.getTopicPartitionStatesRaw(partitions);
        }
        catch (Exception e) {
            return new Tuple2((Object)partitions.iterator().map((Function1 & Serializable)x$5 -> {
                Left left;
                if (package$.MODULE$.Left() == null) {
                    throw null;
                }
                Left left2 = left = new Left((Object)e);
                left = null;
                Left $minus$greater$extension_y = left2;
                return new Tuple2(x$5, (Object)$minus$greater$extension_y);
            }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), (Object)Seq$.MODULE$.empty());
        }
        Seq<GetDataResponse> getDataResponses = seq;
        scala.collection.mutable.Map failedElections = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        Buffer validLeaderAndIsrs = (Buffer)Buffer$.MODULE$.empty();
        getDataResponses.foreach((Function1 & Serializable)getDataResponse -> {
            void apply_value;
            TopicPartition partition = (TopicPartition)getDataResponse.ctx().get();
            PartitionState currState = this.partitionState(partition);
            KeeperException.Code code = getDataResponse.resultCode();
            KeeperException.Code code2 = KeeperException.Code.OK;
            if (!(code != null ? !code.equals(code2) : code2 != null)) {
                Option option;
                Option<LeaderIsrAndControllerEpoch> option2 = TopicPartitionStateZNode$.MODULE$.decode(getDataResponse.data(), getDataResponse.stat());
                if (option2 instanceof Some) {
                    Growable growable;
                    LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)((Some)option2).value();
                    if (leaderIsrAndControllerEpoch.controllerEpoch() > $this.controllerContext.epoch()) {
                        void apply_value2;
                        String failMsg = new StringBuilder(0).append(new StringBuilder(71).append("Aborted leader election for partition ").append(partition).append(" since the LeaderAndIsr path was ").toString()).append(new StringBuilder(101).append("already written by another controller. This probably means that the current controller ").append(this.controllerId()).append(" went through ").toString()).append(new StringBuilder(62).append("a soft failure and another controller was elected with epoch ").append(leaderIsrAndControllerEpoch.controllerEpoch()).append(".").toString()).toString();
                        StateChangeFailedException stateChangeFailedException = new StateChangeFailedException(failMsg);
                        if (package$.MODULE$.Left() == null) {
                            throw null;
                        }
                        stateChangeFailedException = null;
                        growable = failedElections.put((Object)partition, (Object)new Left((Object)apply_value2));
                    } else {
                        void $plus$eq_elem;
                        Growable growable2;
                        Tuple2 tuple2;
                        LeaderAndIsr $minus$greater$extension_y = leaderIsrAndControllerEpoch.leaderAndIsr();
                        Tuple2 tuple22 = tuple2 = new Tuple2((Object)partition, (Object)$minus$greater$extension_y);
                        Object var14_11 = null;
                        tuple2 = null;
                        Tuple2 tuple23 = tuple22;
                        if (validLeaderAndIsrs == null) {
                            throw null;
                        }
                        growable = growable2 = validLeaderAndIsrs.addOne((Object)$plus$eq_elem);
                        tuple23 = null;
                        growable2 = null;
                    }
                    option = growable;
                } else if (None$.MODULE$.equals(option2)) {
                    StateChangeFailedException exception = new StateChangeFailedException(new StringBuilder(63).append("LeaderAndIsr information doesn't exist for partition ").append(partition).append(" in ").append(currState).append(" state").toString());
                    if (package$.MODULE$.Left() == null) {
                        throw null;
                    }
                    option = failedElections.put((Object)partition, (Object)new Left((Object)exception));
                } else {
                    throw new MatchError(option2);
                }
                return option;
            }
            KeeperException.Code code3 = getDataResponse.resultCode();
            KeeperException.Code code4 = KeeperException.Code.NONODE;
            if (!(code3 != null ? !code3.equals(code4) : code4 != null)) {
                StateChangeFailedException exception = new StateChangeFailedException(new StringBuilder(63).append("LeaderAndIsr information doesn't exist for partition ").append(partition).append(" in ").append(currState).append(" state").toString());
                if (package$.MODULE$.Left() == null) {
                    throw null;
                }
                return failedElections.put((Object)partition, (Object)new Left((Object)exception));
            }
            Object object = getDataResponse.resultException().get();
            if (package$.MODULE$.Left() == null) {
                throw null;
            }
            object = null;
            return failedElections.put((Object)partition, (Object)new Left((Object)apply_value));
        });
        if (validLeaderAndIsrs.isEmpty()) {
            return new Tuple2((Object)failedElections.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), (Object)Seq$.MODULE$.empty());
        }
        if (partitionLeaderElectionStrategy instanceof OfflinePartitionLeaderElectionStrategy) {
            boolean allowUnclean = ((OfflinePartitionLeaderElectionStrategy)partitionLeaderElectionStrategy).allowUnclean();
            Seq<Tuple3<TopicPartition, Option<LeaderAndIsr>, Object>> partitionsWithUncleanLeaderElectionState = this.collectUncleanLeaderElectionState((Seq<Tuple2<TopicPartition, LeaderAndIsr>>)validLeaderAndIsrs, allowUnclean);
            tuple2 = Election$.MODULE$.leaderForOffline(this.controllerContext, partitionsWithUncleanLeaderElectionState).partition((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)ZkPartitionStateMachine.$anonfun$doElectLeaderForPartitions$3(x$6)));
        } else if (ReassignPartitionLeaderElectionStrategy$.MODULE$.equals(partitionLeaderElectionStrategy)) {
            tuple2 = Election$.MODULE$.leaderForReassign(this.controllerContext, (Seq<Tuple2<TopicPartition, LeaderAndIsr>>)validLeaderAndIsrs).partition((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)ZkPartitionStateMachine.$anonfun$doElectLeaderForPartitions$4(x$7)));
        } else if (PreferredReplicaPartitionLeaderElectionStrategy$.MODULE$.equals(partitionLeaderElectionStrategy)) {
            tuple2 = Election$.MODULE$.leaderForPreferredReplica(this.controllerContext, (Seq<Tuple2<TopicPartition, LeaderAndIsr>>)validLeaderAndIsrs).partition((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)ZkPartitionStateMachine.$anonfun$doElectLeaderForPartitions$5(x$8)));
        } else if (ControlledShutdownPartitionLeaderElectionStrategy$.MODULE$.equals(partitionLeaderElectionStrategy)) {
            tuple2 = Election$.MODULE$.leaderForControlledShutdown(this.controllerContext, (Seq<Tuple2<TopicPartition, LeaderAndIsr>>)validLeaderAndIsrs).partition((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)ZkPartitionStateMachine.$anonfun$doElectLeaderForPartitions$6(x$9)));
        } else {
            throw new MatchError((Object)partitionLeaderElectionStrategy);
        }
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Seq seq2 = (Seq)tuple2._1();
        Seq seq3 = (Seq)tuple2._2();
        seq2.foreach((Function1 & Serializable)electionResult -> {
            void apply_value;
            TopicPartition partition = electionResult.topicPartition();
            String failMsg = new StringBuilder(53).append("Failed to elect leader for partition ").append(partition).append(" under strategy ").append(partitionLeaderElectionStrategy).toString();
            StateChangeFailedException stateChangeFailedException = new StateChangeFailedException(failMsg);
            if (package$.MODULE$.Left() == null) {
                throw null;
            }
            stateChangeFailedException = null;
            return failedElections.put((Object)partition, (Object)new Left((Object)apply_value));
        });
        scala.collection.immutable.Map recipientsPerPartition = ((IterableOnceOps)seq3.map((Function1 & Serializable)result -> {
            Seq<Object> $minus$greater$extension_y = result.liveReplicas();
            TopicPartition $minus$greater$extension_$this = result.topicPartition();
            return new Tuple2((Object)$minus$greater$extension_$this, $minus$greater$extension_y);
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        scala.collection.immutable.Map adjustedLeaderAndIsrs = ((IterableOnceOps)seq3.map((Function1 & Serializable)result -> {
            Object $minus$greater$extension_y = result.leaderAndIsr().get();
            TopicPartition $minus$greater$extension_$this = result.topicPartition();
            return new Tuple2((Object)$minus$greater$extension_$this, $minus$greater$extension_y);
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        KafkaZkClient.UpdateLeaderAndIsrResult updateLeaderAndIsrResult = this.zkClient.updateLeaderAndIsr((Map<TopicPartition, LeaderAndIsr>)adjustedLeaderAndIsrs, this.controllerContext.epoch(), this.controllerContext.epochZkVersion());
        if (updateLeaderAndIsrResult == null) {
            throw new MatchError(null);
        }
        Map<TopicPartition, Either<Exception, LeaderAndIsr>> map = updateLeaderAndIsrResult.finishedPartitions();
        Seq<TopicPartition> seq4 = updateLeaderAndIsrResult.partitionsToRetry();
        Function2 & Serializable forKeyValue$extension_f = (Function2 & Serializable)(partition, result) -> {
            ZkPartitionStateMachine.$anonfun$doElectLeaderForPartitions$10(this, recipientsPerPartition, partition, result);
            return BoxedUnit.UNIT;
        };
        map.foreachEntry((arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1(forKeyValue$extension_f, arg_0, arg_1));
        Object var17_17 = null;
        return new Tuple2((Object)map.$plus$plus((IterableOnce)failedElections), seq4);
    }

    /*
     * WARNING - void declaration
     */
    private Seq<Tuple3<TopicPartition, Option<LeaderAndIsr>, Object>> collectUncleanLeaderElectionState(Seq<Tuple2<TopicPartition, LeaderAndIsr>> leaderAndIsrs, boolean allowUnclean) {
        void $plus$plus_suffix;
        Seq seq;
        Tuple2 tuple2 = leaderAndIsrs.partition((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ZkPartitionStateMachine.$anonfun$collectUncleanLeaderElectionState$1(this, x0$1)));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Seq seq2 = (Seq)tuple2._1();
        Seq seq3 = (Seq)tuple2._2();
        if (allowUnclean) {
            seq = (Seq)seq2.map((Function1 & Serializable)x0$2 -> {
                if (x0$2 == null) {
                    throw new MatchError(null);
                }
                TopicPartition partition = (TopicPartition)x0$2._1();
                LeaderAndIsr leaderAndIsr = (LeaderAndIsr)x0$2._2();
                Tuple3 tuple3 = new Tuple3((Object)partition, (Object)Option$.MODULE$.apply((Object)leaderAndIsr), (Object)true);
                return tuple3;
            });
        } else {
            Tuple2<Map<String, LogConfig>, Map<String, Exception>> tuple22 = this.zkClient.getLogConfigs((Set<String>)seq2.iterator().map((Function1 & Serializable)x0$3 -> {
                if (x0$3 == null) {
                    throw new MatchError(null);
                }
                String string = ((TopicPartition)x0$3._1()).topic();
                return string;
            }).toSet(), this.config.originals());
            if (tuple22 == null) {
                throw new MatchError(null);
            }
            Map map = (Map)tuple22._1();
            Map map2 = (Map)tuple22._2();
            seq = (Seq)seq2.map((Function1 & Serializable)x0$4 -> {
                Tuple3 tuple3;
                if (x0$4 != null) {
                    TopicPartition partition = (TopicPartition)x0$4._1();
                    LeaderAndIsr leaderAndIsr = (LeaderAndIsr)x0$4._2();
                    if (map2.contains((Object)partition.topic())) {
                        this.logFailedStateChange(partition, this.partitionState(partition), (PartitionState)OnlinePartition$.MODULE$, (Throwable)map2.apply((Object)partition.topic()));
                        tuple3 = new Tuple3((Object)partition, (Object)None$.MODULE$, (Object)false);
                    } else {
                        tuple3 = new Tuple3((Object)partition, (Object)Option$.MODULE$.apply((Object)leaderAndIsr), (Object)((LogConfig)map.apply((Object)partition.topic())).uncleanLeaderElectionEnable());
                    }
                } else {
                    throw new MatchError(null);
                }
                Tuple3 tuple32 = tuple3;
                return tuple32;
            });
        }
        Seq electionForPartitionWithoutLiveReplicas = seq;
        IterableOnce iterableOnce = (IterableOnce)seq3.map((Function1 & Serializable)x0$5 -> {
            if (x0$5 == null) {
                throw new MatchError(null);
            }
            TopicPartition partition = (TopicPartition)x0$5._1();
            LeaderAndIsr leaderAndIsr = (LeaderAndIsr)x0$5._2();
            Tuple3 tuple3 = new Tuple3((Object)partition, (Object)Option$.MODULE$.apply((Object)leaderAndIsr), (Object)false);
            return tuple3;
        });
        if (electionForPartitionWithoutLiveReplicas == null) {
            throw null;
        }
        return (Seq)electionForPartitionWithoutLiveReplicas.appendedAll((IterableOnce)$plus$plus_suffix);
    }

    /*
     * WARNING - void declaration
     */
    private void logInvalidTransition(TopicPartition partition, PartitionState targetState) {
        void mkString_sep;
        PartitionState currState = this.partitionState(partition);
        Set<PartitionState> set = targetState.validPreviousStates();
        String string = ",";
        if (set == null) {
            throw null;
        }
        string = null;
        IllegalStateException e = new IllegalStateException(new StringBuilder(0).append(new StringBuilder(31).append("Partition ").append(partition).append(" should be in one of ").toString()).append(new StringBuilder(50).append(set.mkString("", (String)mkString_sep, "")).append(" states before moving to ").append(targetState).append(" state. Instead it is in ").toString()).append(new StringBuilder(6).append(currState).append(" state").toString()).toString());
        this.logFailedStateChange(partition, currState, targetState, e);
    }

    private void logFailedStateChange(TopicPartition partition, PartitionState currState, PartitionState targetState, KeeperException.Code code) {
        this.logFailedStateChange(partition, currState, targetState, (Throwable)KeeperException.create((KeeperException.Code)code));
    }

    private void logFailedStateChange(TopicPartition partition, PartitionState currState, PartitionState targetState, Throwable t) {
        this.stateChangeLogger.withControllerEpoch(this.controllerContext.epoch()).error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(57).append("Controller ").append(this.controllerId()).append(" epoch ").append($this.controllerContext.epoch()).append(" failed to change state for partition ").append(partition).append(" ").toString()).append(new StringBuilder(9).append("from ").append(currState).append(" to ").append(targetState).toString()).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> t);
    }

    public static final /* synthetic */ void $anonfun$doHandleStateChanges$3(ZkPartitionStateMachine $this, StateChangeLogger stateChangeLog$1, PartitionState targetState$2, TopicPartition partition) {
        stateChangeLog$1.info((Function0<String>)(Function0 & Serializable)() -> {
            void mkString_sep;
            Seq<Object> seq = $this.controllerContext.partitionReplicaAssignment(partition);
            String string = ",";
            if (seq == null) {
                throw null;
            }
            string = null;
            return new StringBuilder(0).append(new StringBuilder(40).append("Changed partition ").append(partition).append(" state from ").append($this.partitionState(partition)).append(" to ").append(targetState$2).append(" with ").toString()).append(new StringBuilder(18).append("assigned replicas ").append(seq.mkString("", (String)mkString_sep, "")).toString()).toString();
        });
        $this.controllerContext.putPartitionState(partition, NewPartition$.MODULE$);
    }

    public static final /* synthetic */ boolean $anonfun$doHandleStateChanges$5(ZkPartitionStateMachine $this, TopicPartition partition) {
        PartitionState partitionState = $this.partitionState(partition);
        NewPartition$ newPartition$ = NewPartition$.MODULE$;
        return partitionState != null && partitionState.equals(newPartition$);
    }

    public static final /* synthetic */ boolean $anonfun$doHandleStateChanges$6(ZkPartitionStateMachine $this, TopicPartition partition) {
        block3: {
            block2: {
                PartitionState partitionState = $this.partitionState(partition);
                OfflinePartition$ offlinePartition$ = OfflinePartition$.MODULE$;
                if (partitionState != null && partitionState.equals(offlinePartition$)) break block2;
                PartitionState partitionState2 = $this.partitionState(partition);
                OnlinePartition$ onlinePartition$ = OnlinePartition$.MODULE$;
                if (partitionState2 == null || !partitionState2.equals(onlinePartition$)) break block3;
            }
            return true;
        }
        return false;
    }

    public static final /* synthetic */ void $anonfun$doHandleStateChanges$7(ZkPartitionStateMachine $this, StateChangeLogger stateChangeLog$1, PartitionState targetState$2, TopicPartition partition) {
        stateChangeLog$1.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(40).append("Changed partition ").append(partition).append(" from ").append($this.partitionState(partition)).append(" to ").append(targetState$2).append(" with state ").toString()).append(String.valueOf(((LeaderIsrAndControllerEpoch)$this.controllerContext.partitionLeadershipInfo(partition).get()).leaderAndIsr())).toString());
        $this.controllerContext.putPartitionState(partition, OnlinePartition$.MODULE$);
    }

    public static final /* synthetic */ Nothing$ $anonfun$doHandleStateChanges$9() {
        throw new IllegalArgumentException("Election strategy is a required field when the target state is OnlinePartition");
    }

    public static final /* synthetic */ void $anonfun$doHandleStateChanges$10(ZkPartitionStateMachine $this, StateChangeLogger stateChangeLog$1, PartitionState targetState$2, Tuple2 x0$1) {
        if (x0$1 != null) {
            TopicPartition partition = (TopicPartition)x0$1._1();
            Either either = (Either)x0$1._2();
            if (either instanceof Right) {
                LeaderAndIsr leaderAndIsr = (LeaderAndIsr)((Right)either).value();
                stateChangeLog$1.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(40).append("Changed partition ").append(partition).append(" from ").append($this.partitionState(partition)).append(" to ").append(targetState$2).append(" with state ").append(leaderAndIsr).toString());
                $this.controllerContext.putPartitionState(partition, OnlinePartition$.MODULE$);
                return;
            }
        }
        if (x0$1 != null && (Either)x0$1._2() instanceof Left) {
            return;
        }
        throw new MatchError((Object)x0$1);
    }

    public static final /* synthetic */ void $anonfun$doHandleStateChanges$12(ZkPartitionStateMachine $this, boolean traceEnabled$1, StateChangeLogger stateChangeLog$1, PartitionState targetState$2, TopicPartition partition) {
        if (traceEnabled$1) {
            stateChangeLog$1.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(34).append("Changed partition ").append(partition).append(" state from ").append($this.partitionState(partition)).append(" to ").append(targetState$2).toString());
        }
        $this.controllerContext.putPartitionState(partition, OfflinePartition$.MODULE$);
    }

    public static final /* synthetic */ void $anonfun$doHandleStateChanges$14(ZkPartitionStateMachine $this, boolean traceEnabled$1, StateChangeLogger stateChangeLog$1, PartitionState targetState$2, TopicPartition partition) {
        if (traceEnabled$1) {
            stateChangeLog$1.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(34).append("Changed partition ").append(partition).append(" state from ").append($this.partitionState(partition)).append(" to ").append(targetState$2).toString());
        }
        $this.controllerContext.putPartitionState(partition, NonExistentPartition$.MODULE$);
    }

    public static final /* synthetic */ boolean $anonfun$initializeLeaderAndIsrForPartitions$4(Tuple2 x0$2) {
        if (x0$2 == null) {
            throw new MatchError(null);
        }
        boolean bl = ((Seq)x0$2._2()).isEmpty();
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$initializeLeaderAndIsrForPartitions$5(ZkPartitionStateMachine $this, Tuple2 x0$3) {
        if (x0$3 != null) {
            void mkString_sep;
            TopicPartition partition = (TopicPartition)x0$3._1();
            Seq replicas = (Seq)x0$3._2();
            String string = ",";
            if (replicas == null) {
                throw null;
            }
            string = null;
            String failMsg = new StringBuilder(17).append(new StringBuilder(60).append("Controller ").append($this.controllerId()).append(" epoch ").append($this.controllerContext.epoch()).append(" encountered error during state change of ").toString()).append(new StringBuilder(53).append("partition ").append(partition).append(" from New to Online, assigned replicas are ").toString()).append(new StringBuilder(37).append("[").append(replicas.mkString("", (String)mkString_sep, "")).append("], live brokers are [").append($this.controllerContext.liveBrokerIds()).append("]. No assigned ").toString()).append("replica is alive.").toString();
            $this.logFailedStateChange(partition, (PartitionState)NewPartition$.MODULE$, (PartitionState)OnlinePartition$.MODULE$, new StateChangeFailedException(failMsg));
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$initializeLeaderAndIsrForPartitions$9(ZkPartitionStateMachine $this, Exception e$4, Tuple2 x0$5) {
        if (x0$5 != null) {
            TopicPartition partition = (TopicPartition)x0$5._1();
            $this.logFailedStateChange(partition, $this.partitionState(partition), (PartitionState)NewPartition$.MODULE$, e$4);
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$electLeaderForPartitions$1(ZkPartitionStateMachine $this, Tuple2 x0$1) {
        if (x0$1 != null) {
            TopicPartition partition = (TopicPartition)x0$1._1();
            Either either = (Either)x0$1._2();
            if (either instanceof Left) {
                Exception e = (Exception)((Left)either).value();
                $this.logFailedStateChange(partition, $this.partitionState(partition), (PartitionState)OnlinePartition$.MODULE$, e);
                return;
            }
        }
        if (x0$1 != null && (Either)x0$1._2() instanceof Right) {
            return;
        }
        throw new MatchError((Object)x0$1);
    }

    public static final /* synthetic */ boolean $anonfun$doElectLeaderForPartitions$3(ElectionResult x$6) {
        return x$6.leaderAndIsr().isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$doElectLeaderForPartitions$4(ElectionResult x$7) {
        return x$7.leaderAndIsr().isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$doElectLeaderForPartitions$5(ElectionResult x$8) {
        return x$8.leaderAndIsr().isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$doElectLeaderForPartitions$6(ElectionResult x$9) {
        return x$9.leaderAndIsr().isEmpty();
    }

    public static final /* synthetic */ void $anonfun$doElectLeaderForPartitions$11(ZkPartitionStateMachine $this, TopicPartition partition$7, scala.collection.immutable.Map recipientsPerPartition$1, LeaderAndIsr leaderAndIsr) {
        ReplicaAssignment replicaAssignment = $this.controllerContext.partitionFullReplicaAssignment(partition$7);
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr, $this.controllerContext.epoch());
        $this.controllerContext.putPartitionLeadershipInfo(partition$7, leaderIsrAndControllerEpoch);
        $this.controllerBrokerRequestBatch.addLeaderAndIsrRequestForBrokers((Seq<Object>)((Seq)recipientsPerPartition$1.apply((Object)partition$7)), partition$7, leaderIsrAndControllerEpoch, replicaAssignment, false);
    }

    public static final /* synthetic */ void $anonfun$doElectLeaderForPartitions$10(ZkPartitionStateMachine $this, scala.collection.immutable.Map recipientsPerPartition$1, TopicPartition partition, Either result) {
        if (result == null) {
            throw null;
        }
        if (result instanceof Right) {
            LeaderAndIsr leaderAndIsr = (LeaderAndIsr)((Right)result).value();
            ZkPartitionStateMachine.$anonfun$doElectLeaderForPartitions$11($this, partition, recipientsPerPartition$1, leaderAndIsr);
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$collectUncleanLeaderElectionState$1(ZkPartitionStateMachine $this, Tuple2 x0$1) {
        Nil$ nil$;
        Object var11_10;
        Object var10_9;
        List list;
        Object var19_18;
        Object var18_17;
        Object var17_16;
        Object var16_15;
        Object var15_14;
        Object var14_13;
        Object var13_12;
        Object var12_11;
        Nil$ nil$2;
        if (x0$1 != null) {
            TopicPartition partition = (TopicPartition)x0$1._1();
            List list2 = ((LeaderAndIsr)x0$1._2()).isr();
            if (list2 == null) {
                throw null;
            }
            List filter_this = list2;
            boolean filter_filterCommon_isFlipped = false;
            List filter_filterCommon_noneIn$1_l = filter_this;
            while (true) {
                if (filter_filterCommon_noneIn$1_l.isEmpty()) {
                    nil$2 = Nil$.MODULE$;
                    break;
                }
                Object filter_filterCommon_noneIn$1_h = filter_filterCommon_noneIn$1_l.head();
                List filter_filterCommon_noneIn$1_t = (List)filter_filterCommon_noneIn$1_l.tail();
                int n = BoxesRunTime.unboxToInt((Object)filter_filterCommon_noneIn$1_h);
                if ($this.controllerContext.isReplicaOnline(n, partition, $this.controllerContext.isReplicaOnline$default$3()) != filter_filterCommon_isFlipped) {
                    List list3;
                    block13: {
                        List filter_filterCommon_noneIn$1_allIn$1_partialFill$1_next;
                        List filter_filterCommon_noneIn$1_allIn$1_remaining = filter_filterCommon_noneIn$1_t;
                        while (true) {
                            if (filter_filterCommon_noneIn$1_allIn$1_remaining.isEmpty()) {
                                list3 = filter_filterCommon_noneIn$1_l;
                                break block13;
                            }
                            Object filter_filterCommon_noneIn$1_allIn$1_x = filter_filterCommon_noneIn$1_allIn$1_remaining.head();
                            n = BoxesRunTime.unboxToInt((Object)filter_filterCommon_noneIn$1_allIn$1_x);
                            if ($this.controllerContext.isReplicaOnline(n, partition, $this.controllerContext.isReplicaOnline$default$3()) == filter_filterCommon_isFlipped) break;
                            filter_filterCommon_noneIn$1_allIn$1_remaining = (List)filter_filterCommon_noneIn$1_allIn$1_remaining.tail();
                        }
                        .colon.colon filter_filterCommon_noneIn$1_allIn$1_partialFill$1_newHead = new .colon.colon(filter_filterCommon_noneIn$1_l.head(), (List)Nil$.MODULE$);
                        .colon.colon filter_filterCommon_noneIn$1_allIn$1_partialFill$1_currentLast = filter_filterCommon_noneIn$1_allIn$1_partialFill$1_newHead;
                        for (List filter_filterCommon_noneIn$1_allIn$1_partialFill$1_toProcess = (List)filter_filterCommon_noneIn$1_l.tail(); filter_filterCommon_noneIn$1_allIn$1_partialFill$1_toProcess != filter_filterCommon_noneIn$1_allIn$1_remaining; filter_filterCommon_noneIn$1_allIn$1_partialFill$1_toProcess = (List)filter_filterCommon_noneIn$1_allIn$1_partialFill$1_toProcess.tail()) {
                            .colon.colon filter_filterCommon_noneIn$1_allIn$1_partialFill$1_newElem = new .colon.colon(filter_filterCommon_noneIn$1_allIn$1_partialFill$1_toProcess.head(), (List)Nil$.MODULE$);
                            filter_filterCommon_noneIn$1_allIn$1_partialFill$1_currentLast.next_$eq((List)filter_filterCommon_noneIn$1_allIn$1_partialFill$1_newElem);
                            filter_filterCommon_noneIn$1_allIn$1_partialFill$1_currentLast = filter_filterCommon_noneIn$1_allIn$1_partialFill$1_newElem;
                        }
                        List filter_filterCommon_noneIn$1_allIn$1_partialFill$1_nextToCopy = filter_filterCommon_noneIn$1_allIn$1_partialFill$1_next = (List)filter_filterCommon_noneIn$1_allIn$1_remaining.tail();
                        while (!filter_filterCommon_noneIn$1_allIn$1_partialFill$1_next.isEmpty()) {
                            Object filter_filterCommon_noneIn$1_allIn$1_partialFill$1_head = filter_filterCommon_noneIn$1_allIn$1_partialFill$1_next.head();
                            n = BoxesRunTime.unboxToInt((Object)filter_filterCommon_noneIn$1_allIn$1_partialFill$1_head);
                            if ($this.controllerContext.isReplicaOnline(n, partition, $this.controllerContext.isReplicaOnline$default$3()) != filter_filterCommon_isFlipped) {
                                filter_filterCommon_noneIn$1_allIn$1_partialFill$1_next = (List)filter_filterCommon_noneIn$1_allIn$1_partialFill$1_next.tail();
                                continue;
                            }
                            while (filter_filterCommon_noneIn$1_allIn$1_partialFill$1_nextToCopy != filter_filterCommon_noneIn$1_allIn$1_partialFill$1_next) {
                                .colon.colon filter_filterCommon_noneIn$1_allIn$1_partialFill$1_newElem = new .colon.colon(filter_filterCommon_noneIn$1_allIn$1_partialFill$1_nextToCopy.head(), (List)Nil$.MODULE$);
                                filter_filterCommon_noneIn$1_allIn$1_partialFill$1_currentLast.next_$eq((List)filter_filterCommon_noneIn$1_allIn$1_partialFill$1_newElem);
                                filter_filterCommon_noneIn$1_allIn$1_partialFill$1_currentLast = filter_filterCommon_noneIn$1_allIn$1_partialFill$1_newElem;
                                filter_filterCommon_noneIn$1_allIn$1_partialFill$1_nextToCopy = (List)filter_filterCommon_noneIn$1_allIn$1_partialFill$1_nextToCopy.tail();
                            }
                            filter_filterCommon_noneIn$1_allIn$1_partialFill$1_nextToCopy = (List)filter_filterCommon_noneIn$1_allIn$1_partialFill$1_next.tail();
                            filter_filterCommon_noneIn$1_allIn$1_partialFill$1_next = (List)filter_filterCommon_noneIn$1_allIn$1_partialFill$1_next.tail();
                        }
                        if (!filter_filterCommon_noneIn$1_allIn$1_partialFill$1_nextToCopy.isEmpty()) {
                            filter_filterCommon_noneIn$1_allIn$1_partialFill$1_currentLast.next_$eq(filter_filterCommon_noneIn$1_allIn$1_partialFill$1_nextToCopy);
                        }
                        list3 = var12_11;
                        var12_11 = null;
                        var13_12 = null;
                        var14_13 = null;
                        var15_14 = null;
                        var16_15 = null;
                        var17_16 = null;
                        var18_17 = null;
                        var19_18 = null;
                    }
                    list = list3;
                    nil$2 = list;
                    var10_9 = null;
                    var11_10 = null;
                    var12_11 = null;
                    var13_12 = null;
                    var14_13 = null;
                    var15_14 = null;
                    var16_15 = null;
                    var17_16 = null;
                    var18_17 = null;
                    var19_18 = null;
                    list = null;
                    break;
                }
                filter_filterCommon_noneIn$1_l = filter_filterCommon_noneIn$1_t;
            }
        } else {
            throw new MatchError(null);
        }
        Nil$ nil$3 = nil$ = nil$2;
        Object var7_5 = null;
        Object var8_7 = null;
        Object var9_8 = null;
        var10_9 = null;
        var11_10 = null;
        var12_11 = null;
        var13_12 = null;
        var14_13 = null;
        var15_14 = null;
        var16_15 = null;
        var17_16 = null;
        var18_17 = null;
        var19_18 = null;
        list = null;
        nil$ = null;
        Nil$ nil$4 = nil$3;
        Statics.releaseFence();
        Nil$ nil$5 = nil$4;
        Object var4_3 = null;
        nil$4 = null;
        boolean bl = nil$5.isEmpty();
        return bl;
    }

    public ZkPartitionStateMachine(KafkaConfig config, StateChangeLogger stateChangeLogger, ControllerContext controllerContext, KafkaZkClient zkClient, ControllerBrokerRequestBatch controllerBrokerRequestBatch) {
        this.config = config;
        this.stateChangeLogger = stateChangeLogger;
        this.controllerContext = controllerContext;
        this.zkClient = zkClient;
        this.controllerBrokerRequestBatch = controllerBrokerRequestBatch;
        super(controllerContext);
        this.controllerId = config.brokerId();
        this.logIdent_$eq(new StringBuilder(38).append("[PartitionStateMachine controllerId=").append(this.controllerId()).append("] ").toString());
    }

    public static final /* synthetic */ Object $anonfun$doElectLeaderForPartitions$11$adapted(ZkPartitionStateMachine $this, TopicPartition partition$7, scala.collection.immutable.Map recipientsPerPartition$1, LeaderAndIsr leaderAndIsr) {
        ZkPartitionStateMachine.$anonfun$doElectLeaderForPartitions$11($this, partition$7, recipientsPerPartition$1, leaderAndIsr);
        return BoxedUnit.UNIT;
    }
}

