/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.nio.ByteBuffer;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata;
import kafka.coordinator.transaction.Dead$;
import kafka.coordinator.transaction.Ongoing$;
import kafka.coordinator.transaction.PrepareAbort$;
import kafka.coordinator.transaction.PrepareCommit$;
import kafka.coordinator.transaction.TransactionConfig;
import kafka.coordinator.transaction.TransactionLog$;
import kafka.coordinator.transaction.TransactionMetadata;
import kafka.coordinator.transaction.TransactionPartitionAndLeaderEpoch;
import kafka.coordinator.transaction.TransactionState;
import kafka.coordinator.transaction.TransactionStateManager$;
import kafka.coordinator.transaction.TransactionalIdAndProducerIdEpoch;
import kafka.coordinator.transaction.TransactionalIdCoordinatorEpochAndMetadata;
import kafka.coordinator.transaction.TransactionalIdCoordinatorEpochAndTransitMetadata;
import kafka.coordinator.transaction.TxnMetadataCacheEntry;
import kafka.coordinator.transaction.TxnTransitMetadata;
import kafka.log.AppendOrigin$Coordinator$;
import kafka.log.Log;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.message.UncompressedCodec$;
import kafka.server.FetchDataInfo;
import kafka.server.FetchLogEnd$;
import kafka.server.ReplicaManager;
import kafka.utils.Logging;
import kafka.utils.Pool;
import kafka.utils.Scheduler;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Avg;
import org.apache.kafka.common.metrics.stats.Max;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.MutableRecordBatch;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.requests.TransactionResult;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import scala.Function0;
import scala.Function1;
import scala.Function4;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.MapFactory;
import scala.collection.StringOps$;
import scala.collection.convert.AsScalaExtensions;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Right$;

@ScalaSignature(bytes="\u0006\u0005\r]r!B\u001f?\u0011\u0003)e!B$?\u0011\u0003A\u0005\"B(\u0002\t\u0003\u0001\u0006bB)\u0002\u0005\u0004%\tA\u0015\u0005\u0007-\u0006\u0001\u000b\u0011B*\t\u000f]\u000b!\u0019!C\u0001%\"1\u0001,\u0001Q\u0001\nMCq!W\u0001C\u0002\u0013\u0005!\u000b\u0003\u0004[\u0003\u0001\u0006Ia\u0015\u0005\b7\u0006\u0011\r\u0011\"\u0001S\u0011\u0019a\u0016\u0001)A\u0005'\"9Q,\u0001b\u0001\n\u0003q\u0006B\u00026\u0002A\u0003%q\fC\u0004l\u0003\t\u0007I\u0011\u00010\t\r1\f\u0001\u0015!\u0003`\r\u00119e\bA7\t\u0011Q|!\u0011!Q\u0001\nMC\u0001\"^\b\u0003\u0002\u0003\u0006IA\u001e\u0005\ty>\u0011\t\u0011)A\u0005{\"Q\u0011\u0011A\b\u0003\u0002\u0003\u0006I!a\u0001\t\u0015\u0005=qB!A!\u0002\u0013\t\t\u0002\u0003\u0006\u0002\u0018=\u0011\t\u0011)A\u0005\u00033A!\"!\r\u0010\u0005\u0003\u0005\u000b\u0011BA\u001a\u0011\u0019yu\u0002\"\u0001\u0002>\u00151\u0011qJ\b\u0001\u0003#B\u0011\"!\u001e\u0010\u0005\u0004%I!a\u001e\t\u0011\u0005Eu\u0002)A\u0005\u0003sB\u0011\"a%\u0010\u0005\u0004%I!!&\t\u0011\u0005\rv\u0002)A\u0005\u0003/C!\"!*\u0010\u0005\u0004%\tAPAT\u0011!\tyl\u0004Q\u0001\n\u0005%\u0006BCAa\u001f\t\u0007I\u0011\u0001 \u0002D\"A\u0011\u0011[\b!\u0002\u0013\t)\r\u0003\u0005\u0002T>\u0011\r\u0011\"\u0003S\u0011\u001d\t)n\u0004Q\u0001\nMC\u0011\"a6\u0010\u0005\u0004%I!!7\t\u0011\u0005\u0005x\u0002)A\u0005\u00037D\u0001\"a9\u0010\t\u0003q\u0014Q\u001d\u0005\b\u0003_|A\u0011AAy\u0011\u001d\u0011Ya\u0004C\u0005\u0005\u001bAqAa\b\u0010\t\u0013\u0011\t\u0003C\u0004\u00038=!IA!\u000f\t\u0011\t-q\u0002\"\u0001?\u0005\u001fBqA!\u0015\u0010\t\u0013\u0011\u0019\u0006C\u0004\u0003n=!\tAa\u0014\t\u000f\t=t\u0002\"\u0001\u0003r!9!QS\b\u0005\u0002\t]\u0005b\u0002BO\u001f\u0011%!q\u0014\u0005\b\u0005S{A\u0011\u0001BV\u0011\u001d\u0011\tl\u0004C\u0001\u0005gCqA!0\u0010\t\u0003\u0011y\f\u0003\u0004\u0003D>!IA\u0015\u0005\b\u0005\u000b|A\u0011\u0002Bd\u0011!\u0011)n\u0004C\u0001}\t]\u0007b\u0002Br\u001f\u0011\u0005!Q\u001d\u0005\b\u0005g|A\u0011\u0001B{\u0011\u001d\u0011\u0019p\u0004C\u0001\u0005sDqAa@\u0010\t\u0013\u0011y\u0005C\u0004\u0004\u0002=!\taa\u0001\t\u0013\ruq\"%A\u0005\u0002\r}\u0001bBB\u001b\u001f\u0011\u0005!qJ\u0001\u0018)J\fgn]1di&|gn\u0015;bi\u0016l\u0015M\\1hKJT!a\u0010!\u0002\u0017Q\u0014\u0018M\\:bGRLwN\u001c\u0006\u0003\u0003\n\u000b1bY8pe\u0012Lg.\u0019;pe*\t1)A\u0003lC\u001a\\\u0017m\u0001\u0001\u0011\u0005\u0019\u000bQ\"\u0001 \u0003/Q\u0013\u0018M\\:bGRLwN\\*uCR,W*\u00198bO\u0016\u00148CA\u0001J!\tQU*D\u0001L\u0015\u0005a\u0015!B:dC2\f\u0017B\u0001(L\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012!R\u0001 \t\u00164\u0017-\u001e7u)J\fgn]1di&|gn]'bqRKW.Z8vi6\u001bX#A*\u0011\u0005)#\u0016BA+L\u0005\rIe\u000e^\u0001!\t\u00164\u0017-\u001e7u)J\fgn]1di&|gn]'bqRKW.Z8vi6\u001b\b%\u0001\u0012EK\u001a\fW\u000f\u001c;Ue\u0006t7/Y2uS>t\u0017\r\\%e\u000bb\u0004\u0018N]1uS>tWj]\u0001$\t\u00164\u0017-\u001e7u)J\fgn]1di&|g.\u00197JI\u0016C\b/\u001b:bi&|g.T:!\u0003)\"UMZ1vYR\f%m\u001c:u)&lW\rZ(viR\u0013\u0018M\\:bGRLwN\\:J]R,'O^1m\u001bN\f1\u0006R3gCVdG/\u00112peR$\u0016.\\3e\u001fV$HK]1og\u0006\u001cG/[8og&sG/\u001a:wC2l5\u000fI\u0001/\t\u00164\u0017-\u001e7u%\u0016lwN^3FqBL'/\u001a3Ue\u0006t7/Y2uS>t\u0017\r\\%eg&sG/\u001a:wC2l5/A\u0018EK\u001a\fW\u000f\u001c;SK6|g/Z#ya&\u0014X\r\u001a+sC:\u001c\u0018m\u0019;j_:\fG.\u00133t\u0013:$XM\u001d<bY6\u001b\b%\u0001\u0007NKR\u0014\u0018nY:He>,\b/F\u0001`!\t\u0001wM\u0004\u0002bKB\u0011!mS\u0007\u0002G*\u0011A\rR\u0001\u0007yI|w\u000e\u001e \n\u0005\u0019\\\u0015A\u0002)sK\u0012,g-\u0003\u0002iS\n11\u000b\u001e:j]\u001eT!AZ&\u0002\u001b5+GO]5dg\u001e\u0013x.\u001e9!\u00039au.\u00193US6,7+\u001a8t_J\fq\u0002T8bIRKW.Z*f]N|'\u000fI\n\u0004\u001f%s\u0007CA8s\u001b\u0005\u0001(BA9C\u0003\u0015)H/\u001b7t\u0013\t\u0019\bOA\u0004M_\u001e<\u0017N\\4\u0002\u0011\t\u0014xn[3s\u0013\u0012\f\u0001B_6DY&,g\u000e\u001e\t\u0003ojl\u0011\u0001\u001f\u0006\u0003s\n\u000b!A_6\n\u0005mD(!D&bM.\f'l[\"mS\u0016tG/A\u0005tG\",G-\u001e7feB\u0011qN`\u0005\u0003\u007fB\u0014\u0011bU2iK\u0012,H.\u001a:\u0002\u001dI,\u0007\u000f\\5dC6\u000bg.Y4feB!\u0011QAA\u0006\u001b\t\t9AC\u0002\u0002\n\t\u000baa]3sm\u0016\u0014\u0018\u0002BA\u0007\u0003\u000f\u0011aBU3qY&\u001c\u0017-T1oC\u001e,'/\u0001\u0004d_:4\u0017n\u001a\t\u0004\r\u0006M\u0011bAA\u000b}\t\tBK]1og\u0006\u001cG/[8o\u0007>tg-[4\u0002\tQLW.\u001a\t\u0005\u00037\ti#\u0004\u0002\u0002\u001e)\u0019\u0011/a\b\u000b\t\u0005\u0005\u00121E\u0001\u0007G>lWn\u001c8\u000b\u0007\r\u000b)C\u0003\u0003\u0002(\u0005%\u0012AB1qC\u000eDWM\u0003\u0002\u0002,\u0005\u0019qN]4\n\t\u0005=\u0012Q\u0004\u0002\u0005)&lW-A\u0004nKR\u0014\u0018nY:\u0011\t\u0005U\u0012\u0011H\u0007\u0003\u0003oQA!!\r\u0002 %!\u00111HA\u001c\u0005\u001diU\r\u001e:jGN$\u0002#a\u0010\u0002B\u0005\r\u0013QIA$\u0003\u0013\nY%!\u0014\u0011\u0005\u0019{\u0001\"\u0002;\u0018\u0001\u0004\u0019\u0006\"B;\u0018\u0001\u00041\b\"\u0002?\u0018\u0001\u0004i\bbBA\u0001/\u0001\u0007\u00111\u0001\u0005\b\u0003\u001f9\u0002\u0019AA\t\u0011\u001d\t9b\u0006a\u0001\u00033Aq!!\r\u0018\u0001\u0004\t\u0019D\u0001\fTK:$G\u000b\u001f8NCJ\\WM]:DC2d'-Y2l!1Q\u00151K*\u0002X\u0005\r\u0014\u0011NA8\u0013\r\t)f\u0013\u0002\n\rVt7\r^5p]R\u0002B!!\u0017\u0002`5\u0011\u00111\f\u0006\u0005\u0003;\ny\"\u0001\u0005sKF,Xm\u001d;t\u0013\u0011\t\t'a\u0017\u0003#Q\u0013\u0018M\\:bGRLwN\u001c*fgVdG\u000fE\u0002G\u0003KJ1!a\u001a?\u0005M!&/\u00198tC\u000e$\u0018n\u001c8NKR\fG-\u0019;b!\r1\u00151N\u0005\u0004\u0003[r$A\u0005+y]R\u0013\u0018M\\:ji6+G/\u00193bi\u0006\u00042ASA9\u0013\r\t\u0019h\u0013\u0002\u0005+:LG/\u0001\u0007tQV$H/\u001b8h\t><h.\u0006\u0002\u0002zA!\u00111PAG\u001b\t\tiH\u0003\u0003\u0002\u0000\u0005\u0005\u0015AB1u_6L7M\u0003\u0003\u0002\u0004\u0006\u0015\u0015AC2p]\u000e,(O]3oi*!\u0011qQAE\u0003\u0011)H/\u001b7\u000b\u0005\u0005-\u0015\u0001\u00026bm\u0006LA!a$\u0002~\ti\u0011\t^8nS\u000e\u0014un\u001c7fC:\fQb\u001d5viRLgn\u001a#po:\u0004\u0013!C:uCR,Gj\\2l+\t\t9\n\u0005\u0003\u0002\u001a\u0006}UBAAN\u0015\u0011\ti*!!\u0002\u000b1|7m[:\n\t\u0005\u0005\u00161\u0014\u0002\u0017%\u0016,g\u000e\u001e:b]R\u0014V-\u00193Xe&$X\rT8dW\u0006Q1\u000f^1uK2{7m\u001b\u0011\u0002#1|\u0017\rZ5oOB\u000b'\u000f^5uS>t7/\u0006\u0002\u0002*B1\u00111VA[\u0003sk!!!,\u000b\t\u0005=\u0016\u0011W\u0001\b[V$\u0018M\u00197f\u0015\r\t\u0019lS\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA\\\u0003[\u00131aU3u!\r1\u00151X\u0005\u0004\u0003{s$A\t+sC:\u001c\u0018m\u0019;j_:\u0004\u0016M\u001d;ji&|g.\u00118e\u0019\u0016\fG-\u001a:Fa>\u001c\u0007.\u0001\nm_\u0006$\u0017N\\4QCJ$\u0018\u000e^5p]N\u0004\u0013\u0001\u0007;sC:\u001c\u0018m\u0019;j_:lU\r^1eCR\f7)Y2iKV\u0011\u0011Q\u0019\t\b\u0003W\u000b9mUAf\u0013\u0011\tI-!,\u0003\u00075\u000b\u0007\u000fE\u0002G\u0003\u001bL1!a4?\u0005U!\u0006P\\'fi\u0006$\u0017\r^1DC\u000eDW-\u00128uef\f\u0011\u0004\u001e:b]N\f7\r^5p]6+G/\u00193bi\u0006\u001c\u0015m\u00195fA\u0005qBO]1og\u0006\u001cG/[8o)>\u0004\u0018n\u0019)beRLG/[8o\u0007>,h\u000e^\u0001 iJ\fgn]1di&|g\u000eV8qS\u000e\u0004\u0016M\u001d;ji&|gnQ8v]R\u0004\u0013a\u00059beRLG/[8o\u0019>\fGmU3og>\u0014XCAAn!\u0011\t)$!8\n\t\u0005}\u0017q\u0007\u0002\u0007'\u0016t7o\u001c:\u0002)A\f'\u000f^5uS>tGj\\1e'\u0016t7o\u001c:!\u0003M\tG\r\u001a'pC\u0012Lgn\u001a)beRLG/[8o)\u0019\ty'a:\u0002l\"1\u0011\u0011^\u0013A\u0002M\u000b1\u0002]1si&$\u0018n\u001c8JI\"1\u0011Q^\u0013A\u0002M\u000b\u0001cY8pe\u0012Lg.\u0019;pe\u0016\u0003xn\u00195\u0002)QLW.\u001a3PkR$&/\u00198tC\u000e$\u0018n\u001c8t)\t\t\u0019\u0010\u0005\u0004\u0002v\u0006}(Q\u0001\b\u0005\u0003o\fYPD\u0002c\u0003sL\u0011\u0001T\u0005\u0004\u0003{\\\u0015a\u00029bG.\fw-Z\u0005\u0005\u0005\u0003\u0011\u0019A\u0001\u0005Ji\u0016\u0014\u0018M\u00197f\u0015\r\tip\u0013\t\u0004\r\n\u001d\u0011b\u0001B\u0005}\t\tCK]1og\u0006\u001cG/[8oC2LE-\u00118e!J|G-^2fe&#W\t]8dQ\u0006i\"/Z7pm\u0016,\u0005\u0010]5sK\u0012$&/\u00198tC\u000e$\u0018n\u001c8bY&#7\u000f\u0006\u0004\u0002p\t=!1\u0004\u0005\b\u0005#9\u0003\u0019\u0001B\n\u0003Q!(/\u00198tC\u000e$\u0018n\u001c8QCJ$\u0018\u000e^5p]B!!Q\u0003B\f\u001b\t\ty\"\u0003\u0003\u0003\u001a\u0005}!A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0005\b\u0005;9\u0003\u0019AAf\u0003U!\bP\\'fi\u0006$\u0017\r^1DC\u000eDW-\u00128uef\fAb\u001d5pk2$W\t\u001f9je\u0016$bAa\t\u0003*\t5\u0002c\u0001&\u0003&%\u0019!qE&\u0003\u000f\t{w\u000e\\3b]\"9!1\u0006\u0015A\u0002\u0005\r\u0014a\u0003;y]6+G/\u00193bi\u0006DqAa\f)\u0001\u0004\u0011\t$A\u0007dkJ\u0014XM\u001c;US6,Wj\u001d\t\u0004\u0015\nM\u0012b\u0001B\u001b\u0017\n!Aj\u001c8h\u0003Ui\u0017-\u001f2f\u0003B\u0004XM\u001c3FqBL'/\u0019;j_:$\u0002Ba\t\u0003<\tu\"Q\n\u0005\b\u0005WI\u0003\u0019AA2\u0011\u001d\u0011y$\u000ba\u0001\u0005\u0003\naB]3d_J$7OQ;jY\u0012,'\u000f\u0005\u0003\u0003D\t%SB\u0001B#\u0015\u0011\u00119%a\b\u0002\rI,7m\u001c:e\u0013\u0011\u0011YE!\u0012\u0003)5+Wn\u001c:z%\u0016\u001cwN\u001d3t\u0005VLG\u000eZ3s\u0011\u001d\u0011y#\u000ba\u0001\u0005c!\"!a\u001c\u0002S]\u0014\u0018\u000e^3U_6\u00147\u000f^8oKN4uN]#ya&\u0014X\r\u001a+sC:\u001c\u0018m\u0019;j_:\fG.\u00133t)!\tyG!\u0016\u0003X\t\r\u0004b\u0002B\tW\u0001\u0007!1\u0003\u0005\b\u00053Z\u0003\u0019\u0001B.\u0003M)\u0007\u0010]5sK\u00124uN\u001d)beRLG/[8o!\u0019\t)0a@\u0003^A\u0019aIa\u0018\n\u0007\t\u0005dH\u0001\u0016Ue\u0006t7/Y2uS>t\u0017\r\\%e\u0007>|'\u000fZ5oCR|'/\u00129pG\"\fe\u000eZ'fi\u0006$\u0017\r^1\t\u000f\t\u00154\u00061\u0001\u0003h\u0005\u0001Bo\\7cgR|g.\u001a*fG>\u0014Hm\u001d\t\u0005\u0005\u0007\u0012I'\u0003\u0003\u0003l\t\u0015#!D'f[>\u0014\u0018PU3d_J$7/A\u0010f]\u0006\u0014G.\u001a+sC:\u001c\u0018m\u0019;j_:\fG.\u00133FqBL'/\u0019;j_:\f1cZ3u)J\fgn]1di&|gn\u0015;bi\u0016$BAa\u001d\u0003\u0012BA\u0011Q\u001fB;\u0005s\u0012))\u0003\u0003\u0003x\t\r!AB#ji\",'\u000f\u0005\u0003\u0003|\t\u0005UB\u0001B?\u0015\u0011\u0011y(a\b\u0002\u0011A\u0014x\u000e^8d_2LAAa!\u0003~\t1QI\u001d:peN\u0004RA\u0013BD\u0005\u0017K1A!#L\u0005\u0019y\u0005\u000f^5p]B\u0019aI!$\n\u0007\t=eH\u0001\u0010D_>\u0014H-\u001b8bi>\u0014X\t]8dQ\u0006sG\r\u0016=o\u001b\u0016$\u0018\rZ1uC\"1!1S\u0017A\u0002}\u000bq\u0002\u001e:b]N\f7\r^5p]\u0006d\u0017\nZ\u0001\u001faV$HK]1og\u0006\u001cG/[8o'R\fG/Z%g\u001d>$X\t_5tiN$BA!'\u0003\u001cBA\u0011Q\u001fB;\u0005s\u0012Y\tC\u0004\u0003,9\u0002\r!a\u0019\u0002=\u001d,G/\u00118e\u001b\u0006L(-Z!eIR\u0013\u0018M\\:bGRLwN\\*uCR,GC\u0002B:\u0005C\u0013\u0019\u000b\u0003\u0004\u0003\u0014>\u0002\ra\u0018\u0005\b\u0005K{\u0003\u0019\u0001BT\u0003U\u0019'/Z1uK\u0012$\u0006P\\'fi\u0006$\u0017\r^1PaR\u0004RA\u0013BD\u0003G\nAD^1mS\u0012\fG/\u001a+sC:\u001c\u0018m\u0019;j_:$\u0016.\\3pkRl5\u000f\u0006\u0003\u0003$\t5\u0006B\u0002BXa\u0001\u00071+\u0001\u0007uq:$\u0016.\\3pkRl5/A\fue\u0006t7/Y2uS>tGk\u001c9jG\u000e{gNZ5hgV\u0011!Q\u0017\t\u0005\u0005o\u0013I,\u0004\u0002\u0002\u0006&!!1XAC\u0005)\u0001&o\u001c9feRLWm]\u0001\ra\u0006\u0014H/\u001b;j_:4uN\u001d\u000b\u0004'\n\u0005\u0007B\u0002BJe\u0001\u0007q,A\u0011hKR$&/\u00198tC\u000e$\u0018n\u001c8U_BL7\rU1si&$\u0018n\u001c8D_VtG/A\fm_\u0006$GK]1og\u0006\u001cG/[8o\u001b\u0016$\u0018\rZ1uCR1!\u0011\u001aBh\u0005'\u0004ba\u001cBf?\u0006\r\u0014b\u0001Bga\n!\u0001k\\8m\u0011\u001d\u0011\t\u000e\u000ea\u0001\u0005'\ta\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0003\u0004\u0002nR\u0002\raU\u0001\u001dC\u0012$Gj\\1eK\u0012$&/\u00198tC\u000e$\u0018n\u001c8t)>\u001c\u0015m\u00195f)!\tyG!7\u0003^\n}\u0007B\u0002Bnk\u0001\u00071+A\tuq:$v\u000e]5d!\u0006\u0014H/\u001b;j_:Da!!<6\u0001\u0004\u0019\u0006b\u0002Bqk\u0001\u0007!\u0011Z\u0001\u0013Y>\fG-\u001a3Ue\u0006t7/Y2uS>t7/\u0001\u0013m_\u0006$GK]1og\u0006\u001cG/[8og\u001a{'\u000f\u0016=o)>\u0004\u0018n\u0019)beRLG/[8o)!\tyGa:\u0003j\n-\bBBAum\u0001\u00071\u000b\u0003\u0004\u0002nZ\u0002\ra\u0015\u0005\b\u0005[4\u0004\u0019\u0001Bx\u00039\u0019XM\u001c3Uq:l\u0015M]6feN\u00042A!=\u0019\u001b\u0005y\u0011A\n:f[>4X\r\u0016:b]N\f7\r^5p]N4uN\u001d+y]R{\u0007/[2QCJ$\u0018\u000e^5p]R!\u0011q\u000eB|\u0011\u0019\tIo\u000ea\u0001'R1\u0011q\u000eB~\u0005{Da!!;9\u0001\u0004\u0019\u0006BBAwq\u0001\u00071+\u0001\u0018wC2LG-\u0019;f)J\fgn]1di&|g\u000eV8qS\u000e\u0004\u0016M\u001d;ji&|gnQ8v]RL5o\u0015;bE2,\u0017AF1qa\u0016tG\r\u0016:b]N\f7\r^5p]R{Gj\\4\u0015\u0019\u0005=4QAB\u0004\u0007\u0013\u0019iaa\u0006\t\r\tM%\b1\u0001`\u0011\u0019\tiO\u000fa\u0001'\"911\u0002\u001eA\u0002\u0005%\u0014a\u00038fo6+G/\u00193bi\u0006Dqaa\u0004;\u0001\u0004\u0019\t\"\u0001\tsKN\u0004xN\\:f\u0007\u0006dGNY1dWB9!ja\u0005\u0003z\u0005=\u0014bAB\u000b\u0017\nIa)\u001e8di&|g.\r\u0005\n\u00073Q\u0004\u0013!a\u0001\u00077\tAB]3uef|e.\u0012:s_J\u0004rASB\n\u0005s\u0012\u0019#\u0001\u0011baB,g\u000e\u001a+sC:\u001c\u0018m\u0019;j_:$v\u000eT8hI\u0011,g-Y;mi\u0012*TCAB\u0011U\u0011\u0019Yba\t,\u0005\r\u0015\u0002\u0003BB\u0014\u0007ci!a!\u000b\u000b\t\r-2QF\u0001\nk:\u001c\u0007.Z2lK\u0012T1aa\fL\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0007g\u0019ICA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f\u0001b\u001d5vi\u0012|wO\u001c")
public class TransactionStateManager
implements Logging {
    private final KafkaZkClient zkClient;
    private final Scheduler scheduler;
    private final ReplicaManager replicaManager;
    private final TransactionConfig config;
    private final Time time;
    private final AtomicBoolean shuttingDown;
    private final ReentrantReadWriteLock stateLock;
    private final Set<TransactionPartitionAndLeaderEpoch> loadingPartitions;
    private final scala.collection.mutable.Map<Object, TxnMetadataCacheEntry> transactionMetadataCache;
    private final int transactionTopicPartitionCount;
    private final Sensor partitionLoadSensor;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static String LoadTimeSensor() {
        return TransactionStateManager$.MODULE$.LoadTimeSensor();
    }

    public static String MetricsGroup() {
        return TransactionStateManager$.MODULE$.MetricsGroup();
    }

    public static int DefaultRemoveExpiredTransactionalIdsIntervalMs() {
        return TransactionStateManager$.MODULE$.DefaultRemoveExpiredTransactionalIdsIntervalMs();
    }

    public static int DefaultAbortTimedOutTransactionsIntervalMs() {
        return TransactionStateManager$.MODULE$.DefaultAbortTimedOutTransactionsIntervalMs();
    }

    public static int DefaultTransactionalIdExpirationMs() {
        return TransactionStateManager$.MODULE$.DefaultTransactionalIdExpirationMs();
    }

    public static int DefaultTransactionsMaxTimeoutMs() {
        return TransactionStateManager$.MODULE$.DefaultTransactionsMaxTimeoutMs();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private AtomicBoolean shuttingDown() {
        return this.shuttingDown;
    }

    private ReentrantReadWriteLock stateLock() {
        return this.stateLock;
    }

    public Set<TransactionPartitionAndLeaderEpoch> loadingPartitions() {
        return this.loadingPartitions;
    }

    public scala.collection.mutable.Map<Object, TxnMetadataCacheEntry> transactionMetadataCache() {
        return this.transactionMetadataCache;
    }

    private int transactionTopicPartitionCount() {
        return this.transactionTopicPartitionCount;
    }

    private Sensor partitionLoadSensor() {
        return this.partitionLoadSensor;
    }

    public void addLoadingPartition(int partitionId, int coordinatorEpoch) {
        TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch = new TransactionPartitionAndLeaderEpoch(partitionId, coordinatorEpoch);
        Lock inWriteLock_inLock_lock = this.stateLock().writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            TransactionStateManager.$anonfun$addLoadingPartition$1(this, partitionAndLeaderEpoch);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    public Iterable<TransactionalIdAndProducerIdEpoch> timedOutTransactions() {
        scala.collection.mutable.Iterable iterable;
        long now = this.time.milliseconds();
        Lock inReadLock_inLock_lock = this.stateLock().readLock();
        inReadLock_inLock_lock.lock();
        try {
            iterable = TransactionStateManager.$anonfun$timedOutTransactions$1(this, now);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
        return iterable;
    }

    private void removeExpiredTransactionalIds(TopicPartition transactionPartition, TxnMetadataCacheEntry txnMetadataCacheEntry) {
        Lock inReadLock_inLock_lock = this.stateLock().readLock();
        inReadLock_inLock_lock.lock();
        try {
            TransactionStateManager.$anonfun$removeExpiredTransactionalIds$1(this, transactionPartition, txnMetadataCacheEntry);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
    }

    private boolean shouldExpire(TransactionMetadata txnMetadata, long currentTimeMs) {
        return txnMetadata.state().isExpirationAllowed() && txnMetadata.txnLastUpdateTimestamp() <= currentTimeMs - (long)this.config.transactionalIdExpirationMs();
    }

    private boolean maybeAppendExpiration(TransactionMetadata txnMetadata, MemoryRecordsBuilder recordsBuilder, long currentTimeMs) {
        byte[] keyBytes = TransactionLog$.MODULE$.keyToBytes(txnMetadata.transactionalId());
        if (recordsBuilder.hasRoomFor(currentTimeMs, keyBytes, null, Record.EMPTY_HEADERS)) {
            recordsBuilder.append(currentTimeMs, keyBytes, null, Record.EMPTY_HEADERS);
            return true;
        }
        return false;
    }

    public void removeExpiredTransactionalIds() {
        Lock inReadLock_inLock_lock = this.stateLock().readLock();
        inReadLock_inLock_lock.lock();
        try {
            TransactionStateManager.$anonfun$removeExpiredTransactionalIds$4(this);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
    }

    private void writeTombstonesForExpiredTransactionalIds(TopicPartition transactionPartition, Iterable<TransactionalIdCoordinatorEpochAndMetadata> expiredForPartition, MemoryRecords tombstoneRecords) {
        Lock inReadLock_inLock_lock = this.stateLock().readLock();
        inReadLock_inLock_lock.lock();
        try {
            TransactionStateManager.$anonfun$writeTombstonesForExpiredTransactionalIds$7(this, transactionPartition, tombstoneRecords, expiredForPartition);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
    }

    public void enableTransactionalIdExpiration() {
        this.scheduler.schedule("transactionalId-expiration", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.removeExpiredTransactionalIds(), this.config.removeExpiredTransactionalIdsIntervalMs(), this.config.removeExpiredTransactionalIdsIntervalMs(), this.scheduler.schedule$default$5());
    }

    public Either<Errors, Option<CoordinatorEpochAndTxnMetadata>> getTransactionState(String transactionalId) {
        return this.getAndMaybeAddTransactionState(transactionalId, (Option<TransactionMetadata>)None$.MODULE$);
    }

    public Either<Errors, CoordinatorEpochAndTxnMetadata> putTransactionStateIfNotExists(TransactionMetadata txnMetadata) {
        Right right;
        Right right2 = this.getAndMaybeAddTransactionState(txnMetadata.transactionalId(), (Option<TransactionMetadata>)new Some((Object)txnMetadata));
        if (right2 == null) {
            throw null;
        }
        Right map_this = right2;
        if (map_this instanceof Right) {
            Object map_b = ((Right)map_this).value();
            Option option = (Option)map_b;
            right = new Right((Object)TransactionStateManager.$anonfun$putTransactionStateIfNotExists$1(txnMetadata, option));
        } else {
            right = map_this;
        }
        return right;
    }

    private Either<Errors, Option<CoordinatorEpochAndTxnMetadata>> getAndMaybeAddTransactionState(String transactionalId, Option<TransactionMetadata> createdTxnMetadataOpt) {
        Either either;
        Lock inReadLock_inLock_lock = this.stateLock().readLock();
        inReadLock_inLock_lock.lock();
        try {
            either = TransactionStateManager.$anonfun$getAndMaybeAddTransactionState$1(this, transactionalId, createdTxnMetadataOpt);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
        return either;
    }

    public boolean validateTransactionTimeoutMs(int txnTimeoutMs) {
        return txnTimeoutMs <= this.config.transactionMaxTimeoutMs() && txnTimeoutMs > 0;
    }

    /*
     * WARNING - void declaration
     */
    public Properties transactionTopicConfigs() {
        void var1_1;
        Properties props = new Properties();
        props.put(LogConfig$.MODULE$.UncleanLeaderElectionEnableProp(), "false");
        props.put(LogConfig$.MODULE$.CompressionTypeProp(), UncompressedCodec$.MODULE$.name());
        props.put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact());
        props.put(LogConfig$.MODULE$.MinInSyncReplicasProp(), ((Object)this.config.transactionLogMinInsyncReplicas()).toString());
        props.put(LogConfig$.MODULE$.SegmentBytesProp(), ((Object)this.config.transactionLogSegmentBytes()).toString());
        return var1_1;
    }

    public int partitionFor(String transactionalId) {
        return Utils.abs((int)transactionalId.hashCode()) % this.transactionTopicPartitionCount();
    }

    private int getTransactionTopicPartitionCount() {
        Option<Object> option = this.zkClient.getTopicPartitionCount("__transaction_state");
        if (option == null) {
            throw null;
        }
        Option<Object> getOrElse_this = option;
        Object object = getOrElse_this.isEmpty() ? BoxesRunTime.boxToInteger((int)this.config.transactionLogNumPartitions()) : getOrElse_this.get();
        Object object2 = object;
        Object var1_1 = null;
        object = null;
        return BoxesRunTime.unboxToInt((Object)object2);
    }

    private Pool<String, TransactionMetadata> loadTransactionMetadata(TopicPartition topicPartition, int coordinatorEpoch) {
        Pool<String, TransactionMetadata> loadedTransactions = new Pool<String, TransactionMetadata>((Option<Function1<String, TransactionMetadata>>)None$.MODULE$);
        Option<Log> option = this.replicaManager.getLog(topicPartition);
        if (None$.MODULE$.equals(option)) {
            this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(62).append("Attempted to load transaction metadata from ").append(topicPartition).append(", but found no log").toString());
        } else if (option instanceof Some) {
            LongRef longRef;
            Log log = (Log)((Some)option).value();
            ByteBuffer buffer = ByteBuffer.allocate(0);
            long create_e = log.logStartOffset();
            LongRef longRef2 = longRef = new LongRef(create_e);
            longRef = null;
            LongRef currOffset = longRef2;
            boolean readAtLeastOneRecord = true;
            try {
                while (currOffset.elem < this.logEndOffset$1(topicPartition) && readAtLeastOneRecord && !this.shuttingDown().get()) {
                    MemoryRecords memoryRecords;
                    boolean bl;
                    Lock inReadLock_inLock_lock = this.stateLock().readLock();
                    inReadLock_inLock_lock.lock();
                    try {
                        bl = TransactionStateManager.$anonfun$loadTransactionMetadata$3(this, topicPartition, coordinatorEpoch);
                    }
                    finally {
                        inReadLock_inLock_lock.unlock();
                    }
                    Object var16_17 = null;
                    Object var17_18 = null;
                    if (!bl) break;
                    FetchDataInfo fetchDataInfo = log.read(currOffset.elem, this.config.transactionLogLoadBufferSize(), FetchLogEnd$.MODULE$, true);
                    readAtLeastOneRecord = fetchDataInfo.records().sizeInBytes() > 0;
                    Records records = fetchDataInfo.records();
                    if (records instanceof MemoryRecords) {
                        memoryRecords = (MemoryRecords)records;
                    } else if (records instanceof FileRecords) {
                        FileRecords fileRecords = (FileRecords)records;
                        int sizeInBytes = fileRecords.sizeInBytes();
                        int bytesNeeded = Math.max(this.config.transactionLogLoadBufferSize(), sizeInBytes);
                        if (buffer.capacity() < bytesNeeded) {
                            if (this.config.transactionLogLoadBufferSize() < bytesNeeded) {
                                this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(67).append("Loaded transaction metadata from ").append(topicPartition).append(" with buffer larger (").append(bytesNeeded).append(" bytes) than ").toString()).append(new StringBuilder(58).append("configured transaction.state.log.load.buffer.size (").append($this.config.transactionLogLoadBufferSize()).append(" bytes)").toString()).toString());
                            }
                            buffer = ByteBuffer.allocate(bytesNeeded);
                        } else {
                            buffer.clear();
                        }
                        buffer.clear();
                        fileRecords.readInto(buffer, 0);
                        memoryRecords = MemoryRecords.readableRecords((ByteBuffer)buffer);
                    } else {
                        throw new MatchError((Object)records);
                    }
                    memoryRecords.batches().forEach(batch -> AsScalaExtensions.IterableHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.lang.Iterable)batch).asScala().foreach((Function1 & Serializable)record -> {
                        TransactionStateManager.$anonfun$loadTransactionMetadata$7(loadedTransactions, currOffset, batch, record);
                        return BoxedUnit.UNIT;
                    }));
                }
            }
            catch (Throwable t) {
                this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(48).append("Error loading transactions from transaction log ").append(topicPartition).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> t);
            }
        } else {
            throw new MatchError(option);
        }
        return loadedTransactions;
    }

    public void addLoadedTransactionsToCache(int txnTopicPartition, int coordinatorEpoch, Pool<String, TransactionMetadata> loadedTransactions) {
        TxnMetadataCacheEntry txnMetadataCacheEntry = new TxnMetadataCacheEntry(coordinatorEpoch, loadedTransactions);
        Option previousTxnMetadataCacheEntryOpt = this.transactionMetadataCache().put((Object)txnTopicPartition, (Object)txnMetadataCacheEntry);
        if (previousTxnMetadataCacheEntryOpt == null) {
            throw null;
        }
        if (!previousTxnMetadataCacheEntryOpt.isEmpty()) {
            TxnMetadataCacheEntry txnMetadataCacheEntry2 = (TxnMetadataCacheEntry)previousTxnMetadataCacheEntryOpt.get();
            this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(48).append("Unloaded transaction metadata ").append(previousTxnMetadataCacheEntry).append(" from ").append(txnTopicPartition$1).append(" as part of ").toString()).append(new StringBuilder(26).append("loading metadata at epoch ").append(coordinatorEpoch$2).toString()).toString());
        }
    }

    public void loadTransactionsForTxnTopicPartition(int partitionId, int coordinatorEpoch, Function4<Object, TransactionResult, TransactionMetadata, TxnTransitMetadata, BoxedUnit> sendTxnMarkers) {
        TopicPartition topicPartition = new TopicPartition("__transaction_state", partitionId);
        TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch = new TransactionPartitionAndLeaderEpoch(partitionId, coordinatorEpoch);
        Lock inWriteLock_inLock_lock = this.stateLock().writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            TransactionStateManager.$anonfun$loadTransactionsForTxnTopicPartition$1(this, partitionAndLeaderEpoch);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
        Object var8_6 = null;
        long scheduleStartMs = this.time.milliseconds();
        this.scheduler.schedule(new StringBuilder(24).append("load-txns-for-partition-").append(topicPartition).toString(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.loadTransactions$1(Predef$.MODULE$.long2Long(scheduleStartMs), topicPartition, coordinatorEpoch, partitionAndLeaderEpoch, sendTxnMarkers), this.scheduler.schedule$default$3(), this.scheduler.schedule$default$4(), this.scheduler.schedule$default$5());
    }

    public void removeTransactionsForTxnTopicPartition(int partitionId) {
        TopicPartition topicPartition = new TopicPartition("__transaction_state", partitionId);
        Lock inWriteLock_inLock_lock = this.stateLock().writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            TransactionStateManager.$anonfun$removeTransactionsForTxnTopicPartition$1(this, partitionId, topicPartition);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    public void removeTransactionsForTxnTopicPartition(int partitionId, int coordinatorEpoch) {
        TopicPartition topicPartition = new TopicPartition("__transaction_state", partitionId);
        TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch = new TransactionPartitionAndLeaderEpoch(partitionId, coordinatorEpoch);
        Lock inWriteLock_inLock_lock = this.stateLock().writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            TransactionStateManager.$anonfun$removeTransactionsForTxnTopicPartition$5(this, partitionAndLeaderEpoch, partitionId, topicPartition);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    private void validateTransactionTopicPartitionCountIsStable() {
        int curTransactionTopicPartitionCount = this.getTransactionTopicPartitionCount();
        if (this.transactionTopicPartitionCount() != curTransactionTopicPartitionCount) {
            throw new KafkaException(new StringBuilder(60).append("Transaction topic number of partitions has changed from ").append(this.transactionTopicPartitionCount()).append(" to ").append(curTransactionTopicPartitionCount).toString());
        }
    }

    /*
     * Unable to fully structure code
     */
    public void appendTransactionToLog(String transactionalId, int coordinatorEpoch, TxnTransitMetadata newMetadata, Function1<Errors, BoxedUnit> responseCallback, Function1<Errors, Object> retryOnError) {
        keyBytes = TransactionLog$.MODULE$.keyToBytes(transactionalId);
        valueBytes = TransactionLog$.MODULE$.valueToBytes(newMetadata);
        timestamp = this.time.milliseconds();
        var17_9 = new SimpleRecord[]{new SimpleRecord(timestamp, keyBytes, valueBytes)};
        withRecords_compressionType = TransactionLog$.MODULE$.EnforcedCompressionType();
        withRecords_magic = 2;
        var23_12 = TimestampType.CREATE_TIME;
        withRecords_initialOffset = 0L;
        v0 = var24_14 = MemoryRecords.withRecords((byte)withRecords_magic, (long)withRecords_initialOffset, (CompressionType)withRecords_compressionType, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records);
        var23_12 = null;
        var24_14 = null;
        v1 = var20_15 = v0;
        var20_15 = null;
        v2 = var18_16 = v1;
        var16_10 = null;
        var17_9 = null;
        var18_16 = null;
        records = v2;
        topicPartition = new TopicPartition("__transaction_state", this.partitionFor(transactionalId));
        v3 = Predef$.MODULE$.Map();
        v4 = new Tuple2[1];
        v4[0] = new Tuple2((Object)topicPartition, (Object)records);
        var13_19 = ScalaRunTime$.MODULE$.wrapRefArray(v4);
        if (v3 == null) {
            throw null;
        }
        var13_19 = null;
        recordsPerPartition = (scala.collection.immutable.Map)MapFactory.apply$((MapFactory)v3, (Seq)apply_elems);
        inReadLock_inLock_lock = this.stateLock().readLock();
        inReadLock_inLock_lock.lock();
        try {
            block11: {
                block10: {
                    var25_22 = false;
                    var26_23 = null;
                    var27_24 = this.getTransactionState(transactionalId);
                    if (!(var27_24 instanceof Left)) break block10;
                    $anonfun$appendTransactionToLog$13_err = (Errors)((Left)var27_24).value();
                    (BoxedUnit)responseCallback.apply((Object)$anonfun$appendTransactionToLog$13_err);
                    break block11;
                }
                if (!(var27_24 instanceof Right)) ** GOTO lbl-1000
                var25_22 = true;
                var26_23 = (Right)var27_24;
                var29_26 = (Option)var26_23.value();
                if (None$.MODULE$.equals(var29_26)) {
                    (BoxedUnit)responseCallback.apply((Object)Errors.NOT_COORDINATOR);
                } else if (var25_22 && (var30_27 = (Option)var26_23.value()) instanceof Some) {
                    $anonfun$appendTransactionToLog$13_epochAndMetadata = (CoordinatorEpochAndTxnMetadata)((Some)var30_27).value();
                    if (BoxesRunTime.unboxToBoolean($anonfun$appendTransactionToLog$13_epochAndMetadata.transactionMetadata().inLock((JFunction0.mcZ.sp & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Z, $anonfun$appendTransactionToLog$14(kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata int scala.Function1 ), ()Z)((CoordinatorEpochAndTxnMetadata)$anonfun$appendTransactionToLog$13_epochAndMetadata, (int)coordinatorEpoch, responseCallback)))) {
                        this.replicaManager.appendRecords(newMetadata.txnTimeoutMs(), TransactionLog$.MODULE$.EnforcedRequiredAcks(), true, AppendOrigin$Coordinator$.MODULE$, (Map<TopicPartition, MemoryRecords>)recordsPerPartition, (Function1<Map<TopicPartition, ProduceResponse.PartitionResponse>, BoxedUnit>)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$appendTransactionToLog$15$adapted(kafka.coordinator.transaction.TransactionStateManager org.apache.kafka.common.TopicPartition java.lang.String kafka.coordinator.transaction.TxnTransitMetadata int scala.Function1 scala.Function1 scala.collection.Map ), (Lscala/collection/Map;)Ljava/lang/Object;)((TransactionStateManager)this, (TopicPartition)topicPartition, (String)transactionalId, (TxnTransitMetadata)newMetadata, (int)coordinatorEpoch, retryOnError, responseCallback), this.replicaManager.appendRecords$default$7(), this.replicaManager.appendRecords$default$8());
                        this.trace((Function0<String>)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$16(kafka.coordinator.transaction.TxnTransitMetadata java.lang.String int ), ()Ljava/lang/String;)((TxnTransitMetadata)newMetadata, (String)transactionalId, (int)coordinatorEpoch));
                    }
                } else {
                    throw new MatchError(var27_24);
                }
            }
            var26_23 = null;
            var27_24 = null;
            var28_25 = null;
            var29_26 = null;
            var30_27 = null;
            var31_28 = null;
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
    }

    public Function1<Errors, Object> appendTransactionToLog$default$5() {
        return (Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManager.$anonfun$appendTransactionToLog$default$5$1(x$5));
    }

    public void shutdown() {
        this.shuttingDown().set(true);
        this.loadingPartitions().clear();
        this.transactionMetadataCache().clear();
        this.info((Function0<String>)(Function0 & Serializable)() -> "Shutdown complete");
    }

    public static final /* synthetic */ boolean $anonfun$addLoadingPartition$1(TransactionStateManager $this, TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch$1) {
        return $this.loadingPartitions().add((Object)partitionAndLeaderEpoch$1);
    }

    public static final /* synthetic */ boolean $anonfun$timedOutTransactions$3(long now$1, Tuple2 x0$2) {
        boolean bl;
        if (x0$2 != null) {
            TransactionMetadata txnMetadata = (TransactionMetadata)x0$2._2();
            if (txnMetadata.pendingTransitionInProgress()) {
                bl = false;
            } else {
                TransactionState transactionState = txnMetadata.state();
                boolean bl2 = Ongoing$.MODULE$.equals(transactionState) ? txnMetadata.txnStartTimestamp() + (long)txnMetadata.txnTimeoutMs() < now$1 : false;
                bl = bl2;
            }
        } else {
            throw new MatchError(null);
        }
        boolean bl3 = bl;
        return bl3;
    }

    public static final /* synthetic */ scala.collection.mutable.Iterable $anonfun$timedOutTransactions$1(TransactionStateManager $this, long now$1) {
        return (scala.collection.mutable.Iterable)$this.transactionMetadataCache().flatMap((Function1 & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            IterableOnce iterableOnce = (IterableOnce)((IterableOps)((TxnMetadataCacheEntry)x0$1._2()).metadataPerTransactionalId().filter((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManager.$anonfun$timedOutTransactions$3(now$1, x0$2)))).map((Function1 & Serializable)x0$3 -> {
                if (x0$3 == null) {
                    throw new MatchError(null);
                }
                String txnId = (String)x0$3._1();
                TransactionMetadata txnMetadata = (TransactionMetadata)x0$3._2();
                TransactionalIdAndProducerIdEpoch transactionalIdAndProducerIdEpoch = new TransactionalIdAndProducerIdEpoch(txnId, txnMetadata.producerId(), txnMetadata.producerEpoch());
                return transactionalIdAndProducerIdEpoch;
            });
            return iterableOnce;
        });
    }

    private final void flushRecordsBuilder$1(TopicPartition transactionPartition$1, ListBuffer expired$1, ObjectRef recordsBuilder$1) {
        this.writeTombstonesForExpiredTransactionalIds(transactionPartition$1, (Iterable<TransactionalIdCoordinatorEpochAndMetadata>)expired$1.toSeq(), ((MemoryRecordsBuilder)recordsBuilder$1.elem).build());
        expired$1.clear();
        recordsBuilder$1.elem = null;
    }

    public static final /* synthetic */ void $anonfun$removeExpiredTransactionalIds$1(TransactionStateManager $this, TopicPartition transactionPartition$1, TxnMetadataCacheEntry txnMetadataCacheEntry$1) {
        Option<LogConfig> option = $this.replicaManager.getLogConfig(transactionPartition$1);
        if (option instanceof Some) {
            ObjectRef objectRef;
            ListBuffer listBuffer;
            LogConfig logConfig = (LogConfig)((Some)option).value();
            long currentTimeMs = $this.time.milliseconds();
            Integer maxBatchSize = logConfig.maxMessageSize();
            ListBuffer listBuffer2 = listBuffer = new ListBuffer();
            listBuffer = null;
            ListBuffer expired = listBuffer2;
            ObjectRef objectRef2 = objectRef = new ObjectRef(null);
            objectRef = null;
            ObjectRef recordsBuilder = objectRef2;
            BufferedIterator stateEntries = txnMetadataCacheEntry$1.metadataPerTransactionalId().values().iterator().buffered();
            while (stateEntries.hasNext()) {
                BooleanRef booleanRef;
                TransactionMetadata txnMetadata = (TransactionMetadata)stateEntries.head();
                String transactionalId = txnMetadata.transactionalId();
                boolean create_e = false;
                BooleanRef booleanRef2 = booleanRef = new BooleanRef(create_e);
                booleanRef = null;
                BooleanRef fullBatch = booleanRef2;
                txnMetadata.inLock((Function0 & Serializable)() -> {
                    if (txnMetadata.pendingState().isEmpty() && $this.shouldExpire(txnMetadata, currentTimeMs)) {
                        if ((MemoryRecordsBuilder)recordsBuilder$1.elem == null) {
                            recordsBuilder$1.elem = MemoryRecords.builder((ByteBuffer)ByteBuffer.allocate(Math.min(16384, BoxesRunTime.unboxToInt((Object)maxBatchSize))), (CompressionType)TransactionLog$.MODULE$.EnforcedCompressionType(), (TimestampType)TimestampType.CREATE_TIME, (long)0L, (int)BoxesRunTime.unboxToInt((Object)maxBatchSize));
                        }
                        if ($this.maybeAppendExpiration(txnMetadata, (MemoryRecordsBuilder)recordsBuilder$1.elem, currentTimeMs)) {
                            void $plus$eq_elem;
                            TxnTransitMetadata transitMetadata = txnMetadata.prepareDead();
                            TransactionalIdCoordinatorEpochAndMetadata transactionalIdCoordinatorEpochAndMetadata = new TransactionalIdCoordinatorEpochAndMetadata(transactionalId, txnMetadataCacheEntry$1.coordinatorEpoch(), transitMetadata);
                            if (expired == null) {
                                throw null;
                            }
                            return expired.addOne((Object)$plus$eq_elem);
                        }
                        fullBatch$1.elem = true;
                        return BoxedUnit.UNIT;
                    }
                    return BoxedUnit.UNIT;
                });
                if (fullBatch.elem) {
                    $this.writeTombstonesForExpiredTransactionalIds(transactionPartition$1, (Iterable<TransactionalIdCoordinatorEpochAndMetadata>)expired.toSeq(), ((MemoryRecordsBuilder)recordsBuilder.elem).build());
                    expired.clear();
                    recordsBuilder.elem = null;
                    continue;
                }
                stateEntries.next();
            }
            if (expired.nonEmpty()) {
                $this.writeTombstonesForExpiredTransactionalIds(transactionPartition$1, (Iterable<TransactionalIdCoordinatorEpochAndMetadata>)expired.toSeq(), ((MemoryRecordsBuilder)recordsBuilder.elem).build());
                expired.clear();
                recordsBuilder.elem = null;
                return;
            }
        } else {
            if (None$.MODULE$.equals(option)) {
                $this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(95).append(new StringBuilder(61).append("Transaction expiration for partition ").append(transactionPartition$1).append(" failed because the log ").toString()).append("config was not available, which likely means the partition is not online or is no longer local.").toString());
                return;
            }
            throw new MatchError(option);
        }
    }

    public static final /* synthetic */ void $anonfun$removeExpiredTransactionalIds$5(TransactionStateManager $this, Tuple2 x0$1) {
        if (x0$1 != null) {
            int partitionId = x0$1._1$mcI$sp();
            TxnMetadataCacheEntry partitionCacheEntry = (TxnMetadataCacheEntry)x0$1._2();
            TopicPartition transactionPartition = new TopicPartition("__transaction_state", partitionId);
            $this.removeExpiredTransactionalIds(transactionPartition, partitionCacheEntry);
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$removeExpiredTransactionalIds$4(TransactionStateManager $this) {
        $this.transactionMetadataCache().foreach((Function1 & Serializable)x0$1 -> {
            TransactionStateManager.$anonfun$removeExpiredTransactionalIds$5($this, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$writeTombstonesForExpiredTransactionalIds$2(TransactionStateManager $this, TopicPartition topicPartition$1, Iterable expiredForPartition$1, ProduceResponse.PartitionResponse response$1) {
        Option option = $this.transactionMetadataCache().get((Object)topicPartition$1.partition());
        if (option == null) {
            throw null;
        }
        Option foreach_this = option;
        if (!foreach_this.isEmpty()) {
            TxnMetadataCacheEntry txnMetadataCacheEntry = (TxnMetadataCacheEntry)foreach_this.get();
            expiredForPartition$1.foreach((Function1 & Serializable)idCoordinatorEpochAndMetadata -> {
                String transactionalId = idCoordinatorEpochAndMetadata.transactionalId();
                TransactionMetadata txnMetadata = txnMetadataCacheEntry.metadataPerTransactionalId().get(transactionalId);
                return txnMetadata.inLock((Function0 & Serializable)() -> {
                    if (txnMetadataCacheEntry.coordinatorEpoch() == idCoordinatorEpochAndMetadata.coordinatorEpoch() && txnMetadata.pendingState().contains((Object)Dead$.MODULE$) && txnMetadata.producerEpoch() == idCoordinatorEpochAndMetadata.transitMetadata().producerEpoch()) {
                        Errors errors = response$1.error;
                        Errors errors2 = Errors.NONE;
                        if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
                            return txnMetadataCacheEntry.metadataPerTransactionalId().remove(transactionalId);
                        }
                    }
                    $this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(42).append("Failed to remove expired transactionalId: ").append(transactionalId).toString()).append(new StringBuilder(43).append(" from cache. Tombstone append error code: ").append(response$1.error).append(",").toString()).append(new StringBuilder(33).append(" pendingState: ").append(txnMetadata.pendingState()).append(", producerEpoch: ").append(txnMetadata.producerEpoch()).append(",").toString()).append(new StringBuilder(26).append(" expected producerEpoch: ").append(idCoordinatorEpochAndMetadata.transitMetadata().producerEpoch()).append(",").toString()).append(new StringBuilder(48).append(" coordinatorEpoch: ").append(txnMetadataCacheEntry.coordinatorEpoch()).append(", expected coordinatorEpoch: ").toString()).append(String.valueOf((Object)idCoordinatorEpochAndMetadata.coordinatorEpoch())).toString());
                    txnMetadata.pendingState_$eq((Option<TransactionState>)None$.MODULE$);
                    return BoxedUnit.UNIT;
                });
            });
        }
    }

    public static final /* synthetic */ void $anonfun$writeTombstonesForExpiredTransactionalIds$1(TransactionStateManager $this, Iterable expiredForPartition$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            TopicPartition topicPartition = (TopicPartition)x0$1._1();
            ProduceResponse.PartitionResponse response = (ProduceResponse.PartitionResponse)x0$1._2();
            Lock inReadLock_inLock_lock = $this.stateLock().readLock();
            inReadLock_inLock_lock.lock();
            try {
                TransactionStateManager.$anonfun$writeTombstonesForExpiredTransactionalIds$2($this, topicPartition, expiredForPartition$1, response);
            }
            finally {
                inReadLock_inLock_lock.unlock();
            }
            return;
        }
        throw new MatchError(null);
    }

    private final void removeFromCacheCallback$1(Map responses, Iterable expiredForPartition$1) {
        responses.foreach((Function1 & Serializable)x0$1 -> {
            TransactionStateManager.$anonfun$writeTombstonesForExpiredTransactionalIds$1(this, expiredForPartition$1, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$writeTombstonesForExpiredTransactionalIds$7(TransactionStateManager $this, TopicPartition transactionPartition$2, MemoryRecords tombstoneRecords$1, Iterable expiredForPartition$1) {
        void apply_elems;
        scala.collection.immutable.Map$ map$ = Predef$.MODULE$.Map();
        Object[] objectArray = new Tuple2[1];
        objectArray[0] = new Tuple2((Object)transactionPartition$2, (Object)tombstoneRecords$1);
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
        if (map$ == null) {
            throw null;
        }
        arraySeq = null;
        $this.replicaManager.appendRecords($this.config.requestTimeoutMs(), TransactionLog$.MODULE$.EnforcedRequiredAcks(), true, AppendOrigin$Coordinator$.MODULE$, (Map<TopicPartition, MemoryRecords>)((Map)MapFactory.apply$((MapFactory)map$, (Seq)apply_elems)), (Function1<Map<TopicPartition, ProduceResponse.PartitionResponse>, BoxedUnit>)(Function1 & Serializable)responses -> {
            $this.removeFromCacheCallback$1(responses, expiredForPartition$1);
            return BoxedUnit.UNIT;
        }, $this.replicaManager.appendRecords$default$7(), $this.replicaManager.appendRecords$default$8());
    }

    public static final /* synthetic */ Nothing$ $anonfun$putTransactionStateIfNotExists$2(TransactionMetadata txnMetadata$3) {
        throw new IllegalStateException(new StringBuilder(61).append("Unexpected empty transaction metadata returned while putting ").append(txnMetadata$3).toString());
    }

    public static final /* synthetic */ CoordinatorEpochAndTxnMetadata $anonfun$putTransactionStateIfNotExists$1(TransactionMetadata txnMetadata$3, Option x$1) {
        if (x$1 == null) {
            throw null;
        }
        if (x$1.isEmpty()) {
            throw TransactionStateManager.$anonfun$putTransactionStateIfNotExists$2(txnMetadata$3);
        }
        return (CoordinatorEpochAndTxnMetadata)x$1.get();
    }

    public static final /* synthetic */ boolean $anonfun$getAndMaybeAddTransactionState$2(int partitionId$1, TransactionPartitionAndLeaderEpoch x$2) {
        return x$2.txnPartitionId() == partitionId$1;
    }

    public static final /* synthetic */ TransactionMetadata $anonfun$getAndMaybeAddTransactionState$5(TransactionMetadata createdTxnMetadata$1) {
        return createdTxnMetadata$1;
    }

    public static final /* synthetic */ TransactionMetadata $anonfun$getAndMaybeAddTransactionState$4(TxnMetadataCacheEntry cacheEntry$1, String transactionalId$3, TransactionMetadata createdTxnMetadata) {
        Option option = Option$.MODULE$.apply((Object)cacheEntry$1.metadataPerTransactionalId().putIfNotExists(transactionalId$3, createdTxnMetadata));
        if (option == null) {
            throw null;
        }
        Option getOrElse_this = option;
        Object object = getOrElse_this.isEmpty() ? createdTxnMetadata : getOrElse_this.get();
        return (TransactionMetadata)object;
    }

    public static final /* synthetic */ Option $anonfun$getAndMaybeAddTransactionState$3(Option createdTxnMetadataOpt$1, TxnMetadataCacheEntry cacheEntry$1, String transactionalId$3) {
        None$ none$;
        if (createdTxnMetadataOpt$1.isEmpty()) {
            none$ = None$.MODULE$;
        } else {
            TransactionMetadata transactionMetadata = (TransactionMetadata)createdTxnMetadataOpt$1.get();
            none$ = new Some((Object)TransactionStateManager.$anonfun$getAndMaybeAddTransactionState$4(cacheEntry$1, transactionalId$3, transactionMetadata));
        }
        return none$;
    }

    public static final /* synthetic */ CoordinatorEpochAndTxnMetadata $anonfun$getAndMaybeAddTransactionState$6(TxnMetadataCacheEntry cacheEntry$1, TransactionMetadata x$3) {
        return new CoordinatorEpochAndTxnMetadata(cacheEntry$1.coordinatorEpoch(), x$3);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ Either $anonfun$getAndMaybeAddTransactionState$1(TransactionStateManager $this, String transactionalId$3, Option createdTxnMetadataOpt$1) {
        Left left;
        int partitionId = $this.partitionFor(transactionalId$3);
        if ($this.loadingPartitions().exists((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManager.$anonfun$getAndMaybeAddTransactionState$2(partitionId, x$2)))) {
            void apply_value;
            Errors errors = Errors.COORDINATOR_LOAD_IN_PROGRESS;
            if (package$.MODULE$.Left() == null) {
                throw null;
            }
            return new Left((Object)apply_value);
        }
        Option option = $this.transactionMetadataCache().get((Object)partitionId);
        if (option instanceof Some) {
            void apply_value;
            Right right;
            None$ none$;
            TxnMetadataCacheEntry cacheEntry = (TxnMetadataCacheEntry)((Some)option).value();
            Option option2 = Option$.MODULE$.apply((Object)cacheEntry.metadataPerTransactionalId().get(transactionalId$3));
            if (option2 == null) {
                throw null;
            }
            Option orElse_this = option2;
            Option option3 = orElse_this.isEmpty() ? TransactionStateManager.$anonfun$getAndMaybeAddTransactionState$3(createdTxnMetadataOpt$1, cacheEntry, transactionalId$3) : orElse_this;
            Option option4 = option3;
            Object var8_7 = null;
            option3 = null;
            Option txnMetadata = option4;
            Right$ right$ = package$.MODULE$.Right();
            if (txnMetadata == null) {
                throw null;
            }
            if (txnMetadata.isEmpty()) {
                none$ = None$.MODULE$;
            } else {
                TransactionMetadata transactionMetadata = (TransactionMetadata)txnMetadata.get();
                none$ = new Some((Object)TransactionStateManager.$anonfun$getAndMaybeAddTransactionState$6(cacheEntry, transactionMetadata));
            }
            None$ none$2 = none$;
            none$ = null;
            None$ none$3 = none$2;
            if (right$ == null) {
                throw null;
            }
            Right right2 = right = new Right((Object)apply_value);
            none$3 = null;
            right = null;
            left = right2;
        } else if (None$.MODULE$.equals(option)) {
            void apply_value;
            Left left2;
            Errors errors = Errors.NOT_COORDINATOR;
            if (package$.MODULE$.Left() == null) {
                throw null;
            }
            Left left3 = left2 = new Left((Object)apply_value);
            errors = null;
            left2 = null;
            left = left3;
        } else {
            throw new MatchError((Object)option);
        }
        return left;
    }

    public static final /* synthetic */ long $anonfun$loadTransactionMetadata$1() {
        return -1L;
    }

    private final long logEndOffset$1(TopicPartition topicPartition$2) {
        Object object;
        Option<Object> option = this.replicaManager.getLogEndOffset(topicPartition$2);
        if (option == null) {
            throw null;
        }
        Option<Object> getOrElse_this = option;
        if (getOrElse_this.isEmpty()) {
            Long l;
            Long l2 = l = Long.valueOf(-1L);
            l = null;
            object = l2;
        } else {
            object = getOrElse_this.get();
        }
        Object object2 = object;
        Object var2_2 = null;
        object = null;
        return BoxesRunTime.unboxToLong((Object)object2);
    }

    public static final /* synthetic */ boolean $anonfun$loadTransactionMetadata$4(TopicPartition topicPartition$2, int coordinatorEpoch$1, TransactionPartitionAndLeaderEpoch idAndEpoch) {
        return idAndEpoch.txnPartitionId() == topicPartition$2.partition() && idAndEpoch.coordinatorEpoch() == coordinatorEpoch$1;
    }

    public static final /* synthetic */ boolean $anonfun$loadTransactionMetadata$3(TransactionStateManager $this, TopicPartition topicPartition$2, int coordinatorEpoch$1) {
        return $this.loadingPartitions().exists((Function1 & Serializable)idAndEpoch -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManager.$anonfun$loadTransactionMetadata$4(topicPartition$2, coordinatorEpoch$1, idAndEpoch)));
    }

    public static final /* synthetic */ String $anonfun$loadTransactionMetadata$8() {
        return "Transaction state log's key should not be null";
    }

    public static final /* synthetic */ void $anonfun$loadTransactionMetadata$7(Pool loadedTransactions$1, LongRef currOffset$1, MutableRecordBatch batch$1, Record record) {
        if (!record.hasKey()) {
            throw new IllegalArgumentException(new StringBuilder(20).append("requirement failed: ").append((Object)"Transaction state log's key should not be null").toString());
        }
        String transactionalId = TransactionLog$.MODULE$.readTxnRecordKey(record.key()).transactionalId();
        Option<TransactionMetadata> option = TransactionLog$.MODULE$.readTxnRecordValue(transactionalId, record.value());
        if (None$.MODULE$.equals(option)) {
            TransactionMetadata cfr_ignored_0 = (TransactionMetadata)loadedTransactions$1.remove(transactionalId);
        } else if (option instanceof Some) {
            TransactionMetadata txnMetadata = (TransactionMetadata)((Some)option).value();
            loadedTransactions$1.put(transactionalId, txnMetadata);
        } else {
            throw new MatchError(option);
        }
        currOffset$1.elem = batch$1.nextOffset();
    }

    public static final /* synthetic */ boolean $anonfun$loadTransactionsForTxnTopicPartition$1(TransactionStateManager $this, TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch$2) {
        return $this.loadingPartitions().add((Object)partitionAndLeaderEpoch$2);
    }

    public static final /* synthetic */ void $anonfun$loadTransactionsForTxnTopicPartition$4(TransactionStateManager $this, TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch$2, TopicPartition topicPartition$3, int coordinatorEpoch$3, Pool loadedTransactions$2, Function4 sendTxnMarkers$1) {
        if ($this.loadingPartitions().contains((Object)partitionAndLeaderEpoch$2)) {
            $this.addLoadedTransactionsToCache(topicPartition$3.partition(), coordinatorEpoch$3, loadedTransactions$2);
            ListBuffer transactionsPendingForCompletion = new ListBuffer();
            loadedTransactions$2.foreach((Function1 & Serializable)x0$1 -> {
                if (x0$1 == null) {
                    throw new MatchError(null);
                }
                String transactionalId = (String)x0$1._1();
                TransactionMetadata txnMetadata = (TransactionMetadata)x0$1._2();
                Object t = txnMetadata.inLock((Function0 & Serializable)() -> {
                    BoxedUnit boxedUnit;
                    TransactionState transactionState = txnMetadata.state();
                    if (PrepareAbort$.MODULE$.equals(transactionState)) {
                        ListBuffer listBuffer;
                        ListBuffer listBuffer2;
                        ListBuffer listBuffer3;
                        void $plus$eq_elem;
                        ListBuffer listBuffer4;
                        TransactionalIdCoordinatorEpochAndTransitMetadata transactionalIdCoordinatorEpochAndTransitMetadata = new TransactionalIdCoordinatorEpochAndTransitMetadata(transactionalId, coordinatorEpoch$3, TransactionResult.ABORT, txnMetadata, txnMetadata.prepareComplete($this.time.milliseconds()));
                        if (transactionsPendingForCompletion == null) {
                            throw null;
                        }
                        ListBuffer listBuffer5 = listBuffer4 = transactionsPendingForCompletion.addOne((Object)$plus$eq_elem);
                        listBuffer4 = null;
                        ListBuffer listBuffer6 = listBuffer3 = listBuffer5;
                        listBuffer3 = null;
                        ListBuffer listBuffer7 = listBuffer2 = listBuffer6;
                        listBuffer2 = null;
                        ListBuffer listBuffer8 = listBuffer = listBuffer7;
                        transactionalIdCoordinatorEpochAndTransitMetadata = null;
                        listBuffer = null;
                        boxedUnit = listBuffer8;
                    } else if (PrepareCommit$.MODULE$.equals(transactionState)) {
                        ListBuffer listBuffer;
                        ListBuffer listBuffer9;
                        ListBuffer listBuffer10;
                        void $plus$eq_elem;
                        ListBuffer listBuffer11;
                        TransactionalIdCoordinatorEpochAndTransitMetadata transactionalIdCoordinatorEpochAndTransitMetadata = new TransactionalIdCoordinatorEpochAndTransitMetadata(transactionalId, coordinatorEpoch$3, TransactionResult.COMMIT, txnMetadata, txnMetadata.prepareComplete($this.time.milliseconds()));
                        if (transactionsPendingForCompletion == null) {
                            throw null;
                        }
                        ListBuffer listBuffer12 = listBuffer11 = transactionsPendingForCompletion.addOne((Object)$plus$eq_elem);
                        listBuffer11 = null;
                        ListBuffer listBuffer13 = listBuffer10 = listBuffer12;
                        listBuffer10 = null;
                        ListBuffer listBuffer14 = listBuffer9 = listBuffer13;
                        listBuffer9 = null;
                        ListBuffer listBuffer15 = listBuffer = listBuffer14;
                        transactionalIdCoordinatorEpochAndTransitMetadata = null;
                        listBuffer = null;
                        boxedUnit = listBuffer15;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    return boxedUnit;
                });
                return t;
            });
            $this.loadingPartitions().remove((Object)partitionAndLeaderEpoch$2);
            transactionsPendingForCompletion.foreach((Function1 & Serializable)txnTransitMetadata -> {
                sendTxnMarkers$1.apply((Object)txnTransitMetadata.coordinatorEpoch(), (Object)txnTransitMetadata.result(), (Object)txnTransitMetadata.txnMetadata(), (Object)txnTransitMetadata.transitMetadata());
                return BoxedUnit.UNIT;
            });
        }
    }

    private final void loadTransactions$1(Long startTimeMs, TopicPartition topicPartition$3, int coordinatorEpoch$3, TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch$2, Function4 sendTxnMarkers$1) {
        long schedulerTimeMs = this.time.milliseconds() - BoxesRunTime.unboxToLong((Object)startTimeMs);
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(44).append("Loading transaction metadata from ").append(topicPartition$3).append(" at epoch ").append(coordinatorEpoch$3).toString());
        this.validateTransactionTopicPartitionCountIsStable();
        Pool<String, TransactionMetadata> loadedTransactions = this.loadTransactionMetadata(topicPartition$3, coordinatorEpoch$3);
        long endTimeMs = this.time.milliseconds();
        long totalLoadingTimeMs = endTimeMs - BoxesRunTime.unboxToLong((Object)startTimeMs);
        this.partitionLoadSensor().record((double)totalLoadingTimeMs, endTimeMs, false);
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(48).append("Finished loading ").append(loadedTransactions.size()).append(" transaction metadata from ").append(topicPartition$3).append(" in ").toString()).append(new StringBuilder(65).append(totalLoadingTimeMs).append(" milliseconds, of which ").append(schedulerTimeMs).append(" milliseconds was spent in the scheduler.").toString()).toString());
        Lock inWriteLock_inLock_lock = this.stateLock().writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            if (this.loadingPartitions().contains((Object)partitionAndLeaderEpoch$2)) {
                this.addLoadedTransactionsToCache(topicPartition$3.partition(), coordinatorEpoch$3, loadedTransactions);
                ListBuffer $anonfun$loadTransactionsForTxnTopicPartition$4_transactionsPendingForCompletion = new ListBuffer();
                loadedTransactions.foreach((Function1 & Serializable)x0$1 -> {
                    if (x0$1 == null) {
                        throw new MatchError(null);
                    }
                    String transactionalId = (String)x0$1._1();
                    TransactionMetadata txnMetadata = (TransactionMetadata)x0$1._2();
                    Object t = txnMetadata.inLock((Function0 & Serializable)() -> {
                        BoxedUnit boxedUnit;
                        TransactionState transactionState = txnMetadata.state();
                        if (PrepareAbort$.MODULE$.equals(transactionState)) {
                            ListBuffer listBuffer;
                            ListBuffer listBuffer2;
                            ListBuffer listBuffer3;
                            void $plus$eq_elem;
                            ListBuffer listBuffer4;
                            TransactionalIdCoordinatorEpochAndTransitMetadata transactionalIdCoordinatorEpochAndTransitMetadata = new TransactionalIdCoordinatorEpochAndTransitMetadata(transactionalId, coordinatorEpoch$3, TransactionResult.ABORT, txnMetadata, txnMetadata.prepareComplete($this.time.milliseconds()));
                            if (transactionsPendingForCompletion == null) {
                                throw null;
                            }
                            ListBuffer listBuffer5 = listBuffer4 = transactionsPendingForCompletion.addOne((Object)$plus$eq_elem);
                            listBuffer4 = null;
                            ListBuffer listBuffer6 = listBuffer3 = listBuffer5;
                            listBuffer3 = null;
                            ListBuffer listBuffer7 = listBuffer2 = listBuffer6;
                            listBuffer2 = null;
                            ListBuffer listBuffer8 = listBuffer = listBuffer7;
                            transactionalIdCoordinatorEpochAndTransitMetadata = null;
                            listBuffer = null;
                            boxedUnit = listBuffer8;
                        } else if (PrepareCommit$.MODULE$.equals(transactionState)) {
                            ListBuffer listBuffer;
                            ListBuffer listBuffer9;
                            ListBuffer listBuffer10;
                            void $plus$eq_elem;
                            ListBuffer listBuffer11;
                            TransactionalIdCoordinatorEpochAndTransitMetadata transactionalIdCoordinatorEpochAndTransitMetadata = new TransactionalIdCoordinatorEpochAndTransitMetadata(transactionalId, coordinatorEpoch$3, TransactionResult.COMMIT, txnMetadata, txnMetadata.prepareComplete($this.time.milliseconds()));
                            if (transactionsPendingForCompletion == null) {
                                throw null;
                            }
                            ListBuffer listBuffer12 = listBuffer11 = transactionsPendingForCompletion.addOne((Object)$plus$eq_elem);
                            listBuffer11 = null;
                            ListBuffer listBuffer13 = listBuffer10 = listBuffer12;
                            listBuffer10 = null;
                            ListBuffer listBuffer14 = listBuffer9 = listBuffer13;
                            listBuffer9 = null;
                            ListBuffer listBuffer15 = listBuffer = listBuffer14;
                            transactionalIdCoordinatorEpochAndTransitMetadata = null;
                            listBuffer = null;
                            boxedUnit = listBuffer15;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        return boxedUnit;
                    });
                    return t;
                });
                this.loadingPartitions().remove((Object)partitionAndLeaderEpoch$2);
                $anonfun$loadTransactionsForTxnTopicPartition$4_transactionsPendingForCompletion.foreach((Function1 & Serializable)txnTransitMetadata -> {
                    sendTxnMarkers$1.apply((Object)txnTransitMetadata.coordinatorEpoch(), (Object)txnTransitMetadata.result(), (Object)txnTransitMetadata.txnMetadata(), (Object)txnTransitMetadata.transitMetadata());
                    return BoxedUnit.UNIT;
                });
            }
            Object var15_11 = null;
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
        Object var13_10 = null;
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(67).append("Completed loading transaction metadata from ").append(topicPartition$3).append(" for coordinator epoch ").append(coordinatorEpoch$3).toString());
    }

    public static final /* synthetic */ boolean $anonfun$removeTransactionsForTxnTopicPartition$2(int partitionId$2, TransactionPartitionAndLeaderEpoch x$4) {
        return x$4.txnPartitionId() == partitionId$2;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$removeTransactionsForTxnTopicPartition$1(TransactionStateManager $this, int partitionId$2, TopicPartition topicPartition$4) {
        void $minus$minus$eq_xs;
        Set<TransactionPartitionAndLeaderEpoch> set = $this.loadingPartitions();
        IterableOnce iterableOnce = (IterableOnce)$this.loadingPartitions().filter((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManager.$anonfun$removeTransactionsForTxnTopicPartition$2(partitionId$2, x$4)));
        if (set == null) {
            throw null;
        }
        set.subtractAll((IterableOnce)$minus$minus$eq_xs);
        iterableOnce = null;
        Option option = $this.transactionMetadataCache().remove((Object)partitionId$2);
        if (option == null) {
            throw null;
        }
        Option foreach_this = option;
        if (!foreach_this.isEmpty()) {
            TxnMetadataCacheEntry txnMetadataCacheEntry = (TxnMetadataCacheEntry)foreach_this.get();
            $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(46).append("Unloaded transaction metadata ").append(txnMetadataCacheEntry).append(" for ").append(topicPartition$4).append(" following ").toString()).append("local partition deletion").toString());
        }
    }

    public static final /* synthetic */ void $anonfun$removeTransactionsForTxnTopicPartition$5(TransactionStateManager $this, TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch$3, int partitionId$3, TopicPartition topicPartition$5) {
        $this.loadingPartitions().remove((Object)partitionAndLeaderEpoch$3);
        Option option = $this.transactionMetadataCache().remove((Object)partitionId$3);
        if (option instanceof Some) {
            TxnMetadataCacheEntry txnMetadataCacheEntry = (TxnMetadataCacheEntry)((Some)option).value();
            $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(65).append("Unloaded transaction metadata ").append(txnMetadataCacheEntry).append(" for ").append(topicPartition$5).append(" on become-follower transition").toString());
            return;
        }
        if (None$.MODULE$.equals(option)) {
            $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(75).append("No cached transaction metadata found for ").append(topicPartition$5).append(" during become-follower transition").toString());
            return;
        }
        throw new MatchError((Object)option);
    }

    public static final /* synthetic */ String $anonfun$appendTransactionToLog$1(String transactionalId$5, TxnTransitMetadata newMetadata$1, ProduceResponse.PartitionResponse status$1) {
        return new StringBuilder(41).append("Appending ").append(transactionalId$5).append("'s new metadata ").append(newMetadata$1).append(" failed due to ").append(status$1.error.exceptionName()).toString();
    }

    public static final /* synthetic */ String $anonfun$appendTransactionToLog$2(String transactionalId$5, Errors err$1) {
        return new StringBuilder(0).append(new StringBuilder(63).append("Accessing the cached transaction metadata for ").append(transactionalId$5).append(" returns ").append(err$1).append(" error; ").toString()).append("aborting transition to the new metadata and setting the error in the callback").toString();
    }

    public static final /* synthetic */ void $anonfun$appendTransactionToLog$3(TransactionStateManager $this, CoordinatorEpochAndTxnMetadata epochAndMetadata$1, int coordinatorEpoch$4, String transactionalId$5, TxnTransitMetadata newMetadata$1, ObjectRef responseError$1, TransactionMetadata metadata$1) {
        if (epochAndMetadata$1.coordinatorEpoch() != coordinatorEpoch$4) {
            $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(83).append("The cached coordinator epoch for ").append(transactionalId$5).append(" has changed to ").append(epochAndMetadata$1.coordinatorEpoch()).append(" after appended its new metadata ").append(newMetadata$1).append(" ").toString()).append(new StringBuilder(78).append("to the transaction log (txn topic partition ").append($this.partitionFor(transactionalId$5)).append(") while it was ").append(coordinatorEpoch$4).append(" before appending; ").toString()).append(new StringBuilder(70).append("aborting transition to the new metadata and returning ").append(Errors.NOT_COORDINATOR).append(" in the callback").toString()).toString());
            responseError$1.elem = Errors.NOT_COORDINATOR;
            return;
        }
        metadata$1.completeTransitionTo(newMetadata$1);
        $this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(72).append("Updating ").append(transactionalId$5).append("'s transaction state to ").append(newMetadata$1).append(" with coordinator epoch ").append(coordinatorEpoch$4).append(" for ").append(transactionalId$5).append(" succeeded").toString());
    }

    public static final /* synthetic */ String $anonfun$appendTransactionToLog$6(TransactionStateManager $this, String transactionalId$5, TxnTransitMetadata newMetadata$1, int coordinatorEpoch$4) {
        return new StringBuilder(0).append(new StringBuilder(106).append("The cached coordinator metadata does not exist in the cache anymore for ").append(transactionalId$5).append(" after appended its new metadata ").append(newMetadata$1).append(" ").toString()).append(new StringBuilder(78).append("to the transaction log (txn topic partition ").append($this.partitionFor(transactionalId$5)).append(") while it was ").append(coordinatorEpoch$4).append(" before appending; ").toString()).append(new StringBuilder(70).append("aborting transition to the new metadata and returning ").append(Errors.NOT_COORDINATOR).append(" in the callback").toString()).toString();
    }

    public static final /* synthetic */ void $anonfun$appendTransactionToLog$7(TransactionStateManager $this, CoordinatorEpochAndTxnMetadata epochAndTxnMetadata$1, int coordinatorEpoch$4, Function1 retryOnError$1, ObjectRef responseError$1, TransactionMetadata metadata$2, TxnTransitMetadata newMetadata$1) {
        if (epochAndTxnMetadata$1.coordinatorEpoch() == coordinatorEpoch$4) {
            if (BoxesRunTime.unboxToBoolean((Object)retryOnError$1.apply((Object)((Errors)responseError$1.elem)))) {
                $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(72).append("TransactionalId ").append(metadata$2.transactionalId()).append(" append transaction log for ").append(newMetadata$1).append(" transition failed due to ").append((Errors)responseError$1.elem).append(", ").toString()).append(new StringBuilder(97).append("not resetting pending state ").append(metadata$2.pendingState()).append(" but just returning the error in the callback to let the caller retry").toString()).toString());
                return;
            }
            $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(72).append("TransactionalId ").append(metadata$2.transactionalId()).append(" append transaction log for ").append(newMetadata$1).append(" transition failed due to ").append((Errors)responseError$1.elem).append(", ").toString()).append(new StringBuilder(87).append("resetting pending state from ").append(metadata$2.pendingState()).append(", aborting state transition and returning ").append((Errors)responseError$1.elem).append(" in the callback").toString()).toString());
            metadata$2.pendingState_$eq((Option<TransactionState>)None$.MODULE$);
            return;
        }
        $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(72).append("TransactionalId ").append(metadata$2.transactionalId()).append(" append transaction log for ").append(newMetadata$1).append(" transition failed due to ").append((Errors)responseError$1.elem).append(", ").toString()).append(new StringBuilder(115).append("aborting state transition and returning the error in the callback since the coordinator epoch has changed from ").append(epochAndTxnMetadata$1.coordinatorEpoch()).append(" to ").append(coordinatorEpoch$4).toString()).toString());
    }

    public static final /* synthetic */ String $anonfun$appendTransactionToLog$11(String transactionalId$5, TxnTransitMetadata newMetadata$1, ObjectRef responseError$1) {
        return new StringBuilder(0).append(new StringBuilder(72).append("TransactionalId ").append(transactionalId$5).append(" append transaction log for ").append(newMetadata$1).append(" transition failed due to ").append((Errors)responseError$1.elem).append(", ").toString()).append("aborting state transition and returning the error in the callback since metadata is not available in the cache anymore").toString();
    }

    public static final /* synthetic */ String $anonfun$appendTransactionToLog$12(String transactionalId$5, TxnTransitMetadata newMetadata$1, ObjectRef responseError$1, Errors error$1) {
        return new StringBuilder(0).append(new StringBuilder(72).append("TransactionalId ").append(transactionalId$5).append(" append transaction log for ").append(newMetadata$1).append(" transition failed due to ").append((Errors)responseError$1.elem).append(", ").toString()).append(new StringBuilder(101).append("aborting state transition and returning the error in the callback since retrieving metadata returned ").append(error$1).toString()).toString();
    }

    /*
     * Unable to fully structure code
     */
    private final void updateCacheCallback$1(Map responseStatus, TopicPartition topicPartition$6, String transactionalId$5, TxnTransitMetadata newMetadata$1, int coordinatorEpoch$4, Function1 retryOnError$1, Function1 responseCallback$1) {
        block15: {
            block13: {
                block17: {
                    block16: {
                        block14: {
                            if (responseStatus.size() != 1 || !responseStatus.contains((Object)topicPartition$6)) {
                                throw new IllegalStateException(StringOps$.MODULE$.format$extension("Append status %s should only have one partition %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{responseStatus, topicPartition$6})));
                            }
                            status = (ProduceResponse.PartitionResponse)responseStatus.apply((Object)topicPartition$6);
                            v0 = status.error;
                            var14_9 = Errors.NONE;
                            if (!(v0 != null ? v0.equals(var14_9) == false : var14_9 != null)) {
                                v1 = Errors.NONE;
                            } else {
                                this.debug((Function0<String>)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$1(java.lang.String kafka.coordinator.transaction.TxnTransitMetadata org.apache.kafka.common.requests.ProduceResponse$PartitionResponse ), ()Ljava/lang/String;)((String)transactionalId$5, (TxnTransitMetadata)newMetadata$1, (ProduceResponse.PartitionResponse)status));
                                var15_10 = status.error;
                                var11_11 = Errors.UNKNOWN_TOPIC_OR_PARTITION.equals(var15_10) != false ? true : (Errors.NOT_ENOUGH_REPLICAS.equals(var15_10) != false ? true : (Errors.NOT_ENOUGH_REPLICAS_AFTER_APPEND.equals(var15_10) != false ? true : Errors.REQUEST_TIMED_OUT.equals(var15_10) != false));
                                if (var11_11) {
                                    var8_12 = Errors.COORDINATOR_NOT_AVAILABLE;
                                } else {
                                    var10_13 = Errors.NOT_LEADER_OR_FOLLOWER.equals(var15_10) != false ? true : Errors.KAFKA_STORAGE_ERROR.equals(var15_10) != false;
                                    if (var10_13) {
                                        var8_12 = Errors.NOT_COORDINATOR;
                                    } else {
                                        var9_14 = Errors.MESSAGE_TOO_LARGE.equals(var15_10) != false ? true : Errors.RECORD_LIST_TOO_LARGE.equals(var15_10) != false;
                                        var8_12 = var9_14 != false ? Errors.UNKNOWN_SERVER_ERROR : var15_10;
                                    }
                                }
                                v1 = var8_12;
                            }
                            create_e = v1;
                            var33_15 = null;
                            responseError = new ObjectRef((Object)create_e);
                            v2 = (Errors)responseError.elem;
                            var16_17 = Errors.NONE;
                            if (v2 != null ? v2.equals(var16_17) == false : var16_17 != null) break block13;
                            var17_18 = false;
                            var18_19 = null;
                            var19_20 = this.getTransactionState(transactionalId$5);
                            if (!(var19_20 instanceof Left)) break block14;
                            err = (Errors)((Left)var19_20).value();
                            this.info((Function0<String>)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$2(java.lang.String org.apache.kafka.common.protocol.Errors ), ()Ljava/lang/String;)((String)transactionalId$5, (Errors)err));
                            responseError.elem = err;
                            break block15;
                        }
                        if (!(var19_20 instanceof Right)) break block16;
                        var17_18 = true;
                        var18_19 = (Right)var19_20;
                        var21_22 = (Option)var18_19.value();
                        if (!(var21_22 instanceof Some)) break block16;
                        epochAndMetadata = (CoordinatorEpochAndTxnMetadata)((Some)var21_22).value();
                        metadata = epochAndMetadata.transactionMetadata();
                        (BoxedUnit)metadata.inLock((JFunction0.mcV.sp & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()V, $anonfun$appendTransactionToLog$3(kafka.coordinator.transaction.TransactionStateManager kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata int java.lang.String kafka.coordinator.transaction.TxnTransitMetadata scala.runtime.ObjectRef kafka.coordinator.transaction.TransactionMetadata ), ()V)((TransactionStateManager)this, (CoordinatorEpochAndTxnMetadata)epochAndMetadata, (int)coordinatorEpoch$4, (String)transactionalId$5, (TxnTransitMetadata)newMetadata$1, (ObjectRef)responseError, (TransactionMetadata)metadata));
                        break block15;
                    }
                    if (!var17_18 || !None$.MODULE$.equals(var24_25 = (Option)var18_19.value())) break block17;
                    this.info((Function0<String>)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$6(kafka.coordinator.transaction.TransactionStateManager java.lang.String kafka.coordinator.transaction.TxnTransitMetadata int ), ()Ljava/lang/String;)((TransactionStateManager)this, (String)transactionalId$5, (TxnTransitMetadata)newMetadata$1, (int)coordinatorEpoch$4));
                    responseError.elem = Errors.NOT_COORDINATOR;
                    break block15;
                }
                throw new MatchError(var19_20);
            }
            var25_26 = false;
            var26_27 = null;
            var27_28 = this.getTransactionState(transactionalId$5);
            if (!(var27_28 instanceof Right)) ** GOTO lbl-1000
            var25_26 = true;
            var26_27 = (Right)var27_28;
            var28_29 = (Option)var26_27.value();
            if (var28_29 instanceof Some) {
                epochAndTxnMetadata = (CoordinatorEpochAndTxnMetadata)((Some)var28_29).value();
                metadata = epochAndTxnMetadata.transactionMetadata();
                (BoxedUnit)metadata.inLock((JFunction0.mcV.sp & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()V, $anonfun$appendTransactionToLog$7(kafka.coordinator.transaction.TransactionStateManager kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata int scala.Function1 scala.runtime.ObjectRef kafka.coordinator.transaction.TransactionMetadata kafka.coordinator.transaction.TxnTransitMetadata ), ()V)((TransactionStateManager)this, (CoordinatorEpochAndTxnMetadata)epochAndTxnMetadata, (int)coordinatorEpoch$4, (Function1)retryOnError$1, (ObjectRef)responseError, (TransactionMetadata)metadata, (TxnTransitMetadata)newMetadata$1));
            } else if (var25_26 && None$.MODULE$.equals(var31_32 = (Option)var26_27.value())) {
                this.info((Function0<String>)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$11(java.lang.String kafka.coordinator.transaction.TxnTransitMetadata scala.runtime.ObjectRef ), ()Ljava/lang/String;)((String)transactionalId$5, (TxnTransitMetadata)newMetadata$1, (ObjectRef)responseError));
            } else if (var27_28 instanceof Left) {
                error = (Errors)((Left)var27_28).value();
                this.info((Function0<String>)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$12(java.lang.String kafka.coordinator.transaction.TxnTransitMetadata scala.runtime.ObjectRef org.apache.kafka.common.protocol.Errors ), ()Ljava/lang/String;)((String)transactionalId$5, (TxnTransitMetadata)newMetadata$1, (ObjectRef)responseError, (Errors)error));
            } else {
                throw new MatchError(var27_28);
            }
        }
        responseCallback$1.apply((Object)((Errors)responseError.elem));
    }

    public static final /* synthetic */ void $anonfun$appendTransactionToLog$13(TransactionStateManager $this, String transactionalId$5, Function1 responseCallback$1, int coordinatorEpoch$4, TxnTransitMetadata newMetadata$1, scala.collection.immutable.Map recordsPerPartition$1, TopicPartition topicPartition$6, Function1 retryOnError$1) {
        Option option;
        boolean bl = false;
        Right right = null;
        Either<Errors, Option<CoordinatorEpochAndTxnMetadata>> either = $this.getTransactionState(transactionalId$5);
        if (either instanceof Left) {
            Errors err = (Errors)((Left)either).value();
            BoxedUnit cfr_ignored_0 = (BoxedUnit)responseCallback$1.apply((Object)err);
            return;
        }
        if (either instanceof Right) {
            bl = true;
            right = (Right)either;
            Option option2 = (Option)right.value();
            if (None$.MODULE$.equals(option2)) {
                BoxedUnit cfr_ignored_1 = (BoxedUnit)responseCallback$1.apply((Object)Errors.NOT_COORDINATOR);
                return;
            }
        }
        if (bl && (option = (Option)right.value()) instanceof Some) {
            CoordinatorEpochAndTxnMetadata epochAndMetadata = (CoordinatorEpochAndTxnMetadata)((Some)option).value();
            if (BoxesRunTime.unboxToBoolean(epochAndMetadata.transactionMetadata().inLock((JFunction0.mcZ.sp & Serializable)() -> {
                if (epochAndMetadata.coordinatorEpoch() != coordinatorEpoch$4) {
                    responseCallback$1.apply((Object)Errors.NOT_COORDINATOR);
                    return false;
                }
                return true;
            }))) {
                $this.replicaManager.appendRecords(newMetadata$1.txnTimeoutMs(), TransactionLog$.MODULE$.EnforcedRequiredAcks(), true, AppendOrigin$Coordinator$.MODULE$, (Map<TopicPartition, MemoryRecords>)recordsPerPartition$1, (Function1<Map<TopicPartition, ProduceResponse.PartitionResponse>, BoxedUnit>)(Function1 & Serializable)responseStatus -> {
                    $this.updateCacheCallback$1(responseStatus, topicPartition$6, transactionalId$5, newMetadata$1, coordinatorEpoch$4, retryOnError$1, responseCallback$1);
                    return BoxedUnit.UNIT;
                }, $this.replicaManager.appendRecords$default$7(), $this.replicaManager.appendRecords$default$8());
                $this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(96).append("Appending new metadata ").append(newMetadata$1).append(" for transaction id ").append(transactionalId$5).append(" with coordinator epoch ").append(coordinatorEpoch$4).append(" to the local transaction log").toString());
                return;
            }
        } else {
            throw new MatchError(either);
        }
    }

    public static final /* synthetic */ boolean $anonfun$appendTransactionToLog$default$5$1(Errors x$5) {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public TransactionStateManager(int brokerId, KafkaZkClient zkClient, Scheduler scheduler, ReplicaManager replicaManager, TransactionConfig config, Time time, Metrics metrics) {
        void add_stat;
        void add_metricName;
        void add_stat2;
        void add_metricName2;
        this.zkClient = zkClient;
        this.scheduler = scheduler;
        this.replicaManager = replicaManager;
        this.config = config;
        this.time = time;
        this.logIdent_$eq(new StringBuilder(30).append("[Transaction State Manager ").append(brokerId).append("]: ").toString());
        this.shuttingDown = new AtomicBoolean(false);
        this.stateLock = new ReentrantReadWriteLock();
        this.loadingPartitions = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.transactionMetadataCache = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.transactionTopicPartitionCount = this.getTransactionTopicPartitionCount();
        this.partitionLoadSensor = metrics.sensor(TransactionStateManager$.MODULE$.LoadTimeSensor());
        Sensor sensor = this.partitionLoadSensor();
        Max max = new Max();
        MetricName metricName = metrics.metricName("partition-load-time-max", TransactionStateManager$.MODULE$.MetricsGroup(), "The max time it took to load the partitions in the last 30sec");
        if (sensor == null) {
            throw null;
        }
        sensor.add((MetricName)add_metricName2, (MeasurableStat)add_stat2, null);
        metricName = null;
        max = null;
        Sensor sensor2 = this.partitionLoadSensor();
        Avg avg = new Avg();
        MetricName metricName2 = metrics.metricName("partition-load-time-avg", TransactionStateManager$.MODULE$.MetricsGroup(), "The avg time it took to load the partitions in the last 30sec");
        if (sensor2 == null) {
            throw null;
        }
        sensor2.add((MetricName)add_metricName, (MeasurableStat)add_stat, null);
    }

    public static final /* synthetic */ Object $anonfun$addLoadedTransactionsToCache$1$adapted(TransactionStateManager $this, int txnTopicPartition$1, int coordinatorEpoch$2, TxnMetadataCacheEntry previousTxnMetadataCacheEntry) {
        $this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(48).append("Unloaded transaction metadata ").append(previousTxnMetadataCacheEntry).append(" from ").append(txnTopicPartition$1).append(" as part of ").toString()).append(new StringBuilder(26).append("loading metadata at epoch ").append(coordinatorEpoch$2).toString()).toString());
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$writeTombstonesForExpiredTransactionalIds$3$adapted(TransactionStateManager $this, Iterable expiredForPartition$1, ProduceResponse.PartitionResponse response$1, TxnMetadataCacheEntry txnMetadataCacheEntry) {
        expiredForPartition$1.foreach((Function1 & Serializable)idCoordinatorEpochAndMetadata -> {
            String transactionalId = idCoordinatorEpochAndMetadata.transactionalId();
            TransactionMetadata txnMetadata = txnMetadataCacheEntry.metadataPerTransactionalId().get(transactionalId);
            return txnMetadata.inLock((Function0 & Serializable)() -> {
                if (txnMetadataCacheEntry.coordinatorEpoch() == idCoordinatorEpochAndMetadata.coordinatorEpoch() && txnMetadata.pendingState().contains((Object)Dead$.MODULE$) && txnMetadata.producerEpoch() == idCoordinatorEpochAndMetadata.transitMetadata().producerEpoch()) {
                    Errors errors = response$1.error;
                    Errors errors2 = Errors.NONE;
                    if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
                        return txnMetadataCacheEntry.metadataPerTransactionalId().remove(transactionalId);
                    }
                }
                $this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(42).append("Failed to remove expired transactionalId: ").append(transactionalId).toString()).append(new StringBuilder(43).append(" from cache. Tombstone append error code: ").append(response$1.error).append(",").toString()).append(new StringBuilder(33).append(" pendingState: ").append(txnMetadata.pendingState()).append(", producerEpoch: ").append(txnMetadata.producerEpoch()).append(",").toString()).append(new StringBuilder(26).append(" expected producerEpoch: ").append(idCoordinatorEpochAndMetadata.transitMetadata().producerEpoch()).append(",").toString()).append(new StringBuilder(48).append(" coordinatorEpoch: ").append(txnMetadataCacheEntry.coordinatorEpoch()).append(", expected coordinatorEpoch: ").toString()).append(String.valueOf((Object)idCoordinatorEpochAndMetadata.coordinatorEpoch())).toString());
                txnMetadata.pendingState_$eq((Option<TransactionState>)None$.MODULE$);
                return BoxedUnit.UNIT;
            });
        });
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$removeTransactionsForTxnTopicPartition$3$adapted(TransactionStateManager $this, TopicPartition topicPartition$4, TxnMetadataCacheEntry txnMetadataCacheEntry) {
        $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(46).append("Unloaded transaction metadata ").append(txnMetadataCacheEntry).append(" for ").append(topicPartition$4).append(" following ").toString()).append("local partition deletion").toString());
        return BoxedUnit.UNIT;
    }
}

