/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.util.Properties;
import kafka.cluster.Broker;
import kafka.server.BrokerState;
import kafka.server.BrokerStates;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.RunningAsBroker$;
import kafka.server.ServerStartupTest;
import kafka.server.ServerStartupTest$MockKafkaServer$2$;
import kafka.utils.TestUtils$;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.apache.zookeeper.KeeperException;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.None$;
import scala.Option;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.LazyRef;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\r3Aa\u0003\u0007\u0001#!)\u0001\u0004\u0001C\u00013!9Q\u0002\u0001a\u0001\n\u0013a\u0002b\u0002\u0011\u0001\u0001\u0004%I!\t\u0005\u0007U\u0001\u0001\u000b\u0015B\u000f\t\u000b-\u0002A\u0011\t\u0017\t\u000bY\u0002A\u0011\u0001\u0017\t\u000bm\u0002A\u0011\u0001\u0017\t\u000bu\u0002A\u0011\u0001\u0017\t\u000b}\u0002A\u0011\u0001\u0017\t\u000b\u0005\u0003A\u0011\u0001\u0017\u0003#M+'O^3s'R\f'\u000f^;q)\u0016\u001cHO\u0003\u0002\u000e\u001d\u000511/\u001a:wKJT\u0011aD\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001!\u0003\u0005\u0002\u0014-5\tAC\u0003\u0002\u0016\u001d\u0005\u0011!p[\u0005\u0003/Q\u0011ACW8p\u0017\u0016,\u0007/\u001a:UKN$\b*\u0019:oKN\u001c\u0018A\u0002\u001fj]&$h\bF\u0001\u001b!\tY\u0002!D\u0001\r+\u0005i\u0002CA\u000e\u001f\u0013\tyBBA\u0006LC\u001a\\\u0017mU3sm\u0016\u0014\u0018AC:feZ,'o\u0018\u0013fcR\u0011!\u0005\u000b\t\u0003G\u0019j\u0011\u0001\n\u0006\u0002K\u0005)1oY1mC&\u0011q\u0005\n\u0002\u0005+:LG\u000fC\u0004*\u0007\u0005\u0005\t\u0019A\u000f\u0002\u0007a$\u0013'A\u0004tKJ4XM\u001d\u0011\u0002\u0011Q,\u0017M\u001d#po:$\u0012A\t\u0015\u0003\u000b9\u0002\"a\f\u001b\u000e\u0003AR!!\r\u001a\u0002\u000b),h.\u001b;\u000b\u0003M\n1a\u001c:h\u0013\t)\u0004GA\u0003BMR,'/A\ruKN$(I]8lKJ\u001c%/Z1uKNT6j\u00115s_>$\bF\u0001\u00049!\ty\u0013(\u0003\u0002;a\t!A+Z:u\u0003\u0015\"Xm\u001d;D_:4G.[2u\u0005J|7.\u001a:Ti\u0006\u0014H/\u001e9XSRD7+Y7f!>\u0014H\u000f\u000b\u0002\bq\u0005qB/Z:u\u0007>tg\r\\5di\n\u0013xn[3s%\u0016<\u0017n\u001d;sCRLwN\u001c\u0015\u0003\u0011a\n1\u0003^3ti\n\u0013xn[3s'\u0016dg-Q<be\u0016D#!\u0003\u001d\u0002;Q,7\u000f\u001e\"s_.,'o\u0015;bi\u0016\u0014VO\u001c8j]\u001e\fe\r^3s5.C#A\u0003\u001d")
public class ServerStartupTest
extends ZooKeeperTestHarness {
    private KafkaServer server = null;

    private KafkaServer server() {
        return this.server;
    }

    private void server_$eq(KafkaServer x$1) {
        this.server = x$1;
    }

    @Override
    @After
    public void tearDown() {
        if (this.server() != null) {
            TestUtils$.MODULE$.shutdownServers((Seq<KafkaServer>)((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{this.server()}))));
        }
        super.tearDown();
    }

    @Test
    public void testBrokerCreatesZKChroot() {
        int brokerId = 0;
        String zookeeperChroot = "/kafka-chroot-for-unittest";
        Properties props = TestUtils$.MODULE$.createBrokerConfig(brokerId, this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1);
        Object zooKeeperConnect = props.get("zookeeper.connect");
        props.put("zookeeper.connect", new StringBuilder(0).append(zooKeeperConnect.toString()).append(zookeeperChroot).toString());
        this.server_$eq(TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(props), Time.SYSTEM, (Option<String>)None$.MODULE$));
        Assert.assertTrue((boolean)this.zkClient().pathExists(zookeeperChroot));
    }

    @Test
    public void testConflictBrokerStartupWithSamePort() {
        None$ none$;
        None$ none$2;
        None$ none$3;
        None$ none$4;
        int brokerId1 = 0;
        Properties props1 = TestUtils$.MODULE$.createBrokerConfig(brokerId1, this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1);
        this.server_$eq(TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(props1), Time.SYSTEM, (Option<String>)None$.MODULE$));
        int port = TestUtils$.MODULE$.boundPort(this.server(), SecurityProtocol.PLAINTEXT);
        int brokerId2 = 1;
        String x$2 = this.zkConnect();
        boolean bl = true;
        boolean bl2 = true;
        None$ none$5 = none$4 = None$.MODULE$;
        none$4 = null;
        None$ x$6 = none$5;
        None$ none$6 = none$3 = None$.MODULE$;
        none$3 = null;
        None$ x$7 = none$6;
        None$ none$7 = none$2 = None$.MODULE$;
        none$2 = null;
        None$ x$8 = none$7;
        boolean bl3 = true;
        boolean bl4 = false;
        int n = TestUtils$.MODULE$.RandomPort();
        boolean bl5 = false;
        int n2 = TestUtils$.MODULE$.RandomPort();
        boolean bl6 = false;
        int n3 = TestUtils$.MODULE$.RandomPort();
        None$ none$8 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$16 = none$8;
        int n4 = 1;
        boolean bl7 = false;
        int n5 = 1;
        short s = 1;
        Properties props2 = TestUtils$.MODULE$.createBrokerConfig(brokerId2, x$2, bl, bl2, port, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, bl3, bl4, n, bl5, n2, bl6, n3, (Option<String>)x$16, n4, bl7, n5, s);
        try {
            TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(props2), Time.SYSTEM, (Option<String>)None$.MODULE$);
            Assert.fail((String)"Starting a broker with the same port should fail");
            return;
        }
        catch (KafkaException kafkaException) {
            return;
        }
    }

    @Test
    public void testConflictBrokerRegistration() {
        Object object;
        Object object2;
        int brokerId = 0;
        Properties props1 = TestUtils$.MODULE$.createBrokerConfig(brokerId, this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1);
        this.server_$eq(TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(props1), Time.SYSTEM, (Option<String>)None$.MODULE$));
        Option option = this.zkClient().getBroker(brokerId);
        if (option == null) {
            throw null;
        }
        Option getOrElse_this = option;
        if (getOrElse_this.isEmpty()) {
            Assert.fail((String)"broker doesn't exists");
            object2 = BoxedUnit.UNIT;
        } else {
            object2 = getOrElse_this.get();
        }
        Object object3 = object2;
        Object var5_3 = null;
        object2 = null;
        Object brokerRegistration = object3;
        Properties props2 = TestUtils$.MODULE$.createBrokerConfig(brokerId, this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1);
        try {
            TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(props2), Time.SYSTEM, (Option<String>)None$.MODULE$);
            Assert.fail((String)"Registering a broker with a conflicting id should fail");
        }
        catch (KeeperException.NodeExistsException nodeExistsException) {}
        Option option2 = this.zkClient().getBroker(brokerId);
        if (option2 == null) {
            throw null;
        }
        Option getOrElse_this2 = option2;
        if (getOrElse_this2.isEmpty()) {
            Assert.fail((String)"broker doesn't exists");
            object = BoxedUnit.UNIT;
        } else {
            object = getOrElse_this2.get();
        }
        Object object4 = object;
        Object var7_7 = null;
        object = null;
        Assert.assertEquals((Object)brokerRegistration, (Object)object4);
    }

    @Test
    public void testBrokerSelfAware() {
        int brokerId = 0;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(brokerId, this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1);
        this.server_$eq(TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(props), Time.SYSTEM, (Option<String>)None$.MODULE$));
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ServerStartupTest.$anonfun$testBrokerSelfAware$1(this)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                throw Assertions$.MODULE$.fail("Wait for cache to update", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            Thread.sleep(Math.min(l, l2));
        }
        Seq seq = this.server().metadataCache().getAliveBrokers();
        if (seq == null) {
            throw null;
        }
        Assert.assertEquals((long)1L, (long)seq.length());
        Assert.assertEquals((long)brokerId, (long)((Broker)this.server().metadataCache().getAliveBrokers().head()).id());
    }

    @Test
    public void testBrokerStateRunningAfterZK() {
        LazyRef MockKafkaServer$module = new LazyRef();
        int brokerId = 0;
        BrokerState mockBrokerState = (BrokerState)EasyMock.niceMock(BrokerState.class);
        Properties props = TestUtils$.MODULE$.createBrokerConfig(brokerId, this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1);
        public class Kafka_server_ServerStartupTest$MockKafkaServer$1
        extends KafkaServer {
            private final BrokerState brokerState;

            public KafkaConfig config() {
                return super.config();
            }

            public BrokerState brokerState() {
                return this.brokerState;
            }

            public Kafka_server_ServerStartupTest$MockKafkaServer$1(ServerStartupTest $outer, KafkaConfig config, BrokerState brokerState) {
                this.brokerState = brokerState;
                super(config, Time.SYSTEM, (Option)None$.MODULE$, (Seq)Nil$.MODULE$);
            }
        }
        this.server_$eq(new Kafka_server_ServerStartupTest$MockKafkaServer$1(null, KafkaConfig$.MODULE$.fromProps(props), this.MockKafkaServer$3(MockKafkaServer$module, mockBrokerState).$lessinit$greater$default$2()));
        mockBrokerState.newState((BrokerStates)RunningAsBroker$.MODULE$);
        public class Kafka_server_ServerStartupTest$BrokerStateInterceptor$1
        extends BrokerState {
            private final /* synthetic */ ServerStartupTest $outer;
            private final int brokerId$1;

            public void newState(BrokerStates newState) {
                Seq brokers = this.$outer.zkClient().getAllBrokersInCluster();
                if (brokers == null) {
                    throw null;
                }
                Assert.assertEquals((long)1L, (long)brokers.length());
                Assert.assertEquals((long)this.brokerId$1, (long)((Broker)brokers.head()).id());
            }

            public Kafka_server_ServerStartupTest$BrokerStateInterceptor$1(ServerStartupTest $outer, int brokerId$1) {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.brokerId$1 = brokerId$1;
            }
        }
        EasyMock.expect((Object)BoxedUnit.UNIT).andDelegateTo((Object)new Kafka_server_ServerStartupTest$BrokerStateInterceptor$1(this, brokerId)).once();
        EasyMock.replay((Object[])new Object[]{mockBrokerState});
        this.server().startup();
    }

    public static final /* synthetic */ void $anonfun$testConflictBrokerRegistration$1() {
        Assert.fail((String)"broker doesn't exists");
    }

    public static final /* synthetic */ void $anonfun$testConflictBrokerRegistration$2() {
        Assert.fail((String)"broker doesn't exists");
    }

    public static final /* synthetic */ boolean $anonfun$testBrokerSelfAware$1(ServerStartupTest $this) {
        return $this.server().metadataCache().getAliveBrokers().nonEmpty();
    }

    public static final /* synthetic */ String $anonfun$testBrokerSelfAware$2() {
        return "Wait for cache to update";
    }

    private static final /* synthetic */ ServerStartupTest$MockKafkaServer$2$ MockKafkaServer$lzycompute$1(LazyRef MockKafkaServer$module$1, BrokerState mockBrokerState$1) {
        synchronized (MockKafkaServer$module$1) {
            ServerStartupTest$MockKafkaServer$2$ serverStartupTest$MockKafkaServer$2$ = MockKafkaServer$module$1.initialized() ? (ServerStartupTest$MockKafkaServer$2$)MockKafkaServer$module$1.value() : (ServerStartupTest$MockKafkaServer$2$)MockKafkaServer$module$1.initialize((Object)new ServerStartupTest$MockKafkaServer$2$(null, mockBrokerState$1));
            return serverStartupTest$MockKafkaServer$2$;
        }
    }

    private final ServerStartupTest$MockKafkaServer$2$ MockKafkaServer$3(LazyRef MockKafkaServer$module$1, BrokerState mockBrokerState$1) {
        if (MockKafkaServer$module$1.initialized()) {
            return (ServerStartupTest$MockKafkaServer$2$)MockKafkaServer$module$1.value();
        }
        return ServerStartupTest.MockKafkaServer$lzycompute$1(MockKafkaServer$module$1, mockBrokerState$1);
    }
}

