/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.checkpoints;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.Serializable;
import kafka.server.LogDirFailureChannel;
import kafka.server.checkpoints.CheckpointFile;
import kafka.server.checkpoints.CheckpointFileFormatter;
import kafka.server.checkpoints.LazyOffsetCheckpoints;
import kafka.server.checkpoints.OffsetCheckpointFile;
import kafka.server.checkpoints.OffsetCheckpointFile$;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.test.TestUtils;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.None$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u00193A\u0001C\u0005\u0001!!)Q\u0004\u0001C\u0001=!)\u0011\u0005\u0001C\u0001E!)q\u0006\u0001C\u0001E!)\u0011\u0007\u0001C\u0001E!)1\u0007\u0001C\u0001E!)!\t\u0001C\u0001E!)A\t\u0001C\u0001E\tArJ\u001a4tKR\u001c\u0005.Z2la>Lg\u000e\u001e$jY\u0016$Vm\u001d;\u000b\u0005)Y\u0011aC2iK\u000e\\\u0007o\\5oiNT!\u0001D\u0007\u0002\rM,'O^3s\u0015\u0005q\u0011!B6bM.\f7\u0001A\n\u0004\u0001E9\u0002C\u0001\n\u0016\u001b\u0005\u0019\"\"\u0001\u000b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Y\u0019\"AB!osJ+g\r\u0005\u0002\u001975\t\u0011D\u0003\u0002\u001b\u001b\u0005)Q\u000f^5mg&\u0011A$\u0007\u0002\b\u0019><w-\u001b8h\u0003\u0019a\u0014N\\5u}Q\tq\u0004\u0005\u0002!\u00015\t\u0011\"\u0001\u0014tQ>,H\u000e\u001a)feNL7\u000f^!oI>3XM]<sSR,\u0017I\u001c3SK2|\u0017\r\u001a$jY\u0016$\u0012a\t\t\u0003%\u0011J!!J\n\u0003\tUs\u0017\u000e\u001e\u0015\u0003\u0005\u001d\u0002\"\u0001K\u0017\u000e\u0003%R!AK\u0016\u0002\u000b),h.\u001b;\u000b\u00031\n1a\u001c:h\u0013\tq\u0013F\u0001\u0003UKN$\u0018!G:i_VdG\rS1oI2,W*\u001e7uSBdW\rT5oKND#aA\u0014\u0002AMDw.\u001e7e%\u0016$XO\u001d8F[B$\u00180T1q\r>\u0014X)\u001c9us\u001aKG.\u001a\u0015\u0003\t\u001d\n1e\u001d5pk2$G\u000b\u001b:po&3g+\u001a:tS>t\u0017j\u001d(piJ+7m\\4oSN,G\r\u000b\u0003\u0006OU2\u0014\u0001C3ya\u0016\u001cG/\u001a3$\u0003]\u0002\"\u0001\u000f!\u000e\u0003eR!AO\u001e\u0002\r\u0015\u0014(o\u001c:t\u0015\taT(\u0001\u0004d_6lwN\u001c\u0006\u0003\u001dyR!aP\u0016\u0002\r\u0005\u0004\u0018m\u00195f\u0013\t\t\u0015HA\u000bLC\u001a\\\u0017m\u0015;pe\u0006<W-\u0012=dKB$\u0018n\u001c8\u00021Q,7\u000f\u001e'buf|eMZ:fi\u000eCWmY6q_&tG\u000f\u000b\u0002\u0007O\u0005IC/Z:u\u0019\u0006T\u0018p\u00144gg\u0016$8\t[3dWB|\u0017N\u001c;GS2,\u0017J\u001c<bY&$Gj\\4ESJD#aB\u0014")
public class OffsetCheckpointFileTest
implements Logging {
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$((Logging)this, (String)msg);
    }

    public void trace(Function0<String> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$((Logging)this, msg, e);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$((Logging)this, msg, e);
    }

    public void info(Function0<String> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$((Logging)this, msg, e);
    }

    public void warn(Function0<String> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$((Logging)this, msg, e);
    }

    public void error(Function0<String> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$((Logging)this, msg, e);
    }

    public void fatal(Function0<String> msg) {
        Logging.fatal$((Logging)this, msg);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$((Logging)this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void shouldPersistAndOverwriteAndReloadFile() {
        void $minus$greater$extension_y;
        Long l;
        void $minus$greater$extension_y2;
        Long l2;
        void $minus$greater$extension_y3;
        Long l3;
        void $minus$greater$extension_y4;
        Long l4;
        OffsetCheckpointFile checkpoint = new OffsetCheckpointFile(TestUtils.tempFile(), null);
        Object[] objectArray = new Tuple2[2];
        Long l5 = l4 = Long.valueOf(5L);
        l4 = null;
        Long l6 = l5;
        TopicPartition $minus$greater$extension_$this = new TopicPartition("foo", 1);
        Object var4_4 = null;
        l6 = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y4);
        Long l7 = l3 = Long.valueOf(10L);
        l3 = null;
        Long l8 = l7;
        TopicPartition $minus$greater$extension_$this2 = new TopicPartition("bar", 2);
        Object var6_7 = null;
        l8 = null;
        objectArray[1] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y3);
        Map offsets = (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        checkpoint.write(offsets);
        Assert.assertEquals((Object)offsets, (Object)checkpoint.read());
        Object[] objectArray2 = new Tuple2[2];
        Long l9 = l2 = Long.valueOf(15L);
        l2 = null;
        Long l10 = l9;
        TopicPartition $minus$greater$extension_$this3 = new TopicPartition("foo", 2);
        Object var8_11 = null;
        l10 = null;
        objectArray2[0] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y2);
        Long l11 = l = Long.valueOf(20L);
        l = null;
        Long l12 = l11;
        TopicPartition $minus$greater$extension_$this4 = new TopicPartition("bar", 3);
        Object var10_14 = null;
        l12 = null;
        objectArray2[1] = new Tuple2((Object)$minus$greater$extension_$this4, (Object)$minus$greater$extension_y);
        Map offsets2 = (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray2));
        checkpoint.write(offsets2);
        Assert.assertEquals((Object)offsets2, (Object)checkpoint.read());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void shouldHandleMultipleLines() {
        void $minus$greater$extension_y;
        Long l;
        void $minus$greater$extension_y2;
        Long l2;
        void $minus$greater$extension_y3;
        Long l3;
        void $minus$greater$extension_y4;
        Long l4;
        void $minus$greater$extension_y5;
        Long l5;
        void $minus$greater$extension_y6;
        Long l6;
        void $minus$greater$extension_y7;
        Long l7;
        void $minus$greater$extension_y8;
        Long l8;
        void $minus$greater$extension_y9;
        Long l9;
        void $minus$greater$extension_y10;
        Long l10;
        OffsetCheckpointFile checkpoint = new OffsetCheckpointFile(TestUtils.tempFile(), null);
        Object[] objectArray = new Tuple2[10];
        Long l11 = l10 = Long.valueOf(5L);
        l10 = null;
        Long l12 = l11;
        TopicPartition $minus$greater$extension_$this = new TopicPartition("foo", 1);
        Object var3_4 = null;
        l12 = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y10);
        Long l13 = l9 = Long.valueOf(10L);
        l9 = null;
        Long l14 = l13;
        TopicPartition $minus$greater$extension_$this2 = new TopicPartition("bar", 6);
        Object var5_7 = null;
        l14 = null;
        objectArray[1] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y9);
        Long l15 = l8 = Long.valueOf(5L);
        l8 = null;
        Long l16 = l15;
        TopicPartition $minus$greater$extension_$this3 = new TopicPartition("foo", 2);
        Object var7_10 = null;
        l16 = null;
        objectArray[2] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y8);
        Long l17 = l7 = Long.valueOf(10L);
        l7 = null;
        Long l18 = l17;
        TopicPartition $minus$greater$extension_$this4 = new TopicPartition("bar", 7);
        Object var9_13 = null;
        l18 = null;
        objectArray[3] = new Tuple2((Object)$minus$greater$extension_$this4, (Object)$minus$greater$extension_y7);
        Long l19 = l6 = Long.valueOf(5L);
        l6 = null;
        Long l20 = l19;
        TopicPartition $minus$greater$extension_$this5 = new TopicPartition("foo", 3);
        Object var11_16 = null;
        l20 = null;
        objectArray[4] = new Tuple2((Object)$minus$greater$extension_$this5, (Object)$minus$greater$extension_y6);
        Long l21 = l5 = Long.valueOf(10L);
        l5 = null;
        Long l22 = l21;
        TopicPartition $minus$greater$extension_$this6 = new TopicPartition("bar", 8);
        Object var13_19 = null;
        l22 = null;
        objectArray[5] = new Tuple2((Object)$minus$greater$extension_$this6, (Object)$minus$greater$extension_y5);
        Long l23 = l4 = Long.valueOf(5L);
        l4 = null;
        Long l24 = l23;
        TopicPartition $minus$greater$extension_$this7 = new TopicPartition("foo", 4);
        Object var15_22 = null;
        l24 = null;
        objectArray[6] = new Tuple2((Object)$minus$greater$extension_$this7, (Object)$minus$greater$extension_y4);
        Long l25 = l3 = Long.valueOf(10L);
        l3 = null;
        Long l26 = l25;
        TopicPartition $minus$greater$extension_$this8 = new TopicPartition("bar", 9);
        Object var17_25 = null;
        l26 = null;
        objectArray[7] = new Tuple2((Object)$minus$greater$extension_$this8, (Object)$minus$greater$extension_y3);
        Long l27 = l2 = Long.valueOf(5L);
        l2 = null;
        Long l28 = l27;
        TopicPartition $minus$greater$extension_$this9 = new TopicPartition("foo", 5);
        Object var19_28 = null;
        l28 = null;
        objectArray[8] = new Tuple2((Object)$minus$greater$extension_$this9, (Object)$minus$greater$extension_y2);
        Long l29 = l = Long.valueOf(10L);
        l = null;
        Long l30 = l29;
        TopicPartition $minus$greater$extension_$this10 = new TopicPartition("bar", 10);
        Object var21_31 = null;
        l30 = null;
        objectArray[9] = new Tuple2((Object)$minus$greater$extension_$this10, (Object)$minus$greater$extension_y);
        Map offsets = (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        checkpoint.write(offsets);
        Assert.assertEquals((Object)offsets, (Object)checkpoint.read());
    }

    @Test
    public void shouldReturnEmptyMapForEmptyFile() {
        OffsetCheckpointFile checkpoint = new OffsetCheckpointFile(TestUtils.tempFile(), null);
        Assert.assertEquals((Object)Map$.MODULE$.apply((Seq)Nil$.MODULE$), (Object)checkpoint.read());
        checkpoint.write((Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$));
        Assert.assertEquals((Object)Map$.MODULE$.apply((Seq)Nil$.MODULE$), (Object)checkpoint.read());
    }

    /*
     * WARNING - void declaration
     */
    @Test(expected=KafkaStorageException.class)
    public void shouldThrowIfVersionIsNotRecognised() {
        void $minus$greater$extension_y;
        Long l;
        File file;
        File file2 = file = TestUtils.tempFile();
        file = null;
        File file3 = file2;
        LogDirFailureChannel logDirFailureChannel = new LogDirFailureChannel(10);
        CheckpointFile checkpointFile = new CheckpointFile(file3, OffsetCheckpointFile$.MODULE$.CurrentVersion() + 1, (CheckpointFileFormatter)OffsetCheckpointFile.Formatter$.MODULE$, logDirFailureChannel, file3.getParent());
        Object[] objectArray = new Tuple2[1];
        Long l2 = l = Long.valueOf(10L);
        l = null;
        Long l3 = l2;
        TopicPartition $minus$greater$extension_$this = new TopicPartition("foo", 5);
        Object var4_7 = null;
        l3 = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        checkpointFile.write((Iterable)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
        new OffsetCheckpointFile(checkpointFile.file(), logDirFailureChannel).read();
    }

    @Test
    public void testLazyOffsetCheckpoint() {
        Long l;
        Long l2;
        String logDir = "/tmp/kafka-logs";
        OffsetCheckpointFile mockCheckpointFile = (OffsetCheckpointFile)Mockito.mock(OffsetCheckpointFile.class);
        Object[] objectArray = new Tuple2[1];
        objectArray[0] = new Tuple2((Object)logDir, (Object)mockCheckpointFile);
        LazyOffsetCheckpoints lazyCheckpoints = new LazyOffsetCheckpoints((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
        ((OffsetCheckpointFile)Mockito.verify((Object)mockCheckpointFile, (VerificationMode)Mockito.never())).read();
        TopicPartition partition0 = new TopicPartition("foo", 0);
        TopicPartition partition1 = new TopicPartition("foo", 1);
        TopicPartition partition2 = new TopicPartition("foo", 2);
        Object[] objectArray2 = new Tuple2[2];
        Long l3 = l2 = Long.valueOf(1000L);
        l2 = null;
        Long $minus$greater$extension_y = l3;
        Object var7_8 = null;
        objectArray2[0] = new Tuple2((Object)partition0, (Object)$minus$greater$extension_y);
        Long l4 = l = Long.valueOf(2000L);
        l = null;
        Long $minus$greater$extension_y2 = l4;
        Object var8_10 = null;
        objectArray2[1] = new Tuple2((Object)partition1, (Object)$minus$greater$extension_y2);
        Mockito.when((Object)mockCheckpointFile.read()).thenReturn(Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray2)));
        Assert.assertEquals((Object)new Some((Object)1000L), (Object)lazyCheckpoints.fetch(logDir, partition0));
        Assert.assertEquals((Object)new Some((Object)2000L), (Object)lazyCheckpoints.fetch(logDir, partition1));
        Assert.assertEquals((Object)None$.MODULE$, (Object)lazyCheckpoints.fetch(logDir, partition2));
        ((OffsetCheckpointFile)Mockito.verify((Object)mockCheckpointFile, (VerificationMode)Mockito.times((int)1))).read();
    }

    @Test
    public void testLazyOffsetCheckpointFileInvalidLogDir() {
        String logDir = "/tmp/kafka-logs";
        OffsetCheckpointFile mockCheckpointFile = (OffsetCheckpointFile)Mockito.mock(OffsetCheckpointFile.class);
        Object[] objectArray = new Tuple2[1];
        objectArray[0] = new Tuple2((Object)logDir, (Object)mockCheckpointFile);
        LazyOffsetCheckpoints lazyCheckpoints = new LazyOffsetCheckpoints((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
        Assertions$.MODULE$.assertThrows((Function0 & Serializable)() -> lazyCheckpoints.fetch("/invalid/kafka-logs", new TopicPartition("foo", 0)), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("OffsetCheckpointFileTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 132));
    }
}

