/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import kafka.cluster.BrokerEndPoint;
import kafka.common.ClientIdAndBroker;
import kafka.log.LogAppendInfo;
import kafka.server.AbstractFetcherThread$;
import kafka.server.FailedPartitions;
import kafka.server.FetcherLagStats;
import kafka.server.FetcherStats;
import kafka.server.Fetching$;
import kafka.server.InitialFetchState;
import kafka.server.OffsetAndEpoch;
import kafka.server.OffsetTruncationState;
import kafka.server.PartitionFetchState;
import kafka.server.PartitionFetchState$;
import kafka.server.ReplicaState;
import kafka.server.Truncating$;
import kafka.utils.CoreUtils$;
import kafka.utils.DelayedItem;
import kafka.utils.ShutdownableThread;
import org.apache.kafka.common.InvalidRecordException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.CorruptRecordException;
import org.apache.kafka.common.errors.FencedLeaderEpochException;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.errors.NotLeaderForPartitionException;
import org.apache.kafka.common.errors.UnknownLeaderEpochException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.internals.PartitionStates;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.requests.EpochEndOffset;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.OffsetsForLeaderEpochRequest;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Growable;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0011]e!\u0002.\\\u0003\u0003\u0001\u0007\"C4\u0001\u0005\u0003\u0005\u000b\u0011\u00025v\u0011!1\bA!A!\u0002\u0013A\u0007\u0002C<\u0001\u0005\u000b\u0007I\u0011\u0001=\t\u0011}\u0004!\u0011!Q\u0001\neD!\"!\u0001\u0001\u0005\u0003\u0005\u000b\u0011BA\u0002\u0011)\tY\u0001\u0001B\u0001B\u0003%\u0011Q\u0002\u0005\r\u0003+\u0001!\u0011!Q\u0001\n\u0005]\u0011Q\u0004\u0005\b\u0003?\u0001A\u0011AA\u0011\u000b\u0019\t\t\u0004\u0001\u0001\u00024\u00151\u0011\u0011\r\u0001\u0001\u0003GB\u0011\"a\u001c\u0001\u0005\u0004%I!!\u001d\t\u0011\u0005\u0015\u0005\u0001)A\u0005\u0003gB\u0011\"a\"\u0001\u0005\u0004%I!!#\t\u0011\u0005\r\u0006\u0001)A\u0005\u0003\u0017C\u0011\"!*\u0001\u0005\u0004%I!a*\t\u0011\u0005=\u0006\u0001)A\u0005\u0003SC\u0011\"!-\u0001\u0005\u0004%I!a-\t\u0011\u0005}\u0006\u0001)A\u0005\u0003kC\u0011\"!1\u0001\u0005\u0004%\t!a1\t\u0011\u0005-\u0007\u0001)A\u0005\u0003\u000bD\u0011\"!4\u0001\u0005\u0004%\t!a4\t\u0011\u0005]\u0007\u0001)A\u0005\u0003#Dq!!7\u0001\r#\tY\u000eC\u0004\u0003\u000e\u00011\tBa\u0004\t\u000f\t\r\u0002A\"\u0005\u0003&!9!Q\u0006\u0001\u0007\u0012\t=\u0002bBB<\u0001\u0019E1\u0011\u0010\u0005\b\u0007\u007f\u0002a\u0011CBA\u0011\u001d\u0019)\t\u0001D\t\u0007\u000fCqaa&\u0001\r#\u0019I\nC\u0004\u0004,\u00021\tb!,\t\u000f\rm\u0006A\"\u0005\u0004>\"91Q\u0019\u0001\u0007\u0012\r\u001d\u0007bBBg\u0001\u0019E1q\u001a\u0005\b\u0007#\u0004A\u0011IBj\u0011\u001d\u0019)\u000e\u0001C!\u0007'Dqaa6\u0001\t\u0013\u0019\u0019\u000eC\u0004\u0004Z\u0002!Iaa7\t\u000f\r%\b\u0001\"\u0003\u0004l\"91q\u001e\u0001\u0005\n\rM\u0007bBBy\u0001\u0011%11\u001f\u0005\b\u0007s\u0004A\u0011BB~\u0011!!\t\u0001\u0001C\u00017\u0012\r\u0001b\u0002C\u0004\u0001\u0011%A\u0011\u0002\u0005\b\t'\u0001A\u0011\u0002C\u000b\u0011\u001d!Y\u0002\u0001C\u0005\t;Aq\u0001\"\n\u0001\t\u0003!9\u0003C\u0004\u00050\u0001!I\u0001\"\r\t\u000f\u0011U\u0002\u0001\"\u0001\u00058!9Aq\b\u0001\u0005\n\u0011\u0005\u0003b\u0002C$\u0001\u0011%A\u0011\n\u0005\b\t#\u0002A\u0011\u0002C*\u0011\u001d!Y\u0006\u0001C\t\t;Bq\u0001b\u0019\u0001\t\u0003!)\u0007C\u0004\u0005n\u0001!\t\u0001b\u001c\t\u000f\u0011U\u0004\u0001\"\u0001\u0004\u0002!AA\u0011\f\u0001\u0005\u0002m#9\b\u0003\u0005\u0005~\u0001!\ta\u0017C@\u0011\u001d!I\t\u0001C\t\t\u0017;qA!\u000e\\\u0011\u0003\u00119D\u0002\u0004[7\"\u0005!\u0011\b\u0005\b\u0003?iD\u0011\u0001B!\r\u0019\u0011\u0019%\u0010!\u0003F!Q!\u0011M \u0003\u0016\u0004%\tAa\u0019\t\u0015\tmtH!E!\u0002\u0013\u0011)\u0007\u0003\u0006\u0003~}\u0012)\u001a!C\u0001\u0005\u007fB!B!$@\u0005#\u0005\u000b\u0011\u0002BA\u0011\u001d\tyb\u0010C\u0001\u0005\u001fC\u0011B!'@\u0003\u0003%\tAa'\t\u0013\t%v(%A\u0005\u0002\t-\u0006\"\u0003Bc\u007fE\u0005I\u0011\u0001Bd\u0011%\u0011ymPA\u0001\n\u0003\u0012\t\u000eC\u0005\u0003^~\n\t\u0011\"\u0001\u0003`\"I!\u0011] \u0002\u0002\u0013\u0005!1\u001d\u0005\n\u0005S|\u0014\u0011!C!\u0005WD\u0011Ba=@\u0003\u0003%\tA!>\t\u0013\tex(!A\u0005B\tm\b\"\u0003B\u0000\u007f\u0005\u0005I\u0011IB\u0001\u0011%\u0019\u0019aPA\u0001\n\u0003\u001a)\u0001C\u0005\u0004\b}\n\t\u0011\"\u0011\u0004\n\u001dI1QB\u001f\u0002\u0002#\u00051q\u0002\u0004\n\u0005\u0007j\u0014\u0011!E\u0001\u0007#Aq!a\bS\t\u0003\u0019i\u0002C\u0005\u0004\u0004I\u000b\t\u0011\"\u0012\u0004\u0006!I1q\u0004*\u0002\u0002\u0013\u00055\u0011\u0005\u0005\n\u0007_\u0011\u0016\u0011!CA\u0007cA\u0011ba\u0012S\u0003\u0003%Ia!\u0013\t\u0013\rES(%A\u0005\u0002\rM\u0003\"CB,{E\u0005I\u0011AB-\u0005U\t%m\u001d;sC\u000e$h)\u001a;dQ\u0016\u0014H\u000b\u001b:fC\u0012T!\u0001X/\u0002\rM,'O^3s\u0015\u0005q\u0016!B6bM.\f7\u0001A\n\u0003\u0001\u0005\u0004\"AY3\u000e\u0003\rT!\u0001Z/\u0002\u000bU$\u0018\u000e\\:\n\u0005\u0019\u001c'AE*ikR$wn\u001e8bE2,G\u000b\u001b:fC\u0012\fAA\\1nKB\u0011\u0011N\u001d\b\u0003UB\u0004\"a\u001b8\u000e\u00031T!!\\0\u0002\rq\u0012xn\u001c;?\u0015\u0005y\u0017!B:dC2\f\u0017BA9o\u0003\u0019\u0001&/\u001a3fM&\u00111\u000f\u001e\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005Et\u0017BA4f\u0003!\u0019G.[3oi&#\u0017\u0001D:pkJ\u001cWM\u0011:pW\u0016\u0014X#A=\u0011\u0005ilX\"A>\u000b\u0005ql\u0016aB2mkN$XM]\u0005\u0003}n\u0014aB\u0011:pW\u0016\u0014XI\u001c3Q_&tG/A\u0007t_V\u00148-\u001a\"s_.,'\u000fI\u0001\u0011M\u0006LG.\u001a3QCJ$\u0018\u000e^5p]N\u0004B!!\u0002\u0002\b5\t1,C\u0002\u0002\nm\u0013\u0001CR1jY\u0016$\u0007+\u0019:uSRLwN\\:\u0002\u001d\u0019,Go\u00195CC\u000e\\wJ\u001a4NgB!\u0011qBA\t\u001b\u0005q\u0017bAA\n]\n\u0019\u0011J\u001c;\u0002\u001f%\u001c\u0018J\u001c;feJ,\b\u000f^5cY\u0016\u0004B!a\u0004\u0002\u001a%\u0019\u00111\u00048\u0003\u000f\t{w\u000e\\3b]&\u0019\u0011QC3\u0002\rqJg.\u001b;?)9\t\u0019#!\n\u0002(\u0005%\u00121FA\u0017\u0003_\u00012!!\u0002\u0001\u0011\u00159\u0007\u00021\u0001i\u0011\u00151\b\u00021\u0001i\u0011\u00159\b\u00021\u0001z\u0011\u001d\t\t\u0001\u0003a\u0001\u0003\u0007A\u0011\"a\u0003\t!\u0003\u0005\r!!\u0004\t\u0013\u0005U\u0001\u0002%AA\u0002\u0005]!!\u0003$fi\u000eDG)\u0019;b!\u0019\t)$a\u0014\u0002V9!\u0011qGA&\u001b\t\tID\u0003\u0003\u0002<\u0005u\u0012\u0001\u0003:fcV,7\u000f^:\u000b\t\u0005}\u0012\u0011I\u0001\u0007G>lWn\u001c8\u000b\u0007y\u000b\u0019E\u0003\u0003\u0002F\u0005\u001d\u0013AB1qC\u000eDWM\u0003\u0002\u0002J\u0005\u0019qN]4\n\t\u00055\u0013\u0011H\u0001\u000e\r\u0016$8\r\u001b*fgB|gn]3\n\t\u0005E\u00131\u000b\u0002\u000e!\u0006\u0014H/\u001b;j_:$\u0015\r^1\u000b\t\u00055\u0013\u0011\b\t\u0005\u0003/\ni&\u0004\u0002\u0002Z)!\u00111LA\u001f\u0003\u0019\u0011XmY8sI&!\u0011qLA-\u0005\u001d\u0011VmY8sIN\u0014\u0011\"\u00129pG\"$\u0015\r^1\u0011\t\u0005\u0015\u00141\u000e\b\u0005\u0003o\t9'\u0003\u0003\u0002j\u0005e\u0012\u0001H(gMN,Go\u001d$pe2+\u0017\rZ3s\u000bB|7\r\u001b*fcV,7\u000f^\u0005\u0005\u0003#\niG\u0003\u0003\u0002j\u0005e\u0012a\u00049beRLG/[8o'R\fG/Z:\u0016\u0005\u0005M\u0004CBA;\u0003w\ny(\u0004\u0002\u0002x)!\u0011\u0011PA\u001f\u0003%Ig\u000e^3s]\u0006d7/\u0003\u0003\u0002~\u0005]$a\u0004)beRLG/[8o'R\fG/Z:\u0011\t\u0005\u0015\u0011\u0011Q\u0005\u0004\u0003\u0007[&a\u0005)beRLG/[8o\r\u0016$8\r[*uCR,\u0017\u0001\u00059beRLG/[8o'R\fG/Z:!\u0003A\u0001\u0018M\u001d;ji&|g.T1q\u0019>\u001c7.\u0006\u0002\u0002\fB!\u0011QRAP\u001b\t\tyI\u0003\u0003\u0002\u0012\u0006M\u0015!\u00027pG.\u001c(\u0002BAK\u0003/\u000b!bY8oGV\u0014(/\u001a8u\u0015\u0011\tI*a'\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0003;\u000bAA[1wC&!\u0011\u0011UAH\u00055\u0011V-\u001a8ue\u0006tG\u000fT8dW\u0006\t\u0002/\u0019:uSRLwN\\'ba2{7m\u001b\u0011\u0002!A\f'\u000f^5uS>tW*\u00199D_:$WCAAU!\u0011\ti)a+\n\t\u00055\u0016q\u0012\u0002\n\u0007>tG-\u001b;j_:\f\u0011\u0003]1si&$\u0018n\u001c8NCB\u001cuN\u001c3!\u0003!iW\r\u001e:jG&#WCAA[!\u0011\t9,a/\u000e\u0005\u0005e&bAA ;&!\u0011QXA]\u0005E\u0019E.[3oi&#\u0017I\u001c3Ce>\\WM]\u0001\n[\u0016$(/[2JI\u0002\nABZ3uG\",'o\u0015;biN,\"!!2\u0011\t\u0005\u0015\u0011qY\u0005\u0004\u0003\u0013\\&\u0001\u0004$fi\u000eDWM]*uCR\u001c\u0018!\u00044fi\u000eDWM]*uCR\u001c\b%A\bgKR\u001c\u0007.\u001a:MC\u001e\u001cF/\u0019;t+\t\t\t\u000e\u0005\u0003\u0002\u0006\u0005M\u0017bAAk7\nya)\u001a;dQ\u0016\u0014H*Y4Ti\u0006$8/\u0001\tgKR\u001c\u0007.\u001a:MC\u001e\u001cF/\u0019;tA\u0005!\u0002O]8dKN\u001c\b+\u0019:uSRLwN\u001c#bi\u0006$\u0002\"!8\u0002p\u0006m(Q\u0001\t\u0007\u0003\u001f\ty.a9\n\u0007\u0005\u0005hN\u0001\u0004PaRLwN\u001c\t\u0005\u0003K\fY/\u0004\u0002\u0002h*\u0019\u0011\u0011^/\u0002\u00071|w-\u0003\u0003\u0002n\u0006\u001d(!\u0004'pO\u0006\u0003\b/\u001a8e\u0013:4w\u000eC\u0004\u0002r^\u0001\r!a=\u0002\u001dQ|\u0007/[2QCJ$\u0018\u000e^5p]B!\u0011Q_A|\u001b\t\ti$\u0003\u0003\u0002z\u0006u\"A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0005\b\u0003{<\u0002\u0019AA\u0000\u0003-1W\r^2i\u001f\u001a47/\u001a;\u0011\t\u0005=!\u0011A\u0005\u0004\u0005\u0007q'\u0001\u0002'p]\u001eDqAa\u0002\u0018\u0001\u0004\u0011I!A\u0007qCJ$\u0018\u000e^5p]\u0012\u000bG/\u0019\t\u0004\u0005\u0017IQ\"\u0001\u0001\u0002\u0011Q\u0014XO\\2bi\u0016$bA!\u0005\u0003\u0018\te\u0001\u0003BA\b\u0005'I1A!\u0006o\u0005\u0011)f.\u001b;\t\u000f\u0005E\b\u00041\u0001\u0002t\"9!1\u0004\rA\u0002\tu\u0011a\u0004;sk:\u001c\u0017\r^5p]N#\u0018\r^3\u0011\t\u0005\u0015!qD\u0005\u0004\u0005CY&!F(gMN,G\u000f\u0016:v]\u000e\fG/[8o'R\fG/Z\u0001\u0018iJ,hnY1uK\u001a+H\u000e\\=B]\u0012\u001cF/\u0019:u\u0003R$bA!\u0005\u0003(\t%\u0002bBAy3\u0001\u0007\u00111\u001f\u0005\b\u0005WI\u0002\u0019AA\u0000\u0003\u0019ygMZ:fi\u0006Q!-^5mI\u001a+Go\u00195\u0015\t\tE2Q\u000e\t\u0006\u0005gy4Q\f\b\u0004\u0003\u000ba\u0014!F!cgR\u0014\u0018m\u0019;GKR\u001c\u0007.\u001a:UQJ,\u0017\r\u001a\t\u0004\u0003\u000bi4cA\u001f\u0003<A!\u0011q\u0002B\u001f\u0013\r\u0011yD\u001c\u0002\u0007\u0003:L(+\u001a4\u0015\u0005\t]\"\u0001\u0006*fgVdGoV5uQB\u000b'\u000f^5uS>t7/\u0006\u0003\u0003H\t%4cB \u0003<\t%#q\n\t\u0005\u0003\u001f\u0011Y%C\u0002\u0003N9\u0014q\u0001\u0015:pIV\u001cG\u000f\u0005\u0003\u0003R\tmc\u0002\u0002B*\u0005/r1a\u001bB+\u0013\u0005y\u0017b\u0001B-]\u00069\u0001/Y2lC\u001e,\u0017\u0002\u0002B/\u0005?\u0012AbU3sS\u0006d\u0017N_1cY\u0016T1A!\u0017o\u0003\u0019\u0011Xm];miV\u0011!Q\r\t\u0005\u0005O\u0012I\u0007\u0004\u0001\u0005\u000f\t-tH1\u0001\u0003n\t\t!+\u0005\u0003\u0003p\tU\u0004\u0003BA\b\u0005cJ1Aa\u001do\u0005\u001dqu\u000e\u001e5j]\u001e\u0004B!a\u0004\u0003x%\u0019!\u0011\u00108\u0003\u0007\u0005s\u00170A\u0004sKN,H\u000e\u001e\u0011\u0002'A\f'\u000f^5uS>t7oV5uQ\u0016\u0013(o\u001c:\u0016\u0005\t\u0005\u0005C\u0002BB\u0005\u0013\u000b\u00190\u0004\u0002\u0003\u0006*\u0019!q\u00118\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0003\f\n\u0015%aA*fi\u0006!\u0002/\u0019:uSRLwN\\:XSRDWI\u001d:pe\u0002\"bA!%\u0003\u0016\n]\u0005#\u0002BJ\u007f\t\u0015T\"A\u001f\t\u000f\t\u0005D\t1\u0001\u0003f!9!Q\u0010#A\u0002\t\u0005\u0015\u0001B2paf,BA!(\u0003$R1!q\u0014BS\u0005O\u0003RAa%@\u0005C\u0003BAa\u001a\u0003$\u00129!1N#C\u0002\t5\u0004\"\u0003B1\u000bB\u0005\t\u0019\u0001BQ\u0011%\u0011i(\u0012I\u0001\u0002\u0004\u0011\t)\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\t\t5&1Y\u000b\u0003\u0005_SCA!\u001a\u00032.\u0012!1\u0017\t\u0005\u0005k\u0013y,\u0004\u0002\u00038*!!\u0011\u0018B^\u0003%)hn\u00195fG.,GMC\u0002\u0003>:\f!\"\u00198o_R\fG/[8o\u0013\u0011\u0011\tMa.\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rB\u0004\u0003l\u0019\u0013\rA!\u001c\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU!!\u0011\u001aBg+\t\u0011YM\u000b\u0003\u0003\u0002\nEFa\u0002B6\u000f\n\u0007!QN\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\tM\u0007\u0003\u0002Bk\u00057l!Aa6\u000b\t\te\u00171T\u0001\u0005Y\u0006tw-C\u0002t\u0005/\fA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!!\u0004\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!!Q\u000fBs\u0011%\u00119OSA\u0001\u0002\u0004\ti!A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0005[\u0004bAa!\u0003p\nU\u0014\u0002\u0002By\u0005\u000b\u0013\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u0011q\u0003B|\u0011%\u00119\u000fTA\u0001\u0002\u0004\u0011)(\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,G\u0003\u0002Bj\u0005{D\u0011Ba:N\u0003\u0003\u0005\r!!\u0004\u0002\u0011!\f7\u000f[\"pI\u0016$\"!!\u0004\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"Aa5\u0002\r\u0015\fX/\u00197t)\u0011\t9ba\u0003\t\u0013\t\u001d\b+!AA\u0002\tU\u0014\u0001\u0006*fgVdGoV5uQB\u000b'\u000f^5uS>t7\u000fE\u0002\u0003\u0014J\u001bRA\u0015B\u001e\u0007'\u0001Ba!\u0006\u0004\u001c5\u00111q\u0003\u0006\u0005\u00073\tY*\u0001\u0002j_&!!QLB\f)\t\u0019y!A\u0003baBd\u00170\u0006\u0003\u0004$\r%BCBB\u0013\u0007W\u0019i\u0003E\u0003\u0003\u0014~\u001a9\u0003\u0005\u0003\u0003h\r%Ba\u0002B6+\n\u0007!Q\u000e\u0005\b\u0005C*\u0006\u0019AB\u0014\u0011\u001d\u0011i(\u0016a\u0001\u0005\u0003\u000bq!\u001e8baBd\u00170\u0006\u0003\u00044\r}B\u0003BB\u001b\u0007\u0003\u0002b!a\u0004\u0002`\u000e]\u0002\u0003CA\b\u0007s\u0019iD!!\n\u0007\rmbN\u0001\u0004UkBdWM\r\t\u0005\u0005O\u001ay\u0004B\u0004\u0003lY\u0013\rA!\u001c\t\u0013\r\rc+!AA\u0002\r\u0015\u0013a\u0001=%aA)!1S \u0004>\u0005aqO]5uKJ+\u0007\u000f\\1dKR\u001111\n\t\u0005\u0005+\u001ci%\u0003\u0003\u0004P\t]'AB(cU\u0016\u001cG/A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%N\u000b\u0003\u0007+RC!!\u0004\u00032\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIY*\"aa\u0017+\t\u0005]!\u0011\u0017\t\u0007\u0003\u001f\tyna\u0018\u0011\t\r\u00054q\r\b\u0005\u0003o\u0019\u0019'\u0003\u0003\u0004f\u0005e\u0012\u0001\u0004$fi\u000eD'+Z9vKN$\u0018\u0002BB5\u0007W\u0012qAQ;jY\u0012,'O\u0003\u0003\u0004f\u0005e\u0002bBB85\u0001\u00071\u0011O\u0001\ra\u0006\u0014H/\u001b;j_:l\u0015\r\u001d\t\t\u0005\u0007\u001b\u0019(a=\u0002\u0000%!1Q\u000fBC\u0005\ri\u0015\r]\u0001\fY\u0006$Xm\u001d;Fa>\u001c\u0007\u000e\u0006\u0003\u0004|\ru\u0004CBA\b\u0003?\fi\u0001C\u0004\u0002rn\u0001\r!a=\u0002\u00191|w-\u00128e\u001f\u001a47/\u001a;\u0015\t\u0005}81\u0011\u0005\b\u0003cd\u0002\u0019AAz\u0003E)g\u000eZ(gMN,GOR8s\u000bB|7\r\u001b\u000b\u0007\u0007\u0013\u001b\tja%\u0011\r\u0005=\u0011q\\BF!\u0011\t)a!$\n\u0007\r=5L\u0001\bPM\u001a\u001cX\r^!oI\u0016\u0003xn\u00195\t\u000f\u0005EX\u00041\u0001\u0002t\"91QS\u000fA\u0002\u00055\u0011!B3q_\u000eD\u0017\u0001\u00064fi\u000eDW\t]8dQ\u0016sGm\u00144gg\u0016$8\u000f\u0006\u0003\u0004\u001c\u000e\r\u0006\u0003\u0003BB\u0007g\n\u0019p!(\u0011\t\u0005]2qT\u0005\u0005\u0007C\u000bID\u0001\bFa>\u001c\u0007.\u00128e\u001f\u001a47/\u001a;\t\u000f\r\u0015f\u00041\u0001\u0004(\u0006Q\u0001/\u0019:uSRLwN\\:\u0011\u0011\t\r51OAz\u0007S\u00032Aa\u0003\u000b\u0003=1W\r^2i\rJ|W\u000eT3bI\u0016\u0014H\u0003BBX\u0007o\u0003bAa!\u00042\u000eU\u0016\u0002BBZ\u0005\u000b\u00131aU3r!!\tya!\u000f\u0002t\n%\u0001bBB]?\u0001\u00071qL\u0001\rM\u0016$8\r\u001b*fcV,7\u000f^\u0001\u001eM\u0016$8\r[#be2LWm\u001d;PM\u001a\u001cX\r\u001e$s_6dU-\u00193feR1\u0011q`B`\u0007\u0003Dq!!=!\u0001\u0004\t\u0019\u0010C\u0004\u0004D\u0002\u0002\r!!\u0004\u0002%\r,(O]3oi2+\u0017\rZ3s\u000bB|7\r[\u0001\u001cM\u0016$8\r\u001b'bi\u0016\u001cHo\u00144gg\u0016$hI]8n\u0019\u0016\fG-\u001a:\u0015\r\u0005}8\u0011ZBf\u0011\u001d\t\t0\ta\u0001\u0003gDqaa1\"\u0001\u0004\ti!A\u0010jg>3gm]3u\r>\u0014H*Z1eKJ,\u0005o\\2i'V\u0004\bo\u001c:uK\u0012,\"!a\u0006\u0002\u0011MDW\u000f\u001e3po:$\"A!\u0005\u0002\r\u0011|wk\u001c:l\u0003)i\u0017-\u001f2f\r\u0016$8\r[\u0001\u001bQ\u0006tG\r\\3QCJ$\u0018\u000e^5p]N<\u0016\u000e\u001e5FeJ|'o\u001d\u000b\u0007\u0005#\u0019in!:\t\u000f\r\u0015f\u00051\u0001\u0004`B1!\u0011KBq\u0003gLAaa9\u0003`\tA\u0011\n^3sC\ndW\r\u0003\u0004\u0004h\u001a\u0002\r\u0001[\u0001\u000b[\u0016$\bn\u001c3OC6,\u0017!\u00074fi\u000eDGK];oG\u0006$\u0018N\\4QCJ$\u0018\u000e^5p]N$\"a!<\u0011\u0011\u0005=1\u0011HBT\u0005\u0003\u000bQ\"\\1zE\u0016$&/\u001e8dCR,\u0017A\u00033p)J,hnY1uKR1\u0011qCB{\u0007oDq!!=*\u0001\u0004\t\u0019\u0010C\u0004\u0003\u001c%\u0002\rA!\b\u00023Q\u0014XO\\2bi\u0016$v.\u00129pG\",e\u000eZ(gMN,Go\u001d\u000b\u0005\u0005#\u0019i\u0010C\u0004\u0004\u0000*\u0002\raa*\u000231\fG/Z:u\u000bB|7\r[:G_J\u0004\u0016M\u001d;ji&|gn]\u0001\u0018iJ,hnY1uKR{\u0007*[4i/\u0006$XM]7be.$BA!\u0005\u0005\u0006!91QU\u0016A\u0002\t\u0005\u0015AH7bs\n,GK];oG\u0006$X\rV8Fa>\u001c\u0007.\u00128e\u001f\u001a47/\u001a;t)\u0011!Y\u0001b\u0004\u0011\u000b\tMr\b\"\u0004\u0011\u0011\t\r51OAz\u0005;Aq\u0001\"\u0005-\u0001\u0004\u0019Y*A\u0007gKR\u001c\u0007.\u001a3Fa>\u001c\u0007n]\u0001\u0012_:\u0004\u0016M\u001d;ji&|gNR3oG\u0016$G\u0003\u0002B\t\t/Aq\u0001\"\u0007.\u0001\u0004\t\u00190\u0001\u0002ua\u0006\u0019\u0002O]8dKN\u001ch)\u001a;dQJ+\u0017/^3tiR1!\u0011\u0003C\u0010\tGAq\u0001\"\t/\u0001\u0004\u0019\t(A\u0006gKR\u001c\u0007n\u0015;bi\u0016\u001c\bbBB]]\u0001\u00071qL\u0001\u001c[\u0006\u00148\u000eU1si&$\u0018n\u001c8t\r>\u0014HK];oG\u0006$\u0018n\u001c8\u0015\r\tEA\u0011\u0006C\u0016\u0011\u001d\t\tp\fa\u0001\u0003gDq\u0001\"\f0\u0001\u0004\ty0\u0001\tueVt7-\u0019;j_:|eMZ:fi\u0006\u0019R.\u0019:l!\u0006\u0014H/\u001b;j_:4\u0015-\u001b7fIR!!\u0011\u0003C\u001a\u0011\u001d\t\t\u0010\ra\u0001\u0003g\fQ\"\u00193e!\u0006\u0014H/\u001b;j_:\u001cH\u0003\u0002B\t\tsAq\u0001b\u000f2\u0001\u0004!i$\u0001\nj]&$\u0018.\u00197GKR\u001c\u0007n\u0015;bi\u0016\u001c\b\u0003\u0003BB\u0007g\n\u0019pa#\u0002_U\u0004H-\u0019;f\r\u0016$8\r[(gMN,G/\u00118e\u001b\u0006L(-Z'be.$&/\u001e8dCRLwN\\\"p[BdW\r^3\u0015\t\tEA1\t\u0005\b\t\u000b\u0012\u0004\u0019\u0001C\u0007\u000311W\r^2i\u001f\u001a47/\u001a;t\u0003a9W\r^(gMN,G\u000f\u0016:v]\u000e\fG/[8o'R\fG/\u001a\u000b\u0007\u0005;!Y\u0005\"\u0014\t\u000f\u0011e1\u00071\u0001\u0002t\"9AqJ\u001aA\u0002\ru\u0015!\u00057fC\u0012,'/\u00129pG\"|eMZ:fi\u0006)\u0002.\u00198eY\u0016|U\u000f^(g%\u0006tw-Z#se>\u0014HCBA\f\t+\"9\u0006C\u0004\u0002rR\u0002\r!a=\t\u000f\u0011eC\u00071\u0001\u0002\u0000\u0005Qa-\u001a;dQN#\u0018\r^3\u0002-\u0019,Go\u00195PM\u001a\u001cX\r^!oIR\u0013XO\\2bi\u0016$b!a@\u0005`\u0011\u0005\u0004bBAyk\u0001\u0007\u00111\u001f\u0005\b\u0007\u0007,\u0004\u0019AA\u0007\u0003=!W\r\\1z!\u0006\u0014H/\u001b;j_:\u001cHC\u0002B\t\tO\"I\u0007C\u0004\u0004&Z\u0002\raa8\t\u000f\u0011-d\u00071\u0001\u0002\u0000\u0006)A-\u001a7bs\u0006\u0001\"/Z7pm\u0016\u0004\u0016M\u001d;ji&|gn\u001d\u000b\u0005\u0005#!\t\bC\u0004\u0005t]\u0002\rA!!\u0002\u001fQ|\u0007/[2QCJ$\u0018\u000e^5p]N\fa\u0002]1si&$\u0018n\u001c8D_VtG\u000f\u0006\u0003\u0005z\u0011m\u0004CBA\b\u0003?\fy\bC\u0004\u0002rf\u0002\r!a=\u0002)A\f'\u000f^5uS>t7/\u00118e\u001f\u001a47/\u001a;t+\t!\t\t\u0005\u0005\u0003\u0004\u000eM\u00141\u001fCB!\u0011\t)\u0001\"\"\n\u0007\u0011\u001d5LA\tJ]&$\u0018.\u00197GKR\u001c\u0007n\u0015;bi\u0016\fq\u0002^8NK6|'/\u001f*fG>\u0014Hm\u001d\u000b\u0005\t\u001b#\u0019\n\u0005\u0003\u0002X\u0011=\u0015\u0002\u0002CI\u00033\u0012Q\"T3n_JL(+Z2pe\u0012\u001c\bb\u0002CKw\u0001\u0007\u0011QK\u0001\be\u0016\u001cwN\u001d3t\u0001")
public abstract class AbstractFetcherThread
extends ShutdownableThread {
    private final BrokerEndPoint sourceBroker;
    private final FailedPartitions failedPartitions;
    private final int fetchBackOffMs;
    private final PartitionStates<PartitionFetchState> partitionStates;
    private final ReentrantLock partitionMapLock;
    private final Condition partitionMapCond;
    private final ClientIdAndBroker metricId;
    private final FetcherStats fetcherStats;
    private final FetcherLagStats fetcherLagStats;

    public static boolean $lessinit$greater$default$6() {
        return AbstractFetcherThread$.MODULE$.$lessinit$greater$default$6();
    }

    public static int $lessinit$greater$default$5() {
        return AbstractFetcherThread$.MODULE$.$lessinit$greater$default$5();
    }

    public BrokerEndPoint sourceBroker() {
        return this.sourceBroker;
    }

    private PartitionStates<PartitionFetchState> partitionStates() {
        return this.partitionStates;
    }

    private ReentrantLock partitionMapLock() {
        return this.partitionMapLock;
    }

    private Condition partitionMapCond() {
        return this.partitionMapCond;
    }

    private ClientIdAndBroker metricId() {
        return this.metricId;
    }

    public FetcherStats fetcherStats() {
        return this.fetcherStats;
    }

    public FetcherLagStats fetcherLagStats() {
        return this.fetcherLagStats;
    }

    public abstract Option<LogAppendInfo> processPartitionData(TopicPartition var1, long var2, FetchResponse.PartitionData<Records> var4);

    public abstract void truncate(TopicPartition var1, OffsetTruncationState var2);

    public abstract void truncateFullyAndStartAt(TopicPartition var1, long var2);

    public abstract ResultWithPartitions<Option<FetchRequest.Builder>> buildFetch(Map<TopicPartition, PartitionFetchState> var1);

    public abstract Option<Object> latestEpoch(TopicPartition var1);

    public abstract long logEndOffset(TopicPartition var1);

    public abstract Option<OffsetAndEpoch> endOffsetForEpoch(TopicPartition var1, int var2);

    public abstract Map<TopicPartition, EpochEndOffset> fetchEpochEndOffsets(Map<TopicPartition, OffsetsForLeaderEpochRequest.PartitionData> var1);

    public abstract Seq<Tuple2<TopicPartition, FetchResponse.PartitionData<Records>>> fetchFromLeader(FetchRequest.Builder var1);

    public abstract long fetchEarliestOffsetFromLeader(TopicPartition var1, int var2);

    public abstract long fetchLatestOffsetFromLeader(TopicPartition var1, int var2);

    public abstract boolean isOffsetForLeaderEpochSupported();

    @Override
    public void shutdown() {
        this.initiateShutdown();
        CoreUtils$.MODULE$.inLock(this.partitionMapLock(), (JFunction0.mcV.sp & Serializable)() -> this.partitionMapCond().signalAll());
        this.awaitShutdown();
        this.fetcherStats().unregister();
        this.fetcherLagStats().unregister();
    }

    @Override
    public void doWork() {
        this.maybeTruncate();
        this.maybeFetch();
    }

    private void maybeFetch() {
        Tuple2 tuple2 = (Tuple2)CoreUtils$.MODULE$.inLock(this.partitionMapLock(), (Function0 & Serializable)() -> {
            Object object;
            scala.collection.mutable.Map fetchStates = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)this.partitionStates().partitionStateMap()).asScala();
            ResultWithPartitions<Option<FetchRequest.Builder>> resultWithPartitions = this.buildFetch((Map<TopicPartition, PartitionFetchState>)fetchStates);
            if (resultWithPartitions == null) {
                throw new MatchError(resultWithPartitions);
            }
            Option<FetchRequest.Builder> fetchRequestOpt = resultWithPartitions.result();
            Set<TopicPartition> partitionsWithError = resultWithPartitions.partitionsWithError();
            Tuple2 tuple2 = new Tuple2(fetchRequestOpt, partitionsWithError);
            Tuple2 tuple22 = tuple2;
            Option fetchRequestOpt2 = (Option)tuple22._1();
            Set partitionsWithError2 = (Set)tuple22._2();
            this.handlePartitionsWithErrors((Iterable<TopicPartition>)partitionsWithError2, "maybeFetch");
            if (fetchRequestOpt2.isEmpty()) {
                this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(79).append("There are no active partitions. Back off for ").append($this.fetchBackOffMs).append(" ms before sending a fetch request").toString());
                object = BoxesRunTime.boxToBoolean((boolean)this.partitionMapCond().await($this.fetchBackOffMs, TimeUnit.MILLISECONDS));
            } else {
                object = BoxedUnit.UNIT;
            }
            return new Tuple2((Object)fetchStates, (Object)fetchRequestOpt2);
        });
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        scala.collection.mutable.Map fetchStates = (scala.collection.mutable.Map)tuple2._1();
        Option fetchRequestOpt = (Option)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)fetchStates, (Object)fetchRequestOpt);
        Tuple2 tuple23 = tuple22;
        scala.collection.mutable.Map fetchStates2 = (scala.collection.mutable.Map)tuple23._1();
        Option fetchRequestOpt2 = (Option)tuple23._2();
        fetchRequestOpt2.foreach((Function1 & Serializable)fetchRequest -> {
            this.processFetchRequest((Map<TopicPartition, PartitionFetchState>)fetchStates2, fetchRequest);
            return BoxedUnit.UNIT;
        });
    }

    private void handlePartitionsWithErrors(Iterable<TopicPartition> partitions, String methodName) {
        block0: {
            if (!partitions.nonEmpty()) break block0;
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(35).append("Handling errors in ").append(methodName).append(" for partitions ").append(partitions).toString());
            this.delayPartitions(partitions, this.fetchBackOffMs);
        }
    }

    private Tuple2<Map<TopicPartition, OffsetsForLeaderEpochRequest.PartitionData>, Set<TopicPartition>> fetchTruncatingPartitions() {
        return (Tuple2)CoreUtils$.MODULE$.inLock(this.partitionMapLock(), (Function0 & Serializable)() -> {
            scala.collection.mutable.Map partitionsWithEpochs = (scala.collection.mutable.Map)Map$.MODULE$.empty();
            scala.collection.mutable.Set partitionsWithoutEpochs = (scala.collection.mutable.Set)Set$.MODULE$.empty();
            this.partitionStates().stream().forEach(new Consumer<PartitionStates.PartitionState<PartitionFetchState>>(this, partitionsWithEpochs, partitionsWithoutEpochs){
                private final /* synthetic */ AbstractFetcherThread $outer;
                private final scala.collection.mutable.Map partitionsWithEpochs$1;
                private final scala.collection.mutable.Set partitionsWithoutEpochs$1;

                public Consumer<PartitionStates.PartitionState<PartitionFetchState>> andThen(Consumer<? super PartitionStates.PartitionState<PartitionFetchState>> x$1) {
                    return Consumer.super.andThen(x$1);
                }

                /*
                 * Enabled aggressive block sorting
                 */
                public void accept(PartitionStates.PartitionState<PartitionFetchState> state) {
                    if (!((PartitionFetchState)state.value()).isTruncating()) return;
                    TopicPartition tp = state.topicPartition();
                    Option<Object> option = this.$outer.latestEpoch(tp);
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        int epoch = BoxesRunTime.unboxToInt((Object)some.value());
                        if (this.$outer.isOffsetForLeaderEpochSupported()) {
                            this.partitionsWithEpochs$1.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)new OffsetsForLeaderEpochRequest.PartitionData(Optional.of(Predef$.MODULE$.int2Integer(((PartitionFetchState)state.value()).currentLeaderEpoch())), epoch)));
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                    }
                    this.partitionsWithoutEpochs$1.$plus$eq((Object)tp);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.partitionsWithEpochs$1 = partitionsWithEpochs$1;
                    this.partitionsWithoutEpochs$1 = partitionsWithoutEpochs$1;
                }
            });
            return new Tuple2((Object)partitionsWithEpochs, (Object)partitionsWithoutEpochs);
        });
    }

    private void maybeTruncate() {
        block2: {
            Tuple2<Map<TopicPartition, OffsetsForLeaderEpochRequest.PartitionData>, Set<TopicPartition>> tuple2 = this.fetchTruncatingPartitions();
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Map partitionsWithEpochs = (Map)tuple2._1();
            Set partitionsWithoutEpochs = (Set)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)partitionsWithEpochs, (Object)partitionsWithoutEpochs);
            Tuple2 tuple23 = tuple22;
            Map partitionsWithEpochs2 = (Map)tuple23._1();
            Set partitionsWithoutEpochs2 = (Set)tuple23._2();
            if (partitionsWithEpochs2.nonEmpty()) {
                this.truncateToEpochEndOffsets((Map<TopicPartition, OffsetsForLeaderEpochRequest.PartitionData>)partitionsWithEpochs2);
            }
            if (!partitionsWithoutEpochs2.nonEmpty()) break block2;
            this.truncateToHighWatermark((Set<TopicPartition>)partitionsWithoutEpochs2);
        }
    }

    private boolean doTruncate(TopicPartition topicPartition, OffsetTruncationState truncationState) {
        boolean bl;
        try {
            this.truncate(topicPartition, truncationState);
            bl = true;
        }
        catch (KafkaStorageException e) {
            this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(30).append("Failed to truncate ").append(topicPartition).append(" at offset ").append(truncationState.offset()).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> e);
            this.markPartitionFailed(topicPartition);
            bl = false;
        }
        catch (Throwable t) {
            this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(49).append("Unexpected error occurred during truncation for ").append(topicPartition).append(" ").toString()).append(new StringBuilder(10).append("at offset ").append(truncationState.offset()).toString()).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> t);
            this.markPartitionFailed(topicPartition);
            bl = false;
        }
        return bl;
    }

    private void truncateToEpochEndOffsets(Map<TopicPartition, OffsetsForLeaderEpochRequest.PartitionData> latestEpochsForPartitions) {
        Map<TopicPartition, EpochEndOffset> endOffsets = this.fetchEpochEndOffsets(latestEpochsForPartitions);
        CoreUtils$.MODULE$.inLock(this.partitionMapLock(), (JFunction0.mcV.sp & Serializable)() -> {
            Map epochEndOffsets = (Map)endOffsets.filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherThread.$anonfun$truncateToEpochEndOffsets$2(this, latestEpochsForPartitions, x0$1)));
            ResultWithPartitions<Map<TopicPartition, OffsetTruncationState>> resultWithPartitions = this.maybeTruncateToEpochEndOffsets((Map<TopicPartition, EpochEndOffset>)epochEndOffsets);
            if (resultWithPartitions == null) {
                throw new MatchError(resultWithPartitions);
            }
            Map<TopicPartition, OffsetTruncationState> fetchOffsets = resultWithPartitions.result();
            Set<TopicPartition> partitionsWithError = resultWithPartitions.partitionsWithError();
            Tuple2 tuple2 = new Tuple2(fetchOffsets, partitionsWithError);
            Tuple2 tuple22 = tuple2;
            Map fetchOffsets2 = (Map)tuple22._1();
            Set partitionsWithError2 = (Set)tuple22._2();
            this.handlePartitionsWithErrors((Iterable<TopicPartition>)partitionsWithError2, "truncateToEpochEndOffsets");
            this.updateFetchOffsetAndMaybeMarkTruncationComplete((Map<TopicPartition, OffsetTruncationState>)fetchOffsets2);
        });
    }

    public void truncateToHighWatermark(Set<TopicPartition> partitions) {
        CoreUtils$.MODULE$.inLock(this.partitionMapLock(), (JFunction0.mcV.sp & Serializable)() -> {
            HashMap fetchOffsets = HashMap$.MODULE$.empty();
            partitions.foreach((Function1 & Serializable)tp -> {
                Object object;
                PartitionFetchState partitionState = (PartitionFetchState)this.partitionStates().stateValue(tp);
                if (partitionState != null) {
                    long highWatermark = partitionState.fetchOffset();
                    OffsetTruncationState truncationState = new OffsetTruncationState(highWatermark, true);
                    this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(46).append("Truncating partition ").append(tp).append(" to local high watermark ").append(highWatermark).toString());
                    object = this.doTruncate((TopicPartition)tp, truncationState) ? fetchOffsets.put(tp, (Object)truncationState) : BoxedUnit.UNIT;
                } else {
                    object = BoxedUnit.UNIT;
                }
                return object;
            });
            this.updateFetchOffsetAndMaybeMarkTruncationComplete((Map<TopicPartition, OffsetTruncationState>)fetchOffsets);
        });
    }

    private ResultWithPartitions<Map<TopicPartition, OffsetTruncationState>> maybeTruncateToEpochEndOffsets(Map<TopicPartition, EpochEndOffset> fetchedEpochs) {
        HashMap fetchOffsets = HashMap$.MODULE$.empty();
        HashSet partitionsWithError = HashSet$.MODULE$.empty();
        fetchedEpochs.foreach((Function1 & Serializable)x0$1 -> {
            BoxedUnit boxedUnit;
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                TopicPartition tp = (TopicPartition)tuple2._1();
                EpochEndOffset leaderEpochOffset = (EpochEndOffset)tuple2._2();
                Errors errors = leaderEpochOffset.error();
                if (Errors.NONE.equals(errors)) {
                    OffsetTruncationState offsetTruncationState = this.getOffsetTruncationState(tp, leaderEpochOffset);
                    boxedUnit = this.doTruncate(tp, offsetTruncationState) ? fetchOffsets.put((Object)tp, (Object)offsetTruncationState) : BoxedUnit.UNIT;
                } else if (Errors.FENCED_LEADER_EPOCH.equals(errors)) {
                    this.onPartitionFenced(tp);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(77).append("Retrying leaderEpoch request for partition ").append(tp).append(" as the leader reported an error: ").append(errors).toString());
                    boxedUnit = partitionsWithError.$plus$eq((Object)tp);
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            BoxedUnit boxedUnit2 = boxedUnit;
            return boxedUnit2;
        });
        return new ResultWithPartitions<HashMap>(fetchOffsets, (Set<TopicPartition>)partitionsWithError);
    }

    private void onPartitionFenced(TopicPartition tp) {
        CoreUtils$.MODULE$.inLock(this.partitionMapLock(), (JFunction0.mcV.sp & Serializable)() -> Option$.MODULE$.apply(this.partitionStates().stateValue(tp)).foreach((Function1 & Serializable)currentFetchState -> {
            AbstractFetcherThread.$anonfun$onPartitionFenced$2(this, tp, currentFetchState);
            return BoxedUnit.UNIT;
        }));
    }

    private void processFetchRequest(Map<TopicPartition, PartitionFetchState> fetchStates, FetchRequest.Builder fetchRequest) {
        block3: {
            Object object;
            scala.collection.mutable.Set partitionsWithError = (scala.collection.mutable.Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
            ObjectRef responseData = ObjectRef.create((Object)((Seq)Seq$.MODULE$.empty()));
            try {
                this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(22).append("Sending fetch request ").append(fetchRequest).toString());
                responseData.elem = this.fetchFromLeader(fetchRequest);
                object = BoxedUnit.UNIT;
            }
            catch (Throwable t) {
                if (this.isRunning()) {
                    this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(36).append("Error in response for fetch request ").append(fetchRequest).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> t);
                    object = CoreUtils$.MODULE$.inLock(this.partitionMapLock(), (JFunction0.mcZ.sp & Serializable)() -> {
                        partitionsWithError.$plus$plus$eq((IterableOnce)JavaConverters$.MODULE$.asScalaSetConverter(this.partitionStates().partitionSet()).asScala());
                        return this.partitionMapCond().await($this.fetchBackOffMs, TimeUnit.MILLISECONDS);
                    });
                }
                object = BoxedUnit.UNIT;
            }
            this.fetcherStats().requestRate().mark();
            Object object2 = ((Seq)responseData.elem).nonEmpty() ? CoreUtils$.MODULE$.inLock(this.partitionMapLock(), (JFunction0.mcV.sp & Serializable)() -> ((Seq)responseData$1.elem).foreach((Function1 & Serializable)x0$1 -> {
                AbstractFetcherThread.$anonfun$processFetchRequest$6(this, fetchStates, partitionsWithError, x0$1);
                return BoxedUnit.UNIT;
            })) : BoxedUnit.UNIT;
            if (!partitionsWithError.nonEmpty()) break block3;
            this.handlePartitionsWithErrors((Iterable<TopicPartition>)partitionsWithError, "processFetchRequest");
        }
    }

    public void markPartitionsForTruncation(TopicPartition topicPartition, long truncationOffset) {
        this.partitionMapLock().lockInterruptibly();
        try {
            Option$.MODULE$.apply(this.partitionStates().stateValue(topicPartition)).foreach((Function1 & Serializable)state -> {
                AbstractFetcherThread.$anonfun$markPartitionsForTruncation$1(this, truncationOffset, topicPartition, state);
                return BoxedUnit.UNIT;
            });
        }
        finally {
            this.partitionMapLock().unlock();
        }
    }

    private void markPartitionFailed(TopicPartition topicPartition) {
        this.partitionMapLock().lock();
        try {
            this.failedPartitions.add(topicPartition);
            this.removePartitions((Set<TopicPartition>)((Set)scala.collection.Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))));
        }
        finally {
            this.partitionMapLock().unlock();
        }
        this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(27).append("Partition ").append(topicPartition).append(" marked as failed").toString());
    }

    public void addPartitions(Map<TopicPartition, OffsetAndEpoch> initialFetchStates) {
        this.partitionMapLock().lockInterruptibly();
        try {
            initialFetchStates.foreach((Function1 & Serializable)x0$1 -> {
                AbstractFetcherThread.$anonfun$addPartitions$1(this, x0$1);
                return BoxedUnit.UNIT;
            });
            this.partitionMapCond().signalAll();
        }
        finally {
            this.partitionMapLock().unlock();
        }
    }

    private void updateFetchOffsetAndMaybeMarkTruncationComplete(Map<TopicPartition, OffsetTruncationState> fetchOffsets) {
        scala.collection.immutable.Map newStates = ((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(this.partitionStates().partitionStates()).asScala()).map((Function1 & Serializable)state -> {
            PartitionFetchState partitionFetchState;
            PartitionFetchState currentFetchState = (PartitionFetchState)state.value();
            Option option = fetchOffsets.get((Object)state.topicPartition());
            if (option instanceof Some) {
                Some some = (Some)option;
                OffsetTruncationState offsetTruncationState = (OffsetTruncationState)some.value();
                Product state2 = offsetTruncationState.truncationCompleted() ? Fetching$.MODULE$ : Truncating$.MODULE$;
                partitionFetchState = new PartitionFetchState(offsetTruncationState.offset(), currentFetchState.currentLeaderEpoch(), currentFetchState.delay(), (ReplicaState)state2);
            } else if (None$.MODULE$.equals(option)) {
                partitionFetchState = currentFetchState;
            } else {
                throw new MatchError((Object)option);
            }
            PartitionFetchState maybeTruncationComplete = partitionFetchState;
            return new Tuple2((Object)state.topicPartition(), (Object)maybeTruncationComplete);
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        this.partitionStates().set((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)newStates).asJava());
    }

    private OffsetTruncationState getOffsetTruncationState(TopicPartition tp, EpochEndOffset leaderEpochOffset) {
        return (OffsetTruncationState)CoreUtils$.MODULE$.inLock(this.partitionMapLock(), (Function0 & Serializable)() -> {
            OffsetTruncationState offsetTruncationState;
            if (leaderEpochOffset.endOffset() == -1L) {
                this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(76).append("Based on replica's leader epoch, leader replied with an unknown offset in ").append(tp).append(". ").toString()).append(new StringBuilder(54).append("The initial fetch offset ").append(((PartitionFetchState)this.partitionStates().stateValue(tp)).fetchOffset()).append(" will be used for truncation.").toString()).toString());
                offsetTruncationState = new OffsetTruncationState(((PartitionFetchState)this.partitionStates().stateValue(tp)).fetchOffset(), true);
            } else if (leaderEpochOffset.leaderEpoch() == -1) {
                this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append("Leader or replica is on protocol version where leader epoch is not considered in the OffsetsForLeaderEpoch response. ").append(new StringBuilder(53).append("The leader's offset ").append(leaderEpochOffset.endOffset()).append(" will be used for truncation in ").append(tp).append(".").toString()).toString());
                offsetTruncationState = new OffsetTruncationState(package$.MODULE$.min(leaderEpochOffset.endOffset(), this.logEndOffset(tp)), true);
            } else {
                OffsetTruncationState offsetTruncationState2;
                Some some;
                OffsetAndEpoch offsetAndEpoch;
                long replicaEndOffset = this.logEndOffset(tp);
                Option<OffsetAndEpoch> option = this.endOffsetForEpoch(tp, leaderEpochOffset.leaderEpoch());
                if (option instanceof Some && (offsetAndEpoch = (OffsetAndEpoch)(some = (Some)option).value()) != null) {
                    OffsetTruncationState offsetTruncationState3;
                    long followerEndOffset = offsetAndEpoch.offset();
                    int followerEpoch = offsetAndEpoch.leaderEpoch();
                    if (followerEpoch != leaderEpochOffset.leaderEpoch()) {
                        long intermediateOffsetToTruncateTo = package$.MODULE$.min(followerEndOffset, replicaEndOffset);
                        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(60).append("Based on replica's leader epoch, leader replied with epoch ").append(leaderEpochOffset.leaderEpoch()).append(" ").toString()).append(new StringBuilder(29).append("unknown to the replica for ").append(tp).append(". ").toString()).append(new StringBuilder(70).append("Will truncate to ").append(intermediateOffsetToTruncateTo).append(" and send another leader epoch request to the leader.").toString()).toString());
                        offsetTruncationState3 = new OffsetTruncationState(intermediateOffsetToTruncateTo, false);
                    } else {
                        long offsetToTruncateTo = package$.MODULE$.min(followerEndOffset, leaderEpochOffset.endOffset());
                        offsetTruncationState3 = new OffsetTruncationState(package$.MODULE$.min(offsetToTruncateTo, replicaEndOffset), true);
                    }
                    offsetTruncationState2 = offsetTruncationState3;
                } else if (None$.MODULE$.equals(option)) {
                    this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(60).append("Based on replica's leader epoch, leader replied with epoch ").append(leaderEpochOffset.leaderEpoch()).append(" ").toString()).append(new StringBuilder(41).append("below any replica's tracked epochs for ").append(tp).append(". ").toString()).append(new StringBuilder(54).append("The leader's offset only ").append(leaderEpochOffset.endOffset()).append(" will be used for truncation.").toString()).toString());
                    offsetTruncationState2 = new OffsetTruncationState(package$.MODULE$.min(leaderEpochOffset.endOffset(), replicaEndOffset), true);
                } else {
                    throw new MatchError(option);
                }
                offsetTruncationState = offsetTruncationState2;
            }
            return offsetTruncationState;
        });
    }

    private boolean handleOutOfRangeError(TopicPartition topicPartition, PartitionFetchState fetchState) {
        boolean bl;
        try {
            long newOffset = this.fetchOffsetAndTruncate(topicPartition, fetchState.currentLeaderEpoch());
            PartitionFetchState newFetchState = PartitionFetchState$.MODULE$.apply(newOffset, fetchState.currentLeaderEpoch(), Fetching$.MODULE$);
            this.partitionStates().updateAndMoveToEnd(topicPartition, (Object)newFetchState);
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(34).append("Current offset ").append(fetchState.fetchOffset()).append(" for partition ").append(topicPartition).append(" is ").toString()).append(new StringBuilder(77).append("out of range, which typically implies a leader change. Reset fetch offset to ").append(newOffset).toString()).toString());
            bl = true;
        }
        catch (Throwable throwable) {
            boolean bl2;
            Throwable throwable2 = throwable;
            if (throwable2 instanceof FencedLeaderEpochException) {
                this.onPartitionFenced(topicPartition);
                bl2 = true;
            } else {
                boolean bl3 = throwable2 instanceof UnknownTopicOrPartitionException ? true : (throwable2 instanceof UnknownLeaderEpochException ? true : throwable2 instanceof NotLeaderForPartitionException);
                if (bl3) {
                    this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(42).append("Could not fetch offset for ").append(topicPartition).append(" due to error: ").append(throwable2.getMessage()).toString());
                    bl2 = false;
                } else if (throwable2 != null) {
                    Throwable throwable3 = throwable2;
                    this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(35).append("Error getting offset for partition ").append(topicPartition).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> throwable3);
                    bl2 = false;
                } else {
                    throw throwable;
                }
            }
            bl = bl2;
        }
        return bl;
    }

    public long fetchOffsetAndTruncate(TopicPartition topicPartition, int currentLeaderEpoch) {
        long l;
        long replicaEndOffset = this.logEndOffset(topicPartition);
        long leaderEndOffset = this.fetchLatestOffsetFromLeader(topicPartition, currentLeaderEpoch);
        if (leaderEndOffset < replicaEndOffset) {
            this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(51).append("Reset fetch offset for partition ").append(topicPartition).append(" from ").append(replicaEndOffset).append(" to current ").toString()).append(new StringBuilder(23).append("leader's latest offset ").append(leaderEndOffset).toString()).toString());
            this.truncate(topicPartition, new OffsetTruncationState(leaderEndOffset, true));
            l = leaderEndOffset;
        } else {
            long leaderStartOffset = this.fetchEarliestOffsetFromLeader(topicPartition, currentLeaderEpoch);
            this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(51).append("Reset fetch offset for partition ").append(topicPartition).append(" from ").append(replicaEndOffset).append(" to current ").toString()).append(new StringBuilder(22).append("leader's start offset ").append(leaderStartOffset).toString()).toString());
            long offsetToFetch = Math.max(leaderStartOffset, replicaEndOffset);
            if (leaderStartOffset > replicaEndOffset) {
                this.truncateFullyAndStartAt(topicPartition, leaderStartOffset);
            }
            l = offsetToFetch;
        }
        return l;
    }

    public void delayPartitions(Iterable<TopicPartition> partitions, long delay) {
        this.partitionMapLock().lockInterruptibly();
        try {
            partitions.foreach((Function1 & Serializable)partition -> {
                AbstractFetcherThread.$anonfun$delayPartitions$1(this, delay, partition);
                return BoxedUnit.UNIT;
            });
            this.partitionMapCond().signalAll();
        }
        finally {
            this.partitionMapLock().unlock();
        }
    }

    public void removePartitions(Set<TopicPartition> topicPartitions) {
        this.partitionMapLock().lockInterruptibly();
        try {
            topicPartitions.foreach((Function1 & Serializable)topicPartition -> {
                AbstractFetcherThread.$anonfun$removePartitions$1(this, topicPartition);
                return BoxedUnit.UNIT;
            });
        }
        finally {
            this.partitionMapLock().unlock();
        }
    }

    public int partitionCount() {
        int n;
        this.partitionMapLock().lockInterruptibly();
        try {
            n = this.partitionStates().size();
        }
        finally {
            this.partitionMapLock().unlock();
        }
        return n;
    }

    public Option<PartitionFetchState> fetchState(TopicPartition topicPartition) {
        return (Option)CoreUtils$.MODULE$.inLock(this.partitionMapLock(), (Function0 & Serializable)() -> Option$.MODULE$.apply(this.partitionStates().stateValue(topicPartition)));
    }

    public Map<TopicPartition, InitialFetchState> partitionsAndOffsets() {
        return (Map)CoreUtils$.MODULE$.inLock(this.partitionMapLock(), (Function0 & Serializable)() -> ((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(this.partitionStates().partitionStates()).asScala()).map((Function1 & Serializable)state -> {
            InitialFetchState initialFetchState = new InitialFetchState(this.sourceBroker(), ((PartitionFetchState)state.value()).currentLeaderEpoch(), ((PartitionFetchState)state.value()).fetchOffset());
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)state.topicPartition()), (Object)initialFetchState);
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    public MemoryRecords toMemoryRecords(Records records) {
        MemoryRecords memoryRecords;
        Records records2 = records;
        if (records2 instanceof MemoryRecords) {
            MemoryRecords memoryRecords2;
            memoryRecords = memoryRecords2 = (MemoryRecords)records2;
        } else if (records2 instanceof FileRecords) {
            FileRecords fileRecords = (FileRecords)records2;
            ByteBuffer buffer = ByteBuffer.allocate(fileRecords.sizeInBytes());
            fileRecords.readInto(buffer, 0);
            memoryRecords = MemoryRecords.readableRecords((ByteBuffer)buffer);
        } else {
            throw new MatchError((Object)records2);
        }
        return memoryRecords;
    }

    public static final /* synthetic */ boolean $anonfun$truncateToEpochEndOffsets$2(AbstractFetcherThread $this, Map latestEpochsForPartitions$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition tp = (TopicPartition)tuple2._1();
        PartitionFetchState curPartitionState = (PartitionFetchState)$this.partitionStates().stateValue(tp);
        OffsetsForLeaderEpochRequest.PartitionData partitionEpochRequest = (OffsetsForLeaderEpochRequest.PartitionData)latestEpochsForPartitions$1.get((Object)tp).getOrElse((Function0 & Serializable)() -> {
            throw new IllegalStateException(new StringBuilder(77).append("Leader replied with partition ").append(tp).append(" not requested in OffsetsForLeaderEpoch request").toString());
        });
        Integer leaderEpochInRequest = (Integer)partitionEpochRequest.currentLeaderEpoch.get();
        boolean bl = curPartitionState != null && BoxesRunTime.equalsNumObject((Number)leaderEpochInRequest, (Object)BoxesRunTime.boxToInteger((int)curPartitionState.currentLeaderEpoch()));
        return bl;
    }

    public static final /* synthetic */ void $anonfun$onPartitionFenced$2(AbstractFetcherThread $this, TopicPartition tp$4, PartitionFetchState currentFetchState) {
        int currentLeaderEpoch = currentFetchState.currentLeaderEpoch();
        $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(69).append("Partition ").append(tp$4).append(" has an older epoch (").append(currentLeaderEpoch).append(") than the current leader. Will await ").toString()).append("the new LeaderAndIsr state before resuming fetching.").toString());
        $this.markPartitionFailed(tp$4);
    }

    public static final /* synthetic */ void $anonfun$processFetchRequest$8(AbstractFetcherThread $this, PartitionFetchState currentFetchState$1, TopicPartition topicPartition$2, FetchResponse.PartitionData partitionData$1, PartitionFetchState fetchState$1, LogAppendInfo logAppendInfo) {
        block0: {
            int validBytes = logAppendInfo.validBytes();
            long nextOffset = validBytes > 0 ? logAppendInfo.lastOffset() + 1L : currentFetchState$1.fetchOffset();
            $this.fetcherLagStats().getAndMaybePut(topicPartition$2).lag_$eq(Math.max(0L, partitionData$1.highWatermark - nextOffset));
            if (validBytes <= 0 || !$this.partitionStates().contains(topicPartition$2)) break block0;
            PartitionFetchState newFetchState = PartitionFetchState$.MODULE$.apply(nextOffset, fetchState$1.currentLeaderEpoch(), Fetching$.MODULE$);
            $this.partitionStates().updateAndMoveToEnd(topicPartition$2, (Object)newFetchState);
            $this.fetcherStats().byteRate().mark((long)validBytes);
        }
    }

    public static final /* synthetic */ void $anonfun$processFetchRequest$6(AbstractFetcherThread $this, Map fetchStates$2, scala.collection.mutable.Set partitionsWithError$2, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition topicPartition = (TopicPartition)tuple2._1();
        FetchResponse.PartitionData partitionData = (FetchResponse.PartitionData)tuple2._2();
        Option$.MODULE$.apply($this.partitionStates().stateValue(topicPartition)).foreach((Function1 & Serializable)currentFetchState -> {
            BoxedUnit boxedUnit;
            PartitionFetchState fetchState = (PartitionFetchState)fetchStates$2.apply((Object)topicPartition);
            if (fetchState.fetchOffset() == currentFetchState.fetchOffset() && currentFetchState.isReadyForFetch()) {
                BoxedUnit boxedUnit2;
                Errors errors = partitionData$1.error;
                if (Errors.NONE.equals(errors)) {
                    BoxedUnit boxedUnit3;
                    try {
                        Option<LogAppendInfo> logAppendInfoOpt = $this.processPartitionData(topicPartition, currentFetchState.fetchOffset(), (FetchResponse.PartitionData<Records>)partitionData);
                        logAppendInfoOpt.foreach((Function1 & Serializable)logAppendInfo -> {
                            AbstractFetcherThread.$anonfun$processFetchRequest$8($this, currentFetchState, topicPartition, partitionData, fetchState, logAppendInfo);
                            return BoxedUnit.UNIT;
                        });
                        boxedUnit3 = BoxedUnit.UNIT;
                    }
                    catch (Throwable throwable) {
                        Growable growable;
                        Throwable throwable2 = throwable;
                        boolean bl = throwable2 instanceof CorruptRecordException ? true : throwable2 instanceof InvalidRecordException;
                        if (bl) {
                            $this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(51).append("Found invalid messages during fetch for partition ").append(topicPartition).append(" ").toString()).append(new StringBuilder(7).append("offset ").append(currentFetchState.fetchOffset()).toString()).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> throwable2);
                            growable = partitionsWithError$2.$plus$eq((Object)topicPartition);
                        } else if (throwable2 instanceof KafkaStorageException) {
                            KafkaStorageException kafkaStorageException = (KafkaStorageException)throwable2;
                            $this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(43).append("Error while processing data for partition ").append(topicPartition).append(" ").toString()).append(new StringBuilder(10).append("at offset ").append(currentFetchState.fetchOffset()).toString()).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> kafkaStorageException);
                            $this.markPartitionFailed(topicPartition);
                            growable = BoxedUnit.UNIT;
                        } else if (throwable2 != null) {
                            Throwable throwable3 = throwable2;
                            $this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(63).append("Unexpected error occurred while processing data for partition ").append(topicPartition).append(" ").toString()).append(new StringBuilder(10).append("at offset ").append(currentFetchState.fetchOffset()).toString()).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> throwable3);
                            $this.markPartitionFailed(topicPartition);
                            growable = BoxedUnit.UNIT;
                        } else {
                            throw throwable;
                        }
                        boxedUnit3 = growable;
                    }
                    boxedUnit2 = boxedUnit3;
                } else if (Errors.OFFSET_OUT_OF_RANGE.equals(errors)) {
                    boxedUnit2 = !$this.handleOutOfRangeError(topicPartition, (PartitionFetchState)currentFetchState) ? partitionsWithError$2.$plus$eq((Object)topicPartition) : BoxedUnit.UNIT;
                } else if (Errors.UNKNOWN_LEADER_EPOCH.equals(errors)) {
                    $this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(61).append("Remote broker has a smaller leader epoch for partition ").append(topicPartition).append(" than ").toString()).append(new StringBuilder(40).append("this replica's current leader epoch of ").append(fetchState.currentLeaderEpoch()).append(".").toString()).toString());
                    boxedUnit2 = partitionsWithError$2.$plus$eq((Object)topicPartition);
                } else if (Errors.FENCED_LEADER_EPOCH.equals(errors)) {
                    $this.onPartitionFenced(topicPartition);
                    boxedUnit2 = BoxedUnit.UNIT;
                } else if (Errors.NOT_LEADER_FOR_PARTITION.equals(errors)) {
                    $this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(33).append(new StringBuilder(69).append("Remote broker is not the leader for partition ").append(topicPartition).append(", which could indicate ").toString()).append("that the partition is being moved").toString());
                    boxedUnit2 = partitionsWithError$2.$plus$eq((Object)topicPartition);
                } else {
                    $this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(31).append("Error for partition ").append(topicPartition).append(" at offset ").append(currentFetchState.fetchOffset()).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> partitionData$1.error.exception());
                    boxedUnit2 = partitionsWithError$2.$plus$eq((Object)topicPartition);
                }
                boxedUnit = boxedUnit2;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return boxedUnit;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$markPartitionsForTruncation$1(AbstractFetcherThread $this, long truncationOffset$1, TopicPartition topicPartition$3, PartitionFetchState state) {
        PartitionFetchState newState = new PartitionFetchState(package$.MODULE$.min(truncationOffset$1, state.fetchOffset()), state.currentLeaderEpoch(), state.delay(), Truncating$.MODULE$);
        $this.partitionStates().updateAndMoveToEnd(topicPartition$3, (Object)newState);
        $this.partitionMapCond().signalAll();
    }

    public static final /* synthetic */ void $anonfun$addPartitions$1(AbstractFetcherThread $this, Tuple2 x0$1) {
        PartitionFetchState partitionFetchState;
        TopicPartition tp;
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            tp = (TopicPartition)tuple2._1();
            OffsetAndEpoch initialFetchState = (OffsetAndEpoch)tuple2._2();
            PartitionFetchState currentState = (PartitionFetchState)$this.partitionStates().stateValue(tp);
            if (currentState != null && currentState.currentLeaderEpoch() == initialFetchState.leaderEpoch()) {
                partitionFetchState = currentState;
            } else {
                long initialFetchOffset = initialFetchState.offset() < 0L ? $this.fetchOffsetAndTruncate(tp, initialFetchState.leaderEpoch()) : initialFetchState.offset();
                partitionFetchState = PartitionFetchState$.MODULE$.apply(initialFetchOffset, initialFetchState.leaderEpoch(), Truncating$.MODULE$);
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        PartitionFetchState updatedState = partitionFetchState;
        $this.partitionStates().updateAndMoveToEnd(tp, (Object)updatedState);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$delayPartitions$2(AbstractFetcherThread $this, TopicPartition partition$1, long delay$1, PartitionFetchState currentFetchState) {
        block0: {
            if (currentFetchState.isDelayed()) break block0;
            $this.partitionStates().updateAndMoveToEnd(partition$1, (Object)new PartitionFetchState(currentFetchState.fetchOffset(), currentFetchState.currentLeaderEpoch(), new DelayedItem(delay$1), currentFetchState.state()));
        }
    }

    public static final /* synthetic */ void $anonfun$delayPartitions$1(AbstractFetcherThread $this, long delay$1, TopicPartition partition) {
        Option$.MODULE$.apply($this.partitionStates().stateValue(partition)).foreach((Function1 & Serializable)currentFetchState -> {
            AbstractFetcherThread.$anonfun$delayPartitions$2($this, partition, delay$1, currentFetchState);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$removePartitions$1(AbstractFetcherThread $this, TopicPartition topicPartition) {
        $this.partitionStates().remove(topicPartition);
        $this.fetcherLagStats().unregister(topicPartition);
    }

    public AbstractFetcherThread(String name, String clientId, BrokerEndPoint sourceBroker, FailedPartitions failedPartitions, int fetchBackOffMs, boolean isInterruptible) {
        this.sourceBroker = sourceBroker;
        this.failedPartitions = failedPartitions;
        this.fetchBackOffMs = fetchBackOffMs;
        super(name, isInterruptible);
        this.partitionStates = new PartitionStates();
        this.partitionMapLock = new ReentrantLock();
        this.partitionMapCond = this.partitionMapLock().newCondition();
        this.metricId = new ClientIdAndBroker(clientId, sourceBroker.host(), sourceBroker.port());
        this.fetcherStats = new FetcherStats(this.metricId());
        this.fetcherLagStats = new FetcherLagStats(this.metricId());
    }

    public static class ResultWithPartitions<R>
    implements Product,
    Serializable {
        private final R result;
        private final Set<TopicPartition> partitionsWithError;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public R result() {
            return this.result;
        }

        public Set<TopicPartition> partitionsWithError() {
            return this.partitionsWithError;
        }

        public <R> ResultWithPartitions<R> copy(R result, Set<TopicPartition> partitionsWithError) {
            return new ResultWithPartitions<R>(result, partitionsWithError);
        }

        public <R> R copy$default$1() {
            return this.result();
        }

        public <R> Set<TopicPartition> copy$default$2() {
            return this.partitionsWithError();
        }

        public String productPrefix() {
            return "ResultWithPartitions";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.result();
                    break;
                }
                case 1: {
                    object = this.partitionsWithError();
                    break;
                }
                default: {
                    object = Statics.ioobe((int)x$1);
                    break;
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ResultWithPartitions;
        }

        public String productElementName(int x$1) {
            String string;
            int n = x$1;
            switch (n) {
                case 0: {
                    string = "result";
                    break;
                }
                case 1: {
                    string = "partitionsWithError";
                    break;
                }
                default: {
                    string = (String)Statics.ioobe((int)x$1);
                    break;
                }
            }
            return string;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof ResultWithPartitions)) return false;
            boolean bl = true;
            if (!bl) return false;
            ResultWithPartitions resultWithPartitions = (ResultWithPartitions)x$1;
            if (!BoxesRunTime.equals(this.result(), resultWithPartitions.result())) return false;
            Set<TopicPartition> set = this.partitionsWithError();
            Set<TopicPartition> set2 = resultWithPartitions.partitionsWithError();
            if (set == null) {
                if (set2 != null) {
                    return false;
                }
            } else if (!set.equals(set2)) return false;
            if (!resultWithPartitions.canEqual(this)) return false;
            return true;
        }

        public ResultWithPartitions(R result, Set<TopicPartition> partitionsWithError) {
            this.result = result;
            this.partitionsWithError = partitionsWithError;
            Product.$init$((Product)this);
        }
    }
}

