/*
 * Decompiled with CFR 0.152.
 */
package kafka.security.authorizer;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import kafka.network.RequestChannel;
import kafka.security.auth.Acl;
import kafka.security.auth.Authorizer;
import kafka.security.auth.Operation;
import kafka.security.auth.Operation$;
import kafka.security.auth.Resource;
import kafka.security.authorizer.AuthorizerUtils$;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.server.authorizer.AclCreateResult;
import org.apache.kafka.server.authorizer.AclDeleteResult;
import org.apache.kafka.server.authorizer.Action;
import org.apache.kafka.server.authorizer.AuthorizableRequestContext;
import org.apache.kafka.server.authorizer.AuthorizationResult;
import org.apache.kafka.server.authorizer.AuthorizerServerInfo;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Growable;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0005\u0005md\u0001B\u0006\r\u0001MA\u0011\u0002\u000b\u0001\u0003\u0006\u0004%\t\u0001E\u0015\t\u0011=\u0002!\u0011!Q\u0001\n)BQ\u0001\r\u0001\u0005\u0002EBQ!\u000e\u0001\u0005BYBQ\u0001\u0018\u0001\u0005BuCQ\u0001\u001f\u0001\u0005BeDq!a\u0006\u0001\t\u0003\nI\u0002C\u0004\u0002D\u0001!\t%!\u0012\t\u000f\u0005%\u0004\u0001\"\u0011\u0002l!9\u0011q\u000f\u0001\u0005B\u0005e$!E!vi\"|'/\u001b>fe^\u0013\u0018\r\u001d9fe*\u0011QBD\u0001\u000bCV$\bn\u001c:ju\u0016\u0014(BA\b\u0011\u0003!\u0019XmY;sSRL(\"A\t\u0002\u000b-\fgm[1\u0004\u0001M\u0019\u0001\u0001\u0006\u000f\u0011\u0005UQR\"\u0001\f\u000b\u0005]A\u0012\u0001\u00027b]\u001eT\u0011!G\u0001\u0005U\u00064\u0018-\u0003\u0002\u001c-\t1qJ\u00196fGR\u0004\"!\b\u0014\u000e\u0003yQ!!D\u0010\u000b\u0005\u0001\n\u0013AB:feZ,'O\u0003\u0002\u0012E)\u00111\u0005J\u0001\u0007CB\f7\r[3\u000b\u0003\u0015\n1a\u001c:h\u0013\t9cD\u0001\u0006BkRDwN]5{KJ\faBY1tK\u0006+H\u000f[8sSj,'/F\u0001+!\tYc&D\u0001-\u0015\tic\"\u0001\u0003bkRD\u0017BA\u0014-\u0003=\u0011\u0017m]3BkRDwN]5{KJ\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u00023iA\u00111\u0007A\u0007\u0002\u0019!)\u0001f\u0001a\u0001U\u0005I1m\u001c8gS\u001e,(/\u001a\u000b\u0003ou\u0002\"\u0001O\u001e\u000e\u0003eR\u0011AO\u0001\u0006g\u000e\fG.Y\u0005\u0003ye\u0012A!\u00168ji\")a\b\u0002a\u0001\u007f\u000591m\u001c8gS\u001e\u001c\bG\u0001!T!\u0011\tEIR)\u000e\u0003\tS!a\u0011\r\u0002\tU$\u0018\u000e\\\u0005\u0003\u000b\n\u00131!T1q!\t9eJ\u0004\u0002I\u0019B\u0011\u0011*O\u0007\u0002\u0015*\u00111JE\u0001\u0007yI|w\u000e\u001e \n\u00055K\u0014A\u0002)sK\u0012,g-\u0003\u0002P!\n11\u000b\u001e:j]\u001eT!!T\u001d\u0011\u0005I\u001bF\u0002\u0001\u0003\n)v\n\t\u0011!A\u0003\u0002U\u00131a\u0018\u00132#\t1\u0016\f\u0005\u00029/&\u0011\u0001,\u000f\u0002\b\u001d>$\b.\u001b8h!\tA$,\u0003\u0002\\s\t\u0019\u0011I\\=\u0002\u000bM$\u0018M\u001d;\u0015\u0005y\u001b\bGA0h!\u0011\tE\t\u00194\u0011\u0005\u0005$W\"\u00012\u000b\u0005\r\f\u0013AB2p[6|g.\u0003\u0002fE\nAQI\u001c3q_&tG\u000f\u0005\u0002SO\u0012I\u0001.BA\u0001\u0002\u0003\u0015\t!\u001b\u0002\u0004?\u0012\u0012\u0014C\u0001,k!\rYg\u000e]\u0007\u0002Y*\u0011QNQ\u0001\u000bG>t7-\u001e:sK:$\u0018BA8m\u0005=\u0019u.\u001c9mKRLwN\\*uC\u001e,\u0007CA\u000br\u0013\t\u0011hC\u0001\u0003W_&$\u0007\"\u0002;\u0006\u0001\u0004)\u0018AC:feZ,'/\u00138g_B\u0011QD^\u0005\u0003oz\u0011A#Q;uQ>\u0014\u0018N_3s'\u0016\u0014h/\u001a:J]\u001a|\u0017!C1vi\"|'/\u001b>f)\u0015Q\u0018\u0011AA\u0006!\r\t50`\u0005\u0003y\n\u0013A\u0001T5tiB\u0011QD`\u0005\u0003\u007fz\u00111#Q;uQ>\u0014\u0018N_1uS>t'+Z:vYRDq!a\u0001\u0007\u0001\u0004\t)!\u0001\bsKF,Xm\u001d;D_:$X\r\u001f;\u0011\u0007u\t9!C\u0002\u0002\ny\u0011!$Q;uQ>\u0014\u0018N_1cY\u0016\u0014V-];fgR\u001cuN\u001c;fqRDq!!\u0004\u0007\u0001\u0004\ty!A\u0004bGRLwN\\:\u0011\t\u0005[\u0018\u0011\u0003\t\u0004;\u0005M\u0011bAA\u000b=\t1\u0011i\u0019;j_:\f!b\u0019:fCR,\u0017i\u00197t)\u0019\tY\"a\f\u00022A\"\u0011QDA\u0011!\u0011\t50a\b\u0011\u0007I\u000b\t\u0003B\u0006\u0002$\u001d\t\t\u0011!A\u0003\u0002\u0005\u0015\"aA0%gE\u0019a+a\n\u0011\t-t\u0017\u0011\u0006\t\u0004;\u0005-\u0012bAA\u0017=\ty\u0011i\u00197De\u0016\fG/\u001a*fgVdG\u000fC\u0004\u0002\u0004\u001d\u0001\r!!\u0002\t\u000f\u0005Mr\u00011\u0001\u00026\u0005Y\u0011m\u00197CS:$\u0017N\\4t!\u0011\t50a\u000e\u0011\t\u0005e\u0012qH\u0007\u0003\u0003wQ1!!\u0010c\u0003\r\t7\r\\\u0005\u0005\u0003\u0003\nYD\u0001\u0006BG2\u0014\u0015N\u001c3j]\u001e\f!\u0002Z3mKR,\u0017i\u00197t)\u0019\t9%a\u0017\u0002^A\"\u0011\u0011JA'!\u0011\t50a\u0013\u0011\u0007I\u000bi\u0005B\u0006\u0002P!\t\t\u0011!A\u0003\u0002\u0005E#aA0%iE\u0019a+a\u0015\u0011\t-t\u0017Q\u000b\t\u0004;\u0005]\u0013bAA-=\ty\u0011i\u00197EK2,G/\u001a*fgVdG\u000fC\u0004\u0002\u0004!\u0001\r!!\u0002\t\u000f\u0005}\u0003\u00021\u0001\u0002b\u0005\t\u0012m\u00197CS:$\u0017N\\4GS2$XM]:\u0011\t\u0005[\u00181\r\t\u0005\u0003s\t)'\u0003\u0003\u0002h\u0005m\"\u0001E!dY\nKg\u000eZ5oO\u001aKG\u000e^3s\u0003\u0011\t7\r\\:\u0015\t\u00055\u00141\u000f\t\u0006+\u0005=\u0014qG\u0005\u0004\u0003c2\"\u0001C%uKJ\f'\r\\3\t\u000f\u0005U\u0014\u00021\u0001\u0002d\u00051a-\u001b7uKJ\fQa\u00197pg\u0016$\u0012a\u000e")
public class AuthorizerWrapper
implements org.apache.kafka.server.authorizer.Authorizer {
    private final Authorizer baseAuthorizer;

    public Authorizer baseAuthorizer() {
        return this.baseAuthorizer;
    }

    public void configure(java.util.Map<String, ?> configs) {
        this.baseAuthorizer().configure(configs);
    }

    public java.util.Map<Endpoint, ? extends CompletionStage<Void>> start(AuthorizerServerInfo serverInfo) {
        return (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(serverInfo.endpoints()).asScala()).map((Function1 & Serializable)endpoint -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(endpoint), CompletableFuture.completedFuture(null)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).asJava();
    }

    public List<AuthorizationResult> authorize(AuthorizableRequestContext requestContext, List<Action> actions) {
        RequestChannel.Session session = new RequestChannel.Session(requestContext.principal(), requestContext.clientAddress());
        return (List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(actions).asScala()).map((Function1 & Serializable)action -> {
            Operation operation = Operation$.MODULE$.fromJava(action.operation());
            return this.baseAuthorizer().authorize(session, operation, AuthorizerUtils$.MODULE$.convertToResource(action.resourcePattern())) ? AuthorizationResult.ALLOWED : AuthorizationResult.DENIED;
        })).asJava();
    }

    public List<? extends CompletionStage<AclCreateResult>> createAcls(AuthorizableRequestContext requestContext, List<AclBinding> aclBindings) {
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(aclBindings).asScala()).map((Function1 & Serializable)aclBinding -> {
            Right right;
            Tuple2 tuple2;
            AclCreateResult aclCreateResult;
            Either<ApiError, Tuple2<Resource, Acl>> either = AuthorizerUtils$.MODULE$.convertToResourceAndAcl(aclBinding.toFilter());
            if (either instanceof Left) {
                Left left = (Left)either;
                ApiError apiError = (ApiError)left.value();
                aclCreateResult = new AclCreateResult(apiError.exception());
            } else if (either instanceof Right && (tuple2 = (Tuple2)(right = (Right)either).value()) != null) {
                AclCreateResult aclCreateResult2;
                Resource resource = (Resource)tuple2._1();
                Acl acl = (Acl)tuple2._2();
                try {
                    this.baseAuthorizer().addAcls((Set<Acl>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Acl[]{acl}))), resource);
                    aclCreateResult2 = AclCreateResult.SUCCESS;
                }
                catch (ApiException e) {
                    aclCreateResult2 = new AclCreateResult(e);
                }
                catch (Throwable e) {
                    aclCreateResult2 = new AclCreateResult((ApiException)new InvalidRequestException("Failed to create ACL", e));
                }
                aclCreateResult = aclCreateResult2;
            } else {
                throw new MatchError(either);
            }
            return aclCreateResult;
        })).toList().map((Function1 & Serializable)x$1 -> CompletableFuture.completedFuture(x$1))).asJava();
    }

    public List<? extends CompletionStage<AclDeleteResult>> deleteAcls(AuthorizableRequestContext requestContext, List<AclBindingFilter> aclBindingFilters) {
        Buffer filters = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(aclBindingFilters).asScala();
        scala.collection.mutable.Map results = (scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        scala.collection.mutable.Map toDelete = (scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        if (filters.forall((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.matchesAtMostOne()))) {
            ((IterableOps)filters.zipWithIndex()).withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)AuthorizerWrapper.$anonfun$deleteAcls$2(check$ifrefutable$1))).foreach((Function1 & Serializable)x$2 -> {
                Option option;
                Tuple2 tuple2 = x$2;
                if (tuple2 == null) throw new MatchError((Object)tuple2);
                AclBindingFilter filter = (AclBindingFilter)tuple2._1();
                int i = tuple2._2$mcI$sp();
                Either<ApiError, Tuple2<Resource, Acl>> either = AuthorizerUtils$.MODULE$.convertToResourceAndAcl(filter);
                if (either instanceof Left) {
                    Left left = (Left)either;
                    ApiError apiError = (ApiError)left.value();
                    option = results.put((Object)BoxesRunTime.boxToInteger((int)i), (Object)new AclDeleteResult(apiError.exception()));
                    return option;
                } else {
                    if (!(either instanceof Right)) throw new MatchError(either);
                    Right right = (Right)either;
                    Tuple2 binding = (Tuple2)right.value();
                    option = toDelete.put((Object)BoxesRunTime.boxToInteger((int)i), ArrayBuffer$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{binding})));
                }
                return option;
            });
        } else {
            scala.collection.immutable.Map<Resource, Set<Acl>> aclMap = this.baseAuthorizer().getAcls();
            Buffer filtersWithIndex = (Buffer)filters.zipWithIndex();
            aclMap.withFilter((Function1 & Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)AuthorizerWrapper.$anonfun$deleteAcls$4(check$ifrefutable$2))).foreach((Function1 & Serializable)x$5 -> {
                AuthorizerWrapper.$anonfun$deleteAcls$5(filtersWithIndex, toDelete, x$5);
                return BoxedUnit.UNIT;
            });
        }
        toDelete.withFilter((Function1 & Serializable)check$ifrefutable$4 -> BoxesRunTime.boxToBoolean((boolean)AuthorizerWrapper.$anonfun$deleteAcls$11(check$ifrefutable$4))).foreach((Function1 & Serializable)x$6 -> {
            Tuple2 tuple2 = x$6;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int i = tuple2._1$mcI$sp();
            ArrayBuffer acls = (ArrayBuffer)tuple2._2();
            List deletionResults = (List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)acls.flatMap((Function1 & Serializable)x0$1 -> {
                Object object;
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    Resource resource = (Resource)tuple2._1();
                    Acl acl = (Acl)tuple2._2();
                    AclBinding aclBinding = AuthorizerUtils$.MODULE$.convertToAclBinding(resource, acl);
                    try {
                        object = this.baseAuthorizer().removeAcls((Set<Acl>)((Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Acl[]{acl}))), resource) ? new Some((Object)new AclDeleteResult.AclBindingDeleteResult(aclBinding)) : None$.MODULE$;
                    }
                    catch (Throwable throwable) {
                        object = new Some((Object)new AclDeleteResult.AclBindingDeleteResult(aclBinding, ApiError.fromThrowable((Throwable)throwable).exception()));
                    }
                } else {
                    throw new MatchError((Object)tuple2);
                }
                Some some = object;
                return some;
            })).asJava();
            Option option = results.put((Object)BoxesRunTime.boxToInteger((int)i), (Object)new AclDeleteResult((Collection)deletionResults));
            return option;
        });
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)filters.indices().map((Function1 & Serializable)i -> AuthorizerWrapper.$anonfun$deleteAcls$14(results, BoxesRunTime.unboxToInt((Object)i))).map((Function1 & Serializable)x$1 -> CompletableFuture.completedFuture(x$1))).asJava();
    }

    public java.lang.Iterable<AclBinding> acls(AclBindingFilter filter) {
        return (java.lang.Iterable)JavaConverters$.MODULE$.asJavaIterableConverter((Iterable)this.baseAuthorizer().getAcls().flatMap((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Resource resource = (Resource)tuple2._1();
            Set acls = (Set)tuple2._2();
            Set set = (Set)((IterableOps)acls.map((Function1 & Serializable)acl -> AuthorizerUtils$.MODULE$.convertToAclBinding(resource, (Acl)acl))).filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)filter.matches(x$1)));
            return set;
        })).asJava();
    }

    public void close() {
        this.baseAuthorizer().close();
    }

    public static final /* synthetic */ boolean $anonfun$deleteAcls$2(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$deleteAcls$4(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$deleteAcls$7(Tuple2 check$ifrefutable$3) {
        Tuple2 tuple2 = check$ifrefutable$3;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$deleteAcls$8(AclBinding binding$1, Tuple2 x$3) {
        Tuple2 tuple2 = x$3;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        AclBindingFilter filter = (AclBindingFilter)tuple2._1();
        boolean bl = filter.matches(binding$1);
        return bl;
    }

    public static final /* synthetic */ void $anonfun$deleteAcls$6(Resource resource$1, Buffer filtersWithIndex$1, scala.collection.mutable.Map toDelete$1, Acl acl) {
        AclBinding binding = new AclBinding(new ResourcePattern(resource$1.resourceType().toJava(), resource$1.name(), resource$1.patternType()), new AccessControlEntry(acl.principal().toString(), acl.host().toString(), acl.operation().toJava(), acl.permissionType().toJava()));
        filtersWithIndex$1.withFilter((Function1 & Serializable)check$ifrefutable$3 -> BoxesRunTime.boxToBoolean((boolean)AuthorizerWrapper.$anonfun$deleteAcls$7(check$ifrefutable$3))).withFilter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)AuthorizerWrapper.$anonfun$deleteAcls$8(binding, x$3))).foreach((Function1 & Serializable)x$4 -> {
            Tuple2 tuple2 = x$4;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int i = tuple2._2$mcI$sp();
            ArrayBuffer arrayBuffer = (ArrayBuffer)((Growable)toDelete$1.getOrElseUpdate((Object)BoxesRunTime.boxToInteger((int)i), (Function0 & Serializable)() -> ArrayBuffer$.MODULE$.empty())).$plus$eq((Object)new Tuple2((Object)resource$1, (Object)acl));
            return arrayBuffer;
        });
    }

    public static final /* synthetic */ void $anonfun$deleteAcls$5(Buffer filtersWithIndex$1, scala.collection.mutable.Map toDelete$1, Tuple2 x$5) {
        Tuple2 tuple2 = x$5;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Resource resource = (Resource)tuple2._1();
        Set acls = (Set)tuple2._2();
        acls.foreach((Function1 & Serializable)acl -> {
            AuthorizerWrapper.$anonfun$deleteAcls$6(resource, filtersWithIndex$1, toDelete$1, acl);
            return BoxedUnit.UNIT;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$deleteAcls$11(Tuple2 check$ifrefutable$4) {
        Tuple2 tuple2 = check$ifrefutable$4;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ AclDeleteResult $anonfun$deleteAcls$14(scala.collection.mutable.Map results$1, int i) {
        return (AclDeleteResult)results$1.getOrElse((Object)BoxesRunTime.boxToInteger((int)i), (Function0 & Serializable)() -> new AclDeleteResult((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.empty()).asJava()));
    }

    public AuthorizerWrapper(Authorizer baseAuthorizer) {
        this.baseAuthorizer = baseAuthorizer;
    }
}

