/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import kafka.log.CompletedTxn;
import kafka.log.CorruptSnapshotException;
import kafka.log.Log$;
import kafka.log.ProducerAppendInfo;
import kafka.log.ProducerStateEntry;
import kafka.log.ProducerStateEntry$;
import kafka.log.ProducerStateManager$;
import kafka.log.TxnMetadata;
import kafka.log.ValidationType$EpochOnly$;
import kafka.log.ValidationType$Full$;
import kafka.log.ValidationType$None$;
import kafka.server.LogOffsetMetadata;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.types.Schema;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.JavaConverters$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\r\rt!B/_\u0011\u0003\u0019g!B3_\u0011\u00031\u0007\"B7\u0002\t\u0003q\u0007bB8\u0002\u0005\u0004%I\u0001\u001d\u0005\u0007i\u0006\u0001\u000b\u0011B9\t\u000fU\f!\u0019!C\u0005m\"1q0\u0001Q\u0001\n]D\u0001\"!\u0001\u0002\u0005\u0004%IA\u001e\u0005\b\u0003\u0007\t\u0001\u0015!\u0003x\u0011!\t)!\u0001b\u0001\n\u00131\bbBA\u0004\u0003\u0001\u0006Ia\u001e\u0005\t\u0003\u0013\t!\u0019!C\u0005m\"9\u00111B\u0001!\u0002\u00139\b\u0002CA\u0007\u0003\t\u0007I\u0011\u0002<\t\u000f\u0005=\u0011\u0001)A\u0005o\"A\u0011\u0011C\u0001C\u0002\u0013%a\u000fC\u0004\u0002\u0014\u0005\u0001\u000b\u0011B<\t\u0011\u0005U\u0011A1A\u0005\nYDq!a\u0006\u0002A\u0003%q\u000f\u0003\u0005\u0002\u001a\u0005\u0011\r\u0011\"\u0003w\u0011\u001d\tY\"\u0001Q\u0001\n]D\u0001\"!\b\u0002\u0005\u0004%IA\u001e\u0005\b\u0003?\t\u0001\u0015!\u0003x\u0011!\t\t#\u0001b\u0001\n\u00131\bbBA\u0012\u0003\u0001\u0006Ia\u001e\u0005\t\u0003K\t!\u0019!C\u0005m\"9\u0011qE\u0001!\u0002\u00139\b\"CA\u0015\u0003\t\u0007I\u0011BA\u0016\u0011!\t\u0019$\u0001Q\u0001\n\u00055\u0002\"CA\u001b\u0003\t\u0007I\u0011BA\u0016\u0011!\t9$\u0001Q\u0001\n\u00055\u0002\"CA\u001d\u0003\t\u0007I\u0011BA\u0016\u0011!\tY$\u0001Q\u0001\n\u00055\u0002\"CA\u001f\u0003\t\u0007I\u0011AA \u0011!\ty&\u0001Q\u0001\n\u0005\u0005\u0003\"CA1\u0003\t\u0007I\u0011AA \u0011!\t\u0019'\u0001Q\u0001\n\u0005\u0005\u0003bBA3\u0003\u0011\u0005\u0011q\r\u0005\b\u0003/\u000bA\u0011BAM\u0011\u001d\ti,\u0001C\u0005\u0003\u007fC\u0001\"!3\u0002\t\u0003q\u00161\u001a\u0005\t\u0003/\fA\u0011\u00010\u0002Z\"9\u0011\u0011]\u0001\u0005\n\u0005\r\b\"CAy\u0003E\u0005I\u0011BAz\u0011%\u0011I!AI\u0001\n\u0003\u0011YAB\u0003f=\u0002\u0011y\u0001\u0003\u0006\u0003\u001e5\u0012)\u0019!C\u0001\u0005?A!B!\u000b.\u0005\u0003\u0005\u000b\u0011\u0002B\u0011\u0011)\u0011Y#\fBA\u0002\u0013\u0005!Q\u0006\u0005\u000b\u0005_i#\u00111A\u0005\u0002\tE\u0002B\u0003B\u001c[\t\u0005\t\u0015)\u0003\u0002\f\"Q!\u0011I\u0017\u0003\u0006\u0004%\t!a\u000b\t\u0015\t\rSF!A!\u0002\u0013\ti\u0003\u0003\u0004n[\u0011\u0005!Q\t\u0005\n\u0005\u001fj#\u0019!C\u0005\u0005#B\u0001Ba\u0015.A\u0003%\u0011q\u0015\u0005\n\u0005+j\u0003\u0019!C\u0005\u0005/B\u0011B!\u0017.\u0001\u0004%IAa\u0017\t\u0011\t}S\u0006)Q\u0005\u0003oC\u0011B!\u0019.\u0001\u0004%IAa\u0016\t\u0013\t\rT\u00061A\u0005\n\t\u0015\u0004\u0002\u0003B5[\u0001\u0006K!a.\t\u0013\t-TF1A\u0005\n\t5\u0004\u0002\u0003BA[\u0001\u0006IAa\u001c\t\u0013\t\rUF1A\u0005\n\t5\u0004\u0002\u0003BC[\u0001\u0006IAa\u001c\t\u000f\t\u001dU\u0006\"\u0001\u0003\n\"9!QT\u0017\u0005\u0002\t}\u0005b\u0002BS[\u0011\u0005!q\u0015\u0005\b\u0005WkC\u0011\u0001B,\u0011\u001d\u0011i+\fC\u0001\u0005_CqAa/.\t\u0003\u0011i\fC\u0004\u0003@6\"IA!1\t\u0011\t-W\u0006\"\u0001_\u0005\u001bDqAa5.\t\u0013\u0011)\u000eC\u0004\u0003`6\"\tA!9\t\u000f\t\u0015X\u0006\"\u0001\u0003h\"9!\u0011_\u0017\u0005\u0002\tM\bbBB\u0002[\u0011\u00051Q\u0001\u0005\b\u0007\u0017iC\u0011AB\u0007\u0011\u001d\u0019\u0019\"\fC\u0001\u0007+Aqaa\u0007.\t\u0003\u0019i\u0002C\u0004\u0004 5\"\tAa*\t\u000f\r\u0005R\u0006\"\u0001\u0003(\"911E\u0017\u0005\u0002\r\u0015\u0002bBB\u0015[\u0011%11\u0006\u0005\b\u0007_iC\u0011AB\u000f\u0011\u001d\u0019\t$\fC\u0001\u0007gAqaa\u0010.\t\u0003\u0019\t\u0005C\u0004\u0002X6\"\ta!\u0012\t\u000f\rES\u0006\"\u0003\u0004T!91qK\u0017\u0005\n\rM\u0003bBAe[\u0011%1\u0011L\u0001\u0015!J|G-^2feN#\u0018\r^3NC:\fw-\u001a:\u000b\u0005}\u0003\u0017a\u00017pO*\t\u0011-A\u0003lC\u001a\\\u0017m\u0001\u0001\u0011\u0005\u0011\fQ\"\u00010\u0003)A\u0013x\u000eZ;dKJ\u001cF/\u0019;f\u001b\u0006t\u0017mZ3s'\t\tq\r\u0005\u0002iW6\t\u0011NC\u0001k\u0003\u0015\u00198-\u00197b\u0013\ta\u0017N\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\r\fq\u0003\u0015:pIV\u001cWM]*oCB\u001c\bn\u001c;WKJ\u001c\u0018n\u001c8\u0016\u0003E\u0004\"\u0001\u001b:\n\u0005ML'!B*i_J$\u0018\u0001\u0007)s_\u0012,8-\u001a:T]\u0006\u00048\u000f[8u-\u0016\u00148/[8oA\u0005aa+\u001a:tS>tg)[3mIV\tq\u000f\u0005\u0002y{6\t\u0011P\u0003\u0002{w\u0006!A.\u00198h\u0015\u0005a\u0018\u0001\u00026bm\u0006L!A`=\u0003\rM#(/\u001b8h\u000351VM]:j_:4\u0015.\u001a7eA\u0005A1I]2GS\u0016dG-A\u0005De\u000e4\u0015.\u001a7eA\u0005y\u0001K]8ek\u000e,'/\u00133GS\u0016dG-\u0001\tQe>$WoY3s\u0013\u00124\u0015.\u001a7eA\u0005\tB*Y:u'\u0016\fX/\u001a8dK\u001aKW\r\u001c3\u0002%1\u000b7\u000f^*fcV,gnY3GS\u0016dG\rI\u0001\u0013!J|G-^2fe\u0016\u0003xn\u00195GS\u0016dG-A\nQe>$WoY3s\u000bB|7\r\u001b$jK2$\u0007%A\bMCN$xJ\u001a4tKR4\u0015.\u001a7e\u0003Aa\u0015m\u001d;PM\u001a\u001cX\r\u001e$jK2$\u0007%\u0001\tPM\u001a\u001cX\r\u001e#fYR\fg)[3mI\u0006\trJ\u001a4tKR$U\r\u001c;b\r&,G\u000e\u001a\u0011\u0002\u001dQKW.Z:uC6\u0004h)[3mI\u0006yA+[7fgR\fW\u000e\u001d$jK2$\u0007%\u0001\u000bQe>$WoY3s\u000b:$(/[3t\r&,G\u000eZ\u0001\u0016!J|G-^2fe\u0016sGO]5fg\u001aKW\r\u001c3!\u0003U\u0019un\u001c:eS:\fGo\u001c:Fa>\u001c\u0007NR5fY\u0012\facQ8pe\u0012Lg.\u0019;pe\u0016\u0003xn\u00195GS\u0016dG\rI\u0001\u001b\u0007V\u0014(/\u001a8u)btg)\u001b:ti>3gm]3u\r&,G\u000eZ\u0001\u001c\u0007V\u0014(/\u001a8u)btg)\u001b:ti>3gm]3u\r&,G\u000e\u001a\u0011\u0002\u001bY+'o]5p]>3gm]3u+\t\ti\u0003E\u0002i\u0003_I1!!\rj\u0005\rIe\u000e^\u0001\u000f-\u0016\u00148/[8o\u001f\u001a47/\u001a;!\u0003%\u0019%oY(gMN,G/\u0001\u0006De\u000e|eMZ:fi\u0002\nQ\u0003\u0015:pIV\u001cWM]#oiJLWm](gMN,G/\u0001\fQe>$WoY3s\u000b:$(/[3t\u001f\u001a47/\u001a;!\u0003m\u0001&o\u001c3vG\u0016\u00148K\\1qg\"|G/\u00128uef\u001c6\r[3nCV\u0011\u0011\u0011\t\t\u0005\u0003\u0007\nY&\u0004\u0002\u0002F)!\u0011qIA%\u0003\u0015!\u0018\u0010]3t\u0015\u0011\tY%!\u0014\u0002\u0011A\u0014x\u000e^8d_2TA!a\u0014\u0002R\u000511m\\7n_:T1!YA*\u0015\u0011\t)&a\u0016\u0002\r\u0005\u0004\u0018m\u00195f\u0015\t\tI&A\u0002pe\u001eLA!!\u0018\u0002F\t11k\u00195f[\u0006\fA\u0004\u0015:pIV\u001cWM]*oCB\u001c\bn\u001c;F]R\u0014\u0018pU2iK6\f\u0007%\u0001\u000bQS\u0012\u001cf.\u00199tQ>$X*\u00199TG\",W.Y\u0001\u0016!&$7K\\1qg\"|G/T1q'\u000eDW-\\1!\u00031\u0011X-\u00193T]\u0006\u00048\u000f[8u)\u0011\tI'a\"\u0011\r\u0005-\u00141PAA\u001d\u0011\ti'a\u001e\u000f\t\u0005=\u0014QO\u0007\u0003\u0003cR1!a\u001dc\u0003\u0019a$o\\8u}%\t!.C\u0002\u0002z%\fq\u0001]1dW\u0006<W-\u0003\u0003\u0002~\u0005}$\u0001C%uKJ\f'\r\\3\u000b\u0007\u0005e\u0014\u000eE\u0002e\u0003\u0007K1!!\"_\u0005I\u0001&o\u001c3vG\u0016\u00148\u000b^1uK\u0016sGO]=\t\u000f\u0005%U\u00051\u0001\u0002\f\u0006!a-\u001b7f!\u0011\ti)a%\u000e\u0005\u0005=%bAAIw\u0006\u0011\u0011n\\\u0005\u0005\u0003+\u000byI\u0001\u0003GS2,\u0017!D<sSR,7K\\1qg\"|G\u000f\u0006\u0004\u0002\u001c\u0006\u0005\u00161\u0015\t\u0004Q\u0006u\u0015bAAPS\n!QK\\5u\u0011\u001d\tII\na\u0001\u0003\u0017Cq!!*'\u0001\u0004\t9+A\u0004f]R\u0014\u0018.Z:\u0011\u0011\u0005%\u00161WA\\\u0003\u0003k!!a+\u000b\t\u00055\u0016qV\u0001\b[V$\u0018M\u00197f\u0015\r\t\t,[\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA[\u0003W\u00131!T1q!\rA\u0017\u0011X\u0005\u0004\u0003wK'\u0001\u0002'p]\u001e\fa\"[:T]\u0006\u00048\u000f[8u\r&dW\r\u0006\u0003\u0002B\u0006\u001d\u0007c\u00015\u0002D&\u0019\u0011QY5\u0003\u000f\t{w\u000e\\3b]\"9\u0011\u0011R\u0014A\u0002\u0005-\u0015!\u00057jgR\u001cf.\u00199tQ>$h)\u001b7fgR!\u0011QZAj!\u0019\tY'a4\u0002\f&!\u0011\u0011[A@\u0005\r\u0019V-\u001d\u0005\b\u0003+D\u0003\u0019AAF\u0003\r!\u0017N]\u0001\u0016I\u0016dW\r^3T]\u0006\u00048\u000f[8ug\n+gm\u001c:f)\u0019\tY*a7\u0002^\"9\u0011Q[\u0015A\u0002\u0005-\u0005bBApS\u0001\u0007\u0011qW\u0001\u0007_\u001a47/\u001a;\u0002'\u0011,G.\u001a;f':\f\u0007o\u001d5pi\u001aKG.Z:\u0015\r\u0005m\u0015Q]At\u0011\u001d\t)N\u000ba\u0001\u0003\u0017C\u0011\"!;+!\u0003\u0005\r!a;\u0002\u0013A\u0014X\rZ5dCR,\u0007c\u00025\u0002n\u0006]\u0016\u0011Y\u0005\u0004\u0003_L'!\u0003$v]\u000e$\u0018n\u001c82\u0003u!W\r\\3uKNs\u0017\r]:i_R4\u0015\u000e\\3tI\u0011,g-Y;mi\u0012\u0012TCAA{U\u0011\tY/a>,\u0005\u0005e\b\u0003BA~\u0005\u000bi!!!@\u000b\t\u0005}(\u0011A\u0001\nk:\u001c\u0007.Z2lK\u0012T1Aa\u0001j\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005\u000f\tiPA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u001aTC\u0001B\u0007U\u0011\ti#a>\u0014\t5:'\u0011\u0003\t\u0005\u0005'\u0011I\"\u0004\u0002\u0003\u0016)\u0019!q\u00031\u0002\u000bU$\u0018\u000e\\:\n\t\tm!Q\u0003\u0002\b\u0019><w-\u001b8h\u00039!x\u000e]5d!\u0006\u0014H/\u001b;j_:,\"A!\t\u0011\t\t\r\"QE\u0007\u0003\u0003\u001bJAAa\n\u0002N\tqAk\u001c9jGB\u000b'\u000f^5uS>t\u0017a\u0004;pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0011\u0002\r1|w\rR5s+\t\tY)\u0001\u0006m_\u001e$\u0015N]0%KF$B!a'\u00034!I!QG\u0019\u0002\u0002\u0003\u0007\u00111R\u0001\u0004q\u0012\n\u0014a\u00027pO\u0012K'\u000f\t\u0015\u0004e\tm\u0002c\u00015\u0003>%\u0019!qH5\u0003\u0011Y|G.\u0019;jY\u0016\f\u0011$\\1y!J|G-^2fe&#W\t\u001f9je\u0006$\u0018n\u001c8Ng\u0006QR.\u0019=Qe>$WoY3s\u0013\u0012,\u0005\u0010]5sCRLwN\\'tAQA!q\tB%\u0005\u0017\u0012i\u0005\u0005\u0002e[!9!QD\u001bA\u0002\t\u0005\u0002b\u0002B\u0016k\u0001\u0007\u00111\u0012\u0005\n\u0005\u0003*\u0004\u0013!a\u0001\u0003[\t\u0011\u0002\u001d:pIV\u001cWM]:\u0016\u0005\u0005\u001d\u0016A\u00039s_\u0012,8-\u001a:tA\u0005iA.Y:u\u001b\u0006\u0004xJ\u001a4tKR,\"!a.\u0002#1\f7\u000f^'ba>3gm]3u?\u0012*\u0017\u000f\u0006\u0003\u0002\u001c\nu\u0003\"\u0003B\u001bs\u0005\u0005\t\u0019AA\\\u00039a\u0017m\u001d;NCB|eMZ:fi\u0002\na\u0002\\1tiNs\u0017\r](gMN,G/\u0001\nmCN$8K\\1q\u001f\u001a47/\u001a;`I\u0015\fH\u0003BAN\u0005OB\u0011B!\u000e=\u0003\u0003\u0005\r!a.\u0002\u001f1\f7\u000f^*oCB|eMZ:fi\u0002\n1b\u001c8h_&tw\r\u0016=ogV\u0011!q\u000e\t\t\u0005c\u00129(a.\u0003|5\u0011!1\u000f\u0006\u0004\u0005kZ\u0018\u0001B;uS2LAA!\u001f\u0003t\t9AK]3f\u001b\u0006\u0004\bc\u00013\u0003~%\u0019!q\u00100\u0003\u0017QCh.T3uC\u0012\fG/Y\u0001\r_:<w.\u001b8h)bt7\u000fI\u0001\u0011k:\u0014X\r\u001d7jG\u0006$X\r\u001a+y]N\f\u0011#\u001e8sKBd\u0017nY1uK\u0012$\u0006P\\:!\u0003M1\u0017N]:u+:\u001cH/\u00192mK>3gm]3u+\t\u0011Y\tE\u0003i\u0005\u001b\u0013\t*C\u0002\u0003\u0010&\u0014aa\u00149uS>t\u0007\u0003\u0002BJ\u00053k!A!&\u000b\u0007\t]\u0005-\u0001\u0004tKJ4XM]\u0005\u0005\u00057\u0013)JA\tM_\u001e|eMZ:fi6+G/\u00193bi\u0006\fac\u001c8IS\u001eDw+\u0019;fe6\f'o[+qI\u0006$X\r\u001a\u000b\u0005\u00037\u0013\t\u000bC\u0004\u0003$\u000e\u0003\r!a.\u0002\u001b!Lw\r[,bi\u0016\u0014X.\u0019:l\u0003Q1\u0017N]:u+:$WmY5eK\u0012|eMZ:fiV\u0011!\u0011\u0016\t\u0006Q\n5\u0015qW\u0001\r[\u0006\u0004XI\u001c3PM\u001a\u001cX\r^\u0001\u0010C\u000e$\u0018N^3Qe>$WoY3sgV\u0011!\u0011\u0017\t\t\u0005g\u0013I,a.\u0002\u00026\u0011!Q\u0017\u0006\u0005\u0005o\u000by+A\u0005j[6,H/\u00192mK&!\u0011Q\u0017B[\u0003\u001dI7/R7qif,\"!!1\u0002!1|\u0017\r\u001a$s_6\u001cf.\u00199tQ>$HCBAN\u0005\u0007\u00149\rC\u0004\u0003F\"\u0003\r!a.\u0002\u001d1|wm\u0015;beR|eMZ:fi\"9!\u0011\u001a%A\u0002\u0005]\u0016aC2veJ,g\u000e\u001e+j[\u0016\f\u0011\u0003\\8bIB\u0013x\u000eZ;dKJ,e\u000e\u001e:z)\u0011\tYJa4\t\u000f\tE\u0017\n1\u0001\u0002\u0002\u0006)QM\u001c;ss\u0006\t\u0012n\u001d)s_\u0012,8-\u001a:FqBL'/\u001a3\u0015\r\u0005\u0005'q\u001bBn\u0011\u001d\u0011IN\u0013a\u0001\u0003o\u000bQbY;se\u0016tG\u000fV5nK6\u001b\bb\u0002Bo\u0015\u0002\u0007\u0011\u0011Q\u0001\u000eaJ|G-^2feN#\u0018\r^3\u0002-I,Wn\u001c<f\u000bb\u0004\u0018N]3e!J|G-^2feN$B!a'\u0003d\"9!\u0011\\&A\u0002\u0005]\u0016!\u0005;sk:\u001c\u0017\r^3B]\u0012\u0014V\r\\8bIRA\u00111\u0014Bu\u0005W\u0014y\u000fC\u0004\u0003F2\u0003\r!a.\t\u000f\t5H\n1\u0001\u00028\u0006aAn\\4F]\u0012|eMZ:fi\"9!\u0011\u001c'A\u0002\u0005]\u0016!\u00049sKB\f'/Z+qI\u0006$X\r\u0006\u0004\u0003v\nm(q \t\u0004I\n]\u0018b\u0001B}=\n\u0011\u0002K]8ek\u000e,'/\u00119qK:$\u0017J\u001c4p\u0011\u001d\u0011i0\u0014a\u0001\u0003o\u000b!\u0002\u001d:pIV\u001cWM]%e\u0011\u001d\u0019\t!\u0014a\u0001\u0003\u0003\fA\"[:Ge>l7\t\\5f]R\fa!\u001e9eCR,G\u0003BAN\u0007\u000fAqa!\u0003O\u0001\u0004\u0011)0\u0001\u0006baB,g\u000eZ%oM>\f!#\u001e9eCR,W*\u00199F]\u0012|eMZ:fiR!\u00111TB\b\u0011\u001d\u0019\tb\u0014a\u0001\u0003o\u000b!\u0002\\1ti>3gm]3u\u0003%a\u0017m\u001d;F]R\u0014\u0018\u0010\u0006\u0003\u0004\u0018\re\u0001#\u00025\u0003\u000e\u0006\u0005\u0005b\u0002B\u007f!\u0002\u0007\u0011qW\u0001\ri\u0006\\Wm\u00158baNDw\u000e\u001e\u000b\u0003\u00037\u000bA\u0003\\1uKN$8K\\1qg\"|Go\u00144gg\u0016$\u0018\u0001F8mI\u0016\u001cHo\u00158baNDw\u000e^(gMN,G/\u0001\u0007ueVt7-\u0019;f\u0011\u0016\fG\r\u0006\u0003\u0002\u001c\u000e\u001d\u0002b\u0002Bc)\u0002\u0007\u0011qW\u0001\u001fe\u0016lwN^3V]J,\u0007\u000f\\5dCR,G\r\u0016:b]N\f7\r^5p]N$B!a'\u0004.!9\u0011q\\+A\u0002\u0005]\u0016\u0001\u0003;sk:\u001c\u0017\r^3\u0002!1\f7\u000f^*uC\ndWm\u00144gg\u0016$H\u0003BA\\\u0007kAqaa\u000eX\u0001\u0004\u0019I$\u0001\u0007d_6\u0004H.\u001a;fIRCh\u000eE\u0002e\u0007wI1a!\u0010_\u00051\u0019u.\u001c9mKR,G\r\u0016=o\u0003-\u0019w.\u001c9mKR,G\u000b\u001f8\u0015\t\u0005m51\t\u0005\b\u0007oA\u0006\u0019AB\u001d)\u0011\tYja\u0012\t\u000f\u0005}\u0017\f1\u0001\u00028\"\u001a\u0011la\u0013\u0011\t\tM1QJ\u0005\u0005\u0007\u001f\u0012)B\u0001\u0006uQJ,\u0017\rZ:bM\u0016\f!c\u001c7eKN$8K\\1qg\"|GOR5mKV\u00111Q\u000b\t\u0006Q\n5\u00151R\u0001\u0013Y\u0006$Xm\u001d;T]\u0006\u00048\u000f[8u\r&dW-\u0006\u0002\u0002N\"\u001aQf!\u0018\u0011\t\tM1qL\u0005\u0005\u0007C\u0012)BA\u0007o_:$\bN]3bIN\fg-\u001a")
public class ProducerStateManager
implements Logging {
    private final TopicPartition topicPartition;
    private volatile File logDir;
    private final int maxProducerIdExpirationMs;
    private final Map<Object, ProducerStateEntry> producers;
    private long lastMapOffset;
    private long lastSnapOffset;
    private final TreeMap<Object, TxnMetadata> ongoingTxns;
    private final TreeMap<Object, TxnMetadata> unreplicatedTxns;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static int $lessinit$greater$default$3() {
        return ProducerStateManager$.MODULE$.$lessinit$greater$default$3();
    }

    public static Iterable<ProducerStateEntry> readSnapshot(File file) {
        return ProducerStateManager$.MODULE$.readSnapshot(file);
    }

    public static Schema PidSnapshotMapSchema() {
        return ProducerStateManager$.MODULE$.PidSnapshotMapSchema();
    }

    public static Schema ProducerSnapshotEntrySchema() {
        return ProducerStateManager$.MODULE$.ProducerSnapshotEntrySchema();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        ProducerStateManager producerStateManager = this;
        synchronized (producerStateManager) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public File logDir() {
        return this.logDir;
    }

    public void logDir_$eq(File x$1) {
        this.logDir = x$1;
    }

    public int maxProducerIdExpirationMs() {
        return this.maxProducerIdExpirationMs;
    }

    private Map<Object, ProducerStateEntry> producers() {
        return this.producers;
    }

    private long lastMapOffset() {
        return this.lastMapOffset;
    }

    private void lastMapOffset_$eq(long x$1) {
        this.lastMapOffset = x$1;
    }

    private long lastSnapOffset() {
        return this.lastSnapOffset;
    }

    private void lastSnapOffset_$eq(long x$1) {
        this.lastSnapOffset = x$1;
    }

    private TreeMap<Object, TxnMetadata> ongoingTxns() {
        return this.ongoingTxns;
    }

    private TreeMap<Object, TxnMetadata> unreplicatedTxns() {
        return this.unreplicatedTxns;
    }

    /*
     * WARNING - void declaration
     */
    public Option<LogOffsetMetadata> firstUnstableOffset() {
        void var1_1;
        Option unreplicatedFirstOffset = Option$.MODULE$.apply(this.unreplicatedTxns().firstEntry()).map((Function1 & Serializable)x$3 -> ((TxnMetadata)x$3.getValue()).firstOffset());
        Option undecidedFirstOffset = Option$.MODULE$.apply(this.ongoingTxns().firstEntry()).map((Function1 & Serializable)x$4 -> ((TxnMetadata)x$4.getValue()).firstOffset());
        return unreplicatedFirstOffset.isEmpty() ? undecidedFirstOffset : (undecidedFirstOffset.isEmpty() ? unreplicatedFirstOffset : (((LogOffsetMetadata)undecidedFirstOffset.get()).messageOffset() < ((LogOffsetMetadata)unreplicatedFirstOffset.get()).messageOffset() ? undecidedFirstOffset : var1_1));
    }

    public void onHighWatermarkUpdated(long highWatermark) {
        this.removeUnreplicatedTransactions(highWatermark);
    }

    public Option<Object> firstUndecidedOffset() {
        return Option$.MODULE$.apply(this.ongoingTxns().firstEntry()).map((Function1 & Serializable)x$5 -> BoxesRunTime.boxToLong((long)ProducerStateManager.$anonfun$firstUndecidedOffset$1(x$5)));
    }

    public long mapEndOffset() {
        return this.lastMapOffset();
    }

    public scala.collection.immutable.Map<Object, ProducerStateEntry> activeProducers() {
        return this.producers().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public boolean isEmpty() {
        return this.producers().isEmpty() && this.unreplicatedTxns().isEmpty();
    }

    private void loadFromSnapshot(long logStartOffset, long currentTime) {
        while (true) {
            Option<File> option;
            if ((option = this.latestSnapshotFile()) instanceof Some) {
                Some some = (Some)option;
                File file = (File)some.value();
                try {
                    this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(44).append("Loading producer state from snapshot file '").append(file).append("'").toString());
                    Iterable loadedProducers = (Iterable)ProducerStateManager$.MODULE$.readSnapshot(file).filter((Function1 & Serializable)producerEntry -> BoxesRunTime.boxToBoolean((boolean)ProducerStateManager.$anonfun$loadFromSnapshot$2(this, currentTime, producerEntry)));
                    loadedProducers.foreach((Function1 & Serializable)entry -> {
                        this.loadProducerEntry(entry);
                        return BoxedUnit.UNIT;
                    });
                    this.lastSnapOffset_$eq(Log$.MODULE$.offsetFromFile(file));
                    this.lastMapOffset_$eq(this.lastSnapOffset());
                    return;
                }
                catch (CorruptSnapshotException e) {
                    this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(42).append("Failed to load producer snapshot from '").append(file).append("': ").append(e.getMessage()).toString());
                    boolean bl = Files.deleteIfExists(file.toPath());
                }
            } else {
                if (None$.MODULE$.equals(option)) {
                    this.lastSnapOffset_$eq(logStartOffset);
                    this.lastMapOffset_$eq(logStartOffset);
                    return;
                }
                throw new MatchError(option);
            }
        }
    }

    public void loadProducerEntry(ProducerStateEntry entry) {
        long producerId = entry.producerId();
        this.producers().put((Object)BoxesRunTime.boxToLong((long)producerId), (Object)entry);
        entry.currentTxnFirstOffset().foreach((Function1 & Serializable)offset -> ProducerStateManager.$anonfun$loadProducerEntry$1(this, producerId, BoxesRunTime.unboxToLong((Object)offset)));
    }

    private boolean isProducerExpired(long currentTimeMs, ProducerStateEntry producerState) {
        return producerState.currentTxnFirstOffset().isEmpty() && currentTimeMs - producerState.lastTimestamp() >= (long)this.maxProducerIdExpirationMs();
    }

    public void removeExpiredProducers(long currentTimeMs) {
        this.producers().retain((Function2 & Serializable)(x0$1, x1$1) -> BoxesRunTime.boxToBoolean((boolean)ProducerStateManager.$anonfun$removeExpiredProducers$1(this, currentTimeMs, BoxesRunTime.unboxToLong((Object)x0$1), x1$1)));
    }

    public void truncateAndReload(long logStartOffset, long logEndOffset, long currentTimeMs) {
        ProducerStateManager$.MODULE$.kafka$log$ProducerStateManager$$deleteSnapshotFiles(this.logDir(), (Function1<Object, Object>)(JFunction1.mcZJ.sp & Serializable)snapOffset -> snapOffset > logEndOffset || snapOffset <= logStartOffset);
        if (logEndOffset != this.mapEndOffset()) {
            this.producers().clear();
            this.ongoingTxns().clear();
            this.unreplicatedTxns().clear();
            this.loadFromSnapshot(logStartOffset, currentTimeMs);
        } else {
            this.truncateHead(logStartOffset);
        }
    }

    public ProducerAppendInfo prepareUpdate(long producerId, boolean isFromClient) {
        Product product;
        if (!isFromClient) {
            product = ValidationType$None$.MODULE$;
        } else {
            String string = this.topicPartition().topic();
            String string2 = "__consumer_offsets";
            product = !(string != null ? !string.equals(string2) : string2 != null) ? ValidationType$EpochOnly$.MODULE$ : ValidationType$Full$.MODULE$;
        }
        ValidationType$None$ validationToPerform = product;
        ProducerStateEntry currentEntry = (ProducerStateEntry)this.lastEntry(producerId).getOrElse((Function0 & Serializable)() -> ProducerStateEntry$.MODULE$.empty(producerId));
        return new ProducerAppendInfo(this.topicPartition(), producerId, currentEntry, validationToPerform);
    }

    public void update(ProducerAppendInfo appendInfo) {
        BoxedUnit boxedUnit;
        if (appendInfo.producerId() == -1L) {
            throw new IllegalArgumentException(new StringBuilder(0).append(new StringBuilder(38).append("Invalid producer id ").append(appendInfo.producerId()).append(" passed to update ").toString()).append(new StringBuilder(14).append("for partition ").append(this.topicPartition()).toString()).toString());
        }
        this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(27).append("Updated producer ").append(appendInfo.producerId()).append(" state to ").append(appendInfo).toString());
        ProducerStateEntry updatedEntry = appendInfo.toEntry();
        Option option = this.producers().get((Object)BoxesRunTime.boxToLong((long)appendInfo.producerId()));
        if (option instanceof Some) {
            Some some = (Some)option;
            ProducerStateEntry currentEntry = (ProducerStateEntry)some.value();
            currentEntry.update(updatedEntry);
            boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            boxedUnit = this.producers().put((Object)BoxesRunTime.boxToLong((long)appendInfo.producerId()), (Object)updatedEntry);
        } else {
            throw new MatchError((Object)option);
        }
        appendInfo.startedTransactions().foreach((Function1 & Serializable)txn -> this.ongoingTxns().put(BoxesRunTime.boxToLong((long)txn.firstOffset().messageOffset()), (TxnMetadata)txn));
    }

    public void updateMapEndOffset(long lastOffset) {
        this.lastMapOffset_$eq(lastOffset);
    }

    public Option<ProducerStateEntry> lastEntry(long producerId) {
        return this.producers().get((Object)BoxesRunTime.boxToLong((long)producerId));
    }

    public void takeSnapshot() {
        block0: {
            if (this.lastMapOffset() <= this.lastSnapOffset()) break block0;
            File snapshotFile = Log$.MODULE$.producerSnapshotFile(this.logDir(), this.lastMapOffset());
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(36).append("Writing producer snapshot at offset ").append(this.lastMapOffset()).toString());
            ProducerStateManager$.MODULE$.kafka$log$ProducerStateManager$$writeSnapshot(snapshotFile, this.producers());
            this.lastSnapOffset_$eq(this.lastMapOffset());
        }
    }

    public Option<Object> latestSnapshotOffset() {
        return this.latestSnapshotFile().map((Function1 & Serializable)file -> BoxesRunTime.boxToLong((long)Log$.MODULE$.offsetFromFile(file)));
    }

    public Option<Object> oldestSnapshotOffset() {
        return this.oldestSnapshotFile().map((Function1 & Serializable)file -> BoxesRunTime.boxToLong((long)Log$.MODULE$.offsetFromFile(file)));
    }

    public void truncateHead(long logStartOffset) {
        this.removeUnreplicatedTransactions(logStartOffset);
        if (this.lastMapOffset() < logStartOffset) {
            this.lastMapOffset_$eq(logStartOffset);
        }
        this.deleteSnapshotsBefore(logStartOffset);
        this.lastSnapOffset_$eq(BoxesRunTime.unboxToLong((Object)this.latestSnapshotOffset().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> logStartOffset)));
    }

    private void removeUnreplicatedTransactions(long offset) {
        Iterator<Map.Entry<Object, TxnMetadata>> iterator = this.unreplicatedTxns().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, TxnMetadata> txnEntry = iterator.next();
            Option<Object> lastOffset = txnEntry.getValue().lastOffset();
            if (!lastOffset.exists((Function1)(JFunction1.mcZJ.sp & Serializable)x$6 -> x$6 < offset)) continue;
            iterator.remove();
        }
    }

    public void truncate() {
        this.producers().clear();
        this.ongoingTxns().clear();
        this.unreplicatedTxns().clear();
        ProducerStateManager$.MODULE$.kafka$log$ProducerStateManager$$deleteSnapshotFiles(this.logDir(), ProducerStateManager$.MODULE$.kafka$log$ProducerStateManager$$deleteSnapshotFiles$default$2());
        this.lastSnapOffset_$eq(0L);
        this.lastMapOffset_$eq(0L);
    }

    public long lastStableOffset(CompletedTxn completedTxn) {
        Option nextIncompleteTxn = ((IterableOnceOps)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.ongoingTxns().values()).asScala()).find((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)ProducerStateManager.$anonfun$lastStableOffset$1(completedTxn, x$7)));
        return BoxesRunTime.unboxToLong((Object)nextIncompleteTxn.map((Function1 & Serializable)x$8 -> BoxesRunTime.boxToLong((long)ProducerStateManager.$anonfun$lastStableOffset$2(x$8))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> completedTxn.lastOffset() + 1L));
    }

    public void completeTxn(CompletedTxn completedTxn) {
        TxnMetadata txnMetadata = this.ongoingTxns().remove(BoxesRunTime.boxToLong((long)completedTxn.firstOffset()));
        if (txnMetadata == null) {
            throw new IllegalArgumentException(new StringBuilder(0).append(new StringBuilder(49).append("Attempted to complete transaction ").append(completedTxn).append(" on partition ").append(this.topicPartition()).append(" ").toString()).append("which was not started").toString());
        }
        txnMetadata.lastOffset_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)completedTxn.lastOffset())));
        this.unreplicatedTxns().put(BoxesRunTime.boxToLong((long)completedTxn.firstOffset()), txnMetadata);
    }

    public void deleteSnapshotsBefore(long offset) {
        ProducerStateManager$.MODULE$.deleteSnapshotsBefore(this.logDir(), offset);
    }

    private Option<File> oldestSnapshotFile() {
        Seq<File> files = this.listSnapshotFiles();
        return files.nonEmpty() ? new Some(files.minBy((Function1 & Serializable)file -> BoxesRunTime.boxToLong((long)Log$.MODULE$.offsetFromFile(file)), (Ordering)Ordering.Long$.MODULE$)) : None$.MODULE$;
    }

    private Option<File> latestSnapshotFile() {
        Seq<File> files = this.listSnapshotFiles();
        return files.nonEmpty() ? new Some(files.maxBy((Function1 & Serializable)file -> BoxesRunTime.boxToLong((long)Log$.MODULE$.offsetFromFile(file)), (Ordering)Ordering.Long$.MODULE$)) : None$.MODULE$;
    }

    private Seq<File> listSnapshotFiles() {
        return ProducerStateManager$.MODULE$.listSnapshotFiles(this.logDir());
    }

    public static final /* synthetic */ long $anonfun$firstUndecidedOffset$1(Map.Entry x$5) {
        return ((TxnMetadata)x$5.getValue()).firstOffset().messageOffset();
    }

    public static final /* synthetic */ boolean $anonfun$loadFromSnapshot$2(ProducerStateManager $this, long currentTime$1, ProducerStateEntry producerEntry) {
        return !$this.isProducerExpired(currentTime$1, producerEntry);
    }

    public static final /* synthetic */ TxnMetadata $anonfun$loadProducerEntry$1(ProducerStateManager $this, long producerId$1, long offset) {
        return $this.ongoingTxns().put(BoxesRunTime.boxToLong((long)offset), new TxnMetadata(producerId$1, offset));
    }

    public static final /* synthetic */ boolean $anonfun$removeExpiredProducers$1(ProducerStateManager $this, long currentTimeMs$1, long x0$1, ProducerStateEntry x1$1) {
        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToLong((long)x0$1), (Object)x1$1);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        ProducerStateEntry lastEntry = (ProducerStateEntry)tuple2._2();
        boolean bl = !$this.isProducerExpired(currentTimeMs$1, lastEntry);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$lastStableOffset$1(CompletedTxn completedTxn$1, TxnMetadata x$7) {
        return x$7.producerId() != completedTxn$1.producerId();
    }

    public static final /* synthetic */ long $anonfun$lastStableOffset$2(TxnMetadata x$8) {
        return x$8.firstOffset().messageOffset();
    }

    public ProducerStateManager(TopicPartition topicPartition, File logDir, int maxProducerIdExpirationMs) {
        this.topicPartition = topicPartition;
        this.logDir = logDir;
        this.maxProducerIdExpirationMs = maxProducerIdExpirationMs;
        Logging.$init$(this);
        this.logIdent_$eq(new StringBuilder(34).append("[ProducerStateManager partition=").append(topicPartition).append("] ").toString());
        this.producers = (Map)Map$.MODULE$.empty();
        this.lastMapOffset = 0L;
        this.lastSnapOffset = 0L;
        this.ongoingTxns = new TreeMap();
        this.unreplicatedTxns = new TreeMap();
    }
}

