/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.text.NumberFormat;
import java.util.UUID;
import java.util.regex.Pattern;
import kafka.log.Log;
import kafka.log.LogConfig;
import kafka.log.LogSegment;
import kafka.log.ProducerStateManager;
import kafka.server.BrokerTopicStats;
import kafka.server.LogDirFailureChannel;
import kafka.utils.Scheduler;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Time;
import scala.Function1;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.math.Numeric;
import scala.runtime.BoxesRunTime;

public final class Log$ {
    public static final Log$ MODULE$ = new Log$();
    private static final String LogFileSuffix = ".log";
    private static final String IndexFileSuffix = ".index";
    private static final String TimeIndexFileSuffix = ".timeindex";
    private static final String ProducerSnapshotFileSuffix = ".snapshot";
    private static final String TxnIndexFileSuffix = ".txnindex";
    private static final String DeletedFileSuffix = ".deleted";
    private static final String CleanedFileSuffix = ".cleaned";
    private static final String SwapFileSuffix = ".swap";
    private static final String CleanShutdownFile = ".kafka_cleanshutdown";
    private static final String DeleteDirSuffix = "-delete";
    private static final String FutureDirSuffix = "-future";
    private static final Pattern DeleteDirPattern = Pattern.compile(new StringBuilder(19).append("^(\\S+)-(\\S+)\\.(\\S+)").append(MODULE$.DeleteDirSuffix()).toString());
    private static final Pattern FutureDirPattern = Pattern.compile(new StringBuilder(19).append("^(\\S+)-(\\S+)\\.(\\S+)").append(MODULE$.FutureDirSuffix()).toString());
    private static final long UnknownOffset = -1L;

    public String LogFileSuffix() {
        return LogFileSuffix;
    }

    public String IndexFileSuffix() {
        return IndexFileSuffix;
    }

    public String TimeIndexFileSuffix() {
        return TimeIndexFileSuffix;
    }

    public String ProducerSnapshotFileSuffix() {
        return ProducerSnapshotFileSuffix;
    }

    public String TxnIndexFileSuffix() {
        return TxnIndexFileSuffix;
    }

    public String DeletedFileSuffix() {
        return DeletedFileSuffix;
    }

    public String CleanedFileSuffix() {
        return CleanedFileSuffix;
    }

    public String SwapFileSuffix() {
        return SwapFileSuffix;
    }

    public String CleanShutdownFile() {
        return CleanShutdownFile;
    }

    public String DeleteDirSuffix() {
        return DeleteDirSuffix;
    }

    public String FutureDirSuffix() {
        return FutureDirSuffix;
    }

    public Pattern DeleteDirPattern() {
        return DeleteDirPattern;
    }

    public Pattern FutureDirPattern() {
        return FutureDirPattern;
    }

    public long UnknownOffset() {
        return UnknownOffset;
    }

    public Log apply(File dir, LogConfig config, long logStartOffset, long recoveryPoint, Scheduler scheduler, BrokerTopicStats brokerTopicStats, Time time, int maxProducerIdExpirationMs, int producerIdExpirationCheckIntervalMs, LogDirFailureChannel logDirFailureChannel) {
        TopicPartition topicPartition = this.parseTopicPartitionName(dir);
        ProducerStateManager producerStateManager = new ProducerStateManager(topicPartition, dir, maxProducerIdExpirationMs);
        return new Log(dir, config, logStartOffset, recoveryPoint, scheduler, brokerTopicStats, time, maxProducerIdExpirationMs, producerIdExpirationCheckIntervalMs, topicPartition, producerStateManager, logDirFailureChannel);
    }

    public Time apply$default$7() {
        return Time.SYSTEM;
    }

    public String filenamePrefixFromOffset(long offset) {
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMinimumIntegerDigits(20);
        nf.setMaximumFractionDigits(0);
        nf.setGroupingUsed(false);
        return nf.format(offset);
    }

    public File logFile(File dir, long offset, String suffix) {
        return new File(dir, new StringBuilder(0).append(this.filenamePrefixFromOffset(offset)).append(this.LogFileSuffix()).append(suffix).toString());
    }

    public String logFile$default$3() {
        return "";
    }

    public String logDeleteDirName(TopicPartition topicPartition) {
        String uniqueId = UUID.randomUUID().toString().replaceAll("-", "");
        String suffix = new StringBuilder(2).append("-").append(topicPartition.partition()).append(".").append(uniqueId).append(this.DeleteDirSuffix()).toString();
        int prefixLength = Math.min(StringOps$.MODULE$.size$extension(Predef$.MODULE$.augmentString(topicPartition.topic())), 255 - StringOps$.MODULE$.size$extension(Predef$.MODULE$.augmentString(suffix)));
        return new StringBuilder(0).append(topicPartition.topic().substring(0, prefixLength)).append(suffix).toString();
    }

    public String logFutureDirName(TopicPartition topicPartition) {
        return this.logDirNameWithSuffix(topicPartition, this.FutureDirSuffix());
    }

    private String logDirNameWithSuffix(TopicPartition topicPartition, String suffix) {
        String uniqueId = UUID.randomUUID().toString().replaceAll("-", "");
        return new StringBuilder(1).append(this.logDirName(topicPartition)).append(".").append(uniqueId).append(suffix).toString();
    }

    public String logDirName(TopicPartition topicPartition) {
        return new StringBuilder(1).append(topicPartition.topic()).append("-").append(topicPartition.partition()).toString();
    }

    public File offsetIndexFile(File dir, long offset, String suffix) {
        return new File(dir, new StringBuilder(0).append(this.filenamePrefixFromOffset(offset)).append(this.IndexFileSuffix()).append(suffix).toString());
    }

    public String offsetIndexFile$default$3() {
        return "";
    }

    public File timeIndexFile(File dir, long offset, String suffix) {
        return new File(dir, new StringBuilder(0).append(this.filenamePrefixFromOffset(offset)).append(this.TimeIndexFileSuffix()).append(suffix).toString());
    }

    public String timeIndexFile$default$3() {
        return "";
    }

    public void deleteFileIfExists(File file, String suffix) {
        Files.deleteIfExists(new File(new StringBuilder(0).append(file.getPath()).append(suffix).toString()).toPath());
    }

    public String deleteFileIfExists$default$2() {
        return "";
    }

    public File producerSnapshotFile(File dir, long offset) {
        return new File(dir, new StringBuilder(0).append(this.filenamePrefixFromOffset(offset)).append(this.ProducerSnapshotFileSuffix()).toString());
    }

    public File transactionIndexFile(File dir, long offset, String suffix) {
        return new File(dir, new StringBuilder(0).append(this.filenamePrefixFromOffset(offset)).append(this.TxnIndexFileSuffix()).append(suffix).toString());
    }

    public String transactionIndexFile$default$3() {
        return "";
    }

    public long offsetFromFileName(String filename) {
        return StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(filename.substring(0, filename.indexOf(46))));
    }

    public long offsetFromFile(File file) {
        return this.offsetFromFileName(file.getName());
    }

    public long sizeInBytes(Iterable<LogSegment> segments) {
        return BoxesRunTime.unboxToLong((Object)((IterableOnceOps)segments.map((Function1 & Serializable)x$49 -> BoxesRunTime.boxToLong((long)x$49.size()))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    public TopicPartition parseTopicPartitionName(File dir) {
        int n;
        if (dir == null) {
            throw new KafkaException("dir should not be null");
        }
        String dirName = dir.getName();
        if (dirName == null || dirName.isEmpty() || !StringOps$.MODULE$.contains$extension(Predef$.MODULE$.augmentString(dirName), '-')) {
            throw Log$.exception$1(dir);
        }
        if (dirName.endsWith(this.DeleteDirSuffix()) && !this.DeleteDirPattern().matcher(dirName).matches() || dirName.endsWith(this.FutureDirSuffix()) && !this.FutureDirPattern().matcher(dirName).matches()) {
            throw Log$.exception$1(dir);
        }
        String name = dirName.endsWith(this.DeleteDirSuffix()) || dirName.endsWith(this.FutureDirSuffix()) ? dirName.substring(0, dirName.lastIndexOf(46)) : dirName;
        int index = name.lastIndexOf(45);
        String topic = name.substring(0, index);
        String partitionString = name.substring(index + 1);
        if (topic.isEmpty() || partitionString.isEmpty()) {
            throw Log$.exception$1(dir);
        }
        try {
            n = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(partitionString));
        }
        catch (NumberFormatException numberFormatException) {
            throw Log$.exception$1(dir);
        }
        int partition = n;
        return new TopicPartition(topic, partition);
    }

    public boolean kafka$log$Log$$isIndexFile(File file) {
        String filename = file.getName();
        return filename.endsWith(this.IndexFileSuffix()) || filename.endsWith(this.TimeIndexFileSuffix()) || filename.endsWith(this.TxnIndexFileSuffix());
    }

    public boolean kafka$log$Log$$isLogFile(File file) {
        return file.getPath().endsWith(this.LogFileSuffix());
    }

    private static final KafkaException exception$1(File dir) {
        return new KafkaException(new StringBuilder(153).append(new StringBuilder(43).append("Found directory ").append(dir.getCanonicalPath()).append(", '").append(dir.getName()).append("' is not in the form of ").toString()).append("topic-partition or topic-partition.uniqueId-delete (if marked for deletion).\n").append("Kafka's log directories (and children) should only contain Kafka topic data.").toString());
    }

    private Log$() {
    }
}

