/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Iterator;
import kafka.api.ApiVersion;
import kafka.api.KAFKA_2_1_IV0$;
import kafka.common.RecordValidationException;
import kafka.log.AppendOrigin;
import kafka.log.AppendOrigin$Client$;
import kafka.log.LogValidator;
import kafka.message.CompressionCodec;
import kafka.message.NoCompressionCodec$;
import kafka.message.ZStdCompressionCodec$;
import kafka.server.BrokerTopicStats;
import kafka.utils.Logging;
import org.apache.kafka.common.InvalidRecordException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.CorruptRecordException;
import org.apache.kafka.common.errors.InvalidTimestampException;
import org.apache.kafka.common.errors.UnsupportedCompressionTypeException;
import org.apache.kafka.common.errors.UnsupportedForMessageFormatException;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.AbstractRecords;
import org.apache.kafka.common.record.BufferSupplier;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.MutableRecordBatch;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.RecordConversionStats;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.utils.CloseableIterator;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.IterableView$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableViewLike;
import scala.collection.mutable.ArrayBuffer;
import scala.math.package$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;

public final class LogValidator$
implements Logging {
    public static LogValidator$ MODULE$;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new LogValidator$();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public LogValidator.ValidationAndOffsetAssignResult validateMessagesAndAssignOffsets(MemoryRecords records, TopicPartition topicPartition, kafka.common.LongRef offsetCounter, Time time, long now, CompressionCodec sourceCodec, CompressionCodec targetCodec, boolean compactedTopic, byte magic, TimestampType timestampType, long timestampDiffMaxMs, int partitionLeaderEpoch, AppendOrigin origin, ApiVersion interBrokerProtocolVersion, BrokerTopicStats brokerTopicStats) {
        CompressionCodec compressionCodec = sourceCodec;
        NoCompressionCodec$ noCompressionCodec$ = NoCompressionCodec$.MODULE$;
        if (!(compressionCodec != null ? !compressionCodec.equals(noCompressionCodec$) : noCompressionCodec$ != null)) {
            CompressionCodec compressionCodec2 = targetCodec;
            NoCompressionCodec$ noCompressionCodec$2 = NoCompressionCodec$.MODULE$;
            if (!(compressionCodec2 != null ? !compressionCodec2.equals(noCompressionCodec$2) : noCompressionCodec$2 != null)) {
                if (!records.hasMatchingMagic(magic)) {
                    return this.convertAndAssignOffsetsNonCompressed(records, topicPartition, offsetCounter, compactedTopic, time, now, timestampType, timestampDiffMaxMs, magic, partitionLeaderEpoch, origin, brokerTopicStats);
                }
                return this.assignOffsetsNonCompressed(records, topicPartition, offsetCounter, now, compactedTopic, timestampType, timestampDiffMaxMs, partitionLeaderEpoch, origin, magic, brokerTopicStats);
            }
        }
        return this.validateMessagesAndAssignOffsetsCompressed(records, topicPartition, offsetCounter, time, now, sourceCodec, targetCodec, compactedTopic, magic, timestampType, timestampDiffMaxMs, partitionLeaderEpoch, origin, interBrokerProtocolVersion, brokerTopicStats);
    }

    private RecordBatch getFirstBatchAndMaybeValidateNoMoreBatches(MemoryRecords records, CompressionCodec sourceCodec) {
        MutableRecordBatch batch;
        block6: {
            Iterator batchIterator;
            block5: {
                batchIterator = records.batches().iterator();
                if (!batchIterator.hasNext()) {
                    throw new InvalidRecordException("Record batch has no batches at all");
                }
                batch = (MutableRecordBatch)batchIterator.next();
                if (batch.magic() >= 2) break block5;
                CompressionCodec compressionCodec = sourceCodec;
                NoCompressionCodec$ noCompressionCodec$ = NoCompressionCodec$.MODULE$;
                if (!(compressionCodec == null ? noCompressionCodec$ != null : !compressionCodec.equals(noCompressionCodec$))) break block6;
            }
            if (batchIterator.hasNext()) {
                throw new InvalidRecordException("Compressed outer record has more than one batch");
            }
        }
        return batch;
    }

    private void validateBatch(TopicPartition topicPartition, RecordBatch firstBatch, RecordBatch batch, AppendOrigin origin, byte toMagic, BrokerTopicStats brokerTopicStats) {
        if (firstBatch.magic() != batch.magic()) {
            brokerTopicStats.allTopicsStats().invalidMagicNumberRecordsPerSec().mark();
            throw new InvalidRecordException(new StringBuilder(83).append("Batch magic ").append(batch.magic()).append(" is not the same as the first batch'es magic byte ").append(firstBatch.magic()).append(" in topic partition ").append(topicPartition).append(".").toString());
        }
        AppendOrigin appendOrigin = origin;
        AppendOrigin$Client$ appendOrigin$Client$ = AppendOrigin$Client$.MODULE$;
        if (!(appendOrigin != null ? !appendOrigin.equals(appendOrigin$Client$) : appendOrigin$Client$ != null)) {
            if (batch.magic() >= 2) {
                long countFromOffsets = batch.lastOffset() - batch.baseOffset() + 1L;
                if (countFromOffsets <= 0L) {
                    brokerTopicStats.allTopicsStats().invalidOffsetOrSequenceRecordsPerSec().mark();
                    throw new InvalidRecordException(new StringBuilder(60).append("Batch has an invalid offset range: [").append(batch.baseOffset()).append(", ").append(batch.lastOffset()).append("] in topic partition ").append(topicPartition).append(".").toString());
                }
                Integer count = batch.countOrNull();
                if (Predef$.MODULE$.Integer2int(count) <= 0) {
                    brokerTopicStats.allTopicsStats().invalidOffsetOrSequenceRecordsPerSec().mark();
                    throw new InvalidRecordException(new StringBuilder(62).append("Invalid reported count for record batch: ").append(count).append(" in topic partition ").append(topicPartition).append(".").toString());
                }
                if (!BoxesRunTime.equals((Object)BoxesRunTime.boxToLong((long)countFromOffsets), (Object)batch.countOrNull())) {
                    brokerTopicStats.allTopicsStats().invalidOffsetOrSequenceRecordsPerSec().mark();
                    throw new InvalidRecordException(new StringBuilder(79).append("Inconsistent batch offset range [").append(batch.baseOffset()).append(", ").append(batch.lastOffset()).append("] ").append("and count of records ").append(count).append(" in topic partition ").append(topicPartition).append(".").toString());
                }
            }
            if (batch.isControlBatch()) {
                brokerTopicStats.allTopicsStats().invalidOffsetOrSequenceRecordsPerSec().mark();
                throw new InvalidRecordException(new StringBuilder(69).append("Clients are not allowed to write control records in topic partition ").append(topicPartition).append(".").toString());
            }
            if (batch.hasProducerId() && batch.baseSequence() < 0) {
                brokerTopicStats.allTopicsStats().invalidOffsetOrSequenceRecordsPerSec().mark();
                throw new InvalidRecordException(new StringBuilder(78).append("Invalid sequence number ").append(batch.baseSequence()).append(" in record batch ").append("with producerId ").append(batch.producerId()).append(" in topic partition ").append(topicPartition).append(".").toString());
            }
        }
        if (batch.isTransactional() && toMagic < 2) {
            throw new UnsupportedForMessageFormatException(new StringBuilder(56).append("Transactional records cannot be used with magic version ").append(toMagic).toString());
        }
        if (batch.hasProducerId() && toMagic < 2) {
            throw new UnsupportedForMessageFormatException(new StringBuilder(53).append("Idempotent records cannot be used with magic version ").append(toMagic).toString());
        }
    }

    private Option<LogValidator.ApiRecordError> validateRecord(RecordBatch batch, TopicPartition topicPartition, Record record, int batchIndex, long now, TimestampType timestampType, long timestampDiffMaxMs, boolean compactedTopic, BrokerTopicStats brokerTopicStats) {
        if (!record.hasMagic(batch.magic())) {
            brokerTopicStats.allTopicsStats().invalidMagicNumberRecordsPerSec().mark();
            return new Some((Object)new LogValidator.ApiRecordError(Errors.INVALID_RECORD, new ProduceResponse.RecordError(batchIndex, new StringBuilder(64).append("Record ").append(record).append("'s magic does not match outer magic ").append(batch.magic()).append(" in topic partition ").append(topicPartition).append(".").toString())));
        }
        if (batch.magic() <= 1 && batch.isCompressed()) {
            try {
                record.ensureValid();
            }
            catch (InvalidRecordException e) {
                brokerTopicStats.allTopicsStats().invalidMessageCrcRecordsPerSec().mark();
                throw new CorruptRecordException(new StringBuilder(21).append(e.getMessage()).append(" in topic partition ").append(topicPartition).append(".").toString());
            }
        }
        Option option = this.validateKey(record, batchIndex, topicPartition, compactedTopic, brokerTopicStats);
        if (option == null) {
            throw null;
        }
        Option orElse_this = option;
        Option option2 = orElse_this.isEmpty() ? LogValidator$.MODULE$.validateTimestamp(batch, record, batchIndex, now, timestampType, timestampDiffMaxMs) : orElse_this;
        return option2;
    }

    private LogValidator.ValidationAndOffsetAssignResult convertAndAssignOffsetsNonCompressed(MemoryRecords records, TopicPartition topicPartition, kafka.common.LongRef offsetCounter, boolean compactedTopic, Time time, long now, TimestampType timestampType, long timestampDiffMaxMs, byte toMagicValue, int partitionLeaderEpoch, AppendOrigin origin, BrokerTopicStats brokerTopicStats) {
        long startNanos = time.nanoseconds();
        int sizeInBytesAfterConversion = AbstractRecords.estimateSizeInBytes((byte)toMagicValue, (long)offsetCounter.value(), (CompressionType)CompressionType.NONE, (java.lang.Iterable)records.records());
        MutableRecordBatch first = (MutableRecordBatch)((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records.batches()).asScala()).head();
        long l = first.producerId();
        short s = first.producerEpoch();
        int n = first.baseSequence();
        boolean bl = first.isTransactional();
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)ByteBuffer.allocate(sizeInBytesAfterConversion), (byte)toMagicValue, (CompressionType)CompressionType.NONE, (TimestampType)timestampType, (long)offsetCounter.value(), (long)now, (long)l, (short)s, (int)n, (boolean)bl, (int)partitionLeaderEpoch);
        RecordBatch firstBatch = this.getFirstBatchAndMaybeValidateNoMoreBatches(records, NoCompressionCodec$.MODULE$);
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records.batches()).asScala()).foreach((Function1 & Serializable & scala.Serializable)batch -> {
            LogValidator$.$anonfun$convertAndAssignOffsetsNonCompressed$1(topicPartition, firstBatch, origin, toMagicValue, brokerTopicStats, now, timestampType, timestampDiffMaxMs, compactedTopic, builder, offsetCounter, batch);
            return BoxedUnit.UNIT;
        });
        MemoryRecords convertedRecords = builder.build();
        MemoryRecordsBuilder.RecordsInfo info = builder.info();
        RecordConversionStats recordConversionStats = new RecordConversionStats((long)builder.uncompressedBytesWritten(), builder.numRecords(), time.nanoseconds() - startNanos);
        return new LogValidator.ValidationAndOffsetAssignResult(convertedRecords, info.maxTimestamp, info.shallowOffsetOfMaxTimestamp, true, recordConversionStats);
    }

    private LogValidator.ValidationAndOffsetAssignResult assignOffsetsNonCompressed(MemoryRecords records, TopicPartition topicPartition, kafka.common.LongRef offsetCounter, long now, boolean compactedTopic, TimestampType timestampType, long timestampDiffMaxMs, int partitionLeaderEpoch, AppendOrigin origin, byte magic, BrokerTopicStats brokerTopicStats) {
        LongRef maxTimestamp = LongRef.create((long)-1L);
        LongRef offsetOfMaxTimestamp = LongRef.create((long)-1L);
        long initialOffset = offsetCounter.value();
        RecordBatch firstBatch = this.getFirstBatchAndMaybeValidateNoMoreBatches(records, NoCompressionCodec$.MODULE$);
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records.batches()).asScala()).foreach((Function1 & Serializable & scala.Serializable)batch -> {
            LogValidator$.$anonfun$assignOffsetsNonCompressed$1(topicPartition, firstBatch, origin, magic, brokerTopicStats, now, timestampType, timestampDiffMaxMs, compactedTopic, offsetCounter, maxTimestamp, offsetOfMaxTimestamp, partitionLeaderEpoch, batch);
            return BoxedUnit.UNIT;
        });
        TimestampType timestampType2 = timestampType;
        TimestampType timestampType3 = TimestampType.LOG_APPEND_TIME;
        if (!(timestampType2 != null ? !timestampType2.equals(timestampType3) : timestampType3 != null)) {
            maxTimestamp.elem = now;
            offsetOfMaxTimestamp.elem = magic >= 2 ? offsetCounter.value() - 1L : initialOffset;
        }
        return new LogValidator.ValidationAndOffsetAssignResult(records, maxTimestamp.elem, offsetOfMaxTimestamp.elem, false, RecordConversionStats.EMPTY);
    }

    public LogValidator.ValidationAndOffsetAssignResult validateMessagesAndAssignOffsetsCompressed(MemoryRecords records, TopicPartition topicPartition, kafka.common.LongRef offsetCounter, Time time, long now, CompressionCodec sourceCodec, CompressionCodec targetCodec, boolean compactedTopic, byte toMagic, TimestampType timestampType, long timestampDiffMaxMs, int partitionLeaderEpoch, AppendOrigin origin, ApiVersion interBrokerProtocolVersion, BrokerTopicStats brokerTopicStats) {
        CompressionCodec compressionCodec = targetCodec;
        ZStdCompressionCodec$ zStdCompressionCodec$ = ZStdCompressionCodec$.MODULE$;
        if (!(compressionCodec != null ? !compressionCodec.equals(zStdCompressionCodec$) : zStdCompressionCodec$ != null) && interBrokerProtocolVersion.$less(KAFKA_2_1_IV0$.MODULE$)) {
            throw new UnsupportedCompressionTypeException("Produce requests to inter.broker.protocol.version < 2.1 broker are not allowed to use ZStandard compression");
        }
        CompressionCodec compressionCodec2 = sourceCodec;
        BooleanRef inPlaceAssignment = BooleanRef.create((!(compressionCodec2 != null ? !compressionCodec2.equals(targetCodec) : targetCodec != null) ? 1 : 0) != 0);
        LongRef maxTimestamp = LongRef.create((long)-1L);
        kafka.common.LongRef expectedInnerOffset = new kafka.common.LongRef(0L);
        ArrayBuffer validatedRecords = new ArrayBuffer();
        IntRef uncompressedSizeInBytes = IntRef.create((int)0);
        RecordBatch firstBatch = this.getFirstBatchAndMaybeValidateNoMoreBatches(records, sourceCodec);
        if (firstBatch.magic() != toMagic || toMagic == 0) {
            inPlaceAssignment.elem = false;
        }
        CompressionCodec compressionCodec3 = sourceCodec;
        NoCompressionCodec$ noCompressionCodec$ = NoCompressionCodec$.MODULE$;
        if (!(compressionCodec3 != null ? !compressionCodec3.equals(noCompressionCodec$) : noCompressionCodec$ != null) && firstBatch.isControlBatch()) {
            inPlaceAssignment.elem = true;
        }
        ((Iterable)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records.batches()).asScala()).foreach((Function1 & Serializable & scala.Serializable)batch -> {
            LogValidator$.$anonfun$validateMessagesAndAssignOffsetsCompressed$1(topicPartition, firstBatch, origin, toMagic, brokerTopicStats, uncompressedSizeInBytes, inPlaceAssignment, expectedInnerOffset, now, timestampType, timestampDiffMaxMs, compactedTopic, maxTimestamp, validatedRecords, sourceCodec, batch);
            return BoxedUnit.UNIT;
        });
        if (!inPlaceAssignment.elem) {
            MutableRecordBatch first = (MutableRecordBatch)((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records.batches()).asScala()).head();
            long l = first.producerId();
            short s = first.producerEpoch();
            int n = first.baseSequence();
            boolean bl = first.isTransactional();
            return this.buildRecordsAndAssignOffsets(toMagic, offsetCounter, time, timestampType, CompressionType.forId((int)targetCodec.codec()), now, (Seq<Record>)validatedRecords, l, s, n, bl, partitionLeaderEpoch, uncompressedSizeInBytes.elem);
        }
        MutableRecordBatch batch2 = (MutableRecordBatch)records.batches().iterator().next();
        long lastOffset = offsetCounter.addAndGet(validatedRecords.size()) - 1L;
        batch2.setLastOffset(lastOffset);
        TimestampType timestampType2 = timestampType;
        TimestampType timestampType3 = TimestampType.LOG_APPEND_TIME;
        if (!(timestampType2 != null ? !timestampType2.equals(timestampType3) : timestampType3 != null)) {
            maxTimestamp.elem = now;
        }
        if (toMagic >= 1) {
            batch2.setMaxTimestamp(timestampType, maxTimestamp.elem);
        }
        if (toMagic >= 2) {
            batch2.setPartitionLeaderEpoch(partitionLeaderEpoch);
        }
        RecordConversionStats recordConversionStats = new RecordConversionStats((long)uncompressedSizeInBytes.elem, 0, 0L);
        return new LogValidator.ValidationAndOffsetAssignResult(records, maxTimestamp.elem, lastOffset, false, recordConversionStats);
    }

    private LogValidator.ValidationAndOffsetAssignResult buildRecordsAndAssignOffsets(byte magic, kafka.common.LongRef offsetCounter, Time time, TimestampType timestampType, CompressionType compressionType, long logAppendTime, Seq<Record> validatedRecords, long producerId, short producerEpoch, int baseSequence, boolean isTransactional, int partitionLeaderEpoch, int uncompressedSizeInBytes) {
        long startNanos = time.nanoseconds();
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)ByteBuffer.allocate(AbstractRecords.estimateSizeInBytes((byte)magic, (long)offsetCounter.value(), (CompressionType)compressionType, (java.lang.Iterable)((java.lang.Iterable)JavaConverters$.MODULE$.seqAsJavaListConverter(validatedRecords).asJava()))), (byte)magic, (CompressionType)compressionType, (TimestampType)timestampType, (long)offsetCounter.value(), (long)logAppendTime, (long)producerId, (short)producerEpoch, (int)baseSequence, (boolean)isTransactional, (int)partitionLeaderEpoch);
        validatedRecords.foreach((Function1 & Serializable & scala.Serializable)record -> {
            builder.appendWithOffset(offsetCounter.getAndIncrement(), record);
            return BoxedUnit.UNIT;
        });
        MemoryRecords records = builder.build();
        MemoryRecordsBuilder.RecordsInfo info = builder.info();
        int conversionCount = builder.numRecords();
        RecordConversionStats recordConversionStats = new RecordConversionStats((long)(uncompressedSizeInBytes + builder.uncompressedBytesWritten()), conversionCount, time.nanoseconds() - startNanos);
        return new LogValidator.ValidationAndOffsetAssignResult(records, info.maxTimestamp, info.shallowOffsetOfMaxTimestamp, true, recordConversionStats);
    }

    private Option<LogValidator.ApiRecordError> validateKey(Record record, int batchIndex, TopicPartition topicPartition, boolean compactedTopic, BrokerTopicStats brokerTopicStats) {
        if (compactedTopic && !record.hasKey()) {
            brokerTopicStats.allTopicsStats().noKeyCompactedTopicRecordsPerSec().mark();
            return new Some((Object)new LogValidator.ApiRecordError(Errors.INVALID_RECORD, new ProduceResponse.RecordError(batchIndex, new StringBuilder(70).append("Compacted topic cannot accept message without key in topic partition ").append(topicPartition).append(".").toString())));
        }
        return None$.MODULE$;
    }

    private Option<LogValidator.ApiRecordError> validateTimestamp(RecordBatch batch, Record record, int batchIndex, long now, TimestampType timestampType, long timestampDiffMaxMs) {
        TimestampType timestampType2 = timestampType;
        TimestampType timestampType3 = TimestampType.CREATE_TIME;
        if (!(timestampType2 != null ? !timestampType2.equals(timestampType3) : timestampType3 != null)) {
            if (record.timestamp() != -1L && package$.MODULE$.abs(record.timestamp() - now) > timestampDiffMaxMs) {
                return new Some((Object)new LogValidator.ApiRecordError(Errors.INVALID_TIMESTAMP, new ProduceResponse.RecordError(batchIndex, new StringBuilder(87).append("Timestamp ").append(record.timestamp()).append(" of message with offset ").append(record.offset()).append(" is ").append("out of range. The timestamp should be within [").append(now - timestampDiffMaxMs).append(", ").append(now + timestampDiffMaxMs).append("]").toString())));
            }
        }
        TimestampType timestampType4 = batch.timestampType();
        TimestampType timestampType5 = TimestampType.LOG_APPEND_TIME;
        if (!(timestampType4 != null ? !timestampType4.equals(timestampType5) : timestampType5 != null)) {
            return new Some((Object)new LogValidator.ApiRecordError(Errors.INVALID_TIMESTAMP, new ProduceResponse.RecordError(batchIndex, new StringBuilder(92).append("Invalid timestamp type in message ").append(record).append(". Producer should not set timestamp ").append("type to LogAppendTime.").toString())));
        }
        return None$.MODULE$;
    }

    private void processRecordErrors(Seq<LogValidator.ApiRecordError> recordErrors) {
        if (recordErrors.nonEmpty()) {
            Seq errors = (Seq)recordErrors.map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.recordError(), Seq$.MODULE$.canBuildFrom());
            if (recordErrors.exists((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)LogValidator$.$anonfun$processRecordErrors$2(x$7)))) {
                throw new RecordValidationException((ApiException)new InvalidTimestampException("One or more records have been rejected due to invalid timestamp"), (Seq<ProduceResponse.RecordError>)errors);
            }
            throw new RecordValidationException((ApiException)((Object)new InvalidRecordException("One or more records have been rejected")), (Seq<ProduceResponse.RecordError>)errors);
        }
    }

    public static final /* synthetic */ void $anonfun$convertAndAssignOffsetsNonCompressed$3(MutableRecordBatch batch$2, TopicPartition topicPartition$1, long now$2, TimestampType timestampType$2, long timestampDiffMaxMs$2, boolean compactedTopic$1, BrokerTopicStats brokerTopicStats$1, ArrayBuffer recordErrors$1, MemoryRecordsBuilder builder$1, kafka.common.LongRef offsetCounter$1, Tuple2 x$2) {
        if (x$2 != null) {
            Record record = (Record)x$2._1();
            int batchIndex = x$2._2$mcI$sp();
            Option<LogValidator.ApiRecordError> option = MODULE$.validateRecord((RecordBatch)batch$2, topicPartition$1, record, batchIndex, now$2, timestampType$2, timestampDiffMaxMs$2, compactedTopic$1, brokerTopicStats$1);
            if (option == null) {
                throw null;
            }
            Option<LogValidator.ApiRecordError> foreach_this = option;
            if (!foreach_this.isEmpty()) {
                LogValidator.ApiRecordError apiRecordError = (LogValidator.ApiRecordError)foreach_this.get();
                recordErrors$1.$plus$eq((Object)apiRecordError);
            }
            if (recordErrors$1.isEmpty()) {
                builder$1.appendWithOffset(offsetCounter$1.getAndIncrement(), record);
                return;
            }
        } else {
            throw new MatchError(null);
        }
    }

    public static final /* synthetic */ void $anonfun$convertAndAssignOffsetsNonCompressed$1(TopicPartition topicPartition$1, RecordBatch firstBatch$1, AppendOrigin origin$1, byte toMagicValue$1, BrokerTopicStats brokerTopicStats$1, long now$2, TimestampType timestampType$2, long timestampDiffMaxMs$2, boolean compactedTopic$1, MemoryRecordsBuilder builder$1, kafka.common.LongRef offsetCounter$1, MutableRecordBatch batch) {
        MODULE$.validateBatch(topicPartition$1, firstBatch$1, (RecordBatch)batch, origin$1, toMagicValue$1, brokerTopicStats$1);
        ArrayBuffer recordErrors = new ArrayBuffer(0);
        ((IterableLike)((TraversableViewLike)((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)batch).asScala()).view().zipWithIndex(IterableView$.MODULE$.canBuildFrom())).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$1 != null)))).foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            LogValidator$.$anonfun$convertAndAssignOffsetsNonCompressed$3(batch, topicPartition$1, now$2, timestampType$2, timestampDiffMaxMs$2, compactedTopic$1, brokerTopicStats$1, recordErrors, builder$1, offsetCounter$1, x$2);
            return BoxedUnit.UNIT;
        });
        MODULE$.processRecordErrors((Seq<LogValidator.ApiRecordError>)recordErrors);
    }

    public static final /* synthetic */ void $anonfun$assignOffsetsNonCompressed$3(MutableRecordBatch batch$3, TopicPartition topicPartition$2, long now$3, TimestampType timestampType$3, long timestampDiffMaxMs$3, boolean compactedTopic$2, BrokerTopicStats brokerTopicStats$2, ArrayBuffer recordErrors$2, kafka.common.LongRef offsetCounter$2, LongRef maxBatchTimestamp$1, LongRef offsetOfMaxBatchTimestamp$1, Tuple2 x$3) {
        if (x$3 != null) {
            Record record = (Record)x$3._1();
            int batchIndex = x$3._2$mcI$sp();
            Option<LogValidator.ApiRecordError> option = MODULE$.validateRecord((RecordBatch)batch$3, topicPartition$2, record, batchIndex, now$3, timestampType$3, timestampDiffMaxMs$3, compactedTopic$2, brokerTopicStats$2);
            if (option == null) {
                throw null;
            }
            Option<LogValidator.ApiRecordError> foreach_this = option;
            if (!foreach_this.isEmpty()) {
                LogValidator.ApiRecordError apiRecordError = (LogValidator.ApiRecordError)foreach_this.get();
                recordErrors$2.$plus$eq((Object)apiRecordError);
            }
            long offset = offsetCounter$2.getAndIncrement();
            if (batch$3.magic() > 0 && record.timestamp() > maxBatchTimestamp$1.elem) {
                maxBatchTimestamp$1.elem = record.timestamp();
                offsetOfMaxBatchTimestamp$1.elem = offset;
                return;
            }
        } else {
            throw new MatchError(null);
        }
    }

    public static final /* synthetic */ void $anonfun$assignOffsetsNonCompressed$1(TopicPartition topicPartition$2, RecordBatch firstBatch$2, AppendOrigin origin$2, byte magic$1, BrokerTopicStats brokerTopicStats$2, long now$3, TimestampType timestampType$3, long timestampDiffMaxMs$3, boolean compactedTopic$2, kafka.common.LongRef offsetCounter$2, LongRef maxTimestamp$1, LongRef offsetOfMaxTimestamp$1, int partitionLeaderEpoch$1, MutableRecordBatch batch) {
        MODULE$.validateBatch(topicPartition$2, firstBatch$2, (RecordBatch)batch, origin$2, magic$1, brokerTopicStats$2);
        LongRef maxBatchTimestamp = LongRef.create((long)-1L);
        LongRef offsetOfMaxBatchTimestamp = LongRef.create((long)-1L);
        ArrayBuffer recordErrors = new ArrayBuffer(0);
        ((IterableLike)((TraversableViewLike)((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)batch).asScala()).view().zipWithIndex(IterableView$.MODULE$.canBuildFrom())).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$2 != null)))).foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            LogValidator$.$anonfun$assignOffsetsNonCompressed$3(batch, topicPartition$2, now$3, timestampType$3, timestampDiffMaxMs$3, compactedTopic$2, brokerTopicStats$2, recordErrors, offsetCounter$2, maxBatchTimestamp, offsetOfMaxBatchTimestamp, x$3);
            return BoxedUnit.UNIT;
        });
        MODULE$.processRecordErrors((Seq<LogValidator.ApiRecordError>)recordErrors);
        if (batch.magic() > 0 && maxBatchTimestamp.elem > maxTimestamp$1.elem) {
            maxTimestamp$1.elem = maxBatchTimestamp.elem;
            offsetOfMaxTimestamp$1.elem = offsetOfMaxBatchTimestamp.elem;
        }
        batch.setLastOffset(offsetCounter$2.value() - 1L);
        if (batch.magic() >= 2) {
            batch.setPartitionLeaderEpoch(partitionLeaderEpoch$1);
        }
        if (batch.magic() > 0) {
            TimestampType timestampType = timestampType$3;
            TimestampType timestampType2 = TimestampType.LOG_APPEND_TIME;
            if (!(timestampType != null ? !timestampType.equals(timestampType2) : timestampType2 != null)) {
                batch.setMaxTimestamp(TimestampType.LOG_APPEND_TIME, now$3);
                return;
            }
            batch.setMaxTimestamp(timestampType$3, maxBatchTimestamp.elem);
        }
    }

    private static final Option validateRecordCompression$1(int batchIndex, Record record, CompressionCodec sourceCodec$1) {
        CompressionCodec compressionCodec = sourceCodec$1;
        NoCompressionCodec$ noCompressionCodec$ = NoCompressionCodec$.MODULE$;
        if ((compressionCodec == null ? noCompressionCodec$ != null : !compressionCodec.equals(noCompressionCodec$)) && record.isCompressed()) {
            return new Some((Object)new LogValidator.ApiRecordError(Errors.INVALID_RECORD, new ProduceResponse.RecordError(batchIndex, new StringBuilder(90).append("Compressed outer record should not have an inner record with a compression attribute set: ").append(record).toString())));
        }
        return None$.MODULE$;
    }

    private static final Option validateOffset$1(int batchIndex, Record record, long expectedOffset, BrokerTopicStats brokerTopicStats$3, TopicPartition topicPartition$3) {
        if (record.offset() != expectedOffset) {
            brokerTopicStats$3.allTopicsStats().invalidOffsetOrSequenceRecordsPerSec().mark();
            return new Some((Object)new LogValidator.ApiRecordError(Errors.INVALID_RECORD, new ProduceResponse.RecordError(batchIndex, new StringBuilder(124).append("Inner record ").append(record).append(" inside the compressed record batch does not have ").append("incremental offsets, expected offset is ").append(expectedOffset).append(" in topic partition ").append(topicPartition$3).append(".").toString())));
        }
        return None$.MODULE$;
    }

    public static final /* synthetic */ Option $anonfun$validateMessagesAndAssignOffsetsCompressed$5(MutableRecordBatch batch$4, byte toMagic$1, Record record$2, LongRef maxTimestamp$2, int batchIndex$2, long expectedOffset$1, BrokerTopicStats brokerTopicStats$3, TopicPartition topicPartition$3) {
        if (batch$4.magic() > 0 && toMagic$1 > 0) {
            if (record$2.timestamp() > maxTimestamp$2.elem) {
                maxTimestamp$2.elem = record$2.timestamp();
            }
            return LogValidator$.validateOffset$1(batchIndex$2, record$2, expectedOffset$1, brokerTopicStats$3, topicPartition$3);
        }
        return None$.MODULE$;
    }

    public static final /* synthetic */ Option $anonfun$validateMessagesAndAssignOffsetsCompressed$4(MutableRecordBatch batch$4, TopicPartition topicPartition$3, Record record$2, int batchIndex$2, long now$4, TimestampType timestampType$4, long timestampDiffMaxMs$4, boolean compactedTopic$3, BrokerTopicStats brokerTopicStats$3, byte toMagic$1, LongRef maxTimestamp$2, long expectedOffset$1) {
        Option option = MODULE$.validateRecord((RecordBatch)batch$4, topicPartition$3, record$2, batchIndex$2, now$4, timestampType$4, timestampDiffMaxMs$4, compactedTopic$3, brokerTopicStats$3);
        if (option == null) {
            throw null;
        }
        Option orElse_this = option;
        Option option2 = orElse_this.isEmpty() ? LogValidator$.$anonfun$validateMessagesAndAssignOffsetsCompressed$5(batch$4, toMagic$1, record$2, maxTimestamp$2, batchIndex$2, expectedOffset$1, brokerTopicStats$3, topicPartition$3) : orElse_this;
        return option2;
    }

    public static final /* synthetic */ void $anonfun$validateMessagesAndAssignOffsetsCompressed$1(TopicPartition topicPartition$3, RecordBatch firstBatch$3, AppendOrigin origin$3, byte toMagic$1, BrokerTopicStats brokerTopicStats$3, IntRef uncompressedSizeInBytes$1, BooleanRef inPlaceAssignment$1, kafka.common.LongRef expectedInnerOffset$1, long now$4, TimestampType timestampType$4, long timestampDiffMaxMs$4, boolean compactedTopic$3, LongRef maxTimestamp$2, ArrayBuffer validatedRecords$1, CompressionCodec sourceCodec$1, MutableRecordBatch batch) {
        MODULE$.validateBatch(topicPartition$3, firstBatch$3, (RecordBatch)batch, origin$3, toMagic$1, brokerTopicStats$3);
        uncompressedSizeInBytes$1.elem += AbstractRecords.recordBatchHeaderSizeInBytes((byte)toMagic$1, (CompressionType)batch.compressionType());
        try (CloseableIterator recordsIterator = inPlaceAssignment$1.elem && firstBatch$3.magic() >= 2 ? batch.skipKeyValueIterator(BufferSupplier.NO_CACHING) : batch.streamingIterator(BufferSupplier.NO_CACHING);){
            ArrayBuffer recordErrors = new ArrayBuffer(0);
            ((IterableLike)((TraversableViewLike)((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)batch).asScala()).view().zipWithIndex(IterableView$.MODULE$.canBuildFrom())).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$3 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$3 != null)))).foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
                if (x$4 == null) throw new MatchError(null);
                Record record = (Record)x$4._1();
                int batchIndex = x$4._2$mcI$sp();
                long expectedOffset = expectedInnerOffset$1.getAndIncrement();
                Option option = LogValidator$.validateRecordCompression$1(batchIndex, record, sourceCodec$1);
                if (option == null) {
                    throw null;
                }
                Option orElse_this = option;
                Option option2 = orElse_this.isEmpty() ? LogValidator$.$anonfun$validateMessagesAndAssignOffsetsCompressed$4(batch, topicPartition$3, record, batchIndex, now$4, timestampType$4, timestampDiffMaxMs$4, compactedTopic$3, brokerTopicStats$3, toMagic$1, maxTimestamp$2, expectedOffset) : orElse_this;
                if (option2 instanceof Some) {
                    LogValidator.ApiRecordError e = (LogValidator.ApiRecordError)((Some)option2).value();
                    return recordErrors.$plus$eq((Object)e);
                }
                if (!None$.MODULE$.equals(option2)) throw new MatchError((Object)option2);
                uncompressedSizeInBytes$1.elem += record.sizeInBytes();
                return validatedRecords$1.$plus$eq((Object)record);
            });
            MODULE$.processRecordErrors((Seq<LogValidator.ApiRecordError>)recordErrors);
        }
    }

    public static final /* synthetic */ boolean $anonfun$processRecordErrors$2(LogValidator.ApiRecordError x$7) {
        Errors errors = x$7.apiError();
        Errors errors2 = Errors.INVALID_TIMESTAMP;
        return !(errors != null ? !errors.equals(errors2) : errors2 != null);
    }

    private LogValidator$() {
        MODULE$ = this;
        Logging.$init$(this);
    }
}

