/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import kafka.log.Log;
import kafka.log.Log$;
import kafka.log.LogConcurrencyTest$FetchedBatch$;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager$;
import kafka.log.LogSegment;
import kafka.server.BrokerTopicStats;
import kafka.server.FetchDataInfo;
import kafka.server.FetchHighWatermark$;
import kafka.server.FetchIsolation;
import kafka.server.LogDirFailureChannel;
import kafka.server.LogOffsetMetadata;
import kafka.utils.KafkaScheduler;
import kafka.utils.KafkaScheduler$;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.FileLogInputStream;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Product;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Range;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0001\t]d\u0001B\u001c9\u0001uBQ\u0001\u0012\u0001\u0005\u0002\u0015Cq\u0001\u0013\u0001C\u0002\u0013%\u0011\n\u0003\u0004Q\u0001\u0001\u0006IA\u0013\u0005\b#\u0002\u0011\r\u0011\"\u0003S\u0011\u0019I\u0006\u0001)A\u0005'\"9!\f\u0001b\u0001\n\u0013Y\u0006B\u00022\u0001A\u0003%A\fC\u0004d\u0001\t\u0007I\u0011\u00023\t\r5\u0004\u0001\u0015!\u0003f\u0011\u001dq\u0007A1A\u0005\n\u0011Daa\u001c\u0001!\u0002\u0013)\u0007\"\u00029\u0001\t\u0003\t\b\"\u0002@\u0001\t\u0003\t\bBBA\u0004\u0001\u0011\u0005\u0011\u000f\u0003\u0004\u0002\u0012\u0001!\t!\u001d\u0005\b\u0003\u000f\u0001A\u0011AA\u000b\r\u0019\ty\u0002\u0001\u0003\u0002\"!I\u0011(\u0005B\u0001B\u0003%\u0011\u0011\u0004\u0005\u000b\u0003{\t\"\u0011!Q\u0001\n\u0005}\u0002B\u0002#\u0012\t\u0003\t)\u0005C\u0005\u0002PE\u0011\r\u0011\"\u0001\u0002R!A!qA\t!\u0002\u0013\t\u0019\u0006\u0003\u0004\u0003\nE!\t%\u001d\u0004\u0007\u0005\u0017\u0001AA!\u0004\t\u0013eB\"\u0011!Q\u0001\n\u0005e\u0001BCA\u001f1\t\u0005\t\u0015!\u0003\u0002z!1A\t\u0007C\u0001\u0005\u001fAaA!\u0003\u0019\t\u0003\n\bb\u0002B\f\u0001\u0011%!\u0011\u0004\u0005\n\u0005K\u0001\u0011\u0013!C\u0005\u0005OAqAa\u000b\u0001\t\u0013\u0011iC\u0002\u0004\u0002f\u0001!\u0015q\r\u0005\u000b\u0003k\u0002#Q3A\u0005\u0002\u0005]\u0004BCA@A\tE\t\u0015!\u0003\u0002z!Q\u0011\u0011\u0011\u0011\u0003\u0016\u0004%\t!a!\t\u0015\u0005\u0015\u0005E!E!\u0002\u0013\ty\u0004\u0003\u0004EA\u0011\u0005\u0011q\u0011\u0005\b\u0003\u001b\u0003C\u0011IAH\u0011%\t9\u000bIA\u0001\n\u0003\tI\u000bC\u0005\u00020\u0002\n\n\u0011\"\u0001\u00022\"I\u0011q\u0019\u0011\u0012\u0002\u0013\u0005\u0011\u0011\u001a\u0005\n\u0003\u001b\u0004\u0013\u0011!C!\u0003\u001fD\u0011\"!6!\u0003\u0003%\t!a!\t\u0013\u0005]\u0007%!A\u0005\u0002\u0005e\u0007\"CAsA\u0005\u0005I\u0011IAt\u0011%\t\t\u0010IA\u0001\n\u0003\t\u0019\u0010C\u0005\u0002~\u0002\n\t\u0011\"\u0011\u0002\u0000\"I!\u0011\u0001\u0011\u0002\u0002\u0013\u0005#1A\u0004\n\u0005\u000b\u0002\u0011\u0011!E\u0005\u0005\u000f2\u0011\"!\u001a\u0001\u0003\u0003EIA!\u0013\t\r\u0011\u0013D\u0011\u0001B,\u0011%\tiIMA\u0001\n\u000b\u0012I\u0006C\u0005\u0003\\I\n\t\u0011\"!\u0003^!I!1\r\u001a\u0002\u0002\u0013\u0005%Q\r\u0002\u0013\u0019><7i\u001c8dkJ\u0014XM\\2z)\u0016\u001cHO\u0003\u0002:u\u0005\u0019An\\4\u000b\u0003m\nQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001}A\u0011qHQ\u0007\u0002\u0001*\t\u0011)A\u0003tG\u0006d\u0017-\u0003\u0002D\u0001\n1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001$\u0011\u0005\u001d\u0003Q\"\u0001\u001d\u0002!\t\u0014xn[3s)>\u0004\u0018nY*uCR\u001cX#\u0001&\u0011\u0005-sU\"\u0001'\u000b\u00055S\u0014AB:feZ,'/\u0003\u0002P\u0019\n\u0001\"I]8lKJ$v\u000e]5d'R\fGo]\u0001\u0012EJ|7.\u001a:U_BL7m\u0015;biN\u0004\u0013A\u0002:b]\u0012|W.F\u0001T!\t!v+D\u0001V\u0015\t1\u0006)\u0001\u0003vi&d\u0017B\u0001-V\u0005\u0019\u0011\u0016M\u001c3p[\u00069!/\u00198e_6\u0004\u0013!C:dQ\u0016$W\u000f\\3s+\u0005a\u0006CA/a\u001b\u0005q&BA0;\u0003\u0015)H/\u001b7t\u0013\t\tgL\u0001\bLC\u001a\\\u0017mU2iK\u0012,H.\u001a:\u0002\u0015M\u001c\u0007.\u001a3vY\u0016\u0014\b%\u0001\u0004u[B$\u0015N]\u000b\u0002KB\u0011am[\u0007\u0002O*\u0011\u0001.[\u0001\u0003S>T\u0011A[\u0001\u0005U\u00064\u0018-\u0003\u0002mO\n!a)\u001b7f\u0003\u001d!X\u000e\u001d#je\u0002\na\u0001\\8h\t&\u0014\u0018a\u00027pO\u0012K'\u000fI\u0001\u0006g\u0016$X\u000f\u001d\u000b\u0002eB\u0011qh]\u0005\u0003i\u0002\u0013A!\u00168ji\"\u0012AB\u001e\t\u0003orl\u0011\u0001\u001f\u0006\u0003sj\fQA[;oSRT\u0011a_\u0001\u0004_J<\u0017BA?y\u0005\u0019\u0011UMZ8sK\u0006A1\u000f[;uI><h\u000eK\u0002\u000e\u0003\u0003\u00012a^A\u0002\u0013\r\t)\u0001\u001f\u0002\u0006\u0003\u001a$XM]\u0001\u001fi\u0016\u001cH/\u00168d_6l\u0017\u000e\u001e;fI\u0012\u000bG/\u0019(pi\u000e{gn];nK\u0012D3ADA\u0006!\r9\u0018QB\u0005\u0004\u0003\u001fA(\u0001\u0002+fgR\f!\u0007^3tiVs7m\\7nSR$X\r\u001a#bi\u0006tu\u000e^\"p]N,X.\u001a3Ge\u0016\fX/\u001a8u'\u0016<W.\u001a8u%>dGn\u001d\u0015\u0004\u001f\u0005-Ac\u0001:\u0002\u0018!1\u0011\b\u0005a\u0001\u00033\u00012aRA\u000e\u0013\r\ti\u0002\u000f\u0002\u0004\u0019><'\u0001D\"p]N,X.\u001a:UCN\\7#B\t\u0002$\u0005=\u0002\u0003BA\u0013\u0003Wi!!a\n\u000b\u0007\u0005%\u0012.\u0001\u0003mC:<\u0017\u0002BA\u0017\u0003O\u0011aa\u00142kK\u000e$\b#BA\u0019\u0003s\u0011XBAA\u001a\u0015\u0011\t)$a\u000e\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002WS&!\u00111HA\u001a\u0005!\u0019\u0015\r\u001c7bE2,\u0017A\u00037bgR|eMZ:fiB\u0019q(!\u0011\n\u0007\u0005\r\u0003IA\u0002J]R$b!a\u0012\u0002L\u00055\u0003cAA%#5\t\u0001\u0001\u0003\u0004:)\u0001\u0007\u0011\u0011\u0004\u0005\b\u0003{!\u0002\u0019AA \u0003=\u0019wN\\:v[\u0016$')\u0019;dQ\u0016\u001cXCAA*!\u0019\t)&a\u0018\u0002d5\u0011\u0011q\u000b\u0006\u0005\u00033\nY&A\u0004nkR\f'\r\\3\u000b\u0007\u0005u\u0003)\u0001\u0006d_2dWm\u0019;j_:LA!!\u0019\u0002X\tQA*[:u\u0005V4g-\u001a:\u0011\u0007\u0005%\u0003E\u0001\u0007GKR\u001c\u0007.\u001a3CCR\u001c\u0007n\u0005\u0004!}\u0005%\u0014q\u000e\t\u0004\u007f\u0005-\u0014bAA7\u0001\n9\u0001K]8ek\u000e$\bcA \u0002r%\u0019\u00111\u000f!\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\u0015\t\f7/Z(gMN,G/\u0006\u0002\u0002zA\u0019q(a\u001f\n\u0007\u0005u\u0004I\u0001\u0003M_:<\u0017a\u00032bg\u0016|eMZ:fi\u0002\nQ!\u001a9pG\",\"!a\u0010\u0002\r\u0015\u0004xn\u00195!)\u0019\t\u0019'!#\u0002\f\"9\u0011QO\u0013A\u0002\u0005e\u0004bBAAK\u0001\u0007\u0011qH\u0001\ti>\u001cFO]5oOR\u0011\u0011\u0011\u0013\t\u0005\u0003'\u000b\tK\u0004\u0003\u0002\u0016\u0006u\u0005cAAL\u00016\u0011\u0011\u0011\u0014\u0006\u0004\u00037c\u0014A\u0002\u001fs_>$h(C\u0002\u0002 \u0002\u000ba\u0001\u0015:fI\u00164\u0017\u0002BAR\u0003K\u0013aa\u0015;sS:<'bAAP\u0001\u0006!1m\u001c9z)\u0019\t\u0019'a+\u0002.\"I\u0011QO\u0014\u0011\u0002\u0003\u0007\u0011\u0011\u0010\u0005\n\u0003\u0003;\u0003\u0013!a\u0001\u0003\u007f\tabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u00024*\"\u0011\u0011PA[W\t\t9\f\u0005\u0003\u0002:\u0006\rWBAA^\u0015\u0011\ti,a0\u0002\u0013Ut7\r[3dW\u0016$'bAAa\u0001\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005\u0015\u00171\u0018\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0003\u0017TC!a\u0010\u00026\u0006i\u0001O]8ek\u000e$\bK]3gSb,\"!!5\u0011\t\u0005\u0015\u00121[\u0005\u0005\u0003G\u000b9#\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005m\u0017\u0011\u001d\t\u0004\u007f\u0005u\u0017bAAp\u0001\n\u0019\u0011I\\=\t\u0013\u0005\rH&!AA\u0002\u0005}\u0012a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002jB1\u00111^Aw\u00037l!!a\u0017\n\t\u0005=\u00181\f\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002v\u0006m\bcA \u0002x&\u0019\u0011\u0011 !\u0003\u000f\t{w\u000e\\3b]\"I\u00111\u001d\u0018\u0002\u0002\u0003\u0007\u00111\\\u0001\tQ\u0006\u001c\bnQ8eKR\u0011\u0011qH\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005U(Q\u0001\u0005\n\u0003G\u0004\u0014\u0011!a\u0001\u00037\f\u0001cY8ogVlW\r\u001a\"bi\u000eDWm\u001d\u0011\u0002\t\r\fG\u000e\u001c\u0002\u000e\u0019><\u0017\t\u001d9f]\u0012$\u0016m]6\u0014\u000ba\t\u0019#a\f\u0015\r\tE!1\u0003B\u000b!\r\tI\u0005\u0007\u0005\u0007sm\u0001\r!!\u0007\t\u000f\u0005u2\u00041\u0001\u0002z\u0005I1M]3bi\u0016dun\u001a\u000b\u0005\u00033\u0011Y\u0002C\u0005\u0003\u001eu\u0001\n\u00111\u0001\u0003 \u000511m\u001c8gS\u001e\u00042a\u0012B\u0011\u0013\r\u0011\u0019\u0003\u000f\u0002\n\u0019><7i\u001c8gS\u001e\f1c\u0019:fCR,Gj\\4%I\u00164\u0017-\u001e7uIE*\"A!\u000b+\t\t}\u0011QW\u0001\u0015m\u0006d\u0017\u000eZ1uK\u000e{gn];nK\u0012$\u0015\r^1\u0015\u000bI\u0014yC!\r\t\rez\u0002\u0019AA\r\u0011\u001d\tye\ba\u0001\u0005g\u0001bA!\u000e\u0003@\u0005\rd\u0002\u0002B\u001c\u0005wqA!a&\u0003:%\t\u0011)C\u0002\u0003>\u0001\u000bq\u0001]1dW\u0006<W-\u0003\u0003\u0003B\t\r#\u0001C%uKJ\f'\r\\3\u000b\u0007\tu\u0002)\u0001\u0007GKR\u001c\u0007.\u001a3CCR\u001c\u0007\u000eE\u0002\u0002JI\u001aRA\rB&\u0003_\u0002\"B!\u0014\u0003T\u0005e\u0014qHA2\u001b\t\u0011yEC\u0002\u0003R\u0001\u000bqA];oi&lW-\u0003\u0003\u0003V\t=#!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oeQ\u0011!q\t\u000b\u0003\u0003#\fQ!\u00199qYf$b!a\u0019\u0003`\t\u0005\u0004bBA;k\u0001\u0007\u0011\u0011\u0010\u0005\b\u0003\u0003+\u0004\u0019AA \u0003\u001d)h.\u00199qYf$BAa\u001a\u0003tA)qH!\u001b\u0003n%\u0019!1\u000e!\u0003\r=\u0003H/[8o!\u001dy$qNA=\u0003\u007fI1A!\u001dA\u0005\u0019!V\u000f\u001d7fe!I!Q\u000f\u001c\u0002\u0002\u0003\u0007\u00111M\u0001\u0004q\u0012\u0002\u0004")
public class LogConcurrencyTest {
    private volatile LogConcurrencyTest$FetchedBatch$ FetchedBatch$module;
    private final BrokerTopicStats brokerTopicStats = new BrokerTopicStats();
    private final Random kafka$log$LogConcurrencyTest$$random = new Random();
    private final KafkaScheduler scheduler = new KafkaScheduler(1, KafkaScheduler$.MODULE$.$lessinit$greater$default$2(), KafkaScheduler$.MODULE$.$lessinit$greater$default$3());
    private final File tmpDir = TestUtils$.MODULE$.tempDir();
    private final File logDir = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir());

    private LogConcurrencyTest$FetchedBatch$ FetchedBatch() {
        if (this.FetchedBatch$module == null) {
            this.FetchedBatch$lzycompute$1();
        }
        return this.FetchedBatch$module;
    }

    private BrokerTopicStats brokerTopicStats() {
        return this.brokerTopicStats;
    }

    public Random kafka$log$LogConcurrencyTest$$random() {
        return this.kafka$log$LogConcurrencyTest$$random;
    }

    private KafkaScheduler scheduler() {
        return this.scheduler;
    }

    private File tmpDir() {
        return this.tmpDir;
    }

    private File logDir() {
        return this.logDir;
    }

    @Before
    public void setup() {
        this.scheduler().startup();
    }

    @After
    public void shutdown() {
        this.scheduler().shutdown();
        Utils.delete((File)this.tmpDir());
    }

    @Test
    public void testUncommittedDataNotConsumed() {
        this.testUncommittedDataNotConsumed(this.createLog(this.createLog$default$1()));
    }

    @Test
    public void testUncommittedDataNotConsumedFrequentSegmentRolls() {
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(237));
        LogConfig logConfig = new LogConfig((Map)logProps, LogConfig$.MODULE$.apply$default$2());
        this.testUncommittedDataNotConsumed(this.createLog(logConfig));
    }

    public void testUncommittedDataNotConsumed(Log log) {
        ExecutorService executor = Executors.newFixedThreadPool(2);
        try {
            int maxOffset = 5000;
            ConsumerTask consumer = new ConsumerTask(this, log, maxOffset);
            LogAppendTask appendTask = new LogAppendTask(this, log, maxOffset);
            Future<BoxedUnit> consumerFuture = executor.submit(consumer);
            executor.submit(appendTask).get();
            consumerFuture.get();
            this.validateConsumedData(log, (Iterable<FetchedBatch>)consumer.consumedBatches());
        }
        finally {
            executor.shutdownNow();
        }
    }

    private Log createLog(LogConfig config) {
        return Log$.MODULE$.apply(this.logDir(), config, 0L, 0L, (Scheduler)this.scheduler(), this.brokerTopicStats(), Time.SYSTEM, 3600000, LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs(), new LogDirFailureChannel(10));
    }

    private LogConfig createLog$default$1() {
        return new LogConfig((Map)new Properties(), LogConfig$.MODULE$.apply$default$2());
    }

    private void validateConsumedData(Log log, Iterable<FetchedBatch> consumedBatches) {
        Iterator iter = consumedBatches.iterator();
        log.logSegments().foreach((Function1 & Serializable & scala.Serializable)segment -> {
            LogConcurrencyTest.$anonfun$validateConsumedData$1(iter, segment);
            return BoxedUnit.UNIT;
        });
    }

    private final void FetchedBatch$lzycompute$1() {
        synchronized (this) {
            if (this.FetchedBatch$module == null) {
                this.FetchedBatch$module = new LogConcurrencyTest$FetchedBatch$(this);
            }
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$validateConsumedData$2(Iterator iter$1, FileLogInputStream.FileChannelRecordBatch batch) {
        if (iter$1.hasNext()) {
            FetchedBatch consumedBatch = (FetchedBatch)iter$1.next();
            try {
                Assert.assertEquals((String)"Consumed batch with unexpected leader epoch", (long)batch.partitionLeaderEpoch(), (long)consumedBatch.epoch());
                Assert.assertEquals((String)"Consumed batch with unexpected base offset", (long)batch.baseOffset(), (long)consumedBatch.baseOffset());
                return;
            }
            catch (Throwable t) {
                throw new AssertionError(new StringBuilder(58).append("Consumed batch ").append(consumedBatch).append(" ").append("does not match next expected batch in log ").append(batch).toString(), t);
            }
        }
    }

    public static final /* synthetic */ void $anonfun$validateConsumedData$1(Iterator iter$1, LogSegment segment) {
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(segment.log().batches()).asScala()).foreach((Function1 & Serializable & scala.Serializable)batch -> {
            LogConcurrencyTest.$anonfun$validateConsumedData$2(iter$1, batch);
            return BoxedUnit.UNIT;
        });
    }

    public class ConsumerTask
    implements Callable<BoxedUnit> {
        private final Log log;
        private final int lastOffset;
        private final ListBuffer<FetchedBatch> consumedBatches;
        public final /* synthetic */ LogConcurrencyTest $outer;

        public ListBuffer<FetchedBatch> consumedBatches() {
            return this.consumedBatches;
        }

        @Override
        public void call() {
            LongRef fetchOffset = LongRef.create((long)0L);
            while (this.log.highWatermark() < (long)this.lastOffset) {
                FetchDataInfo readInfo = this.log.read(fetchOffset.elem, 1, (FetchIsolation)FetchHighWatermark$.MODULE$, true);
                ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(readInfo.records().batches()).asScala()).foreach((Function1 & Serializable & scala.Serializable)batch -> {
                    ConsumerTask.$anonfun$call$1(this, fetchOffset, batch);
                    return BoxedUnit.UNIT;
                });
            }
        }

        public /* synthetic */ LogConcurrencyTest kafka$log$LogConcurrencyTest$ConsumerTask$$$outer() {
            return this.$outer;
        }

        public static final /* synthetic */ void $anonfun$call$1(ConsumerTask $this, LongRef fetchOffset$1, RecordBatch batch) {
            $this.consumedBatches().$plus$eq((Object)new FetchedBatch($this.kafka$log$LogConcurrencyTest$ConsumerTask$$$outer(), batch.baseOffset(), batch.partitionLeaderEpoch()));
            fetchOffset$1.elem = batch.lastOffset() + 1L;
        }

        public ConsumerTask(LogConcurrencyTest $outer, Log log, int lastOffset) {
            this.log = log;
            this.lastOffset = lastOffset;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.consumedBatches = (ListBuffer)ListBuffer$.MODULE$.empty();
        }
    }

    public class FetchedBatch
    implements Product,
    scala.Serializable {
        private final long baseOffset;
        private final int epoch;
        public final /* synthetic */ LogConcurrencyTest $outer;

        public long baseOffset() {
            return this.baseOffset;
        }

        public int epoch() {
            return this.epoch;
        }

        public String toString() {
            return new StringBuilder(33).append("FetchedBatch(baseOffset=").append(this.baseOffset()).append(", epoch=").append(this.epoch()).append(")").toString();
        }

        public FetchedBatch copy(long baseOffset, int epoch) {
            return new FetchedBatch(this.kafka$log$LogConcurrencyTest$FetchedBatch$$$outer(), baseOffset, epoch);
        }

        public long copy$default$1() {
            return this.baseOffset();
        }

        public int copy$default$2() {
            return this.epoch();
        }

        public String productPrefix() {
            return "FetchedBatch";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return BoxesRunTime.boxToLong((long)this.baseOffset());
                }
                case 1: {
                    return BoxesRunTime.boxToInteger((int)this.epoch());
                }
            }
            throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof FetchedBatch;
        }

        public int hashCode() {
            return Statics.finalizeHash((int)Statics.mix((int)Statics.mix((int)-889275714, (int)Statics.longHash((long)this.baseOffset())), (int)this.epoch()), (int)2);
        }

        public boolean equals(Object x$1) {
            block3: {
                block2: {
                    if (this == x$1) break block2;
                    boolean bl = x$1 instanceof FetchedBatch && ((FetchedBatch)x$1).kafka$log$LogConcurrencyTest$FetchedBatch$$$outer() == this.kafka$log$LogConcurrencyTest$FetchedBatch$$$outer();
                    if (!bl) break block3;
                    FetchedBatch fetchedBatch = (FetchedBatch)x$1;
                    if (!(this.baseOffset() == fetchedBatch.baseOffset() && this.epoch() == fetchedBatch.epoch() && fetchedBatch.canEqual(this))) break block3;
                }
                return true;
            }
            return false;
        }

        public /* synthetic */ LogConcurrencyTest kafka$log$LogConcurrencyTest$FetchedBatch$$$outer() {
            return this.$outer;
        }

        public FetchedBatch(LogConcurrencyTest $outer, long baseOffset, int epoch) {
            this.baseOffset = baseOffset;
            this.epoch = epoch;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }

    public class LogAppendTask
    implements Callable<BoxedUnit> {
        private final Log log;
        private final long lastOffset;
        public final /* synthetic */ LogConcurrencyTest $outer;

        /*
         * WARNING - void declaration
         */
        @Override
        public void call() {
            int leaderEpoch = 1;
            boolean isLeader = true;
            block4: while (this.log.highWatermark() < this.lastOffset) {
                int n = this.kafka$log$LogConcurrencyTest$LogAppendTask$$$outer().kafka$log$LogConcurrencyTest$$random().nextInt(2);
                switch (n) {
                    case 0: {
                        void map_bf;
                        void map_f;
                        LogOffsetMetadata logEndOffsetMetadata = this.log.logEndOffsetMetadata();
                        long logEndOffset = logEndOffsetMetadata.messageOffset();
                        int batchSize = this.kafka$log$LogConcurrencyTest$LogAppendTask$$$outer().kafka$log$LogConcurrencyTest$$random().nextInt(9) + 1;
                        int n2 = 0;
                        if (Predef$.MODULE$ == null) {
                            throw null;
                        }
                        Range.Inclusive inclusive = RichInt$.MODULE$.to$extension0(n2, batchSize);
                        CanBuildFrom canBuildFrom = IndexedSeq$.MODULE$.canBuildFrom();
                        Function1 & Serializable & scala.Serializable intersect = (Function1 & Serializable & scala.Serializable)i -> LogAppendTask.$anonfun$call$2(BoxesRunTime.unboxToInt((Object)i));
                        if (inclusive == null) {
                            throw null;
                        }
                        IndexedSeq records = (IndexedSeq)TraversableLike.map$((TraversableLike)inclusive, (Function1)map_f, (CanBuildFrom)map_bf);
                        if (isLeader) {
                            this.log.appendAsLeader(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)records, TestUtils$.MODULE$.records$default$2(), TestUtils$.MODULE$.records$default$3(), TestUtils$.MODULE$.records$default$4(), TestUtils$.MODULE$.records$default$5(), TestUtils$.MODULE$.records$default$6(), TestUtils$.MODULE$.records$default$7(), TestUtils$.MODULE$.records$default$8()), leaderEpoch, this.log.appendAsLeader$default$3(), this.log.appendAsLeader$default$4());
                            this.log.maybeIncrementHighWatermark(logEndOffsetMetadata);
                            continue block4;
                        }
                        byte x$4 = TestUtils$.MODULE$.records$default$2();
                        CompressionType x$5 = TestUtils$.MODULE$.records$default$3();
                        long x$6 = TestUtils$.MODULE$.records$default$4();
                        short x$7 = TestUtils$.MODULE$.records$default$5();
                        int x$8 = TestUtils$.MODULE$.records$default$6();
                        this.log.appendAsFollower(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)records, x$4, x$5, x$6, x$7, x$8, logEndOffset, leaderEpoch));
                        this.log.updateHighWatermark(logEndOffset);
                        continue block4;
                    }
                    case 1: {
                        isLeader = !isLeader;
                        ++leaderEpoch;
                        if (isLeader) continue block4;
                        this.log.truncateTo(this.log.highWatermark());
                        continue block4;
                    }
                }
                throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
            }
        }

        public /* synthetic */ LogConcurrencyTest kafka$log$LogConcurrencyTest$LogAppendTask$$$outer() {
            return this.$outer;
        }

        public static final /* synthetic */ SimpleRecord $anonfun$call$2(int i) {
            return new SimpleRecord(String.valueOf(BoxesRunTime.boxToInteger((int)i)).getBytes());
        }

        public LogAppendTask(LogConcurrencyTest $outer, Log log, long lastOffset) {
            this.log = log;
            this.lastOffset = lastOffset;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }
}

