/*
 * Decompiled with CFR 0.152.
 */
package kafka.integration;

import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import kafka.controller.ControllerStats;
import kafka.network.Processor;
import kafka.server.KafkaApis;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.CoreUtils$;
import kafka.utils.TestUtils$;
import kafka.zk.KafkaZkClient;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversable;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0001\u0005-g\u0001\u0002\u0017.\u0001IBQ!\u000f\u0001\u0005\u0002iBq!\u0010\u0001C\u0002\u0013\u0005a\b\u0003\u0004F\u0001\u0001\u0006Ia\u0010\u0005\b\r\u0002\u0011\r\u0011\"\u0001?\u0011\u00199\u0005\u0001)A\u0005\u007f!9\u0001\n\u0001b\u0001\n\u0003I\u0005BB'\u0001A\u0003%!\nC\u0004O\u0001\u0001\u0007I\u0011A(\t\u000fa\u0003\u0001\u0019!C\u00013\"1q\f\u0001Q!\nACq\u0001\u0019\u0001A\u0002\u0013\u0005q\nC\u0004b\u0001\u0001\u0007I\u0011\u00012\t\r\u0011\u0004\u0001\u0015)\u0003Q\u0011\u001d)\u0007\u00011A\u0005\u0002\u0019Dqa\u001d\u0001A\u0002\u0013\u0005A\u000f\u0003\u0004w\u0001\u0001\u0006Ka\u001a\u0005\bo\u0002\u0001\r\u0011\"\u0001y\u0011\u001di\b\u00011A\u0005\u0002yDq!!\u0001\u0001A\u0003&\u0011\u0010C\u0005\u0002\u0004\u0001\u0011\r\u0011\"\u0001\u0002\u0006!A\u0011\u0011\u0003\u0001!\u0002\u0013\t9\u0001C\u0005\u0002\u0014\u0001\u0011\r\u0011\"\u0001\u0002\u0016!A\u00111\u0005\u0001!\u0002\u0013\t9\u0002\u0003\u0005\u0002&\u0001\u0011\r\u0011\"\u0001?\u0011\u001d\t9\u0003\u0001Q\u0001\n}B\u0011\"!\u000b\u0001\u0005\u0004%\t!a\u000b\t\u0011\u0005\u0005\u0003\u0001)A\u0005\u0003[A\u0011\"a\u0011\u0001\u0005\u0004%\t!a\u000b\t\u0011\u0005\u0015\u0003\u0001)A\u0005\u0003[Aq!a\u0012\u0001\t\u0003\nI\u0005C\u0004\u0002Z\u0001!\t%!\u0013\t\u000f\u0005\r\u0004\u0001\"\u0003\u0002f!9\u0011Q\u000e\u0001\u0005\u0002\u0005%\u0003bBA<\u0001\u0011\u0005\u0011\u0011\n\u0005\b\u0003w\u0002A\u0011AA%\u0011\u001d\ty\b\u0001C\u0001\u0003\u0013Bq!a!\u0001\t\u0003\tI\u0005C\u0004\u0002\b\u0002!\t!!\u0013\t\u000f\u0005%\u0005\u0001\"\u0001\u0002J!9\u00111\u0012\u0001\u0005\n\u00055\u0005bBAI\u0001\u0011%\u00111\u0013\u0005\b\u0003c\u0003A\u0011AA%\u0011\u001d\t)\f\u0001C\u0005\u0003o\u0013\u0011$\u00168dY\u0016\fg\u000eT3bI\u0016\u0014X\t\\3di&|g\u000eV3ti*\u0011afL\u0001\fS:$Xm\u001a:bi&|gNC\u00011\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A\u001a\u0011\u0005Q:T\"A\u001b\u000b\u0005Yz\u0013A\u0001>l\u0013\tATG\u0001\u000b[_>\\U-\u001a9feR+7\u000f\u001e%be:,7o]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003m\u0002\"\u0001\u0010\u0001\u000e\u00035\n\u0011B\u0019:pW\u0016\u0014\u0018\nZ\u0019\u0016\u0003}\u0002\"\u0001Q\"\u000e\u0003\u0005S\u0011AQ\u0001\u0006g\u000e\fG.Y\u0005\u0003\t\u0006\u00131!\u00138u\u0003)\u0011'o\\6fe&#\u0017\u0007I\u0001\nEJ|7.\u001a:JIJ\n!B\u0019:pW\u0016\u0014\u0018\n\u001a\u001a!\u0003a)g.\u00192mK\u000e{g\u000e\u001e:pY2,Gm\u00155vi\u0012|wO\\\u000b\u0002\u0015B\u0011\u0001iS\u0005\u0003\u0019\u0006\u0013qAQ8pY\u0016\fg.A\rf]\u0006\u0014G.Z\"p]R\u0014x\u000e\u001c7fINCW\u000f\u001e3po:\u0004\u0013\u0001D2p]\u001aLw\r\u0015:paN\fT#\u0001)\u0011\u0005E3V\"\u0001*\u000b\u0005M#\u0016\u0001B;uS2T\u0011!V\u0001\u0005U\u00064\u0018-\u0003\u0002X%\nQ\u0001K]8qKJ$\u0018.Z:\u0002!\r|gNZ5h!J|\u0007o]\u0019`I\u0015\fHC\u0001.^!\t\u00015,\u0003\u0002]\u0003\n!QK\\5u\u0011\u001dq\u0016\"!AA\u0002A\u000b1\u0001\u001f\u00132\u00035\u0019wN\u001c4jOB\u0013x\u000e]:2A\u0005a1m\u001c8gS\u001e\u0004&o\u001c9te\u0005\u00012m\u001c8gS\u001e\u0004&o\u001c9te}#S-\u001d\u000b\u00035\u000eDqA\u0018\u0007\u0002\u0002\u0003\u0007\u0001+A\u0007d_:4\u0017n\u001a)s_B\u001c(\u0007I\u0001\bG>tg-[4t+\u00059\u0007c\u00015l[6\t\u0011N\u0003\u0002k\u0003\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u00051L'aA*fcB\u0011a.]\u0007\u0002_*\u0011\u0001oL\u0001\u0007g\u0016\u0014h/\u001a:\n\u0005I|'aC&bM.\f7i\u001c8gS\u001e\f1bY8oM&<7o\u0018\u0013fcR\u0011!,\u001e\u0005\b=>\t\t\u00111\u0001h\u0003!\u0019wN\u001c4jON\u0004\u0013aB:feZ,'o]\u000b\u0002sB\u0019\u0001n\u001b>\u0011\u00059\\\u0018B\u0001?p\u0005-Y\u0015MZ6b'\u0016\u0014h/\u001a:\u0002\u0017M,'O^3sg~#S-\u001d\u000b\u00035~DqA\u0018\n\u0002\u0002\u0003\u0007\u00110\u0001\u0005tKJ4XM]:!\u0003\u0019\u0011\u0018M\u001c3p[V\u0011\u0011q\u0001\t\u0005\u0003\u0013\ti!\u0004\u0002\u0002\f)\u00111+Q\u0005\u0005\u0003\u001f\tYA\u0001\u0004SC:$w.\\\u0001\be\u0006tGm\\7!\u0003\u0015!x\u000e]5d+\t\t9\u0002\u0005\u0003\u0002\u001a\u0005}QBAA\u000e\u0015\r\ti\u0002V\u0001\u0005Y\u0006tw-\u0003\u0003\u0002\"\u0005m!AB*ue&tw-\u0001\u0004u_BL7\rI\u0001\fa\u0006\u0014H/\u001b;j_:LE-\u0001\u0007qCJ$\u0018\u000e^5p]&#\u0007%A\blC\u001a\\\u0017-\u00119jg2{wmZ3s+\t\ti\u0003\u0005\u0003\u00020\u0005uRBAA\u0019\u0015\u0011\t\u0019$!\u000e\u0002\u000b1|w\r\u000e6\u000b\t\u0005]\u0012\u0011H\u0001\u0007CB\f7\r[3\u000b\u0005\u0005m\u0012aA8sO&!\u0011qHA\u0019\u0005\u0019aunZ4fe\u0006\u00012.\u00194lC\u0006\u0003\u0018n\u001d'pO\u001e,'\u000fI\u0001\u0017]\u0016$xo\u001c:l!J|7-Z:t_JdunZ4fe\u00069b.\u001a;x_J\\\u0007K]8dKN\u001cxN\u001d'pO\u001e,'\u000fI\u0001\u0006g\u0016$X\u000b\u001d\u000b\u00025\"\u001aa$!\u0014\u0011\t\u0005=\u0013QK\u0007\u0003\u0003#RA!a\u0015\u0002:\u0005)!.\u001e8ji&!\u0011qKA)\u0005\u0019\u0011UMZ8sK\u0006AA/Z1s\t><h\u000eK\u0002 \u0003;\u0002B!a\u0014\u0002`%!\u0011\u0011MA)\u0005\u0015\te\r^3s\u00031\u0019H/\u0019:u\u0005J|7.\u001a:t)\rQ\u0016q\r\u0005\b\u0003S\u0002\u0003\u0019AA6\u0003\u001d\u0019G.^:uKJ\u00042\u0001[6Q\u0003\u0001\"Xm\u001d;V]\u000edW-\u00198MK\u0006$WM]#mK\u000e$\u0018n\u001c8F]\u0006\u0014G.\u001a3)\u0007\u0005\n\t\b\u0005\u0003\u0002P\u0005M\u0014\u0002BA;\u0003#\u0012A\u0001V3ti\u0006\tC/Z:u+:\u001cG.Z1o\u0019\u0016\fG-\u001a:FY\u0016\u001cG/[8o\t&\u001c\u0018M\u00197fI\"\u001a!%!\u001d\u0002_Q,7\u000f^+oG2,\u0017M\u001c'fC\u0012,'/\u00127fGRLwN\\#oC\ndW\r\u001a\"z)>\u0004\u0018nY(wKJ\u0014\u0018\u000eZ3)\u0007\r\n\t(\u0001\u0019uKN$XK\\2mK\u0006tG*Z1eKJ,E.Z2uS>tG)[:bE2,GMQ=U_BL7m\u0014<feJLG-\u001a\u0015\u0004I\u0005E\u0014!\f;fgR,fn\u00197fC:dU-\u00193fe\u0016cWm\u0019;j_:LeN^1mS\u0012$v\u000e]5d\u001fZ,'O]5eK\"\u001aQ%!\u001d\u0002EY,'/\u001b4z+:\u001cG.Z1o\u0019\u0016\fG-\u001a:FY\u0016\u001cG/[8o\u000b:\f'\r\\3e\u0003\r2XM]5gsVs7\r\\3b]2+\u0017\rZ3s\u000b2,7\r^5p]\u0012K7/\u00192mK\u0012\fab\u001d5vi\u0012|wO\\*feZ,'\u000fF\u0002[\u0003\u001fCQ\u0001\u001d\u0015A\u0002i\f!cY8ogVlW-\u00117m\u001b\u0016\u001c8/Y4fgR1\u0011QSAV\u0003[\u0003B\u0001[6\u0002\u0018B!\u0011\u0011TAT\u001d\u0011\tY*a)\u0011\u0007\u0005u\u0015)\u0004\u0002\u0002 *\u0019\u0011\u0011U\u0019\u0002\rq\u0012xn\u001c;?\u0013\r\t)+Q\u0001\u0007!J,G-\u001a4\n\t\u0005\u0005\u0012\u0011\u0016\u0006\u0004\u0003K\u000b\u0005bBA\nS\u0001\u0007\u0011q\u0013\u0005\u0007\u0003_K\u0003\u0019A \u0002\u00179,X.T3tg\u0006<Wm]\u0001%i\u0016\u001cH\u000fV8qS\u000e,fn\u00197fC:dU-\u00193fe\u0016cWm\u0019;j_:,e.\u00192mK\"\u001a!&!\u001d\u0002#\r\u0014X-\u0019;f\u0003\u0012l\u0017N\\\"mS\u0016tG\u000f\u0006\u0002\u0002:B!\u00111XAd\u001b\t\tiL\u0003\u0003\u0002@\u0006\u0005\u0017!B1e[&t'\u0002BAb\u0003\u000b\fqa\u00197jK:$8OC\u00021\u0003kIA!!3\u0002>\n)\u0011\tZ7j]\u0002")
public class UncleanLeaderElectionTest
extends ZooKeeperTestHarness {
    private final int brokerId1;
    private final int brokerId2;
    private final boolean enableControlledShutdown;
    private Properties configProps1 = null;
    private Properties configProps2 = null;
    private Seq<KafkaConfig> configs = (Seq)Seq$.MODULE$.empty();
    private Seq<KafkaServer> servers = (Seq)Seq$.MODULE$.empty();
    private final Random random = new Random();
    private final String topic = new StringBuilder(5).append("topic").append(this.random().nextLong()).toString();
    private final int partitionId;
    private final Logger kafkaApisLogger = Logger.getLogger(KafkaApis.class);
    private final Logger networkProcessorLogger = Logger.getLogger(Processor.class);

    public int brokerId1() {
        return this.brokerId1;
    }

    public int brokerId2() {
        return this.brokerId2;
    }

    public boolean enableControlledShutdown() {
        return this.enableControlledShutdown;
    }

    public Properties configProps1() {
        return this.configProps1;
    }

    public void configProps1_$eq(Properties x$1) {
        this.configProps1 = x$1;
    }

    public Properties configProps2() {
        return this.configProps2;
    }

    public void configProps2_$eq(Properties x$1) {
        this.configProps2 = x$1;
    }

    public Seq<KafkaConfig> configs() {
        return this.configs;
    }

    public void configs_$eq(Seq<KafkaConfig> x$1) {
        this.configs = x$1;
    }

    public Seq<KafkaServer> servers() {
        return this.servers;
    }

    public void servers_$eq(Seq<KafkaServer> x$1) {
        this.servers = x$1;
    }

    public Random random() {
        return this.random;
    }

    public String topic() {
        return this.topic;
    }

    public int partitionId() {
        return this.partitionId;
    }

    public Logger kafkaApisLogger() {
        return this.kafkaApisLogger;
    }

    public Logger networkProcessorLogger() {
        return this.networkProcessorLogger;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.configProps1_$eq(TestUtils$.MODULE$.createBrokerConfig(this.brokerId1(), this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20()));
        this.configProps2_$eq(TestUtils$.MODULE$.createBrokerConfig(this.brokerId2(), this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20()));
        .colon.colon foreach_these = new .colon.colon((Object)this.configProps1(), (List)new .colon.colon((Object)this.configProps2(), (List)Nil$.MODULE$));
        while (!foreach_these.isEmpty()) {
            Properties properties = (Properties)foreach_these.head();
            UncleanLeaderElectionTest.$anonfun$setUp$1(this, properties);
            foreach_these = (List)foreach_these.tail();
        }
        this.kafkaApisLogger().setLevel(Level.FATAL);
        this.networkProcessorLogger().setLevel(Level.FATAL);
    }

    @Override
    @After
    public void tearDown() {
        this.servers().foreach((Function1 & Serializable & scala.Serializable)server -> {
            this.shutdownServer(server);
            return BoxedUnit.UNIT;
        });
        this.servers().foreach((Function1 & Serializable & scala.Serializable)server -> {
            CoreUtils$.MODULE$.delete(server.config().logDirs());
            return BoxedUnit.UNIT;
        });
        this.kafkaApisLogger().setLevel(Level.ERROR);
        this.networkProcessorLogger().setLevel(Level.ERROR);
        super.tearDown();
    }

    private void startBrokers(Seq<Properties> cluster) {
        cluster.foreach((Function1 & Serializable & scala.Serializable)props -> {
            UncleanLeaderElectionTest.$anonfun$startBrokers$1(this, props);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testUncleanLeaderElectionEnabled() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        this.configProps1().put("unclean.leader.election.enable", "true");
        this.configProps2().put("unclean.leader.election.enable", "true");
        this.startBrokers((Seq<Properties>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Properties[]{this.configProps1(), this.configProps2()}))));
        Tuple2[] tuple2Array = new Tuple2[1];
        GenTraversable genTraversable = Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId1(), this.brokerId2()}));
        Object object = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.partitionId()));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic(), (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))), this.servers());
        this.verifyUncleanLeaderElectionEnabled();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testUncleanLeaderElectionDisabled() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        this.startBrokers((Seq<Properties>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Properties[]{this.configProps1(), this.configProps2()}))));
        Tuple2[] tuple2Array = new Tuple2[1];
        GenTraversable genTraversable = Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId1(), this.brokerId2()}));
        Object object = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.partitionId()));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic(), (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))), this.servers());
        this.verifyUncleanLeaderElectionDisabled();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testUncleanLeaderElectionEnabledByTopicOverride() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        this.configProps1().put("unclean.leader.election.enable", "false");
        this.configProps2().put("unclean.leader.election.enable", "false");
        this.startBrokers((Seq<Properties>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Properties[]{this.configProps1(), this.configProps2()}))));
        Properties topicProps = new Properties();
        topicProps.put("unclean.leader.election.enable", "true");
        Tuple2[] tuple2Array = new Tuple2[1];
        GenTraversable genTraversable = Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId1(), this.brokerId2()}));
        Object object = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.partitionId()));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic(), (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))), this.servers(), topicProps);
        this.verifyUncleanLeaderElectionEnabled();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testUncleanLeaderElectionDisabledByTopicOverride() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        this.configProps1().put("unclean.leader.election.enable", "true");
        this.configProps2().put("unclean.leader.election.enable", "true");
        this.startBrokers((Seq<Properties>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Properties[]{this.configProps1(), this.configProps2()}))));
        Properties topicProps = new Properties();
        topicProps.put("unclean.leader.election.enable", "false");
        Tuple2[] tuple2Array = new Tuple2[1];
        GenTraversable genTraversable = Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId1(), this.brokerId2()}));
        Object object = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.partitionId()));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic(), (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))), this.servers(), topicProps);
        this.verifyUncleanLeaderElectionDisabled();
    }

    @Test
    public void testUncleanLeaderElectionInvalidTopicOverride() {
        this.startBrokers((Seq<Properties>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Properties[]{this.configProps1()}))));
        Properties topicProps = new Properties();
        topicProps.put("unclean.leader.election.enable", "invalid");
        Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> {
            void $minus$greater$extension_y;
            void $minus$greater$extension_$this;
            Tuple2[] tuple2Array = new Tuple2[1];
            GenTraversable genTraversable = Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId1()}));
            Object object = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.partitionId()));
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
            return TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic(), (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))), this.servers(), topicProps);
        }, ClassTag$.MODULE$.apply(ConfigException.class), new Position("UncleanLeaderElectionTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 165));
    }

    public void verifyUncleanLeaderElectionEnabled() {
        int leaderId = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), this.topic(), this.partitionId(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> {
            String string = " is elected to be: %s";
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            return new StringBuilder(11).append("Leader for ").append(this.topic()).append(new StringOps(string).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)leaderId)}))).toString();
        });
        Assert.assertTrue((String)new StringBuilder(46).append("Leader id is set to expected value for topic: ").append(this.topic()).toString(), (leaderId == this.brokerId1() || leaderId == this.brokerId2() ? 1 : 0) != 0);
        int followerId = leaderId == this.brokerId1() ? this.brokerId2() : this.brokerId1();
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> {
            String string = " is: %s";
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            return new StringBuilder(13).append("Follower for ").append(this.topic()).append(new StringOps(string).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)followerId)}))).toString();
        });
        TestUtils$.MODULE$.produceMessage(this.servers(), this.topic(), "first", TestUtils$.MODULE$.produceMessage$default$4(), TestUtils$.MODULE$.produceMessage$default$5());
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated(this.servers(), this.topic(), this.partitionId(), TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        Assert.assertEquals((Object)new .colon.colon((Object)"first", (List)Nil$.MODULE$), this.consumeAllMessages(this.topic(), 1));
        ((TraversableLike)this.servers().filter((Function1 & Serializable & scala.Serializable)server -> BoxesRunTime.boxToBoolean((boolean)UncleanLeaderElectionTest.$anonfun$verifyUncleanLeaderElectionEnabled$3(followerId, server)))).map((Function1 & Serializable & scala.Serializable)server -> {
            this.shutdownServer(server);
            return BoxedUnit.UNIT;
        }, Seq$.MODULE$.canBuildFrom());
        TestUtils$.MODULE$.produceMessage(this.servers(), this.topic(), "second", TestUtils$.MODULE$.produceMessage$default$4(), TestUtils$.MODULE$.produceMessage$default$5());
        Assert.assertEquals((Object)new .colon.colon((Object)"first", (List)new .colon.colon((Object)"second", (List)Nil$.MODULE$)), this.consumeAllMessages(this.topic(), 2));
        this.servers().map((Function1 & Serializable & scala.Serializable)x$1 -> {
            UncleanLeaderElectionTest.$anonfun$verifyUncleanLeaderElectionEnabled$5(x$1);
            return BoxedUnit.UNIT;
        }, Seq$.MODULE$.canBuildFrom());
        ((TraversableLike)this.servers().filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)UncleanLeaderElectionTest.$anonfun$verifyUncleanLeaderElectionEnabled$6(leaderId, x$2)))).map((Function1 & Serializable & scala.Serializable)server -> {
            this.shutdownServer(server);
            return BoxedUnit.UNIT;
        }, Seq$.MODULE$.canBuildFrom());
        KafkaServer followerServer = (KafkaServer)this.servers().find((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)UncleanLeaderElectionTest.$anonfun$verifyUncleanLeaderElectionEnabled$8(followerId, x$3))).get();
        followerServer.startup();
        KafkaZkClient x$32 = this.zkClient();
        String x$4 = this.topic();
        int x$5 = this.partitionId();
        Some x$6 = new Some((Object)BoxesRunTime.boxToInteger((int)followerId));
        long x$7 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4();
        Option<Object> x$8 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5();
        TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(x$32, x$4, x$5, x$7, x$8, (Option<Object>)x$6);
        Assert.assertEquals((long)1L, (long)followerServer.kafkaController().controllerContext().stats().uncleanLeaderElectionRate().count());
        TestUtils$.MODULE$.produceMessage(this.servers(), this.topic(), "third", TestUtils$.MODULE$.produceMessage$default$4(), TestUtils$.MODULE$.produceMessage$default$5());
        Assert.assertEquals((Object)new .colon.colon((Object)"first", (List)new .colon.colon((Object)"third", (List)Nil$.MODULE$)), this.consumeAllMessages(this.topic(), 2));
    }

    /*
     * WARNING - void declaration
     */
    public void verifyUncleanLeaderElectionDisabled() {
        KafkaServer followerServer;
        int followerId;
        int leaderId;
        block6: {
            leaderId = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), this.topic(), this.partitionId(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> {
                String string = " is elected to be: %s";
                if (Predef$.MODULE$ == null) {
                    throw null;
                }
                return new StringBuilder(11).append("Leader for ").append(this.topic()).append(new StringOps(string).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)leaderId)}))).toString();
            });
            Assert.assertTrue((String)new StringBuilder(46).append("Leader id is set to expected value for topic: ").append(this.topic()).toString(), (leaderId == this.brokerId1() || leaderId == this.brokerId2() ? 1 : 0) != 0);
            followerId = leaderId == this.brokerId1() ? this.brokerId2() : this.brokerId1();
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> {
                String string = " is: %s";
                if (Predef$.MODULE$ == null) {
                    throw null;
                }
                return new StringBuilder(13).append("Follower for ").append(this.topic()).append(new StringOps(string).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)followerId)}))).toString();
            });
            TestUtils$.MODULE$.produceMessage(this.servers(), this.topic(), "first", TestUtils$.MODULE$.produceMessage$default$4(), TestUtils$.MODULE$.produceMessage$default$5());
            TestUtils$.MODULE$.waitUntilMetadataIsPropagated(this.servers(), this.topic(), this.partitionId(), TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
            Assert.assertEquals((Object)new .colon.colon((Object)"first", (List)Nil$.MODULE$), this.consumeAllMessages(this.topic(), 1));
            ((IterableLike)this.servers().filter((Function1 & Serializable & scala.Serializable)server -> BoxesRunTime.boxToBoolean((boolean)UncleanLeaderElectionTest.$anonfun$verifyUncleanLeaderElectionDisabled$3(followerId, server)))).foreach((Function1 & Serializable & scala.Serializable)server -> {
                this.shutdownServer(server);
                return BoxedUnit.UNIT;
            });
            TestUtils$.MODULE$.produceMessage(this.servers(), this.topic(), "second", TestUtils$.MODULE$.produceMessage$default$4(), TestUtils$.MODULE$.produceMessage$default$5());
            Assert.assertEquals((Object)new .colon.colon((Object)"first", (List)new .colon.colon((Object)"second", (List)Nil$.MODULE$)), this.consumeAllMessages(this.topic(), 2));
            this.servers().foreach((Function1 & Serializable & scala.Serializable)server -> {
                UncleanLeaderElectionTest.$anonfun$verifyUncleanLeaderElectionDisabled$5(server);
                return BoxedUnit.UNIT;
            });
            ((IterableLike)this.servers().filter((Function1 & Serializable & scala.Serializable)server -> BoxesRunTime.boxToBoolean((boolean)UncleanLeaderElectionTest.$anonfun$verifyUncleanLeaderElectionDisabled$6(leaderId, server)))).foreach((Function1 & Serializable & scala.Serializable)server -> {
                this.shutdownServer(server);
                return BoxedUnit.UNIT;
            });
            followerServer = (KafkaServer)this.servers().find((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)UncleanLeaderElectionTest.$anonfun$verifyUncleanLeaderElectionDisabled$8(followerId, x$4))).get();
            followerServer.startup();
            KafkaZkClient x$3 = this.zkClient();
            String x$42 = this.topic();
            int x$5 = this.partitionId();
            Some x$6 = new Some((Object)BoxesRunTime.boxToInteger((int)-1));
            long x$7 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4();
            Option<Object> x$8 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5();
            TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(x$3, x$42, x$5, x$7, x$8, (Option<Object>)x$6);
            Assert.assertEquals((long)0L, (long)followerServer.kafkaController().controllerContext().stats().uncleanLeaderElectionRate().count());
            try {
                TestUtils$.MODULE$.produceMessage(this.servers(), this.topic(), "third", 1000, 1000);
                Assert.fail((String)"Message produced while leader is down should fail, but it succeeded");
            }
            catch (Throwable throwable) {
                if (throwable instanceof ExecutionException && ((ExecutionException)throwable).getCause() instanceof TimeoutException) break block6;
                throw throwable;
            }
        }
        Assert.assertEquals((Object)List$.MODULE$.empty(), this.consumeAllMessages(this.topic(), 0));
        ((IterableLike)this.servers().filter((Function1 & Serializable & scala.Serializable)server -> BoxesRunTime.boxToBoolean((boolean)UncleanLeaderElectionTest.$anonfun$verifyUncleanLeaderElectionDisabled$9(leaderId, server)))).foreach((Function1 & Serializable & scala.Serializable)server -> {
            server.startup();
            return BoxedUnit.UNIT;
        });
        KafkaZkClient x$9 = this.zkClient();
        String x$10 = this.topic();
        int x$11 = this.partitionId();
        Some x$12 = new Some((Object)BoxesRunTime.boxToInteger((int)leaderId));
        long x$13 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4();
        Option<Object> x$14 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5();
        TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(x$9, x$10, x$11, x$13, x$14, (Option<Object>)x$12);
        TestUtils$.MODULE$.produceMessage(this.servers(), this.topic(), "third", TestUtils$.MODULE$.produceMessage$default$4(), TestUtils$.MODULE$.produceMessage$default$5());
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!UncleanLeaderElectionTest.$anonfun$verifyUncleanLeaderElectionDisabled$11(this, followerServer, followerId)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(UncleanLeaderElectionTest.$anonfun$verifyUncleanLeaderElectionDisabled$12(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 845));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
        ((IterableLike)this.servers().filter((Function1 & Serializable & scala.Serializable)server -> BoxesRunTime.boxToBoolean((boolean)UncleanLeaderElectionTest.$anonfun$verifyUncleanLeaderElectionDisabled$13(leaderId, server)))).foreach((Function1 & Serializable & scala.Serializable)server -> {
            this.shutdownServer(server);
            return BoxedUnit.UNIT;
        });
        KafkaZkClient x$15 = this.zkClient();
        String x$16 = this.topic();
        int x$17 = this.partitionId();
        Some x$18 = new Some((Object)BoxesRunTime.boxToInteger((int)followerId));
        long x$19 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4();
        Option<Object> x$20 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5();
        TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(x$15, x$16, x$17, x$19, x$20, (Option<Object>)x$18);
        Assert.assertEquals((Object)new .colon.colon((Object)"first", (List)new .colon.colon((Object)"second", (List)new .colon.colon((Object)"third", (List)Nil$.MODULE$))), this.consumeAllMessages(this.topic(), 3));
    }

    private void shutdownServer(KafkaServer server) {
        server.shutdown();
        server.awaitShutdown();
    }

    private Seq<String> consumeAllMessages(String topic, int numMessages) {
        Seq seq;
        String brokerList = TestUtils$.MODULE$.bootstrapServers(this.servers(), ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT));
        String x$2 = new StringBuilder(5).append("group").append(this.random().nextLong()).toString();
        boolean x$3 = false;
        StringDeserializer x$4 = new StringDeserializer();
        String x$52 = TestUtils$.MODULE$.createConsumer$default$3();
        boolean x$6 = TestUtils$.MODULE$.createConsumer$default$5();
        int x$7 = TestUtils$.MODULE$.createConsumer$default$6();
        SecurityProtocol x$8 = TestUtils$.MODULE$.createConsumer$default$7();
        Option<File> x$9 = TestUtils$.MODULE$.createConsumer$default$8();
        Option<Properties> x$10 = TestUtils$.MODULE$.createConsumer$default$9();
        ByteArrayDeserializer x$11 = TestUtils$.MODULE$.createConsumer$default$10();
        try (KafkaConsumer consumer = TestUtils$.MODULE$.createConsumer(brokerList, x$2, x$52, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$4);){
            TopicPartition tp = new TopicPartition(topic, this.partitionId());
            consumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp}))).asJava());
            consumer.seek(tp, 0L);
            seq = (Seq)TestUtils$.MODULE$.consumeRecords(consumer, numMessages, TestUtils$.MODULE$.consumeRecords$default$3()).map((Function1 & Serializable & scala.Serializable)x$5 -> (String)x$5.value(), Seq$.MODULE$.canBuildFrom());
        }
        return seq;
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testTopicUncleanLeaderElectionEnable() {
        KafkaServer followerServer;
        int followerId;
        block3: {
            void $minus$greater$extension_y;
            void $minus$greater$extension_$this;
            this.startBrokers((Seq<Properties>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Properties[]{this.configProps1(), this.configProps2()}))));
            Tuple2[] tuple2Array = new Tuple2[1];
            GenTraversable genTraversable = Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId1(), this.brokerId2()}));
            Object object = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.partitionId()));
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
            this.adminZkClient().createTopicWithAssignment(this.topic(), new Properties(), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array)));
            int leaderId = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), this.topic(), this.partitionId(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
            followerId = leaderId == this.brokerId1() ? this.brokerId2() : this.brokerId1();
            TestUtils$.MODULE$.produceMessage(this.servers(), this.topic(), "first", TestUtils$.MODULE$.produceMessage$default$4(), TestUtils$.MODULE$.produceMessage$default$5());
            TestUtils$.MODULE$.waitUntilMetadataIsPropagated(this.servers(), this.topic(), this.partitionId(), TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
            Assert.assertEquals((Object)new .colon.colon((Object)"first", (List)Nil$.MODULE$), this.consumeAllMessages(this.topic(), 1));
            ((TraversableLike)this.servers().filter((Function1 & Serializable & scala.Serializable)server -> BoxesRunTime.boxToBoolean((boolean)UncleanLeaderElectionTest.$anonfun$testTopicUncleanLeaderElectionEnable$1(followerId, server)))).map((Function1 & Serializable & scala.Serializable)server -> {
                this.shutdownServer(server);
                return BoxedUnit.UNIT;
            }, Seq$.MODULE$.canBuildFrom());
            TestUtils$.MODULE$.produceMessage(this.servers(), this.topic(), "second", TestUtils$.MODULE$.produceMessage$default$4(), TestUtils$.MODULE$.produceMessage$default$5());
            Assert.assertEquals((Object)new .colon.colon((Object)"first", (List)new .colon.colon((Object)"second", (List)Nil$.MODULE$)), this.consumeAllMessages(this.topic(), 2));
            this.servers().map((Function1 & Serializable & scala.Serializable)server -> {
                UncleanLeaderElectionTest.$anonfun$testTopicUncleanLeaderElectionEnable$3(server);
                return BoxedUnit.UNIT;
            }, Seq$.MODULE$.canBuildFrom());
            ((TraversableLike)this.servers().filter((Function1 & Serializable & scala.Serializable)server -> BoxesRunTime.boxToBoolean((boolean)UncleanLeaderElectionTest.$anonfun$testTopicUncleanLeaderElectionEnable$4(leaderId, server)))).map((Function1 & Serializable & scala.Serializable)server -> {
                this.shutdownServer(server);
                return BoxedUnit.UNIT;
            }, Seq$.MODULE$.canBuildFrom());
            followerServer = (KafkaServer)this.servers().find((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)UncleanLeaderElectionTest.$anonfun$testTopicUncleanLeaderElectionEnable$6(followerId, x$6))).get();
            followerServer.startup();
            Assert.assertEquals((long)0L, (long)followerServer.kafkaController().controllerContext().stats().uncleanLeaderElectionRate().count());
            try {
                TestUtils$.MODULE$.produceMessage(this.servers(), this.topic(), "third", 1000, 1000);
                Assert.fail((String)"Message produced while leader is down should fail, but it succeeded");
            }
            catch (Throwable throwable) {
                if (throwable instanceof ExecutionException && ((ExecutionException)throwable).getCause() instanceof TimeoutException) break block3;
                throw throwable;
            }
        }
        Assert.assertEquals((Object)List$.MODULE$.empty(), this.consumeAllMessages(this.topic(), 0));
        Admin adminClient = this.createAdminClient();
        Properties newProps = new Properties();
        newProps.put(KafkaConfig$.MODULE$.UncleanLeaderElectionEnableProp(), "true");
        TestUtils$.MODULE$.alterTopicConfigs(adminClient, this.topic(), newProps).all().get();
        adminClient.close();
        KafkaZkClient x$3 = this.zkClient();
        String x$4 = this.topic();
        int x$5 = this.partitionId();
        Some x$62 = new Some((Object)BoxesRunTime.boxToInteger((int)followerId));
        long x$7 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4();
        Option<Object> x$8 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5();
        TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(x$3, x$4, x$5, x$7, x$8, (Option<Object>)x$62);
        Assert.assertEquals((long)1L, (long)followerServer.kafkaController().controllerContext().stats().uncleanLeaderElectionRate().count());
        TestUtils$.MODULE$.produceMessage(this.servers(), this.topic(), "third", TestUtils$.MODULE$.produceMessage$default$4(), TestUtils$.MODULE$.produceMessage$default$5());
        Assert.assertEquals((Object)new .colon.colon((Object)"first", (List)new .colon.colon((Object)"third", (List)Nil$.MODULE$)), this.consumeAllMessages(this.topic(), 2));
    }

    private Admin createAdminClient() {
        Properties config = new Properties();
        String bootstrapServers = TestUtils$.MODULE$.bootstrapServers(this.servers(), new ListenerName("PLAINTEXT"));
        config.put("bootstrap.servers", bootstrapServers);
        config.put("metadata.max.age.ms", "10");
        return AdminClient.create((Properties)config);
    }

    public static final /* synthetic */ Object $anonfun$setUp$1(UncleanLeaderElectionTest $this, Properties configProps) {
        configProps.put("controlled.shutdown.enable", ((Object)BoxesRunTime.boxToBoolean((boolean)$this.enableControlledShutdown())).toString());
        configProps.put("controlled.shutdown.max.retries", "1");
        return configProps.put("controlled.shutdown.retry.backoff.ms", "1000");
    }

    public static final /* synthetic */ void $anonfun$startBrokers$1(UncleanLeaderElectionTest $this, Properties props) {
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        KafkaServer server = TestUtils$.MODULE$.createServer(config, TestUtils$.MODULE$.createServer$default$2());
        $this.configs_$eq((Seq<KafkaConfig>)((Seq)$this.configs().$plus$plus((GenTraversableOnce)new .colon.colon((Object)config, (List)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom())));
        $this.servers_$eq((Seq<KafkaServer>)((Seq)$this.servers().$plus$plus((GenTraversableOnce)new .colon.colon((Object)server, (List)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom())));
    }

    public static final /* synthetic */ boolean $anonfun$verifyUncleanLeaderElectionEnabled$3(int followerId$1, KafkaServer server) {
        return server.config().brokerId() == followerId$1;
    }

    public static final /* synthetic */ void $anonfun$verifyUncleanLeaderElectionEnabled$5(KafkaServer x$1) {
        ControllerStats qual$1 = x$1.kafkaController().controllerContext().stats();
        String x$12 = "UncleanLeaderElectionsPerSec";
        Map x$2 = qual$1.removeMetric$default$2();
        qual$1.removeMetric(x$12, x$2);
    }

    public static final /* synthetic */ boolean $anonfun$verifyUncleanLeaderElectionEnabled$6(int leaderId$1, KafkaServer x$2) {
        return x$2.config().brokerId() == leaderId$1;
    }

    public static final /* synthetic */ boolean $anonfun$verifyUncleanLeaderElectionEnabled$8(int followerId$1, KafkaServer x$3) {
        return x$3.config().brokerId() == followerId$1;
    }

    public static final /* synthetic */ boolean $anonfun$verifyUncleanLeaderElectionDisabled$3(int followerId$2, KafkaServer server) {
        return server.config().brokerId() == followerId$2;
    }

    public static final /* synthetic */ void $anonfun$verifyUncleanLeaderElectionDisabled$5(KafkaServer server) {
        ControllerStats qual$1 = server.kafkaController().controllerContext().stats();
        String x$1 = "UncleanLeaderElectionsPerSec";
        Map x$2 = qual$1.removeMetric$default$2();
        qual$1.removeMetric(x$1, x$2);
    }

    public static final /* synthetic */ boolean $anonfun$verifyUncleanLeaderElectionDisabled$6(int leaderId$2, KafkaServer server) {
        return server.config().brokerId() == leaderId$2;
    }

    public static final /* synthetic */ boolean $anonfun$verifyUncleanLeaderElectionDisabled$8(int followerId$2, KafkaServer x$4) {
        return x$4.config().brokerId() == followerId$2;
    }

    public static final /* synthetic */ boolean $anonfun$verifyUncleanLeaderElectionDisabled$9(int leaderId$2, KafkaServer server) {
        return server.config().brokerId() == leaderId$2;
    }

    public static final /* synthetic */ boolean $anonfun$verifyUncleanLeaderElectionDisabled$11(UncleanLeaderElectionTest $this, KafkaServer followerServer$1, int followerId$2) {
        Option partitionInfoOpt = followerServer$1.metadataCache().getPartitionInfo($this.topic(), $this.partitionId());
        return partitionInfoOpt.isDefined() && ((UpdateMetadataRequestData.UpdateMetadataPartitionState)partitionInfoOpt.get()).isr().contains(BoxesRunTime.boxToInteger((int)followerId$2));
    }

    public static final /* synthetic */ String $anonfun$verifyUncleanLeaderElectionDisabled$12() {
        return "Inconsistent metadata after first server startup";
    }

    public static final /* synthetic */ boolean $anonfun$verifyUncleanLeaderElectionDisabled$13(int leaderId$2, KafkaServer server) {
        return server.config().brokerId() == leaderId$2;
    }

    public static final /* synthetic */ boolean $anonfun$testTopicUncleanLeaderElectionEnable$1(int followerId$3, KafkaServer server) {
        return server.config().brokerId() == followerId$3;
    }

    public static final /* synthetic */ void $anonfun$testTopicUncleanLeaderElectionEnable$3(KafkaServer server) {
        ControllerStats qual$1 = server.kafkaController().controllerContext().stats();
        String x$1 = "UncleanLeaderElectionsPerSec";
        Map x$2 = qual$1.removeMetric$default$2();
        qual$1.removeMetric(x$1, x$2);
    }

    public static final /* synthetic */ boolean $anonfun$testTopicUncleanLeaderElectionEnable$4(int leaderId$3, KafkaServer server) {
        return server.config().brokerId() == leaderId$3;
    }

    public static final /* synthetic */ boolean $anonfun$testTopicUncleanLeaderElectionEnable$6(int followerId$3, KafkaServer x$6) {
        return x$6.config().brokerId() == followerId$3;
    }

    public UncleanLeaderElectionTest() {
        this.brokerId1 = 0;
        this.brokerId2 = 1;
        this.enableControlledShutdown = true;
        this.partitionId = 0;
    }
}

