/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.time.Duration;
import java.util.Collections;
import java.util.Properties;
import kafka.api.IntegrationTestHarness;
import kafka.api.QuotaTestClients;
import kafka.api.QuotaTestClients$;
import kafka.server.ClientQuotaManagerConfig$;
import kafka.server.DynamicConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.QuotaType;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Option;
import scala.Some;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005ma!\u0002\u0010 \u0003\u0003!\u0003\"B\u0015\u0001\t\u0003Q\u0003b\u0002\u0017\u0001\u0005\u0004%\t%\f\u0005\u0007i\u0001\u0001\u000b\u0011\u0002\u0018\t\u000bU\u0002A\u0011\u0003\u001c\t\u000b}\u0002A\u0011\u0003\u001c\t\u000b\u0001\u0003a\u0011C!\t\u000fe\u0003!\u0019!C\u0001[!1!\f\u0001Q\u0001\n9Bqa\u0017\u0001C\u0002\u0013\u0005Q\u0006\u0003\u0004]\u0001\u0001\u0006IA\f\u0005\b;\u0002\u0011\r\u0011\"\u0001.\u0011\u0019q\u0006\u0001)A\u0005]!9q\f\u0001b\u0001\n\u00031\u0004B\u00021\u0001A\u0003%q\u0007C\u0005S\u0001\u0001\u0007\t\u0019!C\u0001C\"I!\r\u0001a\u0001\u0002\u0004%\ta\u0019\u0005\nS\u0002\u0001\r\u0011!Q!\nMC\u0011B\u001b\u0001A\u0002\u0003\u0007I\u0011A1\t\u0013-\u0004\u0001\u0019!a\u0001\n\u0003a\u0007\"\u00038\u0001\u0001\u0004\u0005\t\u0015)\u0003T\u0011%y\u0007\u00011AA\u0002\u0013\u0005\u0001\u000fC\u0005r\u0001\u0001\u0007\t\u0019!C\u0001e\"IA\u000f\u0001a\u0001\u0002\u0003\u0006KA\u0011\u0005\u0006k\u0002!\tE\u001e\u0005\u0007\u0003\u0003\u0001A\u0011\u0001<\t\r\u0005-\u0001\u0001\"\u0001w\u0011\u0019\ty\u0001\u0001C\u0001m\"1\u00111\u0003\u0001\u0005\u0002YDa!a\u0006\u0001\t\u00031(!\u0004\"bg\u0016\fVo\u001c;b)\u0016\u001cHO\u0003\u0002!C\u0005\u0019\u0011\r]5\u000b\u0003\t\nQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001KA\u0011aeJ\u0007\u0002?%\u0011\u0001f\b\u0002\u0017\u0013:$Xm\u001a:bi&|g\u000eV3ti\"\u000b'O\\3tg\u00061A(\u001b8jiz\"\u0012a\u000b\t\u0003M\u0001\t1B\u0019:pW\u0016\u00148i\\;oiV\ta\u0006\u0005\u00020e5\t\u0001GC\u00012\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0004GA\u0002J]R\fAB\u0019:pW\u0016\u00148i\\;oi\u0002\n\u0001\u0003\u001d:pIV\u001cWM]\"mS\u0016tG/\u00133\u0016\u0003]\u0002\"\u0001O\u001f\u000e\u0003eR!AO\u001e\u0002\t1\fgn\u001a\u0006\u0002y\u0005!!.\u0019<b\u0013\tq\u0014H\u0001\u0004TiJLgnZ\u0001\u0011G>t7/^7fe\u000ec\u0017.\u001a8u\u0013\u0012\fac\u0019:fCR,\u0017+^8uCR+7\u000f^\"mS\u0016tGo\u001d\u000b\u0004\u0005\u0016\u000b\u0006C\u0001\u0014D\u0013\t!uD\u0001\tRk>$\u0018\rV3ti\u000ec\u0017.\u001a8ug\")aI\u0002a\u0001\u000f\u0006)Ao\u001c9jGB\u0011\u0001j\u0014\b\u0003\u00136\u0003\"A\u0013\u0019\u000e\u0003-S!\u0001T\u0012\u0002\rq\u0012xn\u001c;?\u0013\tq\u0005'\u0001\u0004Qe\u0016$WMZ\u0005\u0003}AS!A\u0014\u0019\t\u000bI3\u0001\u0019A*\u0002\u00151,\u0017\rZ3s\u001d>$W\r\u0005\u0002U/6\tQK\u0003\u0002WC\u000511/\u001a:wKJL!\u0001W+\u0003\u0017-\u000bgm[1TKJ4XM]\u0001\u0015I\u00164\u0017-\u001e7u!J|G-^2feF+x\u000e^1\u0002+\u0011,g-Y;miB\u0013x\u000eZ;dKJ\fVo\u001c;bA\u0005!B-\u001a4bk2$8i\u001c8tk6,'/U;pi\u0006\fQ\u0003Z3gCVdGoQ8ogVlWM])v_R\f\u0007%A\neK\u001a\fW\u000f\u001c;SKF,Xm\u001d;Rk>$\u0018-\u0001\u000beK\u001a\fW\u000f\u001c;SKF,Xm\u001d;Rk>$\u0018\rI\u0001\u0007i>\u0004\u0018nY\u0019\u0002\u000fQ|\u0007/[22AU\t1+\u0001\bmK\u0006$WM\u001d(pI\u0016|F%Z9\u0015\u0005\u0011<\u0007CA\u0018f\u0013\t1\u0007G\u0001\u0003V]&$\bb\u00025\u0011\u0003\u0003\u0005\raU\u0001\u0004q\u0012\n\u0014a\u00037fC\u0012,'OT8eK\u0002\nABZ8mY><XM\u001d(pI\u0016\f\u0001CZ8mY><XM\u001d(pI\u0016|F%Z9\u0015\u0005\u0011l\u0007b\u00025\u0014\u0003\u0003\u0005\raU\u0001\u000eM>dGn\\<fe:{G-\u001a\u0011\u0002!E,x\u000e^1UKN$8\t\\5f]R\u001cX#\u0001\"\u0002)E,x\u000e^1UKN$8\t\\5f]R\u001cx\fJ3r)\t!7\u000fC\u0004i-\u0005\u0005\t\u0019\u0001\"\u0002#E,x\u000e^1UKN$8\t\\5f]R\u001c\b%A\u0003tKR,\u0006\u000fF\u0001eQ\tA\u0002\u0010\u0005\u0002z}6\t!P\u0003\u0002|y\u0006)!.\u001e8ji*\tQ0A\u0002pe\u001eL!a >\u0003\r\t+gm\u001c:f\u0003u!Xm\u001d;UQJ|G\u000f\u001e7fIB\u0013x\u000eZ;dKJ\u001cuN\\:v[\u0016\u0014\bfA\r\u0002\u0006A\u0019\u00110a\u0002\n\u0007\u0005%!P\u0001\u0003UKN$\u0018a\n;fgR\u0004&o\u001c3vG\u0016\u00148i\u001c8tk6,'o\u0014<feJLG-Z+oi\"\u0014x\u000e\u001e;mK\u0012D3AGA\u0003\u0003\u0019\"Xm\u001d;Qe>$WoY3s\u0007>t7/^7fe>3XM\u001d:jI\u0016dun^3s#V|G/\u0019\u0015\u00047\u0005\u0015\u0011a\u0006;fgR\fVo\u001c;b\u001fZ,'O]5eK\u0012+G.\u001a;fQ\ra\u0012QA\u0001\u0015i\u0016\u001cH\u000f\u00165s_R$H.\u001a3SKF,Xm\u001d;)\u0007u\t)\u0001")
public abstract class BaseQuotaTest
extends IntegrationTestHarness {
    private final int brokerCount;
    private final int defaultProducerQuota;
    private final int defaultConsumerQuota;
    private final int defaultRequestQuota;
    private final String topic1;
    private KafkaServer leaderNode;
    private KafkaServer followerNode;
    private QuotaTestClients quotaTestClients;

    @Override
    public int brokerCount() {
        return this.brokerCount;
    }

    public String producerClientId() {
        return "QuotasTestProducer-1";
    }

    public String consumerClientId() {
        return "QuotasTestConsumer-1";
    }

    public abstract QuotaTestClients createQuotaTestClients(String var1, KafkaServer var2);

    public int defaultProducerQuota() {
        return this.defaultProducerQuota;
    }

    public int defaultConsumerQuota() {
        return this.defaultConsumerQuota;
    }

    public int defaultRequestQuota() {
        return this.defaultRequestQuota;
    }

    public String topic1() {
        return this.topic1;
    }

    public KafkaServer leaderNode() {
        return this.leaderNode;
    }

    public void leaderNode_$eq(KafkaServer x$1) {
        this.leaderNode = x$1;
    }

    public KafkaServer followerNode() {
        return this.followerNode;
    }

    public void followerNode_$eq(KafkaServer x$1) {
        this.followerNode = x$1;
    }

    public QuotaTestClients quotaTestClients() {
        return this.quotaTestClients;
    }

    public void quotaTestClients_$eq(QuotaTestClients x$1) {
        this.quotaTestClients = x$1;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        int numPartitions = 1;
        Map<Object, Object> leaders = this.createTopic(this.topic1(), numPartitions, this.brokerCount(), this.createTopic$default$4());
        this.leaderNode_$eq(BoxesRunTime.unboxToInt((Object)leaders.apply((Object)BoxesRunTime.boxToInteger((int)0))) == ((KafkaServer)this.servers().head()).config().brokerId() ? (KafkaServer)this.servers().head() : (KafkaServer)this.servers().apply(1));
        this.followerNode_$eq(BoxesRunTime.unboxToInt((Object)leaders.apply((Object)BoxesRunTime.boxToInteger((int)0))) != ((KafkaServer)this.servers().head()).config().brokerId() ? (KafkaServer)this.servers().head() : (KafkaServer)this.servers().apply(1));
        this.quotaTestClients_$eq(this.createQuotaTestClients(this.topic1(), this.leaderNode()));
    }

    @Test
    public void testThrottledProducerConsumer() {
        int numRecords = 1000;
        QuotaTestClients qual$1 = this.quotaTestClients();
        boolean x$2 = qual$1.produceUntilThrottled$default$2();
        int produced = qual$1.produceUntilThrottled(numRecords, x$2);
        QuotaTestClients qual$2 = this.quotaTestClients();
        boolean x$3 = true;
        boolean x$4 = qual$2.verifyProduceThrottle$default$2();
        qual$2.verifyProduceThrottle(x$3, x$4);
        QuotaTestClients qual$3 = this.quotaTestClients();
        boolean x$6 = qual$3.consumeUntilThrottled$default$2();
        Assert.assertTrue((String)"Should have consumed at least one record", (qual$3.consumeUntilThrottled(produced, x$6) > 0 ? 1 : 0) != 0);
        QuotaTestClients qual$4 = this.quotaTestClients();
        boolean x$7 = true;
        boolean x$8 = qual$4.verifyConsumeThrottle$default$2();
        qual$4.verifyConsumeThrottle(x$7, x$8);
    }

    @Test
    public void testProducerConsumerOverrideUnthrottled() {
        Properties props = new Properties();
        props.put(DynamicConfig.Client$.MODULE$.ProducerByteRateOverrideProp(), ((Object)BoxesRunTime.boxToLong((long)Long.MAX_VALUE)).toString());
        props.put(DynamicConfig.Client$.MODULE$.ConsumerByteRateOverrideProp(), ((Object)BoxesRunTime.boxToLong((long)Long.MAX_VALUE)).toString());
        this.quotaTestClients().overrideQuotas(Long.MAX_VALUE, Long.MAX_VALUE, 2.147483647E9);
        QuotaTestClients qual$1 = this.quotaTestClients();
        long x$1 = Long.MAX_VALUE;
        long x$2 = Long.MAX_VALUE;
        double x$3 = 2.147483647E9;
        KafkaServer x$4 = qual$1.waitForQuotaUpdate$default$4();
        qual$1.waitForQuotaUpdate(x$1, x$2, x$3, x$4);
        int numRecords = 1000;
        QuotaTestClients qual$2 = this.quotaTestClients();
        boolean x$6 = qual$2.produceUntilThrottled$default$2();
        Assert.assertEquals((long)numRecords, (long)qual$2.produceUntilThrottled(numRecords, x$6));
        QuotaTestClients qual$3 = this.quotaTestClients();
        boolean x$7 = false;
        boolean x$8 = qual$3.verifyProduceThrottle$default$2();
        qual$3.verifyProduceThrottle(x$7, x$8);
        QuotaTestClients qual$4 = this.quotaTestClients();
        boolean x$10 = qual$4.consumeUntilThrottled$default$2();
        Assert.assertEquals((long)numRecords, (long)qual$4.consumeUntilThrottled(numRecords, x$10));
        QuotaTestClients qual$5 = this.quotaTestClients();
        boolean x$11 = false;
        boolean x$12 = qual$5.verifyConsumeThrottle$default$2();
        qual$5.verifyConsumeThrottle(x$11, x$12);
    }

    @Test
    public void testProducerConsumerOverrideLowerQuota() {
        this.quotaTestClients().overrideQuotas(2000L, 250L, 2.147483647E9);
        QuotaTestClients qual$1 = this.quotaTestClients();
        long x$1 = 2000L;
        long x$2 = 250L;
        double x$3 = 2.147483647E9;
        KafkaServer x$4 = qual$1.waitForQuotaUpdate$default$4();
        qual$1.waitForQuotaUpdate(x$1, x$2, x$3, x$4);
        int numRecords = 1000;
        QuotaTestClients qual$2 = this.quotaTestClients();
        boolean x$6 = qual$2.produceUntilThrottled$default$2();
        int produced = qual$2.produceUntilThrottled(numRecords, x$6);
        QuotaTestClients qual$3 = this.quotaTestClients();
        boolean x$7 = true;
        boolean x$8 = qual$3.verifyProduceThrottle$default$2();
        qual$3.verifyProduceThrottle(x$7, x$8);
        QuotaTestClients qual$4 = this.quotaTestClients();
        boolean x$10 = qual$4.consumeUntilThrottled$default$2();
        Assert.assertTrue((String)"Should have consumed at least one record", (qual$4.consumeUntilThrottled(produced, x$10) > 0 ? 1 : 0) != 0);
        QuotaTestClients qual$5 = this.quotaTestClients();
        boolean x$11 = true;
        boolean x$12 = qual$5.verifyConsumeThrottle$default$2();
        qual$5.verifyConsumeThrottle(x$11, x$12);
    }

    @Test
    public void testQuotaOverrideDelete() {
        this.quotaTestClients().overrideQuotas(Long.MAX_VALUE, Long.MAX_VALUE, 2.147483647E9);
        QuotaTestClients qual$1 = this.quotaTestClients();
        long x$1 = Long.MAX_VALUE;
        long x$2 = Long.MAX_VALUE;
        double x$3 = 2.147483647E9;
        KafkaServer x$4 = qual$1.waitForQuotaUpdate$default$4();
        qual$1.waitForQuotaUpdate(x$1, x$2, x$3, x$4);
        int numRecords = 1000;
        QuotaTestClients qual$2 = this.quotaTestClients();
        boolean x$6 = qual$2.produceUntilThrottled$default$2();
        Assert.assertEquals((long)numRecords, (long)qual$2.produceUntilThrottled(numRecords, x$6));
        QuotaTestClients qual$3 = this.quotaTestClients();
        boolean x$7 = false;
        boolean x$8 = qual$3.verifyProduceThrottle$default$2();
        qual$3.verifyProduceThrottle(x$7, x$8);
        QuotaTestClients qual$4 = this.quotaTestClients();
        boolean x$10 = qual$4.consumeUntilThrottled$default$2();
        Assert.assertEquals((long)numRecords, (long)qual$4.consumeUntilThrottled(numRecords, x$10));
        QuotaTestClients qual$5 = this.quotaTestClients();
        boolean x$11 = false;
        boolean x$12 = qual$5.verifyConsumeThrottle$default$2();
        qual$5.verifyConsumeThrottle(x$11, x$12);
        this.quotaTestClients().removeQuotaOverrides();
        QuotaTestClients qual$6 = this.quotaTestClients();
        boolean x$14 = qual$6.produceUntilThrottled$default$2();
        int produced = qual$6.produceUntilThrottled(numRecords, x$14);
        QuotaTestClients qual$7 = this.quotaTestClients();
        boolean x$15 = true;
        boolean x$16 = qual$7.verifyProduceThrottle$default$2();
        qual$7.verifyProduceThrottle(x$15, x$16);
        this.quotaTestClients().consumer().seekToBeginning(Collections.singleton(new TopicPartition(this.topic1(), 0)));
        QuotaTestClients qual$8 = this.quotaTestClients();
        int x$17 = numRecords + produced;
        boolean x$18 = qual$8.consumeUntilThrottled$default$2();
        qual$8.consumeUntilThrottled(x$17, x$18);
        QuotaTestClients qual$9 = this.quotaTestClients();
        boolean x$19 = true;
        boolean x$20 = qual$9.verifyConsumeThrottle$default$2();
        qual$9.verifyConsumeThrottle(x$19, x$20);
    }

    @Test
    public void testThrottledRequest() {
        this.quotaTestClients().overrideQuotas(Long.MAX_VALUE, Long.MAX_VALUE, 0.1);
        QuotaTestClients qual$1 = this.quotaTestClients();
        long x$1 = Long.MAX_VALUE;
        long x$2 = Long.MAX_VALUE;
        double x$3 = 0.1;
        KafkaServer x$4 = qual$1.waitForQuotaUpdate$default$4();
        qual$1.waitForQuotaUpdate(x$1, x$2, x$3, x$4);
        KafkaConsumer<byte[], byte[]> consumer = this.quotaTestClients().consumer();
        consumer.subscribe(Collections.singleton(this.topic1()));
        long endTimeMs = System.currentTimeMillis() + 10000L;
        boolean throttled = false;
        while (!(throttled && this.quotaTestClients().exemptRequestMetric() != null || System.currentTimeMillis() >= endTimeMs)) {
            consumer.poll(Duration.ofMillis(100L));
            KafkaMetric throttleMetric = this.quotaTestClients().throttleMetric((QuotaType)QuotaType.Request$.MODULE$, this.consumerClientId());
            throttled = throttleMetric != null && QuotaTestClients$.MODULE$.metricValue((Metric)throttleMetric) > 0.0;
        }
        Assert.assertTrue((String)"Should have been throttled", (boolean)throttled);
        this.quotaTestClients().verifyConsumerClientThrottleTimeMetric(true, (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)((double)ClientQuotaManagerConfig$.MODULE$.DefaultQuotaWindowSizeSeconds() * 1000.0))));
        KafkaMetric exemptMetric = this.quotaTestClients().exemptRequestMetric();
        Assert.assertNotNull((String)"Exempt requests not recorded", (Object)exemptMetric);
        Assert.assertTrue((String)"Exempt requests not recorded", (QuotaTestClients$.MODULE$.metricValue((Metric)exemptMetric) > 0.0 ? 1 : 0) != 0);
    }

    public BaseQuotaTest() {
        this.brokerCount = 2;
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.ControlledShutdownEnableProp(), "false");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.OffsetsTopicReplicationFactorProp(), "2");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp(), "1");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.GroupMinSessionTimeoutMsProp(), "100");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.GroupMaxSessionTimeoutMsProp(), "30000");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.GroupInitialRebalanceDelayMsProp(), "0");
        this.producerConfig().setProperty("acks", "-1");
        this.producerConfig().setProperty("buffer.memory", "300000");
        this.producerConfig().setProperty("client.id", this.producerClientId());
        this.consumerConfig().setProperty("group.id", "QuotasTest");
        this.consumerConfig().setProperty("max.partition.fetch.bytes", ((Object)BoxesRunTime.boxToInteger((int)4096)).toString());
        this.consumerConfig().setProperty("auto.offset.reset", "earliest");
        this.consumerConfig().setProperty("client.id", this.consumerClientId());
        this.consumerConfig().setProperty("fetch.min.bytes", "0");
        this.consumerConfig().setProperty("fetch.max.wait.ms", "0");
        this.defaultProducerQuota = 8000;
        this.defaultConsumerQuota = 2500;
        this.defaultRequestQuota = Integer.MAX_VALUE;
        this.topic1 = "topic-1";
    }
}

