/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import kafka.server.CachedPartition;
import kafka.server.FetchContext;
import kafka.server.FetchSessionCache;
import kafka.server.FetchSessionCacheShard;
import kafka.server.FullFetchContext$;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.FetchMetadata;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Option$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Mt!B\r\u001b\u0011\u0003yb!B\u0011\u001b\u0011\u0003\u0011\u0003\"B\u0015\u0002\t\u0003Q\u0003bB\u0016\u0002\u0005\u0004%i\u0001\f\u0005\u0007o\u0005\u0001\u000bQB\u0017\u0007\t\u0005R\u0002\u0001\u000f\u0005\ty\u0015\u0011)\u0019!C\u0005{!A1*\u0002B\u0001B\u0003%a\b\u0003\u0005M\u000b\t\u0015\r\u0011\"\u0003N\u0011!\tVA!A!\u0002\u0013q\u0005\u0002\u0003*\u0006\u0005\u000b\u0007I\u0011B*\t\u0011i+!\u0011!Q\u0001\nQC\u0001bW\u0003\u0003\u0006\u0004%I\u0001\u0018\u0005\ta\u0016\u0011\t\u0011)A\u0005;\"A\u0011/\u0002BC\u0002\u0013%!\u000f\u0003\u0005w\u000b\t\u0005\t\u0015!\u0003t\u0011!9XA!b\u0001\n\u0013\u0011\b\u0002\u0003=\u0006\u0005\u0003\u0005\u000b\u0011B:\t\u000b%*A\u0011A=\t\r%*A\u0011AA\u0002\u0011!YS\u0001#b\u0001\n\u0003b\u0003bBA\r\u000b\u0011\u0005\u00131\u0004\u0005\b\u0003[)A\u0011IA\u0018\u0011\u001d\t\t%\u0002C!\u0003\u0007Bq!a\u001a\u0006\t\u0003\nI'\u0001\tGk2dg)\u001a;dQ\u000e{g\u000e^3yi*\u00111\u0004H\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003u\tQa[1gW\u0006\u001c\u0001\u0001\u0005\u0002!\u00035\t!D\u0001\tGk2dg)\u001a;dQ\u000e{g\u000e^3yiN\u0011\u0011a\t\t\u0003I\u001dj\u0011!\n\u0006\u0002M\u0005)1oY1mC&\u0011\u0001&\n\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005y\u0012A\u00027pO\u001e,'/F\u0001.!\tqS'D\u00010\u0015\t\u0001\u0014'\u0001\u0007tG\u0006d\u0017\r\\8hO&twM\u0003\u00023g\u0005AA/\u001f9fg\u00064WMC\u00015\u0003\r\u0019w.\\\u0005\u0003m=\u0012a\u0001T8hO\u0016\u0014\u0018a\u00027pO\u001e,'\u000fI\n\u0004\u000b\rJ\u0004C\u0001\u0011;\u0013\tY$D\u0001\u0007GKR\u001c\u0007nQ8oi\u0016DH/\u0001\u0003uS6,W#\u0001 \u0011\u0005}JU\"\u0001!\u000b\u0005\u0005\u0013\u0015!B;uS2\u001c(BA\"E\u0003\u0019\u0019w.\\7p]*\u0011Q$\u0012\u0006\u0003\r\u001e\u000ba!\u00199bG\",'\"\u0001%\u0002\u0007=\u0014x-\u0003\u0002K\u0001\n!A+[7f\u0003\u0015!\u0018.\\3!\u0003\u0015\u0019\u0017m\u00195f+\u0005q\u0005C\u0001\u0011P\u0013\t\u0001&DA\tGKR\u001c\u0007nU3tg&|gnQ1dQ\u0016\faaY1dQ\u0016\u0004\u0013a\u0003:fc6+G/\u00193bi\u0006,\u0012\u0001\u0016\t\u0003+bk\u0011A\u0016\u0006\u0003/\n\u000b\u0001B]3rk\u0016\u001cHo]\u0005\u00033Z\u0013QBR3uG\"lU\r^1eCR\f\u0017\u0001\u0004:fc6+G/\u00193bi\u0006\u0004\u0013!\u00034fi\u000eDG)\u0019;b+\u0005i\u0006\u0003\u00020dK&l\u0011a\u0018\u0006\u0003A\u0006\fA!\u001e;jY*\t!-\u0001\u0003kCZ\f\u0017B\u00013`\u0005\ri\u0015\r\u001d\t\u0003M\u001el\u0011AQ\u0005\u0003Q\n\u0013\u0001\u0003V8qS\u000eLE\rU1si&$\u0018n\u001c8\u0011\u0005)lgBA+l\u0013\tag+\u0001\u0007GKR\u001c\u0007NU3rk\u0016\u001cH/\u0003\u0002o_\ni\u0001+\u0019:uSRLwN\u001c#bi\u0006T!\u0001\u001c,\u0002\u0015\u0019,Go\u00195ECR\f\u0007%\u0001\u0007vg\u0016\u001cHk\u001c9jG&#7/F\u0001t!\t!C/\u0003\u0002vK\t9!i\\8mK\u0006t\u0017!D;tKN$v\u000e]5d\u0013\u0012\u001c\b%\u0001\bjg\u001a\u0013x.\u001c$pY2|w/\u001a:\u0002\u001f%\u001chI]8n\r>dGn\\<fe\u0002\"\u0002B_>}{z|\u0018\u0011\u0001\t\u0003A\u0015AQ\u0001\u0010\nA\u0002yBQ\u0001\u0014\nA\u00029CQA\u0015\nA\u0002QCQa\u0017\nA\u0002uCQ!\u001d\nA\u0002MDQa\u001e\nA\u0002M$RB_A\u0003\u0003\u000f\t\t\"a\u0005\u0002\u0016\u0005]\u0001\"\u0002\u001f\u0014\u0001\u0004q\u0004bBA\u0005'\u0001\u0007\u00111B\u0001\u000bG\u0006\u001c\u0007.Z*iCJ$\u0007c\u0001\u0011\u0002\u000e%\u0019\u0011q\u0002\u000e\u0003-\u0019+Go\u00195TKN\u001c\u0018n\u001c8DC\u000eDWm\u00155be\u0012DQAU\nA\u0002QCQaW\nA\u0002uCQ!]\nA\u0002MDQa^\nA\u0002M\fabZ3u\r\u0016$8\r[(gMN,G\u000f\u0006\u0003\u0002\u001e\u0005%\u0002#\u0002\u0013\u0002 \u0005\r\u0012bAA\u0011K\t1q\n\u001d;j_:\u00042\u0001JA\u0013\u0013\r\t9#\n\u0002\u0005\u0019>tw\r\u0003\u0004\u0002,U\u0001\r!Z\u0001\u0005a\u0006\u0014H/\u0001\tg_J,\u0017m\u00195QCJ$\u0018\u000e^5p]R!\u0011\u0011GA\u001c!\r!\u00131G\u0005\u0004\u0003k)#\u0001B+oSRDq!!\u000f\u0017\u0001\u0004\tY$A\u0002gk:\u0004r\u0001JA\u001fK&\f\t$C\u0002\u0002@\u0015\u0012\u0011BR;oGRLwN\u001c\u001a\u0002\u001f\u001d,GOU3ta>t7/Z*ju\u0016$b!!\u0012\u0002L\u0005u\u0003c\u0001\u0013\u0002H%\u0019\u0011\u0011J\u0013\u0003\u0007%sG\u000fC\u0004\u0002N]\u0001\r!a\u0014\u0002\u000fU\u0004H-\u0019;fgB!\u0011\u0011KA,\u001d\r\u0001\u00131K\u0005\u0004\u0003+R\u0012\u0001\u0004$fi\u000eD7+Z:tS>t\u0017\u0002BA-\u00037\u0012\u0001BU#T!~k\u0015\t\u0015\u0006\u0004\u0003+R\u0002bBA0/\u0001\u0007\u0011\u0011M\u0001\nm\u0016\u00148/[8o\u0013\u0012\u00042\u0001JA2\u0013\r\t)'\n\u0002\u0006'\"|'\u000f^\u0001\u001ekB$\u0017\r^3B]\u0012<UM\\3sCR,'+Z:q_:\u001cX\rR1uCR!\u00111NA9!\r)\u0016QN\u0005\u0004\u0003_2&!\u0004$fi\u000eD'+Z:q_:\u001cX\rC\u0004\u0002Na\u0001\r!a\u0014")
public class FullFetchContext
implements FetchContext {
    private Logger logger;
    private final Time time;
    private final FetchSessionCache cache;
    private final FetchMetadata reqMetadata;
    private final Map<TopicIdPartition, FetchRequest.PartitionData> fetchData;
    private final boolean usesTopicIds;
    private final boolean isFromFollower;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String partitionsToLogString(Collection<TopicIdPartition> partitions) {
        return FetchContext.partitionsToLogString$(this, partitions);
    }

    @Override
    public FetchResponse getThrottledResponse(int throttleTimeMs) {
        return FetchContext.getThrottledResponse$(this, throttleTimeMs);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private Time time() {
        return this.time;
    }

    private FetchSessionCache cache() {
        return this.cache;
    }

    private FetchMetadata reqMetadata() {
        return this.reqMetadata;
    }

    private Map<TopicIdPartition, FetchRequest.PartitionData> fetchData() {
        return this.fetchData;
    }

    private boolean usesTopicIds() {
        return this.usesTopicIds;
    }

    private boolean isFromFollower() {
        return this.isFromFollower;
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = FullFetchContext$.MODULE$.kafka$server$FullFetchContext$$logger();
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public Option<Object> getFetchOffset(TopicIdPartition part) {
        return Option$.MODULE$.apply((Object)this.fetchData().get(part)).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.fetchOffset));
    }

    @Override
    public void foreachPartition(Function2<TopicIdPartition, FetchRequest.PartitionData, BoxedUnit> fun) {
        this.fetchData().forEach((tp, data) -> fun.apply(tp, data));
    }

    @Override
    public int getResponseSize(LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> updates, short versionId) {
        return FetchResponse.sizeOf((short)versionId, updates.entrySet().iterator());
    }

    @Override
    public FetchResponse updateAndGenerateResponseData(LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> updates) {
        int responseSessionId = this.cache().getNextCacheShard().maybeCreateSession(this.time().milliseconds(), this.isFromFollower(), updates.size(), this.usesTopicIds(), (Function0<ImplicitLinkedHashCollection<CachedPartition>>)(Function0 & Serializable & scala.Serializable)() -> this.createNewSession$1(updates));
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Full fetch context with session id ").append(responseSessionId).append(" returning ").append(this.partitionsToLogString(updates.keySet())).toString());
        return FetchResponse.of((Errors)Errors.NONE, (int)0, (int)responseSessionId, updates);
    }

    private final ImplicitLinkedHashCollection createNewSession$1(LinkedHashMap updates$2) {
        ImplicitLinkedHashCollection cachedPartitions = new ImplicitLinkedHashCollection(updates$2.size());
        updates$2.forEach((part, respData) -> {
            FetchRequest.PartitionData reqData = this.fetchData().get(part);
            cachedPartitions.mustAdd((ImplicitLinkedHashCollection.Element)new CachedPartition((TopicIdPartition)part, reqData, (FetchResponseData.PartitionData)respData));
        });
        return cachedPartitions;
    }

    public FullFetchContext(Time time, FetchSessionCache cache, FetchMetadata reqMetadata, Map<TopicIdPartition, FetchRequest.PartitionData> fetchData, boolean usesTopicIds, boolean isFromFollower) {
        this.time = time;
        this.cache = cache;
        this.reqMetadata = reqMetadata;
        this.fetchData = fetchData;
        this.usesTopicIds = usesTopicIds;
        this.isFromFollower = isFromFollower;
        Logging.$init$(this);
        FetchContext.$init$(this);
    }

    public FullFetchContext(Time time, FetchSessionCacheShard cacheShard, FetchMetadata reqMetadata, Map<TopicIdPartition, FetchRequest.PartitionData> fetchData, boolean usesTopicIds, boolean isFromFollower) {
        this(time, new FetchSessionCache((Seq<FetchSessionCacheShard>)new .colon.colon((Object)cacheShard, (List)Nil$.MODULE$)), reqMetadata, fetchData, usesTopicIds, isFromFollower);
    }
}

