/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.metadata;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kafka.api.LeaderAndIsr$;
import kafka.cluster.Broker;
import kafka.cluster.Broker$;
import kafka.cluster.EndPoint;
import kafka.controller.StateChangeLogger;
import kafka.server.BrokerFeatures;
import kafka.server.CachedControllerId;
import kafka.server.KRaftCachedControllerId;
import kafka.server.MetadataCache;
import kafka.server.ZkCachedControllerId;
import kafka.server.metadata.FeatureCacheUpdateException;
import kafka.server.metadata.MetadataSnapshot;
import kafka.server.metadata.ZkFinalizedFeatureCache;
import kafka.server.metadata.ZkMetadataCache$;
import kafka.utils.CoreUtils$;
import kafka.utils.Implicits$;
import kafka.utils.Implicits$MapExtensionMethods$;
import kafka.utils.Logging;
import org.apache.kafka.admin.BrokerMetadata;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.message.MetadataResponseData;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractControlRequest;
import org.apache.kafka.common.requests.UpdateMetadataRequest;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.server.common.Features;
import org.apache.kafka.server.common.MetadataVersion;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.compat.MapExtensionMethods$;
import scala.collection.compat.package$;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.mutable.AnyRefMap;
import scala.collection.mutable.AnyRefMap$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.LongMap;
import scala.collection.mutable.LongMap$;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0011\u0005r!\u0002#F\u0011\u0003ae!\u0002(F\u0011\u0003y\u0005\"\u0002,\u0002\t\u00039\u0006\"\u0002-\u0002\t\u0003I\u0006\"CA\u0016\u0003E\u0005I\u0011AA\u0017\u0011%\tY%AI\u0001\n\u0003\tiEB\u0003O\u000b\u0002\t9\u0006C\u0005\u0002t\u0019\u0011\t\u0011)A\u0005e\"Q\u0011Q\u000f\u0004\u0003\u0002\u0003\u0006I!a\u001e\t\u0015\u0005\reA!A!\u0002\u0013\t)\t\u0003\u0006\u0002\f\u001a\u0011\t\u0011)A\u0005\u0003cA!\"!$\u0007\u0005\u0003\u0005\u000b\u0011BA)\u0011\u00191f\u0001\"\u0001\u0002\u0010\"I\u0011Q\u0014\u0004C\u0002\u0013%\u0011q\u0014\u0005\t\u0003c3\u0001\u0015!\u0003\u0002\"\"I\u00111\u0017\u0004A\u0002\u0013%\u0011Q\u0017\u0005\n\u0003o3\u0001\u0019!C\u0005\u0003sCq!!2\u0007A\u0003&Q\u000eC\u0005\u0002P\u001a\u0011\r\u0011\"\u0003\u0002R\"A\u0011q\u001c\u0004!\u0002\u0013\t\u0019\u000eC\u0005\u0002b\u001a\u0001\r\u0011\"\u0003\u0002d\"I\u0011\u0011\u001f\u0004A\u0002\u0013%\u00111\u001f\u0005\t\u0003o4\u0001\u0015)\u0003\u0002f\"I\u00111 \u0004C\u0002\u0013%\u0011Q \u0005\t\u0005\u000b1\u0001\u0015!\u0003\u0002\u0000\"I!q\u0001\u0004C\u0002\u0013%!\u0011\u0002\u0005\t\u0005#1\u0001\u0015!\u0003\u0003\f!I!1\u0003\u0004C\u0002\u0013%!Q\u0003\u0005\t\u0005G1\u0001\u0015!\u0003\u0003\u0018!9!Q\u0005\u0004\u0005\n\t\u001d\u0002b\u0002B*\r\u0011%!Q\u000b\u0005\b\u000533A\u0011\u0002BN\u0011\u001d\u0011\u0019K\u0002C\u0005\u0005KCqAa,\u0007\t\u0003\u0011\t\fC\u0005\u0003L\u001a\t\n\u0011\"\u0001\u0002N!I!Q\u001a\u0004\u0012\u0002\u0013\u0005\u0011Q\n\u0005\b\u0005\u001f4A\u0011\u0001Bi\u0011\u001d\u00119N\u0002C\u0001\u00053DqA!8\u0007\t\u0003\u0011y\u000eC\u0004\u0003h\u001a!\tE!;\t\u000f\t-h\u0001\"\u0011\u0003n\"9!q\u001d\u0004\u0005\n\tm\bb\u0002B\u0000\r\u0011%1\u0011\u0001\u0005\b\u0007\u001f1A\u0011AB\t\u0011\u001d\u0019)B\u0002C!\u0007/Aqaa\u0007\u0007\t\u0003\u001ai\u0002C\u0004\u0004.\u0019!\tea\f\t\u000f\rUb\u0001\"\u0011\u00048!91Q\b\u0004\u0005\u0002\r}\u0002bBB\"\r\u0011\u00051Q\t\u0005\b\u0007\u001b2A\u0011BB(\u0011\u001d\u0019\tH\u0002C\u0001\u0007gBqaa\u001f\u0007\t\u0003\u0019i\bC\u0004\u0004\u0004\u001a!\ta!\"\t\u000f\r5e\u0001\"\u0001\u0004\u0010\"91\u0011\u0014\u0004\u0005\u0002\rm\u0005bBBS\r\u0011\u00051q\u0015\u0005\b\u0007S3A\u0011ABV\u0011\u001d\u0019IL\u0002C\u0001\u0007wCqaa5\u0007\t\u0003\u0019)\u000eC\u0004\u0004T\u001a!\ta!7\t\u000f\rug\u0001\"\u0003\u0004`\"9\u0011Q\u000f\u0004\u0005B\r=\bbBBy\r\u0011\u000531\u001f\u0005\b\u0007k4A\u0011AB|\u0011\u001d!yA\u0002C\u0001\t#Aq\u0001b\u0005\u0007\t\u0003!)\u0002C\u0004\u0005 \u0019!\t%a9\u0002\u001fi[W*\u001a;bI\u0006$\u0018mQ1dQ\u0016T!AR$\u0002\u00115,G/\u00193bi\u0006T!\u0001S%\u0002\rM,'O^3s\u0015\u0005Q\u0015!B6bM.\f7\u0001\u0001\t\u0003\u001b\u0006i\u0011!\u0012\u0002\u00105.lU\r^1eCR\f7)Y2iKN\u0011\u0011\u0001\u0015\t\u0003#Rk\u0011A\u0015\u0006\u0002'\u0006)1oY1mC&\u0011QK\u0015\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005a\u0015aM7bs\n,\u0017J\u001c6fGR$U\r\\3uK\u0012\u0004\u0016M\u001d;ji&|gn\u001d$s_64U\u000f\u001c7NKR\fG-\u0019;b%\u0016\fX/Z:u)\u0011Q6\u000e];\u0011\u0007ms\u0006-D\u0001]\u0015\ti&+\u0001\u0006d_2dWm\u0019;j_:L!a\u0018/\u0003\u0007M+\u0017\u000f\u0005\u0002bS6\t!M\u0003\u0002dI\u000611m\\7n_:T!AS3\u000b\u0005\u0019<\u0017AB1qC\u000eDWMC\u0001i\u0003\ry'oZ\u0005\u0003U\n\u0014A!V;jI\")An\u0001a\u0001[\u0006y1-\u001e:sK:$X*\u001a;bI\u0006$\u0018\r\u0005\u0002N]&\u0011q.\u0012\u0002\u0011\u001b\u0016$\u0018\rZ1uCNs\u0017\r]:i_RDQ!]\u0002A\u0002I\faC]3rk\u0016\u001cHoQ8oiJ|G\u000e\\3s\u000bB|7\r\u001b\t\u0003#NL!\u0001\u001e*\u0003\u0007%sG\u000fC\u0003w\u0007\u0001\u0007q/\u0001\nsKF,Xm\u001d;U_BL7m\u0015;bi\u0016\u001c\bc\u0001=~\u007f6\t\u0011P\u0003\u0002{w\u0006!Q\u000f^5m\u0015\u0005a\u0018\u0001\u00026bm\u0006L!A`=\u0003\t1K7\u000f\u001e\t\u0005\u0003\u0003\t)C\u0004\u0003\u0002\u0004\u0005}a\u0002BA\u0003\u00037qA!a\u0002\u0002\u001a9!\u0011\u0011BA\f\u001d\u0011\tY!!\u0006\u000f\t\u00055\u00111C\u0007\u0003\u0003\u001fQ1!!\u0005L\u0003\u0019a$o\\8u}%\t\u0001.\u0003\u0002gO&\u0011!*Z\u0005\u0003G\u0012L1!!\bc\u0003\u001diWm]:bO\u0016LA!!\t\u0002$\u0005IR\u000b\u001d3bi\u0016lU\r^1eCR\f'+Z9vKN$H)\u0019;b\u0015\r\tiBY\u0005\u0005\u0003O\tIC\u0001\rVa\u0012\fG/Z'fi\u0006$\u0017\r^1U_BL7m\u0015;bi\u0016TA!!\t\u0002$\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIQ*\"!a\f+\t\u0005E\u0012\u0011\b\t\u00057z\u000b\u0019\u0004E\u0002b\u0003kI1!a\u000ec\u0005\u0011qu\u000eZ3,\u0005\u0005m\u0002\u0003BA\u001f\u0003\u000fj!!a\u0010\u000b\t\u0005\u0005\u00131I\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\u0012S\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003\u0013\nyDA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012*TCAA(U\u0011\t\t&!\u000f\u0011\u0007E\u000b\u0019&C\u0002\u0002VI\u0013qAQ8pY\u0016\fgn\u0005\u0005\u0007!\u0006e\u0013\u0011MA4!\u0011\tY&!\u0018\u000e\u0003\u001dK1!a\u0018H\u00055iU\r^1eCR\f7)Y2iKB\u0019Q*a\u0019\n\u0007\u0005\u0015TIA\f[W\u001aKg.\u00197ju\u0016$g)Z1ukJ,7)Y2iKB!\u0011\u0011NA8\u001b\t\tYGC\u0002\u0002n%\u000bQ!\u001e;jYNLA!!\u001d\u0002l\t9Aj\\4hS:<\u0017\u0001\u00032s_.,'/\u00133\u0002\u001f5,G/\u00193bi\u00064VM]:j_:\u0004B!!\u001f\u0002\u00005\u0011\u00111\u0010\u0006\u0004G\u0006u$B\u0001%e\u0013\u0011\t\t)a\u001f\u0003\u001f5+G/\u00193bi\u00064VM]:j_:\faB\u0019:pW\u0016\u0014h)Z1ukJ,7\u000f\u0005\u0003\u0002\\\u0005\u001d\u0015bAAE\u000f\nq!I]8lKJ4U-\u0019;ve\u0016\u001c\u0018\u0001F6sC\u001a$8i\u001c8ue>dG.\u001a:O_\u0012,7/\u0001\n{W6KwM]1uS>tWI\\1cY\u0016$G\u0003DAI\u0003'\u000b)*a&\u0002\u001a\u0006m\u0005CA'\u0007\u0011\u0019\t\u0019\b\u0004a\u0001e\"9\u0011Q\u000f\u0007A\u0002\u0005]\u0004bBAB\u0019\u0001\u0007\u0011Q\u0011\u0005\n\u0003\u0017c\u0001\u0013!a\u0001\u0003cA\u0011\"!$\r!\u0003\u0005\r!!\u0015\u0002+A\f'\u000f^5uS>tW*\u001a;bI\u0006$\u0018\rT8dWV\u0011\u0011\u0011\u0015\t\u0005\u0003G\u000bi+\u0004\u0002\u0002&*!\u0011qUAU\u0003\u0015awnY6t\u0015\r\tY+_\u0001\u000bG>t7-\u001e:sK:$\u0018\u0002BAX\u0003K\u0013aCU3f]R\u0014\u0018M\u001c;SK\u0006$wK]5uK2{7m[\u0001\u0017a\u0006\u0014H/\u001b;j_:lU\r^1eCR\fGj\\2lA\u0005\u0001R.\u001a;bI\u0006$\u0018m\u00158baNDw\u000e^\u000b\u0002[\u0006!R.\u001a;bI\u0006$\u0018m\u00158baNDw\u000e^0%KF$B!a/\u0002BB\u0019\u0011+!0\n\u0007\u0005}&K\u0001\u0003V]&$\b\u0002CAb!\u0005\u0005\t\u0019A7\u0002\u0007a$\u0013'A\tnKR\fG-\u0019;b':\f\u0007o\u001d5pi\u0002B3!EAe!\r\t\u00161Z\u0005\u0004\u0003\u001b\u0014&\u0001\u0003<pY\u0006$\u0018\u000e\\3\u0002#M$\u0018\r^3DQ\u0006tw-\u001a'pO\u001e,'/\u0006\u0002\u0002TB!\u0011Q[An\u001b\t\t9NC\u0002\u0002Z&\u000b!bY8oiJ|G\u000e\\3s\u0013\u0011\ti.a6\u0003#M#\u0018\r^3DQ\u0006tw-\u001a'pO\u001e,'/\u0001\nti\u0006$Xm\u00115b]\u001e,Gj\\4hKJ\u0004\u0013!C0gK\u0006$XO]3t+\t\t)\u000fE\u0003R\u0003O\fY/C\u0002\u0002jJ\u0013aa\u00149uS>t\u0007\u0003BA=\u0003[LA!a<\u0002|\tAa)Z1ukJ,7/A\u0007`M\u0016\fG/\u001e:fg~#S-\u001d\u000b\u0005\u0003w\u000b)\u0010C\u0005\u0002DV\t\t\u00111\u0001\u0002f\u0006QqLZ3biV\u0014Xm\u001d\u0011)\u0007Y\tI-A\u0006gK\u0006$XO]3M_\u000e\\WCAA\u0000!\u0011\t\u0019K!\u0001\n\t\t\r\u0011Q\u0015\u0002\u000e%\u0016,g\u000e\u001e:b]RdunY6\u0002\u0019\u0019,\u0017\r^;sK2{7m\u001b\u0011\u0002\u0017\u0019,\u0017\r^;sK\u000e{g\u000eZ\u000b\u0003\u0005\u0017\u0001B!a)\u0003\u000e%!!qBAS\u0005%\u0019uN\u001c3ji&|g.\u0001\u0007gK\u0006$XO]3D_:$\u0007%\u0001\fle\u00064GoQ8oiJ|G\u000e\\3s\u001d>$W-T1q+\t\u00119\u0002E\u0004\u0003\u001a\t}!/a\r\u000e\u0005\tm!b\u0001B\u000f9\u0006I\u0011.\\7vi\u0006\u0014G.Z\u0005\u0005\u0005C\u0011YBA\u0002NCB\fqc\u001b:bMR\u001cuN\u001c;s_2dWM\u001d(pI\u0016l\u0015\r\u001d\u0011\u000215\f\u0017PY3GS2$XM]!mSZ,'+\u001a9mS\u000e\f7\u000f\u0006\u0006\u0003*\t]\"1\bB \u0005\u001f\u0002B\u0001_?\u0003,A!!Q\u0006B\u001a\u001b\t\u0011yCC\u0002\u00032m\fA\u0001\\1oO&!!Q\u0007B\u0018\u0005\u001dIe\u000e^3hKJDaA!\u000f\u001e\u0001\u0004i\u0017\u0001C:oCB\u001c\bn\u001c;\t\u000f\tuR\u00041\u0001\u0003*\u00059!M]8lKJ\u001c\bb\u0002B!;\u0001\u0007!1I\u0001\rY&\u001cH/\u001a8fe:\u000bW.\u001a\t\u0005\u0005\u000b\u0012Y%\u0004\u0002\u0003H)\u0019!\u0011\n2\u0002\u000f9,Go^8sW&!!Q\nB$\u00051a\u0015n\u001d;f]\u0016\u0014h*Y7f\u0011\u001d\u0011\t&\ba\u0001\u0003#\n!DZ5mi\u0016\u0014XK\\1wC&d\u0017M\u00197f\u000b:$\u0007o\\5oiN\fAcZ3u!\u0006\u0014H/\u001b;j_:lU\r^1eCR\fG\u0003\u0004B,\u0005s\u0012YHa$\u0003\u0012\nU\u0005#B)\u0002h\ne\u0003C\u0002B.\u0005K\u0012YG\u0004\u0003\u0003^\t\u0005d\u0002BA\u0007\u0005?J\u0011aU\u0005\u0004\u0005G\u0012\u0016a\u00029bG.\fw-Z\u0005\u0005\u0005O\u0012IG\u0001\u0005Ji\u0016\u0014\u0018M\u00197f\u0015\r\u0011\u0019G\u0015\t\u0005\u0005[\u0012\u0019H\u0004\u0003\u0002\u0004\t=\u0014\u0002\u0002B9\u0003G\tA#T3uC\u0012\fG/\u0019*fgB|gn]3ECR\f\u0017\u0002\u0002B;\u0005o\u0012\u0011$T3uC\u0012\fG/\u0019*fgB|gn]3QCJ$\u0018\u000e^5p]*!!\u0011OA\u0012\u0011\u0019\u0011ID\ba\u0001[\"9!Q\u0010\u0010A\u0002\t}\u0014!\u0002;pa&\u001c\u0007\u0003\u0002BA\u0005\u0013sAAa!\u0003\u0006B\u0019\u0011Q\u0002*\n\u0007\t\u001d%+\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0005\u0017\u0013iI\u0001\u0004TiJLgn\u001a\u0006\u0004\u0005\u000f\u0013\u0006b\u0002B!=\u0001\u0007!1\t\u0005\b\u0005's\u0002\u0019AA)\u0003e)'O]8s+:\fg/Y5mC\ndW-\u00128ea>Lg\u000e^:\t\u000f\t]e\u00041\u0001\u0002R\u0005IRM\u001d:peVs\u0017M^1jY\u0006\u0014G.\u001a'jgR,g.\u001a:t\u0003AA\u0017m]!mSZ,WI\u001c3q_&tG\u000f\u0006\u0005\u0002R\tu%q\u0014BQ\u0011\u0019\u0011Id\ba\u0001[\"1\u00111O\u0010A\u0002IDqA!\u0011 \u0001\u0004\u0011\u0019%\u0001\thKR\fE.\u001b<f\u000b:$\u0007o\\5oiRA!q\u0015BU\u0005W\u0013i\u000bE\u0003R\u0003O\f\u0019\u0004\u0003\u0004\u0003:\u0001\u0002\r!\u001c\u0005\u0007\u0003g\u0002\u0003\u0019\u0001:\t\u000f\t\u0005\u0003\u00051\u0001\u0003D\u0005\u0001r-\u001a;U_BL7-T3uC\u0012\fG/\u0019\u000b\u000b\u0005g\u0013YL!2\u0003H\n%\u0007\u0003B._\u0005k\u0003BA!\u001c\u00038&!!\u0011\u0018B<\u0005UiU\r^1eCR\f'+Z:q_:\u001cX\rV8qS\u000eDqA!0\"\u0001\u0004\u0011y,\u0001\u0004u_BL7m\u001d\t\u00067\n\u0005'qP\u0005\u0004\u0005\u0007d&aA*fi\"9!\u0011I\u0011A\u0002\t\r\u0003\"\u0003BJCA\u0005\t\u0019AA)\u0011%\u00119*\tI\u0001\u0002\u0004\t\t&\u0001\u000ehKR$v\u000e]5d\u001b\u0016$\u0018\rZ1uC\u0012\"WMZ1vYR$3'\u0001\u000ehKR$v\u000e]5d\u001b\u0016$\u0018\rZ1uC\u0012\"WMZ1vYR$C'A\bu_BL7MT1nKN$v.\u00133t)\t\u0011\u0019\u000e\u0005\u0004y\u0005+\u0014y\bY\u0005\u0004\u0005CI\u0018a\u0004;pa&\u001c\u0017\nZ:U_:\u000bW.Z:\u0015\u0005\tm\u0007C\u0002=\u0003V\u0002\u0014y(A\u0006u_BL7-\u00133J]\u001a|GC\u0001Bq!\u001d\t&1\u001dBj\u00057L1A!:S\u0005\u0019!V\u000f\u001d7fe\u0005aq-\u001a;BY2$v\u000e]5dgR\u0011!qX\u0001\u0013O\u0016$Hk\u001c9jGB\u000b'\u000f^5uS>t7\u000f\u0006\u0003\u0003p\n]\b#B.\u0003B\nE\bcA1\u0003t&\u0019!Q\u001f2\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\"9!\u0011 \u0015A\u0002\t}\u0014!\u0003;pa&\u001cg*Y7f)\u0011\u0011yL!@\t\r\te\u0012\u00061\u0001n\u0003A9W\r^!mYB\u000b'\u000f^5uS>t7\u000f\u0006\u0003\u0004\u0004\r5\u0001\u0003\u0003BA\u0007\u000b\u0011\tpa\u0002\n\t\t\u0005\"Q\u0012\t\u0005\u0003\u0003\u0019I!\u0003\u0003\u0004\f\u0005%\"\u0001H+qI\u0006$X-T3uC\u0012\fG/\u0019)beRLG/[8o'R\fG/\u001a\u0005\u0007\u0005sQ\u0003\u0019A7\u0002)\u001d,GOT8o\u000bbL7\u000f^5oOR{\u0007/[2t)\u0011\u0011yla\u0005\t\u000f\tu6\u00061\u0001\u0003@\u0006q\u0001.Y:BY&4XM\u0011:pW\u0016\u0014H\u0003BA)\u00073Aa!a\u001d-\u0001\u0004\u0011\u0018aD4fi\u0006c\u0017N^3Ce>\\WM]:\u0015\u0005\r}\u0001C\u0002B.\u0005K\u001a\t\u0003\u0005\u0003\u0004$\r%RBAB\u0013\u0015\r\u00199\u0003Z\u0001\u0006C\u0012l\u0017N\\\u0005\u0005\u0007W\u0019)C\u0001\bCe>\\WM]'fi\u0006$\u0017\r^1\u0002%\u001d,G/\u00117jm\u0016\u0014%o\\6fe:{G-\u001a\u000b\u0007\u0005O\u001b\tda\r\t\r\u0005Md\u00061\u0001s\u0011\u001d\u0011\tE\fa\u0001\u0005\u0007\n1cZ3u\u00032Lg/\u001a\"s_.,'OT8eKN$Ba!\u000f\u0004<A1!1\fB3\u0003gAqA!\u00110\u0001\u0004\u0011\u0019%\u0001\u0006hKR$v\u000e]5d\u0013\u0012$2\u0001YB!\u0011\u001d\u0011I\u0010\ra\u0001\u0005\u007f\nAbZ3u)>\u0004\u0018n\u0019(b[\u0016$Baa\u0012\u0004JA)\u0011+a:\u0003\u0000!111J\u0019A\u0002\u0001\fq\u0001^8qS\u000eLE-\u0001\rbI\u0012|%/\u00169eCR,\u0007+\u0019:uSRLwN\\%oM>$\"\"a/\u0004R\r\u001d4\u0011NB7\u0011\u001d\u0019\u0019F\ra\u0001\u0007+\nq\u0002]1si&$\u0018n\u001c8Ti\u0006$Xm\u001d\t\t\u0007/\u001aiFa \u0004b5\u00111\u0011\f\u0006\u0004\u00077b\u0016aB7vi\u0006\u0014G.Z\u0005\u0005\u0007?\u001aIFA\u0005B]f\u0014VMZ'baB11qKB2\u0007\u000fIAa!\u001a\u0004Z\t9Aj\u001c8h\u001b\u0006\u0004\bb\u0002B?e\u0001\u0007!q\u0010\u0005\u0007\u0007W\u0012\u0004\u0019\u0001:\u0002\u0017A\f'\u000f^5uS>t\u0017\n\u001a\u0005\b\u0007_\u0012\u0004\u0019AB\u0004\u0003%\u0019H/\u0019;f\u0013:4w.\u0001\thKR\u0004\u0016M\u001d;ji&|g.\u00138g_R11QOB<\u0007s\u0002R!UAt\u0007\u000fAqA! 4\u0001\u0004\u0011y\b\u0003\u0004\u0004lM\u0002\rA]\u0001\u000e]Vl\u0007+\u0019:uSRLwN\\:\u0015\t\r}4\u0011\u0011\t\u0005#\u0006\u001d(\u000fC\u0004\u0003~Q\u0002\rAa \u00025\u001d,G\u000fU1si&$\u0018n\u001c8MK\u0006$WM]#oIB|\u0017N\u001c;\u0015\u0011\t\u001d6qQBE\u0007\u0017CqA! 6\u0001\u0004\u0011y\b\u0003\u0004\u0004lU\u0002\rA\u001d\u0005\b\u0005\u0003*\u0004\u0019\u0001B\"\u0003q9W\r\u001e)beRLG/[8o%\u0016\u0004H.[2b\u000b:$\u0007o\\5oiN$ba!%\u0004\u0014\u000e]\u0005c\u0002BA\u0007\u000b\u0011\u00181\u0007\u0005\b\u0007+3\u0004\u0019\u0001By\u0003\t!\b\u000fC\u0004\u0003BY\u0002\rAa\u0011\u0002\u001f\u001d,GoQ8oiJ|G\u000e\\3s\u0013\u0012,\"a!(\u0011\u000bE\u000b9oa(\u0011\t\u0005m3\u0011U\u0005\u0004\u0007G;%AE\"bG\",GmQ8oiJ|G\u000e\\3s\u0013\u0012\facZ3u%\u0006tGm\\7BY&4XM\u0011:pW\u0016\u0014\u0018\nZ\u000b\u0003\u0007\u007f\n!cZ3u\u00072,8\u000f^3s\u001b\u0016$\u0018\rZ1uCR11QVBZ\u0007o\u00032!YBX\u0013\r\u0019\tL\u0019\u0002\b\u00072,8\u000f^3s\u0011\u001d\u0019),\u000fa\u0001\u0005\u007f\n\u0011b\u00197vgR,'/\u00133\t\u000f\t\u0005\u0013\b1\u0001\u0003D\u0005qQ\u000f\u001d3bi\u0016lU\r^1eCR\fGCBB_\u0007\u007f\u001b\u0019\r\u0005\u0003\\=\nE\bBBBau\u0001\u0007!/A\u0007d_J\u0014X\r\\1uS>t\u0017\n\u001a\u0005\b\u0007\u000bT\u0004\u0019ABd\u0003U)\b\u000fZ1uK6+G/\u00193bi\u0006\u0014V-];fgR\u0004Ba!3\u0004P6\u001111\u001a\u0006\u0004\u0007\u001b\u0014\u0017\u0001\u0003:fcV,7\u000f^:\n\t\rE71\u001a\u0002\u0016+B$\u0017\r^3NKR\fG-\u0019;b%\u0016\fX/Z:u\u0003!\u0019wN\u001c;bS:\u001cH\u0003BA)\u0007/DqA! <\u0001\u0004\u0011y\b\u0006\u0003\u0002R\rm\u0007bBBKy\u0001\u0007!\u0011_\u0001\u0014e\u0016lwN^3QCJ$\u0018\u000e^5p]&sgm\u001c\u000b\u000b\u0003#\u001a\toa9\u0004l\u000e5\bbBB*{\u0001\u00071Q\u000b\u0005\b\u0007Kl\u0004\u0019ABt\u0003!!x\u000e]5d\u0013\u0012\u001c\bcBB,\u0007S\u0014y\bY\u0005\u0005\u0005C\u0019I\u0006C\u0004\u0003~u\u0002\rAa \t\r\r-T\b1\u0001s)\t\t9(\u0001\u0005gK\u0006$XO]3t)\t\tY/A\u000bva\u0012\fG/\u001a$fCR,(/Z:PeRC'o\\<\u0015\r\u0005m6\u0011 C\u0003\u0011\u001d\u0019Y\u0010\u0011a\u0001\u0007{\fa\u0002\\1uKN$h)Z1ukJ,7\u000f\u0005\u0005\u0003\u0002\u000e\u0015!qPB\u0000!\r\tF\u0011A\u0005\u0004\t\u0007\u0011&!B*i_J$\bb\u0002C\u0004\u0001\u0002\u0007A\u0011B\u0001\fY\u0006$Xm\u001d;Fa>\u001c\u0007\u000eE\u0002R\t\u0017I1\u0001\"\u0004S\u0005\u0011auN\\4\u0002\u001b\rdW-\u0019:GK\u0006$XO]3t)\t\tY,\u0001\u000fxC&$XK\u001c;jY\u001a+\u0017\r^;sK\u0016\u0003xn\u00195PeRC'o\\<\u0015\r\u0005mFq\u0003C\u000e\u0011\u001d!IB\u0011a\u0001\t\u0013\t\u0001#\\5o\u000bb\u0004Xm\u0019;fI\u0016\u0003xn\u00195\t\u000f\u0011u!\t1\u0001\u0005\n\u0005IA/[7f_V$Xj]\u0001\u0011O\u0016$h)Z1ukJ,w\n\u001d;j_:\u0004")
public class ZkMetadataCache
implements MetadataCache,
ZkFinalizedFeatureCache,
Logging {
    private final int brokerId;
    private final MetadataVersion metadataVersion;
    private final BrokerFeatures brokerFeatures;
    private final boolean zkMigrationEnabled;
    private final ReentrantReadWriteLock partitionMetadataLock;
    private volatile MetadataSnapshot metadataSnapshot;
    private final StateChangeLogger stateChangeLogger;
    private volatile Option<Features> _features;
    private final ReentrantLock featureLock;
    private final Condition featureCond;
    private final scala.collection.immutable.Map<Object, Node> kraftControllerNodeMap;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static boolean $lessinit$greater$default$5() {
        return ZkMetadataCache$.MODULE$.$lessinit$greater$default$5();
    }

    public static Seq<Node> $lessinit$greater$default$4() {
        return ZkMetadataCache$.MODULE$.$lessinit$greater$default$4();
    }

    public static Seq<Uuid> maybeInjectDeletedPartitionsFromFullMetadataRequest(MetadataSnapshot metadataSnapshot, int n, java.util.List<UpdateMetadataRequestData.UpdateMetadataTopicState> list) {
        return ZkMetadataCache$.MODULE$.maybeInjectDeletedPartitionsFromFullMetadataRequest(metadataSnapshot, n, list);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private ReentrantReadWriteLock partitionMetadataLock() {
        return this.partitionMetadataLock;
    }

    private MetadataSnapshot metadataSnapshot() {
        return this.metadataSnapshot;
    }

    private void metadataSnapshot_$eq(MetadataSnapshot x$1) {
        this.metadataSnapshot = x$1;
    }

    private StateChangeLogger stateChangeLogger() {
        return this.stateChangeLogger;
    }

    private Option<Features> _features() {
        return this._features;
    }

    private void _features_$eq(Option<Features> x$1) {
        this._features = x$1;
    }

    private ReentrantLock featureLock() {
        return this.featureLock;
    }

    private Condition featureCond() {
        return this.featureCond;
    }

    private scala.collection.immutable.Map<Object, Node> kraftControllerNodeMap() {
        return this.kraftControllerNodeMap;
    }

    private java.util.List<Integer> maybeFilterAliveReplicas(MetadataSnapshot snapshot, java.util.List<Integer> brokers, ListenerName listenerName, boolean filterUnavailableEndpoints) {
        if (!filterUnavailableEndpoints) {
            return brokers;
        }
        ArrayList<Integer> res = new ArrayList<Integer>(scala.math.package$.MODULE$.min(snapshot.aliveBrokers().size(), brokers.size()));
        ((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(brokers).asScala()).foreach((Function1 & Serializable & scala.Serializable)brokerId -> {
            if (this.hasAliveEndpoint(snapshot, Predef$.MODULE$.Integer2int(brokerId), listenerName)) {
                return BoxesRunTime.boxToBoolean((boolean)res.add((Integer)brokerId));
            }
            return BoxedUnit.UNIT;
        });
        return res;
    }

    private Option<Iterable<MetadataResponseData.MetadataResponsePartition>> getPartitionMetadata(MetadataSnapshot snapshot, String topic, ListenerName listenerName, boolean errorUnavailableEndpoints, boolean errorUnavailableListeners) {
        return snapshot.partitionStates().get((Object)topic).map((Function1 & Serializable & scala.Serializable)partitions -> (Iterable)partitions.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 != null) {
                long partitionId = x0$1._1$mcJ$sp();
                UpdateMetadataRequestData.UpdateMetadataPartitionState partitionState = (UpdateMetadataRequestData.UpdateMetadataPartitionState)x0$1._2();
                TopicPartition topicPartition = new TopicPartition(topic, (int)partitionId);
                int leaderBrokerId = partitionState.leader();
                int leaderEpoch = partitionState.leaderEpoch();
                Option<Node> maybeLeader = this.getAliveEndpoint(snapshot, leaderBrokerId, listenerName);
                java.util.List replicas = partitionState.replicas();
                java.util.List<Integer> filteredReplicas = this.maybeFilterAliveReplicas(snapshot, replicas, listenerName, errorUnavailableEndpoints);
                java.util.List isr = partitionState.isr();
                java.util.List<Integer> filteredIsr = this.maybeFilterAliveReplicas(snapshot, isr, listenerName, errorUnavailableEndpoints);
                java.util.List offlineReplicas = partitionState.offlineReplicas();
                if (None$.MODULE$.equals(maybeLeader)) {
                    Errors errors;
                    if (!snapshot.aliveBrokers().contains((long)leaderBrokerId)) {
                        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Error while fetching metadata for ").append(topicPartition).append(": leader not available").toString());
                        errors = Errors.LEADER_NOT_AVAILABLE;
                    } else {
                        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(66).append("Error while fetching metadata for ").append(topicPartition).append(": listener ").append(listenerName).append(" ").append("not found on leader ").append(leaderBrokerId).toString());
                        errors = errorUnavailableListeners ? Errors.LISTENER_NOT_FOUND : Errors.LEADER_NOT_AVAILABLE;
                    }
                    Errors error = errors;
                    return new MetadataResponseData.MetadataResponsePartition().setErrorCode(error.code()).setPartitionIndex((int)partitionId).setLeaderId(-1).setLeaderEpoch(leaderEpoch).setReplicaNodes(filteredReplicas).setIsrNodes(filteredIsr).setOfflineReplicas(offlineReplicas);
                }
                if (maybeLeader instanceof Some) {
                    Errors errors;
                    if (filteredReplicas.size() < replicas.size()) {
                        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(92).append("Error while fetching metadata for ").append(topicPartition).append(": replica information not available for ").append("following brokers ").append(((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(replicas).asScala()).filterNot((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)filteredReplicas.contains(x$1)))).mkString(",")).toString());
                        errors = Errors.REPLICA_NOT_AVAILABLE;
                    } else if (filteredIsr.size() < isr.size()) {
                        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(100).append("Error while fetching metadata for ").append(topicPartition).append(": in sync replica information not available for ").append("following brokers ").append(((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(isr).asScala()).filterNot((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)filteredIsr.contains(x$1)))).mkString(",")).toString());
                        errors = Errors.REPLICA_NOT_AVAILABLE;
                    } else {
                        errors = Errors.NONE;
                    }
                    Errors error = errors;
                    return new MetadataResponseData.MetadataResponsePartition().setErrorCode(error.code()).setPartitionIndex((int)partitionId).setLeaderId(BoxesRunTime.unboxToInt((Object)maybeLeader.map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.id())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> -1))).setLeaderEpoch(leaderEpoch).setReplicaNodes(filteredReplicas).setIsrNodes(filteredIsr).setOfflineReplicas(offlineReplicas);
                }
                throw new MatchError(maybeLeader);
            }
            throw new MatchError(null);
        }, scala.collection.mutable.Iterable$.MODULE$.canBuildFrom()));
    }

    private boolean hasAliveEndpoint(MetadataSnapshot snapshot, int brokerId, ListenerName listenerName) {
        return snapshot.aliveNodes().get((long)brokerId).exists((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.contains((Object)listenerName)));
    }

    private Option<Node> getAliveEndpoint(MetadataSnapshot snapshot, int brokerId, ListenerName listenerName) {
        return snapshot.aliveNodes().get((long)brokerId).flatMap((Function1 & Serializable & scala.Serializable)x$4 -> x$4.get((Object)listenerName));
    }

    @Override
    public Seq<MetadataResponseData.MetadataResponseTopic> getTopicMetadata(Set<String> topics, ListenerName listenerName, boolean errorUnavailableEndpoints, boolean errorUnavailableListeners) {
        MetadataSnapshot snapshot = this.metadataSnapshot();
        return (Seq)topics.toSeq().flatMap((Function1 & Serializable & scala.Serializable)topic -> Option$.MODULE$.option2Iterable(this.getPartitionMetadata(snapshot, (String)topic, listenerName, errorUnavailableEndpoints, errorUnavailableListeners).map((Function1 & Serializable & scala.Serializable)partitionMetadata -> new MetadataResponseData.MetadataResponseTopic().setErrorCode(Errors.NONE.code()).setName(topic).setTopicId((Uuid)snapshot.topicIds().getOrElse(topic, (Function0 & Serializable & scala.Serializable)() -> Uuid.ZERO_UUID)).setIsInternal(Topic.isInternal((String)topic)).setPartitions((java.util.List)CollectionConverters$.MODULE$.bufferAsJavaListConverter(partitionMetadata.toBuffer()).asJava()))), Seq$.MODULE$.canBuildFrom());
    }

    @Override
    public boolean getTopicMetadata$default$3() {
        return false;
    }

    @Override
    public boolean getTopicMetadata$default$4() {
        return false;
    }

    @Override
    public java.util.Map<String, Uuid> topicNamesToIds() {
        return Collections.unmodifiableMap((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(this.metadataSnapshot().topicIds()).asJava());
    }

    @Override
    public java.util.Map<Uuid, String> topicIdsToNames() {
        return Collections.unmodifiableMap((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(this.metadataSnapshot().topicNames()).asJava());
    }

    @Override
    public Tuple2<java.util.Map<String, Uuid>, java.util.Map<Uuid, String>> topicIdInfo() {
        MetadataSnapshot snapshot = this.metadataSnapshot();
        return new Tuple2(Collections.unmodifiableMap((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(snapshot.topicIds()).asJava()), Collections.unmodifiableMap((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(snapshot.topicNames()).asJava()));
    }

    @Override
    public Set<String> getAllTopics() {
        return this.getAllTopics(this.metadataSnapshot());
    }

    @Override
    public Set<TopicPartition> getTopicPartitions(String topicName) {
        return ((TraversableOnce)((MapLike)this.metadataSnapshot().partitionStates().getOrElse((Object)topicName, (Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Map().empty())).values().map((Function1 & Serializable & scala.Serializable)p -> new TopicPartition(topicName, p.partitionIndex()), scala.collection.Iterable$.MODULE$.canBuildFrom())).toSet();
    }

    private Set<String> getAllTopics(MetadataSnapshot snapshot) {
        return snapshot.partitionStates().keySet();
    }

    private scala.collection.immutable.Map<TopicPartition, UpdateMetadataRequestData.UpdateMetadataPartitionState> getAllPartitions(MetadataSnapshot snapshot) {
        return ((TraversableOnce)snapshot.partitionStates().flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 != null) {
                String topic = (String)x0$1._1();
                return (scala.collection.mutable.Map)((LongMap)x0$1._2()).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                    if (x0$2 != null) {
                        long partition = x0$2._1$mcJ$sp();
                        UpdateMetadataRequestData.UpdateMetadataPartitionState state = (UpdateMetadataRequestData.UpdateMetadataPartitionState)x0$2._2();
                        return new Tuple2((Object)new TopicPartition(topic, (int)partition), (Object)state);
                    }
                    throw new MatchError(null);
                }, Map$.MODULE$.canBuildFrom());
            }
            throw new MatchError(null);
        }, AnyRefMap$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public Set<String> getNonExistingTopics(Set<String> topics) {
        return topics.diff((GenSet)this.metadataSnapshot().partitionStates().keySet());
    }

    @Override
    public boolean hasAliveBroker(int brokerId) {
        return this.metadataSnapshot().aliveBrokers().contains((long)brokerId);
    }

    @Override
    public Iterable<BrokerMetadata> getAliveBrokers() {
        return (Iterable)this.metadataSnapshot().aliveBrokers().values().map((Function1 & Serializable & scala.Serializable)b -> new BrokerMetadata(b.id(), Optional.ofNullable(b.rack().orNull(Predef$.MODULE$.$conforms()))), scala.collection.Iterable$.MODULE$.canBuildFrom());
    }

    @Override
    public Option<Node> getAliveBrokerNode(int brokerId, ListenerName listenerName) {
        MetadataSnapshot snapshot = this.metadataSnapshot();
        switch (brokerId) {
            default: 
        }
        if (snapshot.controllerId().filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)ZkMetadataCache.$anonfun$getAliveBrokerNode$1(x$5))).exists((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)ZkMetadataCache.$anonfun$getAliveBrokerNode$2(brokerId, x$6)))) {
            return this.kraftControllerNodeMap().get((Object)BoxesRunTime.boxToInteger((int)brokerId));
        }
        return snapshot.aliveBrokers().get((long)brokerId).flatMap((Function1 & Serializable & scala.Serializable)x$7 -> x$7.getNode(listenerName));
    }

    @Override
    public Iterable<Node> getAliveBrokerNodes(ListenerName listenerName) {
        return (Iterable)this.metadataSnapshot().aliveBrokers().values().flatMap((Function1 & Serializable & scala.Serializable)x$8 -> Option$.MODULE$.option2Iterable(x$8.getNode(listenerName)), scala.collection.Iterable$.MODULE$.canBuildFrom());
    }

    @Override
    public Uuid getTopicId(String topicName) {
        return (Uuid)this.metadataSnapshot().topicIds().getOrElse((Object)topicName, (Function0 & Serializable & scala.Serializable)() -> Uuid.ZERO_UUID);
    }

    @Override
    public Option<String> getTopicName(Uuid topicId) {
        return this.metadataSnapshot().topicNames().get((Object)topicId);
    }

    private void addOrUpdatePartitionInfo(AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>> partitionStates, String topic, int partitionId, UpdateMetadataRequestData.UpdateMetadataPartitionState stateInfo) {
        ((LongMap)partitionStates.getOrElseUpdate((Object)topic, (Function0 & Serializable & scala.Serializable)() -> LongMap$.MODULE$.empty())).update((long)partitionId, (Object)stateInfo);
    }

    @Override
    public Option<UpdateMetadataRequestData.UpdateMetadataPartitionState> getPartitionInfo(String topic, int partitionId) {
        return this.metadataSnapshot().partitionStates().get((Object)topic).flatMap((Function1 & Serializable & scala.Serializable)x$9 -> x$9.get((long)partitionId));
    }

    @Override
    public Option<Object> numPartitions(String topic) {
        return this.metadataSnapshot().partitionStates().get((Object)topic).map((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToInteger((int)x$10.size()));
    }

    @Override
    public Option<Node> getPartitionLeaderEndpoint(String topic, int partitionId, ListenerName listenerName) {
        MetadataSnapshot snapshot = this.metadataSnapshot();
        return snapshot.partitionStates().get((Object)topic).flatMap((Function1 & Serializable & scala.Serializable)x$11 -> x$11.get((long)partitionId)).map((Function1 & Serializable & scala.Serializable)partitionInfo -> {
            int leaderId = partitionInfo.leader();
            Option option = snapshot.aliveNodes().get((long)leaderId);
            if (option instanceof Some) {
                return (Node)((Map)((Some)option).value()).getOrElse((Object)listenerName, (Function0 & Serializable & scala.Serializable)() -> Node.noNode());
            }
            if (None$.MODULE$.equals(option)) {
                return Node.noNode();
            }
            throw new MatchError((Object)option);
        });
    }

    @Override
    public scala.collection.immutable.Map<Object, Node> getPartitionReplicaEndpoints(TopicPartition tp, ListenerName listenerName) {
        MetadataSnapshot snapshot = this.metadataSnapshot();
        return (scala.collection.immutable.Map)snapshot.partitionStates().get((Object)tp.topic()).flatMap((Function1 & Serializable & scala.Serializable)x$12 -> x$12.get((long)tp.partition())).map((Function1 & Serializable & scala.Serializable)partitionInfo -> {
            java.util.List replicaIds = partitionInfo.replicas();
            return (scala.collection.immutable.Map)((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(replicaIds).asScala()).map((Function1 & Serializable & scala.Serializable)replicaId -> {
                Node node;
                Object object = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)replicaId));
                Option option = snapshot.aliveBrokers().get(replicaId.longValue());
                if (option instanceof Some) {
                    node = (Node)((Broker)((Some)option).value()).getNode(listenerName).getOrElse((Function0 & Serializable & scala.Serializable)() -> Node.noNode());
                } else if (None$.MODULE$.equals(option)) {
                    node = Node.noNode();
                } else {
                    throw new MatchError((Object)option);
                }
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(object, (Object)node);
            }, Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()).filter((Function1 & Serializable & scala.Serializable)pair -> BoxesRunTime.boxToBoolean((boolean)ZkMetadataCache.$anonfun$getPartitionReplicaEndpoints$5(pair)));
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Map().empty());
    }

    @Override
    public Option<CachedControllerId> getControllerId() {
        return this.metadataSnapshot().controllerId();
    }

    @Override
    public Option<Object> getRandomAliveBrokerId() {
        List aliveBrokers = this.metadataSnapshot().aliveBrokers().values().toList();
        return new Some((Object)BoxesRunTime.boxToInteger((int)((Broker)aliveBrokers.apply(ThreadLocalRandom.current().nextInt(aliveBrokers.size()))).id()));
    }

    @Override
    public Cluster getClusterMetadata(String clusterId, ListenerName listenerName) {
        MetadataSnapshot snapshot = this.metadataSnapshot();
        LongMap nodes = (LongMap)snapshot.aliveNodes().flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 != null) {
                long id = x0$1._1$mcJ$sp();
                Map nodesByListener = (Map)x0$1._2();
                return Option$.MODULE$.option2Iterable(nodesByListener.get((Object)listenerName).map((Function1 & Serializable & scala.Serializable)node -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)id)), node)));
            }
            throw new MatchError(null);
        }, LongMap$.MODULE$.canBuildFrom());
        scala.collection.immutable.Iterable partitions = (scala.collection.immutable.Iterable)((TraversableLike)this.getAllPartitions(snapshot).filter((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)ZkMetadataCache.$anonfun$getClusterMetadata$6(x0$2)))).map((Function1 & Serializable & scala.Serializable)x0$3 -> {
            if (x0$3 != null) {
                TopicPartition tp = (TopicPartition)x0$3._1();
                UpdateMetadataRequestData.UpdateMetadataPartitionState state = (UpdateMetadataRequestData.UpdateMetadataPartitionState)x0$3._2();
                return new PartitionInfo(tp.topic(), tp.partition(), ZkMetadataCache.node$1(Predef$.MODULE$.int2Integer(state.leader()), nodes), (Node[])((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(state.replicas()).asScala()).map((Function1 & Serializable & scala.Serializable)id -> ZkMetadataCache.node$1(id, nodes), Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Node.class)), (Node[])((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(state.isr()).asScala()).map((Function1 & Serializable & scala.Serializable)id -> ZkMetadataCache.node$1(id, nodes), Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Node.class)), (Node[])((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(state.offlineReplicas()).asScala()).map((Function1 & Serializable & scala.Serializable)id -> ZkMetadataCache.node$1(id, nodes), Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Node.class)));
            }
            throw new MatchError(null);
        }, Iterable$.MODULE$.canBuildFrom());
        java.util.Set unauthorizedTopics = Collections.emptySet();
        java.util.Set internalTopics = (java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)this.getAllTopics(snapshot).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ZkMetadataCache.$anonfun$getClusterMetadata$11(x$1)))).asJava();
        return new Cluster(clusterId, (Collection)CollectionConverters$.MODULE$.bufferAsJavaListConverter(nodes.values().toBuffer()).asJava(), (Collection)CollectionConverters$.MODULE$.bufferAsJavaListConverter(partitions.toBuffer()).asJava(), unauthorizedTopics, internalTopics, (Node)this.controllerId$1(snapshot, listenerName).orNull(Predef$.MODULE$.$conforms()));
    }

    /*
     * WARNING - void declaration
     */
    public Seq<TopicPartition> updateMetadata(int correlationId, UpdateMetadataRequest updateMetadataRequest) {
        ArrayBuffer arrayBuffer;
        void inWriteLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.partitionMetadataLock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inWriteLock_inLock_lock = inWriteLock_lock.writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            arrayBuffer = ZkMetadataCache.$anonfun$updateMetadata$1(this, updateMetadataRequest, correlationId);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
        return arrayBuffer;
    }

    @Override
    public boolean contains(String topic) {
        return this.metadataSnapshot().partitionStates().contains((Object)topic);
    }

    @Override
    public boolean contains(TopicPartition tp) {
        return this.getPartitionInfo(tp.topic(), tp.partition()).isDefined();
    }

    private boolean removePartitionInfo(AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>> partitionStates, scala.collection.mutable.Map<String, Uuid> topicIds, String topic, int partitionId) {
        return partitionStates.get((Object)topic).exists((Function1 & Serializable & scala.Serializable)infos -> BoxesRunTime.boxToBoolean((boolean)ZkMetadataCache.$anonfun$removePartitionInfo$1(partitionId, partitionStates, topic, topicIds, infos)));
    }

    @Override
    public MetadataVersion metadataVersion() {
        return this.metadataVersion;
    }

    @Override
    public Features features() {
        Option<Features> option = this._features();
        if (option instanceof Some) {
            return (Features)((Some)option).value();
        }
        if (None$.MODULE$.equals(option)) {
            return new Features(this.metadataVersion, Collections.emptyMap(), -1L, false);
        }
        throw new MatchError(option);
    }

    /*
     * WARNING - void declaration
     */
    public void updateFeaturesOrThrow(scala.collection.immutable.Map<String, Object> latestFeatures, long latestEpoch) {
        void inLock_lock;
        Features latest = new Features(this.metadataVersion, (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)latestFeatures.map((Function1 & Serializable & scala.Serializable)kv -> new Tuple2(kv._1(), (Object)((Short)kv._2())), scala.collection.immutable.Map$.MODULE$.canBuildFrom())).asJava(), latestEpoch, false);
        Option<Features> existing = this._features();
        if (existing.isDefined() && ((Features)existing.get()).finalizedFeaturesEpoch() > latest.finalizedFeaturesEpoch()) {
            String errorMsg = new StringBuilder(99).append("FinalizedFeatureCache update failed due to invalid epoch in new ").append(latest).append(".").append(" The existing cache contents are ").append(existing).append(".").toString();
            throw new FeatureCacheUpdateException(errorMsg);
        }
        if (this.brokerFeatures.incompatibleFeatures((scala.collection.immutable.Map<String, Object>)((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(latest.finalizedFeatures()).asScala()).map((Function1 & Serializable & scala.Serializable)kv -> new Tuple2(kv._1(), (Object)BoxesRunTime.boxToShort((short)Predef$.MODULE$.Short2short((Short)kv._2()))), Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).nonEmpty()) {
            String errorMsg = new StringBuilder(129).append("FinalizedFeatureCache update failed since feature compatibility").append(" checks failed! Supported ").append(this.brokerFeatures.supportedFeatures()).append(" has incompatibilities").append(" with the latest ").append(latest).append(".").toString();
            throw new FeatureCacheUpdateException(errorMsg);
        }
        String logMsg = new StringBuilder(40).append("Updated cache from existing ").append(existing).append(" to latest ").append(latest).append(".").toString();
        ReentrantLock reentrantLock = this.featureLock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        inLock_lock.lock();
        try {
            ZkMetadataCache.$anonfun$updateFeaturesOrThrow$3(this, latest);
        }
        finally {
            inLock_lock.unlock();
        }
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> logMsg);
    }

    /*
     * WARNING - void declaration
     */
    public void clearFeatures() {
        void inLock_lock;
        ReentrantLock reentrantLock = this.featureLock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        inLock_lock.lock();
        try {
            ZkMetadataCache.$anonfun$clearFeatures$1(this);
        }
        finally {
            inLock_lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void waitUntilFeatureEpochOrThrow(long minExpectedEpoch, long timeoutMs) {
        void inLock_lock;
        if (minExpectedEpoch < 0L) {
            throw new IllegalArgumentException(new StringBuilder(50).append("Expected minExpectedEpoch >= 0, but ").append(minExpectedEpoch).append(" was provided.").toString());
        }
        if (timeoutMs < 0L) {
            throw new IllegalArgumentException(new StringBuilder(43).append("Expected timeoutMs >= 0, but ").append(timeoutMs).append(" was provided.").toString());
        }
        long waitEndTimeNanos = System.nanoTime() + timeoutMs * 1000000L;
        ReentrantLock reentrantLock = this.featureLock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        inLock_lock.lock();
        try {
            ZkMetadataCache.$anonfun$waitUntilFeatureEpochOrThrow$1(this, minExpectedEpoch, waitEndTimeNanos, timeoutMs);
        }
        finally {
            inLock_lock.unlock();
        }
    }

    @Override
    public Option<Features> getFeatureOption() {
        return this._features();
    }

    public static final /* synthetic */ boolean $anonfun$getAliveBrokerNode$1(CachedControllerId x$5) {
        return x$5 instanceof KRaftCachedControllerId;
    }

    public static final /* synthetic */ boolean $anonfun$getAliveBrokerNode$2(int x1$1, CachedControllerId x$6) {
        return x$6.id() == x1$1;
    }

    public static final /* synthetic */ boolean $anonfun$getPartitionReplicaEndpoints$5(Tuple2 pair) {
        if (pair != null) {
            return !((Node)pair._2()).isEmpty();
        }
        throw new MatchError(null);
    }

    private static final Node node$1(Integer id, LongMap nodes$1) {
        return (Node)nodes$1.getOrElse((long)Predef$.MODULE$.Integer2int(id), (Function0 & Serializable & scala.Serializable)() -> new Node(Predef$.MODULE$.Integer2int(id), "", -1));
    }

    private final Option controllerId$1(MetadataSnapshot snapshot, ListenerName listenerName$10) {
        return snapshot.controllerId().flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 instanceof ZkCachedControllerId) {
                int id = ((ZkCachedControllerId)x0$1).id();
                return this.getAliveBrokerNode(id, listenerName$10);
            }
            if (x0$1 instanceof KRaftCachedControllerId) {
                return this.getRandomAliveBrokerId().flatMap((Function1 & Serializable & scala.Serializable)x$13 -> this.getAliveBrokerNode(BoxesRunTime.unboxToInt((Object)x$13), listenerName$10));
            }
            throw new MatchError(x0$1);
        });
    }

    public static final /* synthetic */ boolean $anonfun$getClusterMetadata$6(Tuple2 x0$2) {
        if (x0$2 != null) {
            return ((UpdateMetadataRequestData.UpdateMetadataPartitionState)x0$2._2()).leader() != LeaderAndIsr$.MODULE$.LeaderDuringDelete();
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$getClusterMetadata$11(String x$1) {
        return Topic.isInternal((String)x$1);
    }

    public static final /* synthetic */ boolean $anonfun$updateMetadata$8(Set listeners$1, Map x$14) {
        Set set = x$14.keySet();
        return !(set != null ? !set.equals(listeners$1) : listeners$1 != null);
    }

    public static final /* synthetic */ void $anonfun$updateMetadata$7(ZkMetadataCache $this, LongMap aliveNodes$1, Map listenerMap) {
        Set listeners = listenerMap.keySet();
        if (!aliveNodes$1.values().forall((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)ZkMetadataCache.$anonfun$updateMetadata$8(listeners, x$14)))) {
            $this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Listeners are not identical across brokers: ").append(aliveNodes$1).toString());
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$updateMetadata$11(Tuple2 x0$1) {
        if (x0$1 != null) {
            Uuid uuid = (Uuid)x0$1._2();
            Uuid uuid2 = Uuid.ZERO_UUID;
            return uuid == null ? uuid2 != null : !uuid.equals(uuid2);
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$updateMetadata$13(AnyRefMap partitionStates$1, String topic, LongMap oldPartitionStates) {
        LongMap copy = new LongMap(oldPartitionStates.size());
        copy.$plus$plus$eq((TraversableOnce)oldPartitionStates);
        partitionStates$1.update((Object)topic, (Object)copy);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ ArrayBuffer $anonfun$updateMetadata$1(ZkMetadataCache $this, UpdateMetadataRequest updateMetadataRequest$1, int correlationId$1) {
        void var12_12;
        void var11_11;
        if (updateMetadataRequest$1.isKRaftController()) {
            AbstractControlRequest.Type type = updateMetadataRequest$1.updateType();
            AbstractControlRequest.Type type2 = AbstractControlRequest.Type.FULL;
            if (!(type != null ? !type.equals(type2) : type2 != null)) {
                if (!$this.zkMigrationEnabled) {
                    $this.stateChangeLogger().error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(144).append("Received UpdateMetadataRequest with Type=FULL (2), but ZK migrations ").append("are not enabled on this broker. Not treating this as a full metadata update").toString());
                } else {
                    Seq<Uuid> deletedTopicIds = ZkMetadataCache$.MODULE$.maybeInjectDeletedPartitionsFromFullMetadataRequest($this.metadataSnapshot(), updateMetadataRequest$1.controllerEpoch(), updateMetadataRequest$1.topicStates());
                    if (deletedTopicIds.isEmpty()) {
                        $this.stateChangeLogger().trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(87).append("Received UpdateMetadataRequest with Type=FULL (2), ").append("but no deleted topics were detected.").toString());
                    } else {
                        $this.stateChangeLogger().debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(80).append("Received UpdateMetadataRequest with Type=FULL (2), ").append("found ").append(deletedTopicIds.size()).append(" deleted topic ID(s): ").append(deletedTopicIds).append(".").toString());
                    }
                }
            }
        }
        LongMap aliveBrokers = new LongMap($this.metadataSnapshot().aliveBrokers().size());
        LongMap aliveNodes = new LongMap($this.metadataSnapshot().aliveNodes().size());
        int n = updateMetadataRequest$1.controllerId();
        switch (n) {
            default: 
        }
        None$ controllerIdOpt = n < 0 ? None$.MODULE$ : (updateMetadataRequest$1.isKRaftController() ? new Some((Object)new KRaftCachedControllerId(n)) : new Some((Object)new ZkCachedControllerId(n)));
        updateMetadataRequest$1.liveBrokers().forEach(broker -> {
            HashMap nodes = new HashMap();
            ArrayBuffer endPoints = new ArrayBuffer();
            broker.endpoints().forEach(ep -> {
                ListenerName listenerName = new ListenerName(ep.listener());
                endPoints.$plus$eq((Object)new EndPoint(ep.host(), ep.port(), listenerName, SecurityProtocol.forId((short)ep.securityProtocol())));
                nodes.put(listenerName, new Node(broker.id(), ep.host(), ep.port(), broker.rack()));
            });
            aliveBrokers.update((long)broker.id(), (Object)Broker$.MODULE$.apply(broker.id(), (Seq<EndPoint>)endPoints, (Option<String>)Option$.MODULE$.apply((Object)broker.rack())));
            aliveNodes.update((long)broker.id(), CollectionConverters$.MODULE$.mapAsScalaMapConverter(nodes).asScala());
        });
        aliveNodes.get((long)$this.brokerId).foreach((Function1 & Serializable & scala.Serializable)listenerMap -> {
            ZkMetadataCache.$anonfun$updateMetadata$7($this, aliveNodes, listenerMap);
            return BoxedUnit.UNIT;
        });
        scala.collection.mutable.Map topicIds = Map$.MODULE$.empty();
        topicIds.$plus$plus$eq($this.metadataSnapshot().topicIds());
        Tuple2 tuple2 = ((TraversableLike)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(updateMetadataRequest$1.topicStates()).asScala()).map((Function1 & Serializable & scala.Serializable)topicState -> new Tuple2((Object)topicState.topicName(), (Object)topicState.topicId()), Buffer$.MODULE$.canBuildFrom())).partition((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ZkMetadataCache.$anonfun$updateMetadata$11(x0$1)));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Buffer newTopicIds = (Buffer)tuple2._1();
        Buffer newZeroIds = (Buffer)tuple2._2();
        void newTopicIds2 = var11_11;
        var12_12.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            if (x0$2 != null) {
                String zeroIdTopic = (String)x0$2._1();
                return topicIds.remove((Object)zeroIdTopic);
            }
            throw new MatchError(null);
        });
        topicIds.$plus$plus$eq((TraversableOnce)newTopicIds2.toMap(Predef$.MODULE$.$conforms()));
        ArrayBuffer deletedPartitions = new ArrayBuffer();
        if (!updateMetadataRequest$1.partitionStates().iterator().hasNext()) {
            $this.metadataSnapshot_$eq(new MetadataSnapshot($this.metadataSnapshot().partitionStates(), (scala.collection.immutable.Map<String, Uuid>)topicIds.toMap(Predef$.MODULE$.$conforms()), (Option<CachedControllerId>)controllerIdOpt, (LongMap<Broker>)aliveBrokers, (LongMap<Map<ListenerName, Node>>)aliveNodes));
        } else {
            void forKeyValue$extension_f;
            void forKeyValue$extension_$this;
            AnyRefMap partitionStates = new AnyRefMap($this.metadataSnapshot().partitionStates().size());
            Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(topic, oldPartitionStates) -> {
                ZkMetadataCache.$anonfun$updateMetadata$13(partitionStates, topic, oldPartitionStates);
                return BoxedUnit.UNIT;
            };
            Map<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>> map = Implicits$.MODULE$.MapExtensionMethods($this.metadataSnapshot().partitionStates());
            if (Implicits$MapExtensionMethods$.MODULE$ == null) {
                throw null;
            }
            MapExtensionMethods$.MODULE$.foreachEntry$extension(package$.MODULE$.toMapExtensionMethods((Map)forKeyValue$extension_$this), (arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f, arg_0, arg_1));
            boolean traceEnabled = $this.stateChangeLogger().isTraceEnabled();
            int controllerId = updateMetadataRequest$1.controllerId();
            int controllerEpoch = updateMetadataRequest$1.controllerEpoch();
            Iterable newStates = (Iterable)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(updateMetadataRequest$1.partitionStates()).asScala();
            newStates.foreach((Function1 & Serializable & scala.Serializable)state -> {
                TopicPartition tp = new TopicPartition(state.topicName(), state.partitionIndex());
                if (state.leader() == LeaderAndIsr$.MODULE$.LeaderDuringDelete()) {
                    $this.removePartitionInfo((AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>>)partitionStates, (scala.collection.mutable.Map<String, Uuid>)topicIds, tp.topic(), tp.partition());
                    if (traceEnabled) {
                        $this.stateChangeLogger().trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(124).append("Deleted partition ").append(tp).append(" from metadata cache in response to UpdateMetadata ").append("request sent by controller ").append(controllerId).append(" epoch ").append(controllerEpoch).append(" with correlation id ").append(correlationId$1).toString());
                    }
                    return deletedPartitions.$plus$eq((Object)tp);
                }
                $this.addOrUpdatePartitionInfo((AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>>)partitionStates, tp.topic(), tp.partition(), (UpdateMetadataRequestData.UpdateMetadataPartitionState)state);
                if (traceEnabled) {
                    $this.stateChangeLogger().trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(120).append("Cached leader info ").append(state).append(" for partition ").append(tp).append(" in response to ").append("UpdateMetadata request sent by controller ").append(controllerId).append(" epoch ").append(controllerEpoch).append(" with correlation id ").append(correlationId$1).toString());
                    return BoxedUnit.UNIT;
                }
                return BoxedUnit.UNIT;
            });
            int cachedPartitionsCount = newStates.size() - deletedPartitions.size();
            $this.stateChangeLogger().info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(145).append("Add ").append(cachedPartitionsCount).append(" partitions and deleted ").append(deletedPartitions.size()).append(" partitions from metadata cache ").append("in response to UpdateMetadata request sent by controller ").append(controllerId).append(" epoch ").append(controllerEpoch).append(" with correlation id ").append(correlationId$1).toString());
            $this.metadataSnapshot_$eq(new MetadataSnapshot((AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>>)partitionStates, (scala.collection.immutable.Map<String, Uuid>)topicIds.toMap(Predef$.MODULE$.$conforms()), (Option<CachedControllerId>)controllerIdOpt, (LongMap<Broker>)aliveBrokers, (LongMap<Map<ListenerName, Node>>)aliveNodes));
        }
        return deletedPartitions;
    }

    public static final /* synthetic */ boolean $anonfun$removePartitionInfo$1(int partitionId$3, AnyRefMap partitionStates$2, String topic$4, scala.collection.mutable.Map topicIds$2, LongMap infos) {
        infos.remove((Object)BoxesRunTime.boxToLong((long)partitionId$3));
        if (infos.isEmpty()) {
            partitionStates$2.remove((Object)topic$4);
            topicIds$2.remove((Object)topic$4);
        }
        return true;
    }

    public static final /* synthetic */ void $anonfun$updateFeaturesOrThrow$3(ZkMetadataCache $this, Features latest$1) {
        $this._features_$eq((Option<Features>)new Some((Object)latest$1));
        $this.featureCond().signalAll();
    }

    public static final /* synthetic */ void $anonfun$clearFeatures$1(ZkMetadataCache $this) {
        $this._features_$eq((Option<Features>)None$.MODULE$);
        $this.featureCond().signalAll();
    }

    public static final /* synthetic */ void $anonfun$waitUntilFeatureEpochOrThrow$1(ZkMetadataCache $this, long minExpectedEpoch$1, long waitEndTimeNanos$1, long timeoutMs$1) {
        while (!$this._features().isDefined() || ((Features)$this._features().get()).finalizedFeaturesEpoch() < minExpectedEpoch$1) {
            long nowNanos = System.nanoTime();
            if (nowNanos > waitEndTimeNanos$1) {
                throw new TimeoutException(new StringBuilder(81).append("Timed out after waiting for ").append(timeoutMs$1).append("ms for required condition to be met.").append(" Current epoch: ").append($this._features().map((Function1 & Serializable & scala.Serializable)fe -> BoxesRunTime.boxToLong((long)fe.finalizedFeaturesEpoch())).getOrElse((Function0 & Serializable & scala.Serializable)() -> "<none>")).append(".").toString());
            }
            long sleepTimeMs = scala.math.package$.MODULE$.max(1L, (waitEndTimeNanos$1 - nowNanos) / 1000000L);
            $this.featureCond().await(sleepTimeMs, TimeUnit.MILLISECONDS);
        }
    }

    public ZkMetadataCache(int brokerId, MetadataVersion metadataVersion, BrokerFeatures brokerFeatures, Seq<Node> kraftControllerNodes, boolean zkMigrationEnabled) {
        this.brokerId = brokerId;
        this.metadataVersion = metadataVersion;
        this.brokerFeatures = brokerFeatures;
        this.zkMigrationEnabled = zkMigrationEnabled;
        Logging.$init$(this);
        this.partitionMetadataLock = new ReentrantReadWriteLock();
        this.metadataSnapshot = new MetadataSnapshot((AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>>)AnyRefMap$.MODULE$.empty(), (scala.collection.immutable.Map<String, Uuid>)Predef$.MODULE$.Map().empty(), (Option<CachedControllerId>)None$.MODULE$, (LongMap<Broker>)LongMap$.MODULE$.empty(), (LongMap<Map<ListenerName, Node>>)LongMap$.MODULE$.empty());
        this.logIdent_$eq(new StringBuilder(26).append("[MetadataCache brokerId=").append(brokerId).append("] ").toString());
        this.stateChangeLogger = new StateChangeLogger(brokerId, false, (Option<Object>)None$.MODULE$);
        this._features = Option$.MODULE$.empty();
        this.featureLock = new ReentrantLock();
        this.featureCond = this.featureLock().newCondition();
        this.kraftControllerNodeMap = ((TraversableOnce)kraftControllerNodes.map((Function1 & Serializable & scala.Serializable)node -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)node.id())), node), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }
}

