/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.cluster.EndPoint;
import kafka.network.Acceptor$DelayedCloseSocket$;
import kafka.network.ConnectionQuotas;
import kafka.network.ConnectionThrottledException;
import kafka.network.Processor;
import kafka.network.Processor$;
import kafka.network.RequestChannel;
import kafka.network.SocketServer;
import kafka.network.SocketServer$;
import kafka.network.TooManyConnectionsException;
import kafka.security.CredentialProvider;
import kafka.server.ApiVersionManager;
import kafka.server.KafkaConfig;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.KafkaThread;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.metrics.KafkaMetricsGroup;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.PriorityQueue;
import scala.jdk.CollectionConverters$;
import scala.math.Ordered;
import scala.math.Ordering$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.control.ControlThrowable;

@ScalaSignature(bytes="\u0006\u0001\u0011UbAB0a\u0003\u0003\u0011G\r\u0003\u0005w\u0001\t\u0015\r\u0011\"\u0001y\u0011!i\bA!A!\u0002\u0013I\b\u0002\u0003@\u0001\u0005\u000b\u0007I\u0011A@\t\u0015\u00055\u0001A!A!\u0002\u0013\t\t\u0001\u0003\u0006\u0002\u0010\u0001\u0011\t\u0019!C\u0001\u0003#A!\"a\b\u0001\u0005\u0003\u0007I\u0011AA\u0011\u0011)\t\u0019\u0004\u0001B\u0001B\u0003&\u00111\u0003\u0005\u000b\u0003k\u0001!\u0011!Q\u0001\n\u0005]\u0002BCA\u001f\u0001\t\u0015\r\u0011\"\u0001\u0002@!Q\u0011q\t\u0001\u0003\u0002\u0003\u0006I!!\u0011\t\u0015\u0005%\u0003A!A!\u0002\u0013\tY\u0005\u0003\u0006\u0002d\u0001\u0011\t\u0011)A\u0005\u0003KB!\"a\u001b\u0001\u0005\u0003\u0005\u000b\u0011BA7\u0011)\t\u0019\b\u0001B\u0001B\u0003%\u0011Q\u000f\u0005\u000b\u0003\u007f\u0002!\u0011!Q\u0001\n\u0005\u0005\u0005BCAG\u0001\t\u0005\t\u0015!\u0003\u0002\u0010\"Q\u0011Q\u0013\u0001\u0003\u0002\u0003\u0006I!a&\t\u0015\u0005\r\u0006A!A!\u0002\u0013\t)\u000bC\u0004\u0002,\u0002!\t!!,\t\u0013\u0005-\u0007A1A\u0005\n\u00055\u0007\u0002CAn\u0001\u0001\u0006I!a4\t\u0013\u0005u\u0007A1A\u0005\u0002\u0005}\u0007\u0002CA{\u0001\u0001\u0006I!!9\t\u000f\u0005]\bA\"\u0001\u0002z\"9!\u0011\u0003\u0001\u0007\u0002\u0005e\b\"\u0003B\n\u0001\t\u0007I\u0011\u0002B\u000b\u0011!\u0011i\u0002\u0001Q\u0001\n\t]\u0001\"\u0003B\u0010\u0001\t\u0007I\u0011\u0002B\u000b\u0011!\u0011\t\u0003\u0001Q\u0001\n\t]\u0001\"\u0003B\u0012\u0001\t\u0007I\u0011\u0002B\u000b\u0011!\u0011)\u0003\u0001Q\u0001\n\t]\u0001\"\u0003B\u0014\u0001\t\u0007I\u0011\u0002B\u0015\u0011!\u0011Y\u0004\u0001Q\u0001\n\t-\u0002\u0002\u0004B\u001f\u0001\u0001\u0007\t\u0019!C\u0001A\n}\u0002\u0002\u0004B$\u0001\u0001\u0007\t\u0019!C\u0001A\n%\u0003b\u0003B'\u0001\u0001\u0007\t\u0011)Q\u0005\u0005\u0003B!Ba\u0014\u0001\u0005\u0004%\t\u0001\u0019B)\u0011!\u0011\u0019\u0006\u0001Q\u0001\n\u0005]\u0002B\u0003B+\u0001\t\u0007I\u0011\u00011\u0003X!A!q\u000e\u0001!\u0002\u0013\u0011I\u0006C\u0005\u0003r\u0001\u0011\r\u0011\"\u0003\u0003t!A!1\u0012\u0001!\u0002\u0013\u0011)\bC\u0005\u0003\u000e\u0002\u0011\r\u0011\"\u0003\u0003\u0010\"A!q\u0013\u0001!\u0002\u0013\u0011\t\nC\u0005\u0003\u001a\u0002\u0001\r\u0011\"\u0003\u0003R!I!1\u0014\u0001A\u0002\u0013%!Q\u0014\u0005\t\u0005C\u0003\u0001\u0015)\u0003\u00028!Q!1\u0015\u0001C\u0002\u0013\u0005\u0001M!*\t\u0011\rm\u0003\u0001)A\u0005\u0005OC\u0011b!\u0018\u0001\u0001\u0004%Iaa\u0018\t\u0013\r\u0005\u0004\u00011A\u0005\n\r\r\u0004\u0002CB4\u0001\u0001\u0006K!!\u001a\t\u0015\r%\u0004A1A\u0005\u0002\u0001\u001cY\u0007\u0003\u0005\u0004|\u0001\u0001\u000b\u0011BB7\u0011%\u0019i\b\u0001b\u0001\n\u0003\u0019y\b\u0003\u0005\u0004\b\u0002\u0001\u000b\u0011BBA\u0011\u001d\u0019I\t\u0001C\u0001\u0007\u00173qA!-\u0001\u0001\u0002\u0014\u0019\f\u0003\u0006\u0003Zj\u0012)\u001a!C\u0001\u00057D!Ba9;\u0005#\u0005\u000b\u0011\u0002Bo\u0011)\u0011)O\u000fBK\u0002\u0013\u0005!q\u001d\u0005\u000b\u0005_T$\u0011#Q\u0001\n\t%\bbBAVu\u0011\u0005!\u0011\u001f\u0005\b\u0005oTD\u0011\tB}\u0011%\u0011yPOA\u0001\n\u0003\u0019\t\u0001C\u0005\u0004\bi\n\n\u0011\"\u0001\u0004\n!I1q\u0004\u001e\u0012\u0002\u0013\u00051\u0011\u0005\u0005\n\u0007KQ\u0014\u0011!C!\u0007OA\u0011b!\f;\u0003\u0003%\tA!\u0015\t\u0013\r=\"(!A\u0005\u0002\rE\u0002\"CB\u001eu\u0005\u0005I\u0011IB\u001f\u0011%\u00199EOA\u0001\n\u0003\u0019I\u0005C\u0005\u0004Ni\n\t\u0011\"\u0011\u0004P!I1\u0011\u000b\u001e\u0002\u0002\u0013\u000531\u000b\u0005\n\u0007+R\u0014\u0011!C!\u0007/:!b!$\u0001\u0003\u0003E\t\u0001YBH\r)\u0011\t\fAA\u0001\u0012\u0003\u00017\u0011\u0013\u0005\b\u0003WkE\u0011ABP\u0011%\u0019\t&TA\u0001\n\u000b\u001a\u0019\u0006C\u0005\u0004\"6\u000b\t\u0011\"!\u0004$\"I1\u0011V'\u0002\u0002\u0013\u000551\u0016\u0005\t\u0007{\u0003A\u0011\u00011\u0004@\"91Q\u0019\u0001\u0005\u0002\r-\u0005bBBd\u0001\u0011\u000511\u0012\u0005\b\u0007\u0013\u0004A\u0011IBF\u0011\u001d\u0019Y\r\u0001C\u0005\u0007\u001bDqa!7\u0001\t\u0013\u0019Y\tC\u0004\u0004\\\u0002!Ia!8\t\u000f\r-\b\u0001\"\u0005\u0004n\"911\u001f\u0001\u0005\n\r-\u0005bBB{\u0001\u0011%1q\u001f\u0005\b\t\u0007\u0001A\u0011ABF\u0011\u001d!)\u0001\u0001C\u0001\t\u000fAq\u0001\"\u0004\u0001\t\u0003!yA\u0001\u0005BG\u000e,\u0007\u000f^8s\u0015\t\t'-A\u0004oKR<xN]6\u000b\u0003\r\fQa[1gW\u0006\u001cB\u0001A3naB\u0011am[\u0007\u0002O*\u0011\u0001.[\u0001\u0005Y\u0006twMC\u0001k\u0003\u0011Q\u0017M^1\n\u00051<'AB(cU\u0016\u001cG\u000f\u0005\u0002g]&\u0011qn\u001a\u0002\t%Vtg.\u00192mKB\u0011\u0011\u000f^\u0007\u0002e*\u00111OY\u0001\u0006kRLGn]\u0005\u0003kJ\u0014q\u0001T8hO&tw-\u0001\u0007t_\u000e\\W\r^*feZ,'o\u0001\u0001\u0016\u0003e\u0004\"A_>\u000e\u0003\u0001L!\u0001 1\u0003\u0019M{7m[3u'\u0016\u0014h/\u001a:\u0002\u001bM|7m[3u'\u0016\u0014h/\u001a:!\u0003!)g\u000e\u001a)pS:$XCAA\u0001!\u0011\t\u0019!!\u0003\u000e\u0005\u0005\u0015!bAA\u0004E\u000691\r\\;ti\u0016\u0014\u0018\u0002BA\u0006\u0003\u000b\u0011\u0001\"\u00128e!>Lg\u000e^\u0001\nK:$\u0007k\\5oi\u0002\naaY8oM&<WCAA\n!\u0011\t)\"a\u0007\u000e\u0005\u0005]!bAA\rE\u000611/\u001a:wKJLA!!\b\u0002\u0018\tY1*\u00194lC\u000e{gNZ5h\u0003)\u0019wN\u001c4jO~#S-\u001d\u000b\u0005\u0003G\ty\u0003\u0005\u0003\u0002&\u0005-RBAA\u0014\u0015\t\tI#A\u0003tG\u0006d\u0017-\u0003\u0003\u0002.\u0005\u001d\"\u0001B+oSRD\u0011\"!\r\u0007\u0003\u0003\u0005\r!a\u0005\u0002\u0007a$\u0013'A\u0004d_:4\u0017n\u001a\u0011\u0002\r9|G-Z%e!\u0011\t)#!\u000f\n\t\u0005m\u0012q\u0005\u0002\u0004\u0013:$\u0018\u0001E2p]:,7\r^5p]F+x\u000e^1t+\t\t\t\u0005E\u0002{\u0003\u0007J1!!\u0012a\u0005A\u0019uN\u001c8fGRLwN\\)v_R\f7/A\td_:tWm\u0019;j_:\fVo\u001c;bg\u0002\nA\u0001^5nKB!\u0011QJA0\u001b\t\tyEC\u0002t\u0003#RA!a\u0015\u0002V\u000511m\\7n_:T1aYA,\u0015\u0011\tI&a\u0017\u0002\r\u0005\u0004\u0018m\u00195f\u0015\t\ti&A\u0002pe\u001eLA!!\u0019\u0002P\t!A+[7f\u0003QI7\u000f\u0015:jm&dWmZ3e\u0019&\u001cH/\u001a8feB!\u0011QEA4\u0013\u0011\tI'a\n\u0003\u000f\t{w\u000e\\3b]\u0006q!/Z9vKN$8\t[1o]\u0016d\u0007c\u0001>\u0002p%\u0019\u0011\u0011\u000f1\u0003\u001dI+\u0017/^3ti\u000eC\u0017M\u001c8fY\u00069Q.\u001a;sS\u000e\u001c\b\u0003BA<\u0003wj!!!\u001f\u000b\t\u0005M\u0014\u0011K\u0005\u0005\u0003{\nIHA\u0004NKR\u0014\u0018nY:\u0002%\r\u0014X\rZ3oi&\fG\u000e\u0015:pm&$WM\u001d\t\u0005\u0003\u0007\u000bI)\u0004\u0002\u0002\u0006*\u0019\u0011q\u00112\u0002\u0011M,7-\u001e:jifLA!a#\u0002\u0006\n\u00112I]3eK:$\u0018.\u00197Qe>4\u0018\u000eZ3s\u0003)awnZ\"p]R,\u0007\u0010\u001e\t\u0005\u0003\u001b\n\t*\u0003\u0003\u0002\u0014\u0006=#A\u0003'pO\u000e{g\u000e^3yi\u0006QQ.Z7pef\u0004vn\u001c7\u0011\t\u0005e\u0015qT\u0007\u0003\u00037SA!!(\u0002R\u00051Q.Z7pefLA!!)\u0002\u001c\nQQ*Z7pef\u0004vn\u001c7\u0002#\u0005\u0004\u0018NV3sg&|g.T1oC\u001e,'\u000f\u0005\u0003\u0002\u0016\u0005\u001d\u0016\u0002BAU\u0003/\u0011\u0011#\u00119j-\u0016\u00148/[8o\u001b\u0006t\u0017mZ3s\u0003\u0019a\u0014N\\5u}Qa\u0012qVAY\u0003g\u000b),a.\u0002:\u0006m\u0016QXA`\u0003\u0003\f\u0019-!2\u0002H\u0006%\u0007C\u0001>\u0001\u0011\u001518\u00031\u0001z\u0011\u0019q8\u00031\u0001\u0002\u0002!9\u0011qB\nA\u0002\u0005M\u0001bBA\u001b'\u0001\u0007\u0011q\u0007\u0005\b\u0003{\u0019\u0002\u0019AA!\u0011\u001d\tIe\u0005a\u0001\u0003\u0017Bq!a\u0019\u0014\u0001\u0004\t)\u0007C\u0004\u0002lM\u0001\r!!\u001c\t\u000f\u0005M4\u00031\u0001\u0002v!9\u0011qP\nA\u0002\u0005\u0005\u0005bBAG'\u0001\u0007\u0011q\u0012\u0005\b\u0003+\u001b\u0002\u0019AAL\u0011\u001d\t\u0019k\u0005a\u0001\u0003K\u000bA\"\\3ue&\u001c7o\u0012:pkB,\"!a4\u0011\t\u0005E\u0017q[\u0007\u0003\u0003'TA!a\u001d\u0002V*!\u0011\u0011DA+\u0013\u0011\tI.a5\u0003#-\u000bgm[1NKR\u0014\u0018nY:He>,\b/A\u0007nKR\u0014\u0018nY:He>,\b\u000fI\u0001\ng\"|W\u000f\u001c3Sk:,\"!!9\u0011\t\u0005\r\u0018\u0011_\u0007\u0003\u0003KTA!a:\u0002j\u00061\u0011\r^8nS\u000eTA!a;\u0002n\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0007\u0005=\u0018.\u0001\u0003vi&d\u0017\u0002BAz\u0003K\u0014Q\"\u0011;p[&\u001c'i\\8mK\u0006t\u0017AC:i_VdGMU;oA\u0005aQ.\u001a;sS\u000e\u0004&/\u001a4jqR\u0011\u00111 \t\u0005\u0003{\u0014YA\u0004\u0003\u0002\u0000\n\u001d\u0001\u0003\u0002B\u0001\u0003Oi!Aa\u0001\u000b\u0007\t\u0015q/\u0001\u0004=e>|GOP\u0005\u0005\u0005\u0013\t9#\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0005\u001b\u0011yA\u0001\u0004TiJLgn\u001a\u0006\u0005\u0005\u0013\t9#\u0001\u0007uQJ,\u0017\r\u001a)sK\u001aL\u00070\u0001\btK:$')\u001e4gKJ\u001c\u0016N_3\u0016\u0005\t]\u0001c\u00014\u0003\u001a%\u0019!1D4\u0003\u000f%sG/Z4fe\u0006y1/\u001a8e\u0005V4g-\u001a:TSj,\u0007%\u0001\bsK\u000e4()\u001e4gKJ\u001c\u0016N_3\u0002\u001fI,7M\u001e\"vM\u001a,'oU5{K\u0002\n\u0011\u0003\\5ti\u0016t')Y2lY><7+\u001b>f\u0003Ia\u0017n\u001d;f]\n\u000b7m\u001b7pONK'0\u001a\u0011\u0002\u00179LwnU3mK\u000e$xN]\u000b\u0003\u0005W\u0001BA!\f\u000385\u0011!q\u0006\u0006\u0005\u0005c\u0011\u0019$\u0001\u0005dQ\u0006tg.\u001a7t\u0015\r\u0011)$[\u0001\u0004]&|\u0017\u0002\u0002B\u001d\u0005_\u0011\u0001bU3mK\u000e$xN]\u0001\r]&|7+\u001a7fGR|'\u000fI\u0001\u000eg\u0016\u0014h/\u001a:DQ\u0006tg.\u001a7\u0016\u0005\t\u0005\u0003\u0003\u0002B\u0017\u0005\u0007JAA!\u0012\u00030\t\u00192+\u001a:wKJ\u001cvnY6fi\u000eC\u0017M\u001c8fY\u0006\t2/\u001a:wKJ\u001c\u0005.\u00198oK2|F%Z9\u0015\t\u0005\r\"1\n\u0005\n\u0003c\u0019\u0013\u0011!a\u0001\u0005\u0003\nab]3sm\u0016\u00148\t[1o]\u0016d\u0007%A\u0005m_\u000e\fG\u000eU8siV\u0011\u0011qG\u0001\u000bY>\u001c\u0017\r\u001c)peR\u0004\u0013A\u00039s_\u000e,7o]8sgV\u0011!\u0011\f\t\u0007\u00057\u0012)G!\u001b\u000e\u0005\tu#\u0002\u0002B0\u0005C\nq!\\;uC\ndWM\u0003\u0003\u0003d\u0005\u001d\u0012AC2pY2,7\r^5p]&!!q\rB/\u0005-\t%O]1z\u0005V4g-\u001a:\u0011\u0007i\u0014Y'C\u0002\u0003n\u0001\u0014\u0011\u0002\u0015:pG\u0016\u001c8o\u001c:\u0002\u0017A\u0014xnY3tg>\u00148\u000fI\u0001\u001eE2|7m[3e!\u0016\u00148-\u001a8u\u001b\u0016$XM]'fiJL7MT1nKV\u0011!Q\u000f\t\u0005\u0005o\u00129)\u0004\u0002\u0003z)!!1\u0010B?\u0003\u0011\u0019wN]3\u000b\t\u0005M$q\u0010\u0006\u0005\u0005\u0003\u0013\u0019)\u0001\u0004zC6lWM\u001d\u0006\u0003\u0005\u000b\u000b1aY8n\u0013\u0011\u0011II!\u001f\u0003\u00155+GO]5d\u001d\u0006lW-\u0001\u0010cY>\u001c7.\u001a3QKJ\u001cWM\u001c;NKR,'/T3ue&\u001cg*Y7fA\u0005\u0019\"\r\\8dW\u0016$\u0007+\u001a:dK:$X*\u001a;feV\u0011!\u0011\u0013\t\u0005\u0005o\u0012\u0019*\u0003\u0003\u0003\u0016\ne$!B'fi\u0016\u0014\u0018\u0001\u00062m_\u000e\\W\r\u001a)fe\u000e,g\u000e^'fi\u0016\u0014\b%A\u000bdkJ\u0014XM\u001c;Qe>\u001cWm]:pe&sG-\u001a=\u00023\r,(O]3oiB\u0013xnY3tg>\u0014\u0018J\u001c3fq~#S-\u001d\u000b\u0005\u0003G\u0011y\nC\u0005\u000229\n\t\u00111\u0001\u00028\u000512-\u001e:sK:$\bK]8dKN\u001cxN]%oI\u0016D\b%\u0001\tuQJ|G\u000f\u001e7fIN{7m[3ugV\u0011!q\u0015\t\u0007\u00057\u0012IK!,\n\t\t-&Q\f\u0002\u000e!JLwN]5usF+X-^3\u0011\u0007\t=&(D\u0001\u0001\u0005I!U\r\\1zK\u0012\u001cEn\\:f'>\u001c7.\u001a;\u0014\u0013i\u0012)La/\u0003N\nM\u0007\u0003BA\u0013\u0005oKAA!/\u0002(\t1\u0011I\\=SK\u001a\u0004bA!0\u0003H\n5f\u0002\u0002B`\u0005\u0007tAA!\u0001\u0003B&\u0011\u0011\u0011F\u0005\u0005\u0005\u000b\f9#A\u0004qC\u000e\\\u0017mZ3\n\t\t%'1\u001a\u0002\b\u001fJ$WM]3e\u0015\u0011\u0011)-a\n\u0011\t\u0005\u0015\"qZ\u0005\u0005\u0005#\f9CA\u0004Qe>$Wo\u0019;\u0011\t\u0005\u0015\"Q[\u0005\u0005\u0005/\f9C\u0001\u0007TKJL\u0017\r\\5{C\ndW-\u0001\u0004t_\u000e\\W\r^\u000b\u0003\u0005;\u0004BA!\f\u0003`&!!\u0011\u001dB\u0018\u00055\u0019vnY6fi\u000eC\u0017M\u001c8fY\u000691o\\2lKR\u0004\u0013!E3oIRC'o\u001c;uY\u0016$\u0016.\\3NgV\u0011!\u0011\u001e\t\u0005\u0003K\u0011Y/\u0003\u0003\u0003n\u0006\u001d\"\u0001\u0002'p]\u001e\f!#\u001a8e)\"\u0014x\u000e\u001e;mKRKW.Z'tAQ1!Q\u0016Bz\u0005kDqA!7@\u0001\u0004\u0011i\u000eC\u0004\u0003f~\u0002\rA!;\u0002\u000f\r|W\u000e]1sKR!\u0011q\u0007B~\u0011\u001d\u0011i\u0010\u0011a\u0001\u0005[\u000bA\u0001\u001e5bi\u0006!1m\u001c9z)\u0019\u0011ika\u0001\u0004\u0006!I!\u0011\\!\u0011\u0002\u0003\u0007!Q\u001c\u0005\n\u0005K\f\u0005\u0013!a\u0001\u0005S\fabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0004\f)\"!Q\\B\u0007W\t\u0019y\u0001\u0005\u0003\u0004\u0012\rmQBAB\n\u0015\u0011\u0019)ba\u0006\u0002\u0013Ut7\r[3dW\u0016$'\u0002BB\r\u0003O\t!\"\u00198o_R\fG/[8o\u0013\u0011\u0019iba\u0005\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\r\r\"\u0006\u0002Bu\u0007\u001b\tQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAB\u0015!\r171F\u0005\u0004\u0005\u001b9\u0017\u0001\u00049s_\u0012,8\r^!sSRL\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0007g\u0019I\u0004\u0005\u0003\u0002&\rU\u0012\u0002BB\u001c\u0003O\u00111!\u00118z\u0011%\t\tDRA\u0001\u0002\u0004\t9$A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\u0019y\u0004\u0005\u0004\u0004B\r\r31G\u0007\u0003\u0005CJAa!\u0012\u0003b\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\t)ga\u0013\t\u0013\u0005E\u0002*!AA\u0002\rM\u0012\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\u0005]\u0012\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\r%\u0012AB3rk\u0006d7\u000f\u0006\u0003\u0002f\re\u0003\"CA\u0019\u0017\u0006\u0005\t\u0019AB\u001a\u0003E!\bN]8ui2,GmU8dW\u0016$8\u000fI\u0001\bgR\f'\u000f^3e+\t\t)'A\u0006ti\u0006\u0014H/\u001a3`I\u0015\fH\u0003BA\u0012\u0007KB\u0011\"!\r4\u0003\u0003\u0005\r!!\u001a\u0002\u0011M$\u0018M\u001d;fI\u0002\nQb\u001d;beR,GMR;ukJ,WCAB7!\u0019\u0019yg!\u001d\u0004v5\u0011\u0011\u0011^\u0005\u0005\u0007g\nIOA\tD_6\u0004H.\u001a;bE2,g)\u001e;ve\u0016\u00042AZB<\u0013\r\u0019Ih\u001a\u0002\u0005->LG-\u0001\bti\u0006\u0014H/\u001a3GkR,(/\u001a\u0011\u0002\rQD'/Z1e+\t\u0019\t\t\u0005\u0003\u0002N\r\r\u0015\u0002BBC\u0003\u001f\u00121bS1gW\u0006$\u0006N]3bI\u00069A\u000f\u001b:fC\u0012\u0004\u0013!B:uCJ$HCAA\u0012\u0003I!U\r\\1zK\u0012\u001cEn\\:f'>\u001c7.\u001a;\u0011\u0007\t=VjE\u0003N\u0007'\u0013\u0019\u000e\u0005\u0006\u0004\u0016\u000em%Q\u001cBu\u0005[k!aa&\u000b\t\re\u0015qE\u0001\beVtG/[7f\u0013\u0011\u0019ija&\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t'\u0007\u0006\u0002\u0004\u0010\u0006)\u0011\r\u001d9msR1!QVBS\u0007OCqA!7Q\u0001\u0004\u0011i\u000eC\u0004\u0003fB\u0003\rA!;\u0002\u000fUt\u0017\r\u001d9msR!1QVB]!\u0019\t)ca,\u00044&!1\u0011WA\u0014\u0005\u0019y\u0005\u000f^5p]BA\u0011QEB[\u0005;\u0014I/\u0003\u0003\u00048\u0006\u001d\"A\u0002+va2,'\u0007C\u0005\u0004<F\u000b\t\u00111\u0001\u0003.\u0006\u0019\u0001\u0010\n\u0019\u0002!I,Wn\u001c<f!J|7-Z:t_J\u001cH\u0003BA\u0012\u0007\u0003Dqaa1S\u0001\u0004\t9$A\u0006sK6|g/Z\"pk:$\u0018!\u00042fO&t7\u000b[;uI><h.A\u0003dY>\u001cX-A\u0002sk:\f\u0001c\u001c9f]N+'O^3s'>\u001c7.\u001a;\u0015\u0011\t\u00053qZBj\u0007/Dqa!5W\u0001\u0004\tY0\u0001\u0003i_N$\bbBBk-\u0002\u0007\u0011qG\u0001\u0005a>\u0014H\u000fC\u0004\u0003$Y\u0003\r!a\u000e\u0002)\u0005\u001c7-\u001a9u\u001d\u0016<8i\u001c8oK\u000e$\u0018n\u001c8t\u0003\u0019\t7mY3qiR!1q\\Bq!\u0019\t)ca,\u0003^\"911\u001d-A\u0002\r\u0015\u0018aA6fsB!!QFBt\u0013\u0011\u0019IOa\f\u0003\u0019M+G.Z2uS>t7*Z=\u0002=\r|gNZ5hkJ,\u0017iY2faR,GmU8dW\u0016$8\t[1o]\u0016dG\u0003BA\u0012\u0007_Dqa!=Z\u0001\u0004\u0011i.A\u0007t_\u000e\\W\r^\"iC:tW\r\\\u0001\u001aG2|7/\u001a+ie>$H\u000f\\3e\u0007>tg.Z2uS>t7/A\nbgNLwM\u001c(fo\u000e{gN\\3di&|g\u000e\u0006\u0005\u0002f\re81`B\u0000\u0011\u001d\u0019\tp\u0017a\u0001\u0005;Dqa!@\\\u0001\u0004\u0011I'A\u0005qe>\u001cWm]:pe\"9A\u0011A.A\u0002\u0005\u0015\u0014\u0001C7bs\ncwnY6\u0002\r]\f7.Z;q\u00035\tG\r\u001a)s_\u000e,7o]8sgR!\u00111\u0005C\u0005\u0011\u001d!Y!\u0018a\u0001\u0003o\t\u0001\u0002^8De\u0016\fG/Z\u0001\r]\u0016<\bK]8dKN\u001cxN\u001d\u000b\t\u0005S\"\t\u0002\"\u0006\u0005$!9A1\u00030A\u0002\u0005]\u0012AA5e\u0011\u001d!9B\u0018a\u0001\t3\tA\u0002\\5ti\u0016tWM\u001d(b[\u0016\u0004B\u0001b\u0007\u0005 5\u0011AQ\u0004\u0006\u0004C\u0006E\u0013\u0002\u0002C\u0011\t;\u0011A\u0002T5ti\u0016tWM\u001d(b[\u0016Dq\u0001\"\n_\u0001\u0004!9#\u0001\ttK\u000e,(/\u001b;z!J|Go\\2pYB!A\u0011\u0006C\u0019\u001b\t!YC\u0003\u0003\u0005.\u0011=\u0012\u0001B1vi\"TA!a\"\u0002R%!A1\u0007C\u0016\u0005A\u0019VmY;sSRL\bK]8u_\u000e|G\u000e")
public abstract class Acceptor
implements Runnable,
Logging {
    private volatile Acceptor$DelayedCloseSocket$ DelayedCloseSocket$module;
    private final SocketServer socketServer;
    private final EndPoint endPoint;
    private KafkaConfig config;
    private final int nodeId;
    private final ConnectionQuotas connectionQuotas;
    private final Time time;
    private final boolean isPrivilegedListener;
    private final RequestChannel requestChannel;
    private final Metrics metrics;
    private final CredentialProvider credentialProvider;
    private final LogContext logContext;
    private final MemoryPool memoryPool;
    private final ApiVersionManager apiVersionManager;
    private final KafkaMetricsGroup metricsGroup;
    private final AtomicBoolean shouldRun;
    private final Integer sendBufferSize;
    private final Integer recvBufferSize;
    private final Integer listenBacklogSize;
    private final Selector nioSelector;
    private ServerSocketChannel serverChannel;
    private final int localPort;
    private final ArrayBuffer<Processor> processors;
    private final MetricName blockedPercentMeterMetricName;
    private final Meter blockedPercentMeter;
    private int currentProcessorIndex;
    private final PriorityQueue<DelayedCloseSocket> throttledSockets;
    private boolean started;
    private final CompletableFuture<Void> startedFuture;
    private final KafkaThread thread;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    public Acceptor$DelayedCloseSocket$ DelayedCloseSocket() {
        if (this.DelayedCloseSocket$module == null) {
            this.DelayedCloseSocket$lzycompute$1();
        }
        return this.DelayedCloseSocket$module;
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public SocketServer socketServer() {
        return this.socketServer;
    }

    public EndPoint endPoint() {
        return this.endPoint;
    }

    public KafkaConfig config() {
        return this.config;
    }

    public void config_$eq(KafkaConfig x$1) {
        this.config = x$1;
    }

    public ConnectionQuotas connectionQuotas() {
        return this.connectionQuotas;
    }

    private KafkaMetricsGroup metricsGroup() {
        return this.metricsGroup;
    }

    public AtomicBoolean shouldRun() {
        return this.shouldRun;
    }

    public abstract String metricPrefix();

    public abstract String threadPrefix();

    private Integer sendBufferSize() {
        return this.sendBufferSize;
    }

    private Integer recvBufferSize() {
        return this.recvBufferSize;
    }

    private Integer listenBacklogSize() {
        return this.listenBacklogSize;
    }

    private Selector nioSelector() {
        return this.nioSelector;
    }

    public ServerSocketChannel serverChannel() {
        return this.serverChannel;
    }

    public void serverChannel_$eq(ServerSocketChannel x$1) {
        this.serverChannel = x$1;
    }

    public int localPort() {
        return this.localPort;
    }

    public ArrayBuffer<Processor> processors() {
        return this.processors;
    }

    private MetricName blockedPercentMeterMetricName() {
        return this.blockedPercentMeterMetricName;
    }

    private Meter blockedPercentMeter() {
        return this.blockedPercentMeter;
    }

    private int currentProcessorIndex() {
        return this.currentProcessorIndex;
    }

    private void currentProcessorIndex_$eq(int x$1) {
        this.currentProcessorIndex = x$1;
    }

    public PriorityQueue<DelayedCloseSocket> throttledSockets() {
        return this.throttledSockets;
    }

    private boolean started() {
        return this.started;
    }

    private void started_$eq(boolean x$1) {
        this.started = x$1;
    }

    public CompletableFuture<Void> startedFuture() {
        return this.startedFuture;
    }

    public KafkaThread thread() {
        return this.thread;
    }

    public void start() {
        synchronized (this) {
            this.liftedTree1$1();
            return;
        }
    }

    public synchronized void removeProcessors(int removeCount) {
        ArrayBuffer toRemove = (ArrayBuffer)this.processors().takeRight(removeCount);
        this.processors().remove(this.processors().size() - removeCount, removeCount);
        toRemove.foreach((Function1 & Serializable & scala.Serializable)x$14 -> {
            x$14.close();
            return BoxedUnit.UNIT;
        });
        toRemove.foreach((Function1 & Serializable & scala.Serializable)processor -> {
            this.requestChannel.removeProcessor(processor.id());
            return BoxedUnit.UNIT;
        });
    }

    public void beginShutdown() {
        if (this.shouldRun().getAndSet(false)) {
            this.wakeup();
            synchronized (this) {
                this.processors().foreach((Function1 & Serializable & scala.Serializable)x$15 -> {
                    x$15.beginShutdown();
                    return BoxedUnit.UNIT;
                });
                return;
            }
        }
    }

    public void close() {
        this.beginShutdown();
        this.thread().join();
        synchronized (this) {
            this.processors().foreach((Function1 & Serializable & scala.Serializable)x$16 -> {
                x$16.close();
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        this.serverChannel().register(this.nioSelector(), 16);
        try {
            while (this.shouldRun().get()) {
                try {
                    this.acceptNewConnections();
                    this.closeThrottledConnections();
                }
                catch (Throwable throwable) {
                    if (throwable instanceof ControlThrowable) {
                        throw (Throwable)((ControlThrowable)throwable);
                    }
                    if (throwable == null) throw null;
                    this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error occurred", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> throwable);
                    continue;
                    return;
                }
            }
        }
        finally {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Closing server socket, selector, and any throttled sockets.");
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.serverChannel().close(), this, Level.ERROR);
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.nioSelector().close(), this, Level.ERROR);
            this.throttledSockets().foreach((Function1 & Serializable & scala.Serializable)throttledSocket -> {
                SocketServer$.MODULE$.closeSocket(throttledSocket.socket(), this);
                return BoxedUnit.UNIT;
            });
            this.throttledSockets().clear();
        }
    }

    private ServerSocketChannel openServerSocket(String host, int port, int listenBacklogSize) {
        InetSocketAddress socketAddress = Utils.isBlank((String)host) ? new InetSocketAddress(port) : new InetSocketAddress(host, port);
        ServerSocketChannel serverChannel = ServerSocketChannel.open();
        serverChannel.configureBlocking(false);
        if (!BoxesRunTime.equalsNumObject((Number)this.recvBufferSize(), (Object)BoxesRunTime.boxToInteger((int)-1))) {
            serverChannel.socket().setReceiveBufferSize(Predef$.MODULE$.Integer2int(this.recvBufferSize()));
        }
        try {
            serverChannel.socket().bind(socketAddress, listenBacklogSize);
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Awaiting socket connections on ").append(socketAddress.getHostString()).append(":").append(serverChannel.socket().getLocalPort()).append(".").toString());
        }
        catch (SocketException e) {
            throw new KafkaException(new StringBuilder(36).append("Socket server failed to bind to ").append(socketAddress.getHostString()).append(":").append(port).append(": ").append(e.getMessage()).append(".").toString(), (Throwable)e);
        }
        return serverChannel;
    }

    private void acceptNewConnections() {
        if (this.nioSelector().select(500L) > 0) {
            java.util.Iterator<SelectionKey> iter = this.nioSelector().selectedKeys().iterator();
            while (iter.hasNext() && this.shouldRun().get()) {
                try {
                    SelectionKey key = iter.next();
                    iter.remove();
                    if (key.isAcceptable()) {
                        this.accept(key).foreach((Function1 & Serializable & scala.Serializable)socketChannel -> {
                            Acceptor.$anonfun$acceptNewConnections$1(this, socketChannel);
                            return BoxedUnit.UNIT;
                        });
                        continue;
                    }
                    throw new IllegalStateException("Unrecognized key state for acceptor thread.");
                }
                catch (Throwable e) {
                    this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error while accepting connection", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                }
            }
            return;
        }
    }

    private Option<SocketChannel> accept(SelectionKey key) {
        SocketChannel socketChannel = ((ServerSocketChannel)key.channel()).accept();
        try {
            this.connectionQuotas().inc(this.endPoint().listenerName(), socketChannel.socket().getInetAddress(), this.blockedPercentMeter());
            this.configureAcceptedSocketChannel(socketChannel);
            return new Some((Object)socketChannel);
        }
        catch (TooManyConnectionsException e) {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(86).append("Rejected connection from ").append(e.ip()).append(", address already has the configured maximum of ").append(e.count()).append(" connections.").toString());
            this.connectionQuotas().closeChannel(this, this.endPoint().listenerName(), socketChannel);
            return None$.MODULE$;
        }
        catch (ConnectionThrottledException e) {
            InetAddress ip = socketChannel.socket().getInetAddress();
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Delaying closing of connection from ").append(ip).append(" for ").append(e.throttleTimeMs()).append(" ms").toString());
            long endThrottleTimeMs = e.startThrottleTimeMs() + e.throttleTimeMs();
            this.throttledSockets().$plus$eq((Object)new DelayedCloseSocket(this, socketChannel, endThrottleTimeMs));
            return None$.MODULE$;
        }
        catch (IOException e) {
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Encountered an error while configuring the connection, closing it.", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
            this.connectionQuotas().closeChannel(this, this.endPoint().listenerName(), socketChannel);
            return None$.MODULE$;
        }
    }

    public void configureAcceptedSocketChannel(SocketChannel socketChannel) {
        socketChannel.configureBlocking(false);
        socketChannel.socket().setTcpNoDelay(true);
        socketChannel.socket().setKeepAlive(true);
        if (!BoxesRunTime.equalsNumObject((Number)this.sendBufferSize(), (Object)BoxesRunTime.boxToInteger((int)-1))) {
            socketChannel.socket().setSendBufferSize(Predef$.MODULE$.Integer2int(this.sendBufferSize()));
            return;
        }
    }

    private void closeThrottledConnections() {
        long timeMs = this.time.milliseconds();
        while (this.throttledSockets().headOption().exists((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToBoolean((boolean)Acceptor.$anonfun$closeThrottledConnections$1(timeMs, x$17)))) {
            DelayedCloseSocket closingSocket = (DelayedCloseSocket)this.throttledSockets().dequeue();
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(23).append("Closing socket from ip ").append(closingSocket.socket().getRemoteAddress()).toString());
            SocketServer$.MODULE$.closeSocket(closingSocket.socket(), this);
        }
    }

    private boolean assignNewConnection(SocketChannel socketChannel, Processor processor, boolean mayBlock) {
        if (processor.accept(socketChannel, mayBlock, this.blockedPercentMeter())) {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(138).append("Accepted connection from ").append(socketChannel.socket().getRemoteSocketAddress()).append(" on").append(" ").append(socketChannel.socket().getLocalSocketAddress()).append(" and assigned it to processor ").append(processor.id()).append(",").append(" sendBufferSize [actual|requested]: [").append(socketChannel.socket().getSendBufferSize()).append("|").append(this.sendBufferSize()).append("]").append(" recvBufferSize [actual|requested]: [").append(socketChannel.socket().getReceiveBufferSize()).append("|").append(this.recvBufferSize()).append("]").toString());
            return true;
        }
        return false;
    }

    public void wakeup() {
        this.nioSelector().wakeup();
    }

    public void addProcessors(int toCreate) {
        synchronized (this) {
            ListenerName listenerName = this.endPoint().listenerName();
            SecurityProtocol securityProtocol = this.endPoint().securityProtocol();
            ArrayBuffer listenerProcessors = new ArrayBuffer();
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), toCreate).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
                Processor processor = this.newProcessor(this.socketServer().nextProcessorId(), listenerName, securityProtocol);
                listenerProcessors.$plus$eq((Object)processor);
                $this.requestChannel.addProcessor(processor);
                if (this.started()) {
                    processor.start();
                    return;
                }
            });
            this.processors().$plus$plus$eq((TraversableOnce)listenerProcessors);
            return;
        }
    }

    public Processor newProcessor(int id, ListenerName listenerName, SecurityProtocol securityProtocol) {
        String name = new StringBuilder(25).append(this.threadPrefix()).append("-kafka-network-thread-").append(this.nodeId).append("-").append(this.endPoint().listenerName()).append("-").append(this.endPoint().securityProtocol()).append("-").append(id).toString();
        return new Processor(id, this.time, Predef$.MODULE$.Integer2int(this.config().socketRequestMaxBytes()), this.requestChannel, this.connectionQuotas(), Predef$.MODULE$.Long2long(this.config().connectionsMaxIdleMs()), Predef$.MODULE$.Integer2int(this.config().failedAuthenticationDelayMs()), listenerName, securityProtocol, this.config(), this.metrics, this.credentialProvider, this.memoryPool, this.logContext, Processor$.MODULE$.ConnectionQueueSize(), this.isPrivilegedListener, this.apiVersionManager, name);
    }

    private final void DelayedCloseSocket$lzycompute$1() {
        synchronized (this) {
            if (this.DelayedCloseSocket$module == null) {
                this.DelayedCloseSocket$module = new Acceptor$DelayedCloseSocket$(this);
            }
            return;
        }
    }

    private final /* synthetic */ Object liftedTree1$1() {
        try {
            if (!this.shouldRun().get()) {
                throw new ClosedChannelException();
            }
            if (this.serverChannel() == null) {
                this.serverChannel_$eq(this.openServerSocket(this.endPoint().host(), this.endPoint().port(), Predef$.MODULE$.Integer2int(this.listenBacklogSize())));
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(17).append("Opened endpoint ").append(this.endPoint().host()).append(":").append(this.endPoint().port()).toString());
            }
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Starting processors for listener ").append(this.endPoint().listenerName()).toString());
            this.processors().foreach((Function1 & Serializable & scala.Serializable)x$13 -> {
                x$13.start();
                return BoxedUnit.UNIT;
            });
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Starting acceptor thread for listener ").append(this.endPoint().listenerName()).toString());
            this.thread().start();
            this.startedFuture().complete(null);
            this.started_$eq(true);
            return BoxedUnit.UNIT;
        }
        catch (ClosedChannelException e) {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(78).append("Refusing to start acceptor for ").append(this.endPoint().listenerName()).append(" since the acceptor has already been shut down.").toString());
            return BoxesRunTime.boxToBoolean((boolean)this.startedFuture().completeExceptionally(e));
        }
        catch (Throwable t) {
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Unable to start acceptor for ").append(this.endPoint().listenerName()).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> t);
            return BoxesRunTime.boxToBoolean((boolean)this.startedFuture().completeExceptionally(new RuntimeException(new StringBuilder(29).append("Unable to start acceptor for ").append(this.endPoint().listenerName()).toString(), t)));
        }
    }

    public static final /* synthetic */ void $anonfun$acceptNewConnections$1(Acceptor $this, SocketChannel socketChannel) {
        Processor processor;
        int n;
        synchronized ($this) {
            n = $this.processors().length();
        }
        int retriesLeft = n;
        do {
            --retriesLeft;
            synchronized ($this) {
                $this.currentProcessorIndex_$eq($this.currentProcessorIndex() % $this.processors().length());
                processor = (Processor)$this.processors().apply($this.currentProcessorIndex());
            }
            $this.currentProcessorIndex_$eq($this.currentProcessorIndex() + 1);
        } while (!$this.assignNewConnection(socketChannel, processor, retriesLeft == 0));
    }

    public static final /* synthetic */ boolean $anonfun$closeThrottledConnections$1(long timeMs$1, DelayedCloseSocket x$17) {
        return x$17.endThrottleTimeMs() < timeMs$1;
    }

    public Acceptor(SocketServer socketServer, EndPoint endPoint, KafkaConfig config, int nodeId, ConnectionQuotas connectionQuotas, Time time, boolean isPrivilegedListener, RequestChannel requestChannel, Metrics metrics, CredentialProvider credentialProvider, LogContext logContext, MemoryPool memoryPool, ApiVersionManager apiVersionManager) {
        int n;
        this.socketServer = socketServer;
        this.endPoint = endPoint;
        this.config = config;
        this.nodeId = nodeId;
        this.connectionQuotas = connectionQuotas;
        this.time = time;
        this.isPrivilegedListener = isPrivilegedListener;
        this.requestChannel = requestChannel;
        this.metrics = metrics;
        this.credentialProvider = credentialProvider;
        this.logContext = logContext;
        this.memoryPool = memoryPool;
        this.apiVersionManager = apiVersionManager;
        Logging.$init$(this);
        this.metricsGroup = new KafkaMetricsGroup(this.getClass());
        this.shouldRun = new AtomicBoolean(true);
        this.sendBufferSize = this.config().socketSendBufferBytes();
        this.recvBufferSize = this.config().socketReceiveBufferBytes();
        this.listenBacklogSize = this.config().socketListenBacklogSize();
        this.nioSelector = Selector.open();
        if (endPoint.port() != 0) {
            n = endPoint.port();
        } else {
            this.serverChannel_$eq(this.openServerSocket(endPoint.host(), endPoint.port(), Predef$.MODULE$.Integer2int(this.listenBacklogSize())));
            int newPort = this.serverChannel().socket().getLocalPort();
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append("Opened wildcard endpoint ").append(this.endPoint().host()).append(":").append(newPort).toString());
            n = newPort;
        }
        this.localPort = n;
        this.processors = new ArrayBuffer();
        this.blockedPercentMeterMetricName = KafkaMetricsGroup.explicitMetricName((String)"kafka.network", (String)"Acceptor", (String)new StringBuilder(22).append(this.metricPrefix()).append("AcceptorBlockedPercent").toString(), (java.util.Map)((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Processor$.MODULE$.ListenerMetricTag()), (Object)endPoint.listenerName().value())}))).asJava()));
        this.blockedPercentMeter = this.metricsGroup().newMeter(this.blockedPercentMeterMetricName(), "blocked time", TimeUnit.NANOSECONDS);
        this.currentProcessorIndex = 0;
        this.throttledSockets = new PriorityQueue(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()));
        this.started = false;
        this.startedFuture = new CompletableFuture();
        String nonDaemon_name = new StringBuilder(25).append(this.threadPrefix()).append("-kafka-socket-acceptor-").append(endPoint.listenerName()).append("-").append(endPoint.securityProtocol()).append("-").append(endPoint.port()).toString();
        this.thread = new KafkaThread(nonDaemon_name, (Runnable)this, false);
    }

    public class DelayedCloseSocket
    implements Ordered<DelayedCloseSocket>,
    Product,
    scala.Serializable {
        private final SocketChannel socket;
        private final long endThrottleTimeMs;
        public final /* synthetic */ Acceptor $outer;

        public boolean $less(Object that) {
            return Ordered.$less$((Ordered)this, (Object)that);
        }

        public boolean $greater(Object that) {
            return Ordered.$greater$((Ordered)this, (Object)that);
        }

        public boolean $less$eq(Object that) {
            return Ordered.$less$eq$((Ordered)this, (Object)that);
        }

        public boolean $greater$eq(Object that) {
            return Ordered.$greater$eq$((Ordered)this, (Object)that);
        }

        public int compareTo(Object that) {
            return Ordered.compareTo$((Ordered)this, (Object)that);
        }

        public SocketChannel socket() {
            return this.socket;
        }

        public long endThrottleTimeMs() {
            return this.endThrottleTimeMs;
        }

        public int compare(DelayedCloseSocket that) {
            return new RichLong(Predef$.MODULE$.longWrapper(this.endThrottleTimeMs())).compare((Object)BoxesRunTime.boxToLong((long)that.endThrottleTimeMs()));
        }

        public DelayedCloseSocket copy(SocketChannel socket, long endThrottleTimeMs) {
            return new DelayedCloseSocket(this.kafka$network$Acceptor$DelayedCloseSocket$$$outer(), socket, endThrottleTimeMs);
        }

        public SocketChannel copy$default$1() {
            return this.socket();
        }

        public long copy$default$2() {
            return this.endThrottleTimeMs();
        }

        public String productPrefix() {
            return "DelayedCloseSocket";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.socket();
                }
                case 1: {
                    return BoxesRunTime.boxToLong((long)this.endThrottleTimeMs());
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof DelayedCloseSocket;
        }

        public int hashCode() {
            return Statics.finalizeHash((int)Statics.mix((int)Statics.mix((int)-889275714, (int)Statics.anyHash((Object)this.socket())), (int)Statics.longHash((long)this.endThrottleTimeMs())), (int)2);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean equals(Object x$1) {
            block3: {
                block2: {
                    if (this == x$1) break block2;
                    if (!(x$1 instanceof DelayedCloseSocket && ((DelayedCloseSocket)x$1).kafka$network$Acceptor$DelayedCloseSocket$$$outer() == this.kafka$network$Acceptor$DelayedCloseSocket$$$outer())) break block3;
                    DelayedCloseSocket delayedCloseSocket = (DelayedCloseSocket)x$1;
                    SocketChannel socketChannel = this.socket();
                    SocketChannel socketChannel2 = delayedCloseSocket.socket();
                    if (socketChannel != null ? !socketChannel.equals(socketChannel2) : socketChannel2 != null) break block3;
                    if (this.endThrottleTimeMs() != delayedCloseSocket.endThrottleTimeMs() || !delayedCloseSocket.canEqual(this)) break block3;
                }
                return true;
            }
            return false;
        }

        public /* synthetic */ Acceptor kafka$network$Acceptor$DelayedCloseSocket$$$outer() {
            return this.$outer;
        }

        public DelayedCloseSocket(Acceptor $outer, SocketChannel socket, long endThrottleTimeMs) {
            this.socket = socket;
            this.endThrottleTimeMs = endThrottleTimeMs;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Ordered.$init$((Ordered)this);
            Product.$init$((Product)this);
        }
    }
}

