/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Collection;
import kafka.utils.Json$;
import kafka.utils.json.DecodeJson$;
import kafka.utils.json.DecodeJson$DecodeInt$;
import kafka.utils.json.DecodeJson$DecodeLong$;
import kafka.utils.json.DecodeJson$DecodeString$;
import kafka.utils.json.JsonObject;
import kafka.utils.json.JsonValue;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.token.delegation.TokenInformation;
import org.apache.kafka.common.utils.Sanitizer;
import org.apache.kafka.common.utils.SecurityUtils;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxesRunTime;

public final class DelegationTokenManagerZk$ {
    public static DelegationTokenManagerZk$ MODULE$;
    private final String OwnerKey;
    private final String TokenRequesterKey;
    private final String RenewersKey;
    private final String IssueTimestampKey;
    private final String MaxTimestampKey;
    private final String ExpiryTimestampKey;
    private final String TokenIdKey;
    private final String VersionKey;
    private final int CurrentVersion;

    static {
        new DelegationTokenManagerZk$();
    }

    public String OwnerKey() {
        return this.OwnerKey;
    }

    public String TokenRequesterKey() {
        return this.TokenRequesterKey;
    }

    public String RenewersKey() {
        return this.RenewersKey;
    }

    public String IssueTimestampKey() {
        return this.IssueTimestampKey;
    }

    public String MaxTimestampKey() {
        return this.MaxTimestampKey;
    }

    public String ExpiryTimestampKey() {
        return this.ExpiryTimestampKey;
    }

    public String TokenIdKey() {
        return this.TokenIdKey;
    }

    public String VersionKey() {
        return this.VersionKey;
    }

    public int CurrentVersion() {
        return this.CurrentVersion;
    }

    public Map<String, Object> toJsonCompatibleMap(TokenInformation tokenInfo) {
        scala.collection.mutable.Map tokenInfoMap = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        tokenInfoMap.update((Object)this.VersionKey(), (Object)BoxesRunTime.boxToInteger((int)this.CurrentVersion()));
        tokenInfoMap.update((Object)this.OwnerKey(), (Object)Sanitizer.sanitize((String)tokenInfo.ownerAsString()));
        tokenInfoMap.update((Object)this.TokenRequesterKey(), (Object)Sanitizer.sanitize((String)tokenInfo.tokenRequester().toString()));
        tokenInfoMap.update((Object)this.RenewersKey(), CollectionConverters$.MODULE$.asJavaIterableConverter((Iterable)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(tokenInfo.renewersAsString()).asScala()).map((Function1 & Serializable & scala.Serializable)e -> Sanitizer.sanitize((String)e), Iterable$.MODULE$.canBuildFrom())).asJava());
        tokenInfoMap.update((Object)this.IssueTimestampKey(), (Object)BoxesRunTime.boxToLong((long)tokenInfo.issueTimestamp()));
        tokenInfoMap.update((Object)this.MaxTimestampKey(), (Object)BoxesRunTime.boxToLong((long)tokenInfo.maxTimestamp()));
        tokenInfoMap.update((Object)this.ExpiryTimestampKey(), (Object)BoxesRunTime.boxToLong((long)tokenInfo.expiryTimestamp()));
        tokenInfoMap.update((Object)this.TokenIdKey(), (Object)tokenInfo.tokenId());
        return tokenInfoMap.toMap(Predef$.MODULE$.$conforms());
    }

    public Option<TokenInformation> fromBytes(byte[] bytes) {
        if (bytes == null || new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(bytes)).isEmpty()) {
            return None$.MODULE$;
        }
        Option<JsonValue> option = Json$.MODULE$.parseBytes(bytes);
        if (option instanceof Some) {
            KafkaPrincipal owner;
            JsonObject mainJs = ((JsonValue)((Some)option).value()).asJsonObject();
            int version = BoxesRunTime.unboxToInt((Object)mainJs.apply(this.VersionKey()).to(DecodeJson$DecodeInt$.MODULE$));
            Predef$.MODULE$.require(version > 0 && version <= this.CurrentVersion());
            KafkaPrincipal tokenRequester = owner = SecurityUtils.parseKafkaPrincipal((String)Sanitizer.desanitize((String)mainJs.apply(this.OwnerKey()).to(DecodeJson$DecodeString$.MODULE$)));
            if (version >= 3) {
                tokenRequester = SecurityUtils.parseKafkaPrincipal((String)Sanitizer.desanitize((String)mainJs.apply(this.TokenRequesterKey()).to(DecodeJson$DecodeString$.MODULE$)));
            }
            Seq renewers = (Seq)((TraversableLike)((Seq)mainJs.apply(this.RenewersKey()).to(DecodeJson$.MODULE$.decodeSeq(DecodeJson$DecodeString$.MODULE$, Predef$.MODULE$.fallbackStringCanBuildFrom()))).map((Function1 & Serializable & scala.Serializable)x$1 -> Sanitizer.desanitize((String)x$1), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$1 -> SecurityUtils.parseKafkaPrincipal((String)x$1), Seq$.MODULE$.canBuildFrom());
            long issueTimestamp = BoxesRunTime.unboxToLong((Object)mainJs.apply(this.IssueTimestampKey()).to(DecodeJson$DecodeLong$.MODULE$));
            long expiryTimestamp = BoxesRunTime.unboxToLong((Object)mainJs.apply(this.ExpiryTimestampKey()).to(DecodeJson$DecodeLong$.MODULE$));
            long maxTimestamp = BoxesRunTime.unboxToLong((Object)mainJs.apply(this.MaxTimestampKey()).to(DecodeJson$DecodeLong$.MODULE$));
            String tokenId = mainJs.apply(this.TokenIdKey()).to(DecodeJson$DecodeString$.MODULE$);
            TokenInformation tokenInfo = new TokenInformation(tokenId, owner, tokenRequester, (Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter(renewers).asJava(), issueTimestamp, maxTimestamp, expiryTimestamp);
            return new Some((Object)tokenInfo);
        }
        if (None$.MODULE$.equals(option)) {
            return None$.MODULE$;
        }
        throw new MatchError(option);
    }

    private DelegationTokenManagerZk$() {
        MODULE$ = this;
        this.OwnerKey = "owner";
        this.TokenRequesterKey = "tokenRequester";
        this.RenewersKey = "renewers";
        this.IssueTimestampKey = "issueTimestamp";
        this.MaxTimestampKey = "maxTimestamp";
        this.ExpiryTimestampKey = "expiryTimestamp";
        this.TokenIdKey = "tokenId";
        this.VersionKey = "version";
        this.CurrentVersion = 3;
    }
}

