/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collection;
import java.util.Map;
import javax.crypto.SecretKey;
import kafka.common.ZkNodeChangeNotificationListener;
import kafka.common.ZkNodeChangeNotificationListener$;
import kafka.server.CreateTokenResult;
import kafka.server.DelegationTokenManager$;
import kafka.server.DelegationTokenManager$TokenChangedNotificationHandler$;
import kafka.server.KafkaConfig;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.zk.DelegationTokenChangeNotificationSequenceZNode$;
import kafka.zk.DelegationTokenChangeNotificationZNode$;
import kafka.zk.DelegationTokensZNode$;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.scram.ScramCredential;
import org.apache.kafka.common.security.scram.internals.ScramFormatter;
import org.apache.kafka.common.security.scram.internals.ScramMechanism;
import org.apache.kafka.common.security.token.delegation.DelegationToken;
import org.apache.kafka.common.security.token.delegation.TokenInformation;
import org.apache.kafka.common.security.token.delegation.internals.DelegationTokenCache;
import org.apache.kafka.common.utils.Time;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\rut!\u0002*T\u0011\u0003Af!\u0002.T\u0011\u0003Y\u0006\"\u00022\u0002\t\u0003\u0019\u0007b\u00023\u0002\u0005\u0004%\t!\u001a\u0005\u0007]\u0006\u0001\u000b\u0011\u00024\t\u000f=\f!\u0019!C\u0001K\"1\u0001/\u0001Q\u0001\n\u0019Dq!]\u0001C\u0002\u0013\u0005Q\r\u0003\u0004s\u0003\u0001\u0006IA\u001a\u0005\bg\u0006\u0011\r\u0011\"\u0001f\u0011\u0019!\u0018\u0001)A\u0005M\"9Q/\u0001b\u0001\n\u0003)\u0007B\u0002<\u0002A\u0003%a\rC\u0004x\u0003\t\u0007I\u0011A3\t\ra\f\u0001\u0015!\u0003g\u0011\u001dI\u0018A1A\u0005\u0002\u0015DaA_\u0001!\u0002\u00131\u0007bB>\u0002\u0005\u0004%\t!\u001a\u0005\u0007y\u0006\u0001\u000b\u0011\u00024\t\u000fu\f!\u0019!C\u0001K\"1a0\u0001Q\u0001\n\u0019D\u0001b`\u0001C\u0002\u0013\u0005\u0011\u0011\u0001\u0005\t\u0003\u0013\t\u0001\u0015!\u0003\u0002\u0004!I\u00111B\u0001C\u0002\u0013\u0005\u0011\u0011\u0001\u0005\t\u0003\u001b\t\u0001\u0015!\u0003\u0002\u0004!9\u0011qB\u0001\u0005\u0002\u0005E\u0001bBA\u001e\u0003\u0011\u0005\u0011Q\b\u0005\b\u0003'\nA\u0011AA+\u0011\u001d\ty!\u0001C\u0001\u00037Bq!!\u0019\u0002\t\u0003\t\u0019\u0007C\u0004\u0002\u0016\u0006!\t!a&\t\u000f\u0005%\u0016\u0001\"\u0001\u0002,\u001a)!l\u0015\u0001\u0002n\"Q\u00111 \u0011\u0003\u0006\u0004%\t!!@\t\u0015\t\u0015\u0001E!A!\u0002\u0013\ty\u0010\u0003\u0006\u0003\b\u0001\u0012)\u0019!C\u0001\u0005\u0013A!Ba\u0006!\u0005\u0003\u0005\u000b\u0011\u0002B\u0006\u0011)\u0011I\u0002\tBC\u0002\u0013\u0005!1\u0004\u0005\u000b\u0005O\u0001#\u0011!Q\u0001\n\tu\u0001B\u0003B\u0015A\t\u0015\r\u0011\"\u0001\u0003,!Q!\u0011\b\u0011\u0003\u0002\u0003\u0006IA!\f\t\r\t\u0004C\u0011\u0001B\u001e\u000b\u0019\u00119\u0005\t\u0001\u0003J\u00151!q\u000b\u0011\u0001\u00053*aA!\u001d!\u0001\teSA\u0002B:A\u0001\u0011)\bC\u0005\u0002:\u0001\u0012\r\u0011\"\u0001\u0003z!A!1\u0010\u0011!\u0002\u0013\ty\u0004C\u0005\u0003~\u0001\u0012\r\u0011\"\u0001\u0003\u0000!A!\u0011\u0011\u0011!\u0002\u0013\u0011Y\u0007C\u0005\u0003\u0004\u0002\u0012\r\u0011\"\u0001\u0003\u0000!A!Q\u0011\u0011!\u0002\u0013\u0011Y\u0007C\u0005\u0003\b\u0002\u0012\r\u0011\"\u0001\u0003\u0000!A!\u0011\u0012\u0011!\u0002\u0013\u0011Y\u0007C\u0005\u0003\f\u0002\u0012\r\u0011\"\u0003\u0003\u000e\"A!Q\u0013\u0011!\u0002\u0013\u0011y\tC\u0006\u0003\u0018\u0002\u0002\r\u00111A\u0005\n\te\u0005b\u0003BSA\u0001\u0007\t\u0019!C\u0005\u0005OC1B!,!\u0001\u0004\u0005\t\u0015)\u0003\u0003\u001c\"9!q\u0016\u0011\u0005\u0002\tE\u0006b\u0002BZA\u0011\u0005!\u0011\u0017\u0005\b\u0005k\u0003C\u0011\u0002BY\u0011\u001d\u00119\f\tC\u0005\u0005sCqAa0!\t\u0013\u0011\t\rC\u0004\u0003F\u0002\"IAa2\t\u000f\tm\u0007\u0005\"\u0001\u0003^\"9!q\u001f\u0011\u0005\u0002\te\bbBB\rA\u0011%11\u0004\u0005\b\u0007?\u0001C\u0011BB\u0011\u0011\u001d\u0019)\u0003\tC\u0005\u0007OAqaa\b!\t\u0003\u0019y\u0003C\u0004\u0004 \u0001\"Iaa\r\t\u000f\r]\u0002\u0005\"\u0001\u0004:!91\u0011\n\u0011\u0005\n\r-\u0003bBB(A\u0011%1\u0011\u000b\u0005\b\u0007+\u0002C\u0011\u0001BY\u0011\u001d\u00199\u0006\tC\u0001\u00073Bqa!\u0018!\t\u0003\u0019yfB\u0004\u0004f\u0001B\taa\u001a\u0007\u000f\r%\u0004\u0005#\u0001\u0004l!1!m\u0014C\u0001\u0007gBqa!\u001eP\t\u0003\u001a9(\u0001\fEK2,w-\u0019;j_:$vn[3o\u001b\u0006t\u0017mZ3s\u0015\t!V+\u0001\u0004tKJ4XM\u001d\u0006\u0002-\u0006)1.\u00194lC\u000e\u0001\u0001CA-\u0002\u001b\u0005\u0019&A\u0006#fY\u0016<\u0017\r^5p]R{7.\u001a8NC:\fw-\u001a:\u0014\u0005\u0005a\u0006CA/a\u001b\u0005q&\"A0\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0005t&AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u00021\u0006!B)\u001a4bk2$\b*\\1d\u00032<wN]5uQ6,\u0012A\u001a\t\u0003O2l\u0011\u0001\u001b\u0006\u0003S*\fA\u0001\\1oO*\t1.\u0001\u0003kCZ\f\u0017BA7i\u0005\u0019\u0019FO]5oO\u0006)B)\u001a4bk2$\b*\\1d\u00032<wN]5uQ6\u0004\u0013\u0001C(x]\u0016\u00148*Z=\u0002\u0013=;h.\u001a:LKf\u0004\u0013!\u0005+pW\u0016t'+Z9vKN$XM]&fs\u0006\u0011Bk\\6f]J+\u0017/^3ti\u0016\u00148*Z=!\u0003-\u0011VM\\3xKJ\u001c8*Z=\u0002\u0019I+g.Z<feN\\U-\u001f\u0011\u0002#%\u001b8/^3US6,7\u000f^1na.+\u00170\u0001\nJgN,X\rV5nKN$\u0018-\u001c9LKf\u0004\u0013aD'bqRKW.Z:uC6\u00048*Z=\u0002!5\u000b\u0007\u0010V5nKN$\u0018-\u001c9LKf\u0004\u0013AE#ya&\u0014\u0018\u0010V5nKN$\u0018-\u001c9LKf\f1#\u0012=qSJLH+[7fgR\fW\u000e]&fs\u0002\n!\u0002V8lK:LEmS3z\u0003-!vn[3o\u0013\u0012\\U-\u001f\u0011\u0002\u0015Y+'o]5p].+\u00170A\u0006WKJ\u001c\u0018n\u001c8LKf\u0004\u0013AD\"veJ,g\u000e\u001e,feNLwN\\\u000b\u0003\u0003\u0007\u00012!XA\u0003\u0013\r\t9A\u0018\u0002\u0004\u0013:$\u0018aD\"veJ,g\u000e\u001e,feNLwN\u001c\u0011\u0002\u001d\u0015\u0013(o\u001c:US6,7\u000f^1na\u0006yQI\u001d:peRKW.Z:uC6\u0004\b%\u0001\u0006de\u0016\fG/\u001a%nC\u000e$b!a\u0005\u0002 \u0005]\u0002#B/\u0002\u0016\u0005e\u0011bAA\f=\n)\u0011I\u001d:bsB\u0019Q,a\u0007\n\u0007\u0005uaL\u0001\u0003CsR,\u0007bBA\u00113\u0001\u0007\u00111E\u0001\bi>\\WM\\%e!\u0011\t)#a\r\u000f\t\u0005\u001d\u0012q\u0006\t\u0004\u0003SqVBAA\u0016\u0015\r\ticV\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005Eb,\u0001\u0004Qe\u0016$WMZ\u0005\u0004[\u0006U\"bAA\u0019=\"9\u0011\u0011H\rA\u0002\u0005\r\u0012!C:fGJ,GoS3z\u0003=\u0019'/Z1uKN+7M]3u\u0017\u0016LH\u0003BA \u0003\u001f\u0002B!!\u0011\u0002L5\u0011\u00111\t\u0006\u0005\u0003\u000b\n9%\u0001\u0004def\u0004Ho\u001c\u0006\u0003\u0003\u0013\nQA[1wCbLA!!\u0014\u0002D\tI1+Z2sKR\\U-\u001f\u0005\b\u0003#R\u0002\u0019AA\n\u0003!YW-\u001f2zi\u0016\u001c\u0018\u0001E2sK\u0006$XMQ1tKZ\"\u0004*T!D)\u0019\t\u0019#a\u0016\u0002Z!9\u0011\u0011E\u000eA\u0002\u0005\r\u0002bBA\u001d7\u0001\u0007\u0011q\b\u000b\u0007\u0003'\ti&a\u0018\t\u000f\u0005\u0005B\u00041\u0001\u0002$!9\u0011\u0011\b\u000fA\u0002\u0005}\u0012a\u0005;p\u0015N|gnQ8na\u0006$\u0018N\u00197f\u001b\u0006\u0004H\u0003BA3\u0003c\u0002\u0002\"!\n\u0002h\u0005\r\u00121N\u0005\u0005\u0003S\n)DA\u0002NCB\u00042!XA7\u0013\r\tyG\u0018\u0002\u0004\u0003:L\bbBA:;\u0001\u0007\u0011QO\u0001\u0006i>\\WM\u001c\t\u0005\u0003o\n\t*\u0004\u0002\u0002z)!\u00111PA?\u0003)!W\r\\3hCRLwN\u001c\u0006\u0005\u0003g\nyH\u0003\u0003\u0002\u0002\u0006\r\u0015\u0001C:fGV\u0014\u0018\u000e^=\u000b\t\u0005\u0015\u0015qQ\u0001\u0007G>lWn\u001c8\u000b\u0007Y\u000bII\u0003\u0003\u0002\f\u00065\u0015AB1qC\u000eDWM\u0003\u0002\u0002\u0010\u0006\u0019qN]4\n\t\u0005M\u0015\u0011\u0010\u0002\u0010\t\u0016dWmZ1uS>tGk\\6f]\u0006IaM]8n\u0005f$Xm\u001d\u000b\u0005\u00033\u000b)\u000bE\u0003^\u00037\u000by*C\u0002\u0002\u001ez\u0013aa\u00149uS>t\u0007\u0003BA<\u0003CKA!a)\u0002z\t\u0001Bk\\6f]&sgm\u001c:nCRLwN\u001c\u0005\b\u0003Os\u0002\u0019AA\n\u0003\u0015\u0011\u0017\u0010^3t\u0003-1\u0017\u000e\u001c;feR{7.\u001a8\u0015\u0019\u00055\u00161WAb\u00037\fi.a:\u0011\u0007u\u000by+C\u0002\u00022z\u0013qAQ8pY\u0016\fg\u000eC\u0004\u00026~\u0001\r!a.\u0002%I,\u0017/^3ti\u0016\u0014\bK]5oG&\u0004\u0018\r\u001c\t\u0005\u0003s\u000by,\u0004\u0002\u0002<*!\u0011QXA@\u0003\u0011\tW\u000f\u001e5\n\t\u0005\u0005\u00171\u0018\u0002\u000f\u0017\u000647.\u0019)sS:\u001c\u0017\u000e]1m\u0011\u001d\t)m\ba\u0001\u0003\u000f\faa\\<oKJ\u001c\b#B/\u0002\u001c\u0006%\u0007CBAf\u0003+\f9L\u0004\u0003\u0002N\u0006Eg\u0002BA\u0015\u0003\u001fL\u0011aX\u0005\u0004\u0003't\u0016a\u00029bG.\fw-Z\u0005\u0005\u0003/\fIN\u0001\u0003MSN$(bAAj=\"9\u00111O\u0010A\u0002\u0005}\u0005bBAp?\u0001\u0007\u0011\u0011]\u0001\u000fCV$\bn\u001c:ju\u0016$vn[3o!\u001di\u00161]A\u0012\u0003[K1!!:_\u0005%1UO\\2uS>t\u0017\u0007C\u0004\u0002j~\u0001\r!a;\u0002%\u0005,H\u000f[8sSj,'+Z9vKN$XM\u001d\t\b;\u0006\r\u0018qWAW'\u0011\u0001C,a<\u0011\t\u0005E\u0018q_\u0007\u0003\u0003gT1!!>V\u0003\u0015)H/\u001b7t\u0013\u0011\tI0a=\u0003\u000f1{wmZ5oO\u000611m\u001c8gS\u001e,\"!a@\u0011\u0007e\u0013\t!C\u0002\u0003\u0004M\u00131bS1gW\u0006\u001cuN\u001c4jO\u000691m\u001c8gS\u001e\u0004\u0013A\u0003;pW\u0016t7)Y2iKV\u0011!1\u0002\t\u0005\u0005\u001b\u0011\u0019\"\u0004\u0002\u0003\u0010)!!\u0011CA=\u0003%Ig\u000e^3s]\u0006d7/\u0003\u0003\u0003\u0016\t=!\u0001\u0006#fY\u0016<\u0017\r^5p]R{7.\u001a8DC\u000eDW-A\u0006u_.,gnQ1dQ\u0016\u0004\u0013\u0001\u0002;j[\u0016,\"A!\b\u0011\t\t}!1E\u0007\u0003\u0005CQA!!>\u0002\u0004&!!Q\u0005B\u0011\u0005\u0011!\u0016.\\3\u0002\u000bQLW.\u001a\u0011\u0002\u0011i\\7\t\\5f]R,\"A!\f\u0011\t\t=\"QG\u0007\u0003\u0005cQ1Aa\rV\u0003\tQ8.\u0003\u0003\u00038\tE\"!D&bM.\f'l[\"mS\u0016tG/A\u0005{W\u000ec\u0017.\u001a8uAQQ!Q\bB \u0005\u0003\u0012\u0019E!\u0012\u0011\u0005e\u0003\u0003bBA~S\u0001\u0007\u0011q \u0005\b\u0005\u000fI\u0003\u0019\u0001B\u0006\u0011\u001d\u0011I\"\u000ba\u0001\u0005;AqA!\u000b*\u0001\u0004\u0011iC\u0001\fDe\u0016\fG/\u001a*fgB|gn]3DC2d'-Y2l!\u001di\u00161\u001dB&\u0005#\u00022!\u0017B'\u0013\r\u0011ye\u0015\u0002\u0012\u0007J,\u0017\r^3U_.,gNU3tk2$\bcA/\u0003T%\u0019!Q\u000b0\u0003\tUs\u0017\u000e\u001e\u0002\u0016%\u0016tWm\u001e*fgB|gn]3DC2d'-Y2l!%i&1\fB0\u0005W\u0012\t&C\u0002\u0003^y\u0013\u0011BR;oGRLwN\u001c\u001a\u0011\t\t\u0005$qM\u0007\u0003\u0005GRAA!\u001a\u0002\u0004\u0006A\u0001O]8u_\u000e|G.\u0003\u0003\u0003j\t\r$AB#se>\u00148\u000fE\u0002^\u0005[J1Aa\u001c_\u0005\u0011auN\\4\u0003-\u0015C\b/\u001b:f%\u0016\u001c\bo\u001c8tK\u000e\u000bG\u000e\u001c2bG.\u0014\u0001\u0004R3tGJL'-\u001a*fgB|gn]3DC2d'-Y2l!%i&1\fB0\u0005o\u0012\t\u0006\u0005\u0004\u0002L\u0006U\u0017QO\u000b\u0003\u0003\u007f\t!b]3de\u0016$8*Z=!\u0003A!xn[3o\u001b\u0006DH*\u001b4fi&lW-\u0006\u0002\u0003l\u0005\tBo\\6f]6\u000b\u0007\u0010T5gKRLW.\u001a\u0011\u0002+\u0011,g-Y;miR{7.\u001a8SK:,w\u000fV5nK\u00061B-\u001a4bk2$Hk\\6f]J+g.Z<US6,\u0007%\u0001\ru_.,gNU3n_Z,'oU2b]&sG/\u001a:wC2\f\u0011\u0004^8lK:\u0014V-\\8wKJ\u001c6-\u00198J]R,'O^1mA\u0005!An\\2l+\t\u0011y\tE\u0002h\u0005#K1Aa%i\u0005\u0019y%M[3di\u0006)An\\2lA\u0005\u0019Bo\\6f]\u000eC\u0017M\\4f\u0019&\u001cH/\u001a8feV\u0011!1\u0014\t\u0005\u0005;\u0013\t+\u0004\u0002\u0003 *\u0019\u0011QQ+\n\t\t\r&q\u0014\u0002!5.tu\u000eZ3DQ\u0006tw-\u001a(pi&4\u0017nY1uS>tG*[:uK:,'/A\fu_.,gn\u00115b]\u001e,G*[:uK:,'o\u0018\u0013fcR!!\u0011\u000bBU\u0011%\u0011Y+OA\u0001\u0002\u0004\u0011Y*A\u0002yIE\nA\u0003^8lK:\u001c\u0005.\u00198hK2K7\u000f^3oKJ\u0004\u0013aB:uCJ$X\u000f\u001d\u000b\u0003\u0005#\n\u0001b\u001d5vi\u0012|wO\\\u0001\nY>\fGmQ1dQ\u0016\fabZ3u)>\\WM\u001c$s_6T6\u000e\u0006\u0003\u0003<\nu\u0006#B/\u0002\u001c\u0006U\u0004bBA\u0011}\u0001\u0007\u00111E\u0001\fkB$\u0017\r^3DC\u000eDW\r\u0006\u0003\u0003R\t\r\u0007bBA:\u007f\u0001\u0007\u0011QO\u0001\u0018aJ,\u0007/\u0019:f'\u000e\u0014\u0018-\\\"sK\u0012,g\u000e^5bYN$BA!3\u0003XBA\u0011QEA4\u0003G\u0011Y\r\u0005\u0003\u0003N\nMWB\u0001Bh\u0015\u0011\u0011\t.a \u0002\u000bM\u001c'/Y7\n\t\tU'q\u001a\u0002\u0010'\u000e\u0014\u0018-\\\"sK\u0012,g\u000e^5bY\"9!\u0011\u001c!A\u0002\u0005\r\u0012A\u00035nC\u000e\u001cFO]5oO\u0006Y1M]3bi\u0016$vn[3o)1\u0011\tFa8\u0003d\n\u001d(1\u001eBx\u0011\u001d\u0011\t/\u0011a\u0001\u0003o\u000bQa\\<oKJDqA!:B\u0001\u0004\t9,\u0001\bu_.,gNU3rk\u0016\u001cH/\u001a:\t\u000f\t%\u0018\t1\u0001\u0002J\u0006A!/\u001a8fo\u0016\u00148\u000fC\u0004\u0003n\u0006\u0003\rAa\u001b\u0002\u001b5\f\u0007\u0010T5gKRKW.Z't\u0011\u001d\u0011\t0\u0011a\u0001\u0005g\f\u0001C]3ta>t7/Z\"bY2\u0014\u0017mY6\u0011\u0007\tU(&D\u0001!\u0003)\u0011XM\\3x)>\\WM\u001c\u000b\u000b\u0005#\u0012YPa@\u0004\u0010\rM\u0001b\u0002B\u007f\u0005\u0002\u0007\u0011qW\u0001\naJLgnY5qC2Dqa!\u0001C\u0001\u0004\u0019\u0019!\u0001\u0003i[\u0006\u001c\u0007\u0003BB\u0003\u0007\u0017i!aa\u0002\u000b\u0007\r%!.A\u0002oS>LAa!\u0004\u0004\b\tQ!)\u001f;f\u0005V4g-\u001a:\t\u000f\rE!\t1\u0001\u0003l\u0005y!/\u001a8fo2Kg-\u001a+j[\u0016l5\u000fC\u0004\u0004\u0016\t\u0003\raa\u0006\u0002\u001bI,g.Z<DC2d'-Y2l!\r\u0011)pK\u0001\fkB$\u0017\r^3U_.,g\u000e\u0006\u0003\u0003R\ru\u0001bBA:\u0007\u0002\u0007\u0011QO\u0001\tO\u0016$Hk\\6f]R!!1XB\u0012\u0011\u001d\u0019\t\u0001\u0012a\u0001\u0007\u0007\ta\"\u00197m_^,G\rV8SK:,w\u000f\u0006\u0004\u0002.\u000e%21\u0006\u0005\b\u0005{,\u0005\u0019AA\\\u0011\u001d\u0019i#\u0012a\u0001\u0003?\u000b\u0011\u0002^8lK:LeNZ8\u0015\t\tm6\u0011\u0007\u0005\b\u0003C1\u0005\u0019AA\u0012)\u0011\t)h!\u000e\t\u000f\r5r\t1\u0001\u0002 \u0006YQ\r\u001f9je\u0016$vn[3o))\u0011\tfa\u000f\u0004>\r}21\t\u0005\b\u0005{D\u0005\u0019AA\\\u0011\u001d\u0019\t\u0001\u0013a\u0001\u0007\u0007Aqa!\u0011I\u0001\u0004\u0011Y'\u0001\tfqBL'/\u001a'jM\u0016$\u0016.\\3Ng\"91Q\t%A\u0002\r\u001d\u0013AF3ya&\u0014XMU3ta>t7/Z\"bY2\u0014\u0017mY6\u0011\u0007\tUH&A\u0006sK6|g/\u001a+pW\u0016tG\u0003\u0002B)\u0007\u001bBq!!\tJ\u0001\u0004\t\u0019#A\u0006sK6|g/Z\"bG\",G\u0003\u0002B)\u0007'Bq!!\tK\u0001\u0004\t\u0019#\u0001\u0007fqBL'/\u001a+pW\u0016t7/\u0001\fhKR\fE\u000e\u001c+pW\u0016t\u0017J\u001c4pe6\fG/[8o+\t\u0019Y\u0006\u0005\u0004\u0002L\u0006U\u0017qT\u0001\nO\u0016$Hk\\6f]N$BAa\u001e\u0004b!9\u0011\u0011V'A\u0002\r\r\u0004cB/\u0002d\u0006}\u0015QV\u0001 )>\\WM\\\"iC:<W\r\u001a(pi&4\u0017nY1uS>t\u0007*\u00198eY\u0016\u0014\bc\u0001B{\u001f\nyBk\\6f]\u000eC\u0017M\\4fI:{G/\u001b4jG\u0006$\u0018n\u001c8IC:$G.\u001a:\u0014\t=c6Q\u000e\t\u0005\u0005;\u001by'\u0003\u0003\u0004r\t}%a\u0005(pi&4\u0017nY1uS>t\u0007*\u00198eY\u0016\u0014HCAB4\u0003M\u0001(o\\2fgNtu\u000e^5gS\u000e\fG/[8o)\u0011\u0011\tf!\u001f\t\u000f\rm\u0014\u000b1\u0001\u0002\u0014\u0005aAo\\6f]&#')\u001f;fg\u0002")
public class DelegationTokenManager
implements Logging {
    private volatile DelegationTokenManager$TokenChangedNotificationHandler$ TokenChangedNotificationHandler$module;
    private final KafkaConfig config;
    private final DelegationTokenCache tokenCache;
    private final Time time;
    private final KafkaZkClient zkClient;
    private final SecretKey secretKey;
    private final long tokenMaxLifetime;
    private final long defaultTokenRenewTime;
    private final long tokenRemoverScanInterval;
    private final Object kafka$server$DelegationTokenManager$$lock;
    private ZkNodeChangeNotificationListener tokenChangeListener;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static boolean filterToken(KafkaPrincipal kafkaPrincipal, Option<List<KafkaPrincipal>> option, TokenInformation tokenInformation, Function1<String, Object> function1, Function1<KafkaPrincipal, Object> function12) {
        if (DelegationTokenManager$.MODULE$ == null) {
            throw null;
        }
        if (option.isDefined() && !((LinearSeqOptimized)option.get()).exists(arg_0 -> DelegationTokenManager$.$anonfun$filterToken$1$adapted(tokenInformation, arg_0))) {
            return false;
        }
        if (tokenInformation.ownerOrRenewer(kafkaPrincipal)) {
            return true;
        }
        return BoxesRunTime.unboxToBoolean((Object)function1.apply((Object)tokenInformation.tokenId())) || BoxesRunTime.unboxToBoolean((Object)function12.apply((Object)tokenInformation.owner()));
    }

    public static Option<TokenInformation> fromBytes(byte[] byArray) {
        return DelegationTokenManager$.MODULE$.fromBytes(byArray);
    }

    public static scala.collection.immutable.Map<String, Object> toJsonCompatibleMap(DelegationToken delegationToken) {
        return DelegationTokenManager$.MODULE$.toJsonCompatibleMap(delegationToken);
    }

    public static byte[] createHmac(String string, SecretKey secretKey) {
        return DelegationTokenManager$.MODULE$.createHmac(string, secretKey);
    }

    public static String createBase64HMAC(String string, SecretKey secretKey) {
        return DelegationTokenManager$.MODULE$.createBase64HMAC(string, secretKey);
    }

    public static SecretKey createSecretKey(byte[] byArray) {
        return DelegationTokenManager$.MODULE$.createSecretKey(byArray);
    }

    public static byte[] createHmac(String string, String string2) {
        return DelegationTokenManager$.MODULE$.createHmac(string, string2);
    }

    public static int ErrorTimestamp() {
        return DelegationTokenManager$.MODULE$.ErrorTimestamp();
    }

    public static int CurrentVersion() {
        return DelegationTokenManager$.MODULE$.CurrentVersion();
    }

    public static String VersionKey() {
        return DelegationTokenManager$.MODULE$.VersionKey();
    }

    public static String TokenIdKey() {
        return DelegationTokenManager$.MODULE$.TokenIdKey();
    }

    public static String ExpiryTimestampKey() {
        return DelegationTokenManager$.MODULE$.ExpiryTimestampKey();
    }

    public static String MaxTimestampKey() {
        return DelegationTokenManager$.MODULE$.MaxTimestampKey();
    }

    public static String IssueTimestampKey() {
        return DelegationTokenManager$.MODULE$.IssueTimestampKey();
    }

    public static String RenewersKey() {
        return DelegationTokenManager$.MODULE$.RenewersKey();
    }

    public static String TokenRequesterKey() {
        return DelegationTokenManager$.MODULE$.TokenRequesterKey();
    }

    public static String OwnerKey() {
        return DelegationTokenManager$.MODULE$.OwnerKey();
    }

    public static String DefaultHmacAlgorithm() {
        return DelegationTokenManager$.MODULE$.DefaultHmacAlgorithm();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    public DelegationTokenManager$TokenChangedNotificationHandler$ TokenChangedNotificationHandler() {
        if (this.TokenChangedNotificationHandler$module == null) {
            this.TokenChangedNotificationHandler$lzycompute$1();
        }
        return this.TokenChangedNotificationHandler$module;
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public KafkaConfig config() {
        return this.config;
    }

    public DelegationTokenCache tokenCache() {
        return this.tokenCache;
    }

    public Time time() {
        return this.time;
    }

    public KafkaZkClient zkClient() {
        return this.zkClient;
    }

    public SecretKey secretKey() {
        return this.secretKey;
    }

    public long tokenMaxLifetime() {
        return this.tokenMaxLifetime;
    }

    public long defaultTokenRenewTime() {
        return this.defaultTokenRenewTime;
    }

    public long tokenRemoverScanInterval() {
        return this.tokenRemoverScanInterval;
    }

    public Object kafka$server$DelegationTokenManager$$lock() {
        return this.kafka$server$DelegationTokenManager$$lock;
    }

    private ZkNodeChangeNotificationListener tokenChangeListener() {
        return this.tokenChangeListener;
    }

    private void tokenChangeListener_$eq(ZkNodeChangeNotificationListener x$1) {
        this.tokenChangeListener = x$1;
    }

    public void startup() {
        if (this.config().tokenAuthEnabled()) {
            this.zkClient().createDelegationTokenPaths();
            this.loadCache();
            this.tokenChangeListener_$eq(new ZkNodeChangeNotificationListener(this.zkClient(), DelegationTokenChangeNotificationZNode$.MODULE$.path(), DelegationTokenChangeNotificationSequenceZNode$.MODULE$.SequenceNumberPrefix(), this.TokenChangedNotificationHandler(), ZkNodeChangeNotificationListener$.MODULE$.$lessinit$greater$default$5(), ZkNodeChangeNotificationListener$.MODULE$.$lessinit$greater$default$6()));
            this.tokenChangeListener().init();
        }
    }

    public void shutdown() {
        if (this.config().tokenAuthEnabled() && this.tokenChangeListener() != null) {
            this.tokenChangeListener().close();
            return;
        }
    }

    private void loadCache() {
        Object object = this.kafka$server$DelegationTokenManager$$lock();
        synchronized (object) {
            Seq<String> tokens = this.zkClient().getChildren(DelegationTokensZNode$.MODULE$.path());
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Loading the token cache. Total token count: ").append(tokens.size()).toString());
            tokens.foreach((Function1 & Serializable & scala.Serializable)tokenId -> {
                DelegationTokenManager.$anonfun$loadCache$2(this, tokenId);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public Option<DelegationToken> kafka$server$DelegationTokenManager$$getTokenFromZk(String tokenId) {
        None$ none$;
        Option<TokenInformation> option = this.zkClient().getDelegationTokenInfo(tokenId);
        if (option instanceof Some) {
            TokenInformation tokenInformation = (TokenInformation)((Some)option).value();
            byte[] hmac = DelegationTokenManager$.MODULE$.createHmac(tokenId, this.secretKey());
            none$ = new Some((Object)new DelegationToken(tokenInformation, hmac));
        } else if (None$.MODULE$.equals(option)) {
            none$ = None$.MODULE$;
        } else {
            throw new MatchError(option);
        }
        return none$;
    }

    public void kafka$server$DelegationTokenManager$$updateCache(DelegationToken token) {
        String hmacString = token.hmacAsBase64String();
        scala.collection.immutable.Map<String, ScramCredential> scramCredentialMap = this.prepareScramCredentials(hmacString);
        this.tokenCache().updateCache(token, (Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(scramCredentialMap).asJava());
    }

    private scala.collection.immutable.Map<String, ScramCredential> prepareScramCredentials(String hmacString) {
        scala.collection.mutable.Map scramCredentialMap = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ScramMechanism.values())).foreach((Function1 & Serializable & scala.Serializable)mechanism -> {
            scramCredentialMap.update((Object)mechanism.mechanismName(), (Object)DelegationTokenManager.scramCredential$1(mechanism, hmacString));
            return BoxedUnit.UNIT;
        });
        return scramCredentialMap.toMap(Predef$.MODULE$.$conforms());
    }

    public void createToken(KafkaPrincipal owner, KafkaPrincipal tokenRequester, List<KafkaPrincipal> renewers, long maxLifeTimeMs, Function1<CreateTokenResult, BoxedUnit> responseCallback) {
        if (!this.config().tokenAuthEnabled()) {
            responseCallback.apply((Object)new CreateTokenResult(owner, tokenRequester, -1L, -1L, -1L, "", (byte[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte()), Errors.DELEGATION_TOKEN_AUTH_DISABLED));
            return;
        }
        Object object = this.kafka$server$DelegationTokenManager$$lock();
        synchronized (object) {
            String tokenId = CoreUtils$.MODULE$.generateUuidAsBase64();
            long issueTimeStamp = this.time().milliseconds();
            long maxLifeTime = maxLifeTimeMs <= 0L ? this.tokenMaxLifetime() : Math.min(maxLifeTimeMs, this.tokenMaxLifetime());
            long maxLifeTimeStamp = issueTimeStamp + maxLifeTime;
            long expiryTimeStamp = Math.min(maxLifeTimeStamp, issueTimeStamp + this.defaultTokenRenewTime());
            TokenInformation tokenInfo = new TokenInformation(tokenId, owner, tokenRequester, (Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter(renewers).asJava(), issueTimeStamp, maxLifeTimeStamp, expiryTimeStamp);
            byte[] hmac = DelegationTokenManager$.MODULE$.createHmac(tokenId, this.secretKey());
            DelegationToken token = new DelegationToken(tokenInfo, hmac);
            this.updateToken(token);
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("Created a delegation token: ").append(tokenId).append(" for owner: ").append(owner).toString());
            responseCallback.apply((Object)new CreateTokenResult(owner, tokenRequester, issueTimeStamp, expiryTimeStamp, maxLifeTimeStamp, tokenId, hmac, Errors.NONE));
            return;
        }
    }

    public void renewToken(KafkaPrincipal principal, ByteBuffer hmac, long renewLifeTimeMs, Function2<Errors, Object, BoxedUnit> renewCallback) {
        if (!this.config().tokenAuthEnabled()) {
            renewCallback.apply((Object)Errors.DELEGATION_TOKEN_AUTH_DISABLED, (Object)BoxesRunTime.boxToLong((long)-1L));
            return;
        }
        Object object = this.kafka$server$DelegationTokenManager$$lock();
        synchronized (object) {
            Option<DelegationToken> option = this.getToken(hmac);
            if (option instanceof Some) {
                DelegationToken token = (DelegationToken)((Some)option).value();
                long now = this.time().milliseconds();
                TokenInformation tokenInfo = token.tokenInfo();
                if (!this.allowedToRenew(principal, tokenInfo)) {
                    BoxedUnit cfr_ignored_0 = (BoxedUnit)renewCallback.apply((Object)Errors.DELEGATION_TOKEN_OWNER_MISMATCH, (Object)BoxesRunTime.boxToLong((long)-1L));
                } else if (tokenInfo.maxTimestamp() < now || tokenInfo.expiryTimestamp() < now) {
                    BoxedUnit cfr_ignored_1 = (BoxedUnit)renewCallback.apply((Object)Errors.DELEGATION_TOKEN_EXPIRED, (Object)BoxesRunTime.boxToLong((long)-1L));
                } else {
                    long renewLifeTime = renewLifeTimeMs < 0L ? this.defaultTokenRenewTime() : renewLifeTimeMs;
                    long renewTimeStamp = now + renewLifeTime;
                    long expiryTimeStamp = Math.min(tokenInfo.maxTimestamp(), renewTimeStamp);
                    tokenInfo.setExpiryTimestamp(expiryTimeStamp);
                    this.updateToken(token);
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("Delegation token renewed for token: ").append(tokenInfo.tokenId()).append(" for owner: ").append(tokenInfo.owner()).toString());
                    BoxedUnit cfr_ignored_2 = (BoxedUnit)renewCallback.apply((Object)Errors.NONE, (Object)BoxesRunTime.boxToLong((long)expiryTimeStamp));
                }
            } else if (None$.MODULE$.equals(option)) {
                BoxedUnit cfr_ignored_3 = (BoxedUnit)renewCallback.apply((Object)Errors.DELEGATION_TOKEN_NOT_FOUND, (Object)BoxesRunTime.boxToLong((long)-1L));
            } else {
                throw new MatchError(option);
            }
            return;
        }
    }

    private void updateToken(DelegationToken token) {
        this.zkClient().setOrCreateDelegationToken(token);
        this.kafka$server$DelegationTokenManager$$updateCache(token);
        this.zkClient().createTokenChangeNotification(token.tokenInfo().tokenId());
    }

    private Option<DelegationToken> getToken(ByteBuffer hmac) {
        None$ none$;
        try {
            byte[] byteArray = new byte[hmac.remaining()];
            hmac.get(byteArray);
            String base64Pwd = Base64.getEncoder().encodeToString(byteArray);
            TokenInformation tokenInfo = this.tokenCache().tokenForHmac(base64Pwd);
            if (tokenInfo != null) {
                return new Some((Object)new DelegationToken(tokenInfo, byteArray));
            }
            none$ = None$.MODULE$;
        }
        catch (Exception e) {
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Exception while getting token for hmac", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
            none$ = None$.MODULE$;
        }
        return none$;
    }

    private boolean allowedToRenew(KafkaPrincipal principal, TokenInformation tokenInfo) {
        return principal.equals((Object)tokenInfo.owner()) || ((TraversableOnce)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(tokenInfo.renewers()).asScala()).toList().contains((Object)principal);
    }

    public Option<DelegationToken> getToken(String tokenId) {
        TokenInformation tokenInfo = this.tokenCache().token(tokenId);
        if (tokenInfo != null) {
            return new Some((Object)this.getToken(tokenInfo));
        }
        return None$.MODULE$;
    }

    private DelegationToken getToken(TokenInformation tokenInfo) {
        byte[] hmac = DelegationTokenManager$.MODULE$.createHmac(tokenInfo.tokenId(), this.secretKey());
        return new DelegationToken(tokenInfo, hmac);
    }

    public void expireToken(KafkaPrincipal principal, ByteBuffer hmac, long expireLifeTimeMs, Function2<Errors, Object, BoxedUnit> expireResponseCallback) {
        if (!this.config().tokenAuthEnabled()) {
            expireResponseCallback.apply((Object)Errors.DELEGATION_TOKEN_AUTH_DISABLED, (Object)BoxesRunTime.boxToLong((long)-1L));
            return;
        }
        Object object = this.kafka$server$DelegationTokenManager$$lock();
        synchronized (object) {
            Option<DelegationToken> option = this.getToken(hmac);
            if (option instanceof Some) {
                DelegationToken token = (DelegationToken)((Some)option).value();
                TokenInformation tokenInfo = token.tokenInfo();
                long now = this.time().milliseconds();
                if (!this.allowedToRenew(principal, tokenInfo)) {
                    BoxedUnit cfr_ignored_0 = (BoxedUnit)expireResponseCallback.apply((Object)Errors.DELEGATION_TOKEN_OWNER_MISMATCH, (Object)BoxesRunTime.boxToLong((long)-1L));
                } else if (expireLifeTimeMs < 0L) {
                    this.removeToken(tokenInfo.tokenId());
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Token expired for token: ").append(tokenInfo.tokenId()).append(" for owner: ").append(tokenInfo.owner()).toString());
                    BoxedUnit cfr_ignored_1 = (BoxedUnit)expireResponseCallback.apply((Object)Errors.NONE, (Object)BoxesRunTime.boxToLong((long)now));
                } else if (tokenInfo.maxTimestamp() < now || tokenInfo.expiryTimestamp() < now) {
                    BoxedUnit cfr_ignored_2 = (BoxedUnit)expireResponseCallback.apply((Object)Errors.DELEGATION_TOKEN_EXPIRED, (Object)BoxesRunTime.boxToLong((long)-1L));
                } else {
                    long expiryTimeStamp = Math.min(tokenInfo.maxTimestamp(), now + expireLifeTimeMs);
                    tokenInfo.setExpiryTimestamp(expiryTimeStamp);
                    this.updateToken(token);
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Updated expiry time for token: ").append(tokenInfo.tokenId()).append(" for owner: ").append(tokenInfo.owner()).toString());
                    BoxedUnit cfr_ignored_3 = (BoxedUnit)expireResponseCallback.apply((Object)Errors.NONE, (Object)BoxesRunTime.boxToLong((long)expiryTimeStamp));
                }
            } else if (None$.MODULE$.equals(option)) {
                BoxedUnit cfr_ignored_4 = (BoxedUnit)expireResponseCallback.apply((Object)Errors.DELEGATION_TOKEN_NOT_FOUND, (Object)BoxesRunTime.boxToLong((long)-1L));
            } else {
                throw new MatchError(option);
            }
            return;
        }
    }

    private void removeToken(String tokenId) {
        this.zkClient().deleteDelegationToken(tokenId);
        this.kafka$server$DelegationTokenManager$$removeCache(tokenId);
        this.zkClient().createTokenChangeNotification(tokenId);
    }

    public void kafka$server$DelegationTokenManager$$removeCache(String tokenId) {
        this.tokenCache().removeCache(tokenId);
    }

    public void expireTokens() {
        Object object = this.kafka$server$DelegationTokenManager$$lock();
        synchronized (object) {
            this.getAllTokenInformation().foreach((Function1 & Serializable & scala.Serializable)tokenInfo -> {
                DelegationTokenManager.$anonfun$expireTokens$1(this, tokenInfo);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public List<TokenInformation> getAllTokenInformation() {
        return ((TraversableOnce)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(this.tokenCache().tokens()).asScala()).toList();
    }

    public List<DelegationToken> getTokens(Function1<TokenInformation, Object> filterToken) {
        return (List)((List)this.getAllTokenInformation().filter(filterToken)).map((Function1 & Serializable & scala.Serializable)token -> this.getToken((TokenInformation)token), List$.MODULE$.canBuildFrom());
    }

    private final void TokenChangedNotificationHandler$lzycompute$1() {
        synchronized (this) {
            if (this.TokenChangedNotificationHandler$module == null) {
                this.TokenChangedNotificationHandler$module = new DelegationTokenManager$TokenChangedNotificationHandler$(this);
            }
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$loadCache$2(DelegationTokenManager $this, String tokenId) {
        try {
            Option<DelegationToken> option = $this.kafka$server$DelegationTokenManager$$getTokenFromZk(tokenId);
            if (option instanceof Some) {
                DelegationToken token = (DelegationToken)((Some)option).value();
                $this.kafka$server$DelegationTokenManager$$updateCache(token);
            } else if (!None$.MODULE$.equals(option)) {
                throw new MatchError(option);
            }
        }
        catch (Throwable ex) {
            $this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Error while getting Token for tokenId: ").append(tokenId).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> ex);
        }
    }

    private static final ScramCredential scramCredential$1(ScramMechanism mechanism, String hmacString$1) {
        return new ScramFormatter(mechanism).generateCredential(hmacString$1, mechanism.minIterations());
    }

    public static final /* synthetic */ void $anonfun$expireTokens$1(DelegationTokenManager $this, TokenInformation tokenInfo) {
        long now = $this.time().milliseconds();
        if (tokenInfo.maxTimestamp() < now || tokenInfo.expiryTimestamp() < now) {
            $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("Delegation token expired for token: ").append(tokenInfo.tokenId()).append(" for owner: ").append(tokenInfo.owner()).toString());
            $this.removeToken(tokenInfo.tokenId());
        }
    }

    public DelegationTokenManager(KafkaConfig config, DelegationTokenCache tokenCache, Time time, KafkaZkClient zkClient) {
        this.config = config;
        this.tokenCache = tokenCache;
        this.time = time;
        this.zkClient = zkClient;
        Logging.$init$(this);
        this.logIdent_$eq(new StringBuilder(28).append("[Token Manager on Broker ").append(config.brokerId()).append("]: ").toString());
        byte[] keyBytes = config.tokenAuthEnabled() ? config.delegationTokenSecretKey().value().getBytes(StandardCharsets.UTF_8) : null;
        this.secretKey = keyBytes == null || new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(keyBytes)).isEmpty() ? null : DelegationTokenManager$.MODULE$.createSecretKey(keyBytes);
        this.tokenMaxLifetime = Predef$.MODULE$.Long2long(config.delegationTokenMaxLifeMs());
        this.defaultTokenRenewTime = Predef$.MODULE$.Long2long(config.delegationTokenExpiryTimeMs());
        this.tokenRemoverScanInterval = Predef$.MODULE$.Long2long(config.delegationTokenExpiryCheckIntervalMs());
        this.kafka$server$DelegationTokenManager$$lock = new Object();
    }
}

