/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.utils.KafkaScheduler$;
import kafka.utils.Logging;
import kafka.utils.NoOpScheduledFutureTask;
import kafka.utils.Scheduler;
import org.apache.kafka.common.utils.KafkaThread;
import scala.Function0;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Ed\u0001\u0002\r\u001a\u0001yA\u0001\u0002\f\u0001\u0003\u0006\u0004%\t!\f\u0005\tc\u0001\u0011\t\u0011)A\u0005]!A!\u0007\u0001BC\u0002\u0013\u00051\u0007\u0003\u0005@\u0001\t\u0005\t\u0015!\u00035\u0011!\u0001\u0005A!A!\u0002\u0013\t\u0005\"\u0002#\u0001\t\u0003)\u0005\"\u0003&\u0001\u0001\u0004\u0005\r\u0011\"\u0003L\u0011%1\u0006\u00011AA\u0002\u0013%q\u000bC\u0005^\u0001\u0001\u0007\t\u0011)Q\u0005\u0019\"9a\f\u0001b\u0001\n\u0013y\u0006B\u00024\u0001A\u0003%\u0001\rC\u0003h\u0001\u0011\u0005\u0003\u000eC\u0003j\u0001\u0011\u0005\u0003\u000eC\u0003k\u0001\u0011\u00051\u000eC\u0003t\u0001\u0011\u0005A\u000f\u0003\u0005\u0002&\u0001!\taGA\u0014\u0011\u001d\t9\u0004\u0001C\u0001\u0003sAq!a\u0010\u0001\t\u0003\t\teB\u0005\u0002Le\t\t\u0011#\u0001\u0002N\u0019A\u0001$GA\u0001\u0012\u0003\ty\u0005\u0003\u0004E)\u0011\u0005\u0011\u0011\u000b\u0005\n\u0003'\"\u0012\u0013!C\u0001\u0003+B\u0011\"a\u001b\u0015#\u0003%\t!!\u001c\u0003\u001d-\u000bgm[1TG\",G-\u001e7fe*\u0011!dG\u0001\u0006kRLGn\u001d\u0006\u00029\u0005)1.\u00194lC\u000e\u00011\u0003\u0002\u0001 K%\u0002\"\u0001I\u0012\u000e\u0003\u0005R\u0011AI\u0001\u0006g\u000e\fG.Y\u0005\u0003I\u0005\u0012a!\u00118z%\u00164\u0007C\u0001\u0014(\u001b\u0005I\u0012B\u0001\u0015\u001a\u0005%\u00196\r[3ek2,'\u000f\u0005\u0002'U%\u00111&\u0007\u0002\b\u0019><w-\u001b8h\u0003\u001d!\bN]3bIN,\u0012A\f\t\u0003A=J!\u0001M\u0011\u0003\u0007%sG/\u0001\u0005uQJ,\u0017\rZ:!\u0003A!\bN]3bI:\u000bW.\u001a)sK\u001aL\u00070F\u00015!\t)DH\u0004\u00027uA\u0011q'I\u0007\u0002q)\u0011\u0011(H\u0001\u0007yI|w\u000e\u001e \n\u0005m\n\u0013A\u0002)sK\u0012,g-\u0003\u0002>}\t11\u000b\u001e:j]\u001eT!aO\u0011\u0002#QD'/Z1e\u001d\u0006lW\r\u0015:fM&D\b%\u0001\u0004eC\u0016lwN\u001c\t\u0003A\tK!aQ\u0011\u0003\u000f\t{w\u000e\\3b]\u00061A(\u001b8jiz\"BAR$I\u0013B\u0011a\u0005\u0001\u0005\u0006Y\u0019\u0001\rA\f\u0005\be\u0019\u0001\n\u00111\u00015\u0011\u001d\u0001e\u0001%AA\u0002\u0005\u000b\u0001\"\u001a=fGV$xN]\u000b\u0002\u0019B\u0011Q\nV\u0007\u0002\u001d*\u0011q\nU\u0001\u000bG>t7-\u001e:sK:$(BA)S\u0003\u0011)H/\u001b7\u000b\u0003M\u000bAA[1wC&\u0011QK\u0014\u0002\u001c'\u000eDW\rZ;mK\u0012$\u0006N]3bIB{w\u000e\\#yK\u000e,Ho\u001c:\u0002\u0019\u0015DXmY;u_J|F%Z9\u0015\u0005a[\u0006C\u0001\u0011Z\u0013\tQ\u0016E\u0001\u0003V]&$\bb\u0002/\t\u0003\u0003\u0005\r\u0001T\u0001\u0004q\u0012\n\u0014!C3yK\u000e,Ho\u001c:!\u0003E\u00198\r[3ek2,'\u000f\u00165sK\u0006$\u0017\nZ\u000b\u0002AB\u0011\u0011\rZ\u0007\u0002E*\u00111MT\u0001\u0007CR|W.[2\n\u0005\u0015\u0014'!D!u_6L7-\u00138uK\u001e,'/\u0001\ntG\",G-\u001e7feRC'/Z1e\u0013\u0012\u0004\u0013aB:uCJ$X\u000f\u001d\u000b\u00021\u0006A1\u000f[;uI><h.\u0001\u0007tG\",G-\u001e7f\u001f:\u001cW\rF\u0002YY:DQ!\u001c\bA\u0002Q\nAA\\1nK\")qN\u0004a\u0001a\u0006\u0019a-\u001e8\u0011\u0007\u0001\n\b,\u0003\u0002sC\tIa)\u001e8di&|g\u000eM\u0001\tg\u000eDW\rZ;mKRYQ/!\u0003\u0002\f\u00055\u0011qCA\u000ea\t18\u0010E\u0002NofL!\u0001\u001f(\u0003\u001fM\u001b\u0007.\u001a3vY\u0016$g)\u001e;ve\u0016\u0004\"A_>\r\u0001\u0011IApDA\u0001\u0002\u0003\u0015\t! \u0002\u0004?\u0012\u0012\u0014c\u0001@\u0002\u0004A\u0011\u0001e`\u0005\u0004\u0003\u0003\t#a\u0002(pi\"Lgn\u001a\t\u0004A\u0005\u0015\u0011bAA\u0004C\t\u0019\u0011I\\=\t\u000b5|\u0001\u0019\u0001\u001b\t\u000b=|\u0001\u0019\u00019\t\u0013\u0005=q\u0002%AA\u0002\u0005E\u0011!\u00023fY\u0006L\bc\u0001\u0011\u0002\u0014%\u0019\u0011QC\u0011\u0003\t1{gn\u001a\u0005\n\u00033y\u0001\u0013!a\u0001\u0003#\ta\u0001]3sS>$\u0007\"CA\u000f\u001fA\u0005\t\u0019AA\u0010\u0003\u0011)h.\u001b;\u0011\u00075\u000b\t#C\u0002\u0002$9\u0013\u0001\u0002V5nKVs\u0017\u000e^\u0001\fi\u0006\u001c8NU;o]&tw\rF\u0002B\u0003SAq!a\u000b\u0011\u0001\u0004\ti#\u0001\u0003uCN\\\u0007\u0007BA\u0018\u0003g\u0001B!T<\u00022A\u0019!0a\r\u0005\u0017\u0005U\u0012\u0011FA\u0001\u0002\u0003\u0015\t! \u0002\u0004?\u0012\u001a\u0014\u0001\u0005:fg&TX\r\u00165sK\u0006$\u0007k\\8m)\rA\u00161\b\u0005\u0007\u0003{\t\u0002\u0019\u0001\u0018\u0002\u000f9,woU5{K\u0006I\u0011n]*uCJ$X\rZ\u000b\u0002\u0003\"\u001a\u0001!!\u0012\u0011\u0007\u0019\n9%C\u0002\u0002Je\u0011!\u0002\u001e5sK\u0006$7/\u00194f\u00039Y\u0015MZ6b'\u000eDW\rZ;mKJ\u0004\"A\n\u000b\u0014\u0005QyBCAA'\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011q\u000b\u0016\u0004i\u0005e3FAA.!\u0011\ti&a\u001a\u000e\u0005\u0005}#\u0002BA1\u0003G\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\u0015\u0014%\u0001\u0006b]:|G/\u0019;j_:LA!!\u001b\u0002`\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00134+\t\tyGK\u0002B\u00033\u0002")
public class KafkaScheduler
implements Scheduler,
Logging {
    private final int threads;
    private final String threadNamePrefix;
    private final boolean daemon;
    private ScheduledThreadPoolExecutor executor;
    private final AtomicInteger schedulerThreadId;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static boolean $lessinit$greater$default$3() {
        return KafkaScheduler$.MODULE$.$lessinit$greater$default$3();
    }

    public static String $lessinit$greater$default$2() {
        return KafkaScheduler$.MODULE$.$lessinit$greater$default$2();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    @Override
    public long schedule$default$3() {
        return Scheduler.schedule$default$3$(this);
    }

    @Override
    public long schedule$default$4() {
        return Scheduler.schedule$default$4$(this);
    }

    @Override
    public TimeUnit schedule$default$5() {
        return Scheduler.schedule$default$5$(this);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public int threads() {
        return this.threads;
    }

    public String threadNamePrefix() {
        return this.threadNamePrefix;
    }

    private ScheduledThreadPoolExecutor executor() {
        return this.executor;
    }

    private void executor_$eq(ScheduledThreadPoolExecutor x$1) {
        this.executor = x$1;
    }

    private AtomicInteger schedulerThreadId() {
        return this.schedulerThreadId;
    }

    @Override
    public void startup() {
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Initializing task scheduler.");
        synchronized (this) {
            if (this.isStarted()) {
                throw new IllegalStateException("This scheduler has already been started!");
            }
            this.executor_$eq(new ScheduledThreadPoolExecutor(this.threads()));
            this.executor().setContinueExistingPeriodicTasksAfterShutdownPolicy(false);
            this.executor().setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
            this.executor().setRemoveOnCancelPolicy(true);
            this.executor().setThreadFactory(runnable -> new KafkaThread(new StringBuilder(0).append(this.threadNamePrefix()).append(this.schedulerThreadId().getAndIncrement()).toString(), runnable, $this.daemon));
            return;
        }
    }

    @Override
    public void shutdown() {
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Shutting down task scheduler.");
        ScheduledThreadPoolExecutor cachedExecutor = this.executor();
        if (cachedExecutor != null) {
            synchronized (this) {
                cachedExecutor.shutdown();
                this.executor_$eq(null);
            }
            cachedExecutor.awaitTermination(1L, TimeUnit.DAYS);
        }
    }

    public void scheduleOnce(String name, Function0<BoxedUnit> fun) {
        this.schedule(name, fun, 0L, -1L, TimeUnit.MILLISECONDS);
    }

    @Override
    public ScheduledFuture<?> schedule(String name, Function0<BoxedUnit> fun, long delay, long period, TimeUnit unit) {
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Scheduling task %s with initial delay %d ms and period %d ms.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name, BoxesRunTime.boxToLong((long)TimeUnit.MILLISECONDS.convert(delay, unit)), BoxesRunTime.boxToLong((long)TimeUnit.MILLISECONDS.convert(period, unit))})));
        synchronized (this) {
            ScheduledFuture<BoxedUnit> scheduledFuture;
            if (this.isStarted()) {
                Runnable runnable = () -> {
                    try {
                        try {
                            this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Beginning execution of scheduled task '%s'.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name})));
                            fun.apply$mcV$sp();
                        }
                        catch (Throwable t) {
                            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Uncaught exception in scheduled task '").append(name).append("'").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> t);
                        }
                    }
                    finally {
                        this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Completed execution of scheduled task '%s'.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name})));
                    }
                };
                scheduledFuture = period > 0L ? this.executor().scheduleAtFixedRate(runnable, delay, period, unit) : this.executor().schedule(runnable, delay, unit);
            } else {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Kafka scheduler is not running at the time task '%s' is scheduled. The task is ignored.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name})));
                scheduledFuture = new NoOpScheduledFutureTask();
            }
            NoOpScheduledFutureTask noOpScheduledFutureTask = scheduledFuture;
            return noOpScheduledFutureTask;
        }
    }

    public boolean taskRunning(ScheduledFuture<?> task) {
        return this.executor().getQueue().contains(task);
    }

    public void resizeThreadPool(int newSize) {
        this.executor().setCorePoolSize(newSize);
    }

    @Override
    public synchronized boolean isStarted() {
        return this.executor() != null;
    }

    public KafkaScheduler(int threads, String threadNamePrefix, boolean daemon) {
        this.threads = threads;
        this.threadNamePrefix = threadNamePrefix;
        this.daemon = daemon;
        Logging.$init$(this);
        this.schedulerThreadId = new AtomicInteger(0);
    }
}

