/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Properties;
import kafka.controller.KafkaController;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.server.ConfigHandler;
import kafka.server.Constants$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.QuotaFactory;
import kafka.server.ReplicationQuotaManager;
import kafka.server.ThrottledReplicaListValidator$;
import kafka.utils.Implicits$;
import kafka.utils.Implicits$MapExtensionMethods$;
import kafka.utils.Logging;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.compat.MapExtensionMethods$;
import scala.collection.compat.package$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005\ra\u0001B\u0006\r\u0001EA\u0001B\t\u0001\u0003\u0006\u0004%Ia\t\u0005\tU\u0001\u0011\t\u0011)A\u0005I!A1\u0006\u0001B\u0001B\u0003%A\u0006\u0003\u00050\u0001\t\u0015\r\u0011\"\u00011\u0011!y\u0004A!A!\u0002\u0013\t\u0004\u0002\u0003!\u0001\u0005\u0003\u0005\u000b\u0011B!\t\u000b)\u0003A\u0011A&\t\u000bE\u0003A\u0011\u0001*\t\u000b)\u0004A\u0011A6\t\u000bi\u0004A\u0011A>\u0003%Q{\u0007/[2D_:4\u0017n\u001a%b]\u0012dWM\u001d\u0006\u0003\u001b9\taa]3sm\u0016\u0014(\"A\b\u0002\u000b-\fgm[1\u0004\u0001M!\u0001A\u0005\r\u001d!\t\u0019b#D\u0001\u0015\u0015\u0005)\u0012!B:dC2\f\u0017BA\f\u0015\u0005\u0019\te.\u001f*fMB\u0011\u0011DG\u0007\u0002\u0019%\u00111\u0004\u0004\u0002\u000e\u0007>tg-[4IC:$G.\u001a:\u0011\u0005u\u0001S\"\u0001\u0010\u000b\u0005}q\u0011!B;uS2\u001c\u0018BA\u0011\u001f\u0005\u001daunZ4j]\u001e\f!\u0002\\8h\u001b\u0006t\u0017mZ3s+\u0005!\u0003CA\u0013)\u001b\u00051#BA\u0014\u000f\u0003\rawnZ\u0005\u0003S\u0019\u0012!\u0002T8h\u001b\u0006t\u0017mZ3s\u0003-awnZ'b]\u0006<WM\u001d\u0011\u0002\u0017-\fgm[1D_:4\u0017n\u001a\t\u000335J!A\f\u0007\u0003\u0017-\u000bgm[1D_:4\u0017nZ\u0001\u0007cV|G/Y:\u0016\u0003E\u0002\"A\r\u001f\u000f\u0005MRdB\u0001\u001b:\u001d\t)\u0004(D\u00017\u0015\t9\u0004#\u0001\u0004=e>|GOP\u0005\u0002\u001f%\u0011QBD\u0005\u0003w1\tA\"U;pi\u00064\u0015m\u0019;pefL!!\u0010 \u0003\u001bE+x\u000e^1NC:\fw-\u001a:t\u0015\tYD\"A\u0004rk>$\u0018m\u001d\u0011\u0002\u001f-\fgm[1D_:$(o\u001c7mKJ\u00042a\u0005\"E\u0013\t\u0019EC\u0001\u0004PaRLwN\u001c\t\u0003\u000b\"k\u0011A\u0012\u0006\u0003\u000f:\t!bY8oiJ|G\u000e\\3s\u0013\tIeIA\bLC\u001a\\\u0017mQ8oiJ|G\u000e\\3s\u0003\u0019a\u0014N\\5u}Q)A*\u0014(P!B\u0011\u0011\u0004\u0001\u0005\u0006E\u001d\u0001\r\u0001\n\u0005\u0006W\u001d\u0001\r\u0001\f\u0005\u0006_\u001d\u0001\r!\r\u0005\u0006\u0001\u001e\u0001\r!Q\u0001\u0015aJ|7-Z:t\u0007>tg-[4DQ\u0006tw-Z:\u0015\u0007M3\u0006\r\u0005\u0002\u0014)&\u0011Q\u000b\u0006\u0002\u0005+:LG\u000fC\u0003X\u0011\u0001\u0007\u0001,A\u0003u_BL7\r\u0005\u0002Z;:\u0011!l\u0017\t\u0003kQI!\u0001\u0018\u000b\u0002\rA\u0013X\rZ3g\u0013\tqvL\u0001\u0004TiJLgn\u001a\u0006\u00039RAQ!\u0019\u0005A\u0002\t\f1\u0002^8qS\u000e\u001cuN\u001c4jOB\u00111\r[\u0007\u0002I*\u0011QMZ\u0001\u0005kRLGNC\u0001h\u0003\u0011Q\u0017M^1\n\u0005%$'A\u0003)s_B,'\u000f^5fg\u0006A\u0002/\u0019:tKRC'o\u001c;uY\u0016$\u0007+\u0019:uSRLwN\\:\u0015\t1,h\u000f\u001f\t\u0004[B\u0014X\"\u00018\u000b\u0005=$\u0012AC2pY2,7\r^5p]&\u0011\u0011O\u001c\u0002\u0004'\u0016\f\bCA\nt\u0013\t!HCA\u0002J]RDQ!Y\u0005A\u0002\tDQa^\u0005A\u0002I\f\u0001B\u0019:pW\u0016\u0014\u0018\n\u001a\u0005\u0006s&\u0001\r\u0001W\u0001\u0005aJ|\u0007/A\bfq\u000edW\u000fZ3e\u0007>tg-[4t)\u0011ax0!\u0001\u0011\u0007ek\b,\u0003\u0002\u007f?\n\u00191+\u001a;\t\u000b]S\u0001\u0019\u0001-\t\u000b\u0005T\u0001\u0019\u00012")
public class TopicConfigHandler
implements ConfigHandler,
Logging {
    private final LogManager logManager;
    private final KafkaConfig kafkaConfig;
    private final QuotaFactory.QuotaManagers quotas;
    private final Option<KafkaController> kafkaController;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private LogManager logManager() {
        return this.logManager;
    }

    public QuotaFactory.QuotaManagers quotas() {
        return this.quotas;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void processConfigChanges(String topic, Properties topicConfig) {
        void forKeyValue$extension_f;
        void forKeyValue$extension_$this;
        Set<String> configNamesToExclude = this.excludedConfigs(topic, topicConfig);
        Properties props = new Properties();
        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(key, value) -> {
            if (!configNamesToExclude.contains(key)) {
                return props.put(key, value);
            }
            return BoxedUnit.UNIT;
        };
        Map map = Implicits$.MODULE$.MapExtensionMethods((Map)CollectionConverters$.MODULE$.propertiesAsScalaMapConverter(topicConfig).asScala());
        if (Implicits$MapExtensionMethods$.MODULE$ == null) {
            throw null;
        }
        MapExtensionMethods$.MODULE$.foreachEntry$extension(package$.MODULE$.toMapExtensionMethods((Map)forKeyValue$extension_$this), (arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f, arg_0, arg_1));
        this.logManager().updateTopicConfig(topic, props);
        this.updateThrottledList$1(LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp(), this.quotas().leader(), topicConfig, topic);
        this.updateThrottledList$1(LogConfig$.MODULE$.FollowerReplicationThrottledReplicasProp(), this.quotas().follower(), topicConfig, topic);
        if (BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(topicConfig.getProperty(KafkaConfig$.MODULE$.UncleanLeaderElectionEnableProp()))).toBoolean()).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false))) {
            this.kafkaController.foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                x$1.enableTopicUncleanLeaderElection(topic);
                return BoxedUnit.UNIT;
            });
        }
    }

    public Seq<Object> parseThrottledPartitions(Properties topicConfig, int brokerId, String prop) {
        String configValue = topicConfig.get(prop).toString().trim();
        ThrottledReplicaListValidator$.MODULE$.ensureValidString(prop, configValue);
        Seq seq = "".equals(configValue) ? Nil$.MODULE$ : ("*".equals(configValue) ? Constants$.MODULE$.AllReplicas() : new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])configValue.trim().split(","))).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.split(":"), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)))))).filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)TopicConfigHandler.$anonfun$parseThrottledPartitions$2(brokerId, x$3))))).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)TopicConfigHandler.$anonfun$parseThrottledPartitions$3(x$4)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())))).toSeq());
        return seq;
    }

    public Set<String> excludedConfigs(String topic, Properties topicConfig) {
        return Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)topicConfig.getProperty(LogConfig$.MODULE$.MessageFormatVersionProp())).flatMap((Function1 & Serializable & scala.Serializable)versionString -> {
            LogConfig.MessageFormatVersion messageFormatVersion = new LogConfig.MessageFormatVersion((String)versionString, $this.kafkaConfig.interBrokerProtocolVersion().version());
            if (messageFormatVersion.shouldIgnore()) {
                if (messageFormatVersion.shouldWarn()) {
                    this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> messageFormatVersion.topicWarningMessage(topic));
                }
                return new Some((Object)LogConfig$.MODULE$.MessageFormatVersionProp());
            }
            if ($this.kafkaConfig.interBrokerProtocolVersion().isLessThan(messageFormatVersion.messageFormatVersion())) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(120).append("Topic configuration ").append(LogConfig$.MODULE$.MessageFormatVersionProp()).append(" is ignored for `").append(topic).append("` because `").append((String)versionString).append("` ").append("is higher than what is allowed by the inter-broker protocol version `").append($this.kafkaConfig.interBrokerProtocolVersionString()).append("`").toString());
                return new Some((Object)LogConfig$.MODULE$.MessageFormatVersionProp());
            }
            return None$.MODULE$;
        })).toSet();
    }

    private final void updateThrottledList$1(String prop, ReplicationQuotaManager quotaManager, Properties topicConfig$1, String topic$1) {
        if (topicConfig$1.containsKey(prop) && new StringOps(Predef$.MODULE$.augmentString(topicConfig$1.getProperty(prop))).nonEmpty()) {
            Seq<Object> partitions = this.parseThrottledPartitions(topicConfig$1, this.kafkaConfig.brokerId(), prop);
            quotaManager.markThrottled(topic$1, partitions);
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append("Setting ").append(prop).append(" on broker ").append($this.kafkaConfig.brokerId()).append(" for topic: ").append(topic$1).append(" and partitions ").append(partitions).toString());
            return;
        }
        quotaManager.removeThrottle(topic$1);
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Removing ").append(prop).append(" from broker ").append($this.kafkaConfig.brokerId()).append(" for topic ").append(topic$1).toString());
    }

    public static final /* synthetic */ boolean $anonfun$parseThrottledPartitions$2(int brokerId$1, String[] x$3) {
        return new StringOps(Predef$.MODULE$.augmentString(x$3[1])).toInt() == brokerId$1;
    }

    public static final /* synthetic */ int $anonfun$parseThrottledPartitions$3(String[] x$4) {
        return new StringOps(Predef$.MODULE$.augmentString(x$4[0])).toInt();
    }

    public TopicConfigHandler(LogManager logManager, KafkaConfig kafkaConfig, QuotaFactory.QuotaManagers quotas, Option<KafkaController> kafkaController) {
        this.logManager = logManager;
        this.kafkaConfig = kafkaConfig;
        this.quotas = quotas;
        this.kafkaController = kafkaController;
        Logging.$init$(this);
    }
}

