/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.OptionalLong;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import kafka.cluster.Broker;
import kafka.cluster.EndPoint;
import kafka.metrics.KafkaMetricsGroup;
import kafka.metrics.LinuxIoMetricsCollector;
import kafka.migration.MigrationPropagator;
import kafka.network.DataPlaneAcceptor$;
import kafka.network.SocketServer;
import kafka.raft.KafkaRaftManager;
import kafka.security.CredentialProvider;
import kafka.server.ControllerApis;
import kafka.server.ControllerConfigurationValidator;
import kafka.server.ControllerMigrationSupport;
import kafka.server.DynamicMetricReporterState;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaRaftServer$BrokerRole$;
import kafka.server.KafkaRequestHandlerPool;
import kafka.server.KafkaServer$;
import kafka.server.QuotaFactory;
import kafka.server.QuotaFactory$;
import kafka.server.Server;
import kafka.server.Server$SHUTDOWN$;
import kafka.server.Server$SHUTTING_DOWN$;
import kafka.server.Server$STARTED$;
import kafka.server.Server$STARTING$;
import kafka.server.SharedServer;
import kafka.server.SimpleApiVersionManager;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.zk.KafkaZkClient;
import kafka.zk.KafkaZkClient$;
import kafka.zk.ZkMigrationClient;
import org.apache.kafka.clients.ApiVersions;
import org.apache.kafka.common.ClusterResource;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.message.ApiMessageType;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.security.scram.internals.ScramMechanism;
import org.apache.kafka.common.security.token.delegation.internals.DelegationTokenCache;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.controller.ConfigurationValidator;
import org.apache.kafka.controller.Controller;
import org.apache.kafka.controller.ControllerMetrics;
import org.apache.kafka.controller.QuorumController;
import org.apache.kafka.controller.QuorumFeatures;
import org.apache.kafka.metadata.KafkaConfigSchema;
import org.apache.kafka.metadata.authorizer.ClusterMetadataAuthorizer;
import org.apache.kafka.metadata.bootstrap.BootstrapMetadata;
import org.apache.kafka.metadata.migration.KRaftMigrationDriver;
import org.apache.kafka.metadata.migration.LegacyPropagator;
import org.apache.kafka.metadata.migration.MigrationClient;
import org.apache.kafka.raft.RaftConfig;
import org.apache.kafka.server.authorizer.Authorizer;
import org.apache.kafka.server.authorizer.AuthorizerServerInfo;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.apache.kafka.server.policy.AlterConfigPolicy;
import org.apache.kafka.server.policy.CreateTopicPolicy;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set$;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\r=a\u0001B\"E\u0001%C\u0001\u0002\u0018\u0001\u0003\u0006\u0004%\t!\u0018\u0005\tE\u0002\u0011\t\u0011)A\u0005=\"A1\r\u0001BC\u0002\u0013\u0005A\r\u0003\u0005q\u0001\t\u0005\t\u0015!\u0003f\u0011!\t\bA!b\u0001\n\u0003\u0011\b\u0002C=\u0001\u0005\u0003\u0005\u000b\u0011B:\t\u000bi\u0004A\u0011A>\t\u0013\u0005\u0005\u0001A1A\u0005\u0002\u0005\r\u0001\u0002CA\u0006\u0001\u0001\u0006I!!\u0002\t\u0013\u00055\u0001A1A\u0005\u0002\u0005=\u0001\u0002CA\u0010\u0001\u0001\u0006I!!\u0005\t\re\u0003A\u0011AA\u0011\u0011%\ti\u0003\u0001b\u0001\n\u0003\ty\u0003\u0003\u0005\u0002H\u0001\u0001\u000b\u0011BA\u0019\u0011\u001d\tI\u0005\u0001C\u0001\u0003\u0017B\u0011\"!\u001a\u0001\u0005\u0004%\t!a\u001a\t\u0011\u0005\u0005\u0005\u0001)A\u0005\u0003SB\u0011\"a!\u0001\u0005\u0004%\t!!\"\t\u0011\u00055\u0005\u0001)A\u0005\u0003\u000fC\u0011\"a$\u0001\u0001\u0004%\t!!%\t\u0013\u0005%\u0006\u00011A\u0005\u0002\u0005-\u0006\u0002CA\\\u0001\u0001\u0006K!a%\t\u0017\u0005e\u0006\u00011AA\u0002\u0013\u0005\u00111\u0018\u0005\f\u0003\u0007\u0004\u0001\u0019!a\u0001\n\u0003\t)\rC\u0006\u0002J\u0002\u0001\r\u0011!Q!\n\u0005u\u0006\"CAf\u0001\u0001\u0007I\u0011AAg\u0011%\ty\u000e\u0001a\u0001\n\u0003\t\t\u000f\u0003\u0005\u0002f\u0002\u0001\u000b\u0015BAh\u0011-\ty\u000f\u0001a\u0001\u0002\u0004%\t!!=\t\u0017\t-\u0001\u00011AA\u0002\u0013\u0005!Q\u0002\u0005\f\u0005#\u0001\u0001\u0019!A!B\u0013\t\u0019\u0010C\u0006\u0003\u0014\u0001\u0001\r\u00111A\u0005\u0002\tU\u0001b\u0003B\u0011\u0001\u0001\u0007\t\u0019!C\u0001\u0005GA1Ba\n\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0003\u0018!Y!\u0011\u0006\u0001A\u0002\u0003\u0007I\u0011\u0001B\u0016\u0011-\u0011I\u0004\u0001a\u0001\u0002\u0004%\tAa\u000f\t\u0017\t}\u0002\u00011A\u0001B\u0003&!Q\u0006\u0005\n\u0005\u0003\u0002!\u0019!C\u0001\u0005\u0007B\u0001B!\u0017\u0001A\u0003%!Q\t\u0005\n\u00057\u0002\u0001\u0019!C\u0001\u0005;B\u0011B!\u001c\u0001\u0001\u0004%\tAa\u001c\t\u0011\tM\u0004\u0001)Q\u0005\u0005?B\u0011B!\u001e\u0001\u0001\u0004%\tAa\u001e\t\u0013\t\u0005\u0005\u00011A\u0005\u0002\t\r\u0005\u0002\u0003BD\u0001\u0001\u0006KA!\u001f\t\u0017\t%\u0005\u00011AA\u0002\u0013\u0005!1\u0012\u0005\f\u0005/\u0003\u0001\u0019!a\u0001\n\u0003\u0011I\nC\u0006\u0003\u001e\u0002\u0001\r\u0011!Q!\n\t5\u0005b\u0003BP\u0001\u0001\u0007\t\u0019!C\u0001\u0005CC1B!-\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u00034\"Y!q\u0017\u0001A\u0002\u0003\u0005\u000b\u0015\u0002BR\u0011-\u0011I\f\u0001a\u0001\u0002\u0004%\tAa/\t\u0017\t\r\u0007\u00011AA\u0002\u0013\u0005!Q\u0019\u0005\f\u0005\u0013\u0004\u0001\u0019!A!B\u0013\u0011i\fC\u0006\u0003L\u0002\u0001\r\u00111A\u0005\u0002\t5\u0007b\u0003Bk\u0001\u0001\u0007\t\u0019!C\u0001\u0005/D1Ba7\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0003P\"I!Q\u001c\u0001A\u0002\u0013\u0005!q\u001c\u0005\n\u0005S\u0004\u0001\u0019!C\u0001\u0005WD\u0001Ba<\u0001A\u0003&!\u0011\u001d\u0005\b\u0005c\u0004A\u0011\u0002Bz\u0011\u001d\u0019\u0019\u0001\u0001C\u0005\u0007\u000bAqaa\u0002\u0001\t\u0003\ty\u0003C\u0004\u0004\n\u0001!\ta!\u0002\t\u000f\r-\u0001\u0001\"\u0001\u0004\u0006!91Q\u0002\u0001\u0005\u0002\r\u0015!\u0001E\"p]R\u0014x\u000e\u001c7feN+'O^3s\u0015\t)e)\u0001\u0004tKJ4XM\u001d\u0006\u0002\u000f\u0006)1.\u00194lC\u000e\u00011\u0003\u0002\u0001K!Z\u0003\"a\u0013(\u000e\u00031S\u0011!T\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001f2\u0013a!\u00118z%\u00164\u0007CA)U\u001b\u0005\u0011&BA*G\u0003\u0015)H/\u001b7t\u0013\t)&KA\u0004M_\u001e<\u0017N\\4\u0011\u0005]SV\"\u0001-\u000b\u0005e3\u0015aB7fiJL7m]\u0005\u00037b\u0013\u0011cS1gW\u0006lU\r\u001e:jGN<%o\\;q\u00031\u0019\b.\u0019:fIN+'O^3s+\u0005q\u0006CA0a\u001b\u0005!\u0015BA1E\u00051\u0019\u0006.\u0019:fIN+'O^3s\u00035\u0019\b.\u0019:fIN+'O^3sA\u0005a1m\u001c8gS\u001e\u001c6\r[3nCV\tQ\r\u0005\u0002g]6\tqM\u0003\u0002iS\u0006AQ.\u001a;bI\u0006$\u0018M\u0003\u0002HU*\u00111\u000e\\\u0001\u0007CB\f7\r[3\u000b\u00035\f1a\u001c:h\u0013\tywMA\tLC\u001a\\\u0017mQ8oM&<7k\u00195f[\u0006\fQbY8oM&<7k\u00195f[\u0006\u0004\u0013!\u00052p_R\u001cHO]1q\u001b\u0016$\u0018\rZ1uCV\t1\u000f\u0005\u0002uo6\tQO\u0003\u0002wO\u0006I!m\\8ugR\u0014\u0018\r]\u0005\u0003qV\u0014\u0011CQ8piN$(/\u00199NKR\fG-\u0019;b\u0003I\u0011wn\u001c;tiJ\f\u0007/T3uC\u0012\fG/\u0019\u0011\u0002\rqJg.\u001b;?)\u0011aXP`@\u0011\u0005}\u0003\u0001\"\u0002/\b\u0001\u0004q\u0006\"B2\b\u0001\u0004)\u0007\"B9\b\u0001\u0004\u0019\u0018AB2p]\u001aLw-\u0006\u0002\u0002\u0006A\u0019q,a\u0002\n\u0007\u0005%AIA\u0006LC\u001a\\\u0017mQ8oM&<\u0017aB2p]\u001aLw\rI\u0001\u0005i&lW-\u0006\u0002\u0002\u0012A!\u00111CA\u000e\u001b\t\t)BC\u0002T\u0003/Q1!!\u0007j\u0003\u0019\u0019w.\\7p]&!\u0011QDA\u000b\u0005\u0011!\u0016.\\3\u0002\u000bQLW.\u001a\u0011\u0016\u0005\u0005\r\u0002\u0003BA\u0013\u0003Si!!a\n\u000b\u0007e\u000b9\"\u0003\u0003\u0002,\u0005\u001d\"aB'fiJL7m]\u0001\u0011i\"\u0014X-\u00193OC6,\u0007K]3gSb,\"!!\r\u0011\t\u0005M\u0012\u0011\t\b\u0005\u0003k\ti\u0004E\u0002\u000281k!!!\u000f\u000b\u0007\u0005m\u0002*\u0001\u0004=e>|GOP\u0005\u0004\u0003\u007fa\u0015A\u0002)sK\u0012,g-\u0003\u0003\u0002D\u0005\u0015#AB*ue&twMC\u0002\u0002@1\u000b\u0011\u0003\u001e5sK\u0006$g*Y7f!J,g-\u001b=!\u0003-\u0011\u0018M\u001a;NC:\fw-\u001a:\u0016\u0005\u00055\u0003CBA(\u0003+\nI&\u0004\u0002\u0002R)\u0019\u00111\u000b$\u0002\tI\fg\r^\u0005\u0005\u0003/\n\tF\u0001\tLC\u001a\\\u0017MU1gi6\u000bg.Y4feB!\u00111LA1\u001b\t\tiF\u0003\u0003\u0002\u001a\u0005}#BA#j\u0013\u0011\t\u0019'!\u0018\u0003)\u0005\u0003\u0018.T3tg\u0006<W-\u00118e-\u0016\u00148/[8o\u0003\u0011awnY6\u0016\u0005\u0005%\u0004\u0003BA6\u0003{j!!!\u001c\u000b\t\u0005=\u0014\u0011O\u0001\u0006Y>\u001c7n\u001d\u0006\u0005\u0003g\n)(\u0001\u0006d_:\u001cWO\u001d:f]RTA!a\u001e\u0002z\u0005!Q\u000f^5m\u0015\t\tY(\u0001\u0003kCZ\f\u0017\u0002BA@\u0003[\u0012QBU3f]R\u0014\u0018M\u001c;M_\u000e\\\u0017!\u00027pG.\u0004\u0013!E1xC&$8\u000b[;uI><hnQ8oIV\u0011\u0011q\u0011\t\u0005\u0003W\nI)\u0003\u0003\u0002\f\u00065$!C\"p]\u0012LG/[8o\u0003I\tw/Y5u'\",H\u000fZ8x]\u000e{g\u000e\u001a\u0011\u0002\rM$\u0018\r^;t+\t\t\u0019\n\u0005\u0003\u0002\u0016\u0006\rf\u0002BAL\u0003?sA!!'\u0002\u001e:!\u0011qGAN\u0013\u00059\u0015BA#G\u0013\r\t\t\u000bR\u0001\u0007'\u0016\u0014h/\u001a:\n\t\u0005\u0015\u0016q\u0015\u0002\u000e!J|7-Z:t'R\fG/^:\u000b\u0007\u0005\u0005F)\u0001\u0006ti\u0006$Xo]0%KF$B!!,\u00024B\u00191*a,\n\u0007\u0005EFJ\u0001\u0003V]&$\b\"CA[+\u0005\u0005\t\u0019AAJ\u0003\rAH%M\u0001\bgR\fG/^:!\u0003]a\u0017N\\;y\u0013>lU\r\u001e:jGN\u001cu\u000e\u001c7fGR|'/\u0006\u0002\u0002>B\u0019q+a0\n\u0007\u0005\u0005\u0007LA\fMS:,\b0S8NKR\u0014\u0018nY:D_2dWm\u0019;pe\u0006YB.\u001b8vq&{W*\u001a;sS\u000e\u001c8i\u001c7mK\u000e$xN]0%KF$B!!,\u0002H\"I\u0011Q\u0017\r\u0002\u0002\u0003\u0007\u0011QX\u0001\u0019Y&tW\u000f_%p\u001b\u0016$(/[2t\u0007>dG.Z2u_J\u0004\u0013AC1vi\"|'/\u001b>feV\u0011\u0011q\u001a\t\u0006\u0017\u0006E\u0017Q[\u0005\u0004\u0003'd%AB(qi&|g\u000e\u0005\u0003\u0002X\u0006mWBAAm\u0015\u0011\tY-a\u0018\n\t\u0005u\u0017\u0011\u001c\u0002\u000b\u0003V$\bn\u001c:ju\u0016\u0014\u0018AD1vi\"|'/\u001b>fe~#S-\u001d\u000b\u0005\u0003[\u000b\u0019\u000fC\u0005\u00026n\t\t\u00111\u0001\u0002P\u0006Y\u0011-\u001e;i_JL'0\u001a:!Q\ra\u0012\u0011\u001e\t\u0004\u0017\u0006-\u0018bAAw\u0019\nAao\u001c7bi&dW-\u0001\u0006u_.,gnQ1dQ\u0016,\"!a=\u0011\t\u0005U(qA\u0007\u0003\u0003oTA!!?\u0002|\u0006I\u0011N\u001c;fe:\fGn\u001d\u0006\u0005\u0003{\fy0\u0001\u0006eK2,w-\u0019;j_:TAA!\u0001\u0003\u0004\u0005)Ao\\6f]*!!QAA\f\u0003!\u0019XmY;sSRL\u0018\u0002\u0002B\u0005\u0003o\u0014A\u0003R3mK\u001e\fG/[8o)>\\WM\\\"bG\",\u0017A\u0004;pW\u0016t7)Y2iK~#S-\u001d\u000b\u0005\u0003[\u0013y\u0001C\u0005\u00026z\t\t\u00111\u0001\u0002t\u0006YAo\\6f]\u000e\u000b7\r[3!\u0003I\u0019'/\u001a3f]RL\u0017\r\u001c)s_ZLG-\u001a:\u0016\u0005\t]\u0001\u0003\u0002B\r\u0005;i!Aa\u0007\u000b\u0007\t\u0015a)\u0003\u0003\u0003 \tm!AE\"sK\u0012,g\u000e^5bYB\u0013xN^5eKJ\fac\u0019:fI\u0016tG/[1m!J|g/\u001b3fe~#S-\u001d\u000b\u0005\u0003[\u0013)\u0003C\u0005\u00026\u0006\n\t\u00111\u0001\u0003\u0018\u0005\u00192M]3eK:$\u0018.\u00197Qe>4\u0018\u000eZ3sA\u0005a1o\\2lKR\u001cVM\u001d<feV\u0011!Q\u0006\t\u0005\u0005_\u0011)$\u0004\u0002\u00032)\u0019!1\u0007$\u0002\u000f9,Go^8sW&!!q\u0007B\u0019\u00051\u0019vnY6fiN+'O^3s\u0003A\u0019xnY6fiN+'O^3s?\u0012*\u0017\u000f\u0006\u0003\u0002.\nu\u0002\"CA[I\u0005\u0005\t\u0019\u0001B\u0017\u00035\u0019xnY6fiN+'O^3sA\u0005\u00013o\\2lKR\u001cVM\u001d<fe\u001aK'o\u001d;C_VtG\rU8si\u001a+H/\u001e:f+\t\u0011)\u0005\u0005\u0004\u0003H\t%#QJ\u0007\u0003\u0003cJAAa\u0013\u0002r\t\t2i\\7qY\u0016$\u0018M\u00197f\rV$XO]3\u0011\t\t=#QK\u0007\u0003\u0005#RAAa\u0015\u0002z\u0005!A.\u00198h\u0013\u0011\u00119F!\u0015\u0003\u000f%sG/Z4fe\u0006\t3o\\2lKR\u001cVM\u001d<fe\u001aK'o\u001d;C_VtG\rU8si\u001a+H/\u001e:fA\u0005\t2M]3bi\u0016$v\u000e]5d!>d\u0017nY=\u0016\u0005\t}\u0003#B&\u0002R\n\u0005\u0004\u0003\u0002B2\u0005Sj!A!\u001a\u000b\t\t\u001d\u0014qL\u0001\u0007a>d\u0017nY=\n\t\t-$Q\r\u0002\u0012\u0007J,\u0017\r^3U_BL7\rU8mS\u000eL\u0018!F2sK\u0006$X\rV8qS\u000e\u0004v\u000e\\5ds~#S-\u001d\u000b\u0005\u0003[\u0013\t\bC\u0005\u00026&\n\t\u00111\u0001\u0003`\u0005\u00112M]3bi\u0016$v\u000e]5d!>d\u0017nY=!\u0003E\tG\u000e^3s\u0007>tg-[4Q_2L7-_\u000b\u0003\u0005s\u0002RaSAi\u0005w\u0002BAa\u0019\u0003~%!!q\u0010B3\u0005E\tE\u000e^3s\u0007>tg-[4Q_2L7-_\u0001\u0016C2$XM]\"p]\u001aLw\rU8mS\u000eLx\fJ3r)\u0011\tiK!\"\t\u0013\u0005UF&!AA\u0002\te\u0014AE1mi\u0016\u00148i\u001c8gS\u001e\u0004v\u000e\\5ds\u0002\n!bY8oiJ|G\u000e\\3s+\t\u0011i\t\u0005\u0003\u0003\u0010\nMUB\u0001BI\u0015\r\u0011I)[\u0005\u0005\u0005+\u0013\tJ\u0001\u0006D_:$(o\u001c7mKJ\fabY8oiJ|G\u000e\\3s?\u0012*\u0017\u000f\u0006\u0003\u0002.\nm\u0005\"CA[_\u0005\u0005\t\u0019\u0001BG\u0003-\u0019wN\u001c;s_2dWM\u001d\u0011\u0002\u001bE,x\u000e^1NC:\fw-\u001a:t+\t\u0011\u0019\u000b\u0005\u0003\u0003&\n-f\u0002BAL\u0005OK1A!+E\u00031\tVo\u001c;b\r\u0006\u001cGo\u001c:z\u0013\u0011\u0011iKa,\u0003\u001bE+x\u000e^1NC:\fw-\u001a:t\u0015\r\u0011I\u000bR\u0001\u0012cV|G/Y'b]\u0006<WM]:`I\u0015\fH\u0003BAW\u0005kC\u0011\"!.3\u0003\u0003\u0005\rAa)\u0002\u001dE,x\u000e^1NC:\fw-\u001a:tA\u0005q1m\u001c8ue>dG.\u001a:Ba&\u001cXC\u0001B_!\ry&qX\u0005\u0004\u0005\u0003$%AD\"p]R\u0014x\u000e\u001c7fe\u0006\u0003\u0018n]\u0001\u0013G>tGO]8mY\u0016\u0014\u0018\t]5t?\u0012*\u0017\u000f\u0006\u0003\u0002.\n\u001d\u0007\"CA[k\u0005\u0005\t\u0019\u0001B_\u0003=\u0019wN\u001c;s_2dWM]!qSN\u0004\u0013!G2p]R\u0014x\u000e\u001c7fe\u0006\u0003\u0018n\u001d%b]\u0012dWM\u001d)p_2,\"Aa4\u0011\u0007}\u0013\t.C\u0002\u0003T\u0012\u0013qcS1gW\u0006\u0014V-];fgRD\u0015M\u001c3mKJ\u0004vn\u001c7\u0002;\r|g\u000e\u001e:pY2,'/\u00119jg\"\u000bg\u000e\u001a7feB{w\u000e\\0%KF$B!!,\u0003Z\"I\u0011Q\u0017\u001d\u0002\u0002\u0003\u0007!qZ\u0001\u001bG>tGO]8mY\u0016\u0014\u0018\t]5t\u0011\u0006tG\r\\3s!>|G\u000eI\u0001\u0011[&<'/\u0019;j_:\u001cV\u000f\u001d9peR,\"A!9\u0011\u000b-\u000b\tNa9\u0011\u0007}\u0013)/C\u0002\u0003h\u0012\u0013!dQ8oiJ|G\u000e\\3s\u001b&<'/\u0019;j_:\u001cV\u000f\u001d9peR\fA#\\5he\u0006$\u0018n\u001c8TkB\u0004xN\u001d;`I\u0015\fH\u0003BAW\u0005[D\u0011\"!.<\u0003\u0003\u0005\rA!9\u0002#5LwM]1uS>t7+\u001e9q_J$\b%A\tnCf\u0014Wm\u00115b]\u001e,7\u000b^1ukN$bA!>\u0003|\n}\bcA&\u0003x&\u0019!\u0011 '\u0003\u000f\t{w\u000e\\3b]\"9!Q`\u001fA\u0002\u0005M\u0015\u0001\u00024s_6Dqa!\u0001>\u0001\u0004\t\u0019*\u0001\u0002u_\u0006\u0011Bm\u001c*f[>$Xm\u0013:bMR\u001cV\r^;q)\t\ti+A\u0005dYV\u001cH/\u001a:JI\u000691\u000f^1siV\u0004\u0018\u0001C:ikR$wn\u001e8\u0002\u001b\u0005<\u0018-\u001b;TQV$Hm\\<o\u0001")
public class ControllerServer
implements KafkaMetricsGroup {
    private final SharedServer sharedServer;
    private final KafkaConfigSchema configSchema;
    private final BootstrapMetadata bootstrapMetadata;
    private final KafkaConfig config;
    private final Time time;
    private final String threadNamePrefix;
    private final ReentrantLock lock;
    private final Condition awaitShutdownCond;
    private Server.ProcessStatus status;
    private LinuxIoMetricsCollector linuxIoMetricsCollector;
    private volatile Option<Authorizer> authorizer;
    private DelegationTokenCache tokenCache;
    private CredentialProvider credentialProvider;
    private SocketServer socketServer;
    private final CompletableFuture<Integer> socketServerFirstBoundPortFuture;
    private Option<CreateTopicPolicy> createTopicPolicy;
    private Option<AlterConfigPolicy> alterConfigPolicy;
    private Controller controller;
    private QuotaFactory.QuotaManagers quotaManagers;
    private ControllerApis controllerApis;
    private KafkaRequestHandlerPool controllerApisHandlerPool;
    private Option<ControllerMigrationSupport> migrationSupport;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Meter newMeter(MetricName metricName, String eventType, TimeUnit timeUnit) {
        return KafkaMetricsGroup.newMeter$(this, metricName, eventType, timeUnit);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public SharedServer sharedServer() {
        return this.sharedServer;
    }

    public KafkaConfigSchema configSchema() {
        return this.configSchema;
    }

    public BootstrapMetadata bootstrapMetadata() {
        return this.bootstrapMetadata;
    }

    public KafkaConfig config() {
        return this.config;
    }

    public Time time() {
        return this.time;
    }

    public Metrics metrics() {
        return this.sharedServer().metrics();
    }

    public String threadNamePrefix() {
        return this.threadNamePrefix;
    }

    public KafkaRaftManager<ApiMessageAndVersion> raftManager() {
        return this.sharedServer().raftManager();
    }

    public ReentrantLock lock() {
        return this.lock;
    }

    public Condition awaitShutdownCond() {
        return this.awaitShutdownCond;
    }

    public Server.ProcessStatus status() {
        return this.status;
    }

    public void status_$eq(Server.ProcessStatus x$1) {
        this.status = x$1;
    }

    public LinuxIoMetricsCollector linuxIoMetricsCollector() {
        return this.linuxIoMetricsCollector;
    }

    public void linuxIoMetricsCollector_$eq(LinuxIoMetricsCollector x$1) {
        this.linuxIoMetricsCollector = x$1;
    }

    public Option<Authorizer> authorizer() {
        return this.authorizer;
    }

    public void authorizer_$eq(Option<Authorizer> x$1) {
        this.authorizer = x$1;
    }

    public DelegationTokenCache tokenCache() {
        return this.tokenCache;
    }

    public void tokenCache_$eq(DelegationTokenCache x$1) {
        this.tokenCache = x$1;
    }

    public CredentialProvider credentialProvider() {
        return this.credentialProvider;
    }

    public void credentialProvider_$eq(CredentialProvider x$1) {
        this.credentialProvider = x$1;
    }

    public SocketServer socketServer() {
        return this.socketServer;
    }

    public void socketServer_$eq(SocketServer x$1) {
        this.socketServer = x$1;
    }

    public CompletableFuture<Integer> socketServerFirstBoundPortFuture() {
        return this.socketServerFirstBoundPortFuture;
    }

    public Option<CreateTopicPolicy> createTopicPolicy() {
        return this.createTopicPolicy;
    }

    public void createTopicPolicy_$eq(Option<CreateTopicPolicy> x$1) {
        this.createTopicPolicy = x$1;
    }

    public Option<AlterConfigPolicy> alterConfigPolicy() {
        return this.alterConfigPolicy;
    }

    public void alterConfigPolicy_$eq(Option<AlterConfigPolicy> x$1) {
        this.alterConfigPolicy = x$1;
    }

    public Controller controller() {
        return this.controller;
    }

    public void controller_$eq(Controller x$1) {
        this.controller = x$1;
    }

    public QuotaFactory.QuotaManagers quotaManagers() {
        return this.quotaManagers;
    }

    public void quotaManagers_$eq(QuotaFactory.QuotaManagers x$1) {
        this.quotaManagers = x$1;
    }

    public ControllerApis controllerApis() {
        return this.controllerApis;
    }

    public void controllerApis_$eq(ControllerApis x$1) {
        this.controllerApis = x$1;
    }

    public KafkaRequestHandlerPool controllerApisHandlerPool() {
        return this.controllerApisHandlerPool;
    }

    public void controllerApisHandlerPool_$eq(KafkaRequestHandlerPool x$1) {
        this.controllerApisHandlerPool = x$1;
    }

    public Option<ControllerMigrationSupport> migrationSupport() {
        return this.migrationSupport;
    }

    public void migrationSupport_$eq(Option<ControllerMigrationSupport> x$1) {
        this.migrationSupport = x$1;
    }

    private boolean maybeChangeStatus(Server.ProcessStatus from, Server.ProcessStatus to) {
        block9: {
            boolean bl;
            block8: {
                this.lock().lock();
                try {
                    Server.ProcessStatus processStatus = this.status();
                    if (processStatus == null ? from != null : !processStatus.equals(from)) {
                        bl = false;
                        break block8;
                    }
                    this.status_$eq(to);
                    Server.ProcessStatus processStatus2 = to;
                    Server$SHUTDOWN$ server$SHUTDOWN$ = Server$SHUTDOWN$.MODULE$;
                    if (processStatus2 == null) {
                        if (server$SHUTDOWN$ != null) {
                            break block9;
                        }
                    } else if (!processStatus2.equals(server$SHUTDOWN$)) break block9;
                    this.awaitShutdownCond().signalAll();
                    break block9;
                }
                finally {
                    this.lock().unlock();
                }
            }
            return bl;
        }
        return true;
    }

    private void doRemoteKraftSetup() {
        new DynamicMetricReporterState(this.config().nodeId(), this.config(), this.metrics(), this.clusterId());
    }

    public String clusterId() {
        return this.sharedServer().metaProps().clusterId();
    }

    public void startup() {
        if (!this.maybeChangeStatus(Server$SHUTDOWN$.MODULE$, Server$STARTING$.MODULE$)) {
            return;
        }
        try {
            Authorizer a;
            scala.collection.immutable.Map map;
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Starting controller");
            this.config().dynamicConfig().initialize((Option<KafkaZkClient>)None$.MODULE$);
            this.maybeChangeStatus(Server$STARTING$.MODULE$, Server$STARTED$.MODULE$);
            this.logIdent_$eq(new LogContext(new StringBuilder(23).append("[ControllerServer id=").append(this.config().nodeId()).append("] ").toString()).logPrefix());
            this.newGauge("ClusterId", new Gauge<String>(this){
                private final /* synthetic */ ControllerServer $outer;

                public final String value() {
                    return this.$outer.kafka$server$ControllerServer$$$anonfun$startup$2();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, this.newGauge$default$3());
            this.newGauge("yammer-metrics-count", new Gauge<Object>(this){
                private final /* synthetic */ ControllerServer $outer;

                public final int value() {
                    return ControllerServer.kafka$server$ControllerServer$$$anonfun$startup$4();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, this.newGauge$default$3());
            this.linuxIoMetricsCollector_$eq(new LinuxIoMetricsCollector("/proc", this.time(), this.logger().underlying()));
            if (this.linuxIoMetricsCollector().usable()) {
                this.newGauge("linux-disk-read-bytes", new Gauge<Object>(this){
                    private final /* synthetic */ ControllerServer $outer;

                    public final long value() {
                        return this.$outer.kafka$server$ControllerServer$$$anonfun$startup$6();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, this.newGauge$default$3());
                this.newGauge("linux-disk-write-bytes", new Gauge<Object>(this){
                    private final /* synthetic */ ControllerServer $outer;

                    public final long value() {
                        return this.$outer.kafka$server$ControllerServer$$$anonfun$startup$8();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, this.newGauge$default$3());
            }
            List javaListeners = (List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)this.config().controllerListeners().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.toJava(), Seq$.MODULE$.canBuildFrom())).asJava();
            this.authorizer_$eq(this.config().createNewAuthorizer());
            this.authorizer().foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
                x$2.configure(this.config().originals());
                return BoxedUnit.UNIT;
            });
            Option<Authorizer> option = this.authorizer();
            if (option instanceof Some) {
                Authorizer authZ = (Authorizer)((Some)option).value();
                Broker.ServerInfo controllerAuthorizerInfo = new Broker.ServerInfo(new ClusterResource(this.clusterId()), this.config().nodeId(), javaListeners, (Endpoint)javaListeners.get(0), (java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)this.config().earlyStartListeners().map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.value(), Set$.MODULE$.canBuildFrom())).asJava());
                map = ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(authZ.start((AuthorizerServerInfo)controllerAuthorizerInfo)).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    if (x0$1 == null) {
                        throw new MatchError(null);
                    }
                    Endpoint ep = (Endpoint)x0$1._1();
                    CompletionStage cs = (CompletionStage)x0$1._2();
                    Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ep), cs.toCompletableFuture());
                    return tuple2;
                }, Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            } else if (None$.MODULE$.equals(option)) {
                map = ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(javaListeners).asScala()).map((Function1 & Serializable & scala.Serializable)ep -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(ep), CompletableFuture.completedFuture(null)), Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            } else {
                throw new MatchError(option);
            }
            SimpleApiVersionManager apiVersionManager = new SimpleApiVersionManager(ApiMessageType.ListenerType.CONTROLLER);
            this.tokenCache_$eq(new DelegationTokenCache(ScramMechanism.mechanismNames()));
            this.credentialProvider_$eq(new CredentialProvider(ScramMechanism.mechanismNames(), this.tokenCache()));
            this.socketServer_$eq(new SocketServer(this.config(), this.metrics(), this.time(), this.credentialProvider(), apiVersionManager));
            if (!this.config().controllerListeners().nonEmpty()) {
                throw new ConfigException("No controller.listener.names defined for controller");
            }
            this.socketServerFirstBoundPortFuture().complete(Predef$.MODULE$.int2Integer(this.socketServer().boundPort(((EndPoint)this.config().controllerListeners().head()).listenerName())));
            this.sharedServer().startForController();
            this.createTopicPolicy_$eq((Option<CreateTopicPolicy>)Option$.MODULE$.apply(this.config().getConfiguredInstance(KafkaConfig$.MODULE$.CreateTopicPolicyClassNameProp(), CreateTopicPolicy.class)));
            this.alterConfigPolicy_$eq((Option<AlterConfigPolicy>)Option$.MODULE$.apply(this.config().getConfiguredInstance(KafkaConfig$.MODULE$.AlterConfigPolicyClassNameProp(), AlterConfigPolicy.class)));
            List controllerNodes = RaftConfig.voterConnectionsToNodes(this.sharedServer().controllerQuorumVotersFuture().get());
            QuorumFeatures quorumFeatures = QuorumFeatures.create((int)this.config().nodeId(), (ApiVersions)this.sharedServer().raftManager().apiVersions(), (java.util.Map)QuorumFeatures.defaultFeatureMap(), (Collection)controllerNodes);
            OptionalLong leaderImbalanceCheckIntervalNs = Predef$.MODULE$.Boolean2boolean(this.config().autoLeaderRebalanceEnable()) ? OptionalLong.of(TimeUnit.NANOSECONDS.convert(this.config().leaderImbalanceCheckIntervalSeconds(), TimeUnit.SECONDS)) : OptionalLong.empty();
            OptionalLong maxIdleIntervalNs = (OptionalLong)this.config().metadataMaxIdleIntervalNs().fold((Function0 & Serializable & scala.Serializable)() -> OptionalLong.empty(), (Function1 & Serializable & scala.Serializable)x$1 -> ControllerServer.$anonfun$startup$16(BoxesRunTime.unboxToLong((Object)x$1)));
            QuorumController.Builder controllerBuilder = new QuorumController.Builder(this.config().nodeId(), this.sharedServer().metaProps().clusterId()).setTime(this.time()).setThreadNamePrefix(this.threadNamePrefix()).setConfigSchema(this.configSchema()).setRaftClient(this.raftManager().client()).setQuorumFeatures(quorumFeatures).setDefaultReplicationFactor((short)this.config().defaultReplicationFactor()).setDefaultNumPartitions(this.config().numPartitions().intValue()).setSessionTimeoutNs(TimeUnit.NANOSECONDS.convert(this.config().brokerSessionTimeoutMs(), TimeUnit.MILLISECONDS)).setLeaderImbalanceCheckIntervalNs(leaderImbalanceCheckIntervalNs).setMaxIdleIntervalNs(maxIdleIntervalNs).setMetrics((ControllerMetrics)this.sharedServer().controllerMetrics()).setCreateTopicPolicy(OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(this.createTopicPolicy()))).setAlterConfigPolicy(OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(this.alterConfigPolicy()))).setConfigurationValidator((ConfigurationValidator)new ControllerConfigurationValidator()).setStaticConfig(this.config().originals()).setBootstrapMetadata(this.bootstrapMetadata()).setFatalFaultHandler(this.sharedServer().quorumControllerFaultHandler()).setZkMigrationEnabled(this.config().migrationEnabled());
            Option<Authorizer> option2 = this.authorizer();
            if (option2 instanceof Some && (a = (Authorizer)((Some)option2).value()) instanceof ClusterMetadataAuthorizer) {
                ClusterMetadataAuthorizer clusterMetadataAuthorizer = (ClusterMetadataAuthorizer)a;
                controllerBuilder.setAuthorizer(clusterMetadataAuthorizer);
            }
            this.controller_$eq((Controller)controllerBuilder.build());
            if (!this.config().processRoles().contains((Object)KafkaRaftServer$BrokerRole$.MODULE$)) {
                this.doRemoteKraftSetup();
            }
            if (this.config().migrationEnabled()) {
                KafkaZkClient zkClient = KafkaZkClient$.MODULE$.createZkClient("KRaft Migration", this.time(), this.config(), KafkaServer$.MODULE$.zkClientConfigFromKafkaConfig(this.config(), KafkaServer$.MODULE$.zkClientConfigFromKafkaConfig$default$2()));
                ZkMigrationClient migrationClient = new ZkMigrationClient(zkClient);
                MigrationPropagator propagator = new MigrationPropagator(this.config().nodeId(), this.config());
                KRaftMigrationDriver migrationDriver = new KRaftMigrationDriver(this.config().nodeId(), ((QuorumController)this.controller()).zkRecordConsumer(), (MigrationClient)migrationClient, (LegacyPropagator)propagator, publisher -> this.sharedServer().loader().installPublishers(Collections.singletonList(publisher)), this.sharedServer().faultHandlerFactory().build("zk migration", false, () -> {}));
                migrationDriver.start();
                this.migrationSupport_$eq((Option<ControllerMigrationSupport>)new Some((Object)new ControllerMigrationSupport(zkClient, migrationDriver, propagator)));
            }
            this.quotaManagers_$eq(QuotaFactory$.MODULE$.instantiate(this.config(), this.metrics(), this.time(), this.threadNamePrefix()));
            this.controllerApis_$eq(new ControllerApis(this.socketServer().dataPlaneRequestChannel(), this.authorizer(), this.quotaManagers(), this.time(), this.controller(), this.raftManager(), this.config(), this.sharedServer().metaProps(), (Seq<Node>)((SeqLike)CollectionConverters$.MODULE$.asScalaBufferConverter(controllerNodes).asScala()).toSeq(), apiVersionManager));
            this.controllerApisHandlerPool_$eq(new KafkaRequestHandlerPool(this.config().nodeId(), this.socketServer().dataPlaneRequestChannel(), this.controllerApis(), this.time(), Predef$.MODULE$.Integer2int(this.config().numIoThreads()), new StringBuilder(28).append(DataPlaneAcceptor$.MODULE$.MetricPrefix()).append("RequestHandlerAvgIdlePercent").toString(), DataPlaneAcceptor$.MODULE$.ThreadPrefix()));
            this.socketServer().enableRequestProcessing((Map<Endpoint, CompletableFuture<Void>>)map);
            return;
        }
        catch (Throwable e) {
            this.maybeChangeStatus(Server$STARTING$.MODULE$, Server$STARTED$.MODULE$);
            this.fatal((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Fatal error during controller startup. Prepare to shutdown", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
            this.shutdown();
            throw e;
        }
    }

    public void shutdown() {
        if (!this.maybeChangeStatus(Server$STARTED$.MODULE$, Server$SHUTTING_DOWN$.MODULE$)) {
            return;
        }
        try {
            try {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "shutting down");
                this.sharedServer().ensureNotRaftLeader();
                if (this.socketServer() != null) {
                    CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.socketServer().stopProcessingRequests(), this, CoreUtils$.MODULE$.swallow$default$3());
                }
                this.migrationSupport().foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
                    x$4.shutdown(this);
                    return BoxedUnit.UNIT;
                });
                if (this.controller() != null) {
                    this.controller().beginShutdown();
                }
                if (this.socketServer() != null) {
                    CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.socketServer().shutdown(), this, CoreUtils$.MODULE$.swallow$default$3());
                }
                if (this.controllerApisHandlerPool() != null) {
                    CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.controllerApisHandlerPool().shutdown(), this, CoreUtils$.MODULE$.swallow$default$3());
                }
                if (this.controllerApis() != null) {
                    CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.controllerApis().close(), this, CoreUtils$.MODULE$.swallow$default$3());
                }
                if (this.quotaManagers() != null) {
                    CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.quotaManagers().shutdown(), this, CoreUtils$.MODULE$.swallow$default$3());
                }
                if (this.controller() != null) {
                    this.controller().close();
                }
                CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.authorizer().foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
                    x$5.close();
                    return BoxedUnit.UNIT;
                }), this, CoreUtils$.MODULE$.swallow$default$3());
                this.createTopicPolicy().foreach((Function1 & Serializable & scala.Serializable)policy -> {
                    CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> policy.close(), this, CoreUtils$.MODULE$.swallow$default$3());
                    return BoxedUnit.UNIT;
                });
                this.alterConfigPolicy().foreach((Function1 & Serializable & scala.Serializable)policy -> {
                    CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> policy.close(), this, CoreUtils$.MODULE$.swallow$default$3());
                    return BoxedUnit.UNIT;
                });
                this.socketServerFirstBoundPortFuture().completeExceptionally(new RuntimeException("shutting down"));
                CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.config().dynamicConfig().clear(), this, CoreUtils$.MODULE$.swallow$default$3());
                this.sharedServer().stopForController();
            }
            catch (Throwable e) {
                this.fatal((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Fatal error during controller shutdown.", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                throw e;
            }
        }
        finally {
            this.maybeChangeStatus(Server$SHUTTING_DOWN$.MODULE$, Server$SHUTDOWN$.MODULE$);
        }
    }

    public void awaitShutdown() {
        this.lock().lock();
        try {
            while (true) {
                Server.ProcessStatus processStatus = this.status();
                Server$SHUTDOWN$ server$SHUTDOWN$ = Server$SHUTDOWN$.MODULE$;
                if (processStatus == null ? server$SHUTDOWN$ != null : !processStatus.equals(server$SHUTDOWN$)) {
                    this.awaitShutdownCond().awaitUninterruptibly();
                    continue;
                }
                break;
            }
        }
        finally {
            this.lock().unlock();
        }
    }

    public final /* synthetic */ String kafka$server$ControllerServer$$$anonfun$startup$2() {
        return this.clusterId();
    }

    public static final /* synthetic */ int kafka$server$ControllerServer$$$anonfun$startup$4() {
        return KafkaYammerMetrics.defaultRegistry().allMetrics().size();
    }

    public final /* synthetic */ long kafka$server$ControllerServer$$$anonfun$startup$6() {
        return this.linuxIoMetricsCollector().readBytes();
    }

    public final /* synthetic */ long kafka$server$ControllerServer$$$anonfun$startup$8() {
        return this.linuxIoMetricsCollector().writeBytes();
    }

    public static final /* synthetic */ OptionalLong $anonfun$startup$16(long x$1) {
        return OptionalLong.of(x$1);
    }

    public ControllerServer(SharedServer sharedServer, KafkaConfigSchema configSchema, BootstrapMetadata bootstrapMetadata) {
        this.sharedServer = sharedServer;
        this.configSchema = configSchema;
        this.bootstrapMetadata = bootstrapMetadata;
        Logging.$init$(this);
        KafkaMetricsGroup.$init$(this);
        this.config = sharedServer.controllerConfig();
        this.time = sharedServer.time();
        this.threadNamePrefix = (String)sharedServer.threadNamePrefix().getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        this.lock = new ReentrantLock();
        this.awaitShutdownCond = this.lock().newCondition();
        this.status = Server$SHUTDOWN$.MODULE$;
        this.authorizer = None$.MODULE$;
        this.socketServerFirstBoundPortFuture = new CompletableFuture();
        this.createTopicPolicy = None$.MODULE$;
        this.alterConfigPolicy = None$.MODULE$;
        this.migrationSupport = None$.MODULE$;
    }
}

