/*
 * Decompiled with CFR 0.152.
 */
package kafka.raft;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Paths;
import java.util.Map;
import java.util.OptionalInt;
import java.util.concurrent.CompletableFuture;
import kafka.log.UnifiedLog$;
import kafka.raft.KafkaMetadataLog;
import kafka.raft.KafkaMetadataLog$;
import kafka.raft.KafkaNetworkChannel;
import kafka.raft.KafkaRaftManager$;
import kafka.raft.MetadataLogConfig$;
import kafka.raft.RaftManager;
import kafka.raft.TimingWheelExpirationService;
import kafka.server.KafkaConfig;
import kafka.server.KafkaRaftServer;
import kafka.server.KafkaRaftServer$ControllerRole$;
import kafka.server.MetaProperties;
import kafka.utils.CoreUtils$;
import kafka.utils.FileLock;
import kafka.utils.KafkaScheduler;
import kafka.utils.KafkaScheduler$;
import kafka.utils.Logging;
import kafka.utils.ShutdownableThread;
import kafka.utils.timer.SystemTimer;
import kafka.utils.timer.SystemTimer$;
import org.apache.kafka.clients.ApiVersions;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.ManualMetadataUpdater;
import org.apache.kafka.clients.MetadataUpdater;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ChannelBuilder;
import org.apache.kafka.common.network.ChannelBuilders;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.Selectable;
import org.apache.kafka.common.network.Selector;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.security.JaasContext;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.raft.ExpirationService;
import org.apache.kafka.raft.FileBasedStateStore;
import org.apache.kafka.raft.KafkaRaftClient;
import org.apache.kafka.raft.LeaderAndEpoch;
import org.apache.kafka.raft.NetworkChannel;
import org.apache.kafka.raft.QuorumStateStore;
import org.apache.kafka.raft.RaftClient;
import org.apache.kafka.raft.RaftConfig;
import org.apache.kafka.raft.RaftRequest;
import org.apache.kafka.raft.ReplicatedLog;
import org.apache.kafka.server.common.serialization.RecordSerde;
import org.apache.kafka.server.fault.FaultHandler;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.GenTraversable;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\r]r!\u0002 @\u0011\u0003!e!\u0002$@\u0011\u00039\u0005\"\u0002(\u0002\t\u0003ye\u0001\u0002)\u0002\u0001EC\u0001\u0002W\u0002\u0003\u0002\u0003\u0006I!\u0017\u0005\t_\u000e\u0011\t\u0011)A\u0005a\"A1p\u0001B\u0001B\u0003%A\u0010\u0003\u0004O\u0007\u0011\u0005\u0011\u0011\u0002\u0005\b\u0003;\u0019A\u0011IA\u0010\u0011\u001d\t9c\u0001C!\u0003SAq!!\r\u0004\t\u0003\n\u0019\u0004C\u0004\u00026\u0005!I!a\u000e\t\u000f\u0005E\u0013\u0001\"\u0003\u0002T\u0019)ai\u0010\u0001\u0002`!Q\u0011QO\u0007\u0003\u0002\u0003\u0006I!a\u001e\t\u0015\u0005\u0005UB!A!\u0002\u0013\t\u0019\t\u0003\u0006\u0002\n6\u0011\t\u0011)A\u0005\u0003\u0017C!\"a'\u000e\u0005\u0003\u0005\u000b\u0011BAO\u0011)\t9+\u0004B\u0001B\u0003%\u0011\u0011\u0016\u0005\u000b\u0003_k!\u0011!Q\u0001\n\u0005E\u0006BCA^\u001b\t\u0005\t\u0015!\u0003\u0002>\"Q\u0011qY\u0007\u0003\u0002\u0003\u0006I!!3\t\u0015\u0005=WB!b\u0001\n\u0003\t\t\u000e\u0003\u0006\u0003\u00165\u0011\t\u0011)A\u0005\u0003'D\u0001b_\u0007\u0003\u0002\u0003\u0006I\u0001 \u0005\u0007\u001d6!\tAa\u0006\t\u0013\t=RB1A\u0005\u0002\tE\u0002\u0002\u0003B \u001b\u0001\u0006IAa\r\t\u0013\t\u0005SB1A\u0005\n\t\r\u0003\u0002\u0003B&\u001b\u0001\u0006IA!\u0012\t\u0011=l!\u0019!C\u0005\u0005\u001bBqAa\u0014\u000eA\u0003%\u0001\u000fC\u0005\u0003R5\u0011\r\u0011\"\u0003\u0003T!A!1L\u0007!\u0002\u0013\u0011)\u0006C\u0005\u0003^5\u0011\r\u0011\"\u0003\u0003`!A!qM\u0007!\u0002\u0013\u0011\t\u0007C\u0005\u0002^5\u0011\r\u0011\"\u0003\u0003j!A!1N\u0007!\u0002\u0013\tI\u0004C\u0005\u0003n5\u0011\r\u0011\"\u0003\u0003p!A!1O\u0007!\u0002\u0013\u0011\t\bC\u0005\u0003v5\u0011\r\u0011\"\u0011\u0003x!A!qP\u0007!\u0002\u0013\u0011I\bC\u0005\u0003\u00026\u0011\r\u0011\"\u0003\u0003\u0004\"A!1R\u0007!\u0002\u0013\u0011)\tC\u0005\u0003\u000e6\u0011\r\u0011\"\u0003\u0003\u0010\"A!QT\u0007!\u0002\u0013\u0011\t\nC\u0005\u0003 6\u0011\r\u0011\"\u0003\u0003\"\"A!\u0011V\u0007!\u0002\u0013\u0011\u0019\u000b\u0003\u0005Y\u001b\t\u0007I\u0011\tBV\u0011!\u0011y+\u0004Q\u0001\n\t5\u0006\"\u0003BY\u001b\t\u0007I\u0011\u0002BZ\u0011!\u0011\t-\u0004Q\u0001\n\tU\u0006b\u0002Bb\u001b\u0011\u0005\u0011q\u0004\u0005\b\u0005\u000blA\u0011AA\u0010\u0011\u001d\u00119-\u0004C!\u0005\u0013DqA!8\u000e\t\u0003\u0012y\u000eC\u0004\u0004\u000e5!Iaa\u0004\t\u000f\rEQ\u0002\"\u0003\u0004\u0014!91QC\u0007\u0005\n\r]\u0001bBB\r\u001b\u0011%11\u0004\u0005\b\u0007GiA\u0011BB\u0013\u0011\u001d\u0019i#\u0004C!\u0007_\t\u0001cS1gW\u0006\u0014\u0016M\u001a;NC:\fw-\u001a:\u000b\u0005\u0001\u000b\u0015\u0001\u0002:bMRT\u0011AQ\u0001\u0006W\u000647.Y\u0002\u0001!\t)\u0015!D\u0001@\u0005AY\u0015MZ6b%\u00064G/T1oC\u001e,'o\u0005\u0002\u0002\u0011B\u0011\u0011\nT\u0007\u0002\u0015*\t1*A\u0003tG\u0006d\u0017-\u0003\u0002N\u0015\n1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001#\u0003\u0019I\u000bg\r^%p)\"\u0014X-\u00193\u0014\u0005\r\u0011\u0006CA*W\u001b\u0005!&BA+B\u0003\u0015)H/\u001b7t\u0013\t9FK\u0001\nTQV$Hm\\<oC\ndW\r\u00165sK\u0006$\u0017AB2mS\u0016tG\u000f\r\u0002[MB\u00191L\u00193\u000e\u0003qS!\u0001Q/\u000b\u0005\ts&BA0a\u0003\u0019\t\u0007/Y2iK*\t\u0011-A\u0002pe\u001eL!a\u0019/\u0003\u001f-\u000bgm[1SC\u001a$8\t\\5f]R\u0004\"!\u001a4\r\u0001\u0011Iq\rBA\u0001\u0002\u0003\u0015\t\u0001\u001b\u0002\u0004?\u0012\n\u0014CA5m!\tI%.\u0003\u0002l\u0015\n9aj\u001c;iS:<\u0007CA%n\u0013\tq'JA\u0002B]f\f\u0001\u0003\u001e5sK\u0006$g*Y7f!J,g-\u001b=\u0011\u0005EDhB\u0001:w!\t\u0019(*D\u0001u\u0015\t)8)\u0001\u0004=e>|GOP\u0005\u0003o*\u000ba\u0001\u0015:fI\u00164\u0017BA={\u0005\u0019\u0019FO]5oO*\u0011qOS\u0001\u0012M\u0006$\u0018\r\u001c$bk2$\b*\u00198eY\u0016\u0014\bcA?\u0002\u00065\taPC\u0002\u0000\u0003\u0003\tQAZ1vYRT1!a\u0001^\u0003\u0019\u0019XM\u001d<fe&\u0019\u0011q\u0001@\u0003\u0019\u0019\u000bW\u000f\u001c;IC:$G.\u001a:\u0015\u0011\u0005-\u0011qBA\r\u00037\u00012!!\u0004\u0004\u001b\u0005\t\u0001B\u0002-\b\u0001\u0004\t\t\u0002\r\u0003\u0002\u0014\u0005]\u0001\u0003B.c\u0003+\u00012!ZA\f\t)9\u0017qBA\u0001\u0002\u0003\u0015\t\u0001\u001b\u0005\u0006_\u001e\u0001\r\u0001\u001d\u0005\u0006w\u001e\u0001\r\u0001`\u0001\u0007I><vN]6\u0015\u0005\u0005\u0005\u0002cA%\u0002$%\u0019\u0011Q\u0005&\u0003\tUs\u0017\u000e^\u0001\u0011S:LG/[1uKNCW\u000f\u001e3po:$\"!a\u000b\u0011\u0007%\u000bi#C\u0002\u00020)\u0013qAQ8pY\u0016\fg.A\u0005jgJ+hN\\5oOV\u0011\u00111F\u0001\u0013GJ,\u0017\r^3M_\u001e$\u0015N]3di>\u0014\u0018\u0010\u0006\u0004\u0002:\u0005%\u0013Q\n\t\u0005\u0003w\t)%\u0004\u0002\u0002>)!\u0011qHA!\u0003\tIwN\u0003\u0002\u0002D\u0005!!.\u0019<b\u0013\u0011\t9%!\u0010\u0003\t\u0019KG.\u001a\u0005\b\u0003\u0017Z\u0001\u0019AA\u001d\u0003\u0019awn\u001a#je\"1\u0011qJ\u0006A\u0002A\f!\u0002\\8h\t&\u0014h*Y7f\u0003-awnY6ECR\fG)\u001b:\u0015\t\u0005U\u00131\f\t\u0004'\u0006]\u0013bAA-)\nAa)\u001b7f\u0019>\u001c7\u000eC\u0004\u0002^1\u0001\r!!\u000f\u0002\u000f\u0011\fG/\u0019#jeV!\u0011\u0011MA6'\u0019i\u0001*a\u0019\u0002pA)Q)!\u001a\u0002j%\u0019\u0011qM \u0003\u0017I\u000bg\r^'b]\u0006<WM\u001d\t\u0004K\u0006-DABA7\u001b\t\u0007\u0001NA\u0001U!\r\u0019\u0016\u0011O\u0005\u0004\u0003g\"&a\u0002'pO\u001eLgnZ\u0001\u000f[\u0016$\u0018\r\u0015:pa\u0016\u0014H/[3t!\u0011\tI(! \u000e\u0005\u0005m$bAA\u0002\u0003&!\u0011qPA>\u00059iU\r^1Qe>\u0004XM\u001d;jKN\faaY8oM&<\u0007\u0003BA=\u0003\u000bKA!a\"\u0002|\tY1*\u00194lC\u000e{gNZ5h\u0003-\u0011XmY8sIN+'\u000fZ3\u0011\r\u00055\u0015qSA5\u001b\t\tyI\u0003\u0003\u0002\u0012\u0006M\u0015!D:fe&\fG.\u001b>bi&|gN\u0003\u0003\u0002\u0016\u0006\u0005\u0011AB2p[6|g.\u0003\u0003\u0002\u001a\u0006=%a\u0003*fG>\u0014HmU3sI\u0016\fa\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0005\u0003\u0002 \u0006\rVBAAQ\u0015\r\t)*X\u0005\u0005\u0003K\u000b\tK\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0002\u000fQ|\u0007/[2JIB!\u0011qTAV\u0013\u0011\ti+!)\u0003\tU+\u0018\u000eZ\u0001\u0005i&lW\r\u0005\u0003\u00024\u0006]VBAA[\u0015\r)\u0016\u0011U\u0005\u0005\u0003s\u000b)L\u0001\u0003US6,\u0017aB7fiJL7m\u001d\t\u0005\u0003\u007f\u000b\u0019-\u0004\u0002\u0002B*!\u00111XAQ\u0013\u0011\t)-!1\u0003\u000f5+GO]5dg\u0006\u0019B\u000f\u001b:fC\u0012t\u0015-\\3Qe\u00164\u0017\u000e_(qiB!\u0011*a3q\u0013\r\tiM\u0013\u0002\u0007\u001fB$\u0018n\u001c8\u00029\r|g\u000e\u001e:pY2,'/U;peVlgk\u001c;feN4U\u000f^;sKV\u0011\u00111\u001b\t\u0007\u0003+\fy.a9\u000e\u0005\u0005]'\u0002BAm\u00037\f!bY8oGV\u0014(/\u001a8u\u0015\u0011\ti.!\u0011\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003C\f9NA\tD_6\u0004H.\u001a;bE2,g)\u001e;ve\u0016\u0004\u0002\"!:\u0002h\u0006-\u0018q_\u0007\u0003\u00037LA!!;\u0002\\\n\u0019Q*\u00199\u0011\t\u00055\u00181_\u0007\u0003\u0003_TA!!=\u0002B\u0005!A.\u00198h\u0013\u0011\t)0a<\u0003\u000f%sG/Z4feB!\u0011\u0011 B\b\u001d\u0011\tYPa\u0003\u000f\t\u0005u(\u0011\u0002\b\u0005\u0003\u007f\u00149A\u0004\u0003\u0003\u0002\t\u0015abA:\u0003\u0004%\t\u0011-\u0003\u0002`A&\u0011!IX\u0005\u0003\u0001vK1A!\u0004]\u0003)\u0011\u0016M\u001a;D_:4\u0017nZ\u0005\u0005\u0005#\u0011\u0019BA\u0006BI\u0012\u0014Xm]:Ta\u0016\u001c'b\u0001B\u00079\u0006i2m\u001c8ue>dG.\u001a:Rk>\u0014X/\u001c,pi\u0016\u00148OR;ukJ,\u0007\u0005\u0006\f\u0003\u001a\tm!Q\u0004B\u0010\u0005C\u0011\u0019C!\n\u0003(\t%\"1\u0006B\u0017!\u0011)U\"!\u001b\t\u000f\u0005U\u0014\u00041\u0001\u0002x!9\u0011\u0011Q\rA\u0002\u0005\r\u0005bBAE3\u0001\u0007\u00111\u0012\u0005\b\u00037K\u0002\u0019AAO\u0011\u001d\t9+\u0007a\u0001\u0003SCq!a,\u001a\u0001\u0004\t\t\fC\u0004\u0002<f\u0001\r!!0\t\u000f\u0005\u001d\u0017\u00041\u0001\u0002J\"9\u0011qZ\rA\u0002\u0005M\u0007\"B>\u001a\u0001\u0004a\u0018aC1qSZ+'o]5p]N,\"Aa\r\u0011\t\tU\"1H\u0007\u0003\u0005oQ1A!\u000f^\u0003\u001d\u0019G.[3oiNLAA!\u0010\u00038\tY\u0011\t]5WKJ\u001c\u0018n\u001c8t\u00031\t\u0007/\u001b,feNLwN\\:!\u0003)\u0011\u0018M\u001a;D_:4\u0017nZ\u000b\u0003\u0005\u000b\u00022a\u0017B$\u0013\r\u0011I\u0005\u0018\u0002\u000b%\u00064GoQ8oM&<\u0017a\u0003:bMR\u001cuN\u001c4jO\u0002*\u0012\u0001]\u0001\u0012i\"\u0014X-\u00193OC6,\u0007K]3gSb\u0004\u0013A\u00037pO\u000e{g\u000e^3yiV\u0011!Q\u000b\t\u0005\u0003g\u00139&\u0003\u0003\u0003Z\u0005U&A\u0003'pO\u000e{g\u000e^3yi\u0006YAn\\4D_:$X\r\u001f;!\u0003%\u00198\r[3ek2,'/\u0006\u0002\u0003bA\u00191Ka\u0019\n\u0007\t\u0015DK\u0001\bLC\u001a\\\u0017mU2iK\u0012,H.\u001a:\u0002\u0015M\u001c\u0007.\u001a3vY\u0016\u0014\b%\u0006\u0002\u0002:\u0005AA-\u0019;b\t&\u0014\b%A\u0006eCR\fG)\u001b:M_\u000e\\WC\u0001B9!\u0015I\u00151ZA+\u00031!\u0017\r^1ESJdunY6!\u00035\u0011X\r\u001d7jG\u0006$X\r\u001a'pOV\u0011!\u0011\u0010\t\u00047\nm\u0014b\u0001B?9\ni!+\u001a9mS\u000e\fG/\u001a3M_\u001e\faB]3qY&\u001c\u0017\r^3e\u0019><\u0007%\u0001\u0006oKR\u001c\u0005.\u00198oK2,\"A!\"\u0011\u0007\u0015\u00139)C\u0002\u0003\n~\u00121cS1gW\u0006tU\r^<pe.\u001c\u0005.\u00198oK2\f1B\\3u\u0007\"\fgN\\3mA\u0005yQ\r\u001f9je\u0006$\u0018n\u001c8US6,'/\u0006\u0002\u0003\u0012B!!1\u0013BM\u001b\t\u0011)JC\u0002\u0003\u0018R\u000bQ\u0001^5nKJLAAa'\u0003\u0016\nY1+_:uK6$\u0016.\\3s\u0003A)\u0007\u0010]5sCRLwN\u001c+j[\u0016\u0014\b%A\tfqBL'/\u0019;j_:\u001cVM\u001d<jG\u0016,\"Aa)\u0011\u0007\u0015\u0013)+C\u0002\u0003(~\u0012A\u0004V5nS:<w\u000b[3fY\u0016C\b/\u001b:bi&|gnU3sm&\u001cW-\u0001\nfqBL'/\u0019;j_:\u001cVM\u001d<jG\u0016\u0004SC\u0001BW!\u0011Y&-!\u001b\u0002\u000f\rd\u0017.\u001a8uA\u0005a!/\u00194u\u0013>$\u0006N]3bIV\u0011!Q\u0017\t\u0004\u0005o\u001bab\u0001B]\u00019!!1\u0018B`\u001d\r\u0019(QX\u0005\u0002\u0005&\u0011\u0001)Q\u0001\u000ee\u00064G/S8UQJ,\u0017\r\u001a\u0011\u0002\u000fM$\u0018M\u001d;va\u0006A1\u000f[;uI><h.\u0001\u0005sK\u001eL7\u000f^3s)\u0011\t\tCa3\t\u000f\t5g\u00071\u0001\u0003P\u0006AA.[:uK:,'\u000f\u0005\u0004\u0003R\n]\u0017\u0011\u000e\b\u00047\nM\u0017b\u0001Bk9\u0006Q!+\u00194u\u00072LWM\u001c;\n\t\te'1\u001c\u0002\t\u0019&\u001cH/\u001a8fe*\u0019!Q\u001b/\u0002\u001b!\fg\u000e\u001a7f%\u0016\fX/Z:u)!\u0011\tOa<\u0003\u0000\u000e\r\u0001CBAk\u0003?\u0014\u0019\u000f\u0005\u0003\u0003f\n-XB\u0001Bt\u0015\u0011\u0011I/!)\u0002\u0011A\u0014x\u000e^8d_2LAA!<\u0003h\nQ\u0011\t]5NKN\u001c\u0018mZ3\t\u000f\tEx\u00071\u0001\u0003t\u00061\u0001.Z1eKJ\u0004BA!>\u0003|6\u0011!q\u001f\u0006\u0005\u0005s\f\t+\u0001\u0005sKF,Xm\u001d;t\u0013\u0011\u0011iPa>\u0003\u001bI+\u0017/^3ti\"+\u0017\rZ3s\u0011\u001d\u0019\ta\u000ea\u0001\u0005G\fqA]3rk\u0016\u001cH\u000fC\u0004\u0004\u0006]\u0002\raa\u0002\u0002\u001b\r\u0014X-\u0019;fIRKW.Z't!\rI5\u0011B\u0005\u0004\u0007\u0017Q%\u0001\u0002'p]\u001e\fqBY;jY\u0012\u0014\u0016M\u001a;DY&,g\u000e\u001e\u000b\u0003\u0005[\u000b1CY;jY\u0012tU\r^<pe.\u001c\u0005.\u00198oK2$\"A!\"\u0002\u001b\r\u0014X-\u0019;f\t\u0006$\u0018\rR5s)\t\tI$\u0001\tck&dG-T3uC\u0012\fG/\u0019'pOR\u00111Q\u0004\t\u0004\u000b\u000e}\u0011bAB\u0011\u007f\t\u00012*\u00194lC6+G/\u00193bi\u0006dunZ\u0001\u0013EVLG\u000e\u001a(fi^|'o[\"mS\u0016tG\u000f\u0006\u0002\u0004(A!!QGB\u0015\u0013\u0011\u0019YCa\u000e\u0003\u001b9+Go^8sW\u000ec\u0017.\u001a8u\u00039aW-\u00193fe\u0006sG-\u00129pG\",\"a!\r\u0011\u0007m\u001b\u0019$C\u0002\u00046q\u0013a\u0002T3bI\u0016\u0014\u0018I\u001c3Fa>\u001c\u0007\u000e")
public class KafkaRaftManager<T>
implements RaftManager<T>,
Logging {
    private final MetaProperties metaProperties;
    private final KafkaConfig config;
    private final RecordSerde<T> recordSerde;
    private final TopicPartition topicPartition;
    private final Uuid topicId;
    private final Time time;
    private final Metrics metrics;
    private final CompletableFuture<java.util.Map<Integer, RaftConfig.AddressSpec>> controllerQuorumVotersFuture;
    private final ApiVersions apiVersions;
    private final RaftConfig raftConfig;
    private final String threadNamePrefix;
    private final LogContext logContext;
    private final KafkaScheduler scheduler;
    private final File dataDir;
    private final Option<FileLock> dataDirLock;
    private final ReplicatedLog replicatedLog;
    private final KafkaNetworkChannel netChannel;
    private final SystemTimer expirationTimer;
    private final TimingWheelExpirationService expirationService;
    private final KafkaRaftClient<T> client;
    private final RaftIoThread raftIoThread;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public CompletableFuture<java.util.Map<Integer, RaftConfig.AddressSpec>> controllerQuorumVotersFuture() {
        return this.controllerQuorumVotersFuture;
    }

    public ApiVersions apiVersions() {
        return this.apiVersions;
    }

    private RaftConfig raftConfig() {
        return this.raftConfig;
    }

    private String threadNamePrefix() {
        return this.threadNamePrefix;
    }

    private LogContext logContext() {
        return this.logContext;
    }

    private KafkaScheduler scheduler() {
        return this.scheduler;
    }

    private File dataDir() {
        return this.dataDir;
    }

    private Option<FileLock> dataDirLock() {
        return this.dataDirLock;
    }

    @Override
    public ReplicatedLog replicatedLog() {
        return this.replicatedLog;
    }

    private KafkaNetworkChannel netChannel() {
        return this.netChannel;
    }

    private SystemTimer expirationTimer() {
        return this.expirationTimer;
    }

    private TimingWheelExpirationService expirationService() {
        return this.expirationService;
    }

    @Override
    public KafkaRaftClient<T> client() {
        return this.client;
    }

    private RaftIoThread raftIoThread() {
        return this.raftIoThread;
    }

    public void startup() {
        java.util.Map<Integer, RaftConfig.AddressSpec> voterAddresses = this.controllerQuorumVotersFuture().get();
        ((IterableLike)CollectionConverters$.MODULE$.asScalaSetConverter(voterAddresses.entrySet()).asScala()).foreach((Function1 & Serializable & scala.Serializable)voterAddressEntry -> {
            KafkaRaftManager.$anonfun$startup$1(this, voterAddressEntry);
            return BoxedUnit.UNIT;
        });
        this.netChannel().start();
        this.raftIoThread().start();
    }

    public void shutdown() {
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.expirationService().shutdown(), this, CoreUtils$.MODULE$.swallow$default$3());
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.expirationTimer().shutdown(), this, CoreUtils$.MODULE$.swallow$default$3());
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.raftIoThread().shutdown(), this, CoreUtils$.MODULE$.swallow$default$3());
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.client().close(), this, CoreUtils$.MODULE$.swallow$default$3());
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.scheduler().shutdown(), this, CoreUtils$.MODULE$.swallow$default$3());
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.netChannel().close(), this, CoreUtils$.MODULE$.swallow$default$3());
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.replicatedLog().close(), this, CoreUtils$.MODULE$.swallow$default$3());
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.dataDirLock().foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            x$3.destroy();
            return BoxedUnit.UNIT;
        }), this, CoreUtils$.MODULE$.swallow$default$3());
    }

    @Override
    public void register(RaftClient.Listener<T> listener) {
        this.client().register(listener);
    }

    @Override
    public CompletableFuture<ApiMessage> handleRequest(RequestHeader header, ApiMessage request, long createdTimeMs) {
        RaftRequest.Inbound inboundRequest = new RaftRequest.Inbound(header.correlationId(), request, createdTimeMs);
        this.client().handle(inboundRequest);
        return inboundRequest.completion.thenApply(response -> response.data());
    }

    /*
     * WARNING - void declaration
     */
    private KafkaRaftClient<T> buildRaftClient() {
        void var3_3;
        FileBasedStateStore quorumStateStore = new FileBasedStateStore(new File(this.dataDir(), "quorum-state"));
        OptionalInt nodeId = OptionalInt.of(this.config.nodeId());
        KafkaRaftClient client = new KafkaRaftClient(this.recordSerde, (NetworkChannel)this.netChannel(), this.replicatedLog(), (QuorumStateStore)quorumStateStore, this.time, this.metrics, (ExpirationService)this.expirationService(), this.logContext(), this.metaProperties.clusterId(), nodeId, this.raftConfig());
        client.initialize();
        return var3_3;
    }

    private KafkaNetworkChannel buildNetworkChannel() {
        NetworkClient netClient = this.buildNetworkClient();
        return new KafkaNetworkChannel(this.time, (KafkaClient)netClient, Predef$.MODULE$.Integer2int(this.config.quorumRequestTimeoutMs()), this.threadNamePrefix());
    }

    private File createDataDir() {
        String logDirName = UnifiedLog$.MODULE$.logDirName(this.topicPartition);
        return KafkaRaftManager$.MODULE$.kafka$raft$KafkaRaftManager$$createLogDirectory(new File(this.config.metadataLogDir()), logDirName);
    }

    private KafkaMetadataLog buildMetadataLog() {
        return KafkaMetadataLog$.MODULE$.apply(this.topicPartition, this.topicId, this.dataDir(), this.time, this.scheduler(), MetadataLogConfig$.MODULE$.apply(this.config, 0x800000, 0x800000));
    }

    private NetworkClient buildNetworkClient() {
        ListenerName controllerListenerName = new ListenerName((String)this.config.controllerListenerNames().head());
        ChannelBuilder channelBuilder = ChannelBuilders.clientChannelBuilder((SecurityProtocol)((SecurityProtocol)this.config.effectiveListenerSecurityProtocolMap().getOrElse((Object)controllerListenerName, (Function0 & Serializable & scala.Serializable)() -> SecurityProtocol.forName((String)controllerListenerName.value()))), (JaasContext.Type)JaasContext.Type.SERVER, (AbstractConfig)this.config, (ListenerName)controllerListenerName, (String)this.config.saslMechanismControllerProtocol(), (Time)this.time, (boolean)this.config.saslInterBrokerHandshakeRequestEnable(), (LogContext)this.logContext());
        String metricGroupPrefix = "raft-channel";
        boolean collectPerConnectionMetrics = false;
        Selector selector = new Selector(-1, Predef$.MODULE$.Long2long(this.config.connectionsMaxIdleMs()), this.metrics, this.time, metricGroupPrefix, (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().empty()).asJava(), collectPerConnectionMetrics, channelBuilder, this.logContext());
        String clientId = new StringBuilder(12).append("raft-client-").append(this.config.nodeId()).toString();
        int maxInflightRequestsPerConnection = 1;
        int reconnectBackoffMs = 50;
        int reconnectBackoffMsMs = 500;
        boolean discoverBrokerVersions = true;
        return new NetworkClient((Selectable)selector, (MetadataUpdater)new ManualMetadataUpdater(), clientId, maxInflightRequestsPerConnection, (long)reconnectBackoffMs, (long)reconnectBackoffMsMs, -1, Predef$.MODULE$.Integer2int(this.config.socketReceiveBufferBytes()), Predef$.MODULE$.Integer2int(this.config.quorumRequestTimeoutMs()), Predef$.MODULE$.Long2long(this.config.connectionSetupTimeoutMs()), Predef$.MODULE$.Long2long(this.config.connectionSetupTimeoutMaxMs()), this.time, discoverBrokerVersions, this.apiVersions(), this.logContext());
    }

    @Override
    public LeaderAndEpoch leaderAndEpoch() {
        return this.client().leaderAndEpoch();
    }

    public static final /* synthetic */ void $anonfun$startup$1(KafkaRaftManager $this, Map.Entry voterAddressEntry) {
        RaftConfig.AddressSpec addressSpec = (RaftConfig.AddressSpec)voterAddressEntry.getValue();
        if (addressSpec instanceof RaftConfig.InetAddressSpec) {
            RaftConfig.InetAddressSpec inetAddressSpec = (RaftConfig.InetAddressSpec)addressSpec;
            $this.netChannel().updateEndpoint(Predef$.MODULE$.Integer2int((Integer)voterAddressEntry.getKey()), inetAddressSpec);
            return;
        }
        if (addressSpec instanceof RaftConfig.UnknownAddressSpec) {
            $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(79).append("Skipping channel update for destination ID: ").append(voterAddressEntry.getKey()).append(" ").append("because of non-routable endpoint: ").append(RaftConfig.NON_ROUTABLE_ADDRESS.toString()).toString());
            return;
        }
        if (addressSpec != null) {
            $this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(72).append("Unexpected address spec (type: ").append(addressSpec.getClass()).append(") for channel update for ").append("destination ID: ").append(voterAddressEntry.getKey()).toString());
            return;
        }
        throw new MatchError(null);
    }

    public KafkaRaftManager(MetaProperties metaProperties, KafkaConfig config, RecordSerde<T> recordSerde, TopicPartition topicPartition, Uuid topicId, Time time, Metrics metrics, Option<String> threadNamePrefixOpt, CompletableFuture<java.util.Map<Integer, RaftConfig.AddressSpec>> controllerQuorumVotersFuture, FaultHandler fatalFaultHandler) {
        this.metaProperties = metaProperties;
        this.config = config;
        this.recordSerde = recordSerde;
        this.topicPartition = topicPartition;
        this.topicId = topicId;
        this.time = time;
        this.metrics = metrics;
        this.controllerQuorumVotersFuture = controllerQuorumVotersFuture;
        Logging.$init$(this);
        this.apiVersions = new ApiVersions();
        this.raftConfig = new RaftConfig((AbstractConfig)config);
        this.threadNamePrefix = (String)threadNamePrefixOpt.getOrElse((Function0 & Serializable & scala.Serializable)() -> "kafka-raft");
        this.logContext = new LogContext(new StringBuilder(22).append("[RaftManager nodeId=").append(config.nodeId()).append("] ").toString());
        this.logIdent_$eq(this.logContext().logPrefix());
        this.scheduler = new KafkaScheduler(1, new StringBuilder(10).append(this.threadNamePrefix()).append("-scheduler").toString(), KafkaScheduler$.MODULE$.$lessinit$greater$default$3());
        this.scheduler().startup();
        this.dataDir = this.createDataDir();
        boolean differentMetadataLogDir = !((SeqLike)config.logDirs().map((Function1 & Serializable & scala.Serializable)x$2 -> Paths.get(x$2, new String[0]).toAbsolutePath(), Seq$.MODULE$.canBuildFrom())).contains((Object)Paths.get(config.metadataLogDir(), new String[0]).toAbsolutePath());
        Set<KafkaRaftServer.ProcessRole> set = config.processRoles();
        GenTraversable genTraversable = Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaRaftServer$ControllerRole$[]{KafkaRaftServer$ControllerRole$.MODULE$}));
        boolean isOnlyController = !(set != null ? !set.equals((Object)genTraversable) : genTraversable != null);
        this.dataDirLock = differentMetadataLogDir || isOnlyController ? new Some((Object)KafkaRaftManager$.MODULE$.kafka$raft$KafkaRaftManager$$lockDataDir(new File(config.metadataLogDir()))) : None$.MODULE$;
        this.replicatedLog = this.buildMetadataLog();
        this.netChannel = this.buildNetworkChannel();
        this.expirationTimer = new SystemTimer("raft-expiration-executor", SystemTimer$.MODULE$.$lessinit$greater$default$2(), SystemTimer$.MODULE$.$lessinit$greater$default$3(), SystemTimer$.MODULE$.$lessinit$greater$default$4());
        this.expirationService = new TimingWheelExpirationService(this.expirationTimer());
        this.client = this.buildRaftClient();
        this.raftIoThread = new RaftIoThread(this.client(), this.threadNamePrefix(), fatalFaultHandler);
    }

    public static class RaftIoThread
    extends ShutdownableThread {
        private final KafkaRaftClient<?> client;
        private final FaultHandler fatalFaultHandler;

        @Override
        public void doWork() {
            try {
                this.client.poll();
                return;
            }
            catch (Throwable t) {
                throw this.fatalFaultHandler.handleFault("Unexpected error in raft IO thread", t);
            }
        }

        @Override
        public boolean initiateShutdown() {
            if (super.initiateShutdown()) {
                this.client.shutdown(5000).whenComplete((x$1, exception) -> {
                    if (exception != null) {
                        this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Graceful shutdown of RaftClient failed", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> exception);
                        return;
                    }
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Completed graceful shutdown of RaftClient");
                });
                return true;
            }
            return false;
        }

        @Override
        public boolean isRunning() {
            return this.client.isRunning() && !this.isThreadFailed();
        }

        public RaftIoThread(KafkaRaftClient<?> client, String threadNamePrefix, FaultHandler fatalFaultHandler) {
            this.client = client;
            this.fatalFaultHandler = fatalFaultHandler;
            super(new StringBuilder(10).append(threadNamePrefix).append("-io-thread").toString(), false);
        }
    }
}

