/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.group;

import java.io.Serializable;
import java.util.concurrent.CompletableFuture;
import kafka.coordinator.group.GroupCoordinator;
import kafka.coordinator.group.JoinGroupResult;
import kafka.coordinator.group.LeaveGroupResult;
import kafka.coordinator.group.SyncGroupResult;
import kafka.server.RequestLocal;
import org.apache.kafka.common.message.HeartbeatRequestData;
import org.apache.kafka.common.message.HeartbeatResponseData;
import org.apache.kafka.common.message.JoinGroupRequestData;
import org.apache.kafka.common.message.JoinGroupResponseData;
import org.apache.kafka.common.message.LeaveGroupRequestData;
import org.apache.kafka.common.message.LeaveGroupResponseData;
import org.apache.kafka.common.message.SyncGroupRequestData;
import org.apache.kafka.common.message.SyncGroupResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.utils.BufferSupplier;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map$;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Builder;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001Y4A\u0001C\u0005\u0001!!AA\u0002\u0001BC\u0002\u0013\u0005A\u0005\u0003\u0005)\u0001\t\u0005\t\u0015!\u0003&\u0011\u0015I\u0003\u0001\"\u0001+\u0011\u0015i\u0003\u0001\"\u0011/\u0011\u0015!\u0006\u0001\"\u0011V\u0011\u0015\u0001\u0007\u0001\"\u0011b\u0011\u0015Y\u0007\u0001\"\u0011m\u0005]9%o\\;q\u0007>|'\u000fZ5oCR|'/\u00113baR,'O\u0003\u0002\u000b\u0017\u0005)qM]8va*\u0011A\"D\u0001\fG>|'\u000fZ5oCR|'OC\u0001\u000f\u0003\u0015Y\u0017MZ6b\u0007\u0001\u00192\u0001A\t\u001a!\t\u0011r#D\u0001\u0014\u0015\t!R#\u0001\u0003mC:<'\"\u0001\f\u0002\t)\fg/Y\u0005\u00031M\u0011aa\u00142kK\u000e$\bC\u0001\u000e#\u001b\u0005Y\"B\u0001\u0006\u001d\u0015\taQD\u0003\u0002\u000f=)\u0011q\u0004I\u0001\u0007CB\f7\r[3\u000b\u0003\u0005\n1a\u001c:h\u0013\t\u00193D\u0001\tHe>,\boQ8pe\u0012Lg.\u0019;peV\tQ\u0005\u0005\u0002'O5\t\u0011\"\u0003\u0002$\u0013\u0005a1m\\8sI&t\u0017\r^8sA\u00051A(\u001b8jiz\"\"a\u000b\u0017\u0011\u0005\u0019\u0002\u0001\"\u0002\u0007\u0004\u0001\u0004)\u0013!\u00036pS:<%o\\;q)\u0011ysh\u0012'\u0011\u0007A*t'D\u00012\u0015\t\u00114'\u0001\u0006d_:\u001cWO\u001d:f]RT!\u0001N\u000b\u0002\tU$\u0018\u000e\\\u0005\u0003mE\u0012\u0011cQ8na2,G/\u00192mK\u001a+H/\u001e:f!\tAT(D\u0001:\u0015\tQ4(A\u0004nKN\u001c\u0018mZ3\u000b\u0005qj\u0012AB2p[6|g.\u0003\u0002?s\t)\"j\\5o\u000fJ|W\u000f\u001d*fgB|gn]3ECR\f\u0007\"\u0002!\u0005\u0001\u0004\t\u0015aB2p]R,\u0007\u0010\u001e\t\u0003\u0005\u0016k\u0011a\u0011\u0006\u0003\tn\n\u0001B]3rk\u0016\u001cHo]\u0005\u0003\r\u000e\u0013aBU3rk\u0016\u001cHoQ8oi\u0016DH\u000fC\u0003I\t\u0001\u0007\u0011*A\u0004sKF,Xm\u001d;\u0011\u0005aR\u0015BA&:\u0005QQu.\u001b8He>,\bOU3rk\u0016\u001cH\u000fR1uC\")Q\n\u0002a\u0001\u001d\u0006q!-\u001e4gKJ\u001cV\u000f\u001d9mS\u0016\u0014\bCA(S\u001b\u0005\u0001&BA)<\u0003\u0015)H/\u001b7t\u0013\t\u0019\u0006K\u0001\bCk\u001a4WM]*vaBd\u0017.\u001a:\u0002\u0013MLhnY$s_V\u0004H\u0003\u0002,[7~\u00032\u0001M\u001bX!\tA\u0004,\u0003\u0002Zs\t)2+\u001f8d\u000fJ|W\u000f\u001d*fgB|gn]3ECR\f\u0007\"\u0002!\u0006\u0001\u0004\t\u0005\"\u0002%\u0006\u0001\u0004a\u0006C\u0001\u001d^\u0013\tq\u0016H\u0001\u000bTs:\u001cwI]8vaJ+\u0017/^3ti\u0012\u000bG/\u0019\u0005\u0006\u001b\u0016\u0001\rAT\u0001\nQ\u0016\f'\u000f\u001e2fCR$2A\u00194h!\r\u0001Tg\u0019\t\u0003q\u0011L!!Z\u001d\u0003+!+\u0017M\u001d;cK\u0006$(+Z:q_:\u001cX\rR1uC\")\u0001I\u0002a\u0001\u0003\")\u0001J\u0002a\u0001QB\u0011\u0001([\u0005\u0003Uf\u0012A\u0003S3beR\u0014W-\u0019;SKF,Xm\u001d;ECR\f\u0017A\u00037fCZ,wI]8vaR\u0019Q.\u001d:\u0011\u0007A*d\u000e\u0005\u00029_&\u0011\u0001/\u000f\u0002\u0017\u0019\u0016\fg/Z$s_V\u0004(+Z:q_:\u001cX\rR1uC\")\u0001i\u0002a\u0001\u0003\")\u0001j\u0002a\u0001gB\u0011\u0001\b^\u0005\u0003kf\u0012Q\u0003T3bm\u0016<%o\\;q%\u0016\fX/Z:u\t\u0006$\u0018\r")
public class GroupCoordinatorAdapter
implements org.apache.kafka.coordinator.group.GroupCoordinator {
    private final GroupCoordinator coordinator;

    public GroupCoordinator coordinator() {
        return this.coordinator;
    }

    public CompletableFuture<JoinGroupResponseData> joinGroup(RequestContext context, JoinGroupRequestData request, BufferSupplier bufferSupplier) {
        CompletableFuture<JoinGroupResponseData> future = new CompletableFuture<JoinGroupResponseData>();
        Option groupInstanceId = Option$.MODULE$.apply((Object)request.groupInstanceId());
        boolean requireKnownMemberId = context.apiVersion() >= 4 && groupInstanceId.isEmpty();
        List protocols = ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(request.protocols().valuesList()).asScala()).map((Function1 & Serializable & scala.Serializable)protocol -> new Tuple2((Object)protocol.name(), (Object)protocol.metadata()), Buffer$.MODULE$.canBuildFrom())).toList();
        boolean supportSkippingAssignment = context.apiVersion() >= 9;
        this.coordinator().handleJoinGroup(request.groupId(), request.memberId(), (Option<String>)groupInstanceId, requireKnownMemberId, supportSkippingAssignment, context.clientId(), context.clientAddress.toString(), request.rebalanceTimeoutMs(), request.sessionTimeoutMs(), request.protocolType(), (List<Tuple2<String, byte[]>>)protocols, (Function1<JoinGroupResult, BoxedUnit>)(Function1 & Serializable & scala.Serializable)joinResult -> {
            GroupCoordinatorAdapter.callback$1(joinResult, future);
            return BoxedUnit.UNIT;
        }, (Option<String>)Option$.MODULE$.apply((Object)request.reason()), new RequestLocal(bufferSupplier));
        return future;
    }

    public CompletableFuture<SyncGroupResponseData> syncGroup(RequestContext context, SyncGroupRequestData request, BufferSupplier bufferSupplier) {
        CompletableFuture<SyncGroupResponseData> future = new CompletableFuture<SyncGroupResponseData>();
        Builder assignmentMap = Map$.MODULE$.newBuilder();
        request.assignments().forEach(assignment -> assignmentMap.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)assignment.memberId()), (Object)assignment.assignment())));
        this.coordinator().handleSyncGroup(request.groupId(), request.generationId(), request.memberId(), (Option<String>)Option$.MODULE$.apply((Object)request.protocolType()), (Option<String>)Option$.MODULE$.apply((Object)request.protocolName()), (Option<String>)Option$.MODULE$.apply((Object)request.groupInstanceId()), (Map<String, byte[]>)((Map)assignmentMap.result()), (Function1<SyncGroupResult, BoxedUnit>)(Function1 & Serializable & scala.Serializable)syncGroupResult -> {
            GroupCoordinatorAdapter.callback$2(syncGroupResult, future);
            return BoxedUnit.UNIT;
        }, new RequestLocal(bufferSupplier));
        return future;
    }

    /*
     * WARNING - void declaration
     */
    public CompletableFuture<HeartbeatResponseData> heartbeat(RequestContext context, HeartbeatRequestData request) {
        void var3_3;
        CompletableFuture future = new CompletableFuture();
        this.coordinator().handleHeartbeat(request.groupId(), request.memberId(), (Option<String>)Option$.MODULE$.apply((Object)request.groupInstanceId()), request.generationId(), (Function1<Errors, BoxedUnit>)(Function1 & Serializable & scala.Serializable)error -> {
            future.complete(new HeartbeatResponseData().setErrorCode(error.code()));
            return BoxedUnit.UNIT;
        });
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public CompletableFuture<LeaveGroupResponseData> leaveGroup(RequestContext context, LeaveGroupRequestData request) {
        void var3_3;
        CompletableFuture future = new CompletableFuture();
        this.coordinator().handleLeaveGroup(request.groupId(), (List<LeaveGroupRequestData.MemberIdentity>)((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(request.members()).asScala()).toList(), (Function1<LeaveGroupResult, BoxedUnit>)(Function1 & Serializable & scala.Serializable)leaveGroupResult -> {
            GroupCoordinatorAdapter.callback$3(leaveGroupResult, future);
            return BoxedUnit.UNIT;
        });
        return var3_3;
    }

    private static final void callback$1(JoinGroupResult joinResult, CompletableFuture future$1) {
        future$1.complete(new JoinGroupResponseData().setErrorCode(joinResult.error().code()).setGenerationId(joinResult.generationId()).setProtocolType((String)joinResult.protocolType().orNull(Predef$.MODULE$.$conforms())).setProtocolName((String)joinResult.protocolName().orNull(Predef$.MODULE$.$conforms())).setLeader(joinResult.leaderId()).setSkipAssignment(joinResult.skipAssignment()).setMemberId(joinResult.memberId()).setMembers((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter(joinResult.members()).asJava()));
    }

    private static final void callback$2(SyncGroupResult syncGroupResult, CompletableFuture future$2) {
        future$2.complete(new SyncGroupResponseData().setErrorCode(syncGroupResult.error().code()).setProtocolType((String)syncGroupResult.protocolType().orNull(Predef$.MODULE$.$conforms())).setProtocolName((String)syncGroupResult.protocolName().orNull(Predef$.MODULE$.$conforms())).setAssignment(syncGroupResult.memberAssignment()));
    }

    private static final void callback$3(LeaveGroupResult leaveGroupResult, CompletableFuture future$4) {
        future$4.complete(new LeaveGroupResponseData().setErrorCode(leaveGroupResult.topLevelError().code()).setMembers((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)leaveGroupResult.memberResponses().map((Function1 & Serializable & scala.Serializable)member -> new LeaveGroupResponseData.MemberResponse().setErrorCode(member.error().code()).setMemberId(member.memberId()).setGroupInstanceId((String)member.groupInstanceId().orNull(Predef$.MODULE$.$conforms())), List$.MODULE$.canBuildFrom())).asJava()));
    }

    public GroupCoordinatorAdapter(GroupCoordinator coordinator) {
        this.coordinator = coordinator;
    }
}

