/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.Serializable;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import kafka.cluster.Broker;
import kafka.controller.ControllerBrokerStateInfo;
import kafka.controller.ControllerChannelManager$;
import kafka.controller.QueueItem;
import kafka.controller.RequestSendThread;
import kafka.controller.StateChangeLogger;
import kafka.metrics.KafkaMetricsGroup;
import kafka.server.KafkaConfig;
import kafka.utils.Logging;
import org.apache.kafka.clients.ApiVersions;
import org.apache.kafka.clients.ManualMetadataUpdater;
import org.apache.kafka.clients.MetadataUpdater;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.Reconfigurable;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ChannelBuilder;
import org.apache.kafka.common.network.ChannelBuilders;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.Selectable;
import org.apache.kafka.common.network.Selector;
import org.apache.kafka.common.requests.AbstractControlRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.security.JaasContext;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Ex!\u0002\u0010 \u0011\u0003!c!\u0002\u0014 \u0011\u00039\u0003\"\u0002\u0018\u0002\t\u0003y\u0003b\u0002\u0019\u0002\u0005\u0004%\t!\r\u0005\u0007u\u0005\u0001\u000b\u0011\u0002\u001a\t\u000fm\n!\u0019!C\u0001c!1A(\u0001Q\u0001\nIBq!P\u0001\u0012\u0002\u0013\u0005aH\u0002\u0003'?\u00011\u0006\u0002C2\t\u0005\u0003\u0005\u000b\u0011\u00023\t\u0011)D!\u0011!Q\u0001\n-D\u0001\"\u001d\u0005\u0003\u0002\u0003\u0006IA\u001d\u0005\tA\"\u0011\t\u0011)A\u0005}\"Q\u0011q\u0001\u0005\u0003\u0002\u0003\u0006I!!\u0003\t\u0013\u0005=\u0001B!A!\u0002\u0013\u0001\u0005B\u0002\u0018\t\t\u0003\t\t\u0002C\u0005\u0002\"!\u0011\r\u0011\"\u0005\u0002$!A\u00111\b\u0005!\u0002\u0013\t)\u0003C\u0005\u0002>!\u0011\r\u0011\"\u0003\u0002@!A\u0011q\t\u0005!\u0002\u0013\t\t\u0005C\u0004\u0002J!!\t!a\u0013\t\u000f\u0005-\u0004\u0002\"\u0001\u0002n!9\u0011q\u000e\u0005\u0005\u0002\u0005E\u0004\"CA\\\u0011E\u0005I\u0011AA]\u0011\u001d\ti\f\u0003C\u0001\u0003\u007fCq!!2\t\t\u0003\t9\rC\u0004\u0002L\"!I!!4\t\u000f\u0005E\u0007\u0002\"\u0003\u0002T\"9\u00111\u001d\u0005\u0005\n\u0005\u0015\bbBAv\u0011\u0011E\u0011Q^\u0001\u0019\u0007>tGO]8mY\u0016\u00148\t[1o]\u0016dW*\u00198bO\u0016\u0014(B\u0001\u0011\"\u0003)\u0019wN\u001c;s_2dWM\u001d\u0006\u0002E\u0005)1.\u00194lC\u000e\u0001\u0001CA\u0013\u0002\u001b\u0005y\"\u0001G\"p]R\u0014x\u000e\u001c7fe\u000eC\u0017M\u001c8fY6\u000bg.Y4feN\u0011\u0011\u0001\u000b\t\u0003S1j\u0011A\u000b\u0006\u0002W\u0005)1oY1mC&\u0011QF\u000b\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005!\u0013aE)vKV,7+\u001b>f\u001b\u0016$(/[2OC6,W#\u0001\u001a\u0011\u0005MBT\"\u0001\u001b\u000b\u0005U2\u0014\u0001\u00027b]\u001eT\u0011aN\u0001\u0005U\u00064\u0018-\u0003\u0002:i\t11\u000b\u001e:j]\u001e\fA#U;fk\u0016\u001c\u0016N_3NKR\u0014\u0018n\u0019(b[\u0016\u0004\u0013!\t*fcV,7\u000f\u001e*bi\u0016\fe\u000eZ)vKV,G+[7f\u001b\u0016$(/[2OC6,\u0017A\t*fcV,7\u000f\u001e*bi\u0016\fe\u000eZ)vKV,G+[7f\u001b\u0016$(/[2OC6,\u0007%A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HEN\u000b\u0002\u007f)\u0012\u0001)\u0014\t\u0004S\u0005\u001b\u0015B\u0001\"+\u0005\u0019y\u0005\u000f^5p]B\u0011Ai\u0013\b\u0003\u000b&\u0003\"A\u0012\u0016\u000e\u0003\u001dS!\u0001S\u0012\u0002\rq\u0012xn\u001c;?\u0013\tQ%&\u0001\u0004Qe\u0016$WMZ\u0005\u0003s1S!A\u0013\u0016,\u00039\u0003\"a\u0014+\u000e\u0003AS!!\u0015*\u0002\u0013Ut7\r[3dW\u0016$'BA*+\u0003)\tgN\\8uCRLwN\\\u0005\u0003+B\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f'\u0011A\u0001fV/\u0011\u0005a[V\"A-\u000b\u0005i\u000b\u0013!B;uS2\u001c\u0018B\u0001/Z\u0005\u001daunZ4j]\u001e\u0004\"AX1\u000e\u0003}S!\u0001Y\u0011\u0002\u000f5,GO]5dg&\u0011!m\u0018\u0002\u0012\u0017\u000647.Y'fiJL7m]$s_V\u0004\u0018aD2p]R\u0014x\u000e\u001c7fe\u0016\u0003xn\u00195\u0011\u0007%*w-\u0003\u0002gU\tIa)\u001e8di&|g\u000e\r\t\u0003S!L!!\u001b\u0016\u0003\u0007%sG/\u0001\u0004d_:4\u0017n\u001a\t\u0003Y>l\u0011!\u001c\u0006\u0003]\u0006\naa]3sm\u0016\u0014\u0018B\u00019n\u0005-Y\u0015MZ6b\u0007>tg-[4\u0002\tQLW.\u001a\t\u0003grl\u0011\u0001\u001e\u0006\u00035VT!A^<\u0002\r\r|W.\\8o\u0015\t\u0011\u0003P\u0003\u0002zu\u00061\u0011\r]1dQ\u0016T\u0011a_\u0001\u0004_J<\u0017BA?u\u0005\u0011!\u0016.\\3\u0011\u0007}\f\u0019!\u0004\u0002\u0002\u0002)\u0011\u0001-^\u0005\u0005\u0003\u000b\t\tAA\u0004NKR\u0014\u0018nY:\u0002#M$\u0018\r^3DQ\u0006tw-\u001a'pO\u001e,'\u000fE\u0002&\u0003\u0017I1!!\u0004 \u0005E\u0019F/\u0019;f\u0007\"\fgnZ3M_\u001e<WM]\u0001\u0011i\"\u0014X-\u00193OC6,\u0007K]3gSb$b\"a\u0005\u0002\u0016\u0005]\u0011\u0011DA\u000e\u0003;\ty\u0002\u0005\u0002&\u0011!)1m\u0004a\u0001I\")!n\u0004a\u0001W\")\u0011o\u0004a\u0001e\")\u0001m\u0004a\u0001}\"9\u0011qA\bA\u0002\u0005%\u0001\u0002CA\b\u001fA\u0005\t\u0019\u0001!\u0002\u001f\t\u0014xn[3s'R\fG/Z%oM>,\"!!\n\u0011\u000f\u0005\u001d\u0012\u0011G4\u000265\u0011\u0011\u0011\u0006\u0006\u0005\u0003W\ti#A\u0004nkR\f'\r\\3\u000b\u0007\u0005=\"&\u0001\u0006d_2dWm\u0019;j_:LA!a\r\u0002*\t9\u0001*Y:i\u001b\u0006\u0004\bcA\u0013\u00028%\u0019\u0011\u0011H\u0010\u00033\r{g\u000e\u001e:pY2,'O\u0011:pW\u0016\u00148\u000b^1uK&sgm\\\u0001\u0011EJ|7.\u001a:Ti\u0006$X-\u00138g_\u0002\n!B\u0019:pW\u0016\u0014Hj\\2l+\t\t\t\u0005E\u00024\u0003\u0007J1!!\u00125\u0005\u0019y%M[3di\u0006Y!M]8lKJdunY6!\u0003\u001d\u0019H/\u0019:ukB$B!!\u0014\u0002TA\u0019\u0011&a\u0014\n\u0007\u0005E#F\u0001\u0003V]&$\bbBA+)\u0001\u0007\u0011qK\u0001\u000fS:LG/[1m\u0005J|7.\u001a:t!\u0019\tI&a\u0017\u0002`5\u0011\u0011QF\u0005\u0005\u0003;\niCA\u0002TKR\u0004B!!\u0019\u0002h5\u0011\u00111\r\u0006\u0004\u0003K\n\u0013aB2mkN$XM]\u0005\u0005\u0003S\n\u0019G\u0001\u0004Ce>\\WM]\u0001\tg\",H\u000fZ8x]R\u0011\u0011QJ\u0001\fg\u0016tGMU3rk\u0016\u001cH\u000f\u0006\u0005\u0002N\u0005M\u0014qOAT\u0011\u0019\t)H\u0006a\u0001O\u0006A!M]8lKJLE\rC\u0004\u0002zY\u0001\r!a\u001f\u0002\u000fI,\u0017/^3tiB\"\u0011QPAK!\u0019\ty(a#\u0002\u0012:!\u0011\u0011QAD\u001b\t\t\u0019IC\u0002\u0002\u0006V\f\u0001B]3rk\u0016\u001cHo]\u0005\u0005\u0003\u0013\u000b\u0019)\u0001\fBEN$(/Y2u\u0007>tGO]8m%\u0016\fX/Z:u\u0013\u0011\ti)a$\u0003\u000f\t+\u0018\u000e\u001c3fe*!\u0011\u0011RAB!\u0011\t\u0019*!&\r\u0001\u0011a\u0011qSA<\u0003\u0003\u0005\tQ!\u0001\u0002\u001a\n\u0019q\fJ\u0019\u0012\t\u0005m\u0015\u0011\u0015\t\u0004S\u0005u\u0015bAAPU\t9aj\u001c;iS:<\u0007\u0003BAA\u0003GKA!!*\u0002\u0004\n1\u0012IY:ue\u0006\u001cGoQ8oiJ|GNU3rk\u0016\u001cH\u000fC\u0005\u0002*Z\u0001\n\u00111\u0001\u0002,\u0006A1-\u00197mE\u0006\u001c7\u000eE\u0004*\u0003[\u000b\t,!\u0014\n\u0007\u0005=&FA\u0005Gk:\u001cG/[8ocA!\u0011\u0011QAZ\u0013\u0011\t),a!\u0003!\u0005\u00137\u000f\u001e:bGR\u0014Vm\u001d9p]N,\u0017!F:f]\u0012\u0014V-];fgR$C-\u001a4bk2$HeM\u000b\u0003\u0003wS3!a+N\u0003%\tG\r\u001a\"s_.,'\u000f\u0006\u0003\u0002N\u0005\u0005\u0007bBAb1\u0001\u0007\u0011qL\u0001\u0007EJ|7.\u001a:\u0002\u0019I,Wn\u001c<f\u0005J|7.\u001a:\u0015\t\u00055\u0013\u0011\u001a\u0005\u0007\u0003kJ\u0002\u0019A4\u0002\u0019\u0005$GMT3x\u0005J|7.\u001a:\u0015\t\u00055\u0013q\u001a\u0005\b\u0003\u0007T\u0002\u0019AA0\u0003A\u0011'o\\6fe6+GO]5d)\u0006<7\u000f\u0006\u0003\u0002V\u0006\u0005\bCBAl\u0003;\u0014$'\u0004\u0002\u0002Z*!\u00111\\A\u0017\u0003%IW.\\;uC\ndW-\u0003\u0003\u0002`\u0006e'aA'ba\"1\u0011QO\u000eA\u0002\u001d\fAC]3n_Z,W\t_5ti&twM\u0011:pW\u0016\u0014H\u0003BA'\u0003ODq!!;\u001d\u0001\u0004\t)$A\u0006ce>\\WM]*uCR,\u0017AF:uCJ$(+Z9vKN$8+\u001a8e)\"\u0014X-\u00193\u0015\t\u00055\u0013q\u001e\u0005\u0007\u0003kj\u0002\u0019A4")
public class ControllerChannelManager
implements KafkaMetricsGroup {
    private final Function0<Object> controllerEpoch;
    private final KafkaConfig config;
    private final Time time;
    private final Metrics metrics;
    private final StateChangeLogger stateChangeLogger;
    private final Option<String> threadNamePrefix;
    private final HashMap<Object, ControllerBrokerStateInfo> brokerStateInfo;
    private final Object brokerLock;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Option<String> $lessinit$greater$default$6() {
        return ControllerChannelManager$.MODULE$.$lessinit$greater$default$6();
    }

    public static String RequestRateAndQueueTimeMetricName() {
        return ControllerChannelManager$.MODULE$.RequestRateAndQueueTimeMetricName();
    }

    public static String QueueSizeMetricName() {
        return ControllerChannelManager$.MODULE$.QueueSizeMetricName();
    }

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Meter newMeter(MetricName metricName, String eventType, TimeUnit timeUnit) {
        return KafkaMetricsGroup.newMeter$(this, metricName, eventType, timeUnit);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public HashMap<Object, ControllerBrokerStateInfo> brokerStateInfo() {
        return this.brokerStateInfo;
    }

    private Object brokerLock() {
        return this.brokerLock;
    }

    public void startup(Set<Broker> initialBrokers) {
        initialBrokers.foreach((Function1 & Serializable & scala.Serializable)broker -> {
            this.addNewBroker(broker);
            return BoxedUnit.UNIT;
        });
        Object object = this.brokerLock();
        synchronized (object) {
            this.brokerStateInfo().foreach((Function1 & Serializable & scala.Serializable)brokerState -> {
                this.startRequestSendThread(brokerState._1$mcI$sp());
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public void shutdown() {
        Object object = this.brokerLock();
        synchronized (object) {
            this.brokerStateInfo().values().toList().foreach((Function1 & Serializable & scala.Serializable)brokerState -> {
                this.removeExistingBroker(brokerState);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public void sendRequest(int brokerId, AbstractControlRequest.Builder<? extends AbstractControlRequest> request, Function1<AbstractResponse, BoxedUnit> callback) {
        Object object = this.brokerLock();
        synchronized (object) {
            Option stateInfoOpt = this.brokerStateInfo().get((Object)BoxesRunTime.boxToInteger((int)brokerId));
            if (stateInfoOpt instanceof Some) {
                ((ControllerBrokerStateInfo)((Some)stateInfoOpt).value()).messageQueue().put(new QueueItem(request.apiKey(), request, callback, this.time.milliseconds()));
            } else if (None$.MODULE$.equals(stateInfoOpt)) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(53).append("Not sending request ").append(request).append(" to broker ").append(brokerId).append(", since it is offline.").toString());
            } else {
                throw new MatchError((Object)stateInfoOpt);
            }
            return;
        }
    }

    public Function1<AbstractResponse, BoxedUnit> sendRequest$default$3() {
        return null;
    }

    public void addBroker(Broker broker) {
        Object object = this.brokerLock();
        synchronized (object) {
            if (!this.brokerStateInfo().contains((Object)BoxesRunTime.boxToInteger((int)broker.id()))) {
                this.addNewBroker(broker);
                this.startRequestSendThread(broker.id());
            }
            return;
        }
    }

    public void removeBroker(int brokerId) {
        Object object = this.brokerLock();
        synchronized (object) {
            this.removeExistingBroker((ControllerBrokerStateInfo)this.brokerStateInfo().apply((Object)BoxesRunTime.boxToInteger((int)brokerId)));
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void addNewBroker(Broker broker) {
        String string;
        void var12_11;
        void var11_10;
        None$ none$;
        LinkedBlockingQueue<QueueItem> messageQueue = new LinkedBlockingQueue<QueueItem>();
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("Controller ").append($this.config.brokerId()).append(" trying to connect to broker ").append(broker.id()).toString());
        ListenerName controllerToBrokerListenerName = (ListenerName)this.config.controlPlaneListenerName().getOrElse((Function0 & Serializable & scala.Serializable)() -> $this.config.interBrokerListenerName());
        SecurityProtocol controllerToBrokerSecurityProtocol = (SecurityProtocol)this.config.controlPlaneSecurityProtocol().getOrElse((Function0 & Serializable & scala.Serializable)() -> $this.config.interBrokerSecurityProtocol());
        Node brokerNode = broker.node(controllerToBrokerListenerName);
        LogContext logContext = new LogContext(new StringBuilder(34).append("[Controller id=").append(this.config.brokerId()).append(", targetBrokerId=").append(brokerNode.idString()).append("] ").toString());
        ChannelBuilder channelBuilder = ChannelBuilders.clientChannelBuilder((SecurityProtocol)controllerToBrokerSecurityProtocol, (JaasContext.Type)JaasContext.Type.SERVER, (AbstractConfig)this.config, (ListenerName)controllerToBrokerListenerName, (String)this.config.saslMechanismInterBrokerProtocol(), (Time)this.time, (boolean)this.config.saslInterBrokerHandshakeRequestEnable(), (LogContext)logContext);
        if (channelBuilder instanceof Reconfigurable) {
            this.config.addReconfigurable((Reconfigurable)channelBuilder);
            none$ = new Some((Object)channelBuilder);
        } else {
            none$ = None$.MODULE$;
        }
        Selector selector = new Selector(-1, -1L, this.metrics, this.time, "controller-channel", (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"broker-id"), (Object)brokerNode.idString())}))).asJava(), false, channelBuilder, logContext);
        NetworkClient networkClient = new NetworkClient((Selectable)selector, (MetadataUpdater)new ManualMetadataUpdater((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)brokerNode, (List)Nil$.MODULE$)).asJava()), Integer.toString(this.config.brokerId()), 1, 0L, 0L, -1, -1, Predef$.MODULE$.Integer2int(this.config.requestTimeoutMs()), Predef$.MODULE$.Long2long(this.config.connectionSetupTimeoutMs()), Predef$.MODULE$.Long2long(this.config.connectionSetupTimeoutMaxMs()), this.time, false, new ApiVersions(), logContext);
        Option reconfigurableChannelBuilder = (Option)none$;
        void networkClient2 = var11_10;
        void reconfigurableChannelBuilder2 = var12_11;
        Option<String> option = this.threadNamePrefix;
        if (None$.MODULE$.equals(option)) {
            string = new StringBuilder(34).append("Controller-").append(this.config.brokerId()).append("-to-broker-").append(broker.id()).append("-send-thread").toString();
        } else if (option instanceof Some) {
            String name = (String)((Some)option).value();
            string = new StringBuilder(35).append(name).append(":Controller-").append(this.config.brokerId()).append("-to-broker-").append(broker.id()).append("-send-thread").toString();
        } else {
            throw new MatchError(option);
        }
        Timer requestRateAndQueueTimeMetrics = this.newTimer(ControllerChannelManager$.MODULE$.RequestRateAndQueueTimeMetricName(), TimeUnit.MILLISECONDS, TimeUnit.SECONDS, (Map<String, String>)this.brokerMetricTags(broker.id()));
        RequestSendThread requestThread = new RequestSendThread(this.config.brokerId(), this.controllerEpoch, messageQueue, (NetworkClient)networkClient2, brokerNode, this.config, this.time, requestRateAndQueueTimeMetrics, this.stateChangeLogger, string);
        requestThread.setDaemon(false);
        Gauge<Object> queueSizeGauge = this.newGauge(ControllerChannelManager$.MODULE$.QueueSizeMetricName(), (Gauge)new Gauge<Object>(this, messageQueue){
            private final /* synthetic */ ControllerChannelManager $outer;
            private final LinkedBlockingQueue messageQueue$1;

            public final int value() {
                return ControllerChannelManager.kafka$controller$ControllerChannelManager$$$anonfun$addNewBroker$4(this.messageQueue$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.messageQueue$1 = messageQueue$1;
            }
        }, (Map<String, String>)this.brokerMetricTags(broker.id()));
        this.brokerStateInfo().put((Object)BoxesRunTime.boxToInteger((int)broker.id()), (Object)new ControllerBrokerStateInfo((NetworkClient)networkClient2, brokerNode, messageQueue, requestThread, queueSizeGauge, requestRateAndQueueTimeMetrics, (Option<Reconfigurable>)reconfigurableChannelBuilder2));
    }

    private scala.collection.immutable.Map<String, String> brokerMetricTags(int brokerId) {
        return (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"broker-id"), (Object)Integer.toString(brokerId))}));
    }

    private void removeExistingBroker(ControllerBrokerStateInfo brokerState) {
        try {
            brokerState.reconfigurableChannelBuilder().foreach((Function1 & Serializable & scala.Serializable)reconfigurable -> {
                this.config.removeReconfigurable(reconfigurable);
                return BoxedUnit.UNIT;
            });
            brokerState.requestSendThread().shutdown();
            brokerState.networkClient().close();
            brokerState.messageQueue().clear();
            this.removeMetric(ControllerChannelManager$.MODULE$.QueueSizeMetricName(), (Map<String, String>)this.brokerMetricTags(brokerState.brokerNode().id()));
            this.removeMetric(ControllerChannelManager$.MODULE$.RequestRateAndQueueTimeMetricName(), (Map<String, String>)this.brokerMetricTags(brokerState.brokerNode().id()));
            this.brokerStateInfo().remove((Object)BoxesRunTime.boxToInteger((int)brokerState.brokerNode().id()));
            return;
        }
        catch (Throwable e) {
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error while removing broker by the controller", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
            return;
        }
    }

    public void startRequestSendThread(int brokerId) {
        block7: {
            RequestSendThread requestThread;
            block6: {
                Thread.State state;
                Thread.State state2;
                block5: {
                    requestThread = ((ControllerBrokerStateInfo)this.brokerStateInfo().apply((Object)BoxesRunTime.boxToInteger((int)brokerId))).requestSendThread();
                    state2 = requestThread.getState();
                    state = Thread.State.NEW;
                    if (state2 != null) break block5;
                    if (state != null) {
                        return;
                    }
                    break block6;
                }
                if (!((Object)((Object)state2)).equals((Object)state)) break block7;
            }
            requestThread.start();
        }
    }

    public static final /* synthetic */ int $anonfun$new$2(ControllerBrokerStateInfo x$1) {
        return x$1.messageQueue().size();
    }

    public final /* synthetic */ int kafka$controller$ControllerChannelManager$$$anonfun$new$1() {
        Object object = this.brokerLock();
        synchronized (object) {
            int n = BoxesRunTime.unboxToInt((Object)this.brokerStateInfo().values().iterator().map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)ControllerChannelManager.$anonfun$new$2(x$1))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
            return n;
        }
    }

    public static final /* synthetic */ int kafka$controller$ControllerChannelManager$$$anonfun$addNewBroker$4(LinkedBlockingQueue messageQueue$1) {
        return messageQueue$1.size();
    }

    public ControllerChannelManager(Function0<Object> controllerEpoch, KafkaConfig config, Time time, Metrics metrics, StateChangeLogger stateChangeLogger, Option<String> threadNamePrefix) {
        this.controllerEpoch = controllerEpoch;
        this.config = config;
        this.time = time;
        this.metrics = metrics;
        this.stateChangeLogger = stateChangeLogger;
        this.threadNamePrefix = threadNamePrefix;
        Logging.$init$(this);
        KafkaMetricsGroup.$init$(this);
        this.brokerStateInfo = new HashMap();
        this.brokerLock = new Object();
        this.logIdent_$eq(new StringBuilder(34).append("[Channel manager on controller ").append(config.brokerId()).append("]: ").toString());
        this.newGauge("TotalQueueSize", new Gauge<Object>(this){
            private final /* synthetic */ ControllerChannelManager $outer;

            public final int value() {
                return this.$outer.kafka$controller$ControllerChannelManager$$$anonfun$new$1();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
    }
}

