/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import java.util.regex.Pattern;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import kafka.common.MessageReader;
import kafka.message.DefaultCompressionCodec$;
import kafka.message.NoCompressionCodec$;
import kafka.tools.ConsoleProducer$;
import kafka.utils.CommandDefaultOptions;
import kafka.utils.CommandDefaultOptions$;
import kafka.utils.CommandLineUtils$;
import kafka.utils.ToolsUtils$;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.KafkaException;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\rUt!\u0002<x\u0011\u0003ah!\u0002@x\u0011\u0003y\bbBA\u0007\u0003\u0011\u0005\u0011q\u0002\u0005\b\u0003#\tA\u0011AA\n\u0011\u001d\tY$\u0001C\u0005\u0003{Aq!a\u001e\u0002\t\u0003\tI\bC\u0004\u0003z\u0005!\tAa\u001f\u0007\r\u0005M\u0015\u0001AAK\u00111\tib\u0002B\u0001B\u0003%\u0011qDAR\u0011\u001d\tia\u0002C\u0001\u0003KC\u0011\"!+\b\u0005\u0004%\t!a+\t\u0011\u0005ev\u0001)A\u0005\u0003[C\u0011\"a/\b\u0005\u0004%\t!a+\t\u0011\u0005uv\u0001)A\u0005\u0003[C\u0011\"a0\b\u0005\u0004%\t!a+\t\u0011\u0005\u0005w\u0001)A\u0005\u0003[C\u0011\"a1\b\u0005\u0004%\t!!2\t\u0011\u00055w\u0001)A\u0005\u0003\u000fD\u0011\"a4\b\u0005\u0004%\t!a+\t\u0011\u0005Ew\u0001)A\u0005\u0003[C\u0011\"a5\b\u0005\u0004%\t!!6\t\u0011\u0005\u0015x\u0001)A\u0005\u0003/D\u0011\"a:\b\u0005\u0004%\t!!6\t\u0011\u0005%x\u0001)A\u0005\u0003/D\u0011\"a;\b\u0005\u0004%\t!!<\t\u0011\u0005]x\u0001)A\u0005\u0003_D\u0011\"!?\b\u0005\u0004%\t!!<\t\u0011\u0005mx\u0001)A\u0005\u0003_D\u0011\"!@\b\u0005\u0004%\t!a@\t\u0011\t\u001dq\u0001)A\u0005\u0005\u0003A\u0011B!\u0003\b\u0005\u0004%\t!!6\t\u0011\t-q\u0001)A\u0005\u0003/D\u0011B!\u0004\b\u0005\u0004%\t!!<\t\u0011\t=q\u0001)A\u0005\u0003_D\u0011B!\u0005\b\u0005\u0004%\t!!<\t\u0011\tMq\u0001)A\u0005\u0003_D\u0011B!\u0006\b\u0005\u0004%\t!!<\t\u0011\t]q\u0001)A\u0005\u0003_D\u0011B!\u0007\b\u0005\u0004%\t!!6\t\u0011\tmq\u0001)A\u0005\u0003/D\u0011B!\b\b\u0005\u0004%\t!a@\t\u0011\t}q\u0001)A\u0005\u0005\u0003A\u0011B!\t\b\u0005\u0004%\t!!6\t\u0011\t\rr\u0001)A\u0005\u0003/D\u0011B!\n\b\u0005\u0004%\t!a+\t\u0011\t\u001dr\u0001)A\u0005\u0003[C\u0011B!\u000b\b\u0005\u0004%\t!a+\t\u0011\t-r\u0001)A\u0005\u0003[C\u0011B!\f\b\u0005\u0004%\t!a+\t\u0011\t=r\u0001)A\u0005\u0003[C\u0011B!\r\b\u0005\u0004%\t!a+\t\u0011\tMr\u0001)A\u0005\u0003[C\u0011B!\u000e\b\u0005\u0004%\tAa\u000e\t\u0011\ter\u0001)A\u0005\u0003KA\u0011Ba\u000f\b\u0005\u0004%\tAa\u000e\t\u0011\tur\u0001)A\u0005\u0003KA\u0011Ba\u0010\b\u0005\u0004%\tAa\u000e\t\u0011\t\u0005s\u0001)A\u0005\u0003KA\u0011Ba\u0011\b\u0005\u0004%\tAa\u000e\t\u0011\t\u0015s\u0001)A\u0005\u0003KA\u0011\"a\u001c\b\u0005\u0004%\tAa\u0012\t\u0011\t%s\u0001)A\u0005\u0003cB\u0011Ba\u0013\b\u0005\u0004%\tAa\u000e\t\u0011\t5s\u0001)A\u0005\u0003KA\u0011Ba\u0014\b\u0005\u0004%\tAa\u000e\t\u0011\tEs\u0001)A\u0005\u0003KA\u0011Ba\u0015\b\u0005\u0004%\tA!\u0016\t\u0011\t]s\u0001)A\u0005\u0005\u0007A\u0011B!\u0017\b\u0005\u0004%\tAa\u0017\t\u0011\tus\u0001)A\u0005\u0003wB\u0011Ba\u0018\b\u0005\u0004%\tAa\u0017\t\u0011\t\u0005t\u0001)A\u0005\u0003wBqAa\u0019\b\t\u0003\u0011)G\u0002\u0004\u0003\u0000\u0005\u0001!\u0011\u0011\u0005\b\u0003\u001bIE\u0011\u0001BH\u0011-\u0011)$\u0013a\u0001\u0002\u0004%\tAa\u000e\t\u0017\tM\u0015\n1AA\u0002\u0013\u0005!Q\u0013\u0005\f\u0005sI\u0005\u0019!A!B\u0013\t)\u0003C\u0006\u0003\u001c&\u0003\r\u00111A\u0005\u0002\tu\u0005b\u0003BV\u0013\u0002\u0007\t\u0019!C\u0001\u0005[C1B!-J\u0001\u0004\u0005\t\u0015)\u0003\u0003 \"I!1W%A\u0002\u0013\u0005!q\t\u0005\n\u0005kK\u0005\u0019!C\u0001\u0005oC\u0001Ba/JA\u0003&\u0011\u0011\u000f\u0005\n\u0005{K\u0005\u0019!C\u0001\u0005+B\u0011Ba0J\u0001\u0004%\tA!1\t\u0011\t\u0015\u0017\n)Q\u0005\u0005\u0007A\u0011Ba2J\u0001\u0004%\tAa\u0012\t\u0013\t%\u0017\n1A\u0005\u0002\t-\u0007\u0002\u0003Bh\u0013\u0002\u0006K!!\u001d\t\u0013\tE\u0017\n1A\u0005\u0002\tU\u0003\"\u0003Bj\u0013\u0002\u0007I\u0011\u0001Bk\u0011!\u0011I.\u0013Q!\n\t\r\u0001\"\u0003Bn\u0013\u0002\u0007I\u0011\u0001B+\u0011%\u0011i.\u0013a\u0001\n\u0003\u0011y\u000e\u0003\u0005\u0003d&\u0003\u000b\u0015\u0002B\u0002\u0011%\u0011)/\u0013a\u0001\n\u0003\u0011)\u0006C\u0005\u0003h&\u0003\r\u0011\"\u0001\u0003j\"A!Q^%!B\u0013\u0011\u0019\u0001C\u0005\u0003p&\u0003\r\u0011\"\u0001\u0003H!I!\u0011_%A\u0002\u0013\u0005!1\u001f\u0005\t\u0005oL\u0005\u0015)\u0003\u0002r!I!\u0011`%A\u0002\u0013\u0005!1 \u0005\n\u0007\u0007I\u0005\u0019!C\u0001\u0007\u000bA\u0001b!\u0003JA\u0003&!Q \u0005\n\u0007\u0017I\u0005\u0019!C\u0001\u0005\u000fB\u0011b!\u0004J\u0001\u0004%\taa\u0004\t\u0011\rM\u0011\n)Q\u0005\u0003cB1b!\u0006J\u0001\u0004\u0005\r\u0011\"\u0001\u0004\u0018!Y1QE%A\u0002\u0003\u0007I\u0011AB\u0014\u0011-\u0019Y#\u0013a\u0001\u0002\u0003\u0006Ka!\u0007\t\u0017\r5\u0012\n1AA\u0002\u0013\u0005!q\u0007\u0005\f\u0007_I\u0005\u0019!a\u0001\n\u0003\u0019\t\u0004C\u0006\u00046%\u0003\r\u0011!Q!\n\u0005\u0015\u0002bBB\u001c\u0013\u0012\u00053\u0011\b\u0005\b\u0007\u0013JE\u0011IB&\u0011\u001d\u0019i%\u0013C\u0005\u0007\u001fBqa!\u001aJ\t\u0013\u00199'A\bD_:\u001cx\u000e\\3Qe>$WoY3s\u0015\tA\u00180A\u0003u_>d7OC\u0001{\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0001\"!`\u0001\u000e\u0003]\u0014qbQ8og>dW\r\u0015:pIV\u001cWM]\n\u0004\u0003\u0005\u0005\u0001\u0003BA\u0002\u0003\u0013i!!!\u0002\u000b\u0005\u0005\u001d\u0011!B:dC2\f\u0017\u0002BA\u0006\u0003\u000b\u0011a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001}\u0003\u0011i\u0017-\u001b8\u0015\t\u0005U\u00111\u0004\t\u0005\u0003\u0007\t9\"\u0003\u0003\u0002\u001a\u0005\u0015!\u0001B+oSRDq!!\b\u0004\u0001\u0004\ty\"\u0001\u0003be\u001e\u001c\bCBA\u0002\u0003C\t)#\u0003\u0003\u0002$\u0005\u0015!!B!se\u0006L\b\u0003BA\u0014\u0003kqA!!\u000b\u00022A!\u00111FA\u0003\u001b\t\tiCC\u0002\u00020m\fa\u0001\u0010:p_Rt\u0014\u0002BA\u001a\u0003\u000b\ta\u0001\u0015:fI\u00164\u0017\u0002BA\u001c\u0003s\u0011aa\u0015;sS:<'\u0002BA\u001a\u0003\u000b\tAa]3oIRA\u0011QCA \u0003G\ni\u0007C\u0004\u0002B\u0011\u0001\r!a\u0011\u0002\u0011A\u0014x\u000eZ;dKJ\u0004\u0002\"!\u0012\u0002X\u0005m\u00131L\u0007\u0003\u0003\u000fRA!!\u0011\u0002J)!\u00111JA'\u0003\u001d\u0019G.[3oiNT1A_A(\u0015\u0011\t\t&a\u0015\u0002\r\u0005\u0004\u0018m\u00195f\u0015\t\t)&A\u0002pe\u001eLA!!\u0017\u0002H\ti1*\u00194lCB\u0013x\u000eZ;dKJ\u0004b!a\u0001\u0002\"\u0005u\u0003\u0003BA\u0002\u0003?JA!!\u0019\u0002\u0006\t!!)\u001f;f\u0011\u001d\t)\u0007\u0002a\u0001\u0003O\naA]3d_J$\u0007\u0003CA#\u0003S\nY&a\u0017\n\t\u0005-\u0014q\t\u0002\u000f!J|G-^2feJ+7m\u001c:e\u0011\u001d\ty\u0007\u0002a\u0001\u0003c\nAa]=oGB!\u00111AA:\u0013\u0011\t)(!\u0002\u0003\u000f\t{w\u000e\\3b]\u0006qq-\u001a;SK\u0006$WM\u001d)s_B\u001cH\u0003BA>\u0003\u0017\u0003B!! \u0002\b6\u0011\u0011q\u0010\u0006\u0005\u0003\u0003\u000b\u0019)\u0001\u0003vi&d'BAAC\u0003\u0011Q\u0017M^1\n\t\u0005%\u0015q\u0010\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\bbBAG\u000b\u0001\u0007\u0011qR\u0001\u0007G>tg-[4\u0011\u0007\u0005Eu!D\u0001\u0002\u00059\u0001&o\u001c3vG\u0016\u00148i\u001c8gS\u001e\u001c2aBAL!\u0011\tI*a(\u000e\u0005\u0005m%bAAOs\u0006)Q\u000f^5mg&!\u0011\u0011UAN\u0005U\u0019u.\\7b]\u0012$UMZ1vYR|\u0005\u000f^5p]NLA!!\b\u0002 R!\u0011qRAT\u0011\u001d\ti\"\u0003a\u0001\u0003?\t\u0001\u0002^8qS\u000e|\u0005\u000f^\u000b\u0003\u0003[\u0003b!a,\u00026\u0006\u0015RBAAY\u0015\t\t\u0019,\u0001\u0006k_B$8/[7qY\u0016LA!a.\u00022\nY\u0012I]4v[\u0016tG/Q2dKB$\u0018N\\4PaRLwN\\*qK\u000e\f\u0011\u0002^8qS\u000e|\u0005\u000f\u001e\u0011\u0002\u001b\t\u0014xn[3s\u0019&\u001cHo\u00149u\u00039\u0011'o\\6fe2K7\u000f^(qi\u0002\n!CY8piN$(/\u00199TKJ4XM](qi\u0006\u0019\"m\\8ugR\u0014\u0018\r]*feZ,'o\u00149uA\u000591/\u001f8d\u001fB$XCAAd!\u0011\ty+!3\n\t\u0005-\u0017\u0011\u0017\u0002\u0012\u001fB$\u0018n\u001c8Ta\u0016\u001c')^5mI\u0016\u0014\u0018\u0001C:z]\u000e|\u0005\u000f\u001e\u0011\u0002'\r|W\u000e\u001d:fgNLwN\\\"pI\u0016\u001cw\n\u001d;\u0002)\r|W\u000e\u001d:fgNLwN\\\"pI\u0016\u001cw\n\u001d;!\u00031\u0011\u0017\r^2i'&TXm\u00149u+\t\t9\u000e\u0005\u0004\u00020\u0006U\u0016\u0011\u001c\t\u0005\u00037\f\t/\u0004\u0002\u0002^*!\u0011q\\AB\u0003\u0011a\u0017M\\4\n\t\u0005\r\u0018Q\u001c\u0002\b\u0013:$XmZ3s\u00035\u0011\u0017\r^2i'&TXm\u00149uA\u0005AR.Z:tC\u001e,7+\u001a8e\u001b\u0006D(+\u001a;sS\u0016\u001cx\n\u001d;\u000235,7o]1hKN+g\u000eZ'bqJ+GO]5fg>\u0003H\u000fI\u0001\u0012e\u0016$(/\u001f\"bG.|gMZ't\u001fB$XCAAx!\u0019\ty+!.\u0002rB!\u00111\\Az\u0013\u0011\t)0!8\u0003\t1{gnZ\u0001\u0013e\u0016$(/\u001f\"bG.|gMZ't\u001fB$\b%\u0001\btK:$G+[7f_V$x\n\u001d;\u0002\u001fM,g\u000e\u001a+j[\u0016|W\u000f^(qi\u0002\naC]3rk\u0016\u001cHOU3rk&\u0014X\rZ!dWN|\u0005\u000f^\u000b\u0003\u0005\u0003\u0001b!a,\u00026\n\r\u0001\u0003BAn\u0005\u000bIA!a\u000e\u0002^\u00069\"/Z9vKN$(+Z9vSJ,G-Q2lg>\u0003H\u000fI\u0001\u0014e\u0016\fX/Z:u)&lWm\\;u\u001bN|\u0005\u000f^\u0001\u0015e\u0016\fX/Z:u)&lWm\\;u\u001bN|\u0005\u000f\u001e\u0011\u0002'5,G/\u00193bi\u0006,\u0005\u0010]5ss6\u001bx\n\u001d;\u0002)5,G/\u00193bi\u0006,\u0005\u0010]5ss6\u001bx\n\u001d;!\u00035i\u0017\r\u001f\"m_\u000e\\Wj](qi\u0006qQ.\u0019=CY>\u001c7.T:PaR\u0004\u0013!E7bq6+Wn\u001c:z\u0005f$Xm](qi\u0006\u0011R.\u0019=NK6|'/\u001f\"zi\u0016\u001cx\n\u001d;!\u0003ii\u0017\r\u001f)beRLG/[8o\u001b\u0016lwN]=CsR,7o\u00149u\u0003mi\u0017\r\u001f)beRLG/[8o\u001b\u0016lwN]=CsR,7o\u00149uA\u0005\u0001R.Z:tC\u001e,'+Z1eKJ|\u0005\u000f^\u0001\u0012[\u0016\u001c8/Y4f%\u0016\fG-\u001a:PaR\u0004\u0013aE:pG.,GOQ;gM\u0016\u00148+\u001b>f\u001fB$\u0018\u0001F:pG.,GOQ;gM\u0016\u00148+\u001b>f\u001fB$\b%A\u0006qe>\u0004XM\u001d;z\u001fB$\u0018\u0001\u00049s_B,'\u000f^=PaR\u0004\u0013a\u0004:fC\u0012,'oQ8oM&<w\n\u001d;\u0002!I,\u0017\rZ3s\u0007>tg-[4PaR\u0004\u0013a\u00059s_\u0012,8-\u001a:Qe>\u0004XM\u001d;z\u001fB$\u0018\u0001\u00069s_\u0012,8-\u001a:Qe>\u0004XM\u001d;z\u001fB$\b%A\tqe>$WoY3s\u0007>tg-[4PaR\f!\u0003\u001d:pIV\u001cWM]\"p]\u001aLwm\u00149uA\u0005)Ao\u001c9jGV\u0011\u0011QE\u0001\u0007i>\u0004\u0018n\u0019\u0011\u0002\u001f\t|w\u000e^:ue\u0006\u00048+\u001a:wKJ\f\u0001CY8piN$(/\u00199TKJ4XM\u001d\u0011\u0002\u0015\t\u0014xn[3s\u0019&\u001cH/A\u0006ce>\\WM\u001d'jgR\u0004\u0013a\u00052s_.,'\u000fS8tiN\fe\u000e\u001a)peR\u001c\u0018\u0001\u00062s_.,'\u000fS8tiN\fe\u000e\u001a)peR\u001c\b%\u0006\u0002\u0002r\u0005)1/\u001f8dA\u0005Y2m\\7qe\u0016\u001c8/[8o\u0007>$WmY(qi&|gNV1mk\u0016\fAdY8naJ,7o]5p]\u000e{G-Z2PaRLwN\u001c,bYV,\u0007%\u0001\td_6\u0004(/Z:tS>t7i\u001c3fG\u0006\t2m\\7qe\u0016\u001c8/[8o\u0007>$Wm\u0019\u0011\u0002\u0017I,\u0017\rZ3s\u00072\f7o]\u000b\u0003\u0005\u0007\tAB]3bI\u0016\u00148\t\\1tg\u0002\nAbY7e\u0019&tW\r\u0015:paN,\"!a\u001f\u0002\u001b\rlG\rT5oKB\u0013x\u000e]:!\u0003I)\u0007\u0010\u001e:b!J|G-^2feB\u0013x\u000e]:\u0002'\u0015DHO]1Qe>$WoY3s!J|\u0007o\u001d\u0011\u0002\u0011Q\u0014\u0018\u0010U1sg\u0016$bAa\u001a\u0003n\t]\u0004\u0003BAX\u0005SJAAa\u001b\u00022\nIq\n\u001d;j_:\u001cV\r\u001e\u0005\b\u0005_B\u0005\u0019\u0001B9\u0003\u0019\u0001\u0018M]:feB!\u0011q\u0016B:\u0013\u0011\u0011)(!-\u0003\u0019=\u0003H/[8o!\u0006\u00148/\u001a:\t\u000f\u0005u\u0001\n1\u0001\u0002 \u0005i\u0001O]8ek\u000e,'\u000f\u0015:paN$B!a\u001f\u0003~!9\u0011Q\u0012\u0004A\u0002\u0005=%!\u0005'j]\u0016lUm]:bO\u0016\u0014V-\u00193feN)\u0011*!\u0001\u0003\u0004B!!Q\u0011BF\u001b\t\u00119IC\u0002\u0003\nf\faaY8n[>t\u0017\u0002\u0002BG\u0005\u000f\u0013Q\"T3tg\u0006<WMU3bI\u0016\u0014HC\u0001BI!\r\t\t*S\u0001\ni>\u0004\u0018nY0%KF$B!!\u0006\u0003\u0018\"I!\u0011\u0014'\u0002\u0002\u0003\u0007\u0011QE\u0001\u0004q\u0012\n\u0014A\u0002:fC\u0012,'/\u0006\u0002\u0003 B!!\u0011\u0015BT\u001b\t\u0011\u0019K\u0003\u0003\u0003&\u0006\r\u0015AA5p\u0013\u0011\u0011IKa)\u0003\u001d\t+hMZ3sK\u0012\u0014V-\u00193fe\u0006Q!/Z1eKJ|F%Z9\u0015\t\u0005U!q\u0016\u0005\n\u00053{\u0015\u0011!a\u0001\u0005?\u000bqA]3bI\u0016\u0014\b%\u0001\u0005qCJ\u001cXmS3z\u00031\u0001\u0018M]:f\u0017\u0016Lx\fJ3r)\u0011\t)B!/\t\u0013\te%+!AA\u0002\u0005E\u0014!\u00039beN,7*Z=!\u00031YW-_*fa\u0006\u0014\u0018\r^8s\u0003AYW-_*fa\u0006\u0014\u0018\r^8s?\u0012*\u0017\u000f\u0006\u0003\u0002\u0016\t\r\u0007\"\u0003BM+\u0006\u0005\t\u0019\u0001B\u0002\u00035YW-_*fa\u0006\u0014\u0018\r^8sA\u0005a\u0001/\u0019:tK\"+\u0017\rZ3sg\u0006\u0001\u0002/\u0019:tK\"+\u0017\rZ3sg~#S-\u001d\u000b\u0005\u0003+\u0011i\rC\u0005\u0003\u001ab\u000b\t\u00111\u0001\u0002r\u0005i\u0001/\u0019:tK\"+\u0017\rZ3sg\u0002\n\u0001\u0003[3bI\u0016\u00148\u000fR3mS6LG/\u001a:\u0002)!,\u0017\rZ3sg\u0012+G.[7ji\u0016\u0014x\fJ3r)\u0011\t)Ba6\t\u0013\te5,!AA\u0002\t\r\u0011!\u00055fC\u0012,'o\u001d#fY&l\u0017\u000e^3sA\u0005\u0001\u0002.Z1eKJ\u001c8+\u001a9be\u0006$xN]\u0001\u0015Q\u0016\fG-\u001a:t'\u0016\u0004\u0018M]1u_J|F%Z9\u0015\t\u0005U!\u0011\u001d\u0005\n\u00053s\u0016\u0011!a\u0001\u0005\u0007\t\u0011\u0003[3bI\u0016\u00148oU3qCJ\fGo\u001c:!\u0003MAW-\u00193feN\\U-_*fa\u0006\u0014\u0018\r^8s\u0003]AW-\u00193feN\\U-_*fa\u0006\u0014\u0018\r^8s?\u0012*\u0017\u000f\u0006\u0003\u0002\u0016\t-\b\"\u0003BMC\u0006\u0005\t\u0019\u0001B\u0002\u0003QAW-\u00193feN\\U-_*fa\u0006\u0014\u0018\r^8sA\u0005Y\u0011n\u001a8pe\u0016,%O]8s\u0003=IwM\\8sK\u0016\u0013(o\u001c:`I\u0015\fH\u0003BA\u000b\u0005kD\u0011B!'e\u0003\u0003\u0005\r!!\u001d\u0002\u0019%<gn\u001c:f\u000bJ\u0014xN\u001d\u0011\u0002\u00151Lg.\u001a(v[\n,'/\u0006\u0002\u0003~B!\u00111\u0001B\u0000\u0013\u0011\u0019\t!!\u0002\u0003\u0007%sG/\u0001\bmS:,g*^7cKJ|F%Z9\u0015\t\u0005U1q\u0001\u0005\n\u00053;\u0017\u0011!a\u0001\u0005{\f1\u0002\\5oK:+XNY3sA\u0005Y\u0001O]5oiB\u0013x.\u001c9u\u0003=\u0001(/\u001b8u!J|W\u000e\u001d;`I\u0015\fH\u0003BA\u000b\u0007#A\u0011B!'k\u0003\u0003\u0005\r!!\u001d\u0002\u0019A\u0014\u0018N\u001c;Qe>l\u0007\u000f\u001e\u0011\u0002/!,\u0017\rZ3sgN+\u0007/\u0019:bi>\u0014\b+\u0019;uKJtWCAB\r!\u0011\u0019Yb!\t\u000e\u0005\ru!\u0002BB\u0010\u0003\u007f\nQA]3hKbLAaa\t\u0004\u001e\t9\u0001+\u0019;uKJt\u0017a\u00075fC\u0012,'o]*fa\u0006\u0014\u0018\r^8s!\u0006$H/\u001a:o?\u0012*\u0017\u000f\u0006\u0003\u0002\u0016\r%\u0002\"\u0003BM[\u0006\u0005\t\u0019AB\r\u0003aAW-\u00193feN\u001cV\r]1sCR|'\u000fU1ui\u0016\u0014h\u000eI\u0001\u000b]VdG.T1sW\u0016\u0014\u0018A\u00048vY2l\u0015M]6fe~#S-\u001d\u000b\u0005\u0003+\u0019\u0019\u0004C\u0005\u0003\u001aB\f\t\u00111\u0001\u0002&\u0005Ya.\u001e7m\u001b\u0006\u00148.\u001a:!\u0003\u0011Ig.\u001b;\u0015\r\u0005U11HB#\u0011\u001d\u0019iD\u001da\u0001\u0007\u007f\t1\"\u001b8qkR\u001cFO]3b[B!!\u0011UB!\u0013\u0011\u0019\u0019Ea)\u0003\u0017%s\u0007/\u001e;TiJ,\u0017-\u001c\u0005\b\u0007\u000f\u0012\b\u0019AA>\u0003\u0015\u0001(o\u001c9t\u0003-\u0011X-\u00193NKN\u001c\u0018mZ3\u0015\u0005\u0005\u001d\u0014!\u00029beN,G\u0003DA\u0013\u0007#\u001a)f!\u0017\u0004^\r\u0005\u0004bBB*i\u0002\u0007\u0011\u0011O\u0001\bK:\f'\r\\3e\u0011\u001d\u00199\u0006\u001ea\u0001\u0003K\tA\u0001\\5oK\"911\f;A\u0002\tu\u0018AC:uCJ$\u0018J\u001c3fq\"91q\f;A\u0002\u0005\u0015\u0012a\u00033f[\u0006\u00148-\u0019;j_:Dqaa\u0019u\u0001\u0004\t)#A\beK6\f'oY1uS>tg*Y7f\u00031\u0019\b\u000f\\5u\u0011\u0016\fG-\u001a:t)\u0011\u0019Ig!\u001d\u0011\r\u0005\r\u0011\u0011EB6!!\t\u0019a!\u001c\u0002&\u0005m\u0013\u0002BB8\u0003\u000b\u0011a\u0001V;qY\u0016\u0014\u0004bBB:k\u0002\u0007\u0011QE\u0001\bQ\u0016\fG-\u001a:t\u0001")
public final class ConsoleProducer {
    public static Properties producerProps(ProducerConfig producerConfig) {
        return ConsoleProducer$.MODULE$.producerProps(producerConfig);
    }

    public static Properties getReaderProps(ProducerConfig producerConfig) {
        return ConsoleProducer$.MODULE$.getReaderProps(producerConfig);
    }

    public static void main(String[] stringArray) {
        ConsoleProducer$.MODULE$.main(stringArray);
    }

    public static class LineMessageReader
    implements MessageReader {
        private String topic;
        private BufferedReader reader;
        private boolean parseKey;
        private String keySeparator;
        private boolean parseHeaders;
        private String headersDelimiter;
        private String headersSeparator;
        private String headersKeySeparator;
        private boolean ignoreError;
        private int lineNumber;
        private boolean printPrompt;
        private Pattern headersSeparatorPattern;
        private String nullMarker;

        @Override
        public void close() {
            MessageReader.close$(this);
        }

        public String topic() {
            return this.topic;
        }

        public void topic_$eq(String x$1) {
            this.topic = x$1;
        }

        public BufferedReader reader() {
            return this.reader;
        }

        public void reader_$eq(BufferedReader x$1) {
            this.reader = x$1;
        }

        public boolean parseKey() {
            return this.parseKey;
        }

        public void parseKey_$eq(boolean x$1) {
            this.parseKey = x$1;
        }

        public String keySeparator() {
            return this.keySeparator;
        }

        public void keySeparator_$eq(String x$1) {
            this.keySeparator = x$1;
        }

        public boolean parseHeaders() {
            return this.parseHeaders;
        }

        public void parseHeaders_$eq(boolean x$1) {
            this.parseHeaders = x$1;
        }

        public String headersDelimiter() {
            return this.headersDelimiter;
        }

        public void headersDelimiter_$eq(String x$1) {
            this.headersDelimiter = x$1;
        }

        public String headersSeparator() {
            return this.headersSeparator;
        }

        public void headersSeparator_$eq(String x$1) {
            this.headersSeparator = x$1;
        }

        public String headersKeySeparator() {
            return this.headersKeySeparator;
        }

        public void headersKeySeparator_$eq(String x$1) {
            this.headersKeySeparator = x$1;
        }

        public boolean ignoreError() {
            return this.ignoreError;
        }

        public void ignoreError_$eq(boolean x$1) {
            this.ignoreError = x$1;
        }

        public int lineNumber() {
            return this.lineNumber;
        }

        public void lineNumber_$eq(int x$1) {
            this.lineNumber = x$1;
        }

        public boolean printPrompt() {
            return this.printPrompt;
        }

        public void printPrompt_$eq(boolean x$1) {
            this.printPrompt = x$1;
        }

        public Pattern headersSeparatorPattern() {
            return this.headersSeparatorPattern;
        }

        public void headersSeparatorPattern_$eq(Pattern x$1) {
            this.headersSeparatorPattern = x$1;
        }

        public String nullMarker() {
            return this.nullMarker;
        }

        public void nullMarker_$eq(String x$1) {
            this.nullMarker = x$1;
        }

        @Override
        public void init(InputStream inputStream, Properties props) {
            this.topic_$eq(props.getProperty("topic"));
            if (props.containsKey("parse.key")) {
                this.parseKey_$eq(props.getProperty("parse.key").trim().equalsIgnoreCase("true"));
            }
            if (props.containsKey("key.separator")) {
                this.keySeparator_$eq(props.getProperty("key.separator"));
            }
            if (props.containsKey("parse.headers")) {
                this.parseHeaders_$eq(props.getProperty("parse.headers").trim().equalsIgnoreCase("true"));
            }
            if (props.containsKey("headers.delimiter")) {
                this.headersDelimiter_$eq(props.getProperty("headers.delimiter"));
            }
            if (props.containsKey("headers.separator")) {
                this.headersSeparator_$eq(props.getProperty("headers.separator"));
            }
            this.headersSeparatorPattern_$eq(Pattern.compile(this.headersSeparator()));
            if (props.containsKey("headers.key.separator")) {
                this.headersKeySeparator_$eq(props.getProperty("headers.key.separator"));
            }
            if (props.containsKey("ignore.error")) {
                this.ignoreError_$eq(props.getProperty("ignore.error").trim().equalsIgnoreCase("true"));
            }
            String string = this.headersDelimiter();
            String string2 = this.headersSeparator();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                throw new KafkaException("headers.delimiter and headers.separator may not be equal");
            }
            String string3 = this.headersDelimiter();
            String string4 = this.headersKeySeparator();
            if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                throw new KafkaException("headers.delimiter and headers.key.separator may not be equal");
            }
            String string5 = this.headersSeparator();
            String string6 = this.headersKeySeparator();
            if (!(string5 != null ? !string5.equals(string6) : string6 != null)) {
                throw new KafkaException("headers.separator and headers.key.separator may not be equal");
            }
            if (props.containsKey("null.marker")) {
                this.nullMarker_$eq(props.getProperty("null.marker"));
            }
            String string7 = this.nullMarker();
            String string8 = this.keySeparator();
            if (!(string7 != null ? !string7.equals(string8) : string8 != null)) {
                throw new KafkaException("null.marker and key.separator may not be equal");
            }
            String string9 = this.nullMarker();
            String string10 = this.headersSeparator();
            if (!(string9 != null ? !string9.equals(string10) : string10 != null)) {
                throw new KafkaException("null.marker and headers.separator may not be equal");
            }
            String string11 = this.nullMarker();
            String string12 = this.headersDelimiter();
            if (!(string11 != null ? !string11.equals(string12) : string12 != null)) {
                throw new KafkaException("null.marker and headers.delimiter may not be equal");
            }
            String string13 = this.nullMarker();
            String string14 = this.headersKeySeparator();
            if (!(string13 != null ? !string13.equals(string14) : string14 != null)) {
                throw new KafkaException("null.marker and headers.key.separator may not be equal");
            }
            this.reader_$eq(new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8)));
        }

        @Override
        public ProducerRecord<byte[], byte[]> readMessage() {
            ProducerRecord producerRecord;
            String line;
            this.lineNumber_$eq(this.lineNumber() + 1);
            if (this.printPrompt()) {
                Predef$.MODULE$.print((Object)">");
            }
            if ((line = this.reader().readLine()) == null) {
                producerRecord = null;
            } else {
                String headers = this.parse(this.parseHeaders(), line, 0, this.headersDelimiter(), "headers delimiter");
                int headerOffset = headers == null ? 0 : headers.length() + this.headersDelimiter().length();
                String key = this.parse(this.parseKey(), line, headerOffset, this.keySeparator(), "key separator");
                int keyOffset = key == null ? 0 : key.length() + this.keySeparator().length();
                String value = line.substring(headerOffset + keyOffset);
                ProducerRecord record = new ProducerRecord(this.topic(), key != null && !key.equals(this.nullMarker()) ? key.getBytes(StandardCharsets.UTF_8) : null, value != null && !value.equals(this.nullMarker()) ? value.getBytes(StandardCharsets.UTF_8) : null);
                if (headers != null && !headers.equals(this.nullMarker())) {
                    new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.splitHeaders(headers))).foreach((Function1 & Serializable & scala.Serializable)header -> record.headers().add((String)header._1(), (byte[])header._2()));
                }
                producerRecord = record;
            }
            return producerRecord;
        }

        private String parse(boolean enabled, String line, int startIndex, String demarcation, String demarcationName) {
            String string;
            int n = line.indexOf(demarcation, startIndex);
            if (!enabled) {
                string = null;
            } else if (-1 == n) {
                if (!this.ignoreError()) {
                    throw new KafkaException(new StringBuilder(29).append("No ").append(demarcationName).append(" found on line number ").append(this.lineNumber()).append(": '").append(line).append("'").toString());
                }
                string = null;
            } else {
                string = line.substring(startIndex, n);
            }
            return string;
        }

        private Tuple2<String, byte[]>[] splitHeaders(String headers) {
            return (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.headersSeparatorPattern().split(headers))).map((Function1 & Serializable & scala.Serializable)pair -> {
                Tuple2 tuple2;
                boolean bl = this.ignoreError();
                int n = pair.indexOf(this.headersKeySeparator());
                if (-1 == n && !bl) {
                    throw new KafkaException(new StringBuilder(56).append("No header key separator found in pair '").append((String)pair).append("' on line number ").append(this.lineNumber()).toString());
                }
                if (-1 == n && bl) {
                    tuple2 = new Tuple2(pair, null);
                } else {
                    String string;
                    String string2;
                    String string3 = string2 = pair.substring(0, n);
                    String string4 = this.nullMarker();
                    if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                        throw new KafkaException(new StringBuilder(75).append("Header keys should not be equal to the null marker '").append(this.nullMarker()).append("' as they can't be null").toString());
                    }
                    String string5 = string = pair.substring(n + this.headersKeySeparator().length());
                    String string6 = this.nullMarker();
                    byte[] byArray = !(string5 != null ? !string5.equals(string6) : string6 != null) ? null : string.getBytes(StandardCharsets.UTF_8);
                    tuple2 = new Tuple2((Object)string2, (Object)byArray);
                }
                return tuple2;
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
        }

        public LineMessageReader() {
            MessageReader.$init$(this);
            this.parseKey = false;
            this.keySeparator = "\t";
            this.parseHeaders = false;
            this.headersDelimiter = "\t";
            this.headersSeparator = ",";
            this.headersKeySeparator = ":";
            this.ignoreError = false;
            this.lineNumber = 0;
            this.printPrompt = System.console() != null;
        }
    }

    public static class ProducerConfig
    extends CommandDefaultOptions {
        private final ArgumentAcceptingOptionSpec<String> topicOpt = this.parser().accepts("topic", "REQUIRED: The topic id to produce messages to.").withRequiredArg().describedAs("topic").ofType(String.class);
        private final ArgumentAcceptingOptionSpec<String> brokerListOpt = this.parser().accepts("broker-list", "DEPRECATED, use --bootstrap-server instead; ignored if --bootstrap-server is specified.  The broker list string in the form HOST1:PORT1,HOST2:PORT2.").withRequiredArg().describedAs("broker-list").ofType(String.class);
        private final ArgumentAcceptingOptionSpec<String> bootstrapServerOpt = this.parser().accepts("bootstrap-server", "REQUIRED unless --broker-list(deprecated) is specified. The server(s) to connect to. The broker list string in the form HOST1:PORT1,HOST2:PORT2.").requiredUnless("broker-list", new String[0]).withRequiredArg().describedAs("server to connect to").ofType(String.class);
        private final OptionSpecBuilder syncOpt = this.parser().accepts("sync", "If set message send requests to the brokers are synchronously, one at a time as they arrive.");
        private final ArgumentAcceptingOptionSpec<String> compressionCodecOpt = this.parser().accepts("compression-codec", "The compression codec: either 'none', 'gzip', 'snappy', 'lz4', or 'zstd'.If specified without value, then it defaults to 'gzip'").withOptionalArg().describedAs("compression-codec").ofType(String.class);
        private final ArgumentAcceptingOptionSpec<Integer> batchSizeOpt = this.parser().accepts("batch-size", "Number of messages to send in a single batch if they are not being sent synchronously. please note that this option will be replaced if max-partition-memory-bytes is also set").withRequiredArg().describedAs("size").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(16384), (Object[])new Integer[0]);
        private final ArgumentAcceptingOptionSpec<Integer> messageSendMaxRetriesOpt = this.parser().accepts("message-send-max-retries", "Brokers can fail receiving the message for multiple reasons, and being unavailable transiently is just one of them. This property specifies the number of retries before the producer give up and drop this message. This is the option to control `retries` in producer configs.").withRequiredArg().ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(3), (Object[])new Integer[0]);
        private final ArgumentAcceptingOptionSpec<Long> retryBackoffMsOpt = this.parser().accepts("retry-backoff-ms", "Before each retry, the producer refreshes the metadata of relevant topics. Since leader election takes a bit of time, this property specifies the amount of time that the producer waits before refreshing the metadata. This is the option to control `retry.backoff.ms` in producer configs.").withRequiredArg().ofType(Long.class).defaultsTo((Object)Predef$.MODULE$.long2Long(100L), (Object[])new Long[0]);
        private final ArgumentAcceptingOptionSpec<Long> sendTimeoutOpt = this.parser().accepts("timeout", "If set and the producer is running in asynchronous mode, this gives the maximum amount of time a message will queue awaiting sufficient batch size. The value is given in ms. This is the option to control `linger.ms` in producer configs.").withRequiredArg().describedAs("timeout_ms").ofType(Long.class).defaultsTo((Object)Predef$.MODULE$.long2Long(1000L), (Object[])new Long[0]);
        private final ArgumentAcceptingOptionSpec<String> requestRequiredAcksOpt = this.parser().accepts("request-required-acks", "The required `acks` of the producer requests").withRequiredArg().describedAs("request required acks").ofType(String.class).defaultsTo((Object)"-1", (Object[])new String[0]);
        private final ArgumentAcceptingOptionSpec<Integer> requestTimeoutMsOpt = this.parser().accepts("request-timeout-ms", "The ack timeout of the producer requests. Value must be non-negative and non-zero.").withRequiredArg().describedAs("request timeout ms").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(1500), (Object[])new Integer[0]);
        private final ArgumentAcceptingOptionSpec<Long> metadataExpiryMsOpt = this.parser().accepts("metadata-expiry-ms", "The period of time in milliseconds after which we force a refresh of metadata even if we haven't seen any leadership changes. This is the option to control `metadata.max.age.ms` in producer configs.").withRequiredArg().describedAs("metadata expiration interval").ofType(Long.class).defaultsTo((Object)Predef$.MODULE$.long2Long(300000L), (Object[])new Long[0]);
        private final ArgumentAcceptingOptionSpec<Long> maxBlockMsOpt = this.parser().accepts("max-block-ms", "The max time that the producer will block for during a send request.").withRequiredArg().describedAs("max block on send").ofType(Long.class).defaultsTo((Object)Predef$.MODULE$.long2Long(60000L), (Object[])new Long[0]);
        private final ArgumentAcceptingOptionSpec<Long> maxMemoryBytesOpt = this.parser().accepts("max-memory-bytes", "The total memory used by the producer to buffer records waiting to be sent to the server. This is the option to control `buffer.memory` in producer configs.").withRequiredArg().describedAs("total memory in bytes").ofType(Long.class).defaultsTo((Object)Predef$.MODULE$.long2Long(0x2000000L), (Object[])new Long[0]);
        private final ArgumentAcceptingOptionSpec<Integer> maxPartitionMemoryBytesOpt = this.parser().accepts("max-partition-memory-bytes", "The buffer size allocated for a partition. When records are received which are smaller than this size the producer will attempt to optimistically group them together until this size is reached. This is the option to control `batch.size` in producer configs.").withRequiredArg().describedAs("memory in bytes per partition").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(16384), (Object[])new Integer[0]);
        private final ArgumentAcceptingOptionSpec<String> messageReaderOpt = this.parser().accepts("line-reader", "The class name of the class to use for reading lines from standard in. By default each line is read as a separate message.").withRequiredArg().describedAs("reader_class").ofType(String.class).defaultsTo((Object)LineMessageReader.class.getName(), (Object[])new String[0]);
        private final ArgumentAcceptingOptionSpec<Integer> socketBufferSizeOpt = this.parser().accepts("socket-buffer-size", "The size of the tcp RECV size. This is the option to control `send.buffer.bytes` in producer configs.").withRequiredArg().describedAs("size").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(102400), (Object[])new Integer[0]);
        private final ArgumentAcceptingOptionSpec<String> propertyOpt = this.parser().accepts("property", new StringOps(Predef$.MODULE$.augmentString("A mechanism to pass user-defined properties in the form key=value to the message reader. This allows custom configuration for a user-defined message reader.\n        |Default properties include:\n        | parse.key=false\n        | parse.headers=false\n        | ignore.error=false\n        | key.separator=\\t\n        | headers.delimiter=\\t\n        | headers.separator=,\n        | headers.key.separator=:\n        | null.marker=   When set, any fields (key, value and headers) equal to this will be replaced by null\n        |Default parsing pattern when:\n        | parse.headers=true and parse.key=true:\n        |  \"h1:v1,h2:v2...\\tkey\\tvalue\"\n        | parse.key=true:\n        |  \"key\\tvalue\"\n        | parse.headers=true:\n        |  \"h1:v1,h2:v2...\\tvalue\"\n      ")).stripMargin()).withRequiredArg().describedAs("prop").ofType(String.class);
        private final ArgumentAcceptingOptionSpec<String> readerConfigOpt = this.parser().accepts("reader-config", new StringBuilder(92).append("Config properties file for the message reader. Note that ").append(this.propertyOpt()).append(" takes precedence over this config.").toString()).withRequiredArg().describedAs("config file").ofType(String.class);
        private final ArgumentAcceptingOptionSpec<String> producerPropertyOpt = this.parser().accepts("producer-property", "A mechanism to pass user-defined properties in the form key=value to the producer. ").withRequiredArg().describedAs("producer_prop").ofType(String.class);
        private final ArgumentAcceptingOptionSpec<String> producerConfigOpt = this.parser().accepts("producer.config", new StringBuilder(78).append("Producer config properties file. Note that ").append(this.producerPropertyOpt()).append(" takes precedence over this config.").toString()).withRequiredArg().describedAs("config file").ofType(String.class);
        private final String topic;
        private final String bootstrapServer;
        private final String brokerList;
        private final String brokerHostsAndPorts;
        private final boolean sync;
        private final String compressionCodecOptionValue;
        private final String compressionCodec;
        private final String readerClass;
        private final Properties cmdLineProps;
        private final Properties extraProducerProps;

        public ArgumentAcceptingOptionSpec<String> topicOpt() {
            return this.topicOpt;
        }

        public ArgumentAcceptingOptionSpec<String> brokerListOpt() {
            return this.brokerListOpt;
        }

        public ArgumentAcceptingOptionSpec<String> bootstrapServerOpt() {
            return this.bootstrapServerOpt;
        }

        public OptionSpecBuilder syncOpt() {
            return this.syncOpt;
        }

        public ArgumentAcceptingOptionSpec<String> compressionCodecOpt() {
            return this.compressionCodecOpt;
        }

        public ArgumentAcceptingOptionSpec<Integer> batchSizeOpt() {
            return this.batchSizeOpt;
        }

        public ArgumentAcceptingOptionSpec<Integer> messageSendMaxRetriesOpt() {
            return this.messageSendMaxRetriesOpt;
        }

        public ArgumentAcceptingOptionSpec<Long> retryBackoffMsOpt() {
            return this.retryBackoffMsOpt;
        }

        public ArgumentAcceptingOptionSpec<Long> sendTimeoutOpt() {
            return this.sendTimeoutOpt;
        }

        public ArgumentAcceptingOptionSpec<String> requestRequiredAcksOpt() {
            return this.requestRequiredAcksOpt;
        }

        public ArgumentAcceptingOptionSpec<Integer> requestTimeoutMsOpt() {
            return this.requestTimeoutMsOpt;
        }

        public ArgumentAcceptingOptionSpec<Long> metadataExpiryMsOpt() {
            return this.metadataExpiryMsOpt;
        }

        public ArgumentAcceptingOptionSpec<Long> maxBlockMsOpt() {
            return this.maxBlockMsOpt;
        }

        public ArgumentAcceptingOptionSpec<Long> maxMemoryBytesOpt() {
            return this.maxMemoryBytesOpt;
        }

        public ArgumentAcceptingOptionSpec<Integer> maxPartitionMemoryBytesOpt() {
            return this.maxPartitionMemoryBytesOpt;
        }

        public ArgumentAcceptingOptionSpec<String> messageReaderOpt() {
            return this.messageReaderOpt;
        }

        public ArgumentAcceptingOptionSpec<Integer> socketBufferSizeOpt() {
            return this.socketBufferSizeOpt;
        }

        public ArgumentAcceptingOptionSpec<String> propertyOpt() {
            return this.propertyOpt;
        }

        public ArgumentAcceptingOptionSpec<String> readerConfigOpt() {
            return this.readerConfigOpt;
        }

        public ArgumentAcceptingOptionSpec<String> producerPropertyOpt() {
            return this.producerPropertyOpt;
        }

        public ArgumentAcceptingOptionSpec<String> producerConfigOpt() {
            return this.producerConfigOpt;
        }

        public String topic() {
            return this.topic;
        }

        public String bootstrapServer() {
            return this.bootstrapServer;
        }

        public String brokerList() {
            return this.brokerList;
        }

        public String brokerHostsAndPorts() {
            return this.brokerHostsAndPorts;
        }

        public boolean sync() {
            return this.sync;
        }

        public String compressionCodecOptionValue() {
            return this.compressionCodecOptionValue;
        }

        public String compressionCodec() {
            return this.compressionCodec;
        }

        public String readerClass() {
            return this.readerClass;
        }

        public Properties cmdLineProps() {
            return this.cmdLineProps;
        }

        public Properties extraProducerProps() {
            return this.extraProducerProps;
        }

        public OptionSet tryParse(OptionParser parser, String[] args) {
            try {
                return parser.parse(args);
            }
            catch (OptionException e) {
                throw CommandLineUtils$.MODULE$.printUsageAndDie(parser, e.getMessage());
            }
        }

        public ProducerConfig(String[] args) {
            super(args, CommandDefaultOptions$.MODULE$.$lessinit$greater$default$2());
            this.options_$eq(this.tryParse(this.parser(), super.args()));
            CommandLineUtils$.MODULE$.printHelpAndExitIfNeeded(this, "This tool helps to read data from standard input and publish it to Kafka.");
            CommandLineUtils$.MODULE$.checkRequiredArgs(this.parser(), this.options(), (Seq<OptionSpec<?>>)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{this.topicOpt()}));
            this.topic = (String)this.options().valueOf(this.topicOpt());
            this.bootstrapServer = (String)this.options().valueOf(this.bootstrapServerOpt());
            this.brokerList = (String)this.options().valueOf(this.brokerListOpt());
            this.brokerHostsAndPorts = (String)this.options().valueOf(this.options().has(this.bootstrapServerOpt()) ? this.bootstrapServerOpt() : this.brokerListOpt());
            ToolsUtils$.MODULE$.validatePortOrDie(this.parser(), this.brokerHostsAndPorts());
            this.sync = this.options().has((OptionSpec)this.syncOpt());
            this.compressionCodecOptionValue = (String)this.options().valueOf(this.compressionCodecOpt());
            this.compressionCodec = this.options().has(this.compressionCodecOpt()) ? (this.compressionCodecOptionValue() == null || this.compressionCodecOptionValue().isEmpty() ? DefaultCompressionCodec$.MODULE$.name() : this.compressionCodecOptionValue()) : NoCompressionCodec$.MODULE$.name();
            this.readerClass = (String)this.options().valueOf(this.messageReaderOpt());
            this.cmdLineProps = CommandLineUtils$.MODULE$.parseKeyValueArgs((Iterable<String>)((Iterable)CollectionConverters$.MODULE$.asScalaBufferConverter(this.options().valuesOf(this.propertyOpt())).asScala()), CommandLineUtils$.MODULE$.parseKeyValueArgs$default$2());
            this.extraProducerProps = CommandLineUtils$.MODULE$.parseKeyValueArgs((Iterable<String>)((Iterable)CollectionConverters$.MODULE$.asScalaBufferConverter(this.options().valuesOf(this.producerPropertyOpt())).asScala()), CommandLineUtils$.MODULE$.parseKeyValueArgs$default$2());
        }
    }
}

