/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.builders;

import java.util.Collections;
import java.util.Optional;
import kafka.coordinator.group.GroupCoordinator;
import kafka.coordinator.group.GroupCoordinatorAdapter;
import kafka.coordinator.transaction.TransactionCoordinator;
import kafka.network.RequestChannel;
import kafka.server.ApiVersionManager;
import kafka.server.AutoTopicCreationManager;
import kafka.server.BrokerTopicStats;
import kafka.server.DelegationTokenManager;
import kafka.server.FetchManager;
import kafka.server.KafkaApis;
import kafka.server.KafkaConfig;
import kafka.server.MetadataCache;
import kafka.server.MetadataSupport;
import kafka.server.QuotaFactory;
import kafka.server.ReplicaManager;
import kafka.server.metadata.ConfigRepository;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.authorizer.Authorizer;
import scala.Option;
import scala.compat.java8.OptionConverters;

public class KafkaApisBuilder {
    private RequestChannel requestChannel = null;
    private MetadataSupport metadataSupport = null;
    private ReplicaManager replicaManager = null;
    private GroupCoordinator groupCoordinator = null;
    private TransactionCoordinator txnCoordinator = null;
    private AutoTopicCreationManager autoTopicCreationManager = null;
    private int brokerId = 0;
    private KafkaConfig config = null;
    private ConfigRepository configRepository = null;
    private MetadataCache metadataCache = null;
    private Metrics metrics = null;
    private Optional<Authorizer> authorizer = Optional.empty();
    private QuotaFactory.QuotaManagers quotas = null;
    private FetchManager fetchManager = null;
    private BrokerTopicStats brokerTopicStats = null;
    private String clusterId = "clusterId";
    private Time time = Time.SYSTEM;
    private DelegationTokenManager tokenManager = null;
    private ApiVersionManager apiVersionManager = null;

    public KafkaApisBuilder setRequestChannel(RequestChannel requestChannel) {
        this.requestChannel = requestChannel;
        return this;
    }

    public KafkaApisBuilder setMetadataSupport(MetadataSupport metadataSupport) {
        this.metadataSupport = metadataSupport;
        return this;
    }

    public KafkaApisBuilder setReplicaManager(ReplicaManager replicaManager) {
        this.replicaManager = replicaManager;
        return this;
    }

    public KafkaApisBuilder setGroupCoordinator(GroupCoordinator groupCoordinator) {
        this.groupCoordinator = groupCoordinator;
        return this;
    }

    public KafkaApisBuilder setTxnCoordinator(TransactionCoordinator txnCoordinator) {
        this.txnCoordinator = txnCoordinator;
        return this;
    }

    public KafkaApisBuilder setAutoTopicCreationManager(AutoTopicCreationManager autoTopicCreationManager) {
        this.autoTopicCreationManager = autoTopicCreationManager;
        return this;
    }

    public KafkaApisBuilder setBrokerId(int brokerId) {
        this.brokerId = brokerId;
        return this;
    }

    public KafkaApisBuilder setConfig(KafkaConfig config) {
        this.config = config;
        return this;
    }

    public KafkaApisBuilder setConfigRepository(ConfigRepository configRepository) {
        this.configRepository = configRepository;
        return this;
    }

    public KafkaApisBuilder setMetadataCache(MetadataCache metadataCache) {
        this.metadataCache = metadataCache;
        return this;
    }

    public KafkaApisBuilder setMetrics(Metrics metrics) {
        this.metrics = metrics;
        return this;
    }

    public KafkaApisBuilder setAuthorizer(Optional<Authorizer> authorizer) {
        this.authorizer = authorizer;
        return this;
    }

    public KafkaApisBuilder setQuotas(QuotaFactory.QuotaManagers quotas) {
        this.quotas = quotas;
        return this;
    }

    public KafkaApisBuilder setFetchManager(FetchManager fetchManager) {
        this.fetchManager = fetchManager;
        return this;
    }

    public KafkaApisBuilder setBrokerTopicStats(BrokerTopicStats brokerTopicStats) {
        this.brokerTopicStats = brokerTopicStats;
        return this;
    }

    public KafkaApisBuilder setClusterId(String clusterId) {
        this.clusterId = clusterId;
        return this;
    }

    public KafkaApisBuilder setTime(Time time) {
        this.time = time;
        return this;
    }

    public KafkaApisBuilder setTokenManager(DelegationTokenManager tokenManager) {
        this.tokenManager = tokenManager;
        return this;
    }

    public KafkaApisBuilder setApiVersionManager(ApiVersionManager apiVersionManager) {
        this.apiVersionManager = apiVersionManager;
        return this;
    }

    public KafkaApis build() {
        if (this.requestChannel == null) {
            throw new RuntimeException("you must set requestChannel");
        }
        if (this.metadataSupport == null) {
            throw new RuntimeException("you must set metadataSupport");
        }
        if (this.replicaManager == null) {
            throw new RuntimeException("You must set replicaManager");
        }
        if (this.groupCoordinator == null) {
            throw new RuntimeException("You must set groupCoordinator");
        }
        if (this.txnCoordinator == null) {
            throw new RuntimeException("You must set txnCoordinator");
        }
        if (this.autoTopicCreationManager == null) {
            throw new RuntimeException("You must set autoTopicCreationManager");
        }
        if (this.config == null) {
            this.config = new KafkaConfig(Collections.emptyMap());
        }
        if (this.configRepository == null) {
            throw new RuntimeException("You must set configRepository");
        }
        if (this.metadataCache == null) {
            throw new RuntimeException("You must set metadataCache");
        }
        if (this.metrics == null) {
            throw new RuntimeException("You must set metrics");
        }
        if (this.quotas == null) {
            throw new RuntimeException("You must set quotas");
        }
        if (this.fetchManager == null) {
            throw new RuntimeException("You must set fetchManager");
        }
        if (this.brokerTopicStats == null) {
            this.brokerTopicStats = new BrokerTopicStats();
        }
        if (this.apiVersionManager == null) {
            throw new RuntimeException("You must set apiVersionManager");
        }
        return new KafkaApis(this.requestChannel, this.metadataSupport, this.replicaManager, this.groupCoordinator, new GroupCoordinatorAdapter(this.groupCoordinator), this.txnCoordinator, this.autoTopicCreationManager, this.brokerId, this.config, this.configRepository, this.metadataCache, this.metrics, (Option<Authorizer>)OptionConverters.toScala(this.authorizer), this.quotas, this.fetchManager, this.brokerTopicStats, this.clusterId, this.time, this.tokenManager, this.apiVersionManager);
    }
}

