/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import kafka.cluster.Partition;
import kafka.coordinator.group.GroupCoordinator;
import kafka.coordinator.transaction.TransactionCoordinator;
import kafka.network.RequestChannel;
import kafka.server.ClientQuotaManager;
import kafka.server.ControllerMutationQuota;
import kafka.server.QuotaFactory;
import kafka.server.RequestHandlerHelper$;
import kafka.server.ThrottleCallback;
import kafka.utils.NotNothing$;
import org.apache.kafka.common.errors.ClusterAuthorizationException;
import org.apache.kafka.common.network.Send;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.utils.Time;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.collection.Iterable;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Mw!\u0002\f\u0018\u0011\u0003ab!\u0002\u0010\u0018\u0011\u0003y\u0002\"\u0002\u0014\u0002\t\u00039\u0003\"\u0002\u0015\u0002\t\u0003Ic\u0001\u0002\u0010\u0018\u0001UC\u0001B\u0016\u0003\u0003\u0002\u0003\u0006Ia\u0016\u0005\t;\u0012\u0011\t\u0011)A\u0005=\"A\u0011\u000e\u0002B\u0001B\u0003%!\u000eC\u0003'\t\u0011\u0005q\u000fC\u0003}\t\u0011\u0005Q\u0010C\u0004\u0002$\u0011!\t!!\n\t\u000f\u0005MB\u0001\"\u0001\u00026!9\u0011\u0011\t\u0003\u0005\u0002\u0005\r\u0003bBA,\t\u0011\u0005\u0011\u0011\f\u0005\b\u0003?\"A\u0011AA1\u0011\u001d\ty\u0007\u0002C\u0001\u0003cBq!a\u001e\u0005\t\u0003\tI\bC\u0004\u0002~\u0011!\t!a \t\u000f\u0005=E\u0001\"\u0001\u0002\u0012\"I\u0011Q\u0016\u0003\u0012\u0002\u0013\u0005\u0011q\u0016\u0005\b\u0003\u000b$A\u0011AAd\u0011\u001d\ti\r\u0002C\u0001\u0003\u001f\fACU3rk\u0016\u001cH\u000fS1oI2,'\u000fS3ma\u0016\u0014(B\u0001\r\u001a\u0003\u0019\u0019XM\u001d<fe*\t!$A\u0003lC\u001a\\\u0017m\u0001\u0001\u0011\u0005u\tQ\"A\f\u0003)I+\u0017/^3ti\"\u000bg\u000e\u001a7fe\"+G\u000e]3s'\t\t\u0001\u0005\u0005\u0002\"I5\t!EC\u0001$\u0003\u0015\u00198-\u00197b\u0013\t)#E\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003q\t!c\u001c8MK\u0006$WM]:iSB\u001c\u0005.\u00198hKR)!&L\u001c@'B\u0011\u0011eK\u0005\u0003Y\t\u0012A!\u00168ji\")af\u0001a\u0001_\u0005\u0001rM]8va\u000e{wN\u001d3j]\u0006$xN\u001d\t\u0003aUj\u0011!\r\u0006\u0003eM\nQa\u001a:pkBT!\u0001N\r\u0002\u0017\r|wN\u001d3j]\u0006$xN]\u0005\u0003mE\u0012\u0001c\u0012:pkB\u001cun\u001c:eS:\fGo\u001c:\t\u000ba\u001a\u0001\u0019A\u001d\u0002\u001dQDhnQ8pe\u0012Lg.\u0019;peB\u0011!(P\u0007\u0002w)\u0011AhM\u0001\fiJ\fgn]1di&|g.\u0003\u0002?w\t1BK]1og\u0006\u001cG/[8o\u0007>|'\u000fZ5oCR|'\u000fC\u0003A\u0007\u0001\u0007\u0011)\u0001\bva\u0012\fG/\u001a3MK\u0006$WM]:\u0011\u0007\tSUJ\u0004\u0002D\u0011:\u0011AiR\u0007\u0002\u000b*\u0011aiG\u0001\u0007yI|w\u000e\u001e \n\u0003\rJ!!\u0013\u0012\u0002\u000fA\f7m[1hK&\u00111\n\u0014\u0002\t\u0013R,'/\u00192mK*\u0011\u0011J\t\t\u0003\u001dFk\u0011a\u0014\u0006\u0003!f\tqa\u00197vgR,'/\u0003\u0002S\u001f\nI\u0001+\u0019:uSRLwN\u001c\u0005\u0006)\u000e\u0001\r!Q\u0001\u0011kB$\u0017\r^3e\r>dGn\\<feN\u001c\"\u0001\u0002\u0011\u0002\u001dI,\u0017/^3ti\u000eC\u0017M\u001c8fYB\u0011\u0001lW\u0007\u00023*\u0011!,G\u0001\b]\u0016$xo\u001c:l\u0013\ta\u0016L\u0001\bSKF,Xm\u001d;DQ\u0006tg.\u001a7\u0002\rE,x\u000e^1t!\tyfM\u0004\u0002aI:\u0011\u0011m\u0019\b\u0003\t\nL\u0011AG\u0005\u00031eI!!Z\f\u0002\u0019E+x\u000e^1GC\u000e$xN]=\n\u0005\u001dD'!D)v_R\fW*\u00198bO\u0016\u00148O\u0003\u0002f/\u0005!A/[7f!\tYW/D\u0001m\u0015\tig.A\u0003vi&d7O\u0003\u0002pa\u000611m\\7n_:T!AG9\u000b\u0005I\u001c\u0018AB1qC\u000eDWMC\u0001u\u0003\ry'oZ\u0005\u0003m2\u0014A\u0001V5nKR!\u00010\u001f>|!\tiB\u0001C\u0003W\u0011\u0001\u0007q\u000bC\u0003^\u0011\u0001\u0007a\fC\u0003j\u0011\u0001\u0007!.\u0001\u0005uQJ|G\u000f\u001e7f)\u0019Qc0a\u0002\u0002\u001a!1q0\u0003a\u0001\u0003\u0003\tA\"];pi\u0006l\u0015M\\1hKJ\u00042!HA\u0002\u0013\r\t)a\u0006\u0002\u0013\u00072LWM\u001c;Rk>$\u0018-T1oC\u001e,'\u000fC\u0004\u0002\n%\u0001\r!a\u0003\u0002\u000fI,\u0017/^3tiB!\u0011QBA\n\u001d\rA\u0016qB\u0005\u0004\u0003#I\u0016A\u0004*fcV,7\u000f^\"iC:tW\r\\\u0005\u0005\u0003+\t9BA\u0004SKF,Xm\u001d;\u000b\u0007\u0005E\u0011\fC\u0004\u0002\u001c%\u0001\r!!\b\u0002\u001dQD'o\u001c;uY\u0016$\u0016.\\3NgB\u0019\u0011%a\b\n\u0007\u0005\u0005\"EA\u0002J]R\f1\u0002[1oI2,WI\u001d:peR)!&a\n\u0002*!9\u0011\u0011\u0002\u0006A\u0002\u0005-\u0001bBA\u0016\u0015\u0001\u0007\u0011QF\u0001\u0002KB\u0019!)a\f\n\u0007\u0005EBJA\u0005UQJ|w/\u00192mK\u0006Q2/\u001a8e\u000bJ\u0014xN](s\u00072|7/Z\"p]:,7\r^5p]R9!&a\u000e\u0002:\u0005u\u0002bBA\u0005\u0017\u0001\u0007\u00111\u0002\u0005\b\u0003wY\u0001\u0019AA\u0017\u0003\u0015)'O]8s\u0011\u001d\tyd\u0003a\u0001\u0003;\t!\u0002\u001e5s_R$H.Z't\u0003U\u0019XM\u001c3G_J<\u0018M\u001d3fIJ+7\u000f]8og\u0016$RAKA#\u0003\u000fBq!!\u0003\r\u0001\u0004\tY\u0001C\u0004\u0002J1\u0001\r!a\u0013\u0002\u0011I,7\u000f]8og\u0016\u0004B!!\u0014\u0002T5\u0011\u0011q\n\u0006\u0004\u0003#r\u0017\u0001\u0003:fcV,7\u000f^:\n\t\u0005U\u0013q\n\u0002\u0011\u0003\n\u001cHO]1diJ+7\u000f]8og\u0016\f\u0011c]3oI6\u000b\u0017PY3UQJ|G\u000f\u001e7f)\u0015Q\u00131LA/\u0011\u001d\tI!\u0004a\u0001\u0003\u0017Aq!!\u0013\u000e\u0001\u0004\tY%A\rtK:$'+Z:q_:\u001cX-T1zE\u0016$\u0006N]8ui2,G#\u0002\u0016\u0002d\u0005\u0015\u0004bBA\u0005\u001d\u0001\u0007\u00111\u0002\u0005\b\u0003Or\u0001\u0019AA5\u00039\u0019'/Z1uKJ+7\u000f]8og\u0016\u0004r!IA6\u0003;\tY%C\u0002\u0002n\t\u0012\u0011BR;oGRLwN\\\u0019\u0002=M,g\u000eZ#se>\u0014(+Z:q_:\u001cX-T1zE\u0016$\u0006N]8ui2,G#\u0002\u0016\u0002t\u0005U\u0004bBA\u0005\u001f\u0001\u0007\u00111\u0002\u0005\b\u0003wy\u0001\u0019AA\u0017\u0003}i\u0017-\u001f2f%\u0016\u001cwN\u001d3B]\u0012<U\r\u001e+ie>$H\u000f\\3US6,Wj\u001d\u000b\u0005\u0003;\tY\bC\u0004\u0002\nA\u0001\r!a\u0003\u0002YM,g\u000e\u001a*fgB|gn]3NCf\u0014W\r\u00165s_R$H.Z,ji\"\u001cuN\u001c;s_2dWM])v_R\fGc\u0002\u0016\u0002\u0002\u0006-\u0015Q\u0012\u0005\b\u0003\u0007\u000b\u0002\u0019AAC\u0003]\u0019wN\u001c;s_2dWM]'vi\u0006$\u0018n\u001c8Rk>$\u0018\rE\u0002\u001e\u0003\u000fK1!!#\u0018\u0005]\u0019uN\u001c;s_2dWM]'vi\u0006$\u0018n\u001c8Rk>$\u0018\rC\u0004\u0002\nE\u0001\r!a\u0003\t\u000f\u0005\u001d\u0014\u00031\u0001\u0002j\u0005Q2/\u001a8e%\u0016\u001c\bo\u001c8tK\u0016CX-\u001c9u)\"\u0014x\u000e\u001e;mKR9!&a%\u0002\u0016\u0006]\u0005bBA\u0005%\u0001\u0007\u00111\u0002\u0005\b\u0003\u0013\u0012\u0002\u0019AA&\u0011%\tIJ\u0005I\u0001\u0002\u0004\tY*\u0001\u0006p]\u000e{W\u000e\u001d7fi\u0016\u0004R!IAO\u0003CK1!a(#\u0005\u0019y\u0005\u000f^5p]B1\u0011%a\u001b\u0002$*\u0002B!!*\u0002*6\u0011\u0011q\u0015\u0006\u00035:LA!a+\u0002(\n!1+\u001a8e\u0003\u0011\u001aXM\u001c3SKN\u0004xN\\:f\u000bb,W\u000e\u001d;UQJ|G\u000f\u001e7fI\u0011,g-Y;mi\u0012\u001aTCAAYU\u0011\tY*a-,\u0005\u0005U\u0006\u0003BA\\\u0003\u0003l!!!/\u000b\t\u0005m\u0016QX\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a0#\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003\u0007\fILA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fqd]3oI\u0016\u0013(o\u001c:SKN\u0004xN\\:f\u000bb,W\u000e\u001d;UQJ|G\u000f\u001e7f)\u0015Q\u0013\u0011ZAf\u0011\u001d\tI\u0001\u0006a\u0001\u0003\u0017Aq!a\u000f\u0015\u0001\u0004\ti#\u0001\u0010tK:$gj\\(q%\u0016\u001c\bo\u001c8tK\u0016CX-\u001c9u)\"\u0014x\u000e\u001e;mKR\u0019!&!5\t\u000f\u0005%Q\u00031\u0001\u0002\f\u0001")
public class RequestHandlerHelper {
    public final RequestChannel kafka$server$RequestHandlerHelper$$requestChannel;
    private final QuotaFactory.QuotaManagers quotas;
    private final Time time;

    public static void onLeadershipChange(GroupCoordinator groupCoordinator, TransactionCoordinator transactionCoordinator, Iterable<Partition> iterable, Iterable<Partition> iterable2) {
        RequestHandlerHelper$.MODULE$.onLeadershipChange(groupCoordinator, transactionCoordinator, iterable, iterable2);
    }

    public void throttle(ClientQuotaManager quotaManager, RequestChannel.Request request, int throttleTimeMs) {
        ThrottleCallback callback = new ThrottleCallback(this, request){
            private final /* synthetic */ RequestHandlerHelper $outer;
            private final RequestChannel.Request request$1;

            public void startThrottling() {
                this.$outer.kafka$server$RequestHandlerHelper$$requestChannel.startThrottling(this.request$1);
            }

            public void endThrottling() {
                this.$outer.kafka$server$RequestHandlerHelper$$requestChannel.endThrottling(this.request$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.request$1 = request$1;
            }
        };
        quotaManager.throttle(request, callback, throttleTimeMs);
    }

    public void handleError(RequestChannel.Request request, Throwable e) {
        if (e instanceof ClusterAuthorizationException || !request.header().apiKey().clusterAction) {
            this.sendErrorResponseMaybeThrottle(request, e);
            return;
        }
        this.sendErrorResponseExemptThrottle(request, e);
    }

    public void sendErrorOrCloseConnection(RequestChannel.Request request, Throwable error, int throttleMs) {
        Object requestBody = request.body(ClassTag$.MODULE$.apply(AbstractRequest.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
        AbstractResponse response = requestBody.getErrorResponse(throttleMs, error);
        if (response == null) {
            this.kafka$server$RequestHandlerHelper$$requestChannel.closeConnection(request, requestBody.errorCounts(error));
            return;
        }
        this.kafka$server$RequestHandlerHelper$$requestChannel.sendResponse(request, response, (Option<Function1<Send, BoxedUnit>>)None$.MODULE$);
    }

    public void sendForwardedResponse(RequestChannel.Request request, AbstractResponse response) {
        int controllerThrottleTimeMs = response.throttleTimeMs();
        int requestThrottleTimeMs = this.maybeRecordAndGetThrottleTimeMs(request);
        int appliedThrottleTimeMs = package$.MODULE$.max(controllerThrottleTimeMs, requestThrottleTimeMs);
        this.throttle(this.quotas.request(), request, appliedThrottleTimeMs);
        response.maybeSetThrottleTimeMs(appliedThrottleTimeMs);
        this.kafka$server$RequestHandlerHelper$$requestChannel.sendResponse(request, response, (Option<Function1<Send, BoxedUnit>>)None$.MODULE$);
    }

    public void sendMaybeThrottle(RequestChannel.Request request, AbstractResponse response) {
        int throttleTimeMs = this.maybeRecordAndGetThrottleTimeMs(request);
        if (!request.isForwarded()) {
            this.throttle(this.quotas.request(), request, throttleTimeMs);
        }
        response.maybeSetThrottleTimeMs(throttleTimeMs);
        this.kafka$server$RequestHandlerHelper$$requestChannel.sendResponse(request, response, (Option<Function1<Send, BoxedUnit>>)None$.MODULE$);
    }

    public void sendResponseMaybeThrottle(RequestChannel.Request request, Function1<Object, AbstractResponse> createResponse) {
        int throttleTimeMs = this.maybeRecordAndGetThrottleTimeMs(request);
        if (!request.isForwarded()) {
            this.throttle(this.quotas.request(), request, throttleTimeMs);
        }
        this.kafka$server$RequestHandlerHelper$$requestChannel.sendResponse(request, (AbstractResponse)createResponse.apply((Object)BoxesRunTime.boxToInteger((int)throttleTimeMs)), (Option<Function1<Send, BoxedUnit>>)None$.MODULE$);
    }

    public void sendErrorResponseMaybeThrottle(RequestChannel.Request request, Throwable error) {
        int throttleTimeMs = this.maybeRecordAndGetThrottleTimeMs(request);
        if (error instanceof ClusterAuthorizationException || !request.isForwarded()) {
            this.throttle(this.quotas.request(), request, throttleTimeMs);
        }
        this.sendErrorOrCloseConnection(request, error, throttleTimeMs);
    }

    /*
     * WARNING - void declaration
     */
    public int maybeRecordAndGetThrottleTimeMs(RequestChannel.Request request) {
        void var2_2;
        int throttleTimeMs = this.quotas.request().maybeRecordAndGetThrottleTimeMs(request, this.time.milliseconds());
        request.apiThrottleTimeMs_$eq(throttleTimeMs);
        return (int)var2_2;
    }

    public void sendResponseMaybeThrottleWithControllerQuota(ControllerMutationQuota controllerMutationQuota, RequestChannel.Request request, Function1<Object, AbstractResponse> createResponse) {
        int requestThrottleTimeMs;
        long timeMs = this.time.milliseconds();
        int controllerThrottleTimeMs = controllerMutationQuota.throttleTime();
        int maxThrottleTimeMs = Math.max(controllerThrottleTimeMs, requestThrottleTimeMs = this.quotas.request().maybeRecordAndGetThrottleTimeMs(request, timeMs));
        if (maxThrottleTimeMs > 0 && !request.isForwarded()) {
            request.apiThrottleTimeMs_$eq(maxThrottleTimeMs);
            if (controllerThrottleTimeMs > requestThrottleTimeMs) {
                this.throttle(this.quotas.controllerMutation(), request, controllerThrottleTimeMs);
            } else {
                this.throttle(this.quotas.request(), request, requestThrottleTimeMs);
            }
        }
        this.kafka$server$RequestHandlerHelper$$requestChannel.sendResponse(request, (AbstractResponse)createResponse.apply((Object)BoxesRunTime.boxToInteger((int)maxThrottleTimeMs)), (Option<Function1<Send, BoxedUnit>>)None$.MODULE$);
    }

    public void sendResponseExemptThrottle(RequestChannel.Request request, AbstractResponse response, Option<Function1<Send, BoxedUnit>> onComplete) {
        this.quotas.request().maybeRecordExempt(request);
        this.kafka$server$RequestHandlerHelper$$requestChannel.sendResponse(request, response, onComplete);
    }

    public Option<Function1<Send, BoxedUnit>> sendResponseExemptThrottle$default$3() {
        return None$.MODULE$;
    }

    public void sendErrorResponseExemptThrottle(RequestChannel.Request request, Throwable error) {
        this.quotas.request().maybeRecordExempt(request);
        this.sendErrorOrCloseConnection(request, error, 0);
    }

    public void sendNoOpResponseExemptThrottle(RequestChannel.Request request) {
        this.quotas.request().maybeRecordExempt(request);
        this.kafka$server$RequestHandlerHelper$$requestChannel.sendNoOpResponse(request);
    }

    public RequestHandlerHelper(RequestChannel requestChannel, QuotaFactory.QuotaManagers quotas, Time time) {
        this.kafka$server$RequestHandlerHelper$$requestChannel = requestChannel;
        this.quotas = quotas;
        this.time = time;
    }
}

