/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import kafka.server.BrokerToControllerChannelManager;
import kafka.server.BrokerToControllerQueueItem;
import kafka.server.BrokerToControllerRequestThread;
import kafka.server.ControllerInformation;
import kafka.server.ControllerNodeProvider;
import kafka.server.ControllerRequestCompletionHandler;
import kafka.server.KafkaConfig;
import kafka.utils.Logging;
import org.apache.kafka.clients.ApiVersions;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.ManualMetadataUpdater;
import org.apache.kafka.clients.MetadataUpdater;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.clients.NodeApiVersions;
import org.apache.kafka.common.Reconfigurable;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ChannelBuilder;
import org.apache.kafka.common.network.ChannelBuilders;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.Selectable;
import org.apache.kafka.common.network.Selector;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.security.JaasContext;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005mc\u0001\u0002\f\u0018\u0001qA\u0001\"\f\u0001\u0003\u0002\u0003\u0006IA\f\u0005\tc\u0001\u0011\t\u0011)A\u0005e!Aa\b\u0001B\u0001B\u0003%q\b\u0003\u0005E\u0001\t\u0005\t\u0015!\u0003F\u0011!A\u0005A!A!\u0002\u0013I\u0005\u0002\u0003+\u0001\u0005\u0003\u0005\u000b\u0011B+\t\u0011a\u0003!\u0011!Q\u0001\neCQ\u0001\u0018\u0001\u0005\u0002uCqA\u001a\u0001C\u0002\u0013%q\r\u0003\u0004l\u0001\u0001\u0006I\u0001\u001b\u0005\bY\u0002\u0011\r\u0011\"\u0003n\u0011\u0019!\b\u0001)A\u0005]\"9Q\u000f\u0001b\u0001\n\u00131\bB\u0002>\u0001A\u0003%q\u000fC\u0004|\u0001\t\u0007I\u0011\u0002?\t\u000f\u0005\u0005\u0001\u0001)A\u0005{\"9\u00111\u0001\u0001\u0005\u0002\u0005\u0015\u0001bBA\u0007\u0001\u0011\u0005\u0011Q\u0001\u0005\b\u0003\u001f\u0001A\u0011A\f}\u0011\u001d\t\t\u0002\u0001C\u0001\u0003'Aq!a\u0014\u0001\t\u0003\t\tF\u0001\u0013Ce>\\WM\u001d+p\u0007>tGO]8mY\u0016\u00148\t[1o]\u0016dW*\u00198bO\u0016\u0014\u0018*\u001c9m\u0015\tA\u0012$\u0001\u0004tKJ4XM\u001d\u0006\u00025\u0005)1.\u00194lC\u000e\u00011\u0003\u0002\u0001\u001eG\u001d\u0002\"AH\u0011\u000e\u0003}Q\u0011\u0001I\u0001\u0006g\u000e\fG.Y\u0005\u0003E}\u0011a!\u00118z%\u00164\u0007C\u0001\u0013&\u001b\u00059\u0012B\u0001\u0014\u0018\u0005\u0001\u0012%o\\6feR{7i\u001c8ue>dG.\u001a:DQ\u0006tg.\u001a7NC:\fw-\u001a:\u0011\u0005!ZS\"A\u0015\u000b\u0005)J\u0012!B;uS2\u001c\u0018B\u0001\u0017*\u0005\u001daunZ4j]\u001e\facY8oiJ|G\u000e\\3s\u001d>$W\r\u0015:pm&$WM\u001d\t\u0003I=J!\u0001M\f\u0003-\r{g\u000e\u001e:pY2,'OT8eKB\u0013xN^5eKJ\fA\u0001^5nKB\u00111\u0007P\u0007\u0002i)\u0011!&\u000e\u0006\u0003m]\naaY8n[>t'B\u0001\u000e9\u0015\tI$(\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002w\u0005\u0019qN]4\n\u0005u\"$\u0001\u0002+j[\u0016\fq!\\3ue&\u001c7\u000f\u0005\u0002A\u00056\t\u0011I\u0003\u0002?k%\u00111)\u0011\u0002\b\u001b\u0016$(/[2t\u0003\u0019\u0019wN\u001c4jOB\u0011AER\u0005\u0003\u000f^\u00111bS1gW\u0006\u001cuN\u001c4jO\u0006Y1\r[1o]\u0016dg*Y7f!\tQ\u0015K\u0004\u0002L\u001fB\u0011AjH\u0007\u0002\u001b*\u0011ajG\u0001\u0007yI|w\u000e\u001e \n\u0005A{\u0012A\u0002)sK\u0012,g-\u0003\u0002S'\n11\u000b\u001e:j]\u001eT!\u0001U\u0010\u0002!QD'/Z1e\u001d\u0006lW\r\u0015:fM&D\bc\u0001\u0010W\u0013&\u0011qk\b\u0002\u0007\u001fB$\u0018n\u001c8\u0002\u001dI,GO]=US6,w.\u001e;NgB\u0011aDW\u0005\u00037~\u0011A\u0001T8oO\u00061A(\u001b8jiz\"\u0002BX0aC\n\u001cG-\u001a\t\u0003I\u0001AQ!\f\u0005A\u00029BQ!\r\u0005A\u0002IBQA\u0010\u0005A\u0002}BQ\u0001\u0012\u0005A\u0002\u0015CQ\u0001\u0013\u0005A\u0002%CQ\u0001\u0016\u0005A\u0002UCQ\u0001\u0017\u0005A\u0002e\u000b!\u0002\\8h\u0007>tG/\u001a=u+\u0005A\u0007CA\u001aj\u0013\tQGG\u0001\u0006M_\u001e\u001cuN\u001c;fqR\f1\u0002\\8h\u0007>tG/\u001a=uA\u0005)R.\u00198vC2lU\r^1eCR\fW\u000b\u001d3bi\u0016\u0014X#\u00018\u0011\u0005=\u0014X\"\u00019\u000b\u0005E<\u0014aB2mS\u0016tGo]\u0005\u0003gB\u0014Q#T1ok\u0006dW*\u001a;bI\u0006$\u0018-\u00169eCR,'/\u0001\fnC:,\u0018\r\\'fi\u0006$\u0017\r^1Va\u0012\fG/\u001a:!\u0003-\t\u0007/\u001b,feNLwN\\:\u0016\u0003]\u0004\"a\u001c=\n\u0005e\u0004(aC!qSZ+'o]5p]N\fA\"\u00199j-\u0016\u00148/[8og\u0002\nQB]3rk\u0016\u001cH\u000f\u00165sK\u0006$W#A?\u0011\u0005\u0011r\u0018BA@\u0018\u0005}\u0011%o\\6feR{7i\u001c8ue>dG.\u001a:SKF,Xm\u001d;UQJ,\u0017\rZ\u0001\u000fe\u0016\fX/Z:u)\"\u0014X-\u00193!\u0003\u0015\u0019H/\u0019:u)\t\t9\u0001E\u0002\u001f\u0003\u0013I1!a\u0003 \u0005\u0011)f.\u001b;\u0002\u0011MDW\u000f\u001e3po:\f\u0001C\\3x%\u0016\fX/Z:u)\"\u0014X-\u00193\u0002\u0017M,g\u000e\u001a*fcV,7\u000f\u001e\u000b\u0007\u0003\u000f\t)\"!\u0012\t\u000f\u0005]A\u00031\u0001\u0002\u001a\u00059!/Z9vKN$\b\u0007BA\u000e\u0003g\u0001b!!\b\u0002*\u0005=b\u0002BA\u0010\u0003Ki!!!\t\u000b\u0007\u0005\rR'\u0001\u0005sKF,Xm\u001d;t\u0013\u0011\t9#!\t\u0002\u001f\u0005\u00137\u000f\u001e:bGR\u0014V-];fgRLA!a\u000b\u0002.\t9!)^5mI\u0016\u0014(\u0002BA\u0014\u0003C\u0001B!!\r\u000241\u0001A\u0001DA\u001b\u0003+\t\t\u0011!A\u0003\u0002\u0005]\"aA0%eE!\u0011\u0011HA !\rq\u00121H\u0005\u0004\u0003{y\"a\u0002(pi\"Lgn\u001a\t\u0005\u0003?\t\t%\u0003\u0003\u0002D\u0005\u0005\"aD!cgR\u0014\u0018m\u0019;SKF,Xm\u001d;\t\u000f\u0005\u001dC\u00031\u0001\u0002J\u0005A1-\u00197mE\u0006\u001c7\u000eE\u0002%\u0003\u0017J1!!\u0014\u0018\u0005\t\u001auN\u001c;s_2dWM\u001d*fcV,7\u000f^\"p[BdW\r^5p]\"\u000bg\u000e\u001a7fe\u0006)2m\u001c8ue>dG.\u001a:Ba&4VM]:j_:\u001cHCAA*!\u0011qb+!\u0016\u0011\u0007=\f9&C\u0002\u0002ZA\u0014qBT8eK\u0006\u0003\u0018NV3sg&|gn\u001d")
public class BrokerToControllerChannelManagerImpl
implements BrokerToControllerChannelManager,
Logging {
    private final ControllerNodeProvider controllerNodeProvider;
    private final Time time;
    private final Metrics metrics;
    private final KafkaConfig config;
    private final String channelName;
    private final Option<String> threadNamePrefix;
    private final long retryTimeoutMs;
    private final LogContext logContext;
    private final ManualMetadataUpdater manualMetadataUpdater;
    private final ApiVersions apiVersions;
    private final BrokerToControllerRequestThread requestThread;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private LogContext logContext() {
        return this.logContext;
    }

    private ManualMetadataUpdater manualMetadataUpdater() {
        return this.manualMetadataUpdater;
    }

    private ApiVersions apiVersions() {
        return this.apiVersions;
    }

    private BrokerToControllerRequestThread requestThread() {
        return this.requestThread;
    }

    @Override
    public void start() {
        this.requestThread().start();
    }

    @Override
    public void shutdown() {
        this.requestThread().shutdown();
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("Broker to controller channel manager for ").append($this.channelName).append(" shutdown").toString());
    }

    public BrokerToControllerRequestThread newRequestThread() {
        String string;
        Option<String> option = this.threadNamePrefix;
        if (None$.MODULE$.equals(option)) {
            string = new StringBuilder(46).append("BrokerToControllerChannelManager broker=").append(this.config.brokerId()).append(" name=").append(this.channelName).toString();
        } else if (option instanceof Some) {
            String name = (String)((Some)option).value();
            string = new StringBuilder(47).append(name).append(":BrokerToControllerChannelManager broker=").append(this.config.brokerId()).append(" name=").append(this.channelName).toString();
        } else {
            throw new MatchError(option);
        }
        ControllerInformation controllerInformation = this.controllerNodeProvider.getControllerInfo();
        return new BrokerToControllerRequestThread((KafkaClient)this.buildNetworkClient$1(controllerInformation), controllerInformation.isZkController(), (Function1<ControllerInformation, KafkaClient>)(Function1 & Serializable & scala.Serializable)controllerInfo -> this.buildNetworkClient$1((ControllerInformation)controllerInfo), this.manualMetadataUpdater(), this.controllerNodeProvider, this.config, this.time, string, this.retryTimeoutMs);
    }

    @Override
    public void sendRequest(AbstractRequest.Builder<? extends AbstractRequest> request, ControllerRequestCompletionHandler callback) {
        this.requestThread().enqueue(new BrokerToControllerQueueItem(this.time.milliseconds(), request, callback));
    }

    @Override
    public Option<NodeApiVersions> controllerApiVersions() {
        return this.requestThread().activeControllerAddress().flatMap((Function1 & Serializable & scala.Serializable)activeController -> Option$.MODULE$.apply((Object)this.apiVersions().get(activeController.idString())));
    }

    private final NetworkClient buildNetworkClient$1(ControllerInformation controllerInfo) {
        ChannelBuilder channelBuilder = ChannelBuilders.clientChannelBuilder((SecurityProtocol)controllerInfo.securityProtocol(), (JaasContext.Type)JaasContext.Type.SERVER, (AbstractConfig)this.config, (ListenerName)controllerInfo.listenerName(), (String)controllerInfo.saslMechanism(), (Time)this.time, (boolean)this.config.saslInterBrokerHandshakeRequestEnable(), (LogContext)this.logContext());
        if (channelBuilder instanceof Reconfigurable) {
            this.config.addReconfigurable((Reconfigurable)channelBuilder);
        }
        Selector selector = new Selector(-1, -1L, this.metrics, this.time, this.channelName, (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"BrokerId"), (Object)Integer.toString(this.config.brokerId()))}))).asJava(), false, channelBuilder, this.logContext());
        return new NetworkClient((Selectable)selector, (MetadataUpdater)this.manualMetadataUpdater(), Integer.toString(this.config.brokerId()), 1, 50L, 50L, -1, -1, (int)Math.min(Integer.MAX_VALUE, Math.min((long)this.config.controllerSocketTimeoutMs(), this.retryTimeoutMs)), Predef$.MODULE$.Long2long(this.config.connectionSetupTimeoutMs()), Predef$.MODULE$.Long2long(this.config.connectionSetupTimeoutMaxMs()), this.time, true, this.apiVersions(), this.logContext());
    }

    public BrokerToControllerChannelManagerImpl(ControllerNodeProvider controllerNodeProvider, Time time, Metrics metrics, KafkaConfig config, String channelName, Option<String> threadNamePrefix, long retryTimeoutMs) {
        this.controllerNodeProvider = controllerNodeProvider;
        this.time = time;
        this.metrics = metrics;
        this.config = config;
        this.channelName = channelName;
        this.threadNamePrefix = threadNamePrefix;
        this.retryTimeoutMs = retryTimeoutMs;
        Logging.$init$(this);
        this.logContext = new LogContext(new StringBuilder(49).append("[BrokerToControllerChannelManager broker=").append(config.brokerId()).append(" name=").append(channelName).append("] ").toString());
        this.manualMetadataUpdater = new ManualMetadataUpdater();
        this.apiVersions = new ApiVersions();
        this.requestThread = this.newRequestThread();
    }
}

