/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.cluster.EndPoint;
import kafka.metrics.KafkaMetricsGroup;
import kafka.network.Acceptor$DelayedCloseSocket$;
import kafka.network.ConnectionQuotas;
import kafka.network.ConnectionThrottledException;
import kafka.network.Processor;
import kafka.network.Processor$;
import kafka.network.RequestChannel;
import kafka.network.SocketServer;
import kafka.network.SocketServer$;
import kafka.network.TooManyConnectionsException;
import kafka.security.CredentialProvider;
import kafka.server.ApiVersionManager;
import kafka.server.KafkaConfig;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.KafkaThread;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.PriorityQueue;
import scala.math.Ordered;
import scala.math.Ordering$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.control.ControlThrowable;

@ScalaSignature(bytes="\u0006\u0001\u0011UaAB-[\u0003\u0003af\f\u0003\u0005w\u0001\t\u0015\r\u0011\"\u0001y\u0011!i\bA!A!\u0002\u0013I\b\u0002\u0003@\u0001\u0005\u000b\u0007I\u0011A@\t\u0015\u00055\u0001A!A!\u0002\u0013\t\t\u0001\u0003\u0006\u0002\u0010\u0001\u0011\t\u0019!C\u0001\u0003#A!\"a\b\u0001\u0005\u0003\u0007I\u0011AA\u0011\u0011)\t\u0019\u0004\u0001B\u0001B\u0003&\u00111\u0003\u0005\u000b\u0003k\u0001!\u0011!Q\u0001\n\u0005]\u0002BCA\u001f\u0001\t\u0015\r\u0011\"\u0001\u0002@!Q\u0011q\t\u0001\u0003\u0002\u0003\u0006I!!\u0011\t\u0015\u0005%\u0003A!A!\u0002\u0013\tY\u0005\u0003\u0006\u0002d\u0001\u0011\t\u0011)A\u0005\u0003KB!\"a\u001b\u0001\u0005\u0003\u0005\u000b\u0011BA7\u0011%\u0019\bA!A!\u0002\u0013\t\u0019\b\u0003\u0006\u0002~\u0001\u0011\t\u0011)A\u0005\u0003\u007fB!\"a#\u0001\u0005\u0003\u0005\u000b\u0011BAG\u0011)\t\u0019\n\u0001B\u0001B\u0003%\u0011Q\u0013\u0005\u000b\u0003C\u0003!\u0011!Q\u0001\n\u0005\r\u0006bBAU\u0001\u0011\u0005\u00111\u0016\u0005\n\u0003\u0013\u0004!\u0019!C\u0001\u0003\u0017D\u0001\"!9\u0001A\u0003%\u0011Q\u001a\u0005\b\u0003G\u0004a\u0011AAs\u0011\u001d\ti\u0010\u0001D\u0001\u0003KD\u0011\"a@\u0001\u0005\u0004%IA!\u0001\t\u0011\t%\u0001\u0001)A\u0005\u0005\u0007A\u0011Ba\u0003\u0001\u0005\u0004%IA!\u0001\t\u0011\t5\u0001\u0001)A\u0005\u0005\u0007A\u0011Ba\u0004\u0001\u0005\u0004%IA!\u0001\t\u0011\tE\u0001\u0001)A\u0005\u0005\u0007A\u0011Ba\u0005\u0001\u0005\u0004%IA!\u0006\t\u0011\t\u001d\u0002\u0001)A\u0005\u0005/A!B!\u000b\u0001\u0005\u0004%\tA\u0017B\u0016\u0011!\u0011\u0019\u0004\u0001Q\u0001\n\t5\u0002B\u0003B\u001b\u0001\t\u0007I\u0011\u0001.\u00038!A!q\n\u0001!\u0002\u0013\u0011I\u0004C\u0005\u0003R\u0001\u0011\r\u0011\"\u0003\u0003T!A!1\u000e\u0001!\u0002\u0013\u0011)\u0006C\u0005\u0003n\u0001\u0011\r\u0011\"\u0003\u0003p!A!q\u000f\u0001!\u0002\u0013\u0011\t\bC\u0005\u0003z\u0001\u0001\r\u0011\"\u0003\u0003|!I!Q\u0010\u0001A\u0002\u0013%!q\u0010\u0005\t\u0005\u0007\u0003\u0001\u0015)\u0003\u00028!Q!Q\u0011\u0001C\u0002\u0013\u0005!La\"\t\u0011\ru\u0002\u0001)A\u0005\u0005\u0013C\u0011ba\u0010\u0001\u0001\u0004%Ia!\u0011\t\u0013\r\r\u0003\u00011A\u0005\n\r\u0015\u0003\u0002CB%\u0001\u0001\u0006K!!\u001a\t\u0015\r-\u0003A1A\u0005\u0002i\u001bi\u0005\u0003\u0005\u0004^\u0001\u0001\u000b\u0011BB(\u0011%\u0019y\u0006\u0001b\u0001\n\u0003\u0019\t\u0007\u0003\u0005\u0004j\u0001\u0001\u000b\u0011BB2\r\u001d\u0011\u0019\n\u0001![\u0005+C!Ba/5\u0005+\u0007I\u0011\u0001B_\u0011)\u0011)\r\u000eB\tB\u0003%!q\u0018\u0005\u000b\u0005\u000f$$Q3A\u0005\u0002\t%\u0007B\u0003Bii\tE\t\u0015!\u0003\u0003L\"9\u0011\u0011\u0016\u001b\u0005\u0002\tM\u0007b\u0002Bmi\u0011\u0005#1\u001c\u0005\n\u0005C$\u0014\u0011!C\u0001\u0005GD\u0011B!;5#\u0003%\tAa;\t\u0013\r\u0005A'%A\u0005\u0002\r\r\u0001\"CB\u0004i\u0005\u0005I\u0011IB\u0005\u0011%\u0019y\u0001NA\u0001\n\u0003\u0011Y\bC\u0005\u0004\u0012Q\n\t\u0011\"\u0001\u0004\u0014!I1Q\u0004\u001b\u0002\u0002\u0013\u00053q\u0004\u0005\n\u0007S!\u0014\u0011!C\u0001\u0007WA\u0011ba\f5\u0003\u0003%\te!\r\t\u0013\rMB'!A\u0005B\rU\u0002\"CB\u001ci\u0005\u0005I\u0011IB\u001d\u000f)\u0019Y\u0007AA\u0001\u0012\u0003Q6Q\u000e\u0004\u000b\u0005'\u0003\u0011\u0011!E\u00015\u000e=\u0004bBAU\u000f\u0012\u00051Q\u0010\u0005\n\u0007g9\u0015\u0011!C#\u0007kA\u0011ba H\u0003\u0003%\ti!!\t\u0013\r\u001du)!A\u0005\u0002\u000e%\u0005\u0002CBN\u0001\u0011\u0005!l!(\t\u000f\r\r\u0006\u0001\"\u0001\u0004&\"91q\u0015\u0001\u0005\u0002\r\u0015\u0006bBBU\u0001\u0011\u00053Q\u0015\u0005\b\u0007W\u0003A\u0011BBW\u0011\u001d\u0019I\f\u0001C\u0005\u0007KCqaa/\u0001\t\u0013\u0019i\fC\u0004\u0004L\u0002!\tb!4\t\u000f\rM\u0007\u0001\"\u0003\u0004&\"91Q\u001b\u0001\u0005\n\r]\u0007bBBr\u0001\u0011\u00051Q\u0015\u0005\b\u0007K\u0004A\u0011ABt\u0011\u001d\u0019i\u000f\u0001C\u0001\u0007_\u0014\u0001\"Q2dKB$xN\u001d\u0006\u00037r\u000bqA\\3uo>\u00148NC\u0001^\u0003\u0015Y\u0017MZ6b'\u0015\u0001ql\u001a6q!\t\u0001W-D\u0001b\u0015\t\u00117-\u0001\u0003mC:<'\"\u00013\u0002\t)\fg/Y\u0005\u0003M\u0006\u0014aa\u00142kK\u000e$\bC\u00011i\u0013\tI\u0017M\u0001\u0005Sk:t\u0017M\u00197f!\tYg.D\u0001m\u0015\tiG,A\u0003vi&d7/\u0003\u0002pY\n9Aj\\4hS:<\u0007CA9u\u001b\u0005\u0011(BA:]\u0003\u001diW\r\u001e:jGNL!!\u001e:\u0003#-\u000bgm[1NKR\u0014\u0018nY:He>,\b/\u0001\u0007t_\u000e\\W\r^*feZ,'o\u0001\u0001\u0016\u0003e\u0004\"A_>\u000e\u0003iK!\u0001 .\u0003\u0019M{7m[3u'\u0016\u0014h/\u001a:\u0002\u001bM|7m[3u'\u0016\u0014h/\u001a:!\u0003!)g\u000e\u001a)pS:$XCAA\u0001!\u0011\t\u0019!!\u0003\u000e\u0005\u0005\u0015!bAA\u00049\u000691\r\\;ti\u0016\u0014\u0018\u0002BA\u0006\u0003\u000b\u0011\u0001\"\u00128e!>Lg\u000e^\u0001\nK:$\u0007k\\5oi\u0002\naaY8oM&<WCAA\n!\u0011\t)\"a\u0007\u000e\u0005\u0005]!bAA\r9\u000611/\u001a:wKJLA!!\b\u0002\u0018\tY1*\u00194lC\u000e{gNZ5h\u0003)\u0019wN\u001c4jO~#S-\u001d\u000b\u0005\u0003G\ty\u0003\u0005\u0003\u0002&\u0005-RBAA\u0014\u0015\t\tI#A\u0003tG\u0006d\u0017-\u0003\u0003\u0002.\u0005\u001d\"\u0001B+oSRD\u0011\"!\r\u0007\u0003\u0003\u0005\r!a\u0005\u0002\u0007a$\u0013'A\u0004d_:4\u0017n\u001a\u0011\u0002\r9|G-Z%e!\u0011\t)#!\u000f\n\t\u0005m\u0012q\u0005\u0002\u0004\u0013:$\u0018\u0001E2p]:,7\r^5p]F+x\u000e^1t+\t\t\t\u0005E\u0002{\u0003\u0007J1!!\u0012[\u0005A\u0019uN\u001c8fGRLwN\\)v_R\f7/A\td_:tWm\u0019;j_:\fVo\u001c;bg\u0002\nA\u0001^5nKB!\u0011QJA0\u001b\t\tyEC\u0002n\u0003#RA!a\u0015\u0002V\u000511m\\7n_:T1!XA,\u0015\u0011\tI&a\u0017\u0002\r\u0005\u0004\u0018m\u00195f\u0015\t\ti&A\u0002pe\u001eLA!!\u0019\u0002P\t!A+[7f\u0003QI7\u000f\u0015:jm&dWmZ3e\u0019&\u001cH/\u001a8feB!\u0011QEA4\u0013\u0011\tI'a\n\u0003\u000f\t{w\u000e\\3b]\u0006q!/Z9vKN$8\t[1o]\u0016d\u0007c\u0001>\u0002p%\u0019\u0011\u0011\u000f.\u0003\u001dI+\u0017/^3ti\u000eC\u0017M\u001c8fYB!\u0011QOA=\u001b\t\t9HC\u0002t\u0003#JA!a\u001f\u0002x\t9Q*\u001a;sS\u000e\u001c\u0018AE2sK\u0012,g\u000e^5bYB\u0013xN^5eKJ\u0004B!!!\u0002\b6\u0011\u00111\u0011\u0006\u0004\u0003\u000bc\u0016\u0001C:fGV\u0014\u0018\u000e^=\n\t\u0005%\u00151\u0011\u0002\u0013\u0007J,G-\u001a8uS\u0006d\u0007K]8wS\u0012,'/\u0001\u0006m_\u001e\u001cuN\u001c;fqR\u0004B!!\u0014\u0002\u0010&!\u0011\u0011SA(\u0005)aunZ\"p]R,\u0007\u0010^\u0001\u000b[\u0016lwN]=Q_>d\u0007\u0003BAL\u0003;k!!!'\u000b\t\u0005m\u0015\u0011K\u0001\u0007[\u0016lwN]=\n\t\u0005}\u0015\u0011\u0014\u0002\u000b\u001b\u0016lwN]=Q_>d\u0017!E1qSZ+'o]5p]6\u000bg.Y4feB!\u0011QCAS\u0013\u0011\t9+a\u0006\u0003#\u0005\u0003\u0018NV3sg&|g.T1oC\u001e,'/\u0001\u0004=S:LGO\u0010\u000b\u001d\u0003[\u000by+!-\u00024\u0006U\u0016qWA]\u0003w\u000bi,a0\u0002B\u0006\r\u0017QYAd!\tQ\b\u0001C\u0003w'\u0001\u0007\u0011\u0010\u0003\u0004\u007f'\u0001\u0007\u0011\u0011\u0001\u0005\b\u0003\u001f\u0019\u0002\u0019AA\n\u0011\u001d\t)d\u0005a\u0001\u0003oAq!!\u0010\u0014\u0001\u0004\t\t\u0005C\u0004\u0002JM\u0001\r!a\u0013\t\u000f\u0005\r4\u00031\u0001\u0002f!9\u00111N\nA\u0002\u00055\u0004BB:\u0014\u0001\u0004\t\u0019\bC\u0004\u0002~M\u0001\r!a \t\u000f\u0005-5\u00031\u0001\u0002\u000e\"9\u00111S\nA\u0002\u0005U\u0005bBAQ'\u0001\u0007\u00111U\u0001\ng\"|W\u000f\u001c3Sk:,\"!!4\u0011\t\u0005=\u0017Q\\\u0007\u0003\u0003#TA!a5\u0002V\u00061\u0011\r^8nS\u000eTA!a6\u0002Z\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0007\u0005m7-\u0001\u0003vi&d\u0017\u0002BAp\u0003#\u0014Q\"\u0011;p[&\u001c'i\\8mK\u0006t\u0017AC:i_VdGMU;oA\u0005aQ.\u001a;sS\u000e\u0004&/\u001a4jqR\u0011\u0011q\u001d\t\u0005\u0003S\f9P\u0004\u0003\u0002l\u0006M\b\u0003BAw\u0003Oi!!a<\u000b\u0007\u0005Ex/\u0001\u0004=e>|GOP\u0005\u0005\u0003k\f9#\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003s\fYP\u0001\u0004TiJLgn\u001a\u0006\u0005\u0003k\f9#\u0001\u0007uQJ,\u0017\r\u001a)sK\u001aL\u00070\u0001\btK:$')\u001e4gKJ\u001c\u0016N_3\u0016\u0005\t\r\u0001c\u00011\u0003\u0006%\u0019!qA1\u0003\u000f%sG/Z4fe\u0006y1/\u001a8e\u0005V4g-\u001a:TSj,\u0007%\u0001\bsK\u000e4()\u001e4gKJ\u001c\u0016N_3\u0002\u001fI,7M\u001e\"vM\u001a,'oU5{K\u0002\n\u0011\u0003\\5ti\u0016t')Y2lY><7+\u001b>f\u0003Ia\u0017n\u001d;f]\n\u000b7m\u001b7pONK'0\u001a\u0011\u0002\u00179LwnU3mK\u000e$xN]\u000b\u0003\u0005/\u0001BA!\u0007\u0003$5\u0011!1\u0004\u0006\u0005\u0005;\u0011y\"\u0001\u0005dQ\u0006tg.\u001a7t\u0015\r\u0011\tcY\u0001\u0004]&|\u0017\u0002\u0002B\u0013\u00057\u0011\u0001bU3mK\u000e$xN]\u0001\r]&|7+\u001a7fGR|'\u000fI\u0001\u000eg\u0016\u0014h/\u001a:DQ\u0006tg.\u001a7\u0016\u0005\t5\u0002\u0003\u0002B\r\u0005_IAA!\r\u0003\u001c\t\u00192+\u001a:wKJ\u001cvnY6fi\u000eC\u0017M\u001c8fY\u0006q1/\u001a:wKJ\u001c\u0005.\u00198oK2\u0004\u0013A\u00039s_\u000e,7o]8sgV\u0011!\u0011\b\t\u0007\u0005w\u0011)E!\u0013\u000e\u0005\tu\"\u0002\u0002B \u0005\u0003\nq!\\;uC\ndWM\u0003\u0003\u0003D\u0005\u001d\u0012AC2pY2,7\r^5p]&!!q\tB\u001f\u0005-\t%O]1z\u0005V4g-\u001a:\u0011\u0007i\u0014Y%C\u0002\u0003Ni\u0013\u0011\u0002\u0015:pG\u0016\u001c8o\u001c:\u0002\u0017A\u0014xnY3tg>\u00148\u000fI\u0001\u001eE2|7m[3e!\u0016\u00148-\u001a8u\u001b\u0016$XM]'fiJL7MT1nKV\u0011!Q\u000b\t\u0005\u0005/\u00129'\u0004\u0002\u0003Z)!!1\fB/\u0003\u0011\u0019wN]3\u000b\u0007M\u0014yF\u0003\u0003\u0003b\t\r\u0014AB=b[6,'O\u0003\u0002\u0003f\u0005\u00191m\\7\n\t\t%$\u0011\f\u0002\u000b\u001b\u0016$(/[2OC6,\u0017A\b2m_\u000e\\W\r\u001a)fe\u000e,g\u000e^'fi\u0016\u0014X*\u001a;sS\u000et\u0015-\\3!\u0003M\u0011Gn\\2lK\u0012\u0004VM]2f]RlU\r^3s+\t\u0011\t\b\u0005\u0003\u0003X\tM\u0014\u0002\u0002B;\u00053\u0012Q!T3uKJ\fAC\u00197pG.,G\rU3sG\u0016tG/T3uKJ\u0004\u0013!F2veJ,g\u000e\u001e)s_\u000e,7o]8s\u0013:$W\r_\u000b\u0003\u0003o\t\u0011dY;se\u0016tG\u000f\u0015:pG\u0016\u001c8o\u001c:J]\u0012,\u0007p\u0018\u0013fcR!\u00111\u0005BA\u0011%\t\t$KA\u0001\u0002\u0004\t9$\u0001\fdkJ\u0014XM\u001c;Qe>\u001cWm]:pe&sG-\u001a=!\u0003A!\bN]8ui2,GmU8dW\u0016$8/\u0006\u0002\u0003\nB1!1\bBF\u0005\u001fKAA!$\u0003>\ti\u0001K]5pe&$\u00180U;fk\u0016\u00042A!%5\u001b\u0005\u0001!A\u0005#fY\u0006LX\rZ\"m_N,7k\\2lKR\u001c\u0012\u0002\u000eBL\u0005;\u0013yK!.\u0011\t\u0005\u0015\"\u0011T\u0005\u0005\u00057\u000b9C\u0001\u0004B]f\u0014VM\u001a\t\u0007\u0005?\u0013IKa$\u000f\t\t\u0005&Q\u0015\b\u0005\u0003[\u0014\u0019+\u0003\u0002\u0002*%!!qUA\u0014\u0003\u001d\u0001\u0018mY6bO\u0016LAAa+\u0003.\n9qJ\u001d3fe\u0016$'\u0002\u0002BT\u0003O\u0001B!!\n\u00032&!!1WA\u0014\u0005\u001d\u0001&o\u001c3vGR\u0004B!!\n\u00038&!!\u0011XA\u0014\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003\u0019\u0019xnY6fiV\u0011!q\u0018\t\u0005\u00053\u0011\t-\u0003\u0003\u0003D\nm!!D*pG.,Go\u00115b]:,G.A\u0004t_\u000e\\W\r\u001e\u0011\u0002#\u0015tG\r\u00165s_R$H.\u001a+j[\u0016l5/\u0006\u0002\u0003LB!\u0011Q\u0005Bg\u0013\u0011\u0011y-a\n\u0003\t1{gnZ\u0001\u0013K:$G\u000b\u001b:piRdW\rV5nK6\u001b\b\u0005\u0006\u0004\u0003\u0010\nU'q\u001b\u0005\b\u0005wK\u0004\u0019\u0001B`\u0011\u001d\u00119-\u000fa\u0001\u0005\u0017\fqaY8na\u0006\u0014X\r\u0006\u0003\u00028\tu\u0007b\u0002Bpu\u0001\u0007!qR\u0001\u0005i\"\fG/\u0001\u0003d_BLHC\u0002BH\u0005K\u00149\u000fC\u0005\u0003<n\u0002\n\u00111\u0001\u0003@\"I!qY\u001e\u0011\u0002\u0003\u0007!1Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\u0011iO\u000b\u0003\u0003@\n=8F\u0001By!\u0011\u0011\u0019P!@\u000e\u0005\tU(\u0002\u0002B|\u0005s\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\t\tm\u0018qE\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B\u0000\u0005k\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"a!\u0002+\t\t-'q^\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\r-\u0001c\u00011\u0004\u000e%\u0019\u0011\u0011`1\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!1QCB\u000e!\u0011\t)ca\u0006\n\t\re\u0011q\u0005\u0002\u0004\u0003:L\b\"CA\u0019\u0001\u0006\u0005\t\u0019AA\u001c\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAB\u0011!\u0019\u0019\u0019c!\n\u0004\u00165\u0011!\u0011I\u0005\u0005\u0007O\u0011\tE\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BA3\u0007[A\u0011\"!\rC\u0003\u0003\u0005\ra!\u0006\u0002\u0011!\f7\u000f[\"pI\u0016$\"!a\u000e\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"aa\u0003\u0002\r\u0015\fX/\u00197t)\u0011\t)ga\u000f\t\u0013\u0005ER)!AA\u0002\rU\u0011!\u0005;ie>$H\u000f\\3e'>\u001c7.\u001a;tA\u000591\u000f^1si\u0016$WCAA3\u0003-\u0019H/\u0019:uK\u0012|F%Z9\u0015\t\u0005\r2q\t\u0005\n\u0003cq\u0013\u0011!a\u0001\u0003K\n\u0001b\u001d;beR,G\rI\u0001\fgR\f'\u000f\u001e$viV\u0014X-\u0006\u0002\u0004PA11\u0011KB*\u0007/j!!!6\n\t\rU\u0013Q\u001b\u0002\u0012\u0007>l\u0007\u000f\\3uC\ndWMR;ukJ,\u0007c\u00011\u0004Z%\u001911L1\u0003\tY{\u0017\u000eZ\u0001\rgR\f'\u000f\u001e$viV\u0014X\rI\u0001\u0007i\"\u0014X-\u00193\u0016\u0005\r\r\u0004\u0003BA'\u0007KJAaa\u001a\u0002P\tY1*\u00194lCRC'/Z1e\u0003\u001d!\bN]3bI\u0002\n!\u0003R3mCf,Gm\u00117pg\u0016\u001cvnY6fiB\u0019!\u0011S$\u0014\u000b\u001d\u001b\tH!.\u0011\u0015\rM4\u0011\u0010B`\u0005\u0017\u0014y)\u0004\u0002\u0004v)!1qOA\u0014\u0003\u001d\u0011XO\u001c;j[\u0016LAaa\u001f\u0004v\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001a\u0015\u0005\r5\u0014!B1qa2LHC\u0002BH\u0007\u0007\u001b)\tC\u0004\u0003<*\u0003\rAa0\t\u000f\t\u001d'\n1\u0001\u0003L\u00069QO\\1qa2LH\u0003BBF\u0007/\u0003b!!\n\u0004\u000e\u000eE\u0015\u0002BBH\u0003O\u0011aa\u00149uS>t\u0007\u0003CA\u0013\u0007'\u0013yLa3\n\t\rU\u0015q\u0005\u0002\u0007)V\u0004H.\u001a\u001a\t\u0013\re5*!AA\u0002\t=\u0015a\u0001=%a\u0005\u0001\"/Z7pm\u0016\u0004&o\\2fgN|'o\u001d\u000b\u0005\u0003G\u0019y\nC\u0004\u0004\"2\u0003\r!a\u000e\u0002\u0017I,Wn\u001c<f\u0007>,h\u000e^\u0001\u000eE\u0016<\u0017N\\*ikR$wn\u001e8\u0015\u0005\u0005\r\u0012!B2m_N,\u0017a\u0001:v]\u0006\u0001r\u000e]3o'\u0016\u0014h/\u001a:T_\u000e\\W\r\u001e\u000b\t\u0005[\u0019yka-\u00048\"91\u0011\u0017)A\u0002\u0005\u001d\u0018\u0001\u00025pgRDqa!.Q\u0001\u0004\t9$\u0001\u0003q_J$\bb\u0002B\b!\u0002\u0007\u0011qG\u0001\u0015C\u000e\u001cW\r\u001d;OK^\u001cuN\u001c8fGRLwN\\:\u0002\r\u0005\u001c7-\u001a9u)\u0011\u0019yl!1\u0011\r\u0005\u00152Q\u0012B`\u0011\u001d\u0019\u0019M\u0015a\u0001\u0007\u000b\f1a[3z!\u0011\u0011Iba2\n\t\r%'1\u0004\u0002\r'\u0016dWm\u0019;j_:\\U-_\u0001\u001fG>tg-[4ve\u0016\f5mY3qi\u0016$7k\\2lKR\u001c\u0005.\u00198oK2$B!a\t\u0004P\"91\u0011[*A\u0002\t}\u0016!D:pG.,Go\u00115b]:,G.A\rdY>\u001cX\r\u00165s_R$H.\u001a3D_:tWm\u0019;j_:\u001c\u0018aE1tg&<gNT3x\u0007>tg.Z2uS>tG\u0003CA3\u00073\u001cYna8\t\u000f\rEW\u000b1\u0001\u0003@\"91Q\\+A\u0002\t%\u0013!\u00039s_\u000e,7o]8s\u0011\u001d\u0019\t/\u0016a\u0001\u0003K\n\u0001\"\\1z\u00052|7m[\u0001\u0007o\u0006\\W-\u001e9\u0002\u001b\u0005$G\r\u0015:pG\u0016\u001c8o\u001c:t)\u0011\t\u0019c!;\t\u000f\r-x\u000b1\u0001\u00028\u0005AAo\\\"sK\u0006$X-\u0001\u0007oK^\u0004&o\\2fgN|'\u000f\u0006\u0005\u0003J\rE8Q\u001fC\u0002\u0011\u001d\u0019\u0019\u0010\u0017a\u0001\u0003o\t!!\u001b3\t\u000f\r]\b\f1\u0001\u0004z\u0006aA.[:uK:,'OT1nKB!11`B\u0000\u001b\t\u0019iPC\u0002\\\u0003#JA\u0001\"\u0001\u0004~\naA*[:uK:,'OT1nK\"9AQ\u0001-A\u0002\u0011\u001d\u0011\u0001E:fGV\u0014\u0018\u000e^=Qe>$xnY8m!\u0011!I\u0001\"\u0005\u000e\u0005\u0011-!\u0002\u0002C\u0007\t\u001f\tA!Y;uQ*!\u0011QQA)\u0013\u0011!\u0019\u0002b\u0003\u0003!M+7-\u001e:jif\u0004&o\u001c;pG>d\u0007")
public abstract class Acceptor
implements Runnable,
KafkaMetricsGroup {
    private volatile Acceptor$DelayedCloseSocket$ DelayedCloseSocket$module;
    private final SocketServer socketServer;
    private final EndPoint endPoint;
    private KafkaConfig config;
    private final int nodeId;
    private final ConnectionQuotas connectionQuotas;
    private final Time time;
    private final boolean isPrivilegedListener;
    private final RequestChannel requestChannel;
    private final Metrics metrics;
    private final CredentialProvider credentialProvider;
    private final LogContext logContext;
    private final MemoryPool memoryPool;
    private final ApiVersionManager apiVersionManager;
    private final AtomicBoolean shouldRun;
    private final Integer sendBufferSize;
    private final Integer recvBufferSize;
    private final Integer listenBacklogSize;
    private final Selector nioSelector;
    private final ServerSocketChannel serverChannel;
    private final ArrayBuffer<Processor> processors;
    private final MetricName blockedPercentMeterMetricName;
    private final Meter blockedPercentMeter;
    private int currentProcessorIndex;
    private final PriorityQueue<DelayedCloseSocket> throttledSockets;
    private boolean started;
    private final CompletableFuture<Void> startFuture;
    private final KafkaThread thread;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Meter newMeter(MetricName metricName, String eventType, TimeUnit timeUnit) {
        return KafkaMetricsGroup.newMeter$(this, metricName, eventType, timeUnit);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    public Acceptor$DelayedCloseSocket$ DelayedCloseSocket() {
        if (this.DelayedCloseSocket$module == null) {
            this.DelayedCloseSocket$lzycompute$1();
        }
        return this.DelayedCloseSocket$module;
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public SocketServer socketServer() {
        return this.socketServer;
    }

    public EndPoint endPoint() {
        return this.endPoint;
    }

    public KafkaConfig config() {
        return this.config;
    }

    public void config_$eq(KafkaConfig x$1) {
        this.config = x$1;
    }

    public ConnectionQuotas connectionQuotas() {
        return this.connectionQuotas;
    }

    public AtomicBoolean shouldRun() {
        return this.shouldRun;
    }

    public abstract String metricPrefix();

    public abstract String threadPrefix();

    private Integer sendBufferSize() {
        return this.sendBufferSize;
    }

    private Integer recvBufferSize() {
        return this.recvBufferSize;
    }

    private Integer listenBacklogSize() {
        return this.listenBacklogSize;
    }

    private Selector nioSelector() {
        return this.nioSelector;
    }

    public ServerSocketChannel serverChannel() {
        return this.serverChannel;
    }

    public ArrayBuffer<Processor> processors() {
        return this.processors;
    }

    private MetricName blockedPercentMeterMetricName() {
        return this.blockedPercentMeterMetricName;
    }

    private Meter blockedPercentMeter() {
        return this.blockedPercentMeter;
    }

    private int currentProcessorIndex() {
        return this.currentProcessorIndex;
    }

    private void currentProcessorIndex_$eq(int x$1) {
        this.currentProcessorIndex = x$1;
    }

    public PriorityQueue<DelayedCloseSocket> throttledSockets() {
        return this.throttledSockets;
    }

    private boolean started() {
        return this.started;
    }

    private void started_$eq(boolean x$1) {
        this.started = x$1;
    }

    public CompletableFuture<Void> startFuture() {
        return this.startFuture;
    }

    public KafkaThread thread() {
        return this.thread;
    }

    public synchronized void removeProcessors(int removeCount) {
        ArrayBuffer toRemove = (ArrayBuffer)this.processors().takeRight(removeCount);
        this.processors().remove(this.processors().size() - removeCount, removeCount);
        toRemove.foreach((Function1 & Serializable & scala.Serializable)x$12 -> {
            x$12.close();
            return BoxedUnit.UNIT;
        });
        toRemove.foreach((Function1 & Serializable & scala.Serializable)processor -> {
            this.requestChannel.removeProcessor(processor.id());
            return BoxedUnit.UNIT;
        });
    }

    public void beginShutdown() {
        if (this.shouldRun().getAndSet(false)) {
            this.wakeup();
            synchronized (this) {
                this.processors().foreach((Function1 & Serializable & scala.Serializable)x$13 -> {
                    x$13.beginShutdown();
                    return BoxedUnit.UNIT;
                });
                return;
            }
        }
    }

    public void close() {
        this.beginShutdown();
        this.thread().join();
        synchronized (this) {
            this.processors().foreach((Function1 & Serializable & scala.Serializable)x$14 -> {
                x$14.close();
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        this.serverChannel().register(this.nioSelector(), 16);
        try {
            while (this.shouldRun().get()) {
                try {
                    this.acceptNewConnections();
                    this.closeThrottledConnections();
                }
                catch (Throwable throwable) {
                    if (throwable instanceof ControlThrowable) {
                        throw (Throwable)((ControlThrowable)throwable);
                    }
                    if (throwable == null) throw null;
                    this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error occurred", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> throwable);
                    continue;
                    return;
                }
            }
        }
        finally {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Closing server socket, selector, and any throttled sockets.");
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.serverChannel().close(), this, Level.ERROR);
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.nioSelector().close(), this, Level.ERROR);
            this.throttledSockets().foreach((Function1 & Serializable & scala.Serializable)throttledSocket -> {
                SocketServer$.MODULE$.closeSocket(throttledSocket.socket(), this);
                return BoxedUnit.UNIT;
            });
            this.throttledSockets().clear();
        }
    }

    private ServerSocketChannel openServerSocket(String host, int port, int listenBacklogSize) {
        InetSocketAddress socketAddress = Utils.isBlank((String)host) ? new InetSocketAddress(port) : new InetSocketAddress(host, port);
        ServerSocketChannel serverChannel = ServerSocketChannel.open();
        serverChannel.configureBlocking(false);
        if (!BoxesRunTime.equalsNumObject((Number)this.recvBufferSize(), (Object)BoxesRunTime.boxToInteger((int)-1))) {
            serverChannel.socket().setReceiveBufferSize(Predef$.MODULE$.Integer2int(this.recvBufferSize()));
        }
        try {
            serverChannel.socket().bind(socketAddress, listenBacklogSize);
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Awaiting socket connections on ").append(socketAddress.getHostString()).append(":").append(serverChannel.socket().getLocalPort()).append(".").toString());
        }
        catch (SocketException e) {
            throw new KafkaException(new StringBuilder(36).append("Socket server failed to bind to ").append(socketAddress.getHostString()).append(":").append(port).append(": ").append(e.getMessage()).append(".").toString(), (Throwable)e);
        }
        return serverChannel;
    }

    private void acceptNewConnections() {
        if (this.nioSelector().select(500L) > 0) {
            java.util.Iterator<SelectionKey> iter = this.nioSelector().selectedKeys().iterator();
            while (iter.hasNext() && this.shouldRun().get()) {
                try {
                    SelectionKey key = iter.next();
                    iter.remove();
                    if (key.isAcceptable()) {
                        this.accept(key).foreach((Function1 & Serializable & scala.Serializable)socketChannel -> {
                            Acceptor.$anonfun$acceptNewConnections$1(this, socketChannel);
                            return BoxedUnit.UNIT;
                        });
                        continue;
                    }
                    throw new IllegalStateException("Unrecognized key state for acceptor thread.");
                }
                catch (Throwable e) {
                    this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error while accepting connection", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                }
            }
        }
    }

    private Option<SocketChannel> accept(SelectionKey key) {
        SocketChannel socketChannel = ((ServerSocketChannel)key.channel()).accept();
        try {
            this.connectionQuotas().inc(this.endPoint().listenerName(), socketChannel.socket().getInetAddress(), this.blockedPercentMeter());
            this.configureAcceptedSocketChannel(socketChannel);
            return new Some((Object)socketChannel);
        }
        catch (TooManyConnectionsException e) {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(86).append("Rejected connection from ").append(e.ip()).append(", address already has the configured maximum of ").append(e.count()).append(" connections.").toString());
            this.connectionQuotas().closeChannel(this, this.endPoint().listenerName(), socketChannel);
            return None$.MODULE$;
        }
        catch (ConnectionThrottledException e) {
            InetAddress ip = socketChannel.socket().getInetAddress();
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Delaying closing of connection from ").append(ip).append(" for ").append(e.throttleTimeMs()).append(" ms").toString());
            long endThrottleTimeMs = e.startThrottleTimeMs() + e.throttleTimeMs();
            this.throttledSockets().$plus$eq((Object)new DelayedCloseSocket(this, socketChannel, endThrottleTimeMs));
            return None$.MODULE$;
        }
        catch (IOException e) {
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Encountered an error while configuring the connection, closing it.", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
            this.connectionQuotas().closeChannel(this, this.endPoint().listenerName(), socketChannel);
            return None$.MODULE$;
        }
    }

    public void configureAcceptedSocketChannel(SocketChannel socketChannel) {
        socketChannel.configureBlocking(false);
        socketChannel.socket().setTcpNoDelay(true);
        socketChannel.socket().setKeepAlive(true);
        if (!BoxesRunTime.equalsNumObject((Number)this.sendBufferSize(), (Object)BoxesRunTime.boxToInteger((int)-1))) {
            socketChannel.socket().setSendBufferSize(Predef$.MODULE$.Integer2int(this.sendBufferSize()));
        }
    }

    private void closeThrottledConnections() {
        long timeMs = this.time.milliseconds();
        while (this.throttledSockets().headOption().exists((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)Acceptor.$anonfun$closeThrottledConnections$1(timeMs, x$15)))) {
            DelayedCloseSocket closingSocket = (DelayedCloseSocket)this.throttledSockets().dequeue();
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(23).append("Closing socket from ip ").append(closingSocket.socket().getRemoteAddress()).toString());
            SocketServer$.MODULE$.closeSocket(closingSocket.socket(), this);
        }
    }

    private boolean assignNewConnection(SocketChannel socketChannel, Processor processor, boolean mayBlock) {
        if (processor.accept(socketChannel, mayBlock, this.blockedPercentMeter())) {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(138).append("Accepted connection from ").append(socketChannel.socket().getRemoteSocketAddress()).append(" on").append(" ").append(socketChannel.socket().getLocalSocketAddress()).append(" and assigned it to processor ").append(processor.id()).append(",").append(" sendBufferSize [actual|requested]: [").append(socketChannel.socket().getSendBufferSize()).append("|").append(this.sendBufferSize()).append("]").append(" recvBufferSize [actual|requested]: [").append(socketChannel.socket().getReceiveBufferSize()).append("|").append(this.recvBufferSize()).append("]").toString());
            return true;
        }
        return false;
    }

    public void wakeup() {
        this.nioSelector().wakeup();
    }

    public void addProcessors(int toCreate) {
        synchronized (this) {
            ListenerName listenerName = this.endPoint().listenerName();
            SecurityProtocol securityProtocol = this.endPoint().securityProtocol();
            ArrayBuffer listenerProcessors = new ArrayBuffer();
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), toCreate).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
                Processor processor = this.newProcessor(this.socketServer().nextProcessorId(), listenerName, securityProtocol);
                listenerProcessors.$plus$eq((Object)processor);
                $this.requestChannel.addProcessor(processor);
                if (this.started()) {
                    processor.start();
                }
            });
            this.processors().$plus$plus$eq((TraversableOnce)listenerProcessors);
            return;
        }
    }

    public Processor newProcessor(int id, ListenerName listenerName, SecurityProtocol securityProtocol) {
        String name = new StringBuilder(25).append(this.threadPrefix()).append("-kafka-network-thread-").append(this.nodeId).append("-").append(this.endPoint().listenerName()).append("-").append(this.endPoint().securityProtocol()).append("-").append(id).toString();
        return new Processor(id, this.time, Predef$.MODULE$.Integer2int(this.config().socketRequestMaxBytes()), this.requestChannel, this.connectionQuotas(), Predef$.MODULE$.Long2long(this.config().connectionsMaxIdleMs()), Predef$.MODULE$.Integer2int(this.config().failedAuthenticationDelayMs()), listenerName, securityProtocol, this.config(), this.metrics, this.credentialProvider, this.memoryPool, this.logContext, Processor$.MODULE$.ConnectionQueueSize(), this.isPrivilegedListener, this.apiVersionManager, name);
    }

    private final void DelayedCloseSocket$lzycompute$1() {
        synchronized (this) {
            if (this.DelayedCloseSocket$module == null) {
                this.DelayedCloseSocket$module = new Acceptor$DelayedCloseSocket$(this);
            }
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$acceptNewConnections$1(Acceptor $this, SocketChannel socketChannel) {
        Processor processor;
        int n;
        synchronized ($this) {
            n = $this.processors().length();
        }
        int retriesLeft = n;
        do {
            --retriesLeft;
            synchronized ($this) {
                $this.currentProcessorIndex_$eq($this.currentProcessorIndex() % $this.processors().length());
                processor = (Processor)$this.processors().apply($this.currentProcessorIndex());
            }
            $this.currentProcessorIndex_$eq($this.currentProcessorIndex() + 1);
        } while (!$this.assignNewConnection(socketChannel, processor, retriesLeft == 0));
    }

    public static final /* synthetic */ boolean $anonfun$closeThrottledConnections$1(long timeMs$1, DelayedCloseSocket x$15) {
        return x$15.endThrottleTimeMs() < timeMs$1;
    }

    public Acceptor(SocketServer socketServer, EndPoint endPoint, KafkaConfig config, int nodeId, ConnectionQuotas connectionQuotas, Time time, boolean isPrivilegedListener, RequestChannel requestChannel, Metrics metrics, CredentialProvider credentialProvider, LogContext logContext, MemoryPool memoryPool, ApiVersionManager apiVersionManager) {
        this.socketServer = socketServer;
        this.endPoint = endPoint;
        this.config = config;
        this.nodeId = nodeId;
        this.connectionQuotas = connectionQuotas;
        this.time = time;
        this.isPrivilegedListener = isPrivilegedListener;
        this.requestChannel = requestChannel;
        this.metrics = metrics;
        this.credentialProvider = credentialProvider;
        this.logContext = logContext;
        this.memoryPool = memoryPool;
        this.apiVersionManager = apiVersionManager;
        Logging.$init$(this);
        KafkaMetricsGroup.$init$(this);
        this.shouldRun = new AtomicBoolean(true);
        this.sendBufferSize = this.config().socketSendBufferBytes();
        this.recvBufferSize = this.config().socketReceiveBufferBytes();
        this.listenBacklogSize = this.config().socketListenBacklogSize();
        this.nioSelector = Selector.open();
        this.serverChannel = this.openServerSocket(endPoint.host(), endPoint.port(), Predef$.MODULE$.Integer2int(this.listenBacklogSize()));
        this.processors = new ArrayBuffer();
        this.blockedPercentMeterMetricName = this.explicitMetricName("kafka.network", "Acceptor", new StringBuilder(22).append(this.metricPrefix()).append("AcceptorBlockedPercent").toString(), (Map<String, String>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Processor$.MODULE$.ListenerMetricTag()), (Object)endPoint.listenerName().value())}))));
        this.blockedPercentMeter = this.newMeter(this.blockedPercentMeterMetricName(), "blocked time", TimeUnit.NANOSECONDS);
        this.currentProcessorIndex = 0;
        this.throttledSockets = new PriorityQueue(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()));
        this.started = false;
        this.startFuture = new CompletableFuture();
        String nonDaemon_name = new StringBuilder(25).append(this.threadPrefix()).append("-kafka-socket-acceptor-").append(endPoint.listenerName()).append("-").append(endPoint.securityProtocol()).append("-").append(endPoint.port()).toString();
        this.thread = new KafkaThread(nonDaemon_name, (Runnable)this, false);
        this.startFuture().thenRun(() -> {
            synchronized (this) {
                if (!this.shouldRun().get()) {
                    this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(73).append("Ignoring start future for ").append(this.endPoint().listenerName()).append(" since the acceptor has already been shut down.").toString());
                } else {
                    this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Starting processors for listener ").append(this.endPoint().listenerName()).toString());
                    this.started_$eq(true);
                    this.processors().foreach((Function1 & Serializable & scala.Serializable)x$11 -> {
                        x$11.start();
                        return BoxedUnit.UNIT;
                    });
                    this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Starting acceptor thread for listener ").append(this.endPoint().listenerName()).toString());
                    this.thread().start();
                }
                return;
            }
        });
    }

    public class DelayedCloseSocket
    implements Ordered<DelayedCloseSocket>,
    Product,
    scala.Serializable {
        private final SocketChannel socket;
        private final long endThrottleTimeMs;
        public final /* synthetic */ Acceptor $outer;

        public boolean $less(Object that) {
            return Ordered.$less$((Ordered)this, (Object)that);
        }

        public boolean $greater(Object that) {
            return Ordered.$greater$((Ordered)this, (Object)that);
        }

        public boolean $less$eq(Object that) {
            return Ordered.$less$eq$((Ordered)this, (Object)that);
        }

        public boolean $greater$eq(Object that) {
            return Ordered.$greater$eq$((Ordered)this, (Object)that);
        }

        public int compareTo(Object that) {
            return Ordered.compareTo$((Ordered)this, (Object)that);
        }

        public SocketChannel socket() {
            return this.socket;
        }

        public long endThrottleTimeMs() {
            return this.endThrottleTimeMs;
        }

        public int compare(DelayedCloseSocket that) {
            return new RichLong(Predef$.MODULE$.longWrapper(this.endThrottleTimeMs())).compare((Object)BoxesRunTime.boxToLong((long)that.endThrottleTimeMs()));
        }

        public DelayedCloseSocket copy(SocketChannel socket, long endThrottleTimeMs) {
            return new DelayedCloseSocket(this.kafka$network$Acceptor$DelayedCloseSocket$$$outer(), socket, endThrottleTimeMs);
        }

        public SocketChannel copy$default$1() {
            return this.socket();
        }

        public long copy$default$2() {
            return this.endThrottleTimeMs();
        }

        public String productPrefix() {
            return "DelayedCloseSocket";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.socket();
                }
                case 1: {
                    return BoxesRunTime.boxToLong((long)this.endThrottleTimeMs());
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof DelayedCloseSocket;
        }

        public int hashCode() {
            return Statics.finalizeHash((int)Statics.mix((int)Statics.mix((int)-889275714, (int)Statics.anyHash((Object)this.socket())), (int)Statics.longHash((long)this.endThrottleTimeMs())), (int)2);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            if (!(x$1 instanceof DelayedCloseSocket)) return false;
            if (((DelayedCloseSocket)x$1).kafka$network$Acceptor$DelayedCloseSocket$$$outer() != this.kafka$network$Acceptor$DelayedCloseSocket$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            DelayedCloseSocket delayedCloseSocket = (DelayedCloseSocket)x$1;
            SocketChannel socketChannel = this.socket();
            SocketChannel socketChannel2 = delayedCloseSocket.socket();
            if (socketChannel == null) {
                if (socketChannel2 != null) {
                    return false;
                }
            } else if (!socketChannel.equals(socketChannel2)) return false;
            if (this.endThrottleTimeMs() != delayedCloseSocket.endThrottleTimeMs()) return false;
            if (!delayedCloseSocket.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ Acceptor kafka$network$Acceptor$DelayedCloseSocket$$$outer() {
            return this.$outer;
        }

        public DelayedCloseSocket(Acceptor $outer, SocketChannel socket, long endThrottleTimeMs) {
            this.socket = socket;
            this.endThrottleTimeMs = endThrottleTimeMs;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Ordered.$init$((Ordered)this);
            Product.$init$((Product)this);
        }
    }
}

