/*
 * Decompiled with CFR 0.152.
 */
package kafka.metrics;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.reporting.CsvReporter;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.TimeUnit;
import kafka.metrics.KafkaCSVMetricsReporterMBean;
import kafka.metrics.KafkaMetricsConfig;
import kafka.metrics.KafkaMetricsReporter;
import kafka.utils.Logging;
import kafka.utils.VerifiableProperties;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import scala.Function0;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001a4AAE\n\u00051!)A\u0006\u0001C\u0001[!Iq\u0006\u0001a\u0001\u0002\u0004%I\u0001\r\u0005\ns\u0001\u0001\r\u00111A\u0005\niB\u0011\u0002\u0011\u0001A\u0002\u0003\u0005\u000b\u0015B\u0019\t\u0013\u0005\u0003\u0001\u0019!a\u0001\n\u0013\u0011\u0005\"\u0003(\u0001\u0001\u0004\u0005\r\u0011\"\u0003P\u0011%\t\u0006\u00011A\u0001B\u0003&1\tC\u0004S\u0001\u0001\u0007I\u0011B*\t\u000f]\u0003\u0001\u0019!C\u00051\"1!\f\u0001Q!\nQCqa\u0017\u0001A\u0002\u0013%1\u000bC\u0004]\u0001\u0001\u0007I\u0011B/\t\r}\u0003\u0001\u0015)\u0003U\u0011\u0015\u0001\u0007\u0001\"\u0011b\u0011\u0015A\u0007\u0001\"\u0011j\u0011\u0015y\u0007\u0001\"\u0011q\u0011\u00151\b\u0001\"\u0011x\u0005]Y\u0015MZ6b\u0007N3V*\u001a;sS\u000e\u001c(+\u001a9peR,'O\u0003\u0002\u0015+\u00059Q.\u001a;sS\u000e\u001c(\"\u0001\f\u0002\u000b-\fgm[1\u0004\u0001M)\u0001!G\u0010$MA\u0011!$H\u0007\u00027)\tA$A\u0003tG\u0006d\u0017-\u0003\u0002\u001f7\t1\u0011I\\=SK\u001a\u0004\"\u0001I\u0011\u000e\u0003MI!AI\n\u0003)-\u000bgm[1NKR\u0014\u0018nY:SKB|'\u000f^3s!\t\u0001C%\u0003\u0002&'\ta2*\u00194lC\u000e\u001bf+T3ue&\u001c7OU3q_J$XM]'CK\u0006t\u0007CA\u0014+\u001b\u0005A#BA\u0015\u0016\u0003\u0015)H/\u001b7t\u0013\tY\u0003FA\u0004M_\u001e<\u0017N\\4\u0002\rqJg.\u001b;?)\u0005q\u0003C\u0001\u0011\u0001\u0003\u0019\u00197O\u001e#jeV\t\u0011\u0007\u0005\u00023o5\t1G\u0003\u00025k\u0005\u0011\u0011n\u001c\u0006\u0002m\u0005!!.\u0019<b\u0013\tA4G\u0001\u0003GS2,\u0017AC2tm\u0012K'o\u0018\u0013fcR\u00111H\u0010\t\u00035qJ!!P\u000e\u0003\tUs\u0017\u000e\u001e\u0005\b\u007f\r\t\t\u00111\u00012\u0003\rAH%M\u0001\bGN4H)\u001b:!\u0003))h\u000eZ3sYfLgnZ\u000b\u0002\u0007B\u0011A\tT\u0007\u0002\u000b*\u0011aiR\u0001\ne\u0016\u0004xN\u001d;j]\u001eT!\u0001\u0006%\u000b\u0005%S\u0015AB=b[6,'OC\u0001L\u0003\r\u0019w.\\\u0005\u0003\u001b\u0016\u00131bQ:w%\u0016\u0004xN\u001d;fe\u0006qQO\u001c3fe2L\u0018N\\4`I\u0015\fHCA\u001eQ\u0011\u001dyd!!AA\u0002\r\u000b1\"\u001e8eKJd\u00170\u001b8hA\u00059!/\u001e8oS:<W#\u0001+\u0011\u0005i)\u0016B\u0001,\u001c\u0005\u001d\u0011un\u001c7fC:\f1B];o]&twm\u0018\u0013fcR\u00111(\u0017\u0005\b\u007f%\t\t\u00111\u0001U\u0003!\u0011XO\u001c8j]\u001e\u0004\u0013aC5oSRL\u0017\r\\5{K\u0012\fq\"\u001b8ji&\fG.\u001b>fI~#S-\u001d\u000b\u0003wyCqa\u0010\u0007\u0002\u0002\u0003\u0007A+\u0001\u0007j]&$\u0018.\u00197ju\u0016$\u0007%\u0001\u0007hKRl%)Z1o\u001d\u0006lW-F\u0001c!\t\u0019g-D\u0001e\u0015\t)W'\u0001\u0003mC:<\u0017BA4e\u0005\u0019\u0019FO]5oO\u0006!\u0011N\\5u)\tY$\u000eC\u0003l\u001f\u0001\u0007A.A\u0003qe>\u00048\u000f\u0005\u0002([&\u0011a\u000e\u000b\u0002\u0015-\u0016\u0014\u0018NZ5bE2,\u0007K]8qKJ$\u0018.Z:\u0002\u001bM$\u0018M\u001d;SKB|'\u000f^3s)\tY\u0014\u000fC\u0003s!\u0001\u00071/A\tq_2d\u0017N\\4QKJLw\u000eZ*fGN\u0004\"A\u0007;\n\u0005U\\\"\u0001\u0002'p]\u001e\fAb\u001d;paJ+\u0007o\u001c:uKJ$\u0012a\u000f")
public class KafkaCSVMetricsReporter
implements KafkaMetricsReporter,
KafkaCSVMetricsReporterMBean,
Logging {
    private File csvDir;
    private CsvReporter underlying;
    private boolean running;
    private boolean initialized;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private File csvDir() {
        return this.csvDir;
    }

    private void csvDir_$eq(File x$1) {
        this.csvDir = x$1;
    }

    private CsvReporter underlying() {
        return this.underlying;
    }

    private void underlying_$eq(CsvReporter x$1) {
        this.underlying = x$1;
    }

    private boolean running() {
        return this.running;
    }

    private void running_$eq(boolean x$1) {
        this.running = x$1;
    }

    private boolean initialized() {
        return this.initialized;
    }

    private void initialized_$eq(boolean x$1) {
        this.initialized = x$1;
    }

    @Override
    public String getMBeanName() {
        return "kafka:type=kafka.metrics.KafkaCSVMetricsReporter";
    }

    @Override
    public synchronized void init(VerifiableProperties props) {
        if (!this.initialized()) {
            KafkaMetricsConfig metricsConfig = new KafkaMetricsConfig(props);
            this.csvDir_$eq(new File(props.getString("kafka.csv.metrics.dir", "kafka_metrics")));
            Utils.delete((File)this.csvDir());
            Files.createDirectories(this.csvDir().toPath(), new FileAttribute[0]);
            this.underlying_$eq(new CsvReporter(KafkaYammerMetrics.defaultRegistry(), this.csvDir()));
            if (props.getBoolean("kafka.csv.metrics.reporter.enabled", false)) {
                this.initialized_$eq(true);
                this.startReporter(metricsConfig.pollingIntervalSecs());
                return;
            }
        }
    }

    @Override
    public synchronized void startReporter(long pollingPeriodSecs) {
        if (this.initialized() && !this.running()) {
            this.underlying().start(pollingPeriodSecs, TimeUnit.SECONDS);
            this.running_$eq(true);
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Started Kafka CSV metrics reporter with polling period %d seconds")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)pollingPeriodSecs)})));
        }
    }

    @Override
    public synchronized void stopReporter() {
        if (this.initialized() && this.running()) {
            this.underlying().shutdown();
            this.running_$eq(false);
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Stopped Kafka CSV metrics reporter");
            this.underlying_$eq(new CsvReporter(KafkaYammerMetrics.defaultRegistry(), this.csvDir()));
        }
    }

    public KafkaCSVMetricsReporter() {
        Logging.$init$(this);
        this.running = false;
        this.initialized = false;
    }
}

